
function boss_artist() {

    const visited = (game.visited['moat']);
    
    person('Emilio', `Don't bug him! Isn't he depressed enough already?`)

    preview('w', `there's just water that way`)
    preview('talk', `converse with Emilio`)

    preview('examine', `examine the very depressed artist`)
    check('examine', `He looks pretty down.`)

    blues('give the blues to Emilio', () => `He's already depressed enough.`)

    check('talk', () => {
        award("artist")
        nav('boss_draw_puzzle', { show_header: false })
    });

    preview('smell', 'smell the artist');
    check('smell', `Emilio smells of eraser shavings and sharpened pencil lead.`);

    if (!visited) {
        return `
        Seated at the edge of a sparkling blue moat is a
        rather despondent looking man, staring across the water.
        He is dressed as a nobleman, and is nervously clutching
        a worn eraser. Bobbing around in the water is a collection
        of letters, looking like a giant-sized alphabet soup.
        <p>"Hello," he says. "You must be that adventurer everyone's
        talking about. My name is Emilio. I've been commissioned to
        build a new bridge. The King burnt the old bridge after he
        and the Queen had, shall we say, a disagreement."</p> 
        `
    } else {
        return `
        Emilio sits at the edge of the moat, pink eraser still
        clutched in his hand. He regards you with a slight
        nod and returns to his bleak mood. 
        `
    }

}


function artist() {

    const visited = (game.visited['moat']);
    
    person('Emilio', `Don't bug him! Isn't he depressed enough already?`)

    preview('w', `there's just water that way`)
    preview('talk', `converse with Emilio`)

    preview('examine', `examine the very depressed artist`)
    check('examine', `He looks pretty down.`)

    blues('give the blues to Emilio', () => `He's already depressed enough.`)
    
    preview('smell', 'smell the artist');
    check('smell', `Emilio smells of eraser shavings and sharpened pencil lead.`);

    check('talk', () => {
        award("artist")
        nav('draw_puzzle', { show_header: false })
    });

    if (!game.boss) {
        preview('hint', `get a hint`)
        check('hint', () => `
        What kind of bridge can you make with a pencil? A bridge you have to draw, perhaps?
        `)
    }

    if (!visited) {
        return `
        Seated at the edge of a sparkling blue moat is a
        rather despondent looking man, staring across the water.
        He is dressed as a nobleman, and is nervously clutching
        a worn pencil.
        <p>"Hello," he says. "You must be that adventurer everyone's
        talking about. My name is Emilio. I've been commissioned to
        build a new bridge. The King burnt the old bridge after he
        and the Queen had, shall we say, a disagreement."</p> 
        `
    } else {
        return `
        Emilio sits at the edge of the moat, pencil still
        clutched in his hand. He regards you with a slight
        nod and returns to his bleak mood. 
        `
    }

}