
function airman() {
    if (!game.airman_solved) {

        person('the Air to the Throne', `The Air to the Throne appears to have enough problems.`)

        blues('give the blues to the Air to the Throne', () => `
        The Air to the Throne responds at considerable length how disinterested he is in that,
        until he's blue in the face.
        `)

        check(['attack', 'push', 'pull'], `Direct physical assault won't help you get the gem from the Air to the Throne's crown.`)

        preview('take', `take the Clubs gem`)
        check('take', `
        You ask for the Clubs gem, and the Air to the Throne awkwardly hides his forehead behind his lute.
        <p>"What is that?" he asks. "I've ever heard this 'Clubs gem' of which you speak."</p>
        `)

        const d = first_time(`
        <p>A funny-looking little man with large thick spectacles and a robe made of poofy white clouds
        sits perched here near the water. On his head is a crown, with a large club-shaped gem set on the front.
        In his hands is a lute, which he doesn't appear particularly skilled
        at. He keeps mumbling lyrics to himself, and cursing under his breath, along with "That's not right,"
        and "That'll never work!" over and over. He glances up at you as you approach.</p>
        <p>"Well, hello!" he says with a grin. "Pleased to meet you. You've no doubt heard of me, even if you don't
        recognize who I am. I am the Lord of Winds, the Baron of Bluster--none other than the famous Air to the Throne!"
        </p>
        `) ?? `
        <p>The Air to the Throne is still here, messing with his lute.
        The club-shaped gem on his forehead is all but taunting you.</p>
        `;

        if (!game.boss) {
            preview('hint', `get a hint`)
            check('hint', () => `
            He wants a word for his song with some real punch. What about that word
            you learned from the old oak tree?
            `)
        }

        preview('smell', 'smell the Air to the Throne');
        check('smell', `The Air to the Throne wafts of a fresh breeze.`);
    

        preview('talk', `converse with the Air to the Throne`)
        check('talk', () => {
            const v = game.executed[`talk-${game.current}`];
            const song = wind_song().split('\n').map(x => `<div class="verse-div">${x}</div>`).join('\n')

            if (!game.visited['enter_lyric']) {
                on_exit(() => `
                <p>"What am I doing here with this fine musical instrument?" muses the Air. "Well, love is the
                answer, of course. I've fallen for my precious love of my life, the Countess of Currents,
                the beautiful, stunning Lady Gale. Although I bluster over every her every breath, she thinks of me as just
                a blowhard.</p>
                <p>
                "So, I'm writing her a love song to waft some romance into the cockles of her heart. Sadly, though
                I am a brilliant wordsmith, I cannot find the right touch for these lyrics." He sighs, and the trees
                seem to ruffle in the breeze. "Can
                you help? I'm trying to get the last word of this verse perfect."
                </p>
                ${song}`)    
            } else {
                on_exit(() => `
                <p>
                "Can you help me find the perfect last word to this verse?" he asks. "It's for true love!"
                </p>
                ${song}`)
            }
            nav('enter_lyric', { show_header: false })
        })


        return d
    }
}
