
let backup_transcript = [];
let undo_mode_active = false;

function undo_until_index(index) {

    let transcript = [];
    const view = document.querySelector('#view');
    const inp = document.querySelector('#input-text-box');
    inp.value = '';
    view.innerHTML = '';
    undo_mode_active = true;
    backup_transcript = [...game.transcript];
    if (index === 1) {
        game = JSON.parse(JSON.stringify(Game));
        execute_room(game.current);
        undo_mode_active = false;
        setTimeout(() => {
            show_redo_box();
        }, 100);
        return;
    }
    for (let i = 0; i < (index - 1); i += 1) {
        const c = game.transcript[i];
        transcript.push(c);
    }
    game = JSON.parse(JSON.stringify(Game));
    setTimeout(() => {
        const last = transcript.pop();
        execute_room(game.current, { silent: true, show_header: false });
        for (const c of transcript) {
            submit_command(c, () => {});
        }
        undo_mode_active = false;
        setTimeout(() => {
            submit_command(last, () => {});
            show_redo_box();
        }, 100);
    }, 100);

}


function execute_redo() {
    const view = document.querySelector('#view');
    view.innerHTML = '';
    game = JSON.parse(JSON.stringify(Game));
    undo_mode_active = true;
    setTimeout(() => {
        const last = backup_transcript.pop();
        execute_room(game.current, { silent: true, show_header: false });
        for (const c of backup_transcript) {
            submit_command(c, () => {});
        }
        undo_mode_active = false;
        setTimeout(() => {
            submit_command(last, () => {});
            backup_transcript = [];
        }, 100);
    }, 100);
}


function show_redo_box() {
    const view = document.querySelector('#view');
    const a = document.createElement('div');
    const b = document.createElement('div');
    const c = document.createElement('button');
    const d = document.createElement('div');
    a.id = 'redo-commands-box';
    a.className = 'redo-commands-box';
    b.className = 'div-aside';
    a.append(b);
    c.title = `Redo moves`;
    c.innerText = `Redo?`;
    c.ariaLabel = `Redo`;
    d.innerHTML = 'Undo complete. ';
    c.className = 'redo-button';
    c.onclick = () => {
        execute_redo();
    };
    b.append(d);
    b.append(c);
    view.append(a);
}


function remove_redo_box() {
    const redo = document.getElementsByClassName('redo-commands-box');
    for (const c of redo) {
        c.remove();
    }
}
