


const lt_shade = '░';
const med_shade = '▒';
const dk_shade = '▓';
const parser_arrow = () => (game?.dos_mode) ? '¯' :
    '<div class="offset-round-inner">›</div>';
const small_parser_arrow = () => (game?.dos_mode) ? '¯' :
    '<div class="offset-round-inner">›</div>';
const check_mark = () => (game?.dos_mode) ? '√' : '✓';


/*
function symbol_musical_note() {
    const e = document.createElement('kbd');
    e.innerText = '£';
    return e;
}
*/


function banner_left() {
    return `${lt_shade}${med_shade}${dk_shade}`
}


function banner_right() {
    return `${dk_shade}${med_shade}${lt_shade}`
}


function handle_preview_check() {
    setInterval(() => {
        update_preview();
    }, 250);
}


function handle_stray_key () {

    const alpha = 'abcdefghijklmonpqrstuvwxyz'.split();
    const check_text_input_active = (box_input) => document.activeElement === box_input;
    document.addEventListener('keyup', ev => {

        const box_input = document.querySelector('#input-text-box');
        if (!check_text_input_active(box_input)) {
            box_input.focus();
            if (alpha.indexOf(ev.key.toLocaleLowerCase()) > -1) {
                box_input.value += ev.key;    
            }
        }

    });

}


function header(content) {
    header_title = content;
}


function refresh_header() {

    const hdr = document.querySelector('#header');
    if (game.current === 'start') {
        hdr.innerHTML = `
        <div class='header-row'>
            <div>the game called Yurf</div>
            <div>vers. ${game_version}</div>
        </div>
        <div class='header-row'>
            <div>a game by spaceflounder</div>
        </div>
        `
    } else {
        let gems = game.gems.map(m => {
            if (game?.dos_mode) {
                if (m === 'd') {
                    return ' ';
                }
                if (m === 'h') {
                    return ' ';
                }
                if (m === 'c') {
                    return ' ';
                }
                if (m === 's') {
                    return ' ';
                }    
            } else {
                if (m === 'd') {
                    return '♦️';
                }
                if (m === 'h') {
                    return '♥︎';
                }
                if (m === 'c') {
                    return '♣';
                }
                if (m === 's') {
                    return '♠️';
                }
            }
        }).join('');
        if (!gems) {
            gems = 'none';
        } else {
            gems = `<div class='gem-row'>${gems}</div>`;
        }
        let ex = (!game?.exits) ?
            '<div></div>' :
            `<div>Exits: ${game?.exits}</div>`;
        const inv = () => {
            let v = '';
            if (game?.burn) {
                v += '🔥';
            }
            if (game?.blues) {
                v += '<div class="color-splotch-blue"></div>';
            }
            if (game?.boss) {
                v += ' boss⚿';
            }
            if (v === '') {
                return `<div></div>`;
            }
            return `<div class="inv-row">${v}</div>`;
        }
        hdr.innerHTML = `
        <div class='header-row'><div>${header_title}</div>
        <div class="header-right">
        Gems: ${gems} |  
        Score: ${get_score_marker()}</div></div>
        <div class='header-row'>${ex}${inv()}</div>`
    }

}


function show_preview(content) {
    const prev = document.querySelector('#preview');
    prev.innerHTML = content;
}


function set_exits(content) {
    game.exits = content;
}



function show_checked() {
    const c = document.querySelector('#check-area');
    c.innerHTML = check_mark();
}


function remove_checked() {
    const c = document.querySelector('#check-area');
    c.innerHTML = '';
}


function build_form() {

    const inp = document.querySelector('#input');
    const left_arrow = document.createElement('div');
    const frm = document.createElement('form');
    const div = document.createElement('div');
    const prev = document.createElement('div');
    const ca = document.createElement('div');
    const tb = document.createElement('input');
    inp.innerHTML = '';
    prev.id = 'preview';
    div.className = 'input-form-combined';
    left_arrow.className = 'big-round-element';
    left_arrow.innerHTML = parser_arrow();
    frm.className = 'input-form';
    tb.className = 'input-text-box';
    tb.id = 'input-text-box';
    tb.autofocus = true;
    tb.autocapitalize = 'off';
    tb.autocomplete = 'off';
    tb.spellcheck = false;
    ca.id = 'check-area';
    ca.className = 'check-area'
    prev.innerHTML = '';
    frm.onsubmit = ev => {
        ev.preventDefault();
        submit_command(tb.value.trim(), () => tb.value = '');
    };
    div.append(left_arrow);
    div.append(tb);
    div.append(ca);
    frm.append(prev);
    frm.append(div);
    inp.append(frm);

}
