

function award(achievement) {

    const a = achievement;
    if (a in achievements) {
        if (!game.achievements[a]) {
            setTimeout(() => {
                const points = achievements[a]?.score;
                game.achievements[a] = true;
                if (game.boss) {
                    game.plus[a] = points;
                }
            }, 100);
            setTimeout(() => {
                refresh_header();
            }, 3200);
            if (!undo_mode_active) {
                setTimeout(() => {
                    const points = achievements[a]?.score;
                    new_note(`+${points}`)    
                }, 100);    
            }
        }
    }

}


function score_text(msg) {

    if (!msg) {
        msg = `Thus far you have--`;
    }
    const s = get_score();
    const m = get_max_score();
    const r = [];

    for (const n in game?.achievements) {
        if (game?.achievements[n]) {
            const points = achievements[n]?.score ?? 0;
            const text = achievements[n]?.text ?? '';
            const w = (points > 1) ? 'points' : 'point';
            r.push(`${points} ${w} for ${text}`);
        }
    }

    if (r.length === 0) {
        return `You have 0 out of ${m} points.`;
    }

    return `
    ${msg}
    ${r.map(x => `<p>&nbsp; ${x}</p>`).join('')}
    <p>earning you ${s} out of ${m} points.</p>
    `;

}


function get_score_marker() {

    const s = get_score();
    const m = get_max_score();

    const percent = (s / m) * 3;
    return `
    <div class="score-container">
        <div class="score-indicator" style="width: ${percent}em;">
        </div>
    </div>
    `;

}


function get_boss_score() {

    let s = 0;
    for (const n in game?.plus) {
        const points = game?.plus[n];
        s += points ?? 0;
    }
    return s;

}


function get_max_score() {

    let s = 0;
    for (const n in achievements) {
        const points = achievements[n]?.score;
        s += points ?? 0;
    }
    return s;

}


function get_score() {

    let s = 0;
    for (const n in game?.achievements) {
        if (game?.achievements[n]) {
            const points = achievements[n]?.score;
            s += points ?? 0;
        }
    }
    return s;

}

