

let header_title = '';
let game = {};
let registry = {};
let preview_book = {};
let on_exit_callback = false;


function check(tokens, result) {
    if (!Array.isArray(tokens)) {
        tokens = [tokens];
    }
    for (const t of tokens) {
        if (typeof result === 'string') {
            registry[t] = () => `${result}`;
        } else {
            registry[t] = result;
        }    
    }
}


function on_exit(callback) {
   on_exit_callback = callback;
}


function preview(tokens, result) {
    if (!Array.isArray(tokens)) {
        tokens = [tokens];
    }
    for (const t of tokens) {
        preview_book[t] = result;
    }
}


function preprocess(cmd) {

    if (cmd.indexOf(' ') > -1) {
        show_preview(`Arg! I'm a simple one-word parser, my friend!`);
        return false;
    }
    cmd = handle_synonyms(cmd);
    return cmd;

}


function record_val(val, next_room, options) {
    game.record_val_to = [val, next_room, options];
}


function handle_record_val(cmd) {
    const numbers = {
        'zero': '0',
        'one': '1',
        'two': '2',
        'three': '3',
        'four': '4',
        'five': '5',
        'six': '6',
        'seven': '7',
        'eight': '8',
        'nine': '9',
        'ten': '10',
        'eleven': '11',
        'twelve': '12',
        'thirteen': '13',
        'fourteen': '14',
        'fifteen': '15',
        'sixteen': '16',
        'seventeen': '17',
        'eighteen': '18',
        'nineteen': '19',
    };
    const [val, next_room, options] = game.record_val_to;
    for (const n in numbers) {
        if (strcmp(n, cmd)) {
            cmd = numbers[n];
        }
    }
    game.record_val_to = false;
    game[val] = cmd;
    nav(next_room, options);
}


function get_validated_command() {

    const box_input = document.querySelector('#input-text-box');
    const cmd = box_input.value;
    const valid = preprocess(cmd);
    const keys = Object.keys(registry).sort((a, b) =>
        similarity(b, valid) - similarity(a, valid)
    );
    for (const key of keys)  {
        if (strcmp(key, valid)) {
            show_checked();
            return;
        }
    }
    remove_checked();

}


function update_preview(cmd) {
    const box_input = document.querySelector('#input-text-box');
    if (!cmd) {
        cmd = box_input.value;
    }
    cmd = handle_synonyms(cmd);
    get_validated_command();
    const keys = Object.keys(preview_book).sort((a, b) => 
        similarity(b, cmd) - similarity(a, cmd)
    );
    for (const key of keys)  {
        if (strcmp(key, cmd)) {
            show_preview(preview_book[key]);
            return preview_book[key];
        }
    }
    handle_command_message(cmd);
    return '';
}


function no_turn_output(content) {
    const view = document.querySelector('#view');
    const div = document.createElement('div');
    remove_marker();
    create_marker();
    update_preview();
    view.appendChild(div);
    execute(() => content);
    remove_checked();
    setTimeout(() => {
        scroll_to_marker();
    }, 100);
}


function handle_special_commands(cmd) {
    if (cmd === 'save') {
        save_game();
    }
    if (cmd === 'restore') {
        restore_game();
    }
    if (cmd === 'score') {
        no_turn_output(score_text());
    }
    if (cmd === 'transcript') {
        export_transcript();
    }
    if (cmd === 'credits') {
        no_turn_output(credits_text());
    }
}


function handle_special_command_previews() {
    preview('credits', `game credits`);
    preview('score', `show score`);
    preview('save', `save game`);
    preview('restore', `restore game`);
    preview('transcript', `export transcript`);
    preview('undo', `to undo, tap the command you'd like to undo underlined on the right`);
}


function submit_command(cmd, on_complete) {
    const prev = document.querySelector('#preview');
    const view = document.querySelector('#view');
    if (cmd.indexOf(' ') > -1) {
        return;
    }
    remove_redo_box();
    if (cmd === 'save' | cmd === 'restore' | cmd === 'transcript' | cmd === 'credits' | cmd === 'score') {
        handle_special_commands(cmd);
        on_complete();
        return;
    }
    if (game.record_val_to && cmd !== '') {
        remove_marker();
        create_marker();
        const div = document.createElement('div');
        game.turn += 1;
        game.transcript.push(cmd);
        div.className = 'cursor-history-line';
        build_abridged_line(div, cmd, game.turn);
        //div.innerHTML = `<div>${small_parser_arrow()} ${cmd}</div>`;
        view.appendChild(div);
        handle_record_val(cmd);
        on_complete();
        remove_checked();
        setTimeout(() => {
            scroll_to_marker();
        }, 100);
        return;
    }
    if (cmd === '') {
        return;
    }
    if (cmd === 'g' || cmd === 'again') {
        const last = game.transcript.length - 1;
        cmd = game.transcript[last];
    }
    const valid = preprocess(cmd);
    const div = document.createElement('div');
    div.className = 'cursor-history-line';
    const keys = Object.keys(registry).sort((a, b) => similarity(b, valid) - similarity(a, valid));
    if (valid) {
        for (const key of keys) {
            if (strcmp(key, valid)) {
                remove_marker();
                create_marker();
                update_preview();
                const p = update_preview(cmd);
                const k = `${key}-${game.current}`;
                game.turn += 1;
                game.transcript.push(cmd);
                build_history_line(div, p, cmd, game.turn);
                view.appendChild(div);
                game.executed[k] = true;
                execute(registry[key]);
                execute_room(game.current, { silent: true });
                on_complete();
                remove_checked();
                setTimeout(() => {
                    scroll_to_marker();
                }, 100);
                return;
            }
        }
    }
}



function build_abridged_line(div, cmd, index) {
    const b = document.createElement('div');
    const c = document.createElement('button');
    b.className = 'round-element';
    b.innerHTML = small_parser_arrow();
    c.innerHTML = cmd;
    c.className = 'command-history'
    c.onclick = () => {
        undo_until_index(index);
    }
    c.title = `Undo ${cmd} [${index}]`;
    div.appendChild(b);
    div.appendChild(c);
}


function build_history_line(div, p, cmd, index) {
    const a = document.createElement('div');
    const b = document.createElement('div');
    const c = document.createElement('div');
    const d = document.createElement('button');
    a.className = 'cursor-history-combined';
    b.className = 'round-element';
    d.className = 'command-history';
    b.innerHTML = small_parser_arrow();
    d.innerHTML = cmd;
    d.onclick = () => {
        undo_until_index(index);
    }
    d.title = `Undo ${cmd} [${index}]`;
    a.appendChild(b);
    c.innerHTML = p;
    a.appendChild(c);    
    div.appendChild(a);
    div.appendChild(d);
}


function remove_marker() {
    const mk = document.querySelector('#mark-div');
    if (mk) {
        mk.remove();
    }
}


function create_marker() {
    const view = document.querySelector('#view');
    const mk = document.createElement('div');
    mk.id = 'mark-div';
    view.append(mk);
}



function scroll_to_marker() {
    const hd = document.querySelector('#header');
    const mk = document.querySelector('#mark-div');
    if (!undo_mode_active && mk) {
        window.scroll({
            top: mk.offsetTop - (hd.offsetHeight + 10),
            left: 0,
            behavior: 'smooth'
        });    
    }
}


function replace_commands(ext) {
    for (const key in registry) {
        registry[key] = ext;
    }
}


function execute(cmd, options) {
    const view = document.querySelector('#view');
    let content = cmd();
    const hdt = document.createElement('div');
    const div = document.createElement('div');
    const spc = document.createElement('div');
    const silent = options?.silent ?? false;
    div.className = 'text-block';
    spc.className = 'space-block';
    show_preview('');
    if (!game?.dos_mode) {
        content = SmartyPants(content);
    }
    if (content && !silent) {
        div.innerHTML = content;
        if (options?.spaced) {
            view.appendChild(spc);
        }
        if (options?.show_room_header) {
            hdt.innerHTML = header_title;
            hdt.className = 'room-header-div';
            view.appendChild(hdt);
        }
        view.appendChild(div);
    }
}


function execute_room(roomName, options) {
    const cmd = rooms[roomName];
    preview_book = {};
    handle_special_command_previews();
    registry = {};
    execute(cmd, options);
    refresh_header();
    game.visited[roomName] = true;
}


function load_game_engine() {
    handle_preview_check();
    handle_stray_key();
    build_form();
    game = JSON.parse(JSON.stringify(Game));
    execute_room(game.current);
}


window.addEventListener('load', () => {
    load_game_engine();
})
