
const smiley = () => (game?.dos_mode) ? '' : '💕';

const bl_msg = () => (game?.blues) ? `<p>If you have the blues, you can type BLUES to give them to someone else</p>` : ``;
const tn_msg = () => (game?.burn) ? `<p>If you have the tinder box, you can type BURN to burn useless things.</p>` : ``;


const about_msg = () => `
${aside(`What is Yurf, you ask? Well, I don't know precisely. It's a place, but not like our own.
A realm of wonders, the kind you might find between a lazy Sunday daydream and the trodden
sidewalk you take to your best friend's house.
<p>
I'm writing you now because Yurf is in great danger, and only you can save it. If, somehow, you can 
gather the Four Gems of Yurf, you just might, perhaps, succeed.
</p>
<p>
To this end, I've kept the method of traveling to and from Yurf a secret, just between
you and me.
</p>
`)}
<p>
Yurf is a game written for ParserComp 2024. It is a single-word parser game, designed
especially for parents to play together with their children, like good bedtime story. However, I
hope that it will find an audience with anyone who loves wordplay, riddles, and a childlike
sense of wonder.
</p>
<p>Version: ${game_version} Post Comp Release</p>
<p>IFID: ${ifid}</p>
<p>Dedicated to my Dad, who taught me to read with a little help from Scott Adams.</p>
<p>Type <kbd>credits</kbd> to view complete game credits.</p>
`


const help_msg = () => `
<div class='full-width'>
<div>
Yurf is a one-word parser game. It's a bit different from other interactive
fiction you've maybe played in the past.
<p>Some commands you might try include
<span class='key-command'>pull</span>, <span class='key-command'>push</span>, or <span class='key-command'>grab</span>.
It understands silly commands too, like <span class='key-command'>bounce</span>, <span class='key-command'>sniff</span>,
<span class='key-command'>yell</span> and <span class='key-command'>lick</span>. Experiment and have fun! You can't die or
put the game into an unwinnable state. Note that what the game does with
these commands varies greatly on context. Most of the time, you can perform an action
(without solving any puzzles) by pressing <span class='key-command'>.</span> on the keyboard and hitting
the Enter key.</p>
<p>
You'll spend a lot of time conversing with characters. Most are eager to meet you and want to help.
To initiate a conversation, type <span class='key-command'>talk</span>, or
simply hit the <span class='key-command'>&#x0027;</span> key and press Enter.
</p>
${bl_msg()}
${tn_msg()}
<p>Your goal is to find the Four Gems of Yurf and open the vault in the Palace
of the Sunshine King. Do this, and you will indeed save the <i>Land of
Yurf!</i></p>
</div>
${command_card()}
</div>
`;


const command_card = () => `
<div class="command-card">
<div class="command-card-header">
Some Handy Shortcuts
</div>
<div class="command-card-row">
<div>Converse</div> <div class="command-card-key">&#x0027;</div>
</div>
<div class="command-card-row">
<div>Examine</div> <div class="command-card-key">x</div>
</div>
<div class="command-card-row">
<div>Grab</div> <div class="command-card-key">.</div>
</div>
</div>
`


const mail_msg = () => `
<div class='full-width'>
<div>
<h4>Yurf Welcome Packet</h4>
<div class='dropcaps'>Welcome Adventurer! ${smiley()}
Our world is crumbling, only you, <b>yes you,</b> can stop it!
Your goal is to find the Four Gems of Yurf and open the vault in the Palace
of the Sunshine King. Yurf is inhabited by a variety of strange and wonderful creatures.
Talk to each of them. Most (but not all) are eager to help you!
<p>Don't forget to type <span class='key-command'>help</span> if you're having
trouble! And if you're really desperate, you can type <span class='key-command'>hint</span>, too.</p>
</div>
</div>
${command_card()}
</div>
`;


const credits_text = () => `
<hr>
<div><h3>Credits</h3></div>
<div>Yurf is a game by spaceflounder © 2024</div>
<p>Created for ParserComp 2024.</p>
<p>Version: ${game_version} Post Comp Release.</p>
<p>Thanks for Mathbrush and Garry Francis for helping to comb out some typos/bugs.</p>
<p>IFID: ${ifid}</p>
<p>Dedicated to my Dad, who taught me to read with a little help from Scott Adams.</p>
${acknow()}
${get_poem_data()}
`
