/*
 * Decompiled with CFR 0.152.
 */
package edlobez.es.edlanzador.vista;

import edlobez.es.edlanzador.TheMain;
import edlobez.es.edlanzador.controlador.Controlador;
import edlobez.es.edlanzador.gui.Grid;
import edlobez.es.edlanzador.gui.Layout;
import edlobez.es.edlanzador.gui.PanelSuperior;
import edlobez.es.edlanzador.gui.PanelTexto;
import edlobez.es.edlanzador.gui.VentanaPrincipal;
import edlobez.es.edlanzador.vista.Vista;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VistaGrafica
implements Vista {
    private VentanaPrincipal v;
    public PanelTexto ptxt;
    private PanelSuperior ps;
    private Layout l;
    private Controlador c;
    private int startCaret;
    private int endCaret;
    private boolean on = false;

    @Override
    public void crearVista() {
        this.v = new VentanaPrincipal();
        this.v.setTitle("edfiction " + TheMain.version);
        this.ptxt = new PanelTexto();
        this.ps = new PanelSuperior();
        this.l = new Layout();
        new Grid().crearGrid(this.l, this.ptxt.getScrollPanel(), this.ps);
        this.endCaret = -1;
        this.startCaret = -1;
        MyMouseListener mlst = new MyMouseListener();
        MyMouseMotionListener mmlst = new MyMouseMotionListener();
        this.ptxt.addMouseListener(mlst);
        this.ptxt.addMouseMotionListener(mmlst);
        this.ptxt.setFontSize(12);
        this.ps.getB1().addActionListener(new BotonListener());
        MyWindowListener wlst = new MyWindowListener();
        this.v.addWindowListener(wlst);
        this.v.getContentPane().add(this.l);
        this.v.setVisible(true);
    }

    @Override
    public void mostrarMensaje(String txt) {
        this.ptxt.setUnderline(false);
        if (txt.trim().startsWith("http")) {
            this.startCaret = this.ptxt.getCaretPosition();
            this.endCaret = this.startCaret + txt.length() - 1;
            this.ptxt.setUnderline(true);
            this.ptxt.addAtText(txt);
        } else {
            this.ptxt.addAtText(txt);
        }
    }

    @Override
    public void setControlador(Controlador c) {
        this.c = c;
    }

    public void goToURL(String URL2) {
        Desktop desktop;
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            try {
                URI uri = new URI(URL2);
                desktop.browse(uri);
            }
            catch (IOException | URISyntaxException ex) {
                Logger.getLogger(VistaGrafica.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public void cls() {
        this.ptxt.cls();
    }

    @Override
    public void estadoServidor(boolean estado) {
        if (estado) {
            this.cls();
            this.ps.getB1().setText("Stop");
            this.ps.getJl().setForeground(Color.green);
            this.mostrarMensaje("\nServidor encendido...");
            this.mostrarMensaje("\nPara jugar abre el siguiente enlace en tu navegador web:");
            this.mostrarMensaje("\nhttp://localhost:8080/edfiction/");
            this.ps.getJl().setText("Estado del servidor: Encendido");
            this.ps.getB1().setEnabled(true);
        } else {
            this.ps.getB1().setText("Start");
            this.ps.getJl().setForeground(Color.red);
            this.ps.getJl().setText("Estado del servidor: Apagado");
            this.mostrarMensaje("\nServidor apagado.");
            this.ps.getB1().setEnabled(true);
        }
    }

    class MyMouseMotionListener
    implements MouseMotionListener {
        MyMouseMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent arg0) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            if (VistaGrafica.this.startCaret != -1 && VistaGrafica.this.endCaret != -1) {
                if (VistaGrafica.this.startCaret <= VistaGrafica.this.ptxt.viewToModel(new Point(x, y)) && VistaGrafica.this.ptxt.viewToModel(new Point(x, y)) <= VistaGrafica.this.endCaret) {
                    VistaGrafica.this.v.setCursor(new Cursor(12));
                } else {
                    VistaGrafica.this.v.setCursor(new Cursor(0));
                }
            }
        }
    }

    class MyMouseListener
    implements MouseListener {
        MyMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            if (VistaGrafica.this.startCaret <= VistaGrafica.this.ptxt.getCaretPosition() && VistaGrafica.this.ptxt.getCaretPosition() <= VistaGrafica.this.endCaret) {
                VistaGrafica.this.goToURL("http://localhost:8080/edfiction/");
            }
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }
    }

    class BotonListener
    implements ActionListener {
        BotonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String s;
            switch (s = e.getActionCommand()) {
                case "Stop": {
                    VistaGrafica.this.c.pararServidor();
                    break;
                }
                case "Start": {
                    VistaGrafica.this.ps.getB1().setEnabled(false);
                    VistaGrafica.this.c.arrancarServidor();
                }
            }
        }
    }

    class MyWindowListener
    implements WindowListener {
        MyWindowListener() {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (VistaGrafica.this.ps.getJl().getText().contains("Encendido")) {
                VistaGrafica.this.c.pararServidor();
            }
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }
    }
}

