/*
 * Decompiled with CFR 0.152.
 */
package edlobez.es.edlanzador.hilos;

import edlobez.es.edlanzador.controlador.Controlador;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Servidor
implements Runnable {
    private Process proceso;
    private static final String COMANDO = "java -jar edfiction.war";
    private String salida = null;
    private Controlador controlador;
    private BufferedReader bufferedReader;

    public Servidor(Controlador c) {
        this.controlador = c;
    }

    public void crearCanalComunicacion() {
        this.bufferedReader = new BufferedReader(new InputStreamReader(this.proceso.getInputStream()));
    }

    @Override
    public void run() {
        try {
            String line;
            this.controlador.getV().mostrarMensaje("\nArrancando servidor...");
            this.proceso = Runtime.getRuntime().exec(COMANDO);
            this.crearCanalComunicacion();
            while (this.bufferedReader != null && (line = this.bufferedReader.readLine()) != null) {
                this.controlador.getV().mostrarMensaje("\n" + line);
                if (line.indexOf("Started EdfictionOfflineApplication") == -1) continue;
                this.controlador.getV().mostrarMensaje("\nServidor arrancado correctamente.");
                this.controlador.servidorOK();
            }
            this.controlador.getV().mostrarMensaje("\nError al arrancar el servidor, compruebe el fichero .war");
            this.controlador.servidorKO();
        }
        catch (IOException ex) {
            this.controlador.servidorKO();
        }
    }

    public String leer() throws IOException {
        return this.bufferedReader.readLine();
    }

    public String leerLineas() throws IOException {
        String linea;
        StringBuilder resultado = new StringBuilder();
        while ((linea = this.bufferedReader.readLine()) != null) {
            resultado.append(linea).append("\n");
        }
        return resultado.toString();
    }

    public void pararServidor() {
        try {
            if (this.proceso != null) {
                this.proceso.destroy();
                this.proceso = null;
                this.bufferedReader.close();
                this.bufferedReader = null;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Servidor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

