/*
 * Decompiled with CFR 0.152.
 */
package edlobez.es.edlanzador.hilos;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GeneradorDeProcesos {
    private final Process proceso;
    private BufferedReader bufferedReader;
    private PrintStream printStream;

    private void crearCanalesComunicacion() {
        this.bufferedReader = new BufferedReader(new InputStreamReader(this.proceso.getInputStream()));
        this.printStream = new PrintStream(this.proceso.getOutputStream());
    }

    public GeneradorDeProcesos(String[] ordenes) throws IOException {
        this.proceso = Runtime.getRuntime().exec(ordenes);
        this.crearCanalesComunicacion();
    }

    public GeneradorDeProcesos(String orden) throws IOException {
        this.proceso = Runtime.getRuntime().exec(orden);
        this.crearCanalesComunicacion();
    }

    public GeneradorDeProcesos(List ordenes) throws IOException {
        this.proceso = new ProcessBuilder(new String[0]).command(ordenes).start();
        this.crearCanalesComunicacion();
    }

    public void escribir(String datos) {
        this.printStream.println(datos);
        this.printStream.flush();
    }

    public String leer() throws IOException {
        return this.bufferedReader.readLine();
    }

    public String leerLineas() throws IOException {
        String linea;
        StringBuilder resultado = new StringBuilder();
        while ((linea = this.bufferedReader.readLine()) != null) {
            resultado.append(linea).append("\n");
        }
        return resultado.toString();
    }

    public void fin() {
        System.out.println("Vamos a parar el servidor.");
        try {
            this.bufferedReader.close();
            this.printStream.close();
            this.proceso.destroy();
        }
        catch (IOException ex) {
            Logger.getLogger(GeneradorDeProcesos.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

