// This file is (C) Carlos Sanchez 2014, released under the MIT license


//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////// GLOBAL VARIABLES AND CONSTANTS ///////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////



// CONSTANTS 
VOCABULARY_ID = 0;
VOCABULARY_WORD = 1;
VOCABULARY_TYPE = 2;

WORDTYPE_VERB = 0;
WORDTYPE_NOUN = 1
WORDTYPE_ADJECT = 2;
WORDTYPE_ADVERB = 3;
WORDTYPE_PRONOUN = 4;
WORDTYPE_CONJUNCTION = 5;
WORDTYPE_PREPOSITION = 6;

TIMER_MILLISECONDS  = 40;

RESOURCE_TYPE_IMG = 1;
RESOURCE_TYPE_SND = 2;

PROCESS_RESPONSE = 0;
PROCESS_DESCRIPTION = 1;
PROCESS_TURN = 2;


// Aux
SET_VALUE = 255; // Value assigned by SET condact
EMPTY_WORD = 255; // Value for word types when no match is found (as for  sentences without adjective or name)
MAX_WORD_LENGHT = 10;  // Number of characters considered per word
FLAG_COUNT = 256;  // Number of flags
NUM_CONNECTION_VERBS = 14; // Number of verbs used as connection, from 0 to N - 1
NUM_CONVERTIBLE_NOUNS = 20;
NUM_PROPER_NOUNS = 50; // Number of proper nouns, can't be used as pronoun reference
EMPTY_OBJECT = 255; // To remark there is no object when the action requires a objno parameter
NO_EXIT = 255;  // If an exit does not exist, its value is this value
MAX_CHANNELS = 17; // Number of SFX channels
RESOURCES_DIR='dat/';


//Attributes
ATTR_LIGHT=0;			// Object produces light
ATTR_WEARABLE=1;		// Object is wearable
ATTR_CONTAINER=2;       // Object is a container
ATTR_NPC=3;             // Object is actually an NPC
ATTR_CONCEALED = 4; /// Present but not visible
ATTR_EDIBLE = 5;   /// Can be eaten
ATTR_DRINKABLE=6;
ATTR_ENTERABLE = 7;
ATTR_FEMALE = 8;
ATTR_LOCKABLE = 9;
ATTR_LOCKED = 10;
ATTR_MALE = 11;
ATTR_NEUTER=12;
ATTR_OPENABLE =13;
ATTR_OPEN=14;
ATTR_PLURALNAME = 15;
ATTR_TRANSPARENT=16;
ATTR_SCENERY=17;
ATTR_SUPPORTER = 18;
ATTR_SWITCHABLE=19;
ATTR_ON  =20;
ATTR_STATIC  =21;



///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////// INTERNAL STRINGS ///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


// General messages & strings
STR_NEWLINE = '<br />';
STR_PROMPT = '> ';



// Runtime error messages
STR_WRONG_SYSMESS = 'WARNING: System message requested does not exist.'; 
STR_WRONG_LOCATION = 'WARNING: Location requested does not exist.'; 
STR_WRONG_MESSAGE = 'WARNING: Message requested does not exist.'; 
STR_WRONG_PROCESS = 'WARNING: Process requested does not exist.' 
STR_RAMLOAD_ERROR= 'WARNING: Can\'t do RAMLOAD without RAMSAVE'; 
STR_RUNTIME_VERSION  = 'ngPAWS runtime (C) 2014 Carlos Sanchez.  Released under {URL|http://www.opensource.org/licenses/MIT| MIT license}.\nBuzz sound libray (C) Jay Salvat. Released under the {URL|http://www.opensource.org/licenses/MIT| MIT license} \n jQuery (C) jQuery Foundation. Released under the {URL|https://jquery.org/license/| MIT license}.';
STR_TRANSCRIPT = 'To copy the transcript to your clipboard, press Ctrl+C, then press Enter';

STR_SAVE_LOCAL = 'Due to browser security restrictions, the game status can\'t be saved to your hard disk. Please copy the following long string as a code that will allow you to restore the game status.\n\nTo copy the string to your clipboard, press Ctrl+C, then press Enter:\n';
STR_SAVE_STORAGE = 'Please enter savegame name. The name you choose will be requested to you in order to restore the game status.'
STR_LOAD_STORAGE = 'Please enter savegame name you used when saving the game status.'
STR_LOAD_LOCAL = 'Please enter the code you received for loading the game.'

STR_INVALID_TAG_SEQUENCE = 'Invalid tag sequence: ';
STR_INVALID_TAG_SEQUENCE_EMPTY = 'Invalid tag sequence.';
STR_INVALID_TAG_SEQUENCE_BADPARAMS = 'Invalid tag sequence: bad parameters.';
STR_INVALID_TAG_SEQUENCE_BADTAG = 'Invalid tag sequence: unknown tag.';
STR_BADIE = 'You are using a very old version of Internet Explorer. Some features of this product won\'t be avaliable, and other may not work properly. For a better experience please upgrade your browser or install some other one like Firefox, Chrome or Opera.\n\nIt\'s up to you to continue but be warned your experience may be affected.';
STR_INVALID_OBJECT = 'WARNING: Trying to access object that does not exist'


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////     FLAGS     ///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


FLAG_LIGHT = 0;
FLAG_OBJECTS_CARRIED_COUNT = 1;
FLAG_AUTODEC2 = 2; 
FLAG_AUTODEC3 = 3;
FLAG_AUTODEC4 = 4;
FLAG_AUTODEC5 = 5;
FLAG_AUTODEC6 = 6;
FLAG_AUTODEC7 = 7;
FLAG_AUTODEC8 = 8;
FLAG_AUTODEC9 = 9;
FLAG_AUTODEC10 = 10;
FLAG_ESCAPE = 11;
FLAG_PARSER_SETTINGS = 12;
FLAG_PICTURE_SETTINGS = 29
FLAG_SCORE = 30;
FLAG_TURNS_LOW = 31;
FLAG_TURNS_HIGH = 32;
FLAG_VERB = 33;
FLAG_NOUN1 =34;
FLAG_ADJECT1 = 35;
FLAG_ADVERB = 36;
FLAG_MAXOBJECTS_CARRIED = 37;
FLAG_LOCATION = 38;
FLAG_TOPLINE = 39;   // deprecated
FLAG_MODE = 40;  // deprecated
FLAG_PROTECT = 41;   // deprecated
FLAG_PROMPT = 42;  // deprecated
FLAG_PREP = 43;
FLAG_NOUN2 = 44;
FLAG_ADJECT2 = 45;
FLAG_PRONOUN = 46;
FLAG_PRONOUN_ADJECT = 47;
FLAG_TIMEOUT_LENGTH = 48;
FLAG_TIMEOUT_SETTINGS = 49; 
FLAG_DOALL_LOC = 50;
FLAG_REFERRED_OBJECT = 51;
FLAG_MAXWEIGHT_CARRIED = 52;
FLAG_OBJECT_LIST_FORMAT = 53;
FLAG_REFERRED_OBJECT_LOCATION = 54;
FLAG_REFERRED_OBJECT_WEIGHT = 55;
FLAG_REFERRED_OBJECT_LOW_ATTRIBUTES = 56;
FLAG_REFERRED_OBJECT_HIGH_ATTRIBUTES = 57;
FLAG_EXPANSION1 = 58;
FLAG_EXPANSION2 = 59;

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////// SPECIAL LOCATIONS ///////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

LOCATION_WORN = 253;
LOCATION_CARRIED = 254;
LOCATION_NONCREATED = 252;
LOCATION_HERE = 255;

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////  SYSTEM MESSAGES  ///////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////



SYSMESS_ISDARK = 0;
SYSMESS_YOUCANSEE = 1;
SYSMESS_PROMPT0 = 2;
SYSMESS_PROMPT1 = 3;
SYSMESS_PROMPT2 = 4
SYSMESS_PROMPT3= 5;
SYSMESS_IDONTUNDERSTAND = 6;
SYSMESS_WRONGDIRECTION = 7
SYSMESS_CANTDOTHAT = 8;
SYSMESS_YOUARECARRYING = 9;
SYSMESS_WORN = 10;
SYSMESS_CARRYING_NOTHING = 11;
SYSMESS_AREYOUSURE = 12;
SYSMESS_PLAYAGAIN = 13;
SYSMESS_FAREWELL = 14;
SYSMESS_OK = 15;
SYSMESS_PRESSANYKEY = 16;
SYSMESS_TURNS_START = 17;
SYSMESS_TURNS_CONTINUE = 18;
SYSMESS_TURNS_PLURAL = 19;
SYSMESS_TURNS_END = 20;
SYSMESS_SCORE_START= 21;
SYSMESS_SCORE_END =22;
SYSMESS_YOURENOTWEARINGTHAT = 23;
SYSMESS_YOUAREALREADYWEARINGTHAT = 24;
SYSMESS_YOUALREADYHAVEOBJECT = 25;
SYSMESS_CANTSEETHAT = 26;
SYSMESS_CANTCARRYANYMORE = 27;
SYSMESS_YOUDONTHAVETHAT = 28;
SYSMESS_YOUAREALREADYWAERINGOBJECT = 29;
SYSMESS_YES = 30;
SYSMESS_NO = 31;
SYSMESS_MORE = 32;
SYSMESS_CARET = 33;
SYSMESS_TIMEOUT=35;
SYSMESS_YOUTAKEOBJECT = 36;
SYSMESS_YOUWEAROBJECT = 37;
SYSMESS_YOUREMOVEOBJECT = 38;
SYSMESS_YOUDROPOBJECT = 39;
SYSMESS_YOUCANTWEAROBJECT = 40;
SYSMESS_YOUCANTREMOVEOBJECT = 41;
SYSMESS_CANTREMOVE_TOOMANYOBJECTS = 42;
SYSMESS_WEIGHSTOOMUCH = 43;
SYSMESS_YOUPUTOBJECTIN = 44;
SYSMESS_YOUCANTTAKEOBJECTOUTOF = 45;
SYSMESS_LISTSEPARATOR = 46;
SYSMESS_LISTLASTSEPARATOR = 47;
SYSMESS_LISTEND = 48;
SYSMESS_YOUDONTHAVEOBJECT = 49;
SYSMESS_YOUARENOTWEARINGOBJECT = 50;
SYSMESS_PUTINTAKEOUTTERMINATION = 51;
SYSMESS_THATISNOTIN = 52;
SYSMESS_EMPTYOBJECTLIST = 53;
SYSMESS_FILENOTFOUND = 54;
SYSMESS_CORRUPTFILE = 55;
SYSMESS_IOFAILURE = 56;
SYSMESS_DIRECTORYFULL = 57;
SYSMESS_DISKFULL = 58;
SYSMESS_INVALIDFILENAME = 59;
SYSMESS_FILENAME = 60;
SYSMESS_SORRY = 61;
SYSMESS_NONSENSE_SENTENCE = 62;
SYSMESS_NPCLISTSTART = 63;
SYSMESS_NPCLISTCONTINUE = 64;
SYSMESS_NPCLISTCONTINUE_PLURAL = 65;
SYSMESS_INSIDE_YOUCANSEE = 66;
SYSMESS_OVER_YOUCANSEE = 67;
SYSMESS_YOUPUTOBJECTON = 68;
SYSMESS_YOUCANTTAKEOBJECTFROM = 69;


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////// GLOBAL VARS //////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


// Parser vars
var last_player_order = '';   // Store last player order, to be able to restore it when pressing arrow up
var parser_word_found;
var player_order_buffer = '';
var previous_verb = EMPTY_WORD;
var previous_noun = EMPTY_WORD;
var previous_adject = EMPTY_WORD;
var pronoun_suffixes = [];
var transcript = '';

//Settings
var graphicsON = true; 
var soundsON = true; 
var interruptDisabled = false;


// Block and anykey
var unblock_process = null;
var anykey_return_function = null;
var getkey_return_flag = null;

// Status flags
var done_flag;
var describe_location_flag;
var in_response;
var success;

// doall control
var doall_flag;
var process_in_doall;
var entry_for_doall	= '';


var timeout_progress = 0;
var ramsave_value = null;
var num_objects;


// The flags
var flags = new Array();


// The sound channels
var soundChannels = [];
var soundLoopCount = [];

//The last free object attribute
var nextFreeAttr = 22;



// PROCESSES

interruptProcessExists = false;

function pro000()
{
process_restart=true;
pro000_restart: while(process_restart)
{
	process_restart=false;
	// X _
	p000e0000:
	{
 		if (skipdoall('p000e0000')) break p000e0000;
 		if (in_response)
		{
			if (!CNDverb(54)) break p000e0000;
 		}
		if (!CNDnoteq(34,255)) break p000e0000;
 		ACClet(33,30);
		{}

	}

	// GRAFICOS _
	p000e0001:
	{
 		if (skipdoall('p000e0001')) break p000e0001;
 		if (in_response)
		{
			if (!CNDverb(110)) break p000e0001;
 		}
		if (!CNDeq(34,255)) break p000e0001;
 		ACCwrite(0);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// GRAFICOS SI
	p000e0002:
	{
 		if (skipdoall('p000e0002')) break p000e0002;
 		if (in_response)
		{
			if (!CNDverb(110)) break p000e0002;
			if (!CNDnoun1(225)) break p000e0002;
 		}
 		ACCgraphic(0);
 		ACCdesc();
		break pro000_restart;
 		ACCdone();
		break pro000_restart;
		{}

	}

	// GRAFICOS NO
	p000e0003:
	{
 		if (skipdoall('p000e0003')) break p000e0003;
 		if (in_response)
		{
			if (!CNDverb(110)) break p000e0003;
			if (!CNDnoun1(7)) break p000e0003;
 		}
 		ACCgraphic(1);
 		ACCdesc();
		break pro000_restart;
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGELA _
	p000e0004:
	{
 		if (skipdoall('p000e0004')) break p000e0004;
 		if (in_response)
		{
			if (!CNDverb(21)) break p000e0004;
 		}
		if (!CNDnoteq(44,255)) break p000e0004;
 		ACClet(33,59);
		{}

	}

	// SAL _
	p000e0005:
	{
 		if (skipdoall('p000e0005')) break p000e0005;
 		if (in_response)
		{
			if (!CNDverb(49)) break p000e0005;
 		}
		if (!CNDat(13)) break p000e0005;
 		ACCgoto(9);
 		ACCdesc();
		break pro000_restart;
		{}

	}

	// EX _
	p000e0006:
	{
 		if (skipdoall('p000e0006')) break p000e0006;
 		if (in_response)
		{
			if (!CNDverb(30)) break p000e0006;
 		}
		if (!CNDat(13)) break p000e0006;
		if (!CNDozero(1,0)) break p000e0006;
 		ACCwrite(1);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// X _
	p000e0007:
	{
 		if (skipdoall('p000e0007')) break p000e0007;
 		if (in_response)
		{
			if (!CNDverb(54)) break p000e0007;
 		}
		if (!CNDat(13)) break p000e0007;
 		ACCprocess(4);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// _ _
	p000e0008:
	{
 		if (skipdoall('p000e0008')) break p000e0008;
		if (!CNDat(13)) break p000e0008;
		if (!CNDozero(1,0)) break p000e0008;
 		ACCwrite(2);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGELA CORCHO
	p000e0009:
	{
 		if (skipdoall('p000e0009')) break p000e0009;
 		if (in_response)
		{
			if (!CNDverb(21)) break p000e0009;
			if (!CNDnoun1(104)) break p000e0009;
 		}
		if (!CNDnoun2(100)) break p000e0009;
 		ACClet(33,65);
 		ACClet(34,100);
		{}

	}

	// COLOCA CORCHO
	p000e0010:
	{
 		if (skipdoall('p000e0010')) break p000e0010;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0010;
			if (!CNDnoun1(104)) break p000e0010;
 		}
		if (!CNDnoun2(100)) break p000e0010;
 		ACClet(33,65);
 		ACClet(34,100);
		{}

	}

	// COLOCA CORCHO
	p000e0011:
	{
 		if (skipdoall('p000e0011')) break p000e0011;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0011;
			if (!CNDnoun1(104)) break p000e0011;
 		}
		if (!CNDnoun2(100)) break p000e0011;
 		ACClet(33,65);
 		ACClet(34,100);
		{}

	}

	// _ PORTATIL
	p000e0012:
	{
 		if (skipdoall('p000e0012')) break p000e0012;
 		if (in_response)
		{
			if (!CNDnoun1(220)) break p000e0012;
 		}
		if (!CNDat(30)) break p000e0012;
 		ACClet(34,224);
		{}

	}

	// _ _
	p000e0013:
	{
 		if (skipdoall('p000e0013')) break p000e0013;
		if (!CNDnoun2(220)) break p000e0013;
		if (!CNDat(30)) break p000e0013;
 		ACClet(44,224);
		{}

	}

	// SAL _
	p000e0014:
	{
 		if (skipdoall('p000e0014')) break p000e0014;
 		if (in_response)
		{
			if (!CNDverb(49)) break p000e0014;
 		}
		if (!CNDnotzero(108)) break p000e0014;
 		ACCprocess(7);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SAL _
	p000e0015:
	{
 		if (skipdoall('p000e0015')) break p000e0015;
 		if (in_response)
		{
			if (!CNDverb(49)) break p000e0015;
 		}
		if (!CNDat(29)) break p000e0015;
		if (!CNDcarried(23)) break p000e0015;
		if (!CNDnotzero(102)) break p000e0015;
 		ACCcls();
 		ACCpicture(28);
 		ACCwrite(3);
 		ACCwrite(4);
 		ACCanykey();
 		function anykey00005() 
		{
 		ACCplace(23,43);
 		ACCobjat(254,73);
 		ACCset(108);
		entry_for_doall = 'p000e0016';
		process_in_doall = 0;
 		ACCdoall(254);
		return;
		}
 		function anykey00004() 
		{
 		ACCpicture(7);
 		ACCcls();
 		ACCwrite(14);
 		ACCanykey();
 		waitKey(anykey00005);
		}
 		function anykey00003() 
		{
 		ACCwrite(11);
 		ACCwrite(12);
 		ACCwrite(13);
 		ACCanykey();
 		waitKey(anykey00004);
		}
 		function anykey00002() 
		{
 		ACCwrite(10);
 		ACCanykey();
 		waitKey(anykey00003);
		}
 		function anykey00001() 
		{
 		ACCwrite(7);
 		ACCwrite(8);
 		ACCwrite(9);
 		ACCanykey();
 		waitKey(anykey00002);
		}
 		function anykey00000() 
		{
 		ACCpicture(6);
 		ACCwrite(5);
 		ACCwrite(6);
 		ACCanykey();
 		waitKey(anykey00001);
		}
 		waitKey(anykey00000);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// SAL _
	p000e0016:
	{
 		if (skipdoall('p000e0016')) break p000e0016;
 		if (in_response)
		{
			if (!CNDverb(49)) break p000e0016;
 		}
		if (!CNDnotzero(108)) break p000e0016;
 		ACCprocess(7);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// _ _
	p000e0017:
	{
 		if (skipdoall('p000e0017')) break p000e0017;
		if (!CNDnoun2(220)) break p000e0017;
		if (!CNDat(30)) break p000e0017;
 		ACClet(43,224);
		{}

	}

	// COLOCA _
	p000e0018:
	{
 		if (skipdoall('p000e0018')) break p000e0018;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0018;
 		}
		if (!CNDnoun2(224)) break p000e0018;
		if (!CNDat(29)) break p000e0018;
		if (!CNDnoteq(34,156)) break p000e0018;
		if (!CNDnoteq(34,154)) break p000e0018;
 		ACCwrite(15);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA _
	p000e0019:
	{
 		if (skipdoall('p000e0019')) break p000e0019;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0019;
 		}
		if (!CNDnoun2(159)) break p000e0019;
		if (!CNDat(29)) break p000e0019;
		if (!CNDnoteq(34,156)) break p000e0019;
		if (!CNDnoteq(34,154)) break p000e0019;
 		ACCwrite(16);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA _
	p000e0020:
	{
 		if (skipdoall('p000e0020')) break p000e0020;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0020;
 		}
		if (!CNDnoun2(223)) break p000e0020;
		if (!CNDat(29)) break p000e0020;
		if (!CNDnoteq(34,156)) break p000e0020;
		if (!CNDnoteq(34,154)) break p000e0020;
 		ACCwrite(17);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA _
	p000e0021:
	{
 		if (skipdoall('p000e0021')) break p000e0021;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0021;
 		}
		if (!CNDat(29)) break p000e0021;
		if (!CNDnoun2(223)) break p000e0021;
 		ACClet(43,224);
		{}

	}

	// ESCRIBE _
	p000e0022:
	{
 		if (skipdoall('p000e0022')) break p000e0022;
 		if (in_response)
		{
			if (!CNDverb(89)) break p000e0022;
 		}
		if (!CNDnoun2(89)) break p000e0022;
		if (!CNDat(38)) break p000e0022;
 		ACCwrite(18);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ESCRIBE CAJA
	p000e0023:
	{
 		if (skipdoall('p000e0023')) break p000e0023;
 		if (in_response)
		{
			if (!CNDverb(89)) break p000e0023;
			if (!CNDnoun1(89)) break p000e0023;
 		}
		if (!CNDnoun2(192)) break p000e0023;
		if (!CNDnotzero(112)) break p000e0023;
		if (!CNDabsent(26)) break p000e0023;
 		ACCwrite(19);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ESCRIBE CAJA
	p000e0024:
	{
 		if (skipdoall('p000e0024')) break p000e0024;
 		if (in_response)
		{
			if (!CNDverb(89)) break p000e0024;
			if (!CNDnoun1(89)) break p000e0024;
 		}
		if (!CNDnoun2(192)) break p000e0024;
		if (!CNDnotzero(112)) break p000e0024;
		if (!CNDpresent(26)) break p000e0024;
		if (!CNDnotcarr(25)) break p000e0024;
 		ACCwrite(20);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ESCRIBE CAJA
	p000e0025:
	{
 		if (skipdoall('p000e0025')) break p000e0025;
 		if (in_response)
		{
			if (!CNDverb(89)) break p000e0025;
			if (!CNDnoun1(89)) break p000e0025;
 		}
		if (!CNDnoun2(192)) break p000e0025;
		if (!CNDnotzero(114)) break p000e0025;
 		ACCwrite(21);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ESCRIBE CAJA
	p000e0026:
	{
 		if (skipdoall('p000e0026')) break p000e0026;
 		if (in_response)
		{
			if (!CNDverb(89)) break p000e0026;
			if (!CNDnoun1(89)) break p000e0026;
 		}
		if (!CNDnoun2(192)) break p000e0026;
		if (!CNDnotzero(112)) break p000e0026;
		if (!CNDpresent(26)) break p000e0026;
		if (!CNDcarried(25)) break p000e0026;
 		ACCwrite(22);
 		ACCset(114);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA _
	p000e0027:
	{
 		if (skipdoall('p000e0027')) break p000e0027;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0027;
 		}
		if (!CNDnoun2(89)) break p000e0027;
		if (!CNDat(38)) break p000e0027;
 		ACCwrite(23);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// FROTAME JABON
	p000e0028:
	{
 		if (skipdoall('p000e0028')) break p000e0028;
 		if (in_response)
		{
			if (!CNDverb(109)) break p000e0028;
			if (!CNDnoun1(173)) break p000e0028;
 		}
 		ACClet(33,92);
		{}

	}

	// FROTAME _
	p000e0029:
	{
 		if (skipdoall('p000e0029')) break p000e0029;
 		if (in_response)
		{
			if (!CNDverb(109)) break p000e0029;
 		}
		if (!CNDnoun2(173)) break p000e0029;
 		ACClet(33,92);
		{}

	}

	// FROTA TI
	p000e0030:
	{
 		if (skipdoall('p000e0030')) break p000e0030;
 		if (in_response)
		{
			if (!CNDverb(91)) break p000e0030;
			if (!CNDnoun1(181)) break p000e0030;
 		}
		if (!CNDnoun2(173)) break p000e0030;
 		ACClet(33,92);
		{}

	}

	// ENTRA FUENTE
	p000e0031:
	{
 		if (skipdoall('p000e0031')) break p000e0031;
 		if (in_response)
		{
			if (!CNDverb(50)) break p000e0031;
			if (!CNDnoun1(146)) break p000e0031;
 		}
		if (!CNDat(28)) break p000e0031;
 		ACCwrite(24);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENTRA AGUA
	p000e0032:
	{
 		if (skipdoall('p000e0032')) break p000e0032;
 		if (in_response)
		{
			if (!CNDverb(50)) break p000e0032;
			if (!CNDnoun1(107)) break p000e0032;
 		}
		if (!CNDat(28)) break p000e0032;
 		ACCwrite(25);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// BOTA FUENTE
	p000e0033:
	{
 		if (skipdoall('p000e0033')) break p000e0033;
 		if (in_response)
		{
			if (!CNDverb(53)) break p000e0033;
			if (!CNDnoun1(146)) break p000e0033;
 		}
		if (!CNDat(28)) break p000e0033;
 		ACCwrite(26);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// BOTA AGUA
	p000e0034:
	{
 		if (skipdoall('p000e0034')) break p000e0034;
 		if (in_response)
		{
			if (!CNDverb(53)) break p000e0034;
			if (!CNDnoun1(107)) break p000e0034;
 		}
		if (!CNDat(28)) break p000e0034;
 		ACCwrite(27);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE _
	p000e0035:
	{
 		if (skipdoall('p000e0035')) break p000e0035;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0035;
 		}
		if (!CNDnotzero(84)) break p000e0035;
 		ACCwrite(28);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA AGUJERO
	p000e0036:
	{
 		if (skipdoall('p000e0036')) break p000e0036;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0036;
			if (!CNDnoun1(100)) break p000e0036;
 		}
		if (!CNDnoun2(88)) break p000e0036;
		if (!CNDat(5)) break p000e0036;
		if (!CNDnotcarr(12)) break p000e0036;
 		ACCwrite(29);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA AGUJERO
	p000e0037:
	{
 		if (skipdoall('p000e0037')) break p000e0037;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0037;
			if (!CNDnoun1(100)) break p000e0037;
 		}
		if (!CNDnoun2(88)) break p000e0037;
		if (!CNDat(5)) break p000e0037;
		if (!CNDcarried(12)) break p000e0037;
		if (!CNDozero(12,34)) break p000e0037;
 		ACCplace(12,6);
 		ACCwrite(30);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA AGUJERO
	p000e0038:
	{
 		if (skipdoall('p000e0038')) break p000e0038;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0038;
			if (!CNDnoun1(100)) break p000e0038;
 		}
		if (!CNDnoun2(88)) break p000e0038;
		if (!CNDat(5)) break p000e0038;
		if (!CNDcarried(12)) break p000e0038;
		if (!CNDonotzero(12,34)) break p000e0038;
 		ACCoclear(12,34);
 		ACCplace(12,6);
 		ACCwrite(31);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA _
	p000e0039:
	{
 		if (skipdoall('p000e0039')) break p000e0039;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0039;
 		}
		if (!CNDnoun2(100)) break p000e0039;
		if (!CNDnotcarr(12)) break p000e0039;
 		ACCwrite(32);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA _
	p000e0040:
	{
 		if (skipdoall('p000e0040')) break p000e0040;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0040;
 		}
		if (!CNDnoun2(100)) break p000e0040;
		if (!CNDcarried(12)) break p000e0040;
 		ACCwrite(33);
 		ACCdone();
		break pro000_restart;
		{}

	}

	//  AGUJERO
	p000e0041:
	{
 		if (skipdoall('p000e0041')) break p000e0041;
 		if (in_response)
		{
			if (!CNDverb(15)) break p000e0041;
			if (!CNDnoun1(100)) break p000e0041;
 		}
 		ACClet(33,65);
		{}

	}

	// ROMPE CANDADO
	p000e0042:
	{
 		if (skipdoall('p000e0042')) break p000e0042;
 		if (in_response)
		{
			if (!CNDverb(94)) break p000e0042;
			if (!CNDnoun1(99)) break p000e0042;
 		}
		if (!CNDat(8)) break p000e0042;
 		ACClet(33,63);
		{}

	}

	// HUELE ELEXIR
	p000e0043:
	{
 		if (skipdoall('p000e0043')) break p000e0043;
 		if (in_response)
		{
			if (!CNDverb(72)) break p000e0043;
			if (!CNDnoun1(103)) break p000e0043;
 		}
		if (!CNDpresent(13)) break p000e0043;
 		ACCwrite(34);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// HUELE LIQUIDO
	p000e0044:
	{
 		if (skipdoall('p000e0044')) break p000e0044;
 		if (in_response)
		{
			if (!CNDverb(72)) break p000e0044;
			if (!CNDnoun1(105)) break p000e0044;
 		}
		if (!CNDpresent(13)) break p000e0044;
 		ACCwrite(35);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SENTAR BANCO
	p000e0045:
	{
 		if (skipdoall('p000e0045')) break p000e0045;
 		if (in_response)
		{
			if (!CNDverb(108)) break p000e0045;
			if (!CNDnoun1(75)) break p000e0045;
 		}
		if (!CNDat(4)) break p000e0045;
 		ACCwrite(36);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SUBE BANCO
	p000e0046:
	{
 		if (skipdoall('p000e0046')) break p000e0046;
 		if (in_response)
		{
			if (!CNDverb(10)) break p000e0046;
			if (!CNDnoun1(75)) break p000e0046;
 		}
		if (!CNDat(4)) break p000e0046;
 		ACCwrite(37);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LEE ETIQUETA
	p000e0047:
	{
 		if (skipdoall('p000e0047')) break p000e0047;
 		if (in_response)
		{
			if (!CNDverb(32)) break p000e0047;
			if (!CNDnoun1(222)) break p000e0047;
 		}
		if (!CNDpresent(6)) break p000e0047;
 		ACCwrite(38);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// HUELE _
	p000e0048:
	{
 		if (skipdoall('p000e0048')) break p000e0048;
 		if (in_response)
		{
			if (!CNDverb(72)) break p000e0048;
 		}
		if (!CNDat(33)) break p000e0048;
 		ACCwrite(39);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SUBE CAMA
	p000e0049:
	{
 		if (skipdoall('p000e0049')) break p000e0049;
 		if (in_response)
		{
			if (!CNDverb(10)) break p000e0049;
			if (!CNDnoun1(56)) break p000e0049;
 		}
		if (!CNDat(1)) break p000e0049;
 		ACClet(33,35);
		{}

	}

	// ACOSTAR _
	p000e0050:
	{
 		if (skipdoall('p000e0050')) break p000e0050;
 		if (in_response)
		{
			if (!CNDverb(101)) break p000e0050;
 		}
 		ACClet(33,35);
		{}

	}

	// COLOCA _
	p000e0051:
	{
 		if (skipdoall('p000e0051')) break p000e0051;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0051;
 		}
		if (!CNDnoun2(89)) break p000e0051;
		if (!CNDeq(35,255)) break p000e0051;
		if (!CNDabsent(26)) break p000e0051;
		if (!CNDpresent(5)) break p000e0051;
 		ACCwrite(40);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// EMPUJA _
	p000e0052:
	{
 		if (skipdoall('p000e0052')) break p000e0052;
 		if (in_response)
		{
			if (!CNDverb(36)) break p000e0052;
 		}
		if (!CNDlt(34,50)) break p000e0052;
 		ACClet(33,63);
		{}

	}

	// EMPUJA _
	p000e0053:
	{
 		if (skipdoall('p000e0053')) break p000e0053;
 		if (in_response)
		{
			if (!CNDverb(36)) break p000e0053;
 		}
		if (!CNDeq(34,255)) break p000e0053;
 		ACCwrite(41);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// EMPUJA CHIMENEA
	p000e0054:
	{
 		if (skipdoall('p000e0054')) break p000e0054;
 		if (in_response)
		{
			if (!CNDverb(36)) break p000e0054;
			if (!CNDnoun1(66)) break p000e0054;
 		}
		if (!CNDat(1)) break p000e0054;
 		ACCwrite(42);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA AGOSTINE
	p000e0055:
	{
 		if (skipdoall('p000e0055')) break p000e0055;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0055;
			if (!CNDnoun1(26)) break p000e0055;
 		}
		if (!CNDnoun2(89)) break p000e0055;
		if (!CNDpresent(26)) break p000e0055;
		if (!CNDnotzero(113)) break p000e0055;
 		ACCwrite(43);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE CAJA
	p000e0056:
	{
 		if (skipdoall('p000e0056')) break p000e0056;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0056;
			if (!CNDnoun1(89)) break p000e0056;
 		}
		if (!CNDadject1(13)) break p000e0056;
		if (!CNDat(30)) break p000e0056;
		if (!CNDzero(122)) break p000e0056;
 		ACCwrite(44);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA _
	p000e0057:
	{
 		if (skipdoall('p000e0057')) break p000e0057;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0057;
 		}
		if (!CNDnoun2(89)) break p000e0057;
		if (!CNDadject1(13)) break p000e0057;
		if (!CNDat(30)) break p000e0057;
		if (!CNDnotzero(122)) break p000e0057;
		if (!CNDzero(123)) break p000e0057;
 		ACCwrite(45);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA _
	p000e0058:
	{
 		if (skipdoall('p000e0058')) break p000e0058;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0058;
 		}
		if (!CNDnoun2(89)) break p000e0058;
		if (!CNDadject1(13)) break p000e0058;
		if (!CNDat(30)) break p000e0058;
		if (!CNDnotzero(122)) break p000e0058;
		if (!CNDzero(123)) break p000e0058;
 		ACCwrite(46);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA _
	p000e0059:
	{
 		if (skipdoall('p000e0059')) break p000e0059;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0059;
 		}
		if (!CNDnoun2(89)) break p000e0059;
		if (!CNDadject1(13)) break p000e0059;
		if (!CNDat(30)) break p000e0059;
		if (!CNDnotzero(122)) break p000e0059;
		if (!CNDnotzero(123)) break p000e0059;
 		ACCwrite(47);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA CD
	p000e0060:
	{
 		if (skipdoall('p000e0060')) break p000e0060;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0060;
			if (!CNDnoun1(156)) break p000e0060;
 		}
		if (!CNDnoun2(89)) break p000e0060;
		if (!CNDadject1(13)) break p000e0060;
		if (!CNDat(30)) break p000e0060;
		if (!CNDnotzero(122)) break p000e0060;
		if (!CNDnotzero(123)) break p000e0060;
		if (!CNDisat(23,43)) break p000e0060;
 		ACCwrite(48);
 		ACCplace(23,254);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA CD
	p000e0061:
	{
 		if (skipdoall('p000e0061')) break p000e0061;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0061;
			if (!CNDnoun1(156)) break p000e0061;
 		}
		if (!CNDnoun2(89)) break p000e0061;
		if (!CNDadject1(13)) break p000e0061;
		if (!CNDnotzero(122)) break p000e0061;
		if (!CNDnotzero(123)) break p000e0061;
		if (!CNDisnotat(23,43)) break p000e0061;
 		ACCwrite(49);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA _
	p000e0062:
	{
 		if (skipdoall('p000e0062')) break p000e0062;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0062;
 		}
		if (!CNDnoun2(89)) break p000e0062;
		if (!CNDadject1(13)) break p000e0062;
		if (!CNDnotzero(122)) break p000e0062;
		if (!CNDnotzero(123)) break p000e0062;
 		ACCwrite(50);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR CAJA
	p000e0063:
	{
 		if (skipdoall('p000e0063')) break p000e0063;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0063;
			if (!CNDnoun1(89)) break p000e0063;
 		}
		if (!CNDadject1(13)) break p000e0063;
		if (!CNDat(30)) break p000e0063;
		if (!CNDnotzero(122)) break p000e0063;
		if (!CNDnotzero(123)) break p000e0063;
 		ACCwrite(51);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR CAJA
	p000e0064:
	{
 		if (skipdoall('p000e0064')) break p000e0064;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0064;
			if (!CNDnoun1(89)) break p000e0064;
 		}
		if (!CNDadject1(13)) break p000e0064;
		if (!CNDat(30)) break p000e0064;
		if (!CNDnotzero(122)) break p000e0064;
		if (!CNDzero(123)) break p000e0064;
 		ACCwrite(52);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE CAJA
	p000e0065:
	{
 		if (skipdoall('p000e0065')) break p000e0065;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0065;
			if (!CNDnoun1(89)) break p000e0065;
 		}
		if (!CNDadject1(13)) break p000e0065;
		if (!CNDat(30)) break p000e0065;
		if (!CNDnotzero(122)) break p000e0065;
		if (!CNDnotzero(123)) break p000e0065;
 		ACCwrite(53);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE CAJA
	p000e0066:
	{
 		if (skipdoall('p000e0066')) break p000e0066;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0066;
			if (!CNDnoun1(89)) break p000e0066;
 		}
		if (!CNDadject1(13)) break p000e0066;
		if (!CNDnoun2(190)) break p000e0066;
		if (!CNDat(30)) break p000e0066;
		if (!CNDnotzero(122)) break p000e0066;
		if (!CNDzero(123)) break p000e0066;
		if (!CNDnotcarr(28)) break p000e0066;
 		ACCwrite(54);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE CAJA
	p000e0067:
	{
 		if (skipdoall('p000e0067')) break p000e0067;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0067;
			if (!CNDnoun1(89)) break p000e0067;
 		}
		if (!CNDadject1(13)) break p000e0067;
		if (!CNDnoun2(190)) break p000e0067;
		if (!CNDat(30)) break p000e0067;
		if (!CNDnotzero(122)) break p000e0067;
		if (!CNDzero(123)) break p000e0067;
		if (!CNDcarried(28)) break p000e0067;
 		ACCwrite(55);
 		ACCanykey();
 		function anykey00007() 
		{
 		ACCwrite(57);
 		ACCset(123);
 		ACCdone();
		return;
		}
 		function anykey00006() 
		{
 		ACCwrite(56);
 		ACCanykey();
 		waitKey(anykey00007);
		}
 		waitKey(anykey00006);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// ABRE CAJA
	p000e0068:
	{
 		if (skipdoall('p000e0068')) break p000e0068;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0068;
			if (!CNDnoun1(89)) break p000e0068;
 		}
		if (!CNDadject1(13)) break p000e0068;
		if (!CNDat(30)) break p000e0068;
		if (!CNDnotzero(122)) break p000e0068;
		if (!CNDzero(123)) break p000e0068;
 		ACCwrite(58);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ECHA AGUJERO
	p000e0069:
	{
 		if (skipdoall('p000e0069')) break p000e0069;
 		if (in_response)
		{
			if (!CNDverb(67)) break p000e0069;
			if (!CNDnoun1(100)) break p000e0069;
 		}
		if (!CNDnoun2(26)) break p000e0069;
		if (!CNDsame(38,118)) break p000e0069;
		if (!CNDcarried(12)) break p000e0069;
 		ACCwrite(59);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// _ PORTATIL
	p000e0070:
	{
 		if (skipdoall('p000e0070')) break p000e0070;
 		if (in_response)
		{
			if (!CNDnoun1(220)) break p000e0070;
 		}
		if (!CNDat(30)) break p000e0070;
 		ACClet(34,151);
		{}

	}

	// _ _
	p000e0071:
	{
 		if (skipdoall('p000e0071')) break p000e0071;
		if (!CNDnoteq(35,255)) break p000e0071;
		if (!CNDnoteq(35,13)) break p000e0071;
 		ACClet(35,255);
		{}

	}

	// CARGA AGOSTINE
	p000e0072:
	{
 		if (skipdoall('p000e0072')) break p000e0072;
 		if (in_response)
		{
			if (!CNDverb(27)) break p000e0072;
			if (!CNDnoun1(26)) break p000e0072;
 		}
		if (!CNDat(5)) break p000e0072;
		if (!CNDnotzero(71)) break p000e0072;
		if (!CNDzero(113)) break p000e0072;
		if (!CNDeq(118,5)) break p000e0072;
 		ACCwrite(60);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DEJA AGOSTINE
	p000e0073:
	{
 		if (skipdoall('p000e0073')) break p000e0073;
 		if (in_response)
		{
			if (!CNDverb(51)) break p000e0073;
			if (!CNDnoun1(26)) break p000e0073;
 		}
		if (!CNDat(5)) break p000e0073;
		if (!CNDnotzero(71)) break p000e0073;
		if (!CNDnotzero(113)) break p000e0073;
 		ACCwrite(61);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA _
	p000e0074:
	{
 		if (skipdoall('p000e0074')) break p000e0074;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0074;
 		}
		if (!CNDnoun2(224)) break p000e0074;
		if (!CNDat(30)) break p000e0074;
		if (!CNDzero(121)) break p000e0074;
 		ACCwrite(62);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LANZA CERILLA
	p000e0075:
	{
 		if (skipdoall('p000e0075')) break p000e0075;
 		if (in_response)
		{
			if (!CNDverb(76)) break p000e0075;
			if (!CNDnoun1(74)) break p000e0075;
 		}
		if (!CNDnoun2(28)) break p000e0075;
		if (!CNDat(3)) break p000e0075;
		if (!CNDeq(78,1)) break p000e0075;
		if (!CNDlt(66,4)) break p000e0075;
		if (!CNDgt(66,0)) break p000e0075;
 		ACCwrite(63);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// GOLPEA PLANTA
	p000e0076:
	{
 		if (skipdoall('p000e0076')) break p000e0076;
 		if (in_response)
		{
			if (!CNDverb(63)) break p000e0076;
			if (!CNDnoun1(28)) break p000e0076;
 		}
		if (!CNDat(3)) break p000e0076;
		if (!CNDeq(78,1)) break p000e0076;
 		ACCwrite(64);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ATACA PLANTA
	p000e0077:
	{
 		if (skipdoall('p000e0077')) break p000e0077;
 		if (in_response)
		{
			if (!CNDverb(98)) break p000e0077;
			if (!CNDnoun1(28)) break p000e0077;
 		}
		if (!CNDat(3)) break p000e0077;
		if (!CNDeq(78,1)) break p000e0077;
 		ACCwrite(65);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// MORDER CUERDA
	p000e0078:
	{
 		if (skipdoall('p000e0078')) break p000e0078;
 		if (in_response)
		{
			if (!CNDverb(106)) break p000e0078;
			if (!CNDnoun1(90)) break p000e0078;
 		}
		if (!CNDat(5)) break p000e0078;
		if (!CNDnotzero(75)) break p000e0078;
 		ACCwrite(66);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// MORDER CUERDA
	p000e0079:
	{
 		if (skipdoall('p000e0079')) break p000e0079;
 		if (in_response)
		{
			if (!CNDverb(106)) break p000e0079;
			if (!CNDnoun1(90)) break p000e0079;
 		}
		if (!CNDat(5)) break p000e0079;
		if (!CNDzero(75)) break p000e0079;
 		ACCwrite(67);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DESAZ CUERDA
	p000e0080:
	{
 		if (skipdoall('p000e0080')) break p000e0080;
 		if (in_response)
		{
			if (!CNDverb(107)) break p000e0080;
			if (!CNDnoun1(90)) break p000e0080;
 		}
		if (!CNDat(5)) break p000e0080;
 		ACClet(33,61);
		{}

	}

	// ROMPE CUERDA
	p000e0081:
	{
 		if (skipdoall('p000e0081')) break p000e0081;
 		if (in_response)
		{
			if (!CNDverb(94)) break p000e0081;
			if (!CNDnoun1(90)) break p000e0081;
 		}
		if (!CNDat(5)) break p000e0081;
 		ACClet(33,62);
		{}

	}

	// BAJA _
	p000e0082:
	{
 		if (skipdoall('p000e0082')) break p000e0082;
 		if (in_response)
		{
			if (!CNDverb(11)) break p000e0082;
 		}
		if (!CNDnotzero(84)) break p000e0082;
 		ACClet(33,86);
		{}

	}

	// RETIRA _
	p000e0083:
	{
 		if (skipdoall('p000e0083')) break p000e0083;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0083;
 		}
		if (!CNDpresent(26)) break p000e0083;
 		ACCwhatox(11);
		if (!CNDeq(51,5)) break p000e0083;
		if (!CNDisnotat(5,38)) break p000e0083;
 		ACCwrite(68);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SALIDAS _
	p000e0084:
	{
 		if (skipdoall('p000e0084')) break p000e0084;
 		if (in_response)
		{
			if (!CNDverb(105)) break p000e0084;
 		}
 		ACClet(33,54);
		{}

	}

	// ECHA ELEXIR
	p000e0085:
	{
 		if (skipdoall('p000e0085')) break p000e0085;
 		if (in_response)
		{
			if (!CNDverb(67)) break p000e0085;
			if (!CNDnoun1(103)) break p000e0085;
 		}
 		ACClet(33,67);
		{}

	}

	// COLOCA ELEXIR
	p000e0086:
	{
 		if (skipdoall('p000e0086')) break p000e0086;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0086;
			if (!CNDnoun1(103)) break p000e0086;
 		}
		if (!CNDnoun2(100)) break p000e0086;
 		ACClet(33,67);
		{}

	}

	// ROMPE INVERNADER
	p000e0087:
	{
 		if (skipdoall('p000e0087')) break p000e0087;
 		if (in_response)
		{
			if (!CNDverb(94)) break p000e0087;
			if (!CNDnoun1(98)) break p000e0087;
 		}
		if (!CNDnoun2(57)) break p000e0087;
		if (!CNDcarried(3)) break p000e0087;
		if (!CNDat(8)) break p000e0087;
 		ACCwrite(69);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ROMPE CRISTAL
	p000e0088:
	{
 		if (skipdoall('p000e0088')) break p000e0088;
 		if (in_response)
		{
			if (!CNDverb(94)) break p000e0088;
			if (!CNDnoun1(91)) break p000e0088;
 		}
		if (!CNDnoun2(57)) break p000e0088;
		if (!CNDcarried(3)) break p000e0088;
		if (!CNDat(8)) break p000e0088;
 		ACCwrite(70);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ROMPE PARED
	p000e0089:
	{
 		if (skipdoall('p000e0089')) break p000e0089;
 		if (in_response)
		{
			if (!CNDverb(94)) break p000e0089;
			if (!CNDnoun1(177)) break p000e0089;
 		}
		if (!CNDnoun2(57)) break p000e0089;
		if (!CNDcarried(3)) break p000e0089;
		if (!CNDat(8)) break p000e0089;
 		ACCwrite(71);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE PUERTA
	p000e0090:
	{
 		if (skipdoall('p000e0090')) break p000e0090;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0090;
			if (!CNDnoun1(69)) break p000e0090;
 		}
		if (!CNDnoun2(71)) break p000e0090;
		if (!CNDat(8)) break p000e0090;
		if (!CNDcarried(4)) break p000e0090;
		if (!CNDzero(77)) break p000e0090;
 		ACCwrite(72);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// GOLPEA PUERTA
	p000e0091:
	{
 		if (skipdoall('p000e0091')) break p000e0091;
 		if (in_response)
		{
			if (!CNDverb(63)) break p000e0091;
			if (!CNDnoun1(69)) break p000e0091;
 		}
		if (!CNDat(8)) break p000e0091;
		if (!CNDzero(77)) break p000e0091;
 		ACCwrite(73);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// GOLPEA PUERTA
	p000e0092:
	{
 		if (skipdoall('p000e0092')) break p000e0092;
 		if (in_response)
		{
			if (!CNDverb(63)) break p000e0092;
			if (!CNDnoun1(69)) break p000e0092;
 		}
		if (!CNDat(8)) break p000e0092;
		if (!CNDnotzero(77)) break p000e0092;
 		ACCwrite(74);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LLAMA PUERTA
	p000e0093:
	{
 		if (skipdoall('p000e0093')) break p000e0093;
 		if (in_response)
		{
			if (!CNDverb(79)) break p000e0093;
			if (!CNDnoun1(69)) break p000e0093;
 		}
		if (!CNDat(8)) break p000e0093;
 		ACCwrite(75);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LLENA AGUA
	p000e0094:
	{
 		if (skipdoall('p000e0094')) break p000e0094;
 		if (in_response)
		{
			if (!CNDverb(71)) break p000e0094;
			if (!CNDnoun1(107)) break p000e0094;
 		}
		if (!CNDnoun2(100)) break p000e0094;
 		ACClet(34,100);
		{}

	}

	// COGE AGUA
	p000e0095:
	{
 		if (skipdoall('p000e0095')) break p000e0095;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0095;
			if (!CNDnoun1(107)) break p000e0095;
 		}
		if (!CNDnoun2(100)) break p000e0095;
 		ACClet(33,71);
 		ACClet(34,100);
		{}

	}

	// COLOCA AGUA
	p000e0096:
	{
 		if (skipdoall('p000e0096')) break p000e0096;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0096;
			if (!CNDnoun1(107)) break p000e0096;
 		}
		if (!CNDnoun2(100)) break p000e0096;
 		ACClet(33,71);
 		ACClet(34,100);
		{}

	}

	// ENTRA _
	p000e0097:
	{
 		if (skipdoall('p000e0097')) break p000e0097;
 		if (in_response)
		{
			if (!CNDverb(50)) break p000e0097;
 		}
		if (!CNDat(9)) break p000e0097;
		if (!CNDnotzero(79)) break p000e0097;
		if (!CNDcarried(6)) break p000e0097;
		if (!CNDzero(128)) break p000e0097;
 		ACCset(128);
 		ACCwrite(76);
		{}

	}

	// TRANSCRIBE _
	p000e0098:
	{
 		if (skipdoall('p000e0098')) break p000e0098;
 		if (in_response)
		{
			if (!CNDverb(104)) break p000e0098;
 		}
 		ACCtranscript(1);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA PARAGUAS
	p000e0099:
	{
 		if (skipdoall('p000e0099')) break p000e0099;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0099;
			if (!CNDnoun1(76)) break p000e0099;
 		}
		if (!CNDcarried(6)) break p000e0099;
 		ACCwrite(77);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE _
	p000e0100:
	{
 		if (skipdoall('p000e0100')) break p000e0100;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0100;
 		}
		if (!CNDat(2)) break p000e0100;
		if (!CNDnotzero(126)) break p000e0100;
 		ACCwrite(78);
 		ACCwrite(79);
		{}

	}

	// COGE _
	p000e0101:
	{
 		if (skipdoall('p000e0101')) break p000e0101;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0101;
 		}
		if (!CNDat(2)) break p000e0101;
		if (!CNDzero(126)) break p000e0101;
 		ACCwrite(80);
 		ACCset(126);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE CAJA
	p000e0102:
	{
 		if (skipdoall('p000e0102')) break p000e0102;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0102;
			if (!CNDnoun1(89)) break p000e0102;
 		}
		if (!CNDnoteq(35,13)) break p000e0102;
		if (!CNDpresent(5)) break p000e0102;
		if (!CNDpresent(26)) break p000e0102;
 		ACCwrite(81);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE CAJA
	p000e0103:
	{
 		if (skipdoall('p000e0103')) break p000e0103;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0103;
			if (!CNDnoun1(89)) break p000e0103;
 		}
		if (!CNDnoteq(35,13)) break p000e0103;
		if (!CNDpresent(5)) break p000e0103;
 		ACCwrite(82);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR CAJA
	p000e0104:
	{
 		if (skipdoall('p000e0104')) break p000e0104;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0104;
			if (!CNDnoun1(89)) break p000e0104;
 		}
		if (!CNDnoteq(35,13)) break p000e0104;
		if (!CNDpresent(5)) break p000e0104;
		if (!CNDpresent(26)) break p000e0104;
 		ACCwrite(83);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR CAJA
	p000e0105:
	{
 		if (skipdoall('p000e0105')) break p000e0105;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0105;
			if (!CNDnoun1(89)) break p000e0105;
 		}
		if (!CNDnoteq(35,13)) break p000e0105;
		if (!CNDpresent(5)) break p000e0105;
 		ACCwrite(84);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ECHA CAJA
	p000e0106:
	{
 		if (skipdoall('p000e0106')) break p000e0106;
 		if (in_response)
		{
			if (!CNDverb(67)) break p000e0106;
			if (!CNDnoun1(89)) break p000e0106;
 		}
		if (!CNDnoun2(89)) break p000e0106;
		if (!CNDabsent(5)) break p000e0106;
 		ACCwrite(85);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGELA _
	p000e0107:
	{
 		if (skipdoall('p000e0107')) break p000e0107;
 		if (in_response)
		{
			if (!CNDverb(21)) break p000e0107;
 		}
		if (!CNDnoun2(88)) break p000e0107;
		if (!CNDat(5)) break p000e0107;
 		ACClet(33,59);
		{}

	}

	// RETIRA _
	p000e0108:
	{
 		if (skipdoall('p000e0108')) break p000e0108;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0108;
 		}
		if (!CNDnotzero(71)) break p000e0108;
 		ACClet(43,88);
		{}

	}

	// BOTA CAJON
	p000e0109:
	{
 		if (skipdoall('p000e0109')) break p000e0109;
 		if (in_response)
		{
			if (!CNDverb(53)) break p000e0109;
			if (!CNDnoun1(88)) break p000e0109;
 		}
		if (!CNDat(5)) break p000e0109;
 		ACClet(33,10);
		{}

	}

	// ENTRA CAJON
	p000e0110:
	{
 		if (skipdoall('p000e0110')) break p000e0110;
 		if (in_response)
		{
			if (!CNDverb(50)) break p000e0110;
			if (!CNDnoun1(88)) break p000e0110;
 		}
		if (!CNDat(5)) break p000e0110;
 		ACClet(33,10);
		{}

	}

	// BOTA _
	p000e0111:
	{
 		if (skipdoall('p000e0111')) break p000e0111;
 		if (in_response)
		{
			if (!CNDverb(53)) break p000e0111;
 		}
		if (!CNDnotzero(71)) break p000e0111;
 		ACClet(33,11);
 		ACClet(34,88);
		{}

	}

	// BAJA _
	p000e0112:
	{
 		if (skipdoall('p000e0112')) break p000e0112;
 		if (in_response)
		{
			if (!CNDverb(11)) break p000e0112;
 		}
		if (!CNDnotzero(71)) break p000e0112;
 		ACClet(33,11);
 		ACClet(34,88);
		{}

	}

	// SAL _
	p000e0113:
	{
 		if (skipdoall('p000e0113')) break p000e0113;
 		if (in_response)
		{
			if (!CNDverb(49)) break p000e0113;
 		}
		if (!CNDnotzero(71)) break p000e0113;
 		ACClet(33,11);
 		ACClet(34,88);
		{}

	}

	// ENCENDER CAJA
	p000e0114:
	{
 		if (skipdoall('p000e0114')) break p000e0114;
 		if (in_response)
		{
			if (!CNDverb(44)) break p000e0114;
			if (!CNDnoun1(89)) break p000e0114;
 		}
 		ACClet(34,74);
		{}

	}

	// EXAMINAME _
	p000e0115:
	{
 		if (skipdoall('p000e0115')) break p000e0115;
 		if (in_response)
		{
			if (!CNDverb(103)) break p000e0115;
 		}
 		ACClet(33,30);
 		ACClet(34,181);
		{}

	}

	// LEE LIBROS
	p000e0116:
	{
 		if (skipdoall('p000e0116')) break p000e0116;
 		if (in_response)
		{
			if (!CNDverb(32)) break p000e0116;
			if (!CNDnoun1(54)) break p000e0116;
 		}
		if (!CNDat(29)) break p000e0116;
 		ACCwrite(86);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE MUEBLES
	p000e0117:
	{
 		if (skipdoall('p000e0117')) break p000e0117;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0117;
			if (!CNDnoun1(201)) break p000e0117;
 		}
		if (!CNDat(32)) break p000e0117;
 		ACCwrite(87);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE SILLON
	p000e0118:
	{
 		if (skipdoall('p000e0118')) break p000e0118;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0118;
			if (!CNDnoun1(218)) break p000e0118;
 		}
		if (!CNDat(32)) break p000e0118;
 		ACCwrite(88);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// EMPUJA SILLON
	p000e0119:
	{
 		if (skipdoall('p000e0119')) break p000e0119;
 		if (in_response)
		{
			if (!CNDverb(36)) break p000e0119;
			if (!CNDnoun1(218)) break p000e0119;
 		}
		if (!CNDat(32)) break p000e0119;
 		ACCwrite(89);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// EMPUJA SILLON
	p000e0120:
	{
 		if (skipdoall('p000e0120')) break p000e0120;
 		if (in_response)
		{
			if (!CNDverb(36)) break p000e0120;
			if (!CNDnoun1(218)) break p000e0120;
 		}
		if (!CNDat(32)) break p000e0120;
 		ACCwrite(90);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// EMPUJA MUEBLES
	p000e0121:
	{
 		if (skipdoall('p000e0121')) break p000e0121;
 		if (in_response)
		{
			if (!CNDverb(36)) break p000e0121;
			if (!CNDnoun1(201)) break p000e0121;
 		}
		if (!CNDat(32)) break p000e0121;
 		ACCwrite(91);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// EMPUJA MUEBLES
	p000e0122:
	{
 		if (skipdoall('p000e0122')) break p000e0122;
 		if (in_response)
		{
			if (!CNDverb(36)) break p000e0122;
			if (!CNDnoun1(201)) break p000e0122;
 		}
		if (!CNDat(32)) break p000e0122;
 		ACCwrite(92);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE LAMPARA
	p000e0123:
	{
 		if (skipdoall('p000e0123')) break p000e0123;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0123;
			if (!CNDnoun1(200)) break p000e0123;
 		}
		if (!CNDat(32)) break p000e0123;
 		ACCwrite(93);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE COPA
	p000e0124:
	{
 		if (skipdoall('p000e0124')) break p000e0124;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0124;
			if (!CNDnoun1(217)) break p000e0124;
 		}
		if (!CNDat(32)) break p000e0124;
		if (!CNDnotzero(117)) break p000e0124;
 		ACCwrite(94);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LEE LIBROS
	p000e0125:
	{
 		if (skipdoall('p000e0125')) break p000e0125;
 		if (in_response)
		{
			if (!CNDverb(32)) break p000e0125;
			if (!CNDnoun1(54)) break p000e0125;
 		}
		if (!CNDat(32)) break p000e0125;
 		ACCwrite(95);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE LIBROS
	p000e0126:
	{
 		if (skipdoall('p000e0126')) break p000e0126;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0126;
			if (!CNDnoun1(54)) break p000e0126;
 		}
		if (!CNDat(32)) break p000e0126;
 		ACCwrite(96);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE CAJA
	p000e0127:
	{
 		if (skipdoall('p000e0127')) break p000e0127;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0127;
			if (!CNDnoun1(89)) break p000e0127;
 		}
		if (!CNDnoun2(89)) break p000e0127;
		if (!CNDpresent(5)) break p000e0127;
		if (!CNDnotcarr(5)) break p000e0127;
 		ACCget(5);
		if (!success) break pro000_restart;
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DEJA CAJA
	p000e0128:
	{
 		if (skipdoall('p000e0128')) break p000e0128;
 		if (in_response)
		{
			if (!CNDverb(51)) break p000e0128;
			if (!CNDnoun1(89)) break p000e0128;
 		}
		if (!CNDnoun2(89)) break p000e0128;
		if (!CNDcarried(5)) break p000e0128;
 		ACCdrop(5);
		if (!success) break pro000_restart;
 		ACCdone();
		break pro000_restart;
		{}

	}

	// BEBE AGUA
	p000e0129:
	{
 		if (skipdoall('p000e0129')) break p000e0129;
 		if (in_response)
		{
			if (!CNDverb(68)) break p000e0129;
			if (!CNDnoun1(107)) break p000e0129;
 		}
		if (!CNDnotat(12)) break p000e0129;
		if (!CNDnotcarr(12)) break p000e0129;
 		ACCwrite(97);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// BEBE AGUJERO
	p000e0130:
	{
 		if (skipdoall('p000e0130')) break p000e0130;
 		if (in_response)
		{
			if (!CNDverb(68)) break p000e0130;
			if (!CNDnoun1(100)) break p000e0130;
 		}
		if (!CNDnotat(12)) break p000e0130;
		if (!CNDcarried(12)) break p000e0130;
		if (!CNDonotzero(12,34)) break p000e0130;
 		ACCwrite(98);
 		ACCoclear(12,34);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// BEBE AGUJERO
	p000e0131:
	{
 		if (skipdoall('p000e0131')) break p000e0131;
 		if (in_response)
		{
			if (!CNDverb(68)) break p000e0131;
			if (!CNDnoun1(100)) break p000e0131;
 		}
		if (!CNDnotat(12)) break p000e0131;
		if (!CNDcarried(12)) break p000e0131;
		if (!CNDozero(12,34)) break p000e0131;
 		ACCwrite(99);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// BEBE AGUA
	p000e0132:
	{
 		if (skipdoall('p000e0132')) break p000e0132;
 		if (in_response)
		{
			if (!CNDverb(68)) break p000e0132;
			if (!CNDnoun1(107)) break p000e0132;
 		}
		if (!CNDnotat(12)) break p000e0132;
		if (!CNDcarried(12)) break p000e0132;
		if (!CNDonotzero(12,34)) break p000e0132;
 		ACCwrite(100);
 		ACCoclear(12,34);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// BEBE AGUA
	p000e0133:
	{
 		if (skipdoall('p000e0133')) break p000e0133;
 		if (in_response)
		{
			if (!CNDverb(68)) break p000e0133;
			if (!CNDnoun1(107)) break p000e0133;
 		}
		if (!CNDnotat(12)) break p000e0133;
		if (!CNDcarried(12)) break p000e0133;
		if (!CNDozero(12,34)) break p000e0133;
 		ACCwrite(101);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// BOTA CHARCA
	p000e0134:
	{
 		if (skipdoall('p000e0134')) break p000e0134;
 		if (in_response)
		{
			if (!CNDverb(53)) break p000e0134;
			if (!CNDnoun1(108)) break p000e0134;
 		}
		if (!CNDat(12)) break p000e0134;
 		ACClet(33,73);
		{}

	}

	// BOTA AGUA
	p000e0135:
	{
 		if (skipdoall('p000e0135')) break p000e0135;
 		if (in_response)
		{
			if (!CNDverb(53)) break p000e0135;
			if (!CNDnoun1(107)) break p000e0135;
 		}
		if (!CNDat(12)) break p000e0135;
 		ACClet(33,73);
		{}

	}

	// BOTA RIACHUELO
	p000e0136:
	{
 		if (skipdoall('p000e0136')) break p000e0136;
 		if (in_response)
		{
			if (!CNDverb(53)) break p000e0136;
			if (!CNDnoun1(109)) break p000e0136;
 		}
		if (!CNDat(12)) break p000e0136;
 		ACClet(33,73);
		{}

	}

	// GOLPEA TERMITA
	p000e0137:
	{
 		if (skipdoall('p000e0137')) break p000e0137;
 		if (in_response)
		{
			if (!CNDverb(63)) break p000e0137;
			if (!CNDnoun1(29)) break p000e0137;
 		}
 		ACClet(33,77);
		{}

	}

	// ATACA TERMITA
	p000e0138:
	{
 		if (skipdoall('p000e0138')) break p000e0138;
 		if (in_response)
		{
			if (!CNDverb(98)) break p000e0138;
			if (!CNDnoun1(29)) break p000e0138;
 		}
 		ACClet(33,77);
		{}

	}

	// GOLPEA PLANTA
	p000e0139:
	{
 		if (skipdoall('p000e0139')) break p000e0139;
 		if (in_response)
		{
			if (!CNDverb(63)) break p000e0139;
			if (!CNDnoun1(28)) break p000e0139;
 		}
 		ACClet(33,77);
		{}

	}

	// ATACA PLANTA
	p000e0140:
	{
 		if (skipdoall('p000e0140')) break p000e0140;
 		if (in_response)
		{
			if (!CNDverb(98)) break p000e0140;
			if (!CNDnoun1(28)) break p000e0140;
 		}
 		ACClet(33,77);
		{}

	}

	// GOLPEA BM
	p000e0141:
	{
 		if (skipdoall('p000e0141')) break p000e0141;
 		if (in_response)
		{
			if (!CNDverb(63)) break p000e0141;
			if (!CNDnoun1(23)) break p000e0141;
 		}
		if (!CNDat(11)) break p000e0141;
		if (!CNDzero(85)) break p000e0141;
 		ACCwrite(102);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ATACA BM
	p000e0142:
	{
 		if (skipdoall('p000e0142')) break p000e0142;
 		if (in_response)
		{
			if (!CNDverb(98)) break p000e0142;
			if (!CNDnoun1(23)) break p000e0142;
 		}
		if (!CNDat(11)) break p000e0142;
		if (!CNDzero(85)) break p000e0142;
 		ACCwrite(103);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// MATA BM
	p000e0143:
	{
 		if (skipdoall('p000e0143')) break p000e0143;
 		if (in_response)
		{
			if (!CNDverb(77)) break p000e0143;
			if (!CNDnoun1(23)) break p000e0143;
 		}
		if (!CNDat(11)) break p000e0143;
		if (!CNDzero(85)) break p000e0143;
 		ACCwrite(104);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ATACA COFRE
	p000e0144:
	{
 		if (skipdoall('p000e0144')) break p000e0144;
 		if (in_response)
		{
			if (!CNDverb(98)) break p000e0144;
			if (!CNDnoun1(22)) break p000e0144;
 		}
 		ACClet(33,77);
		{}

	}

	// GOLPEA COFRE
	p000e0145:
	{
 		if (skipdoall('p000e0145')) break p000e0145;
 		if (in_response)
		{
			if (!CNDverb(63)) break p000e0145;
			if (!CNDnoun1(22)) break p000e0145;
 		}
 		ACClet(33,77);
		{}

	}

	// ATACA NINFA
	p000e0146:
	{
 		if (skipdoall('p000e0146')) break p000e0146;
 		if (in_response)
		{
			if (!CNDverb(98)) break p000e0146;
			if (!CNDnoun1(21)) break p000e0146;
 		}
 		ACClet(33,77);
		{}

	}

	// GOLPEA NINFA
	p000e0147:
	{
 		if (skipdoall('p000e0147')) break p000e0147;
 		if (in_response)
		{
			if (!CNDverb(63)) break p000e0147;
			if (!CNDnoun1(21)) break p000e0147;
 		}
 		ACClet(33,77);
		{}

	}

	// LANZA CERILLA
	p000e0148:
	{
 		if (skipdoall('p000e0148')) break p000e0148;
 		if (in_response)
		{
			if (!CNDverb(76)) break p000e0148;
			if (!CNDnoun1(74)) break p000e0148;
 		}
 		ACClet(33,51);
		{}

	}

	// DESCANSA BECKHAM
	p000e0149:
	{
 		if (skipdoall('p000e0149')) break p000e0149;
 		if (in_response)
		{
			if (!CNDverb(35)) break p000e0149;
			if (!CNDnoun1(25)) break p000e0149;
 		}
		if (!CNDat(30)) break p000e0149;
		if (!CNDnotzero(121)) break p000e0149;
 		ACCwrite(105);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DESCANSA BECKHAM
	p000e0150:
	{
 		if (skipdoall('p000e0150')) break p000e0150;
 		if (in_response)
		{
			if (!CNDverb(35)) break p000e0150;
			if (!CNDnoun1(25)) break p000e0150;
 		}
		if (!CNDat(30)) break p000e0150;
		if (!CNDzero(121)) break p000e0150;
		if (!CNDnotcarr(27)) break p000e0150;
 		ACCwrite(106);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DESCANSA BECKHAM
	p000e0151:
	{
 		if (skipdoall('p000e0151')) break p000e0151;
 		if (in_response)
		{
			if (!CNDverb(35)) break p000e0151;
			if (!CNDnoun1(25)) break p000e0151;
 		}
		if (!CNDat(30)) break p000e0151;
		if (!CNDzero(121)) break p000e0151;
		if (!CNDcarried(27)) break p000e0151;
 		ACCwrite(107);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DESCANSA BECKHAM
	p000e0152:
	{
 		if (skipdoall('p000e0152')) break p000e0152;
 		if (in_response)
		{
			if (!CNDverb(35)) break p000e0152;
			if (!CNDnoun1(25)) break p000e0152;
 		}
		if (!CNDat(32)) break p000e0152;
		if (!CNDnotzero(117)) break p000e0152;
 		ACCwrite(108);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DESCANSA BECKHAM
	p000e0153:
	{
 		if (skipdoall('p000e0153')) break p000e0153;
 		if (in_response)
		{
			if (!CNDverb(35)) break p000e0153;
			if (!CNDnoun1(25)) break p000e0153;
 		}
		if (!CNDat(32)) break p000e0153;
		if (!CNDzero(117)) break p000e0153;
		if (!CNDnotcarr(27)) break p000e0153;
 		ACCwrite(109);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DESCANSA BECKHAM
	p000e0154:
	{
 		if (skipdoall('p000e0154')) break p000e0154;
 		if (in_response)
		{
			if (!CNDverb(35)) break p000e0154;
			if (!CNDnoun1(25)) break p000e0154;
 		}
		if (!CNDat(32)) break p000e0154;
		if (!CNDzero(117)) break p000e0154;
		if (!CNDcarried(27)) break p000e0154;
 		ACCwrite(110);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ATACA PLANTA
	p000e0155:
	{
 		if (skipdoall('p000e0155')) break p000e0155;
 		if (in_response)
		{
			if (!CNDverb(98)) break p000e0155;
			if (!CNDnoun1(28)) break p000e0155;
 		}
		if (!CNDnoteq(78,1)) break p000e0155;
 		ACClet(33,63);
		{}

	}

	// _ PANUELO
	p000e0156:
	{
 		if (skipdoall('p000e0156')) break p000e0156;
 		if (in_response)
		{
			if (!CNDnoun1(191)) break p000e0156;
 		}
		if (!CNDnoun2(204)) break p000e0156;
 		ACClet(33,59);
		{}

	}

	// COGE _
	p000e0157:
	{
 		if (skipdoall('p000e0157')) break p000e0157;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0157;
 		}
		if (!CNDnoun2(88)) break p000e0157;
 		ACClet(33,58);
		{}

	}

	// COGE _
	p000e0158:
	{
 		if (skipdoall('p000e0158')) break p000e0158;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0158;
 		}
		if (!CNDnoun2(89)) break p000e0158;
 		ACClet(33,58);
		{}

	}

	// COGE _
	p000e0159:
	{
 		if (skipdoall('p000e0159')) break p000e0159;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0159;
 		}
		if (!CNDnoun2(97)) break p000e0159;
 		ACClet(33,58);
		{}

	}

	// COGE _
	p000e0160:
	{
 		if (skipdoall('p000e0160')) break p000e0160;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0160;
 		}
		if (!CNDnoun2(89)) break p000e0160;
		if (!CNDadject1(13)) break p000e0160;
 		ACClet(33,58);
		{}

	}

	// DEJA _
	p000e0161:
	{
 		if (skipdoall('p000e0161')) break p000e0161;
 		if (in_response)
		{
			if (!CNDverb(51)) break p000e0161;
 		}
		if (!CNDnoun2(88)) break p000e0161;
 		ACClet(33,59);
		{}

	}

	// DEJA _
	p000e0162:
	{
 		if (skipdoall('p000e0162')) break p000e0162;
 		if (in_response)
		{
			if (!CNDverb(51)) break p000e0162;
 		}
		if (!CNDnoun2(89)) break p000e0162;
 		ACClet(33,59);
		{}

	}

	// DEJA _
	p000e0163:
	{
 		if (skipdoall('p000e0163')) break p000e0163;
 		if (in_response)
		{
			if (!CNDverb(51)) break p000e0163;
 		}
		if (!CNDnoun2(97)) break p000e0163;
 		ACClet(33,59);
		{}

	}

	// DEJA _
	p000e0164:
	{
 		if (skipdoall('p000e0164')) break p000e0164;
 		if (in_response)
		{
			if (!CNDverb(51)) break p000e0164;
 		}
		if (!CNDnoun2(89)) break p000e0164;
		if (!CNDadject1(13)) break p000e0164;
 		ACClet(33,59);
		{}

	}

	// TOCA PUERTA
	p000e0165:
	{
 		if (skipdoall('p000e0165')) break p000e0165;
 		if (in_response)
		{
			if (!CNDverb(80)) break p000e0165;
			if (!CNDnoun1(69)) break p000e0165;
 		}
 		ACClet(33,79);
		{}

	}

	// TOCA CAMPANA
	p000e0166:
	{
 		if (skipdoall('p000e0166')) break p000e0166;
 		if (in_response)
		{
			if (!CNDverb(80)) break p000e0166;
			if (!CNDnoun1(121)) break p000e0166;
 		}
 		ACClet(33,79);
		{}

	}

	// COGE MUEBLES
	p000e0167:
	{
 		if (skipdoall('p000e0167')) break p000e0167;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0167;
			if (!CNDnoun1(201)) break p000e0167;
 		}
		if (!CNDat(31)) break p000e0167;
 		ACCwrite(111);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE MAGICOS
	p000e0168:
	{
 		if (skipdoall('p000e0168')) break p000e0168;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0168;
			if (!CNDnoun1(61)) break p000e0168;
 		}
		if (!CNDat(31)) break p000e0168;
 		ACCwrite(112);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LEE INFORME
	p000e0169:
	{
 		if (skipdoall('p000e0169')) break p000e0169;
 		if (in_response)
		{
			if (!CNDverb(32)) break p000e0169;
			if (!CNDnoun1(216)) break p000e0169;
 		}
		if (!CNDat(42)) break p000e0169;
		if (!CNDzero(121)) break p000e0169;
 		ACCwrite(113);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CORTA PLANTA
	p000e0170:
	{
 		if (skipdoall('p000e0170')) break p000e0170;
 		if (in_response)
		{
			if (!CNDverb(62)) break p000e0170;
			if (!CNDnoun1(28)) break p000e0170;
 		}
		if (!CNDat(3)) break p000e0170;
		if (!CNDeq(78,0)) break p000e0170;
 		ACCwrite(114);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CORTA PLANTA
	p000e0171:
	{
 		if (skipdoall('p000e0171')) break p000e0171;
 		if (in_response)
		{
			if (!CNDverb(62)) break p000e0171;
			if (!CNDnoun1(28)) break p000e0171;
 		}
		if (!CNDat(3)) break p000e0171;
		if (!CNDeq(78,1)) break p000e0171;
 		ACCwrite(115);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// TALA PLANTA
	p000e0172:
	{
 		if (skipdoall('p000e0172')) break p000e0172;
 		if (in_response)
		{
			if (!CNDverb(102)) break p000e0172;
			if (!CNDnoun1(28)) break p000e0172;
 		}
		if (!CNDat(3)) break p000e0172;
		if (!CNDeq(78,1)) break p000e0172;
 		ACCwrite(116);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LEE LIBROS
	p000e0173:
	{
 		if (skipdoall('p000e0173')) break p000e0173;
 		if (in_response)
		{
			if (!CNDverb(32)) break p000e0173;
			if (!CNDnoun1(54)) break p000e0173;
 		}
		if (!CNDat(1)) break p000e0173;
 		ACCwrite(117);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE CERILLA
	p000e0174:
	{
 		if (skipdoall('p000e0174')) break p000e0174;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0174;
			if (!CNDnoun1(74)) break p000e0174;
 		}
 		ACClet(33,58);
		{}

	}

	// RETIRA CERILLA
	p000e0175:
	{
 		if (skipdoall('p000e0175')) break p000e0175;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0175;
			if (!CNDnoun1(74)) break p000e0175;
 		}
		if (!CNDeq(43,255)) break p000e0175;
		if (!CNDnotcarr(5)) break p000e0175;
		if (!CNDpresent(5)) break p000e0175;
 		ACCwrite(118);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA CERILLA
	p000e0176:
	{
 		if (skipdoall('p000e0176')) break p000e0176;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0176;
			if (!CNDnoun1(74)) break p000e0176;
 		}
		if (!CNDeq(43,255)) break p000e0176;
		if (!CNDcarried(5)) break p000e0176;
		if (!CNDzero(67)) break p000e0176;
 		ACCwrite(119);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA CERILLA
	p000e0177:
	{
 		if (skipdoall('p000e0177')) break p000e0177;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0177;
			if (!CNDnoun1(74)) break p000e0177;
 		}
		if (!CNDeq(43,255)) break p000e0177;
		if (!CNDcarried(5)) break p000e0177;
		if (!CNDnotzero(67)) break p000e0177;
 		ACCwrite(120);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA CERILLA
	p000e0178:
	{
 		if (skipdoall('p000e0178')) break p000e0178;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0178;
			if (!CNDnoun1(74)) break p000e0178;
 		}
		if (!CNDnoun2(89)) break p000e0178;
		if (!CNDnotcarr(5)) break p000e0178;
		if (!CNDpresent(5)) break p000e0178;
 		ACCwrite(121);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA CERILLA
	p000e0179:
	{
 		if (skipdoall('p000e0179')) break p000e0179;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0179;
			if (!CNDnoun1(74)) break p000e0179;
 		}
		if (!CNDnoun2(89)) break p000e0179;
		if (!CNDcarried(5)) break p000e0179;
		if (!CNDzero(67)) break p000e0179;
 		ACCwrite(122);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA CERILLA
	p000e0180:
	{
 		if (skipdoall('p000e0180')) break p000e0180;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0180;
			if (!CNDnoun1(74)) break p000e0180;
 		}
		if (!CNDnoun2(89)) break p000e0180;
		if (!CNDcarried(5)) break p000e0180;
		if (!CNDnotzero(67)) break p000e0180;
 		ACCwrite(123);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DESCANSA AGOSTINE
	p000e0181:
	{
 		if (skipdoall('p000e0181')) break p000e0181;
 		if (in_response)
		{
			if (!CNDverb(35)) break p000e0181;
			if (!CNDnoun1(26)) break p000e0181;
 		}
 		ACClet(33,101);
		{}

	}

	// COLOCA AGOSTINE
	p000e0182:
	{
 		if (skipdoall('p000e0182')) break p000e0182;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0182;
			if (!CNDnoun1(26)) break p000e0182;
 		}
		if (!CNDnoun2(56)) break p000e0182;
 		ACClet(33,101);
		{}

	}

	// COGELA AGOSTINE
	p000e0183:
	{
 		if (skipdoall('p000e0183')) break p000e0183;
 		if (in_response)
		{
			if (!CNDverb(21)) break p000e0183;
			if (!CNDnoun1(26)) break p000e0183;
 		}
		if (!CNDnoun2(56)) break p000e0183;
 		ACClet(33,101);
		{}

	}

	// DEJA AGOSTINE
	p000e0184:
	{
 		if (skipdoall('p000e0184')) break p000e0184;
 		if (in_response)
		{
			if (!CNDverb(51)) break p000e0184;
			if (!CNDnoun1(26)) break p000e0184;
 		}
		if (!CNDnoun2(56)) break p000e0184;
 		ACClet(33,101);
		{}

	}

	// ACOSTAR AGOSTINE
	p000e0185:
	{
 		if (skipdoall('p000e0185')) break p000e0185;
 		if (in_response)
		{
			if (!CNDverb(101)) break p000e0185;
			if (!CNDnoun1(26)) break p000e0185;
 		}
		if (!CNDat(1)) break p000e0185;
		if (!CNDnotzero(124)) break p000e0185;
		if (!CNDzero(113)) break p000e0185;
 		ACCwrite(124);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ACOSTAR AGOSTINE
	p000e0186:
	{
 		if (skipdoall('p000e0186')) break p000e0186;
 		if (in_response)
		{
			if (!CNDverb(101)) break p000e0186;
			if (!CNDnoun1(26)) break p000e0186;
 		}
		if (!CNDnotat(1)) break p000e0186;
		if (!CNDnotzero(124)) break p000e0186;
		if (!CNDnotzero(123)) break p000e0186;
 		ACCwrite(125);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ACOSTAR AGOSTINE
	p000e0187:
	{
 		if (skipdoall('p000e0187')) break p000e0187;
 		if (in_response)
		{
			if (!CNDverb(101)) break p000e0187;
			if (!CNDnoun1(26)) break p000e0187;
 		}
		if (!CNDat(1)) break p000e0187;
		if (!CNDnotzero(124)) break p000e0187;
		if (!CNDnotzero(113)) break p000e0187;
 		ACCwrite(126);
 		ACCwrite(127);
 		ACCanykey();
 		function anykey00025() 
		{
 		ACCend();
		return;
		}
 		function anykey00024() 
		{
 		ACCnewline();
 		ACCwrite(154);
 		ACCnewline();
 		ACCwrite(155);
 		ACCturns();
 		ACCanykey();
 		waitKey(anykey00025);
		}
 		function anykey00023() 
		{
 		ACCextern(152);
 		ACCnewline();
 		ACCwrite(153);
 		ACCanykey();
 		waitKey(anykey00024);
		}
 		function anykey00022() 
		{
 		ACCnewline();
 		ACCwrite(149);
 		ACCwrite(150);
 		ACCwrite(151);
 		ACCanykey();
 		waitKey(anykey00023);
		}
 		function anykey00021() 
		{
 		ACCnewline();
 		ACCwrite(147);
 		ACCwrite(148);
 		ACCanykey();
 		waitKey(anykey00022);
		}
 		function anykey00020() 
		{
 		ACCextern(144);
 		ACCnewline();
 		ACCwrite(145);
 		ACCwrite(146);
 		ACCanykey();
 		waitKey(anykey00021);
		}
 		function anykey00019() 
		{
 		ACCnewline();
 		ACCwrite(142);
 		ACCwrite(143);
 		ACCanykey();
 		waitKey(anykey00020);
		}
 		function anykey00018() 
		{
 		ACCextern(140);
 		ACCnewline();
 		ACCwrite(141);
 		ACCanykey();
 		waitKey(anykey00019);
		}
 		function anykey00017() 
		{
 		ACCpicture(43);
 		ACCwrite(138);
 		ACCwrite(139);
 		ACCanykey();
 		waitKey(anykey00018);
		}
 		function anykey00016() 
		{
 		ACCwrite(137);
 		ACCanykey();
 		waitKey(anykey00017);
		}
 		function anykey00015() 
		{
 		ACCwrite(136);
 		ACCanykey();
 		waitKey(anykey00016);
		}
 		function anykey00014() 
		{
 		ACCwrite(135);
 		ACCanykey();
 		waitKey(anykey00015);
		}
 		function anykey00013() 
		{
 		ACCwrite(134);
 		ACCanykey();
 		waitKey(anykey00014);
		}
 		function anykey00012() 
		{
 		ACCwrite(133);
 		ACCanykey();
 		waitKey(anykey00013);
		}
 		function anykey00011() 
		{
 		ACCwrite(132);
 		ACCanykey();
 		waitKey(anykey00012);
		}
 		function anykey00010() 
		{
 		ACCwrite(130);
 		ACCcls();
 		ACCpicture(7);
 		ACCwrite(131);
 		ACCanykey();
 		waitKey(anykey00011);
		}
 		function anykey00009() 
		{
 		ACCwrite(129);
 		ACCanykey();
 		waitKey(anykey00010);
		}
 		function anykey00008() 
		{
 		ACCwrite(128);
 		ACCanykey();
 		waitKey(anykey00009);
		}
 		waitKey(anykey00008);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// DEJA AGOSTINE
	p000e0188:
	{
 		if (skipdoall('p000e0188')) break p000e0188;
 		if (in_response)
		{
			if (!CNDverb(51)) break p000e0188;
			if (!CNDnoun1(26)) break p000e0188;
 		}
		if (!CNDnoun2(56)) break p000e0188;
		if (!CNDat(1)) break p000e0188;
		if (!CNDnotzero(124)) break p000e0188;
		if (!CNDzero(113)) break p000e0188;
 		ACCwrite(156);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DEJA AGOSTINE
	p000e0189:
	{
 		if (skipdoall('p000e0189')) break p000e0189;
 		if (in_response)
		{
			if (!CNDverb(51)) break p000e0189;
			if (!CNDnoun1(26)) break p000e0189;
 		}
		if (!CNDnoun2(56)) break p000e0189;
		if (!CNDnotat(1)) break p000e0189;
		if (!CNDnotzero(124)) break p000e0189;
		if (!CNDzero(123)) break p000e0189;
 		ACCwrite(157);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DEJA AGOSTINE
	p000e0190:
	{
 		if (skipdoall('p000e0190')) break p000e0190;
 		if (in_response)
		{
			if (!CNDverb(51)) break p000e0190;
			if (!CNDnoun1(26)) break p000e0190;
 		}
		if (!CNDnoun2(56)) break p000e0190;
		if (!CNDat(1)) break p000e0190;
		if (!CNDnotzero(124)) break p000e0190;
		if (!CNDnotzero(113)) break p000e0190;
 		ACCwrite(158);
 		ACCwrite(159);
 		ACCanykey();
 		function anykey00042() 
		{
 		ACCcls();
 		ACCwrite(183);
 		ACCnewline();
 		ACCwrite(184);
 		ACCturns();
 		ACCend();
		return;
		}
 		function anykey00041() 
		{
 		ACCcls();
 		ACCwrite(182);
 		ACCanykey();
 		waitKey(anykey00042);
		}
 		function anykey00040() 
		{
 		ACCcls();
 		ACCwrite(179);
 		ACCwrite(180);
 		ACCwrite(181);
 		ACCanykey();
 		waitKey(anykey00041);
		}
 		function anykey00039() 
		{
 		ACCcls();
 		ACCwrite(177);
 		ACCwrite(178);
 		ACCanykey();
 		waitKey(anykey00040);
		}
 		function anykey00038() 
		{
 		ACCcls();
 		ACCwrite(175);
 		ACCwrite(176);
 		ACCanykey();
 		waitKey(anykey00039);
		}
 		function anykey00037() 
		{
 		ACCwrite(173);
 		ACCwrite(174);
 		ACCanykey();
 		waitKey(anykey00038);
		}
 		function anykey00036() 
		{
 		ACCcls();
 		ACCwrite(172);
 		ACCanykey();
 		waitKey(anykey00037);
		}
 		function anykey00035() 
		{
 		ACCpicture(43);
 		ACCcls();
 		ACCwrite(170);
 		ACCwrite(171);
 		ACCanykey();
 		waitKey(anykey00036);
		}
 		function anykey00034() 
		{
 		ACCwrite(169);
 		ACCanykey();
 		waitKey(anykey00035);
		}
 		function anykey00033() 
		{
 		ACCwrite(168);
 		ACCanykey();
 		waitKey(anykey00034);
		}
 		function anykey00032() 
		{
 		ACCwrite(167);
 		ACCanykey();
 		waitKey(anykey00033);
		}
 		function anykey00031() 
		{
 		ACCwrite(166);
 		ACCanykey();
 		waitKey(anykey00032);
		}
 		function anykey00030() 
		{
 		ACCwrite(165);
 		ACCanykey();
 		waitKey(anykey00031);
		}
 		function anykey00029() 
		{
 		ACCwrite(164);
 		ACCanykey();
 		waitKey(anykey00030);
		}
 		function anykey00028() 
		{
 		ACCwrite(162);
 		ACCcls();
 		ACCpicture(7);
 		ACCwrite(163);
 		ACCanykey();
 		waitKey(anykey00029);
		}
 		function anykey00027() 
		{
 		ACCwrite(161);
 		ACCanykey();
 		waitKey(anykey00028);
		}
 		function anykey00026() 
		{
 		ACCwrite(160);
 		ACCanykey();
 		waitKey(anykey00027);
		}
 		waitKey(anykey00026);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// DESCANSA _
	p000e0191:
	{
 		if (skipdoall('p000e0191')) break p000e0191;
 		if (in_response)
		{
			if (!CNDverb(35)) break p000e0191;
 		}
		if (!CNDnotzero(124)) break p000e0191;
		if (!CNDat(1)) break p000e0191;
 		ACCwrite(185);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA AGOSTINE
	p000e0192:
	{
 		if (skipdoall('p000e0192')) break p000e0192;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0192;
			if (!CNDnoun1(26)) break p000e0192;
 		}
		if (!CNDnoun2(88)) break p000e0192;
		if (!CNDat(5)) break p000e0192;
		if (!CNDnotzero(113)) break p000e0192;
 		ACCwrite(186);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA AGOSTINE
	p000e0193:
	{
 		if (skipdoall('p000e0193')) break p000e0193;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0193;
			if (!CNDnoun1(26)) break p000e0193;
 		}
		if (!CNDnotzero(113)) break p000e0193;
 		ACCwrite(187);
 		ACCdone();
		break pro000_restart;
		{}

	}

	//  _
	p000e0194:
	{
 		if (skipdoall('p000e0194')) break p000e0194;
 		if (in_response)
		{
			if (!CNDverb(3)) break p000e0194;
 		}
		if (!CNDat(10)) break p000e0194;
		if (!CNDnotzero(124)) break p000e0194;
 		ACCwrite(188);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// MONTA BM
	p000e0195:
	{
 		if (skipdoall('p000e0195')) break p000e0195;
 		if (in_response)
		{
			if (!CNDverb(56)) break p000e0195;
			if (!CNDnoun1(23)) break p000e0195;
 		}
		if (!CNDnotzero(124)) break p000e0195;
		if (!CNDsame(38,86)) break p000e0195;
 		ACCwrite(189);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SUBE BM
	p000e0196:
	{
 		if (skipdoall('p000e0196')) break p000e0196;
 		if (in_response)
		{
			if (!CNDverb(10)) break p000e0196;
			if (!CNDnoun1(23)) break p000e0196;
 		}
		if (!CNDnotzero(124)) break p000e0196;
		if (!CNDsame(38,86)) break p000e0196;
 		ACCwrite(190);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DA CD
	p000e0197:
	{
 		if (skipdoall('p000e0197')) break p000e0197;
 		if (in_response)
		{
			if (!CNDverb(75)) break p000e0197;
			if (!CNDnoun1(156)) break p000e0197;
 		}
		if (!CNDnoun2(26)) break p000e0197;
		if (!CNDnotzero(109)) break p000e0197;
		if (!CNDsame(118,38)) break p000e0197;
		if (!CNDnotcarr(23)) break p000e0197;
 		ACCwrite(191);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DA CD
	p000e0198:
	{
 		if (skipdoall('p000e0198')) break p000e0198;
 		if (in_response)
		{
			if (!CNDverb(75)) break p000e0198;
			if (!CNDnoun1(156)) break p000e0198;
 		}
		if (!CNDnoun2(26)) break p000e0198;
		if (!CNDnotzero(109)) break p000e0198;
		if (!CNDsame(118,38)) break p000e0198;
		if (!CNDcarried(23)) break p000e0198;
 		ACCwrite(192);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SAL _
	p000e0199:
	{
 		if (skipdoall('p000e0199')) break p000e0199;
 		if (in_response)
		{
			if (!CNDverb(49)) break p000e0199;
 		}
		if (!CNDat(41)) break p000e0199;
		if (!CNDzero(113)) break p000e0199;
 		ACCwrite(193);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SAL _
	p000e0200:
	{
 		if (skipdoall('p000e0200')) break p000e0200;
 		if (in_response)
		{
			if (!CNDverb(49)) break p000e0200;
 		}
		if (!CNDat(41)) break p000e0200;
		if (!CNDnotzero(113)) break p000e0200;
		if (!CNDnotcarr(23)) break p000e0200;
 		ACCwrite(194);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SAL _
	p000e0201:
	{
 		if (skipdoall('p000e0201')) break p000e0201;
 		if (in_response)
		{
			if (!CNDverb(49)) break p000e0201;
 		}
		if (!CNDat(41)) break p000e0201;
		if (!CNDnotzero(113)) break p000e0201;
		if (!CNDcarried(23)) break p000e0201;
 		ACCset(124);
 		ACCcls();
 		ACCwrite(195);
 		ACCanykey();
 		function anykey00055() 
		{
 		ACClet(86,10);
 		ACCgoto(10);
 		ACCdesc();
		return;
		}
 		function anykey00054() 
		{
 		ACCwrite(211);
 		ACCwrite(212);
 		ACCwrite(213);
 		ACCanykey();
 		waitKey(anykey00055);
		}
 		function anykey00053() 
		{
 		ACCpicture(10);
 		ACCwrite(210);
 		ACCanykey();
 		waitKey(anykey00054);
		}
 		function anykey00052() 
		{
 		ACCpicture(13);
 		ACCwrite(209);
 		ACCanykey();
 		waitKey(anykey00053);
		}
 		function anykey00051() 
		{
 		ACCcls();
 		ACCpicture(25);
 		ACCwrite(208);
 		ACCanykey();
 		waitKey(anykey00052);
		}
 		function anykey00050() 
		{
 		ACCcls();
 		ACCwrite(206);
 		ACCwrite(207);
 		ACCanykey();
 		waitKey(anykey00051);
		}
 		function anykey00049() 
		{
 		ACCcls();
 		ACCpicture(23);
 		ACCwrite(203);
 		ACCwrite(204);
 		ACCwrite(205);
 		ACCanykey();
 		waitKey(anykey00050);
		}
 		function anykey00048() 
		{
 		ACCwrite(202);
 		ACCanykey();
 		waitKey(anykey00049);
		}
 		function anykey00047() 
		{
 		ACCcls();
 		ACCwrite(201);
 		ACCanykey();
 		waitKey(anykey00048);
		}
 		function anykey00046() 
		{
 		ACCwrite(200);
 		ACCanykey();
 		waitKey(anykey00047);
		}
 		function anykey00045() 
		{
 		ACCcls();
 		ACCwrite(199);
 		ACCanykey();
 		waitKey(anykey00046);
		}
 		function anykey00044() 
		{
 		ACCcls();
 		ACCwrite(198);
 		ACCanykey();
 		waitKey(anykey00045);
		}
 		function anykey00043() 
		{
 		ACCwrite(196);
 		ACCwrite(197);
 		ACCanykey();
 		waitKey(anykey00044);
		}
 		waitKey(anykey00043);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// DEJA CD
	p000e0202:
	{
 		if (skipdoall('p000e0202')) break p000e0202;
 		if (in_response)
		{
			if (!CNDverb(51)) break p000e0202;
			if (!CNDnoun1(156)) break p000e0202;
 		}
		if (!CNDnotzero(123)) break p000e0202;
 		ACCwrite(214);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// EMPUJA CUADRO
	p000e0203:
	{
 		if (skipdoall('p000e0203')) break p000e0203;
 		if (in_response)
		{
			if (!CNDverb(36)) break p000e0203;
			if (!CNDnoun1(213)) break p000e0203;
 		}
		if (!CNDat(30)) break p000e0203;
		if (!CNDnotzero(122)) break p000e0203;
 		ACCwrite(215);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// APARTA CUADRO
	p000e0204:
	{
 		if (skipdoall('p000e0204')) break p000e0204;
 		if (in_response)
		{
			if (!CNDverb(99)) break p000e0204;
			if (!CNDnoun1(213)) break p000e0204;
 		}
		if (!CNDat(30)) break p000e0204;
		if (!CNDnotzero(122)) break p000e0204;
 		ACCwrite(216);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DESCOLGAR CUADRO
	p000e0205:
	{
 		if (skipdoall('p000e0205')) break p000e0205;
 		if (in_response)
		{
			if (!CNDverb(100)) break p000e0205;
			if (!CNDnoun1(213)) break p000e0205;
 		}
		if (!CNDat(30)) break p000e0205;
		if (!CNDnotzero(122)) break p000e0205;
 		ACCwrite(217);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// EMPUJA CUADRO
	p000e0206:
	{
 		if (skipdoall('p000e0206')) break p000e0206;
 		if (in_response)
		{
			if (!CNDverb(36)) break p000e0206;
			if (!CNDnoun1(213)) break p000e0206;
 		}
		if (!CNDat(30)) break p000e0206;
		if (!CNDnotzero(121)) break p000e0206;
		if (!CNDzero(122)) break p000e0206;
 		ACCwrite(218);
 		ACCset(122);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// APARTA CUADRO
	p000e0207:
	{
 		if (skipdoall('p000e0207')) break p000e0207;
 		if (in_response)
		{
			if (!CNDverb(99)) break p000e0207;
			if (!CNDnoun1(213)) break p000e0207;
 		}
		if (!CNDat(30)) break p000e0207;
		if (!CNDnotzero(121)) break p000e0207;
		if (!CNDzero(122)) break p000e0207;
 		ACCwrite(219);
 		ACCset(122);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DESCOLGAR CUADRO
	p000e0208:
	{
 		if (skipdoall('p000e0208')) break p000e0208;
 		if (in_response)
		{
			if (!CNDverb(100)) break p000e0208;
			if (!CNDnoun1(213)) break p000e0208;
 		}
		if (!CNDat(30)) break p000e0208;
		if (!CNDnotzero(121)) break p000e0208;
		if (!CNDzero(122)) break p000e0208;
 		ACCwrite(220);
 		ACCset(122);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// EMPUJA CUADRO
	p000e0209:
	{
 		if (skipdoall('p000e0209')) break p000e0209;
 		if (in_response)
		{
			if (!CNDverb(36)) break p000e0209;
			if (!CNDnoun1(213)) break p000e0209;
 		}
		if (!CNDat(30)) break p000e0209;
		if (!CNDzero(121)) break p000e0209;
 		ACCwrite(221);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// APARTA CUADRO
	p000e0210:
	{
 		if (skipdoall('p000e0210')) break p000e0210;
 		if (in_response)
		{
			if (!CNDverb(99)) break p000e0210;
			if (!CNDnoun1(213)) break p000e0210;
 		}
		if (!CNDat(30)) break p000e0210;
		if (!CNDzero(121)) break p000e0210;
 		ACCwrite(222);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DESCOLGAR CUADRO
	p000e0211:
	{
 		if (skipdoall('p000e0211')) break p000e0211;
 		if (in_response)
		{
			if (!CNDverb(100)) break p000e0211;
			if (!CNDnoun1(213)) break p000e0211;
 		}
		if (!CNDat(30)) break p000e0211;
		if (!CNDzero(121)) break p000e0211;
 		ACCwrite(223);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DEJA _
	p000e0212:
	{
 		if (skipdoall('p000e0212')) break p000e0212;
 		if (in_response)
		{
			if (!CNDverb(51)) break p000e0212;
 		}
		if (!CNDat(30)) break p000e0212;
		if (!CNDzero(121)) break p000e0212;
 		ACCwrite(224);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE _
	p000e0213:
	{
 		if (skipdoall('p000e0213')) break p000e0213;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0213;
 		}
		if (!CNDat(30)) break p000e0213;
		if (!CNDzero(121)) break p000e0213;
 		ACCwrite(225);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE CUADRO
	p000e0214:
	{
 		if (skipdoall('p000e0214')) break p000e0214;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0214;
			if (!CNDnoun1(213)) break p000e0214;
 		}
		if (!CNDat(30)) break p000e0214;
		if (!CNDnotzero(121)) break p000e0214;
 		ACCwrite(226);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENCENDER COMPUTADOR
	p000e0215:
	{
 		if (skipdoall('p000e0215')) break p000e0215;
 		if (in_response)
		{
			if (!CNDverb(44)) break p000e0215;
			if (!CNDnoun1(224)) break p000e0215;
 		}
		if (!CNDat(30)) break p000e0215;
		if (!CNDzero(121)) break p000e0215;
 		ACCwrite(227);
 		ACCdone();
		break pro000_restart;
		{}

	}

	//  _
	p000e0216:
	{
 		if (skipdoall('p000e0216')) break p000e0216;
 		if (in_response)
		{
			if (!CNDverb(4)) break p000e0216;
 		}
		if (!CNDat(30)) break p000e0216;
		if (!CNDzero(121)) break p000e0216;
 		ACCwrite(228);
 		ACCdone();
		break pro000_restart;
		{}

	}

	//  _
	p000e0217:
	{
 		if (skipdoall('p000e0217')) break p000e0217;
 		if (in_response)
		{
			if (!CNDverb(4)) break p000e0217;
 		}
		if (!CNDat(30)) break p000e0217;
		if (!CNDnotzero(121)) break p000e0217;
 		ACCgoto(31);
 		ACCdesc();
		break pro000_restart;
		{}

	}

	// ENCENDER COMPUTADOR
	p000e0218:
	{
 		if (skipdoall('p000e0218')) break p000e0218;
 		if (in_response)
		{
			if (!CNDverb(44)) break p000e0218;
			if (!CNDnoun1(224)) break p000e0218;
 		}
		if (!CNDat(30)) break p000e0218;
		if (!CNDnotzero(121)) break p000e0218;
 		ACCwrite(229);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE COMPUTADOR
	p000e0219:
	{
 		if (skipdoall('p000e0219')) break p000e0219;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0219;
			if (!CNDnoun1(224)) break p000e0219;
 		}
		if (!CNDat(30)) break p000e0219;
		if (!CNDnotzero(121)) break p000e0219;
 		ACCwrite(230);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LLAMA TELEFONO
	p000e0220:
	{
 		if (skipdoall('p000e0220')) break p000e0220;
 		if (in_response)
		{
			if (!CNDverb(79)) break p000e0220;
			if (!CNDnoun1(211)) break p000e0220;
 		}
		if (!CNDat(30)) break p000e0220;
		if (!CNDzero(121)) break p000e0220;
 		ACCwrite(231);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LLAMA TELEFONO
	p000e0221:
	{
 		if (skipdoall('p000e0221')) break p000e0221;
 		if (in_response)
		{
			if (!CNDverb(79)) break p000e0221;
			if (!CNDnoun1(211)) break p000e0221;
 		}
		if (!CNDat(30)) break p000e0221;
		if (!CNDnotzero(121)) break p000e0221;
 		ACCwrite(232);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE TELEFONO
	p000e0222:
	{
 		if (skipdoall('p000e0222')) break p000e0222;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0222;
			if (!CNDnoun1(211)) break p000e0222;
 		}
		if (!CNDat(30)) break p000e0222;
		if (!CNDnotzero(121)) break p000e0222;
 		ACCwrite(233);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE PAPELES
	p000e0223:
	{
 		if (skipdoall('p000e0223')) break p000e0223;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0223;
			if (!CNDnoun1(212)) break p000e0223;
 		}
		if (!CNDat(30)) break p000e0223;
 		ACCwrite(234);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LEE PAPELES
	p000e0224:
	{
 		if (skipdoall('p000e0224')) break p000e0224;
 		if (in_response)
		{
			if (!CNDverb(32)) break p000e0224;
			if (!CNDnoun1(212)) break p000e0224;
 		}
		if (!CNDat(30)) break p000e0224;
 		ACCwrite(235);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE LIBROS
	p000e0225:
	{
 		if (skipdoall('p000e0225')) break p000e0225;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0225;
			if (!CNDnoun1(54)) break p000e0225;
 		}
		if (!CNDat(30)) break p000e0225;
 		ACCwrite(236);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LEE LIBROS
	p000e0226:
	{
 		if (skipdoall('p000e0226')) break p000e0226;
 		if (in_response)
		{
			if (!CNDverb(32)) break p000e0226;
			if (!CNDnoun1(54)) break p000e0226;
 		}
		if (!CNDat(30)) break p000e0226;
 		ACCwrite(237);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// EMPUJA MESA
	p000e0227:
	{
 		if (skipdoall('p000e0227')) break p000e0227;
 		if (in_response)
		{
			if (!CNDverb(36)) break p000e0227;
			if (!CNDnoun1(208)) break p000e0227;
 		}
		if (!CNDat(30)) break p000e0227;
 		ACCwrite(238);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// GOLPEA BECKHAM
	p000e0228:
	{
 		if (skipdoall('p000e0228')) break p000e0228;
 		if (in_response)
		{
			if (!CNDverb(63)) break p000e0228;
			if (!CNDnoun1(25)) break p000e0228;
 		}
		if (!CNDnoun2(205)) break p000e0228;
		if (!CNDnotcarr(29)) break p000e0228;
		if (!CNDat(30)) break p000e0228;
		if (!CNDzero(121)) break p000e0228;
 		ACCwrite(239);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// GOLPEA BECKHAM
	p000e0229:
	{
 		if (skipdoall('p000e0229')) break p000e0229;
 		if (in_response)
		{
			if (!CNDverb(63)) break p000e0229;
			if (!CNDnoun1(25)) break p000e0229;
 		}
		if (!CNDnoun2(205)) break p000e0229;
		if (!CNDcarried(29)) break p000e0229;
		if (!CNDat(30)) break p000e0229;
		if (!CNDzero(121)) break p000e0229;
 		ACCwrite(240);
 		ACCanykey();
 		function anykey00058() 
		{
 		ACCwrite(243);
 		ACCset(121);
 		ACCdone();
		return;
		}
 		function anykey00057() 
		{
 		ACCwrite(242);
 		ACCanykey();
 		waitKey(anykey00058);
		}
 		function anykey00056() 
		{
 		ACCwrite(241);
 		ACCanykey();
 		waitKey(anykey00057);
		}
 		waitKey(anykey00056);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// GOLPEA BECKHAM
	p000e0230:
	{
 		if (skipdoall('p000e0230')) break p000e0230;
 		if (in_response)
		{
			if (!CNDverb(63)) break p000e0230;
			if (!CNDnoun1(25)) break p000e0230;
 		}
		if (!CNDat(30)) break p000e0230;
		if (!CNDzero(121)) break p000e0230;
 		ACCwrite(244);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// GOLPEA BECKHAM
	p000e0231:
	{
 		if (skipdoall('p000e0231')) break p000e0231;
 		if (in_response)
		{
			if (!CNDverb(63)) break p000e0231;
			if (!CNDnoun1(25)) break p000e0231;
 		}
		if (!CNDat(30)) break p000e0231;
		if (!CNDnotzero(121)) break p000e0231;
 		ACCwrite(245);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DESPERTAR BECKHAM
	p000e0232:
	{
 		if (skipdoall('p000e0232')) break p000e0232;
 		if (in_response)
		{
			if (!CNDverb(83)) break p000e0232;
			if (!CNDnoun1(25)) break p000e0232;
 		}
		if (!CNDat(30)) break p000e0232;
		if (!CNDnotzero(121)) break p000e0232;
 		ACCwrite(246);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// EMPUJA BECKHAM
	p000e0233:
	{
 		if (skipdoall('p000e0233')) break p000e0233;
 		if (in_response)
		{
			if (!CNDverb(36)) break p000e0233;
			if (!CNDnoun1(25)) break p000e0233;
 		}
		if (!CNDat(30)) break p000e0233;
		if (!CNDnotzero(121)) break p000e0233;
 		ACCwrite(247);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// REGISTRA BECKHAM
	p000e0234:
	{
 		if (skipdoall('p000e0234')) break p000e0234;
 		if (in_response)
		{
			if (!CNDverb(97)) break p000e0234;
			if (!CNDnoun1(25)) break p000e0234;
 		}
		if (!CNDat(30)) break p000e0234;
		if (!CNDnotzero(121)) break p000e0234;
 		ACCwrite(248);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// EMPUJA BECKHAM
	p000e0235:
	{
 		if (skipdoall('p000e0235')) break p000e0235;
 		if (in_response)
		{
			if (!CNDverb(36)) break p000e0235;
			if (!CNDnoun1(25)) break p000e0235;
 		}
		if (!CNDat(30)) break p000e0235;
		if (!CNDzero(121)) break p000e0235;
 		ACCwrite(249);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DECIR BECKHAM
	p000e0236:
	{
 		if (skipdoall('p000e0236')) break p000e0236;
 		if (in_response)
		{
			if (!CNDverb(31)) break p000e0236;
			if (!CNDnoun1(25)) break p000e0236;
 		}
		if (!CNDat(30)) break p000e0236;
		if (!CNDzero(121)) break p000e0236;
 		ACCwrite(250);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DECIR BECKHAM
	p000e0237:
	{
 		if (skipdoall('p000e0237')) break p000e0237;
 		if (in_response)
		{
			if (!CNDverb(31)) break p000e0237;
			if (!CNDnoun1(25)) break p000e0237;
 		}
		if (!CNDat(30)) break p000e0237;
		if (!CNDnotzero(121)) break p000e0237;
 		ACCwrite(251);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ATACA BECKHAM
	p000e0238:
	{
 		if (skipdoall('p000e0238')) break p000e0238;
 		if (in_response)
		{
			if (!CNDverb(98)) break p000e0238;
			if (!CNDnoun1(25)) break p000e0238;
 		}
		if (!CNDat(30)) break p000e0238;
		if (!CNDzero(121)) break p000e0238;
 		ACCwrite(252);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ATACA BECKHAM
	p000e0239:
	{
 		if (skipdoall('p000e0239')) break p000e0239;
 		if (in_response)
		{
			if (!CNDverb(98)) break p000e0239;
			if (!CNDnoun1(25)) break p000e0239;
 		}
		if (!CNDat(30)) break p000e0239;
		if (!CNDnotzero(121)) break p000e0239;
 		ACCwrite(253);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// MATA BECKHAM
	p000e0240:
	{
 		if (skipdoall('p000e0240')) break p000e0240;
 		if (in_response)
		{
			if (!CNDverb(77)) break p000e0240;
			if (!CNDnoun1(25)) break p000e0240;
 		}
		if (!CNDat(30)) break p000e0240;
 		ACCwrite(254);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ATACA BECKHAM
	p000e0241:
	{
 		if (skipdoall('p000e0241')) break p000e0241;
 		if (in_response)
		{
			if (!CNDverb(98)) break p000e0241;
			if (!CNDnoun1(25)) break p000e0241;
 		}
		if (!CNDat(32)) break p000e0241;
		if (!CNDzero(117)) break p000e0241;
 		ACCwrite(255);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ATACA BECKHAM
	p000e0242:
	{
 		if (skipdoall('p000e0242')) break p000e0242;
 		if (in_response)
		{
			if (!CNDverb(98)) break p000e0242;
			if (!CNDnoun1(25)) break p000e0242;
 		}
		if (!CNDat(32)) break p000e0242;
		if (!CNDnotzero(117)) break p000e0242;
 		ACCwrite(256);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// MATA BECKHAM
	p000e0243:
	{
 		if (skipdoall('p000e0243')) break p000e0243;
 		if (in_response)
		{
			if (!CNDverb(77)) break p000e0243;
			if (!CNDnoun1(25)) break p000e0243;
 		}
		if (!CNDat(32)) break p000e0243;
 		ACCwrite(257);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DECIR COCINERO
	p000e0244:
	{
 		if (skipdoall('p000e0244')) break p000e0244;
 		if (in_response)
		{
			if (!CNDverb(31)) break p000e0244;
			if (!CNDnoun1(24)) break p000e0244;
 		}
		if (!CNDat(33)) break p000e0244;
 		ACCwrite(258);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// GOLPEA COCINERO
	p000e0245:
	{
 		if (skipdoall('p000e0245')) break p000e0245;
 		if (in_response)
		{
			if (!CNDverb(63)) break p000e0245;
			if (!CNDnoun1(24)) break p000e0245;
 		}
		if (!CNDat(33)) break p000e0245;
 		ACCwrite(259);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// EMPUJA COCINERO
	p000e0246:
	{
 		if (skipdoall('p000e0246')) break p000e0246;
 		if (in_response)
		{
			if (!CNDverb(36)) break p000e0246;
			if (!CNDnoun1(24)) break p000e0246;
 		}
		if (!CNDat(33)) break p000e0246;
 		ACCwrite(260);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ATACA COCINERO
	p000e0247:
	{
 		if (skipdoall('p000e0247')) break p000e0247;
 		if (in_response)
		{
			if (!CNDverb(98)) break p000e0247;
			if (!CNDnoun1(24)) break p000e0247;
 		}
		if (!CNDat(33)) break p000e0247;
 		ACCwrite(261);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// MATA COCINERO
	p000e0248:
	{
 		if (skipdoall('p000e0248')) break p000e0248;
 		if (in_response)
		{
			if (!CNDverb(77)) break p000e0248;
			if (!CNDnoun1(24)) break p000e0248;
 		}
		if (!CNDat(33)) break p000e0248;
 		ACCwrite(262);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LANZA _
	p000e0249:
	{
 		if (skipdoall('p000e0249')) break p000e0249;
 		if (in_response)
		{
			if (!CNDverb(76)) break p000e0249;
 		}
		if (!CNDnoun2(24)) break p000e0249;
		if (!CNDat(33)) break p000e0249;
 		ACCwrite(263);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE TRAMPILLA
	p000e0250:
	{
 		if (skipdoall('p000e0250')) break p000e0250;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0250;
			if (!CNDnoun1(170)) break p000e0250;
 		}
		if (!CNDat(42)) break p000e0250;
 		ACCwrite(264);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE PUERTA
	p000e0251:
	{
 		if (skipdoall('p000e0251')) break p000e0251;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0251;
			if (!CNDnoun1(69)) break p000e0251;
 		}
		if (!CNDat(42)) break p000e0251;
 		ACCwrite(265);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// BAJA _
	p000e0252:
	{
 		if (skipdoall('p000e0252')) break p000e0252;
 		if (in_response)
		{
			if (!CNDverb(11)) break p000e0252;
 		}
		if (!CNDat(42)) break p000e0252;
 		ACCgoto(37);
 		ACCdesc();
		break pro000_restart;
		{}

	}

	// SUBE _
	p000e0253:
	{
 		if (skipdoall('p000e0253')) break p000e0253;
 		if (in_response)
		{
			if (!CNDverb(10)) break p000e0253;
 		}
		if (!CNDat(37)) break p000e0253;
		if (!CNDnotzero(113)) break p000e0253;
 		ACCwrite(266);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SUBE _
	p000e0254:
	{
 		if (skipdoall('p000e0254')) break p000e0254;
 		if (in_response)
		{
			if (!CNDverb(10)) break p000e0254;
 		}
		if (!CNDat(37)) break p000e0254;
		if (!CNDzero(113)) break p000e0254;
 		ACCgoto(42);
 		ACCdesc();
		break pro000_restart;
		{}

	}

	// TOCA HORNO
	p000e0255:
	{
 		if (skipdoall('p000e0255')) break p000e0255;
 		if (in_response)
		{
			if (!CNDverb(80)) break p000e0255;
			if (!CNDnoun1(207)) break p000e0255;
 		}
		if (!CNDat(33)) break p000e0255;
 		ACCwrite(267);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE GUISO
	p000e0256:
	{
 		if (skipdoall('p000e0256')) break p000e0256;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0256;
			if (!CNDnoun1(206)) break p000e0256;
 		}
		if (!CNDat(33)) break p000e0256;
 		ACCwrite(268);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE HERRAMIENT
	p000e0257:
	{
 		if (skipdoall('p000e0257')) break p000e0257;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0257;
			if (!CNDnoun1(152)) break p000e0257;
 		}
		if (!CNDat(33)) break p000e0257;
 		ACCwrite(269);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// EMPUJA HORNO
	p000e0258:
	{
 		if (skipdoall('p000e0258')) break p000e0258;
 		if (in_response)
		{
			if (!CNDverb(36)) break p000e0258;
			if (!CNDnoun1(207)) break p000e0258;
 		}
		if (!CNDat(33)) break p000e0258;
 		ACCwrite(270);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE HORNO
	p000e0259:
	{
 		if (skipdoall('p000e0259')) break p000e0259;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0259;
			if (!CNDnoun1(207)) break p000e0259;
 		}
		if (!CNDat(33)) break p000e0259;
 		ACCwrite(271);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR HORNO
	p000e0260:
	{
 		if (skipdoall('p000e0260')) break p000e0260;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0260;
			if (!CNDnoun1(207)) break p000e0260;
 		}
		if (!CNDat(33)) break p000e0260;
 		ACCwrite(272);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE SARTEN
	p000e0261:
	{
 		if (skipdoall('p000e0261')) break p000e0261;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0261;
			if (!CNDnoun1(205)) break p000e0261;
 		}
		if (!CNDzero(120)) break p000e0261;
		if (!CNDat(33)) break p000e0261;
		if (!CNDzero(119)) break p000e0261;
 		ACCwrite(273);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE SARTEN
	p000e0262:
	{
 		if (skipdoall('p000e0262')) break p000e0262;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0262;
			if (!CNDnoun1(205)) break p000e0262;
 		}
		if (!CNDzero(120)) break p000e0262;
		if (!CNDat(33)) break p000e0262;
		if (!CNDnotzero(119)) break p000e0262;
 		ACCwrite(274);
 		ACCplace(29,254);
 		ACCset(120);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA AGOSTINE
	p000e0263:
	{
 		if (skipdoall('p000e0263')) break p000e0263;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0263;
			if (!CNDnoun1(26)) break p000e0263;
 		}
		if (!CNDnoun2(89)) break p000e0263;
		if (!CNDnotzero(113)) break p000e0263;
		if (!CNDat(37)) break p000e0263;
 		ACCwrite(275);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENTRA CAJA
	p000e0264:
	{
 		if (skipdoall('p000e0264')) break p000e0264;
 		if (in_response)
		{
			if (!CNDverb(50)) break p000e0264;
			if (!CNDnoun1(89)) break p000e0264;
 		}
		if (!CNDat(37)) break p000e0264;
		if (!CNDnotzero(113)) break p000e0264;
 		ACCwrite(276);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DECIR AGOSTINE
	p000e0265:
	{
 		if (skipdoall('p000e0265')) break p000e0265;
 		if (in_response)
		{
			if (!CNDverb(31)) break p000e0265;
			if (!CNDnoun1(26)) break p000e0265;
 		}
		if (!CNDnotzero(109)) break p000e0265;
		if (!CNDeq(118,getFlag(38))) break p000e0265;
 		ACCwrite(277);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DESPERTAR AGOSTINE
	p000e0266:
	{
 		if (skipdoall('p000e0266')) break p000e0266;
 		if (in_response)
		{
			if (!CNDverb(83)) break p000e0266;
			if (!CNDnoun1(26)) break p000e0266;
 		}
		if (!CNDnotzero(109)) break p000e0266;
		if (!CNDeq(118,getFlag(38))) break p000e0266;
 		ACCwrite(278);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CARGA AGOSTINE
	p000e0267:
	{
 		if (skipdoall('p000e0267')) break p000e0267;
 		if (in_response)
		{
			if (!CNDverb(27)) break p000e0267;
			if (!CNDnoun1(26)) break p000e0267;
 		}
		if (!CNDat(32)) break p000e0267;
		if (!CNDzero(109)) break p000e0267;
 		ACCwrite(279);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE AGOSTINE
	p000e0268:
	{
 		if (skipdoall('p000e0268')) break p000e0268;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0268;
			if (!CNDnoun1(26)) break p000e0268;
 		}
		if (!CNDat(32)) break p000e0268;
		if (!CNDzero(109)) break p000e0268;
 		ACCwrite(280);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE JARRA
	p000e0269:
	{
 		if (skipdoall('p000e0269')) break p000e0269;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0269;
			if (!CNDnoun1(204)) break p000e0269;
 		}
		if (!CNDat(32)) break p000e0269;
		if (!CNDzero(117)) break p000e0269;
 		ACCwrite(281);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// EMPUJA JARRA
	p000e0270:
	{
 		if (skipdoall('p000e0270')) break p000e0270;
 		if (in_response)
		{
			if (!CNDverb(36)) break p000e0270;
			if (!CNDnoun1(204)) break p000e0270;
 		}
		if (!CNDat(32)) break p000e0270;
		if (!CNDzero(117)) break p000e0270;
 		ACCwrite(282);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// EMPUJA BECKHAM
	p000e0271:
	{
 		if (skipdoall('p000e0271')) break p000e0271;
 		if (in_response)
		{
			if (!CNDverb(36)) break p000e0271;
			if (!CNDnoun1(25)) break p000e0271;
 		}
		if (!CNDat(32)) break p000e0271;
		if (!CNDzero(117)) break p000e0271;
 		ACCwrite(283);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// EMPUJA BECKHAM
	p000e0272:
	{
 		if (skipdoall('p000e0272')) break p000e0272;
 		if (in_response)
		{
			if (!CNDverb(36)) break p000e0272;
			if (!CNDnoun1(25)) break p000e0272;
 		}
		if (!CNDat(32)) break p000e0272;
		if (!CNDnotzero(117)) break p000e0272;
 		ACCwrite(284);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DEJA AGOSTINE
	p000e0273:
	{
 		if (skipdoall('p000e0273')) break p000e0273;
 		if (in_response)
		{
			if (!CNDverb(51)) break p000e0273;
			if (!CNDnoun1(26)) break p000e0273;
 		}
		if (!CNDzero(113)) break p000e0273;
 		ACCwrite(285);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DEJA AGOSTINE
	p000e0274:
	{
 		if (skipdoall('p000e0274')) break p000e0274;
 		if (in_response)
		{
			if (!CNDverb(51)) break p000e0274;
			if (!CNDnoun1(26)) break p000e0274;
 		}
		if (!CNDnotzero(113)) break p000e0274;
 		ACCwrite(286);
 		ACCclear(113);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE AGOSTINE
	p000e0275:
	{
 		if (skipdoall('p000e0275')) break p000e0275;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0275;
			if (!CNDnoun1(26)) break p000e0275;
 		}
 		ACClet(33,27);
		{}

	}

	// CARGA AGOSTINE
	p000e0276:
	{
 		if (skipdoall('p000e0276')) break p000e0276;
 		if (in_response)
		{
			if (!CNDverb(27)) break p000e0276;
			if (!CNDnoun1(26)) break p000e0276;
 		}
		if (!CNDeq(118,getFlag(38))) break p000e0276;
		if (!CNDnotzero(113)) break p000e0276;
 		ACCwrite(287);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CARGA AGOSTINE
	p000e0277:
	{
 		if (skipdoall('p000e0277')) break p000e0277;
 		if (in_response)
		{
			if (!CNDverb(27)) break p000e0277;
			if (!CNDnoun1(26)) break p000e0277;
 		}
		if (!CNDzero(113)) break p000e0277;
		if (!CNDnoteq(118,getFlag(38))) break p000e0277;
 		ACCwrite(288);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CARGA AGOSTINE
	p000e0278:
	{
 		if (skipdoall('p000e0278')) break p000e0278;
 		if (in_response)
		{
			if (!CNDverb(27)) break p000e0278;
			if (!CNDnoun1(26)) break p000e0278;
 		}
		if (!CNDzero(113)) break p000e0278;
		if (!CNDeq(118,getFlag(38))) break p000e0278;
 		ACCset(113);
 		ACCwrite(289);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DESPERTAR AGOSTINE
	p000e0279:
	{
 		if (skipdoall('p000e0279')) break p000e0279;
 		if (in_response)
		{
			if (!CNDverb(83)) break p000e0279;
			if (!CNDnoun1(26)) break p000e0279;
 		}
		if (!CNDnotzero(109)) break p000e0279;
		if (!CNDeq(118,getFlag(38))) break p000e0279;
 		ACCwrite(290);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DECIR AGOSTINE
	p000e0280:
	{
 		if (skipdoall('p000e0280')) break p000e0280;
 		if (in_response)
		{
			if (!CNDverb(31)) break p000e0280;
			if (!CNDnoun1(26)) break p000e0280;
 		}
		if (!CNDnotzero(119)) break p000e0280;
		if (!CNDeq(118,getFlag(38))) break p000e0280;
 		ACCwrite(291);
 		ACCwrite(292);
 		ACCwrite(293);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CORTA CUERDA
	p000e0281:
	{
 		if (skipdoall('p000e0281')) break p000e0281;
 		if (in_response)
		{
			if (!CNDverb(62)) break p000e0281;
			if (!CNDnoun1(90)) break p000e0281;
 		}
		if (!CNDat(32)) break p000e0281;
 		ACClet(33,61);
 		ACClet(34,26);
		{}

	}

	// CORTA CUERDA
	p000e0282:
	{
 		if (skipdoall('p000e0282')) break p000e0282;
 		if (in_response)
		{
			if (!CNDverb(62)) break p000e0282;
			if (!CNDnoun1(90)) break p000e0282;
 		}
		if (!CNDat(32)) break p000e0282;
		if (!CNDnoun2(91)) break p000e0282;
 		ACClet(33,61);
 		ACClet(34,26);
		{}

	}

	// DESATA AGOSTINE
	p000e0283:
	{
 		if (skipdoall('p000e0283')) break p000e0283;
 		if (in_response)
		{
			if (!CNDverb(61)) break p000e0283;
			if (!CNDnoun1(26)) break p000e0283;
 		}
		if (!CNDat(32)) break p000e0283;
		if (!CNDnotzero(117)) break p000e0283;
		if (!CNDzero(109)) break p000e0283;
 		ACCset(109);
 		ACCwrite(294);
 		ACClet(118,32);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DECIR AGOSTINE
	p000e0284:
	{
 		if (skipdoall('p000e0284')) break p000e0284;
 		if (in_response)
		{
			if (!CNDverb(31)) break p000e0284;
			if (!CNDnoun1(26)) break p000e0284;
 		}
		if (!CNDat(32)) break p000e0284;
		if (!CNDnotzero(117)) break p000e0284;
		if (!CNDzero(109)) break p000e0284;
 		ACCwrite(295);
 		ACCwrite(296);
 		ACCwrite(297);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DESPERTAR AGOSTINE
	p000e0285:
	{
 		if (skipdoall('p000e0285')) break p000e0285;
 		if (in_response)
		{
			if (!CNDverb(83)) break p000e0285;
			if (!CNDnoun1(26)) break p000e0285;
 		}
		if (!CNDat(32)) break p000e0285;
		if (!CNDnotzero(117)) break p000e0285;
		if (!CNDzero(109)) break p000e0285;
 		ACCwrite(298);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// REGISTRA BECKHAM
	p000e0286:
	{
 		if (skipdoall('p000e0286')) break p000e0286;
 		if (in_response)
		{
			if (!CNDverb(97)) break p000e0286;
			if (!CNDnoun1(25)) break p000e0286;
 		}
		if (!CNDat(32)) break p000e0286;
 		ACCwrite(299);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DESPERTAR BECKHAM
	p000e0287:
	{
 		if (skipdoall('p000e0287')) break p000e0287;
 		if (in_response)
		{
			if (!CNDverb(83)) break p000e0287;
			if (!CNDnoun1(25)) break p000e0287;
 		}
		if (!CNDat(32)) break p000e0287;
		if (!CNDnotzero(117)) break p000e0287;
 		ACCwrite(300);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGELA PANUELO
	p000e0288:
	{
 		if (skipdoall('p000e0288')) break p000e0288;
 		if (in_response)
		{
			if (!CNDverb(21)) break p000e0288;
			if (!CNDnoun1(191)) break p000e0288;
 		}
		if (!CNDnoun2(204)) break p000e0288;
		if (!CNDat(32)) break p000e0288;
		if (!CNDnotcarr(27)) break p000e0288;
 		ACCwrite(301);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGELA PANUELO
	p000e0289:
	{
 		if (skipdoall('p000e0289')) break p000e0289;
 		if (in_response)
		{
			if (!CNDverb(21)) break p000e0289;
			if (!CNDnoun1(191)) break p000e0289;
 		}
		if (!CNDnoun2(204)) break p000e0289;
		if (!CNDat(32)) break p000e0289;
		if (!CNDcarried(27)) break p000e0289;
		if (!CNDzero(117)) break p000e0289;
 		ACCwrite(302);
 		ACCanykey();
 		function anykey00067() 
		{
 		ACCwrite(311);
 		ACCdestroy(27);
 		ACCset(117);
 		ACCdone();
		return;
		}
 		function anykey00066() 
		{
 		ACCwrite(310);
 		ACCanykey();
 		waitKey(anykey00067);
		}
 		function anykey00065() 
		{
 		ACCwrite(309);
 		ACCanykey();
 		waitKey(anykey00066);
		}
 		function anykey00064() 
		{
 		ACCwrite(308);
 		ACCanykey();
 		waitKey(anykey00065);
		}
 		function anykey00063() 
		{
 		ACCwrite(307);
 		ACCanykey();
 		waitKey(anykey00064);
		}
 		function anykey00062() 
		{
 		ACCwrite(306);
 		ACCanykey();
 		waitKey(anykey00063);
		}
 		function anykey00061() 
		{
 		ACCwrite(305);
 		ACCanykey();
 		waitKey(anykey00062);
		}
 		function anykey00060() 
		{
 		ACCwrite(304);
 		ACCanykey();
 		waitKey(anykey00061);
		}
 		function anykey00059() 
		{
 		ACCwrite(303);
 		ACCanykey();
 		waitKey(anykey00060);
		}
 		waitKey(anykey00059);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// COGELA _
	p000e0290:
	{
 		if (skipdoall('p000e0290')) break p000e0290;
 		if (in_response)
		{
			if (!CNDverb(21)) break p000e0290;
 		}
		if (!CNDnoun2(204)) break p000e0290;
		if (!CNDat(32)) break p000e0290;
		if (!CNDzero(117)) break p000e0290;
 		ACCwrite(312);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA PANUELO
	p000e0291:
	{
 		if (skipdoall('p000e0291')) break p000e0291;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0291;
			if (!CNDnoun1(191)) break p000e0291;
 		}
		if (!CNDnoun2(204)) break p000e0291;
		if (!CNDat(32)) break p000e0291;
		if (!CNDnotcarr(27)) break p000e0291;
 		ACCwrite(313);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA PANUELO
	p000e0292:
	{
 		if (skipdoall('p000e0292')) break p000e0292;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0292;
			if (!CNDnoun1(191)) break p000e0292;
 		}
		if (!CNDnoun2(204)) break p000e0292;
		if (!CNDat(32)) break p000e0292;
		if (!CNDcarried(27)) break p000e0292;
		if (!CNDzero(117)) break p000e0292;
 		ACCwrite(314);
 		ACCanykey();
 		function anykey00076() 
		{
 		ACCwrite(323);
 		ACCdestroy(27);
 		ACCset(117);
 		ACCdone();
		return;
		}
 		function anykey00075() 
		{
 		ACCwrite(322);
 		ACCanykey();
 		waitKey(anykey00076);
		}
 		function anykey00074() 
		{
 		ACCwrite(321);
 		ACCanykey();
 		waitKey(anykey00075);
		}
 		function anykey00073() 
		{
 		ACCwrite(320);
 		ACCanykey();
 		waitKey(anykey00074);
		}
 		function anykey00072() 
		{
 		ACCwrite(319);
 		ACCanykey();
 		waitKey(anykey00073);
		}
 		function anykey00071() 
		{
 		ACCwrite(318);
 		ACCanykey();
 		waitKey(anykey00072);
		}
 		function anykey00070() 
		{
 		ACCwrite(317);
 		ACCanykey();
 		waitKey(anykey00071);
		}
 		function anykey00069() 
		{
 		ACCwrite(316);
 		ACCanykey();
 		waitKey(anykey00070);
		}
 		function anykey00068() 
		{
 		ACCwrite(315);
 		ACCanykey();
 		waitKey(anykey00069);
		}
 		waitKey(anykey00068);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// COLOCA _
	p000e0293:
	{
 		if (skipdoall('p000e0293')) break p000e0293;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0293;
 		}
		if (!CNDnoun2(204)) break p000e0293;
		if (!CNDat(32)) break p000e0293;
		if (!CNDzero(117)) break p000e0293;
 		ACCwrite(324);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENTRA BIBLIOTECA
	p000e0294:
	{
 		if (skipdoall('p000e0294')) break p000e0294;
 		if (in_response)
		{
			if (!CNDverb(50)) break p000e0294;
			if (!CNDnoun1(199)) break p000e0294;
 		}
		if (!CNDat(32)) break p000e0294;
 		ACCwrite(325);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// GOLPEA BECKHAM
	p000e0295:
	{
 		if (skipdoall('p000e0295')) break p000e0295;
 		if (in_response)
		{
			if (!CNDverb(63)) break p000e0295;
			if (!CNDnoun1(25)) break p000e0295;
 		}
		if (!CNDat(32)) break p000e0295;
		if (!CNDzero(117)) break p000e0295;
 		ACCwrite(326);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// GOLPEA BECKHAM
	p000e0296:
	{
 		if (skipdoall('p000e0296')) break p000e0296;
 		if (in_response)
		{
			if (!CNDverb(63)) break p000e0296;
			if (!CNDnoun1(25)) break p000e0296;
 		}
		if (!CNDat(32)) break p000e0296;
		if (!CNDnotzero(117)) break p000e0296;
 		ACCwrite(327);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DECIR BECKHAM
	p000e0297:
	{
 		if (skipdoall('p000e0297')) break p000e0297;
 		if (in_response)
		{
			if (!CNDverb(31)) break p000e0297;
			if (!CNDnoun1(25)) break p000e0297;
 		}
		if (!CNDat(32)) break p000e0297;
		if (!CNDzero(117)) break p000e0297;
 		ACCwrite(328);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DECIR BECKHAM
	p000e0298:
	{
 		if (skipdoall('p000e0298')) break p000e0298;
 		if (in_response)
		{
			if (!CNDverb(31)) break p000e0298;
			if (!CNDnoun1(25)) break p000e0298;
 		}
		if (!CNDat(32)) break p000e0298;
		if (!CNDnotzero(117)) break p000e0298;
 		ACCwrite(329);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DESPERTAR AGOSTINE
	p000e0299:
	{
 		if (skipdoall('p000e0299')) break p000e0299;
 		if (in_response)
		{
			if (!CNDverb(83)) break p000e0299;
			if (!CNDnoun1(26)) break p000e0299;
 		}
		if (!CNDat(32)) break p000e0299;
		if (!CNDzero(117)) break p000e0299;
 		ACCwrite(330);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DESATA AGOSTINE
	p000e0300:
	{
 		if (skipdoall('p000e0300')) break p000e0300;
 		if (in_response)
		{
			if (!CNDverb(61)) break p000e0300;
			if (!CNDnoun1(26)) break p000e0300;
 		}
		if (!CNDat(32)) break p000e0300;
		if (!CNDzero(117)) break p000e0300;
 		ACCwrite(331);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DECIR AGOSTINE
	p000e0301:
	{
 		if (skipdoall('p000e0301')) break p000e0301;
 		if (in_response)
		{
			if (!CNDverb(31)) break p000e0301;
			if (!CNDnoun1(26)) break p000e0301;
 		}
		if (!CNDat(32)) break p000e0301;
		if (!CNDzero(117)) break p000e0301;
 		ACCwrite(332);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LANZA _
	p000e0302:
	{
 		if (skipdoall('p000e0302')) break p000e0302;
 		if (in_response)
		{
			if (!CNDverb(76)) break p000e0302;
 		}
		if (!CNDnoun2(25)) break p000e0302;
		if (!CNDat(32)) break p000e0302;
 		ACCwrite(333);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SAL _
	p000e0303:
	{
 		if (skipdoall('p000e0303')) break p000e0303;
 		if (in_response)
		{
			if (!CNDverb(49)) break p000e0303;
 		}
		if (!CNDat(37)) break p000e0303;
		if (!CNDzero(116)) break p000e0303;
 		ACCwrite(334);
 		ACCanykey();
 		function anykey00077() 
		{
 		ACCset(116);
 		ACCgoto(40);
 		ACCdesc();
		return;
		}
 		waitKey(anykey00077);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// SAL _
	p000e0304:
	{
 		if (skipdoall('p000e0304')) break p000e0304;
 		if (in_response)
		{
			if (!CNDverb(49)) break p000e0304;
 		}
		if (!CNDat(37)) break p000e0304;
		if (!CNDnotzero(116)) break p000e0304;
 		ACCgoto(40);
 		ACCdesc();
		break pro000_restart;
		{}

	}

	// ABRE PUERTA
	p000e0305:
	{
 		if (skipdoall('p000e0305')) break p000e0305;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0305;
			if (!CNDnoun1(69)) break p000e0305;
 		}
		if (!CNDat(37)) break p000e0305;
		if (!CNDzero(116)) break p000e0305;
 		ACCwrite(335);
 		ACCset(116);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE PUERTA
	p000e0306:
	{
 		if (skipdoall('p000e0306')) break p000e0306;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0306;
			if (!CNDnoun1(69)) break p000e0306;
 		}
		if (!CNDat(37)) break p000e0306;
		if (!CNDnotzero(116)) break p000e0306;
 		ACCwrite(336);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR PUERTA
	p000e0307:
	{
 		if (skipdoall('p000e0307')) break p000e0307;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0307;
			if (!CNDnoun1(69)) break p000e0307;
 		}
		if (!CNDat(37)) break p000e0307;
		if (!CNDzero(116)) break p000e0307;
 		ACCwrite(337);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR PUERTA
	p000e0308:
	{
 		if (skipdoall('p000e0308')) break p000e0308;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0308;
			if (!CNDnoun1(69)) break p000e0308;
 		}
		if (!CNDat(37)) break p000e0308;
		if (!CNDnotzero(116)) break p000e0308;
 		ACCwrite(338);
 		ACCclear(116);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE CAJA
	p000e0309:
	{
 		if (skipdoall('p000e0309')) break p000e0309;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0309;
			if (!CNDnoun1(89)) break p000e0309;
 		}
		if (!CNDat(37)) break p000e0309;
		if (!CNDisat(5,37)) break p000e0309;
 		ACCplace(5,254);
 		ACCwrite(339);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE CAJA
	p000e0310:
	{
 		if (skipdoall('p000e0310')) break p000e0310;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0310;
			if (!CNDnoun1(89)) break p000e0310;
 		}
		if (!CNDat(37)) break p000e0310;
 		ACCwrite(340);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LLAMA CAMPANA
	p000e0311:
	{
 		if (skipdoall('p000e0311')) break p000e0311;
 		if (in_response)
		{
			if (!CNDverb(79)) break p000e0311;
			if (!CNDnoun1(121)) break p000e0311;
 		}
		if (!CNDat(40)) break p000e0311;
		if (!CNDnotzero(116)) break p000e0311;
 		ACCwrite(341);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LLAMA CAMPANA
	p000e0312:
	{
 		if (skipdoall('p000e0312')) break p000e0312;
 		if (in_response)
		{
			if (!CNDverb(79)) break p000e0312;
			if (!CNDnoun1(121)) break p000e0312;
 		}
		if (!CNDat(40)) break p000e0312;
		if (!CNDzero(115)) break p000e0312;
 		ACClet(115,1);
 		ACClet(6,2);
 		ACCwrite(342);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LLAMA CAMPANA
	p000e0313:
	{
 		if (skipdoall('p000e0313')) break p000e0313;
 		if (in_response)
		{
			if (!CNDverb(79)) break p000e0313;
			if (!CNDnoun1(121)) break p000e0313;
 		}
		if (!CNDat(40)) break p000e0313;
		if (!CNDnotzero(115)) break p000e0313;
 		ACCwrite(343);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ASOMAR VENTANA
	p000e0314:
	{
 		if (skipdoall('p000e0314')) break p000e0314;
 		if (in_response)
		{
			if (!CNDverb(52)) break p000e0314;
			if (!CNDnoun1(70)) break p000e0314;
 		}
		if (!CNDat(40)) break p000e0314;
 		ACCwrite(344);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE ADORNO
	p000e0315:
	{
 		if (skipdoall('p000e0315')) break p000e0315;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0315;
			if (!CNDnoun1(193)) break p000e0315;
 		}
		if (!CNDat(40)) break p000e0315;
 		ACCwrite(345);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// TOCA PUERTA
	p000e0316:
	{
 		if (skipdoall('p000e0316')) break p000e0316;
 		if (in_response)
		{
			if (!CNDverb(80)) break p000e0316;
			if (!CNDnoun1(69)) break p000e0316;
 		}
		if (!CNDat(40)) break p000e0316;
 		ACCwrite(346);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LLAMA PUERTA
	p000e0317:
	{
 		if (skipdoall('p000e0317')) break p000e0317;
 		if (in_response)
		{
			if (!CNDverb(79)) break p000e0317;
			if (!CNDnoun1(69)) break p000e0317;
 		}
		if (!CNDat(40)) break p000e0317;
 		ACCwrite(347);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// EMPUJA PUERTA
	p000e0318:
	{
 		if (skipdoall('p000e0318')) break p000e0318;
 		if (in_response)
		{
			if (!CNDverb(36)) break p000e0318;
			if (!CNDnoun1(69)) break p000e0318;
 		}
		if (!CNDat(40)) break p000e0318;
 		ACCwrite(348);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE PUERTA
	p000e0319:
	{
 		if (skipdoall('p000e0319')) break p000e0319;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0319;
			if (!CNDnoun1(69)) break p000e0319;
 		}
		if (!CNDat(40)) break p000e0319;
		if (!CNDzero(116)) break p000e0319;
 		ACCwrite(349);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE PUERTA
	p000e0320:
	{
 		if (skipdoall('p000e0320')) break p000e0320;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0320;
			if (!CNDnoun1(69)) break p000e0320;
 		}
		if (!CNDat(40)) break p000e0320;
		if (!CNDnotzero(116)) break p000e0320;
 		ACCwrite(350);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR PUERTA
	p000e0321:
	{
 		if (skipdoall('p000e0321')) break p000e0321;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0321;
			if (!CNDnoun1(69)) break p000e0321;
 		}
		if (!CNDat(40)) break p000e0321;
		if (!CNDzero(116)) break p000e0321;
 		ACCwrite(351);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR PUERTA
	p000e0322:
	{
 		if (skipdoall('p000e0322')) break p000e0322;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0322;
			if (!CNDnoun1(69)) break p000e0322;
 		}
		if (!CNDat(40)) break p000e0322;
		if (!CNDnotzero(116)) break p000e0322;
 		ACCwrite(352);
 		ACCclear(116);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE VENTANAS
	p000e0323:
	{
 		if (skipdoall('p000e0323')) break p000e0323;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0323;
			if (!CNDnoun1(183)) break p000e0323;
 		}
		if (!CNDat(40)) break p000e0323;
 		ACCwrite(353);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE VENTANAS
	p000e0324:
	{
 		if (skipdoall('p000e0324')) break p000e0324;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0324;
			if (!CNDnoun1(183)) break p000e0324;
 		}
		if (!CNDat(40)) break p000e0324;
 		ACCwrite(354);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// BOTA VALLA
	p000e0325:
	{
 		if (skipdoall('p000e0325')) break p000e0325;
 		if (in_response)
		{
			if (!CNDverb(53)) break p000e0325;
			if (!CNDnoun1(145)) break p000e0325;
 		}
		if (!CNDat(41)) break p000e0325;
 		ACCwrite(355);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ESCRIBE _
	p000e0326:
	{
 		if (skipdoall('p000e0326')) break p000e0326;
 		if (in_response)
		{
			if (!CNDverb(89)) break p000e0326;
 		}
		if (!CNDnoun2(89)) break p000e0326;
		if (!CNDzero(112)) break p000e0326;
 		ACCwrite(356);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ESCRIBE DESTINATAR
	p000e0327:
	{
 		if (skipdoall('p000e0327')) break p000e0327;
 		if (in_response)
		{
			if (!CNDverb(89)) break p000e0327;
			if (!CNDnoun1(192)) break p000e0327;
 		}
		if (!CNDnoun2(89)) break p000e0327;
		if (!CNDnotzero(112)) break p000e0327;
		if (!CNDabsent(26)) break p000e0327;
 		ACCwrite(357);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ESCRIBE DESTINATAR
	p000e0328:
	{
 		if (skipdoall('p000e0328')) break p000e0328;
 		if (in_response)
		{
			if (!CNDverb(89)) break p000e0328;
			if (!CNDnoun1(192)) break p000e0328;
 		}
		if (!CNDnoun2(89)) break p000e0328;
		if (!CNDnotzero(112)) break p000e0328;
		if (!CNDpresent(26)) break p000e0328;
		if (!CNDnotcarr(25)) break p000e0328;
 		ACCwrite(358);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ESCRIBE DESTINATAR
	p000e0329:
	{
 		if (skipdoall('p000e0329')) break p000e0329;
 		if (in_response)
		{
			if (!CNDverb(89)) break p000e0329;
			if (!CNDnoun1(192)) break p000e0329;
 		}
		if (!CNDnoun2(89)) break p000e0329;
		if (!CNDnotzero(114)) break p000e0329;
 		ACCwrite(359);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ESCRIBE DESTINATAR
	p000e0330:
	{
 		if (skipdoall('p000e0330')) break p000e0330;
 		if (in_response)
		{
			if (!CNDverb(89)) break p000e0330;
			if (!CNDnoun1(192)) break p000e0330;
 		}
		if (!CNDnoun2(89)) break p000e0330;
		if (!CNDnotzero(112)) break p000e0330;
		if (!CNDpresent(26)) break p000e0330;
		if (!CNDcarried(25)) break p000e0330;
 		ACCwrite(360);
 		ACCset(114);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ESCRIBE DESTINATAR
	p000e0331:
	{
 		if (skipdoall('p000e0331')) break p000e0331;
 		if (in_response)
		{
			if (!CNDverb(89)) break p000e0331;
			if (!CNDnoun1(192)) break p000e0331;
 		}
		if (!CNDeq(44,255)) break p000e0331;
 		ACCwrite(361);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA _
	p000e0332:
	{
 		if (skipdoall('p000e0332')) break p000e0332;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0332;
 		}
		if (!CNDnoun2(97)) break p000e0332;
		if (!CNDat(41)) break p000e0332;
 		ACCwrite(362);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA _
	p000e0333:
	{
 		if (skipdoall('p000e0333')) break p000e0333;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0333;
 		}
		if (!CNDnoun2(97)) break p000e0333;
		if (!CNDat(41)) break p000e0333;
 		ACCwrite(363);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE BUZON
	p000e0334:
	{
 		if (skipdoall('p000e0334')) break p000e0334;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0334;
			if (!CNDnoun1(97)) break p000e0334;
 		}
		if (!CNDat(41)) break p000e0334;
 		ACCwrite(364);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE BUZON
	p000e0335:
	{
 		if (skipdoall('p000e0335')) break p000e0335;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0335;
			if (!CNDnoun1(97)) break p000e0335;
 		}
		if (!CNDat(41)) break p000e0335;
 		ACCwrite(365);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR BUZON
	p000e0336:
	{
 		if (skipdoall('p000e0336')) break p000e0336;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0336;
			if (!CNDnoun1(97)) break p000e0336;
 		}
		if (!CNDat(41)) break p000e0336;
 		ACCwrite(366);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE PUERTA
	p000e0337:
	{
 		if (skipdoall('p000e0337')) break p000e0337;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0337;
			if (!CNDnoun1(69)) break p000e0337;
 		}
		if (!CNDat(41)) break p000e0337;
 		ACCwrite(367);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR PUERTA
	p000e0338:
	{
 		if (skipdoall('p000e0338')) break p000e0338;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0338;
			if (!CNDnoun1(69)) break p000e0338;
 		}
		if (!CNDat(41)) break p000e0338;
 		ACCwrite(368);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// HUELE PANUELO
	p000e0339:
	{
 		if (skipdoall('p000e0339')) break p000e0339;
 		if (in_response)
		{
			if (!CNDverb(72)) break p000e0339;
			if (!CNDnoun1(191)) break p000e0339;
 		}
		if (!CNDpresent(27)) break p000e0339;
 		ACCwrite(369);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA _
	p000e0340:
	{
 		if (skipdoall('p000e0340')) break p000e0340;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0340;
 		}
		if (!CNDnoun2(89)) break p000e0340;
		if (!CNDat(38)) break p000e0340;
 		ACCwrite(370);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA _
	p000e0341:
	{
 		if (skipdoall('p000e0341')) break p000e0341;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0341;
 		}
		if (!CNDnoun2(89)) break p000e0341;
		if (!CNDat(38)) break p000e0341;
 		ACCwrite(371);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENTRA CAJA
	p000e0342:
	{
 		if (skipdoall('p000e0342')) break p000e0342;
 		if (in_response)
		{
			if (!CNDverb(50)) break p000e0342;
			if (!CNDnoun1(89)) break p000e0342;
 		}
		if (!CNDpresent(26)) break p000e0342;
		if (!CNDcarried(26)) break p000e0342;
 		ACCwrite(372);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENTRA CAJA
	p000e0343:
	{
 		if (skipdoall('p000e0343')) break p000e0343;
 		if (in_response)
		{
			if (!CNDverb(50)) break p000e0343;
			if (!CNDnoun1(89)) break p000e0343;
 		}
		if (!CNDpresent(26)) break p000e0343;
		if (!CNDnotcarr(26)) break p000e0343;
 		ACCcopyff(38,111);
 		ACCgoto(38);
 		ACCdesc();
		break pro000_restart;
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SAL _
	p000e0344:
	{
 		if (skipdoall('p000e0344')) break p000e0344;
 		if (in_response)
		{
			if (!CNDverb(49)) break p000e0344;
 		}
		if (!CNDat(38)) break p000e0344;
 		ACCgoto(getFlag(111));
 		ACCdesc();
		break pro000_restart;
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENTRA _
	p000e0345:
	{
 		if (skipdoall('p000e0345')) break p000e0345;
 		if (in_response)
		{
			if (!CNDverb(50)) break p000e0345;
 		}
		if (!CNDat(40)) break p000e0345;
		if (!CNDnotzero(116)) break p000e0345;
 		ACCgoto(37);
 		ACCdesc();
		break pro000_restart;
		{}

	}

	// ENTRA _
	p000e0346:
	{
 		if (skipdoall('p000e0346')) break p000e0346;
 		if (in_response)
		{
			if (!CNDverb(50)) break p000e0346;
 		}
		if (!CNDat(40)) break p000e0346;
		if (!CNDzero(116)) break p000e0346;
 		ACCwrite(373);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGELA _
	p000e0347:
	{
 		if (skipdoall('p000e0347')) break p000e0347;
 		if (in_response)
		{
			if (!CNDverb(21)) break p000e0347;
 		}
		if (!CNDnoun2(89)) break p000e0347;
		if (!CNDpresent(26)) break p000e0347;
 		ACCwrite(374);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DEJA _
	p000e0348:
	{
 		if (skipdoall('p000e0348')) break p000e0348;
 		if (in_response)
		{
			if (!CNDverb(51)) break p000e0348;
 		}
		if (!CNDnoun2(89)) break p000e0348;
		if (!CNDpresent(26)) break p000e0348;
 		ACCwrite(375);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE _
	p000e0349:
	{
 		if (skipdoall('p000e0349')) break p000e0349;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0349;
 		}
		if (!CNDnoun2(89)) break p000e0349;
		if (!CNDpresent(26)) break p000e0349;
 		ACCwrite(376);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA _
	p000e0350:
	{
 		if (skipdoall('p000e0350')) break p000e0350;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0350;
 		}
		if (!CNDnoun2(89)) break p000e0350;
		if (!CNDabsent(26)) break p000e0350;
 		ACCwrite(377);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA _
	p000e0351:
	{
 		if (skipdoall('p000e0351')) break p000e0351;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0351;
 		}
		if (!CNDnoun2(89)) break p000e0351;
		if (!CNDpresent(26)) break p000e0351;
 		ACCwhatox(11);
		if (!CNDeq(51,255)) break p000e0351;
 		ACCwrite(378);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA _
	p000e0352:
	{
 		if (skipdoall('p000e0352')) break p000e0352;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0352;
 		}
		if (!CNDnoun2(89)) break p000e0352;
		if (!CNDpresent(26)) break p000e0352;
 		ACCwhatox(11);
		if (!CNDnoteq(11,255)) break p000e0352;
		if (!CNDisnotat(getFlag(11),38)) break p000e0352;
 		ACCwrite(379);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA _
	p000e0353:
	{
 		if (skipdoall('p000e0353')) break p000e0353;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0353;
 		}
		if (!CNDnoun2(89)) break p000e0353;
		if (!CNDpresent(26)) break p000e0353;
 		ACCwhatox(11);
		if (!CNDnoteq(11,255)) break p000e0353;
		if (!CNDisat(getFlag(11),38)) break p000e0353;
 		ACCwrite(380);
 		ACCplace(getFlag(11),254);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA ANTORCHA
	p000e0354:
	{
 		if (skipdoall('p000e0354')) break p000e0354;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0354;
			if (!CNDnoun1(50)) break p000e0354;
 		}
		if (!CNDnoun2(89)) break p000e0354;
 		ACCwrite(381);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA CAPUCHA
	p000e0355:
	{
 		if (skipdoall('p000e0355')) break p000e0355;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0355;
			if (!CNDnoun1(52)) break p000e0355;
 		}
		if (!CNDnoun2(89)) break p000e0355;
 		ACCwrite(382);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA _
	p000e0356:
	{
 		if (skipdoall('p000e0356')) break p000e0356;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0356;
 		}
		if (!CNDnoun2(89)) break p000e0356;
		if (!CNDabsent(26)) break p000e0356;
 		ACCwrite(383);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA _
	p000e0357:
	{
 		if (skipdoall('p000e0357')) break p000e0357;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0357;
 		}
		if (!CNDnoun2(89)) break p000e0357;
		if (!CNDnoteq(35,13)) break p000e0357;
		if (!CNDpresent(26)) break p000e0357;
 		ACCwhatox(11);
		if (!CNDeq(11,255)) break p000e0357;
 		ACCwrite(384);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA _
	p000e0358:
	{
 		if (skipdoall('p000e0358')) break p000e0358;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0358;
 		}
		if (!CNDnoun2(89)) break p000e0358;
		if (!CNDnoteq(35,13)) break p000e0358;
		if (!CNDpresent(26)) break p000e0358;
 		ACCwhatox(11);
		if (!CNDnoteq(11,255)) break p000e0358;
		if (!CNDnotcarr(getFlag(11))) break p000e0358;
 		ACCwrite(385);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA _
	p000e0359:
	{
 		if (skipdoall('p000e0359')) break p000e0359;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0359;
 		}
		if (!CNDnoun2(89)) break p000e0359;
		if (!CNDnoteq(35,13)) break p000e0359;
		if (!CNDpresent(26)) break p000e0359;
 		ACCwhatox(11);
		if (!CNDnoteq(11,255)) break p000e0359;
		if (!CNDcarried(getFlag(11))) break p000e0359;
 		ACCwrite(386);
 		ACCplace(getFlag(11),38);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR CAJA
	p000e0360:
	{
 		if (skipdoall('p000e0360')) break p000e0360;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0360;
			if (!CNDnoun1(89)) break p000e0360;
 		}
		if (!CNDpresent(26)) break p000e0360;
 		ACCwrite(387);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE CAJA
	p000e0361:
	{
 		if (skipdoall('p000e0361')) break p000e0361;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0361;
			if (!CNDnoun1(89)) break p000e0361;
 		}
		if (!CNDpresent(26)) break p000e0361;
 		ACCwrite(388);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ECHA CAJA
	p000e0362:
	{
 		if (skipdoall('p000e0362')) break p000e0362;
 		if (in_response)
		{
			if (!CNDverb(67)) break p000e0362;
			if (!CNDnoun1(89)) break p000e0362;
 		}
		if (!CNDpresent(26)) break p000e0362;
		if (!CNDabsent(5)) break p000e0362;
 		ACCwrite(389);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE TRASTO
	p000e0363:
	{
 		if (skipdoall('p000e0363')) break p000e0363;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0363;
			if (!CNDnoun1(182)) break p000e0363;
 		}
		if (!CNDat(36)) break p000e0363;
 		ACCwrite(390);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE HERRAMIENT
	p000e0364:
	{
 		if (skipdoall('p000e0364')) break p000e0364;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0364;
			if (!CNDnoun1(152)) break p000e0364;
 		}
		if (!CNDat(36)) break p000e0364;
 		ACCwrite(391);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// TOCA MECANISMO
	p000e0365:
	{
 		if (skipdoall('p000e0365')) break p000e0365;
 		if (in_response)
		{
			if (!CNDverb(80)) break p000e0365;
			if (!CNDnoun1(189)) break p000e0365;
 		}
		if (!CNDat(36)) break p000e0365;
 		ACCwrite(392);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE PUERTA
	p000e0366:
	{
 		if (skipdoall('p000e0366')) break p000e0366;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0366;
			if (!CNDnoun1(69)) break p000e0366;
 		}
		if (!CNDat(36)) break p000e0366;
 		ACCwrite(393);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR PUERTA
	p000e0367:
	{
 		if (skipdoall('p000e0367')) break p000e0367;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0367;
			if (!CNDnoun1(69)) break p000e0367;
 		}
		if (!CNDat(36)) break p000e0367;
 		ACCwrite(394);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// GOLPEA AUTO
	p000e0368:
	{
 		if (skipdoall('p000e0368')) break p000e0368;
 		if (in_response)
		{
			if (!CNDverb(63)) break p000e0368;
			if (!CNDnoun1(137)) break p000e0368;
 		}
		if (!CNDat(36)) break p000e0368;
 		ACCwrite(395);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// EMPUJA AUTO
	p000e0369:
	{
 		if (skipdoall('p000e0369')) break p000e0369;
 		if (in_response)
		{
			if (!CNDverb(36)) break p000e0369;
			if (!CNDnoun1(137)) break p000e0369;
 		}
		if (!CNDat(36)) break p000e0369;
 		ACCwrite(396);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE PUERTA
	p000e0370:
	{
 		if (skipdoall('p000e0370')) break p000e0370;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0370;
			if (!CNDnoun1(69)) break p000e0370;
 		}
		if (!CNDat(36)) break p000e0370;
		if (!CNDnoun2(137)) break p000e0370;
 		ACCwrite(397);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE AUTO
	p000e0371:
	{
 		if (skipdoall('p000e0371')) break p000e0371;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0371;
			if (!CNDnoun1(137)) break p000e0371;
 		}
		if (!CNDat(36)) break p000e0371;
 		ACCwrite(398);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SUBE AUTO
	p000e0372:
	{
 		if (skipdoall('p000e0372')) break p000e0372;
 		if (in_response)
		{
			if (!CNDverb(10)) break p000e0372;
			if (!CNDnoun1(137)) break p000e0372;
 		}
		if (!CNDat(36)) break p000e0372;
 		ACCwrite(399);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// MONTA AUTO
	p000e0373:
	{
 		if (skipdoall('p000e0373')) break p000e0373;
 		if (in_response)
		{
			if (!CNDverb(56)) break p000e0373;
			if (!CNDnoun1(137)) break p000e0373;
 		}
		if (!CNDat(36)) break p000e0373;
 		ACCwrite(400);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENTRA _
	p000e0374:
	{
 		if (skipdoall('p000e0374')) break p000e0374;
 		if (in_response)
		{
			if (!CNDverb(50)) break p000e0374;
 		}
		if (!CNDat(39)) break p000e0374;
 		ACCgoto(36);
 		ACCdesc();
		break pro000_restart;
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SAL _
	p000e0375:
	{
 		if (skipdoall('p000e0375')) break p000e0375;
 		if (in_response)
		{
			if (!CNDverb(49)) break p000e0375;
 		}
		if (!CNDat(36)) break p000e0375;
 		ACCgoto(39);
 		ACCdesc();
		break pro000_restart;
 		ACCdone();
		break pro000_restart;
		{}

	}

	// EX COCHERA
	p000e0376:
	{
 		if (skipdoall('p000e0376')) break p000e0376;
 		if (in_response)
		{
			if (!CNDverb(30)) break p000e0376;
			if (!CNDnoun1(188)) break p000e0376;
 		}
		if (!CNDat(39)) break p000e0376;
 		ACCwrite(401);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// AD _
	p000e0377:
	{
 		if (skipdoall('p000e0377')) break p000e0377;
 		if (in_response)
		{
			if (!CNDverb(95)) break p000e0377;
 		}
 		ACCwrite(402);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CAAD _
	p000e0378:
	{
 		if (skipdoall('p000e0378')) break p000e0378;
 		if (in_response)
		{
			if (!CNDverb(96)) break p000e0378;
 		}
 		ACCwrite(403);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ROMPE _
	p000e0379:
	{
 		if (skipdoall('p000e0379')) break p000e0379;
 		if (in_response)
		{
			if (!CNDverb(94)) break p000e0379;
 		}
 		ACCwrite(404);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// BAJA ESCALON
	p000e0380:
	{
 		if (skipdoall('p000e0380')) break p000e0380;
 		if (in_response)
		{
			if (!CNDverb(11)) break p000e0380;
			if (!CNDnoun1(185)) break p000e0380;
 		}
		if (!CNDat(39)) break p000e0380;
 		ACCwrite(405);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SUBE ESCALON
	p000e0381:
	{
 		if (skipdoall('p000e0381')) break p000e0381;
 		if (in_response)
		{
			if (!CNDverb(10)) break p000e0381;
			if (!CNDnoun1(185)) break p000e0381;
 		}
		if (!CNDat(39)) break p000e0381;
 		ACCwrite(406);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ASOMAR VENTANA
	p000e0382:
	{
 		if (skipdoall('p000e0382')) break p000e0382;
 		if (in_response)
		{
			if (!CNDverb(52)) break p000e0382;
			if (!CNDnoun1(70)) break p000e0382;
 		}
		if (!CNDat(39)) break p000e0382;
 		ACCwrite(407);
		{}

	}

	// ASOMAR VENTANA
	p000e0383:
	{
 		if (skipdoall('p000e0383')) break p000e0383;
 		if (in_response)
		{
			if (!CNDverb(52)) break p000e0383;
			if (!CNDnoun1(70)) break p000e0383;
 		}
		if (!CNDat(39)) break p000e0383;
		if (!CNDzero(109)) break p000e0383;
 		ACCwrite(408);
 		ACCanykey();
 		function anykey00079() 
		{
 		ACCwrite(410);
 		ACCdone();
		return;
		}
 		function anykey00078() 
		{
 		ACCwrite(409);
 		ACCanykey();
 		waitKey(anykey00079);
		}
 		waitKey(anykey00078);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// ASOMAR VENTANA
	p000e0384:
	{
 		if (skipdoall('p000e0384')) break p000e0384;
 		if (in_response)
		{
			if (!CNDverb(52)) break p000e0384;
			if (!CNDnoun1(70)) break p000e0384;
 		}
		if (!CNDat(39)) break p000e0384;
		if (!CNDnotzero(109)) break p000e0384;
 		ACCwrite(411);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE VENTANAS
	p000e0385:
	{
 		if (skipdoall('p000e0385')) break p000e0385;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0385;
			if (!CNDnoun1(183)) break p000e0385;
 		}
		if (!CNDat(39)) break p000e0385;
 		ACCwrite(412);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE VENTANA
	p000e0386:
	{
 		if (skipdoall('p000e0386')) break p000e0386;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0386;
			if (!CNDnoun1(70)) break p000e0386;
 		}
		if (!CNDat(39)) break p000e0386;
 		ACCwrite(413);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LLAMA VENTANA
	p000e0387:
	{
 		if (skipdoall('p000e0387')) break p000e0387;
 		if (in_response)
		{
			if (!CNDverb(79)) break p000e0387;
			if (!CNDnoun1(70)) break p000e0387;
 		}
		if (!CNDat(39)) break p000e0387;
 		ACCwrite(414);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ASOMAR VENTANA
	p000e0388:
	{
 		if (skipdoall('p000e0388')) break p000e0388;
 		if (in_response)
		{
			if (!CNDverb(52)) break p000e0388;
			if (!CNDnoun1(70)) break p000e0388;
 		}
		if (!CNDat(39)) break p000e0388;
		if (!CNDzero(109)) break p000e0388;
 		ACCwrite(415);
 		ACCanykey();
 		function anykey00081() 
		{
 		ACCwrite(417);
 		ACCdone();
		return;
		}
 		function anykey00080() 
		{
 		ACCwrite(416);
 		ACCanykey();
 		waitKey(anykey00081);
		}
 		waitKey(anykey00080);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// ASOMAR VENTANA
	p000e0389:
	{
 		if (skipdoall('p000e0389')) break p000e0389;
 		if (in_response)
		{
			if (!CNDverb(52)) break p000e0389;
			if (!CNDnoun1(70)) break p000e0389;
 		}
		if (!CNDat(39)) break p000e0389;
		if (!CNDnotzero(109)) break p000e0389;
 		ACCwrite(418);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ASOMAR VENTANAS
	p000e0390:
	{
 		if (skipdoall('p000e0390')) break p000e0390;
 		if (in_response)
		{
			if (!CNDverb(52)) break p000e0390;
			if (!CNDnoun1(183)) break p000e0390;
 		}
		if (!CNDat(35)) break p000e0390;
 		ACCwrite(419);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE VENTANA
	p000e0391:
	{
 		if (skipdoall('p000e0391')) break p000e0391;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0391;
			if (!CNDnoun1(70)) break p000e0391;
 		}
		if (!CNDat(35)) break p000e0391;
 		ACCwrite(420);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE VENTANAS
	p000e0392:
	{
 		if (skipdoall('p000e0392')) break p000e0392;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0392;
			if (!CNDnoun1(183)) break p000e0392;
 		}
		if (!CNDat(35)) break p000e0392;
 		ACCwrite(421);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE FLORES
	p000e0393:
	{
 		if (skipdoall('p000e0393')) break p000e0393;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0393;
			if (!CNDnoun1(125)) break p000e0393;
 		}
		if (!CNDat(35)) break p000e0393;
 		ACCwrite(422);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE HELECHOS
	p000e0394:
	{
 		if (skipdoall('p000e0394')) break p000e0394;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0394;
			if (!CNDnoun1(101)) break p000e0394;
 		}
		if (!CNDat(35)) break p000e0394;
 		ACCwrite(423);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ARRANCA FLORES
	p000e0395:
	{
 		if (skipdoall('p000e0395')) break p000e0395;
 		if (in_response)
		{
			if (!CNDverb(60)) break p000e0395;
			if (!CNDnoun1(125)) break p000e0395;
 		}
		if (!CNDat(35)) break p000e0395;
 		ACCwrite(424);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ARRANCA HELECHOS
	p000e0396:
	{
 		if (skipdoall('p000e0396')) break p000e0396;
 		if (in_response)
		{
			if (!CNDverb(60)) break p000e0396;
			if (!CNDnoun1(101)) break p000e0396;
 		}
		if (!CNDat(35)) break p000e0396;
 		ACCwrite(425);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE TRASTO
	p000e0397:
	{
 		if (skipdoall('p000e0397')) break p000e0397;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0397;
			if (!CNDnoun1(182)) break p000e0397;
 		}
		if (!CNDat(34)) break p000e0397;
 		ACCwrite(426);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE MAGICOS
	p000e0398:
	{
 		if (skipdoall('p000e0398')) break p000e0398;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0398;
			if (!CNDnoun1(61)) break p000e0398;
 		}
		if (!CNDat(34)) break p000e0398;
 		ACCwrite(427);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ELEVA CAJAS
	p000e0399:
	{
 		if (skipdoall('p000e0399')) break p000e0399;
 		if (in_response)
		{
			if (!CNDverb(47)) break p000e0399;
			if (!CNDnoun1(172)) break p000e0399;
 		}
		if (!CNDat(34)) break p000e0399;
 		ACCwrite(428);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENJABONA _
	p000e0400:
	{
 		if (skipdoall('p000e0400')) break p000e0400;
 		if (in_response)
		{
			if (!CNDverb(90)) break p000e0400;
 		}
		if (!CNDnotcarr(24)) break p000e0400;
 		ACCwrite(429);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENJABONA BARROTES
	p000e0401:
	{
 		if (skipdoall('p000e0401')) break p000e0401;
 		if (in_response)
		{
			if (!CNDverb(90)) break p000e0401;
			if (!CNDnoun1(178)) break p000e0401;
 		}
		if (!CNDat(34)) break p000e0401;
		if (!CNDcarried(24)) break p000e0401;
 		ACCwrite(430);
 		ACCset(106);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// FROTA JABON
	p000e0402:
	{
 		if (skipdoall('p000e0402')) break p000e0402;
 		if (in_response)
		{
			if (!CNDverb(91)) break p000e0402;
			if (!CNDnoun1(173)) break p000e0402;
 		}
		if (!CNDnoun2(178)) break p000e0402;
		if (!CNDat(34)) break p000e0402;
		if (!CNDcarried(24)) break p000e0402;
 		ACCwrite(431);
 		ACCset(106);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// FROTA BARROTES
	p000e0403:
	{
 		if (skipdoall('p000e0403')) break p000e0403;
 		if (in_response)
		{
			if (!CNDverb(91)) break p000e0403;
			if (!CNDnoun1(178)) break p000e0403;
 		}
		if (!CNDnoun2(173)) break p000e0403;
		if (!CNDat(34)) break p000e0403;
		if (!CNDcarried(24)) break p000e0403;
 		ACCwrite(432);
 		ACCset(106);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENJABONAME _
	p000e0404:
	{
 		if (skipdoall('p000e0404')) break p000e0404;
 		if (in_response)
		{
			if (!CNDverb(92)) break p000e0404;
 		}
		if (!CNDcarried(24)) break p000e0404;
 		ACCwrite(433);
 		ACCset(107);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENJABONAME _
	p000e0405:
	{
 		if (skipdoall('p000e0405')) break p000e0405;
 		if (in_response)
		{
			if (!CNDverb(92)) break p000e0405;
 		}
		if (!CNDcarried(24)) break p000e0405;
 		ACCwrite(434);
 		ACCset(107);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENJABONA CUERPO
	p000e0406:
	{
 		if (skipdoall('p000e0406')) break p000e0406;
 		if (in_response)
		{
			if (!CNDverb(90)) break p000e0406;
			if (!CNDnoun1(179)) break p000e0406;
 		}
		if (!CNDcarried(24)) break p000e0406;
 		ACCwrite(435);
 		ACCset(107);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENJABONA MI
	p000e0407:
	{
 		if (skipdoall('p000e0407')) break p000e0407;
 		if (in_response)
		{
			if (!CNDverb(90)) break p000e0407;
			if (!CNDnoun1(180)) break p000e0407;
 		}
		if (!CNDcarried(24)) break p000e0407;
 		ACCwrite(436);
 		ACCset(107);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENJABONAME _
	p000e0408:
	{
 		if (skipdoall('p000e0408')) break p000e0408;
 		if (in_response)
		{
			if (!CNDverb(92)) break p000e0408;
 		}
		if (!CNDcarried(24)) break p000e0408;
 		ACCwrite(437);
 		ACCset(107);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// FROTA JABON
	p000e0409:
	{
 		if (skipdoall('p000e0409')) break p000e0409;
 		if (in_response)
		{
			if (!CNDverb(91)) break p000e0409;
			if (!CNDnoun1(173)) break p000e0409;
 		}
		if (!CNDnoun2(179)) break p000e0409;
		if (!CNDcarried(24)) break p000e0409;
 		ACCwrite(438);
 		ACCset(107);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// FROTA CUERPO
	p000e0410:
	{
 		if (skipdoall('p000e0410')) break p000e0410;
 		if (in_response)
		{
			if (!CNDverb(91)) break p000e0410;
			if (!CNDnoun1(179)) break p000e0410;
 		}
		if (!CNDnoun2(173)) break p000e0410;
		if (!CNDcarried(24)) break p000e0410;
 		ACCwrite(439);
 		ACCset(107);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// HUELE _
	p000e0411:
	{
 		if (skipdoall('p000e0411')) break p000e0411;
 		if (in_response)
		{
			if (!CNDverb(72)) break p000e0411;
 		}
		if (!CNDat(34)) break p000e0411;
 		ACCwrite(440);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE VENTANA
	p000e0412:
	{
 		if (skipdoall('p000e0412')) break p000e0412;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0412;
			if (!CNDnoun1(70)) break p000e0412;
 		}
		if (!CNDat(34)) break p000e0412;
 		ACCwrite(441);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR VENTANA
	p000e0413:
	{
 		if (skipdoall('p000e0413')) break p000e0413;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0413;
			if (!CNDnoun1(70)) break p000e0413;
 		}
		if (!CNDat(34)) break p000e0413;
 		ACCwrite(442);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE BARROTES
	p000e0414:
	{
 		if (skipdoall('p000e0414')) break p000e0414;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0414;
			if (!CNDnoun1(178)) break p000e0414;
 		}
		if (!CNDat(34)) break p000e0414;
 		ACCwrite(443);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SAL VENTANA
	p000e0415:
	{
 		if (skipdoall('p000e0415')) break p000e0415;
 		if (in_response)
		{
			if (!CNDverb(49)) break p000e0415;
			if (!CNDnoun1(70)) break p000e0415;
 		}
		if (!CNDat(34)) break p000e0415;
		if (!CNDzero(106)) break p000e0415;
		if (!CNDzero(107)) break p000e0415;
 		ACCwrite(444);
 		ACCanykey();
 		function anykey00083() 
		{
 		ACCwrite(446);
 		ACCdone();
		return;
		}
 		function anykey00082() 
		{
 		ACCwrite(445);
 		ACCanykey();
 		waitKey(anykey00083);
		}
 		waitKey(anykey00082);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// SAL VENTANA
	p000e0416:
	{
 		if (skipdoall('p000e0416')) break p000e0416;
 		if (in_response)
		{
			if (!CNDverb(49)) break p000e0416;
			if (!CNDnoun1(70)) break p000e0416;
 		}
		if (!CNDat(34)) break p000e0416;
		if (!CNDnotzero(106)) break p000e0416;
		if (!CNDzero(107)) break p000e0416;
 		ACCwrite(447);
 		ACCanykey();
 		function anykey00085() 
		{
 		ACCwrite(449);
 		ACCdone();
		return;
		}
 		function anykey00084() 
		{
 		ACCwrite(448);
 		ACCanykey();
 		waitKey(anykey00085);
		}
 		waitKey(anykey00084);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// SAL VENTANA
	p000e0417:
	{
 		if (skipdoall('p000e0417')) break p000e0417;
 		if (in_response)
		{
			if (!CNDverb(49)) break p000e0417;
			if (!CNDnoun1(70)) break p000e0417;
 		}
		if (!CNDat(34)) break p000e0417;
		if (!CNDnotzero(107)) break p000e0417;
		if (!CNDzero(106)) break p000e0417;
 		ACCwrite(450);
 		ACCanykey();
 		function anykey00087() 
		{
 		ACCwrite(452);
 		ACCdone();
		return;
		}
 		function anykey00086() 
		{
 		ACCwrite(451);
 		ACCanykey();
 		waitKey(anykey00087);
		}
 		waitKey(anykey00086);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// SAL VENTANA
	p000e0418:
	{
 		if (skipdoall('p000e0418')) break p000e0418;
 		if (in_response)
		{
			if (!CNDverb(49)) break p000e0418;
			if (!CNDnoun1(70)) break p000e0418;
 		}
		if (!CNDat(34)) break p000e0418;
		if (!CNDnotzero(106)) break p000e0418;
		if (!CNDnotzero(107)) break p000e0418;
		if (!CNDnotcarr(27)) break p000e0418;
 		ACCwrite(453);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SAL VENTANA
	p000e0419:
	{
 		if (skipdoall('p000e0419')) break p000e0419;
 		if (in_response)
		{
			if (!CNDverb(49)) break p000e0419;
			if (!CNDnoun1(70)) break p000e0419;
 		}
		if (!CNDat(34)) break p000e0419;
		if (!CNDnotzero(106)) break p000e0419;
		if (!CNDnotzero(107)) break p000e0419;
		if (!CNDnotcarr(25)) break p000e0419;
 		ACCwrite(454);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SAL VENTANA
	p000e0420:
	{
 		if (skipdoall('p000e0420')) break p000e0420;
 		if (in_response)
		{
			if (!CNDverb(49)) break p000e0420;
			if (!CNDnoun1(70)) break p000e0420;
 		}
		if (!CNDat(34)) break p000e0420;
		if (!CNDnotzero(106)) break p000e0420;
		if (!CNDnotzero(107)) break p000e0420;
 		ACCwrite(455);
 		ACCwrite(456);
 		ACCanykey();
 		function anykey00091() 
		{
 		ACCgoto(35);
 		ACCdesc();
		return;
		}
 		function anykey00090() 
		{
 		ACCpicture(35);
 		ACCwrite(459);
 		ACCanykey();
 		waitKey(anykey00091);
		}
 		function anykey00089() 
		{
 		ACCwrite(458);
 		ACCanykey();
 		waitKey(anykey00090);
		}
 		function anykey00088() 
		{
 		ACCwrite(457);
 		ACCanykey();
 		waitKey(anykey00089);
		}
 		waitKey(anykey00088);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// SAL BARROTES
	p000e0421:
	{
 		if (skipdoall('p000e0421')) break p000e0421;
 		if (in_response)
		{
			if (!CNDverb(49)) break p000e0421;
			if (!CNDnoun1(178)) break p000e0421;
 		}
		if (!CNDat(34)) break p000e0421;
		if (!CNDnotzero(106)) break p000e0421;
		if (!CNDnotzero(107)) break p000e0421;
		if (!CNDnotcarr(27)) break p000e0421;
 		ACCwrite(460);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SAL BARROTES
	p000e0422:
	{
 		if (skipdoall('p000e0422')) break p000e0422;
 		if (in_response)
		{
			if (!CNDverb(49)) break p000e0422;
			if (!CNDnoun1(178)) break p000e0422;
 		}
		if (!CNDat(34)) break p000e0422;
		if (!CNDnotzero(106)) break p000e0422;
		if (!CNDnotzero(107)) break p000e0422;
		if (!CNDnotcarr(25)) break p000e0422;
 		ACCwrite(461);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SAL BARROTES
	p000e0423:
	{
 		if (skipdoall('p000e0423')) break p000e0423;
 		if (in_response)
		{
			if (!CNDverb(49)) break p000e0423;
			if (!CNDnoun1(178)) break p000e0423;
 		}
		if (!CNDat(34)) break p000e0423;
		if (!CNDzero(106)) break p000e0423;
		if (!CNDzero(107)) break p000e0423;
 		ACCwrite(462);
 		ACCanykey();
 		function anykey00093() 
		{
 		ACCwrite(464);
 		ACCdone();
		return;
		}
 		function anykey00092() 
		{
 		ACCwrite(463);
 		ACCanykey();
 		waitKey(anykey00093);
		}
 		waitKey(anykey00092);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// SAL BARROTES
	p000e0424:
	{
 		if (skipdoall('p000e0424')) break p000e0424;
 		if (in_response)
		{
			if (!CNDverb(49)) break p000e0424;
			if (!CNDnoun1(178)) break p000e0424;
 		}
		if (!CNDat(34)) break p000e0424;
		if (!CNDnotzero(106)) break p000e0424;
		if (!CNDzero(107)) break p000e0424;
 		ACCwrite(465);
 		ACCanykey();
 		function anykey00095() 
		{
 		ACCwrite(467);
 		ACCdone();
		return;
		}
 		function anykey00094() 
		{
 		ACCwrite(466);
 		ACCanykey();
 		waitKey(anykey00095);
		}
 		waitKey(anykey00094);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// SAL BARROTES
	p000e0425:
	{
 		if (skipdoall('p000e0425')) break p000e0425;
 		if (in_response)
		{
			if (!CNDverb(49)) break p000e0425;
			if (!CNDnoun1(178)) break p000e0425;
 		}
		if (!CNDat(34)) break p000e0425;
		if (!CNDnotzero(107)) break p000e0425;
		if (!CNDzero(106)) break p000e0425;
 		ACCwrite(468);
 		ACCanykey();
 		function anykey00097() 
		{
 		ACCwrite(470);
 		ACCdone();
		return;
		}
 		function anykey00096() 
		{
 		ACCwrite(469);
 		ACCanykey();
 		waitKey(anykey00097);
		}
 		waitKey(anykey00096);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// SAL BARROTES
	p000e0426:
	{
 		if (skipdoall('p000e0426')) break p000e0426;
 		if (in_response)
		{
			if (!CNDverb(49)) break p000e0426;
			if (!CNDnoun1(178)) break p000e0426;
 		}
		if (!CNDat(34)) break p000e0426;
		if (!CNDnotzero(106)) break p000e0426;
		if (!CNDnotzero(107)) break p000e0426;
 		ACCwrite(471);
 		ACCwrite(472);
 		ACCanykey();
 		function anykey00101() 
		{
 		ACCgoto(35);
 		ACCdesc();
		return;
		}
 		function anykey00100() 
		{
 		ACCpicture(35);
 		ACCwrite(475);
 		ACCanykey();
 		waitKey(anykey00101);
		}
 		function anykey00099() 
		{
 		ACCwrite(474);
 		ACCanykey();
 		waitKey(anykey00100);
		}
 		function anykey00098() 
		{
 		ACCwrite(473);
 		ACCanykey();
 		waitKey(anykey00099);
		}
 		waitKey(anykey00098);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// ATRAVESAR BARROTES
	p000e0427:
	{
 		if (skipdoall('p000e0427')) break p000e0427;
 		if (in_response)
		{
			if (!CNDverb(93)) break p000e0427;
			if (!CNDnoun1(178)) break p000e0427;
 		}
		if (!CNDat(34)) break p000e0427;
		if (!CNDnotzero(106)) break p000e0427;
		if (!CNDnotzero(107)) break p000e0427;
		if (!CNDnotcarr(27)) break p000e0427;
 		ACCwrite(476);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ATRAVESAR BARROTES
	p000e0428:
	{
 		if (skipdoall('p000e0428')) break p000e0428;
 		if (in_response)
		{
			if (!CNDverb(93)) break p000e0428;
			if (!CNDnoun1(178)) break p000e0428;
 		}
		if (!CNDat(34)) break p000e0428;
		if (!CNDnotzero(106)) break p000e0428;
		if (!CNDnotzero(107)) break p000e0428;
		if (!CNDnotcarr(25)) break p000e0428;
 		ACCwrite(477);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ATRAVESAR BARROTES
	p000e0429:
	{
 		if (skipdoall('p000e0429')) break p000e0429;
 		if (in_response)
		{
			if (!CNDverb(93)) break p000e0429;
			if (!CNDnoun1(178)) break p000e0429;
 		}
		if (!CNDat(34)) break p000e0429;
		if (!CNDzero(106)) break p000e0429;
		if (!CNDzero(107)) break p000e0429;
 		ACCwrite(478);
 		ACCanykey();
 		function anykey00103() 
		{
 		ACCwrite(480);
 		ACCdone();
		return;
		}
 		function anykey00102() 
		{
 		ACCwrite(479);
 		ACCanykey();
 		waitKey(anykey00103);
		}
 		waitKey(anykey00102);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// ATRAVESAR BARROTES
	p000e0430:
	{
 		if (skipdoall('p000e0430')) break p000e0430;
 		if (in_response)
		{
			if (!CNDverb(93)) break p000e0430;
			if (!CNDnoun1(178)) break p000e0430;
 		}
		if (!CNDat(34)) break p000e0430;
		if (!CNDnotzero(106)) break p000e0430;
		if (!CNDzero(107)) break p000e0430;
 		ACCwrite(481);
 		ACCanykey();
 		function anykey00105() 
		{
 		ACCwrite(483);
 		ACCdone();
		return;
		}
 		function anykey00104() 
		{
 		ACCwrite(482);
 		ACCanykey();
 		waitKey(anykey00105);
		}
 		waitKey(anykey00104);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// ATRAVESAR BARROTES
	p000e0431:
	{
 		if (skipdoall('p000e0431')) break p000e0431;
 		if (in_response)
		{
			if (!CNDverb(93)) break p000e0431;
			if (!CNDnoun1(178)) break p000e0431;
 		}
		if (!CNDat(34)) break p000e0431;
		if (!CNDnotzero(107)) break p000e0431;
		if (!CNDzero(106)) break p000e0431;
 		ACCwrite(484);
 		ACCanykey();
 		function anykey00107() 
		{
 		ACCwrite(486);
 		ACCdone();
		return;
		}
 		function anykey00106() 
		{
 		ACCwrite(485);
 		ACCanykey();
 		waitKey(anykey00107);
		}
 		waitKey(anykey00106);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// ATRAVESAR BARROTES
	p000e0432:
	{
 		if (skipdoall('p000e0432')) break p000e0432;
 		if (in_response)
		{
			if (!CNDverb(93)) break p000e0432;
			if (!CNDnoun1(178)) break p000e0432;
 		}
		if (!CNDat(34)) break p000e0432;
		if (!CNDnotzero(106)) break p000e0432;
		if (!CNDnotzero(107)) break p000e0432;
 		ACCwrite(487);
 		ACCwrite(488);
 		ACCanykey();
 		function anykey00111() 
		{
 		ACCgoto(35);
 		ACCdesc();
		return;
		}
 		function anykey00110() 
		{
 		ACCpicture(35);
 		ACCwrite(491);
 		ACCanykey();
 		waitKey(anykey00111);
		}
 		function anykey00109() 
		{
 		ACCwrite(490);
 		ACCanykey();
 		waitKey(anykey00110);
		}
 		function anykey00108() 
		{
 		ACCwrite(489);
 		ACCanykey();
 		waitKey(anykey00109);
		}
 		waitKey(anykey00108);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// ATRAVESAR VENTANA
	p000e0433:
	{
 		if (skipdoall('p000e0433')) break p000e0433;
 		if (in_response)
		{
			if (!CNDverb(93)) break p000e0433;
			if (!CNDnoun1(70)) break p000e0433;
 		}
		if (!CNDat(34)) break p000e0433;
		if (!CNDnotzero(106)) break p000e0433;
		if (!CNDnotzero(107)) break p000e0433;
		if (!CNDnotcarr(27)) break p000e0433;
 		ACCwrite(492);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ATRAVESAR VENTANA
	p000e0434:
	{
 		if (skipdoall('p000e0434')) break p000e0434;
 		if (in_response)
		{
			if (!CNDverb(93)) break p000e0434;
			if (!CNDnoun1(70)) break p000e0434;
 		}
		if (!CNDat(34)) break p000e0434;
		if (!CNDnotzero(106)) break p000e0434;
		if (!CNDnotzero(107)) break p000e0434;
		if (!CNDnotcarr(25)) break p000e0434;
 		ACCwrite(493);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ATRAVESAR VENTANA
	p000e0435:
	{
 		if (skipdoall('p000e0435')) break p000e0435;
 		if (in_response)
		{
			if (!CNDverb(93)) break p000e0435;
			if (!CNDnoun1(70)) break p000e0435;
 		}
		if (!CNDat(34)) break p000e0435;
		if (!CNDzero(106)) break p000e0435;
		if (!CNDzero(107)) break p000e0435;
 		ACCwrite(494);
 		ACCanykey();
 		function anykey00113() 
		{
 		ACCwrite(496);
 		ACCdone();
		return;
		}
 		function anykey00112() 
		{
 		ACCwrite(495);
 		ACCanykey();
 		waitKey(anykey00113);
		}
 		waitKey(anykey00112);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// ATRAVESAR VENTANA
	p000e0436:
	{
 		if (skipdoall('p000e0436')) break p000e0436;
 		if (in_response)
		{
			if (!CNDverb(93)) break p000e0436;
			if (!CNDnoun1(70)) break p000e0436;
 		}
		if (!CNDat(34)) break p000e0436;
		if (!CNDnotzero(106)) break p000e0436;
		if (!CNDzero(107)) break p000e0436;
 		ACCwrite(497);
 		ACCanykey();
 		function anykey00115() 
		{
 		ACCwrite(499);
 		ACCdone();
		return;
		}
 		function anykey00114() 
		{
 		ACCwrite(498);
 		ACCanykey();
 		waitKey(anykey00115);
		}
 		waitKey(anykey00114);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// ATRAVESAR VENTANA
	p000e0437:
	{
 		if (skipdoall('p000e0437')) break p000e0437;
 		if (in_response)
		{
			if (!CNDverb(93)) break p000e0437;
			if (!CNDnoun1(70)) break p000e0437;
 		}
		if (!CNDat(34)) break p000e0437;
		if (!CNDnotzero(107)) break p000e0437;
		if (!CNDzero(106)) break p000e0437;
 		ACCwrite(500);
 		ACCanykey();
 		function anykey00117() 
		{
 		ACCwrite(502);
 		ACCdone();
		return;
		}
 		function anykey00116() 
		{
 		ACCwrite(501);
 		ACCanykey();
 		waitKey(anykey00117);
		}
 		waitKey(anykey00116);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// ATRAVESAR VENTANA
	p000e0438:
	{
 		if (skipdoall('p000e0438')) break p000e0438;
 		if (in_response)
		{
			if (!CNDverb(93)) break p000e0438;
			if (!CNDnoun1(70)) break p000e0438;
 		}
		if (!CNDat(34)) break p000e0438;
		if (!CNDnotzero(106)) break p000e0438;
		if (!CNDnotzero(107)) break p000e0438;
 		ACCwrite(503);
 		ACCwrite(504);
 		ACCanykey();
 		function anykey00121() 
		{
 		ACCgoto(35);
 		ACCdesc();
		return;
		}
 		function anykey00120() 
		{
 		ACCpicture(35);
 		ACCwrite(507);
 		ACCanykey();
 		waitKey(anykey00121);
		}
 		function anykey00119() 
		{
 		ACCwrite(506);
 		ACCanykey();
 		waitKey(anykey00120);
		}
 		function anykey00118() 
		{
 		ACCwrite(505);
 		ACCanykey();
 		waitKey(anykey00119);
		}
 		waitKey(anykey00118);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// SAL _
	p000e0439:
	{
 		if (skipdoall('p000e0439')) break p000e0439;
 		if (in_response)
		{
			if (!CNDverb(49)) break p000e0439;
 		}
		if (!CNDat(34)) break p000e0439;
 		ACCwrite(508);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE ESPUMA
	p000e0440:
	{
 		if (skipdoall('p000e0440')) break p000e0440;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0440;
			if (!CNDnoun1(176)) break p000e0440;
 		}
		if (!CNDat(34)) break p000e0440;
 		ACCwrite(509);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE CAJAS
	p000e0441:
	{
 		if (skipdoall('p000e0441')) break p000e0441;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0441;
			if (!CNDnoun1(172)) break p000e0441;
 		}
		if (!CNDat(34)) break p000e0441;
 		ACCwrite(510);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE VENTILADOR
	p000e0442:
	{
 		if (skipdoall('p000e0442')) break p000e0442;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0442;
			if (!CNDnoun1(175)) break p000e0442;
 		}
		if (!CNDat(34)) break p000e0442;
 		ACCwrite(511);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE TRAMPILLA
	p000e0443:
	{
 		if (skipdoall('p000e0443')) break p000e0443;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0443;
			if (!CNDnoun1(170)) break p000e0443;
 		}
		if (!CNDat(34)) break p000e0443;
 		ACCwrite(512);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR TRAMPILLA
	p000e0444:
	{
 		if (skipdoall('p000e0444')) break p000e0444;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0444;
			if (!CNDnoun1(170)) break p000e0444;
 		}
		if (!CNDat(34)) break p000e0444;
 		ACCwrite(513);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SAL _
	p000e0445:
	{
 		if (skipdoall('p000e0445')) break p000e0445;
 		if (in_response)
		{
			if (!CNDverb(49)) break p000e0445;
 		}
		if (!CNDat(3)) break p000e0445;
 		ACCgoto(8);
 		ACCdesc();
		break pro000_restart;
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SAL _
	p000e0446:
	{
 		if (skipdoall('p000e0446')) break p000e0446;
 		if (in_response)
		{
			if (!CNDverb(49)) break p000e0446;
 		}
		if (!CNDat(1)) break p000e0446;
 		ACCgoto(4);
 		ACCdesc();
		break pro000_restart;
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ESCRIBE _
	p000e0447:
	{
 		if (skipdoall('p000e0447')) break p000e0447;
 		if (in_response)
		{
			if (!CNDverb(89)) break p000e0447;
 		}
		if (!CNDat(29)) break p000e0447;
		if (!CNDzero(97)) break p000e0447;
 		ACCwrite(514);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ESCRIBE _
	p000e0448:
	{
 		if (skipdoall('p000e0448')) break p000e0448;
 		if (in_response)
		{
			if (!CNDverb(89)) break p000e0448;
 		}
		if (!CNDat(29)) break p000e0448;
		if (!CNDeq(97,1)) break p000e0448;
 		ACCwrite(515);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ESCRIBE _
	p000e0449:
	{
 		if (skipdoall('p000e0449')) break p000e0449;
 		if (in_response)
		{
			if (!CNDverb(89)) break p000e0449;
 		}
		if (!CNDat(29)) break p000e0449;
		if (!CNDeq(97,2)) break p000e0449;
 		ACCplus(99,1);
 		ACCprocess(6);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ESCRIBE AGOSTINE
	p000e0450:
	{
 		if (skipdoall('p000e0450')) break p000e0450;
 		if (in_response)
		{
			if (!CNDverb(89)) break p000e0450;
			if (!CNDnoun1(26)) break p000e0450;
 		}
		if (!CNDat(29)) break p000e0450;
		if (!CNDeq(97,3)) break p000e0450;
 		ACCwrite(516);
 		ACCwrite(517);
 		ACCanykey();
 		function anykey00124() 
		{
 		ACCwrite(525);
 		ACCwrite(526);
 		ACCset(102);
 		ACCplace(23,254);
 		ACClet(97,1);
 		ACCdone();
		return;
		}
 		function anykey00123() 
		{
 		ACCwrite(520);
 		ACCwrite(521);
 		ACCwrite(522);
 		ACCwrite(523);
 		ACCwrite(524);
 		ACCanykey();
 		waitKey(anykey00124);
		}
 		function anykey00122() 
		{
 		ACCwrite(518);
 		ACCwrite(519);
 		ACCanykey();
 		waitKey(anykey00123);
		}
 		waitKey(anykey00122);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// ESCRIBE _
	p000e0451:
	{
 		if (skipdoall('p000e0451')) break p000e0451;
 		if (in_response)
		{
			if (!CNDverb(89)) break p000e0451;
 		}
		if (!CNDat(29)) break p000e0451;
		if (!CNDeq(97,3)) break p000e0451;
 		ACCwrite(527);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA CD
	p000e0452:
	{
 		if (skipdoall('p000e0452')) break p000e0452;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0452;
			if (!CNDnoun1(156)) break p000e0452;
 		}
		if (!CNDnoun2(159)) break p000e0452;
		if (!CNDnoteq(97,3)) break p000e0452;
		if (!CNDat(29)) break p000e0452;
 		ACCwrite(528);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA CD
	p000e0453:
	{
 		if (skipdoall('p000e0453')) break p000e0453;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0453;
			if (!CNDnoun1(156)) break p000e0453;
 		}
		if (!CNDnoun2(159)) break p000e0453;
		if (!CNDeq(97,3)) break p000e0453;
		if (!CNDat(29)) break p000e0453;
 		ACCwrite(529);
 		ACCplace(23,254);
 		ACClet(97,1);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA DISCO
	p000e0454:
	{
 		if (skipdoall('p000e0454')) break p000e0454;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0454;
			if (!CNDnoun1(154)) break p000e0454;
 		}
		if (!CNDnoun2(159)) break p000e0454;
		if (!CNDnoteq(97,2)) break p000e0454;
		if (!CNDat(29)) break p000e0454;
 		ACCwrite(530);
 		ACCplace(22,254);
 		ACClet(97,1);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA DISCO
	p000e0455:
	{
 		if (skipdoall('p000e0455')) break p000e0455;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0455;
			if (!CNDnoun1(154)) break p000e0455;
 		}
		if (!CNDnoun2(159)) break p000e0455;
		if (!CNDeq(97,2)) break p000e0455;
		if (!CNDat(29)) break p000e0455;
 		ACCwrite(531);
 		ACCplace(22,254);
 		ACClet(97,1);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA _
	p000e0456:
	{
 		if (skipdoall('p000e0456')) break p000e0456;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0456;
 		}
		if (!CNDnoun2(159)) break p000e0456;
		if (!CNDat(29)) break p000e0456;
 		ACCwrite(532);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA _
	p000e0457:
	{
 		if (skipdoall('p000e0457')) break p000e0457;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0457;
 		}
		if (!CNDnoun2(159)) break p000e0457;
		if (!CNDeq(97,0)) break p000e0457;
		if (!CNDat(29)) break p000e0457;
 		ACCwrite(533);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA _
	p000e0458:
	{
 		if (skipdoall('p000e0458')) break p000e0458;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0458;
 		}
		if (!CNDnoun2(223)) break p000e0458;
		if (!CNDeq(97,0)) break p000e0458;
		if (!CNDat(29)) break p000e0458;
 		ACCwrite(534);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA DISCO
	p000e0459:
	{
 		if (skipdoall('p000e0459')) break p000e0459;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0459;
			if (!CNDnoun1(154)) break p000e0459;
 		}
		if (!CNDnoun2(223)) break p000e0459;
		if (!CNDat(29)) break p000e0459;
		if (!CNDnotcarr(22)) break p000e0459;
 		ACCwrite(535);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA DISCO
	p000e0460:
	{
 		if (skipdoall('p000e0460')) break p000e0460;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0460;
			if (!CNDnoun1(154)) break p000e0460;
 		}
		if (!CNDnoun2(223)) break p000e0460;
		if (!CNDat(29)) break p000e0460;
		if (!CNDcarried(22)) break p000e0460;
		if (!CNDeq(97,3)) break p000e0460;
 		ACClet(97,2);
 		ACCdestroy(22);
 		ACCwrite(536);
 		ACCplace(23,254);
 		ACCwrite(537);
 		ACCwrite(538);
 		ACCwrite(539);
 		ACCwrite(540);
 		ACCwrite(541);
 		ACCwrite(542);
 		ACCwrite(543);
 		ACCwrite(544);
 		ACCwrite(545);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA DISCO
	p000e0461:
	{
 		if (skipdoall('p000e0461')) break p000e0461;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0461;
			if (!CNDnoun1(154)) break p000e0461;
 		}
		if (!CNDnoun2(223)) break p000e0461;
		if (!CNDat(29)) break p000e0461;
		if (!CNDcarried(22)) break p000e0461;
		if (!CNDeq(97,1)) break p000e0461;
 		ACClet(97,2);
 		ACCdestroy(22);
 		ACCwrite(546);
 		ACCwrite(547);
 		ACCwrite(548);
 		ACCwrite(549);
 		ACCwrite(550);
 		ACCwrite(551);
 		ACCwrite(552);
 		ACCwrite(553);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA CD
	p000e0462:
	{
 		if (skipdoall('p000e0462')) break p000e0462;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0462;
			if (!CNDnoun1(156)) break p000e0462;
 		}
		if (!CNDnoun2(223)) break p000e0462;
		if (!CNDnotcarr(23)) break p000e0462;
		if (!CNDat(29)) break p000e0462;
 		ACCwrite(554);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA CD
	p000e0463:
	{
 		if (skipdoall('p000e0463')) break p000e0463;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0463;
			if (!CNDnoun1(156)) break p000e0463;
 		}
		if (!CNDnoun2(223)) break p000e0463;
		if (!CNDcarried(23)) break p000e0463;
		if (!CNDeq(97,2)) break p000e0463;
		if (!CNDat(29)) break p000e0463;
 		ACCwrite(555);
 		ACCplace(22,254);
 		ACCwrite(556);
 		ACCwrite(557);
 		ACCwrite(558);
 		ACClet(97,3);
 		ACCdestroy(23);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA CD
	p000e0464:
	{
 		if (skipdoall('p000e0464')) break p000e0464;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0464;
			if (!CNDnoun1(156)) break p000e0464;
 		}
		if (!CNDnoun2(223)) break p000e0464;
		if (!CNDcarried(23)) break p000e0464;
		if (!CNDat(29)) break p000e0464;
		if (!CNDeq(97,1)) break p000e0464;
 		ACCwrite(559);
 		ACCwrite(560);
 		ACCwrite(561);
 		ACClet(97,3);
 		ACCdestroy(23);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA _
	p000e0465:
	{
 		if (skipdoall('p000e0465')) break p000e0465;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0465;
 		}
		if (!CNDnoun2(224)) break p000e0465;
		if (!CNDeq(97,0)) break p000e0465;
		if (!CNDat(29)) break p000e0465;
 		ACCwrite(562);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA DISCO
	p000e0466:
	{
 		if (skipdoall('p000e0466')) break p000e0466;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0466;
			if (!CNDnoun1(154)) break p000e0466;
 		}
		if (!CNDnoun2(159)) break p000e0466;
		if (!CNDat(29)) break p000e0466;
		if (!CNDnotcarr(22)) break p000e0466;
 		ACCwrite(563);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA DISCO
	p000e0467:
	{
 		if (skipdoall('p000e0467')) break p000e0467;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0467;
			if (!CNDnoun1(154)) break p000e0467;
 		}
		if (!CNDnoun2(159)) break p000e0467;
		if (!CNDat(29)) break p000e0467;
		if (!CNDcarried(22)) break p000e0467;
		if (!CNDeq(97,3)) break p000e0467;
 		ACClet(97,2);
 		ACCdestroy(22);
 		ACCwrite(564);
 		ACCplace(23,254);
 		ACCwrite(565);
 		ACCwrite(566);
 		ACCwrite(567);
 		ACCwrite(568);
 		ACCwrite(569);
 		ACCwrite(570);
 		ACCwrite(571);
 		ACCwrite(572);
 		ACCwrite(573);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA DISCO
	p000e0468:
	{
 		if (skipdoall('p000e0468')) break p000e0468;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0468;
			if (!CNDnoun1(154)) break p000e0468;
 		}
		if (!CNDnoun2(159)) break p000e0468;
		if (!CNDat(29)) break p000e0468;
		if (!CNDcarried(22)) break p000e0468;
		if (!CNDeq(97,1)) break p000e0468;
 		ACClet(97,2);
 		ACCdestroy(22);
 		ACCwrite(574);
 		ACCwrite(575);
 		ACCwrite(576);
 		ACCwrite(577);
 		ACCwrite(578);
 		ACCwrite(579);
 		ACCwrite(580);
 		ACCwrite(581);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA CD
	p000e0469:
	{
 		if (skipdoall('p000e0469')) break p000e0469;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0469;
			if (!CNDnoun1(156)) break p000e0469;
 		}
		if (!CNDnoun2(159)) break p000e0469;
		if (!CNDnotcarr(23)) break p000e0469;
		if (!CNDat(29)) break p000e0469;
 		ACCwrite(582);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA CD
	p000e0470:
	{
 		if (skipdoall('p000e0470')) break p000e0470;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0470;
			if (!CNDnoun1(156)) break p000e0470;
 		}
		if (!CNDnoun2(159)) break p000e0470;
		if (!CNDcarried(23)) break p000e0470;
		if (!CNDeq(97,2)) break p000e0470;
		if (!CNDat(29)) break p000e0470;
 		ACCwrite(583);
 		ACCplace(22,254);
 		ACCwrite(584);
 		ACCwrite(585);
 		ACCwrite(586);
 		ACClet(97,3);
 		ACCdestroy(23);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA CD
	p000e0471:
	{
 		if (skipdoall('p000e0471')) break p000e0471;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0471;
			if (!CNDnoun1(156)) break p000e0471;
 		}
		if (!CNDnoun2(159)) break p000e0471;
		if (!CNDcarried(23)) break p000e0471;
		if (!CNDat(29)) break p000e0471;
		if (!CNDeq(97,1)) break p000e0471;
 		ACCwrite(587);
 		ACCwrite(588);
 		ACCwrite(589);
 		ACClet(97,3);
 		ACCdestroy(23);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA CD
	p000e0472:
	{
 		if (skipdoall('p000e0472')) break p000e0472;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0472;
			if (!CNDnoun1(156)) break p000e0472;
 		}
		if (!CNDnoun2(224)) break p000e0472;
		if (!CNDat(29)) break p000e0472;
		if (!CNDnoteq(97,3)) break p000e0472;
 		ACCwrite(590);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA CD
	p000e0473:
	{
 		if (skipdoall('p000e0473')) break p000e0473;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0473;
			if (!CNDnoun1(156)) break p000e0473;
 		}
		if (!CNDnoun2(224)) break p000e0473;
		if (!CNDeq(97,3)) break p000e0473;
		if (!CNDat(29)) break p000e0473;
 		ACCwrite(591);
 		ACCplace(23,254);
 		ACClet(97,1);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA DISCO
	p000e0474:
	{
 		if (skipdoall('p000e0474')) break p000e0474;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0474;
			if (!CNDnoun1(154)) break p000e0474;
 		}
		if (!CNDnoun2(224)) break p000e0474;
		if (!CNDnoteq(97,2)) break p000e0474;
		if (!CNDat(29)) break p000e0474;
 		ACCwrite(592);
 		ACCplace(22,254);
 		ACClet(97,1);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA DISCO
	p000e0475:
	{
 		if (skipdoall('p000e0475')) break p000e0475;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0475;
			if (!CNDnoun1(154)) break p000e0475;
 		}
		if (!CNDnoun2(224)) break p000e0475;
		if (!CNDeq(97,2)) break p000e0475;
		if (!CNDat(29)) break p000e0475;
 		ACCwrite(593);
 		ACCplace(22,254);
 		ACClet(97,1);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA _
	p000e0476:
	{
 		if (skipdoall('p000e0476')) break p000e0476;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0476;
 		}
		if (!CNDnoun2(224)) break p000e0476;
		if (!CNDat(29)) break p000e0476;
 		ACCwrite(594);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA _
	p000e0477:
	{
 		if (skipdoall('p000e0477')) break p000e0477;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0477;
 		}
		if (!CNDnoun2(224)) break p000e0477;
		if (!CNDat(29)) break p000e0477;
		if (!CNDeq(97,0)) break p000e0477;
 		ACCwrite(595);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA DISCO
	p000e0478:
	{
 		if (skipdoall('p000e0478')) break p000e0478;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0478;
			if (!CNDnoun1(154)) break p000e0478;
 		}
		if (!CNDnoun2(224)) break p000e0478;
		if (!CNDat(29)) break p000e0478;
		if (!CNDnotcarr(22)) break p000e0478;
 		ACCwrite(596);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA DISCO
	p000e0479:
	{
 		if (skipdoall('p000e0479')) break p000e0479;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0479;
			if (!CNDnoun1(154)) break p000e0479;
 		}
		if (!CNDnoun2(224)) break p000e0479;
		if (!CNDat(29)) break p000e0479;
		if (!CNDcarried(22)) break p000e0479;
		if (!CNDeq(97,3)) break p000e0479;
 		ACClet(97,2);
 		ACCdestroy(22);
 		ACCwrite(597);
 		ACCplace(23,254);
 		ACCwrite(598);
 		ACCwrite(599);
 		ACCwrite(600);
 		ACCwrite(601);
 		ACCwrite(602);
 		ACCwrite(603);
 		ACCwrite(604);
 		ACCwrite(605);
 		ACCwrite(606);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA DISCO
	p000e0480:
	{
 		if (skipdoall('p000e0480')) break p000e0480;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0480;
			if (!CNDnoun1(154)) break p000e0480;
 		}
		if (!CNDnoun2(224)) break p000e0480;
		if (!CNDat(29)) break p000e0480;
		if (!CNDcarried(22)) break p000e0480;
		if (!CNDeq(97,1)) break p000e0480;
 		ACClet(97,2);
 		ACCdestroy(22);
 		ACCwrite(607);
 		ACCwrite(608);
 		ACCwrite(609);
 		ACCwrite(610);
 		ACCwrite(611);
 		ACCwrite(612);
 		ACCwrite(613);
 		ACCwrite(614);
 		ACCwrite(615);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA CD
	p000e0481:
	{
 		if (skipdoall('p000e0481')) break p000e0481;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0481;
			if (!CNDnoun1(156)) break p000e0481;
 		}
		if (!CNDnoun2(224)) break p000e0481;
		if (!CNDat(29)) break p000e0481;
		if (!CNDnotcarr(23)) break p000e0481;
 		ACCwrite(616);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA CD
	p000e0482:
	{
 		if (skipdoall('p000e0482')) break p000e0482;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0482;
			if (!CNDnoun1(156)) break p000e0482;
 		}
		if (!CNDnoun2(224)) break p000e0482;
		if (!CNDat(29)) break p000e0482;
		if (!CNDcarried(23)) break p000e0482;
		if (!CNDeq(97,2)) break p000e0482;
 		ACCdestroy(23);
 		ACCwrite(617);
 		ACCplace(22,254);
 		ACCwrite(618);
 		ACCwrite(619);
 		ACCwrite(620);
 		ACClet(97,3);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA CD
	p000e0483:
	{
 		if (skipdoall('p000e0483')) break p000e0483;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0483;
			if (!CNDnoun1(156)) break p000e0483;
 		}
		if (!CNDnoun2(224)) break p000e0483;
		if (!CNDat(29)) break p000e0483;
		if (!CNDcarried(23)) break p000e0483;
		if (!CNDeq(97,1)) break p000e0483;
 		ACCdestroy(23);
 		ACCwrite(621);
 		ACCwrite(622);
 		ACCwrite(623);
 		ACClet(97,3);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA CD
	p000e0484:
	{
 		if (skipdoall('p000e0484')) break p000e0484;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0484;
			if (!CNDnoun1(156)) break p000e0484;
 		}
		if (!CNDat(29)) break p000e0484;
 		ACCwrite(624);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA DISCO
	p000e0485:
	{
 		if (skipdoall('p000e0485')) break p000e0485;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0485;
			if (!CNDnoun1(154)) break p000e0485;
 		}
		if (!CNDat(29)) break p000e0485;
 		ACCwrite(625);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA CD
	p000e0486:
	{
 		if (skipdoall('p000e0486')) break p000e0486;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0486;
			if (!CNDnoun1(156)) break p000e0486;
 		}
		if (!CNDcarried(23)) break p000e0486;
		if (!CNDeq(44,255)) break p000e0486;
 		ACCwrite(626);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA DISCO
	p000e0487:
	{
 		if (skipdoall('p000e0487')) break p000e0487;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0487;
			if (!CNDnoun1(154)) break p000e0487;
 		}
		if (!CNDcarried(22)) break p000e0487;
		if (!CNDeq(44,255)) break p000e0487;
 		ACCwrite(627);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA CD
	p000e0488:
	{
 		if (skipdoall('p000e0488')) break p000e0488;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0488;
			if (!CNDnoun1(156)) break p000e0488;
 		}
		if (!CNDnoun2(224)) break p000e0488;
		if (!CNDat(30)) break p000e0488;
		if (!CNDcarried(23)) break p000e0488;
		if (!CNDnotzero(121)) break p000e0488;
 		ACCwrite(628);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA DISCO
	p000e0489:
	{
 		if (skipdoall('p000e0489')) break p000e0489;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0489;
			if (!CNDnoun1(154)) break p000e0489;
 		}
		if (!CNDnoun2(224)) break p000e0489;
		if (!CNDat(30)) break p000e0489;
		if (!CNDcarried(22)) break p000e0489;
		if (!CNDnotzero(121)) break p000e0489;
 		ACCwrite(629);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// EX DISCO
	p000e0490:
	{
 		if (skipdoall('p000e0490')) break p000e0490;
 		if (in_response)
		{
			if (!CNDverb(30)) break p000e0490;
			if (!CNDnoun1(154)) break p000e0490;
 		}
		if (!CNDpresent(22)) break p000e0490;
 		ACCwrite(630);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// EX DISCO
	p000e0491:
	{
 		if (skipdoall('p000e0491')) break p000e0491;
 		if (in_response)
		{
			if (!CNDverb(30)) break p000e0491;
			if (!CNDnoun1(154)) break p000e0491;
 		}
		if (!CNDat(5)) break p000e0491;
		if (!CNDisat(22,6)) break p000e0491;
 		ACCwrite(631);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENCENDER COMPUTADOR
	p000e0492:
	{
 		if (skipdoall('p000e0492')) break p000e0492;
 		if (in_response)
		{
			if (!CNDverb(44)) break p000e0492;
			if (!CNDnoun1(224)) break p000e0492;
 		}
		if (!CNDat(29)) break p000e0492;
		if (!CNDeq(97,0)) break p000e0492;
 		ACCwrite(632);
 		ACClet(97,1);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENCENDER COMPUTADOR
	p000e0493:
	{
 		if (skipdoall('p000e0493')) break p000e0493;
 		if (in_response)
		{
			if (!CNDverb(44)) break p000e0493;
			if (!CNDnoun1(224)) break p000e0493;
 		}
		if (!CNDat(29)) break p000e0493;
		if (!CNDnoteq(97,0)) break p000e0493;
 		ACCwrite(633);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// APAGA COMPUTADOR
	p000e0494:
	{
 		if (skipdoall('p000e0494')) break p000e0494;
 		if (in_response)
		{
			if (!CNDverb(45)) break p000e0494;
			if (!CNDnoun1(224)) break p000e0494;
 		}
		if (!CNDat(29)) break p000e0494;
		if (!CNDeq(97,1)) break p000e0494;
 		ACCwrite(634);
 		ACCclear(97);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// APAGA COMPUTADOR
	p000e0495:
	{
 		if (skipdoall('p000e0495')) break p000e0495;
 		if (in_response)
		{
			if (!CNDverb(45)) break p000e0495;
			if (!CNDnoun1(224)) break p000e0495;
 		}
		if (!CNDat(29)) break p000e0495;
		if (!CNDeq(97,2)) break p000e0495;
 		ACCwrite(635);
 		ACCplace(22,254);
 		ACCclear(97);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// APAGA COMPUTADOR
	p000e0496:
	{
 		if (skipdoall('p000e0496')) break p000e0496;
 		if (in_response)
		{
			if (!CNDverb(45)) break p000e0496;
			if (!CNDnoun1(224)) break p000e0496;
 		}
		if (!CNDat(29)) break p000e0496;
		if (!CNDeq(97,3)) break p000e0496;
 		ACCwrite(636);
 		ACCclear(97);
 		ACCplace(23,254);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// APAGA COMPUTADOR
	p000e0497:
	{
 		if (skipdoall('p000e0497')) break p000e0497;
 		if (in_response)
		{
			if (!CNDverb(45)) break p000e0497;
			if (!CNDnoun1(224)) break p000e0497;
 		}
		if (!CNDat(29)) break p000e0497;
		if (!CNDzero(97)) break p000e0497;
 		ACCwrite(637);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE LIBROS
	p000e0498:
	{
 		if (skipdoall('p000e0498')) break p000e0498;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0498;
			if (!CNDnoun1(54)) break p000e0498;
 		}
		if (!CNDat(29)) break p000e0498;
 		ACCwrite(638);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE CASETES
	p000e0499:
	{
 		if (skipdoall('p000e0499')) break p000e0499;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0499;
			if (!CNDnoun1(153)) break p000e0499;
 		}
		if (!CNDat(29)) break p000e0499;
 		ACCwrite(639);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE HERRAMIENT
	p000e0500:
	{
 		if (skipdoall('p000e0500')) break p000e0500;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0500;
			if (!CNDnoun1(152)) break p000e0500;
 		}
		if (!CNDat(29)) break p000e0500;
 		ACCwrite(640);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE ROPA
	p000e0501:
	{
 		if (skipdoall('p000e0501')) break p000e0501;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0501;
			if (!CNDnoun1(60)) break p000e0501;
 		}
		if (!CNDat(29)) break p000e0501;
 		ACCwrite(641);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE COMPUTADOR
	p000e0502:
	{
 		if (skipdoall('p000e0502')) break p000e0502;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0502;
			if (!CNDnoun1(224)) break p000e0502;
 		}
		if (!CNDat(29)) break p000e0502;
 		ACCwrite(642);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE MONITOR
	p000e0503:
	{
 		if (skipdoall('p000e0503')) break p000e0503;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0503;
			if (!CNDnoun1(157)) break p000e0503;
 		}
		if (!CNDat(29)) break p000e0503;
 		ACCwrite(643);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE CPU
	p000e0504:
	{
 		if (skipdoall('p000e0504')) break p000e0504;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0504;
			if (!CNDnoun1(159)) break p000e0504;
 		}
		if (!CNDat(29)) break p000e0504;
 		ACCwrite(644);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE TECLADO
	p000e0505:
	{
 		if (skipdoall('p000e0505')) break p000e0505;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0505;
			if (!CNDnoun1(158)) break p000e0505;
 		}
		if (!CNDat(29)) break p000e0505;
 		ACCwrite(645);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LEE DIARIO
	p000e0506:
	{
 		if (skipdoall('p000e0506')) break p000e0506;
 		if (in_response)
		{
			if (!CNDverb(32)) break p000e0506;
			if (!CNDnoun1(51)) break p000e0506;
 		}
		if (!CNDnotcarr(21)) break p000e0506;
 		ACCwrite(646);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LEE DIARIO
	p000e0507:
	{
 		if (skipdoall('p000e0507')) break p000e0507;
 		if (in_response)
		{
			if (!CNDverb(32)) break p000e0507;
			if (!CNDnoun1(51)) break p000e0507;
 		}
		if (!CNDcarried(21)) break p000e0507;
 		ACCwrite(647);
 		ACCwrite(648);
 		ACCwrite(649);
 		ACCwrite(650);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE PUERTA
	p000e0508:
	{
 		if (skipdoall('p000e0508')) break p000e0508;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0508;
			if (!CNDnoun1(69)) break p000e0508;
 		}
		if (!CNDat(29)) break p000e0508;
 		ACCwrite(651);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR PUERTA
	p000e0509:
	{
 		if (skipdoall('p000e0509')) break p000e0509;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0509;
			if (!CNDnoun1(69)) break p000e0509;
 		}
		if (!CNDat(29)) break p000e0509;
 		ACCwrite(652);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE ALFOMBRA
	p000e0510:
	{
 		if (skipdoall('p000e0510')) break p000e0510;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0510;
			if (!CNDnoun1(150)) break p000e0510;
 		}
		if (!CNDat(28)) break p000e0510;
 		ACCwrite(653);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ELEVA ALFOMBRA
	p000e0511:
	{
 		if (skipdoall('p000e0511')) break p000e0511;
 		if (in_response)
		{
			if (!CNDverb(47)) break p000e0511;
			if (!CNDnoun1(150)) break p000e0511;
 		}
		if (!CNDat(28)) break p000e0511;
		if (!CNDnotzero(94)) break p000e0511;
 		ACCwrite(654);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ELEVA ALFOMBRA
	p000e0512:
	{
 		if (skipdoall('p000e0512')) break p000e0512;
 		if (in_response)
		{
			if (!CNDverb(47)) break p000e0512;
			if (!CNDnoun1(150)) break p000e0512;
 		}
		if (!CNDat(28)) break p000e0512;
		if (!CNDzero(94)) break p000e0512;
 		ACCwrite(655);
 		ACCcreate(20);
 		ACCset(94);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LEE NOTA
	p000e0513:
	{
 		if (skipdoall('p000e0513')) break p000e0513;
 		if (in_response)
		{
			if (!CNDverb(32)) break p000e0513;
			if (!CNDnoun1(149)) break p000e0513;
 		}
		if (!CNDnotcarr(20)) break p000e0513;
 		ACCwrite(656);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LEE NOTA
	p000e0514:
	{
 		if (skipdoall('p000e0514')) break p000e0514;
 		if (in_response)
		{
			if (!CNDverb(32)) break p000e0514;
			if (!CNDnoun1(149)) break p000e0514;
 		}
		if (!CNDcarried(20)) break p000e0514;
 		ACCwrite(657);
 		ACCwrite(658);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// TOCA ELFOS
	p000e0515:
	{
 		if (skipdoall('p000e0515')) break p000e0515;
 		if (in_response)
		{
			if (!CNDverb(80)) break p000e0515;
			if (!CNDnoun1(147)) break p000e0515;
 		}
		if (!CNDat(28)) break p000e0515;
 		ACCwrite(659);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENTRA _
	p000e0516:
	{
 		if (skipdoall('p000e0516')) break p000e0516;
 		if (in_response)
		{
			if (!CNDverb(50)) break p000e0516;
 		}
		if (!CNDat(28)) break p000e0516;
		if (!CNDzero(93)) break p000e0516;
 		ACCwrite(660);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENTRA _
	p000e0517:
	{
 		if (skipdoall('p000e0517')) break p000e0517;
 		if (in_response)
		{
			if (!CNDverb(50)) break p000e0517;
 		}
		if (!CNDat(28)) break p000e0517;
		if (!CNDnotzero(93)) break p000e0517;
 		ACCgoto(29);
 		ACCdesc();
		break pro000_restart;
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LLAMA PUERTA
	p000e0518:
	{
 		if (skipdoall('p000e0518')) break p000e0518;
 		if (in_response)
		{
			if (!CNDverb(79)) break p000e0518;
			if (!CNDnoun1(69)) break p000e0518;
 		}
		if (!CNDat(28)) break p000e0518;
 		ACCwrite(661);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE PUERTA
	p000e0519:
	{
 		if (skipdoall('p000e0519')) break p000e0519;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0519;
			if (!CNDnoun1(69)) break p000e0519;
 		}
		if (!CNDat(28)) break p000e0519;
		if (!CNDzero(93)) break p000e0519;
 		ACCwrite(662);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR PUERTA
	p000e0520:
	{
 		if (skipdoall('p000e0520')) break p000e0520;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0520;
			if (!CNDnoun1(69)) break p000e0520;
 		}
		if (!CNDat(28)) break p000e0520;
		if (!CNDzero(93)) break p000e0520;
 		ACCwrite(663);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR PUERTA
	p000e0521:
	{
 		if (skipdoall('p000e0521')) break p000e0521;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0521;
			if (!CNDnoun1(69)) break p000e0521;
 		}
		if (!CNDat(28)) break p000e0521;
		if (!CNDnotzero(93)) break p000e0521;
 		ACCwrite(664);
 		ACCclear(93);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// EMPUJA PUERTA
	p000e0522:
	{
 		if (skipdoall('p000e0522')) break p000e0522;
 		if (in_response)
		{
			if (!CNDverb(36)) break p000e0522;
			if (!CNDnoun1(69)) break p000e0522;
 		}
		if (!CNDat(28)) break p000e0522;
		if (!CNDzero(93)) break p000e0522;
 		ACCwrite(665);
 		ACCset(93);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// GOLPEA PUERTA
	p000e0523:
	{
 		if (skipdoall('p000e0523')) break p000e0523;
 		if (in_response)
		{
			if (!CNDverb(63)) break p000e0523;
			if (!CNDnoun1(69)) break p000e0523;
 		}
		if (!CNDat(28)) break p000e0523;
		if (!CNDzero(93)) break p000e0523;
 		ACCwrite(666);
 		ACCset(93);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// EMPUJA PUERTA
	p000e0524:
	{
 		if (skipdoall('p000e0524')) break p000e0524;
 		if (in_response)
		{
			if (!CNDverb(36)) break p000e0524;
			if (!CNDnoun1(69)) break p000e0524;
 		}
		if (!CNDat(28)) break p000e0524;
		if (!CNDnotzero(93)) break p000e0524;
 		ACCwrite(667);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// GOLPEA PUERTA
	p000e0525:
	{
 		if (skipdoall('p000e0525')) break p000e0525;
 		if (in_response)
		{
			if (!CNDverb(63)) break p000e0525;
			if (!CNDnoun1(69)) break p000e0525;
 		}
		if (!CNDat(28)) break p000e0525;
		if (!CNDnotzero(93)) break p000e0525;
 		ACCwrite(668);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LLENA _
	p000e0526:
	{
 		if (skipdoall('p000e0526')) break p000e0526;
 		if (in_response)
		{
			if (!CNDverb(71)) break p000e0526;
 		}
		if (!CNDat(28)) break p000e0526;
 		ACCwrite(669);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// BEBE _
	p000e0527:
	{
 		if (skipdoall('p000e0527')) break p000e0527;
 		if (in_response)
		{
			if (!CNDverb(68)) break p000e0527;
 		}
		if (!CNDat(28)) break p000e0527;
 		ACCwrite(670);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// TREPA VALLA
	p000e0528:
	{
 		if (skipdoall('p000e0528')) break p000e0528;
 		if (in_response)
		{
			if (!CNDverb(55)) break p000e0528;
			if (!CNDnoun1(145)) break p000e0528;
 		}
		if (!CNDat(26)) break p000e0528;
 		ACCwrite(671);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE PUERTA
	p000e0529:
	{
 		if (skipdoall('p000e0529')) break p000e0529;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0529;
			if (!CNDnoun1(69)) break p000e0529;
 		}
		if (!CNDat(26)) break p000e0529;
 		ACCwrite(672);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE VALLA
	p000e0530:
	{
 		if (skipdoall('p000e0530')) break p000e0530;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0530;
			if (!CNDnoun1(145)) break p000e0530;
 		}
		if (!CNDat(26)) break p000e0530;
 		ACCwrite(673);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR PUERTA
	p000e0531:
	{
 		if (skipdoall('p000e0531')) break p000e0531;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0531;
			if (!CNDnoun1(69)) break p000e0531;
 		}
		if (!CNDat(26)) break p000e0531;
 		ACCwrite(674);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR PUERTAS
	p000e0532:
	{
 		if (skipdoall('p000e0532')) break p000e0532;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0532;
			if (!CNDnoun1(215)) break p000e0532;
 		}
		if (!CNDat(26)) break p000e0532;
 		ACCwrite(675);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR VALLA
	p000e0533:
	{
 		if (skipdoall('p000e0533')) break p000e0533;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0533;
			if (!CNDnoun1(145)) break p000e0533;
 		}
		if (!CNDat(26)) break p000e0533;
 		ACCwrite(676);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENTRA _
	p000e0534:
	{
 		if (skipdoall('p000e0534')) break p000e0534;
 		if (in_response)
		{
			if (!CNDverb(50)) break p000e0534;
 		}
		if (!CNDat(26)) break p000e0534;
 		ACCgoto(27);
 		ACCdesc();
		break pro000_restart;
		{}

	}

	// COGE TAXI
	p000e0535:
	{
 		if (skipdoall('p000e0535')) break p000e0535;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0535;
			if (!CNDnoun1(194)) break p000e0535;
 		}
		if (!CNDat(25)) break p000e0535;
 		ACCwrite(677);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SUBE TAXI
	p000e0536:
	{
 		if (skipdoall('p000e0536')) break p000e0536;
 		if (in_response)
		{
			if (!CNDverb(10)) break p000e0536;
			if (!CNDnoun1(194)) break p000e0536;
 		}
		if (!CNDat(25)) break p000e0536;
 		ACCwrite(678);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE SEMAFORO
	p000e0537:
	{
 		if (skipdoall('p000e0537')) break p000e0537;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0537;
			if (!CNDnoun1(144)) break p000e0537;
 		}
		if (!CNDat(25)) break p000e0537;
 		ACCwrite(679);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SUBE SEMAFORO
	p000e0538:
	{
 		if (skipdoall('p000e0538')) break p000e0538;
 		if (in_response)
		{
			if (!CNDverb(10)) break p000e0538;
			if (!CNDnoun1(144)) break p000e0538;
 		}
		if (!CNDat(25)) break p000e0538;
 		ACCwrite(680);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// TREPA SEMAFORO
	p000e0539:
	{
 		if (skipdoall('p000e0539')) break p000e0539;
 		if (in_response)
		{
			if (!CNDverb(55)) break p000e0539;
			if (!CNDnoun1(144)) break p000e0539;
 		}
		if (!CNDat(25)) break p000e0539;
 		ACCwrite(681);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DECIR GENTE
	p000e0540:
	{
 		if (skipdoall('p000e0540')) break p000e0540;
 		if (in_response)
		{
			if (!CNDverb(31)) break p000e0540;
			if (!CNDnoun1(140)) break p000e0540;
 		}
		if (!CNDat(25)) break p000e0540;
 		ACCwrite(682);
 		ACCdone();
		break pro000_restart;
		{}

	}

	//  _
	p000e0541:
	{
 		if (skipdoall('p000e0541')) break p000e0541;
 		if (in_response)
		{
			if (!CNDverb(5)) break p000e0541;
 		}
		if (!CNDat(26)) break p000e0541;
 		ACCwrite(683);
 		ACCanykey();
 		function anykey00125() 
		{
 		ACCgoto(25);
 		ACCdesc();
		return;
 		ACCdone();
		return;
		}
 		waitKey(anykey00125);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// CRUZA _
	p000e0542:
	{
 		if (skipdoall('p000e0542')) break p000e0542;
 		if (in_response)
		{
			if (!CNDverb(88)) break p000e0542;
 		}
		if (!CNDat(26)) break p000e0542;
 		ACCwrite(684);
 		ACCanykey();
 		function anykey00126() 
		{
 		ACCgoto(25);
 		ACCdesc();
		return;
 		ACCdone();
		return;
		}
 		waitKey(anykey00126);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// CRUZA CALLE
	p000e0543:
	{
 		if (skipdoall('p000e0543')) break p000e0543;
 		if (in_response)
		{
			if (!CNDverb(88)) break p000e0543;
			if (!CNDnoun1(141)) break p000e0543;
 		}
		if (!CNDat(26)) break p000e0543;
 		ACCwrite(685);
 		ACCanykey();
 		function anykey00127() 
		{
 		ACCgoto(25);
 		ACCdesc();
		return;
 		ACCdone();
		return;
		}
 		waitKey(anykey00127);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// CRUZA CALLE
	p000e0544:
	{
 		if (skipdoall('p000e0544')) break p000e0544;
 		if (in_response)
		{
			if (!CNDverb(88)) break p000e0544;
			if (!CNDnoun1(141)) break p000e0544;
 		}
		if (!CNDat(25)) break p000e0544;
		if (!CNDeq(91,0)) break p000e0544;
 		ACCwrite(686);
 		ACCwrite(687);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CRUZA CALLE
	p000e0545:
	{
 		if (skipdoall('p000e0545')) break p000e0545;
 		if (in_response)
		{
			if (!CNDverb(88)) break p000e0545;
			if (!CNDnoun1(141)) break p000e0545;
 		}
		if (!CNDat(25)) break p000e0545;
		if (!CNDeq(91,1)) break p000e0545;
 		ACCwrite(688);
 		ACCanykey();
 		function anykey00128() 
		{
 		ACCgoto(26);
 		ACCdesc();
		return;
		}
 		waitKey(anykey00128);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// CRUZA _
	p000e0546:
	{
 		if (skipdoall('p000e0546')) break p000e0546;
 		if (in_response)
		{
			if (!CNDverb(88)) break p000e0546;
 		}
		if (!CNDat(25)) break p000e0546;
		if (!CNDeq(91,0)) break p000e0546;
 		ACCwrite(689);
 		ACCwrite(690);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CRUZA _
	p000e0547:
	{
 		if (skipdoall('p000e0547')) break p000e0547;
 		if (in_response)
		{
			if (!CNDverb(88)) break p000e0547;
 		}
		if (!CNDat(25)) break p000e0547;
		if (!CNDeq(91,1)) break p000e0547;
 		ACCwrite(691);
 		ACCanykey();
 		function anykey00129() 
		{
 		ACCgoto(26);
 		ACCdesc();
		return;
		}
 		waitKey(anykey00129);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// APRETAR BOTON
	p000e0548:
	{
 		if (skipdoall('p000e0548')) break p000e0548;
 		if (in_response)
		{
			if (!CNDverb(87)) break p000e0548;
			if (!CNDnoun1(142)) break p000e0548;
 		}
		if (!CNDat(25)) break p000e0548;
		if (!CNDeq(91,0)) break p000e0548;
		if (!CNDeq(92,0)) break p000e0548;
 		ACClet(92,1);
 		ACClet(5,4);
 		ACCwrite(692);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// APRETAR BOTON
	p000e0549:
	{
 		if (skipdoall('p000e0549')) break p000e0549;
 		if (in_response)
		{
			if (!CNDverb(87)) break p000e0549;
			if (!CNDnoun1(142)) break p000e0549;
 		}
		if (!CNDat(25)) break p000e0549;
		if (!CNDeq(91,0)) break p000e0549;
		if (!CNDeq(92,1)) break p000e0549;
 		ACCwrite(693);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// APRETAR BOTON
	p000e0550:
	{
 		if (skipdoall('p000e0550')) break p000e0550;
 		if (in_response)
		{
			if (!CNDverb(87)) break p000e0550;
			if (!CNDnoun1(142)) break p000e0550;
 		}
		if (!CNDat(25)) break p000e0550;
		if (!CNDeq(91,1)) break p000e0550;
 		ACCwrite(694);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// EMPUJA BOTON
	p000e0551:
	{
 		if (skipdoall('p000e0551')) break p000e0551;
 		if (in_response)
		{
			if (!CNDverb(36)) break p000e0551;
			if (!CNDnoun1(142)) break p000e0551;
 		}
		if (!CNDat(25)) break p000e0551;
 		ACCwrite(695);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LEE AVISO
	p000e0552:
	{
 		if (skipdoall('p000e0552')) break p000e0552;
 		if (in_response)
		{
			if (!CNDverb(32)) break p000e0552;
			if (!CNDnoun1(143)) break p000e0552;
 		}
		if (!CNDat(25)) break p000e0552;
 		ACCwrite(696);
 		ACCdone();
		break pro000_restart;
		{}

	}

	//  _
	p000e0553:
	{
 		if (skipdoall('p000e0553')) break p000e0553;
 		if (in_response)
		{
			if (!CNDverb(3)) break p000e0553;
 		}
		if (!CNDat(25)) break p000e0553;
 		ACCwrite(697);
 		ACCdone();
		break pro000_restart;
		{}

	}

	//  _
	p000e0554:
	{
 		if (skipdoall('p000e0554')) break p000e0554;
 		if (in_response)
		{
			if (!CNDverb(4)) break p000e0554;
 		}
		if (!CNDat(25)) break p000e0554;
 		ACCwrite(698);
 		ACCdone();
		break pro000_restart;
		{}

	}

	//  _
	p000e0555:
	{
 		if (skipdoall('p000e0555')) break p000e0555;
 		if (in_response)
		{
			if (!CNDverb(5)) break p000e0555;
 		}
		if (!CNDat(25)) break p000e0555;
 		ACCwrite(699);
 		ACCdone();
		break pro000_restart;
		{}

	}

	//  _
	p000e0556:
	{
 		if (skipdoall('p000e0556')) break p000e0556;
 		if (in_response)
		{
			if (!CNDverb(6)) break p000e0556;
 		}
		if (!CNDat(25)) break p000e0556;
 		ACCwrite(700);
 		ACCdone();
		break pro000_restart;
		{}

	}

	//  _
	p000e0557:
	{
 		if (skipdoall('p000e0557')) break p000e0557;
 		if (in_response)
		{
			if (!CNDverb(7)) break p000e0557;
 		}
		if (!CNDat(25)) break p000e0557;
 		ACCwrite(701);
 		ACCdone();
		break pro000_restart;
		{}

	}

	//  _
	p000e0558:
	{
 		if (skipdoall('p000e0558')) break p000e0558;
 		if (in_response)
		{
			if (!CNDverb(8)) break p000e0558;
 		}
		if (!CNDat(25)) break p000e0558;
 		ACCwrite(702);
 		ACCdone();
		break pro000_restart;
		{}

	}

	//  _
	p000e0559:
	{
 		if (skipdoall('p000e0559')) break p000e0559;
 		if (in_response)
		{
			if (!CNDverb(9)) break p000e0559;
 		}
		if (!CNDat(25)) break p000e0559;
 		ACCwrite(703);
 		ACCdone();
		break pro000_restart;
		{}

	}

	//  _
	p000e0560:
	{
 		if (skipdoall('p000e0560')) break p000e0560;
 		if (in_response)
		{
			if (!CNDverb(3)) break p000e0560;
 		}
		if (!CNDat(24)) break p000e0560;
		if (!CNDeq(84,1)) break p000e0560;
 		ACCwrite(704);
 		ACCclear(84);
 		ACCwrite(705);
 		ACCanykey();
 		function anykey00130() 
		{
 		ACCgoto(25);
 		ACCdesc();
		return;
 		ACCdone();
		return;
		}
 		waitKey(anykey00130);
		done_flag=true;
		break pro000_restart;
		{}

	}

	//  _
	p000e0561:
	{
 		if (skipdoall('p000e0561')) break p000e0561;
 		if (in_response)
		{
			if (!CNDverb(3)) break p000e0561;
 		}
		if (!CNDat(24)) break p000e0561;
		if (!CNDnoteq(84,1)) break p000e0561;
 		ACCgoto(25);
 		ACCdesc();
		break pro000_restart;
 		ACCdone();
		break pro000_restart;
		{}

	}

	//  _
	p000e0562:
	{
 		if (skipdoall('p000e0562')) break p000e0562;
 		if (in_response)
		{
			if (!CNDverb(2)) break p000e0562;
 		}
		if (!CNDat(14)) break p000e0562;
		if (!CNDnoteq(84,1)) break p000e0562;
 		ACCwrite(706);
 		ACClet(86,10);
 		ACCanykey();
 		function anykey00131() 
		{
 		ACCgoto(10);
 		ACCdesc();
		return;
		}
 		waitKey(anykey00131);
		done_flag=true;
		break pro000_restart;
		{}

	}

	//  _
	p000e0563:
	{
 		if (skipdoall('p000e0563')) break p000e0563;
 		if (in_response)
		{
			if (!CNDverb(2)) break p000e0563;
 		}
		if (!CNDat(14)) break p000e0563;
		if (!CNDeq(84,1)) break p000e0563;
 		ACCgoto(10);
 		ACCdesc();
		break pro000_restart;
		{}

	}

	// COGE MAGICOS
	p000e0564:
	{
 		if (skipdoall('p000e0564')) break p000e0564;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0564;
			if (!CNDnoun1(61)) break p000e0564;
 		}
		if (!CNDat(18)) break p000e0564;
		if (!CNDnotzero(87)) break p000e0564;
 		ACCwrite(707);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE PUERTA
	p000e0565:
	{
 		if (skipdoall('p000e0565')) break p000e0565;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0565;
			if (!CNDnoun1(69)) break p000e0565;
 		}
		if (!CNDat(18)) break p000e0565;
		if (!CNDnotzero(87)) break p000e0565;
 		ACCwrite(708);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE PUERTA
	p000e0566:
	{
 		if (skipdoall('p000e0566')) break p000e0566;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0566;
			if (!CNDnoun1(69)) break p000e0566;
 		}
		if (!CNDat(18)) break p000e0566;
		if (!CNDzero(87)) break p000e0566;
 		ACCwrite(709);
 		ACCanykey();
 		function anykey00132() 
		{
 		ACCwrite(710);
 		ACClet(87,1);
		entry_for_doall = 'p000e0567';
		process_in_doall = 0;
 		ACCdoall(22);
		return;
		}
 		waitKey(anykey00132);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// _ _
	p000e0567:
	{
 		if (skipdoall('p000e0567')) break p000e0567;
		if (!CNDeq(87,1)) break p000e0567;
 		ACCplace(getFlag(51),18);
 		ACCwrite(711);
		{}

	}

	// _ _
	p000e0568:
	{
 		if (skipdoall('p000e0568')) break p000e0568;
		if (!CNDeq(87,1)) break p000e0568;
 		ACCobjat(22,73);
		if (!CNDnotzero(73)) break p000e0568;
 		ACCdone();
		break pro000_restart;
		{}

	}

	// _ _
	p000e0569:
	{
 		if (skipdoall('p000e0569')) break p000e0569;
		if (!CNDeq(87,1)) break p000e0569;
 		ACCobjat(22,73);
		if (!CNDzero(73)) break p000e0569;
 		ACClet(87,2);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR PUERTA
	p000e0570:
	{
 		if (skipdoall('p000e0570')) break p000e0570;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0570;
			if (!CNDnoun1(69)) break p000e0570;
 		}
		if (!CNDat(18)) break p000e0570;
		if (!CNDzero(87)) break p000e0570;
 		ACCwrite(712);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR PUERTA
	p000e0571:
	{
 		if (skipdoall('p000e0571')) break p000e0571;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0571;
			if (!CNDnoun1(69)) break p000e0571;
 		}
		if (!CNDat(18)) break p000e0571;
		if (!CNDnotzero(87)) break p000e0571;
 		ACCwrite(713);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENTRA _
	p000e0572:
	{
 		if (skipdoall('p000e0572')) break p000e0572;
 		if (in_response)
		{
			if (!CNDverb(50)) break p000e0572;
 		}
		if (!CNDat(18)) break p000e0572;
		if (!CNDzero(87)) break p000e0572;
 		ACCwrite(714);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENTRA _
	p000e0573:
	{
 		if (skipdoall('p000e0573')) break p000e0573;
 		if (in_response)
		{
			if (!CNDverb(50)) break p000e0573;
 		}
		if (!CNDat(18)) break p000e0573;
		if (!CNDnotzero(87)) break p000e0573;
 		ACCwrite(715);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE ROCA
	p000e0574:
	{
 		if (skipdoall('p000e0574')) break p000e0574;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0574;
			if (!CNDnoun1(130)) break p000e0574;
 		}
		if (!CNDatgt(14)) break p000e0574;
		if (!CNDatlt(18)) break p000e0574;
 		ACCwrite(716);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE ROCA
	p000e0575:
	{
 		if (skipdoall('p000e0575')) break p000e0575;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0575;
			if (!CNDnoun1(130)) break p000e0575;
 		}
		if (!CNDatgt(18)) break p000e0575;
		if (!CNDatlt(23)) break p000e0575;
 		ACCwrite(717);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// AYUDA _
	p000e0576:
	{
 		if (skipdoall('p000e0576')) break p000e0576;
 		if (in_response)
		{
			if (!CNDverb(39)) break p000e0576;
 		}
		if (!CNDatgt(14)) break p000e0576;
		if (!CNDatlt(18)) break p000e0576;
 		ACCwrite(718);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// AYUDA _
	p000e0577:
	{
 		if (skipdoall('p000e0577')) break p000e0577;
 		if (in_response)
		{
			if (!CNDverb(39)) break p000e0577;
 		}
		if (!CNDatgt(18)) break p000e0577;
		if (!CNDatlt(23)) break p000e0577;
 		ACCwrite(719);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENTRA CASETA
	p000e0578:
	{
 		if (skipdoall('p000e0578')) break p000e0578;
 		if (in_response)
		{
			if (!CNDverb(50)) break p000e0578;
			if (!CNDnoun1(129)) break p000e0578;
 		}
		if (!CNDat(11)) break p000e0578;
 		ACCwrite(720);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE CASETA
	p000e0579:
	{
 		if (skipdoall('p000e0579')) break p000e0579;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0579;
			if (!CNDnoun1(129)) break p000e0579;
 		}
		if (!CNDat(11)) break p000e0579;
 		ACCwrite(721);
 		ACCdone();
		break pro000_restart;
		{}

	}

	//  _
	p000e0580:
	{
 		if (skipdoall('p000e0580')) break p000e0580;
 		if (in_response)
		{
			if (!CNDverb(2)) break p000e0580;
 		}
		if (!CNDat(5)) break p000e0580;
		if (!CNDeq(71,1)) break p000e0580;
 		ACCwrite(722);
 		ACCdone();
		break pro000_restart;
		{}

	}

	//  _
	p000e0581:
	{
 		if (skipdoall('p000e0581')) break p000e0581;
 		if (in_response)
		{
			if (!CNDverb(3)) break p000e0581;
 		}
		if (!CNDat(5)) break p000e0581;
		if (!CNDeq(71,1)) break p000e0581;
 		ACCwrite(723);
 		ACCdone();
		break pro000_restart;
		{}

	}

	//  _
	p000e0582:
	{
 		if (skipdoall('p000e0582')) break p000e0582;
 		if (in_response)
		{
			if (!CNDverb(4)) break p000e0582;
 		}
		if (!CNDat(5)) break p000e0582;
		if (!CNDeq(71,1)) break p000e0582;
 		ACCwrite(724);
 		ACCdone();
		break pro000_restart;
		{}

	}

	//  _
	p000e0583:
	{
 		if (skipdoall('p000e0583')) break p000e0583;
 		if (in_response)
		{
			if (!CNDverb(5)) break p000e0583;
 		}
		if (!CNDat(5)) break p000e0583;
		if (!CNDeq(71,1)) break p000e0583;
 		ACCwrite(725);
 		ACCdone();
		break pro000_restart;
		{}

	}

	//  _
	p000e0584:
	{
 		if (skipdoall('p000e0584')) break p000e0584;
 		if (in_response)
		{
			if (!CNDverb(2)) break p000e0584;
 		}
		if (!CNDat(5)) break p000e0584;
		if (!CNDcarried(8)) break p000e0584;
 		ACCwrite(726);
 		ACCplace(8,5);
 		ACCanykey();
 		function anykey00133() 
		{
 		ACCgoto(8);
 		ACCdesc();
		return;
		}
 		waitKey(anykey00133);
		done_flag=true;
		break pro000_restart;
		{}

	}

	//  _
	p000e0585:
	{
 		if (skipdoall('p000e0585')) break p000e0585;
 		if (in_response)
		{
			if (!CNDverb(3)) break p000e0585;
 		}
		if (!CNDat(5)) break p000e0585;
		if (!CNDcarried(8)) break p000e0585;
 		ACCwrite(727);
 		ACCplace(8,5);
 		ACCanykey();
 		function anykey00134() 
		{
 		ACCgoto(10);
 		ACCdesc();
		return;
		}
 		waitKey(anykey00134);
		done_flag=true;
		break pro000_restart;
		{}

	}

	//  _
	p000e0586:
	{
 		if (skipdoall('p000e0586')) break p000e0586;
 		if (in_response)
		{
			if (!CNDverb(4)) break p000e0586;
 		}
		if (!CNDat(5)) break p000e0586;
		if (!CNDcarried(8)) break p000e0586;
 		ACCwrite(728);
 		ACCplace(8,5);
 		ACCanykey();
 		function anykey00135() 
		{
 		ACCgoto(9);
 		ACCdesc();
		return;
		}
 		waitKey(anykey00135);
		done_flag=true;
		break pro000_restart;
		{}

	}

	//  _
	p000e0587:
	{
 		if (skipdoall('p000e0587')) break p000e0587;
 		if (in_response)
		{
			if (!CNDverb(5)) break p000e0587;
 		}
		if (!CNDat(5)) break p000e0587;
		if (!CNDcarried(8)) break p000e0587;
 		ACCwrite(729);
 		ACCplace(8,5);
 		ACCanykey();
 		function anykey00136() 
		{
 		ACCgoto(11);
 		ACCdesc();
		return;
		}
 		waitKey(anykey00136);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// SUBE _
	p000e0588:
	{
 		if (skipdoall('p000e0588')) break p000e0588;
 		if (in_response)
		{
			if (!CNDverb(10)) break p000e0588;
 		}
		if (!CNDat(5)) break p000e0588;
		if (!CNDeq(84,1)) break p000e0588;
 		ACCwrite(730);
 		ACClet(84,0);
		{}

	}

	// SUBE CAJON
	p000e0589:
	{
 		if (skipdoall('p000e0589')) break p000e0589;
 		if (in_response)
		{
			if (!CNDverb(10)) break p000e0589;
			if (!CNDnoun1(88)) break p000e0589;
 		}
		if (!CNDat(5)) break p000e0589;
		if (!CNDeq(84,1)) break p000e0589;
 		ACCwrite(731);
 		ACClet(84,0);
		{}

	}

	// ENTRA _
	p000e0590:
	{
 		if (skipdoall('p000e0590')) break p000e0590;
 		if (in_response)
		{
			if (!CNDverb(50)) break p000e0590;
 		}
		if (!CNDat(9)) break p000e0590;
		if (!CNDeq(84,1)) break p000e0590;
 		ACCwrite(732);
 		ACCanykey();
 		function anykey00137() 
		{
 		ACClet(84,0);
		}
 		waitKey(anykey00137);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// ENTRA _
	p000e0591:
	{
 		if (skipdoall('p000e0591')) break p000e0591;
 		if (in_response)
		{
			if (!CNDverb(50)) break p000e0591;
 		}
		if (!CNDat(8)) break p000e0591;
		if (!CNDeq(84,1)) break p000e0591;
 		ACCwrite(733);
 		ACCanykey();
 		function anykey00138() 
		{
 		ACClet(84,0);
		}
 		waitKey(anykey00138);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// DECIR BM
	p000e0592:
	{
 		if (skipdoall('p000e0592')) break p000e0592;
 		if (in_response)
		{
			if (!CNDverb(31)) break p000e0592;
			if (!CNDnoun1(23)) break p000e0592;
 		}
		if (!CNDeq(85,1)) break p000e0592;
		if (!CNDsame(38,86)) break p000e0592;
 		ACCwrite(734);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ACARICIA BM
	p000e0593:
	{
 		if (skipdoall('p000e0593')) break p000e0593;
 		if (in_response)
		{
			if (!CNDverb(82)) break p000e0593;
			if (!CNDnoun1(23)) break p000e0593;
 		}
		if (!CNDeq(85,1)) break p000e0593;
		if (!CNDsame(38,86)) break p000e0593;
 		ACCwrite(735);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// MONTA BM
	p000e0594:
	{
 		if (skipdoall('p000e0594')) break p000e0594;
 		if (in_response)
		{
			if (!CNDverb(56)) break p000e0594;
			if (!CNDnoun1(23)) break p000e0594;
 		}
		if (!CNDeq(84,1)) break p000e0594;
 		ACCwrite(736);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// MONTA BM
	p000e0595:
	{
 		if (skipdoall('p000e0595')) break p000e0595;
 		if (in_response)
		{
			if (!CNDverb(56)) break p000e0595;
			if (!CNDnoun1(23)) break p000e0595;
 		}
		if (!CNDeq(85,1)) break p000e0595;
		if (!CNDsame(38,86)) break p000e0595;
		if (!CNDat(5)) break p000e0595;
		if (!CNDeq(71,1)) break p000e0595;
 		ACCwrite(737);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SUBE BM
	p000e0596:
	{
 		if (skipdoall('p000e0596')) break p000e0596;
 		if (in_response)
		{
			if (!CNDverb(10)) break p000e0596;
			if (!CNDnoun1(23)) break p000e0596;
 		}
		if (!CNDeq(84,1)) break p000e0596;
 		ACCwrite(738);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SUBE BM
	p000e0597:
	{
 		if (skipdoall('p000e0597')) break p000e0597;
 		if (in_response)
		{
			if (!CNDverb(10)) break p000e0597;
			if (!CNDnoun1(23)) break p000e0597;
 		}
		if (!CNDeq(85,1)) break p000e0597;
		if (!CNDsame(38,86)) break p000e0597;
		if (!CNDat(5)) break p000e0597;
		if (!CNDeq(71,1)) break p000e0597;
 		ACCwrite(739);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// MONTA _
	p000e0598:
	{
 		if (skipdoall('p000e0598')) break p000e0598;
 		if (in_response)
		{
			if (!CNDverb(56)) break p000e0598;
 		}
		if (!CNDeq(85,1)) break p000e0598;
		if (!CNDsame(38,86)) break p000e0598;
 		ACCwrite(740);
 		ACClet(84,1);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// MONTA BM
	p000e0599:
	{
 		if (skipdoall('p000e0599')) break p000e0599;
 		if (in_response)
		{
			if (!CNDverb(56)) break p000e0599;
			if (!CNDnoun1(23)) break p000e0599;
 		}
		if (!CNDeq(85,1)) break p000e0599;
		if (!CNDsame(38,86)) break p000e0599;
 		ACCwrite(741);
 		ACClet(84,1);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SUBE BM
	p000e0600:
	{
 		if (skipdoall('p000e0600')) break p000e0600;
 		if (in_response)
		{
			if (!CNDverb(10)) break p000e0600;
			if (!CNDnoun1(23)) break p000e0600;
 		}
		if (!CNDeq(85,1)) break p000e0600;
		if (!CNDsame(38,86)) break p000e0600;
 		ACCwrite(742);
 		ACClet(84,1);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DESMONTA BM
	p000e0601:
	{
 		if (skipdoall('p000e0601')) break p000e0601;
 		if (in_response)
		{
			if (!CNDverb(86)) break p000e0601;
			if (!CNDnoun1(23)) break p000e0601;
 		}
		if (!CNDeq(84,1)) break p000e0601;
 		ACCwrite(743);
 		ACClet(84,0);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// BAJA BM
	p000e0602:
	{
 		if (skipdoall('p000e0602')) break p000e0602;
 		if (in_response)
		{
			if (!CNDverb(11)) break p000e0602;
			if (!CNDnoun1(23)) break p000e0602;
 		}
		if (!CNDeq(84,1)) break p000e0602;
 		ACCwrite(744);
 		ACClet(84,0);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DESMONTA _
	p000e0603:
	{
 		if (skipdoall('p000e0603')) break p000e0603;
 		if (in_response)
		{
			if (!CNDverb(86)) break p000e0603;
 		}
		if (!CNDeq(84,1)) break p000e0603;
 		ACCwrite(745);
 		ACClet(84,0);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DECIR BM
	p000e0604:
	{
 		if (skipdoall('p000e0604')) break p000e0604;
 		if (in_response)
		{
			if (!CNDverb(31)) break p000e0604;
			if (!CNDnoun1(23)) break p000e0604;
 		}
		if (!CNDat(11)) break p000e0604;
		if (!CNDzero(85)) break p000e0604;
 		ACCwrite(746);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ACARICIA BM
	p000e0605:
	{
 		if (skipdoall('p000e0605')) break p000e0605;
 		if (in_response)
		{
			if (!CNDverb(82)) break p000e0605;
			if (!CNDnoun1(23)) break p000e0605;
 		}
		if (!CNDat(11)) break p000e0605;
		if (!CNDzero(85)) break p000e0605;
 		ACCwrite(747);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// MONTA BM
	p000e0606:
	{
 		if (skipdoall('p000e0606')) break p000e0606;
 		if (in_response)
		{
			if (!CNDverb(56)) break p000e0606;
			if (!CNDnoun1(23)) break p000e0606;
 		}
		if (!CNDat(11)) break p000e0606;
		if (!CNDzero(85)) break p000e0606;
 		ACCwrite(748);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DA SALCHICHA
	p000e0607:
	{
 		if (skipdoall('p000e0607')) break p000e0607;
 		if (in_response)
		{
			if (!CNDverb(75)) break p000e0607;
			if (!CNDnoun1(127)) break p000e0607;
 		}
		if (!CNDnoun2(23)) break p000e0607;
		if (!CNDnotcarr(17)) break p000e0607;
		if (!CNDnotcarr(18)) break p000e0607;
		if (!CNDat(11)) break p000e0607;
		if (!CNDzero(85)) break p000e0607;
 		ACCwrite(749);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DA SALCHICHA
	p000e0608:
	{
 		if (skipdoall('p000e0608')) break p000e0608;
 		if (in_response)
		{
			if (!CNDverb(75)) break p000e0608;
			if (!CNDnoun1(127)) break p000e0608;
 		}
		if (!CNDnoun2(23)) break p000e0608;
		if (!CNDcarried(17)) break p000e0608;
		if (!CNDat(11)) break p000e0608;
		if (!CNDzero(85)) break p000e0608;
 		ACCwrite(750);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DA ELEXIR
	p000e0609:
	{
 		if (skipdoall('p000e0609')) break p000e0609;
 		if (in_response)
		{
			if (!CNDverb(75)) break p000e0609;
			if (!CNDnoun1(103)) break p000e0609;
 		}
		if (!CNDnoun2(23)) break p000e0609;
		if (!CNDat(11)) break p000e0609;
		if (!CNDzero(85)) break p000e0609;
 		ACCwrite(751);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DA SALCHICHA
	p000e0610:
	{
 		if (skipdoall('p000e0610')) break p000e0610;
 		if (in_response)
		{
			if (!CNDverb(75)) break p000e0610;
			if (!CNDnoun1(127)) break p000e0610;
 		}
		if (!CNDnoun2(23)) break p000e0610;
		if (!CNDat(11)) break p000e0610;
		if (!CNDzero(85)) break p000e0610;
		if (!CNDcarried(18)) break p000e0610;
 		ACCwrite(752);
 		ACCanykey();
 		function anykey00140() 
		{
 		ACCwrite(754);
 		ACClet(85,1);
 		ACClet(86,11);
 		ACCdestroy(18);
 		ACCdone();
		return;
		}
 		function anykey00139() 
		{
 		ACCwrite(753);
 		ACCanykey();
 		waitKey(anykey00140);
		}
 		waitKey(anykey00139);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// DA _
	p000e0611:
	{
 		if (skipdoall('p000e0611')) break p000e0611;
 		if (in_response)
		{
			if (!CNDverb(75)) break p000e0611;
 		}
		if (!CNDnoun2(23)) break p000e0611;
		if (!CNDat(11)) break p000e0611;
		if (!CNDzero(85)) break p000e0611;
 		ACCwhatox(11);
		if (!CNDnoteq(11,255)) break p000e0611;
		if (!CNDcarried(getFlag(11))) break p000e0611;
 		ACCwrite(755);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DA _
	p000e0612:
	{
 		if (skipdoall('p000e0612')) break p000e0612;
 		if (in_response)
		{
			if (!CNDverb(75)) break p000e0612;
 		}
		if (!CNDnoun2(23)) break p000e0612;
		if (!CNDat(11)) break p000e0612;
		if (!CNDzero(85)) break p000e0612;
 		ACCwhatox(11);
		if (!CNDnoteq(11,255)) break p000e0612;
		if (!CNDnotcarr(getFlag(11))) break p000e0612;
 		ACCwrite(756);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ECHA ELEXIR
	p000e0613:
	{
 		if (skipdoall('p000e0613')) break p000e0613;
 		if (in_response)
		{
			if (!CNDverb(67)) break p000e0613;
			if (!CNDnoun1(103)) break p000e0613;
 		}
		if (!CNDnoun2(127)) break p000e0613;
		if (!CNDnotcarr(13)) break p000e0613;
 		ACCwrite(757);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ECHA ELEXIR
	p000e0614:
	{
 		if (skipdoall('p000e0614')) break p000e0614;
 		if (in_response)
		{
			if (!CNDverb(67)) break p000e0614;
			if (!CNDnoun1(103)) break p000e0614;
 		}
		if (!CNDnoun2(127)) break p000e0614;
		if (!CNDcarried(13)) break p000e0614;
		if (!CNDabsent(17)) break p000e0614;
 		ACCwrite(758);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ECHA ELEXIR
	p000e0615:
	{
 		if (skipdoall('p000e0615')) break p000e0615;
 		if (in_response)
		{
			if (!CNDverb(67)) break p000e0615;
			if (!CNDnoun1(103)) break p000e0615;
 		}
		if (!CNDnoun2(127)) break p000e0615;
		if (!CNDcarried(13)) break p000e0615;
		if (!CNDpresent(17)) break p000e0615;
		if (!CNDozero(13,33)) break p000e0615;
 		ACCwrite(759);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ECHA ELEXIR
	p000e0616:
	{
 		if (skipdoall('p000e0616')) break p000e0616;
 		if (in_response)
		{
			if (!CNDverb(67)) break p000e0616;
			if (!CNDnoun1(103)) break p000e0616;
 		}
		if (!CNDnoun2(127)) break p000e0616;
		if (!CNDcarried(13)) break p000e0616;
		if (!CNDpresent(17)) break p000e0616;
		if (!CNDonotzero(13,33)) break p000e0616;
 		ACCwrite(760);
 		ACCwrite(761);
 		ACCdestroy(13);
 		ACCswap(17,18);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ECHA ELEXIR
	p000e0617:
	{
 		if (skipdoall('p000e0617')) break p000e0617;
 		if (in_response)
		{
			if (!CNDverb(67)) break p000e0617;
			if (!CNDnoun1(103)) break p000e0617;
 		}
		if (!CNDnoun2(127)) break p000e0617;
		if (!CNDnotcarr(13)) break p000e0617;
 		ACCwrite(762);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ECHA ELEXIR
	p000e0618:
	{
 		if (skipdoall('p000e0618')) break p000e0618;
 		if (in_response)
		{
			if (!CNDverb(67)) break p000e0618;
			if (!CNDnoun1(103)) break p000e0618;
 		}
		if (!CNDnoun2(127)) break p000e0618;
		if (!CNDcarried(13)) break p000e0618;
		if (!CNDabsent(17)) break p000e0618;
 		ACCwrite(763);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ECHA ELEXIR
	p000e0619:
	{
 		if (skipdoall('p000e0619')) break p000e0619;
 		if (in_response)
		{
			if (!CNDverb(67)) break p000e0619;
			if (!CNDnoun1(103)) break p000e0619;
 		}
		if (!CNDnoun2(127)) break p000e0619;
		if (!CNDcarried(13)) break p000e0619;
		if (!CNDpresent(17)) break p000e0619;
		if (!CNDozero(13,33)) break p000e0619;
 		ACCwrite(764);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ECHA ELEXIR
	p000e0620:
	{
 		if (skipdoall('p000e0620')) break p000e0620;
 		if (in_response)
		{
			if (!CNDverb(67)) break p000e0620;
			if (!CNDnoun1(103)) break p000e0620;
 		}
		if (!CNDnoun2(127)) break p000e0620;
		if (!CNDcarried(13)) break p000e0620;
		if (!CNDpresent(17)) break p000e0620;
		if (!CNDonotzero(13,33)) break p000e0620;
 		ACCwrite(765);
 		ACCwrite(766);
 		ACCdestroy(13);
 		ACCswap(17,18);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ECHA LIQUIDO
	p000e0621:
	{
 		if (skipdoall('p000e0621')) break p000e0621;
 		if (in_response)
		{
			if (!CNDverb(67)) break p000e0621;
			if (!CNDnoun1(105)) break p000e0621;
 		}
		if (!CNDnoun2(127)) break p000e0621;
		if (!CNDnotcarr(13)) break p000e0621;
 		ACCwrite(767);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ECHA LIQUIDO
	p000e0622:
	{
 		if (skipdoall('p000e0622')) break p000e0622;
 		if (in_response)
		{
			if (!CNDverb(67)) break p000e0622;
			if (!CNDnoun1(105)) break p000e0622;
 		}
		if (!CNDnoun2(127)) break p000e0622;
		if (!CNDcarried(13)) break p000e0622;
		if (!CNDabsent(17)) break p000e0622;
 		ACCwrite(768);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ECHA LIQUIDO
	p000e0623:
	{
 		if (skipdoall('p000e0623')) break p000e0623;
 		if (in_response)
		{
			if (!CNDverb(67)) break p000e0623;
			if (!CNDnoun1(105)) break p000e0623;
 		}
		if (!CNDnoun2(127)) break p000e0623;
		if (!CNDcarried(13)) break p000e0623;
		if (!CNDpresent(17)) break p000e0623;
		if (!CNDozero(13,33)) break p000e0623;
 		ACCwrite(769);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ECHA LIQUIDO
	p000e0624:
	{
 		if (skipdoall('p000e0624')) break p000e0624;
 		if (in_response)
		{
			if (!CNDverb(67)) break p000e0624;
			if (!CNDnoun1(105)) break p000e0624;
 		}
		if (!CNDnoun2(127)) break p000e0624;
		if (!CNDcarried(13)) break p000e0624;
		if (!CNDpresent(17)) break p000e0624;
		if (!CNDonotzero(13,33)) break p000e0624;
 		ACCwrite(770);
 		ACCwrite(771);
 		ACCdestroy(13);
 		ACCswap(17,18);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// MOJA SALCHICHA
	p000e0625:
	{
 		if (skipdoall('p000e0625')) break p000e0625;
 		if (in_response)
		{
			if (!CNDverb(85)) break p000e0625;
			if (!CNDnoun1(127)) break p000e0625;
 		}
		if (!CNDnoun2(105)) break p000e0625;
 		ACClet(44,103);
		{}

	}

	// MOJA SALCHICHA
	p000e0626:
	{
 		if (skipdoall('p000e0626')) break p000e0626;
 		if (in_response)
		{
			if (!CNDverb(85)) break p000e0626;
			if (!CNDnoun1(127)) break p000e0626;
 		}
		if (!CNDnoun2(103)) break p000e0626;
		if (!CNDnotcarr(13)) break p000e0626;
 		ACCwrite(772);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// MOJA SALCHICHA
	p000e0627:
	{
 		if (skipdoall('p000e0627')) break p000e0627;
 		if (in_response)
		{
			if (!CNDverb(85)) break p000e0627;
			if (!CNDnoun1(127)) break p000e0627;
 		}
		if (!CNDnoun2(103)) break p000e0627;
		if (!CNDcarried(13)) break p000e0627;
		if (!CNDabsent(17)) break p000e0627;
 		ACCwrite(773);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// MOJA SALCHICHA
	p000e0628:
	{
 		if (skipdoall('p000e0628')) break p000e0628;
 		if (in_response)
		{
			if (!CNDverb(85)) break p000e0628;
			if (!CNDnoun1(127)) break p000e0628;
 		}
		if (!CNDnoun2(103)) break p000e0628;
		if (!CNDcarried(13)) break p000e0628;
		if (!CNDpresent(17)) break p000e0628;
		if (!CNDozero(13,33)) break p000e0628;
 		ACCwrite(774);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// MOJA SALCHICHA
	p000e0629:
	{
 		if (skipdoall('p000e0629')) break p000e0629;
 		if (in_response)
		{
			if (!CNDverb(85)) break p000e0629;
			if (!CNDnoun1(127)) break p000e0629;
 		}
		if (!CNDnoun2(103)) break p000e0629;
		if (!CNDcarried(13)) break p000e0629;
		if (!CNDpresent(17)) break p000e0629;
		if (!CNDonotzero(13,33)) break p000e0629;
 		ACCwrite(775);
 		ACCwrite(776);
 		ACCdestroy(13);
 		ACCswap(17,18);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ECHA ELEXIR
	p000e0630:
	{
 		if (skipdoall('p000e0630')) break p000e0630;
 		if (in_response)
		{
			if (!CNDverb(67)) break p000e0630;
			if (!CNDnoun1(103)) break p000e0630;
 		}
		if (!CNDprep(13)) break p000e0630;
 		ACCwrite(777);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ECHA ELEXIR
	p000e0631:
	{
 		if (skipdoall('p000e0631')) break p000e0631;
 		if (in_response)
		{
			if (!CNDverb(67)) break p000e0631;
			if (!CNDnoun1(103)) break p000e0631;
 		}
		if (!CNDprep(13)) break p000e0631;
 		ACCwrite(778);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE MESILLA
	p000e0632:
	{
 		if (skipdoall('p000e0632')) break p000e0632;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0632;
			if (!CNDnoun1(123)) break p000e0632;
 		}
		if (!CNDat(13)) break p000e0632;
 		ACCwrite(779);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// HUELE FLOR
	p000e0633:
	{
 		if (skipdoall('p000e0633')) break p000e0633;
 		if (in_response)
		{
			if (!CNDverb(72)) break p000e0633;
			if (!CNDnoun1(126)) break p000e0633;
 		}
		if (!CNDpresent(16)) break p000e0633;
 		ACCwrite(780);
 		ACCwrite(781);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COME SALCHICHA
	p000e0634:
	{
 		if (skipdoall('p000e0634')) break p000e0634;
 		if (in_response)
		{
			if (!CNDverb(81)) break p000e0634;
			if (!CNDnoun1(127)) break p000e0634;
 		}
		if (!CNDpresent(17)) break p000e0634;
 		ACCwrite(782);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COME SALCHICHA
	p000e0635:
	{
 		if (skipdoall('p000e0635')) break p000e0635;
 		if (in_response)
		{
			if (!CNDverb(81)) break p000e0635;
			if (!CNDnoun1(127)) break p000e0635;
 		}
		if (!CNDpresent(18)) break p000e0635;
 		ACCwrite(783);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COME PIMIENTA
	p000e0636:
	{
 		if (skipdoall('p000e0636')) break p000e0636;
 		if (in_response)
		{
			if (!CNDverb(81)) break p000e0636;
			if (!CNDnoun1(114)) break p000e0636;
 		}
		if (!CNDpresent(15)) break p000e0636;
 		ACCwrite(784);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COME ARENQUE
	p000e0637:
	{
 		if (skipdoall('p000e0637')) break p000e0637;
 		if (in_response)
		{
			if (!CNDverb(81)) break p000e0637;
			if (!CNDnoun1(86)) break p000e0637;
 		}
		if (!CNDpresent(7)) break p000e0637;
 		ACCwrite(785);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE FLOR
	p000e0638:
	{
 		if (skipdoall('p000e0638')) break p000e0638;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0638;
			if (!CNDnoun1(126)) break p000e0638;
 		}
		if (!CNDat(13)) break p000e0638;
		if (!CNDeq(83,0)) break p000e0638;
 		ACCwrite(786);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE FLOR
	p000e0639:
	{
 		if (skipdoall('p000e0639')) break p000e0639;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0639;
			if (!CNDnoun1(126)) break p000e0639;
 		}
		if (!CNDat(13)) break p000e0639;
		if (!CNDeq(83,1)) break p000e0639;
 		ACCwrite(787);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DESPERTAR NINFA
	p000e0640:
	{
 		if (skipdoall('p000e0640')) break p000e0640;
 		if (in_response)
		{
			if (!CNDverb(83)) break p000e0640;
			if (!CNDnoun1(21)) break p000e0640;
 		}
		if (!CNDat(13)) break p000e0640;
 		ACCwrite(788);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE NINFA
	p000e0641:
	{
 		if (skipdoall('p000e0641')) break p000e0641;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0641;
			if (!CNDnoun1(21)) break p000e0641;
 		}
		if (!CNDat(13)) break p000e0641;
 		ACCwrite(789);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DECIR NINFA
	p000e0642:
	{
 		if (skipdoall('p000e0642')) break p000e0642;
 		if (in_response)
		{
			if (!CNDverb(31)) break p000e0642;
			if (!CNDnoun1(21)) break p000e0642;
 		}
		if (!CNDat(13)) break p000e0642;
 		ACCwrite(790);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// BESA NINFA
	p000e0643:
	{
 		if (skipdoall('p000e0643')) break p000e0643;
 		if (in_response)
		{
			if (!CNDverb(84)) break p000e0643;
			if (!CNDnoun1(21)) break p000e0643;
 		}
		if (!CNDat(13)) break p000e0643;
 		ACCwrite(791);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// MATA NINFA
	p000e0644:
	{
 		if (skipdoall('p000e0644')) break p000e0644;
 		if (in_response)
		{
			if (!CNDverb(77)) break p000e0644;
			if (!CNDnoun1(21)) break p000e0644;
 		}
		if (!CNDat(13)) break p000e0644;
 		ACCwrite(792);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// EMPUJA NINFA
	p000e0645:
	{
 		if (skipdoall('p000e0645')) break p000e0645;
 		if (in_response)
		{
			if (!CNDverb(36)) break p000e0645;
			if (!CNDnoun1(21)) break p000e0645;
 		}
		if (!CNDat(13)) break p000e0645;
 		ACCwrite(793);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE MAGICOS
	p000e0646:
	{
 		if (skipdoall('p000e0646')) break p000e0646;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0646;
			if (!CNDnoun1(61)) break p000e0646;
 		}
		if (!CNDat(13)) break p000e0646;
 		ACCwrite(794);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE FOTO
	p000e0647:
	{
 		if (skipdoall('p000e0647')) break p000e0647;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0647;
			if (!CNDnoun1(55)) break p000e0647;
 		}
		if (!CNDat(13)) break p000e0647;
 		ACCwrite(795);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// HUELE _
	p000e0648:
	{
 		if (skipdoall('p000e0648')) break p000e0648;
 		if (in_response)
		{
			if (!CNDverb(72)) break p000e0648;
 		}
		if (!CNDat(13)) break p000e0648;
 		ACCwrite(796);
 		ACCanykey();
 		function anykey00141() 
		{
 		ACCwrite(797);
 		ACCdone();
		return;
		}
 		waitKey(anykey00141);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// ABRE COFRE
	p000e0649:
	{
 		if (skipdoall('p000e0649')) break p000e0649;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0649;
			if (!CNDnoun1(22)) break p000e0649;
 		}
		if (!CNDat(13)) break p000e0649;
		if (!CNDeq(80,0)) break p000e0649;
 		ACCwrite(798);
 		ACCanykey();
 		function anykey00142() 
		{
 		ACCwrite(799);
 		ACCplus(80,1);
 		ACCdone();
		return;
		}
 		waitKey(anykey00142);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// ABRE COFRE
	p000e0650:
	{
 		if (skipdoall('p000e0650')) break p000e0650;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0650;
			if (!CNDnoun1(22)) break p000e0650;
 		}
		if (!CNDat(13)) break p000e0650;
		if (!CNDeq(80,1)) break p000e0650;
 		ACCwrite(800);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE COFRE
	p000e0651:
	{
 		if (skipdoall('p000e0651')) break p000e0651;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0651;
			if (!CNDnoun1(22)) break p000e0651;
 		}
		if (!CNDat(13)) break p000e0651;
		if (!CNDeq(80,0)) break p000e0651;
 		ACCwrite(801);
 		ACCanykey();
 		function anykey00143() 
		{
 		ACCwrite(802);
 		ACCplus(80,1);
 		ACCdone();
		return;
		}
 		waitKey(anykey00143);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// MATA COFRE
	p000e0652:
	{
 		if (skipdoall('p000e0652')) break p000e0652;
 		if (in_response)
		{
			if (!CNDverb(77)) break p000e0652;
			if (!CNDnoun1(22)) break p000e0652;
 		}
		if (!CNDat(13)) break p000e0652;
		if (!CNDeq(80,1)) break p000e0652;
 		ACCwrite(803);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DECIR COFRE
	p000e0653:
	{
 		if (skipdoall('p000e0653')) break p000e0653;
 		if (in_response)
		{
			if (!CNDverb(31)) break p000e0653;
			if (!CNDnoun1(22)) break p000e0653;
 		}
		if (!CNDat(13)) break p000e0653;
		if (!CNDeq(80,1)) break p000e0653;
 		ACCwrite(804);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ACARICIA COFRE
	p000e0654:
	{
 		if (skipdoall('p000e0654')) break p000e0654;
 		if (in_response)
		{
			if (!CNDverb(82)) break p000e0654;
			if (!CNDnoun1(22)) break p000e0654;
 		}
		if (!CNDat(13)) break p000e0654;
		if (!CNDeq(80,0)) break p000e0654;
 		ACCwrite(805);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ACARICIA COFRE
	p000e0655:
	{
 		if (skipdoall('p000e0655')) break p000e0655;
 		if (in_response)
		{
			if (!CNDverb(82)) break p000e0655;
			if (!CNDnoun1(22)) break p000e0655;
 		}
		if (!CNDat(13)) break p000e0655;
		if (!CNDeq(80,1)) break p000e0655;
		if (!CNDeq(81,0)) break p000e0655;
 		ACCwrite(806);
 		ACCwrite(807);
 		ACClet(81,1);
 		ACClet(80,0);
 		ACCcreate(13);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ACARICIA COFRE
	p000e0656:
	{
 		if (skipdoall('p000e0656')) break p000e0656;
 		if (in_response)
		{
			if (!CNDverb(82)) break p000e0656;
			if (!CNDnoun1(22)) break p000e0656;
 		}
		if (!CNDat(13)) break p000e0656;
		if (!CNDeq(80,1)) break p000e0656;
		if (!CNDeq(81,1)) break p000e0656;
 		ACCwrite(808);
 		ACClet(80,0);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE COFRE
	p000e0657:
	{
 		if (skipdoall('p000e0657')) break p000e0657;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0657;
			if (!CNDnoun1(22)) break p000e0657;
 		}
		if (!CNDat(13)) break p000e0657;
		if (!CNDeq(80,1)) break p000e0657;
 		ACCwrite(809);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA _
	p000e0658:
	{
 		if (skipdoall('p000e0658')) break p000e0658;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0658;
 		}
		if (!CNDnoun2(22)) break p000e0658;
		if (!CNDat(13)) break p000e0658;
		if (!CNDeq(80,0)) break p000e0658;
 		ACCwrite(810);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA _
	p000e0659:
	{
 		if (skipdoall('p000e0659')) break p000e0659;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0659;
 		}
		if (!CNDnoun2(22)) break p000e0659;
		if (!CNDat(13)) break p000e0659;
		if (!CNDeq(80,1)) break p000e0659;
 		ACCwrite(811);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DA PIMIENTA
	p000e0660:
	{
 		if (skipdoall('p000e0660')) break p000e0660;
 		if (in_response)
		{
			if (!CNDverb(75)) break p000e0660;
			if (!CNDnoun1(114)) break p000e0660;
 		}
		if (!CNDnoun2(22)) break p000e0660;
		if (!CNDat(13)) break p000e0660;
		if (!CNDeq(80,1)) break p000e0660;
		if (!CNDcarried(15)) break p000e0660;
 		ACCwrite(812);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DA _
	p000e0661:
	{
 		if (skipdoall('p000e0661')) break p000e0661;
 		if (in_response)
		{
			if (!CNDverb(75)) break p000e0661;
 		}
		if (!CNDnoun2(22)) break p000e0661;
		if (!CNDat(13)) break p000e0661;
		if (!CNDeq(80,1)) break p000e0661;
 		ACCwhatox(11);
		if (!CNDnoteq(11,255)) break p000e0661;
		if (!CNDcarried(getFlag(11))) break p000e0661;
 		ACCwrite(813);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DA _
	p000e0662:
	{
 		if (skipdoall('p000e0662')) break p000e0662;
 		if (in_response)
		{
			if (!CNDverb(75)) break p000e0662;
 		}
		if (!CNDnoun2(22)) break p000e0662;
		if (!CNDat(13)) break p000e0662;
		if (!CNDeq(80,1)) break p000e0662;
 		ACCwhatox(11);
		if (!CNDnoteq(11,255)) break p000e0662;
		if (!CNDnotcarr(getFlag(11))) break p000e0662;
 		ACCwrite(814);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR PUERTA
	p000e0663:
	{
 		if (skipdoall('p000e0663')) break p000e0663;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0663;
			if (!CNDnoun1(69)) break p000e0663;
 		}
		if (!CNDat(13)) break p000e0663;
 		ACCwrite(815);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE PUERTA
	p000e0664:
	{
 		if (skipdoall('p000e0664')) break p000e0664;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0664;
			if (!CNDnoun1(69)) break p000e0664;
 		}
		if (!CNDat(13)) break p000e0664;
 		ACCwrite(816);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENTRA _
	p000e0665:
	{
 		if (skipdoall('p000e0665')) break p000e0665;
 		if (in_response)
		{
			if (!CNDverb(50)) break p000e0665;
 		}
		if (!CNDat(9)) break p000e0665;
		if (!CNDzero(79)) break p000e0665;
 		ACCwrite(817);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENTRA _
	p000e0666:
	{
 		if (skipdoall('p000e0666')) break p000e0666;
 		if (in_response)
		{
			if (!CNDverb(50)) break p000e0666;
 		}
		if (!CNDat(9)) break p000e0666;
		if (!CNDnotzero(79)) break p000e0666;
 		ACCwrite(818);
 		ACCanykey();
 		function anykey00144() 
		{
 		ACCgoto(13);
 		ACCdesc();
		return;
		}
 		waitKey(anykey00144);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// ABRE PUERTA
	p000e0667:
	{
 		if (skipdoall('p000e0667')) break p000e0667;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0667;
			if (!CNDnoun1(69)) break p000e0667;
 		}
		if (!CNDat(9)) break p000e0667;
		if (!CNDnotzero(79)) break p000e0667;
 		ACCwrite(819);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR PUERTA
	p000e0668:
	{
 		if (skipdoall('p000e0668')) break p000e0668;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0668;
			if (!CNDnoun1(69)) break p000e0668;
 		}
		if (!CNDat(9)) break p000e0668;
		if (!CNDzero(79)) break p000e0668;
 		ACCwrite(820);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE PUERTA
	p000e0669:
	{
 		if (skipdoall('p000e0669')) break p000e0669;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0669;
			if (!CNDnoun1(69)) break p000e0669;
 		}
		if (!CNDat(9)) break p000e0669;
		if (!CNDzero(79)) break p000e0669;
		if (!CNDnotcarr(4)) break p000e0669;
 		ACCwrite(821);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE PUERTA
	p000e0670:
	{
 		if (skipdoall('p000e0670')) break p000e0670;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0670;
			if (!CNDnoun1(69)) break p000e0670;
 		}
		if (!CNDat(9)) break p000e0670;
		if (!CNDzero(79)) break p000e0670;
		if (!CNDcarried(4)) break p000e0670;
 		ACCwrite(822);
 		ACCplus(79,1);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR PUERTA
	p000e0671:
	{
 		if (skipdoall('p000e0671')) break p000e0671;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0671;
			if (!CNDnoun1(69)) break p000e0671;
 		}
		if (!CNDat(9)) break p000e0671;
		if (!CNDcarried(4)) break p000e0671;
		if (!CNDnotzero(79)) break p000e0671;
 		ACCwrite(823);
 		ACCclear(79);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR PUERTA
	p000e0672:
	{
 		if (skipdoall('p000e0672')) break p000e0672;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0672;
			if (!CNDnoun1(69)) break p000e0672;
 		}
		if (!CNDat(9)) break p000e0672;
		if (!CNDnotzero(79)) break p000e0672;
		if (!CNDnotcarr(4)) break p000e0672;
 		ACCwrite(824);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LLAMA PUERTA
	p000e0673:
	{
 		if (skipdoall('p000e0673')) break p000e0673;
 		if (in_response)
		{
			if (!CNDverb(79)) break p000e0673;
			if (!CNDnoun1(69)) break p000e0673;
 		}
		if (!CNDat(9)) break p000e0673;
 		ACCwrite(825);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// TOCA CAMPANA
	p000e0674:
	{
 		if (skipdoall('p000e0674')) break p000e0674;
 		if (in_response)
		{
			if (!CNDverb(80)) break p000e0674;
			if (!CNDnoun1(121)) break p000e0674;
 		}
		if (!CNDat(9)) break p000e0674;
 		ACCwrite(826);
 		ACClet(80,1);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LLAMA CAMPANA
	p000e0675:
	{
 		if (skipdoall('p000e0675')) break p000e0675;
 		if (in_response)
		{
			if (!CNDverb(79)) break p000e0675;
			if (!CNDnoun1(121)) break p000e0675;
 		}
		if (!CNDat(9)) break p000e0675;
 		ACCwrite(827);
 		ACClet(80,1);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// EMPUJA CAMPANA
	p000e0676:
	{
 		if (skipdoall('p000e0676')) break p000e0676;
 		if (in_response)
		{
			if (!CNDverb(36)) break p000e0676;
			if (!CNDnoun1(121)) break p000e0676;
 		}
		if (!CNDat(9)) break p000e0676;
 		ACCwrite(828);
 		ACClet(80,1);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE CAMPANA
	p000e0677:
	{
 		if (skipdoall('p000e0677')) break p000e0677;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0677;
			if (!CNDnoun1(121)) break p000e0677;
 		}
		if (!CNDat(9)) break p000e0677;
 		ACCwrite(829);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE CHAMPINON
	p000e0678:
	{
 		if (skipdoall('p000e0678')) break p000e0678;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0678;
			if (!CNDnoun1(117)) break p000e0678;
 		}
		if (!CNDat(9)) break p000e0678;
 		ACCwrite(830);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CORTA CHAMPINON
	p000e0679:
	{
 		if (skipdoall('p000e0679')) break p000e0679;
 		if (in_response)
		{
			if (!CNDverb(62)) break p000e0679;
			if (!CNDnoun1(117)) break p000e0679;
 		}
		if (!CNDat(9)) break p000e0679;
 		ACCwrite(831);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ARRANCA CHAMPINON
	p000e0680:
	{
 		if (skipdoall('p000e0680')) break p000e0680;
 		if (in_response)
		{
			if (!CNDverb(60)) break p000e0680;
			if (!CNDnoun1(117)) break p000e0680;
 		}
		if (!CNDat(9)) break p000e0680;
 		ACCwrite(832);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COME CHAMPINON
	p000e0681:
	{
 		if (skipdoall('p000e0681')) break p000e0681;
 		if (in_response)
		{
			if (!CNDverb(81)) break p000e0681;
			if (!CNDnoun1(117)) break p000e0681;
 		}
		if (!CNDat(9)) break p000e0681;
 		ACCwrite(833);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE HOJAS
	p000e0682:
	{
 		if (skipdoall('p000e0682')) break p000e0682;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0682;
			if (!CNDnoun1(118)) break p000e0682;
 		}
		if (!CNDat(10)) break p000e0682;
 		ACCwrite(834);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DECIR ARBOLES
	p000e0683:
	{
 		if (skipdoall('p000e0683')) break p000e0683;
 		if (in_response)
		{
			if (!CNDverb(31)) break p000e0683;
			if (!CNDnoun1(84)) break p000e0683;
 		}
		if (!CNDat(9)) break p000e0683;
 		ACCwrite(835);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ESCUCHA ARBOLES
	p000e0684:
	{
 		if (skipdoall('p000e0684')) break p000e0684;
 		if (in_response)
		{
			if (!CNDverb(41)) break p000e0684;
			if (!CNDnoun1(84)) break p000e0684;
 		}
		if (!CNDat(9)) break p000e0684;
 		ACClet(34,255);
		{}

	}

	// ESCUCHA _
	p000e0685:
	{
 		if (skipdoall('p000e0685')) break p000e0685;
 		if (in_response)
		{
			if (!CNDverb(41)) break p000e0685;
 		}
		if (!CNDat(9)) break p000e0685;
		if (!CNDeq(34,255)) break p000e0685;
 		ACCwrite(836);
 		ACCwrite(837);
 		ACCwrite(838);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// MATA PLANTA
	p000e0686:
	{
 		if (skipdoall('p000e0686')) break p000e0686;
 		if (in_response)
		{
			if (!CNDverb(77)) break p000e0686;
			if (!CNDnoun1(28)) break p000e0686;
 		}
		if (!CNDat(3)) break p000e0686;
		if (!CNDeq(78,0)) break p000e0686;
 		ACCwrite(839);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// MATA PLANTA
	p000e0687:
	{
 		if (skipdoall('p000e0687')) break p000e0687;
 		if (in_response)
		{
			if (!CNDverb(77)) break p000e0687;
			if (!CNDnoun1(28)) break p000e0687;
 		}
		if (!CNDat(3)) break p000e0687;
		if (!CNDeq(78,1)) break p000e0687;
 		ACCwrite(840);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// MATA PLANTA
	p000e0688:
	{
 		if (skipdoall('p000e0688')) break p000e0688;
 		if (in_response)
		{
			if (!CNDverb(77)) break p000e0688;
			if (!CNDnoun1(28)) break p000e0688;
 		}
		if (!CNDat(12)) break p000e0688;
		if (!CNDeq(78,2)) break p000e0688;
 		ACCwrite(841);
 		ACCdone();
		break pro000_restart;
		{}

	}

	//  _
	p000e0689:
	{
 		if (skipdoall('p000e0689')) break p000e0689;
 		if (in_response)
		{
			if (!CNDverb(3)) break p000e0689;
 		}
		if (!CNDat(10)) break p000e0689;
		if (!CNDnoteq(76,1)) break p000e0689;
 		ACCwrite(842);
 		ACCdone();
		break pro000_restart;
		{}

	}

	//  _
	p000e0690:
	{
 		if (skipdoall('p000e0690')) break p000e0690;
 		if (in_response)
		{
			if (!CNDverb(3)) break p000e0690;
 		}
		if (!CNDat(10)) break p000e0690;
		if (!CNDeq(76,1)) break p000e0690;
		if (!CNDnoteq(84,1)) break p000e0690;
 		ACCwrite(843);
 		ACCdone();
		break pro000_restart;
		{}

	}

	//  _
	p000e0691:
	{
 		if (skipdoall('p000e0691')) break p000e0691;
 		if (in_response)
		{
			if (!CNDverb(3)) break p000e0691;
 		}
		if (!CNDat(10)) break p000e0691;
		if (!CNDeq(76,1)) break p000e0691;
		if (!CNDeq(84,1)) break p000e0691;
 		ACCgoto(14);
 		ACCdesc();
		break pro000_restart;
		{}

	}

	// DECIR PLANTA
	p000e0692:
	{
 		if (skipdoall('p000e0692')) break p000e0692;
 		if (in_response)
		{
			if (!CNDverb(31)) break p000e0692;
			if (!CNDnoun1(28)) break p000e0692;
 		}
		if (!CNDat(12)) break p000e0692;
		if (!CNDeq(78,2)) break p000e0692;
 		ACCwrite(844);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LANZA _
	p000e0693:
	{
 		if (skipdoall('p000e0693')) break p000e0693;
 		if (in_response)
		{
			if (!CNDverb(76)) break p000e0693;
 		}
		if (!CNDnoun2(28)) break p000e0693;
		if (!CNDat(12)) break p000e0693;
		if (!CNDeq(78,2)) break p000e0693;
 		ACCwrite(845);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LANZA _
	p000e0694:
	{
 		if (skipdoall('p000e0694')) break p000e0694;
 		if (in_response)
		{
			if (!CNDverb(76)) break p000e0694;
 		}
		if (!CNDnoun2(28)) break p000e0694;
		if (!CNDat(3)) break p000e0694;
		if (!CNDeq(78,0)) break p000e0694;
 		ACCwrite(846);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LANZA _
	p000e0695:
	{
 		if (skipdoall('p000e0695')) break p000e0695;
 		if (in_response)
		{
			if (!CNDverb(76)) break p000e0695;
 		}
		if (!CNDnoun2(28)) break p000e0695;
		if (!CNDat(3)) break p000e0695;
		if (!CNDeq(78,1)) break p000e0695;
 		ACCwhato();
		if (!CNDlt(51,255)) break p000e0695;
		if (!CNDnotcarr(getFlag(51))) break p000e0695;
 		ACCwrite(847);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LANZA _
	p000e0696:
	{
 		if (skipdoall('p000e0696')) break p000e0696;
 		if (in_response)
		{
			if (!CNDverb(76)) break p000e0696;
 		}
		if (!CNDnoun2(28)) break p000e0696;
		if (!CNDat(3)) break p000e0696;
		if (!CNDeq(78,1)) break p000e0696;
 		ACCwhato();
		if (!CNDeq(51,255)) break p000e0696;
 		ACCwrite(848);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LANZA CERILLA
	p000e0697:
	{
 		if (skipdoall('p000e0697')) break p000e0697;
 		if (in_response)
		{
			if (!CNDverb(76)) break p000e0697;
			if (!CNDnoun1(74)) break p000e0697;
 		}
		if (!CNDnoun2(28)) break p000e0697;
		if (!CNDat(3)) break p000e0697;
		if (!CNDeq(78,1)) break p000e0697;
		if (!CNDlt(66,4)) break p000e0697;
		if (!CNDgt(66,0)) break p000e0697;
 		ACCwrite(849);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LANZA PIMIENTA
	p000e0698:
	{
 		if (skipdoall('p000e0698')) break p000e0698;
 		if (in_response)
		{
			if (!CNDverb(76)) break p000e0698;
			if (!CNDnoun1(114)) break p000e0698;
 		}
		if (!CNDnoun2(28)) break p000e0698;
		if (!CNDat(3)) break p000e0698;
		if (!CNDeq(78,1)) break p000e0698;
		if (!CNDcarried(15)) break p000e0698;
 		ACCwrite(850);
 		ACCanykey();
 		function anykey00150() 
		{
 		ACCwrite(858);
 		ACClet(78,2);
 		ACCdestroy(15);
 		ACCcreate(9);
 		ACCdone();
		return;
		}
 		function anykey00149() 
		{
 		ACCpicture(3);
 		ACCwrite(857);
 		ACCanykey();
 		waitKey(anykey00150);
		}
 		function anykey00148() 
		{
 		ACCwrite(856);
 		ACCanykey();
 		waitKey(anykey00149);
		}
 		function anykey00147() 
		{
 		ACCwrite(854);
 		ACCwrite(855);
 		ACCanykey();
 		waitKey(anykey00148);
		}
 		function anykey00146() 
		{
 		ACCwrite(852);
 		ACCwrite(853);
 		ACCanykey();
 		waitKey(anykey00147);
		}
 		function anykey00145() 
		{
 		ACCwrite(851);
 		ACCanykey();
 		waitKey(anykey00146);
		}
 		waitKey(anykey00145);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// LANZA ANTORCHA
	p000e0699:
	{
 		if (skipdoall('p000e0699')) break p000e0699;
 		if (in_response)
		{
			if (!CNDverb(76)) break p000e0699;
			if (!CNDnoun1(50)) break p000e0699;
 		}
		if (!CNDnoun2(28)) break p000e0699;
		if (!CNDat(3)) break p000e0699;
		if (!CNDeq(78,1)) break p000e0699;
		if (!CNDcarried(0)) break p000e0699;
 		ACCwrite(859);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LANZA CAPUCHA
	p000e0700:
	{
 		if (skipdoall('p000e0700')) break p000e0700;
 		if (in_response)
		{
			if (!CNDverb(76)) break p000e0700;
			if (!CNDnoun1(52)) break p000e0700;
 		}
		if (!CNDnoun2(28)) break p000e0700;
		if (!CNDat(3)) break p000e0700;
		if (!CNDeq(78,1)) break p000e0700;
		if (!CNDcarried(2)) break p000e0700;
 		ACCwrite(860);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LANZA AGUJERO
	p000e0701:
	{
 		if (skipdoall('p000e0701')) break p000e0701;
 		if (in_response)
		{
			if (!CNDverb(76)) break p000e0701;
			if (!CNDnoun1(100)) break p000e0701;
 		}
		if (!CNDnoun2(28)) break p000e0701;
		if (!CNDat(3)) break p000e0701;
		if (!CNDeq(78,1)) break p000e0701;
		if (!CNDcarried(12)) break p000e0701;
		if (!CNDonotzero(12,34)) break p000e0701;
 		ACCoclear(12,34);
		{}

	}

	// LANZA _
	p000e0702:
	{
 		if (skipdoall('p000e0702')) break p000e0702;
 		if (in_response)
		{
			if (!CNDverb(76)) break p000e0702;
 		}
		if (!CNDnoun2(28)) break p000e0702;
		if (!CNDat(3)) break p000e0702;
		if (!CNDeq(78,1)) break p000e0702;
 		ACCwhato();
		if (!CNDlt(51,255)) break p000e0702;
		if (!CNDcarried(getFlag(51))) break p000e0702;
 		ACCwrite(861);
 		ACCanykey();
 		function anykey00152() 
		{
 		ACCwrite(863);
 		ACCdestroy(getFlag(51));
 		ACCplace(getFlag(51),3);
 		ACCdone();
		return;
		}
 		function anykey00151() 
		{
 		ACCwrite(862);
 		ACCanykey();
 		waitKey(anykey00152);
		}
 		waitKey(anykey00151);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// LANZA _
	p000e0703:
	{
 		if (skipdoall('p000e0703')) break p000e0703;
 		if (in_response)
		{
			if (!CNDverb(76)) break p000e0703;
 		}
		if (!CNDat(3)) break p000e0703;
		if (!CNDeq(78,1)) break p000e0703;
 		ACCwrite(864);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DECIR PLANTA
	p000e0704:
	{
 		if (skipdoall('p000e0704')) break p000e0704;
 		if (in_response)
		{
			if (!CNDverb(31)) break p000e0704;
			if (!CNDnoun1(28)) break p000e0704;
 		}
		if (!CNDat(3)) break p000e0704;
		if (!CNDeq(78,1)) break p000e0704;
 		ACCwrite(865);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ESCUCHA PLANTA
	p000e0705:
	{
 		if (skipdoall('p000e0705')) break p000e0705;
 		if (in_response)
		{
			if (!CNDverb(41)) break p000e0705;
			if (!CNDnoun1(28)) break p000e0705;
 		}
		if (!CNDat(3)) break p000e0705;
		if (!CNDeq(78,1)) break p000e0705;
 		ACCwrite(866);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DA _
	p000e0706:
	{
 		if (skipdoall('p000e0706')) break p000e0706;
 		if (in_response)
		{
			if (!CNDverb(75)) break p000e0706;
 		}
		if (!CNDnoun2(28)) break p000e0706;
		if (!CNDat(3)) break p000e0706;
		if (!CNDeq(78,1)) break p000e0706;
 		ACCwrite(867);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// REGAR PLANTA
	p000e0707:
	{
 		if (skipdoall('p000e0707')) break p000e0707;
 		if (in_response)
		{
			if (!CNDverb(74)) break p000e0707;
			if (!CNDnoun1(28)) break p000e0707;
 		}
		if (!CNDeq(78,2)) break p000e0707;
		if (!CNDat(12)) break p000e0707;
 		ACCwrite(868);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// REGAR PLANTA
	p000e0708:
	{
 		if (skipdoall('p000e0708')) break p000e0708;
 		if (in_response)
		{
			if (!CNDverb(74)) break p000e0708;
			if (!CNDnoun1(28)) break p000e0708;
 		}
		if (!CNDat(3)) break p000e0708;
		if (!CNDeq(78,1)) break p000e0708;
 		ACCwrite(869);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE PLANTA
	p000e0709:
	{
 		if (skipdoall('p000e0709')) break p000e0709;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0709;
			if (!CNDnoun1(28)) break p000e0709;
 		}
		if (!CNDat(3)) break p000e0709;
		if (!CNDeq(78,1)) break p000e0709;
 		ACCwrite(870);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// GOLPEA PLANTA
	p000e0710:
	{
 		if (skipdoall('p000e0710')) break p000e0710;
 		if (in_response)
		{
			if (!CNDverb(63)) break p000e0710;
			if (!CNDnoun1(28)) break p000e0710;
 		}
		if (!CNDat(3)) break p000e0710;
		if (!CNDeq(78,1)) break p000e0710;
 		ACCwrite(871);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE PLANTA
	p000e0711:
	{
 		if (skipdoall('p000e0711')) break p000e0711;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0711;
			if (!CNDnoun1(28)) break p000e0711;
 		}
		if (!CNDat(3)) break p000e0711;
		if (!CNDeq(78,1)) break p000e0711;
 		ACCwrite(872);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// GOLPEA PLANTA
	p000e0712:
	{
 		if (skipdoall('p000e0712')) break p000e0712;
 		if (in_response)
		{
			if (!CNDverb(63)) break p000e0712;
			if (!CNDnoun1(28)) break p000e0712;
 		}
		if (!CNDat(3)) break p000e0712;
		if (!CNDeq(78,1)) break p000e0712;
 		ACCwrite(873);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ECHA AGUJERO
	p000e0713:
	{
 		if (skipdoall('p000e0713')) break p000e0713;
 		if (in_response)
		{
			if (!CNDverb(67)) break p000e0713;
			if (!CNDnoun1(100)) break p000e0713;
 		}
		if (!CNDat(3)) break p000e0713;
		if (!CNDeq(78,0)) break p000e0713;
		if (!CNDnoun2(28)) break p000e0713;
		if (!CNDnotcarr(12)) break p000e0713;
 		ACCwrite(874);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ECHA AGUJERO
	p000e0714:
	{
 		if (skipdoall('p000e0714')) break p000e0714;
 		if (in_response)
		{
			if (!CNDverb(67)) break p000e0714;
			if (!CNDnoun1(100)) break p000e0714;
 		}
		if (!CNDat(3)) break p000e0714;
		if (!CNDeq(78,0)) break p000e0714;
		if (!CNDnoun2(28)) break p000e0714;
		if (!CNDcarried(12)) break p000e0714;
		if (!CNDozero(12,34)) break p000e0714;
 		ACCwrite(875);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ECHA AGUJERO
	p000e0715:
	{
 		if (skipdoall('p000e0715')) break p000e0715;
 		if (in_response)
		{
			if (!CNDverb(67)) break p000e0715;
			if (!CNDnoun1(100)) break p000e0715;
 		}
		if (!CNDat(3)) break p000e0715;
		if (!CNDeq(78,0)) break p000e0715;
		if (!CNDnoun2(28)) break p000e0715;
		if (!CNDcarried(12)) break p000e0715;
		if (!CNDonotzero(12,34)) break p000e0715;
 		ACCoclear(12,34);
 		ACClet(78,1);
 		ACCwrite(876);
 		ACCanykey();
 		function anykey00156() 
		{
 		ACCwrite(879);
 		ACCdone();
		return;
		}
 		function anykey00155() 
		{
 		ACCpicture(15);
 		ACCanykey();
 		waitKey(anykey00156);
		}
 		function anykey00154() 
		{
 		ACCwrite(878);
 		ACCanykey();
 		waitKey(anykey00155);
		}
 		function anykey00153() 
		{
 		ACCwrite(877);
 		ACCanykey();
 		waitKey(anykey00154);
		}
 		waitKey(anykey00153);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// REGAR PLANTA
	p000e0716:
	{
 		if (skipdoall('p000e0716')) break p000e0716;
 		if (in_response)
		{
			if (!CNDverb(74)) break p000e0716;
			if (!CNDnoun1(28)) break p000e0716;
 		}
		if (!CNDat(3)) break p000e0716;
		if (!CNDeq(78,0)) break p000e0716;
		if (!CNDnotcarr(12)) break p000e0716;
 		ACCwrite(880);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// REGAR PLANTA
	p000e0717:
	{
 		if (skipdoall('p000e0717')) break p000e0717;
 		if (in_response)
		{
			if (!CNDverb(74)) break p000e0717;
			if (!CNDnoun1(28)) break p000e0717;
 		}
		if (!CNDat(3)) break p000e0717;
		if (!CNDeq(78,0)) break p000e0717;
		if (!CNDcarried(12)) break p000e0717;
		if (!CNDozero(12,34)) break p000e0717;
 		ACCwrite(881);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// REGAR PLANTA
	p000e0718:
	{
 		if (skipdoall('p000e0718')) break p000e0718;
 		if (in_response)
		{
			if (!CNDverb(74)) break p000e0718;
			if (!CNDnoun1(28)) break p000e0718;
 		}
		if (!CNDat(3)) break p000e0718;
		if (!CNDeq(78,0)) break p000e0718;
		if (!CNDcarried(12)) break p000e0718;
		if (!CNDonotzero(12,34)) break p000e0718;
 		ACCoclear(12,34);
 		ACClet(78,1);
 		ACCwrite(882);
 		ACCanykey();
 		function anykey00160() 
		{
 		ACCwrite(885);
 		ACCdone();
		return;
		}
 		function anykey00159() 
		{
 		ACCpicture(15);
 		ACCanykey();
 		waitKey(anykey00160);
		}
 		function anykey00158() 
		{
 		ACCwrite(884);
 		ACCanykey();
 		waitKey(anykey00159);
		}
 		function anykey00157() 
		{
 		ACCwrite(883);
 		ACCanykey();
 		waitKey(anykey00158);
		}
 		waitKey(anykey00157);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// DA _
	p000e0719:
	{
 		if (skipdoall('p000e0719')) break p000e0719;
 		if (in_response)
		{
			if (!CNDverb(75)) break p000e0719;
 		}
		if (!CNDnoun2(28)) break p000e0719;
		if (!CNDat(3)) break p000e0719;
		if (!CNDeq(78,0)) break p000e0719;
 		ACCwrite(886);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ARRANCA PLANTA
	p000e0720:
	{
 		if (skipdoall('p000e0720')) break p000e0720;
 		if (in_response)
		{
			if (!CNDverb(60)) break p000e0720;
			if (!CNDnoun1(28)) break p000e0720;
 		}
		if (!CNDat(3)) break p000e0720;
		if (!CNDeq(78,0)) break p000e0720;
 		ACCwrite(887);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DECIR PLANTA
	p000e0721:
	{
 		if (skipdoall('p000e0721')) break p000e0721;
 		if (in_response)
		{
			if (!CNDverb(31)) break p000e0721;
			if (!CNDnoun1(28)) break p000e0721;
 		}
		if (!CNDat(3)) break p000e0721;
		if (!CNDeq(78,0)) break p000e0721;
 		ACCwrite(888);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE PLANTA
	p000e0722:
	{
 		if (skipdoall('p000e0722')) break p000e0722;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0722;
			if (!CNDnoun1(28)) break p000e0722;
 		}
		if (!CNDat(3)) break p000e0722;
		if (!CNDeq(78,0)) break p000e0722;
 		ACCwrite(889);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE MACETA
	p000e0723:
	{
 		if (skipdoall('p000e0723')) break p000e0723;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0723;
			if (!CNDnoun1(113)) break p000e0723;
 		}
		if (!CNDat(3)) break p000e0723;
		if (!CNDeq(78,0)) break p000e0723;
 		ACCwrite(890);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ESCUCHA PLANTA
	p000e0724:
	{
 		if (skipdoall('p000e0724')) break p000e0724;
 		if (in_response)
		{
			if (!CNDverb(41)) break p000e0724;
			if (!CNDnoun1(28)) break p000e0724;
 		}
		if (!CNDat(3)) break p000e0724;
		if (!CNDeq(78,0)) break p000e0724;
 		ACCwrite(891);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LLENA AGUJERO
	p000e0725:
	{
 		if (skipdoall('p000e0725')) break p000e0725;
 		if (in_response)
		{
			if (!CNDverb(71)) break p000e0725;
			if (!CNDnoun1(100)) break p000e0725;
 		}
		if (!CNDnotcarr(12)) break p000e0725;
 		ACCwrite(892);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LLENA AGUJERO
	p000e0726:
	{
 		if (skipdoall('p000e0726')) break p000e0726;
 		if (in_response)
		{
			if (!CNDverb(71)) break p000e0726;
			if (!CNDnoun1(100)) break p000e0726;
 		}
		if (!CNDat(12)) break p000e0726;
		if (!CNDcarried(12)) break p000e0726;
		if (!CNDnotzero(84)) break p000e0726;
 		ACCwrite(893);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LLENA AGUJERO
	p000e0727:
	{
 		if (skipdoall('p000e0727')) break p000e0727;
 		if (in_response)
		{
			if (!CNDverb(71)) break p000e0727;
			if (!CNDnoun1(100)) break p000e0727;
 		}
		if (!CNDcarried(12)) break p000e0727;
		if (!CNDat(12)) break p000e0727;
		if (!CNDozero(12,33)) break p000e0727;
 		ACCwrite(894);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LLENA AGUJERO
	p000e0728:
	{
 		if (skipdoall('p000e0728')) break p000e0728;
 		if (in_response)
		{
			if (!CNDverb(71)) break p000e0728;
			if (!CNDnoun1(100)) break p000e0728;
 		}
		if (!CNDcarried(12)) break p000e0728;
		if (!CNDat(12)) break p000e0728;
		if (!CNDonotzero(12,33)) break p000e0728;
		if (!CNDonotzero(12,34)) break p000e0728;
 		ACCwrite(895);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LLENA AGUJERO
	p000e0729:
	{
 		if (skipdoall('p000e0729')) break p000e0729;
 		if (in_response)
		{
			if (!CNDverb(71)) break p000e0729;
			if (!CNDnoun1(100)) break p000e0729;
 		}
		if (!CNDcarried(12)) break p000e0729;
		if (!CNDat(12)) break p000e0729;
		if (!CNDonotzero(12,33)) break p000e0729;
		if (!CNDozero(12,34)) break p000e0729;
 		ACCwrite(896);
 		ACCoset(12,34);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ECHA AGUJERO
	p000e0730:
	{
 		if (skipdoall('p000e0730')) break p000e0730;
 		if (in_response)
		{
			if (!CNDverb(67)) break p000e0730;
			if (!CNDnoun1(100)) break p000e0730;
 		}
		if (!CNDnotcarr(12)) break p000e0730;
 		ACCwrite(897);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ECHA AGUJERO
	p000e0731:
	{
 		if (skipdoall('p000e0731')) break p000e0731;
 		if (in_response)
		{
			if (!CNDverb(67)) break p000e0731;
			if (!CNDnoun1(100)) break p000e0731;
 		}
		if (!CNDcarried(12)) break p000e0731;
		if (!CNDozero(12,34)) break p000e0731;
 		ACCwrite(898);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ECHA AGUJERO
	p000e0732:
	{
 		if (skipdoall('p000e0732')) break p000e0732;
 		if (in_response)
		{
			if (!CNDverb(67)) break p000e0732;
			if (!CNDnoun1(100)) break p000e0732;
 		}
		if (!CNDcarried(12)) break p000e0732;
		if (!CNDonotzero(12,34)) break p000e0732;
 		ACCwrite(899);
 		ACCoclear(12,34);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// BEBE _
	p000e0733:
	{
 		if (skipdoall('p000e0733')) break p000e0733;
 		if (in_response)
		{
			if (!CNDverb(68)) break p000e0733;
 		}
		if (!CNDat(12)) break p000e0733;
		if (!CNDnotzero(84)) break p000e0733;
 		ACCwrite(900);
 		ACCclear(84);
		{}

	}

	// BEBE _
	p000e0734:
	{
 		if (skipdoall('p000e0734')) break p000e0734;
 		if (in_response)
		{
			if (!CNDverb(68)) break p000e0734;
 		}
		if (!CNDat(12)) break p000e0734;
		if (!CNDzero(84)) break p000e0734;
 		ACCwrite(901);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// BUCEA _
	p000e0735:
	{
 		if (skipdoall('p000e0735')) break p000e0735;
 		if (in_response)
		{
			if (!CNDverb(73)) break p000e0735;
 		}
		if (!CNDat(12)) break p000e0735;
 		ACCwrite(902);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ESCUCHA _
	p000e0736:
	{
 		if (skipdoall('p000e0736')) break p000e0736;
 		if (in_response)
		{
			if (!CNDverb(41)) break p000e0736;
 		}
		if (!CNDat(12)) break p000e0736;
 		ACCwrite(903);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LLENA ELEXIR
	p000e0737:
	{
 		if (skipdoall('p000e0737')) break p000e0737;
 		if (in_response)
		{
			if (!CNDverb(71)) break p000e0737;
			if (!CNDnoun1(103)) break p000e0737;
 		}
		if (!CNDpresent(13)) break p000e0737;
 		ACCwrite(904);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// HUELE ELEXIR
	p000e0738:
	{
 		if (skipdoall('p000e0738')) break p000e0738;
 		if (in_response)
		{
			if (!CNDverb(72)) break p000e0738;
			if (!CNDnoun1(103)) break p000e0738;
 		}
		if (!CNDpresent(13)) break p000e0738;
 		ACCwrite(905);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// HUELE LIQUIDO
	p000e0739:
	{
 		if (skipdoall('p000e0739')) break p000e0739;
 		if (in_response)
		{
			if (!CNDverb(72)) break p000e0739;
			if (!CNDnoun1(105)) break p000e0739;
 		}
		if (!CNDpresent(13)) break p000e0739;
 		ACCwrite(906);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LLENA AGUJERO
	p000e0740:
	{
 		if (skipdoall('p000e0740')) break p000e0740;
 		if (in_response)
		{
			if (!CNDverb(71)) break p000e0740;
			if (!CNDnoun1(100)) break p000e0740;
 		}
		if (!CNDnoun2(103)) break p000e0740;
		if (!CNDnotcarr(12)) break p000e0740;
 		ACCwrite(907);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LLENA AGUJERO
	p000e0741:
	{
 		if (skipdoall('p000e0741')) break p000e0741;
 		if (in_response)
		{
			if (!CNDverb(71)) break p000e0741;
			if (!CNDnoun1(100)) break p000e0741;
 		}
		if (!CNDnoun2(103)) break p000e0741;
		if (!CNDnotcarr(13)) break p000e0741;
 		ACCwrite(908);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LLENA AGUJERO
	p000e0742:
	{
 		if (skipdoall('p000e0742')) break p000e0742;
 		if (in_response)
		{
			if (!CNDverb(71)) break p000e0742;
			if (!CNDnoun1(100)) break p000e0742;
 		}
		if (!CNDnoun2(103)) break p000e0742;
 		ACCwrite(909);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ECHA ELEXIR
	p000e0743:
	{
 		if (skipdoall('p000e0743')) break p000e0743;
 		if (in_response)
		{
			if (!CNDverb(67)) break p000e0743;
			if (!CNDnoun1(103)) break p000e0743;
 		}
		if (!CNDnoun2(100)) break p000e0743;
		if (!CNDnotcarr(12)) break p000e0743;
 		ACCwrite(910);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ECHA ELEXIR
	p000e0744:
	{
 		if (skipdoall('p000e0744')) break p000e0744;
 		if (in_response)
		{
			if (!CNDverb(67)) break p000e0744;
			if (!CNDnoun1(103)) break p000e0744;
 		}
		if (!CNDnoun2(100)) break p000e0744;
		if (!CNDnotcarr(13)) break p000e0744;
 		ACCwrite(911);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ECHA ELEXIR
	p000e0745:
	{
 		if (skipdoall('p000e0745')) break p000e0745;
 		if (in_response)
		{
			if (!CNDverb(67)) break p000e0745;
			if (!CNDnoun1(103)) break p000e0745;
 		}
		if (!CNDnoun2(100)) break p000e0745;
		if (!CNDcarried(12)) break p000e0745;
		if (!CNDcarried(13)) break p000e0745;
 		ACCwrite(912);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LLENA AGUJERO
	p000e0746:
	{
 		if (skipdoall('p000e0746')) break p000e0746;
 		if (in_response)
		{
			if (!CNDverb(71)) break p000e0746;
			if (!CNDnoun1(100)) break p000e0746;
 		}
		if (!CNDnotcarr(12)) break p000e0746;
 		ACCwrite(913);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LLENA AGUJERO
	p000e0747:
	{
 		if (skipdoall('p000e0747')) break p000e0747;
 		if (in_response)
		{
			if (!CNDverb(71)) break p000e0747;
			if (!CNDnoun1(100)) break p000e0747;
 		}
		if (!CNDcarried(12)) break p000e0747;
		if (!CNDnotat(12)) break p000e0747;
 		ACCwrite(914);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA ANTORCHA
	p000e0748:
	{
 		if (skipdoall('p000e0748')) break p000e0748;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0748;
			if (!CNDnoun1(50)) break p000e0748;
 		}
		if (!CNDnoun2(100)) break p000e0748;
		if (!CNDcarried(12)) break p000e0748;
 		ACCwrite(915);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SELLA AGUJERO
	p000e0749:
	{
 		if (skipdoall('p000e0749')) break p000e0749;
 		if (in_response)
		{
			if (!CNDverb(70)) break p000e0749;
			if (!CNDnoun1(100)) break p000e0749;
 		}
		if (!CNDnoun2(50)) break p000e0749;
		if (!CNDcarried(12)) break p000e0749;
		if (!CNDozero(12,33)) break p000e0749;
 		ACCwrite(916);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// TAPAR AGUJERO
	p000e0750:
	{
 		if (skipdoall('p000e0750')) break p000e0750;
 		if (in_response)
		{
			if (!CNDverb(65)) break p000e0750;
			if (!CNDnoun1(100)) break p000e0750;
 		}
		if (!CNDnoun2(50)) break p000e0750;
		if (!CNDcarried(12)) break p000e0750;
		if (!CNDozero(12,33)) break p000e0750;
 		ACCwrite(917);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SELLA AGUJERO
	p000e0751:
	{
 		if (skipdoall('p000e0751')) break p000e0751;
 		if (in_response)
		{
			if (!CNDverb(70)) break p000e0751;
			if (!CNDnoun1(100)) break p000e0751;
 		}
		if (!CNDnotcarr(12)) break p000e0751;
 		ACCwrite(918);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SELLA AGUJERO
	p000e0752:
	{
 		if (skipdoall('p000e0752')) break p000e0752;
 		if (in_response)
		{
			if (!CNDverb(70)) break p000e0752;
			if (!CNDnoun1(100)) break p000e0752;
 		}
		if (!CNDcarried(12)) break p000e0752;
		if (!CNDonotzero(12,33)) break p000e0752;
 		ACCwrite(919);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SELLA AGUJERO
	p000e0753:
	{
 		if (skipdoall('p000e0753')) break p000e0753;
 		if (in_response)
		{
			if (!CNDverb(70)) break p000e0753;
			if (!CNDnoun1(100)) break p000e0753;
 		}
		if (!CNDcarried(12)) break p000e0753;
		if (!CNDozero(12,33)) break p000e0753;
		if (!CNDnotcarr(14)) break p000e0753;
 		ACCwrite(920);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SELLA AGUJERO
	p000e0754:
	{
 		if (skipdoall('p000e0754')) break p000e0754;
 		if (in_response)
		{
			if (!CNDverb(70)) break p000e0754;
			if (!CNDnoun1(100)) break p000e0754;
 		}
		if (!CNDcarried(12)) break p000e0754;
		if (!CNDcarried(14)) break p000e0754;
		if (!CNDozero(12,33)) break p000e0754;
 		ACCdestroy(14);
 		ACCoset(12,33);
 		ACCwrite(921);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// TAPAR AGUJERO
	p000e0755:
	{
 		if (skipdoall('p000e0755')) break p000e0755;
 		if (in_response)
		{
			if (!CNDverb(65)) break p000e0755;
			if (!CNDnoun1(100)) break p000e0755;
 		}
		if (!CNDnotcarr(12)) break p000e0755;
 		ACCwrite(922);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// TAPAR AGUJERO
	p000e0756:
	{
 		if (skipdoall('p000e0756')) break p000e0756;
 		if (in_response)
		{
			if (!CNDverb(65)) break p000e0756;
			if (!CNDnoun1(100)) break p000e0756;
 		}
		if (!CNDcarried(12)) break p000e0756;
		if (!CNDonotzero(12,33)) break p000e0756;
 		ACCwrite(923);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// TAPAR AGUJERO
	p000e0757:
	{
 		if (skipdoall('p000e0757')) break p000e0757;
 		if (in_response)
		{
			if (!CNDverb(65)) break p000e0757;
			if (!CNDnoun1(100)) break p000e0757;
 		}
		if (!CNDcarried(12)) break p000e0757;
		if (!CNDozero(12,33)) break p000e0757;
		if (!CNDnotcarr(14)) break p000e0757;
 		ACCwrite(924);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// TAPAR AGUJERO
	p000e0758:
	{
 		if (skipdoall('p000e0758')) break p000e0758;
 		if (in_response)
		{
			if (!CNDverb(65)) break p000e0758;
			if (!CNDnoun1(100)) break p000e0758;
 		}
		if (!CNDcarried(12)) break p000e0758;
		if (!CNDcarried(14)) break p000e0758;
		if (!CNDozero(12,33)) break p000e0758;
 		ACCdestroy(14);
 		ACCoset(12,33);
 		ACCwrite(925);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR AGUJERO
	p000e0759:
	{
 		if (skipdoall('p000e0759')) break p000e0759;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0759;
			if (!CNDnoun1(100)) break p000e0759;
 		}
		if (!CNDnotcarr(12)) break p000e0759;
 		ACCwrite(926);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR AGUJERO
	p000e0760:
	{
 		if (skipdoall('p000e0760')) break p000e0760;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0760;
			if (!CNDnoun1(100)) break p000e0760;
 		}
		if (!CNDcarried(12)) break p000e0760;
		if (!CNDonotzero(12,33)) break p000e0760;
 		ACCwrite(927);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR AGUJERO
	p000e0761:
	{
 		if (skipdoall('p000e0761')) break p000e0761;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0761;
			if (!CNDnoun1(100)) break p000e0761;
 		}
		if (!CNDcarried(12)) break p000e0761;
		if (!CNDozero(12,33)) break p000e0761;
		if (!CNDnotcarr(14)) break p000e0761;
 		ACCwrite(928);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR AGUJERO
	p000e0762:
	{
 		if (skipdoall('p000e0762')) break p000e0762;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0762;
			if (!CNDnoun1(100)) break p000e0762;
 		}
		if (!CNDcarried(12)) break p000e0762;
		if (!CNDcarried(14)) break p000e0762;
		if (!CNDozero(12,33)) break p000e0762;
 		ACCdestroy(14);
 		ACCoset(12,33);
 		ACCwrite(929);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// REPARA AGUJERO
	p000e0763:
	{
 		if (skipdoall('p000e0763')) break p000e0763;
 		if (in_response)
		{
			if (!CNDverb(69)) break p000e0763;
			if (!CNDnoun1(100)) break p000e0763;
 		}
		if (!CNDnotcarr(12)) break p000e0763;
 		ACCwrite(930);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// REPARA AGUJERO
	p000e0764:
	{
 		if (skipdoall('p000e0764')) break p000e0764;
 		if (in_response)
		{
			if (!CNDverb(69)) break p000e0764;
			if (!CNDnoun1(100)) break p000e0764;
 		}
		if (!CNDcarried(12)) break p000e0764;
		if (!CNDonotzero(12,33)) break p000e0764;
 		ACCwrite(931);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// REPARA AGUJERO
	p000e0765:
	{
 		if (skipdoall('p000e0765')) break p000e0765;
 		if (in_response)
		{
			if (!CNDverb(69)) break p000e0765;
			if (!CNDnoun1(100)) break p000e0765;
 		}
		if (!CNDcarried(12)) break p000e0765;
		if (!CNDozero(12,33)) break p000e0765;
		if (!CNDnotcarr(14)) break p000e0765;
 		ACCwrite(932);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// REPARA AGUJERO
	p000e0766:
	{
 		if (skipdoall('p000e0766')) break p000e0766;
 		if (in_response)
		{
			if (!CNDverb(69)) break p000e0766;
			if (!CNDnoun1(100)) break p000e0766;
 		}
		if (!CNDcarried(12)) break p000e0766;
		if (!CNDcarried(14)) break p000e0766;
		if (!CNDozero(12,33)) break p000e0766;
 		ACCdestroy(14);
 		ACCoset(12,33);
 		ACCwrite(933);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE AGUJERO
	p000e0767:
	{
 		if (skipdoall('p000e0767')) break p000e0767;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0767;
			if (!CNDnoun1(100)) break p000e0767;
 		}
		if (!CNDcarried(12)) break p000e0767;
		if (!CNDonotzero(12,33)) break p000e0767;
 		ACCwrite(934);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DESTAPAR AGUJERO
	p000e0768:
	{
 		if (skipdoall('p000e0768')) break p000e0768;
 		if (in_response)
		{
			if (!CNDverb(66)) break p000e0768;
			if (!CNDnoun1(100)) break p000e0768;
 		}
		if (!CNDcarried(12)) break p000e0768;
		if (!CNDonotzero(12,33)) break p000e0768;
 		ACCwrite(935);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// BEBE ELEXIR
	p000e0769:
	{
 		if (skipdoall('p000e0769')) break p000e0769;
 		if (in_response)
		{
			if (!CNDverb(68)) break p000e0769;
			if (!CNDnoun1(103)) break p000e0769;
 		}
		if (!CNDnotcarr(13)) break p000e0769;
 		ACCwrite(936);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// BEBE ELEXIR
	p000e0770:
	{
 		if (skipdoall('p000e0770')) break p000e0770;
 		if (in_response)
		{
			if (!CNDverb(68)) break p000e0770;
			if (!CNDnoun1(103)) break p000e0770;
 		}
		if (!CNDcarried(13)) break p000e0770;
 		ACCwrite(937);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// BEBE LIQUIDO
	p000e0771:
	{
 		if (skipdoall('p000e0771')) break p000e0771;
 		if (in_response)
		{
			if (!CNDverb(68)) break p000e0771;
			if (!CNDnoun1(105)) break p000e0771;
 		}
		if (!CNDcarried(13)) break p000e0771;
 		ACCwrite(938);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ECHA ELEXIR
	p000e0772:
	{
 		if (skipdoall('p000e0772')) break p000e0772;
 		if (in_response)
		{
			if (!CNDverb(67)) break p000e0772;
			if (!CNDnoun1(103)) break p000e0772;
 		}
		if (!CNDprep(13)) break p000e0772;
		if (!CNDcarried(13)) break p000e0772;
 		ACCwrite(939);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ECHA ELEXIR
	p000e0773:
	{
 		if (skipdoall('p000e0773')) break p000e0773;
 		if (in_response)
		{
			if (!CNDverb(67)) break p000e0773;
			if (!CNDnoun1(103)) break p000e0773;
 		}
		if (!CNDnotcarr(13)) break p000e0773;
 		ACCwrite(940);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ECHA ELEXIR
	p000e0774:
	{
 		if (skipdoall('p000e0774')) break p000e0774;
 		if (in_response)
		{
			if (!CNDverb(67)) break p000e0774;
			if (!CNDnoun1(103)) break p000e0774;
 		}
		if (!CNDcarried(13)) break p000e0774;
		if (!CNDozero(13,33)) break p000e0774;
 		ACCwrite(941);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ECHA ELEXIR
	p000e0775:
	{
 		if (skipdoall('p000e0775')) break p000e0775;
 		if (in_response)
		{
			if (!CNDverb(67)) break p000e0775;
			if (!CNDnoun1(103)) break p000e0775;
 		}
		if (!CNDcarried(13)) break p000e0775;
		if (!CNDonotzero(13,33)) break p000e0775;
 		ACCwrite(942);
 		ACCanykey();
 		function anykey00162() 
		{
 		ACCwrite(944);
 		ACCdestroy(13);
 		ACCdone();
		return;
		}
 		function anykey00161() 
		{
 		ACCwrite(943);
 		ACCanykey();
 		waitKey(anykey00162);
		}
 		waitKey(anykey00161);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// DESTAPAR ELEXIR
	p000e0776:
	{
 		if (skipdoall('p000e0776')) break p000e0776;
 		if (in_response)
		{
			if (!CNDverb(66)) break p000e0776;
			if (!CNDnoun1(103)) break p000e0776;
 		}
		if (!CNDnotcarr(13)) break p000e0776;
 		ACCwrite(945);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DESTAPAR ELEXIR
	p000e0777:
	{
 		if (skipdoall('p000e0777')) break p000e0777;
 		if (in_response)
		{
			if (!CNDverb(66)) break p000e0777;
			if (!CNDnoun1(103)) break p000e0777;
 		}
		if (!CNDcarried(13)) break p000e0777;
		if (!CNDonotzero(13,33)) break p000e0777;
 		ACCwrite(946);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DESTAPAR ELEXIR
	p000e0778:
	{
 		if (skipdoall('p000e0778')) break p000e0778;
 		if (in_response)
		{
			if (!CNDverb(66)) break p000e0778;
			if (!CNDnoun1(103)) break p000e0778;
 		}
		if (!CNDcarried(13)) break p000e0778;
		if (!CNDozero(13,33)) break p000e0778;
 		ACCwrite(947);
 		ACCplace(14,254);
 		ACCoset(13,33);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// TAPAR ELEXIR
	p000e0779:
	{
 		if (skipdoall('p000e0779')) break p000e0779;
 		if (in_response)
		{
			if (!CNDverb(65)) break p000e0779;
			if (!CNDnoun1(103)) break p000e0779;
 		}
		if (!CNDnotcarr(13)) break p000e0779;
 		ACCwrite(948);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// TAPAR ELEXIR
	p000e0780:
	{
 		if (skipdoall('p000e0780')) break p000e0780;
 		if (in_response)
		{
			if (!CNDverb(65)) break p000e0780;
			if (!CNDnoun1(103)) break p000e0780;
 		}
		if (!CNDnotcarr(14)) break p000e0780;
 		ACCwrite(949);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// TAPAR ELEXIR
	p000e0781:
	{
 		if (skipdoall('p000e0781')) break p000e0781;
 		if (in_response)
		{
			if (!CNDverb(65)) break p000e0781;
			if (!CNDnoun1(103)) break p000e0781;
 		}
		if (!CNDcarried(13)) break p000e0781;
		if (!CNDozero(13,33)) break p000e0781;
 		ACCwrite(950);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// TAPAR ELEXIR
	p000e0782:
	{
 		if (skipdoall('p000e0782')) break p000e0782;
 		if (in_response)
		{
			if (!CNDverb(65)) break p000e0782;
			if (!CNDnoun1(103)) break p000e0782;
 		}
		if (!CNDcarried(13)) break p000e0782;
		if (!CNDcarried(14)) break p000e0782;
		if (!CNDonotzero(13,33)) break p000e0782;
 		ACCwrite(951);
 		ACCdestroy(14);
 		ACCplace(14,2);
 		ACCoclear(13,33);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE ELEXIR
	p000e0783:
	{
 		if (skipdoall('p000e0783')) break p000e0783;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0783;
			if (!CNDnoun1(103)) break p000e0783;
 		}
		if (!CNDnotcarr(13)) break p000e0783;
 		ACCwrite(952);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE ELEXIR
	p000e0784:
	{
 		if (skipdoall('p000e0784')) break p000e0784;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0784;
			if (!CNDnoun1(103)) break p000e0784;
 		}
		if (!CNDcarried(13)) break p000e0784;
		if (!CNDonotzero(13,33)) break p000e0784;
 		ACCwrite(953);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE ELEXIR
	p000e0785:
	{
 		if (skipdoall('p000e0785')) break p000e0785;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0785;
			if (!CNDnoun1(103)) break p000e0785;
 		}
		if (!CNDcarried(13)) break p000e0785;
		if (!CNDozero(13,33)) break p000e0785;
 		ACCwrite(954);
 		ACCplace(14,254);
 		ACCoset(13,33);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR ELEXIR
	p000e0786:
	{
 		if (skipdoall('p000e0786')) break p000e0786;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0786;
			if (!CNDnoun1(103)) break p000e0786;
 		}
		if (!CNDnotcarr(13)) break p000e0786;
 		ACCwrite(955);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR ELEXIR
	p000e0787:
	{
 		if (skipdoall('p000e0787')) break p000e0787;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0787;
			if (!CNDnoun1(103)) break p000e0787;
 		}
		if (!CNDcarried(13)) break p000e0787;
		if (!CNDozero(13,33)) break p000e0787;
 		ACCwrite(956);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR ELEXIR
	p000e0788:
	{
 		if (skipdoall('p000e0788')) break p000e0788;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0788;
			if (!CNDnoun1(103)) break p000e0788;
 		}
		if (!CNDnotcarr(14)) break p000e0788;
 		ACCwrite(957);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR ELEXIR
	p000e0789:
	{
 		if (skipdoall('p000e0789')) break p000e0789;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0789;
			if (!CNDnoun1(103)) break p000e0789;
 		}
		if (!CNDcarried(13)) break p000e0789;
		if (!CNDcarried(14)) break p000e0789;
		if (!CNDonotzero(13,33)) break p000e0789;
 		ACCwrite(958);
 		ACCdestroy(14);
 		ACCplace(14,2);
 		ACCoclear(13,33);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DWALIN _
	p000e0790:
	{
 		if (skipdoall('p000e0790')) break p000e0790;
 		if (in_response)
		{
			if (!CNDverb(48)) break p000e0790;
 		}
 		ACCwrite(959);
 		ACCwrite(960);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE BUZON
	p000e0791:
	{
 		if (skipdoall('p000e0791')) break p000e0791;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0791;
			if (!CNDnoun1(97)) break p000e0791;
 		}
		if (!CNDat(5)) break p000e0791;
 		ACCwrite(961);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE PIEDRAS
	p000e0792:
	{
 		if (skipdoall('p000e0792')) break p000e0792;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0792;
			if (!CNDnoun1(95)) break p000e0792;
 		}
		if (!CNDat(5)) break p000e0792;
 		ACCwrite(962);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE ARBOL
	p000e0793:
	{
 		if (skipdoall('p000e0793')) break p000e0793;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0793;
			if (!CNDnoun1(59)) break p000e0793;
 		}
		if (!CNDat(5)) break p000e0793;
 		ACCwrite(963);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE RUTA
	p000e0794:
	{
 		if (skipdoall('p000e0794')) break p000e0794;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0794;
			if (!CNDnoun1(94)) break p000e0794;
 		}
		if (!CNDat(5)) break p000e0794;
 		ACCwrite(964);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE CRUCE
	p000e0795:
	{
 		if (skipdoall('p000e0795')) break p000e0795;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0795;
			if (!CNDnoun1(96)) break p000e0795;
 		}
		if (!CNDat(5)) break p000e0795;
 		ACCwrite(965);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// QUITA CANDADO
	p000e0796:
	{
 		if (skipdoall('p000e0796')) break p000e0796;
 		if (in_response)
		{
			if (!CNDverb(22)) break p000e0796;
			if (!CNDnoun1(99)) break p000e0796;
 		}
		if (!CNDat(8)) break p000e0796;
		if (!CNDzero(77)) break p000e0796;
 		ACCwrite(966);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// QUITA CANDADO
	p000e0797:
	{
 		if (skipdoall('p000e0797')) break p000e0797;
 		if (in_response)
		{
			if (!CNDverb(22)) break p000e0797;
			if (!CNDnoun1(99)) break p000e0797;
 		}
		if (!CNDat(8)) break p000e0797;
		if (!CNDnotzero(77)) break p000e0797;
 		ACCwrite(967);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE CANDADO
	p000e0798:
	{
 		if (skipdoall('p000e0798')) break p000e0798;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0798;
			if (!CNDnoun1(99)) break p000e0798;
 		}
		if (!CNDat(8)) break p000e0798;
		if (!CNDnotzero(77)) break p000e0798;
 		ACCwrite(968);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE CANDADO
	p000e0799:
	{
 		if (skipdoall('p000e0799')) break p000e0799;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0799;
			if (!CNDnoun1(99)) break p000e0799;
 		}
		if (!CNDnoun2(71)) break p000e0799;
		if (!CNDat(8)) break p000e0799;
		if (!CNDzero(77)) break p000e0799;
		if (!CNDcarried(4)) break p000e0799;
 		ACCwrite(969);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE CANDADO
	p000e0800:
	{
 		if (skipdoall('p000e0800')) break p000e0800;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0800;
			if (!CNDnoun1(99)) break p000e0800;
 		}
		if (!CNDnoun2(71)) break p000e0800;
		if (!CNDzero(77)) break p000e0800;
		if (!CNDat(8)) break p000e0800;
		if (!CNDnotcarr(4)) break p000e0800;
 		ACCwrite(970);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE CANDADO
	p000e0801:
	{
 		if (skipdoall('p000e0801')) break p000e0801;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0801;
			if (!CNDnoun1(99)) break p000e0801;
 		}
		if (!CNDat(8)) break p000e0801;
		if (!CNDzero(77)) break p000e0801;
 		ACCwrite(971);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// GOLPEA CANDADO
	p000e0802:
	{
 		if (skipdoall('p000e0802')) break p000e0802;
 		if (in_response)
		{
			if (!CNDverb(63)) break p000e0802;
			if (!CNDnoun1(99)) break p000e0802;
 		}
		if (!CNDat(8)) break p000e0802;
		if (!CNDnotzero(77)) break p000e0802;
 		ACCwrite(972);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// GOLPEA CANDADO
	p000e0803:
	{
 		if (skipdoall('p000e0803')) break p000e0803;
 		if (in_response)
		{
			if (!CNDverb(63)) break p000e0803;
			if (!CNDnoun1(99)) break p000e0803;
 		}
		if (!CNDnoun2(57)) break p000e0803;
		if (!CNDat(8)) break p000e0803;
		if (!CNDzero(77)) break p000e0803;
		if (!CNDnotcarr(3)) break p000e0803;
 		ACCwrite(973);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// GOLPEA CANDADO
	p000e0804:
	{
 		if (skipdoall('p000e0804')) break p000e0804;
 		if (in_response)
		{
			if (!CNDverb(63)) break p000e0804;
			if (!CNDnoun1(99)) break p000e0804;
 		}
		if (!CNDnoun2(57)) break p000e0804;
		if (!CNDat(8)) break p000e0804;
		if (!CNDzero(77)) break p000e0804;
		if (!CNDcarried(3)) break p000e0804;
 		ACCwrite(974);
 		ACClet(77,1);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// GOLPEA CANDADO
	p000e0805:
	{
 		if (skipdoall('p000e0805')) break p000e0805;
 		if (in_response)
		{
			if (!CNDverb(63)) break p000e0805;
			if (!CNDnoun1(99)) break p000e0805;
 		}
		if (!CNDprep(9)) break p000e0805;
		if (!CNDat(8)) break p000e0805;
		if (!CNDzero(77)) break p000e0805;
 		ACCwrite(975);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// GOLPEA CANDADO
	p000e0806:
	{
 		if (skipdoall('p000e0806')) break p000e0806;
 		if (in_response)
		{
			if (!CNDverb(63)) break p000e0806;
			if (!CNDnoun1(99)) break p000e0806;
 		}
		if (!CNDat(8)) break p000e0806;
		if (!CNDzero(77)) break p000e0806;
 		ACCwrite(976);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR PUERTA
	p000e0807:
	{
 		if (skipdoall('p000e0807')) break p000e0807;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0807;
			if (!CNDnoun1(69)) break p000e0807;
 		}
		if (!CNDat(8)) break p000e0807;
		if (!CNDzero(77)) break p000e0807;
 		ACCwrite(977);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR CANDADO
	p000e0808:
	{
 		if (skipdoall('p000e0808')) break p000e0808;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0808;
			if (!CNDnoun1(99)) break p000e0808;
 		}
		if (!CNDat(8)) break p000e0808;
		if (!CNDzero(77)) break p000e0808;
 		ACCwrite(978);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR CANDADO
	p000e0809:
	{
 		if (skipdoall('p000e0809')) break p000e0809;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0809;
			if (!CNDnoun1(99)) break p000e0809;
 		}
		if (!CNDat(8)) break p000e0809;
		if (!CNDnotzero(77)) break p000e0809;
 		ACCwrite(979);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENTRA _
	p000e0810:
	{
 		if (skipdoall('p000e0810')) break p000e0810;
 		if (in_response)
		{
			if (!CNDverb(50)) break p000e0810;
 		}
		if (!CNDat(8)) break p000e0810;
		if (!CNDzero(77)) break p000e0810;
 		ACCwrite(980);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENTRA _
	p000e0811:
	{
 		if (skipdoall('p000e0811')) break p000e0811;
 		if (in_response)
		{
			if (!CNDverb(50)) break p000e0811;
 		}
		if (!CNDat(8)) break p000e0811;
		if (!CNDnotzero(77)) break p000e0811;
 		ACCgoto(3);
 		ACCdesc();
		break pro000_restart;
		{}

	}

	// ABRE PUERTA
	p000e0812:
	{
 		if (skipdoall('p000e0812')) break p000e0812;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0812;
			if (!CNDnoun1(69)) break p000e0812;
 		}
		if (!CNDat(8)) break p000e0812;
		if (!CNDzero(77)) break p000e0812;
 		ACCwrite(981);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE PUERTA
	p000e0813:
	{
 		if (skipdoall('p000e0813')) break p000e0813;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0813;
			if (!CNDnoun1(69)) break p000e0813;
 		}
		if (!CNDat(8)) break p000e0813;
		if (!CNDnotzero(77)) break p000e0813;
 		ACCwrite(982);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR PUERTA
	p000e0814:
	{
 		if (skipdoall('p000e0814')) break p000e0814;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0814;
			if (!CNDnoun1(69)) break p000e0814;
 		}
		if (!CNDat(8)) break p000e0814;
		if (!CNDnotzero(77)) break p000e0814;
 		ACCwrite(983);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// QUEMA CUERDA
	p000e0815:
	{
 		if (skipdoall('p000e0815')) break p000e0815;
 		if (in_response)
		{
			if (!CNDverb(64)) break p000e0815;
			if (!CNDnoun1(90)) break p000e0815;
 		}
		if (!CNDat(5)) break p000e0815;
		if (!CNDeq(75,0)) break p000e0815;
 		ACCwrite(984);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE CARTA
	p000e0816:
	{
 		if (skipdoall('p000e0816')) break p000e0816;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0816;
			if (!CNDnoun1(92)) break p000e0816;
 		}
		if (!CNDnotcarr(10)) break p000e0816;
 		ACCwrite(985);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE TELEGRAMA
	p000e0817:
	{
 		if (skipdoall('p000e0817')) break p000e0817;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0817;
			if (!CNDnoun1(93)) break p000e0817;
 		}
		if (!CNDnotcarr(11)) break p000e0817;
 		ACCwrite(986);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE CARTA
	p000e0818:
	{
 		if (skipdoall('p000e0818')) break p000e0818;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0818;
			if (!CNDnoun1(92)) break p000e0818;
 		}
		if (!CNDcarried(10)) break p000e0818;
 		ACCwrite(987);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE TELEGRAMA
	p000e0819:
	{
 		if (skipdoall('p000e0819')) break p000e0819;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0819;
			if (!CNDnoun1(93)) break p000e0819;
 		}
		if (!CNDcarried(11)) break p000e0819;
 		ACCwrite(988);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LEE CARTA
	p000e0820:
	{
 		if (skipdoall('p000e0820')) break p000e0820;
 		if (in_response)
		{
			if (!CNDverb(32)) break p000e0820;
			if (!CNDnoun1(92)) break p000e0820;
 		}
		if (!CNDnotcarr(10)) break p000e0820;
 		ACCwrite(989);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LEE TELEGRAMA
	p000e0821:
	{
 		if (skipdoall('p000e0821')) break p000e0821;
 		if (in_response)
		{
			if (!CNDverb(32)) break p000e0821;
			if (!CNDnoun1(93)) break p000e0821;
 		}
		if (!CNDnotcarr(11)) break p000e0821;
 		ACCwrite(990);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LEE CARTA
	p000e0822:
	{
 		if (skipdoall('p000e0822')) break p000e0822;
 		if (in_response)
		{
			if (!CNDverb(32)) break p000e0822;
			if (!CNDnoun1(92)) break p000e0822;
 		}
		if (!CNDcarried(10)) break p000e0822;
 		ACCwrite(991);
 		ACCanykey();
 		function anykey00163() 
		{
 		ACCwrite(992);
 		ACCwrite(993);
 		ACCdone();
		return;
		}
 		waitKey(anykey00163);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// LEE TELEGRAMA
	p000e0823:
	{
 		if (skipdoall('p000e0823')) break p000e0823;
 		if (in_response)
		{
			if (!CNDverb(32)) break p000e0823;
			if (!CNDnoun1(93)) break p000e0823;
 		}
		if (!CNDcarried(11)) break p000e0823;
 		ACCwrite(994);
 		ACCwrite(995);
 		ACClet(76,1);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA _
	p000e0824:
	{
 		if (skipdoall('p000e0824')) break p000e0824;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0824;
 		}
		if (!CNDnoun2(97)) break p000e0824;
		if (!CNDat(5)) break p000e0824;
		if (!CNDeq(75,0)) break p000e0824;
 		ACCwrite(996);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA _
	p000e0825:
	{
 		if (skipdoall('p000e0825')) break p000e0825;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0825;
 		}
		if (!CNDnoun2(97)) break p000e0825;
		if (!CNDat(5)) break p000e0825;
		if (!CNDeq(75,0)) break p000e0825;
 		ACCwrite(997);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE _
	p000e0826:
	{
 		if (skipdoall('p000e0826')) break p000e0826;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0826;
 		}
		if (!CNDnoun2(97)) break p000e0826;
		if (!CNDat(5)) break p000e0826;
		if (!CNDeq(75,0)) break p000e0826;
 		ACCwrite(998);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DEJA _
	p000e0827:
	{
 		if (skipdoall('p000e0827')) break p000e0827;
 		if (in_response)
		{
			if (!CNDverb(51)) break p000e0827;
 		}
		if (!CNDnoun2(97)) break p000e0827;
		if (!CNDat(5)) break p000e0827;
		if (!CNDeq(75,0)) break p000e0827;
 		ACCwrite(999);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE _
	p000e0828:
	{
 		if (skipdoall('p000e0828')) break p000e0828;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0828;
 		}
		if (!CNDnoun2(97)) break p000e0828;
		if (!CNDat(5)) break p000e0828;
		if (!CNDeq(75,1)) break p000e0828;
 		ACCwrite(1000);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DEJA _
	p000e0829:
	{
 		if (skipdoall('p000e0829')) break p000e0829;
 		if (in_response)
		{
			if (!CNDverb(51)) break p000e0829;
 		}
		if (!CNDnoun2(97)) break p000e0829;
		if (!CNDat(5)) break p000e0829;
		if (!CNDeq(75,1)) break p000e0829;
 		ACCwrite(1001);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA TODO
	p000e0830:
	{
 		if (skipdoall('p000e0830')) break p000e0830;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0830;
			if (!CNDnoun1(20)) break p000e0830;
 		}
		if (!CNDnoun2(97)) break p000e0830;
		if (!CNDat(5)) break p000e0830;
		if (!CNDeq(75,1)) break p000e0830;
		entry_for_doall = 'p000e0831';
		process_in_doall = 0;
 		ACCdoall(7);
		break pro000_restart;
		{}

	}

	// RETIRA CARTA
	p000e0831:
	{
 		if (skipdoall('p000e0831')) break p000e0831;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0831;
			if (!CNDnoun1(92)) break p000e0831;
 		}
		if (!CNDnoun2(97)) break p000e0831;
		if (!CNDat(5)) break p000e0831;
		if (!CNDeq(75,1)) break p000e0831;
		if (!CNDisat(10,7)) break p000e0831;
 		ACCplace(10,254);
 		ACCwrite(1002);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA TELEGRAMA
	p000e0832:
	{
 		if (skipdoall('p000e0832')) break p000e0832;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0832;
			if (!CNDnoun1(93)) break p000e0832;
 		}
		if (!CNDnoun2(97)) break p000e0832;
		if (!CNDat(5)) break p000e0832;
		if (!CNDeq(75,1)) break p000e0832;
		if (!CNDisat(11,7)) break p000e0832;
 		ACCplace(11,254);
 		ACCwrite(1003);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA _
	p000e0833:
	{
 		if (skipdoall('p000e0833')) break p000e0833;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0833;
 		}
		if (!CNDnoun2(97)) break p000e0833;
		if (!CNDat(5)) break p000e0833;
		if (!CNDeq(75,1)) break p000e0833;
 		ACCwrite(1004);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA CARTA
	p000e0834:
	{
 		if (skipdoall('p000e0834')) break p000e0834;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0834;
			if (!CNDnoun1(92)) break p000e0834;
 		}
		if (!CNDnoun2(97)) break p000e0834;
		if (!CNDat(5)) break p000e0834;
		if (!CNDeq(75,1)) break p000e0834;
		if (!CNDcarried(10)) break p000e0834;
 		ACCdestroy(10);
 		ACCplace(10,7);
 		ACCwrite(1005);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA TELEGRAMA
	p000e0835:
	{
 		if (skipdoall('p000e0835')) break p000e0835;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0835;
			if (!CNDnoun1(93)) break p000e0835;
 		}
		if (!CNDnoun2(97)) break p000e0835;
		if (!CNDat(5)) break p000e0835;
		if (!CNDeq(75,1)) break p000e0835;
		if (!CNDcarried(11)) break p000e0835;
 		ACCdestroy(11);
 		ACCplace(11,7);
 		ACCwrite(1006);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA _
	p000e0836:
	{
 		if (skipdoall('p000e0836')) break p000e0836;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0836;
 		}
		if (!CNDnoun2(97)) break p000e0836;
		if (!CNDat(5)) break p000e0836;
		if (!CNDeq(75,1)) break p000e0836;
 		ACCwrite(1007);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// GOLPEA _
	p000e0837:
	{
 		if (skipdoall('p000e0837')) break p000e0837;
 		if (in_response)
		{
			if (!CNDverb(63)) break p000e0837;
 		}
 		ACCwrite(1008);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CORTA CUERDA
	p000e0838:
	{
 		if (skipdoall('p000e0838')) break p000e0838;
 		if (in_response)
		{
			if (!CNDverb(62)) break p000e0838;
			if (!CNDnoun1(90)) break p000e0838;
 		}
		if (!CNDat(5)) break p000e0838;
		if (!CNDeq(75,1)) break p000e0838;
 		ACCwrite(1009);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CORTA CUERDA
	p000e0839:
	{
 		if (skipdoall('p000e0839')) break p000e0839;
 		if (in_response)
		{
			if (!CNDverb(62)) break p000e0839;
			if (!CNDnoun1(90)) break p000e0839;
 		}
		if (!CNDat(5)) break p000e0839;
		if (!CNDeq(75,0)) break p000e0839;
		if (!CNDnotcarr(9)) break p000e0839;
 		ACCwrite(1010);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CORTA CUERDA
	p000e0840:
	{
 		if (skipdoall('p000e0840')) break p000e0840;
 		if (in_response)
		{
			if (!CNDverb(62)) break p000e0840;
			if (!CNDnoun1(90)) break p000e0840;
 		}
		if (!CNDat(5)) break p000e0840;
		if (!CNDeq(75,0)) break p000e0840;
		if (!CNDcarried(9)) break p000e0840;
 		ACCwrite(1011);
 		ACCnewline();
 		ACClet(75,1);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DESATA CUERDA
	p000e0841:
	{
 		if (skipdoall('p000e0841')) break p000e0841;
 		if (in_response)
		{
			if (!CNDverb(61)) break p000e0841;
			if (!CNDnoun1(90)) break p000e0841;
 		}
		if (!CNDat(5)) break p000e0841;
		if (!CNDeq(75,0)) break p000e0841;
 		ACCwrite(1012);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE BUZON
	p000e0842:
	{
 		if (skipdoall('p000e0842')) break p000e0842;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0842;
			if (!CNDnoun1(97)) break p000e0842;
 		}
		if (!CNDat(5)) break p000e0842;
		if (!CNDeq(75,1)) break p000e0842;
 		ACCwrite(1013);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE BUZON
	p000e0843:
	{
 		if (skipdoall('p000e0843')) break p000e0843;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0843;
			if (!CNDnoun1(97)) break p000e0843;
 		}
		if (!CNDat(5)) break p000e0843;
		if (!CNDeq(75,0)) break p000e0843;
 		ACCwrite(1014);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR BUZON
	p000e0844:
	{
 		if (skipdoall('p000e0844')) break p000e0844;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0844;
			if (!CNDnoun1(97)) break p000e0844;
 		}
		if (!CNDat(5)) break p000e0844;
		if (!CNDeq(75,0)) break p000e0844;
 		ACCwrite(1015);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR BUZON
	p000e0845:
	{
 		if (skipdoall('p000e0845')) break p000e0845;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0845;
			if (!CNDnoun1(97)) break p000e0845;
 		}
		if (!CNDat(5)) break p000e0845;
		if (!CNDeq(75,1)) break p000e0845;
 		ACCwrite(1016);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// EMPUJA BUZON
	p000e0846:
	{
 		if (skipdoall('p000e0846')) break p000e0846;
 		if (in_response)
		{
			if (!CNDverb(36)) break p000e0846;
			if (!CNDnoun1(97)) break p000e0846;
 		}
		if (!CNDat(5)) break p000e0846;
 		ACCwrite(1017);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ARRANCA BUZON
	p000e0847:
	{
 		if (skipdoall('p000e0847')) break p000e0847;
 		if (in_response)
		{
			if (!CNDverb(60)) break p000e0847;
			if (!CNDnoun1(97)) break p000e0847;
 		}
		if (!CNDat(5)) break p000e0847;
 		ACCwrite(1018);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA PIEDRA
	p000e0848:
	{
 		if (skipdoall('p000e0848')) break p000e0848;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0848;
			if (!CNDnoun1(87)) break p000e0848;
 		}
		if (!CNDnoun2(88)) break p000e0848;
		if (!CNDat(5)) break p000e0848;
		if (!CNDisnotat(8,6)) break p000e0848;
 		ACCwrite(1019);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA PIEDRA
	p000e0849:
	{
 		if (skipdoall('p000e0849')) break p000e0849;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0849;
			if (!CNDnoun1(87)) break p000e0849;
 		}
		if (!CNDnoun2(88)) break p000e0849;
		if (!CNDat(5)) break p000e0849;
		if (!CNDeq(71,1)) break p000e0849;
 		ACCplace(8,254);
 		ACCwrite(1020);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE PIEDRA
	p000e0850:
	{
 		if (skipdoall('p000e0850')) break p000e0850;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0850;
			if (!CNDnoun1(87)) break p000e0850;
 		}
		if (!CNDat(5)) break p000e0850;
		if (!CNDeq(71,1)) break p000e0850;
 		ACCplace(8,254);
 		ACCwrite(1021);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE _
	p000e0851:
	{
 		if (skipdoall('p000e0851')) break p000e0851;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0851;
 		}
		if (!CNDat(5)) break p000e0851;
		if (!CNDeq(71,1)) break p000e0851;
 		ACCwhatox(11);
		if (!CNDisat(getFlag(11),6)) break p000e0851;
 		ACCplace(getFlag(11),254);
 		ACCwrite(1022);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA PIEDRA
	p000e0852:
	{
 		if (skipdoall('p000e0852')) break p000e0852;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0852;
			if (!CNDnoun1(87)) break p000e0852;
 		}
		if (!CNDnoun2(88)) break p000e0852;
		if (!CNDat(5)) break p000e0852;
		if (!CNDeq(71,0)) break p000e0852;
		if (!CNDisat(8,6)) break p000e0852;
 		ACCclear(70);
 		ACClet(74,1);
 		ACCplace(8,254);
 		ACCwrite(1023);
 		ACCnewline();
		{}

	}

	// RETIRA PIEDRA
	p000e0853:
	{
 		if (skipdoall('p000e0853')) break p000e0853;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0853;
			if (!CNDnoun1(87)) break p000e0853;
 		}
		if (!CNDnoun2(88)) break p000e0853;
		if (!CNDeq(71,0)) break p000e0853;
 		ACCobjat(6,73);
		if (!CNDzero(73)) break p000e0853;
 		ACCclear(74);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA PIEDRA
	p000e0854:
	{
 		if (skipdoall('p000e0854')) break p000e0854;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0854;
			if (!CNDnoun1(87)) break p000e0854;
 		}
		if (!CNDnoun2(88)) break p000e0854;
		if (!CNDeq(71,0)) break p000e0854;
 		ACCobjat(6,73);
		if (!CNDnotzero(73)) break p000e0854;
		entry_for_doall = 'p000e0855';
		process_in_doall = 0;
 		ACCdoall(6);
		break pro000_restart;
		{}

	}

	// _ _
	p000e0855:
	{
 		if (skipdoall('p000e0855')) break p000e0855;
		if (!CNDnoun2(88)) break p000e0855;
		if (!CNDeq(74,1)) break p000e0855;
 		ACCplace(getFlag(51),4);
 		ACCwrite(1024);
 		ACCnewline();
		{}

	}

	// _ _
	p000e0856:
	{
 		if (skipdoall('p000e0856')) break p000e0856;
		if (!CNDnoun2(88)) break p000e0856;
		if (!CNDeq(74,1)) break p000e0856;
 		ACCobjat(6,73);
		if (!CNDzero(73)) break p000e0856;
 		ACCclear(74);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// _ _
	p000e0857:
	{
 		if (skipdoall('p000e0857')) break p000e0857;
		if (!CNDnoun2(88)) break p000e0857;
		if (!CNDeq(74,1)) break p000e0857;
 		ACCobjat(6,73);
		if (!CNDnotzero(73)) break p000e0857;
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA _
	p000e0858:
	{
 		if (skipdoall('p000e0858')) break p000e0858;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0858;
 		}
		if (!CNDnoun2(88)) break p000e0858;
		if (!CNDat(5)) break p000e0858;
 		ACCwhatox(11);
		if (!CNDisnotat(getFlag(11),6)) break p000e0858;
 		ACCwrite(1025);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA _
	p000e0859:
	{
 		if (skipdoall('p000e0859')) break p000e0859;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0859;
 		}
		if (!CNDnoun2(88)) break p000e0859;
		if (!CNDat(5)) break p000e0859;
 		ACCwhatox(11);
		if (!CNDisat(getFlag(11),6)) break p000e0859;
 		ACCplace(getFlag(11),254);
 		ACCwrite(1026);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA _
	p000e0860:
	{
 		if (skipdoall('p000e0860')) break p000e0860;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0860;
 		}
		if (!CNDnoun2(88)) break p000e0860;
		if (!CNDat(5)) break p000e0860;
 		ACCwhato();
		if (!CNDeq(51,255)) break p000e0860;
 		ACCwrite(1027);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DEJA PIEDRA
	p000e0861:
	{
 		if (skipdoall('p000e0861')) break p000e0861;
 		if (in_response)
		{
			if (!CNDverb(51)) break p000e0861;
			if (!CNDnoun1(87)) break p000e0861;
 		}
		if (!CNDat(5)) break p000e0861;
		if (!CNDeq(71,1)) break p000e0861;
		if (!CNDcarried(8)) break p000e0861;
 		ACCwrite(1028);
 		ACCwrite(1029);
		{}

	}

	// DEJA PIEDRA
	p000e0862:
	{
 		if (skipdoall('p000e0862')) break p000e0862;
 		if (in_response)
		{
			if (!CNDverb(51)) break p000e0862;
			if (!CNDnoun1(87)) break p000e0862;
 		}
		if (!CNDat(5)) break p000e0862;
		if (!CNDeq(71,1)) break p000e0862;
		if (!CNDcarried(8)) break p000e0862;
 		ACCobjat(6,73);
		if (!CNDzero(73)) break p000e0862;
 		ACCnewline();
 		ACCclear(70);
 		ACCclear(71);
 		ACCdestroy(8);
 		ACCplace(8,5);
 		ACCanykey();
 		function anykey00164() 
		{
 		ACCgoto(4);
 		ACCdesc();
		return;
		}
 		waitKey(anykey00164);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// DEJA PIEDRA
	p000e0863:
	{
 		if (skipdoall('p000e0863')) break p000e0863;
 		if (in_response)
		{
			if (!CNDverb(51)) break p000e0863;
			if (!CNDnoun1(87)) break p000e0863;
 		}
		if (!CNDat(5)) break p000e0863;
		if (!CNDeq(71,1)) break p000e0863;
		if (!CNDcarried(8)) break p000e0863;
 		ACCplace(8,5);
 		ACCobjat(6,73);
		if (!CNDnotzero(73)) break p000e0863;
 		ACCnewline();
 		ACCwrite(1030);
 		ACClet(74,1);
 		ACCnewline();
 		ACCanykey();
 		function anykey00165() 
		{
		entry_for_doall = 'p000e0864';
		process_in_doall = 0;
 		ACCdoall(6);
		return;
		}
 		waitKey(anykey00165);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// _ _
	p000e0864:
	{
 		if (skipdoall('p000e0864')) break p000e0864;
		if (!CNDat(5)) break p000e0864;
		if (!CNDeq(74,1)) break p000e0864;
		if (!CNDeq(71,1)) break p000e0864;
 		ACCobjat(6,73);
		if (!CNDnotzero(73)) break p000e0864;
 		ACCplace(getFlag(51),4);
		{}

	}

	// _ _
	p000e0865:
	{
 		if (skipdoall('p000e0865')) break p000e0865;
		if (!CNDat(5)) break p000e0865;
		if (!CNDeq(71,1)) break p000e0865;
		if (!CNDeq(74,1)) break p000e0865;
 		ACCobjat(6,73);
		if (!CNDzero(73)) break p000e0865;
 		ACCclear(74);
 		ACCplace(8,5);
 		ACCgoto(4);
 		ACCclear(71);
 		ACCclear(74);
 		ACCclear(70);
 		ACCdesc();
		break pro000_restart;
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LANZA PIEDRA
	p000e0866:
	{
 		if (skipdoall('p000e0866')) break p000e0866;
 		if (in_response)
		{
			if (!CNDverb(76)) break p000e0866;
			if (!CNDnoun1(87)) break p000e0866;
 		}
		if (!CNDat(5)) break p000e0866;
		if (!CNDeq(71,1)) break p000e0866;
		if (!CNDcarried(8)) break p000e0866;
 		ACCwrite(1031);
 		ACCwrite(1032);
 		ACCanykey();
 		function anykey00166() 
		{
		}
 		waitKey(anykey00166);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// LANZA PIEDRA
	p000e0867:
	{
 		if (skipdoall('p000e0867')) break p000e0867;
 		if (in_response)
		{
			if (!CNDverb(76)) break p000e0867;
			if (!CNDnoun1(87)) break p000e0867;
 		}
		if (!CNDat(5)) break p000e0867;
		if (!CNDeq(71,1)) break p000e0867;
		if (!CNDcarried(8)) break p000e0867;
 		ACCobjat(6,73);
		if (!CNDzero(73)) break p000e0867;
 		ACCnewline();
 		ACCclear(70);
 		ACCclear(71);
 		ACCdestroy(8);
 		ACCplace(8,5);
 		ACCgoto(4);
 		ACCdesc();
		break pro000_restart;
		{}

	}

	// LANZA PIEDRA
	p000e0868:
	{
 		if (skipdoall('p000e0868')) break p000e0868;
 		if (in_response)
		{
			if (!CNDverb(76)) break p000e0868;
			if (!CNDnoun1(87)) break p000e0868;
 		}
		if (!CNDat(5)) break p000e0868;
		if (!CNDeq(71,1)) break p000e0868;
		if (!CNDcarried(8)) break p000e0868;
 		ACCplace(8,5);
 		ACCobjat(6,73);
		if (!CNDnotzero(73)) break p000e0868;
 		ACCnewline();
 		ACCwrite(1033);
 		ACClet(74,1);
 		ACCnewline();
 		ACCanykey();
 		function anykey00167() 
		{
		entry_for_doall = 'p000e0869';
		process_in_doall = 0;
 		ACCdoall(6);
		return;
		}
 		waitKey(anykey00167);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// _ _
	p000e0869:
	{
 		if (skipdoall('p000e0869')) break p000e0869;
		if (!CNDat(5)) break p000e0869;
		if (!CNDeq(74,1)) break p000e0869;
		if (!CNDeq(71,1)) break p000e0869;
 		ACCobjat(6,73);
		if (!CNDnotzero(73)) break p000e0869;
 		ACCplace(getFlag(51),4);
		{}

	}

	// _ _
	p000e0870:
	{
 		if (skipdoall('p000e0870')) break p000e0870;
		if (!CNDat(5)) break p000e0870;
		if (!CNDeq(71,1)) break p000e0870;
		if (!CNDeq(74,1)) break p000e0870;
 		ACCobjat(6,73);
		if (!CNDzero(73)) break p000e0870;
 		ACCclear(74);
 		ACCplace(8,5);
 		ACCgoto(4);
 		ACCclear(71);
 		ACCclear(74);
 		ACCclear(70);
 		ACCdesc();
		break pro000_restart;
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SUBE CAJON
	p000e0871:
	{
 		if (skipdoall('p000e0871')) break p000e0871;
 		if (in_response)
		{
			if (!CNDverb(10)) break p000e0871;
			if (!CNDnoun1(88)) break p000e0871;
 		}
		if (!CNDat(5)) break p000e0871;
		if (!CNDeq(71,1)) break p000e0871;
 		ACCwrite(1034);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENTRA CAJON
	p000e0872:
	{
 		if (skipdoall('p000e0872')) break p000e0872;
 		if (in_response)
		{
			if (!CNDverb(50)) break p000e0872;
			if (!CNDnoun1(88)) break p000e0872;
 		}
		if (!CNDat(5)) break p000e0872;
		if (!CNDeq(71,1)) break p000e0872;
 		ACCwrite(1035);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// MONTA CAJON
	p000e0873:
	{
 		if (skipdoall('p000e0873')) break p000e0873;
 		if (in_response)
		{
			if (!CNDverb(56)) break p000e0873;
			if (!CNDnoun1(88)) break p000e0873;
 		}
		if (!CNDat(5)) break p000e0873;
		if (!CNDeq(71,1)) break p000e0873;
 		ACCwrite(1036);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// BAJA CAJON
	p000e0874:
	{
 		if (skipdoall('p000e0874')) break p000e0874;
 		if (in_response)
		{
			if (!CNDverb(11)) break p000e0874;
			if (!CNDnoun1(88)) break p000e0874;
 		}
		if (!CNDat(5)) break p000e0874;
		if (!CNDeq(71,1)) break p000e0874;
		if (!CNDnotcarr(8)) break p000e0874;
 		ACCclear(71);
 		ACCwrite(1037);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// BAJA CAJON
	p000e0875:
	{
 		if (skipdoall('p000e0875')) break p000e0875;
 		if (in_response)
		{
			if (!CNDverb(11)) break p000e0875;
			if (!CNDnoun1(88)) break p000e0875;
 		}
		if (!CNDat(5)) break p000e0875;
		if (!CNDeq(71,1)) break p000e0875;
		if (!CNDcarried(8)) break p000e0875;
 		ACCclear(71);
 		ACClet(74,1);
 		ACCwrite(1038);
 		ACCclear(70);
 		ACCwrite(1039);
 		ACCnewline();
		{}

	}

	// BAJA CAJON
	p000e0876:
	{
 		if (skipdoall('p000e0876')) break p000e0876;
 		if (in_response)
		{
			if (!CNDverb(11)) break p000e0876;
			if (!CNDnoun1(88)) break p000e0876;
 		}
		if (!CNDeq(71,0)) break p000e0876;
		if (!CNDeq(74,1)) break p000e0876;
 		ACCobjat(6,73);
		if (!CNDzero(73)) break p000e0876;
 		ACCclear(74);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// BAJA CAJON
	p000e0877:
	{
 		if (skipdoall('p000e0877')) break p000e0877;
 		if (in_response)
		{
			if (!CNDverb(11)) break p000e0877;
			if (!CNDnoun1(88)) break p000e0877;
 		}
		if (!CNDeq(71,0)) break p000e0877;
 		ACCobjat(6,73);
		if (!CNDnotzero(73)) break p000e0877;
		entry_for_doall = 'p000e0878';
		process_in_doall = 0;
 		ACCdoall(6);
		break pro000_restart;
		{}

	}

	// _ _
	p000e0878:
	{
 		if (skipdoall('p000e0878')) break p000e0878;
		if (!CNDeq(74,1)) break p000e0878;
 		ACCplace(getFlag(51),4);
 		ACCwrite(1040);
 		ACCnewline();
		{}

	}

	// _ _
	p000e0879:
	{
 		if (skipdoall('p000e0879')) break p000e0879;
		if (!CNDeq(74,1)) break p000e0879;
 		ACCobjat(6,73);
		if (!CNDzero(73)) break p000e0879;
 		ACCclear(74);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// _ _
	p000e0880:
	{
 		if (skipdoall('p000e0880')) break p000e0880;
		if (!CNDeq(74,1)) break p000e0880;
 		ACCobjat(6,73);
		if (!CNDnotzero(73)) break p000e0880;
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SAL CAJON
	p000e0881:
	{
 		if (skipdoall('p000e0881')) break p000e0881;
 		if (in_response)
		{
			if (!CNDverb(49)) break p000e0881;
			if (!CNDnoun1(88)) break p000e0881;
 		}
		if (!CNDat(5)) break p000e0881;
		if (!CNDeq(71,1)) break p000e0881;
		if (!CNDcarried(8)) break p000e0881;
 		ACCclear(71);
 		ACClet(74,1);
 		ACCwrite(1041);
 		ACCclear(70);
 		ACCwrite(1042);
 		ACCnewline();
		{}

	}

	// SAL CAJON
	p000e0882:
	{
 		if (skipdoall('p000e0882')) break p000e0882;
 		if (in_response)
		{
			if (!CNDverb(49)) break p000e0882;
			if (!CNDnoun1(88)) break p000e0882;
 		}
		if (!CNDeq(71,0)) break p000e0882;
		if (!CNDeq(74,1)) break p000e0882;
 		ACCobjat(6,73);
		if (!CNDzero(73)) break p000e0882;
 		ACCclear(74);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SAL CAJON
	p000e0883:
	{
 		if (skipdoall('p000e0883')) break p000e0883;
 		if (in_response)
		{
			if (!CNDverb(49)) break p000e0883;
			if (!CNDnoun1(88)) break p000e0883;
 		}
		if (!CNDeq(71,0)) break p000e0883;
 		ACCobjat(6,73);
		if (!CNDnotzero(73)) break p000e0883;
		entry_for_doall = 'p000e0884';
		process_in_doall = 0;
 		ACCdoall(6);
		break pro000_restart;
		{}

	}

	// _ _
	p000e0884:
	{
 		if (skipdoall('p000e0884')) break p000e0884;
		if (!CNDeq(74,1)) break p000e0884;
 		ACCplace(getFlag(51),4);
 		ACCwrite(1043);
 		ACCnewline();
		{}

	}

	// _ _
	p000e0885:
	{
 		if (skipdoall('p000e0885')) break p000e0885;
		if (!CNDeq(74,1)) break p000e0885;
 		ACCobjat(6,73);
		if (!CNDzero(73)) break p000e0885;
 		ACCclear(74);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// _ _
	p000e0886:
	{
 		if (skipdoall('p000e0886')) break p000e0886;
		if (!CNDeq(74,1)) break p000e0886;
 		ACCobjat(6,73);
		if (!CNDnotzero(73)) break p000e0886;
 		ACCdone();
		break pro000_restart;
		{}

	}

	// BAJA CAJON
	p000e0887:
	{
 		if (skipdoall('p000e0887')) break p000e0887;
 		if (in_response)
		{
			if (!CNDverb(11)) break p000e0887;
			if (!CNDnoun1(88)) break p000e0887;
 		}
		if (!CNDat(5)) break p000e0887;
		if (!CNDnoteq(71,1)) break p000e0887;
 		ACCwrite(1044);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SAL CAJON
	p000e0888:
	{
 		if (skipdoall('p000e0888')) break p000e0888;
 		if (in_response)
		{
			if (!CNDverb(49)) break p000e0888;
			if (!CNDnoun1(88)) break p000e0888;
 		}
		if (!CNDat(5)) break p000e0888;
		if (!CNDnoteq(71,1)) break p000e0888;
 		ACCwrite(1045);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DEJA ANTORCHA
	p000e0889:
	{
 		if (skipdoall('p000e0889')) break p000e0889;
 		if (in_response)
		{
			if (!CNDverb(51)) break p000e0889;
			if (!CNDnoun1(50)) break p000e0889;
 		}
 		ACCmessage(2);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGELA ANTORCHA
	p000e0890:
	{
 		if (skipdoall('p000e0890')) break p000e0890;
 		if (in_response)
		{
			if (!CNDverb(21)) break p000e0890;
			if (!CNDnoun1(50)) break p000e0890;
 		}
 		ACCmessage(2);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGELA CAPUCHA
	p000e0891:
	{
 		if (skipdoall('p000e0891')) break p000e0891;
 		if (in_response)
		{
			if (!CNDverb(21)) break p000e0891;
			if (!CNDnoun1(52)) break p000e0891;
 		}
		if (!CNDnoun2(88)) break p000e0891;
 		ACCmessage(1);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SUBE CAJON
	p000e0892:
	{
 		if (skipdoall('p000e0892')) break p000e0892;
 		if (in_response)
		{
			if (!CNDverb(10)) break p000e0892;
			if (!CNDnoun1(88)) break p000e0892;
 		}
		if (!CNDat(5)) break p000e0892;
		if (!CNDnotzero(70)) break p000e0892;
 		ACCwrite(1046);
 		ACClet(71,1);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENTRA CAJON
	p000e0893:
	{
 		if (skipdoall('p000e0893')) break p000e0893;
 		if (in_response)
		{
			if (!CNDverb(50)) break p000e0893;
			if (!CNDnoun1(88)) break p000e0893;
 		}
		if (!CNDat(5)) break p000e0893;
		if (!CNDnotzero(70)) break p000e0893;
 		ACCwrite(1047);
 		ACClet(71,1);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA PIEDRA
	p000e0894:
	{
 		if (skipdoall('p000e0894')) break p000e0894;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0894;
			if (!CNDnoun1(87)) break p000e0894;
 		}
		if (!CNDnoun2(88)) break p000e0894;
		if (!CNDcarried(8)) break p000e0894;
		if (!CNDat(5)) break p000e0894;
		if (!CNDnotzero(71)) break p000e0894;
 		ACCplace(8,6);
 		ACCwrite(1048);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA PIEDRA
	p000e0895:
	{
 		if (skipdoall('p000e0895')) break p000e0895;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0895;
			if (!CNDnoun1(87)) break p000e0895;
 		}
		if (!CNDnoun2(88)) break p000e0895;
		if (!CNDcarried(8)) break p000e0895;
		if (!CNDat(5)) break p000e0895;
		if (!CNDzero(84)) break p000e0895;
 		ACCwrite(1049);
 		ACCnewline();
 		ACClet(72,6);
 		ACCcopyfo(72,8);
 		ACCplus(70,1);
 		ACClet(74,0);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA PIEDRA
	p000e0896:
	{
 		if (skipdoall('p000e0896')) break p000e0896;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0896;
			if (!CNDnoun1(87)) break p000e0896;
 		}
		if (!CNDnoun2(88)) break p000e0896;
		if (!CNDcarried(8)) break p000e0896;
		if (!CNDat(5)) break p000e0896;
		if (!CNDnotzero(84)) break p000e0896;
 		ACCwrite(1050);
 		ACCnewline();
 		ACClet(72,6);
 		ACCcopyfo(72,8);
 		ACCplus(70,1);
 		ACClet(74,0);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA _
	p000e0897:
	{
 		if (skipdoall('p000e0897')) break p000e0897;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0897;
 		}
		if (!CNDnoun2(88)) break p000e0897;
		if (!CNDat(5)) break p000e0897;
 		ACCwhato();
		if (!CNDeq(51,255)) break p000e0897;
 		ACCwrite(1051);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA _
	p000e0898:
	{
 		if (skipdoall('p000e0898')) break p000e0898;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0898;
 		}
		if (!CNDnoun2(88)) break p000e0898;
		if (!CNDat(5)) break p000e0898;
 		ACCwhato();
		if (!CNDlt(51,255)) break p000e0898;
		if (!CNDnotcarr(getFlag(51))) break p000e0898;
 		ACCwrite(1052);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA _
	p000e0899:
	{
 		if (skipdoall('p000e0899')) break p000e0899;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e0899;
 		}
		if (!CNDnoun2(88)) break p000e0899;
		if (!CNDat(5)) break p000e0899;
 		ACCwhato();
		if (!CNDlt(51,255)) break p000e0899;
		if (!CNDcarried(getFlag(51))) break p000e0899;
 		ACCputo(6);
 		ACCmessage(17);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SUBE CAJON
	p000e0900:
	{
 		if (skipdoall('p000e0900')) break p000e0900;
 		if (in_response)
		{
			if (!CNDverb(10)) break p000e0900;
			if (!CNDnoun1(88)) break p000e0900;
 		}
		if (!CNDat(5)) break p000e0900;
		if (!CNDzero(70)) break p000e0900;
 		ACCwrite(1053);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// TREPA CAJON
	p000e0901:
	{
 		if (skipdoall('p000e0901')) break p000e0901;
 		if (in_response)
		{
			if (!CNDverb(55)) break p000e0901;
			if (!CNDnoun1(88)) break p000e0901;
 		}
		if (!CNDat(5)) break p000e0901;
		if (!CNDzero(70)) break p000e0901;
 		ACCwrite(1054);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGELA _
	p000e0902:
	{
 		if (skipdoall('p000e0902')) break p000e0902;
 		if (in_response)
		{
			if (!CNDverb(21)) break p000e0902;
 		}
		if (!CNDnoun2(88)) break p000e0902;
		if (!CNDat(5)) break p000e0902;
 		ACCwrite(1055);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DEJA _
	p000e0903:
	{
 		if (skipdoall('p000e0903')) break p000e0903;
 		if (in_response)
		{
			if (!CNDverb(51)) break p000e0903;
 		}
		if (!CNDnoun2(88)) break p000e0903;
		if (!CNDat(5)) break p000e0903;
 		ACCwrite(1056);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE _
	p000e0904:
	{
 		if (skipdoall('p000e0904')) break p000e0904;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0904;
 		}
		if (!CNDnoun2(88)) break p000e0904;
		if (!CNDat(5)) break p000e0904;
 		ACCwrite(1057);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SUBE _
	p000e0905:
	{
 		if (skipdoall('p000e0905')) break p000e0905;
 		if (in_response)
		{
			if (!CNDverb(10)) break p000e0905;
 		}
		if (!CNDat(5)) break p000e0905;
 		ACCwrite(1058);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// TREPA ARBOL
	p000e0906:
	{
 		if (skipdoall('p000e0906')) break p000e0906;
 		if (in_response)
		{
			if (!CNDverb(55)) break p000e0906;
			if (!CNDnoun1(59)) break p000e0906;
 		}
		if (!CNDat(5)) break p000e0906;
 		ACCwrite(1059);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SUBE ARBOL
	p000e0907:
	{
 		if (skipdoall('p000e0907')) break p000e0907;
 		if (in_response)
		{
			if (!CNDverb(10)) break p000e0907;
			if (!CNDnoun1(59)) break p000e0907;
 		}
		if (!CNDat(5)) break p000e0907;
 		ACCwrite(1060);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// TREPA CASA
	p000e0908:
	{
 		if (skipdoall('p000e0908')) break p000e0908;
 		if (in_response)
		{
			if (!CNDverb(55)) break p000e0908;
			if (!CNDnoun1(58)) break p000e0908;
 		}
		if (!CNDat(5)) break p000e0908;
 		ACCwrite(1061);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SUBE CASA
	p000e0909:
	{
 		if (skipdoall('p000e0909')) break p000e0909;
 		if (in_response)
		{
			if (!CNDverb(10)) break p000e0909;
			if (!CNDnoun1(58)) break p000e0909;
 		}
		if (!CNDat(5)) break p000e0909;
 		ACCwrite(1062);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// X _
	p000e0910:
	{
 		if (skipdoall('p000e0910')) break p000e0910;
 		if (in_response)
		{
			if (!CNDverb(54)) break p000e0910;
 		}
 		ACCprocess(4);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE BANCO
	p000e0911:
	{
 		if (skipdoall('p000e0911')) break p000e0911;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0911;
			if (!CNDnoun1(75)) break p000e0911;
 		}
		if (!CNDat(4)) break p000e0911;
 		ACCwrite(1063);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE COLUMNA
	p000e0912:
	{
 		if (skipdoall('p000e0912')) break p000e0912;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0912;
			if (!CNDnoun1(83)) break p000e0912;
 		}
		if (!CNDat(4)) break p000e0912;
 		ACCwrite(1064);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DESCANSA _
	p000e0913:
	{
 		if (skipdoall('p000e0913')) break p000e0913;
 		if (in_response)
		{
			if (!CNDverb(35)) break p000e0913;
 		}
		if (!CNDat(4)) break p000e0913;
 		ACCwrite(1065);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// BAJA _
	p000e0914:
	{
 		if (skipdoall('p000e0914')) break p000e0914;
 		if (in_response)
		{
			if (!CNDverb(11)) break p000e0914;
 		}
		if (!CNDat(4)) break p000e0914;
 		ACCwrite(1066);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ASOMAR _
	p000e0915:
	{
 		if (skipdoall('p000e0915')) break p000e0915;
 		if (in_response)
		{
			if (!CNDverb(52)) break p000e0915;
 		}
		if (!CNDat(4)) break p000e0915;
 		ACCwrite(1067);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// BOTA VACIO
	p000e0916:
	{
 		if (skipdoall('p000e0916')) break p000e0916;
 		if (in_response)
		{
			if (!CNDverb(53)) break p000e0916;
			if (!CNDnoun1(85)) break p000e0916;
 		}
		if (!CNDat(4)) break p000e0916;
		if (!CNDcarried(6)) break p000e0916;
		if (!CNDzero(128)) break p000e0916;
 		ACCwrite(1068);
 		ACCnewline();
 		ACCanykey();
 		function anykey00171() 
		{
 		ACCgoto(5);
 		ACCdesc();
		return;
 		ACCdone();
		return;
		}
 		function anykey00170() 
		{
 		ACCwrite(1071);
 		ACCanykey();
 		waitKey(anykey00171);
		}
 		function anykey00169() 
		{
 		ACCwrite(1070);
 		ACCnewline();
 		ACCanykey();
 		waitKey(anykey00170);
		}
 		function anykey00168() 
		{
 		ACCwrite(1069);
 		ACCnewline();
 		ACCanykey();
 		waitKey(anykey00169);
		}
 		waitKey(anykey00168);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// BOTA VACIO
	p000e0917:
	{
 		if (skipdoall('p000e0917')) break p000e0917;
 		if (in_response)
		{
			if (!CNDverb(53)) break p000e0917;
			if (!CNDnoun1(85)) break p000e0917;
 		}
		if (!CNDat(4)) break p000e0917;
 		ACCwrite(1072);
 		ACCnewline();
 		ACCanykey();
 		function anykey00172() 
		{
 		ACCwrite(1073);
 		ACCnewline();
 		ACCdone();
		return;
		}
 		waitKey(anykey00172);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// BOTA ABAJO
	p000e0918:
	{
 		if (skipdoall('p000e0918')) break p000e0918;
 		if (in_response)
		{
			if (!CNDverb(53)) break p000e0918;
			if (!CNDnoun1(11)) break p000e0918;
 		}
		if (!CNDat(4)) break p000e0918;
		if (!CNDcarried(6)) break p000e0918;
		if (!CNDzero(128)) break p000e0918;
 		ACCwrite(1074);
 		ACCnewline();
 		ACCanykey();
 		function anykey00176() 
		{
 		ACCgoto(5);
 		ACCdesc();
		return;
 		ACCdone();
		return;
		}
 		function anykey00175() 
		{
 		ACCwrite(1077);
 		ACCanykey();
 		waitKey(anykey00176);
		}
 		function anykey00174() 
		{
 		ACCwrite(1076);
 		ACCnewline();
 		ACCanykey();
 		waitKey(anykey00175);
		}
 		function anykey00173() 
		{
 		ACCwrite(1075);
 		ACCnewline();
 		ACCanykey();
 		waitKey(anykey00174);
		}
 		waitKey(anykey00173);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// BOTA ABAJO
	p000e0919:
	{
 		if (skipdoall('p000e0919')) break p000e0919;
 		if (in_response)
		{
			if (!CNDverb(53)) break p000e0919;
			if (!CNDnoun1(11)) break p000e0919;
 		}
		if (!CNDat(4)) break p000e0919;
 		ACCwrite(1078);
 		ACCnewline();
 		ACCanykey();
 		function anykey00177() 
		{
 		ACCwrite(1079);
 		ACCnewline();
 		ACCdone();
		return;
		}
 		waitKey(anykey00177);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// BOTA SUELO
	p000e0920:
	{
 		if (skipdoall('p000e0920')) break p000e0920;
 		if (in_response)
		{
			if (!CNDverb(53)) break p000e0920;
			if (!CNDnoun1(120)) break p000e0920;
 		}
		if (!CNDat(4)) break p000e0920;
		if (!CNDcarried(6)) break p000e0920;
		if (!CNDzero(128)) break p000e0920;
 		ACCwrite(1080);
 		ACCnewline();
 		ACCanykey();
 		function anykey00181() 
		{
 		ACCgoto(5);
 		ACCdesc();
		return;
 		ACCdone();
		return;
		}
 		function anykey00180() 
		{
 		ACCwrite(1083);
 		ACCanykey();
 		waitKey(anykey00181);
		}
 		function anykey00179() 
		{
 		ACCwrite(1082);
 		ACCnewline();
 		ACCanykey();
 		waitKey(anykey00180);
		}
 		function anykey00178() 
		{
 		ACCwrite(1081);
 		ACCnewline();
 		ACCanykey();
 		waitKey(anykey00179);
		}
 		waitKey(anykey00178);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// BOTA SUELO
	p000e0921:
	{
 		if (skipdoall('p000e0921')) break p000e0921;
 		if (in_response)
		{
			if (!CNDverb(53)) break p000e0921;
			if (!CNDnoun1(120)) break p000e0921;
 		}
		if (!CNDat(4)) break p000e0921;
 		ACCwrite(1084);
 		ACCnewline();
 		ACCanykey();
 		function anykey00182() 
		{
 		ACCwrite(1085);
 		ACCnewline();
 		ACCdone();
		return;
		}
 		waitKey(anykey00182);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// BOTA CLARO
	p000e0922:
	{
 		if (skipdoall('p000e0922')) break p000e0922;
 		if (in_response)
		{
			if (!CNDverb(53)) break p000e0922;
			if (!CNDnoun1(79)) break p000e0922;
 		}
		if (!CNDat(4)) break p000e0922;
		if (!CNDcarried(6)) break p000e0922;
		if (!CNDzero(128)) break p000e0922;
 		ACCwrite(1086);
 		ACCnewline();
 		ACCanykey();
 		function anykey00186() 
		{
 		ACCgoto(5);
 		ACCdesc();
		return;
 		ACCdone();
		return;
		}
 		function anykey00185() 
		{
 		ACCwrite(1089);
 		ACCanykey();
 		waitKey(anykey00186);
		}
 		function anykey00184() 
		{
 		ACCwrite(1088);
 		ACCnewline();
 		ACCanykey();
 		waitKey(anykey00185);
		}
 		function anykey00183() 
		{
 		ACCwrite(1087);
 		ACCnewline();
 		ACCanykey();
 		waitKey(anykey00184);
		}
 		waitKey(anykey00183);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// BOTA CLARO
	p000e0923:
	{
 		if (skipdoall('p000e0923')) break p000e0923;
 		if (in_response)
		{
			if (!CNDverb(53)) break p000e0923;
			if (!CNDnoun1(79)) break p000e0923;
 		}
		if (!CNDat(4)) break p000e0923;
 		ACCwrite(1090);
 		ACCnewline();
 		ACCanykey();
 		function anykey00187() 
		{
 		ACCwrite(1091);
 		ACCnewline();
 		ACCdone();
		return;
		}
 		waitKey(anykey00187);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// BOTA PLATAFORMA
	p000e0924:
	{
 		if (skipdoall('p000e0924')) break p000e0924;
 		if (in_response)
		{
			if (!CNDverb(53)) break p000e0924;
			if (!CNDnoun1(77)) break p000e0924;
 		}
		if (!CNDat(4)) break p000e0924;
		if (!CNDcarried(6)) break p000e0924;
		if (!CNDzero(128)) break p000e0924;
 		ACCwrite(1092);
 		ACCnewline();
 		ACCanykey();
 		function anykey00191() 
		{
 		ACCgoto(5);
 		ACCdesc();
		return;
 		ACCdone();
		return;
		}
 		function anykey00190() 
		{
 		ACCwrite(1095);
 		ACCanykey();
 		waitKey(anykey00191);
		}
 		function anykey00189() 
		{
 		ACCwrite(1094);
 		ACCnewline();
 		ACCanykey();
 		waitKey(anykey00190);
		}
 		function anykey00188() 
		{
 		ACCwrite(1093);
 		ACCnewline();
 		ACCanykey();
 		waitKey(anykey00189);
		}
 		waitKey(anykey00188);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// BOTA PLATAFORMA
	p000e0925:
	{
 		if (skipdoall('p000e0925')) break p000e0925;
 		if (in_response)
		{
			if (!CNDverb(53)) break p000e0925;
			if (!CNDnoun1(77)) break p000e0925;
 		}
		if (!CNDat(4)) break p000e0925;
 		ACCwrite(1096);
 		ACCnewline();
 		ACCanykey();
 		function anykey00192() 
		{
 		ACCwrite(1097);
 		ACCnewline();
 		ACCdone();
		return;
		}
 		waitKey(anykey00192);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// BOTA _
	p000e0926:
	{
 		if (skipdoall('p000e0926')) break p000e0926;
 		if (in_response)
		{
			if (!CNDverb(53)) break p000e0926;
 		}
 		ACCwrite(1098);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE PARAGUAS
	p000e0927:
	{
 		if (skipdoall('p000e0927')) break p000e0927;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0927;
			if (!CNDnoun1(76)) break p000e0927;
 		}
		if (!CNDnotcarr(6)) break p000e0927;
 		ACCwrite(1099);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR PARAGUAS
	p000e0928:
	{
 		if (skipdoall('p000e0928')) break p000e0928;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0928;
			if (!CNDnoun1(76)) break p000e0928;
 		}
		if (!CNDnotcarr(6)) break p000e0928;
 		ACCwrite(1100);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE PARAGUAS
	p000e0929:
	{
 		if (skipdoall('p000e0929')) break p000e0929;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0929;
			if (!CNDnoun1(76)) break p000e0929;
 		}
		if (!CNDcarried(6)) break p000e0929;
		if (!CNDnotzero(128)) break p000e0929;
 		ACCwrite(1101);
 		ACCclear(128);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE PARAGUAS
	p000e0930:
	{
 		if (skipdoall('p000e0930')) break p000e0930;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0930;
			if (!CNDnoun1(76)) break p000e0930;
 		}
		if (!CNDcarried(6)) break p000e0930;
		if (!CNDzero(128)) break p000e0930;
 		ACCwrite(1102);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR PARAGUAS
	p000e0931:
	{
 		if (skipdoall('p000e0931')) break p000e0931;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0931;
			if (!CNDnoun1(76)) break p000e0931;
 		}
		if (!CNDcarried(6)) break p000e0931;
		if (!CNDzero(128)) break p000e0931;
 		ACCwrite(1103);
 		ACCset(128);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR PARAGUAS
	p000e0932:
	{
 		if (skipdoall('p000e0932')) break p000e0932;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0932;
			if (!CNDnoun1(76)) break p000e0932;
 		}
		if (!CNDcarried(6)) break p000e0932;
		if (!CNDnotzero(128)) break p000e0932;
 		ACCwrite(1104);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENTRA _
	p000e0933:
	{
 		if (skipdoall('p000e0933')) break p000e0933;
 		if (in_response)
		{
			if (!CNDverb(50)) break p000e0933;
 		}
		if (!CNDat(4)) break p000e0933;
 		ACCgoto(1);
 		ACCdesc();
		break pro000_restart;
 		ACCdone();
		break pro000_restart;
		{}

	}

	// QUITA ANTORCHA
	p000e0934:
	{
 		if (skipdoall('p000e0934')) break p000e0934;
 		if (in_response)
		{
			if (!CNDverb(22)) break p000e0934;
			if (!CNDnoun1(50)) break p000e0934;
 		}
 		ACCmessage(2);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// APAGA ANTORCHA
	p000e0935:
	{
 		if (skipdoall('p000e0935')) break p000e0935;
 		if (in_response)
		{
			if (!CNDverb(45)) break p000e0935;
			if (!CNDnoun1(50)) break p000e0935;
 		}
		if (!CNDozero(1,0)) break p000e0935;
 		ACCwrite(1105);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// APAGA ANTORCHA
	p000e0936:
	{
 		if (skipdoall('p000e0936')) break p000e0936;
 		if (in_response)
		{
			if (!CNDverb(45)) break p000e0936;
			if (!CNDnoun1(50)) break p000e0936;
 		}
		if (!CNDat(13)) break p000e0936;
		if (!CNDonotzero(1,0)) break p000e0936;
 		ACCoclear(1,0);
 		ACCwrite(1106);
 		ACCanykey();
 		function anykey00193() 
		{
 		ACCdesc();
		return;
		}
 		waitKey(anykey00193);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// APAGA ANTORCHA
	p000e0937:
	{
 		if (skipdoall('p000e0937')) break p000e0937;
 		if (in_response)
		{
			if (!CNDverb(45)) break p000e0937;
			if (!CNDnoun1(50)) break p000e0937;
 		}
		if (!CNDonotzero(1,0)) break p000e0937;
 		ACCoclear(1,0);
 		ACCwrite(1107);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENCENDER ANTORCHA
	p000e0938:
	{
 		if (skipdoall('p000e0938')) break p000e0938;
 		if (in_response)
		{
			if (!CNDverb(44)) break p000e0938;
			if (!CNDnoun1(50)) break p000e0938;
 		}
		if (!CNDonotzero(1,0)) break p000e0938;
 		ACCwrite(1108);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENCENDER ANTORCHA
	p000e0939:
	{
 		if (skipdoall('p000e0939')) break p000e0939;
 		if (in_response)
		{
			if (!CNDverb(44)) break p000e0939;
			if (!CNDnoun1(50)) break p000e0939;
 		}
		if (!CNDzero(66)) break p000e0939;
		if (!CNDnotcarr(5)) break p000e0939;
 		ACCwrite(1109);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENCENDER ANTORCHA
	p000e0940:
	{
 		if (skipdoall('p000e0940')) break p000e0940;
 		if (in_response)
		{
			if (!CNDverb(44)) break p000e0940;
			if (!CNDnoun1(50)) break p000e0940;
 		}
		if (!CNDeq(66,5)) break p000e0940;
		if (!CNDnotcarr(5)) break p000e0940;
 		ACCwrite(1110);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENCENDER ANTORCHA
	p000e0941:
	{
 		if (skipdoall('p000e0941')) break p000e0941;
 		if (in_response)
		{
			if (!CNDverb(44)) break p000e0941;
			if (!CNDnoun1(50)) break p000e0941;
 		}
		if (!CNDlt(66,4)) break p000e0941;
		if (!CNDgt(66,0)) break p000e0941;
		if (!CNDozero(1,0)) break p000e0941;
 		ACCwrite(1111);
 		ACCoset(1,0);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENCENDER ANTORCHA
	p000e0942:
	{
 		if (skipdoall('p000e0942')) break p000e0942;
 		if (in_response)
		{
			if (!CNDverb(44)) break p000e0942;
			if (!CNDnoun1(50)) break p000e0942;
 		}
		if (!CNDzero(66)) break p000e0942;
		if (!CNDcarried(5)) break p000e0942;
 		ACCwrite(1112);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENCENDER ANTORCHA
	p000e0943:
	{
 		if (skipdoall('p000e0943')) break p000e0943;
 		if (in_response)
		{
			if (!CNDverb(44)) break p000e0943;
			if (!CNDnoun1(50)) break p000e0943;
 		}
		if (!CNDeq(66,5)) break p000e0943;
		if (!CNDcarried(5)) break p000e0943;
 		ACCwrite(1113);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DEJA CERILLA
	p000e0944:
	{
 		if (skipdoall('p000e0944')) break p000e0944;
 		if (in_response)
		{
			if (!CNDverb(51)) break p000e0944;
			if (!CNDnoun1(74)) break p000e0944;
 		}
		if (!CNDlt(66,4)) break p000e0944;
		if (!CNDgt(66,0)) break p000e0944;
 		ACCwrite(1114);
 		ACCnewline();
 		ACClet(66,5);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LANZA CERILLA
	p000e0945:
	{
 		if (skipdoall('p000e0945')) break p000e0945;
 		if (in_response)
		{
			if (!CNDverb(76)) break p000e0945;
			if (!CNDnoun1(74)) break p000e0945;
 		}
		if (!CNDlt(66,4)) break p000e0945;
		if (!CNDgt(66,0)) break p000e0945;
 		ACCwrite(1115);
 		ACCnewline();
 		ACClet(66,5);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENCENDER CERILLA
	p000e0946:
	{
 		if (skipdoall('p000e0946')) break p000e0946;
 		if (in_response)
		{
			if (!CNDverb(44)) break p000e0946;
			if (!CNDnoun1(74)) break p000e0946;
 		}
		if (!CNDlt(66,4)) break p000e0946;
		if (!CNDgt(66,0)) break p000e0946;
 		ACCwrite(1116);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// APAGA CERILLA
	p000e0947:
	{
 		if (skipdoall('p000e0947')) break p000e0947;
 		if (in_response)
		{
			if (!CNDverb(45)) break p000e0947;
			if (!CNDnoun1(74)) break p000e0947;
 		}
		if (!CNDlt(66,4)) break p000e0947;
		if (!CNDgt(66,0)) break p000e0947;
 		ACCwrite(1117);
 		ACCnewline();
 		ACClet(66,5);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DEJA CERILLA
	p000e0948:
	{
 		if (skipdoall('p000e0948')) break p000e0948;
 		if (in_response)
		{
			if (!CNDverb(51)) break p000e0948;
			if (!CNDnoun1(74)) break p000e0948;
 		}
		if (!CNDzero(66)) break p000e0948;
 		ACCwrite(1118);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DEJA CERILLA
	p000e0949:
	{
 		if (skipdoall('p000e0949')) break p000e0949;
 		if (in_response)
		{
			if (!CNDverb(51)) break p000e0949;
			if (!CNDnoun1(74)) break p000e0949;
 		}
		if (!CNDeq(66,5)) break p000e0949;
 		ACCwrite(1119);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LANZA CERILLA
	p000e0950:
	{
 		if (skipdoall('p000e0950')) break p000e0950;
 		if (in_response)
		{
			if (!CNDverb(76)) break p000e0950;
			if (!CNDnoun1(74)) break p000e0950;
 		}
		if (!CNDzero(66)) break p000e0950;
 		ACCwrite(1120);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LANZA CERILLA
	p000e0951:
	{
 		if (skipdoall('p000e0951')) break p000e0951;
 		if (in_response)
		{
			if (!CNDverb(76)) break p000e0951;
			if (!CNDnoun1(74)) break p000e0951;
 		}
		if (!CNDeq(66,5)) break p000e0951;
 		ACCwrite(1121);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// APAGA CERILLA
	p000e0952:
	{
 		if (skipdoall('p000e0952')) break p000e0952;
 		if (in_response)
		{
			if (!CNDverb(45)) break p000e0952;
			if (!CNDnoun1(74)) break p000e0952;
 		}
		if (!CNDzero(66)) break p000e0952;
 		ACCwrite(1122);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// APAGA CERILLA
	p000e0953:
	{
 		if (skipdoall('p000e0953')) break p000e0953;
 		if (in_response)
		{
			if (!CNDverb(45)) break p000e0953;
			if (!CNDnoun1(74)) break p000e0953;
 		}
		if (!CNDeq(66,5)) break p000e0953;
 		ACCwrite(1123);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENCENDER CERILLA
	p000e0954:
	{
 		if (skipdoall('p000e0954')) break p000e0954;
 		if (in_response)
		{
			if (!CNDverb(44)) break p000e0954;
			if (!CNDnoun1(74)) break p000e0954;
 		}
		if (!CNDnotcarr(5)) break p000e0954;
 		ACCwrite(1124);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENCENDER CERILLA
	p000e0955:
	{
 		if (skipdoall('p000e0955')) break p000e0955;
 		if (in_response)
		{
			if (!CNDverb(44)) break p000e0955;
			if (!CNDnoun1(74)) break p000e0955;
 		}
		if (!CNDcarried(5)) break p000e0955;
		if (!CNDzero(67)) break p000e0955;
 		ACCwrite(1125);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ECHA CAJA
	p000e0956:
	{
 		if (skipdoall('p000e0956')) break p000e0956;
 		if (in_response)
		{
			if (!CNDverb(67)) break p000e0956;
			if (!CNDnoun1(89)) break p000e0956;
 		}
		if (!CNDpresent(5)) break p000e0956;
		if (!CNDabsent(26)) break p000e0956;
		if (!CNDzero(67)) break p000e0956;
 		ACCwrite(1126);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ECHA CAJA
	p000e0957:
	{
 		if (skipdoall('p000e0957')) break p000e0957;
 		if (in_response)
		{
			if (!CNDverb(67)) break p000e0957;
			if (!CNDnoun1(89)) break p000e0957;
 		}
		if (!CNDpresent(5)) break p000e0957;
		if (!CNDabsent(26)) break p000e0957;
		if (!CNDnotzero(67)) break p000e0957;
 		ACCwrite(1127);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ECHA CAJA
	p000e0958:
	{
 		if (skipdoall('p000e0958')) break p000e0958;
 		if (in_response)
		{
			if (!CNDverb(67)) break p000e0958;
			if (!CNDnoun1(89)) break p000e0958;
 		}
		if (!CNDpresent(5)) break p000e0958;
		if (!CNDpresent(26)) break p000e0958;
 		ACCwrite(1128);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ECHA CAJA
	p000e0959:
	{
 		if (skipdoall('p000e0959')) break p000e0959;
 		if (in_response)
		{
			if (!CNDverb(67)) break p000e0959;
			if (!CNDnoun1(89)) break p000e0959;
 		}
		if (!CNDpresent(26)) break p000e0959;
		if (!CNDpresent(5)) break p000e0959;
		if (!CNDnoteq(34,89)) break p000e0959;
 		ACCwrite(1129);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ECHA CAJA
	p000e0960:
	{
 		if (skipdoall('p000e0960')) break p000e0960;
 		if (in_response)
		{
			if (!CNDverb(67)) break p000e0960;
			if (!CNDnoun1(89)) break p000e0960;
 		}
		if (!CNDnoun2(89)) break p000e0960;
		if (!CNDpresent(26)) break p000e0960;
		if (!CNDpresent(5)) break p000e0960;
		if (!CNDnotzero(67)) break p000e0960;
 		ACCwrite(1130);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ECHA CAJA
	p000e0961:
	{
 		if (skipdoall('p000e0961')) break p000e0961;
 		if (in_response)
		{
			if (!CNDverb(67)) break p000e0961;
			if (!CNDnoun1(89)) break p000e0961;
 		}
		if (!CNDnoun2(89)) break p000e0961;
		if (!CNDpresent(26)) break p000e0961;
		if (!CNDpresent(5)) break p000e0961;
		if (!CNDzero(67)) break p000e0961;
 		ACCwrite(1131);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA CERILLA
	p000e0962:
	{
 		if (skipdoall('p000e0962')) break p000e0962;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0962;
			if (!CNDnoun1(74)) break p000e0962;
 		}
		if (!CNDnoun2(89)) break p000e0962;
		if (!CNDcarried(5)) break p000e0962;
		if (!CNDzero(67)) break p000e0962;
 		ACCwrite(1132);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA CERILLA
	p000e0963:
	{
 		if (skipdoall('p000e0963')) break p000e0963;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e0963;
			if (!CNDnoun1(74)) break p000e0963;
 		}
		if (!CNDnoun2(89)) break p000e0963;
		if (!CNDcarried(5)) break p000e0963;
		if (!CNDnotzero(67)) break p000e0963;
 		ACCwrite(1133);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENCENDER CERILLA
	p000e0964:
	{
 		if (skipdoall('p000e0964')) break p000e0964;
 		if (in_response)
		{
			if (!CNDverb(44)) break p000e0964;
			if (!CNDnoun1(74)) break p000e0964;
 		}
		if (!CNDcarried(5)) break p000e0964;
		if (!CNDnotzero(67)) break p000e0964;
		if (!CNDeq(67,1)) break p000e0964;
 		ACCwrite(1134);
		{}

	}

	// ENCENDER CERILLA
	p000e0965:
	{
 		if (skipdoall('p000e0965')) break p000e0965;
 		if (in_response)
		{
			if (!CNDverb(44)) break p000e0965;
			if (!CNDnoun1(74)) break p000e0965;
 		}
		if (!CNDcarried(5)) break p000e0965;
		if (!CNDnotzero(67)) break p000e0965;
 		ACCminus(67,1);
 		ACCwrite(1135);
 		ACClet(66,3);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ENCENDER CHIMENEA
	p000e0966:
	{
 		if (skipdoall('p000e0966')) break p000e0966;
 		if (in_response)
		{
			if (!CNDverb(44)) break p000e0966;
			if (!CNDnoun1(66)) break p000e0966;
 		}
		if (!CNDat(1)) break p000e0966;
 		ACCwrite(1136);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ESPERA _
	p000e0967:
	{
 		if (skipdoall('p000e0967')) break p000e0967;
 		if (in_response)
		{
			if (!CNDverb(46)) break p000e0967;
 		}
 		ACCwrite(1137);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE VENTANA
	p000e0968:
	{
 		if (skipdoall('p000e0968')) break p000e0968;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0968;
			if (!CNDnoun1(70)) break p000e0968;
 		}
		if (!CNDat(1)) break p000e0968;
 		ACCwrite(1138);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR VENTANA
	p000e0969:
	{
 		if (skipdoall('p000e0969')) break p000e0969;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0969;
			if (!CNDnoun1(70)) break p000e0969;
 		}
		if (!CNDat(1)) break p000e0969;
 		ACCwrite(1139);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE PUERTA
	p000e0970:
	{
 		if (skipdoall('p000e0970')) break p000e0970;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0970;
			if (!CNDnoun1(69)) break p000e0970;
 		}
		if (!CNDat(1)) break p000e0970;
 		ACCwrite(1140);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ABRE PUERTA
	p000e0971:
	{
 		if (skipdoall('p000e0971')) break p000e0971;
 		if (in_response)
		{
			if (!CNDverb(43)) break p000e0971;
			if (!CNDnoun1(69)) break p000e0971;
 		}
		if (!CNDat(4)) break p000e0971;
 		ACCwrite(1141);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR PUERTA
	p000e0972:
	{
 		if (skipdoall('p000e0972')) break p000e0972;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0972;
			if (!CNDnoun1(69)) break p000e0972;
 		}
		if (!CNDat(1)) break p000e0972;
 		ACCwrite(1142);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CERRAR PUERTA
	p000e0973:
	{
 		if (skipdoall('p000e0973')) break p000e0973;
 		if (in_response)
		{
			if (!CNDverb(42)) break p000e0973;
			if (!CNDnoun1(69)) break p000e0973;
 		}
		if (!CNDat(4)) break p000e0973;
 		ACCwrite(1143);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE LIBROS
	p000e0974:
	{
 		if (skipdoall('p000e0974')) break p000e0974;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0974;
			if (!CNDnoun1(54)) break p000e0974;
 		}
		if (!CNDat(1)) break p000e0974;
 		ACCwrite(1144);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE ROPA
	p000e0975:
	{
 		if (skipdoall('p000e0975')) break p000e0975;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0975;
			if (!CNDnoun1(60)) break p000e0975;
 		}
		if (!CNDat(1)) break p000e0975;
 		ACCwrite(1145);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE ALFOMBRA
	p000e0976:
	{
 		if (skipdoall('p000e0976')) break p000e0976;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0976;
			if (!CNDnoun1(150)) break p000e0976;
 		}
		if (!CNDat(1)) break p000e0976;
 		ACCwrite(1146);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ELEVA ALFOMBRA
	p000e0977:
	{
 		if (skipdoall('p000e0977')) break p000e0977;
 		if (in_response)
		{
			if (!CNDverb(47)) break p000e0977;
			if (!CNDnoun1(150)) break p000e0977;
 		}
		if (!CNDat(1)) break p000e0977;
 		ACCwrite(1147);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE MAGICOS
	p000e0978:
	{
 		if (skipdoall('p000e0978')) break p000e0978;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0978;
			if (!CNDnoun1(61)) break p000e0978;
 		}
		if (!CNDat(1)) break p000e0978;
 		ACCwrite(1148);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE FOTO
	p000e0979:
	{
 		if (skipdoall('p000e0979')) break p000e0979;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0979;
			if (!CNDnoun1(55)) break p000e0979;
 		}
		if (!CNDat(1)) break p000e0979;
 		ACCwrite(1149);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE CAMA
	p000e0980:
	{
 		if (skipdoall('p000e0980')) break p000e0980;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0980;
			if (!CNDnoun1(56)) break p000e0980;
 		}
		if (!CNDat(1)) break p000e0980;
 		ACCwrite(1150);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE ENSERES
	p000e0981:
	{
 		if (skipdoall('p000e0981')) break p000e0981;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0981;
			if (!CNDnoun1(63)) break p000e0981;
 		}
		if (!CNDat(1)) break p000e0981;
 		ACCwrite(1151);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE CHIMENEA
	p000e0982:
	{
 		if (skipdoall('p000e0982')) break p000e0982;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e0982;
			if (!CNDnoun1(66)) break p000e0982;
 		}
		if (!CNDat(1)) break p000e0982;
 		ACCwrite(1152);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DECIR TERMITA
	p000e0983:
	{
 		if (skipdoall('p000e0983')) break p000e0983;
 		if (in_response)
		{
			if (!CNDverb(31)) break p000e0983;
			if (!CNDnoun1(29)) break p000e0983;
 		}
		if (!CNDnoteq(64,0)) break p000e0983;
		if (!CNDnoteq(64,9)) break p000e0983;
 		ACCwrite(1153);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// MATA TERMITA
	p000e0984:
	{
 		if (skipdoall('p000e0984')) break p000e0984;
 		if (in_response)
		{
			if (!CNDverb(77)) break p000e0984;
			if (!CNDnoun1(29)) break p000e0984;
 		}
		if (!CNDnoteq(64,0)) break p000e0984;
		if (!CNDnoteq(64,9)) break p000e0984;
 		ACCwrite(1154);
 		ACClet(64,9);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// MATA TERMITA
	p000e0985:
	{
 		if (skipdoall('p000e0985')) break p000e0985;
 		if (in_response)
		{
			if (!CNDverb(77)) break p000e0985;
			if (!CNDnoun1(29)) break p000e0985;
 		}
		if (!CNDeq(64,9)) break p000e0985;
 		ACCwrite(1155);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ESCUCHA TERMITA
	p000e0986:
	{
 		if (skipdoall('p000e0986')) break p000e0986;
 		if (in_response)
		{
			if (!CNDverb(41)) break p000e0986;
			if (!CNDnoun1(29)) break p000e0986;
 		}
		if (!CNDeq(64,1)) break p000e0986;
 		ACCplus(64,1);
 		ACCwrite(1156);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ESCUCHA TERMITA
	p000e0987:
	{
 		if (skipdoall('p000e0987')) break p000e0987;
 		if (in_response)
		{
			if (!CNDverb(41)) break p000e0987;
			if (!CNDnoun1(29)) break p000e0987;
 		}
		if (!CNDeq(64,2)) break p000e0987;
 		ACCplus(64,1);
 		ACCwrite(1157);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ESCUCHA TERMITA
	p000e0988:
	{
 		if (skipdoall('p000e0988')) break p000e0988;
 		if (in_response)
		{
			if (!CNDverb(41)) break p000e0988;
			if (!CNDnoun1(29)) break p000e0988;
 		}
		if (!CNDeq(64,3)) break p000e0988;
 		ACCplus(64,1);
 		ACCwrite(1158);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ESCUCHA TERMITA
	p000e0989:
	{
 		if (skipdoall('p000e0989')) break p000e0989;
 		if (in_response)
		{
			if (!CNDverb(41)) break p000e0989;
			if (!CNDnoun1(29)) break p000e0989;
 		}
		if (!CNDeq(64,4)) break p000e0989;
 		ACCplus(64,1);
 		ACCwrite(1159);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ESCUCHA TERMITA
	p000e0990:
	{
 		if (skipdoall('p000e0990')) break p000e0990;
 		if (in_response)
		{
			if (!CNDverb(41)) break p000e0990;
			if (!CNDnoun1(29)) break p000e0990;
 		}
		if (!CNDeq(64,5)) break p000e0990;
 		ACCplus(64,1);
 		ACCwrite(1160);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ESCUCHA TERMITA
	p000e0991:
	{
 		if (skipdoall('p000e0991')) break p000e0991;
 		if (in_response)
		{
			if (!CNDverb(41)) break p000e0991;
			if (!CNDnoun1(29)) break p000e0991;
 		}
		if (!CNDeq(64,6)) break p000e0991;
 		ACCplus(64,1);
 		ACCwrite(1161);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ESCUCHA TERMITA
	p000e0992:
	{
 		if (skipdoall('p000e0992')) break p000e0992;
 		if (in_response)
		{
			if (!CNDverb(41)) break p000e0992;
			if (!CNDnoun1(29)) break p000e0992;
 		}
		if (!CNDeq(64,7)) break p000e0992;
 		ACCplus(64,1);
 		ACCwrite(1162);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ESCUCHA TERMITA
	p000e0993:
	{
 		if (skipdoall('p000e0993')) break p000e0993;
 		if (in_response)
		{
			if (!CNDverb(41)) break p000e0993;
			if (!CNDnoun1(29)) break p000e0993;
 		}
		if (!CNDeq(64,8)) break p000e0993;
 		ACClet(64,1);
 		ACCwrite(1163);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// AYUDA _
	p000e0994:
	{
 		if (skipdoall('p000e0994')) break p000e0994;
 		if (in_response)
		{
			if (!CNDverb(39)) break p000e0994;
 		}
		if (!CNDeq(65,0)) break p000e0994;
 		ACCwrite(1164);
 		ACCnewline();
 		ACCplus(65,1);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// AYUDA _
	p000e0995:
	{
 		if (skipdoall('p000e0995')) break p000e0995;
 		if (in_response)
		{
			if (!CNDverb(39)) break p000e0995;
 		}
		if (!CNDeq(65,1)) break p000e0995;
 		ACCwrite(1165);
 		ACCplus(65,1);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// AYUDA _
	p000e0996:
	{
 		if (skipdoall('p000e0996')) break p000e0996;
 		if (in_response)
		{
			if (!CNDverb(39)) break p000e0996;
 		}
		if (!CNDeq(65,2)) break p000e0996;
 		ACCwrite(1166);
 		ACCplus(65,1);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// AYUDA _
	p000e0997:
	{
 		if (skipdoall('p000e0997')) break p000e0997;
 		if (in_response)
		{
			if (!CNDverb(39)) break p000e0997;
 		}
		if (!CNDeq(65,3)) break p000e0997;
 		ACCwrite(1167);
 		ACCplus(65,1);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// AYUDA _
	p000e0998:
	{
 		if (skipdoall('p000e0998')) break p000e0998;
 		if (in_response)
		{
			if (!CNDverb(39)) break p000e0998;
 		}
		if (!CNDeq(65,4)) break p000e0998;
 		ACCwrite(1168);
 		ACCplus(65,1);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// AYUDA _
	p000e0999:
	{
 		if (skipdoall('p000e0999')) break p000e0999;
 		if (in_response)
		{
			if (!CNDverb(39)) break p000e0999;
 		}
		if (!CNDeq(65,5)) break p000e0999;
 		ACCwrite(1169);
 		ACCplus(65,1);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// AYUDA _
	p000e1000:
	{
 		if (skipdoall('p000e1000')) break p000e1000;
 		if (in_response)
		{
			if (!CNDverb(39)) break p000e1000;
 		}
		if (!CNDeq(65,6)) break p000e1000;
 		ACCwrite(1170);
 		ACCplus(65,1);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// AYUDA _
	p000e1001:
	{
 		if (skipdoall('p000e1001')) break p000e1001;
 		if (in_response)
		{
			if (!CNDverb(39)) break p000e1001;
 		}
		if (!CNDeq(65,7)) break p000e1001;
 		ACCwrite(1171);
 		ACCplus(65,1);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// AYUDA _
	p000e1002:
	{
 		if (skipdoall('p000e1002')) break p000e1002;
 		if (in_response)
		{
			if (!CNDverb(39)) break p000e1002;
 		}
		if (!CNDeq(65,8)) break p000e1002;
 		ACCwrite(1172);
 		ACCplus(65,1);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// AYUDA _
	p000e1003:
	{
 		if (skipdoall('p000e1003')) break p000e1003;
 		if (in_response)
		{
			if (!CNDverb(39)) break p000e1003;
 		}
		if (!CNDeq(65,9)) break p000e1003;
 		ACCwrite(1173);
 		ACCplus(65,1);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// AYUDA _
	p000e1004:
	{
 		if (skipdoall('p000e1004')) break p000e1004;
 		if (in_response)
		{
			if (!CNDverb(39)) break p000e1004;
 		}
		if (!CNDeq(65,10)) break p000e1004;
 		ACCwrite(1174);
 		ACCanykey();
 		function anykey00194() 
		{
 		ACCnewline();
 		ACCwrite(1175);
 		ACCnewline();
 		ACCplus(65,1);
 		ACCdone();
		return;
		}
 		waitKey(anykey00194);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// AYUDA _
	p000e1005:
	{
 		if (skipdoall('p000e1005')) break p000e1005;
 		if (in_response)
		{
			if (!CNDverb(39)) break p000e1005;
 		}
		if (!CNDeq(65,11)) break p000e1005;
 		ACCwrite(1176);
 		ACCanykey();
 		function anykey00198() 
		{
 		ACCwrite(1180);
 		ACCnewline();
 		ACCdone();
		return;
		}
 		function anykey00197() 
		{
 		ACCnewline();
 		ACCwrite(1179);
 		ACCnewline();
 		ACCanykey();
 		waitKey(anykey00198);
		}
 		function anykey00196() 
		{
 		ACCwrite(1178);
 		ACCanykey();
 		waitKey(anykey00197);
		}
 		function anykey00195() 
		{
 		ACCnewline();
 		ACCwrite(1177);
 		ACCnewline();
 		ACCanykey();
 		waitKey(anykey00196);
		}
 		waitKey(anykey00195);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// BOING _
	p000e1006:
	{
 		if (skipdoall('p000e1006')) break p000e1006;
 		if (in_response)
		{
			if (!CNDverb(38)) break p000e1006;
 		}
		if (!CNDnotat(2)) break p000e1006;
 		ACClet(64,getFlag(38));
 		ACClet(38,2);
 		ACCdesc();
		break pro000_restart;
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// BOING _
	p000e1007:
	{
 		if (skipdoall('p000e1007')) break p000e1007;
 		if (in_response)
		{
			if (!CNDverb(38)) break p000e1007;
 		}
		if (!CNDat(2)) break p000e1007;
 		ACClet(38,getFlag(64));
 		ACCdesc();
		break pro000_restart;
 		ACCdone();
		break pro000_restart;
		{}

	}

	// CANTA _
	p000e1008:
	{
 		if (skipdoall('p000e1008')) break p000e1008;
 		if (in_response)
		{
			if (!CNDverb(37)) break p000e1008;
 		}
 		ACCwrite(1181);
 		ACCnewline();
 		ACCwrite(1182);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// EMPUJA _
	p000e1009:
	{
 		if (skipdoall('p000e1009')) break p000e1009;
 		if (in_response)
		{
			if (!CNDverb(36)) break p000e1009;
 		}
 		ACCwrite(1183);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DESCANSA _
	p000e1010:
	{
 		if (skipdoall('p000e1010')) break p000e1010;
 		if (in_response)
		{
			if (!CNDverb(35)) break p000e1010;
 		}
		if (!CNDat(1)) break p000e1010;
 		ACCwrite(1184);
 		ACCnewline();
 		ACCwrite(1185);
 		ACCnewline();
 		ACCanykey();
 		function anykey00200() 
		{
 		ACCdesc();
		return;
 		ACCdone();
		return;
		}
 		function anykey00199() 
		{
 		ACCcls();
 		ACCpicture(7);
 		ACCwrite(1186);
 		ACCnewline();
 		ACCnewline();
 		ACCpause(50);
 		ACCwrite(1187);
 		ACCnewline();
 		ACCnewline();
 		ACCwrite(1188);
 		ACCnewline();
 		ACCnewline();
 		ACCpause(50);
 		ACCwrite(1189);
 		ACCnewline();
 		ACCnewline();
 		ACCpause(50);
 		ACCwrite(1190);
 		ACCnewline();
 		ACCnewline();
 		ACCpause(50);
 		ACCwrite(1191);
 		ACCnewline();
 		ACCanykey();
 		waitKey(anykey00200);
		}
 		waitKey(anykey00199);
		done_flag=true;
		break pro000_restart;
		{}

	}

	// DESCANSA _
	p000e1011:
	{
 		if (skipdoall('p000e1011')) break p000e1011;
 		if (in_response)
		{
			if (!CNDverb(35)) break p000e1011;
 		}
		if (!CNDnotat(1)) break p000e1011;
 		ACCwrite(1192);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// XYZZY _
	p000e1012:
	{
 		if (skipdoall('p000e1012')) break p000e1012;
 		if (in_response)
		{
			if (!CNDverb(33)) break p000e1012;
 		}
 		ACCwrite(1193);
 		ACCnewline();
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LEE LIBRO
	p000e1013:
	{
 		if (skipdoall('p000e1013')) break p000e1013;
 		if (in_response)
		{
			if (!CNDverb(32)) break p000e1013;
			if (!CNDnoun1(53)) break p000e1013;
 		}
		if (!CNDpresent(1)) break p000e1013;
		if (!CNDeq(61,0)) break p000e1013;
 		ACCmessage(8);
 		ACCmessage(9);
 		ACCmessage(10);
 		ACCmessage(11);
 		ACCmessage(12);
 		ACClet(61,1);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LEE LIBRO
	p000e1014:
	{
 		if (skipdoall('p000e1014')) break p000e1014;
 		if (in_response)
		{
			if (!CNDverb(32)) break p000e1014;
			if (!CNDnoun1(53)) break p000e1014;
 		}
		if (!CNDpresent(1)) break p000e1014;
		if (!CNDeq(61,1)) break p000e1014;
 		ACCmessage(13);
 		ACClet(61,2);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LEE LIBRO
	p000e1015:
	{
 		if (skipdoall('p000e1015')) break p000e1015;
 		if (in_response)
		{
			if (!CNDverb(32)) break p000e1015;
			if (!CNDnoun1(53)) break p000e1015;
 		}
		if (!CNDpresent(1)) break p000e1015;
		if (!CNDeq(61,2)) break p000e1015;
 		ACCmessage(14);
 		ACClet(61,3);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LEE LIBRO
	p000e1016:
	{
 		if (skipdoall('p000e1016')) break p000e1016;
 		if (in_response)
		{
			if (!CNDverb(32)) break p000e1016;
			if (!CNDnoun1(53)) break p000e1016;
 		}
		if (!CNDpresent(1)) break p000e1016;
		if (!CNDeq(61,3)) break p000e1016;
 		ACCmessage(15);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE TERMITA
	p000e1017:
	{
 		if (skipdoall('p000e1017')) break p000e1017;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e1017;
			if (!CNDnoun1(29)) break p000e1017;
 		}
		if (!CNDnotzero(64)) break p000e1017;
		if (!CNDnoteq(64,9)) break p000e1017;
 		ACCwrite(1194);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE _
	p000e1018:
	{
 		if (skipdoall('p000e1018')) break p000e1018;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e1018;
 		}
		if (!CNDlt(34,50)) break p000e1018;
		if (!CNDnoteq(34,20)) break p000e1018;
 		ACCwrite(1195);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// ESCUCHA _
	p000e1019:
	{
 		if (skipdoall('p000e1019')) break p000e1019;
 		if (in_response)
		{
			if (!CNDverb(41)) break p000e1019;
 		}
 		ACCwrite(1196);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// HUELE _
	p000e1020:
	{
 		if (skipdoall('p000e1020')) break p000e1020;
 		if (in_response)
		{
			if (!CNDverb(72)) break p000e1020;
 		}
		if (!CNDatlt(27)) break p000e1020;
		if (!CNDatgt(23)) break p000e1020;
 		ACCwrite(1197);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// HUELE _
	p000e1021:
	{
 		if (skipdoall('p000e1021')) break p000e1021;
 		if (in_response)
		{
			if (!CNDverb(72)) break p000e1021;
 		}
 		ACCwrite(1198);
 		ACCdone();
		break pro000_restart;
		{}

	}

	//  _
	p000e1022:
	{
 		if (skipdoall('p000e1022')) break p000e1022;
 		if (in_response)
		{
			if (!CNDverb(14)) break p000e1022;
 		}
		if (!CNDnotzero(113)) break p000e1022;
 		ACCwrite(1199);
		{}

	}

	//  _
	p000e1023:
	{
 		if (skipdoall('p000e1023')) break p000e1023;
 		if (in_response)
		{
			if (!CNDverb(14)) break p000e1023;
 		}
 		ACCinven();
		break pro000_restart;
		{}

	}

	// DEJA ANTORCHA
	p000e1024:
	{
 		if (skipdoall('p000e1024')) break p000e1024;
 		if (in_response)
		{
			if (!CNDverb(51)) break p000e1024;
			if (!CNDnoun1(50)) break p000e1024;
 		}
 		ACCmessage(2);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// QUITA CAPUCHA
	p000e1025:
	{
 		if (skipdoall('p000e1025')) break p000e1025;
 		if (in_response)
		{
			if (!CNDverb(22)) break p000e1025;
			if (!CNDnoun1(52)) break p000e1025;
 		}
 		ACCmessage(1);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LOOK _
	p000e1026:
	{
 		if (skipdoall('p000e1026')) break p000e1026;
 		if (in_response)
		{
			if (!CNDverb(24)) break p000e1026;
 		}
 		ACCdesc();
		break pro000_restart;
		{}

	}

	// SAL _
	p000e1027:
	{
 		if (skipdoall('p000e1027')) break p000e1027;
 		if (in_response)
		{
			if (!CNDverb(49)) break p000e1027;
 		}
		if (!CNDat(29)) break p000e1027;
		if (!CNDzero(102)) break p000e1027;
 		ACCgoto(28);
 		ACCdesc();
		break pro000_restart;
 		ACCdone();
		break pro000_restart;
		{}

	}

	// SAL _
	p000e1028:
	{
 		if (skipdoall('p000e1028')) break p000e1028;
 		if (in_response)
		{
			if (!CNDverb(49)) break p000e1028;
 		}
		if (!CNDat(29)) break p000e1028;
		if (!CNDnotzero(102)) break p000e1028;
		if (!CNDnotcarr(23)) break p000e1028;
 		ACCgoto(28);
 		ACCdesc();
		break pro000_restart;
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DA _
	p000e1029:
	{
 		if (skipdoall('p000e1029')) break p000e1029;
 		if (in_response)
		{
			if (!CNDverb(75)) break p000e1029;
 		}
 		ACCwhatox(11);
		if (!CNDnoteq(11,255)) break p000e1029;
		if (!CNDnotcarr(getFlag(11))) break p000e1029;
 		ACCwrite(1200);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DA _
	p000e1030:
	{
 		if (skipdoall('p000e1030')) break p000e1030;
 		if (in_response)
		{
			if (!CNDverb(75)) break p000e1030;
 		}
 		ACCwhatox(11);
		if (!CNDeq(11,255)) break p000e1030;
 		ACCwrite(1201);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DA _
	p000e1031:
	{
 		if (skipdoall('p000e1031')) break p000e1031;
 		if (in_response)
		{
			if (!CNDverb(75)) break p000e1031;
 		}
		if (!CNDnoun2(29)) break p000e1031;
		if (!CNDnotzero(64)) break p000e1031;
		if (!CNDnoteq(64,9)) break p000e1031;
 		ACCwrite(1202);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DA _
	p000e1032:
	{
 		if (skipdoall('p000e1032')) break p000e1032;
 		if (in_response)
		{
			if (!CNDverb(75)) break p000e1032;
 		}
		if (!CNDnoun2(26)) break p000e1032;
		if (!CNDzero(109)) break p000e1032;
		if (!CNDat(32)) break p000e1032;
 		ACCwrite(1203);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DA _
	p000e1033:
	{
 		if (skipdoall('p000e1033')) break p000e1033;
 		if (in_response)
		{
			if (!CNDverb(75)) break p000e1033;
 		}
		if (!CNDnoun2(26)) break p000e1033;
		if (!CNDnotzero(109)) break p000e1033;
		if (!CNDsame(38,118)) break p000e1033;
 		ACCwrite(1204);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DA _
	p000e1034:
	{
 		if (skipdoall('p000e1034')) break p000e1034;
 		if (in_response)
		{
			if (!CNDverb(75)) break p000e1034;
 		}
		if (!CNDnoun2(24)) break p000e1034;
		if (!CNDat(33)) break p000e1034;
 		ACCwrite(1205);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DA _
	p000e1035:
	{
 		if (skipdoall('p000e1035')) break p000e1035;
 		if (in_response)
		{
			if (!CNDverb(75)) break p000e1035;
 		}
		if (!CNDnoun2(21)) break p000e1035;
		if (!CNDat(13)) break p000e1035;
 		ACCwrite(1206);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DA _
	p000e1036:
	{
 		if (skipdoall('p000e1036')) break p000e1036;
 		if (in_response)
		{
			if (!CNDverb(75)) break p000e1036;
 		}
		if (!CNDnoun2(23)) break p000e1036;
		if (!CNDnoteq(34,255)) break p000e1036;
		if (!CNDnotzero(85)) break p000e1036;
		if (!CNDsame(38,86)) break p000e1036;
 		ACCwrite(1207);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DA _
	p000e1037:
	{
 		if (skipdoall('p000e1037')) break p000e1037;
 		if (in_response)
		{
			if (!CNDverb(75)) break p000e1037;
 		}
		if (!CNDnoun2(28)) break p000e1037;
		if (!CNDat(12)) break p000e1037;
		if (!CNDeq(78,2)) break p000e1037;
		if (!CNDnoteq(34,255)) break p000e1037;
 		ACCwrite(1208);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DA _
	p000e1038:
	{
 		if (skipdoall('p000e1038')) break p000e1038;
 		if (in_response)
		{
			if (!CNDverb(75)) break p000e1038;
 		}
		if (!CNDnoun2(22)) break p000e1038;
		if (!CNDat(13)) break p000e1038;
 		ACCwrite(1209);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DA _
	p000e1039:
	{
 		if (skipdoall('p000e1039')) break p000e1039;
 		if (in_response)
		{
			if (!CNDverb(75)) break p000e1039;
 		}
		if (!CNDnoun2(25)) break p000e1039;
		if (!CNDat(32)) break p000e1039;
 		ACCwrite(1210);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DA _
	p000e1040:
	{
 		if (skipdoall('p000e1040')) break p000e1040;
 		if (in_response)
		{
			if (!CNDverb(75)) break p000e1040;
 		}
		if (!CNDnoun2(25)) break p000e1040;
		if (!CNDat(30)) break p000e1040;
 		ACCwrite(1211);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DA _
	p000e1041:
	{
 		if (skipdoall('p000e1041')) break p000e1041;
 		if (in_response)
		{
			if (!CNDverb(75)) break p000e1041;
 		}
		if (!CNDeq(44,255)) break p000e1041;
 		ACCwrite(1212);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DA _
	p000e1042:
	{
 		if (skipdoall('p000e1042')) break p000e1042;
 		if (in_response)
		{
			if (!CNDverb(75)) break p000e1042;
 		}
		if (!CNDlt(44,50)) break p000e1042;
 		ACCwrite(1213);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DA _
	p000e1043:
	{
 		if (skipdoall('p000e1043')) break p000e1043;
 		if (in_response)
		{
			if (!CNDverb(75)) break p000e1043;
 		}
		if (!CNDgt(44,50)) break p000e1043;
 		ACCwrite(1214);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA _
	p000e1044:
	{
 		if (skipdoall('p000e1044')) break p000e1044;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e1044;
 		}
 		ACCwhatox(11);
		if (!CNDeq(11,255)) break p000e1044;
 		ACCwrite(1215);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA _
	p000e1045:
	{
 		if (skipdoall('p000e1045')) break p000e1045;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e1045;
 		}
		if (!CNDeq(44,255)) break p000e1045;
 		ACCwrite(1216);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// RETIRA _
	p000e1046:
	{
 		if (skipdoall('p000e1046')) break p000e1046;
 		if (in_response)
		{
			if (!CNDverb(58)) break p000e1046;
 		}
		if (!CNDnoteq(44,255)) break p000e1046;
 		ACCwrite(1217);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA _
	p000e1047:
	{
 		if (skipdoall('p000e1047')) break p000e1047;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e1047;
 		}
 		ACCwhatox(11);
		if (!CNDeq(11,255)) break p000e1047;
 		ACCwrite(1218);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA _
	p000e1048:
	{
 		if (skipdoall('p000e1048')) break p000e1048;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e1048;
 		}
		if (!CNDeq(44,255)) break p000e1048;
 		ACCwrite(1219);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA _
	p000e1049:
	{
 		if (skipdoall('p000e1049')) break p000e1049;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e1049;
 		}
 		ACCwrite(1220);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// QUEMA _
	p000e1050:
	{
 		if (skipdoall('p000e1050')) break p000e1050;
 		if (in_response)
		{
			if (!CNDverb(64)) break p000e1050;
 		}
		if (!CNDnoun2(25)) break p000e1050;
		if (!CNDat(30)) break p000e1050;
		if (!CNDzero(121)) break p000e1050;
 		ACCwrite(1221);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// QUEMA _
	p000e1051:
	{
 		if (skipdoall('p000e1051')) break p000e1051;
 		if (in_response)
		{
			if (!CNDverb(64)) break p000e1051;
 		}
		if (!CNDnoun2(25)) break p000e1051;
		if (!CNDat(30)) break p000e1051;
		if (!CNDnotzero(121)) break p000e1051;
 		ACCwrite(1222);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// QUEMA _
	p000e1052:
	{
 		if (skipdoall('p000e1052')) break p000e1052;
 		if (in_response)
		{
			if (!CNDverb(64)) break p000e1052;
 		}
		if (!CNDnoun2(25)) break p000e1052;
		if (!CNDat(32)) break p000e1052;
		if (!CNDzero(117)) break p000e1052;
 		ACCwrite(1223);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// QUEMA _
	p000e1053:
	{
 		if (skipdoall('p000e1053')) break p000e1053;
 		if (in_response)
		{
			if (!CNDverb(64)) break p000e1053;
 		}
		if (!CNDnoun2(25)) break p000e1053;
		if (!CNDat(32)) break p000e1053;
		if (!CNDnotzero(117)) break p000e1053;
 		ACCwrite(1224);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// QUEMA _
	p000e1054:
	{
 		if (skipdoall('p000e1054')) break p000e1054;
 		if (in_response)
		{
			if (!CNDverb(64)) break p000e1054;
 		}
		if (!CNDeq(34,255)) break p000e1054;
 		ACCwrite(1225);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// QUEMA _
	p000e1055:
	{
 		if (skipdoall('p000e1055')) break p000e1055;
 		if (in_response)
		{
			if (!CNDverb(64)) break p000e1055;
 		}
		if (!CNDlt(34,50)) break p000e1055;
 		ACCwrite(1226);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// QUEMA _
	p000e1056:
	{
 		if (skipdoall('p000e1056')) break p000e1056;
 		if (in_response)
		{
			if (!CNDverb(64)) break p000e1056;
 		}
		if (!CNDgt(34,50)) break p000e1056;
 		ACCwrite(1227);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA AGOSTINE
	p000e1057:
	{
 		if (skipdoall('p000e1057')) break p000e1057;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e1057;
			if (!CNDnoun1(26)) break p000e1057;
 		}
		if (!CNDzero(113)) break p000e1057;
		if (!CNDeq(44,255)) break p000e1057;
 		ACCwrite(1228);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COLOCA AGOSTINE
	p000e1058:
	{
 		if (skipdoall('p000e1058')) break p000e1058;
 		if (in_response)
		{
			if (!CNDverb(59)) break p000e1058;
			if (!CNDnoun1(26)) break p000e1058;
 		}
		if (!CNDzero(113)) break p000e1058;
		if (!CNDnoteq(44,255)) break p000e1058;
 		ACCwrite(1229);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LANZA _
	p000e1059:
	{
 		if (skipdoall('p000e1059')) break p000e1059;
 		if (in_response)
		{
			if (!CNDverb(76)) break p000e1059;
 		}
		if (!CNDeq(34,255)) break p000e1059;
 		ACCwrite(1230);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// LANZA _
	p000e1060:
	{
 		if (skipdoall('p000e1060')) break p000e1060;
 		if (in_response)
		{
			if (!CNDverb(76)) break p000e1060;
 		}
 		ACCwrite(1231);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// BUCEA _
	p000e1061:
	{
 		if (skipdoall('p000e1061')) break p000e1061;
 		if (in_response)
		{
			if (!CNDverb(73)) break p000e1061;
 		}
		if (!CNDnotat(12)) break p000e1061;
 		ACCwrite(1232);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// BEBE _
	p000e1062:
	{
 		if (skipdoall('p000e1062')) break p000e1062;
 		if (in_response)
		{
			if (!CNDverb(68)) break p000e1062;
 		}
		if (!CNDeq(34,255)) break p000e1062;
 		ACCwrite(1233);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// BEBE _
	p000e1063:
	{
 		if (skipdoall('p000e1063')) break p000e1063;
 		if (in_response)
		{
			if (!CNDverb(68)) break p000e1063;
 		}
		if (!CNDnoteq(34,105)) break p000e1063;
		if (!CNDnoteq(34,103)) break p000e1063;
 		ACCwrite(1234);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// EX _
	p000e1064:
	{
 		if (skipdoall('p000e1064')) break p000e1064;
 		if (in_response)
		{
			if (!CNDverb(30)) break p000e1064;
 		}
 		ACCprocess(3);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// FIN _
	p000e1065:
	{
 		if (skipdoall('p000e1065')) break p000e1065;
 		if (in_response)
		{
			if (!CNDverb(25)) break p000e1065;
 		}
		if (!CNDquit()) break p000e1065;
 		ACCturns();
 		ACCend();
		break pro000_restart;
		{}

	}

	// GRABA _
	p000e1066:
	{
 		if (skipdoall('p000e1066')) break p000e1066;
 		if (in_response)
		{
			if (!CNDverb(26)) break p000e1066;
 		}
 		ACCsave();
		break pro000_restart;
		{}

	}

	// CARGA _
	p000e1067:
	{
 		if (skipdoall('p000e1067')) break p000e1067;
 		if (in_response)
		{
			if (!CNDverb(27)) break p000e1067;
 		}
 		ACCload();
		break pro000_restart;
		{}

	}

	// RAMSAVE _
	p000e1068:
	{
 		if (skipdoall('p000e1068')) break p000e1068;
 		if (in_response)
		{
			if (!CNDverb(28)) break p000e1068;
 		}
 		ACCramsave();
 		ACCdesc();
		break pro000_restart;
		{}

	}

	// RAMLOAD _
	p000e1069:
	{
 		if (skipdoall('p000e1069')) break p000e1069;
 		if (in_response)
		{
			if (!CNDverb(29)) break p000e1069;
 		}
 		ACCramload(255);
 		ACCdesc();
		break pro000_restart;
		{}

	}

	// SUBE _
	p000e1070:
	{
 		if (skipdoall('p000e1070')) break p000e1070;
 		if (in_response)
		{
			if (!CNDverb(10)) break p000e1070;
 		}
 		ACCwrite(1235);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// BAJA _
	p000e1071:
	{
 		if (skipdoall('p000e1071')) break p000e1071;
 		if (in_response)
		{
			if (!CNDverb(11)) break p000e1071;
 		}
 		ACCwrite(1236);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE TODO
	p000e1072:
	{
 		if (skipdoall('p000e1072')) break p000e1072;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e1072;
			if (!CNDnoun1(20)) break p000e1072;
 		}
 		ACCobjat(getFlag(38),73);
		if (!CNDzero(73)) break p000e1072;
 		ACCwrite(1237);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE TODO
	p000e1073:
	{
 		if (skipdoall('p000e1073')) break p000e1073;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e1073;
			if (!CNDnoun1(20)) break p000e1073;
 		}
		entry_for_doall = 'p000e1074';
		process_in_doall = 0;
 		ACCdoall(255);
		break pro000_restart;
		{}

	}

	// COGE _
	p000e1074:
	{
 		if (skipdoall('p000e1074')) break p000e1074;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e1074;
 		}
 		ACCwhato();
		{}

	}

	// COGE _
	p000e1075:
	{
 		if (skipdoall('p000e1075')) break p000e1075;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e1075;
 		}
		if (!CNDeq(51,255)) break p000e1075;
 		ACCsysmess(26);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE _
	p000e1076:
	{
 		if (skipdoall('p000e1076')) break p000e1076;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e1076;
 		}
		if (!CNDnoteq(51,255)) break p000e1076;
		if (!CNDcarried(getFlag(51))) break p000e1076;
 		ACCwrite(1238);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE _
	p000e1077:
	{
 		if (skipdoall('p000e1077')) break p000e1077;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e1077;
 		}
		if (!CNDnoteq(51,255)) break p000e1077;
		if (!CNDworn(getFlag(51))) break p000e1077;
 		ACCwrite(1239);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE _
	p000e1078:
	{
 		if (skipdoall('p000e1078')) break p000e1078;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e1078;
 		}
		if (!CNDnoteq(51,255)) break p000e1078;
		if (!CNDabsent(getFlag(51))) break p000e1078;
 		ACCsysmess(26);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGE _
	p000e1079:
	{
 		if (skipdoall('p000e1079')) break p000e1079;
 		if (in_response)
		{
			if (!CNDverb(20)) break p000e1079;
 		}
		if (!CNDpresent(getFlag(51))) break p000e1079;
 		ACCget(getFlag(51));
		if (!success) break pro000_restart;
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DEJA TODO
	p000e1080:
	{
 		if (skipdoall('p000e1080')) break p000e1080;
 		if (in_response)
		{
			if (!CNDverb(51)) break p000e1080;
			if (!CNDnoun1(20)) break p000e1080;
 		}
		entry_for_doall = 'p000e1081';
		process_in_doall = 0;
 		ACCdoall(254);
		break pro000_restart;
		{}

	}

	// DEJA _
	p000e1081:
	{
 		if (skipdoall('p000e1081')) break p000e1081;
 		if (in_response)
		{
			if (!CNDverb(51)) break p000e1081;
 		}
 		ACCwhato();
		{}

	}

	// DEJA ANTORCHA
	p000e1082:
	{
 		if (skipdoall('p000e1082')) break p000e1082;
 		if (in_response)
		{
			if (!CNDverb(51)) break p000e1082;
			if (!CNDnoun1(50)) break p000e1082;
 		}
 		ACCmessage(2);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DEJA PARAGUAS
	p000e1083:
	{
 		if (skipdoall('p000e1083')) break p000e1083;
 		if (in_response)
		{
			if (!CNDverb(51)) break p000e1083;
			if (!CNDnoun1(76)) break p000e1083;
 		}
		if (!CNDnotat(1)) break p000e1083;
		if (!CNDnotat(4)) break p000e1083;
 		ACCwrite(1240);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DEJA _
	p000e1084:
	{
 		if (skipdoall('p000e1084')) break p000e1084;
 		if (in_response)
		{
			if (!CNDverb(51)) break p000e1084;
 		}
		if (!CNDeq(51,255)) break p000e1084;
 		ACCwrite(1241);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DEJA _
	p000e1085:
	{
 		if (skipdoall('p000e1085')) break p000e1085;
 		if (in_response)
		{
			if (!CNDverb(51)) break p000e1085;
 		}
		if (!CNDworn(getFlag(51))) break p000e1085;
 		ACCwrite(1242);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DEJA _
	p000e1086:
	{
 		if (skipdoall('p000e1086')) break p000e1086;
 		if (in_response)
		{
			if (!CNDverb(51)) break p000e1086;
 		}
		if (!CNDnoteq(51,255)) break p000e1086;
		if (!CNDnotcarr(getFlag(51))) break p000e1086;
 		ACCwrite(1243);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// DEJA _
	p000e1087:
	{
 		if (skipdoall('p000e1087')) break p000e1087;
 		if (in_response)
		{
			if (!CNDverb(51)) break p000e1087;
 		}
 		ACCdrop(getFlag(51));
		if (!success) break pro000_restart;
 		ACCdone();
		break pro000_restart;
		{}

	}

	// QUITA TODO
	p000e1088:
	{
 		if (skipdoall('p000e1088')) break p000e1088;
 		if (in_response)
		{
			if (!CNDverb(22)) break p000e1088;
			if (!CNDnoun1(20)) break p000e1088;
 		}
		entry_for_doall = 'p000e1089';
		process_in_doall = 0;
 		ACCdoall(253);
		break pro000_restart;
		{}

	}

	// QUITA _
	p000e1089:
	{
 		if (skipdoall('p000e1089')) break p000e1089;
 		if (in_response)
		{
			if (!CNDverb(22)) break p000e1089;
 		}
 		ACCwhato();
		{}

	}

	// QUITA CAPUCHA
	p000e1090:
	{
 		if (skipdoall('p000e1090')) break p000e1090;
 		if (in_response)
		{
			if (!CNDverb(22)) break p000e1090;
			if (!CNDnoun1(52)) break p000e1090;
 		}
 		ACCmessage(1);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// QUITA _
	p000e1091:
	{
 		if (skipdoall('p000e1091')) break p000e1091;
 		if (in_response)
		{
			if (!CNDverb(22)) break p000e1091;
 		}
		if (!CNDeq(51,255)) break p000e1091;
 		ACCwrite(1244);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// QUITA _
	p000e1092:
	{
 		if (skipdoall('p000e1092')) break p000e1092;
 		if (in_response)
		{
			if (!CNDverb(22)) break p000e1092;
 		}
		if (!CNDnotworn(getFlag(51))) break p000e1092;
 		ACCwrite(1245);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// QUITA _
	p000e1093:
	{
 		if (skipdoall('p000e1093')) break p000e1093;
 		if (in_response)
		{
			if (!CNDverb(22)) break p000e1093;
 		}
 		ACCremove(getFlag(51));
		if (!success) break pro000_restart;
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGELA TODO
	p000e1094:
	{
 		if (skipdoall('p000e1094')) break p000e1094;
 		if (in_response)
		{
			if (!CNDverb(21)) break p000e1094;
			if (!CNDnoun1(20)) break p000e1094;
 		}
		entry_for_doall = 'p000e1095';
		process_in_doall = 0;
 		ACCdoall(254);
		break pro000_restart;
		{}

	}

	// COGELA _
	p000e1095:
	{
 		if (skipdoall('p000e1095')) break p000e1095;
 		if (in_response)
		{
			if (!CNDverb(21)) break p000e1095;
 		}
 		ACCwhato();
		{}

	}

	// COGELA _
	p000e1096:
	{
 		if (skipdoall('p000e1096')) break p000e1096;
 		if (in_response)
		{
			if (!CNDverb(21)) break p000e1096;
 		}
		if (!CNDeq(51,254)) break p000e1096;
 		ACCwrite(1246);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGELA _
	p000e1097:
	{
 		if (skipdoall('p000e1097')) break p000e1097;
 		if (in_response)
		{
			if (!CNDverb(21)) break p000e1097;
 		}
		if (!CNDnoteq(51,254)) break p000e1097;
		if (!CNDworn(getFlag(51))) break p000e1097;
 		ACCwrite(1247);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// COGELA _
	p000e1098:
	{
 		if (skipdoall('p000e1098')) break p000e1098;
 		if (in_response)
		{
			if (!CNDverb(21)) break p000e1098;
 		}
		if (!CNDnoteq(getFlag(51),254)) break p000e1098;
		if (!CNDnotworn(getFlag(51))) break p000e1098;
 		ACCwrite(1248);
 		ACCdone();
		break pro000_restart;
		{}

	}

	// _ _
	p000e1099:
	{
 		if (skipdoall('p000e1099')) break p000e1099;
		if (!CNDeq(33,255)) break p000e1099;
 		ACCwrite(1249);
 		ACCdone();
		break pro000_restart;
		{}

	}


}
}

function pro001()
{
process_restart=true;
pro001_restart: while(process_restart)
{
	process_restart=false;
	// _ _
	p001e0000:
	{
 		if (skipdoall('p001e0000')) break p001e0000;
		if (!CNDat(0)) break p001e0000;
 		ACCbset(12,5);
 		ACCtitle(1250);
 		ACCgraphic(1);
 		ACClet(53,64);
 		ACCpicture(0);
 		ACCanykey();
 		function anykey00201() 
		{
 		ACCability(100,100);
 		ACCclear(60);
 		ACCclear(61);
 		ACCclear(62);
 		ACCclear(63);
 		ACCclear(65);
 		ACCclear(64);
 		ACCclear(66);
 		ACClet(67,5);
 		ACCclear(68);
 		ACCclear(69);
 		ACCclear(70);
 		ACCclear(71);
 		ACCclear(72);
 		ACCclear(73);
 		ACCclear(74);
 		ACCclear(75);
 		ACCclear(76);
 		ACCclear(77);
 		ACCclear(78);
 		ACCclear(79);
 		ACCclear(80);
 		ACCclear(81);
 		ACCclear(82);
 		ACCclear(83);
 		ACCclear(84);
 		ACCclear(85);
 		ACCclear(86);
 		ACCclear(87);
 		ACCclear(88);
 		ACCclear(89);
 		ACCclear(90);
 		ACCclear(91);
 		ACCclear(92);
 		ACCclear(93);
 		ACCclear(94);
 		ACCclear(95);
 		ACCclear(96);
 		ACCclear(97);
 		ACCclear(98);
 		ACCclear(99);
 		ACCclear(100);
 		ACCclear(101);
 		ACCclear(102);
 		ACCclear(103);
 		ACCclear(104);
 		ACCclear(105);
 		ACCclear(106);
 		ACCclear(107);
 		ACCclear(108);
 		ACCclear(109);
 		ACCclear(110);
 		ACCclear(111);
 		ACCclear(112);
 		ACCclear(113);
 		ACCclear(114);
 		ACCclear(115);
 		ACCclear(116);
 		ACCclear(117);
 		ACCclear(118);
 		ACCclear(119);
 		ACCclear(120);
 		ACCclear(121);
 		ACCclear(122);
 		ACCclear(123);
 		ACCclear(124);
 		ACCclear(125);
 		ACCclear(126);
 		ACCclear(127);
 		ACCset(128);
 		ACCgoto(1);
 		ACCdesc();
		return;
		}
 		waitKey(anykey00201);
		done_flag=true;
		break pro001_restart;
		{}

	}

	// _ _
	p001e0001:
	{
 		if (skipdoall('p001e0001')) break p001e0001;
		if (!CNDat(33)) break p001e0001;
		if (!CNDisat(12,31)) break p001e0001;
		if (!CNDonotzero(12,34)) break p001e0001;
 		ACCoclear(12,34);
		{}

	}

	// _ _
	p001e0002:
	{
 		if (skipdoall('p001e0002')) break p001e0002;
		if (!CNDat(38)) break p001e0002;
 		ACCpicture(38);
		{}

	}

	// _ _
	p001e0003:
	{
 		if (skipdoall('p001e0003')) break p001e0003;
		if (!CNDat(42)) break p001e0003;
 		ACCpicture(42);
		{}

	}

	// _ _
	p001e0004:
	{
 		if (skipdoall('p001e0004')) break p001e0004;
		if (!CNDat(31)) break p001e0004;
 		ACCpicture(31);
		{}

	}

	// _ _
	p001e0005:
	{
 		if (skipdoall('p001e0005')) break p001e0005;
		if (!CNDat(30)) break p001e0005;
 		ACCpicture(30);
		{}

	}

	// _ _
	p001e0006:
	{
 		if (skipdoall('p001e0006')) break p001e0006;
		if (!CNDat(33)) break p001e0006;
 		ACCpicture(33);
		{}

	}

	// _ _
	p001e0007:
	{
 		if (skipdoall('p001e0007')) break p001e0007;
		if (!CNDat(32)) break p001e0007;
 		ACCpicture(32);
		{}

	}

	// _ _
	p001e0008:
	{
 		if (skipdoall('p001e0008')) break p001e0008;
		if (!CNDat(37)) break p001e0008;
 		ACCpicture(37);
		{}

	}

	// _ _
	p001e0009:
	{
 		if (skipdoall('p001e0009')) break p001e0009;
		if (!CNDat(42)) break p001e0009;
 		ACCpicture(42);
		{}

	}

	// _ _
	p001e0010:
	{
 		if (skipdoall('p001e0010')) break p001e0010;
		if (!CNDat(41)) break p001e0010;
 		ACCpicture(41);
		{}

	}

	// _ _
	p001e0011:
	{
 		if (skipdoall('p001e0011')) break p001e0011;
		if (!CNDat(40)) break p001e0011;
 		ACCpicture(40);
		{}

	}

	// _ _
	p001e0012:
	{
 		if (skipdoall('p001e0012')) break p001e0012;
		if (!CNDat(39)) break p001e0012;
 		ACCpicture(39);
		{}

	}

	// _ _
	p001e0013:
	{
 		if (skipdoall('p001e0013')) break p001e0013;
		if (!CNDat(36)) break p001e0013;
 		ACCpicture(36);
		{}

	}

	// _ _
	p001e0014:
	{
 		if (skipdoall('p001e0014')) break p001e0014;
		if (!CNDat(35)) break p001e0014;
 		ACCpicture(35);
		{}

	}

	// _ _
	p001e0015:
	{
 		if (skipdoall('p001e0015')) break p001e0015;
		if (!CNDat(34)) break p001e0015;
		if (!CNDzero(103)) break p001e0015;
 		ACCwrite(1251);
 		ACCwrite(1252);
 		ACCset(103);
		{}

	}

	// _ _
	p001e0016:
	{
 		if (skipdoall('p001e0016')) break p001e0016;
		if (!CNDat(29)) break p001e0016;
 		ACCpicture(29);
		{}

	}

	// _ _
	p001e0017:
	{
 		if (skipdoall('p001e0017')) break p001e0017;
		if (!CNDat(34)) break p001e0017;
 		ACCpicture(34);
		{}

	}

	// _ _
	p001e0018:
	{
 		if (skipdoall('p001e0018')) break p001e0018;
		if (!CNDat(26)) break p001e0018;
 		ACCpicture(26);
		{}

	}

	// _ _
	p001e0019:
	{
 		if (skipdoall('p001e0019')) break p001e0019;
		if (!CNDat(27)) break p001e0019;
 		ACCpicture(27);
		{}

	}

	// _ _
	p001e0020:
	{
 		if (skipdoall('p001e0020')) break p001e0020;
		if (!CNDat(28)) break p001e0020;
 		ACCpicture(28);
		{}

	}

	// _ _
	p001e0021:
	{
 		if (skipdoall('p001e0021')) break p001e0021;
		if (!CNDat(1)) break p001e0021;
 		ACCpicture(1);
		{}

	}

	// _ _
	p001e0022:
	{
 		if (skipdoall('p001e0022')) break p001e0022;
		if (!CNDat(2)) break p001e0022;
 		ACCpicture(2);
		{}

	}

	// _ _
	p001e0023:
	{
 		if (skipdoall('p001e0023')) break p001e0023;
		if (!CNDat(3)) break p001e0023;
		if (!CNDeq(78,0)) break p001e0023;
 		ACCpicture(3);
		{}

	}

	// _ _
	p001e0024:
	{
 		if (skipdoall('p001e0024')) break p001e0024;
		if (!CNDat(3)) break p001e0024;
		if (!CNDeq(78,2)) break p001e0024;
 		ACCpicture(3);
		{}

	}

	// _ _
	p001e0025:
	{
 		if (skipdoall('p001e0025')) break p001e0025;
		if (!CNDat(3)) break p001e0025;
		if (!CNDeq(78,1)) break p001e0025;
 		ACCpicture(15);
		{}

	}

	// _ _
	p001e0026:
	{
 		if (skipdoall('p001e0026')) break p001e0026;
		if (!CNDat(4)) break p001e0026;
 		ACCpicture(4);
		{}

	}

	// _ _
	p001e0027:
	{
 		if (skipdoall('p001e0027')) break p001e0027;
		if (!CNDat(5)) break p001e0027;
 		ACCpicture(5);
		{}

	}

	// _ _
	p001e0028:
	{
 		if (skipdoall('p001e0028')) break p001e0028;
		if (!CNDat(12)) break p001e0028;
		if (!CNDnoteq(78,2)) break p001e0028;
 		ACCpicture(12);
		{}

	}

	// _ _
	p001e0029:
	{
 		if (skipdoall('p001e0029')) break p001e0029;
		if (!CNDat(12)) break p001e0029;
		if (!CNDeq(78,2)) break p001e0029;
 		ACCpicture(16);
 		ACCwrite(1253);
		{}

	}

	// _ _
	p001e0030:
	{
 		if (skipdoall('p001e0030')) break p001e0030;
		if (!CNDat(23)) break p001e0030;
 		ACCpicture(22);
		{}

	}

	// _ _
	p001e0031:
	{
 		if (skipdoall('p001e0031')) break p001e0031;
		if (!CNDat(14)) break p001e0031;
 		ACCpicture(13);
		{}

	}

	// _ _
	p001e0032:
	{
 		if (skipdoall('p001e0032')) break p001e0032;
		if (!CNDat(8)) break p001e0032;
 		ACCpicture(8);
		{}

	}

	// _ _
	p001e0033:
	{
 		if (skipdoall('p001e0033')) break p001e0033;
		if (!CNDat(9)) break p001e0033;
 		ACCpicture(9);
		{}

	}

	// _ _
	p001e0034:
	{
 		if (skipdoall('p001e0034')) break p001e0034;
		if (!CNDgt(38,14)) break p001e0034;
		if (!CNDlt(38,18)) break p001e0034;
 		ACCpicture(14);
		{}

	}

	// _ _
	p001e0035:
	{
 		if (skipdoall('p001e0035')) break p001e0035;
		if (!CNDgt(38,18)) break p001e0035;
		if (!CNDlt(38,23)) break p001e0035;
 		ACCpicture(14);
		{}

	}

	// _ _
	p001e0036:
	{
 		if (skipdoall('p001e0036')) break p001e0036;
		if (!CNDat(10)) break p001e0036;
 		ACCpicture(10);
		{}

	}

	// _ _
	p001e0037:
	{
 		if (skipdoall('p001e0037')) break p001e0037;
		if (!CNDat(11)) break p001e0037;
		if (!CNDeq(85,0)) break p001e0037;
 		ACCpicture(11);
		{}

	}

	// _ _
	p001e0038:
	{
 		if (skipdoall('p001e0038')) break p001e0038;
		if (!CNDat(11)) break p001e0038;
		if (!CNDeq(85,1)) break p001e0038;
 		ACCpicture(17);
		{}

	}

	// _ _
	p001e0039:
	{
 		if (skipdoall('p001e0039')) break p001e0039;
		if (!CNDat(18)) break p001e0039;
 		ACCpicture(18);
		{}

	}

	// _ _
	p001e0040:
	{
 		if (skipdoall('p001e0040')) break p001e0040;
		if (!CNDat(24)) break p001e0040;
 		ACCpicture(24);
		{}

	}

	// _ _
	p001e0041:
	{
 		if (skipdoall('p001e0041')) break p001e0041;
		if (!CNDat(25)) break p001e0041;
 		ACCpicture(25);
		{}

	}

	// _ _
	p001e0042:
	{
 		if (skipdoall('p001e0042')) break p001e0042;
		if (!CNDnotzero(64)) break p001e0042;
		if (!CNDnoteq(64,9)) break p001e0042;
 		ACCwrite(1254);
 		ACCnewline();
		{}

	}

	// _ _
	p001e0043:
	{
 		if (skipdoall('p001e0043')) break p001e0043;
		if (!CNDat(5)) break p001e0043;
		if (!CNDeq(71,1)) break p001e0043;
 		ACCwrite(1255);
 		ACCnewline();
		{}

	}

	// _ _
	p001e0044:
	{
 		if (skipdoall('p001e0044')) break p001e0044;
		if (!CNDat(3)) break p001e0044;
		if (!CNDeq(78,0)) break p001e0044;
 		ACCwrite(1256);
		{}

	}

	// _ _
	p001e0045:
	{
 		if (skipdoall('p001e0045')) break p001e0045;
		if (!CNDat(3)) break p001e0045;
		if (!CNDeq(78,1)) break p001e0045;
 		ACCwrite(1257);
		{}

	}

	// _ _
	p001e0046:
	{
 		if (skipdoall('p001e0046')) break p001e0046;
		if (!CNDat(13)) break p001e0046;
		if (!CNDonotzero(1,0)) break p001e0046;
 		ACCwrite(1258);
 		ACCpicture(19);
		{}

	}

	// _ _
	p001e0047:
	{
 		if (skipdoall('p001e0047')) break p001e0047;
		if (!CNDat(13)) break p001e0047;
		if (!CNDozero(1,0)) break p001e0047;
 		ACCwrite(1259);
 		ACCpicture(20);
 		ACCdone();
		break pro001_restart;
		{}

	}

	// _ _
	p001e0048:
	{
 		if (skipdoall('p001e0048')) break p001e0048;
		if (!CNDat(11)) break p001e0048;
		if (!CNDzero(85)) break p001e0048;
 		ACCwrite(1260);
		{}

	}

	// _ _
	p001e0049:
	{
 		if (skipdoall('p001e0049')) break p001e0049;
		if (!CNDeq(85,1)) break p001e0049;
		if (!CNDnoteq(84,1)) break p001e0049;
		if (!CNDsame(38,86)) break p001e0049;
 		ACCwrite(1261);
		{}

	}

	// _ _
	p001e0050:
	{
 		if (skipdoall('p001e0050')) break p001e0050;
		if (!CNDeq(84,1)) break p001e0050;
 		ACCwrite(1262);
		{}

	}

	// _ _
	p001e0051:
	{
 		if (skipdoall('p001e0051')) break p001e0051;
		if (!CNDnotzero(113)) break p001e0051;
 		ACCwrite(1263);
		{}

	}

	// _ _
	p001e0052:
	{
 		if (skipdoall('p001e0052')) break p001e0052;
		if (!CNDat(13)) break p001e0052;
		if (!CNDonotzero(1,0)) break p001e0052;
		if (!CNDeq(80,0)) break p001e0052;
 		ACCwrite(1264);
		{}

	}

	// _ _
	p001e0053:
	{
 		if (skipdoall('p001e0053')) break p001e0053;
		if (!CNDat(13)) break p001e0053;
		if (!CNDonotzero(1,0)) break p001e0053;
		if (!CNDeq(80,1)) break p001e0053;
 		ACCwrite(1265);
		{}

	}

	// _ _
	p001e0054:
	{
 		if (skipdoall('p001e0054')) break p001e0054;
		if (!CNDat(32)) break p001e0054;
		if (!CNDeq(109,0)) break p001e0054;
 		ACCwrite(1266);
		{}

	}

	// _ _
	p001e0055:
	{
 		if (skipdoall('p001e0055')) break p001e0055;
		if (!CNDeq(118,getFlag(38))) break p001e0055;
		if (!CNDzero(113)) break p001e0055;
 		ACCwrite(1267);
		{}

	}

	// _ _
	p001e0056:
	{
 		if (skipdoall('p001e0056')) break p001e0056;
		if (!CNDat(32)) break p001e0056;
		if (!CNDeq(117,0)) break p001e0056;
 		ACCwrite(1268);
		{}

	}

	// _ _
	p001e0057:
	{
 		if (skipdoall('p001e0057')) break p001e0057;
		if (!CNDat(32)) break p001e0057;
		if (!CNDnotzero(117)) break p001e0057;
 		ACCwrite(1269);
		{}

	}

	// _ _
	p001e0058:
	{
 		if (skipdoall('p001e0058')) break p001e0058;
		if (!CNDat(33)) break p001e0058;
		if (!CNDzero(120)) break p001e0058;
		if (!CNDzero(119)) break p001e0058;
 		ACCwrite(1270);
		{}

	}

	// _ _
	p001e0059:
	{
 		if (skipdoall('p001e0059')) break p001e0059;
		if (!CNDat(33)) break p001e0059;
		if (!CNDzero(120)) break p001e0059;
		if (!CNDnotzero(119)) break p001e0059;
 		ACCwrite(1271);
		{}

	}

	// _ _
	p001e0060:
	{
 		if (skipdoall('p001e0060')) break p001e0060;
		if (!CNDat(33)) break p001e0060;
		if (!CNDnotzero(120)) break p001e0060;
 		ACCwrite(1272);
		{}

	}

	// _ _
	p001e0061:
	{
 		if (skipdoall('p001e0061')) break p001e0061;
		if (!CNDat(30)) break p001e0061;
		if (!CNDzero(121)) break p001e0061;
 		ACCwrite(1273);
		{}

	}

	// _ _
	p001e0062:
	{
 		if (skipdoall('p001e0062')) break p001e0062;
		if (!CNDat(30)) break p001e0062;
		if (!CNDnotzero(121)) break p001e0062;
 		ACCwrite(1274);
		{}

	}

	// _ _
	p001e0063:
	{
 		if (skipdoall('p001e0063')) break p001e0063;
		if (!CNDat(30)) break p001e0063;
		if (!CNDnotzero(122)) break p001e0063;
 		ACCwrite(1275);
		{}

	}

	// _ _
	p001e0064:
	{
 		if (skipdoall('p001e0064')) break p001e0064;
		if (!CNDat(4)) break p001e0064;
		if (!CNDabsent(6)) break p001e0064;
		if (!CNDisnotat(6,1)) break p001e0064;
		if (!CNDisnotat(6,2)) break p001e0064;
 		ACCwrite(1276);
 		ACCanykey();
 		function anykey00208() 
		{
 		ACCplace(6,4);
 		ACCoset(6,4);
 		ACCdone();
		return;
		}
 		function anykey00207() 
		{
 		ACCwrite(1282);
 		ACCanykey();
 		waitKey(anykey00208);
		}
 		function anykey00206() 
		{
 		ACCwrite(1281);
 		ACCanykey();
 		waitKey(anykey00207);
		}
 		function anykey00205() 
		{
 		ACCwrite(1280);
 		ACCanykey();
 		waitKey(anykey00206);
		}
 		function anykey00204() 
		{
 		ACCwrite(1279);
 		ACCanykey();
 		waitKey(anykey00205);
		}
 		function anykey00203() 
		{
 		ACCwrite(1278);
 		ACCanykey();
 		waitKey(anykey00204);
		}
 		function anykey00202() 
		{
 		ACCwrite(1277);
 		ACCanykey();
 		waitKey(anykey00203);
		}
 		waitKey(anykey00202);
		done_flag=true;
		break pro001_restart;
		{}

	}

	// _ _
	p001e0065:
	{
 		if (skipdoall('p001e0065')) break p001e0065;
		if (!CNDat(1)) break p001e0065;
		if (!CNDzero(127)) break p001e0065;
 		ACCwrite(1283);
 		ACCset(127);
 		ACCdone();
		break pro001_restart;
		{}

	}

	// _ _
	p001e0066:
	{
 		if (skipdoall('p001e0066')) break p001e0066;
		if (!CNDislight()) break p001e0066;
 		ACClistobj();
		{}

	}

	// _ _
	p001e0067:
	{
 		if (skipdoall('p001e0067')) break p001e0067;
		if (!CNDat(31)) break p001e0067;
		if (!CNDzero(125)) break p001e0067;
 		ACCobjat(31,73);
		if (!CNDnotzero(73)) break p001e0067;
 		ACCwrite(1284);
 		ACCset(125);
 		ACCdone();
		break pro001_restart;
		{}

	}


}
}

function pro002()
{
process_restart=true;
pro002_restart: while(process_restart)
{
	process_restart=false;
	// _ _
	p002e0000:
	{
 		if (skipdoall('p002e0000')) break p002e0000;
		if (!CNDzero(119)) break p002e0000;
		if (!CNDzero(7)) break p002e0000;
 		ACClet(7,3);
 		ACCset(119);
		if (!CNDzero(120)) break p002e0000;
		if (!CNDat(33)) break p002e0000;
 		ACCwrite(1285);
		{}

	}

	// _ _
	p002e0001:
	{
 		if (skipdoall('p002e0001')) break p002e0001;
		if (!CNDzero(119)) break p002e0001;
		if (!CNDzero(7)) break p002e0001;
 		ACClet(7,3);
 		ACCset(119);
		{}

	}

	// _ _
	p002e0002:
	{
 		if (skipdoall('p002e0002')) break p002e0002;
		if (!CNDnotzero(119)) break p002e0002;
		if (!CNDzero(7)) break p002e0002;
 		ACClet(7,8);
 		ACCclear(119);
		if (!CNDzero(120)) break p002e0002;
		if (!CNDat(33)) break p002e0002;
 		ACCwrite(1286);
		{}

	}

	// _ _
	p002e0003:
	{
 		if (skipdoall('p002e0003')) break p002e0003;
		if (!CNDnotzero(119)) break p002e0003;
		if (!CNDzero(7)) break p002e0003;
 		ACClet(7,8);
 		ACCclear(119);
		{}

	}

	// _ _
	p002e0004:
	{
 		if (skipdoall('p002e0004')) break p002e0004;
		if (!CNDat(40)) break p002e0004;
		if (!CNDeq(115,1)) break p002e0004;
		if (!CNDzero(6)) break p002e0004;
 		ACCwrite(1287);
		{}

	}

	// _ _
	p002e0005:
	{
 		if (skipdoall('p002e0005')) break p002e0005;
		if (!CNDat(38)) break p002e0005;
		if (!CNDeq(115,1)) break p002e0005;
		if (!CNDzero(6)) break p002e0005;
		if (!CNDisat(26,40)) break p002e0005;
		if (!CNDzero(114)) break p002e0005;
 		ACCwrite(1288);
 		ACCwrite(1289);
 		ACCwrite(1290);
 		ACCwrite(1291);
 		ACCwrite(1292);
 		ACCwrite(1293);
 		ACCclear(115);
		{}

	}

	// _ _
	p002e0006:
	{
 		if (skipdoall('p002e0006')) break p002e0006;
		if (!CNDat(40)) break p002e0006;
		if (!CNDeq(115,1)) break p002e0006;
		if (!CNDzero(6)) break p002e0006;
		if (!CNDisat(26,40)) break p002e0006;
		if (!CNDzero(114)) break p002e0006;
 		ACCwrite(1294);
 		ACCwrite(1295);
 		ACCwrite(1296);
 		ACCwrite(1297);
 		ACCwrite(1298);
 		ACCwrite(1299);
 		ACCclear(115);
		{}

	}

	// _ _
	p002e0007:
	{
 		if (skipdoall('p002e0007')) break p002e0007;
		if (!CNDat(40)) break p002e0007;
		if (!CNDeq(115,1)) break p002e0007;
		if (!CNDzero(6)) break p002e0007;
		if (!CNDisat(26,40)) break p002e0007;
		if (!CNDnotzero(114)) break p002e0007;
 		ACCwrite(1300);
 		ACCwrite(1301);
 		ACCwrite(1302);
 		ACCwrite(1303);
 		ACCplace(26,37);
 		ACCclear(115);
		{}

	}

	// _ _
	p002e0008:
	{
 		if (skipdoall('p002e0008')) break p002e0008;
		if (!CNDat(38)) break p002e0008;
		if (!CNDeq(115,1)) break p002e0008;
		if (!CNDisat(26,40)) break p002e0008;
		if (!CNDnotzero(114)) break p002e0008;
 		ACCwrite(1304);
 		ACCwrite(1305);
 		ACCwrite(1306);
 		ACCplace(26,37);
 		ACClet(111,37);
		{}

	}

	// _ _
	p002e0009:
	{
 		if (skipdoall('p002e0009')) break p002e0009;
		if (!CNDnotat(40)) break p002e0009;
		if (!CNDnotat(38)) break p002e0009;
		if (!CNDeq(115,1)) break p002e0009;
		if (!CNDisat(26,40)) break p002e0009;
		if (!CNDnotzero(114)) break p002e0009;
 		ACCplace(26,37);
 		ACCclear(115);
 		ACCwrite(1307);
		{}

	}

	// _ _
	p002e0010:
	{
 		if (skipdoall('p002e0010')) break p002e0010;
		if (!CNDat(40)) break p002e0010;
		if (!CNDeq(115,1)) break p002e0010;
		if (!CNDzero(6)) break p002e0010;
 		ACCclear(115);
 		ACCwrite(1308);
 		ACCdone();
		break pro002_restart;
		{}

	}

	// _ _
	p002e0011:
	{
 		if (skipdoall('p002e0011')) break p002e0011;
		if (!CNDnotat(40)) break p002e0011;
		if (!CNDeq(115,1)) break p002e0011;
		if (!CNDzero(6)) break p002e0011;
 		ACCclear(115);
 		ACCdone();
		break pro002_restart;
		{}

	}

	// _ _
	p002e0012:
	{
 		if (skipdoall('p002e0012')) break p002e0012;
		if (!CNDeq(84,1)) break p002e0012;
		if (!CNDnotsame(38,86)) break p002e0012;
 		ACCcopyff(38,86);
		{}

	}

	// _ _
	p002e0013:
	{
 		if (skipdoall('p002e0013')) break p002e0013;
		if (!CNDnotzero(113)) break p002e0013;
		if (!CNDnotsame(38,118)) break p002e0013;
 		ACCcopyff(38,118);
		{}

	}

	// _ _
	p002e0014:
	{
 		if (skipdoall('p002e0014')) break p002e0014;
		if (!CNDat(25)) break p002e0014;
		if (!CNDeq(92,1)) break p002e0014;
		if (!CNDeq(5,2)) break p002e0014;
 		ACCwrite(1309);
 		ACCdone();
		break pro002_restart;
		{}

	}

	// _ _
	p002e0015:
	{
 		if (skipdoall('p002e0015')) break p002e0015;
		if (!CNDat(25)) break p002e0015;
		if (!CNDeq(5,1)) break p002e0015;
		if (!CNDeq(92,1)) break p002e0015;
 		ACCwrite(1310);
		{}

	}

	// _ _
	p002e0016:
	{
 		if (skipdoall('p002e0016')) break p002e0016;
		if (!CNDeq(5,1)) break p002e0016;
		if (!CNDeq(92,1)) break p002e0016;
 		ACClet(92,2);
 		ACClet(91,1);
 		ACClet(5,5);
		{}

	}

	// _ _
	p002e0017:
	{
 		if (skipdoall('p002e0017')) break p002e0017;
		if (!CNDeq(92,2)) break p002e0017;
		if (!CNDeq(5,2)) break p002e0017;
		if (!CNDat(25)) break p002e0017;
 		ACCwrite(1311);
 		ACCdone();
		break pro002_restart;
		{}

	}

	// _ _
	p002e0018:
	{
 		if (skipdoall('p002e0018')) break p002e0018;
		if (!CNDeq(92,2)) break p002e0018;
		if (!CNDeq(5,1)) break p002e0018;
		if (!CNDat(25)) break p002e0018;
 		ACCwrite(1312);
		{}

	}

	// _ _
	p002e0019:
	{
 		if (skipdoall('p002e0019')) break p002e0019;
		if (!CNDeq(92,2)) break p002e0019;
		if (!CNDeq(5,1)) break p002e0019;
 		ACCclear(92);
 		ACCclear(5);
 		ACClet(91,0);
		{}

	}

	// _ _
	p002e0020:
	{
 		if (skipdoall('p002e0020')) break p002e0020;
		if (!CNDeq(66,1)) break p002e0020;
 		ACCwrite(1313);
 		ACClet(66,5);
 		ACCnewline();
		{}

	}

	// _ _
	p002e0021:
	{
 		if (skipdoall('p002e0021')) break p002e0021;
		if (!CNDeq(66,2)) break p002e0021;
 		ACCwrite(1314);
 		ACCnewline();
 		ACCminus(66,1);
		{}

	}

	// _ _
	p002e0022:
	{
 		if (skipdoall('p002e0022')) break p002e0022;
		if (!CNDeq(66,3)) break p002e0022;
 		ACCwrite(1315);
 		ACCnewline();
 		ACCminus(66,1);
		{}

	}

	// _ _
	p002e0023:
	{
 		if (skipdoall('p002e0023')) break p002e0023;
		if (!CNDatlt(18)) break p002e0023;
		if (!CNDatgt(14)) break p002e0023;
		if (!CNDchance(15)) break p002e0023;
 		ACCobjat(254,73);
		if (!CNDgt(73,1)) break p002e0023;
		if (!CNDzero(87)) break p002e0023;
 		ACCwrite(1316);
 		ACClet(89,1);
 		ACCclear(88);
 		ACCclear(90);
 		ACCplace(0,0);
 		ACCobjat(254,73);
		entry_for_doall = 'p002e0024';
		process_in_doall = 2;
 		ACCdoall(254);
		break pro002_restart;
		{}

	}

	// _ _
	p002e0024:
	{
 		if (skipdoall('p002e0024')) break p002e0024;
		if (!CNDeq(89,1)) break p002e0024;
 		ACCprocess(5);
 		ACCdone();
		break pro002_restart;
		{}

	}

	// _ _
	p002e0025:
	{
 		if (skipdoall('p002e0025')) break p002e0025;
		if (!CNDatlt(23)) break p002e0025;
		if (!CNDatgt(18)) break p002e0025;
		if (!CNDchance(15)) break p002e0025;
 		ACCobjat(254,73);
		if (!CNDgt(73,1)) break p002e0025;
		if (!CNDzero(87)) break p002e0025;
 		ACCwrite(1317);
 		ACClet(89,1);
 		ACCclear(88);
 		ACCclear(90);
 		ACCplace(0,0);
 		ACCobjat(254,73);
		entry_for_doall = 'p002e0026';
		process_in_doall = 2;
 		ACCdoall(254);
		break pro002_restart;
		{}

	}

	// _ _
	p002e0026:
	{
 		if (skipdoall('p002e0026')) break p002e0026;
		if (!CNDeq(89,1)) break p002e0026;
 		ACCprocess(5);
 		ACCdone();
		break pro002_restart;
		{}

	}


}
}

function pro003()
{
process_restart=true;
pro003_restart: while(process_restart)
{
	process_restart=false;
	// EX ETIQUETA
	p003e0000:
	{
 		if (skipdoall('p003e0000')) break p003e0000;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0000;
			if (!CNDnoun1(222)) break p003e0000;
 		}
		if (!CNDpresent(6)) break p003e0000;
 		ACCwrite(1318);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX RANURA
	p003e0001:
	{
 		if (skipdoall('p003e0001')) break p003e0001;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0001;
			if (!CNDnoun1(223)) break p003e0001;
 		}
		if (!CNDat(29)) break p003e0001;
 		ACCwrite(1319);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX RINCON
	p003e0002:
	{
 		if (skipdoall('p003e0002')) break p003e0002;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0002;
			if (!CNDnoun1(221)) break p003e0002;
 		}
		if (!CNDat(1)) break p003e0002;
 		ACCwrite(1320);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CAJA
	p003e0003:
	{
 		if (skipdoall('p003e0003')) break p003e0003;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0003;
			if (!CNDnoun1(89)) break p003e0003;
 		}
		if (!CNDadject1(13)) break p003e0003;
		if (!CNDat(30)) break p003e0003;
		if (!CNDzero(122)) break p003e0003;
 		ACCwrite(1321);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CAJA
	p003e0004:
	{
 		if (skipdoall('p003e0004')) break p003e0004;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0004;
			if (!CNDnoun1(89)) break p003e0004;
 		}
		if (!CNDadject1(13)) break p003e0004;
		if (!CNDat(30)) break p003e0004;
		if (!CNDnotzero(122)) break p003e0004;
 		ACCwrite(1322);
		{}

	}

	// EX CAJA
	p003e0005:
	{
 		if (skipdoall('p003e0005')) break p003e0005;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0005;
			if (!CNDnoun1(89)) break p003e0005;
 		}
		if (!CNDadject1(13)) break p003e0005;
		if (!CNDat(30)) break p003e0005;
		if (!CNDnotzero(122)) break p003e0005;
		if (!CNDzero(123)) break p003e0005;
 		ACCwrite(1323);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CAJA
	p003e0006:
	{
 		if (skipdoall('p003e0006')) break p003e0006;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0006;
			if (!CNDnoun1(89)) break p003e0006;
 		}
		if (!CNDadject1(13)) break p003e0006;
		if (!CNDat(30)) break p003e0006;
		if (!CNDnotzero(122)) break p003e0006;
		if (!CNDnotzero(123)) break p003e0006;
 		ACCwrite(1324);
		{}

	}

	// EX CAJA
	p003e0007:
	{
 		if (skipdoall('p003e0007')) break p003e0007;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0007;
			if (!CNDnoun1(89)) break p003e0007;
 		}
		if (!CNDadject1(13)) break p003e0007;
		if (!CNDat(30)) break p003e0007;
		if (!CNDnotzero(122)) break p003e0007;
		if (!CNDnotzero(123)) break p003e0007;
 		ACCobjat(43,73);
		if (!CNDzero(73)) break p003e0007;
 		ACCwrite(1325);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CAJA
	p003e0008:
	{
 		if (skipdoall('p003e0008')) break p003e0008;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0008;
			if (!CNDnoun1(89)) break p003e0008;
 		}
		if (!CNDadject1(13)) break p003e0008;
		if (!CNDat(30)) break p003e0008;
		if (!CNDnotzero(122)) break p003e0008;
		if (!CNDnotzero(123)) break p003e0008;
 		ACCobjat(43,73);
		if (!CNDnotzero(73)) break p003e0008;
 		ACCwrite(1326);
 		ACClistat(43);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PUERTA
	p003e0009:
	{
 		if (skipdoall('p003e0009')) break p003e0009;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0009;
			if (!CNDnoun1(69)) break p003e0009;
 		}
		if (!CNDnoun2(97)) break p003e0009;
 		ACClet(34,97);
		{}

	}

	// EX CAJA
	p003e0010:
	{
 		if (skipdoall('p003e0010')) break p003e0010;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0010;
			if (!CNDnoun1(89)) break p003e0010;
 		}
		if (!CNDnoteq(34,89)) break p003e0010;
		if (!CNDpresent(5)) break p003e0010;
		if (!CNDpresent(26)) break p003e0010;
		{}

	}

	// EX CAJA
	p003e0011:
	{
 		if (skipdoall('p003e0011')) break p003e0011;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0011;
			if (!CNDnoun1(89)) break p003e0011;
 		}
		if (!CNDnoteq(34,89)) break p003e0011;
		if (!CNDpresent(26)) break p003e0011;
		if (!CNDpresent(5)) break p003e0011;
		if (!CNDpresent(26)) break p003e0011;
 		ACCwrite(1327);
		{}

	}

	// EX CAJA
	p003e0012:
	{
 		if (skipdoall('p003e0012')) break p003e0012;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0012;
			if (!CNDnoun1(89)) break p003e0012;
 		}
		if (!CNDnoteq(34,89)) break p003e0012;
		if (!CNDpresent(26)) break p003e0012;
		if (!CNDpresent(5)) break p003e0012;
		if (!CNDnotzero(112)) break p003e0012;
 		ACCwrite(1328);
		{}

	}

	// EX CAJA
	p003e0013:
	{
 		if (skipdoall('p003e0013')) break p003e0013;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0013;
			if (!CNDnoun1(89)) break p003e0013;
 		}
		if (!CNDnoteq(34,89)) break p003e0013;
		if (!CNDpresent(26)) break p003e0013;
		if (!CNDpresent(5)) break p003e0013;
 		ACCobjat(38,73);
		if (!CNDzero(73)) break p003e0013;
 		ACCwrite(1329);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CAJA
	p003e0014:
	{
 		if (skipdoall('p003e0014')) break p003e0014;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0014;
			if (!CNDnoun1(89)) break p003e0014;
 		}
		if (!CNDnoteq(34,89)) break p003e0014;
		if (!CNDpresent(5)) break p003e0014;
		if (!CNDpresent(26)) break p003e0014;
 		ACCobjat(38,73);
		if (!CNDnotzero(73)) break p003e0014;
 		ACCwrite(1330);
 		ACClistat(38);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CAJA
	p003e0015:
	{
 		if (skipdoall('p003e0015')) break p003e0015;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0015;
			if (!CNDnoun1(89)) break p003e0015;
 		}
		if (!CNDpresent(5)) break p003e0015;
		if (!CNDpresent(26)) break p003e0015;
		if (!CNDnoun2(89)) break p003e0015;
		if (!CNDnotzero(67)) break p003e0015;
		if (!CNDnoteq(67,1)) break p003e0015;
 		ACCwrite(1331);
 		ACCnewline();
 		ACCwrite(1332);
 		ACCprint(67);
 		ACCwrite(1333);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CAJA
	p003e0016:
	{
 		if (skipdoall('p003e0016')) break p003e0016;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0016;
			if (!CNDnoun1(89)) break p003e0016;
 		}
		if (!CNDpresent(5)) break p003e0016;
		if (!CNDpresent(26)) break p003e0016;
		if (!CNDnoun2(89)) break p003e0016;
		if (!CNDeq(67,1)) break p003e0016;
 		ACCwrite(1334);
 		ACCnewline();
 		ACCwrite(1335);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CAJA
	p003e0017:
	{
 		if (skipdoall('p003e0017')) break p003e0017;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0017;
			if (!CNDnoun1(89)) break p003e0017;
 		}
		if (!CNDpresent(5)) break p003e0017;
		if (!CNDpresent(26)) break p003e0017;
		if (!CNDnoun2(89)) break p003e0017;
		if (!CNDzero(67)) break p003e0017;
 		ACCwrite(1336);
 		ACCwrite(1337);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ESTANCIA
	p003e0018:
	{
 		if (skipdoall('p003e0018')) break p003e0018;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0018;
			if (!CNDnoun1(196)) break p003e0018;
 		}
		if (!CNDat(30)) break p003e0018;
 		ACCwrite(1338);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX DESPACHO
	p003e0019:
	{
 		if (skipdoall('p003e0019')) break p003e0019;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0019;
			if (!CNDnoun1(210)) break p003e0019;
 		}
		if (!CNDat(30)) break p003e0019;
 		ACCdesc();
		break pro003_restart;
		{}

	}

	// EX HERRAMIENT
	p003e0020:
	{
 		if (skipdoall('p003e0020')) break p003e0020;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0020;
			if (!CNDnoun1(152)) break p003e0020;
 		}
		if (!CNDat(33)) break p003e0020;
 		ACCwrite(1339);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX INFORME
	p003e0021:
	{
 		if (skipdoall('p003e0021')) break p003e0021;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0021;
			if (!CNDnoun1(216)) break p003e0021;
 		}
		if (!CNDat(30)) break p003e0021;
		if (!CNDzero(121)) break p003e0021;
 		ACCwrite(1340);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX MUEBLES
	p003e0022:
	{
 		if (skipdoall('p003e0022')) break p003e0022;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0022;
			if (!CNDnoun1(201)) break p003e0022;
 		}
		if (!CNDat(31)) break p003e0022;
 		ACCwrite(1341);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX MAGICOS
	p003e0023:
	{
 		if (skipdoall('p003e0023')) break p003e0023;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0023;
			if (!CNDnoun1(61)) break p003e0023;
 		}
		if (!CNDat(31)) break p003e0023;
 		ACCwrite(1342);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX LIBROS
	p003e0024:
	{
 		if (skipdoall('p003e0024')) break p003e0024;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0024;
			if (!CNDnoun1(54)) break p003e0024;
 		}
		if (!CNDat(30)) break p003e0024;
 		ACCwrite(1343);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX BECKHAM
	p003e0025:
	{
 		if (skipdoall('p003e0025')) break p003e0025;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0025;
			if (!CNDnoun1(25)) break p003e0025;
 		}
		if (!CNDat(30)) break p003e0025;
		if (!CNDzero(121)) break p003e0025;
 		ACCwrite(1344);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX BECKHAM
	p003e0026:
	{
 		if (skipdoall('p003e0026')) break p003e0026;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0026;
			if (!CNDnoun1(25)) break p003e0026;
 		}
		if (!CNDat(30)) break p003e0026;
		if (!CNDnotzero(121)) break p003e0026;
 		ACCwrite(1345);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CUADRO
	p003e0027:
	{
 		if (skipdoall('p003e0027')) break p003e0027;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0027;
			if (!CNDnoun1(213)) break p003e0027;
 		}
		if (!CNDat(30)) break p003e0027;
 		ACCwrite(1346);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX COMPUTADOR
	p003e0028:
	{
 		if (skipdoall('p003e0028')) break p003e0028;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0028;
			if (!CNDnoun1(224)) break p003e0028;
 		}
		if (!CNDat(30)) break p003e0028;
 		ACCwrite(1347);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX TELEFONO
	p003e0029:
	{
 		if (skipdoall('p003e0029')) break p003e0029;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0029;
			if (!CNDnoun1(211)) break p003e0029;
 		}
		if (!CNDat(30)) break p003e0029;
 		ACCwrite(1348);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX MESA
	p003e0030:
	{
 		if (skipdoall('p003e0030')) break p003e0030;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0030;
			if (!CNDnoun1(208)) break p003e0030;
 		}
		if (!CNDat(30)) break p003e0030;
 		ACCwrite(1349);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PAPELES
	p003e0031:
	{
 		if (skipdoall('p003e0031')) break p003e0031;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0031;
			if (!CNDnoun1(212)) break p003e0031;
 		}
		if (!CNDat(30)) break p003e0031;
 		ACCwrite(1350);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PARED
	p003e0032:
	{
 		if (skipdoall('p003e0032')) break p003e0032;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0032;
			if (!CNDnoun1(177)) break p003e0032;
 		}
		if (!CNDat(30)) break p003e0032;
 		ACCwrite(1351);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ESTANTE
	p003e0033:
	{
 		if (skipdoall('p003e0033')) break p003e0033;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0033;
			if (!CNDnoun1(214)) break p003e0033;
 		}
		if (!CNDat(30)) break p003e0033;
 		ACCwrite(1352);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ESCALERAS
	p003e0034:
	{
 		if (skipdoall('p003e0034')) break p003e0034;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0034;
			if (!CNDnoun1(203)) break p003e0034;
 		}
		if (!CNDat(42)) break p003e0034;
 		ACCwrite(1353);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX DESPACHO
	p003e0035:
	{
 		if (skipdoall('p003e0035')) break p003e0035;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0035;
			if (!CNDnoun1(210)) break p003e0035;
 		}
		if (!CNDat(42)) break p003e0035;
 		ACCwrite(1354);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX TRAMPILLA
	p003e0036:
	{
 		if (skipdoall('p003e0036')) break p003e0036;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0036;
			if (!CNDnoun1(170)) break p003e0036;
 		}
		if (!CNDat(42)) break p003e0036;
 		ACCwrite(1355);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PASILLO
	p003e0037:
	{
 		if (skipdoall('p003e0037')) break p003e0037;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0037;
			if (!CNDnoun1(209)) break p003e0037;
 		}
		if (!CNDat(42)) break p003e0037;
 		ACCwrite(1356);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX TECHO
	p003e0038:
	{
 		if (skipdoall('p003e0038')) break p003e0038;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0038;
			if (!CNDnoun1(82)) break p003e0038;
 		}
		if (!CNDat(42)) break p003e0038;
 		ACCwrite(1357);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX COCINERO
	p003e0039:
	{
 		if (skipdoall('p003e0039')) break p003e0039;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0039;
			if (!CNDnoun1(24)) break p003e0039;
 		}
		if (!CNDat(33)) break p003e0039;
 		ACCwrite(1358);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX GUISO
	p003e0040:
	{
 		if (skipdoall('p003e0040')) break p003e0040;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0040;
			if (!CNDnoun1(206)) break p003e0040;
 		}
		if (!CNDat(33)) break p003e0040;
 		ACCwrite(1359);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX HORNO
	p003e0041:
	{
 		if (skipdoall('p003e0041')) break p003e0041;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0041;
			if (!CNDnoun1(207)) break p003e0041;
 		}
		if (!CNDat(33)) break p003e0041;
 		ACCwrite(1360);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX COCINA
	p003e0042:
	{
 		if (skipdoall('p003e0042')) break p003e0042;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0042;
			if (!CNDnoun1(64)) break p003e0042;
 		}
		if (!CNDat(33)) break p003e0042;
 		ACCdesc();
		break pro003_restart;
		{}

	}

	// EX MESA
	p003e0043:
	{
 		if (skipdoall('p003e0043')) break p003e0043;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0043;
			if (!CNDnoun1(208)) break p003e0043;
 		}
		if (!CNDat(33)) break p003e0043;
 		ACCwrite(1361);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX HERRAMIENT
	p003e0044:
	{
 		if (skipdoall('p003e0044')) break p003e0044;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0044;
			if (!CNDnoun1(152)) break p003e0044;
 		}
		if (!CNDat(33)) break p003e0044;
 		ACCwrite(1362);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX SARTEN
	p003e0045:
	{
 		if (skipdoall('p003e0045')) break p003e0045;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0045;
			if (!CNDnoun1(205)) break p003e0045;
 		}
		if (!CNDat(33)) break p003e0045;
		if (!CNDeq(120,0)) break p003e0045;
		if (!CNDeq(119,0)) break p003e0045;
 		ACCwrite(1363);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX SARTEN
	p003e0046:
	{
 		if (skipdoall('p003e0046')) break p003e0046;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0046;
			if (!CNDnoun1(205)) break p003e0046;
 		}
		if (!CNDat(33)) break p003e0046;
		if (!CNDeq(120,0)) break p003e0046;
		if (!CNDnotzero(119)) break p003e0046;
 		ACCwrite(1364);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX SARTEN
	p003e0047:
	{
 		if (skipdoall('p003e0047')) break p003e0047;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0047;
			if (!CNDnoun1(205)) break p003e0047;
 		}
		if (!CNDnotzero(120)) break p003e0047;
		if (!CNDpresent(29)) break p003e0047;
		if (!CNDzero(121)) break p003e0047;
 		ACCwrite(1365);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX SARTEN
	p003e0048:
	{
 		if (skipdoall('p003e0048')) break p003e0048;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0048;
			if (!CNDnoun1(205)) break p003e0048;
 		}
		if (!CNDnotzero(120)) break p003e0048;
		if (!CNDpresent(29)) break p003e0048;
		if (!CNDnotzero(121)) break p003e0048;
 		ACCwrite(1366);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX AGOSTINE
	p003e0049:
	{
 		if (skipdoall('p003e0049')) break p003e0049;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0049;
			if (!CNDnoun1(26)) break p003e0049;
 		}
		if (!CNDnotzero(109)) break p003e0049;
		if (!CNDeq(118,getFlag(38))) break p003e0049;
 		ACCwrite(1367);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX JARRA
	p003e0050:
	{
 		if (skipdoall('p003e0050')) break p003e0050;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0050;
			if (!CNDnoun1(204)) break p003e0050;
 		}
		if (!CNDat(32)) break p003e0050;
		if (!CNDzero(117)) break p003e0050;
 		ACCwrite(1368);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX LIBRO
	p003e0051:
	{
 		if (skipdoall('p003e0051')) break p003e0051;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0051;
			if (!CNDnoun1(53)) break p003e0051;
 		}
		if (!CNDat(32)) break p003e0051;
		if (!CNDzero(117)) break p003e0051;
 		ACCwrite(1369);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX AGOSTINE
	p003e0052:
	{
 		if (skipdoall('p003e0052')) break p003e0052;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0052;
			if (!CNDnoun1(26)) break p003e0052;
 		}
		if (!CNDat(32)) break p003e0052;
		if (!CNDzero(109)) break p003e0052;
 		ACCwrite(1370);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX BECKHAM
	p003e0053:
	{
 		if (skipdoall('p003e0053')) break p003e0053;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0053;
			if (!CNDnoun1(25)) break p003e0053;
 		}
		if (!CNDat(32)) break p003e0053;
		if (!CNDeq(117,0)) break p003e0053;
 		ACCwrite(1371);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX BECKHAM
	p003e0054:
	{
 		if (skipdoall('p003e0054')) break p003e0054;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0054;
			if (!CNDnoun1(25)) break p003e0054;
 		}
		if (!CNDat(32)) break p003e0054;
		if (!CNDnotzero(117)) break p003e0054;
 		ACCwrite(1372);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX BIBLIOTECA
	p003e0055:
	{
 		if (skipdoall('p003e0055')) break p003e0055;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0055;
			if (!CNDnoun1(199)) break p003e0055;
 		}
		if (!CNDat(32)) break p003e0055;
 		ACCwrite(1373);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX LIBROS
	p003e0056:
	{
 		if (skipdoall('p003e0056')) break p003e0056;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0056;
			if (!CNDnoun1(54)) break p003e0056;
 		}
		if (!CNDat(32)) break p003e0056;
 		ACCwrite(1374);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX SUELO
	p003e0057:
	{
 		if (skipdoall('p003e0057')) break p003e0057;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0057;
			if (!CNDnoun1(120)) break p003e0057;
 		}
		if (!CNDat(32)) break p003e0057;
 		ACCwrite(1375);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX SILLON
	p003e0058:
	{
 		if (skipdoall('p003e0058')) break p003e0058;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0058;
			if (!CNDnoun1(218)) break p003e0058;
 		}
		if (!CNDat(32)) break p003e0058;
 		ACCwrite(1376);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX LAMPARA
	p003e0059:
	{
 		if (skipdoall('p003e0059')) break p003e0059;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0059;
			if (!CNDnoun1(200)) break p003e0059;
 		}
		if (!CNDat(32)) break p003e0059;
 		ACCwrite(1377);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX LAMPARA
	p003e0060:
	{
 		if (skipdoall('p003e0060')) break p003e0060;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0060;
			if (!CNDnoun1(200)) break p003e0060;
 		}
		if (!CNDat(32)) break p003e0060;
 		ACCwrite(1378);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX SALON
	p003e0061:
	{
 		if (skipdoall('p003e0061')) break p003e0061;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0061;
			if (!CNDnoun1(197)) break p003e0061;
 		}
		if (!CNDat(32)) break p003e0061;
 		ACCdesc();
		break pro003_restart;
		{}

	}

	// EX MUEBLES
	p003e0062:
	{
 		if (skipdoall('p003e0062')) break p003e0062;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0062;
			if (!CNDnoun1(201)) break p003e0062;
 		}
		if (!CNDat(32)) break p003e0062;
 		ACCwrite(1379);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PARED
	p003e0063:
	{
 		if (skipdoall('p003e0063')) break p003e0063;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0063;
			if (!CNDnoun1(177)) break p003e0063;
 		}
		if (!CNDat(32)) break p003e0063;
 		ACCwrite(1380);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX DISTRIBUID
	p003e0064:
	{
 		if (skipdoall('p003e0064')) break p003e0064;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0064;
			if (!CNDnoun1(195)) break p003e0064;
 		}
		if (!CNDat(37)) break p003e0064;
 		ACCwrite(1381);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ESTANCIA
	p003e0065:
	{
 		if (skipdoall('p003e0065')) break p003e0065;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0065;
			if (!CNDnoun1(196)) break p003e0065;
 		}
		if (!CNDat(37)) break p003e0065;
 		ACCwrite(1382);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX COCINA
	p003e0066:
	{
 		if (skipdoall('p003e0066')) break p003e0066;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0066;
			if (!CNDnoun1(64)) break p003e0066;
 		}
		if (!CNDat(37)) break p003e0066;
 		ACCwrite(1383);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX SALON
	p003e0067:
	{
 		if (skipdoall('p003e0067')) break p003e0067;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0067;
			if (!CNDnoun1(197)) break p003e0067;
 		}
		if (!CNDat(37)) break p003e0067;
 		ACCwrite(1384);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ESCALERAS
	p003e0068:
	{
 		if (skipdoall('p003e0068')) break p003e0068;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0068;
			if (!CNDnoun1(203)) break p003e0068;
 		}
		if (!CNDat(37)) break p003e0068;
 		ACCwrite(1385);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PASAMANOS
	p003e0069:
	{
 		if (skipdoall('p003e0069')) break p003e0069;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0069;
			if (!CNDnoun1(198)) break p003e0069;
 		}
		if (!CNDat(37)) break p003e0069;
 		ACCwrite(1386);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PUERTA
	p003e0070:
	{
 		if (skipdoall('p003e0070')) break p003e0070;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0070;
			if (!CNDnoun1(69)) break p003e0070;
 		}
		if (!CNDat(37)) break p003e0070;
 		ACCwrite(1387);
		{}

	}

	// EX PUERTA
	p003e0071:
	{
 		if (skipdoall('p003e0071')) break p003e0071;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0071;
			if (!CNDnoun1(69)) break p003e0071;
 		}
		if (!CNDat(37)) break p003e0071;
		if (!CNDzero(116)) break p003e0071;
 		ACCwrite(1388);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PUERTA
	p003e0072:
	{
 		if (skipdoall('p003e0072')) break p003e0072;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0072;
			if (!CNDnoun1(69)) break p003e0072;
 		}
		if (!CNDat(37)) break p003e0072;
		if (!CNDnotzero(116)) break p003e0072;
 		ACCwrite(1389);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CAMPANA
	p003e0073:
	{
 		if (skipdoall('p003e0073')) break p003e0073;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0073;
			if (!CNDnoun1(121)) break p003e0073;
 		}
		if (!CNDat(40)) break p003e0073;
 		ACCwrite(1390);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX VENTANAS
	p003e0074:
	{
 		if (skipdoall('p003e0074')) break p003e0074;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0074;
			if (!CNDnoun1(183)) break p003e0074;
 		}
		if (!CNDat(40)) break p003e0074;
 		ACCwrite(1391);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CASA
	p003e0075:
	{
 		if (skipdoall('p003e0075')) break p003e0075;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0075;
			if (!CNDnoun1(58)) break p003e0075;
 		}
		if (!CNDat(40)) break p003e0075;
 		ACCwrite(1392);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PUERTA
	p003e0076:
	{
 		if (skipdoall('p003e0076')) break p003e0076;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0076;
			if (!CNDnoun1(69)) break p003e0076;
 		}
		if (!CNDat(40)) break p003e0076;
 		ACCwrite(1393);
		{}

	}

	// EX PUERTA
	p003e0077:
	{
 		if (skipdoall('p003e0077')) break p003e0077;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0077;
			if (!CNDnoun1(69)) break p003e0077;
 		}
		if (!CNDat(40)) break p003e0077;
		if (!CNDzero(116)) break p003e0077;
 		ACCwrite(1394);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PUERTA
	p003e0078:
	{
 		if (skipdoall('p003e0078')) break p003e0078;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0078;
			if (!CNDnoun1(69)) break p003e0078;
 		}
		if (!CNDat(40)) break p003e0078;
		if (!CNDnotzero(116)) break p003e0078;
 		ACCwrite(1395);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ADORNO
	p003e0079:
	{
 		if (skipdoall('p003e0079')) break p003e0079;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0079;
			if (!CNDnoun1(193)) break p003e0079;
 		}
		if (!CNDat(40)) break p003e0079;
 		ACCwrite(1396);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX FLORES
	p003e0080:
	{
 		if (skipdoall('p003e0080')) break p003e0080;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0080;
			if (!CNDnoun1(125)) break p003e0080;
 		}
		if (!CNDat(40)) break p003e0080;
 		ACCwrite(1397);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX BUZON
	p003e0081:
	{
 		if (skipdoall('p003e0081')) break p003e0081;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0081;
			if (!CNDnoun1(97)) break p003e0081;
 		}
		if (!CNDat(41)) break p003e0081;
 		ACCwrite(1398);
 		ACCset(112);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX VALLA
	p003e0082:
	{
 		if (skipdoall('p003e0082')) break p003e0082;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0082;
			if (!CNDnoun1(145)) break p003e0082;
 		}
		if (!CNDat(41)) break p003e0082;
 		ACCwrite(1399);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PUERTA
	p003e0083:
	{
 		if (skipdoall('p003e0083')) break p003e0083;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0083;
			if (!CNDnoun1(69)) break p003e0083;
 		}
		if (!CNDat(41)) break p003e0083;
 		ACCwrite(1400);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ESTETOSCOP
	p003e0084:
	{
 		if (skipdoall('p003e0084')) break p003e0084;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0084;
			if (!CNDnoun1(190)) break p003e0084;
 		}
		if (!CNDat(5)) break p003e0084;
		if (!CNDisat(28,6)) break p003e0084;
 		ACCwrite(1401);
 		ACCmessage(18);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ESTETOSCOP
	p003e0085:
	{
 		if (skipdoall('p003e0085')) break p003e0085;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0085;
			if (!CNDnoun1(190)) break p003e0085;
 		}
		if (!CNDpresent(28)) break p003e0085;
 		ACCwrite(1402);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PANUELO
	p003e0086:
	{
 		if (skipdoall('p003e0086')) break p003e0086;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0086;
			if (!CNDnoun1(191)) break p003e0086;
 		}
		if (!CNDat(5)) break p003e0086;
		if (!CNDisat(27,6)) break p003e0086;
 		ACCwrite(1403);
 		ACCmessage(18);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PANUELO
	p003e0087:
	{
 		if (skipdoall('p003e0087')) break p003e0087;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0087;
			if (!CNDnoun1(191)) break p003e0087;
 		}
		if (!CNDpresent(27)) break p003e0087;
 		ACCwrite(1404);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX HERRAMIENT
	p003e0088:
	{
 		if (skipdoall('p003e0088')) break p003e0088;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0088;
			if (!CNDnoun1(152)) break p003e0088;
 		}
		if (!CNDat(36)) break p003e0088;
 		ACCwrite(1405);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX TRASTO
	p003e0089:
	{
 		if (skipdoall('p003e0089')) break p003e0089;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0089;
			if (!CNDnoun1(182)) break p003e0089;
 		}
		if (!CNDat(36)) break p003e0089;
		if (!CNDzero(110)) break p003e0089;
 		ACCwrite(1406);
 		ACCcreate(26);
 		ACCset(110);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX TRASTO
	p003e0090:
	{
 		if (skipdoall('p003e0090')) break p003e0090;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0090;
			if (!CNDnoun1(182)) break p003e0090;
 		}
		if (!CNDat(36)) break p003e0090;
		if (!CNDnotzero(110)) break p003e0090;
 		ACCwrite(1407);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PUERTA
	p003e0091:
	{
 		if (skipdoall('p003e0091')) break p003e0091;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0091;
			if (!CNDnoun1(69)) break p003e0091;
 		}
		if (!CNDat(36)) break p003e0091;
 		ACCwrite(1408);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX MECANISMO
	p003e0092:
	{
 		if (skipdoall('p003e0092')) break p003e0092;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0092;
			if (!CNDnoun1(189)) break p003e0092;
 		}
		if (!CNDat(36)) break p003e0092;
 		ACCwrite(1409);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX AUTO
	p003e0093:
	{
 		if (skipdoall('p003e0093')) break p003e0093;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0093;
			if (!CNDnoun1(137)) break p003e0093;
 		}
		if (!CNDat(36)) break p003e0093;
 		ACCwrite(1410);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CORTINA
	p003e0094:
	{
 		if (skipdoall('p003e0094')) break p003e0094;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0094;
			if (!CNDnoun1(186)) break p003e0094;
 		}
		if (!CNDat(35)) break p003e0094;
 		ACCwrite(1411);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CORTINA
	p003e0095:
	{
 		if (skipdoall('p003e0095')) break p003e0095;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0095;
			if (!CNDnoun1(186)) break p003e0095;
 		}
		if (!CNDat(39)) break p003e0095;
 		ACCwrite(1412);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CORTINA
	p003e0096:
	{
 		if (skipdoall('p003e0096')) break p003e0096;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0096;
			if (!CNDnoun1(186)) break p003e0096;
 		}
		if (!CNDat(41)) break p003e0096;
 		ACCwrite(1413);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ESCALON
	p003e0097:
	{
 		if (skipdoall('p003e0097')) break p003e0097;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0097;
			if (!CNDnoun1(185)) break p003e0097;
 		}
		if (!CNDat(39)) break p003e0097;
 		ACCwrite(1414);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX VENTANAS
	p003e0098:
	{
 		if (skipdoall('p003e0098')) break p003e0098;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0098;
			if (!CNDnoun1(183)) break p003e0098;
 		}
		if (!CNDat(39)) break p003e0098;
 		ACCwrite(1415);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX VENTANA
	p003e0099:
	{
 		if (skipdoall('p003e0099')) break p003e0099;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0099;
			if (!CNDnoun1(70)) break p003e0099;
 		}
		if (!CNDat(39)) break p003e0099;
 		ACCwrite(1416);
		{}

	}

	// EX VENTANA
	p003e0100:
	{
 		if (skipdoall('p003e0100')) break p003e0100;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0100;
			if (!CNDnoun1(70)) break p003e0100;
 		}
		if (!CNDat(39)) break p003e0100;
		if (!CNDzero(109)) break p003e0100;
 		ACCanykey();
 		function anykey00211() 
		{
 		ACCwrite(1419);
 		ACCdone();
		return;
		}
 		function anykey00210() 
		{
 		ACCwrite(1418);
 		ACCanykey();
 		waitKey(anykey00211);
		}
 		function anykey00209() 
		{
 		ACCwrite(1417);
 		ACCanykey();
 		waitKey(anykey00210);
		}
 		waitKey(anykey00209);
		done_flag=true;
		break pro003_restart;
		{}

	}

	// EX VENTANA
	p003e0101:
	{
 		if (skipdoall('p003e0101')) break p003e0101;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0101;
			if (!CNDnoun1(70)) break p003e0101;
 		}
		if (!CNDat(39)) break p003e0101;
		if (!CNDnotzero(109)) break p003e0101;
 		ACCanykey();
 		function anykey00212() 
		{
 		ACCwrite(1420);
 		ACCdone();
		return;
		}
 		waitKey(anykey00212);
		done_flag=true;
		break pro003_restart;
		{}

	}

	// EX CASA
	p003e0102:
	{
 		if (skipdoall('p003e0102')) break p003e0102;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0102;
			if (!CNDnoun1(58)) break p003e0102;
 		}
		if (!CNDat(39)) break p003e0102;
 		ACCwrite(1421);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX JARDIN
	p003e0103:
	{
 		if (skipdoall('p003e0103')) break p003e0103;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0103;
			if (!CNDnoun1(184)) break p003e0103;
 		}
		if (!CNDat(39)) break p003e0103;
 		ACCwrite(1422);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX FLORES
	p003e0104:
	{
 		if (skipdoall('p003e0104')) break p003e0104;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0104;
			if (!CNDnoun1(125)) break p003e0104;
 		}
		if (!CNDat(39)) break p003e0104;
 		ACCwrite(1423);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX HELECHOS
	p003e0105:
	{
 		if (skipdoall('p003e0105')) break p003e0105;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0105;
			if (!CNDnoun1(101)) break p003e0105;
 		}
		if (!CNDat(39)) break p003e0105;
 		ACCwrite(1424);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX FLORES
	p003e0106:
	{
 		if (skipdoall('p003e0106')) break p003e0106;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0106;
			if (!CNDnoun1(125)) break p003e0106;
 		}
		if (!CNDat(35)) break p003e0106;
 		ACCwrite(1425);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX HELECHOS
	p003e0107:
	{
 		if (skipdoall('p003e0107')) break p003e0107;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0107;
			if (!CNDnoun1(101)) break p003e0107;
 		}
		if (!CNDat(35)) break p003e0107;
 		ACCwrite(1426);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CASA
	p003e0108:
	{
 		if (skipdoall('p003e0108')) break p003e0108;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0108;
			if (!CNDnoun1(58)) break p003e0108;
 		}
		if (!CNDat(35)) break p003e0108;
 		ACCwrite(1427);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX VENTANAS
	p003e0109:
	{
 		if (skipdoall('p003e0109')) break p003e0109;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0109;
			if (!CNDnoun1(183)) break p003e0109;
 		}
		if (!CNDat(35)) break p003e0109;
 		ACCwrite(1428);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX JARDIN
	p003e0110:
	{
 		if (skipdoall('p003e0110')) break p003e0110;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0110;
			if (!CNDnoun1(184)) break p003e0110;
 		}
		if (!CNDat(35)) break p003e0110;
 		ACCwrite(1429);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX TRASTO
	p003e0111:
	{
 		if (skipdoall('p003e0111')) break p003e0111;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0111;
			if (!CNDnoun1(182)) break p003e0111;
 		}
		if (!CNDat(34)) break p003e0111;
 		ACCwrite(1430);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX MAGICOS
	p003e0112:
	{
 		if (skipdoall('p003e0112')) break p003e0112;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0112;
			if (!CNDnoun1(61)) break p003e0112;
 		}
		if (!CNDat(34)) break p003e0112;
 		ACCwrite(1431);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX TI
	p003e0113:
	{
 		if (skipdoall('p003e0113')) break p003e0113;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0113;
			if (!CNDnoun1(181)) break p003e0113;
 		}
		if (!CNDnotzero(107)) break p003e0113;
 		ACCwrite(1432);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX TI
	p003e0114:
	{
 		if (skipdoall('p003e0114')) break p003e0114;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0114;
			if (!CNDnoun1(181)) break p003e0114;
 		}
		if (!CNDzero(107)) break p003e0114;
 		ACCwrite(1433);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX MI
	p003e0115:
	{
 		if (skipdoall('p003e0115')) break p003e0115;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0115;
			if (!CNDnoun1(180)) break p003e0115;
 		}
		if (!CNDnotzero(107)) break p003e0115;
 		ACCwrite(1434);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX MI
	p003e0116:
	{
 		if (skipdoall('p003e0116')) break p003e0116;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0116;
			if (!CNDnoun1(180)) break p003e0116;
 		}
		if (!CNDzero(107)) break p003e0116;
 		ACCwrite(1435);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX BARROTES
	p003e0117:
	{
 		if (skipdoall('p003e0117')) break p003e0117;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0117;
			if (!CNDnoun1(178)) break p003e0117;
 		}
		if (!CNDat(34)) break p003e0117;
 		ACCwrite(1436);
		{}

	}

	// EX BARROTES
	p003e0118:
	{
 		if (skipdoall('p003e0118')) break p003e0118;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0118;
			if (!CNDnoun1(178)) break p003e0118;
 		}
		if (!CNDat(34)) break p003e0118;
		if (!CNDnotzero(106)) break p003e0118;
 		ACCwrite(1437);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX BARROTES
	p003e0119:
	{
 		if (skipdoall('p003e0119')) break p003e0119;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0119;
			if (!CNDnoun1(178)) break p003e0119;
 		}
		if (!CNDat(34)) break p003e0119;
		if (!CNDzero(106)) break p003e0119;
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX VENTANA
	p003e0120:
	{
 		if (skipdoall('p003e0120')) break p003e0120;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0120;
			if (!CNDnoun1(70)) break p003e0120;
 		}
		if (!CNDat(34)) break p003e0120;
 		ACCwrite(1438);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX BUHARDILLA
	p003e0121:
	{
 		if (skipdoall('p003e0121')) break p003e0121;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0121;
			if (!CNDnoun1(171)) break p003e0121;
 		}
		if (!CNDat(34)) break p003e0121;
 		ACCgoto(34);
 		ACCdesc();
		break pro003_restart;
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX TECHO
	p003e0122:
	{
 		if (skipdoall('p003e0122')) break p003e0122;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0122;
			if (!CNDnoun1(82)) break p003e0122;
 		}
		if (!CNDat(34)) break p003e0122;
 		ACCwrite(1439);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PARED
	p003e0123:
	{
 		if (skipdoall('p003e0123')) break p003e0123;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0123;
			if (!CNDnoun1(177)) break p003e0123;
 		}
		if (!CNDat(34)) break p003e0123;
 		ACCwrite(1440);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ESPUMA
	p003e0124:
	{
 		if (skipdoall('p003e0124')) break p003e0124;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0124;
			if (!CNDnoun1(176)) break p003e0124;
 		}
		if (!CNDat(34)) break p003e0124;
 		ACCwrite(1441);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX SUELO
	p003e0125:
	{
 		if (skipdoall('p003e0125')) break p003e0125;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0125;
			if (!CNDnoun1(120)) break p003e0125;
 		}
		if (!CNDat(34)) break p003e0125;
 		ACCwrite(1442);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX VENTILADOR
	p003e0126:
	{
 		if (skipdoall('p003e0126')) break p003e0126;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0126;
			if (!CNDnoun1(175)) break p003e0126;
 		}
		if (!CNDat(34)) break p003e0126;
 		ACCwrite(1443);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CAJAS
	p003e0127:
	{
 		if (skipdoall('p003e0127')) break p003e0127;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0127;
			if (!CNDnoun1(172)) break p003e0127;
 		}
		if (!CNDat(34)) break p003e0127;
 		ACCwrite(1444);
		{}

	}

	// EX CAJAS
	p003e0128:
	{
 		if (skipdoall('p003e0128')) break p003e0128;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0128;
			if (!CNDnoun1(172)) break p003e0128;
 		}
		if (!CNDat(34)) break p003e0128;
		if (!CNDzero(105)) break p003e0128;
 		ACCwrite(1445);
 		ACCcreate(24);
 		ACCcreate(25);
 		ACCset(105);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CAJAS
	p003e0129:
	{
 		if (skipdoall('p003e0129')) break p003e0129;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0129;
			if (!CNDnoun1(172)) break p003e0129;
 		}
		if (!CNDat(34)) break p003e0129;
		if (!CNDnotzero(105)) break p003e0129;
 		ACCwrite(1446);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX BUHARDILLA
	p003e0130:
	{
 		if (skipdoall('p003e0130')) break p003e0130;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0130;
			if (!CNDnoun1(171)) break p003e0130;
 		}
		if (!CNDat(34)) break p003e0130;
 		ACCdesc();
		break pro003_restart;
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX TRAMPILLA
	p003e0131:
	{
 		if (skipdoall('p003e0131')) break p003e0131;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0131;
			if (!CNDnoun1(170)) break p003e0131;
 		}
		if (!CNDat(34)) break p003e0131;
 		ACCwrite(1447);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CASETES
	p003e0132:
	{
 		if (skipdoall('p003e0132')) break p003e0132;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0132;
			if (!CNDnoun1(153)) break p003e0132;
 		}
		if (!CNDat(29)) break p003e0132;
 		ACCwrite(1448);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX HERRAMIENT
	p003e0133:
	{
 		if (skipdoall('p003e0133')) break p003e0133;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0133;
			if (!CNDnoun1(152)) break p003e0133;
 		}
		if (!CNDat(29)) break p003e0133;
 		ACCwrite(1449);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX COMPUTADOR
	p003e0134:
	{
 		if (skipdoall('p003e0134')) break p003e0134;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0134;
			if (!CNDnoun1(224)) break p003e0134;
 		}
		if (!CNDat(29)) break p003e0134;
 		ACCwrite(1450);
		{}

	}

	// EX COMPUTADOR
	p003e0135:
	{
 		if (skipdoall('p003e0135')) break p003e0135;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0135;
			if (!CNDnoun1(224)) break p003e0135;
 		}
		if (!CNDat(29)) break p003e0135;
		if (!CNDzero(97)) break p003e0135;
 		ACCwrite(1451);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX COMPUTADOR
	p003e0136:
	{
 		if (skipdoall('p003e0136')) break p003e0136;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0136;
			if (!CNDnoun1(224)) break p003e0136;
 		}
		if (!CNDat(29)) break p003e0136;
		if (!CNDnotzero(97)) break p003e0136;
 		ACCwrite(1452);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CPU
	p003e0137:
	{
 		if (skipdoall('p003e0137')) break p003e0137;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0137;
			if (!CNDnoun1(159)) break p003e0137;
 		}
		if (!CNDat(29)) break p003e0137;
 		ACCwrite(1453);
		{}

	}

	// EX CPU
	p003e0138:
	{
 		if (skipdoall('p003e0138')) break p003e0138;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0138;
			if (!CNDnoun1(159)) break p003e0138;
 		}
		if (!CNDat(29)) break p003e0138;
		if (!CNDeq(97,2)) break p003e0138;
 		ACCwrite(1454);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CPU
	p003e0139:
	{
 		if (skipdoall('p003e0139')) break p003e0139;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0139;
			if (!CNDnoun1(159)) break p003e0139;
 		}
		if (!CNDat(29)) break p003e0139;
		if (!CNDeq(97,3)) break p003e0139;
 		ACCwrite(1455);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CPU
	p003e0140:
	{
 		if (skipdoall('p003e0140')) break p003e0140;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0140;
			if (!CNDnoun1(159)) break p003e0140;
 		}
		if (!CNDat(29)) break p003e0140;
		if (!CNDnoteq(97,3)) break p003e0140;
		if (!CNDnoteq(97,2)) break p003e0140;
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX TECLADO
	p003e0141:
	{
 		if (skipdoall('p003e0141')) break p003e0141;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0141;
			if (!CNDnoun1(158)) break p003e0141;
 		}
		if (!CNDat(29)) break p003e0141;
 		ACCwrite(1456);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX MONITOR
	p003e0142:
	{
 		if (skipdoall('p003e0142')) break p003e0142;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0142;
			if (!CNDnoun1(157)) break p003e0142;
 		}
		if (!CNDat(29)) break p003e0142;
		if (!CNDeq(97,0)) break p003e0142;
 		ACCwrite(1457);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX MONITOR
	p003e0143:
	{
 		if (skipdoall('p003e0143')) break p003e0143;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0143;
			if (!CNDnoun1(157)) break p003e0143;
 		}
		if (!CNDat(29)) break p003e0143;
		if (!CNDeq(97,1)) break p003e0143;
 		ACCwrite(1458);
 		ACCwrite(1459);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX MONITOR
	p003e0144:
	{
 		if (skipdoall('p003e0144')) break p003e0144;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0144;
			if (!CNDnoun1(157)) break p003e0144;
 		}
		if (!CNDat(29)) break p003e0144;
		if (!CNDeq(97,3)) break p003e0144;
 		ACCwrite(1460);
 		ACCwrite(1461);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX MONITOR
	p003e0145:
	{
 		if (skipdoall('p003e0145')) break p003e0145;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0145;
			if (!CNDnoun1(157)) break p003e0145;
 		}
		if (!CNDat(29)) break p003e0145;
		if (!CNDeq(97,2)) break p003e0145;
		if (!CNDeq(98,0)) break p003e0145;
 		ACCmessage(19);
 		ACCwrite(1462);
 		ACCwrite(1463);
 		ACCwrite(1464);
 		ACCwrite(1465);
 		ACCwrite(1466);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX MONITOR
	p003e0146:
	{
 		if (skipdoall('p003e0146')) break p003e0146;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0146;
			if (!CNDnoun1(157)) break p003e0146;
 		}
		if (!CNDat(29)) break p003e0146;
		if (!CNDeq(97,2)) break p003e0146;
		if (!CNDeq(98,1)) break p003e0146;
 		ACCmessage(19);
 		ACCwrite(1467);
 		ACCwrite(1468);
 		ACCwrite(1469);
 		ACCwrite(1470);
 		ACCwrite(1471);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX MONITOR
	p003e0147:
	{
 		if (skipdoall('p003e0147')) break p003e0147;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0147;
			if (!CNDnoun1(157)) break p003e0147;
 		}
		if (!CNDat(29)) break p003e0147;
		if (!CNDeq(97,2)) break p003e0147;
		if (!CNDeq(98,2)) break p003e0147;
 		ACCmessage(19);
 		ACCwrite(1472);
 		ACCwrite(1473);
 		ACCwrite(1474);
 		ACCwrite(1475);
 		ACCwrite(1476);
 		ACCwrite(1477);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX MONITOR
	p003e0148:
	{
 		if (skipdoall('p003e0148')) break p003e0148;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0148;
			if (!CNDnoun1(157)) break p003e0148;
 		}
		if (!CNDat(29)) break p003e0148;
		if (!CNDeq(97,2)) break p003e0148;
		if (!CNDeq(98,3)) break p003e0148;
 		ACCmessage(19);
 		ACCwrite(1478);
 		ACCwrite(1479);
 		ACCwrite(1480);
 		ACCwrite(1481);
 		ACCwrite(1482);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ROPA
	p003e0149:
	{
 		if (skipdoall('p003e0149')) break p003e0149;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0149;
			if (!CNDnoun1(60)) break p003e0149;
 		}
		if (!CNDat(29)) break p003e0149;
 		ACCwrite(1483);
		{}

	}

	// EX ROPA
	p003e0150:
	{
 		if (skipdoall('p003e0150')) break p003e0150;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0150;
			if (!CNDnoun1(60)) break p003e0150;
 		}
		if (!CNDat(29)) break p003e0150;
		if (!CNDzero(96)) break p003e0150;
 		ACCwrite(1484);
 		ACCset(96);
 		ACCcreate(22);
 		ACCcreate(23);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ROPA
	p003e0151:
	{
 		if (skipdoall('p003e0151')) break p003e0151;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0151;
			if (!CNDnoun1(60)) break p003e0151;
 		}
		if (!CNDat(29)) break p003e0151;
		if (!CNDnotzero(96)) break p003e0151;
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX LIBROS
	p003e0152:
	{
 		if (skipdoall('p003e0152')) break p003e0152;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0152;
			if (!CNDnoun1(54)) break p003e0152;
 		}
		if (!CNDat(29)) break p003e0152;
 		ACCwrite(1485);
		{}

	}

	// EX LIBROS
	p003e0153:
	{
 		if (skipdoall('p003e0153')) break p003e0153;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0153;
			if (!CNDnoun1(54)) break p003e0153;
 		}
		if (!CNDat(29)) break p003e0153;
		if (!CNDzero(95)) break p003e0153;
 		ACCwrite(1486);
 		ACCcreate(21);
 		ACCset(95);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX LIBROS
	p003e0154:
	{
 		if (skipdoall('p003e0154')) break p003e0154;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0154;
			if (!CNDnoun1(54)) break p003e0154;
 		}
		if (!CNDat(29)) break p003e0154;
		if (!CNDnotzero(95)) break p003e0154;
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PUERTA
	p003e0155:
	{
 		if (skipdoall('p003e0155')) break p003e0155;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0155;
			if (!CNDnoun1(69)) break p003e0155;
 		}
		if (!CNDat(29)) break p003e0155;
 		ACCwrite(1487);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ALFOMBRA
	p003e0156:
	{
 		if (skipdoall('p003e0156')) break p003e0156;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0156;
			if (!CNDnoun1(150)) break p003e0156;
 		}
		if (!CNDat(28)) break p003e0156;
 		ACCwrite(1488);
		{}

	}

	// EX ALFOMBRA
	p003e0157:
	{
 		if (skipdoall('p003e0157')) break p003e0157;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0157;
			if (!CNDnoun1(150)) break p003e0157;
 		}
		if (!CNDat(28)) break p003e0157;
		if (!CNDzero(94)) break p003e0157;
 		ACCwrite(1489);
 		ACCcreate(20);
 		ACCset(94);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ALFOMBRA
	p003e0158:
	{
 		if (skipdoall('p003e0158')) break p003e0158;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0158;
			if (!CNDnoun1(150)) break p003e0158;
 		}
		if (!CNDat(28)) break p003e0158;
		if (!CNDnotzero(94)) break p003e0158;
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CAJA
	p003e0159:
	{
 		if (skipdoall('p003e0159')) break p003e0159;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0159;
			if (!CNDnoun1(89)) break p003e0159;
 		}
		if (!CNDpresent(26)) break p003e0159;
 		ACCwrite(1490);
		{}

	}

	// EX CAJA
	p003e0160:
	{
 		if (skipdoall('p003e0160')) break p003e0160;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0160;
			if (!CNDnoun1(89)) break p003e0160;
 		}
		if (!CNDpresent(26)) break p003e0160;
		if (!CNDnotzero(112)) break p003e0160;
 		ACCwrite(1491);
		{}

	}

	// EX CAJA
	p003e0161:
	{
 		if (skipdoall('p003e0161')) break p003e0161;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0161;
			if (!CNDnoun1(89)) break p003e0161;
 		}
		if (!CNDpresent(26)) break p003e0161;
 		ACCobjat(38,73);
		if (!CNDzero(73)) break p003e0161;
 		ACCwrite(1492);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CAJA
	p003e0162:
	{
 		if (skipdoall('p003e0162')) break p003e0162;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0162;
			if (!CNDnoun1(89)) break p003e0162;
 		}
		if (!CNDpresent(26)) break p003e0162;
 		ACCobjat(38,73);
		if (!CNDnotzero(73)) break p003e0162;
 		ACCwrite(1493);
 		ACClistat(38);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ROTULADOR
	p003e0163:
	{
 		if (skipdoall('p003e0163')) break p003e0163;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0163;
			if (!CNDnoun1(174)) break p003e0163;
 		}
		if (!CNDat(5)) break p003e0163;
		if (!CNDisat(25,6)) break p003e0163;
 		ACCwrite(1494);
 		ACCmessage(18);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ROTULADOR
	p003e0164:
	{
 		if (skipdoall('p003e0164')) break p003e0164;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0164;
			if (!CNDnoun1(174)) break p003e0164;
 		}
		if (!CNDpresent(25)) break p003e0164;
 		ACCwrite(1495);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX JABON
	p003e0165:
	{
 		if (skipdoall('p003e0165')) break p003e0165;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0165;
			if (!CNDnoun1(173)) break p003e0165;
 		}
		if (!CNDat(5)) break p003e0165;
		if (!CNDisat(24,6)) break p003e0165;
 		ACCwrite(1496);
 		ACCmessage(18);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX JABON
	p003e0166:
	{
 		if (skipdoall('p003e0166')) break p003e0166;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0166;
			if (!CNDnoun1(173)) break p003e0166;
 		}
		if (!CNDpresent(24)) break p003e0166;
 		ACCwrite(1497);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CD
	p003e0167:
	{
 		if (skipdoall('p003e0167')) break p003e0167;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0167;
			if (!CNDnoun1(156)) break p003e0167;
 		}
		if (!CNDpresent(23)) break p003e0167;
 		ACCwrite(1498);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CD
	p003e0168:
	{
 		if (skipdoall('p003e0168')) break p003e0168;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0168;
			if (!CNDnoun1(156)) break p003e0168;
 		}
		if (!CNDat(5)) break p003e0168;
		if (!CNDisat(23,6)) break p003e0168;
 		ACCwrite(1499);
 		ACCmessage(18);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX DIARIO
	p003e0169:
	{
 		if (skipdoall('p003e0169')) break p003e0169;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0169;
			if (!CNDnoun1(51)) break p003e0169;
 		}
		if (!CNDpresent(21)) break p003e0169;
 		ACCwrite(1500);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX DIARIO
	p003e0170:
	{
 		if (skipdoall('p003e0170')) break p003e0170;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0170;
			if (!CNDnoun1(51)) break p003e0170;
 		}
		if (!CNDat(5)) break p003e0170;
		if (!CNDisat(21,6)) break p003e0170;
 		ACCwrite(1501);
 		ACCmessage(18);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX NOTA
	p003e0171:
	{
 		if (skipdoall('p003e0171')) break p003e0171;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0171;
			if (!CNDnoun1(149)) break p003e0171;
 		}
		if (!CNDpresent(20)) break p003e0171;
 		ACCwrite(1502);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX NOTA
	p003e0172:
	{
 		if (skipdoall('p003e0172')) break p003e0172;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0172;
			if (!CNDnoun1(149)) break p003e0172;
 		}
		if (!CNDat(5)) break p003e0172;
		if (!CNDisat(20,6)) break p003e0172;
 		ACCwrite(1503);
 		ACCmessage(18);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PUERTA
	p003e0173:
	{
 		if (skipdoall('p003e0173')) break p003e0173;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0173;
			if (!CNDnoun1(69)) break p003e0173;
 		}
		if (!CNDat(28)) break p003e0173;
		if (!CNDzero(93)) break p003e0173;
 		ACCwrite(1504);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PUERTA
	p003e0174:
	{
 		if (skipdoall('p003e0174')) break p003e0174;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0174;
			if (!CNDnoun1(69)) break p003e0174;
 		}
		if (!CNDat(28)) break p003e0174;
		if (!CNDnotzero(93)) break p003e0174;
 		ACCwrite(1505);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX FUENTE
	p003e0175:
	{
 		if (skipdoall('p003e0175')) break p003e0175;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0175;
			if (!CNDnoun1(146)) break p003e0175;
 		}
		if (!CNDat(28)) break p003e0175;
 		ACCwrite(1506);
 		ACCwrite(1507);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ELFOS
	p003e0176:
	{
 		if (skipdoall('p003e0176')) break p003e0176;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0176;
			if (!CNDnoun1(147)) break p003e0176;
 		}
		if (!CNDat(28)) break p003e0176;
 		ACCwrite(1508);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CAMINO
	p003e0177:
	{
 		if (skipdoall('p003e0177')) break p003e0177;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0177;
			if (!CNDnoun1(119)) break p003e0177;
 		}
		if (!CNDat(27)) break p003e0177;
 		ACCwrite(1509);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX TECHO
	p003e0178:
	{
 		if (skipdoall('p003e0178')) break p003e0178;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0178;
			if (!CNDnoun1(82)) break p003e0178;
 		}
		if (!CNDat(27)) break p003e0178;
 		ACCwrite(1510);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PLANTA
	p003e0179:
	{
 		if (skipdoall('p003e0179')) break p003e0179;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0179;
			if (!CNDnoun1(28)) break p003e0179;
 		}
		if (!CNDat(27)) break p003e0179;
 		ACCwrite(1511);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX HELECHOS
	p003e0180:
	{
 		if (skipdoall('p003e0180')) break p003e0180;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0180;
			if (!CNDnoun1(101)) break p003e0180;
 		}
		if (!CNDat(27)) break p003e0180;
 		ACCwrite(1512);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PARQUE
	p003e0181:
	{
 		if (skipdoall('p003e0181')) break p003e0181;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0181;
			if (!CNDnoun1(148)) break p003e0181;
 		}
		if (!CNDat(26)) break p003e0181;
 		ACCwrite(1513);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX VALLA
	p003e0182:
	{
 		if (skipdoall('p003e0182')) break p003e0182;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0182;
			if (!CNDnoun1(145)) break p003e0182;
 		}
		if (!CNDat(26)) break p003e0182;
 		ACCwrite(1514);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PUERTA
	p003e0183:
	{
 		if (skipdoall('p003e0183')) break p003e0183;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0183;
			if (!CNDnoun1(69)) break p003e0183;
 		}
		if (!CNDat(26)) break p003e0183;
 		ACCwrite(1515);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX AVISO
	p003e0184:
	{
 		if (skipdoall('p003e0184')) break p003e0184;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0184;
			if (!CNDnoun1(143)) break p003e0184;
 		}
		if (!CNDat(25)) break p003e0184;
 		ACCwrite(1516);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX BOTON
	p003e0185:
	{
 		if (skipdoall('p003e0185')) break p003e0185;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0185;
			if (!CNDnoun1(142)) break p003e0185;
 		}
		if (!CNDat(25)) break p003e0185;
 		ACCwrite(1517);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CIUDAD
	p003e0186:
	{
 		if (skipdoall('p003e0186')) break p003e0186;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0186;
			if (!CNDnoun1(134)) break p003e0186;
 		}
		if (!CNDat(25)) break p003e0186;
 		ACCwrite(1518);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX TAXI
	p003e0187:
	{
 		if (skipdoall('p003e0187')) break p003e0187;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0187;
			if (!CNDnoun1(194)) break p003e0187;
 		}
		if (!CNDat(25)) break p003e0187;
 		ACCwrite(1519);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX SEMAFORO
	p003e0188:
	{
 		if (skipdoall('p003e0188')) break p003e0188;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0188;
			if (!CNDnoun1(144)) break p003e0188;
 		}
		if (!CNDat(25)) break p003e0188;
		if (!CNDeq(91,0)) break p003e0188;
 		ACCwrite(1520);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX SEMAFORO
	p003e0189:
	{
 		if (skipdoall('p003e0189')) break p003e0189;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0189;
			if (!CNDnoun1(144)) break p003e0189;
 		}
		if (!CNDat(25)) break p003e0189;
		if (!CNDeq(91,1)) break p003e0189;
 		ACCwrite(1521);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CALLE
	p003e0190:
	{
 		if (skipdoall('p003e0190')) break p003e0190;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0190;
			if (!CNDnoun1(141)) break p003e0190;
 		}
		if (!CNDat(25)) break p003e0190;
		if (!CNDeq(91,0)) break p003e0190;
 		ACCwrite(1522);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CALLE
	p003e0191:
	{
 		if (skipdoall('p003e0191')) break p003e0191;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0191;
			if (!CNDnoun1(141)) break p003e0191;
 		}
		if (!CNDat(25)) break p003e0191;
		if (!CNDeq(91,0)) break p003e0191;
 		ACCwrite(1523);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ARBOLES
	p003e0192:
	{
 		if (skipdoall('p003e0192')) break p003e0192;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0192;
			if (!CNDnoun1(84)) break p003e0192;
 		}
		if (!CNDat(25)) break p003e0192;
 		ACCwrite(1524);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ARBOL
	p003e0193:
	{
 		if (skipdoall('p003e0193')) break p003e0193;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0193;
			if (!CNDnoun1(59)) break p003e0193;
 		}
		if (!CNDat(25)) break p003e0193;
 		ACCwrite(1525);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX EDIFICIO
	p003e0194:
	{
 		if (skipdoall('p003e0194')) break p003e0194;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0194;
			if (!CNDnoun1(136)) break p003e0194;
 		}
		if (!CNDat(25)) break p003e0194;
 		ACCwrite(1526);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX GENTE
	p003e0195:
	{
 		if (skipdoall('p003e0195')) break p003e0195;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0195;
			if (!CNDnoun1(140)) break p003e0195;
 		}
		if (!CNDat(25)) break p003e0195;
 		ACCwrite(1527);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX AUTO
	p003e0196:
	{
 		if (skipdoall('p003e0196')) break p003e0196;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0196;
			if (!CNDnoun1(137)) break p003e0196;
 		}
		if (!CNDat(25)) break p003e0196;
 		ACCwrite(1528);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX TIENDA
	p003e0197:
	{
 		if (skipdoall('p003e0197')) break p003e0197;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0197;
			if (!CNDnoun1(138)) break p003e0197;
 		}
		if (!CNDat(25)) break p003e0197;
 		ACCwrite(1529);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CIUDAD
	p003e0198:
	{
 		if (skipdoall('p003e0198')) break p003e0198;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0198;
			if (!CNDnoun1(134)) break p003e0198;
 		}
		if (!CNDat(24)) break p003e0198;
 		ACCwrite(1530);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CALLEJON
	p003e0199:
	{
 		if (skipdoall('p003e0199')) break p003e0199;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0199;
			if (!CNDnoun1(133)) break p003e0199;
 		}
		if (!CNDat(24)) break p003e0199;
 		ACCwrite(1531);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX MONTANA
	p003e0200:
	{
 		if (skipdoall('p003e0200')) break p003e0200;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0200;
			if (!CNDnoun1(80)) break p003e0200;
 		}
		if (!CNDat(23)) break p003e0200;
 		ACCwrite(1532);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CARRETERA
	p003e0201:
	{
 		if (skipdoall('p003e0201')) break p003e0201;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0201;
			if (!CNDnoun1(135)) break p003e0201;
 		}
		if (!CNDat(23)) break p003e0201;
 		ACCwrite(1533);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX RUTA
	p003e0202:
	{
 		if (skipdoall('p003e0202')) break p003e0202;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0202;
			if (!CNDnoun1(94)) break p003e0202;
 		}
		if (!CNDat(23)) break p003e0202;
 		ACCwrite(1534);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX MONTANA
	p003e0203:
	{
 		if (skipdoall('p003e0203')) break p003e0203;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0203;
			if (!CNDnoun1(80)) break p003e0203;
 		}
		if (!CNDat(14)) break p003e0203;
 		ACCwrite(1535);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX RUTA
	p003e0204:
	{
 		if (skipdoall('p003e0204')) break p003e0204;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0204;
			if (!CNDnoun1(94)) break p003e0204;
 		}
		if (!CNDat(14)) break p003e0204;
 		ACCwrite(1536);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CARRETERA
	p003e0205:
	{
 		if (skipdoall('p003e0205')) break p003e0205;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0205;
			if (!CNDnoun1(135)) break p003e0205;
 		}
		if (!CNDat(14)) break p003e0205;
 		ACCwrite(1537);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PUERTA
	p003e0206:
	{
 		if (skipdoall('p003e0206')) break p003e0206;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0206;
			if (!CNDnoun1(69)) break p003e0206;
 		}
		if (!CNDat(18)) break p003e0206;
		if (!CNDzero(87)) break p003e0206;
 		ACCwrite(1538);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PUERTA
	p003e0207:
	{
 		if (skipdoall('p003e0207')) break p003e0207;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0207;
			if (!CNDnoun1(69)) break p003e0207;
 		}
		if (!CNDat(18)) break p003e0207;
		if (!CNDnotzero(18)) break p003e0207;
 		ACCwrite(1539);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX TRIDENTE
	p003e0208:
	{
 		if (skipdoall('p003e0208')) break p003e0208;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0208;
			if (!CNDnoun1(131)) break p003e0208;
 		}
		if (!CNDpresent(19)) break p003e0208;
 		ACCwrite(1540);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX FLOR
	p003e0209:
	{
 		if (skipdoall('p003e0209')) break p003e0209;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0209;
			if (!CNDnoun1(126)) break p003e0209;
 		}
		if (!CNDat(5)) break p003e0209;
		if (!CNDisat(19,6)) break p003e0209;
 		ACCwrite(1541);
 		ACCwrite(1542);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX MAGICOS
	p003e0210:
	{
 		if (skipdoall('p003e0210')) break p003e0210;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0210;
			if (!CNDnoun1(61)) break p003e0210;
 		}
		if (!CNDat(18)) break p003e0210;
		if (!CNDnotzero(87)) break p003e0210;
 		ACCwrite(1543);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX GUARIDA
	p003e0211:
	{
 		if (skipdoall('p003e0211')) break p003e0211;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0211;
			if (!CNDnoun1(132)) break p003e0211;
 		}
		if (!CNDat(18)) break p003e0211;
		if (!CNDzero(87)) break p003e0211;
 		ACCwrite(1544);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX GUARIDA
	p003e0212:
	{
 		if (skipdoall('p003e0212')) break p003e0212;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0212;
			if (!CNDnoun1(132)) break p003e0212;
 		}
		if (!CNDat(18)) break p003e0212;
		if (!CNDnotzero(87)) break p003e0212;
 		ACCwrite(1545);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CASA
	p003e0213:
	{
 		if (skipdoall('p003e0213')) break p003e0213;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0213;
			if (!CNDnoun1(58)) break p003e0213;
 		}
		if (!CNDat(18)) break p003e0213;
		if (!CNDzero(87)) break p003e0213;
 		ACCwrite(1546);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CASA
	p003e0214:
	{
 		if (skipdoall('p003e0214')) break p003e0214;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0214;
			if (!CNDnoun1(58)) break p003e0214;
 		}
		if (!CNDat(18)) break p003e0214;
		if (!CNDnotzero(87)) break p003e0214;
 		ACCwrite(1547);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ROCA
	p003e0215:
	{
 		if (skipdoall('p003e0215')) break p003e0215;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0215;
			if (!CNDnoun1(130)) break p003e0215;
 		}
		if (!CNDatgt(14)) break p003e0215;
		if (!CNDatlt(18)) break p003e0215;
 		ACCwrite(1548);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ROCA
	p003e0216:
	{
 		if (skipdoall('p003e0216')) break p003e0216;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0216;
			if (!CNDnoun1(130)) break p003e0216;
 		}
		if (!CNDatgt(18)) break p003e0216;
		if (!CNDatlt(22)) break p003e0216;
 		ACCwrite(1549);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX MONTANA
	p003e0217:
	{
 		if (skipdoall('p003e0217')) break p003e0217;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0217;
			if (!CNDnoun1(80)) break p003e0217;
 		}
		if (!CNDatgt(14)) break p003e0217;
		if (!CNDatlt(18)) break p003e0217;
 		ACCwrite(1550);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX MONTANA
	p003e0218:
	{
 		if (skipdoall('p003e0218')) break p003e0218;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0218;
			if (!CNDnoun1(80)) break p003e0218;
 		}
		if (!CNDatgt(18)) break p003e0218;
		if (!CNDatlt(22)) break p003e0218;
 		ACCwrite(1551);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX RUTA
	p003e0219:
	{
 		if (skipdoall('p003e0219')) break p003e0219;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0219;
			if (!CNDnoun1(94)) break p003e0219;
 		}
		if (!CNDatgt(14)) break p003e0219;
		if (!CNDatlt(18)) break p003e0219;
 		ACCwrite(1552);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX RUTA
	p003e0220:
	{
 		if (skipdoall('p003e0220')) break p003e0220;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0220;
			if (!CNDnoun1(94)) break p003e0220;
 		}
		if (!CNDatgt(18)) break p003e0220;
		if (!CNDatlt(22)) break p003e0220;
 		ACCwrite(1553);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CAMINO
	p003e0221:
	{
 		if (skipdoall('p003e0221')) break p003e0221;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0221;
			if (!CNDnoun1(119)) break p003e0221;
 		}
		if (!CNDatgt(14)) break p003e0221;
		if (!CNDatlt(18)) break p003e0221;
 		ACCwrite(1554);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CAMINO
	p003e0222:
	{
 		if (skipdoall('p003e0222')) break p003e0222;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0222;
			if (!CNDnoun1(119)) break p003e0222;
 		}
		if (!CNDatgt(18)) break p003e0222;
		if (!CNDatlt(22)) break p003e0222;
 		ACCwrite(1555);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CASETA
	p003e0223:
	{
 		if (skipdoall('p003e0223')) break p003e0223;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0223;
			if (!CNDnoun1(129)) break p003e0223;
 		}
		if (!CNDat(11)) break p003e0223;
 		ACCwrite(1556);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CLARO
	p003e0224:
	{
 		if (skipdoall('p003e0224')) break p003e0224;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0224;
			if (!CNDnoun1(79)) break p003e0224;
 		}
		if (!CNDat(11)) break p003e0224;
 		ACCwrite(1557);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ARBOLES
	p003e0225:
	{
 		if (skipdoall('p003e0225')) break p003e0225;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0225;
			if (!CNDnoun1(84)) break p003e0225;
 		}
		if (!CNDat(11)) break p003e0225;
 		ACCwrite(1558);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX BM
	p003e0226:
	{
 		if (skipdoall('p003e0226')) break p003e0226;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0226;
			if (!CNDnoun1(23)) break p003e0226;
 		}
		if (!CNDat(11)) break p003e0226;
		if (!CNDeq(85,0)) break p003e0226;
 		ACCwrite(1559);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX BM
	p003e0227:
	{
 		if (skipdoall('p003e0227')) break p003e0227;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0227;
			if (!CNDnoun1(23)) break p003e0227;
 		}
		if (!CNDeq(85,1)) break p003e0227;
		if (!CNDsame(38,86)) break p003e0227;
 		ACCwrite(1560);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX SALCHICHA
	p003e0228:
	{
 		if (skipdoall('p003e0228')) break p003e0228;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0228;
			if (!CNDnoun1(127)) break p003e0228;
 		}
		if (!CNDpresent(18)) break p003e0228;
 		ACCwrite(1561);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX SALCHICHA
	p003e0229:
	{
 		if (skipdoall('p003e0229')) break p003e0229;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0229;
			if (!CNDnoun1(127)) break p003e0229;
 		}
		if (!CNDat(5)) break p003e0229;
		if (!CNDisat(18,6)) break p003e0229;
 		ACCwrite(1562);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX SALCHICHA
	p003e0230:
	{
 		if (skipdoall('p003e0230')) break p003e0230;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0230;
			if (!CNDnoun1(127)) break p003e0230;
 		}
		if (!CNDpresent(17)) break p003e0230;
 		ACCwrite(1563);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX SALCHICHA
	p003e0231:
	{
 		if (skipdoall('p003e0231')) break p003e0231;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0231;
			if (!CNDnoun1(127)) break p003e0231;
 		}
		if (!CNDat(5)) break p003e0231;
		if (!CNDisat(17,6)) break p003e0231;
 		ACCwrite(1564);
 		ACCwrite(1565);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX FLOR
	p003e0232:
	{
 		if (skipdoall('p003e0232')) break p003e0232;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0232;
			if (!CNDnoun1(126)) break p003e0232;
 		}
		if (!CNDpresent(16)) break p003e0232;
 		ACCwrite(1566);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX FLOR
	p003e0233:
	{
 		if (skipdoall('p003e0233')) break p003e0233;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0233;
			if (!CNDnoun1(126)) break p003e0233;
 		}
		if (!CNDat(5)) break p003e0233;
		if (!CNDisat(16,6)) break p003e0233;
 		ACCwrite(1567);
 		ACCwrite(1568);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX FLORES
	p003e0234:
	{
 		if (skipdoall('p003e0234')) break p003e0234;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0234;
			if (!CNDnoun1(125)) break p003e0234;
 		}
		if (!CNDat(13)) break p003e0234;
 		ACCwrite(1569);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX COCINA
	p003e0235:
	{
 		if (skipdoall('p003e0235')) break p003e0235;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0235;
			if (!CNDnoun1(64)) break p003e0235;
 		}
		if (!CNDat(13)) break p003e0235;
		if (!CNDeq(82,0)) break p003e0235;
 		ACCwrite(1570);
 		ACCcreate(15);
 		ACClet(82,1);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX COCINA
	p003e0236:
	{
 		if (skipdoall('p003e0236')) break p003e0236;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0236;
			if (!CNDnoun1(64)) break p003e0236;
 		}
		if (!CNDat(13)) break p003e0236;
		if (!CNDeq(82,1)) break p003e0236;
 		ACCwrite(1571);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX NINFA
	p003e0237:
	{
 		if (skipdoall('p003e0237')) break p003e0237;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0237;
			if (!CNDnoun1(21)) break p003e0237;
 		}
		if (!CNDat(13)) break p003e0237;
 		ACCwrite(1572);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX MESILLA
	p003e0238:
	{
 		if (skipdoall('p003e0238')) break p003e0238;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0238;
			if (!CNDnoun1(123)) break p003e0238;
 		}
		if (!CNDat(13)) break p003e0238;
 		ACCwrite(1573);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX MAGICOS
	p003e0239:
	{
 		if (skipdoall('p003e0239')) break p003e0239;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0239;
			if (!CNDnoun1(61)) break p003e0239;
 		}
		if (!CNDat(13)) break p003e0239;
 		ACCwrite(1574);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX FOTO
	p003e0240:
	{
 		if (skipdoall('p003e0240')) break p003e0240;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0240;
			if (!CNDnoun1(55)) break p003e0240;
 		}
		if (!CNDat(13)) break p003e0240;
 		ACCpicture(21);
 		ACCwrite(1575);
 		ACCanykey();
 		function anykey00213() 
		{
 		ACCpicture(19);
 		ACCdone();
		return;
		}
 		waitKey(anykey00213);
		done_flag=true;
		break pro003_restart;
		{}

	}

	// EX COFRE
	p003e0241:
	{
 		if (skipdoall('p003e0241')) break p003e0241;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0241;
			if (!CNDnoun1(22)) break p003e0241;
 		}
		if (!CNDat(13)) break p003e0241;
		if (!CNDeq(80,0)) break p003e0241;
 		ACCwrite(1576);
 		ACCanykey();
 		function anykey00214() 
		{
 		ACCwrite(1577);
 		ACCplus(80,1);
 		ACCdone();
		return;
		}
 		waitKey(anykey00214);
		done_flag=true;
		break pro003_restart;
		{}

	}

	// EX COFRE
	p003e0242:
	{
 		if (skipdoall('p003e0242')) break p003e0242;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0242;
			if (!CNDnoun1(22)) break p003e0242;
 		}
		if (!CNDat(13)) break p003e0242;
		if (!CNDeq(80,1)) break p003e0242;
 		ACCwrite(1578);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX SUELO
	p003e0243:
	{
 		if (skipdoall('p003e0243')) break p003e0243;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0243;
			if (!CNDnoun1(120)) break p003e0243;
 		}
		if (!CNDat(9)) break p003e0243;
 		ACCwrite(1579);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CHAMPINON
	p003e0244:
	{
 		if (skipdoall('p003e0244')) break p003e0244;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0244;
			if (!CNDnoun1(117)) break p003e0244;
 		}
		if (!CNDat(9)) break p003e0244;
 		ACCwrite(1580);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PUERTA
	p003e0245:
	{
 		if (skipdoall('p003e0245')) break p003e0245;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0245;
			if (!CNDnoun1(69)) break p003e0245;
 		}
		if (!CNDat(9)) break p003e0245;
 		ACCwrite(1581);
		{}

	}

	// EX PUERTA
	p003e0246:
	{
 		if (skipdoall('p003e0246')) break p003e0246;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0246;
			if (!CNDnoun1(69)) break p003e0246;
 		}
		if (!CNDat(9)) break p003e0246;
		if (!CNDzero(79)) break p003e0246;
 		ACCwrite(1582);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PUERTA
	p003e0247:
	{
 		if (skipdoall('p003e0247')) break p003e0247;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0247;
			if (!CNDnoun1(69)) break p003e0247;
 		}
		if (!CNDat(9)) break p003e0247;
		if (!CNDnotzero(79)) break p003e0247;
 		ACCwrite(1583);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CAMPANA
	p003e0248:
	{
 		if (skipdoall('p003e0248')) break p003e0248;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0248;
			if (!CNDnoun1(121)) break p003e0248;
 		}
		if (!CNDat(9)) break p003e0248;
 		ACCwrite(1584);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX MONTANA
	p003e0249:
	{
 		if (skipdoall('p003e0249')) break p003e0249;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0249;
			if (!CNDnoun1(80)) break p003e0249;
 		}
		if (!CNDat(10)) break p003e0249;
 		ACCwrite(1585);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CAMINO
	p003e0250:
	{
 		if (skipdoall('p003e0250')) break p003e0250;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0250;
			if (!CNDnoun1(119)) break p003e0250;
 		}
		if (!CNDat(10)) break p003e0250;
 		ACCwrite(1586);
 		ACCwrite(1587);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX HOJAS
	p003e0251:
	{
 		if (skipdoall('p003e0251')) break p003e0251;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0251;
			if (!CNDnoun1(118)) break p003e0251;
 		}
		if (!CNDat(10)) break p003e0251;
 		ACCwrite(1588);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX TOCON
	p003e0252:
	{
 		if (skipdoall('p003e0252')) break p003e0252;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0252;
			if (!CNDnoun1(116)) break p003e0252;
 		}
		if (!CNDat(9)) break p003e0252;
		if (!CNDnotzero(64)) break p003e0252;
		if (!CNDnoteq(64,9)) break p003e0252;
 		ACCwrite(1589);
 		ACCwrite(1590);
 		ACClet(64,9);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX TOCON
	p003e0253:
	{
 		if (skipdoall('p003e0253')) break p003e0253;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0253;
			if (!CNDnoun1(116)) break p003e0253;
 		}
		if (!CNDat(9)) break p003e0253;
		if (!CNDeq(64,9)) break p003e0253;
 		ACCwrite(1591);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX TOCON
	p003e0254:
	{
 		if (skipdoall('p003e0254')) break p003e0254;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0254;
			if (!CNDnoun1(116)) break p003e0254;
 		}
		if (!CNDat(9)) break p003e0254;
 		ACCwrite(1592);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ARBOLES
	p003e0255:
	{
 		if (skipdoall('p003e0255')) break p003e0255;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0255;
			if (!CNDnoun1(84)) break p003e0255;
 		}
		if (!CNDat(9)) break p003e0255;
 		ACCwrite(1593);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PLANTA
	p003e0256:
	{
 		if (skipdoall('p003e0256')) break p003e0256;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0256;
			if (!CNDnoun1(28)) break p003e0256;
 		}
		if (!CNDat(12)) break p003e0256;
		if (!CNDeq(78,2)) break p003e0256;
 		ACCwrite(1594);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX INVERNADER
	p003e0257:
	{
 		if (skipdoall('p003e0257')) break p003e0257;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0257;
			if (!CNDnoun1(98)) break p003e0257;
 		}
		if (!CNDat(3)) break p003e0257;
 		ACCwrite(1595);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX INVERNADER
	p003e0258:
	{
 		if (skipdoall('p003e0258')) break p003e0258;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0258;
			if (!CNDnoun1(98)) break p003e0258;
 		}
		if (!CNDat(3)) break p003e0258;
		if (!CNDeq(78,2)) break p003e0258;
 		ACCwrite(1596);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX HELECHOS
	p003e0259:
	{
 		if (skipdoall('p003e0259')) break p003e0259;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0259;
			if (!CNDnoun1(101)) break p003e0259;
 		}
		if (!CNDat(3)) break p003e0259;
 		ACCwrite(1597);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX HORTENSIA
	p003e0260:
	{
 		if (skipdoall('p003e0260')) break p003e0260;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0260;
			if (!CNDnoun1(115)) break p003e0260;
 		}
		if (!CNDat(3)) break p003e0260;
 		ACCwrite(1598);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PLANTA
	p003e0261:
	{
 		if (skipdoall('p003e0261')) break p003e0261;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0261;
			if (!CNDnoun1(28)) break p003e0261;
 		}
		if (!CNDat(3)) break p003e0261;
		if (!CNDeq(78,1)) break p003e0261;
 		ACCwrite(1599);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PLANTA
	p003e0262:
	{
 		if (skipdoall('p003e0262')) break p003e0262;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0262;
			if (!CNDnoun1(28)) break p003e0262;
 		}
		if (!CNDat(3)) break p003e0262;
		if (!CNDeq(78,0)) break p003e0262;
 		ACCwrite(1600);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CASCADA
	p003e0263:
	{
 		if (skipdoall('p003e0263')) break p003e0263;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0263;
			if (!CNDnoun1(106)) break p003e0263;
 		}
		if (!CNDat(12)) break p003e0263;
 		ACCwrite(1601);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX AGUA
	p003e0264:
	{
 		if (skipdoall('p003e0264')) break p003e0264;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0264;
			if (!CNDnoun1(107)) break p003e0264;
 		}
		if (!CNDat(12)) break p003e0264;
 		ACCwrite(1602);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX RIACHUELO
	p003e0265:
	{
 		if (skipdoall('p003e0265')) break p003e0265;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0265;
			if (!CNDnoun1(109)) break p003e0265;
 		}
		if (!CNDat(12)) break p003e0265;
 		ACCwrite(1603);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ORILLA
	p003e0266:
	{
 		if (skipdoall('p003e0266')) break p003e0266;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0266;
			if (!CNDnoun1(110)) break p003e0266;
 		}
		if (!CNDat(12)) break p003e0266;
 		ACCwrite(1604);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CHARCA
	p003e0267:
	{
 		if (skipdoall('p003e0267')) break p003e0267;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0267;
			if (!CNDnoun1(108)) break p003e0267;
 		}
		if (!CNDat(12)) break p003e0267;
 		ACCwrite(1605);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ARBOLES
	p003e0268:
	{
 		if (skipdoall('p003e0268')) break p003e0268;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0268;
			if (!CNDnoun1(84)) break p003e0268;
 		}
		if (!CNDat(12)) break p003e0268;
 		ACCwrite(1606);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX HELECHOS
	p003e0269:
	{
 		if (skipdoall('p003e0269')) break p003e0269;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0269;
			if (!CNDnoun1(101)) break p003e0269;
 		}
		if (!CNDat(12)) break p003e0269;
 		ACCwrite(1607);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PIMIENTA
	p003e0270:
	{
 		if (skipdoall('p003e0270')) break p003e0270;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0270;
			if (!CNDnoun1(114)) break p003e0270;
 		}
		if (!CNDpresent(15)) break p003e0270;
 		ACCwrite(1608);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PIMIENTA
	p003e0271:
	{
 		if (skipdoall('p003e0271')) break p003e0271;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0271;
			if (!CNDnoun1(114)) break p003e0271;
 		}
		if (!CNDat(5)) break p003e0271;
		if (!CNDisat(15,6)) break p003e0271;
 		ACCwrite(1609);
 		ACCwrite(1610);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CORCHO
	p003e0272:
	{
 		if (skipdoall('p003e0272')) break p003e0272;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0272;
			if (!CNDnoun1(104)) break p003e0272;
 		}
		if (!CNDpresent(13)) break p003e0272;
		if (!CNDozero(13,33)) break p003e0272;
 		ACCwrite(1611);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CORCHO
	p003e0273:
	{
 		if (skipdoall('p003e0273')) break p003e0273;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0273;
			if (!CNDnoun1(104)) break p003e0273;
 		}
		if (!CNDat(5)) break p003e0273;
		if (!CNDisat(14,6)) break p003e0273;
 		ACCwrite(1612);
 		ACCmessage(18);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CORCHO
	p003e0274:
	{
 		if (skipdoall('p003e0274')) break p003e0274;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0274;
			if (!CNDnoun1(104)) break p003e0274;
 		}
		if (!CNDpresent(14)) break p003e0274;
 		ACCwrite(1613);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX LIQUIDO
	p003e0275:
	{
 		if (skipdoall('p003e0275')) break p003e0275;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0275;
			if (!CNDnoun1(105)) break p003e0275;
 		}
		if (!CNDpresent(13)) break p003e0275;
 		ACCwrite(1614);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ELEXIR
	p003e0276:
	{
 		if (skipdoall('p003e0276')) break p003e0276;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0276;
			if (!CNDnoun1(103)) break p003e0276;
 		}
		if (!CNDat(5)) break p003e0276;
		if (!CNDisat(13,6)) break p003e0276;
 		ACCwrite(1615);
 		ACCmessage(18);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ELEXIR
	p003e0277:
	{
 		if (skipdoall('p003e0277')) break p003e0277;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0277;
			if (!CNDnoun1(103)) break p003e0277;
 		}
		if (!CNDpresent(13)) break p003e0277;
 		ACCwrite(1616);
		{}

	}

	// EX ELEXIR
	p003e0278:
	{
 		if (skipdoall('p003e0278')) break p003e0278;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0278;
			if (!CNDnoun1(103)) break p003e0278;
 		}
		if (!CNDpresent(13)) break p003e0278;
		if (!CNDozero(13,33)) break p003e0278;
 		ACCwrite(1617);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ELEXIR
	p003e0279:
	{
 		if (skipdoall('p003e0279')) break p003e0279;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0279;
			if (!CNDnoun1(103)) break p003e0279;
 		}
		if (!CNDpresent(13)) break p003e0279;
		if (!CNDonotzero(13,33)) break p003e0279;
 		ACCwrite(1618);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX RUTA
	p003e0280:
	{
 		if (skipdoall('p003e0280')) break p003e0280;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0280;
			if (!CNDnoun1(94)) break p003e0280;
 		}
		if (!CNDat(8)) break p003e0280;
 		ACCwrite(1619);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX HELECHOS
	p003e0281:
	{
 		if (skipdoall('p003e0281')) break p003e0281;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0281;
			if (!CNDnoun1(101)) break p003e0281;
 		}
		if (!CNDat(8)) break p003e0281;
 		ACCwrite(1620);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX DOCTOR
	p003e0282:
	{
 		if (skipdoall('p003e0282')) break p003e0282;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0282;
			if (!CNDnoun1(27)) break p003e0282;
 		}
 		ACCwrite(1621);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX AGUJERO
	p003e0283:
	{
 		if (skipdoall('p003e0283')) break p003e0283;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0283;
			if (!CNDnoun1(100)) break p003e0283;
 		}
		if (!CNDpresent(12)) break p003e0283;
 		ACCwrite(1622);
		{}

	}

	// EX AGUJERO
	p003e0284:
	{
 		if (skipdoall('p003e0284')) break p003e0284;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0284;
			if (!CNDnoun1(100)) break p003e0284;
 		}
		if (!CNDpresent(12)) break p003e0284;
		if (!CNDozero(12,33)) break p003e0284;
 		ACCwrite(1623);
		{}

	}

	// EX AGUJERO
	p003e0285:
	{
 		if (skipdoall('p003e0285')) break p003e0285;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0285;
			if (!CNDnoun1(100)) break p003e0285;
 		}
		if (!CNDpresent(12)) break p003e0285;
		if (!CNDonotzero(12,33)) break p003e0285;
 		ACCwrite(1624);
		{}

	}

	// EX AGUJERO
	p003e0286:
	{
 		if (skipdoall('p003e0286')) break p003e0286;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0286;
			if (!CNDnoun1(100)) break p003e0286;
 		}
		if (!CNDpresent(12)) break p003e0286;
		if (!CNDozero(12,34)) break p003e0286;
 		ACCwrite(1625);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX AGUJERO
	p003e0287:
	{
 		if (skipdoall('p003e0287')) break p003e0287;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0287;
			if (!CNDnoun1(100)) break p003e0287;
 		}
		if (!CNDpresent(12)) break p003e0287;
		if (!CNDonotzero(12,34)) break p003e0287;
 		ACCwrite(1626);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX AGUJERO
	p003e0288:
	{
 		if (skipdoall('p003e0288')) break p003e0288;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0288;
			if (!CNDnoun1(100)) break p003e0288;
 		}
		if (!CNDat(5)) break p003e0288;
		if (!CNDisat(12,6)) break p003e0288;
 		ACCwrite(1627);
 		ACCmessage(18);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CANDADO
	p003e0289:
	{
 		if (skipdoall('p003e0289')) break p003e0289;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0289;
			if (!CNDnoun1(99)) break p003e0289;
 		}
		if (!CNDat(8)) break p003e0289;
		if (!CNDzero(77)) break p003e0289;
 		ACCwrite(1628);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CANDADO
	p003e0290:
	{
 		if (skipdoall('p003e0290')) break p003e0290;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0290;
			if (!CNDnoun1(99)) break p003e0290;
 		}
		if (!CNDat(8)) break p003e0290;
		if (!CNDnotzero(78)) break p003e0290;
 		ACCwrite(1629);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PUERTA
	p003e0291:
	{
 		if (skipdoall('p003e0291')) break p003e0291;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0291;
			if (!CNDnoun1(69)) break p003e0291;
 		}
		if (!CNDat(8)) break p003e0291;
		if (!CNDzero(77)) break p003e0291;
 		ACCwrite(1630);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PUERTA
	p003e0292:
	{
 		if (skipdoall('p003e0292')) break p003e0292;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0292;
			if (!CNDnoun1(69)) break p003e0292;
 		}
		if (!CNDat(8)) break p003e0292;
		if (!CNDnotzero(77)) break p003e0292;
 		ACCwrite(1631);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX INVERNADER
	p003e0293:
	{
 		if (skipdoall('p003e0293')) break p003e0293;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0293;
			if (!CNDnoun1(98)) break p003e0293;
 		}
		if (!CNDat(8)) break p003e0293;
 		ACCwrite(1632);
		{}

	}

	// EX INVERNADER
	p003e0294:
	{
 		if (skipdoall('p003e0294')) break p003e0294;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0294;
			if (!CNDnoun1(98)) break p003e0294;
 		}
		if (!CNDat(8)) break p003e0294;
		if (!CNDzero(77)) break p003e0294;
 		ACCwrite(1633);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX INVERNADER
	p003e0295:
	{
 		if (skipdoall('p003e0295')) break p003e0295;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0295;
			if (!CNDnoun1(98)) break p003e0295;
 		}
		if (!CNDat(8)) break p003e0295;
		if (!CNDnotzero(77)) break p003e0295;
 		ACCwrite(1634);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX RUTA
	p003e0296:
	{
 		if (skipdoall('p003e0296')) break p003e0296;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0296;
			if (!CNDnoun1(94)) break p003e0296;
 		}
		if (!CNDat(5)) break p003e0296;
 		ACCwrite(1635);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CRUCE
	p003e0297:
	{
 		if (skipdoall('p003e0297')) break p003e0297;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0297;
			if (!CNDnoun1(96)) break p003e0297;
 		}
		if (!CNDat(5)) break p003e0297;
 		ACCwrite(1636);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PIEDRAS
	p003e0298:
	{
 		if (skipdoall('p003e0298')) break p003e0298;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0298;
			if (!CNDnoun1(95)) break p003e0298;
 		}
		if (!CNDat(5)) break p003e0298;
 		ACCwrite(1637);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CASA
	p003e0299:
	{
 		if (skipdoall('p003e0299')) break p003e0299;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0299;
			if (!CNDnoun1(58)) break p003e0299;
 		}
		if (!CNDat(5)) break p003e0299;
 		ACCwrite(1638);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX BOSQUE
	p003e0300:
	{
 		if (skipdoall('p003e0300')) break p003e0300;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0300;
			if (!CNDnoun1(78)) break p003e0300;
 		}
		if (!CNDat(5)) break p003e0300;
 		ACCwrite(1639);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CLARO
	p003e0301:
	{
 		if (skipdoall('p003e0301')) break p003e0301;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0301;
			if (!CNDnoun1(79)) break p003e0301;
 		}
		if (!CNDat(5)) break p003e0301;
 		ACCwrite(1640);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX TELEGRAMA
	p003e0302:
	{
 		if (skipdoall('p003e0302')) break p003e0302;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0302;
			if (!CNDnoun1(93)) break p003e0302;
 		}
		if (!CNDat(5)) break p003e0302;
		if (!CNDeq(75,1)) break p003e0302;
		if (!CNDisat(11,7)) break p003e0302;
 		ACCwrite(1641);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX LLAVE
	p003e0303:
	{
 		if (skipdoall('p003e0303')) break p003e0303;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0303;
			if (!CNDnoun1(71)) break p003e0303;
 		}
		if (!CNDpresent(4)) break p003e0303;
 		ACCwrite(1642);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX LLAVE
	p003e0304:
	{
 		if (skipdoall('p003e0304')) break p003e0304;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0304;
			if (!CNDnoun1(71)) break p003e0304;
 		}
		if (!CNDat(5)) break p003e0304;
		if (!CNDisat(4,6)) break p003e0304;
 		ACCwrite(1643);
 		ACCmessage(18);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX TELEGRAMA
	p003e0305:
	{
 		if (skipdoall('p003e0305')) break p003e0305;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0305;
			if (!CNDnoun1(93)) break p003e0305;
 		}
		if (!CNDat(5)) break p003e0305;
		if (!CNDisat(11,6)) break p003e0305;
 		ACCwrite(1644);
 		ACCmessage(18);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX TELEGRAMA
	p003e0306:
	{
 		if (skipdoall('p003e0306')) break p003e0306;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0306;
			if (!CNDnoun1(93)) break p003e0306;
 		}
		if (!CNDpresent(11)) break p003e0306;
 		ACCwrite(1645);
 		ACCwrite(1646);
 		ACCwrite(1647);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CARTA
	p003e0307:
	{
 		if (skipdoall('p003e0307')) break p003e0307;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0307;
			if (!CNDnoun1(92)) break p003e0307;
 		}
		if (!CNDat(5)) break p003e0307;
		if (!CNDeq(75,1)) break p003e0307;
		if (!CNDisat(10,7)) break p003e0307;
 		ACCwrite(1648);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CARTA
	p003e0308:
	{
 		if (skipdoall('p003e0308')) break p003e0308;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0308;
			if (!CNDnoun1(92)) break p003e0308;
 		}
		if (!CNDat(5)) break p003e0308;
		if (!CNDisat(10,6)) break p003e0308;
 		ACCwrite(1649);
 		ACCmessage(18);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CARTA
	p003e0309:
	{
 		if (skipdoall('p003e0309')) break p003e0309;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0309;
			if (!CNDnoun1(92)) break p003e0309;
 		}
		if (!CNDpresent(10)) break p003e0309;
 		ACCwrite(1650);
 		ACCwrite(1651);
 		ACCwrite(1652);
 		ACCwrite(1653);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CRISTAL
	p003e0310:
	{
 		if (skipdoall('p003e0310')) break p003e0310;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0310;
			if (!CNDnoun1(91)) break p003e0310;
 		}
		if (!CNDpresent(9)) break p003e0310;
 		ACCwrite(1654);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CRISTAL
	p003e0311:
	{
 		if (skipdoall('p003e0311')) break p003e0311;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0311;
			if (!CNDnoun1(91)) break p003e0311;
 		}
		if (!CNDat(5)) break p003e0311;
		if (!CNDisat(9,6)) break p003e0311;
 		ACCwrite(1655);
 		ACCmessage(18);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CUERDA
	p003e0312:
	{
 		if (skipdoall('p003e0312')) break p003e0312;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0312;
			if (!CNDnoun1(90)) break p003e0312;
 		}
		if (!CNDat(5)) break p003e0312;
		if (!CNDeq(75,0)) break p003e0312;
 		ACCwrite(1656);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX BUZON
	p003e0313:
	{
 		if (skipdoall('p003e0313')) break p003e0313;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0313;
			if (!CNDnoun1(97)) break p003e0313;
 		}
		if (!CNDat(5)) break p003e0313;
 		ACCwrite(1657);
		{}

	}

	// EX BUZON
	p003e0314:
	{
 		if (skipdoall('p003e0314')) break p003e0314;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0314;
			if (!CNDnoun1(97)) break p003e0314;
 		}
		if (!CNDat(5)) break p003e0314;
		if (!CNDeq(75,0)) break p003e0314;
 		ACCwrite(1658);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX BUZON
	p003e0315:
	{
 		if (skipdoall('p003e0315')) break p003e0315;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0315;
			if (!CNDnoun1(97)) break p003e0315;
 		}
		if (!CNDat(5)) break p003e0315;
		if (!CNDeq(75,1)) break p003e0315;
 		ACCwrite(1659);
		{}

	}

	// EX BUZON
	p003e0316:
	{
 		if (skipdoall('p003e0316')) break p003e0316;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0316;
			if (!CNDnoun1(97)) break p003e0316;
 		}
		if (!CNDat(5)) break p003e0316;
		if (!CNDeq(75,1)) break p003e0316;
 		ACCobjat(7,73);
		{}

	}

	// EX BUZON
	p003e0317:
	{
 		if (skipdoall('p003e0317')) break p003e0317;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0317;
			if (!CNDnoun1(97)) break p003e0317;
 		}
		if (!CNDat(5)) break p003e0317;
		if (!CNDeq(75,1)) break p003e0317;
		if (!CNDzero(73)) break p003e0317;
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX BUZON
	p003e0318:
	{
 		if (skipdoall('p003e0318')) break p003e0318;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0318;
			if (!CNDnoun1(97)) break p003e0318;
 		}
		if (!CNDat(5)) break p003e0318;
		if (!CNDeq(75,1)) break p003e0318;
		if (!CNDnotzero(73)) break p003e0318;
 		ACCwrite(1660);
 		ACClistat(7);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CAJON
	p003e0319:
	{
 		if (skipdoall('p003e0319')) break p003e0319;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0319;
			if (!CNDnoun1(88)) break p003e0319;
 		}
		if (!CNDat(5)) break p003e0319;
 		ACCwrite(1661);
		{}

	}

	// EX CAJON
	p003e0320:
	{
 		if (skipdoall('p003e0320')) break p003e0320;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0320;
			if (!CNDnoun1(88)) break p003e0320;
 		}
		if (!CNDat(5)) break p003e0320;
		if (!CNDzero(70)) break p003e0320;
 		ACCwrite(1662);
		{}

	}

	// EX CAJON
	p003e0321:
	{
 		if (skipdoall('p003e0321')) break p003e0321;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0321;
			if (!CNDnoun1(88)) break p003e0321;
 		}
		if (!CNDat(5)) break p003e0321;
		if (!CNDnotzero(70)) break p003e0321;
 		ACCwrite(1663);
		{}

	}

	// EX CAJON
	p003e0322:
	{
 		if (skipdoall('p003e0322')) break p003e0322;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0322;
			if (!CNDnoun1(88)) break p003e0322;
 		}
		if (!CNDat(5)) break p003e0322;
 		ACCobjat(6,73);
		if (!CNDnotzero(73)) break p003e0322;
 		ACCwrite(1664);
 		ACClistat(6);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CAJON
	p003e0323:
	{
 		if (skipdoall('p003e0323')) break p003e0323;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0323;
			if (!CNDnoun1(88)) break p003e0323;
 		}
		if (!CNDat(5)) break p003e0323;
 		ACCobjat(6,73);
		if (!CNDzero(73)) break p003e0323;
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PIEDRA
	p003e0324:
	{
 		if (skipdoall('p003e0324')) break p003e0324;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0324;
			if (!CNDnoun1(87)) break p003e0324;
 		}
		if (!CNDpresent(8)) break p003e0324;
 		ACCwrite(1665);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PIEDRA
	p003e0325:
	{
 		if (skipdoall('p003e0325')) break p003e0325;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0325;
			if (!CNDnoun1(87)) break p003e0325;
 		}
		if (!CNDat(5)) break p003e0325;
		if (!CNDisat(8,6)) break p003e0325;
 		ACCwrite(1666);
 		ACCmessage(18);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ARENQUE
	p003e0326:
	{
 		if (skipdoall('p003e0326')) break p003e0326;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0326;
			if (!CNDnoun1(86)) break p003e0326;
 		}
		if (!CNDpresent(7)) break p003e0326;
 		ACCwrite(1667);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ARENQUE
	p003e0327:
	{
 		if (skipdoall('p003e0327')) break p003e0327;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0327;
			if (!CNDnoun1(86)) break p003e0327;
 		}
		if (!CNDat(5)) break p003e0327;
		if (!CNDisat(7,6)) break p003e0327;
 		ACCwrite(1668);
 		ACCmessage(18);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PARAGUAS
	p003e0328:
	{
 		if (skipdoall('p003e0328')) break p003e0328;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0328;
			if (!CNDnoun1(76)) break p003e0328;
 		}
		if (!CNDpresent(6)) break p003e0328;
 		ACCwrite(1669);
		{}

	}

	// EX PARAGUAS
	p003e0329:
	{
 		if (skipdoall('p003e0329')) break p003e0329;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0329;
			if (!CNDnoun1(76)) break p003e0329;
 		}
		if (!CNDpresent(6)) break p003e0329;
		if (!CNDzero(128)) break p003e0329;
 		ACCwrite(1670);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PARAGUAS
	p003e0330:
	{
 		if (skipdoall('p003e0330')) break p003e0330;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0330;
			if (!CNDnoun1(76)) break p003e0330;
 		}
		if (!CNDpresent(6)) break p003e0330;
		if (!CNDeq(128,255)) break p003e0330;
 		ACCwrite(1671);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PARAGUAS
	p003e0331:
	{
 		if (skipdoall('p003e0331')) break p003e0331;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0331;
			if (!CNDnoun1(76)) break p003e0331;
 		}
		if (!CNDat(5)) break p003e0331;
		if (!CNDisat(6,6)) break p003e0331;
 		ACCwrite(1672);
		{}

	}

	// EX PARAGUAS
	p003e0332:
	{
 		if (skipdoall('p003e0332')) break p003e0332;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0332;
			if (!CNDnoun1(76)) break p003e0332;
 		}
		if (!CNDat(5)) break p003e0332;
		if (!CNDisat(6,6)) break p003e0332;
		if (!CNDozero(6,4)) break p003e0332;
 		ACCwrite(1673);
 		ACCmessage(18);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PARAGUAS
	p003e0333:
	{
 		if (skipdoall('p003e0333')) break p003e0333;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0333;
			if (!CNDnoun1(76)) break p003e0333;
 		}
		if (!CNDat(5)) break p003e0333;
		if (!CNDisat(6,6)) break p003e0333;
		if (!CNDonotzero(6,4)) break p003e0333;
 		ACCwrite(1674);
 		ACCmessage(18);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ARBOL
	p003e0334:
	{
 		if (skipdoall('p003e0334')) break p003e0334;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0334;
			if (!CNDnoun1(59)) break p003e0334;
 		}
		if (!CNDat(4)) break p003e0334;
 		ACCwrite(1675);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ARBOL
	p003e0335:
	{
 		if (skipdoall('p003e0335')) break p003e0335;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0335;
			if (!CNDnoun1(59)) break p003e0335;
 		}
		if (!CNDat(5)) break p003e0335;
 		ACCwrite(1676);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ARBOLES
	p003e0336:
	{
 		if (skipdoall('p003e0336')) break p003e0336;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0336;
			if (!CNDnoun1(84)) break p003e0336;
 		}
		if (!CNDatlt(14)) break p003e0336;
 		ACCwrite(1677);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CASA
	p003e0337:
	{
 		if (skipdoall('p003e0337')) break p003e0337;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0337;
			if (!CNDnoun1(58)) break p003e0337;
 		}
		if (!CNDat(4)) break p003e0337;
 		ACCwrite(1678);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PUERTA
	p003e0338:
	{
 		if (skipdoall('p003e0338')) break p003e0338;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0338;
			if (!CNDnoun1(69)) break p003e0338;
 		}
		if (!CNDat(4)) break p003e0338;
 		ACCwrite(1679);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX TECHO
	p003e0339:
	{
 		if (skipdoall('p003e0339')) break p003e0339;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0339;
			if (!CNDnoun1(82)) break p003e0339;
 		}
		if (!CNDat(4)) break p003e0339;
 		ACCwrite(1680);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX BOSQUE
	p003e0340:
	{
 		if (skipdoall('p003e0340')) break p003e0340;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0340;
			if (!CNDnoun1(78)) break p003e0340;
 		}
		if (!CNDat(4)) break p003e0340;
 		ACCwrite(1681);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CLARO
	p003e0341:
	{
 		if (skipdoall('p003e0341')) break p003e0341;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0341;
			if (!CNDnoun1(79)) break p003e0341;
 		}
		if (!CNDat(4)) break p003e0341;
 		ACCwrite(1682);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX COLUMNA
	p003e0342:
	{
 		if (skipdoall('p003e0342')) break p003e0342;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0342;
			if (!CNDnoun1(83)) break p003e0342;
 		}
		if (!CNDat(4)) break p003e0342;
 		ACCwrite(1683);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX MONTANA
	p003e0343:
	{
 		if (skipdoall('p003e0343')) break p003e0343;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0343;
			if (!CNDnoun1(80)) break p003e0343;
 		}
		if (!CNDat(4)) break p003e0343;
 		ACCwrite(1684);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX BANCO
	p003e0344:
	{
 		if (skipdoall('p003e0344')) break p003e0344;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0344;
			if (!CNDnoun1(75)) break p003e0344;
 		}
		if (!CNDat(4)) break p003e0344;
		if (!CNDzero(68)) break p003e0344;
 		ACCwrite(1685);
 		ACCwrite(1686);
 		ACCnewline();
 		ACCplus(68,1);
 		ACCplace(6,4);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX BANCO
	p003e0345:
	{
 		if (skipdoall('p003e0345')) break p003e0345;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0345;
			if (!CNDnoun1(75)) break p003e0345;
 		}
		if (!CNDat(4)) break p003e0345;
		if (!CNDnotzero(68)) break p003e0345;
 		ACCwrite(1687);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PLATAFORMA
	p003e0346:
	{
 		if (skipdoall('p003e0346')) break p003e0346;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0346;
			if (!CNDnoun1(77)) break p003e0346;
 		}
		if (!CNDat(4)) break p003e0346;
 		ACCwrite(1688);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX VALLE
	p003e0347:
	{
 		if (skipdoall('p003e0347')) break p003e0347;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0347;
			if (!CNDnoun1(81)) break p003e0347;
 		}
		if (!CNDat(5)) break p003e0347;
 		ACCwrite(1689);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX VALLE
	p003e0348:
	{
 		if (skipdoall('p003e0348')) break p003e0348;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0348;
			if (!CNDnoun1(81)) break p003e0348;
 		}
		if (!CNDat(4)) break p003e0348;
 		ACCwrite(1690);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ANTORCHA
	p003e0349:
	{
 		if (skipdoall('p003e0349')) break p003e0349;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0349;
			if (!CNDnoun1(50)) break p003e0349;
 		}
		if (!CNDozero(1,0)) break p003e0349;
 		ACCwrite(1691);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ANTORCHA
	p003e0350:
	{
 		if (skipdoall('p003e0350')) break p003e0350;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0350;
			if (!CNDnoun1(50)) break p003e0350;
 		}
		if (!CNDonotzero(1,0)) break p003e0350;
 		ACCwrite(1692);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CAJA
	p003e0351:
	{
 		if (skipdoall('p003e0351')) break p003e0351;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0351;
			if (!CNDnoun1(89)) break p003e0351;
 		}
		if (!CNDpresent(5)) break p003e0351;
		if (!CNDnotzero(67)) break p003e0351;
		if (!CNDnoteq(67,1)) break p003e0351;
 		ACCwrite(1693);
 		ACCnewline();
 		ACCwrite(1694);
 		ACCprint(67);
 		ACCwrite(1695);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CAJA
	p003e0352:
	{
 		if (skipdoall('p003e0352')) break p003e0352;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0352;
			if (!CNDnoun1(89)) break p003e0352;
 		}
		if (!CNDpresent(5)) break p003e0352;
		if (!CNDeq(67,1)) break p003e0352;
 		ACCwrite(1696);
 		ACCnewline();
 		ACCwrite(1697);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CAJA
	p003e0353:
	{
 		if (skipdoall('p003e0353')) break p003e0353;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0353;
			if (!CNDnoun1(89)) break p003e0353;
 		}
		if (!CNDpresent(5)) break p003e0353;
		if (!CNDzero(67)) break p003e0353;
 		ACCwrite(1698);
 		ACCwrite(1699);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CAJA
	p003e0354:
	{
 		if (skipdoall('p003e0354')) break p003e0354;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0354;
			if (!CNDnoun1(89)) break p003e0354;
 		}
		if (!CNDat(5)) break p003e0354;
		if (!CNDisat(5,6)) break p003e0354;
		if (!CNDzero(67)) break p003e0354;
 		ACCwrite(1700);
 		ACCwrite(1701);
 		ACCmessage(18);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CAJA
	p003e0355:
	{
 		if (skipdoall('p003e0355')) break p003e0355;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0355;
			if (!CNDnoun1(89)) break p003e0355;
 		}
		if (!CNDat(5)) break p003e0355;
		if (!CNDisat(5,6)) break p003e0355;
		if (!CNDnotzero(67)) break p003e0355;
		if (!CNDnoteq(67,1)) break p003e0355;
 		ACCwrite(1702);
 		ACCnewline();
 		ACCwrite(1703);
 		ACCprint(67);
 		ACCwrite(1704);
 		ACCmessage(18);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CAJA
	p003e0356:
	{
 		if (skipdoall('p003e0356')) break p003e0356;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0356;
			if (!CNDnoun1(89)) break p003e0356;
 		}
		if (!CNDat(5)) break p003e0356;
		if (!CNDisat(5,6)) break p003e0356;
		if (!CNDeq(67,1)) break p003e0356;
 		ACCwrite(1705);
 		ACCnewline();
 		ACCwrite(1706);
 		ACCmessage(18);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CAJA
	p003e0357:
	{
 		if (skipdoall('p003e0357')) break p003e0357;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0357;
			if (!CNDnoun1(89)) break p003e0357;
 		}
		if (!CNDat(5)) break p003e0357;
		if (!CNDisat(5,6)) break p003e0357;
		if (!CNDzero(67)) break p003e0357;
 		ACCwrite(1707);
 		ACCwrite(1708);
 		ACCmessage(18);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CAJA
	p003e0358:
	{
 		if (skipdoall('p003e0358')) break p003e0358;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0358;
			if (!CNDnoun1(89)) break p003e0358;
 		}
		if (!CNDat(5)) break p003e0358;
		if (!CNDisat(5,6)) break p003e0358;
		if (!CNDzero(67)) break p003e0358;
 		ACCwrite(1709);
 		ACCwrite(1710);
 		ACCmessage(18);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX TERMITA
	p003e0359:
	{
 		if (skipdoall('p003e0359')) break p003e0359;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0359;
			if (!CNDnoun1(29)) break p003e0359;
 		}
		if (!CNDnotzero(64)) break p003e0359;
		if (!CNDnoteq(64,9)) break p003e0359;
 		ACCwrite(1711);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX BAUL
	p003e0360:
	{
 		if (skipdoall('p003e0360')) break p003e0360;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0360;
			if (!CNDnoun1(72)) break p003e0360;
 		}
		if (!CNDat(1)) break p003e0360;
 		ACCwrite(1712);
 		ACCnewline();
 		ACCwrite(1713);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ROPA
	p003e0361:
	{
 		if (skipdoall('p003e0361')) break p003e0361;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0361;
			if (!CNDnoun1(60)) break p003e0361;
 		}
		if (!CNDat(1)) break p003e0361;
		if (!CNDzero(62)) break p003e0361;
 		ACCwrite(1714);
 		ACCwrite(1715);
 		ACCnewline();
 		ACCcreate(4);
 		ACClet(62,1);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ROPA
	p003e0362:
	{
 		if (skipdoall('p003e0362')) break p003e0362;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0362;
			if (!CNDnoun1(60)) break p003e0362;
 		}
		if (!CNDat(1)) break p003e0362;
		if (!CNDnotzero(62)) break p003e0362;
 		ACCwrite(1716);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX MAGICOS
	p003e0363:
	{
 		if (skipdoall('p003e0363')) break p003e0363;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0363;
			if (!CNDnoun1(61)) break p003e0363;
 		}
		if (!CNDat(1)) break p003e0363;
 		ACCwrite(1717);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PUERTA
	p003e0364:
	{
 		if (skipdoall('p003e0364')) break p003e0364;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0364;
			if (!CNDnoun1(69)) break p003e0364;
 		}
		if (!CNDat(1)) break p003e0364;
 		ACCwrite(1718);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX VENTANA
	p003e0365:
	{
 		if (skipdoall('p003e0365')) break p003e0365;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0365;
			if (!CNDnoun1(70)) break p003e0365;
 		}
		if (!CNDat(1)) break p003e0365;
 		ACCwrite(1719);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX PATINES
	p003e0366:
	{
 		if (skipdoall('p003e0366')) break p003e0366;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0366;
			if (!CNDnoun1(68)) break p003e0366;
 		}
		if (!CNDat(1)) break p003e0366;
 		ACCwrite(1720);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ALFOMBRA
	p003e0367:
	{
 		if (skipdoall('p003e0367')) break p003e0367;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0367;
			if (!CNDnoun1(150)) break p003e0367;
 		}
		if (!CNDat(1)) break p003e0367;
 		ACCwrite(1721);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CHIMENEA
	p003e0368:
	{
 		if (skipdoall('p003e0368')) break p003e0368;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0368;
			if (!CNDnoun1(66)) break p003e0368;
 		}
		if (!CNDat(1)) break p003e0368;
		if (!CNDzero(66)) break p003e0368;
 		ACCwrite(1722);
 		ACCnewline();
 		ACCcreate(5);
 		ACClet(66,5);
 		ACClet(67,5);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CHIMENEA
	p003e0369:
	{
 		if (skipdoall('p003e0369')) break p003e0369;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0369;
			if (!CNDnoun1(66)) break p003e0369;
 		}
		if (!CNDnotzero(66)) break p003e0369;
		if (!CNDat(1)) break p003e0369;
 		ACCwrite(1723);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX RELOJ
	p003e0370:
	{
 		if (skipdoall('p003e0370')) break p003e0370;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0370;
			if (!CNDnoun1(65)) break p003e0370;
 		}
		if (!CNDat(1)) break p003e0370;
 		ACCwrite(1724);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ENSERES
	p003e0371:
	{
 		if (skipdoall('p003e0371')) break p003e0371;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0371;
			if (!CNDnoun1(63)) break p003e0371;
 		}
		if (!CNDat(1)) break p003e0371;
		if (!CNDnotzero(69)) break p003e0371;
 		ACCwrite(1725);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ENSERES
	p003e0372:
	{
 		if (skipdoall('p003e0372')) break p003e0372;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0372;
			if (!CNDnoun1(63)) break p003e0372;
 		}
		if (!CNDat(1)) break p003e0372;
		if (!CNDzero(69)) break p003e0372;
 		ACCwrite(1726);
 		ACCnewline();
 		ACCwrite(1727);
 		ACCplace(7,1);
 		ACCplace(17,1);
 		ACCplus(69,1);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX COCINA
	p003e0373:
	{
 		if (skipdoall('p003e0373')) break p003e0373;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0373;
			if (!CNDnoun1(64)) break p003e0373;
 		}
		if (!CNDat(1)) break p003e0373;
		if (!CNDzero(69)) break p003e0373;
 		ACCwrite(1728);
 		ACCnewline();
 		ACCwrite(1729);
 		ACCplace(7,1);
 		ACCplace(17,1);
 		ACCplus(69,1);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX COCINA
	p003e0374:
	{
 		if (skipdoall('p003e0374')) break p003e0374;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0374;
			if (!CNDnoun1(64)) break p003e0374;
 		}
		if (!CNDat(1)) break p003e0374;
		if (!CNDnotzero(69)) break p003e0374;
 		ACCwrite(1730);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX MARTILLO
	p003e0375:
	{
 		if (skipdoall('p003e0375')) break p003e0375;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0375;
			if (!CNDnoun1(57)) break p003e0375;
 		}
		if (!CNDpresent(3)) break p003e0375;
		if (!CNDzero(64)) break p003e0375;
 		ACCwrite(1731);
 		ACCwrite(1732);
 		ACCnewline();
 		ACClet(64,1);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX MARTILLO
	p003e0376:
	{
 		if (skipdoall('p003e0376')) break p003e0376;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0376;
			if (!CNDnoun1(57)) break p003e0376;
 		}
		if (!CNDpresent(3)) break p003e0376;
 		ACCwrite(1733);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX MARTILLO
	p003e0377:
	{
 		if (skipdoall('p003e0377')) break p003e0377;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0377;
			if (!CNDnoun1(57)) break p003e0377;
 		}
		if (!CNDat(5)) break p003e0377;
		if (!CNDisat(3,6)) break p003e0377;
		if (!CNDzero(64)) break p003e0377;
 		ACCwrite(1734);
 		ACCmes(18);
 		ACCwrite(1735);
 		ACCnewline();
 		ACClet(64,1);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX MARTILLO
	p003e0378:
	{
 		if (skipdoall('p003e0378')) break p003e0378;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0378;
			if (!CNDnoun1(57)) break p003e0378;
 		}
		if (!CNDat(5)) break p003e0378;
		if (!CNDisat(3,6)) break p003e0378;
 		ACCwrite(1736);
 		ACCmessage(18);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CASA
	p003e0379:
	{
 		if (skipdoall('p003e0379')) break p003e0379;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0379;
			if (!CNDnoun1(58)) break p003e0379;
 		}
		if (!CNDat(1)) break p003e0379;
 		ACCdesc();
		break pro003_restart;
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX ARBOL
	p003e0380:
	{
 		if (skipdoall('p003e0380')) break p003e0380;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0380;
			if (!CNDnoun1(59)) break p003e0380;
 		}
		if (!CNDat(1)) break p003e0380;
 		ACCdesc();
		break pro003_restart;
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX FOTO
	p003e0381:
	{
 		if (skipdoall('p003e0381')) break p003e0381;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0381;
			if (!CNDnoun1(55)) break p003e0381;
 		}
		if (!CNDat(1)) break p003e0381;
 		ACCmessage(3);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX LIBROS
	p003e0382:
	{
 		if (skipdoall('p003e0382')) break p003e0382;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0382;
			if (!CNDnoun1(54)) break p003e0382;
 		}
		if (!CNDat(1)) break p003e0382;
		if (!CNDeq(60,0)) break p003e0382;
 		ACCmes(5);
 		ACCmessage(6);
 		ACCcreate(1);
 		ACClet(60,1);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX LIBROS
	p003e0383:
	{
 		if (skipdoall('p003e0383')) break p003e0383;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0383;
			if (!CNDnoun1(54)) break p003e0383;
 		}
		if (!CNDat(1)) break p003e0383;
		if (!CNDnotzero(60)) break p003e0383;
 		ACCmessage(5);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX LIBRO
	p003e0384:
	{
 		if (skipdoall('p003e0384')) break p003e0384;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0384;
			if (!CNDnoun1(53)) break p003e0384;
 		}
		if (!CNDpresent(1)) break p003e0384;
 		ACCmessage(7);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX LIBRO
	p003e0385:
	{
 		if (skipdoall('p003e0385')) break p003e0385;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0385;
			if (!CNDnoun1(53)) break p003e0385;
 		}
		if (!CNDat(5)) break p003e0385;
		if (!CNDisat(1,6)) break p003e0385;
 		ACCmessage(7);
 		ACCmessage(18);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CAMA
	p003e0386:
	{
 		if (skipdoall('p003e0386')) break p003e0386;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0386;
			if (!CNDnoun1(56)) break p003e0386;
 		}
		if (!CNDat(1)) break p003e0386;
 		ACCwrite(1737);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX CAPUCHA
	p003e0387:
	{
 		if (skipdoall('p003e0387')) break p003e0387;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0387;
			if (!CNDnoun1(52)) break p003e0387;
 		}
		if (!CNDpresent(2)) break p003e0387;
 		ACCwrite(1738);
 		ACCnewline();
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX _
	p003e0388:
	{
 		if (skipdoall('p003e0388')) break p003e0388;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0388;
 		}
		if (!CNDeq(34,255)) break p003e0388;
 		ACCwrite(1739);
 		ACCdone();
		break pro003_restart;
		{}

	}

	// EX _
	p003e0389:
	{
 		if (skipdoall('p003e0389')) break p003e0389;
 		if (in_response)
		{
			if (!CNDverb(30)) break p003e0389;
 		}
 		ACCwrite(1740);
 		ACCdone();
		break pro003_restart;
		{}

	}


}
}

function pro004()
{
process_restart=true;
pro004_restart: while(process_restart)
{
	process_restart=false;
	// X _
	p004e0000:
	{
 		if (skipdoall('p004e0000')) break p004e0000;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0000;
 		}
		if (!CNDat(2)) break p004e0000;
 		ACCwrite(1741);
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0001:
	{
 		if (skipdoall('p004e0001')) break p004e0001;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0001;
 		}
		if (!CNDat(31)) break p004e0001;
 		ACCwrite(1742);
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0002:
	{
 		if (skipdoall('p004e0002')) break p004e0002;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0002;
 		}
		if (!CNDat(30)) break p004e0002;
 		ACCwrite(1743);
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0003:
	{
 		if (skipdoall('p004e0003')) break p004e0003;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0003;
 		}
		if (!CNDat(42)) break p004e0003;
 		ACCwrite(1744);
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0004:
	{
 		if (skipdoall('p004e0004')) break p004e0004;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0004;
 		}
		if (!CNDat(33)) break p004e0004;
 		ACCwrite(1745);
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0005:
	{
 		if (skipdoall('p004e0005')) break p004e0005;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0005;
 		}
		if (!CNDat(32)) break p004e0005;
 		ACCwrite(1746);
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0006:
	{
 		if (skipdoall('p004e0006')) break p004e0006;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0006;
 		}
		if (!CNDat(37)) break p004e0006;
 		ACCwrite(1747);
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0007:
	{
 		if (skipdoall('p004e0007')) break p004e0007;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0007;
 		}
		if (!CNDat(40)) break p004e0007;
 		ACCwrite(1748);
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0008:
	{
 		if (skipdoall('p004e0008')) break p004e0008;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0008;
 		}
		if (!CNDat(41)) break p004e0008;
 		ACCwrite(1749);
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0009:
	{
 		if (skipdoall('p004e0009')) break p004e0009;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0009;
 		}
		if (!CNDat(38)) break p004e0009;
 		ACCwrite(1750);
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0010:
	{
 		if (skipdoall('p004e0010')) break p004e0010;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0010;
 		}
		if (!CNDat(36)) break p004e0010;
 		ACCwrite(1751);
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0011:
	{
 		if (skipdoall('p004e0011')) break p004e0011;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0011;
 		}
		if (!CNDat(39)) break p004e0011;
 		ACCwrite(1752);
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0012:
	{
 		if (skipdoall('p004e0012')) break p004e0012;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0012;
 		}
		if (!CNDat(35)) break p004e0012;
 		ACCwrite(1753);
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0013:
	{
 		if (skipdoall('p004e0013')) break p004e0013;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0013;
 		}
		if (!CNDat(34)) break p004e0013;
 		ACCwrite(1754);
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0014:
	{
 		if (skipdoall('p004e0014')) break p004e0014;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0014;
 		}
		if (!CNDat(29)) break p004e0014;
 		ACCwrite(1755);
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0015:
	{
 		if (skipdoall('p004e0015')) break p004e0015;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0015;
 		}
		if (!CNDat(28)) break p004e0015;
		if (!CNDzero(93)) break p004e0015;
 		ACCwrite(1756);
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0016:
	{
 		if (skipdoall('p004e0016')) break p004e0016;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0016;
 		}
		if (!CNDat(28)) break p004e0016;
 		ACCwrite(1757);
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0017:
	{
 		if (skipdoall('p004e0017')) break p004e0017;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0017;
 		}
		if (!CNDat(27)) break p004e0017;
 		ACCwrite(1758);
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0018:
	{
 		if (skipdoall('p004e0018')) break p004e0018;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0018;
 		}
		if (!CNDat(26)) break p004e0018;
 		ACCwrite(1759);
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0019:
	{
 		if (skipdoall('p004e0019')) break p004e0019;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0019;
 		}
		if (!CNDat(25)) break p004e0019;
 		ACCwrite(1760);
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0020:
	{
 		if (skipdoall('p004e0020')) break p004e0020;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0020;
 		}
		if (!CNDat(24)) break p004e0020;
 		ACCwrite(1761);
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0021:
	{
 		if (skipdoall('p004e0021')) break p004e0021;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0021;
 		}
		if (!CNDat(23)) break p004e0021;
 		ACCwrite(1762);
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0022:
	{
 		if (skipdoall('p004e0022')) break p004e0022;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0022;
 		}
		if (!CNDat(11)) break p004e0022;
 		ACCwrite(1763);
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0023:
	{
 		if (skipdoall('p004e0023')) break p004e0023;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0023;
 		}
		if (!CNDat(13)) break p004e0023;
 		ACCwrite(1764);
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0024:
	{
 		if (skipdoall('p004e0024')) break p004e0024;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0024;
 		}
		if (!CNDat(9)) break p004e0024;
 		ACCwrite(1765);
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0025:
	{
 		if (skipdoall('p004e0025')) break p004e0025;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0025;
 		}
		if (!CNDat(10)) break p004e0025;
 		ACCwrite(1766);
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0026:
	{
 		if (skipdoall('p004e0026')) break p004e0026;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0026;
 		}
		if (!CNDat(3)) break p004e0026;
 		ACCwrite(1767);
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0027:
	{
 		if (skipdoall('p004e0027')) break p004e0027;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0027;
 		}
		if (!CNDat(12)) break p004e0027;
 		ACCwrite(1768);
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0028:
	{
 		if (skipdoall('p004e0028')) break p004e0028;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0028;
 		}
		if (!CNDat(8)) break p004e0028;
 		ACCwrite(1769);
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0029:
	{
 		if (skipdoall('p004e0029')) break p004e0029;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0029;
 		}
		if (!CNDat(14)) break p004e0029;
 		ACCwrite(1770);
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0030:
	{
 		if (skipdoall('p004e0030')) break p004e0030;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0030;
 		}
		if (!CNDat(23)) break p004e0030;
 		ACCwrite(1771);
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0031:
	{
 		if (skipdoall('p004e0031')) break p004e0031;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0031;
 		}
		if (!CNDat(18)) break p004e0031;
 		ACCwrite(1772);
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0032:
	{
 		if (skipdoall('p004e0032')) break p004e0032;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0032;
 		}
		if (!CNDat(15)) break p004e0032;
 		ACCwrite(1773);
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0033:
	{
 		if (skipdoall('p004e0033')) break p004e0033;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0033;
 		}
		if (!CNDat(16)) break p004e0033;
 		ACCwrite(1774);
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0034:
	{
 		if (skipdoall('p004e0034')) break p004e0034;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0034;
 		}
		if (!CNDat(17)) break p004e0034;
 		ACCwrite(1775);
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0035:
	{
 		if (skipdoall('p004e0035')) break p004e0035;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0035;
 		}
		if (!CNDat(19)) break p004e0035;
 		ACCwrite(1776);
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0036:
	{
 		if (skipdoall('p004e0036')) break p004e0036;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0036;
 		}
		if (!CNDat(20)) break p004e0036;
 		ACCwrite(1777);
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0037:
	{
 		if (skipdoall('p004e0037')) break p004e0037;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0037;
 		}
		if (!CNDat(21)) break p004e0037;
 		ACCwrite(1778);
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0038:
	{
 		if (skipdoall('p004e0038')) break p004e0038;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0038;
 		}
		if (!CNDat(1)) break p004e0038;
 		ACCwrite(1779);
 		ACCnewline();
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0039:
	{
 		if (skipdoall('p004e0039')) break p004e0039;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0039;
 		}
		if (!CNDat(4)) break p004e0039;
 		ACCwrite(1780);
 		ACCnewline();
 		ACCdone();
		break pro004_restart;
		{}

	}

	// X _
	p004e0040:
	{
 		if (skipdoall('p004e0040')) break p004e0040;
 		if (in_response)
		{
			if (!CNDverb(54)) break p004e0040;
 		}
		if (!CNDat(5)) break p004e0040;
 		ACCwrite(1781);
 		ACCnewline();
 		ACCdone();
		break pro004_restart;
		{}

	}


}
}

function pro005()
{
process_restart=true;
pro005_restart: while(process_restart)
{
	process_restart=false;
	// _ _
	p005e0000:
	{
 		if (skipdoall('p005e0000')) break p005e0000;
 		ACCplus(88,1);
		{}

	}

	// _ _
	p005e0001:
	{
 		if (skipdoall('p005e0001')) break p005e0001;
		if (!CNDnotzero(73)) break p005e0001;
		if (!CNDzero(90)) break p005e0001;
		if (!CNDnotsame(88,73)) break p005e0001;
		if (!CNDchance(20)) break p005e0001;
 		ACCplace(getFlag(51),22);
 		ACCwrite(1782);
 		ACClet(90,1);
		{}

	}

	// _ _
	p005e0002:
	{
 		if (skipdoall('p005e0002')) break p005e0002;
		if (!CNDzero(90)) break p005e0002;
		if (!CNDnotsame(88,73)) break p005e0002;
		{}

	}

	// _ _
	p005e0003:
	{
 		if (skipdoall('p005e0003')) break p005e0003;
		if (!CNDsame(88,73)) break p005e0003;
		if (!CNDnotzero(90)) break p005e0003;
 		ACCwrite(1783);
 		ACCplace(0,254);
 		ACCclear(89);
 		ACCclear(88);
 		ACCdone();
		break pro005_restart;
		{}

	}

	// _ _
	p005e0004:
	{
 		if (skipdoall('p005e0004')) break p005e0004;
		if (!CNDsame(88,73)) break p005e0004;
		if (!CNDzero(90)) break p005e0004;
 		ACCwrite(1784);
 		ACCplace(0,254);
 		ACCclear(89);
 		ACCclear(88);
 		ACCdone();
		break pro005_restart;
		{}

	}


}
}

function pro006()
{
process_restart=true;
pro006_restart: while(process_restart)
{
	process_restart=false;
	// _ _
	p006e0000:
	{
 		if (skipdoall('p006e0000')) break p006e0000;
		if (!CNDgt(99,7)) break p006e0000;
 		ACCwrite(1785);
 		ACCwrite(1786);
 		ACCplace(22,254);
 		ACClet(97,1);
 		ACCclear(99);
 		ACCclear(98);
 		ACCclear(100);
 		ACCclear(101);
 		ACCdone();
		break pro006_restart;
		{}

	}

	// ESCRIBE OPEN
	p006e0001:
	{
 		if (skipdoall('p006e0001')) break p006e0001;
 		if (in_response)
		{
			if (!CNDverb(89)) break p006e0001;
			if (!CNDnoun1(163)) break p006e0001;
 		}
		if (!CNDnoun2(162)) break p006e0001;
		if (!CNDeq(98,0)) break p006e0001;
		if (!CNDzero(100)) break p006e0001;
 		ACCmessage(19);
 		ACCwrite(1787);
 		ACCset(100);
 		ACCdone();
		break pro006_restart;
		{}

	}

	// ESCRIBE OPEN
	p006e0002:
	{
 		if (skipdoall('p006e0002')) break p006e0002;
 		if (in_response)
		{
			if (!CNDverb(89)) break p006e0002;
			if (!CNDnoun1(163)) break p006e0002;
 		}
		if (!CNDnoun2(162)) break p006e0002;
		if (!CNDeq(98,3)) break p006e0002;
 		ACCmessage(19);
 		ACCwrite(1788);
 		ACCdone();
		break pro006_restart;
		{}

	}

	// ESCRIBE _
	p006e0003:
	{
 		if (skipdoall('p006e0003')) break p006e0003;
 		if (in_response)
		{
			if (!CNDverb(89)) break p006e0003;
 		}
		if (!CNDnoun2(162)) break p006e0003;
		if (!CNDeq(98,3)) break p006e0003;
 		ACCmessage(19);
 		ACCwrite(1789);
 		ACCdone();
		break pro006_restart;
		{}

	}

	// ESCRIBE CLOSE
	p006e0004:
	{
 		if (skipdoall('p006e0004')) break p006e0004;
 		if (in_response)
		{
			if (!CNDverb(89)) break p006e0004;
			if (!CNDnoun1(164)) break p006e0004;
 		}
		if (!CNDnoun2(162)) break p006e0004;
		if (!CNDeq(98,0)) break p006e0004;
		if (!CNDnotzero(100)) break p006e0004;
 		ACCmessage(19);
 		ACCwrite(1790);
 		ACCclear(100);
 		ACCdone();
		break pro006_restart;
		{}

	}

	// ESCRIBE TAKE
	p006e0005:
	{
 		if (skipdoall('p006e0005')) break p006e0005;
 		if (in_response)
		{
			if (!CNDverb(89)) break p006e0005;
			if (!CNDnoun1(165)) break p006e0005;
 		}
		if (!CNDnoun2(166)) break p006e0005;
		if (!CNDeq(98,0)) break p006e0005;
		if (!CNDzero(101)) break p006e0005;
 		ACCmessage(19);
 		ACCwrite(1791);
 		ACCset(101);
 		ACCdone();
		break pro006_restart;
		{}

	}

	// ESCRIBE _
	p006e0006:
	{
 		if (skipdoall('p006e0006')) break p006e0006;
 		if (in_response)
		{
			if (!CNDverb(89)) break p006e0006;
 		}
		if (!CNDnoun2(166)) break p006e0006;
 		ACCmessage(19);
		if (!CNDnotzero(101)) break p006e0006;
 		ACCmessage(19);
 		ACCwrite(1792);
 		ACCwrite(1793);
 		ACCwrite(1794);
 		ACCdone();
		break pro006_restart;
		{}

	}

	// ESCRIBE E
	p006e0007:
	{
 		if (skipdoall('p006e0007')) break p006e0007;
 		if (in_response)
		{
			if (!CNDverb(89)) break p006e0007;
			if (!CNDnoun1(4)) break p006e0007;
 		}
		if (!CNDeq(98,0)) break p006e0007;
		if (!CNDzero(100)) break p006e0007;
 		ACCmessage(19);
 		ACCwrite(1795);
 		ACCdone();
		break pro006_restart;
		{}

	}

	// ESCRIBE E
	p006e0008:
	{
 		if (skipdoall('p006e0008')) break p006e0008;
 		if (in_response)
		{
			if (!CNDverb(89)) break p006e0008;
			if (!CNDnoun1(4)) break p006e0008;
 		}
		if (!CNDeq(98,0)) break p006e0008;
		if (!CNDnotzero(100)) break p006e0008;
 		ACClet(98,1);
 		ACCwrite(1796);
 		ACCwrite(1797);
 		ACCwrite(1798);
 		ACCwrite(1799);
 		ACCwrite(1800);
 		ACCdone();
		break pro006_restart;
		{}

	}

	// ESCRIBE NE
	p006e0009:
	{
 		if (skipdoall('p006e0009')) break p006e0009;
 		if (in_response)
		{
			if (!CNDverb(89)) break p006e0009;
			if (!CNDnoun1(6)) break p006e0009;
 		}
		if (!CNDeq(98,1)) break p006e0009;
 		ACClet(98,3);
 		ACCmessage(19);
 		ACCwrite(1801);
 		ACCwrite(1802);
 		ACCwrite(1803);
 		ACCwrite(1804);
 		ACCwrite(1805);
 		ACCdone();
		break pro006_restart;
		{}

	}

	// ESCRIBE N
	p006e0010:
	{
 		if (skipdoall('p006e0010')) break p006e0010;
 		if (in_response)
		{
			if (!CNDverb(89)) break p006e0010;
			if (!CNDnoun1(2)) break p006e0010;
 		}
		if (!CNDeq(98,2)) break p006e0010;
 		ACClet(98,3);
 		ACCmessage(19);
 		ACCwrite(1806);
 		ACCwrite(1807);
 		ACCwrite(1808);
 		ACCwrite(1809);
 		ACCwrite(1810);
 		ACCdone();
		break pro006_restart;
		{}

	}

	// ESCRIBE O
	p006e0011:
	{
 		if (skipdoall('p006e0011')) break p006e0011;
 		if (in_response)
		{
			if (!CNDverb(89)) break p006e0011;
			if (!CNDnoun1(5)) break p006e0011;
 		}
		if (!CNDeq(98,1)) break p006e0011;
 		ACClet(98,0);
 		ACCmessage(19);
 		ACCwrite(1811);
 		ACCwrite(1812);
 		ACCwrite(1813);
 		ACCwrite(1814);
 		ACCwrite(1815);
 		ACCdone();
		break pro006_restart;
		{}

	}

	// ESCRIBE E
	p006e0012:
	{
 		if (skipdoall('p006e0012')) break p006e0012;
 		if (in_response)
		{
			if (!CNDverb(89)) break p006e0012;
			if (!CNDnoun1(4)) break p006e0012;
 		}
		if (!CNDeq(98,1)) break p006e0012;
 		ACClet(98,2);
 		ACCwrite(1816);
 		ACCwrite(1817);
 		ACCwrite(1818);
 		ACCwrite(1819);
 		ACCwrite(1820);
 		ACCwrite(1821);
 		ACCwrite(1822);
 		ACCdone();
		break pro006_restart;
		{}

	}

	// ESCRIBE S
	p006e0013:
	{
 		if (skipdoall('p006e0013')) break p006e0013;
 		if (in_response)
		{
			if (!CNDverb(89)) break p006e0013;
			if (!CNDnoun1(3)) break p006e0013;
 		}
		if (!CNDeq(98,3)) break p006e0013;
 		ACClet(98,2);
 		ACCmessage(19);
 		ACCwrite(1823);
 		ACCwrite(1824);
 		ACCwrite(1825);
 		ACCwrite(1826);
 		ACCwrite(1827);
 		ACCwrite(1828);
 		ACCdone();
		break pro006_restart;
		{}

	}

	// ESCRIBE N
	p006e0014:
	{
 		if (skipdoall('p006e0014')) break p006e0014;
 		if (in_response)
		{
			if (!CNDverb(89)) break p006e0014;
			if (!CNDnoun1(2)) break p006e0014;
 		}
		if (!CNDeq(98,1)) break p006e0014;
 		ACClet(98,2);
 		ACCwrite(1829);
 		ACCwrite(1830);
 		ACCwrite(1831);
 		ACCwrite(1832);
 		ACCwrite(1833);
 		ACCwrite(1834);
 		ACCwrite(1835);
 		ACCdone();
		break pro006_restart;
		{}

	}

	// ESCRIBE SO
	p006e0015:
	{
 		if (skipdoall('p006e0015')) break p006e0015;
 		if (in_response)
		{
			if (!CNDverb(89)) break p006e0015;
			if (!CNDnoun1(9)) break p006e0015;
 		}
		if (!CNDeq(98,2)) break p006e0015;
 		ACClet(98,1);
 		ACCmessage(19);
 		ACCwrite(1836);
 		ACCwrite(1837);
 		ACCwrite(1838);
 		ACCwrite(1839);
 		ACCdone();
		break pro006_restart;
		{}

	}

	// ESCRIBE SE
	p006e0016:
	{
 		if (skipdoall('p006e0016')) break p006e0016;
 		if (in_response)
		{
			if (!CNDverb(89)) break p006e0016;
			if (!CNDnoun1(8)) break p006e0016;
 		}
		if (!CNDeq(98,2)) break p006e0016;
 		ACClet(98,1);
 		ACCmessage(19);
 		ACCwrite(1840);
 		ACCwrite(1841);
 		ACCwrite(1842);
 		ACCwrite(1843);
 		ACCdone();
		break pro006_restart;
		{}

	}

	// ESCRIBE _
	p006e0017:
	{
 		if (skipdoall('p006e0017')) break p006e0017;
 		if (in_response)
		{
			if (!CNDverb(89)) break p006e0017;
 		}
		if (!CNDnoun2(167)) break p006e0017;
		if (!CNDeq(98,2)) break p006e0017;
 		ACCmessage(19);
 		ACCwrite(1844);
 		ACCwrite(1845);
 		ACCwrite(1846);
 		ACCwrite(1847);
 		ACCwrite(1848);
 		ACCanykey();
 		function anykey00215() 
		{
 		ACClet(98,0);
 		ACCwrite(1849);
 		ACCwrite(1850);
 		ACCwrite(1851);
 		ACCwrite(1852);
 		ACCwrite(1853);
 		ACCdone();
		return;
		}
 		waitKey(anykey00215);
		done_flag=true;
		break pro006_restart;
		{}

	}

	// ESCRIBE THORIN
	p006e0018:
	{
 		if (skipdoall('p006e0018')) break p006e0018;
 		if (in_response)
		{
			if (!CNDverb(89)) break p006e0018;
			if (!CNDnoun1(161)) break p006e0018;
 		}
 		ACCmessage(19);
 		ACCwrite(1854);
 		ACCdone();
		break pro006_restart;
		{}

	}

	// ESCRIBE CHEST
	p006e0019:
	{
 		if (skipdoall('p006e0019')) break p006e0019;
 		if (in_response)
		{
			if (!CNDverb(89)) break p006e0019;
			if (!CNDnoun1(168)) break p006e0019;
 		}
		if (!CNDeq(98,0)) break p006e0019;
 		ACCmessage(19);
 		ACCwrite(1855);
 		ACCdone();
		break pro006_restart;
		{}

	}

	// ESCRIBE WAIT
	p006e0020:
	{
 		if (skipdoall('p006e0020')) break p006e0020;
 		if (in_response)
		{
			if (!CNDverb(89)) break p006e0020;
			if (!CNDnoun1(169)) break p006e0020;
 		}
		if (!CNDeq(98,2)) break p006e0020;
 		ACCmessage(19);
 		ACCwrite(1856);
 		ACCwrite(1857);
 		ACCwrite(1858);
 		ACCwrite(1859);
 		ACCwrite(1860);
 		ACCanykey();
 		function anykey00216() 
		{
 		ACClet(98,0);
 		ACCwrite(1861);
 		ACCwrite(1862);
 		ACCwrite(1863);
 		ACCwrite(1864);
 		ACCwrite(1865);
 		ACCdone();
		return;
		}
 		waitKey(anykey00216);
		done_flag=true;
		break pro006_restart;
		{}

	}

	// ESCRIBE WAIT
	p006e0021:
	{
 		if (skipdoall('p006e0021')) break p006e0021;
 		if (in_response)
		{
			if (!CNDverb(89)) break p006e0021;
			if (!CNDnoun1(169)) break p006e0021;
 		}
 		ACCmessage(19);
 		ACCwrite(1866);
 		ACCdone();
		break pro006_restart;
		{}

	}

	// ESCRIBE O
	p006e0022:
	{
 		if (skipdoall('p006e0022')) break p006e0022;
 		if (in_response)
		{
			if (!CNDverb(89)) break p006e0022;
			if (!CNDnoun1(5)) break p006e0022;
 		}
 		ACCmessage(19);
 		ACCwrite(1867);
 		ACCdone();
		break pro006_restart;
		{}

	}

	// ESCRIBE S
	p006e0023:
	{
 		if (skipdoall('p006e0023')) break p006e0023;
 		if (in_response)
		{
			if (!CNDverb(89)) break p006e0023;
			if (!CNDnoun1(3)) break p006e0023;
 		}
 		ACCmessage(19);
 		ACCwrite(1868);
 		ACCdone();
		break pro006_restart;
		{}

	}

	// ESCRIBE N
	p006e0024:
	{
 		if (skipdoall('p006e0024')) break p006e0024;
 		if (in_response)
		{
			if (!CNDverb(89)) break p006e0024;
			if (!CNDnoun1(2)) break p006e0024;
 		}
 		ACCmessage(19);
 		ACCwrite(1869);
 		ACCdone();
		break pro006_restart;
		{}

	}

	// ESCRIBE E
	p006e0025:
	{
 		if (skipdoall('p006e0025')) break p006e0025;
 		if (in_response)
		{
			if (!CNDverb(89)) break p006e0025;
			if (!CNDnoun1(4)) break p006e0025;
 		}
 		ACCmessage(19);
 		ACCwrite(1870);
 		ACCdone();
		break pro006_restart;
		{}

	}

	// ESCRIBE SO
	p006e0026:
	{
 		if (skipdoall('p006e0026')) break p006e0026;
 		if (in_response)
		{
			if (!CNDverb(89)) break p006e0026;
			if (!CNDnoun1(9)) break p006e0026;
 		}
 		ACCmessage(19);
 		ACCwrite(1871);
 		ACCdone();
		break pro006_restart;
		{}

	}

	// ESCRIBE SE
	p006e0027:
	{
 		if (skipdoall('p006e0027')) break p006e0027;
 		if (in_response)
		{
			if (!CNDverb(89)) break p006e0027;
			if (!CNDnoun1(8)) break p006e0027;
 		}
 		ACCmessage(19);
 		ACCwrite(1872);
 		ACCdone();
		break pro006_restart;
		{}

	}

	// ESCRIBE NO
	p006e0028:
	{
 		if (skipdoall('p006e0028')) break p006e0028;
 		if (in_response)
		{
			if (!CNDverb(89)) break p006e0028;
			if (!CNDnoun1(7)) break p006e0028;
 		}
 		ACCmessage(19);
 		ACCwrite(1873);
 		ACCdone();
		break pro006_restart;
		{}

	}

	// ESCRIBE NE
	p006e0029:
	{
 		if (skipdoall('p006e0029')) break p006e0029;
 		if (in_response)
		{
			if (!CNDverb(89)) break p006e0029;
			if (!CNDnoun1(6)) break p006e0029;
 		}
 		ACCmessage(19);
 		ACCwrite(1874);
 		ACCdone();
		break pro006_restart;
		{}

	}

	// _ _
	p006e0030:
	{
 		if (skipdoall('p006e0030')) break p006e0030;
		if (!CNDparse()) break p006e0030;
 		ACCwrite(1875);
 		ACCwrite(1876);
 		ACCwrite(1877);
 		ACCdone();
		break pro006_restart;
		{}

	}


}
}

function pro007()
{
process_restart=true;
pro007_restart: while(process_restart)
{
	process_restart=false;
	// _ _
	p007e0000:
	{
 		if (skipdoall('p007e0000')) break p007e0000;
 		ACCplus(104,1);
		{}

	}

	// _ _
	p007e0001:
	{
 		if (skipdoall('p007e0001')) break p007e0001;
 		ACCwhato();
 		ACCplace(getFlag(51),31);
		{}

	}

	// _ _
	p007e0002:
	{
 		if (skipdoall('p007e0002')) break p007e0002;
		if (!CNDsame(104,73)) break p007e0002;
 		ACCwrite(1878);
 		ACCplace(0,254);
 		ACCoclear(1,0);
 		ACCclear(108);
 		ACCanykey();
 		function anykey00217() 
		{
 		ACCgoto(34);
 		ACCdesc();
		return;
		}
 		waitKey(anykey00217);
		done_flag=true;
		break pro007_restart;
		{}

	}

	// _ _
	p007e0003:
	{
 		if (skipdoall('p007e0003')) break p007e0003;
 		ACCdone();
		break pro007_restart;
		{}

	}


}
}

last_process = 7;
// This file is (C) Carlos Sanchez 2014, released under the MIT license

// This function is called first by the start() function that runs when the game starts for the first time
var h_init = function()
{
}


// This function is called last by the start() function that runs when the game starts for the first time
var h_post =  function()
{
}

// This function is called when the engine tries to write any text
var h_writeText =  function (text)
{
	return text;
}

//This function is called every time the user types any order
var h_playerOrder = function(player_order)
{
	return player_order;
}

// This function is called every time a location is described, just after the location text is written
var h_description_init =  function ()
{
}

// This function is called every time a location is described, just after the process 1 is executed
var h_description_post = function()
{
}


// this function is called when the savegame object has been created, in order to be able to add more custom properties
var h_saveGame = function(savegame_object)
{
	return savegame_object;
}


// this function is called after the restore game function has restored the standard information in savegame, in order to restore any additional data included in a patched (by h_saveGame) savegame.
var h_restoreGame = function(savegame_object)
{
}

// this funcion is called before writing a message about player order beeing impossible to understand
var h_invalidOrder = function(player_order)
{
}

// this function is called when a sequence tag is found but does not exist in ngPAWS, giving a last chance for any hook library to provide a response or raise error message
// tagparams receives the params inside the tag as an array  {XXXX|nn|mm|yy} => ['XXXX', 'nn', 'mm', 'yy']
var h_sequencetag = function (tagparams)
{
	return '[[[' + STR_INVALID_TAG_SEQUENCE_BADTAG + ': ' + tagparams[0] + ']]]';
}

// this function is called from certain points in the response or process tables via the HOOK condact. Depending on the string received it can do something or not.
// it's designed to allow direct javascript code to take control in the start database just installing a plugin library (avoiding the wirter need to enter code to activate the library)
var h_code = function(str)
{
	return false;
}


// this function is called from the keydown evente handler used by block and other functions to emulate a pause or waiting for a keypress. It is designed to allow plugin condacts or
// libraries to attend those key presses and react accordingly. 
var h_keydown = function (event)
{
}// This file is (C) Carlos Sanchez 2014, and is relaased under the MIT license
 
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////// CONDACTS ///////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function ACCdesc()
{
	describe_location_flag = true;
	ACCbreak(); // Cancel doall loop
}


function ACCdone()
{
	done_flag = true;
}

function CNDat(locno)
{
  return (loc_here()==locno);
}

function CNDnotat(locno)
{
	 return (loc_here()!=locno);
}


function CNDatgt(locno)
{
	 return (loc_here()>locno);
}


function CNDatlt(locno)
{
	 return (loc_here()<locno);
}

function CNDpresent(objno)
{
	var loc = getObjectLocation(objno);
	if (loc == loc_here()) return true;
	if (loc == LOCATION_WORN) return true;
	if (loc == LOCATION_CARRIED) return true;
	if ( (!bittest(getFlag(FLAG_PARSER_SETTINGS),7)) && (objectIsContainer(loc) || objectIsSupporter(loc))  &&  (loc<=last_object_number)  && (CNDpresent(loc)) )  // Extended context and object in another object that is present
	{
		if (objectIsSupporter(loc)) return true;  // On supporter
		if ( objectIsContainer(loc) && objectIsAttr(loc, ATTR_OPENABLE) && objectIsAttr(loc, ATTR_OPEN)) return true; // In a openable & open container
		if ( objectIsContainer(loc) && (!objectIsAttr(loc, ATTR_OPENABLE)) ) return true; // In a not openable container
	}
	return false;
}

function CNDabsent(objno)
{
	return !CNDpresent(objno);
}

function CNDworn(objno)
{
	return (getObjectLocation(objno) == LOCATION_WORN);
}

function CNDnotworn(objno)
{
	return !CNDworn(objno);
}

function CNDcarried(objno)
{
	return (getObjectLocation(objno) == LOCATION_CARRIED);	
}

function CNDnotcarr(objno)
{
	return !CNDcarried(objno);
}


function CNDchance(percent)
{
	 val = Math.floor((Math.random()*101));
	 return (val<=percent);
}

function CNDzero(flagno)
{
	return (getFlag(flagno) == 0);
}

function CNDnotzero(flagno)
{
	 return !CNDzero(flagno)
}


function CNDeq(flagno, value)
{
	return (getFlag(flagno) == value);
}

function CNDnoteq(flagno,value)
{
	return !CNDeq(flagno, value);
}

function CNDgt(flagno, value)
{
	return (getFlag(flagno) > value);
}

function CNDlt(flagno, value)
{
	return (getFlag(flagno) < value);
}


function CNDadject1(wordno)
{
	return (getFlag(FLAG_ADJECT1) == wordno);
}

function CNDadverb(wordno)
{
	return (getFlag(FLAG_ADVERB) == wordno);
}


function CNDtimeout()
{
	 return bittest(getFlag(FLAG_TIMEOUT_SETTINGS),7);
}


function CNDisat(objno, locno)
{
	return (getObjectLocation(objno) == locno);

}


function CNDisnotat(objno, locno)
{
	return !CNDisat(objno, locno);
}



function CNDprep(wordno)
{
	return (getFlag(FLAG_PREP) == wordno);
}




function CNDnoun2(wordno)
{
	return (getFlag(FLAG_NOUN2) == wordno);
}

function CNDadject2(wordno)
{
	return (getFlag(FLAG_ADJECT2) == wordno);
}

function CNDsame(flagno1,flagno2)
{
	return (getFlag(flagno1) == getFlag(flagno2));
}


function CNDnotsame(flagno1,flagno2)
{
	return (getFlag(flagno1) != getFlag(flagno2));
}

function ACCinven()
{
	var count = 0;
	writeSysMessage(SYSMESS_YOUARECARRYING);
	ACCnewline();
	var listnpcs_with_objects = !bittest(getFlag(FLAG_PARSER_SETTINGS),3);
	var i;
	for (i=0;i<num_objects;i++)
	{
		if ((getObjectLocation(i)) == LOCATION_CARRIED)
		{
			
			if ((listnpcs_with_objects) || (!objectIsNPC(i)))
			{
				writeObject(i);
				if ((objectIsAttr(i,ATTR_SUPPORTER))  || (  (objectIsAttr(i,ATTR_TRANSPARENT))  && (objectIsAttr(i,ATTR_CONTAINER))))  ACClistat(i, i);
				ACCnewline();
				count++;
			}
		}
		if (getObjectLocation(i) == LOCATION_WORN)
		{
			if (listnpcs_with_objects || (!objectIsNPC(i)))
			{
				writeObject(i);
				writeSysMessage(SYSMESS_WORN);
				count++;
				ACCnewline();
			}
		}
	}
	if (!count) 
	{
		 writeSysMessage(SYSMESS_CARRYING_NOTHING);
		 ACCnewline();
	}

	if (!listnpcs_with_objects)
	{
		var numNPC = getNPCCountAt(LOCATION_CARRIED);
		if (numNPC)	ACClistnpc(LOCATION_CARRIED);
	}
	done_flag = true;
}

function desc()
{
	describe_location_flag = true;
}


function CNDquit()
{
	if (!confirm(sysmessages[SYSMESS_AREYOUSURE])) ACCdone(); else 
	{
		if (confirm(sysmessages[SYSMESS_PLAYAGAIN])) restart();
		else 
			{
				disableInterrupt();
				$('body').hide('slow');
				sfxstopall();
			}
	}
}


function ACCend()
{
		if (confirm(sysmessages[SYSMESS_PLAYAGAIN])) location.reload();
		else $('body').hide('slow');
}


function done()
{
	done_flag = true;
}

function ACCok()
{
	writeSysMessage(SYSMESS_OK);
	done_flag = true;
}



function ACCramsave()
{
	savegame_object = getSaveGameObject();
	ramsave_value = savegame_object;
	ACCok();
}

function ACCramload()
{
	savegame_object = ramsave_value;
	if (!savegame_object) {writeText (STR_RAMLOAD_ERROR); done_flag=true; return}
	restoreSaveGameObject(savegame_object);
	ACCdesc();
}

function ACCsave()
{
	var savegame_object = getSaveGameObject();	
	savegame =   JSON.stringify(savegame_object);
	filename = prompt(STR_SAVE_STORAGE,'').toUpperCase();; 
	localStorage.setItem('ngpaws_' + filename.toUpperCase(), savegame);
	ACCok();
}

 
function ACCload() 	
{
	var json_str;
	filename = prompt(STR_LOAD_STORAGE,'').toUpperCase();;
	json_str = localStorage.getItem('ngpaws_' + filename.toUpperCase());
	if (json_str)
	{
		savegame_object = JSON.parse(json_str.trim());
		restoreSaveGameObject(savegame_object);
	}
	else
	{
		writeSysMessage(SYSMESS_FILENOTFOUND);
	}
	ACCdesc();
	focusInput();
}



function ACCturns()
{
	var turns = getFlag(FLAG_TURNS_HIGH) * 256 +  getFlag(FLAG_TURNS_LOW);
	writeSysMessage(SYSMESS_TURNS_START);
	writeText(turns + '');
	writeSysMessage(SYSMESS_TURNS_CONTINUE);
	if (turns > 1) writeSysMessage(SYSMESS_TURNS_PLURAL);
	writeSysMessage(SYSMESS_TURNS_END);
}

function ACCscore()
{
	var score = getFlag(FLAG_SCORE);
	writeSysMessage(SYSMESS_SCORE_START);
	writeTex(score + '');
	writeSysMessage(SYSMESS_SCORE_END);
}


function ACCcls()
{
	clearScreen();
}

function dropall()
{
	// Done in two different loops cause PAW did it like that, just a question of retro compatibility
	var i;
	for (i=0;i<num_objects;i++)	if (getObjectLocation(i) == LOCATION_CARRIED)setObjectLocation(i, getFlag(FLAG_LOCATION));
	for (i=0;i<num_objects;i++)	if (getObjectLocation(i) == LOCATION_WORN)setObjectLocation(i, getFlag(FLAG_LOCATION));
}


function ACCautog()
{
	objno = findMatchingObject(loc_here());
	if (objno != EMPTY_OBJECT) { ACCget(objno); return; };
	objno =findMatchingObject(LOCATION_CARRIED);
	if (objno != EMPTY_OBJECT) { ACCget(objno); return; };
	objno =findMatchingObject(LOCATION_WORN);
	if (objno != EMPTY_OBJECT) { ACCget(objno); return; };
	if (!bittest(getFlag(FLAG_PARSER_SETTINGS),7))  // Extended context for objects
	for (var i=0; i<num_objects;i++) // Try to find it in present containers/supporters
	{
		if (CNDpresent(i) && (isAccesibleContainer(i) || objectIsAttr(i, ATTR_SUPPORTER)) )  // If there is another object present that is an accesible container or a supporter
		{
			objno =findMatchingObject(i);
			if (objno != EMPTY_OBJECT) { ACCget(objno); return; };
		}
	}
	writeSysMessage(SYSMESS_CANTSEETHAT);
	ACCnewtext();
	ACCdone();
}


function ACCautod()
{
	objno =findMatchingObject(LOCATION_CARRIED);
	if (objno != EMPTY_OBJECT) { ACCdrop(objno); return; };
	objno =findMatchingObject(LOCATION_WORN);
	if (objno != EMPTY_OBJECT) { ACCdrop(objno); return; };  
	objno =findMatchingObject(loc_here());
	if (objno != EMPTY_OBJECT) { ACCdrop(objno); return; };
	writeSysMessage(SYSMESS_YOUDONTHAVETHAT);
	ACCnewtext();
	ACCdone();
}


function ACCautow()
{
	objno =findMatchingObject(LOCATION_CARRIED);
	if (objno != EMPTY_OBJECT) { ACCwear(objno); return; };
	objno =findMatchingObject(LOCATION_WORN);
	if (objno != EMPTY_OBJECT) { ACCwear(objno); return; };
	objno =findMatchingObject(loc_here());
	if (objno != EMPTY_OBJECT) { ACCwear(objno); return; };
	writeSysMessage(SYSMESS_YOUDONTHAVETHAT);
	ACCnewtext();
	ACCdone();
}


function ACCautor()
{
	objno =findMatchingObject(LOCATION_WORN);
	if (objno != EMPTY_OBJECT) { ACCremove(objno); return; };
	objno =findMatchingObject(LOCATION_CARRIED);
	if (objno != EMPTY_OBJECT) { ACCremove(objno); return; };
	objno =findMatchingObject(loc_here());
	if (objno != EMPTY_OBJECT) { ACCremove(objno); return; };
	writeSysMessage(SYSMESS_YOURENOTWEARINGTHAT);
	ACCnewtext();
	ACCdone();
}



function ACCpause(value)
{
 if (value == 0) value = 256;
 value = Math.floor(value /50 * 1000);	
 var date = new Date();
 var curDate = null;
 do { curDate = new Date(); } 
 while(curDate-date < value);
} 

function ACCgoto(locno)
{
 	setFlag(FLAG_LOCATION,locno);
}

function ACCmessage(mesno)
{
	writeMessage(mesno);
	ACCnewline();
}


function ACCremove(objno)
{
	success = false; 
	setFlag(FLAG_REFERRED_OBJECT, objno);
	setReferredObject(objno);
	locno = getObjectLocation(objno);
	switch (locno)
	{
		case LOCATION_CARRIED:  
		case loc_here():
			writeSysMessage(SYSMESS_YOUARENOTWEARINGOBJECT);
			ACCnewtext();
			ACCdone();
			return;
			break;

		case LOCATION_WORN:
			if (getFlag(FLAG_OBJECTS_CARRIED_COUNT) >= getFlag(FLAG_MAXOBJECTS_CARRIED))
			{
				writeSysMessage(SYSMESS_CANTREMOVE_TOOMANYOBJECTS);
				ACCnewtext();
				ACCdone();
				return;
			}
			setObjectLocation(objno, LOCATION_CARRIED);
			writeSysMessage(SYSMESS_YOUREMOVEOBJECT);
			success = true;
			break;

		default: 
			writeSysMessage(SYSMESS_YOUARENOTWEARINGTHAT);
			ACCnewtext();
			ACCdone();
			return;
			break;
	}
}


function trytoGet(objno)  // auxiliaty function for ACCget
{
	if (getFlag(FLAG_OBJECTS_CARRIED_COUNT) >= getFlag(FLAG_MAXOBJECTS_CARRIED))
	{
		writeSysMessage(SYSMESS_CANTCARRYANYMORE);
		ACCnewtext();
		ACCdone();
		doall_flag = false;
		return;
	}
	weight = getLocationObjectsWeight(objno);
	weight += getObjectWeight(objno);
	weight +=  getLocationObjectsWeight(LOCATION_CARRIED);
	weight +=  getLocationObjectsWeight(LOCATION_WORN);
	if (weight > getFlag(FLAG_MAXWEIGHT_CARRIED))
	{
		writeSysMessage(SYSMESS_WEIGHSTOOMUCH);
		ACCnewtext();
		ACCdone();
		return;
	}
	setObjectLocation(objno, LOCATION_CARRIED);
	writeSysMessage(SYSMESS_YOUTAKEOBJECT);
	success = true;
}


 function ACCget(objno)
 {
 	success = false; 
	setFlag(FLAG_REFERRED_OBJECT, objno);
	setReferredObject(objno);
	locno = getObjectLocation(objno);
	switch (locno)
	{
		case LOCATION_CARRIED:  
		case LOCATION_WORN:  
			writeSysMessage(SYSMESS_YOUALREADYHAVEOBJECT);
			ACCnewtext();
			ACCdone();
			return;
			break;

		case loc_here():
			trytoGet(objno);
			break;

		default: 
			if  ((locno<=last_object_number) && (CNDpresent(locno)))    // If it's not here, carried or worn but it present, that means that bit 7 of flag 12 is cleared, thus you can get objects from present containers/supporters
			{
				trytoGet(objno);
			}
			else
			{
				writeSysMessage(SYSMESS_CANTSEETHAT);
				ACCnewtext();
				ACCdone();
				return;
				break;
		    }
	}
 }

function ACCdrop(objno)
{
	success = false; 
	setFlag(FLAG_REFERRED_OBJECT, objno);
	setReferredObject(objno);
	locno = getObjectLocation(objno);
	switch (locno)
	{
		case LOCATION_WORN:  
			writeSysMessage(SYSMESS_YOUAREALREADYWEARINGTHAT);
			ACCnewtext();
			ACCdone();
			return;
			break;

		case loc_here():  
			writeSysMessage(SYSMESS_YOUDONTHAVEOBJECT);
			ACCnewtext();
			ACCdone();
			return;
			break;


		case LOCATION_CARRIED:  
			setObjectLocation(objno, loc_here());
			writeSysMessage(SYSMESS_YOUDROPOBJECT);
			success = true;
			break;

		default: 
			writeSysMessage(SYSMESS_YOUDONTHAVETHAT);
			ACCnewtext();
			ACCdone();
			return;
			break;
	}
}

function ACCwear(objno)
{
	success = false; 
	setFlag(FLAG_REFERRED_OBJECT, objno);
	setReferredObject(objno);
	locno = getObjectLocation(objno);
	switch (locno)
	{
		case LOCATION_WORN:  
			writeSysMessage(SYSMESS_YOUAREALREADYWAERINGOBJECT);
			ACCnewtext();
			ACCdone();
			return;
			break;

		case loc_here():  
			writeSysMessage(SYSMESS_YOUDONTHAVEOBJECT);
			ACCnewtext();
			ACCdone();
			return;
			break;


		case LOCATION_CARRIED:  
			if (!objectIsWearable(objno))
			{
				writeSysMessage(SYSMESS_YOUCANTWEAROBJECT);
				ACCnewtext();
				ACCdone();
				return;
			}
			setObjectLocation(objno, LOCATION_WORN);
			writeSysMessage(SYSMESS_YOUWEAROBJECT);
			success = true;
			break;

		default: 
			writeSysMessage(SYSMESS_YOUDONTHAVETHAT);
			ACCnewtext();
			ACCdone();
			return;
			break;
	}
}



function ACCdestroy(objno)
{
	setObjectLocation(objno, LOCATION_NONCREATED);
}


function ACCcreate(objno)
{
	setObjectLocation(objno, loc_here());
}


function ACCswap(objno1,objno2)
{
	var locno1 = getObjectLocation (objno1);
	var locno2 = getObjectLocation (objno2);
	ACCplace (objno1,locno2);
	ACCplace (objno2,locno1);
	setReferredObject(objno2);
}


function ACCplace(objno, locno)
{
	setObjectLocation(objno, locno);
}

function ACCset(flagno)
{
	setFlag(flagno, SET_VALUE);
}

function ACCclear(flagno)
{
	setFlag(flagno,0);
}

function ACCplus(flagno,value)
{
	newval = getFlag(flagno) + value;
	setFlag(flagno, newval);
}

function ACCminus(flagno,value)
{
    newval = getFlag(flagno) - value;
    if (newval < 0) newval = 0;
	setFlag(flagno, newval);
}

function ACClet(flagno,value)
{
	setFlag(flagno,value);
}

function ACCnewline()
{
	writeText(STR_NEWLINE);
}

function ACCprint(flagno)
{
	writeText(getFlag(flagno) +'');
}

function ACCsysmess(sysno)
{
	writeSysMessage(sysno);
}

function ACCcopyof(objno,flagno)
{
	setFlag(flagno, getObjectLocation(objno))
}

function ACCcopyoo(objno1, objno2)
{
	setObjectLocation(objno2,getObjectLocation(objno1));
	setReferredObject(objno2);
}

function ACCcopyfo(flagno,objno)
{
	setObjectLocation(objno, getFlag(flagno));
}

function ACCcopyff(flagno1, flagno2)
{
	setFlag(flagno2, getFlag(flagno1));
}

function ACCadd(flagno1, flagno2)
{
	newval = getFlag(flagno1) + getFlag(flagno2);
	setFlag(flagno2, newval);
}

function ACCsub(flagno1,flagno2)
{
	newval = getFlag(flagno2) - getFlag(flagno1);
	if (newval < 0) newval = 0;
	setFlag(flagno2, newval);
}


function CNDparse()
{
	return (!getLogicSentence());
}


function ACClistat(locno, container_objno)   // objno is a container/suppoter number, used to list contents of objects
{
  var listingContainer = false;
  if (arguments.length > 1) listingContainer = true;
  var objscount =  getObjectCountAt(locno);
  var concealed_objcount = getObjectCountAtWithAttr(locno, ATTR_CONCEALED);
  var scenery_objcount = getObjectCountAtWithAttr(locno, ATTR_SCENERY);
  objscount = objscount - concealed_objcount - scenery_objcount;
  if (!listingContainer) setFlag(FLAG_OBJECT_LIST_FORMAT, bitclear(getFlag(FLAG_OBJECT_LIST_FORMAT),7)); 
  if (!objscount) return;
  var continouslisting = bittest(getFlag(FLAG_OBJECT_LIST_FORMAT),6);
  if (listingContainer) 
  	{
  		writeText(' (');
  		if (objectIsAttr(container_objno, ATTR_SUPPORTER)) writeSysMessage(SYSMESS_OVER_YOUCANSEE); else if (objectIsAttr(container_objno, ATTR_CONTAINER)) writeSysMessage(SYSMESS_INSIDE_YOUCANSEE);
  		continouslisting = true;  // listing contents of container always continuous
  	}
  
  if (!listingContainer)
  {
    setFlag(FLAG_OBJECT_LIST_FORMAT, bitset(getFlag(FLAG_OBJECT_LIST_FORMAT),7)); 
    if (!continouslisting) ACCnewline();
  }
  var progresscount = 0;
  for (var i=0;i<num_objects;i++)
  {
  	if (getObjectLocation(i) == locno)
  		if  ( ((!objectIsNPC(i)) || (!bittest(getFlag(FLAG_PARSER_SETTINGS),3)))  && (!objectIsAttr(i,ATTR_CONCEALED)) && (!objectIsAttr(i,ATTR_SCENERY))   ) // if not an NPC or parser setting say NPCs are considered objects, and object is not concealed nor scenery
  		  { 
  		     writeText(getObjectText(i)); 
  		     if ((objectIsAttr(i,ATTR_SUPPORTER))  || (  (objectIsAttr(i,ATTR_TRANSPARENT))  && (objectIsAttr(i,ATTR_CONTAINER))))  ACClistat(i, i);
  		     progresscount++
  		     if (continouslisting)
  		     {
		  			if (progresscount <= objscount - 2) writeSysMessage(SYSMESS_LISTSEPARATOR);
  					if (progresscount == objscount - 1) writeSysMessage(SYSMESS_LISTLASTSEPARATOR);
  					if (!listingContainer) if (progresscount == objscount ) writeSysMessage(SYSMESS_LISTEND);
  			 } else ACCnewline();
  		  }; 
  }
  if (arguments.length > 1) writeText(')');
}


function ACClistnpc(locno)
{
  var npccount =  getNPCCountAt(locno);
  setFlag(FLAG_OBJECT_LIST_FORMAT, bitclear(getFlag(FLAG_OBJECT_LIST_FORMAT),5)); 
  if (!npccount) return;
  setFlag(FLAG_OBJECT_LIST_FORMAT, bitset(getFlag(FLAG_OBJECT_LIST_FORMAT),5)); 
  continouslisting = bittest(getFlag(FLAG_OBJECT_LIST_FORMAT),6);
  writeSysMessage(SYSMESS_NPCLISTSTART);
  if (!continouslisting) ACCnewline();
  if (npccount==1)  writeSysMessage(SYSMESS_NPCLISTCONTINUE); else writeSysMessage(SYSMESS_NPCLISTCONTINUE_PLURAL);
  var progresscount = 0;
  var i;
  for (i=0;i<num_objects;i++)
  {
  	if (getObjectLocation(i) == locno)
  		if ( (objectIsNPC(i)) && (!objectIsAttr(i,ATTR_CONCEALED)) ) // only NPCs not concealed
  		  { 
  		     writeText(getObjectText(i)); 
  		     progresscount++
  		     if (continouslisting)
  		     {
		  	 	if (progresscount <= npccount - 2) writeSysMessage(SYSMESS_LISTSEPARATOR);
  			 	if (progresscount == npccount - 1) writeSysMessage(SYSMESS_LISTLASTSEPARATOR);
  			 	if (progresscount == npccount ) writeSysMessage(SYSMESS_LISTEND);
  			 } else ACCnewline();
  		  }; 
  }
}


function ACClistobj()
{
  locno = loc_here();
  var objscount =  getObjectCountAt(locno);
  var concealed_objcount = getObjectCountAtWithAttr(locno, ATTR_CONCEALED);
  var scenery_objcount = getObjectCountAtWithAttr(locno, ATTR_SCENERY);
  objscount = objscount - concealed_objcount - scenery_objcount;
  if (objscount)
  {
	  writeSysMessage(SYSMESS_YOUCANSEE);
      ACClistat(loc_here());
  }
}

function ACCprocess(procno)
{
	if (procno > last_process) 
	{
		writeText(STR_WRONG_PROCESS);
		ACCnewtext();
		ACCdone();
	}
	callProcess(procno);
}

function ACCmes(mesno)
{
	writeMessage(mesno);
}

function ACCmode(mode)
{
	setFlag(FLAG_MODE, mode);
}

function ACCtime(length, settings)
{
	setFlag(FLAG_TIMEOUT_LENGTH, length);
	setFlag(FLAG_TIMEOUT_SETTINGS, settings);
}

function ACCdoall(locno)
{
	doall_flag = true;
	if (locno == LOCATION_HERE) locno = loc_here();
	// Each object will be considered for doall loop if is at locno and it's not the object specified by the NOUN2/ADJECT2 pair and it's not a NPC (or setting to consider NPCs as objects is set)
	setFlag(FLAG_DOALL_LOC, locno);
	var doall_obj;
	doall_loop:
	for (doall_obj=0;(doall_obj<num_objects) && (doall_flag);doall_obj++)  
	{
		if (getObjectLocation(doall_obj) == locno)
			if ((!objectIsNPC(doall_obj)) || (!bittest(getFlag(FLAG_PARSER_SETTINGS),3))) 
 			 if (!objectIsAttr(doall_obj, ATTR_CONCEALED)) 
 			  if (!objectIsAttr(doall_obj, ATTR_SCENERY)) 
				if (!( (objectsNoun[doall_obj]==getFlag(FLAG_NOUN2))  &&    ((objectsAdjective[doall_obj]==getFlag(FLAG_ADJECT2)) || (objectsAdjective[doall_obj]==EMPTY_WORD)) ) ) // implements "TAKE ALL EXCEPT BIG SWORD"
				{
					setFlag(FLAG_NOUN1, objectsNoun[doall_obj]);
					setFlag(FLAG_ADJECT1, objectsAdjective[doall_obj]);
					setReferredObject(doall_obj);
					callProcess(process_in_doall);
					if (describe_location_flag) 
						{
							doall_flag = false;
							entry_for_doall = '';
							break doall_loop;
						}
				}
	}
	doall_flag = false;
	entry_for_doall = '';
	if (describe_location_flag) descriptionLoop();
}

function ACCprompt(value)  // deprecated
{
	setFlag(FLAG_PROMPT, value);
}


function ACCweigh(objno, flagno)
{
	weight = getObjectWeight(objno);
	setFlag(flagno, weight);
}

function ACCputin(objno, locno)
{
	success = false;
	setReferredObject(objno);
	if (getObjectLocation(objno) == LOCATION_WORN)
	{
		writeSysMessage(SYSMESS_YOUAREALREADYWEARINGTHAT);
		ACCnewtext();
		ACCdone();
		return;
	}

	if (getObjectLocation(objno) == loc_here())
	{
		writeSysMessage(SYSMESS_YOUDONTHAVEOBJECT);
		ACCnewtext();
		ACCdone();
		return;
	}

	if (getObjectLocation(objno) == LOCATION_CARRIED)
	{
		setObjectLocation(objno, locno);
		if (objectIsAttr(locno, ATTR_SUPPORTER)) writeSysMessage(SYSMESS_YOUPUTOBJECTON); else writeSysMessage(SYSMESS_YOUPUTOBJECTIN);
		writeText(getObjectFixArticles(locno));
		writeSysMessage(SYSMESS_PUTINTAKEOUTTERMINATION);
		success = true;
		return;
	}

	writeSysMessage(SYSMESS_YOUDONTHAVEOBJECT);
	ACCnewtext();
	ACCdone();
}


function ACCtakeout(objno, locno)
{
	success = false;
	setReferredObject(objno);
	if ((getObjectLocation(objno) == LOCATION_WORN) || (getObjectLocation(objno) == LOCATION_CARRIED))
	{
		writeSysMessage(SYSMESS_YOUALREADYHAVEOBJECT);
		ACCnewtext();
		ACCdone();
		return;
	}

	if (getObjectLocation(objno) == loc_here())
	{
		if (objectIsAttr(locno, ATTR_SUPPORTER)) writeSysMessage(SYSMESS_YOUCANTTAKEOBJECTFROM); else writeSysMessage(SYSMESS_YOUCANTTAKEOBJECTOUTOF);
		writeText(getObjectFixArticles(locno));
		writeSysMessage(SYSMESS_PUTINTAKEOUTTERMINATION);
		ACCnewtext();
		ACCdone();
		return;
	}

	if (getObjectWeight(objno) + getLocationObjectsWeight(LOCATION_WORN) + getLocationObjectsWeight(LOCATION_CARRIED) >  getFlag(FLAG_MAXWEIGHT_CARRIED))
	{
		writeSysMessage(SYSMESS_WEIGHSTOOMUCH);
		ACCnewtext();
		ACCdone();
		return;
	}

	if (getFlag(FLAG_OBJECTS_CARRIED_COUNT) >= getFlag(FLAG_MAXOBJECTS_CARRIED))
	{		
		writeSysMessage(SYSMESS_CANTCARRYANYMORE);
		ACCnewtext();
		ACCdone();
		return;
	}

	setObjectLocation(objno, LOCATION_CARRIED);
	writeSysMessage(SYSMESS_YOUTAKEOBJECT);
	success = true;


}
function ACCnewtext()
{
	parser_order_buffer = '';
}

function ACCability(maxObjectsCarried, maxWeightCarried)
{
	setFlag(FLAG_MAXOBJECTS_CARRIED, maxObjectsCarried);
	setFlag(FLAG_MAXWEIGHT_CARRIED, maxWeightCarried);
}

function ACCweight(flagno)
{
	weight_carried = getLocationObjectsWeight(LOCATION_CARRIED);
	weight_worn = getLocationObjectsWeight(LOCATION_WORN);
	total_weight = weight_worn + weight_carried;
	setFlag(flagno, total_weight);
}


function ACCrandom(flagno)
{
	 setFlag(flagno, 1 + Math.floor((Math.random()*100)));
}

function ACCwhato()
{
	whatofound = getReferredObject();
	if (whatofound != EMPTY_OBJECT) setReferredObject(whatofound);
}

function ACCputo(locno)
{
	setObjectLocation(getFlag(FLAG_REFERRED_OBJECT), locno);
}

function ACCnotdone()
{
	done_flag = true;
}

function ACCautop(locno)
{
	objno =findMatchingObject(LOCATION_CARRIED);
	if (objno != EMPTY_OBJECT) { ACCputin(objno, locno); return; };
	objno =findMatchingObject(LOCATION_WORN);
	if (objno != EMPTY_OBJECT) { ACCputin(objno, locno); return; };
	objno = findMatchingObject(loc_here());
	if (objno != EMPTY_OBJECT) { ACCputin(objno, locno); return; };
	objno = findMatchingObject(null); // anywhere
	if (objno != EMPTY_OBJECT) 
		{ 
			writeSysMessage(SYSMESS_YOUDONTHAVETHAT);
			ACCnewtext();
			ACCdone();
			return; 
		};

	writeSysMessage(SYSMESS_CANTDOTHAT);
	ACCnewtext();
	ACCdone();
}


function ACCautot(locno)
{

	objno =findMatchingObject(locno);
	if (objno != EMPTY_OBJECT) { ACCtakeout(objno, locno); return; };
	objno =findMatchingObject(LOCATION_CARRIED);
	if (objno != EMPTY_OBJECT) { ACCtakeout(objno, locno); return; };
	objno =findMatchingObject(LOCATION_WORN);
	if (objno != EMPTY_OBJECT) { ACCtakeout(objno, locno); return; };
	objno = findMatchingObject(loc_here());
	if (objno != EMPTY_OBJECT) { ACCtakeout(objno, locno); return; };

	objno = findMatchingObject(null); // anywhere
	if (objno != EMPTY_OBJECT) 
		{ 
			if (objectIsAttr(locno, ATTR_SUPPORTER)) writeSysMessage(SYSMESS_YOUCANTTAKEOBJECTFROM); else writeSysMessage(SYSMESS_YOUCANTTAKEOBJECTOUTOF);
			writeText(getObjectFixArticles(locno));
			writeSysMessage(SYSMESS_PUTINTAKEOUTTERMINATION)
			ACCnewtext();
			ACCdone();
			return; 
		};

	writeSysMessage(SYSMESS_CANTDOTHAT);
	ACCnewtext();
	ACCdone();
	
}


function CNDmove(flagno)
{
	var locno = getFlag(flagno);
	var dirno = getFlag(FLAG_VERB);
	destination = getConnection( locno,  dirno);
	if (destination != -1) 
		{
			 setFlag(flagno, destination);
			 return true;
		}
	return false;
}


function ACCextern(writeno)
{
	eval(writemessages[writeno]);
}


function ACCpicture(picno)
{
	drawPicture(picno);
}



function ACCgraphic(option)
{
	graphicsON = (option==1);  
	if (!graphicsON) hideGraphicsWindow();	
}

function ACCbeep(sfxno, channelno, times)
{
	if ((channelno <1) || (channelno >MAX_CHANNELS)) return;  //SFX channels from 1 to MAX_CHANNELS, channel 0 is for location music and can't be used here
	sfxplay(sfxno, channelno, times, 'play');
}

function ACCsound(value)
{
	soundsON = (value==1);  
	if (!soundsON) sfxstopall();
}

function CNDozero(objno, attrno)
{
	if (attrno > 63) return false;
	return !objectIsAttr(objno, attrno);

}

function CNDonotzero(objno, attrno)
{
	return objectIsAttr(objno, attrno);
}

function ACCoset(objno, attrno)
{
	if (attrno > 63) return;
	if (attrno <= 31)
	{
		attrs = getObjectLowAttributes(objno);
		attrs = bitset(attrs, attrno);
		setObjectLowAttributes(objno, attrs);
		return;
	}
	attrs = getObjectHighAttributes(objno);
	attrno = attrno - 32;
	attrs = bitset(attrs, attrno);
	setObjectHighAttributes(objno, attrs);

}

function ACCoclear(objno, attrno)
{
	if (attrno > 63) return;
	if (attrno <= 31)
	{
		attrs = getObjectLowAttributes(objno);
		attrs = bitclear(attrs, attrno);
		setObjectLowAttributes(objno, attrs);
		return;
	}
	attrs = getObjectHighAttributes(objno);
	attrno = attrno - 32;
	attrs = bitclear(attrs, attrno);
	setObjectHighAttributes(objno, attrs);

}


function CNDislight()
{
	if (!isDarkHere()) return true;
	return lightObjectsPresent();
}



function CNDisnotlight()
{
	return ! CNDislight();
}

function ACCversion()
{
	writeText(STR_RUNTIME_VERSION);
}


function ACCwrite(writeno)
{
	writeWriteMessage(writeno);
}

function ACCwriteln(writeno)
{
	writeWriteMessage(writeno);
	ACCnewline();
}

function ACCrestart()
{
  process_restart = true;
}


function ACCtranscript()
{
	$('#transcript_area').html(transcript);
	$('.transcript_layer').show();
}

function ACCanykey()
{
	writeSysMessage(SYSMESS_PRESSANYKEY);
}

function ACCgetkey(flagno)
{
	getkey_return_flag = flagno;
}





//////////////////
//   LEGACY     //
//////////////////

// From PAW PC
function ACCbell()
{
 	// Empty, PAW PC legacy, just does nothing 
}


// From PAW Spectrum
function ACCreset()
{
	// Legacy condact, does nothing now
}


function ACCpaper(color)
{
	// Legacy condact, does nothing now, use CSS styles
}

function ACCink(color)
{
	// Legacy condact, does nothing now, use CSS styles
}

function ACCborder(color)
{
	// Legacy condact, does nothing now, use CSS styles
}

function ACCcharset(value)
{
	// Legacy condact, does nothing now, use CSS styles
}

function ACCline(lineno)
{
	// Legacy condact, does nothing now, use CSS styles
}

function ACCinput()
{
	// Legacy condact, does nothing now
}

function ACCsaveat()
{
	// Legacy condact, does nothing now
}

function ACCbackat()
{
	// Legacy condact, does nothing now
}

function ACCprintat()
{
	// Legacy condact, does nothing now
}

function ACCprotect()
{
	// Legacy condact, does nothing now
}

// From Superglus


function ACCdebug()
{
	// Legacy condact, does nothing now		
}




////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////// CONDACTS FOR COMPILER //////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function CNDverb(wordno)
{
	return (getFlag(FLAG_VERB) == wordno);
}


function CNDnoun1(wordno)
{
	return (getFlag(FLAG_NOUN1) == wordno);
}

//   PLUGINS    ;

//CND ATGE C 8 0 0 0

function CNDatge(locno)
{
	return (getFlag(FLAG_LOCATION) >= locno);
}

//CND ATLE C 8 0 0 0

function CNDatle(locno)
{
	return (getFlag(FLAG_LOCATION) <= locno);
}

//CND BCLEAR A 1 2 0 0

function ACCbclear(flagno, bitno)
{
	if (bitno>=32) return;
	setFlag(flagno, bitclear(getFlag(flagno), bitno));
}
//CND BLOCK A 14 2 2 0

function ACCblock(writeno, picno, procno)
{
   disableInterrupt();
   $('.block_layer').css('display','none');
   $('.block_layer').css('background-color',$('.text').css('background-color'));
   text = writemessages[writeno]
   text = h_writeText(text); // hook
   text = filterText(text)
   $('.block_text').html(text);
   
	var filename = getResourceById(RESOURCE_TYPE_IMG, picno);
	if (filename)
	{
		var imgsrc = '<img class="block_picture" src="' + filename + '" />';
		$('.block_graphics').html(imgsrc);
	}
    if (procno == 0 ) unblock_process ==null; else unblock_process = procno;
    $('.block_layer').css('display','block');

}
//CND BNEG A 1 2 0 0

function ACCbneg(flagno, bitno)
{
	if (bitno>=32) return;
	setFlag(flagno, bitneg(getFlag(flagno),bitno));
}
//CND BNOTZERO C 1 2 0 0

function CNDbnotzero(flagno, bitno)
{
	if (bitno>=32) return false;
	return (bittest(getFlag(flagno), bitno));
}

//CND BREAK A 0 0 0 0

function ACCbreak()
{
	doall_flag = false; 
	entry_for_doall = '';
}
//CND BSET A 1 2 0 0

function ACCbset(flagno, bitno)
{
	if (bitno>=32) return;
	setFlag(flagno, bitset(getFlag(flagno),bitno));
}
//CND BZERO C 1 2 0 0

function CNDbzero(flagno, bitno)
{
	if (bitno>=32) return false;
	return (!bittest(getFlag(flagno), bitno));
}
//CND CLEAREXIT A 2 0 0 0

function ACCclearexit(wordno)
{
	if ((wordno >= NUM_CONNECTION_VERBS) || (wordno< 0 )) return;
	setConnection(loc_here(),-1);
}
//CND COMMAND A 2 0 0 0

function ACCcommand(value)
{
	if (value) $('.input').show(); else $('.input').hide();
}
//CND DIV A 1 2 0 0

function ACCdiv(flagno, valor)
{
	if (valor == 0) return;
	setFlag(flagno, Math.floor(getFlag(flagno) / valor));
}
//CND EXITS A 8 5 0 0

function ACCexits(locno,mesno)
{
  if ((getFlag(FLAG_LIGHT) == 0) || ((getFlag(FLAG_LIGHT) != 0) && lightObjectsPresent()))
  {
  		exitcount = 0;
  		for (i=0;i<NUM_CONNECTION_VERBS;i++) if (getConnection(locno, i) != -1) exitcount++;
      if (exitcount)
      {
    		writeMessage(mesno);
    		exitcountprogress = 0;
    		for (i=0;i<NUM_CONNECTION_VERBS;i++) if (getConnection(locno, i) != -1)
    		{ 
    			exitcountprogress++;
    			writeMessage(mesno + 2 + i);
    			if (exitcountprogress == exitcount) writeSysMessage(SYSMESS_LISTEND);
    			if (exitcountprogress == exitcount-1) writeSysMessage(SYSMESS_LISTLASTSEPARATOR);
    			if (exitcountprogress <= exitcount-2) writeSysMessage(SYSMESS_LISTSEPARATOR);
  		  }
      } else writeMessage(mesno + 1);
  } else writeMessage(mesno + 1);
}

//CND FADEIN A 2 2 2 0

function ACCfadein(sfxno, channelno, times)
{
	if ((channelno <1) || (channelno >MAX_CHANNELS)) return;  //SFX channels from 1 to MAX_CHANNELS, channel 0 is for location music and can't be used here
	sfxplay(sfxno, channelno, times, 'fadein');
}
//CND FADEOUT A 2 2 0 0

function ACCfadeout(channelno, value)
{
	if ((channelno <1) || (channelno >MAX_CHANNELS)) return;  //SFX channels from 1 to MAX_CHANNELS, channel 0 is for location music and can't be used here
	sfxfadeout(channelno, value);
}
//CND GE C 1 2 0 0

function CNDge(flagno, valor)
{
	return (getFlag(flagno)>=valor);
}
//CND GETEXIT A 2 2 0 0

function ACCgetexit(value,flagno)
{
	if (value >= NUM_CONNECTION_VERBS) 
		{
			setFlag(flagno, NO_EXIT);
			return;
		}
	locno = getConnection(loc_here(),value);
	if (locno == -1)
		{
			setFlag(flagno, NO_EXIT);
			return;
		}
	setFlag(flagno,locno);
}
//CND HELP A 0 0 0 0

function ACChelp()
{
	if (getLang()=='EN') EnglishHelp(); else SpanishHelp();
}	

function EnglishHelp()
{
	writeText('HOW DO I SEND COMMANDS TO THE PC?');
	writeText(STR_NEWLINE);
	writeText('Use simple orders: OPEN DOOR, TAKE KEY, GO UP, etc.');
	writeText(STR_NEWLINE + STR_NEWLINE);
	writeText('HOW CAN I MOVE IN THE MAP?');
	writeText(STR_NEWLINE);
	writeText('Usually you will have to use compass directions as north (shortcut: "N"), south (S), east (E), west (W) or other directions (up, down, enter, leave, etc.). Some games allow complex order like "go to well". Usually you would be able to know avaliable exits by location description, some games also provide the "EXITS" command.');
	writeText(STR_NEWLINE + STR_NEWLINE);
	writeText('HOW CAN I CHECK MY INVENTORY?');
	writeText(STR_NEWLINE);
	writeText('type INVENTORY (shortcut "I")');
	writeText(STR_NEWLINE + STR_NEWLINE);
	writeText('HOW CAN I USE THE OBJECTS?');
	writeText(STR_NEWLINE);
	writeText('Use the proper verb, that is, instead of USE KEY type OPEN.');
	writeText(STR_NEWLINE + STR_NEWLINE);
	writeText('HOW CAN I CHECK SOMETHING CLOSELY?');
	writeText(STR_NEWLINE);
	writeText('Use "examine" verb: EXAMINE DISH. (shortcut: EX)');
	writeText(STR_NEWLINE + STR_NEWLINE);
	writeText('HOW CAN I SEE AGAIN THE CURRENT LOCATION DSCRIPTION?');
	writeText(STR_NEWLINE);
	writeText('Type LOOK (shortcut "M").');
	writeText(STR_NEWLINE + STR_NEWLINE);
	writeText('HOW CAN I TALK TO OTHER CHARACTERS?');
	writeText(STR_NEWLINE);
	writeText('Most common methods are [CHARACTER, SENTENCE] or [SAY CHARACTER "SENTENCE"]. For instance: [JOHN, HELLO] o [SAY JOHN "HELLO"]. Some games also allow just [TALK TO JOHN]. ');
	writeText(STR_NEWLINE + STR_NEWLINE);
	writeText('HOW CAN I PUT SOMETHING IN A CONTAINER, HOW CAN I TAKE SOMETHING OUT?');
	writeText(STR_NEWLINE);
	writeText('PUT KEY IN BOX. TAKE KEY OUT OF BOX. INSERT KEY IN BOX. EXTRACT KEY FROM BOX.');
	writeText(STR_NEWLINE + STR_NEWLINE);
	writeText('HOW CAN I PUT SOMETHING ON SOMETHING ELSE?');
	writeText(STR_NEWLINE);
	writeText('PUT KEY ON TABLE. TAKE KEY FROM TABLE');
	writeText(STR_NEWLINE + STR_NEWLINE);
}

function SpanishHelp()
{
	writeText('CMO DOY ORDENES AL PERSONAJE?');
	writeText(STR_NEWLINE);
	writeText('Utiliza rdenes en imperativo o infinitivo: ABRE PUERTA, COGER LLAVE, SUBIR, etc.');
	writeText(STR_NEWLINE + STR_NEWLINE);
	writeText('CMO ME MUEVO POR EL JUEGO?');
	writeText(STR_NEWLINE);
	writeText('Por regla general, mediante los puntos cardinales como norte (abreviado "N"), sur (S), este (E), oeste (O) o direcciones espaciales (arriba, abajo, bajar, subir, entrar, salir, etc.). Algunas aventuras permiten tambin cosas como "ir a pozo". Normalmente podrs saber en que direccin puedes ir por la descripcin del sitio, aunque algunos juegos facilitan el comando "SALIDAS" que te dir exactamente cuales hay.');
	writeText(STR_NEWLINE + STR_NEWLINE);
	writeText('CMO PUEDO SABER QUE OBJETOS LLEVO?');
	writeText(STR_NEWLINE);
	writeText('Teclea INVENTARIO (abreviado "I")');
	writeText(STR_NEWLINE + STR_NEWLINE);
	writeText('CMO USO LOS OBJETOS?');
	writeText(STR_NEWLINE);
	writeText('Utiliza el verbo correcto, en lugar de USAR ESCOBA escribe BARRER.');
	writeText(STR_NEWLINE + STR_NEWLINE);
	writeText('CMO PUEDO MIRAR DE CERCA UN OBJETO U OBSERVARLO MS DETALLADAMENTE?');
	writeText(STR_NEWLINE);
	writeText('Con el verbo examinar: EXAMINAR PLATO. Generalmente se puede usar la abreviatura "EX" : EX PLATO.');
	writeText(STR_NEWLINE + STR_NEWLINE);
	writeText('CMO PUEDO VER DE NUEVO LA DESCRIPCIN DEL SITIO DONDE ESTOY?');
	writeText(STR_NEWLINE);
	writeText('Escribe MIRAR (abreviado "M").');
	writeText(STR_NEWLINE + STR_NEWLINE);
	writeText('CMO HABLO CON LOS PERSONAJES?');
	writeText(STR_NEWLINE);
	writeText('Los modos ms comunes son [PERSONAJE, FRASE] o [DECIR A PERSONAJE "FRASE"]. Por ejemplo: [LUIS, HOLA] o [DECIR A LUIS "HOLA"]. En algunas aventuras tambin se puede utilizar el formato [HABLAR A LUIS]. ');
	writeText(STR_NEWLINE + STR_NEWLINE);
	writeText('CMO METO ALGO EN UN CONTENEDOR? COMO SACO ALGO?');
	writeText(STR_NEWLINE);
	writeText('METER LLAVE  EN CAJA. SACAR LLAVE DE CAJA');
	writeText(STR_NEWLINE + STR_NEWLINE);
	writeText('CMO PONGO ALGO SOBRE ALGO? COMO LO QUITO?');
	writeText(STR_NEWLINE);
	writeText('PONER LLAVE EN MESA. COGER LLAVE DE MESA');
	writeText(STR_NEWLINE + STR_NEWLINE);
}
//CND HOOK A 14 0 0 5

function ACChook(writeno)
{
	h_code(writemessages[writeno]);
}
//CND ISMUSIC C 0 0 0 0

function cnd_ismusic()
{
	return (CNDissound(0));	
}

//CND ISNOTMUSIC C 0 0 0 0

function CNDisnotmusic()
{
  return !CNDismusic();
}

//CND ISNOTSOUND C 1 0 0 0

function CNDisnotsound(channelno)
{
  if ((channelno <1) || (channelno >MAX_CHANNELS)) return false;
  return !(CNDissound(channelno));
}
//CND ISSOUND C 1 0 0 0

function CNDissound(channelno)
{
	if ((channelno <1 ) || (channelno > MAX_CHANNELS)) return false;
    return channelActive(channelno);
}
//CND LE C 1 2 0 0

function CNDle(flagno, valor)
{
	return (getFlag(flagno) <= valor);
}
//CND LISTCONTENTS A 9 0 0 0

function ACClistcontents(locno)
{
   ACClistat(locno, locno)
}
//CND LOG A 14 0 0 0

function ACClog(writeno)
{
  console_log(writemessages[writeno]);
}
//CND MOD A 1 2 0 0

function ACCmod(flagno, valor)
{
	if (valor == 0) return;
	setFlag(flagno, Math.floor(getFlag(flagno) % valor));
}
//CND MUL A 1 2 0 0

function ACCmul(flagno, valor)
{
	if (valor == 0) return;
	setFlag(flagno, Math.floor(getFlag(flagno) * valor));
}
//CND NPCAT A 9 1 0 0

function ACCnpcat(locno, flagno)
{
	setFlag(flagno,getNPCCountAt(locno));
}

//CND OBJAT A 9 1 0 0

function ACCobjat(locno, flagno)
{
	setFlag(flagno, getObjectCountAt(locno));
}
//CND OBJFOUND C 2 9 0 0

function CNDobjfound(attrno, locno)
{

	for (i=0;i<num_objects;i++) 
		if ((getObjectLocation(i) == locno) && (CNDonotzero(i,attrno))) {setFlag(FLAG_ESCAPE, i); return true; }
	setFlag(FLAG_ESCAPE, EMPTY_OBJECT);
	return false;
}

//CND OBJNOTFOUND C 2 9 0 0

function CNDobjnotfound(attrno, locno)
{
	for (i=0;i<num_objects;i++) 
		if ((getObjectLocation(i) == locno) && (CNDonotzero(i,attrno))) {setFlag(FLAG_ESCAPE, i); return false; }

	setFlag(FLAG_ESCAPE, EMPTY_OBJECT);
	return true;
}
//CND ONEG A 4 2 0 0

function ACConeg(objno, attrno)
{
	if (attrno > 63) return;
	if (attrno <= 31)
	{
		attrs = getObjectLowAttributes(objno);
		attrs = bitneg(attrs, attrno);
		setObjectLowAttributes(objno, attrs);
		return;
	}
	attrs = getObjectHighAttributes(objno);
	attrno = attrno - 32;
	attrs = bitneg(attrs, attrno);
	setObjectHighAttributes(objno, attrs);
}

//CND PICTUREAT A 2 2 2 0

function ACCpictureat(x,y,picno)
{
	filename = getResourceById(RESOURCE_TYPE_IMG, picno);
	if (!filename) return;

	var screenImage = $('.location_picture');
	if (!screenImage) return;

	// Create a new image with the contents of current image, to be able to calculate original height of image
	var theImage = new Image();

	// Get curent height 
		theImage.onload = function()
		{
			var screenImageHeight = screenImage.height();
			var screenImageX = Math.floor((parseInt($('.graphics').width()) - screenImage.width())/2);;
	    	var imageHeight    = theImage.height; 
			// Calculate scale and x, Y position
			scale =  screenImageHeight / imageHeight;
			x = Math.floor(x * scale);
			y = Math.floor(y * scale);


			// now load new image
			id = 'pictureat_' + picno;
			// add new image
			$('.graphics').append('<img id="'+id+'" style="display:none" />');

			var newImage = new Image();
			newImage.onload = function ()
			{
				newimageHeight = Math.floor(newImage.height * scale);
				$('#' + id).css('position','absolute');
				$('#' + id).css('left', x + screenImageX + 'px');
				$('#' + id).css('top',y + 'px');
				$('#' + id).css('z-index','100');
				$('#' + id).attr('src', filename);
				$('#' + id).css('height',newimageHeight + 'px');
				$('#' + id).show();
			}
			newImage.src = filename;
			};
	theImage.src = screenImage.attr("src");

}

//CND RANDOMX A 1 2 0 0

function ACCrandomx(flagno, value)
{
	 setFlag(flagno, 1 + Math.floor((Math.random()*value)));
}
//CND RNDWRITE A 14 14 14 0

function ACCrndwrite(writeno1,writeno2,writeno3)
{
	val = Math.floor((Math.random()*3));
	switch (val)
	{
		case 0 : writeWriteMessage(writeno1);break;
		case 1 : writeWriteMessage(writeno2);break;
		case 2 : writeWriteMessage(writeno3);break;
	}
}
//CND RNDWRITELN A 14 14 14 0

function ACCrndwriteln(writeno1,writeno2,writeno3)
{
	ACCrndwrite(writeno1,writeno2,writeno3);
	ACCnewline();
}
//CND SETEXIT A 2 2 0 0

function ACCsetexit(value, locno)
{
	if (value < NUM_CONNECTION_VERBS) setConnection(loc_here(), value, locno);
}
//CND SETWEIGHT A 4 2 0 0

function ACCsetweight(objno, value)
{
   objectsWeight[objno] = value;
}

//CND SILENCE A 2 0 0 0

function ACCsilence(channelno)
{
	if ((channelno <1) || (channelno >MAX_CHANNELS)) return;
	sfxstop(channelno);
}
//CND SOFTBLOCK A 2 0 0 0

function ACCsoftblock(procno)
{
   disableInterrupt();

   $('.block_layer').css('display','none');
   $('.block_text').html('');
   $('.block_graphics').html('');
   $('.block_layer').css('background','transparent');
   if (procno == 0 ) unblock_process ==null; else unblock_process = procno;
   $('.block_layer').css('display','block');
}
//CND TEXTPIC A 2 2 0 0

function ACCtextpic(picno, align)
{
	var style = '';
	var post = '';
	var pre = '';
	switch(align)
	{
		case 1: style = 'float:left'; break;
		case 2: style = 'float:right'; break;
		case 3: post = '<br />';
		case 4: pre='<center>';post='</center>';break;
	}
	filename = getResourceById(RESOURCE_TYPE_IMG, picno);
	if (filename)
	texto = pre + "<img class='textpic' style='"+style+"' src='"+filename+"' />" + post;
	writeText(texto);
}
//CND TITLE A 14 0 0 0

function ACCtitle(writeno)
{
	document.title = writemessages[writeno];
}
//CND VOLUME A 2 2 0 0

function ACCvolume(channelno, value)
{
	if ((channelno <1) || (channelno >MAX_CHANNELS)) return;
	sfxvolume(channelno, value);
}

//CND WHATOX A 1 0 0 0

function ACCwhatox(flagno)
{
	whatoxfound = getReferredObject();
	setFlag(flagno,whatoxfound);
}

//CND WHATOX2 A 1 0 0 0

function ACCwhatox2(flagno)
{	
	auxNoun = getFlag(FLAG_NOUN1);
	auxAdj = getFlag(FLAG_ADJECT1);
	setFlag(FLAG_NOUN1, getFlag(FLAG_NOUN2));
	setFlag(FLAG_ADJECT1, getFlag(FLAG_ADJECT2));
	whatox2found = getReferredObject();
	setFlag(flagno,whatox2found);
	setFlag(FLAG_NOUN1, auxNoun);
	setFlag(FLAG_ADJECT1, auxAdj);
}
//CND YOUTUBE A 14 0 0 0

function ACCyoutube(strno)
{

	str = '<iframe id="youtube" width="560" height="315" src="http://www.youtube.com/embed/' + writemessages[strno] + '?autoplay=1&controls=0&modestbranding=1&showinfo=0" frameborder="0" allowfullscreen></iframe>'
	$('#text').css('height','45%');
	$('#graphics').css('height','45%');
	$('#graphics').html(str);
	$('#youtube').css('height','100%');
	$('#youtube').css('display','block');
	$('#youtube').css('margin-left','auto');
	$('#youtube').css('margin-right','auto');
	$('#graphics').show();
}
//CND ZONE C 8 8 0 0

function CNDzone(locno1, locno2)
{

	if (loc_here()<locno1) return false;
	if (loc_here()>locno2) return false;
	return true;
}
// This file is (C) Carlos Sanchez 2014, released under the MIT license


// IMPORTANT: Please notice this file must be encoded with the same encoding the index.html file is, so the "normalize" function works properly.
//            As currently the ngpwas compiler generates iso-8859-1, and the index.html is using iso-8859-1 also, this file must be using that encoding.


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                         Auxiliary functions                                            //
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// General functions
String.prototype.rights= function(n){
    if (n <= 0)
       return "";
    else if (n > String(this).length)
       return this;
    else {
       var iLen = String(this).length;
       return String(this).substring(iLen, iLen - n);
    }
}


String.prototype.firstToLower= function()
{
	return  this.charAt(0).toLowerCase() + this.slice(1);	
	return a;
}
 

// Returns true if using Internet Explorer 9 or below, where some features are not supported
function isBadIE () {
  var myNav = navigator.userAgent.toLowerCase();
  if (myNav.indexOf('msie') == -1) return false;
  ieversion =  parseInt(myNav.split('msie')[1]);
  return (ieversion<10);
}


function runningLocal()
{
	return (window.location.protocol == 'file:');
}



// waitKey helper for ANYKEY and GETKEY

function waitKey(callbackFunction)
{
	anykey_return_function = callbackFunction;
	disableInterrupt();
   	$('.block_layer').css('display','none');
    $('.block_text').html('');
    $('.block_graphics').html('');
    $('.block_layer').css('background','transparent');
    $('.block_layer').css('display','block');
    $('.input').hide();
}

function waitKeyCallback()
{
 			var callback = anykey_return_function;
     		anykey_return_function = null;
			hideBlock();    		
     		callback();
     		if (describe_location_flag) descriptionLoop();  		
}


// Check DOALL entry

function skipdoall(entry)
{
	return  ((doall_flag==true) && (entry_for_doall!='') && (current_process==process_in_doall) && (entry_for_doall > entry));
}

// Dynamic attribute use functions
function getNextFreeAttribute()
{
	var value = nextFreeAttr;
	nextFreeAttr++;
	return value;
}


// Gender functions

function getSimpleGender(objno)  // Simple, for english
{
 	isPlural = objectIsAttr(objno, ATTR_PLURALNAME);
 	if (isPlural) return "P";
 	isFemale = objectIsAttr(objno, ATTR_FEMALE);
 	if (isFemale) return "F";
 	isMale = objectIsAttr(objno, ATTR_MALE);
 	if (isMale) return "M";
    return "N"; // Neuter
}

function getAdvancedGender(objno)  // Complex, for spanish
{
 	var isPlural = objectIsAttr(objno, ATTR_PLURALNAME);
 	var isFemale = objectIsAttr(objno, ATTR_FEMALE);
 	var isMale = objectIsAttr(objno, ATTR_MALE);

 	if (!isPlural) 
 	{
	 	if (isFemale) return "F";
	 	if (isMale) return "M";
	    return "N"; // Neuter
 	}
 	else
 	{
	 	if (isFemale) return "PF";
	 	if (isMale) return "PM";
	 	return "PN"; // Neuter plural
 	}

}

function getLang()
{
	var value = bittest(getFlag(FLAG_PARSER_SETTINGS),5);
	if (value) return "ES"; else return "EN";
}

function getObjectFixArticles(objno)
{
	var object_text = getObjectText(objno);
	var object_words = object_text.split(' ');
	if (object_words.length == 1) return object_text;
	var candidate = object_words[0];
	object_words.splice(0, 1);
	if (getLang()=='EN')
	{
		if ((candidate!='an') && (candidate!='a') && (candidate!='some')) return object_text;
		return 'the ' + object_words.join(' ');
	}
	else
	{
		if ( (candidate!='un') && (candidate!='una') && (candidate!='unas') && (candidate!='unas') && (candidate!='alguna') && (candidate!='algunos') && (candidate!='algunas') && (candidate!='alguno')) return object_text;
		var gender = getAdvancedGender(objno);
		if (gender == 'F') return 'la ' + object_words.join(' ');
		if (gender == 'M') return 'el ' + object_words.join(' ');
		if (gender == 'N') return 'el ' + object_words.join(' ');
		if (gender == 'PF') return 'las ' + object_words.join(' ');
		if (gender == 'PM') return 'los ' + object_words.join(' ');
		if (gender == 'PN') return 'los ' + object_words.join(' ');
	}	


}



// JS level log functions
function console_log(string)
{
	if (typeof console != "undefined") console.log(string);
}


// Resources functions
function getResourceById(resource_type, id)
{
	for (var i=0;i<resources.length;i++)
	 if ((resources[i][0] == resource_type) && (resources[i][1]==id)) return resources[i][2];
	return false; 
}

// Flag read/write functions
function getFlag(flagno)
{
	 return flags[flagno];
}

function setFlag(flagno, value)
{
	 flags[flagno] = value;
}

// Locations functions
function loc_here()  // Returns current location, avoid direct use of flags
{
	 return getFlag(FLAG_LOCATION);
}


// Connections functions

function setConnection(locno1, dirno, locno2)
{
	connections[locno1][dirno] = locno2;
}

function getConnection(locno, dirno)
{
	return connections[locno][dirno];
}

// Objects text functions

function getObjectText(objno)
{
	return objects[objno];
}


// Output processing functions

function implementTag(tag)
{
	tagparams = tag.split('|');
	for (var tagindex=0;tagindex<tagparams.length-1;tagindex++) tagparams[tagindex] = tagparams[tagindex].trim();
	if (tagparams.length == 0) {writeText(STR_INVALID_TAG_SEQUENCE_EMPTY); return ''}

	switch(tagparams[0].toUpperCase())
	{
		case 'URL': if (tagparams.length != 3) {return '[[[' + STR_INVALID_TAG_SEQUENCE_BADPARAMS + ']]]'};
					return '<a target="_blank" href="' + tagparams[1]+ '">' + tagparams[2] + '</a>';
					break;
		case 'CLASS': if (tagparams.length != 3) {return '[[[' + STR_INVALID_TAG_SEQUENCE_BADPARAMS + ']]]'};
					  return '<span class="' + tagparams[1]+ '">' + tagparams[2] + '</span>';
					  break;
		case 'STYLE': if (tagparams.length != 3) {return '[[[' + STR_INVALID_TAG_SEQUENCE_BADPARAMS + ']]]'};
					  return '<span style="' + tagparams[1]+ '">' + tagparams[2] + '</span>';
					  break;
		case 'INK': if (tagparams.length != 3) {return '[[[' + STR_INVALID_TAG_SEQUENCE_BADPARAMS + ']]]'};
					  return '<span style="color:' + tagparams[1]+ '">' + tagparams[2] + '</span>';
					  break;
		case 'PAPER': if (tagparams.length != 3) {return '[[[' + STR_INVALID_TAG_SEQUENCE_BADPARAMS + ']]]'};
					  return '<span style="background-color:' + tagparams[1]+ '">' + tagparams[2] + '</span>';
					  break;
		case 'OBJECT': if (tagparams.length != 2) {return '[[[' + STR_INVALID_TAG_SEQUENCE_BADPARAMS + ']]]'};
					   if(objects[getFlag(tagparams[1])]) return getObjectFixArticles(getFlag(tagparams[1])); else return '';
					   break;
		case 'WEIGHT': if (tagparams.length != 2) {return '[[[' + STR_INVALID_TAG_SEQUENCE_BADPARAMS + ']]]'};
					   if(objectsWeight[getFlag(tagparams[1])]) return objectsWeight[getFlag(tagparams[1])]; else return '';
					   break;
		case 'OLOCATION': if (tagparams.length != 2) {return '[[[' + STR_INVALID_TAG_SEQUENCE_BADPARAMS + ']]]'};
					      if(objectsLocation[getFlag(tagparams[1])]) return objectsLocation[getFlag(tagparams[1])]; else return '';
					      break;
		case 'MESSAGE':if (tagparams.length != 2) {return '[[[' + STR_INVALID_TAG_SEQUENCE_BADPARAMS + ']]]'};
					   if(messages[getFlag(tagparams[1])]) return messages[getFlag(tagparams[1])]; else return '';
					   break;
		case 'SYSMESS':if (tagparams.length != 2) {return '[[[' + STR_INVALID_TAG_SEQUENCE_BADPARAMS + ']]]'};
					   if(sysmessages[getFlag(tagparams[1])]) return sysmessages[getFlag(tagparams[1])]; else return '';
					   break;
		case 'LOCATION':if (tagparams.length != 2) {return '[[[' + STR_INVALID_TAG_SEQUENCE_BADPARAMS + ']]]'};
					   if(locations[getFlag(tagparams[1])]) return locations[getFlag(tagparams[1])]; else return '';
					   break;
		case 'PROCESS':if (tagparams.length != 2) {return '[[[' + STR_INVALID_TAG_SEQUENCE_BADPARAMS + ']]]'};
					   callProcess(tagparams[1]);
					   break;
		case 'ACTION': if (tagparams.length != 3) {return '[[[' + STR_INVALID_TAG_SEQUENCE_BADPARAMS + ']]]'};
					   return '<a href="javascript: void(0)" onclick="orderEnteredLoop(\'' + tagparams[1]+ '\')">' + tagparams[2] + '</a>';
					   break;
		case 'RESTART': if (tagparams.length != 2) {return '[[[' + STR_INVALID_TAG_SEQUENCE_BADPARAMS + ']]]'};
					    return '<a href="javascript: void(0)" onclick="restart()">' + tagparams[1] + '</a>';
					    break;
		case 'EXTERN': if (tagparams.length != 3) {return '[[[' + STR_INVALID_TAG_SEQUENCE_BADPARAMS + ']]]'};
					    return '<a href="javascript: void(0)" onclick="' + tagparams[1] + ' ">' + tagparams[2] + '</a>';
					    break;
		case 'TEXTPIC': if (tagparams.length != 3) {return '[[[' + STR_INVALID_TAG_SEQUENCE_BADPARAMS + ']]]'};
						var style = '';
						var post = '';
						var pre = '';
						align = tagparams[2];
						switch(align)
						{
							case 1: style = 'float:left'; break;
							case 2: style = 'float:right'; break;
							case 3: post = '<br />';
							case 4: pre='<center>';post='</center>';break;
						}
						return pre + "<img class='textpic' style='"+style+"' src='"+ RESOURCES_DIR + tagparams[1]+"' />" + post;
					    break;
		case 'HTML': if (tagparams.length != 2) {return '[[[' + STR_INVALID_TAG_SEQUENCE_BADPARAMS + ']]]'};
						return tagparams[1];
					    break;
		case 'FLAG': if (tagparams.length != 2) {return '[[[' + STR_INVALID_TAG_SEQUENCE_BADPARAMS + ']]]'};
						return getFlag(tagparams[1]);
					    break;
		case 'OREF': if (tagparams.length != 1) {return '[[[' + STR_INVALID_TAG_SEQUENCE_BADPARAMS + ']]]'};
   			        if(objects[getFlag(FLAG_REFERRED_OBJECT)]) return getObjectFixArticles(getFlag(FLAG_REFERRED_OBJECT)); else return '';
					break;
		case 'OPRO': if (tagparams.length != 1) {return '[[[' + STR_INVALID_TAG_SEQUENCE_BADPARAMS + ']]]'};  // returns the pronoun for a given object, used for english start database
					 switch (getSimpleGender(getFlag(FLAG_REFERRED_OBJECT)))
					 {
					 	case 'M' : return "him";
					 	case "F" : return "her";
					 	case "N" : return "it";
					 	case "P" : return "them";  // plural returns them
					 }
					break;
			default : return h_sequencetag(tagparams);
	}
}

function processTags(text)
{
	//Apply the {} tags filtering
	var pre, post, innerTag;
	tagfilter:
	while (text.indexOf('{') != -1)
	{
		if (( text.indexOf('}') == -1 ) || ((text.indexOf('}') < text.indexOf('{'))))
		{
			writeText(STR_INVALID_TAG_SEQUENCE + text);
			break tagfilter;
		}
		pre = text.substring(0,text.indexOf('{'));
		var openbracketcont = 1;
		pointer = text.indexOf('{') + 1;
		innerTag = ''
		while (openbracketcont>0)
		{
			if (text.charAt(pointer) == '{') openbracketcont++;
			if (text.charAt(pointer) == '}') openbracketcont--;
			innerTag = innerTag + text.charAt(pointer);
			pointer++;
		}
		innerTag = innerTag.substring(0,innerTag.length - 1);
		post = text.substring(pointer);
		if (innerTag.indexOf('{') != -1 ) innerTag = processTags(innerTag); 
		innerTag = implementTag(innerTag);
		text = pre + innerTag + post;
	}
	return text;
}

function filterText(text)
{
	// ngPAWS sequences
	text = processTags(text);


	// Superglus sequences (only \n remains)
    text = text.replace(/\n/g, STR_NEWLINE);

	// PAWS sequences (only underscore)
	objno = getFlag(FLAG_REFERRED_OBJECT);
	if ((objno != EMPTY_OBJECT) && (objects[objno]))	text = text.replace(/_/g,getObjectText(objno).firstToLower()); else text = text.replace(/_/g,'');

	return text;
}

// Text Output functions
function writeText(text)
{
	text = h_writeText(text); // hook
	text = filterText(text)
	$('.text').append(text);
	$(".text").scrollTop($(".text")[0].scrollHeight);
	addToTranscript(text);
	focusInput();
}

function addToTranscript(text)
{
	transcript = transcript + text;		
}

function writelnText(text)
{
	writeText(text + STR_NEWLINE);
}

function writeMessage(mesno)
{
	if (messages[mesno]!=null) writeText(messages[mesno]); else writeText(STR_NEWLINE + STR_WRONG_MESSAGE + ' [' + mesno + ']');
}

function writeSysMessage(sysno)
{
		if (sysmessages[sysno]!=null) writeText(sysmessages[sysno]); else writeText(STR_NEWLINE + STR_WRONG_SYSMESS + ' [' + sysno + ']');
		$(".text").scrollTop($(".text")[0].scrollHeight);
}

function writeWriteMessage(writeno)
{
		writeText(writemessages[writeno]); 
}

function writeObject(objno)
{
	writeText(getObjectText(objno));
}

function clearTextWindow()
{
	$('.text').empty();
}


function clearInputWindow()
{
	$('.prompt').val('');
}


function writeLocation(locno)
{
	if (locations[locno]!=null) writeText(locations[locno] + STR_NEWLINE); else writeText(STR_NEWLINE + STR_WRONG_LOCATION + ' [' + locno + ']');
}

// Screen control functions

function clearGraphicsWindow()
{
	$('.graphics').empty();	
}


function clearScreen()
{
	clearInputWindow();
	clearTextWindow();
	clearGraphicsWindow();
}

function copyOrderToTextWindow(player_order)
{
	last_player_order = player_order;
	clearInputWindow();
	writeText(STR_PROMPT);
	writelnText(player_order);
}



// Graphics functions


function hideGraphicsWindow()
{
		$('.text').removeClass('half_text');
		$('.text').addClass('all_text');
		$('.graphics').removeClass('half_graphics');
		$('.graphics').addClass('hidden');
		if ($('.location_picture')) $('.location_picture').remove();
}



function drawPicture(picno)  
{
	var pictureDraw = false;
	if (graphicsON) 
	{
		if ((isDarkHere()) && (!lightObjectsPresent())) picno = 0;
		var filename = getResourceById(RESOURCE_TYPE_IMG, picno);
		if (filename)
		{
			$('.graphics').removeClass('hidden');
			$('.graphics').addClass('half_graphics');
			$('.text').removeClass('all_text');
			$('.text').addClass('half_text');
			$('.graphics').html('<img alt="" class="location_picture" src="' +  filename + '" />');
			$('.location_picture').css('height','100%');
			pictureDraw = true;
		}
	}

	if (!pictureDraw) hideGraphicsWindow();
}




function clearPictureAt() // deletes all pictures drawn by "pictureAT" condact
{
	$.each($('.graphics img'), function () {
		if ($(this)[0].className!= 'location_picture') $(this).remove();
	});

}

// Turns functions

function incTurns()
{
	turns = getFlag(FLAG_TURNS_LOW) + 256 * getFlag(FLAG_TURNS_HIGH)  + 1;
	setFlag(FLAG_TURNS_LOW, turns % 256);
	setFlag(FLAG_TURNS_HIGH, Math.floor(turns / 256));
}

// input box functions

function disableInput()
{
	$(".input").prop('disabled', true); 
}

function enableInput()
{
	$(".input").prop('disabled', false); 
}

function focusInput()
{
	$(".prompt").focus();
	timeout_progress = 0;
}

// Object default attributes functions

function objectIsNPC(objno)
{
	if (objno > last_object_number) return false;
	return bittest(getObjectLowAttributes(objno), ATTR_NPC);
}

function objectIsLight(objno)
{
	if (objno > last_object_number) return false;
	return bittest(getObjectLowAttributes(objno), ATTR_LIGHT);
}

function objectIsWearable(objno)
{
	if (objno > last_object_number) return false;
	return bittest(getObjectLowAttributes(objno), ATTR_WEARABLE);
}

function objectIsContainer(objno)
{
	if (objno > last_object_number) return false;
	return bittest(getObjectLowAttributes(objno), ATTR_CONTAINER);
}

function objectIsSupporter(objno)
{
	if (objno > last_object_number) return false;
	return bittest(getObjectLowAttributes(objno), ATTR_SUPPORTER);
}


function objectIsAttr(objno, attrno)
{
	if (attrno > 63) return false;
	attrs = getObjectLowAttributes(objno);
	if (attrno > 31)
	{
		attrs = getObjectHighAttributes(objno);
		attrno = attrno - 32;
	}
	return bittest(attrs, attrno);
}

function isAccesibleContainer(objno)
{
	if (objectIsSupporter(objno)) return true;   // supporter
	if ( objectIsContainer(objno) && !objectIsAttr(objno, ATTR_OPENABLE) ) return true;  // No openable container
	if ( objectIsContainer(objno) && objectIsAttr(objno, ATTR_OPENABLE) && objectIsAttr(objno, ATTR_OPEN)  )  return true;  // No openable & open container
	return false;
}

//Objects and NPC functions

function findMatchingObject(locno)
{
	for (var i=0;i<num_objects;i++)
		if ((locno==-1) || (getObjectLocation(i) == locno))
		 if (((objectsNoun[i]) == getFlag(FLAG_NOUN1)) && (((objectsAdjective[i]) == EMPTY_WORD) || ((objectsAdjective[i]) == getFlag(FLAG_ADJECT1))))  return i;
	return EMPTY_OBJECT;
}

function getReferredObject()
{
	var objectfound = EMPTY_OBJECT; 
	refobject_search: 
	{
		object_id = findMatchingObject(LOCATION_CARRIED);
		if (object_id != EMPTY_OBJECT)	{objectfound = object_id; break refobject_search;}	

		object_id = findMatchingObject(LOCATION_WORN);
		if (object_id != EMPTY_OBJECT)	{objectfound = object_id; break refobject_search;}	

		object_id = findMatchingObject(loc_here());
		if (object_id != EMPTY_OBJECT)	{objectfound = object_id; break refobject_search;}	

		object_id = findMatchingObject(-1);
		if (object_id != EMPTY_OBJECT)	{objectfound = object_id; break refobject_search;}	
	}
	return objectfound;
}


function getObjectLowAttributes(objno)
{
	return objectsAttrLO[objno];
}

function getObjectHighAttributes(objno)
{
	return objectsAttrHI[objno]
}


function setObjectLowAttributes(objno, attrs)
{
	objectsAttrLO[objno] = attrs;
}

function setObjectHighAttributes(objno, attrs)
{
	objectsAttrHI[objno] = attrs;
}


function getObjectLocation(objno)
{
	if (objno > last_object_number) 
		writeText(STR_INVALID_OBJECT + ' [' + objno + ']');
	return objectsLocation[objno];
}

function setObjectLocation(objno, locno)
{
	if (objectsLocation[objno] == LOCATION_CARRIED) setFlag(FLAG_OBJECTS_CARRIED_COUNT, getFlag(FLAG_OBJECTS_CARRIED_COUNT) - 1);
	objectsLocation[objno] = locno;
	if (objectsLocation[objno] == LOCATION_CARRIED) setFlag(FLAG_OBJECTS_CARRIED_COUNT, getFlag(FLAG_OBJECTS_CARRIED_COUNT) + 1);
}



// Sets all flags associated to  referred object by current LS  
function setReferredObject(objno) 
{
	if (objno == EMPTY_OBJECT)
	{
		setFlag(FLAG_REFERRED_OBJECT, EMPTY_OBJECT);
		setFlag(FLAG_REFERRED_OBJECT_LOCATION, LOCATION_NONCREATED);
		setFlag(FLAG_REFERRED_OBJECT_WEIGHT, 0);
		setFlag(FLAG_REFERRED_OBJECT_LOW_ATTRIBUTES, 0);
		setFlag(FLAG_REFERRED_OBJECT_HIGH_ATTRIBUTES, 0);
		return;
	}
	setFlag(FLAG_REFERRED_OBJECT, objno);
	setFlag(FLAG_REFERRED_OBJECT_LOCATION, getObjectLocation(objno));
	setFlag(FLAG_REFERRED_OBJECT_WEIGHT, getObjectWeight(objno));
	setFlag(FLAG_REFERRED_OBJECT_LOW_ATTRIBUTES, getObjectLowAttributes(objno));
	setFlag(FLAG_REFERRED_OBJECT_HIGH_ATTRIBUTES, getObjectHighAttributes(objno));

}


function getObjectWeight(objno) 
{
	var weight = objectsWeight[objno];
	if ( ((objectIsContainer(objno)) || (objectIsSupporter(objno))) && (weight!=0)) // Container with zero weigth are magic boxes, anything you put inside weigths zero
  		weight = weight + getLocationObjectsWeight(objno);
	return weight;
}


function getLocationObjectsWeight(locno) 
{
	var weight = 0;
	for (var i=0;i<num_objects;i++)
	{
		if (getObjectLocation(i) == locno) 
		{
			objweight = objectsWeight[i];
			weight += objweight;
			if (objweight > 0)
			{
				if (  (objectIsContainer(i)) || (objectIsSupporter(i)) )
				{	
					weight += getLocationObjectsWeight(i);
				}
			}
		}
	}
	return weight;
}

function getObjectCountAt(locno) 
{
	var count = 0;
	for (i=0;i<num_objects;i++)
	{
		if (getObjectLocation(i) == locno) 
		{
			attr = getObjectLowAttributes(i);
			if (!bittest(getFlag(FLAG_PARSER_SETTINGS),3)) count ++;  // Parser settings say we should include NPCs as objects
			 else if (!objectIsNPC(i)) count++;     // or object is not an NPC
		}
	}
	return count;
}


function getObjectCountAtWithAttr(locno, attrno) 
{
	var count = 0;
	for (i=0;i<num_objects;i++)
		if (   (getObjectLocation(i) == locno)  && (objectIsAttr(i, attrno))) count++;
	return count;
}


function getNPCCountAt(locno) 
{
	var count = 0;
	for (i=0;i<num_objects;i++)
		if ((getObjectLocation(i) == locno) &&  (objectIsNPC(i))) count++;
	return count;
}


// Location light function

function lightObjectsAt(locno) 
{
	return getObjectCountAtWithAttr(locno, ATTR_LIGHT) > 0;
}


function lightObjectsPresent() 
{
  if (lightObjectsAt(LOCATION_CARRIED)) return true;
  if (lightObjectsAt(LOCATION_WORN)) return true;
  if (lightObjectsAt(loc_here())) return true;
  return false;
}


function isDarkHere()
{
	return (getFlag(FLAG_LIGHT) != 0);
}

// Sound functions


function preloadsfx()
{
	for (var i=0;i<resources.length;i++)
	 	if (resources[i][0] == 'RESOURCE_TYPE_SND') 
	 	{
	 		var fileparts = resources[i][2].split('.');
			var basename = fileparts[0];
			var mySound = new buzz.sound( basename, {  formats: [ "ogg", "mp3" ] , preload: true} );
	 	}
}

function sfxplay(sfxno, channelno, times, method)
{

	if (!soundsON) return;
	if ((channelno <0) || (channelno >MAX_CHANNELS)) return;
	if (times == 0) times = -1; // more than 4000 million times
	var filename = getResourceById(RESOURCE_TYPE_SND, sfxno);
	if (filename)
	{
		var fileparts = filename.split('.');
		var basename = fileparts[0];
		var mySound = new buzz.sound( basename, {  formats: [ "ogg", "mp3" ] });
		if (soundChannels[channelno]) soundChannels[channelno].stop();
		soundLoopCount[channelno] = times;
		mySound.bind("ended", function(e) {
			for (sndloop=0;sndloop<MAX_CHANNELS;sndloop++)
				if (soundChannels[sndloop] == this)
				{
					if (soundLoopCount[sndloop]==-1) {this.play(); return }
					soundLoopCount[sndloop]--;
					if (soundLoopCount[sndloop] > 0) {this.play(); return }
					sfxstop(sndloop);
					return;
				}
		});
		soundChannels[channelno] = mySound;
		if (method=='play')	mySound.play(); else mySound.fadeIn(2000);
	}
}

function playLocationMusic(locno)
{
	if (soundsON) 
		{
			sfxstop(0);
			sfxplay(locno, 0, 0, 'play');
		}
}

function musicplay(musicno, times)  
{
	sfxplay(musicno, 0, times);
}

function channelActive(channelno)
{
	if (soundChannels[channelno]) return true; else return false;
}


function sfxstopall() 
{
	for (channelno=0;channelno<MAX_CHANNELS;channelno++) sfxstop(channelno);

}


function sfxstop(channelno)
{
	if (soundChannels[channelno]) 
		{
			soundChannels[channelno].unbind('ended');
			soundChannels[channelno].stop();
			soundChannels[channelno] = null;
		}
}

function sfxvolume(channelno, value)
{
	if (soundChannels[channelno]) soundChannels[channelno].setVolume(Math.floor( value * 100 / 65535)); // Inherited volume condact uses a number among 0 and 65535, buzz library uses 0-100.
}

function isSFXPlaying(channelno)
{
	if (!soundChannels[channelno]) return false;
	return true;
}


function sfxfadeout(channelno, value)
{
	if (!soundChannels[channelno]) return;
	soundChannels[channelno].fadeOut(value, function() { sfxstop(channelno) });
}

// Process functions

function callProcess(procno)
{
	current_process = procno;
	var prostr = procno.toString(); 
	while (prostr.length < 3) prostr = "0" + prostr;
	if (procno==0) in_response = true;
	if (doall_flag && in_response) done_flag = false;
	if (!in_response) done_flag = false;
	eval("pro" + prostr + "()");
	if (procno==0) in_response = false;
	
}

// Bitwise functions

function bittest(value, bitno)
{
	mask = 1 << bitno;
	return ((value & mask) != 0);
}

function bitset(value, bitno)
{

	mask = 1 << bitno;
	return value | mask;
}

function bitclear(value, bitno)
{
	mask = 1 << bitno;
	return value & (~mask);
}


function bitneg(value, bitno) 
{
	mask = 1 << bitno;
	return value ^ mask;

}

// Savegame functions
function getSaveGameObject()
{
	var savegame_object = new Object();
	// Notice that slice() is used to make sure a copy of each array is assigned to the object, no the arrays themselves
	savegame_object.flags = flags.slice();
	savegame_object.objectsLocation = objectsLocation.slice();
	savegame_object.objectsWeight = objectsWeight.slice();
	savegame_object.objectsAttrLO = objectsAttrLO.slice();
	savegame_object.objectsAttrHI = objectsAttrHI.slice();
	savegame_object.connections = connections.slice();
	savegame_object = h_saveGame(savegame_object);
	return savegame_object;
}

function restoreSaveGameObject(savegame_object)
{
	flags = savegame_object.flags;
	// Notice that slice() is used to make sure a copy of each array is assigned to the object, no the arrays themselves
	objectsLocation = savegame_object.objectsLocation.slice();
	objectsWeight = savegame_object.objectsWeight.slice();
	objectsAttrLO = savegame_object.objectsAttrLO.slice();
	objectsAttrHI = savegame_object.objectsAttrHI.slice();
	connections = savegame_object.connections.slice();
	h_restoreGame(savegame_object);
}



////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                        The parser                                                      //
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


function loadPronounSufixes()
{

    var swapped;

	for (var j=0;j<vocabulary.length;j++) if (vocabulary[j][VOCABULARY_TYPE] == WORDTYPE_PRONOUN)
			 pronoun_suffixes.push(vocabulary[j][VOCABULARY_WORD]);
	// Now sort them so the longest are first, so you rather replace SELOS in (COGESELOS=>COGE SELOS == >TAKE THEM) than LOS (COGESELOS==> COGESE LOS ==> TAKExx THEM) that woul not be understood (COGESE is not a verb, COGE is)
    do {
        swapped = false;
        for (var i=0; i < pronoun_suffixes.length-1; i++) 
        {
            if (pronoun_suffixes[i].length < pronoun_suffixes[i+1].length) 
            {
                var temp = pronoun_suffixes[i];
                pronoun_suffixes[i] = pronoun_suffixes[i+1];
                pronoun_suffixes[i+1] = temp;
                swapped = true;
            }
        }
    } while (swapped);
}


function findVocabulary(word)  // Pending: sort the vocabulary at the beginning so search may be binary at least
{
	for (var j=0;j<vocabulary.length;j++)
		if (vocabulary[j][VOCABULARY_WORD] == word)
			 return vocabulary[j];
	return null;
}

function normalize(player_order)   
// Removes accented characters and makes sure every sentence separator (colon, semicolon, quotes, etc.) has one space before and after. Also, all separators are converted to comma
{
	var originalchars = '';
	var i;
	var output = '';
	var pos;

	for (i=0;i<player_order.length;i++) 
	{
		pos = originalchars.indexOf(player_order.charAt(i));
		if (pos!=-1) output = output + "aeiou".charAt(pos % 5); else 
		{
			ch = player_order.charAt(i);
			if ((ch=='.') || (ch==',') || (ch==';') || (ch=='"') || (ch=='\'')) output = output + ' , '; else output = output + player_order.charAt(i); 
		}

	}
	return output;
}

function toParserBuffer(player_order)  // Converts a player order in a list of sentences separated by dot.
{
     player_order = normalize(player_order);
     player_order = player_order.toUpperCase();
    
	 var words = player_order.split(' ');
	 for (var q=0;q<words.length;q++)
	 {
	 	words[q] = words[q].trim();
	 	if  (words[q]!=',')
	 	{
	 		words[q] = words[q].trim();
	 		foundWord = findVocabulary(words[q]);
	 		if (foundWord)
	 		{
	 			if (foundWord[VOCABULARY_TYPE]==WORDTYPE_CONJUNCTION)
	 			{
	 			words[q] = ','; // Replace conjunctions with dots
		 		} 
	 		}
	 	}
	 }

	 var output = '';
	 for (q=0;q<words.length;q++)
	 {
	 	if (words[q] == ',') output = output + ','; else output = output + words[q] + ' ';
	 }
	 output = output.replace(/ ,/g,',');
	 output = output.trim();
	 player_order_buffer = output;
}

function getSentencefromBuffer()
{
	var sentences = player_order_buffer.split(',');
	var result = sentences[0];
	sentences.splice(0,1);
	player_order_buffer = sentences.join();
	return result;
}

function processPronounSufixes(words)  
{
	// This procedure will split pronominal sufixes into separated words, so COGELA will become COGE LA at the end, and work exactly as TAKE IT does.
	// it's only for spanish so if lang is english then it makes no changes
	if (getLang() == 'EN') return words;
	verbFound = false;
	if (!bittest(getFlag(FLAG_PARSER_SETTINGS),0)) return words;  // If pronoun sufixes inactive, just do nothing
	// First, we clear the word list from any match with pronouns, cause if we already have something that matches pronouns, probably is just concidence, like in COGE LA LLAVE
	var filtered_words = [];
	for (var q=0;q < words.length;q++)
	{
		foundWord = findVocabulary(words[q]);
		if (foundWord) 
			{
				if (foundWord[VOCABULARY_TYPE] != WORDTYPE_PRONOUN) filtered_words[filtered_words.length] = words[q];
			}
			else filtered_words[filtered_words.length] = words[q];
	}
	words = filtered_words;

	// Now let's start trying to get sufixes
	new_words = [];
	for (var k=0;k < words.length;k++)
	{
		words[k] = words[k].trim();
		foundWord = findVocabulary(words[k]);
		if (foundWord) if (foundWord[VOCABULARY_TYPE] == WORDTYPE_VERB) verbFound = true;  // If we found a verb, we don't look for pronoun sufixes, as they have to come together with verb
		suffixFound = false;
		pronunsufix_search:
		for (var l=0;(l<pronoun_suffixes.length) && (!suffixFound) && (!verbFound);l++)
			if (pronoun_suffixes[l] == words[k].rights(pronoun_suffixes[l].length))
			{
				var verb_part = words[k].substring(0,words[k].length - pronoun_suffixes[l].length);
				var checkWord = findVocabulary(verb_part);
				if ((!checkWord)  || (checkWord[VOCABULARY_TYPE] != WORDTYPE_VERB))  // If the part before the supposed-to-be pronoun sufix is not a verb, then is not a pronoun sufix
				{
					new_words.push(words[k]);	
					continue pronunsufix_search;
				}
				new_words.push(verb_part);  // split the word in two parts: verb + pronoun. Since that very moment it works like in english (COGERLO ==> COGER LO as of TAKE IT)
				new_words.push(pronoun_suffixes[l]);
				suffixFound = true;
				verbFound = true;
			}
		if (!suffixFound) new_words.push(words[k]);
	}
	return new_words;
}

function getLogicSentence()
{
	parser_word_found = false; ;
	aux_verb = -1;
	aux_noun1 = -1;
	aux_adject1 = -1;
	aux_adverb = -1;
	aux_pronoun = -1
	aux_pronoun_adject = -1
	aux_preposition = -1;
	aux_noun2 = -1;
	aux_adject2 = -1;
	initializeLSWords();
	SL_found = false;

	order = getSentencefromBuffer();
	setFlag(FLAG_PARSER_SETTINGS, bitclear(getFlag(FLAG_PARSER_SETTINGS),1)); // Initialize flag that says an unknown word was found in the sentence


	words = order.split(" ");
	words = processPronounSufixes(words);
	wordsearch_loop:
	for (var i=0;i<words.length;i++)
	{
		original_word = currentword = words[i];
		if (currentword.length>10) currentword = currentword.substring(0,MAX_WORD_LENGHT);
		foundWord = findVocabulary(currentword);
		if (foundWord)
		{
			wordtype = foundWord[VOCABULARY_TYPE];
			word_id = foundWord[VOCABULARY_ID];

			switch (wordtype)
			{
				case WORDTYPE_VERB: if (aux_verb == -1)  aux_verb = word_id; 
				        			break;

				case WORDTYPE_NOUN: if (aux_noun1 == -1) aux_noun1 = word_id; else if (aux_noun2 == -1) aux_noun2 = word_id;
									break;

				case WORDTYPE_ADJECT: if (aux_adject1 == -1) aux_adject1 = word_id; else if (aux_adject2 == -1) aux_adject2 = word_id;
									  break;

				case WORDTYPE_ADVERB: if (aux_adverb == -1) aux_adverb = word_id;
				        			  break;

				case WORDTYPE_PRONOUN: if (aux_pronoun == -1) 
											{
												aux_pronoun = word_id;
												if ((previous_noun != EMPTY_WORD) && (aux_noun1 == -1))
												{
													aux_noun1 = previous_noun;
													if (previous_adject != EMPTY_WORD) aux_adject1 = previous_adject;
												}
											}

				        			   break;

				case WORDTYPE_CONJUNCTION: break wordsearch_loop; // conjunction or nexus. Should not appear in this function, just added for security
				
				case WORDTYPE_PREPOSITION: if (aux_preposition == -1) aux_preposition = word_id;
										   if (aux_noun1!=-1) setFlag(FLAG_PARSER_SETTINGS, bitset(getFlag(FLAG_PARSER_SETTINGS),2));  // Set bit that determines that a preposition word was found after first noun
										   break;
			}

			// Nouns that can be converted to verbs
			if ((aux_noun1!=-1) && (aux_verb==-1) && (aux_noun1 < NUM_CONVERTIBLE_NOUNS))
			{
				aux_verb = aux_noun1;
				aux_noun1 = -1;
			}

			if ((aux_verb==-1) && (aux_noun1!=-1) && (previous_verb!=EMPTY_WORD)) aux_verb = previous_verb;  // Support "TAKE SWORD AND SHIELD" --> "TAKE WORD AND TAKE SHIELD"

			if ((aux_verb!=-1) || (aux_noun1!=-1) || (aux_adject1!=-1 || (aux_preposition!=-1) || (aux_adverb!=-1))) SL_found = true;



		} else if (aux_verb!=-1) setFlag(FLAG_PARSER_SETTINGS, bitset(getFlag(FLAG_PARSER_SETTINGS),1));  // Set bit that determines that an unknown word was found after the verb
	}

	if (SL_found)
	{
		if (aux_verb != -1) setFlag(FLAG_VERB, aux_verb);
		if (aux_noun1 != -1) setFlag(FLAG_NOUN1, aux_noun1);
		if (aux_adject1 != -1) setFlag(FLAG_ADJECT1, aux_adject1);
		if (aux_adverb != -1) setFlag(FLAG_ADVERB, aux_adverb);
		if (aux_pronoun != -1) 
			{
				setFlag(FLAG_PRONOUN, aux_noun1);
				setFlag(FLAG_PRONOUN_ADJECT, aux_adject1);
			}
			else
			{
				setFlag(FLAG_PRONOUN, EMPTY_WORD);
				setFlag(FLAG_PRONOUN_ADJECT, EMPTY_WORD);
			}
		if (aux_preposition != -1) setFlag(FLAG_PREP, aux_preposition);
		if (aux_noun2 != -1) setFlag(FLAG_NOUN2, aux_noun2);
		if (aux_adject2 != -1) setFlag(FLAG_ADJECT2, aux_adject2);
		setReferredObject(getReferredObject());
		previous_verb = aux_verb;
		if ((aux_noun1!=-1) && (aux_noun1>=NUM_PROPER_NOUNS))
		{
			previous_noun = aux_noun1;
			if (aux_adject1!=-1) previous_adject = aux_adject1;
		}
		
	}
	if ((aux_verb + aux_noun1+ aux_adject1 + aux_adverb + aux_pronoun + aux_preposition + aux_noun2 + aux_adject2) != -8) parser_word_found = true;

	return SL_found;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                        Main functions and main loop                                    //
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


// Interrupt functions

function enableInterrupt()
{
	interruptDisabled = false;
}

function disableInterrupt()
{
	interruptDisabled = true;
}

function timer()
{
	// Timeout control
	timeout_progress=  timeout_progress + 1/32;  //timer happens every 40 milliseconds, but timeout counter should only increase every 1.28 seconds (according to PAWS documentation)
	timeout_length = getFlag(FLAG_TIMEOUT_LENGTH);
	if ((timeout_length) && (timeout_progress> timeout_length))  // time for timeout
	{
		timeout_progress = 0;
		if (($('.prompt').val() == '')  || (($('.prompt').val()!='') && (!bittest(getFlag(FLAG_TIMEOUT_SETTINGS),0))) )  // but first check there is no text type, or is allowed to timeout when text typed already
		{
			setFlag(FLAG_TIMEOUT_SETTINGS, bitset(getFlag(FLAG_TIMEOUT_SETTINGS),7)); // Clears timeout bit
			writeSysMessage(SYSMESS_TIMEOUT);	
			callProcess(PROCESS_TURN);
		}
	}	

	// Interrupt process control
	if (!interruptDisabled)
	if (interruptProcessExists)
	{
		callProcess(interrupt_proc);
		setFlag(FLAG_PARSER_SETTINGS, bitclear(getFlag(FLAG_PARSER_SETTINGS), 4));  // Set bit at flag that marks that a window resize happened 
	}

	// Set timer again
	setTimeout(function (){
	     	timer();
     },TIMER_MILLISECONDS);
}

// Initialize and finalize functions

function farewell()
{
	writeSysMessage(SYSMESS_FAREWELL);
	ACCnewline();
}


function initializeConnections()
{
  connections = [].concat(connections_start);
}

function initializeObjects()
{
  for (i=0;i<objects.length;i++)
  {
  	objectsAttrLO = [].concat(objectsAttrLO_start);
  	objectsAttrHI = [].concat(objectsAttrHI_start);
  	objectsLocation = [].concat(objectsLocation_start);
  	objectsWeight = [].concat(objectsWeight_start);
  }
}

function  initializeLSWords()
{
  setFlag(FLAG_PREP,EMPTY_WORD);
  setFlag(FLAG_NOUN2,EMPTY_WORD);
  setFlag(FLAG_ADJECT2,EMPTY_WORD);
  setFlag(FLAG_PRONOUN,EMPTY_WORD);
  setFlag(FLAG_ADJECT1,EMPTY_WORD);
  setFlag(FLAG_VERB,EMPTY_WORD);
  setFlag(FLAG_NOUN1,EMPTY_WORD);
  setFlag(FLAG_ADJECT1,EMPTY_WORD);
  setFlag(FLAG_ADVERB,EMPTY_WORD);
}


function initializeFlags()
{
  flags = [];
  for (var  i=0;i<FLAG_COUNT;i++) flags.push(0);
  setFlag(FLAG_MAXOBJECTS_CARRIED,4);
  setFlag(FLAG_PARSER_SETTINGS,9); // Pronoun sufixes active, DOALL and others ignore NPCs, etc. 00001001
  setFlag(FLAG_MAXWEIGHT_CARRIED,10);
  initializeLSWords();
  setFlag(FLAG_OBJECT_LIST_FORMAT,64); // List objects in a single sentence (comma separated)
  setFlag(FLAG_OBJECTS_CARRIED_COUNT,carried_objects);  // FALTA: el compilador genera esta variable, hay que cambiarlo en el compilador, ERA numero_inicial_de_objetos_llevados
}

function initializeInternalVars()
{
	num_objects = last_object_number + 1;
	transcript = '';
	timeout_progress = 0;
	previous_noun = EMPTY_WORD;
	previous_verb = EMPTY_WORD;
	previous_adject = EMPTY_WORD;
	player_order_buffer = '';
	last_player_order = '';
	graphicsON = true; 
	soundsON = true; 
	interruptDisabled = false;
	unblock_process = null;
	done_flag = false;
	describe_location_flag =false;
	in_response = false;
	success = false;
	doall_flag = false;
	entry_for_doall	= '';
}

function initializeSound()
{
	sfxstopall();
}




function initialize()
{
	preloadsfx();
	initializeInternalVars();
	initializeSound();
	initializeFlags();
	initializeObjects();
	initializeConnections();
}



// Main loops

function descriptionLoop()
{
	describe_location_flag = false;
	clearTextWindow();
	if ((isDarkHere()) && (!lightObjectsPresent())) writeSysMessage(SYSMESS_ISDARK); else writeLocation(loc_here()); 
	h_description_init();
	playLocationMusic(loc_here());
	if (loc_here()) drawPicture(loc_here()); else hideGraphicsWindow(); // Don't show picture at location 0
	ACCminus(FLAG_AUTODEC2,1);
	if (isDarkHere()) ACCminus(FLAG_AUTODEC3,1);
	if ((isDarkHere()) && (lightObjectsAt(loc_here())==0)) ACCminus(FLAG_AUTODEC4,1);
	callProcess(PROCESS_DESCRIPTION);
	h_description_post();
	if (describe_location_flag) descriptionLoop();
	describe_location_flag = false;
	callProcess(PROCESS_TURN);
	if (describe_location_flag) descriptionLoop();
	describe_location_flag = false;
	focusInput();

}

function orderEnteredLoop(player_order)
{
	previous_verb = EMPTY_WORD;
	setFlag(FLAG_TIMEOUT_SETTINGS, bitclear(getFlag(FLAG_TIMEOUT_SETTINGS),7)); // Clears timeout bit
	if (player_order == '') {writeSysMessage(SYSMESS_SORRY); ACCnewline(); return; };	
	copyOrderToTextWindow(player_order);
	player_order = h_playerOrder(player_order); //hook
	toParserBuffer(player_order);
	do 
	{
		describe_location_flag = false;
		ACCminus(FLAG_AUTODEC5,1);
		ACCminus(FLAG_AUTODEC6,1);
		ACCminus(FLAG_AUTODEC7,1);
		ACCminus(FLAG_AUTODEC8,1);
		if (isDarkHere()) ACCminus(FLAG_AUTODEC9,1);
		if ((isDarkHere()) && (lightObjectsAt(loc_here())==0)) ACCminus(FLAG_AUTODEC10,1);
		
		if (describe_location_flag) 
		{
			descriptionLoop();
			return;
		};

		if (getLogicSentence())
		{
			incTurns();
			done_flag = false;
			callProcess(PROCESS_RESPONSE); // Response table
			if (describe_location_flag) 
			{
				descriptionLoop();
				return;
			};
			if (!done_flag) 
			{
				if ((getFlag(FLAG_VERB)<NUM_CONNECTION_VERBS) && (CNDmove(FLAG_LOCATION)))
				{
					descriptionLoop();
					return;
				} else if (getFlag(FLAG_VERB)<NUM_CONNECTION_VERBS) {writeSysMessage(SYSMESS_WRONGDIRECTION);ACCnewline();}	else {writeSysMessage(SYSMESS_CANTDOTHAT);ACCnewline();};

			}
		} else
		{
			h_invalidOrder(player_order);
			if (parser_word_found) {writeSysMessage(SYSMESS_IDONTUNDERSTAND);   ACCnewline() }
			    		      else {writeSysMessage(SYSMESS_NONSENSE_SENTENCE); ACCnewline() };	
		}  
		callProcess(PROCESS_TURN);
	} while (player_order_buffer !='');
	previous_verb = ''; // Can't use previous verb if a new order is typed (we keep previous noun though, it can be used)
	focusInput();
}


function restart()
{
	location.reload();	
}


function hideBlock()
{
	clearInputWindow();
    $('.block_layer').hide('slow');
    enableInterrupt();   	
    $('.input').show();  
    focusInput();
}
//called when the block layer is closed
function closeBlock()
{
	if (!unblock_process) return;
	hideBlock();
    var proToCall = unblock_process;
	unblock_process = null;
	callProcess(proToCall);
	if (describe_location_flag) descriptionLoop();
}

// Exacution starts here, called by the html file on document.ready()
function start()
{
	h_init(); //hook
	$('.graphics').addClass('half_graphics');
	$('.text').addClass('half_text');
	if (isBadIE()) alert(STR_BADIE)
	loadPronounSufixes();	

	// Assign keypress action for input box (detect enter key press)
	$('.prompt').keypress(function(e) {  
    	if (e.which == 13) 
    	{ 
    		player_order = $('.prompt').val();
    		if (player_order.charAt(0) == '#')
    		{
    			addToTranscript(player_order + STR_NEWLINE);
    			clearInputWindow();
    		} 
    		else
    		if (player_order!='') 
    				orderEnteredLoop(player_order);
    	}
    });

	// Assign arrow up key press to recover last order
    $('.prompt').keyup( function(e) {
    	if (e.which  == 38) $('.prompt').val(last_player_order);
    });

    //Detect resize to change flag 12
     $(window).resize(function () {
     	setFlag(FLAG_PARSER_SETTINGS, bitset(getFlag(FLAG_PARSER_SETTINGS), 4));  // Set bit at flag that marks that a window resize happened 
     	clearPictureAt();
     	return;
     });


     // assign any click on block layer --> close it
     $(document).click( function(e) {
     	if (unblock_process!=null)
     	{
     		closeBlock();
     		e.preventDefault();
     		return;
     	}

     	if ((anykey_return_function!=null) && (getkey_return_flag==null))  // return for ANYKEY, accepts mouse click
     	{
     		waitKeyCallback();
     		e.preventDefault();
     		return;
    	}

     });
     

	$(document).keydown(function(e) {

		h_keydown(e); // hook

		// if keypress and block displayed, close it
     	if (unblock_process!=null)
     		{
     			closeBlock();
     			e.preventDefault();
     			return;
     		}

		if ((anykey_return_function!=null) && (getkey_return_flag!=null))  // return for getkey
     	{
     		setFlag(getkey_return_flag, e.keyCode);
     		getkey_return_flag = null;
     		waitKeyCallback();
     		e.preventDefault();
     		return;
      	}


     	if ((anykey_return_function!=null) && (getkey_return_flag==null))  // return for anykey
     	{
     		waitKeyCallback();
     		e.preventDefault();
     		return;
     	}

     	

     	// if ESC pressed and transcript layer visible, close it
     	if (($('.transcript_layer').css('display')  !== 'none') &&  (e.keyCode == 27)  ) 
     		{
     			$('.transcript_layer').hide();
     			e.preventDefault();
     			return;
     		}


	});

	initialize();
	descriptionLoop();
	focusInput();
	
	h_post();  //hook

    // Start interrupt process
    setTimeout(function (){
    	timer();
    },TIMER_MILLISECONDS);

}


// VOCABULARY

vocabulary = [];
vocabulary.push([2, "A", 6]);
vocabulary.push([11, "ABAJO", 1]);
vocabulary.push([57, "ABANDONA", 0]);
vocabulary.push([57, "ABANDONAR", 0]);
vocabulary.push([43, "ABRE", 0]);
vocabulary.push([43, "ABRIR", 0]);
vocabulary.push([82, "ACARICIA", 0]);
vocabulary.push([82, "ACARICIAR", 0]);
vocabulary.push([78, "ACERCAR", 0]);
vocabulary.push([78, "ACERCATE", 0]);
vocabulary.push([101, "ACOSTAR", 0]);
vocabulary.push([101, "ACUESTA", 0]);
vocabulary.push([101, "ACUESTATE", 0]);
vocabulary.push([95, "AD", 0]);
vocabulary.push([193, "ADORNO", 1]);
vocabulary.push([193, "ADORNOS", 1]);
vocabulary.push([26, "AGOSTINE", 1]);
vocabulary.push([107, "AGUA", 1]);
vocabulary.push([100, "AGUJERO", 1]);
vocabulary.push([150, "ALFOMBRA", 1]);
vocabulary.push([50, "ANTORCHA", 1]);
vocabulary.push([45, "APAGA", 0]);
vocabulary.push([45, "APAGAR", 0]);
vocabulary.push([99, "APARTA", 0]);
vocabulary.push([99, "APARTAR", 0]);
vocabulary.push([87, "APRETAR", 0]);
vocabulary.push([87, "APRIETA", 0]);
vocabulary.push([59, "ARBOL", 1]);
vocabulary.push([84, "ARBOLES", 1]);
vocabulary.push([86, "ARENQUE", 1]);
vocabulary.push([60, "ARRANCA", 0]);
vocabulary.push([60, "ARRANCAR", 0]);
vocabulary.push([10, "ARRIBA", 1]);
vocabulary.push([52, "ASOMAR", 0]);
vocabulary.push([52, "ASOMARSE", 0]);
vocabulary.push([52, "ASOMARTE", 0]);
vocabulary.push([52, "ASOMATE", 0]);
vocabulary.push([98, "ATACA", 0]);
vocabulary.push([98, "ATACAR", 0]);
vocabulary.push([93, "ATRAVESAR", 0]);
vocabulary.push([93, "ATRAVIESA", 0]);
vocabulary.push([137, "AUTO", 1]);
vocabulary.push([137, "AUTOMOVIL", 1]);
vocabulary.push([137, "AUTOMOVILE", 1]);
vocabulary.push([137, "AUTOS", 1]);
vocabulary.push([143, "AVISO", 1]);
vocabulary.push([39, "AYUDA", 0]);
vocabulary.push([39, "AYUDAME", 0]);
vocabulary.push([11, "BAJA", 0]);
vocabulary.push([11, "BAJAR", 0]);
vocabulary.push([8, "BAJO", 6]);
vocabulary.push([75, "BANCO", 1]);
vocabulary.push([178, "BARROTES", 1]);
vocabulary.push([72, "BAUL", 1]);
vocabulary.push([68, "BEBE", 0]);
vocabulary.push([68, "BEBER", 0]);
vocabulary.push([25, "BECKHAM", 1]);
vocabulary.push([84, "BESA", 0]);
vocabulary.push([84, "BESAR", 0]);
vocabulary.push([199, "BIBLIOTECA", 1]);
vocabulary.push([23, "BM", 1]);
vocabulary.push([38, "BOING", 0]);
vocabulary.push([78, "BOSQUE", 1]);
vocabulary.push([53, "BOTA", 0]);
vocabulary.push([53, "BOTAR", 0]);
vocabulary.push([142, "BOTON", 1]);
vocabulary.push([23, "BRIAN", 1]);
vocabulary.push([73, "BUCEA", 0]);
vocabulary.push([73, "BUCEAR", 0]);
vocabulary.push([171, "BUHARDILLA", 1]);
vocabulary.push([97, "BUZON", 1]);
vocabulary.push([96, "CAAD", 0]);
vocabulary.push([89, "CAJA", 1]);
vocabulary.push([172, "CAJAS", 1]);
vocabulary.push([89, "CAJITA", 1]);
vocabulary.push([88, "CAJON", 1]);
vocabulary.push([141, "CALLE", 1]);
vocabulary.push([133, "CALLEJON", 1]);
vocabulary.push([56, "CAMA", 1]);
vocabulary.push([119, "CAMINO", 1]);
vocabulary.push([119, "CAMINOS", 1]);
vocabulary.push([121, "CAMPANA", 1]);
vocabulary.push([121, "CAMPANILLA", 1]);
vocabulary.push([99, "CANDADO", 1]);
vocabulary.push([37, "CANTA", 0]);
vocabulary.push([37, "CANTAR", 0]);
vocabulary.push([52, "CAPUCHA", 1]);
vocabulary.push([27, "CARGA", 0]);
vocabulary.push([27, "CARGAR", 0]);
vocabulary.push([135, "CARRETERA", 1]);
vocabulary.push([135, "CARRETERAS", 1]);
vocabulary.push([92, "CARTA", 1]);
vocabulary.push([58, "CASA", 1]);
vocabulary.push([106, "CASCADA", 1]);
vocabulary.push([129, "CASETA", 1]);
vocabulary.push([153, "CASETES", 1]);
vocabulary.push([153, "CASETS", 1]);
vocabulary.push([153, "CASETTES", 1]);
vocabulary.push([153, "CASSETES", 1]);
vocabulary.push([153, "CASSETTES", 1]);
vocabulary.push([56, "CATRE", 1]);
vocabulary.push([156, "CD", 1]);
vocabulary.push([156, "CD-ROM", 1]);
vocabulary.push([156, "CDROM", 1]);
vocabulary.push([74, "CERILLA", 1]);
vocabulary.push([89, "CERILLAS", 1]);
vocabulary.push([42, "CERRAR", 0]);
vocabulary.push([117, "CHAMPINON", 1]);
vocabulary.push([117, "CHAMPION", 1]);
vocabulary.push([108, "CHARCA", 1]);
vocabulary.push([108, "CHARCO", 1]);
vocabulary.push([168, "CHEST", 1]);
vocabulary.push([66, "CHIMENEA", 1]);
vocabulary.push([42, "CIERRA", 0]);
vocabulary.push([153, "CINTAS", 1]);
vocabulary.push([50, "CIRIO", 1]);
vocabulary.push([134, "CIUDAD", 1]);
vocabulary.push([79, "CLARO", 1]);
vocabulary.push([164, "CLOSE", 1]);
vocabulary.push([137, "COCHE", 1]);
vocabulary.push([188, "COCHERA", 1]);
vocabulary.push([137, "COCHES", 1]);
vocabulary.push([64, "COCINA", 1]);
vocabulary.push([24, "COCINERO", 1]);
vocabulary.push([22, "COFRE", 1]);
vocabulary.push([20, "COGE", 0]);
vocabulary.push([21, "COGELA", 0]);
vocabulary.push([21, "COGELO", 0]);
vocabulary.push([20, "COGER", 0]);
vocabulary.push([59, "COLOCA", 0]);
vocabulary.push([59, "COLOCAR", 0]);
vocabulary.push([83, "COLUMNA", 1]);
vocabulary.push([83, "COLUMNAS", 1]);
vocabulary.push([81, "COME", 0]);
vocabulary.push([81, "COMER", 0]);
vocabulary.push([81, "COMETE", 0]);
vocabulary.push([224, "COMPUTADOR", 1]);
vocabulary.push([9, "CON", 6]);
vocabulary.push([217, "COPA", 1]);
vocabulary.push([104, "CORCHO", 1]);
vocabulary.push([62, "CORTA", 0]);
vocabulary.push([62, "CORTAR", 0]);
vocabulary.push([186, "CORTINA", 1]);
vocabulary.push([186, "CORTINAJES", 1]);
vocabulary.push([186, "CORTINAS", 1]);
vocabulary.push([8, "CORTO", 2]);
vocabulary.push([159, "CPU", 1]);
vocabulary.push([24, "CRIADO", 1]);
vocabulary.push([91, "CRISTAL", 1]);
vocabulary.push([96, "CRUCE", 1]);
vocabulary.push([88, "CRUZA", 0]);
vocabulary.push([88, "CRUZAR", 0]);
vocabulary.push([213, "CUADRO", 1]);
vocabulary.push([213, "CUADROS", 1]);
vocabulary.push([58, "CUARTO", 1]);
vocabulary.push([90, "CUERDA", 1]);
vocabulary.push([90, "CUERDAS", 1]);
vocabulary.push([90, "CUERDECILL", 1]);
vocabulary.push([179, "CUERPO", 1]);
vocabulary.push([6, "CUIDADOSAM", 3]);
vocabulary.push([75, "DA", 0]);
vocabulary.push([75, "DAR", 0]);
vocabulary.push([3, "DE", 6]);
vocabulary.push([31, "DECIR", 0]);
vocabulary.push([51, "DEJA", 0]);
vocabulary.push([51, "DEJAR", 0]);
vocabulary.push([51, "DEPOSITA", 0]);
vocabulary.push([51, "DEPOSITAR", 0]);
vocabulary.push([61, "DESATA", 0]);
vocabulary.push([61, "DESATAR", 0]);
vocabulary.push([107, "DESAZ", 0]);
vocabulary.push([35, "DESCANSA", 0]);
vocabulary.push([35, "DESCANSAR", 0]);
vocabulary.push([51, "DESCARGA", 0]);
vocabulary.push([51, "DESCARGAR", 0]);
vocabulary.push([11, "DESCENDER", 0]);
vocabulary.push([11, "DESCIENDE", 0]);
vocabulary.push([100, "DESCOLGAR", 0]);
vocabulary.push([100, "DESCUELGA", 0]);
vocabulary.push([5, "DESDE", 6]);
vocabulary.push([107, "DESHACER", 0]);
vocabulary.push([86, "DESMONTA", 0]);
vocabulary.push([86, "DESMONTAR", 0]);
vocabulary.push([210, "DESPACHO", 1]);
vocabulary.push([83, "DESPERTAR", 0]);
vocabulary.push([83, "DESPIERTA", 0]);
vocabulary.push([66, "DESTAPAR", 0]);
vocabulary.push([192, "DESTINATAR", 1]);
vocabulary.push([192, "DESTINO", 1]);
vocabulary.push([171, "DESVAN", 1]);
vocabulary.push([66, "DETAPA", 0]);
vocabulary.push([31, "DI", 0]);
vocabulary.push([51, "DIARIO", 1]);
vocabulary.push([192, "DIRECCION", 1]);
vocabulary.push([154, "DISCO", 1]);
vocabulary.push([154, "DISKETTE", 1]);
vocabulary.push([154, "DISQUETTE", 1]);
vocabulary.push([195, "DISTRIBUID", 1]);
vocabulary.push([27, "DOCTOR", 1]);
vocabulary.push([162, "DOOR", 1]);
vocabulary.push([35, "DORMIR", 0]);
vocabulary.push([35, "DUERME", 0]);
vocabulary.push([6, "DURA", 2]);
vocabulary.push([6, "DURO", 2]);
vocabulary.push([48, "DWALIN", 0]);
vocabulary.push([4, "E", 1]);
vocabulary.push([4, "EAST", 1]);
vocabulary.push([67, "ECHA", 0]);
vocabulary.push([67, "ECHAR", 0]);
vocabulary.push([136, "EDIFICIO", 1]);
vocabulary.push([136, "EDIFICIOS", 1]);
vocabulary.push([192, "ELDRAD", 1]);
vocabulary.push([47, "ELEVA", 0]);
vocabulary.push([88, "ELEVADOR", 1]);
vocabulary.push([47, "ELEVAR", 0]);
vocabulary.push([103, "ELEXIR", 1]);
vocabulary.push([25, "ELFO", 1]);
vocabulary.push([147, "ELFOS", 1]);
vocabulary.push([103, "ELIXIR", 1]);
vocabulary.push([36, "EMPUJA", 0]);
vocabulary.push([36, "EMPUJAR", 0]);
vocabulary.push([4, "EN", 6]);
vocabulary.push([44, "ENCENDER", 0]);
vocabulary.push([44, "ENCHUFA", 0]);
vocabulary.push([44, "ENCHUFAR", 0]);
vocabulary.push([44, "ENCIENDE", 0]);
vocabulary.push([90, "ENJABONA", 0]);
vocabulary.push([92, "ENJABONAME", 0]);
vocabulary.push([90, "ENJABONAR", 0]);
vocabulary.push([92, "ENJABONARM", 0]);
vocabulary.push([92, "ENJABONARS", 0]);
vocabulary.push([92, "ENJABONART", 0]);
vocabulary.push([92, "ENJABONATE", 0]);
vocabulary.push([63, "ENSERES", 1]);
vocabulary.push([2, "ENTONCES", 5]);
vocabulary.push([50, "ENTRA", 0]);
vocabulary.push([50, "ENTRAR", 0]);
vocabulary.push([75, "ENTREGA", 0]);
vocabulary.push([75, "ENTREGAR", 0]);
vocabulary.push([202, "ESCALERA", 1]);
vocabulary.push([203, "ESCALERAS", 1]);
vocabulary.push([185, "ESCALON", 1]);
vocabulary.push([89, "ESCRIBE", 0]);
vocabulary.push([89, "ESCRIBIR", 0]);
vocabulary.push([41, "ESCUCHA", 0]);
vocabulary.push([41, "ESCUCHAR", 0]);
vocabulary.push([41, "ESCUCHARLA", 0]);
vocabulary.push([41, "ESCUCHARLO", 0]);
vocabulary.push([46, "ESPERA", 0]);
vocabulary.push([46, "ESPERAR", 0]);
vocabulary.push([176, "ESPUMA", 1]);
vocabulary.push([196, "ESTANCIA", 1]);
vocabulary.push([196, "ESTANCIAS", 1]);
vocabulary.push([214, "ESTANTE", 1]);
vocabulary.push([214, "ESTANTES", 1]);
vocabulary.push([147, "ESTATUA", 1]);
vocabulary.push([147, "ESTATUAS", 1]);
vocabulary.push([4, "ESTE", 1]);
vocabulary.push([190, "ESTETOSCOP", 1]);
vocabulary.push([222, "ETIQUETA", 1]);
vocabulary.push([30, "EX", 0]);
vocabulary.push([30, "EXAM", 0]);
vocabulary.push([30, "EXAMINA", 0]);
vocabulary.push([103, "EXAMINAME", 0]);
vocabulary.push([30, "EXAMINAR", 0]);
vocabulary.push([103, "EXAMINARSE", 0]);
vocabulary.push([103, "EXAMINATE", 0]);
vocabulary.push([12, "EXCEPTO", 6]);
vocabulary.push([58, "FACHADA", 1]);
vocabulary.push([150, "FELPUDO", 1]);
vocabulary.push([147, "FIGURA", 1]);
vocabulary.push([147, "FIGURAS", 1]);
vocabulary.push([25, "FIN", 0]);
vocabulary.push([126, "FLOR", 1]);
vocabulary.push([193, "FLORAL", 1]);
vocabulary.push([125, "FLORES", 1]);
vocabulary.push([74, "FOSFORO", 1]);
vocabulary.push([55, "FOTO", 1]);
vocabulary.push([55, "FOTOGRAFIA", 1]);
vocabulary.push([55, "FOTOS", 1]);
vocabulary.push([103, "FRASCO", 1]);
vocabulary.push([91, "FROTA", 0]);
vocabulary.push([109, "FROTAME", 0]);
vocabulary.push([91, "FROTAR", 0]);
vocabulary.push([109, "FROTARME", 0]);
vocabulary.push([109, "FROTARSE", 0]);
vocabulary.push([109, "FROTARTE", 0]);
vocabulary.push([109, "FROTATE", 0]);
vocabulary.push([146, "FUENTE", 1]);
vocabulary.push([13, "FUERTE", 2]);
vocabulary.push([66, "FUMERAL", 1]);
vocabulary.push([188, "GARAJE", 1]);
vocabulary.push([140, "GENTE", 1]);
vocabulary.push([192, "GOLDRIN", 1]);
vocabulary.push([63, "GOLPEA", 0]);
vocabulary.push([63, "GOLPEAR", 0]);
vocabulary.push([52, "GORRA", 1]);
vocabulary.push([52, "GORRO", 1]);
vocabulary.push([26, "GRABA", 0]);
vocabulary.push([26, "GRABAR", 0]);
vocabulary.push([110, "GRAFICOS", 0]);
vocabulary.push([3, "GRANDE", 2]);
vocabulary.push([162, "GREEN", 1]);
vocabulary.push([12, "GRIS", 2]);
vocabulary.push([132, "GUARIDA", 1]);
vocabulary.push([206, "GUISO", 1]);
vocabulary.push([25, "GUTI", 1]);
vocabulary.push([58, "HABITACION", 1]);
vocabulary.push([31, "HABLAR", 0]);
vocabulary.push([6, "HACIA", 6]);
vocabulary.push([101, "HELECHOS", 1]);
vocabulary.push([39, "HELP", 0]);
vocabulary.push([152, "HERRAMIENT", 1]);
vocabulary.push([58, "HOGAR", 1]);
vocabulary.push([118, "HOJAS", 1]);
vocabulary.push([117, "HONGO", 1]);
vocabulary.push([207, "HORNO", 1]);
vocabulary.push([115, "HORTENSIA", 1]);
vocabulary.push([115, "HORTENSIAS", 1]);
vocabulary.push([72, "HUELE", 0]);
vocabulary.push([24, "HUMANO", 1]);
vocabulary.push([140, "HUMANOS", 1]);
vocabulary.push([14, "I", 1]);
vocabulary.push([55, "IMAGEN", 1]);
vocabulary.push([55, "IMAGENES", 1]);
vocabulary.push([216, "INFORME", 1]);
vocabulary.push([59, "INSERTA", 0]);
vocabulary.push([59, "INSERTAR", 0]);
vocabulary.push([59, "INTRODUCE", 0]);
vocabulary.push([59, "INTRODUCIR", 0]);
vocabulary.push([14, "INVEN", 1]);
vocabulary.push([14, "INVENTARIO", 1]);
vocabulary.push([98, "INVERNADER", 1]);
vocabulary.push([173, "JABON", 1]);
vocabulary.push([184, "JARDIN", 1]);
vocabulary.push([204, "JARRA", 1]);
vocabulary.push([2, "LA", 4]);
vocabulary.push([108, "LAGO", 1]);
vocabulary.push([108, "LAGUNA", 1]);
vocabulary.push([200, "LAMPARA", 1]);
vocabulary.push([200, "LAMPARAS", 1]);
vocabulary.push([76, "LANZA", 0]);
vocabulary.push([76, "LANZAR", 0]);
vocabulary.push([9, "LARGA", 2]);
vocabulary.push([9, "LARGO", 2]);
vocabulary.push([2, "LAS", 4]);
vocabulary.push([2, "LE", 4]);
vocabulary.push([32, "LEE", 0]);
vocabulary.push([32, "LEER", 0]);
vocabulary.push([3, "LENTAMENTE", 3]);
vocabulary.push([2, "LES", 4]);
vocabulary.push([47, "LEVANTA", 0]);
vocabulary.push([47, "LEVANTAR", 0]);
vocabulary.push([53, "LIBRO", 1]);
vocabulary.push([54, "LIBROS", 1]);
vocabulary.push([105, "LIQUIDO", 1]);
vocabulary.push([115, "LIRIO", 1]);
vocabulary.push([115, "LIRIOS", 1]);
vocabulary.push([56, "LITERA", 1]);
vocabulary.push([79, "LLAMA", 0]);
vocabulary.push([79, "LLAMAR", 0]);
vocabulary.push([71, "LLAVE", 1]);
vocabulary.push([71, "LLENA", 0]);
vocabulary.push([71, "LLENAR", 0]);
vocabulary.push([2, "LO", 4]);
vocabulary.push([27, "LOAD", 0]);
vocabulary.push([24, "LOOK", 0]);
vocabulary.push([2, "LOS", 4]);
vocabulary.push([24, "M", 0]);
vocabulary.push([113, "MACETA", 1]);
vocabulary.push([61, "MAGICOS", 1]);
vocabulary.push([166, "MAP", 1]);
vocabulary.push([57, "MARTILLO", 1]);
vocabulary.push([77, "MATA", 0]);
vocabulary.push([77, "MATAR", 0]);
vocabulary.push([24, "MAYORDOMO", 1]);
vocabulary.push([57, "MAZO", 1]);
vocabulary.push([189, "MECANISMO", 1]);
vocabulary.push([38, "MEGASALTO", 0]);
vocabulary.push([208, "MESA", 1]);
vocabulary.push([208, "MESAS", 1]);
vocabulary.push([123, "MESILLA", 1]);
vocabulary.push([123, "MESITA", 1]);
vocabulary.push([59, "METE", 0]);
vocabulary.push([59, "METER", 0]);
vocabulary.push([180, "MI", 1]);
vocabulary.push([24, "MIRA", 0]);
vocabulary.push([24, "MIRAR", 0]);
vocabulary.push([103, "MIRARSE", 0]);
vocabulary.push([103, "MIRARTE", 0]);
vocabulary.push([103, "MIRATE", 0]);
vocabulary.push([10, "MISTERIOSA", 2]);
vocabulary.push([74, "MISTO", 1]);
vocabulary.push([74, "MISTOS", 1]);
vocabulary.push([85, "MOJA", 0]);
vocabulary.push([85, "MOJAR", 0]);
vocabulary.push([157, "MONITOR", 1]);
vocabulary.push([56, "MONTA", 0]);
vocabulary.push([80, "MONTANA", 1]);
vocabulary.push([80, "MONTANAS", 1]);
vocabulary.push([56, "MONTAR", 0]);
vocabulary.push([80, "MONTAA", 1]);
vocabulary.push([80, "MONTAAS", 1]);
vocabulary.push([106, "MORDER", 0]);
vocabulary.push([36, "MOVER", 0]);
vocabulary.push([201, "MUEBLES", 1]);
vocabulary.push([106, "MUERDE", 0]);
vocabulary.push([36, "MUEVE", 0]);
vocabulary.push([2, "N", 1]);
vocabulary.push([73, "NADA", 0]);
vocabulary.push([73, "NADAR", 0]);
vocabulary.push([6, "NE", 1]);
vocabulary.push([21, "NINFA", 1]);
vocabulary.push([147, "NINOS", 1]);
vocabulary.push([147, "NIOS", 1]);
vocabulary.push([7, "NO", 1]);
vocabulary.push([6, "NORESTE", 1]);
vocabulary.push([7, "NOROESTE", 1]);
vocabulary.push([2, "NORTE", 1]);
vocabulary.push([2, "NORTH", 1]);
vocabulary.push([6, "NORTHEAST", 1]);
vocabulary.push([7, "NORTHWEST", 1]);
vocabulary.push([149, "NOTA", 1]);
vocabulary.push([90, "NUDO", 1]);
vocabulary.push([5, "NUEVA", 2]);
vocabulary.push([5, "NUEVO", 2]);
vocabulary.push([7, "NW", 1]);
vocabulary.push([5, "O", 1]);
vocabulary.push([61, "OBJETOS", 1]);
vocabulary.push([5, "OESTE", 1]);
vocabulary.push([75, "OFRECE", 0]);
vocabulary.push([75, "OFRECER", 0]);
vocabulary.push([41, "OIR", 0]);
vocabulary.push([72, "OLER", 0]);
vocabulary.push([163, "OPEN", 1]);
vocabulary.push([224, "ORDENADOR", 1]);
vocabulary.push([100, "ORIFICIO", 1]);
vocabulary.push([110, "ORILLA", 1]);
vocabulary.push([110, "ORILLAS", 1]);
vocabulary.push([111, "OROGRAFIA", 1]);
vocabulary.push([41, "OYE", 0]);
vocabulary.push([115, "PALMERA", 1]);
vocabulary.push([115, "PALMERAS", 1]);
vocabulary.push([157, "PANTALLA", 1]);
vocabulary.push([191, "PANUELO", 1]);
vocabulary.push([212, "PAPELES", 1]);
vocabulary.push([10, "PARA", 6]);
vocabulary.push([76, "PARAGUAS", 1]);
vocabulary.push([177, "PARED", 1]);
vocabulary.push([177, "PAREDES", 1]);
vocabulary.push([148, "PARQUE", 1]);
vocabulary.push([93, "PASA", 0]);
vocabulary.push([198, "PASAMANOS", 1]);
vocabulary.push([93, "PASAR", 0]);
vocabulary.push([209, "PASILLO", 1]);
vocabulary.push([173, "PASTILLA", 1]);
vocabulary.push([68, "PATINES", 1]);
vocabulary.push([191, "PAUELO", 1]);
vocabulary.push([63, "PEGA", 0]);
vocabulary.push([63, "PEGAR", 0]);
vocabulary.push([2, "PEQUEA", 2]);
vocabulary.push([2, "PEQUEO", 2]);
vocabulary.push([51, "PERIODICO", 1]);
vocabulary.push([80, "PICO", 1]);
vocabulary.push([80, "PICOS", 1]);
vocabulary.push([87, "PIEDRA", 1]);
vocabulary.push([95, "PIEDRAS", 1]);
vocabulary.push([83, "PILAR", 1]);
vocabulary.push([83, "PILARES", 1]);
vocabulary.push([114, "PIMIENTA", 1]);
vocabulary.push([28, "PLANTA", 1]);
vocabulary.push([101, "PLANTAS", 1]);
vocabulary.push([28, "PLANTITA", 1]);
vocabulary.push([77, "PLATAFORMA", 1]);
vocabulary.push([115, "PLATANERO", 1]);
vocabulary.push([21, "PON", 0]);
vocabulary.push([21, "PONER", 0]);
vocabulary.push([21, "PONTE", 0]);
vocabulary.push([11, "POR", 6]);
vocabulary.push([77, "PORCHE", 1]);
vocabulary.push([220, "PORTATIL", 1]);
vocabulary.push([51, "PRENSA", 1]);
vocabulary.push([206, "PUCHERO", 1]);
vocabulary.push([69, "PUERTA", 1]);
vocabulary.push([215, "PUERTAS", 1]);
vocabulary.push([87, "PULSA", 0]);
vocabulary.push([87, "PULSAR", 0]);
vocabulary.push([64, "QUEMA", 0]);
vocabulary.push([64, "QUEMAR", 0]);
vocabulary.push([25, "QUIT", 0]);
vocabulary.push([22, "QUITA", 0]);
vocabulary.push([22, "QUITAR", 0]);
vocabulary.push([22, "QUITATE", 0]);
vocabulary.push([29, "RAMLOAD", 0]);
vocabulary.push([28, "RAMSAVE", 0]);
vocabulary.push([223, "RANURA", 1]);
vocabulary.push([223, "RANURAS", 1]);
vocabulary.push([2, "RAPIDAMENT", 3]);
vocabulary.push([195, "RECIBIDOR", 1]);
vocabulary.push([100, "REGADERA", 1]);
vocabulary.push([74, "REGAR", 0]);
vocabulary.push([97, "REGISTRA", 0]);
vocabulary.push([97, "REGISTRAR", 0]);
vocabulary.push([65, "RELOJ", 1]);
vocabulary.push([69, "REPARA", 0]);
vocabulary.push([69, "REPARAR", 0]);
vocabulary.push([58, "RETIRA", 0]);
vocabulary.push([58, "RETIRAR", 0]);
vocabulary.push([55, "RETRATO", 1]);
vocabulary.push([55, "RETRATOS", 1]);
vocabulary.push([109, "RIACHUELO", 1]);
vocabulary.push([74, "RIEGA", 0]);
vocabulary.push([221, "RINCON", 1]);
vocabulary.push([109, "RIO", 1]);
vocabulary.push([21, "RO", 1]);
vocabulary.push([130, "ROCA", 1]);
vocabulary.push([130, "ROCAS", 1]);
vocabulary.push([11, "ROJO", 2]);
vocabulary.push([94, "ROMPE", 0]);
vocabulary.push([94, "ROMPER", 0]);
vocabulary.push([60, "ROPA", 1]);
vocabulary.push([60, "ROPAS", 1]);
vocabulary.push([126, "ROSA", 1]);
vocabulary.push([115, "ROSAL", 1]);
vocabulary.push([115, "ROSALES", 1]);
vocabulary.push([126, "ROSAS", 1]);
vocabulary.push([21, "ROSI", 1]);
vocabulary.push([89, "ROTULA", 0]);
vocabulary.push([174, "ROTULADOR", 1]);
vocabulary.push([89, "ROTULAR", 0]);
vocabulary.push([5, "RUIDOSAMEN", 3]);
vocabulary.push([94, "RUTA", 1]);
vocabulary.push([94, "RUTAS", 1]);
vocabulary.push([3, "S", 1]);
vocabulary.push([58, "SACA", 0]);
vocabulary.push([58, "SACAR", 0]);
vocabulary.push([49, "SAL", 0]);
vocabulary.push([127, "SALCHICHA", 1]);
vocabulary.push([105, "SALIDAS", 0]);
vocabulary.push([49, "SALIR", 0]);
vocabulary.push([197, "SALON", 1]);
vocabulary.push([53, "SALTA", 0]);
vocabulary.push([53, "SALTAR", 0]);
vocabulary.push([40, "SALTO", 0]);
vocabulary.push([113, "SALTOBET", 0]);
vocabulary.push([205, "SARTEN", 1]);
vocabulary.push([26, "SAVE", 0]);
vocabulary.push([8, "SE", 1]);
vocabulary.push([70, "SELLA", 0]);
vocabulary.push([70, "SELLAR", 0]);
vocabulary.push([144, "SEMAFORO", 1]);
vocabulary.push([94, "SENDA", 1]);
vocabulary.push([94, "SENDAS", 1]);
vocabulary.push([119, "SENDERO", 1]);
vocabulary.push([119, "SENDEROS", 1]);
vocabulary.push([108, "SENTAR", 0]);
vocabulary.push([108, "SENTARSE", 0]);
vocabulary.push([117, "SETA", 1]);
vocabulary.push([225, "SI", 1]);
vocabulary.push([108, "SIENTATE", 0]);
vocabulary.push([35, "SIESTEAR", 0]);
vocabulary.push([4, "SILENCIOSA", 3]);
vocabulary.push([218, "SILLON", 1]);
vocabulary.push([9, "SO", 1]);
vocabulary.push([13, "SOBRE", 6]);
vocabulary.push([51, "SOLTAR", 0]);
vocabulary.push([52, "SOMBRERO", 1]);
vocabulary.push([3, "SOUTH", 1]);
vocabulary.push([8, "SOUTHEAST", 1]);
vocabulary.push([9, "SOUTHWEST", 1]);
vocabulary.push([7, "SUAVE", 2]);
vocabulary.push([10, "SUBE", 0]);
vocabulary.push([10, "SUBIR", 0]);
vocabulary.push([8, "SUDESTE", 1]);
vocabulary.push([120, "SUELO", 1]);
vocabulary.push([51, "SUELTA", 0]);
vocabulary.push([51, "SUELTALA", 0]);
vocabulary.push([51, "SUELTALO", 0]);
vocabulary.push([38, "SUPERSALTO", 0]);
vocabulary.push([3, "SUR", 1]);
vocabulary.push([8, "SURESTE", 1]);
vocabulary.push([9, "SUROESTE", 1]);
vocabulary.push([9, "SW", 1]);
vocabulary.push([165, "TAKE", 1]);
vocabulary.push([102, "TALA", 0]);
vocabulary.push([102, "TALAR", 0]);
vocabulary.push([61, "TALLER", 1]);
vocabulary.push([15, "TAPA", 1]);
vocabulary.push([65, "TAPAR", 0]);
vocabulary.push([104, "TAPON", 1]);
vocabulary.push([70, "TAPONA", 0]);
vocabulary.push([70, "TAPONAR", 0]);
vocabulary.push([194, "TAXI", 1]);
vocabulary.push([194, "TAXIS", 1]);
vocabulary.push([82, "TECHO", 1]);
vocabulary.push([82, "TECHUMBRE", 1]);
vocabulary.push([158, "TECLADO", 1]);
vocabulary.push([89, "TECLEA", 0]);
vocabulary.push([89, "TECLEAR", 0]);
vocabulary.push([82, "TEJADO", 1]);
vocabulary.push([82, "TEJAS", 1]);
vocabulary.push([211, "TELEFONO", 1]);
vocabulary.push([93, "TELEGRAMA", 1]);
vocabulary.push([29, "TERMITA", 1]);
vocabulary.push([111, "TERRENO", 1]);
vocabulary.push([161, "THORIN", 1]);
vocabulary.push([181, "TI", 1]);
vocabulary.push([138, "TIENDA", 1]);
vocabulary.push([138, "TIENDAS", 1]);
vocabulary.push([113, "TIESTO", 1]);
vocabulary.push([121, "TIMBRE", 1]);
vocabulary.push([76, "TIRA", 0]);
vocabulary.push([76, "TIRAR", 0]);
vocabulary.push([80, "TOCA", 0]);
vocabulary.push([80, "TOCAR", 0]);
vocabulary.push([116, "TOCON", 1]);
vocabulary.push([20, "TODO", 1]);
vocabulary.push([170, "TRAMPILLA", 1]);
vocabulary.push([6, "TRANQUILAM", 3]);
vocabulary.push([104, "TRANSCRIBE", 0]);
vocabulary.push([104, "TRANSCRIBI", 0]);
vocabulary.push([7, "TRAS", 6]);
vocabulary.push([171, "TRASTERO", 1]);
vocabulary.push([182, "TRASTO", 1]);
vocabulary.push([182, "TRASTOS", 1]);
vocabulary.push([55, "TREPA", 0]);
vocabulary.push([55, "TREPAR", 0]);
vocabulary.push([131, "TRIDENTE", 1]);
vocabulary.push([167, "TROLL", 1]);
vocabulary.push([116, "TRONCO", 1]);
vocabulary.push([91, "TROZO", 1]);
vocabulary.push([67, "VACIA", 0]);
vocabulary.push([67, "VACIAR", 0]);
vocabulary.push([85, "VACIO", 1]);
vocabulary.push([145, "VALLA", 1]);
vocabulary.push([81, "VALLE", 1]);
vocabulary.push([101, "VEGETACION", 1]);
vocabulary.push([50, "VELA", 1]);
vocabulary.push([70, "VENTANA", 1]);
vocabulary.push([183, "VENTANAS", 1]);
vocabulary.push([175, "VENTILADOR", 1]);
vocabulary.push([30, "VER", 0]);
vocabulary.push([145, "VERJA", 1]);
vocabulary.push([67, "VERTER", 0]);
vocabulary.push([94, "VIA", 1]);
vocabulary.push([94, "VIAS", 1]);
vocabulary.push([111, "VIDEO", 0]);
vocabulary.push([91, "VIDRIO", 1]);
vocabulary.push([4, "VIEJA", 2]);
vocabulary.push([4, "VIEJO", 2]);
vocabulary.push([67, "VIERTE", 0]);
vocabulary.push([5, "W", 1]);
vocabulary.push([169, "WAIT", 1]);
vocabulary.push([5, "WEST", 1]);
vocabulary.push([54, "X", 0]);
vocabulary.push([33, "XYZZY", 0]);
vocabulary.push([2, "Y", 5]);
vocabulary.push([46, "Z", 0]);
vocabulary.push([23, "ZORRO", 1]);
vocabulary.push([35, "ZZZ", 0]);



// SYS MESSAGES

total_sysmessages=68;

sysmessages = [];

sysmessages[0] = "No puedes ver nada, est muy oscuro.\n";
sysmessages[1] = "Llama especialmente tu atencin ";
sysmessages[2] = "Qu haces?      \n";
sysmessages[3] = "Y bien?\n";
sysmessages[4] = "Qu ms?       \n";
sysmessages[5] = "Tus rdenes:\n";
sysmessages[6] = "Cmo? Por favor prueba con otras palabras.\n";
sysmessages[7] = "No puedes ir en esa direccin.\n";
sysmessages[8] = "Perdn?\n";
sysmessages[9] = "Llevas:     ";
sysmessages[10] = " (puesto/a)";
sysmessages[11] = "ningn objeto.\n";
sysmessages[12] = "Seguro? \n";
sysmessages[13] = "Juegas de nuevo? \n";
sysmessages[14] = "Adis...";
sysmessages[15] = "OK.\n";
sysmessages[16] = "";
sysmessages[17] = "Has realizado ";
sysmessages[18] = " turno";
sysmessages[19] = "s";
sysmessages[20] = ".\n";
sysmessages[21] = "Tu puntuacin es del ";
sysmessages[22] = "%.\n";
sysmessages[23] = "No llevas puesto eso.\n";
sysmessages[24] = "No puedes, ya llevas eso puesto.\n";
sysmessages[25] = "Ya tienes {OREF}.\n";
sysmessages[26] = "No ves eso por aqu.\n";
sysmessages[27] = "No puedes llevar ms cosas.\n";
sysmessages[28] = "No tienes eso.\n";
sysmessages[29] = "Pero si ya llevas puesto {OREF}.\n";
sysmessages[30] = "S";
sysmessages[31] = "N";
sysmessages[32] = "Ms...";
sysmessages[33] = "> ";
sysmessages[34] = "";
sysmessages[35] = "El tiempo pasa...\n";
sysmessages[36] = "Coges {OREF}.\n";
sysmessages[37] = "Te pones {OREF}.\n";
sysmessages[38] = "Te quitas {OREF}.\n";
sysmessages[39] = "Dejas {OREF}.\n";
sysmessages[40] = "No puedes ponerte {OREF}.\n";
sysmessages[41] = "No puedes quitarte {OREF}.\n";
sysmessages[42] = "No puedes quitarte {OREF}.  Tienes demasiadas cosas en las manos!\n";
sysmessages[43] = "Desgraciadamente {OREF} pesa demasiado.\n";
sysmessages[44] = "Pones {OREF} en ";
sysmessages[45] = "Me temo que {OREF} no est en ";
sysmessages[46] = ", ";
sysmessages[47] = " y ";
sysmessages[48] = ".\n";
sysmessages[49] = "No tienes {OREF}.\n";
sysmessages[50] = "No llevas puesto {OREF}.\n";
sysmessages[51] = ".\n";
sysmessages[52] = "Eso no est en ";
sysmessages[53] = "ningn objeto\n";
sysmessages[54] = "Fichero no encontrado.\n";
sysmessages[55] = "Fichero corrupto.\n";
sysmessages[56] = "Error de E/S. Fichero no grabado.\n";
sysmessages[57] = "Directorio lleno.\n";
sysmessages[58] = "Disco lleno.\n";
sysmessages[59] = "Nombre de fichero no vlido.\n";
sysmessages[60] = "Nombre del fichero: ";
sysmessages[61] = "";
sysmessages[62] = "Perdn? Por favor prueba con otras palabras.\n";
sysmessages[63] = "";
sysmessages[64] = "";
sysmessages[65] = "";
sysmessages[66] = "";
sysmessages[67] = "";

// USER MESSAGES

total_messages=20;

messages = [];

messages[0] = "La balsa est desierta!";
messages[1] = "Por el Gran Zurcidor! Un Gnomo sin sombrero! No ha llegado an el da en que pueda ver esto.";
messages[2] = "Como todo buen Gnomo Zapatero (GZ) tu vela permanece nida a tu sombrero... y ah debe quedarse!";
messages[3] = "Las fotos de tus mltiples viajes (la Feria del Calzado Menudo en China, el cruzero por los fiordos noruegos, la visita a Erebor para ver a tu primo Glin) se mezclan con fotos de tu infancia (cumpleaos, tu primer bao) y aquella en la que posas orgulloso junto con el Zapatero Potentado (ZP), presidente... del gremio de los Gnomos Zapateros.";
messages[4] = "No tiene nada ms destacable.";
messages[5] = "Tu estantera no puede albergar el gran monton de libros que has acumulado a lo largo de los aos. Amontonados, del derecho o del reves, en estraos ngulos, tu libros reposan esperando el momento en que vuelvas a releerlos. Tus gustos literarios son eclcticos: historia antigua, biografas, un par de libros tcnicos...";
messages[6] = "Uno de los libros, que permaneca en un precario equilibrio cae al suelo.";
messages[7] = "Se trata de un pequeo libro, breve, no muy grueso, una edicin barata que compraste en un mercadillo de segunda mano. Uno de los escasos lbros humanos que conservas en tu biblioteca.";
messages[8] = "Lees la primera pgina: ";
messages[9] = "Stanislaw Lem, Ciberada, Expedicin tercera o los dragones de la probabilidad";
messages[10] = "Ttulo del original en polaco (humano): Cyberiada";
messages[11] = "Traduccin al gnmico: Jadwiga Mauricio";
messages[12] = "Editorial: Alianza";
messages[13] = "'Trurl y Clapaucio eran alumnos del gran Cerebrn Emtadrata, quien durante cuarenta y siete aos haba enseado en la Escuela Superior de Nentica la Teoria General de Dragones. Como sabemos, los dragones no existen. Esta constatacin simplista es, tal vez, suficiente para una mentalidad primaria, pero no para la ciencia. La Escuela Superior de Nentica no se ocupa de lo que existe: la banalidad de la existencia ha sido probada hace demasiados aos para que valga la pena dedicarle una palabra ms. As pues, el genial Cerebrn atac el problema con mtodos exactos descubriendo tres clases de dragones: los iguales a cero, los imaginarios y los negativos. Todos ellos, como antes dijimos, no existen, pero cada clase lo hace de manera completamente distinta. Los dragones imaginarios y ceracos, no existen, pero de modo mucho menos interesante que los negativos. Desde hace mucho tiempo se conoce en la dragonologa una paradoja, consistente en el hecho de que, si se herboriza a dos negativos (operacin correspondiente en el lgebra de dragones a la multiplicacin en la aritmtica corriente), se obtiene como resultado un infradragn en la cantidad 0,6 aproximadamente. A partir de este fenmeno, el mundillo de los especialistas se divida en dos campos, de los cuales uno sostena que se trataba de la parte de dragn contando desde la cabeza, y el segundo afirmaba que haba que contar desde la cola.'";
messages[14] = "'Trurl y Clapaucio tuvieron el gran mrito de esclarecer lo errneo de ambas teoras. Fueron ellos quienes aplicaron por primera vez el clculo de probabilidades a esta rama de la ciencia, creando, gracias a ello, la dragonologa probabilstica. Esta ltima demostr que el dragn era termodinmicamente imposible slo en el sentido estadstico, al igual que los elfos, duendes, gnmos, hadas, etc. Los dos cientficos calcularon en base a la frmula general de la improbabilidad los coeficientes del duendismos, de la elfiacin, etc. La misma frmula demuestra que para presenciar la manifestacin espontnea de un dragn habra que esperar diecisis quintocuatrillones de heptillones de aos ms o menos. No cabe duda de que el problema hubiera quedado como un simple curiosum matermtico, si no fuera por la convencida pasin constructora de Trurl, quien decidi investigar la cuestin empricamente. Y puesto que se trataba de fenmenos improbables, invent un amplificador de la probabilidad y lo comprob, primero en el stano de su casa y luego en un Polgono Dragonfero especial, Dragolign, costeado por la Academia.'";
messages[15] = "La afirmacin en el ltimo prrrafo sobre que los gnmos somos 'termodinmicamente imposibles slo en el sentido estadstico', te ha dejado bastante confundido y te convence de dejar el libro para una mejor ocasin.";
messages[16] = "o mejor: dani.carbonell@gmail.com   ";
messages[17] = "Metes _ dentro del cajn del elevador.";
messages[18] = " Est en el interior del cajn del elevador.";
messages[19] = "En la pantalla aparece el siguiente mensaje:";

// WRITE MESSAGES

total_writemessages=1879;

writemessages = [];

writemessages[0] = "Indica GRAFICOS SI para jugar con grficos, GRAFICOS NO para jugar sin grficos.\n";
writemessages[1] = "Fuerzas la vista, pero no consigues distinguir nada en esta penumbra...\n";
writemessages[2] = "Est demasiado oscuro para hacer nada aqu dentro! Empiezas a asustarte y solo piensas en salir.\n";
writemessages[3] = "Sales de casa de Agostine...\n";
writemessages[4] = "Parece que viene alguien!\n";
writemessages[5] = "Dos elfos! Aqu, en medio de la Gran Ciudad!\n";
writemessages[6] = "Intentas escabullirte tras la fuente...\n";
writemessages[7] = "-A l!-grita uno de los elfos, el que parece el jefe.\n";
writemessages[8] = "Intentas huir, pero tus cortas piernas no son rival para el elfo de la corbata...\n";
writemessages[9] = "-Noooo!!-gritas mientras el elfo te agarra y te levanta en vilo...\n";
writemessages[10] = "El elfo te tapa boca y nariz con un pauelo y te entra una repentina somnolencia...\n";
writemessages[11] = "Antes de dormirte alcanzas a or...\n";
writemessages[12] = "-Seor, lleva el CD.\n";
writemessages[13] = "-Muy bien, el seor Goldrin estar satisfecho...\n";
writemessages[14] = "Duermes...\n";
writemessages[15] = "Eso no puedes meterlo en el ordenador.\n";
writemessages[16] = "Eso no puedes meterlo en el ordenador.\n";
writemessages[17] = "Eso no puedes meterlo en el ordenador.\n";
writemessages[18] = "Mejor por la parte de fuera.\n";
writemessages[19] = "La caja de cartn no est por aqu.\n";
writemessages[20] = "No llevas el objeto adecuado.\n";
writemessages[21] = "Ya lo hiciste.\n";
writemessages[22] = "Con letras bien gordas escribes en la tapa de la caja: A la atencin personal de MR. ELDRAD GOLDRIN, Rochester 960, Gran Ciudad.\n";
writemessages[23] = "Tan apretado ests que mejor salir primero y sacarlo desde fuera.\n";
writemessages[24] = "No alcanzas!\n";
writemessages[25] = "No alcanzas!\n";
writemessages[26] = "No alcanzas!\n";
writemessages[27] = "No alcanzas!\n";
writemessages[28] = "Debes desmontar primero...\n";
writemessages[29] = "No la llevas contigo.\n";
writemessages[30] = "Metes la regadera en el cajn del elevador.\n";
writemessages[31] = "Metes la regadera en el cajn del elevador... tan torpemente que vuelca y se vaca.\n";
writemessages[32] = "No la llevas contigo.\n";
writemessages[33] = "No tiene mucho sentido meter cosas ah dentro, no?\n";
writemessages[34] = "El aroma es evocador...\n";
writemessages[35] = "El aroma es evocador...\n";
writemessages[36] = "No ests especialmente cansado ahora...\n";
writemessages[37] = "No parece que vayas a ver mucho ms subido ah.\n";
writemessages[38] = "'Pepito Grillo Inc'\n";
writemessages[39] = "El aroma del guiso te hace recordar que no has comido en todo el da...\n";
writemessages[40] = "No puedes meter cosas dentro de la caja de cerillas, es demasiado pequea.\n";
writemessages[41] = "O no est a tu alcance o no se puede mover.\n";
writemessages[42] = "Est firmemente sujeta a la pared.\n";
writemessages[43] = "Temes que se ahogara si lo dejas ah dentro.\n";
writemessages[44] = "No se de que ests hablando.\n";
writemessages[45] = "Primero debes abrirla.\n";
writemessages[46] = "Primero tendra que estar abierta.\n";
writemessages[47] = "No quieres dejar nada tuyo en esa caja fuerte, suficiente han robado los elfos a los gnomos a lo largo de los tiempos como para que se queden con algo ms.\n";
writemessages[48] = "Sacas el CD-Rom del interior de la caja fuerte.\n";
writemessages[49] = "El CD-Rom ya no est en el interior de la caja fuerte.\n";
writemessages[50] = "No ves eso en el interior de la caja fuerte.\n";
writemessages[51] = "Con lo que te cost abrirla no parece lo ms inteligente cerrarla ahora.\n";
writemessages[52] = "Por desgracia ya est cerrada.\n";
writemessages[53] = "La caja fuerte ya est abierta.\n";
writemessages[54] = "No lo tienes entre manos en este momento...\n";
writemessages[55] = "Te sientes un poco estpido mientras te colocas el estetoscopio y lo acercas a la caja fuerte...\n";
writemessages[56] = "'No puede ser tan difcil' - piensas, al fin y al cabo lo has visto hacer cientos de veces en las pelculas.\n";
writemessages[57] = "Al fin, con la ayuda del estetoscopio consigues la combinacin correcta y la caja se abre con un hidrulico PUFFFF.\n";
writemessages[58] = "Lo intentas, pero no lo consigues. No es tan fcil abrir una caja fuerte sin saber la combinacin. Qu objeto podra ayudarte?\n";
writemessages[59] = "Creo que ni incluso eso le despertara... lo mejor sera dejarlo descansar.\n";
writemessages[60] = "Para cargarlo antes tienes que bajar del elevador.\n";
writemessages[61] = "No tienes sitio para dejarlo en el cajn del elevador, y no quieres soltarlo desde aqu hasta el suelo, podra hacerse dao.\n";
writemessages[62] = "El elfo te vera!\n";
writemessages[63] = "No llegara encendida hasta esa horrible boca.\n";
writemessages[64] = "No te atreves a acercarte!\n";
writemessages[65] = "No te atreves a acercarte!\n";
writemessages[66] = "Ya te deshiciste de l.\n";
writemessages[67] = "No consigues romperlo! Y encima te ganas un buen dolor de muelas...\n";
writemessages[68] = "Qu quieres sacar de la caja?\n";
writemessages[69] = "No quieres daar el invernadero del Doctor!\n";
writemessages[70] = "No quieres daar el invernadero del Doctor!\n";
writemessages[71] = "No quieres daar el invernadero del Doctor!\n";
writemessages[72] = "La puerta est cerrada por el viejo candado, intentas abrirlo con la llave, pero a simple vista ya se puede ver que esa llave no abrir ese candado.\n";
writemessages[73] = "Golpeas la puerta, pero asegurada por el candado resiste tus esfuerzos.\n";
writemessages[74] = "Cuelga a un lado casi cayndose, mejor no tocarla mucho...\n";
writemessages[75] = "No creo que nadie acudiera a abrirte.\n";
writemessages[76] = "Cierras el paraguas antes de entrar a la seta...\n";
writemessages[77] = "No quieres correr el riesgo de perderlo...\n";
writemessages[78] = "As sea pues...\n";
writemessages[79] = "Diez puntos menos de prestigio aventurero!\n";
writemessages[80] = "Coger cualquier objeto de este limbo-dnde-todo-lo-que-se-pierde-cae puede que te ayude a terminar la aventura, pero ser un borrn en tu historial aventurero. Todo lo que aqu se encuentra puedes conseguirlo de una forma ms honrada. No sera mejor pensar un poco cmo conseguir aquello que aqu tienes al alcance de tu mano?\n";
writemessages[81] = "La caja de cerillas mejor que permanezca cerrada hasta el momento de abrir la cerilla. La gran caja de cartn la abres y cierras segn te conviene.\n";
writemessages[82] = "Cuando quieras encender una cerilla la abrirs. Mientras mejor que permanezca cerrada.\n";
writemessages[83] = "La caja de cerillas permanece cerrada... para que no se escape ninguna!. La gran caja de cartn la abres y cierras segn te conviene.\n";
writemessages[84] = "La caja de cerillas permanece cerrada... para que no se escape ninguna!\n";
writemessages[85] = "Pero, si no est aqu.\n";
writemessages[86] = "Demasiado tcnicos para ti.\n";
writemessages[87] = "Son muy viejos! Y adems, demasiado pesados.\n";
writemessages[88] = "Sin duda demasiado pesado.\n";
writemessages[89] = "Arrastrar muebles provocara un ruido enorme que no quieres hacer.\n";
writemessages[90] = "Arrastrar muebles provocara un ruido enorme que no quieres hacer.\n";
writemessages[91] = "Arrastrar muebles provocara un ruido enorme que no quieres hacer.\n";
writemessages[92] = "Arrastrar muebles provocara un ruido enorme que no quieres hacer.\n";
writemessages[93] = "No alcanzas.\n";
writemessages[94] = "El elfo la sostiene an entre sus dedos. Sera peligroso quitrsela, quin sabe si despertara.\n";
writemessages[95] = "Ahora mismo lo importante es escapar de aqu.\n";
writemessages[96] = "Son demasiados.\n";
writemessages[97] = "No tienes.\n";
writemessages[98] = "Te bebes toda el agua de la regadera de un trago.\n";
writemessages[99] = "Miras en la regadera, pero est vaca.\n";
writemessages[100] = "Te bebes toda el agua de la regadera de un trago.\n";
writemessages[101] = "Miras en la regadera, pero est vaca.\n";
writemessages[102] = "As no conseguirs nunca que vuelva a ser amigo tuyo.\n";
writemessages[103] = "Ja! No podras enfrentarte a un zorro ni aunque quisieras.\n";
writemessages[104] = "BM es tu mascota, y le tienes mucho aprecio. Porqu hacer una cosa as?\n";
writemessages[105] = "El elfo ya est profundamente dormido.\n";
writemessages[106] = "No se te ocurre como.\n";
writemessages[107] = "Tendras que inmovilizarlo durante un tiempo para poder hacerlo... y no veo como!\n";
writemessages[108] = "El elfo ya est profundamente dormido.\n";
writemessages[109] = "No se te ocurre como.\n";
writemessages[110] = "Tendras que inmovilizarlo durante un tiempo para poder hacerlo... y no veo como!\n";
writemessages[111] = "Son viejos y pesados, y no te gustan.\n";
writemessages[112] = "No encentras nada de utilidad. Suerte haber encontrado tus cosas aqu.\n";
writemessages[113] = "No entiendes nada.\n";
writemessages[114] = "Siendo tan pequea e indefensa?\n";
writemessages[115] = "No dispones ni de hacha, ni tijeras ni sierra, pero aunque los tuvieras... No te atreves a acercarte!\n";
writemessages[116] = "No dispones ni de hacha, ni tijeras ni sierra, pero aunque los tuvieras... No te atreves a acercarte!\n";
writemessages[117] = "Hay tantos que necesitaras toda una vida.\n";
writemessages[118] = "Debes coger primero la caja de cerillas.\n";
writemessages[119] = "La caja de cerillas est vaca.\n";
writemessages[120] = "Si quieres encender una cerilla prueba con 'encender cerilla', si no quieres encenderla no te va a servir de nada fuera de la caja.\n";
writemessages[121] = "Debes coger primero la caja de cerillas.\n";
writemessages[122] = "La caja de cerillas est vaca.\n";
writemessages[123] = "Si quieres encender una cerilla prueba con 'encender cerilla', si no quieres encenderla no te va a servir de nada fuera de la caja.\n";
writemessages[124] = "Necesitas llevarlo contigo!\n";
writemessages[125] = "No ests en el sitio adecuado.\n";
writemessages[126] = "Acuestas a Agostine sobre tu catre...\n";
writemessages[127] = "Lo arropas y en su cara te parece ver una expresin de tranquilidad que no habas visto desde hace aos. No hay nada para un gnomo como descansar en un buen hogar gnomo...\n";
writemessages[128] = "Te sientas en la cama mientras acaricias la cara de Agostine... 'En que lo te has metido Agostine, en que lo te has metido...'\n";
writemessages[129] = "Poco a poco el cansancio va haciendo mella en ti...\n";
writemessages[130] = "Te duermes...\n";
writemessages[131] = "Caes...\n\n";
writemessages[132] = "Te persigue una planta carnvora...\n\n";
writemessages[133] = "Y un pirata malcarado...\n\n";
writemessages[134] = "Y dos autos deportivos...\n\n";
writemessages[135] = "Y los dos elfos! Estn aqu!\n\n";
writemessages[136] = "Rudolph! Rudolphine!\n\n";
writemessages[137] = "Rudolphine, despierta dormiln!\n\n";
writemessages[138] = "-Agostine? Agostine!\n";
writemessages[139] = "-Coge tu martillo Rudolph, no tenemos tiempo que perder!\n";
writemessages[140] = "clearTextWindow()";
writemessages[141] = "-Eh, eh! Espera un momento Agostine, tienes mucho que explicarme. Primero que nada, aqu tienes, tu CD, puedes decirme en que lo te has metido, y de paso a mi?\n";
writemessages[142] = "-Esto, si, el cd-rom... bueno, eso no tiene mucha importancia ahora...\n";
writemessages[143] = "-Cmo? Que no tiene importancia? Agostine, he puesto en peligro mi vida para recuperar este CD y tu me dices que no tiene importancia?!\n";
writemessages[144] = "clearTextWindow()";
writemessages[145] = "-El CD era solo una tapadera Rudolphine... No recordaba lo obtuso de mente que eras...\n";
writemessages[146] = "-Agostine! Te juro que...!\n";
writemessages[147] = "-Calla Rudolph, y preprate hemos de salir!\n";
writemessages[148] = "-No pienso ir a ninguna parte si no me cuentas que pasa Agostine.\n";
writemessages[149] = "-El Doctor Rudolph! No te das cuenta que la clave de todo est en el Doctor! Los elfos lo han secuestrado... creo que se lo han llevado a Amrica. No tenemos tiempo que perder, te lo explicar por el camino.\n";
writemessages[150] = "Agostine sale corriendo de la casa y oyes desde fuera:\n";
writemessages[151] = "-Donde has dejado ese maldito paraguas Rudolph?\n";
writemessages[152] = "clearTextWindow()";
writemessages[153] = "Por el Gran Zurcidor! Parece que esto no era ms que el comienzo de las aventuras de Rudolphine Rur.\n";
writemessages[154] = "Pero eso ser en otra ocasin.\n";
writemessages[155] = "Muchas gracias por jugar!\n\n";
writemessages[156] = "Necesitas llevarlo contigo!\n";
writemessages[157] = "No ests en el sitio adecuado.\n";
writemessages[158] = "Acuestas a Agostine sobre tu catre...\n";
writemessages[159] = "Lo arropas y en su cara te parece ver una expresin de tranquilidad que no habas visto desde hace aos. No hay nada para un gnomo como descansar en un buen hogar gnomo...\n";
writemessages[160] = "Te sientas en la cama mientras acaricias la cara de Agostine... 'En que lo te has metido Agostine, en que lo te has metido...'\n";
writemessages[161] = "Poco a poco el cansancio va haciendo mella en ti...\n";
writemessages[162] = "Te duermes...\n";
writemessages[163] = "Caes...\n\n";
writemessages[164] = "Te persigue una planta carnvora...\n\n";
writemessages[165] = "Y un pirata malcarado...\n\n";
writemessages[166] = "Y dos autos deportivos...\n\n";
writemessages[167] = "Y los dos elfos! Estn aqu!\n\n";
writemessages[168] = "Rudolph! Rudolphine!\n\n";
writemessages[169] = "Rudolphine, despierta dormiln!\n\n";
writemessages[170] = "-Agostine? Agostine!\n";
writemessages[171] = "-Coge tu martillo Rudolph, no tenemos tiempo que perder!\n";
writemessages[172] = "-Eh, eh! Espera un momento Agostine, tienes mucho que explicarme. Primero que nada, aqu tienes, tu CD, puedes decirme en que lo te has metido, y de paso a mi?\n";
writemessages[173] = "-Esto, si, el cd-rom... bueno, eso no tiene mucha importancia ahora...\n";
writemessages[174] = "-Cmo? Que no tiene importancia? Agostine, he puesto en peligro mi vida para recuperar este CD y tu me dices que no tiene importancia?!\n";
writemessages[175] = "-El CD era solo una tapadera Rudolphine... No recordaba lo obtuso de mente que eras...\n";
writemessages[176] = "-Agostine! Te juro que...!\n";
writemessages[177] = "-Calla Rudolph, y preprate hemos de salir!\n";
writemessages[178] = "-No pienso ir a ninguna parte si no me cuentas que pasa Agostine.\n";
writemessages[179] = "-El Doctor Rudolph! No te das cuenta que la clave de todo est en el Doctor! Los elfos lo han secuestrado... creo que se lo han llevado a Amrica. No tenemos tiempo que perder, te lo explicar por el camino.\n";
writemessages[180] = "Agostine sale corriendo de la casa y oyes desde fuera:\n";
writemessages[181] = "-Donde has dejado ese maldito paraguas Rudolph?\n";
writemessages[182] = "Por el Gran Zurcidor! Parece que esto no era ms que el comienzo de las aventuras de Rudolphine Rur.\n";
writemessages[183] = "Pero eso ser en otra ocasin.\n";
writemessages[184] = "Muchas gracias por jugar!\n\n";
writemessages[185] = "Ser mejor que acuestes a Agostine... parece que necesita ms de la cama que t.\n";
writemessages[186] = "En su estado no ests del todo seguro que realizara el pequeo vuelo hasta el porche de forma correcta. Ser mejor que subis juntos.\n";
writemessages[187] = "No lo llevas cargado.\n";
writemessages[188] = "Si consigues despertar a Agostine no piensas volver a salir del Valle en muuuucho tiempo.\n";
writemessages[189] = "BM se merece un descanso despus de cargar con dos pesados gnomos desde la Gran Ciudad humana.\n";
writemessages[190] = "BM se merece un descanso despus de cargar con dos pesados gnomos desde la Gran Ciudad humana.\n";
writemessages[191] = "No tienes el CD-Rom en tu poder.\n";
writemessages[192] = "Balanceas el CD delante de la (gran) nariz de Agostine: 'Eh Agostine, lo tengo, lo tengo'... pero es intil, mientras permanezca en este estado no se dar cuenta.\n";
writemessages[193] = "No puedes irte sin Agostine!\n";
writemessages[194] = "No puedes irte sin recuperar el CD!\n";
writemessages[195] = "'Ya es hora de que abandonemos esta maldita casa' piensas mientras afianzndote a Agostine en la espalda cruzas la verja...\n";
writemessages[196] = "Pero ahora, que hars? Tan solo eres un diminuto gnomo perdido en medio del gran mundo humano, cargando con un hermano dormido y con un cd que tan slo el Zurcidor sabe que contiene...\n";
writemessages[197] = "Adems, aquellos dos no tardarn en despertar... y su ira ser terrible!\n";
writemessages[198] = "Te sientas desanimado en la acera pensando que poder hacer...\n";
writemessages[199] = "Suspiro...\n";
writemessages[200] = "Graaan Suspiro...\n";
writemessages[201] = "Un momento!\n";
writemessages[202] = "Puede ser? Es posible?\n";
writemessages[203] = "BM! Tu fiel zorro! Lo acaricias y lo abrazas mientras BM te relame, a ti y a Agostine (no puedes evitar una pizca de envidia cuando compruebas que parece hacer ms caso a Agostine que a ti).\n";
writemessages[204] = "-Oh BM! Como has llegado hasta aqu? Nos has seguido?\n";
writemessages[205] = "BM te mira y te parece notar un extrao poso de inteligencia en el fondo de sus sonrientes ojos. Nunca volvers a dudar del olfato de un zorro nacido en el Valle... ni de su lealtad!\n";
writemessages[206] = "Montas en BM y con menos dificultades de la previstas acomodas a Agostine en el lomo del zorro.\n";
writemessages[207] = "-Llvanos a casa BM!-exclamas con alegra.\n";
writemessages[208] = "BM atraviesa raudo la ciudad...\n";
writemessages[209] = "Sobre su lomo sorteis las nevadas cumbres de las montaas...\n";
writemessages[210] = "Y por fin... el Valle. Has conseguido volver a casa con Agostine sano y salvo...\n";
writemessages[211] = "Sano y salvo y dormido como un tronco!\n";
writemessages[212] = "Lo mejor ser que lo lleves a casa y lo acuestes. Quiz el efecto se le pase pasado un tiempo...\n";
writemessages[213] = "Desmontas a BM y vuelves a cargar a Agostine sobre tu ya dolorida espalda.\n";
writemessages[214] = "Con lo que te ha costado encontrarlo no vas a deshacerte de l ahora.\n";
writemessages[215] = "Aparte de la ya descubierta caja fuerte detrs de los cuadros no encuentras sino polvo.\n";
writemessages[216] = "Aparte de la ya descubierta caja fuerte detrs de los cuadros no encuentras sino polvo.\n";
writemessages[217] = "Aparte de la ya descubierta caja fuerte detrs de los cuadros no encuentras sino polvo.\n";
writemessages[218] = "Tras uno de ellos descubres como habas supuesto una caja fuerte.\n";
writemessages[219] = "Tras uno de ellos descubres como habas supuesto una caja fuerte.\n";
writemessages[220] = "Tras uno de ellos descubres como habas supuesto una caja fuerte.\n";
writemessages[221] = "Temes que el elfo te descubra si te adentras demasiado en la habitacin.\n";
writemessages[222] = "Temes que el elfo te descubra si te adentras demasiado en la habitacin.\n";
writemessages[223] = "Temes que el elfo te descubra si te adentras demasiado en la habitacin.\n";
writemessages[224] = "Temes que si dejas algo el elfo te oiga y se percate de tu presencia. Te estremeces al pensar que haran esta vez contigo si descubren que escapaste del desvn.\n";
writemessages[225] = "Temes que el elfo te descubra si te adentras demasiado en la habitacin.\n";
writemessages[226] = "Creo que no quedaran bien con la decoracin de tu hogar.\n";
writemessages[227] = "Temes que el elfo te descubra si te adentras demasiado en la habitacin.\n";
writemessages[228] = "Para entrar en la estancia contigua tendras que pasar prcticamente por delante de las narices del elfo...\n";
writemessages[229] = "Utilizar el ordenador de Agostine ya fue bastante angustioso para ti, no quieres volver a intentarlo.\n";
writemessages[230] = "No te interesa.\n";
writemessages[231] = "No puedes acercarte al telfono mientras el elfo est aqu.\n";
writemessages[232] = "Piensas por un momento utilizar el telfono... Pero en realidad no se te ocurre a quien llamar... Poca gente, por no decir ninguna, tiene telfono en el Valle.\n";
writemessages[233] = "Se trata de un fijo, no te servir de nada por ah.\n";
writemessages[234] = "Hay multitud de ellos, no sabras por donde empezar.\n";
writemessages[235] = "Hay multitud de ellos, no sabras por donde empezar.\n";
writemessages[236] = "Hay multitud de ellos, no sabras por donde empezar.\n";
writemessages[237] = "Hay multitud de ellos, no sabras por donde empezar.\n";
writemessages[238] = "Demasiado pesada para un gnomo como tu.\n";
writemessages[239] = "No es una mala idea, pero lo malo es que no la tienes entre manos.\n";
writemessages[240] = "Respiras hondo y haciendo acopio de valor te acercas sigilosamente al elfo...\n";
writemessages[241] = "Golpeas furiosamente al elfo en la cabeza con la sartn!\n";
writemessages[242] = "Por un momento parece que resiste...\n";
writemessages[243] = "Pero poco a poco cae a tierra desvanecido...\n";
writemessages[244] = "Necesitars utilizar algo contundente si quieres dejar fuera de combate a este elfo.\n";
writemessages[245] = "Ya lo dejaste fuera de combate, ensaarte con l sera como mnimo cruel.\n";
writemessages[246] = "Mejor lo dejamos dormir un rato.\n";
writemessages[247] = "Lo mueves un poco, con miedo a que se despierte. Pero no lo hace, le metiste un buen golpe.\n";
writemessages[248] = "No encuentras nada interesante entre sus ropas.\n";
writemessages[249] = "Eso sera como acercarte a l y gritar: 'Eh! Estoy aqu! Me escap!'\n";
writemessages[250] = "Tienes ganas de cruzar un par de palabritas con este elfo a propsito de lo que os ha hecho a ti y a tu hermano... pero sabes que no sera muy prudente llamar su atencin.\n";
writemessages[251] = "En su estado ten por seguro que no te responder.\n";
writemessages[252] = "Tendras las de perder...\n";
writemessages[253] = "Te conformas con haberle dejado grogui.\n";
writemessages[254] = "Por el Gran Zurcidor! Ese no es tu estilo...\n";
writemessages[255] = "Tendras las de perder...\n";
writemessages[256] = "Te conformas con haberle dejado grogui.\n";
writemessages[257] = "Por el Gran Zurcidor! Ese no es tu estilo...\n";
writemessages[258] = "Te descubrira y probablemente te volvieran a encerrar en ese oscuro y desagradable desvn.\n";
writemessages[259] = "En realidad no quieres daas al viejo mayordomo humano, sabes que l tan slo cumple rdenes.\n";
writemessages[260] = "En realidad no quieres daas al viejo mayordomo humano, sabes que l tan slo cumple rdenes.\n";
writemessages[261] = "En realidad no quieres daas al viejo mayordomo humano, sabes que l tan slo cumple rdenes.\n";
writemessages[262] = "En realidad no quieres daas al viejo mayordomo humano, sabes que l tan slo cumple rdenes.\n";
writemessages[263] = "Precisamente lo que deseas es no llamar su atencin, no creo que haciendo eso lo consigas.\n";
writemessages[264] = "No alcanzas!\n";
writemessages[265] = "No alcanzas la puerta de la trampilla!\n";
writemessages[266] = "Con Agostine cargado a tus espaldas te resulta imposible subir las escaleras.\n";
writemessages[267] = "Quema!\n";
writemessages[268] = "El cocinero est permanentemente pendiente de l. Adems, es demasiado grande y pesado para un gnomo como tu.\n";
writemessages[269] = "Cucharones, espumaderas y dems utensilios culinarios no te ayudarn a salir de aqu.\n";
writemessages[270] = "Quema!\n";
writemessages[271] = "El mayordomo te descubrira.\n";
writemessages[272] = "Est hermticamente cerrado.\n";
writemessages[273] = "El cocinero la tiene entre manos en estos momentos.\n";
writemessages[274] = "De forma un poco temeraria saltas junto al fogn, estiras la mano y coges la abollada sartn. El cocinero humano no se ha dado cuenta!\n";
writemessages[275] = "Temes que en su estado se ahogara por falta de aire en el interior de la caja, mejor no.\n";
writemessages[276] = "Mejor primero dejas a Agostine en el suelo... No es fcil entrar a una alta caja cargando con un gnomo!\n";
writemessages[277] = "Lo llamas, 'Agostine, eh! Agostine', pero con la boca y los ojos entreabiertos tan solo consigues que murmulle: 'el cd... no pueden apropiarse de los planos, el proyecto...'\n";
writemessages[278] = "Lo llamas, lo palmeas, lo sacudes, le gritas al odo, pero al parecer la droga o la magia lfica es demasiado fuerte. Quiz la nica forma sea esperar a que pase el efecto.\n";
writemessages[279] = "No puedes cargar con l, est atado.\n";
writemessages[280] = "No puedes cargar con l, est atado.\n";
writemessages[281] = "El elfo sin duda se dara cuenta.\n";
writemessages[282] = "La derramaras y el elfo seguramente te descubrira.\n";
writemessages[283] = "Te descubrira!\n";
writemessages[284] = "Empujas un poco al dormido elfo, pero este no se despierta.\n";
writemessages[285] = "No llevas a Agostine.\n";
writemessages[286] = "Dejas a Agostine en el suelo.\n";
writemessages[287] = "Ya lo ests cargando.\n";
writemessages[288] = "Agostine no est por aqu.\n";
writemessages[289] = "Acomodas a Agostine sobre tu espalda... Uf, como pesa!\n";
writemessages[290] = "Intentas despertar a Agostine, pero este parece demasiado dormido, o drogado, para que tus esfuerzos consigan resultado.\n";
writemessages[291] = "Insistes: 'Agostine, Agostine!...\n";
writemessages[292] = "Por fin tu hermano abre un ojo y te mira sin reconocerte: 'El CD... no deben encontrar los planos...'\n";
writemessages[293] = "Agostine vuelve a caer profundamente dormido.\n";
writemessages[294] = "Desatas a Agostine, que cae pesadamente al suelo sin despertarse...\n";
writemessages[295] = "Insistes: 'Agostine, Agostine!...\n";
writemessages[296] = "Por fin tu hermano abre un ojo y te mira sin reconocerte: 'El CD... no deben encontrar los planos...'\n";
writemessages[297] = "Agostine vuelve a caer profundamente dormido.\n";
writemessages[298] = "Intentas despertar a Agostine, pero este parece demasiado dormido, o drogado, para que tus esfuerzos consigan resultado.\n";
writemessages[299] = "No encuentras nada interesante entre sus ropas, adems, no eres un sucio ladrn.\n";
writemessages[300] = "No! Te volvera a apresar.\n";
writemessages[301] = "No tienes contigo el pauelo!\n";
writemessages[302] = "Te arrastras junto al elfo...\n";
writemessages[303] = "Por un momento este aparta la vista del libro y mira a su alrededor...\n";
writemessages[304] = "Te ha odo?\n";
writemessages[305] = "Parece que no, pues bebe un trago de vino y vuelve a fijar su vista en el libro...\n";
writemessages[306] = "Aprovechas este momento para introducir el pequeo pauelo todava hmedo de cloroformo en la jarra de vino...\n";
writemessages[307] = "El elfo vuelve a llenar la copa... Descubriendo el pauelo!\n";
writemessages[308] = "Pnico!\n";
writemessages[309] = "El elfo murmura: 'Maldito mayordomo humano.', arroja el pauelo lejos y apura de un furioso trago la copa de vino...\n";
writemessages[310] = "Esperas...\n";
writemessages[311] = "Poco a poco el elfo parece entrar en letargo... finalmente cae al suelo, con la boca y los ojos entreabiertos, pero definitivamente dormido.\n";
writemessages[312] = "Meter eso en la jarra no parece muy efectivo.\n";
writemessages[313] = "No tienes contigo el pauelo!\n";
writemessages[314] = "Te arrastras junto al elfo...\n";
writemessages[315] = "Por un momento este aparta la vista del libro y mira a su alrededor...\n";
writemessages[316] = "Te ha odo?\n";
writemessages[317] = "Parece que no, pues bebe un trago de vino y vuelve a fijar su vista en el libro...\n";
writemessages[318] = "Aprovechas este momento para introducir el pequeo pauelo todava hmedo de cloroformo en la jarra de vino...\n";
writemessages[319] = "El elfo vuelve a llenar la copa... Descubriendo el pauelo!\n";
writemessages[320] = "Pnico!\n";
writemessages[321] = "El elfo murmura: 'Maldito mayordomo humano.', arroja el pauelo lejos y apura de un furioso trago la copa de vino...\n";
writemessages[322] = "Esperas...\n";
writemessages[323] = "Poco a poco el elfo parece entrar en letargo... finalmente cae al suelo, con la boca y los ojos entreabiertos, pero definitivamente dormido.\n";
writemessages[324] = "Meter eso en la jarra no parece muy efectivo.\n";
writemessages[325] = "Te asomas a su interior, es pequea, nada ms que un par de estantes, y no encuentras nada de inters.\n";
writemessages[326] = "Reprimes las ganas de golpearlo, porqu aunque concentrado en la lectura, el elfo parece demasiado alerta como para pillarlo por sorpresa.\n";
writemessages[327] = "No quieres hacer lea del rbol cado. Aunque ests en todo tu derecho. Finalmente tan solo golpeas un poco con el pie al elfo dormido, que protesta tmidamente...\n";
writemessages[328] = "No quieres que te descubra y te encierre de nuevo en ese horrible desvn!\n";
writemessages[329] = "Te acercas al elfo y le murmuras: 'Ahora qu?', pero el elfo dormido no parece escucharte.\n";
writemessages[330] = "No puedes acercarte a l mientras el elfo est aqu, vigilando.\n";
writemessages[331] = "No puedes acercarte a l mientras el elfo est aqu, vigilando.\n";
writemessages[332] = "Susurras: 'Eh, Agostine', pero tienes miedo de que el elfo te oiga y no dices nada ms.\n";
writemessages[333] = "Eso no parece muy buena idea.\n";
writemessages[334] = "Abres la puerta y sales al porche...\n";
writemessages[335] = "Con cuidado de no hacer ruido abres la puerta...\n";
writemessages[336] = "La puerta ya est abierta.\n";
writemessages[337] = "La puerta ya est cerrada.\n";
writemessages[338] = "Cierras la puerta con cuidado de no hacer ruido...\n";
writemessages[339] = "Coges la caja de cerillas.\n";
writemessages[340] = "La caja de cartn es muy voluminosa... ahora mismo dentro de una casa ajena (donde no eres bienvenido!) es mejor el sigilo y poder esconderte llegado el momento. Cargar con la caja no te ayudara mucho a ello, mejor la dejamos aqu.\n";
writemessages[341] = "No hace falta llamar al timbre para que te abran, la puerta est abierta.\n";
writemessages[342] = "Llamas al timbre... un sordo DONG resuena en el interior de la casa.\n";
writemessages[343] = "Llamas al timbre... oyes un voz ronca decir: 'Un momento!\n";
writemessages[344] = "La penumbra del interior no te deja ver gran cosa.\n";
writemessages[345] = "Es bonito, pero sera engorroso ir cargado con tantas flores por ah.\n";
writemessages[346] = "Golpeas educadamente la puerta, pero no parece ocurrir nada...\n";
writemessages[347] = "Golpeas educadamente la puerta, pero no parece ocurrir nada...\n";
writemessages[348] = "Golpeas con el hombro, pero tus esfuerzos son en vano.\n";
writemessages[349] = "Sin la llave no se puede abrir desde fuera.\n";
writemessages[350] = "La puerta ya est abierta.\n";
writemessages[351] = "Desgraciadamente la puerta ya est cerrada.\n";
writemessages[352] = "Cierras la puerta, y al segundo piensas si no has cometido una tontera... FATAL.\n";
writemessages[353] = "No llegas a las ventanas del primer piso. La ventana junto a la puerta no se puede abrir, tan solo es el cristal.\n";
writemessages[354] = "No llegas a las ventanas del primer piso. La ventana junto a la puerta no se puede abrir, tan solo es el cristal.\n";
writemessages[355] = "Demasiado alta para ti... adems, puedes utilizar la puerta.\n";
writemessages[356] = "No se te ocurre que poner en la caja, una direccin quiz? pero no sabes cul...\n";
writemessages[357] = "La caja de cartn no est por aqu.\n";
writemessages[358] = "No llevas el objeto adecuado.\n";
writemessages[359] = "Ya lo hiciste.\n";
writemessages[360] = "Con letras bien gordas escribes en la tapa de la caja: A la atencin personal de MR. ELDRAD GOLDRIN, Rochester 960, Gran Ciudad.\n";
writemessages[361] = "Dnde quieres escribirlo?\n";
writemessages[362] = "No quieres dejar nada en este buzn.\n";
writemessages[363] = "El buzn est vaco.\n";
writemessages[364] = "Est fuertemente soldado a la verja, no podrs arrancarlo.\n";
writemessages[365] = "Lo abres y te asomas al interior. Est vaco.\n";
writemessages[366] = "Lo cierras.\n";
writemessages[367] = "La abres comprobando que no est cerrada con llave y la vuelves a la cerrar para que no llame la atencin.\n";
writemessages[368] = "Compruebas que est cerrada, aunque no con llave.\n";
writemessages[369] = "Huele an a cloroformo!\n";
writemessages[370] = "No tienes ms que dejarlo...\n";
writemessages[371] = "Mejor sal tu primero...\n";
writemessages[372] = "No puedes entrar dentro de la caja mientras la lleves a cuestas...\n";
writemessages[373] = "La puerta est cerrada.\n";
writemessages[374] = "Prueba con METER/SACAR para introducir objetos o sacarlos del interior de la caja.\n";
writemessages[375] = "Prueba con METER/SACAR para introducir objetos o sacarlos del interior de la caja.\n";
writemessages[376] = "Prueba con METER/SACAR para introducir objetos o sacarlos del interior de la caja.\n";
writemessages[377] = "No acabo de ver claro de donde quieres sacar eso.\n";
writemessages[378] = "Qu quieres sacar de la caja?\n";
writemessages[379] = "No puedo ver dentro de la caja _.\n";
writemessages[380] = "Sacas _ de la caja.\n";
writemessages[381] = "La vela debe permanecer junto al sombrero.\n";
writemessages[382] = "El sombrero debe permanecer junto a tu cabeza.\n";
writemessages[383] = "No acabo de ver claro dnde quieres meter eso.\n";
writemessages[384] = "Qu quieres meter en la caja?\n";
writemessages[385] = "No llevas _.\n";
writemessages[386] = "Metes _ en el interior de la caja.\n";
writemessages[387] = "La abres o la cierras segn te conviene...\n";
writemessages[388] = "La abres o la cierras segn te conviene...\n";
writemessages[389] = "La caja es demasiado grande para voltearla... si quieres vaciarla tendrs que ir sacando los objetos uno por uno.\n";
writemessages[390] = "Basura de elfos! No te ser de mucha ayuda.\n";
writemessages[391] = "No te fas de las herramientas ajenas... No sabes cuando un martillo ajeno puede golpear un pie propio...\n";
writemessages[392] = "La puerta del garaje se abre y cierra mediante un mecanismo elctrico... recuerdas cierta pelcula en la que alguien se mora colgado de un aparato similar, mejor lo dejamos como est.\n";
writemessages[393] = "La puerta del garaje se abre y cierra mediante un mecanismo elctrico... recuerdas cierta pelcula en la que alguien se mora colgado de un aparato similar, mejor lo dejamos como est.\n";
writemessages[394] = "La puerta del garaje se abre y cierra mediante un mecanismo elctrico... recuerdas cierta pelcula en la que alguien se mora colgado de un aparato similar, mejor lo dejamos como est.\n";
writemessages[395] = "No ser por falta de ganas, no...\n";
writemessages[396] = "No lo mueves ni un milmetro... Parece que tienen puesto el freno de mano.\n";
writemessages[397] = "Tanteas tanto uno como otro, pero parecen firmemente cerrados con llave.\n";
writemessages[398] = "Tanteas tanto uno como otro, pero parecen firmemente cerrados con llave.\n";
writemessages[399] = "Imposible... Las puertas estn cerradas.\n";
writemessages[400] = "Imposible... las puertas estn cerradas.\n";
writemessages[401] = "Es donde duermen los automviles de los dueos de la casa...\n";
writemessages[402] = "Ummm te sientes especialmente nostlgico hoy?\n";
writemessages[403] = "Vistalo en: www.caad.es\n";
writemessages[404] = "No se te ocurre una solucin menos drstica?\n";
writemessages[405] = "Te alejas de l.\n";
writemessages[406] = "Lo haces para asomarte o examinar ms de cerca la ventana.\n";
writemessages[407] = "Una de las ventanas de la planta baja tiene la cortina entreabierta... subindote al pequeo escaln contemplas con cuidado el interior...\n";
writemessages[408] = "Es Agostine! Puedes ver a Agostine atado a una silla...\n";
writemessages[409] = "No se mueve! Muerto?\n";
writemessages[410] = "No... ves como respira pesadamente. Parece estar dormido, o drogado.\n";
writemessages[411] = "Contemplas un desordenado saln, lleno hasta los topes de muebles y trastos. Por precaucin no ests mucho tiempo asomado. No sabes cuantos ms de estos malvados elfos pueden merodear por aqu.\n";
writemessages[412] = "Solo alcanzas una... y como todas las dems, parece imposible abrirla desde fuera...\n";
writemessages[413] = "Tanteas la ventana, empujas, mueves... pero no consigues abrirla desde fuera...\n";
writemessages[414] = "El cristal es demasiado grueso para que alguien te oiga desde dentro.\n";
writemessages[415] = "!Es Agostine! Puedes ver a Agostine atado a una silla...\n";
writemessages[416] = "No se mueve! Muerto?\n";
writemessages[417] = "No... ves como respira pesadamente. Parece estar dormido, o drogado.\n";
writemessages[418] = "Contemplas un desordenado saln, lleno hasta los topes de muebles y trastos. Por precaucin no ests mucho tiempo asomado. No sabes cuantos ms de estos malvados elfos pueden merodear por aqu.\n";
writemessages[419] = "No alcanzas! Adems, estn cubiertas por gruesos cortinajes.\n";
writemessages[420] = "No alcanzas! Adems, aunque te parezca raro, abrir una ventana cerrada desde fuera no es tan fcil.\n";
writemessages[421] = "No alcanzas! Adems, aunque te parezca raro, abrir una ventana cerrada desde fuera no es tan fcil.\n";
writemessages[422] = "No te va a ser de mucha utilidad hacer eso...\n";
writemessages[423] = "No te va a ser de mucha utilidad hacer eso...\n";
writemessages[424] = "No te va a ser de mucha utilidad hacer eso...\n";
writemessages[425] = "No te va a ser de mucha utilidad hacer eso...\n";
writemessages[426] = "Rebuscas entre ellos, pero no encuentras nada ms til.\n";
writemessages[427] = "Rebuscas entre ellos, pero no encuentras nada ms til.\n";
writemessages[428] = "No encuentras nada debajo.\n";
writemessages[429] = "No tienes jabn en tu poder.\n";
writemessages[430] = "Frotas la pastilla de jabn contra los barrotes de la ventana, dejndolos cubiertos de una fina pelcula de jabn.\n";
writemessages[431] = "Frotas la pastilla de jabn contra los barrotes de la ventana, dejndolos cubiertos de una fina pelcula de jabn.\n";
writemessages[432] = "Frotas la pastilla de jabn contra los barrotes de la ventana, dejndolos cubiertos de una fina pelcula de jabn.\n";
writemessages[433] = "Te enjabonas a conciencia, quedando resbaladizo y lustroso.\n";
writemessages[434] = "Te enjabonas a conciencia, quedando resbaladizo y lustroso.\n";
writemessages[435] = "Te enjabonas a conciencia, quedando resbaladizo y lustroso.\n";
writemessages[436] = "Te enjabonas a conciencia, quedando resbaladizo y lustroso.\n";
writemessages[437] = "Te enjabonas a conciencia, quedando resbaladizo y lustroso.\n";
writemessages[438] = "Te enjabonas a conciencia, quedando resbaladizo y lustroso.\n";
writemessages[439] = "Te enjabonas a conciencia, quedando resbaladizo y lustroso.\n";
writemessages[440] = "Hueles el polvo y el moho de la estancia.\n";
writemessages[441] = "La ventana no est cerrada, ya que carece de puerta. Lo que si que tiene son unos fuertes barrotes de hierro.\n";
writemessages[442] = "La ventana no tiene puerta que se pueda cerrar, tan slo unos fuertes barrotes que impiden la entrada de intrusos.\n";
writemessages[443] = "Son fuertes y estn firmemente anclados a techo y pared... No los vas a poder mover, cortar, apartar ni limar...\n";
writemessages[444] = "Intentas hacer pasar tu cuerpo por entre los barrotes, parece que lo vas a conseguir, empujas...\n";
writemessages[445] = "Te has quedado atascado! Oh! Qu situacin ms ridcula...\n";
writemessages[446] = "Empujas! Consigues volver a tu posicin original... Ha faltado tan poco para conseguir atravesar los gruesos barrotes.\n";
writemessages[447] = "Deslizas tu cuerpo entre los enjabonados barrotes... S, esta vez mucho mejor...\n";
writemessages[448] = "Te has quedado atascado!\n";
writemessages[449] = "Maldices tu gordo cuerpo mientras vuelves a tu posicin original... ya casi estabas fuera!\n";
writemessages[450] = "Deslizas tu enjabonado cuerpo entre los barrotes... Parece que va a funcionar!\n";
writemessages[451] = "Te has quedado atascado!\n";
writemessages[452] = "Los gruesos barrotes an han ofrecido demasiada resistencia a tu correoso y enjabonado cuerpo...\n";
writemessages[453] = "Seguro que no has dejado nada interesante en el trastero?\n";
writemessages[454] = "Seguro que no has dejado nada interesante en el trastero?\n";
writemessages[455] = "Deslizas tu enjabonado cuerpo por entre los enjabonados barrotes...\n";
writemessages[456] = "Has pasado! Has conseguido salir del desvn!\n";
writemessages[457] = "Oh Oh! Ests colgando de los barrotes a una altura considerable sobre el jardn... Cmo vas a bajar ahora?\n";
writemessages[458] = "La enjabonada mano no resiste... Caes!\n";
writemessages[459] = "De forma poco elegante (de culo, vamos) has cado sobre el jardn trasero... Te levantas acaricindote el trasero...\n";
writemessages[460] = "Seguro que no has dejado nada interesante en el trastero?\n";
writemessages[461] = "Seguro que no has dejado nada interesante en el trastero?\n";
writemessages[462] = "Intentas hacer pasar tu cuerpo por entre los barrotes, parece que lo vas a conseguir, empujas...\n";
writemessages[463] = "Te has quedado atascado! Oh! Qu situacin ms ridcula...\n";
writemessages[464] = "Empujas! Consigues volver a tu posicin original... Ha faltado tan poco para conseguir atravesar los gruesos barrotes.\n";
writemessages[465] = "Deslizas tu cuerpo entre los enjabonados barrotes... S, esta vez mucho mejor...\n";
writemessages[466] = "Te has quedado atascado!\n";
writemessages[467] = "Maldices tu gordo cuerpo mientras vuelves a tu posicin original... ya casi estabas fuera!\n";
writemessages[468] = "Deslizas tu enjabonado cuerpo entre los barrotes... Parece que va a funcionar!\n";
writemessages[469] = "Te has quedado atascado!\n";
writemessages[470] = "Los gruesos barrotes an han ofrecido demasiada resistencia a tu correoso y enjabonado cuerpo...\n";
writemessages[471] = "Deslizas tu enjabonado cuerpo por entre los enjabonados barrotes...\n";
writemessages[472] = "Has pasado! Has conseguido salir del desvn!\n";
writemessages[473] = "Oh Oh! Estas colgando de los barrotes a una altura considerable sobre el jardn... Cmo vas a bajar ahora?\n";
writemessages[474] = "La enjabonada mano no resiste... Caes!\n";
writemessages[475] = "De forma poco elegante (de culo, vamos) has cado sobre el jardn trasero... Te levantas acaricindote el trasero...\n";
writemessages[476] = "Seguro que no has dejado nada interesante en el trastero?\n";
writemessages[477] = "Seguro que no has dejado nada interesante en el trastero?\n";
writemessages[478] = "Intentas hacer pasar tu cuerpo por entre los barrotes, parece que lo vas a conseguir, empujas...\n";
writemessages[479] = "Te has quedado atascado! Oh! Qu situacin ms ridcula...\n";
writemessages[480] = "Empujas! Consigues volver a tu posicin original... Ha faltado tan poco para conseguir atravesar los gruesos barrotes.\n";
writemessages[481] = "Deslizas tu cuerpo entre los enjabonados barrotes... S, esta vez mucho mejor...\n";
writemessages[482] = "Te has quedado atascado!\n";
writemessages[483] = "Maldices tu gordo cuerpo mientras vuelves a tu posicin original... ya casi estabas fuera!\n";
writemessages[484] = "Deslizas tu enjabonado cuerpo entre los barrotes... Parece que va a funcionar!\n";
writemessages[485] = "Te has quedado atascado!\n";
writemessages[486] = "Los gruesos barrotes an han ofrecido demasiada resistencia a tu correoso y enjabonado cuerpo...\n";
writemessages[487] = "Deslizas tu enjabonado cuerpo por entre los enjabonados barrotes...\n";
writemessages[488] = "Has pasado! Has conseguido salir del desvn!\n";
writemessages[489] = "Oh Oh! Estas colgando de los barrotes a una altura considerable sobre el jardn... Cmo vas a bajar ahora?\n";
writemessages[490] = "La enjabonada mano no resiste... Caes!\n";
writemessages[491] = "De forma poco elegante (de culo, vamos) has cado sobre el jardn trasero... Te levantas acaricindote el trasero...\n";
writemessages[492] = "Seguro que no has dejado nada interesante en el trastero?\n";
writemessages[493] = "Seguro que no has dejado nada interesante en el trastero?\n";
writemessages[494] = "Intentas hacer pasar tu cuerpo por entre los barrotes, parece que lo vas a conseguir, empujas...\n";
writemessages[495] = "Te has quedado atascado! Oh! Qu situacin ms ridcula...\n";
writemessages[496] = "Empujas! Consigues volver a tu posicin original... Ha faltado tan poco para conseguir atravesar los gruesos barrotes.\n";
writemessages[497] = "Deslizas tu cuerpo entre los enjabonados barrotes... S, esta vez mucho mejor...\n";
writemessages[498] = "Te has quedado atascado!\n";
writemessages[499] = "Maldices tu gordo cuerpo mientras vuelves a tu posicin original... ya casi estabas fuera!\n";
writemessages[500] = "Deslizas tu enjabonado cuerpo entre los barrotes... Parece que va a funcionar!\n";
writemessages[501] = "Te has quedado atascado!\n";
writemessages[502] = "Los gruesos barrotes an han ofrecido demasiada resistencia a tu correoso y enjabonado cuerpo...\n";
writemessages[503] = "Deslizas tu enjabonado cuerpo por entre los enjabonados barrotes...\n";
writemessages[504] = "Has pasado! Has conseguido salir del desvn!\n";
writemessages[505] = "Oh Oh! Estas colgando de los barrotes a una altura considerable sobre el jardn... Cmo vas a bajar ahora?\n";
writemessages[506] = "La enjabonada mano no resiste... Caes!\n";
writemessages[507] = "De forma poco elegante (de culo, vamos) has cado sobre el jardn trasero... Te levantas acaricindote el trasero...\n";
writemessages[508] = "La trampilla, salida natural del trastero est firmemente cerrada... quiz puedas intentar salir por otro lado.\n";
writemessages[509] = "Pica!\n";
writemessages[510] = "No les encuentras utilidad... adems, mejor buscamos primero la forma de salir de aqu.\n";
writemessages[511] = "No te sientes especialmente caluroso hoy...\n";
writemessages[512] = "Tiras de ella, empujas, saltas encima de ella, pero la trampilla no se abre.\n";
writemessages[513] = "Desgraciadamente la trampilla ya est firmemente cerrada.\n";
writemessages[514] = "Deberas encender el ordenador primero.\n";
writemessages[515] = "Tecleas cuidadosamente, pero el ordenador sigue esperando que introduzcas algn soporte.\n";
writemessages[516] = "Intuitivamente tecleas el nombre de tu hermano...\n";
writemessages[517] = "La pantalla parpadea un par de veces...\n";
writemessages[518] = "La pantalla se ha llenado de hileras y hileras de unos y ceros...\n";
writemessages[519] = "Pasan velozmente, filas y filas... no sabes muy bien que hacer...\n";
writemessages[520] = "Tras varios segundos la pantalla parece apagarse y aparece el siguiente texto:\n";
writemessages[521] = "PROYECTO: DECESUS\n";
writemessages[522] = "SECCIN: A. RUR\n";
writemessages[523] = "FIN DE FICHERO\n";
writemessages[524] = "ALTO SECRETO\n";
writemessages[525] = "No sabes muy bien en que se ha metido Agostine... pero todo esto no te huele muy bien...\n";
writemessages[526] = "Sacas el CD-ROM del ordenador. Mejor ser guardarlo en un lugar seguro hasta que encuentres a Agostine.\n";
writemessages[527] = "En la pantalla aparece: CLAVE INVALIDA\n";
writemessages[528] = "El CD-ROM no est en el interior del ordenador.\n";
writemessages[529] = "Sacas el CD-ROM del ordenador.\n";
writemessages[530] = "El disquette no est en el interior del ordenador.\n";
writemessages[531] = "Sacas el disquette del ordenador.\n";
writemessages[532] = "Eso no parece estar en el interior del ordenador.\n";
writemessages[533] = "Primero debes encender el ordenador.\n";
writemessages[534] = "Primero debes encender el ordenador.\n";
writemessages[535] = "Para eso necesitas tenerlo entre manos primero.\n";
writemessages[536] = "Sacas primero el CD-ROM.\n";
writemessages[537] = "Introduces el disquette en el ordenador... La pantalla parpadea un momento!\n";
writemessages[538] = "Aparece un extrao dibujo: EL HOBBIT, y debajo un perro? no, lo que parece quiera ser un dragn...\n";
writemessages[539] = "Pulsas una tecla y aparece (lentsimamente) un feo dibujo de una puerta y un cofre... y debajo, en ingls! el siguiente texto:\n";
writemessages[540] = "You are in a comfortable tunnel like hall. To the east there is the round green door.\n";
writemessages[541] = "You see:\n";
writemessages[542] = "The wooden chest.\n";
writemessages[543] = "A curios map.\n";
writemessages[544] = "Thorin.\n";
writemessages[545] = "Siempre habas pensado que Agostine era un poco raro, pero tanto como para esto?\n";
writemessages[546] = "Introduces el disquette en el ordenador... La pantalla parpadea un momento!\n";
writemessages[547] = "Aparece un extrao dibujo: EL HOBBIT, y debajo un perro? no, lo que parece quiera ser un dragn...\n";
writemessages[548] = "Pulsas una tecla y aparece (lentsimamente) un feo dibujo de una puerta y un cofre... y debajo, en ingls! el siguiente texto:\n";
writemessages[549] = "You are in a comfortable tunnel like hall. To the east there is the round green door.\n";
writemessages[550] = "You see:\n";
writemessages[551] = "The wooden chest.\n";
writemessages[552] = "Thorin.\n";
writemessages[553] = "Siempre habas pensado que Agostine era un poco raro, pero tanto como para esto?\n";
writemessages[554] = "Necesitas tenerlo en tu poder antes.\n";
writemessages[555] = "Primero sacas el disquette...\n";
writemessages[556] = "Introduces el CD...\n";
writemessages[557] = "Sobre la ya conocida pantalla azul aparece el siguiente texto:\n";
writemessages[558] = "TECLEE CLAVE DE ACCESO:\n";
writemessages[559] = "Introduces el CD...\n";
writemessages[560] = "Sobre la ya conocida pantalla azul aparece el siguiente texto:\n";
writemessages[561] = "TECLEE CLAVE DE ACCESO:\n";
writemessages[562] = "Primero debes encender el ordenador.\n";
writemessages[563] = "Para eso necesitas tenerlo entre manos primero.\n";
writemessages[564] = "Sacas primero el CD-ROM.\n";
writemessages[565] = "Introduces el disquette en el ordenador... La pantalla parpadea un momento!\n";
writemessages[566] = "Aparece un extrao dibujo: EL HOBBIT, y debajo un perro? no, lo que parece quiera ser un dragn...\n";
writemessages[567] = "Pulsas una tecla y aparece (lentsimamente) un feo dibujo de una puerta y un cofre... y debajo, en ingls! el siguiente texto:\n";
writemessages[568] = "You are in a comfortable tunnel like hall. To the east there is the round green door.\n";
writemessages[569] = "You see:\n";
writemessages[570] = "The wooden chest.\n";
writemessages[571] = "A curios map.\n";
writemessages[572] = "Thorin.\n";
writemessages[573] = "Siempre habas pensado que Agostine era un poco raro, pero tanto como para esto?\n";
writemessages[574] = "Introduces el disquette en el ordenador... La pantalla parpadea un momento!\n";
writemessages[575] = "Aparece un extrao dibujo: EL HOBBIT, y debajo un perro? no, lo que parece quiera ser un dragn...\n";
writemessages[576] = "Pulsas una tecla y aparece (lentsimamente) un feo dibujo de una puerta y un cofre... y debajo, en ingls! el siguiente texto:\n";
writemessages[577] = "You are in a comfortable tunnel like hall. To the east there is the round green door.\n";
writemessages[578] = "You see:\n";
writemessages[579] = "The wooden chest.\n";
writemessages[580] = "Thorin.\n";
writemessages[581] = "Siempre habas pensado que Agostine era un poco raro, pero tanto como para esto?\n";
writemessages[582] = "Necesitas tenerlo en tu poder antes.\n";
writemessages[583] = "Primero sacas el disquette...\n";
writemessages[584] = "Introduces el CD...\n";
writemessages[585] = "Sobre la ya conocida pantalla azul aparece el siguiente texto:\n";
writemessages[586] = "TECLEE CLAVE DE ACCESO:\n";
writemessages[587] = "Introduces el CD...\n";
writemessages[588] = "Sobre la ya conocida pantalla azul aparece el siguiente texto:\n";
writemessages[589] = "TECLEE CLAVE DE ACCESO:\n";
writemessages[590] = "El CD-ROM no est en el interior del ordenador.\n";
writemessages[591] = "Sacas el CD-ROM del ordenador.\n";
writemessages[592] = "El disquette no est en el interior del ordenador.\n";
writemessages[593] = "Sacas el disquette del ordenador.\n";
writemessages[594] = "Eso no parece estar en el interior del ordenador.\n";
writemessages[595] = "Primero debes encender el ordenador.\n";
writemessages[596] = "Para eso necesitas tenerlo entre manos primero.\n";
writemessages[597] = "Sacas primero el CD-ROM.\n";
writemessages[598] = "Introduces el disquette en el ordenador... La pantalla parpadea un momento!\n";
writemessages[599] = "Aparece un extrao dibujo: EL HOBBIT, y debajo un perro? no, lo que parece quiera ser un dragn...\n";
writemessages[600] = "Pulsas una tecla y aparece (lentsimamente) un feo dibujo de una puerta y un cofre... y debajo, en ingls! el siguiente texto:\n";
writemessages[601] = "You are in a comfortable tunnel like hall. To the east there is the round green door.\n";
writemessages[602] = "You see:\n";
writemessages[603] = "The wooden chest.\n";
writemessages[604] = "A curios map.\n";
writemessages[605] = "Thorin.\n";
writemessages[606] = "Siempre habas pensado que Agostine era un poco raro, pero tanto como para esto?\n";
writemessages[607] = "Introduces el disquette en el ordenador... La pantalla parpadea un momento!\n";
writemessages[608] = "Aparece un extrao dibujo: EL HOBBIT, y debajo un perro? no, lo que parece quiera ser un dragn...\n";
writemessages[609] = "Pulsas una tecla y aparece (lentsimamente) un feo dibujo de una puerta y un cofre... y debajo, en ingls! el siguiente texto:\n";
writemessages[610] = "You are in a comfortable tunnel like hall. To the east there is the round green door.\n";
writemessages[611] = "You see:\n";
writemessages[612] = "The wooden chest.\n";
writemessages[613] = "A curios map.\n";
writemessages[614] = "Thorin.\n";
writemessages[615] = "Siempre habas pensado que Agostine era un poco raro, pero tanto como para esto?\n";
writemessages[616] = "Necesitas tenerlo en tu poder antes.\n";
writemessages[617] = "Primero sacas el disquette...\n";
writemessages[618] = "Introduces el CD...\n";
writemessages[619] = "Sobre la ya conocida pantalla azul aparece el siguiente texto:\n";
writemessages[620] = "TECLEE CLAVE DE ACCESO:\n";
writemessages[621] = "Introduces el CD...\n";
writemessages[622] = "Sobre la ya conocida pantalla azul aparece el siguiente texto:\n";
writemessages[623] = "TECLEE CLAVE DE ACCESO:\n";
writemessages[624] = "Dnde quieres meterlo?\n";
writemessages[625] = "Dnde quieres meterlo?\n";
writemessages[626] = "No entiendo dnde quieres introducir el cd.\n";
writemessages[627] = "No entiendo dnde quieres introducir el disco.\n";
writemessages[628] = "Ya leste el contenido del CD... siendo algo tan secreto lo ltimo que quisieras sera meterlo en el ordenador de los elfos.\n";
writemessages[629] = "No creo que sea el momento de ponerse a jugar ahora.\n";
writemessages[630] = "Un viejo disco de ordenador en cuya etiqueta puedes leer escrito: The Hobbit.\n";
writemessages[631] = "Un viejo disco de ordenador.\n";
writemessages[632] = "No del todo seguro de lo que haces enciendes el ordenador, que ronronea desperezndose y se pone en marcha.\n";
writemessages[633] = "El ordenador ya est encendido.\n";
writemessages[634] = "Apagas el ordenador.\n";
writemessages[635] = "Apagas el ordenador, pero antes sacas el disquette.\n";
writemessages[636] = "Apagas el ordenador, pero antes sacas el CD-ROM.\n";
writemessages[637] = "El ordenador ya est apagado.\n";
writemessages[638] = "Aos de experiencia te han enseado a mantener tus manos alejadas de cualquier objeto de Agostine.\n";
writemessages[639] = "Aos de experiencia te han enseado a mantener tus manos alejadas de cualquier objeto de Agostine.\n";
writemessages[640] = "Aos de experiencia te han enseado a mantener tus manos alejadas de cualquier objeto de Agostine.\n";
writemessages[641] = "Aos de experiencia te han enseado a mantener tus manos alejadas de cualquier objeto de Agostine.\n";
writemessages[642] = "Es de sobremesa, demasiado pesado y voluminoso para llevarlo por ah.\n";
writemessages[643] = "Las diferentes partes del ordenador deben permanecer unidas.\n";
writemessages[644] = "Las diferentes partes del ordenador deben permanecer unidas.\n";
writemessages[645] = "Las diferentes partes del ordenador deben permanecer unidas.\n";
writemessages[646] = "Sera mejor tenerlo entre manos antes.\n";
writemessages[647] = "Lees los titulares de primer plana:\n";
writemessages[648] = "MISTERIOSO INGENIERO ANUNCIA DESCUBRIMIENTO CIENTFICO DEL SIGLO Empiezas a comprender porqu Agostine guard este peridico en particular...\n";
writemessages[649] = "FAMOSO PEDIATRA DE GRAN CIUDAD DESAPARECIDO Por el Gran Zurcidor! Se trata del Doctor...\n";
writemessages[650] = "MAGNATE ELDRAD GOLDRIN REALIZA OPA HOSTIL SOBRE LABORATORIOS LECKERK No tienes el gusto de conocer al tal Goldrin y poco te interesa!\n";
writemessages[651] = "La puerta permanece abierta.\n";
writemessages[652] = "Mejor no, no quieres correr el riesgo de quedarte aqu dentro encerrado.\n";
writemessages[653] = "No te apetece cargar con un polvoriento felpudo por toda la ciudad.\n";
writemessages[654] = "Bajo el felpudo solo hay polvo.\n";
writemessages[655] = "Bajo el felpudo encuentras una nota y mucho polvo.\n";
writemessages[656] = "Necesitas cogerlo primero.\n";
writemessages[657] = "'Que esperabas encontrar bajo el felpudo? Una llave? A.R.'\n";
writemessages[658] = "Tu hermano Agostine... siempre tan ingenioso...\n";
writemessages[659] = "No llegas hasta ellas.\n";
writemessages[660] = "La cerrada puerta te lo impide.\n";
writemessages[661] = "Golpeas la puerta educadamente... pero no parece pasar nada.\n";
writemessages[662] = "Intentas abrir la puerta, pero parece que est atrancada.\n";
writemessages[663] = "La puerta ya est cerrada.\n";
writemessages[664] = "Cierras la puerta con precaucin, pero no puedes evitar que se vuelva a atrancar.\n";
writemessages[665] = "Con un fuerte empujn consigues abrir la puerta.\n";
writemessages[666] = "Con un fuerte golpe consigues abrir la puerta.\n";
writemessages[667] = "Vale ya, no crees?\n";
writemessages[668] = "Vale ya, no crees?\n";
writemessages[669] = "No te fas mucho del agua humana... adems, aunque te cueste admitirlo, no llegas hasta el agua de la fuente.\n";
writemessages[670] = "No te fas mucho del agua humana... adems, aunque te cueste admitirlo, no llegas hasta el agua de la fuente.\n";
writemessages[671] = "Pero si la puerta est abierta...\n";
writemessages[672] = "La puerta, afortunadamente, ya est abierta.\n";
writemessages[673] = "La puerta, afortunadamente, ya est abierta.\n";
writemessages[674] = "Mejor no, no quieres llamar mucho la atencin.\n";
writemessages[675] = "Mejor no, no quieres llamar mucho la atencin.\n";
writemessages[676] = "Mejor no, no quieres llamar mucho la atencin.\n";
writemessages[677] = "El parque no queda tan lejos, puedes ir perfectamente a pie, adems, como se sentira BM?.\n";
writemessages[678] = "El parque no queda tan lejos, puedes ir perfectamente a pie, adems, como se sentira BM?.\n";
writemessages[679] = "Puedes cogerTE del semforo como si de un borracho te trataras. Pero desde luego, no puedes coger el semforo y llevrtelo por ah.\n";
writemessages[680] = "Eso no parece una buena idea.\n";
writemessages[681] = "No veo en que puede ayudar eso a mi o a Agostine.\n";
writemessages[682] = "No creo que esa sea la mejor forma de pasar desapercibido. Adems, en el fondo tu sabes que los humanos... te dan miedo!\n";
writemessages[683] = "Te alejas de la entrada del Parque y temerariamente trotas hasta la otra acera...\n";
writemessages[684] = "Te alejas de la entrada del Parque y temerariamente trotas hasta la otra acera...\n";
writemessages[685] = "Te alejas de la entrada del Parque y temerariamente trotas hasta la otra acera...\n";
writemessages[686] = "Resoplas un par de veces y te lanzas a la calle para cruzarla...\n";
writemessages[687] = "MOOOCCC!!! Un automvil te esquiva con dificultades! Frenazos, bocinas... vuelves asustado a este lado de la calle. No es esta la mejor forma de no llamar mucho la atencin Rudolph.\n";
writemessages[688] = "Ahora que los automviles estn detenidos cruzas la calle sin mayores dificultades.\n";
writemessages[689] = "Resoplas un par de veces y te lanzas a la calle para cruzarla...\n";
writemessages[690] = "MOOOCCC!!! Un automvil te esquiva con dificultades! Frenazos, bocinas... vuelves asustado a este lado de la calle. No es esta la mejor forma de no llamar mucho la atencin Rudolph.\n";
writemessages[691] = "Ahora que los automviles estn detenidos cruzas la calle sin mayores dificultades.\n";
writemessages[692] = "Pulsas el botn...\n";
writemessages[693] = "Ten un poco de paciencia... el semforo cambiar.\n";
writemessages[694] = "No pierdas el tiempo con el botn, ahora puedes cruzar.\n";
writemessages[695] = "Sera ms correcto pulsarlo.\n";
writemessages[696] = "Pulse para cruzar.\n";
writemessages[697] = "No tienes tiempo de visitar la ciudad mientras Agostine est en peligro.\n";
writemessages[698] = "No tienes tiempo de visitar la ciudad mientras Agostine est en peligro.\n";
writemessages[699] = "No tienes tiempo de visitar la ciudad mientras Agostine est en peligro.\n";
writemessages[700] = "No tienes tiempo de visitar la ciudad mientras Agostine est en peligro.\n";
writemessages[701] = "No tienes tiempo de visitar la ciudad mientras Agostine est en peligro.\n";
writemessages[702] = "No tienes tiempo de visitar la ciudad mientras Agostine est en peligro.\n";
writemessages[703] = "No tienes tiempo de visitar la ciudad mientras Agostine est en peligro.\n";
writemessages[704] = "Desmontas a BM y palmendole el lomo le susurras al odo: 'BM ser mejor que tu esperes aqu.' BM te mira con ojos inteligentes y por un momento te parece que asiente.\n";
writemessages[705] = "Te adentras en la ciudad...\n";
writemessages[706] = "BM aparece trotando y penetra contigo en el interior del Valle...\n";
writemessages[707] = "Quin roba a un ladrn tiene cien aos de perdn? No lo has credo nunca. No te parece justo cargar con los objetos de cientos de aventureros. El extrao tridente bastar.\n";
writemessages[708] = "La puerta ya est abierta.\n";
writemessages[709] = "Intentas abrir la atrancada puerta...\n";
writemessages[710] = "La puerta se abre y del interior de la casa caen cientos de objetos!\n";
writemessages[711] = "Entre los cientos de objetos que caen puedes ver _.\n";
writemessages[712] = "Lo cierto es que la puerta est cerrada.\n";
writemessages[713] = "Hay tantos objetos dentro de la casa y cayendo por entre el marco de la puerta que prcticamente te resulta imposible volver a cerrar esta.\n";
writemessages[714] = "La puerta est cerrada.\n";
writemessages[715] = "La casa est atestada de objetos que te impiden el paso... No sabes como nadie poda vivir aqu.\n";
writemessages[716] = "Demasiado grande, pesada y intil como para hacerlo!\n";
writemessages[717] = "Demasiado grande, pesada y intil como para hacerlo!\n";
writemessages[718] = "Ests en un laberinto! Y no digas que no te lo advert! Puedes mapearlo con el viejo truco de ir dejando objetos, para ver si has cambiado o no de localidad. nimo! No es muy difcil.\n";
writemessages[719] = "Ests en un laberinto! Y no digas que no te lo advert! Puedes mapearlo con el viejo truco de ir dejando objetos, para ver si has cambiado o no de localidad. nimo! No es muy difcil.\n";
writemessages[720] = "No vas a encontrar nada interesante en el interior de la caseta de BM, desde aqu se ve que est vaca.\n";
writemessages[721] = "Eres claramente incapaz.\n";
writemessages[722] = "Antes debes bajar del cajn del elevador.\n";
writemessages[723] = "Antes debes bajar del cajn del elevador.\n";
writemessages[724] = "Antes debes bajar del cajn del elevador.\n";
writemessages[725] = "Antes debes bajar del cajn del elevador.\n";
writemessages[726] = "Uff! La piedra es demasiado pesada para ir por ah cargando con ella. La dejas caer en el suelo...\n";
writemessages[727] = "Uff! La piedra es demasiado pesada para ir por ah cargando con ella. La dejas caer en el suelo...\n";
writemessages[728] = "Uff! La piedra es demasiado pesada para ir por ah cargando con ella. La dejas caer en el suelo...\n";
writemessages[729] = "Uff! La piedra es demasiado pesada para ir por ah cargando con ella. La dejas caer en el suelo...\n";
writemessages[730] = "Primero desmontas de BM.\n";
writemessages[731] = "Primero desmontas de BM.\n";
writemessages[732] = "Primero desmontas de BM.\n";
writemessages[733] = "Primero desmontas de BM.\n";
writemessages[734] = "Aunque de fina inteligencia, la conversacin no es el fuerte de BM. Le susurras palabras de afecto y nimo al odo, que te agradece con un lengetazo.\n";
writemessages[735] = "Acaricias a BM que se muestra agradecido.\n";
writemessages[736] = "Ya ests sobre BM.\n";
writemessages[737] = "Primero debes bajar del cajn del elevador.\n";
writemessages[738] = "Ya ests sobre BM.\n";
writemessages[739] = "Primero debes bajar del cajn del elevador.\n";
writemessages[740] = "Con un grcil (ejem) salto montas sobre el lomo de BM.\n";
writemessages[741] = "Con un grcil (ejem) salto montas sobre el lomo de BM.\n";
writemessages[742] = "Con un grcil (ejem) salto montas sobre el lomo de BM.\n";
writemessages[743] = "Desmontas.\n";
writemessages[744] = "Desmontas.\n";
writemessages[745] = "Desmontas.\n";
writemessages[746] = "Con una mirada fiera y mostrando los dientes un momento BM te disuade de intentar razonar con l.\n";
writemessages[747] = "BM acepta a regaadientes una caricia, pero no te perdona.\n";
writemessages[748] = "Desde la marcha de tu hermano Agostine, BM no te deja montarlo, creyndote responsable de esta.\n";
writemessages[749] = "Necesitaras tenerla entre manos primero.\n";
writemessages[750] = "No comprars la fidelidad de BM tan fcilmente!\n";
writemessages[751] = "No puedes obligar a BM a beber el elixir directamente desde el frasco.\n";
writemessages[752] = "BM olfatea la salchicha, te mira entre la indignacin y la desconfianza...\n";
writemessages[753] = "Pero su instinto es demasiado poderoso y acaba comindola...\n";
writemessages[754] = "Cmo por arte de magia (ejem, es magia vamos) una luz brilla en los ojos de BM, que se te acerca y relame. BM ha olvidado la marcha de Agostine y tu 'parte' en todo el asunto y vuelve a ser tu amigo.\n";
writemessages[755] = "BM lo husmea sin mucho inters.\n";
writemessages[756] = "Necesitas tenerlo entre manos.\n";
writemessages[757] = "No tienes el frasco!\n";
writemessages[758] = "No ves la salchicha por aqu.\n";
writemessages[759] = "Primero tienes que abrirlo.\n";
writemessages[760] = "Vacas el contenido del frasco sobre la salchicha.\n";
writemessages[761] = "Con un leve destello el frasco desaparece!\n";
writemessages[762] = "No tienes el frasco!\n";
writemessages[763] = "No ves la salchicha por aqu.\n";
writemessages[764] = "Primero tienes que abrirlo.\n";
writemessages[765] = "Vacas el contenido del frasco sobre la salchicha.\n";
writemessages[766] = "Con un leve destello el frasco desaparece!\n";
writemessages[767] = "No tienes el frasco!\n";
writemessages[768] = "No ves la salchicha por aqu.\n";
writemessages[769] = "Primero tienes que abrirlo.\n";
writemessages[770] = "Vacas el contenido del frasco sobre la salchicha.\n";
writemessages[771] = "Con un leve destello el frasco desaparece!\n";
writemessages[772] = "No tienes el frasco!\n";
writemessages[773] = "No ves la salchicha por aqu.\n";
writemessages[774] = "Primero tienes que abrirlo.\n";
writemessages[775] = "Vacas el contenido del frasco sobre la salchicha.\n";
writemessages[776] = "Con un leve destello el frasco desaparece!\n";
writemessages[777] = "Eso no parece muy efectivo.\n";
writemessages[778] = "Eso no parece muy efectivo.\n";
writemessages[779] = "Demasiado grande para llevarlo por ah.\n";
writemessages[780] = "Olfateas la flor y tus ojos comienzan a cerrarse...\n";
writemessages[781] = "Cabeceas y recuperas la compostura.\n";
writemessages[782] = "Aunque tiene un aspecto realmente tentador no tienes mucha hambre en este momento.\n";
writemessages[783] = "La salchicha est recubierta por el elixir para olvidar... y no quieres olvidar nada, verdad?\n";
writemessages[784] = "Demasiado picante.\n";
writemessages[785] = "Arghhh!\n";
writemessages[786] = "Ayudan a dormir a Rosi, no quieres molestarla.\n";
writemessages[787] = "Ya cogiste una, creo que es suficiente.\n";
writemessages[788] = "Es muy peligroso despertar a una ninfa de su hibernacin. Eso le podra provocar la muerte... o algo peor.\n";
writemessages[789] = "Una ninfa dormida constituye un peso muerto que ningn gnomo podra soportar.\n";
writemessages[790] = "No puedes evitar susurrarle al odo 'Roooo!' pero muy bajito, temiendo despertarla.\n";
writemessages[791] = "Tu nariz se pone si cabe ms roja mientras le das un pequeo beso en la mejilla a tu fiel amiga.\n";
writemessages[792] = "Con qu clase de persona estoy tratando?\n";
writemessages[793] = "Eso la despertara... cosa que no queremos hacer, verdad?\n";
writemessages[794] = "Mejor los dejas donde estn. Rosi podra despertar de repente y necesitarlos.\n";
writemessages[795] = "Es una foto dedicada del Doctor para Rosi... seguro que le tiene mucho cario. Mejor dejarla donde est.\n";
writemessages[796] = "El aroma de las flores secas invitan al descanso...\n";
writemessages[797] = "No! No es el momento.\n";
writemessages[798] = "Te agachas para abrir el curioso cofre...\n";
writemessages[799] = "GUAAU!!! El cofre se levanta de un salto! Observas pasmado como el cofre se pone a corretear a tu alrededor ladrndote.\n";
writemessages[800] = "El cofre se pone a ladrar escandalosamente y desistes en tu intento.\n";
writemessages[801] = "Te agachas para coger el curioso cofre...\n";
writemessages[802] = "GUAAU!!! El cofre se levanta de un salto! Observas pasmado como el cofre se pone a corretear a tu alrededor ladrndote.\n";
writemessages[803] = "Seguro que no quieres hacerle eso a la mascota de tu amiga Rosi.\n";
writemessages[804] = "El cofre te mira un momento expectante y casi te parece verlo mover una cola de la que carece... Pero al momento vuelve a corretear, saltar y ladrar.\n";
writemessages[805] = "Acaricias torpemente el cofre imaginando que tesoros guardar en su interior.\n";
writemessages[806] = "Acaricias al perro... digo! al cofre. Este ronronea (cmo un gato ahora?), y deja de correr y saltar. Aumentas la intensidad de tu caricia y el cofre se acuesta en el suelo cayendo cada vez ms en un agradable sopor...";
writemessages[807] = " Antes de caer dormido del todo el cofre abre su tapa? boca? y de su interior cae un extrao frasco.\n";
writemessages[808] = "Acaricias al perro... digo! al cofre. Este ronronea (cmo un gato ahora?), y deja de correr y saltar. Aumentas la intensidad de tu caricia y el cofre se acuesta en el suelo cayendo cada vez ms en un agradable sopor...\n";
writemessages[809] = "Corretea a tu alrededor y no se deja coger.\n";
writemessages[810] = "Primero necesitas abrirlo.\n";
writemessages[811] = "No diras eso si pudieras or sus ladridos.\n";
writemessages[812] = "El cofre husmea la pimienta... y estornuda!\n";
writemessages[813] = "El cofre husmea lo que le ofreces, pero no parece muy interesado.\n";
writemessages[814] = "Me temo que no lo llevas contigo.\n";
writemessages[815] = "Un gnomo soltero y una ninfa dormida en una habitacin cerrada? Qu pensaran los vecinos?\n";
writemessages[816] = "La puerta ya est abierta.\n";
writemessages[817] = "La puerta est cerrada.\n";
writemessages[818] = "Aunque parece increble que tu cuerpo quepa por tan diminuta puerta, logras penetrar en el interior de la seta...\n";
writemessages[819] = "La puerta ya est abierta.\n";
writemessages[820] = "La puerta ya est cerrada.\n";
writemessages[821] = "La puerta est cerrada con llave.\n";
writemessages[822] = "Utilizas la pequea llave y con un suave chasquido la puerta se abre.\n";
writemessages[823] = "Cierras la puerta.\n";
writemessages[824] = "Necesitaras la llave para cerrar la puerta convenientemente.\n";
writemessages[825] = "Llamas cortsmente a la puerta... pero no ocurre nada.\n";
writemessages[826] = "Un sordo DOONGG! resuena en el bosque. Te parece or un ladrido apagado en el interior de la seta. Esperas... pero no ocurre nada ms.\n";
writemessages[827] = "Un sordo DOONGG! resuena en el bosque. Te parece or un ladrido apagado en el interior de la seta. Esperas... pero no ocurre nada ms.\n";
writemessages[828] = "Un sordo DOONGG! resuena en el bosque. Te parece or un ladrido apagado en el interior de la seta. Esperas... pero no ocurre nada ms.\n";
writemessages[829] = "Est firmemente anclada a la seta.\n";
writemessages[830] = "Est firmemente anclada al suelo. Adems, es demasiado grande para ti.\n";
writemessages[831] = "Vndalo! An no has comprendido que la seta es una vivienda?\n";
writemessages[832] = "Vndalo! An no has comprendido que la seta es una vivienda?\n";
writemessages[833] = "Por sus colores chillones me jugara el sombrero que se trata de una variedad venenosa de hongo.\n";
writemessages[834] = "Las hay a millares, aqu y en todo el bosque... pero no te hacen mucha falta.\n";
writemessages[835] = "Hablar a las plantas es sin duda una buena forma de ayudarlas a crecer... pero estos rboles pudieron dar sombra a tu bisabuelo... Sin duda no te haran ms caso que a cualquiera de los cientos de seres que han visto crecer y morir sin gloria ninguna.\n";
writemessages[836] = "Los viejos rboles hablan entre ellos en su pausado idioma...\n";
writemessages[837] = "Tu abuelo te enseo a escuchar a los rboles... te parece distinguir historias sobre viejos pastores de rboles y bosques enteros que caminaban a la batalla contra un malvado mago...\n";
writemessages[838] = "Sin duda estos rboles chochean!\n";
writemessages[839] = "La plantita te mira implorante y no eres capaz.\n";
writemessages[840] = "Te aseguro que en un combate a muerte TU tendras todas las de perder.\n";
writemessages[841] = "Fue mucho ms divertido el episodio de la pimienta...\n";
writemessages[842] = "Bah! No te apetece nada abandonar el Valle ahora mismo... Que se te ha perdido en el mundo humano?\n";
writemessages[843] = "El camino es demasiado largo para recorrerlo a pie.\n";
writemessages[844] = "La planta te mira un momento indignada... pero un fuerte estornudo hace que vuelva a zambullirse en el lago.\n";
writemessages[845] = "Mejor la dejas en paz ya.\n";
writemessages[846] = "No quieres daar a la indefensa plantita.\n";
writemessages[847] = "Necesitas tenerlo entre manos para poderlo lanzar.\n";
writemessages[848] = "Qu quieres lanzarle a la planta?\n";
writemessages[849] = "No llegara encendida hasta esa horrible boca.\n";
writemessages[850] = "Lanzas con rabia la pimienta contra la planta...\n";
writemessages[851] = "La planta engulle la pimienta con avidez!\n";
writemessages[852] = "Achs!!!!!!!\n";
writemessages[853] = "La planta estornuda!\n";
writemessages[854] = "Achsss Achsss Achsss\n";
writemessages[855] = "La planta no puede dejar de estornudar... Ruge y salta de un lado a otro del invernadero...\n";
writemessages[856] = "Finalmente, de un salto atraviesa (destrozndolas) las acristaladas paredes del invernadero y se aleja saltando (maceta y todo!) por el bosque...\n";
writemessages[857] = "An oyes un lejano Achs!!!\n";
writemessages[858] = "Cuidado! Algn que otro trozo de cristal ha cado al suelo...\n";
writemessages[859] = "!No quieres deshacerte de la vela\n";
writemessages[860] = "!No quieres deshacerte de tu sombrero\n";
writemessages[861] = "Lanzas con rabia _ contra la planta...\n";
writemessages[862] = "La planta engulle _ con avidez!\n";
writemessages[863] = "Pero tras unos segundos lo escupe con fuerza contra el suelo mientras re todava ms fuerte.\n";
writemessages[864] = "Contra qu o quin quieres lanzar eso?\n";
writemessages[865] = "Enloquecida por el hambre la planta no parece escucharte...\n";
writemessages[866] = "AM AM AM\n";
writemessages[867] = "Ests demasiado lejos y no piensas acercarte ms!\n";
writemessages[868] = "No te parece que ya la regaste lo suficiente?\n";
writemessages[869] = "No te parece que ya has regado lo suficiente?\n";
writemessages[870] = "Por nada del mundo quisieras ponerte al alcance de la planta carnvora...\n";
writemessages[871] = "No te atreves a acercarte!\n";
writemessages[872] = "Por nada del mundo quisieras ponerte al alcance de la planta carnvora...\n";
writemessages[873] = "No te atreves a acercarte!\n";
writemessages[874] = "No llevas contigo el objeto adecuado.\n";
writemessages[875] = "La regadera est vaca.\n";
writemessages[876] = "Vacas el contenido de la regadera sobre la plantita... Esta ronronea y se mueve agradecida bajo la inesperada lluvia...\n";
writemessages[877] = "Algo raro est pasando con la plantita... Se mueve de forma grotesca y se re...\n";
writemessages[878] = "Por el Gran Zurcidor! La plantita est creciendo de forma espectacular!\n";
writemessages[879] = "La anteriormente graciosa e indefensa plantita se ha convertido en una enorme planta carnvora de grandes fauces que mueve sus races cortando el aire mientras re escandalosamente... Sus fauces intentan atraparte de un bocado, pero consigues justo a tiempo dar un paso atrs logrando ponerte fuera de su alcance.\n";
writemessages[880] = "No llevas contigo el objeto adecuado.\n";
writemessages[881] = "La regadera est vaca.\n";
writemessages[882] = "Vacas el contenido de la regadera sobre la plantita... Esta ronronea y se mueve agradecida bajo la inesperada lluvia...\n";
writemessages[883] = "Algo raro est pasando con la plantita... Se mueve de forma grotesca y se re...\n";
writemessages[884] = "Por el Gran Zurcidor! La plantita est creciendo de forma espectacular!\n";
writemessages[885] = "La anteriormente graciosa e indefensa plantita se ha convertido en una enorme planta carnvora de grandes fauces que mueve sus races cortando el aire mientras re escandalosamente... Sus fauces intentan atraparte de un bocado, pero consigues justo a tiempo dar un paso atrs logrando ponerte fuera de su alcance.\n";
writemessages[886] = "La plantita slo quiere agua!\n";
writemessages[887] = "Llorando la plantita se aferra a su maceta con todas sus fuerzas y no te ves capaz de alejarla de ella.\n";
writemessages[888] = "La plantita te mira con ojillos enrojecidos y sigue susurrando 'Agua... Agua...'\n";
writemessages[889] = "Resistira fuera del invernadero?\n";
writemessages[890] = "Resistira la plantita fuera del invernadero?\n";
writemessages[891] = "La plantita susurra 'Agua... Agua...' con voz ronca...\n";
writemessages[892] = "Necesitas tener la regadera contigo.\n";
writemessages[893] = "Debes desmontar primero.\n";
writemessages[894] = "Acercas la regadera a la orilla del lago y la llenas con agua... pero poco a poco el agua se pierde por el pequeo orificio que tiene la regadera, quedando esta otra vez vaca.\n";
writemessages[895] = "Ya llevas la regadera llena, no cabe ms agua.\n";
writemessages[896] = "Acercas la regadera a la orilla del lago y la llenas con agua...\n";
writemessages[897] = "Necesitas tener la regadera contigo.\n";
writemessages[898] = "La regadera ya est vaca.\n";
writemessages[899] = "Viertes el agua de la regadera, vacindola.\n";
writemessages[900] = "Primero desmontas...\n";
writemessages[901] = "Te acercas con cuidado a la orilla del lago y con las manos recoges un poco de agua que bebes rpidamente. Brrrr!! que fra!\n";
writemessages[902] = "Nooo! Hace demasiado fro. Pulmona segura.\n";
writemessages[903] = "El agua que cae provoca un agradable murmullo hipntico.\n";
writemessages[904] = "El frasco ya est lleno de un extrao lquido...\n";
writemessages[905] = "El aroma es evocador...\n";
writemessages[906] = "El aroma es evocador...\n";
writemessages[907] = "Necesitas tenerlo todo contigo.\n";
writemessages[908] = "Necesitas tenerlo todo contigo.\n";
writemessages[909] = "Ummm... quin quisiera beber un elixir desde una regadera?\n";
writemessages[910] = "Necesitas tenerlo todo contigo.\n";
writemessages[911] = "Necesitas tenerlo todo contigo.\n";
writemessages[912] = "Ummm... quin quisiera beber un elixir desde una regadera?\n";
writemessages[913] = "Necesitas tener la regadera contigo.\n";
writemessages[914] = "No ves una fuente de agua por aqu donde puedas llenar la regadera.\n";
writemessages[915] = "La vela debe permaneces junto a tu sombrero!\n";
writemessages[916] = "La vela es demasiado ancha para el orificio de la regadera.\n";
writemessages[917] = "La vela es demasiado ancha para el orificio de la regadera.\n";
writemessages[918] = "Necesitas tener la regadera contigo.\n";
writemessages[919] = "Ya taponaste el agujero de la regadera.\n";
writemessages[920] = "No tienes el objeto adecuado.\n";
writemessages[921] = "Tanteas el agujero de la regadera y con el tapn de corcho consigues taparlo. Ahora est lista para poder usarla.\n";
writemessages[922] = "Necesitas tener la regadera contigo.\n";
writemessages[923] = "Ya taponaste el agujero de la regadera.\n";
writemessages[924] = "No tienes el objeto adecuado.\n";
writemessages[925] = "Tanteas el agujero de la regadera y con el tapn de corcho consigues taparlo. Ahora est lista para poder usarla.\n";
writemessages[926] = "Necesitas tener la regadera contigo.\n";
writemessages[927] = "Ya taponaste el agujero de la regadera.\n";
writemessages[928] = "No tienes el objeto adecuado.\n";
writemessages[929] = "Tanteas el agujero de la regadera y con el tapn de corcho consigues taparlo. Ahora est lista para poder usarla.\n";
writemessages[930] = "Necesitas tener la regadera contigo.\n";
writemessages[931] = "Ya taponaste el agujero de la regadera.\n";
writemessages[932] = "No tienes el objeto adecuado.\n";
writemessages[933] = "Tanteas el agujero de la regadera y con el tapn de corcho consigues taparlo. Ahora est lista para poder usarla.\n";
writemessages[934] = "Despus de lo que te cost repararla no quieres estropear de nuevo la regadera.\n";
writemessages[935] = "Despus de lo que te cost repararla no quieres estropear de nuevo la regadera.\n";
writemessages[936] = "No lo tienes contigo.\n";
writemessages[937] = "No ests muy seguro de querer olvidar algo...\n";
writemessages[938] = "No ests muy seguro de querer olvidar algo... \n";
writemessages[939] = "No entiendo el objetivo de vaciar el frasco sobre eso.\n";
writemessages[940] = "Necesitas tenerlo contigo.\n";
writemessages[941] = "Necesitas destaparlo primero.\n";
writemessages[942] = "Vacas el frasco en el suelo... se forma un pequeo charco azulado que rpidamente se evapora, dejando en el lugar un extrao aroma evocador...\n";
writemessages[943] = "Cmo por arte de magia el frasco parpadea y desaparece!\n";
writemessages[944] = "Algo te dice que acabas de cometer un error... FATAL.\n";
writemessages[945] = "Necesitas tenerlo contigo.";
writemessages[946] = "El frasco ya est abierto.\n";
writemessages[947] = "Quitas el tapn al frasco y un aroma azulado te envuelve agitando tus recuerdos...\n";
writemessages[948] = "Necesitas tenerlo contigo.\n";
writemessages[949] = "No llevas el objeto adecuado.\n";
writemessages[950] = "El frasco ya est cerrado.\n";
writemessages[951] = "Empujas el tapn por el borde del frasco, dejndolo hermticamente cerrado.\n";
writemessages[952] = "Necesitas tenerlo contigo.";
writemessages[953] = "El frasco ya est abierto.\n";
writemessages[954] = "Quitas el tapn al frasco y un aroma azulado te envuelve agitando tus recuerdos...\n";
writemessages[955] = "Necesitas tenerlo contigo.\n";
writemessages[956] = "El frasco ya est cerrado.\n";
writemessages[957] = "No llevas el objeto adecuado.\n";
writemessages[958] = "Empujas el tapn por el borde del frasco, dejndolo hermticamente cerrado.\n";
writemessages[959] = "No pronunciars el nombre del creador en vano...\n";
writemessages[960] = "https://wiki.caad.es/Dwalin\n";
writemessages[961] = "No est muy clavado en el suelo... pero, que haras despus cargado con un buzn por ah?\n";
writemessages[962] = "Las piedras delimitan las sendas, no quieres estropear un elemento pblico.\n";
writemessages[963] = "No lo abarcas con tus pequeos brazos. Adems, est firmemente arraigado en el suelo.\n";
writemessages[964] = "Extrao pensamiento... no se te ocurre cmo.\n";
writemessages[965] = "Extrao pensamiento... no se te ocurre cmo.\n";
writemessages[966] = "Lo intentas una y otra vez, pero el candado estar viejo y oxidado, pero tambin obstinadamente cerrado.\n";
writemessages[967] = "Ya te deshiciste de l.\n";
writemessages[968] = "Ya te deshiciste de l.\n";
writemessages[969] = "Intentas usar la misteriosa llave con el candado, pero a simple vista ya se puede ver que esa llave no abrir este candado.\n";
writemessages[970] = "Quiz s... si tuvieras la llave...\n";
writemessages[971] = "Lo intentas una y otra vez, pero el candado estar viejo y oxidado, pero tambin obstinadamente cerrado.\n";
writemessages[972] = "Ya te deshiciste de l.\n";
writemessages[973] = "Buena idea sera tener el martillo contigo para hacer esto.";
writemessages[974] = "Con certero golpe de martillo arrancas el viejo candado de la puerta... esta, carcomida por los aos y la soledad se abre apenas quedando sostenida por uno de sus goznes...\n";
writemessages[975] = "Eso no parece muy efectivo.\n";
writemessages[976] = "Te dejas llevar por la frustracin y golpeas el candado con el puo... y no consigues ms que llevarte un buen moratn en el dorso de la mano.\n";
writemessages[977] = "Ms cerrada no puede estar.\n";
writemessages[978] = "Para tu desgracia, ms cerrado no puede estar.\n";
writemessages[979] = "Mucho me temo que tu accin lo dej irremediablemente inservible.\n";
writemessages[980] = "La cerrada puerta te lo impide.\n";
writemessages[981] = "La puerta est cerrado por el viejo candado, aunque lo intentas varias veces no lo consigues.\n";
writemessages[982] = "Ya la abriste.";
writemessages[983] = "Tu violencia anterior ha dejado la puerta casi prcticamente inservible... mejor dejarla tal cual.\n";
writemessages[984] = "Pronto desechas la idea... la cuerdecilla parece bastante ignfuga.\n";
writemessages[985] = "Necesitas tenerla entre manos.\n";
writemessages[986] = "Necesitas tenerlo entre manos.\n";
writemessages[987] = "La carta no va dirigida a ti... sera un delito abrirla.\n";
writemessages[988] = "Ya estaba abierto! El cartero se acordar de esto!\n";
writemessages[989] = "Necesitas tenerla entre manos.\n";
writemessages[990] = "Necesitas tenerlo entre manos.\n";
writemessages[991] = "Ummm. No es una carta dirigida a ti. Se tratara de un delito...\n";
writemessages[992] = "No puedes resistir la tentacin de observar el sobre a contraluz...\n";
writemessages[993] = "Puedes leer un pequeo fragmento: 'Adjunto participacin en beneficios por derechos de imagen en Misterio en la catedral...' ya no puedes leer nada ms.\n";
writemessages[994] = "ESTOY EN UN GRAVE APRIETO. STOP. NECESITO TU AYUDA. STOP. ACUDE CUANDO PUEDAS. AGOSTINE\n";
writemessages[995] = "Por el Gran Zurcidor! Parece que tu hermano Agostine se encuentra en apuros! Lo mejor ser que acudas a su casa en la Gran Ciudad para ver que ha ocurrido...\n";
writemessages[996] = "Difcilmente podrs mientras el buzn permanezca cerrado.\n";
writemessages[997] = "Difcilmente podrs mientras el buzn permanezca cerrado.\n";
writemessages[998] = "Difcilmente podrs mientras el buzn permanezca cerrado.\n";
writemessages[999] = "Difcilmente podrs mientras el buzn permanezca cerrado.\n";
writemessages[1000] = "Para preservar la salud mental del programador, si deseas coger o dejar algo del interior del buzn utiliza SACAR o METER.\n";
writemessages[1001] = "Para preservar la salud mental del programador, si deseas coger o dejar algo del interior del buzn utiliza SACAR o METER.\n";
writemessages[1002] = "Alargando la mano sacas la carta del interior del buzn.\n";
writemessages[1003] = "Alargando la mano sacas el telegrama del interior del buzn.\n";
writemessages[1004] = "Eso no est en el interior del buzn.\n";
writemessages[1005] = "Metes la carta en el interior del buzn. Quiz el cartero la recoja y la lleve a su verdadero destino.\n";
writemessages[1006] = "Metes el telegrama en el interior del buzn.\n";
writemessages[1007] = "Recuerdas con una sonrisa el da que metiste un ratn en el interior del buzn a la gamberra edad de 55 aos. Menudo salto dio el cartero. Y tremendo rapapolvo que te llevaste de tu padre. Mejor no meter cosas raras en el interior del buzn.\n";
writemessages[1008] = "La violencia no es la solucin... por lo menos a este problema...";
writemessages[1009] = "Ya cortaste.";
writemessages[1010] = "Buena idea... pero no puedes cortarlo a mordiscos...";
writemessages[1011] = "Manejas con destreza el cristal y cual Alejandro Magno resolviendo el problema del nudo gordiano cortas el dem y consigues abrir el buzn.";
writemessages[1012] = "Pedazo de nudo, pequeo y fuerte. No lo consigues. Quiz si no te comieras las uas...";
writemessages[1013] = "Ya abriste el buzn.\n";
writemessages[1014] = "Intentas abrir el buzn, pero no consigues desatar el nudo de la cuerdecilla que sostiene la tapa. Menudo nudo! Cuando ms fuerza haces ms lo aprietas.\n";
writemessages[1015] = "Ms cerrado no puede estar.\n";
writemessages[1016] = "Sin la cuerdecilla intentas sostener verticalmente la tapa del buzn, pero se cae una y otra vez... Tal vez finalmente el cartero se preste a venderte uno de sus buzones ultra-modernos.\n";
writemessages[1017] = "No quiero cargrmelo!!\n";
writemessages[1018] = "No dudo de que podras hacer eso, pero, que haras despus cargado con un buzn?";
writemessages[1019] = "Dentro del cajn no hay ninguna piedra.\n";
writemessages[1020] = "Coges la pesada piedra.\n";
writemessages[1021] = "Coges la pesada piedra.\n";
writemessages[1022] = "Coges _.\n";
writemessages[1023] = "Sacas la piedra del cajn del elevador. El muelle, ya sin el peso de la piedra salta violentamente.";
writemessages[1024] = "Con una curiosa y calculada parbola, el elevador lanza _ hasta el porche de tu casa.";
writemessages[1025] = "No ves _ dentro del cajn.\n";
writemessages[1026] = "Sacas _ del interior del cajn.\n";
writemessages[1027] = "El cajn no contiene eso.\n";
writemessages[1028] = "Sueltas la piedra en el suelo...\n";
writemessages[1029] = "El muelle, ya sin el peso de la piedra sobre l, recupera su posicin original... lanzndote por los aires. De forma poco elegante pero efectiva te ves catapultado hasta el porche de tu casa...\n";
writemessages[1030] = "Aquello que habas dejado dentro del cajn te acompaa en tu vuelo...";
writemessages[1031] = "Sueltas la piedra en el suelo...\n";
writemessages[1032] = "El muelle, ya sin el peso de la piedra sobre l, recupera su posicin original... lanzndote por los aires. De forma poco elegante pero efectiva te ves catapultado hasta el porche de tu casa...";
writemessages[1033] = "Aquello que habas dejado dentro del cajn te acompaa en tu vuelo...";
writemessages[1034] = "Ya ests dentro del cajn del elevador.\n";
writemessages[1035] = "Ya ests dentro del cajn del elevador.\n";
writemessages[1036] = "Ya ests dentro del cajn del elevador.\n";
writemessages[1037] = "Con un ligero saltito te bajas del cajn del elevador.\n";
writemessages[1038] = "Con un ligero saltito te bajas del cajn del elevador.\n";
writemessages[1039] = "El muelle, ya sin el peso de la piedra sobre l, salta violentamente...";
writemessages[1040] = "Con una curiosa y calculada parbola, el elevador lanza _ hasta el porche de tu casa.";
writemessages[1041] = "Con un ligero saltito te bajas del cajn del elevador.\n";
writemessages[1042] = "El muelle, ya sin el peso de la piedra sobre l, salta violentamente...";
writemessages[1043] = "Con una curiosa y calculada parbola, el elevador lanza _ hasta el porche de tu casa.";
writemessages[1044] = "No ests subido encima del cajn del elevador.\n";
writemessages[1045] = "No ests subido encima del cajn del elevador.\n";
writemessages[1046] = "Subes al cajn del elevador.";
writemessages[1047] = "Subes al cajn del elevador.";
writemessages[1048] = "Metes la piedra en el interior del cajn.\n";
writemessages[1049] = "De puntillas y realizando un gran esfuerzo consigues elevar la piedra hasta la altura del cajn del elevador y meterla dentro de l. Poco a poco, el muelle va cediendo bajo el peso de la piedra, hasta dejar el cajn tan solo un par de palmos por encima del suelo.";
writemessages[1050] = "Elevas la piedra hasta la altura del cajn del elevador y la metes dentro de l. Poco a poco, el muelle va cediendo bajo el peso de la piedra, hasta dejar el cajn tan solo un par de palmos por encima del suelo.";
writemessages[1051] = "Qu quieres meter dentro del cajn?";
writemessages[1052] = "No tienes entre manos el objeto al que te ests refiriendo.";
writemessages[1053] = "El cajn est demasiado alto... no alcanzas.";
writemessages[1054] = "El cajn est demasiado alto... no alcanzas.";
writemessages[1055] = "Si quieres dejar algo o coger algo del cajn del elevador utiliza METER o SACAR ;)";
writemessages[1056] = "Si quieres dejar algo o coger algo del cajn del elevador utiliza METER o SACAR ;)";
writemessages[1057] = "Si quieres dejar algo o coger algo del cajn del elevador utiliza METER o SACAR ;)";
writemessages[1058] = "Intentas trepar al rbol, pero este est cubierto de hmeda vegetacin que hace la idea de trepar a este una misin casi imposible... Adems, al contrario que muchos gnomos nunca has sido muy bueno trepando.";
writemessages[1059] = "El rbol est cubierto de hmeda vegetacin que hace la idea de trepar a este una misin casi imposible... Adems, al contrario que muchos gnomos nunca has sido muy bueno trepando.";
writemessages[1060] = "El rbol est cubierto de hmeda vegetacin que hace la idea de trepar a este una misin casi imposible... Adems, al contrario que muchos gnomos nunca has sido muy bueno trepando.";
writemessages[1061] = "Demasiado alto.";
writemessages[1062] = "Demasiado alto.";
writemessages[1063] = "Demasiado grande.";
writemessages[1064] = "Demasiado grandes.";
writemessages[1065] = "Miras pcaramente al banco... Pero recuerdas la terrible tortcolis con la que te levantaste de tu ltima siesta en el banco.";
writemessages[1066] = "No puedes descender por el tronco del rbol, la plataforma, saliente por todas partes, no te deja acercarte a l.";
writemessages[1067] = "Observas con precaucin la altura entre la plataforma y el suelo... Nunca has sido bueno para medir distancias a ojo... pero te jugaras los dos que es una distancia demasiado grande para bajar de un salto.";
writemessages[1068] = "Te asomas con decisin al borde la plataforma...";
writemessages[1069] = "Aferrndote con fuerza al paraguas saltas al vaco...";
writemessages[1070] = "El paraguas acta cual paracadas, evitndote una cada fatal...";
writemessages[1071] = "Aterrizas limpiamente sobre el suelo.";
writemessages[1072] = "Te asomas con decisin al borde de la plataforma...";
writemessages[1073] = "Y decides que sera casi un suicidio... Los gnomos podemos ser temerarios... pero no suicidas.";
writemessages[1074] = "Te asomas con decisin al borde la plataforma...";
writemessages[1075] = "Aferrndote con fuerza al paraguas saltas al vaco...";
writemessages[1076] = "El paraguas acta cual paracadas, evitndote una cada fatal...";
writemessages[1077] = "Aterrizas limpiamente sobre el suelo.";
writemessages[1078] = "Te asomas con decisin al borde de la plataforma...";
writemessages[1079] = "Y decides que sera casi un suicidio... Los gnomos podemos ser temerarios... pero no suicidas.";
writemessages[1080] = "Te asomas con decisin al borde la plataforma...";
writemessages[1081] = "Aferrndote con fuerza al paraguas saltas al vaco...";
writemessages[1082] = "El paraguas acta cual paracadas, evitndote una cada fatal...";
writemessages[1083] = "Aterrizas limpiamente sobre el suelo.";
writemessages[1084] = "Te asomas con decisin al borde de la plataforma...";
writemessages[1085] = "Y decides que sera casi un suicidio... Los gnomos podemos ser temerarios... pero no suicidas.";
writemessages[1086] = "Te asomas con decisin al borde la plataforma...";
writemessages[1087] = "Aferrndote con fuerza al paraguas saltas al vaco...";
writemessages[1088] = "El paraguas acta cual paracadas, evitndote una cada fatal...";
writemessages[1089] = "Aterrizas limpiamente sobre el suelo.";
writemessages[1090] = "Te asomas con decisin al borde de la plataforma...";
writemessages[1091] = "Y decides que sera casi un suicidio... Los gnomos podemos ser temerarios... pero no suicidas.";
writemessages[1092] = "Te asomas con decisin al borde la plataforma...";
writemessages[1093] = "Aferrndote con fuerza al paraguas saltas al vaco...";
writemessages[1094] = "El paraguas acta cual paracadas, evitndote una cada fatal...";
writemessages[1095] = "Aterrizas limpiamente sobre el suelo.";
writemessages[1096] = "Te asomas con decisin al borde de la plataforma...";
writemessages[1097] = "Y decides que sera casi un suicidio... Los gnomos podemos ser temerarios... pero no suicidas.";
writemessages[1098] = "Saltas repetidamente sobre ti mismo, pero te sientes un poco raro...";
writemessages[1099] = "Necesitas tenerlo en tu poder.";
writemessages[1100] = "Necesitas tenerlo en tu poder.";
writemessages[1101] = "Abres el paraguas.";
writemessages[1102] = "El paraguas ya est abierto.";
writemessages[1103] = "Con un ligero PLOFF cierras el paraguas.";
writemessages[1104] = "El paraguas ya est cerrado.";
writemessages[1105] = "La vela ya est apagada.";
writemessages[1106] = "Apagas la vela con los dedos.\n";
writemessages[1107] = "Apagas la vela con los dedos.";
writemessages[1108] = "La vela ya est encendida.";
writemessages[1109] = "No tienes el objeto adecuado.";
writemessages[1110] = "No tienes el objeto adecuado.";
writemessages[1111] = "Con la cerilla enciendes la vela.";
writemessages[1112] = "Debes encender una cerilla antes.\n";
writemessages[1113] = "Debes encender una cerilla antes.\n";
writemessages[1114] = "Sueltas la cerilla, que cae al suelo casi consumida y se apaga.";
writemessages[1115] = "Sueltas la cerilla, que cae al suelo casi consumida y se apaga.";
writemessages[1116] = "Mejor de una en una...";
writemessages[1117] = "Con un breve soplido apagas la cerilla.";
writemessages[1118] = "No tienes ninguna cerilla.";
writemessages[1119] = "No tienes ninguna cerilla.";
writemessages[1120] = "No tienes ninguna cerilla.";
writemessages[1121] = "No tienes ninguna cerilla.";
writemessages[1122] = "No ves ninguna cerilla encendida por aqu.";
writemessages[1123] = "No ves ninguna cerilla encendida por aqu.";
writemessages[1124] = "No tienes la caja de cerillas en tu poder.";
writemessages[1125] = "Ya no quedan ms cerillas en la caja.";
writemessages[1126] = "La caja de cerillas ya est vaca.\n";
writemessages[1127] = "No te servira de nada una caja de cerillas vaca.\n";
writemessages[1128] = "Por favor, especifica si quieres vaciar la caja de cartn o la caja de cerillas.\n";
writemessages[1129] = "La caja de cartn es demasiado grande para voltearla... si quieres vaciarla debers sacar los objetos que contenga uno a uno.\n";
writemessages[1130] = "No te servira de nada una caja de cerillas vaca.\n";
writemessages[1131] = "Ya est vaca.\n";
writemessages[1132] = "La caja de cerillas est vaca.\n";
writemessages[1133] = "No necesitas sacarla si no quieres encenderla.\n";
writemessages[1134] = "Con esta termina la caja, me pregunto si has sido todo lo prudente que deberas...\n";
writemessages[1135] = "Hbilmente enciendes una cerilla.";
writemessages[1136] = "No tienes ni lea... ni fro, as que no parece muy buena idea.";
writemessages[1137] = "Esperas...";
writemessages[1138] = "La ventana est construida para dejar pasar la luz, no para abrirse o cerrarse.";
writemessages[1139] = "Hermticamente cerrada.";
writemessages[1140] = "La puerta ya est abierta.";
writemessages[1141] = "La puerta ya est abierta.";
writemessages[1142] = "Te jactas continuamente de que al vivir en la copa de un rbol no necesitas proteger tu hogar cerrando la puerta, no es momento de cambiar de opinin ahora.";
writemessages[1143] = "Te jactas continuamente de que al vivir en la copa de un rbol no necesitas proteger tu hogar cerrando la puerta, no es momento de cambiar de opinin ahora.";
writemessages[1144] = "No te los puedes llevar todos!";
writemessages[1145] = "Vas cmodamente vestido ya, no te hace falta ms ropa.";
writemessages[1146] = "Levantaras demasiado polvo, mejor lo dejamos donde est.";
writemessages[1147] = "Levantaras demasiado polvo, mejor lo dejamos donde est.";
writemessages[1148] = "En realidad no te seran de mucha utilidad, mejor no preocuparse por ellos.";
writemessages[1149] = "No quieres romper los marcos!";
writemessages[1150] = "Grande y pesado, lo intentas agarrar, pero pronto compruebas que no es buena idea.";
writemessages[1151] = "No te van a hacer mucha falta por ah.";
writemessages[1152] = "Est pegada a la pared!";
writemessages[1153] = "Te sientes un poco estpido tratando de conversar con una termita.\n";
writemessages[1154] = "La aplastas inmisericorde. Crea de verdad que eras mejor persona.\n";
writemessages[1155] = "No te remuerde la conciencia pensando en lo que hiciste?\n";
writemessages[1156] = "'She's quiet when she's down... Strangers from other towns'";
writemessages[1157] = "'Nowhere to be found... On this side of the scene'";
writemessages[1158] = "'Would you like a cigarette? Or my hand upon your shoulder?'";
writemessages[1159] = "'I think we might have met. Would you like me to come over?'";
writemessages[1160] = "'There's lovers in the backseat. Jealous glances now I'm lookin'for another song'";
writemessages[1161] = "'On the radio... I'll take you to a side street'";
writemessages[1162] = "'In the shadows you can touch one another now'";
writemessages[1163] = "'And I'll just watch the show'";
writemessages[1164] = "Piensa un poco... es fcil!";
writemessages[1165] = "Insistes??";
writemessages[1166] = "Venga hombre, t puedes!";
writemessages[1167] = "No me das NINGUNA lstima.";
writemessages[1168] = "No te oigo!!!";
writemessages[1169] = "Cuando ca al nido de Grongins nadie acudi en mi ayuda!";
writemessages[1170] = "Pedir ayuda es de aventureros gallinas.";
writemessages[1171] = "Antes por lo menos podas consultar al Viejo Archivero.";
writemessages[1172] = "La paciencia es la madre de la ciencia.";
writemessages[1173] = "Sigues probando slo por curiosidad?? Espero por tu bien que s.";
writemessages[1174] = "Te lo has ganado!";
writemessages[1175] = "Recuerdas como tu viejo abuelo acuda al MEGASALTO cada vez que perda las llaves del coche...";
writemessages[1176] = "El Megasalto (sin.'Supersalto', Eng.'Boing') debera ser suficiente.";
writemessages[1177] = "El Megasalto no debera ser utilizado si va a conducir maquinaria pesada.";
writemessages[1178] = "El autor no se responsabiliza penal y/o civilmente de los daos causados por una utilizacin masiva o fraudulenta del megasalto.";
writemessages[1179] = "Tampoco de ningn BUG que tenga relacin con esta opcin provechosa ;)";
writemessages[1180] = "Y por favor... no moleste al perro blanco!";
writemessages[1181] = "Extraa ambicin contemplada por Inform.";
writemessages[1182] = "O, 'De como a todo aventurero se le ocurre cantar al menos una vez por aventura'.";
writemessages[1183] = "Empujas y mueves sin conseguir nada... al menos aparentemente...";
writemessages[1184] = "De repente te invade un profundo sopor. Porqu ahora? No lo sabes, pero te acercas a tu catre con unas irrefrenables ganas de echar una cabezadita.";
writemessages[1185] = "Cierras los ojos...";
writemessages[1186] = "zzzz... zzzz... zzzz...";
writemessages[1187] = "Aqu tiene su pedido Gobernador!";
writemessages[1188] = "Muchas gracias Gobernador! Muy honrado!";
writemessages[1189] = "No mam... an no me he hecho la cama...";
writemessages[1190] = "No! El sombrero noooo!";
writemessages[1191] = "Despiertas con renovado vigor!";
writemessages[1192] = "No es el momento... ni el lugar adecuado.";
writemessages[1193] = "Pronuncias las antiguas palabras mgicas... pero no ocurre nada!";
writemessages[1194] = "Salta de un lado a otro de tu hombre y no te haces con ella.\n";
writemessages[1195] = "Los seres animados no se pueden (en condiciones normales) cargar como si de un objeto se tratara.\n";
writemessages[1196] = "Prestas atencin, pero no te parece or nada fuera de lo habitual.\n";
writemessages[1197] = "Huele a humanos.\n";
writemessages[1198] = "Olfateas... pero no te parece oler nada raro.\n";
writemessages[1199] = "Cargas con tu hermano Agostine.\n";
writemessages[1200] = "Me temo que no lo llevas contigo.\n";
writemessages[1201] = "No comprendo que es lo que quieres dar.\n";
writemessages[1202] = "La termita mueve enrgicamente la cabeza de un lado a otro... parece ser que no le interesa.\n";
writemessages[1203] = "Agostine est atado, no podra sostenerlo.\n";
writemessages[1204] = "En su estado no creo que pudiera ni siquiera sostenerlo.\n";
writemessages[1205] = "Te descubrira!\n";
writemessages[1206] = "Est dormida, no parece que le haga falta ahora mismo.\n";
writemessages[1207] = "No creo que a BM le haga mucha falta.\n";
writemessages[1208] = "No quieres darle nada a una planta que estuvo a punto de comerte.\n";
writemessages[1209] = "No creo que le interesara.\n";
writemessages[1210] = "Al enemigo... ni agua!\n";
writemessages[1211] = "Al enemigo... ni agua!\n";
writemessages[1212] = "A quien quieres dar _?\n";
writemessages[1213] = "Me temo que no est por aqu.\n";
writemessages[1214] = "No puedes darle _ a un objeto inanimado.\n";
writemessages[1215] = "No comprendo que es lo que quieres sacar.\n";
writemessages[1216] = "Por favor, indica de dnde quieres sacar eso. Si ya lo hiciste prueba con otras palabras, ya que no te he entendido.\n";
writemessages[1217] = "O bien no puedes sacar nada de ah dentro o no lo ves por aqu en este momento.\n";
writemessages[1218] = "No comprendo que es lo que quieres meter dentro.\n";
writemessages[1219] = "Por favor, indica dnde quieres meter eso. Si ya lo hiciste prueba con otras palabras, ya que no te he entendido.\n";
writemessages[1220] = "O bien no puedes meter cosas ah dentro o bien no lo ves en este momento.\n";
writemessages[1221] = "No creo que eso le gustase mucho, ni a ti su reaccin...\n";
writemessages[1222] = "No quieres ser cruel con l.\n";
writemessages[1223] = "No creo que eso le gustase mucho, ni a ti su reaccin...\n";
writemessages[1224] = "No quieres ser cruel con l.\n";
writemessages[1225] = "No he comprendido lo que quieres quemar.\n";
writemessages[1226] = "Le haras demasiado dao.\n";
writemessages[1227] = "Puedes hacer algo menos drstico?\n";
writemessages[1228] = "Perdona, no entend donde quieres meter a Agostine.\n";
writemessages[1229] = "Ah no puedes meterlo.\n";
writemessages[1230] = "Lo siento, no se que quieres lanzar.\n";
writemessages[1231] = "No estoy muy seguro de que se podra conseguir con eso.\n";
writemessages[1232] = "No veo donde pueda hacerlo.\n";
writemessages[1233] = "No se a lo que te refieres.\n";
writemessages[1234] = "Creo que eso no se puede beber.\n";
writemessages[1235] = "No puedes ir en esa direccin.\n";
writemessages[1236] = "No puedes ir en esa direccin.\n";
writemessages[1237] = "No ves nada interesante por aqu.\n";
writemessages[1238] = "Ya tienes eso.\n";
writemessages[1239] = "Eso lo llevas puesto.\n";
writemessages[1240] = "El paraguas es como la llave de tu casa... no te permite entrar, pero s salir! Mejor no dejarlo por ah tirado.\n";
writemessages[1241] = "No llevas eso entre manos.\n";
writemessages[1242] = "No puedes dejar _, lo llevas puesto.\n";
writemessages[1243] = "No llevas eso entre manos.\n";
writemessages[1244] = "Eso no lo llevas puesto.\n";
writemessages[1245] = "Eso no lo llevas puesto.\n";
writemessages[1246] = "Eso no parece algo que puedes ponerte.\n";
writemessages[1247] = "Ya lo llevas puesto.\n";
writemessages[1248] = "No es algo que puedas ponerte.\n";
writemessages[1249] = "Perdn, no conozco ese verbo, puedes decirlo con otras palabras?\n";
writemessages[1250] = "Las Aventuras de Rudolphine Rur";
writemessages[1251] = "El CD!\n";
writemessages[1252] = "Ni CD ni nada... parece que te lo han quitado todo...\n";
writemessages[1253] = "La planta carnvora est aqu dentro del lago bebiendo abundante agua para tratar de calmar el picor que le provoc la pimienta.\n";
writemessages[1254] = "La pequea termita canturrea alegremente sobre tu hombro.";
writemessages[1255] = "Ests subido sobre el cajn del elevador.";
writemessages[1256] = "A la verde sombra de un platanero, una pequea plantita te observa desde su maceta.\n";
writemessages[1257] = "La planta carnvora se agita en un rincn, masticando y riendo.\n";
writemessages[1258] = "Como por arte de magia el interior de la pequea seta alberga una amplia estancia Trucos de ninfas! Se trata de una estancia ovalada, revestida de piedra y repleta de flores secas que confieren a la habitacin un aroma apacible y que invita al sueo. En un rincn, acostada sobre un lecho de piedra, tu amiga, la ninfa Rosi, duerme... mejor dicho, hiberna los largos meses de fro. Junto a ella, su pequea mesita de noche, y al otro lado de la estancia su pequea cocina.\n";
writemessages[1259] = "A pesar de que la puerta est abierta, la estancia est sumida en una tenue penumbra... que te impide ver nada!\n";
writemessages[1260] = "Tu zorro BM est aqu, mirndote con desconfianza.\n";
writemessages[1261] = "Tu zorro BM est aqu, relamindose las patas.\n";
writemessages[1262] = "Ests montado sobre tu zorro BM.\n";
writemessages[1263] = "Cargas con Agostine.\n";
writemessages[1264] = "A los pies del lecho observas tambin un curioso cofre.\n";
writemessages[1265] = "Un curioso cofre con patas corre a tu alrededor ladrndote!\n";
writemessages[1266] = "Agostine est aqu! Atado a una silla y como dormido.\n";
writemessages[1267] = "Tirado en el suelo est tu hermano Agostine, profundamente dormido.\n";
writemessages[1268] = "Te escondes tras un alto silln, ya que aqu hay un elfo.\n";
writemessages[1269] = "Cado en el suelo hay un elfo dormido.\n";
writemessages[1270] = "El mayordomo humano est cocinando algo, con una mano remueve un guiso en un puchero mientras con la otra saltea algo en una abollada sartn.\n";
writemessages[1271] = "El mayordomo humano est cocinando, con una mano remueve un guiso en un puchero, pero en estos momentos ha soltado la sartn.\n";
writemessages[1272] = "El mayordomo humano est aqu cocinando algo en el puchero, mientras murmura asombrado: 'Maldita sartn, dnde habr cado? Si no es porqu no puedo dejar de vigilar este guiso...'\n";
writemessages[1273] = "Te encoges en el marco de la puerta cuando descubres a un elfo leyendo junto a la mesa... Por suerte, est de espaldas a ti.\n";
writemessages[1274] = "El antao orgulloso elfo yace desvanecido en el suelo... En su cabeza empieza a insinuarse lo que dentro de poco ser un chichn importante.\n";
writemessages[1275] = "Empotrada en la pared has descubierto la caja fuerte.\n";
writemessages[1276] = "El paraguas! Te acabas de fijar que no lo llevas contigo!\n";
writemessages[1277] = "Como podrs bajar ahora sin l?!\n";
writemessages[1278] = "Piensa Rudolph, piensa!\n";
writemessages[1279] = "...\n";
writemessages[1280] = "Reza Rudolph, reza!\n";
writemessages[1281] = "Eh! Qu es aquello?\n";
writemessages[1282] = "Tus plegarias han sido escuchadas! Arrastrado por una suave (y extraa) brisa el paraguas se posa sobre la superficie del porche.\n";
writemessages[1283] = "Te pareci oir al cartero hace un momento... Quiz sea un buen momento para revisar la correspondencia!\n";
writemessages[1284] = "Tus cosas! Los elfos debieron dejarlas aqu cuando te secuestraron.\n";
writemessages[1285] = "El mayordomo - cocinero suelta un momento la sartn para girar con ms fuerza el guiso que est preparando en el puchero.\n";
writemessages[1286] = "El mayordomo - cocinero vuelve a coger la sartn y empieza a preparar algo en ella.\n";
writemessages[1287] = "Un humano viejo y con cara cansada abre la puerta, parece que viste traje de mayordomo... Apenas te da tiempo a escabullirte tras una maceta para que no te descubra.\n";
writemessages[1288] = "Desde el interior de la caja oyes como abren la puerta y al viejo mayordomo gritar:\n";
writemessages[1289] = "-Seor, hay una caja en el porche.\n";
writemessages[1290] = "-Tiene direccin? Va dirigida al Seor Goldrin? -le preguntan desde dentro de la casa.\n";
writemessages[1291] = "-No, seor.\n";
writemessages[1292] = "-Entonces debe ser cosa del jardinero. Djala ah, ya la recoger maana.\n";
writemessages[1293] = "El viejo mayordomo deja la caja y cerrando la puerta entra en el interior de la casa.\n";
writemessages[1294] = "El viejo mayordomo observa un momento la gran caja de cartn y lo oyes gritar:\n";
writemessages[1295] = "-Seor, hay una caja en el porche.\n";
writemessages[1296] = "-Tiene direccin? Va dirigida al Seor Goldrin? -le preguntan desde dentro de la casa.\n";
writemessages[1297] = "-No, seor.\n";
writemessages[1298] = "-Entonces debe ser cosa del jardinero. Djala ah, ya la recoger maana.\n";
writemessages[1299] = "El viejo mayordomo deja la caja y cerrando la puerta entra en el interior de la casa.\n";
writemessages[1300] = "El viejo mayordomo observa la caja de cartn y lee con dificultad:\n";
writemessages[1301] = "-A la atencin del seor Eldrad Goldrin...\n";
writemessages[1302] = "El viejo mayordomo recoge la caja y con ella entra en el interior de la casa cerrando la puerta.\n";
writemessages[1303] = "Algo te dice que has perdido tu NICA posibilidad de entrar en la casa...\n";
writemessages[1304] = "Desde el interior de la caja oyes abrir la puerta y como el viejo mayordomo lee con dificultad:\n";
writemessages[1305] = "-A la atencin del seor Eldrad Goldrin...\n";
writemessages[1306] = "Te tambaleas en el interior de la caja mientras el mayordomo la recoge y entra con ella al interior de la casa. Notas como la deja en el suelo.\n";
writemessages[1307] = "La caja... seguro que fue buena idea dejarla all? Algo te dice que has perdido la NICA posibilidad de entrar en la casa.\n";
writemessages[1308] = "El mayordomo observa a izquierda y derecha y al no ver a nadie (por suerte) cierra la puerta y vuelve a sus quehaceres.\n";
writemessages[1309] = "El semforo se pone en mbar para los automviles. Algunos conductores aceleran para no pillarlo en rojo.\n";
writemessages[1310] = "El semforo se pone en rojo para los coches y un segundo despus se pone en verde para los peatones.\n";
writemessages[1311] = "El semforo de los peatones parpadea!\n";
writemessages[1312] = "El semforo de los peatones vuelve a ponerse en rojo y el de los automviles en verde. Los autos reinician raudos su loca carrera.\n";
writemessages[1313] = "Con un leve chisporreteo la cerilla se extingue.";
writemessages[1314] = "La cerilla que sostienes est a punto de apagarse!";
writemessages[1315] = "Sostienes una cerilla encendida entre tus dedos.";
writemessages[1316] = "De repente tras un recodo del camino aparece el malvado pirata!\n";
writemessages[1317] = "De repente tras un recodo del camino aparece el malvado pirata!\n";
writemessages[1318] = "'Pepito Grillo Inc'\n";
writemessages[1319] = "Es por donde se meten los cd's y los disquettes en el ordenador...\n";
writemessages[1320] = "En l puedes ver la chimenea...\n";
writemessages[1321] = "No ves eso por aqu.\n";
writemessages[1322] = "Empotrada en la pared y camuflada tras un cuadro has descubierto una pequea caja fuerte. ";
writemessages[1323] = "Est cerrada.\n";
writemessages[1324] = "Est abierta. ";
writemessages[1325] = "Est vaca.\n";
writemessages[1326] = "En su interior puedes ver ";
writemessages[1327] = "Una enorme caja de cartn en la que fcilmente cabra un gnomo...";
writemessages[1328] = "En su parte superior has escrito una direccin... Eldrad Goldrin, el que supones dueo de la casa. ";
writemessages[1329] = " La caja est vaca.\n";
writemessages[1330] = " En el interior de la caja puedes ver ";
writemessages[1331] = "Se trata de una pequea caja de cerillas en donde puedes leer la publicidad (engaosa?): 'interlap.com.ar tu correo POP3 gratis para toda la vida!'";
writemessages[1332] = "En su interior hay ";
writemessages[1333] = " cerillas.";
writemessages[1334] = "Se trata de una pequea caja de cerillas en donde puedes leer la publicidad (engaosa?): 'interlap.com.ar tu correo POP3 gratis para toda la vida!'";
writemessages[1335] = "En su interior tan slo queda 1 cerilla. sala bien!";
writemessages[1336] = "Se trata de una pequea caja de cerillas en donde puedes leer la publicidad (engaosa?): 'interlap.com.ar tu correo POP3 gratis para toda la vida!'";
writemessages[1337] = " Est vaca.";
writemessages[1338] = "Desde aqu no se ve gran cosa de la estancia contigua.\n";
writemessages[1339] = "No eres muy ducho en gastronoma... Cucharones y espumaderas de las que el cocinero parece estar bastante pendiente.\n";
writemessages[1340] = "No entiendes nada.\n";
writemessages[1341] = "Viejos, rotos y gastados, no en vano permanecen apartado en esta estancia.\n";
writemessages[1342] = "No llegan a ser basura, pero si permanecen aqu abandonados un tiempo ms as debern ser considerados.\n";
writemessages[1343] = "La mayora de ellos parecen escritos con extraos caracteres... lfico supones.\n";
writemessages[1344] = "Guapo, elegante, melena rubia recogida... tpico aspecto de elfo... que los hace ser los seres ms vanidosos y engredos sobre la tierra. Est enfrascado en la lectura de una especie de informe y no parece haberse percatado de tu presencia.\n";
writemessages[1345] = "Tu certero golpe lo ha dejado desvanecido sobre el suelo. Bien por ti Rudolphine!\n";
writemessages[1346] = "Parecen representar escenas marineras de forma bastante horrible.\n";
writemessages[1347] = "Se trata de un ordenador porttil, seguramente ltimo modelo. Est apagado.\n";
writemessages[1348] = "Permanece mudo sobre la mesa.\n";
writemessages[1349] = "Se trata de una amplia mesa de despacho, repleta hasta los topes de papeles.\n";
writemessages[1350] = "Facturas, informes, planos... de todo un poco... pero no entiendes nada de ninguno de ellos.\n";
writemessages[1351] = "Est pintada de un bonito color cereza que da vida y calidez a esta estancia.\n";
writemessages[1352] = "Al igual que la mesa est repleto de papeles y libros. Parece que los turbios negocios en los que estn envueltos estos elfos van viento en popa.\n";
writemessages[1353] = "Con un gracioso giro bajan hasta la planta baja.\n";
writemessages[1354] = "No ves gran cosa desde aqu.\n";
writemessages[1355] = "En el techo, una cerrada puerta da acceso al desvn. No alcanzas.\n";
writemessages[1356] = "Largo y oscuro, algo te dice que no necesitas ir ms all.\n";
writemessages[1357] = "En l destaca la trampilla que da acceso al desvn.\n";
writemessages[1358] = "No te sorprende constatar que los elfos tienen un mayordomo / criado / cocinero  humano. Aunque intentan vivir en la sombra y sin llamar mucho la atencin en el mundo humano, no pierden ocasin de humillar a algunos de estos, aunque sea por un msero salario. El mayordomo parece un pobre hombre, viejo ya, eficiente en su trabajo y del que por desgracia no puedes sino esperar lealtad para con sus amos.\n";
writemessages[1359] = "Parece que el mayordomo est preparando un delicioso guiso en el puchero... guiso que por suerte parece precisar de toda su atencin.\n";
writemessages[1360] = "Grande, caliente y antiguo. De hierro colado y pintado de negro. Una reliquia aqu en el mundo humano, pero todava se ven muchos como este en el Valle. Juraras que las deliciosas galletas de la ta Hermianet se cocan en un horno similar.\n";
writemessages[1361] = "Repletas de herramientas culinarias.\n";
writemessages[1362] = "tiles de cocina.\n";
writemessages[1363] = "Sorprendentemente el cocinero la sostiene en una mano mientras con la otra remueve una y otra vez el guiso del puchero.\n";
writemessages[1364] = "El cocinero la ha soltado un momento... tentadoramente cerca de donde te escondes.\n";
writemessages[1365] = "Por lo que puedes ver muy usada.\n";
writemessages[1366] = "Por lo que puedes ver muy usada.  Est abollada... como si hubiese sido utilizada para golpear cabezas, como en las pelculas antiguas.\n";
writemessages[1367] = "Tu hermano Agostine est profundamente dormido, al parecer drogado por los malvados elfos. Observas con tristeza las marcas de la soga en sus muecas, pero aparte de esto no parece en mal estado, tan solo profundamente cansado.\n";
writemessages[1368] = "Se trata de una jarra de vino de la que el elfo bebe cada cierto tiempo.\n";
writemessages[1369] = "No distingues desde aqu que es lo que est leyendo el elfo.\n";
writemessages[1370] = "Tu pobre hermano Agostine, atado a una silla, dormido y con la cabeza cada sobre un hombro.\n";
writemessages[1371] = "Recuerdas su cara, es el que te apres en el parque, cuando saliste de casa de Agostine. Est ojeando un libro mientras bebe de una jarra de vino de vez en cuando.\n";
writemessages[1372] = "El elfo se encuentra cado en el suelo, con la copa de vino todava en la mano, y aparentemente al menos profundamente dormido.\n";
writemessages[1373] = "Una pequea estancia junto al saln, repleta de libros, pero en la que no observas nada ms interesante.\n";
writemessages[1374] = "La mayora son libros humanos, viejos, ajados y usados, la produccin lfica, como la gnmica no atraviesa su mejor momento.\n";
writemessages[1375] = "Recubierto de un viejo parqu, que pide a gritos un cambio.\n";
writemessages[1376] = "Viejo y gastado, a juego con los dems muebles del saln.\n";
writemessages[1377] = "De araa, cuelga del techo, te preguntas cuantas de esas bombillas se encendern llegada la noche.\n";
writemessages[1378] = "De araa, cuelga del techo, te preguntas cuantas de esas bombillas se encendern llegada la noche.\n";
writemessages[1379] = "Ya han pasado su mejor poca, desde luego. Una confusa mezcla de sillones, hamacas y mesas, que quiz han vivido incluso ms que t mismo.\n";
writemessages[1380] = "El saln transmite, o mejor, transmitira una alegre calidez gracias a las paredes recubiertas de madera. Ahora, gastadas y manchadas, la paredes de madera tan solo transmiten una sorda melancola.\n";
writemessages[1381] = "Da paso a las dems estancias de la casa. Est prcticamente vaco.\n";
writemessages[1382] = "Desde aqu puedes ver la entrada a la cocina y al saln.\n";
writemessages[1383] = "No alcanzas a ver mucho desde aqu. Est al norte.\n";
writemessages[1384] = "No alcanzas a ver mucho desde aqu. Est al este.\n";
writemessages[1385] = "Con un estudiado giro y un pasamanos de madera, las escaleras suben hasta el piso superior.\n";
writemessages[1386] = "Suave, gastado y de madera.\n";
writemessages[1387] = "La puerta de salida que te permitir escapar, pintada de blanco por este lado. ";
writemessages[1388] = "Est cerrada.\n";
writemessages[1389] = "Est abierta.\n";
writemessages[1390] = "Invita a llamar.\n";
writemessages[1391] = "La parte delantera de la casa tiene dos ventanas en el primer piso y otra pequea al lado de la puerta. Todas al parecer firmemente cerradas.\n";
writemessages[1392] = "Observas la casa preocupadamente... no entiendes muy bien qu ha ocurrido para que esta maana estuvieras tranquilamente en tu rbol y ahora ests aqu, perdido en medio de la ciudad tratando de entrar a una casa desconocida para salvar a tu hermano.\n";
writemessages[1393] = "Est pintada de un curioso (y bonito, aunque te cueste admitirlo) color azul. Quiz la nica concesin lfica en una casa pensada para pasar desapercibida en este mundo humano. ";
writemessages[1394] = "Est cerrada.\n";
writemessages[1395] = "Est entreabierta.\n";
writemessages[1396] = "Bonito. Te preguntas como consiguen estas flores de aspecto primaveral en medio de este fro otoo.\n";
writemessages[1397] = "Bonito. Te preguntas como consiguen estas flores de aspecto primaveral en medio de este fro otoo.\n";
writemessages[1398] = "Est vaco... puedes ver una direccin escrita: Mr. Eldrad Goldrin, Rochester 960. Gran Ciudad.\n";
writemessages[1399] = "Forma el permetro exterior del jardn y separa la casa de la calle. Soldado a la verja hay un buzn.\n";
writemessages[1400] = "Tanteas la puerta y compruebas que est abierta. El camino hacia la libertad parece posible...\n";
writemessages[1401] = "Instrumento mdico para or la respiracin del cuerpo humano.";
writemessages[1402] = "Peculiar instrumento mdico, que sirve a estos para or la respiracin del paciente. Este en concreto parece bastante usado y tiene grabado en un lateral: Doctor A.S.M.\n";
writemessages[1403] = "Se trata de un pequeo pauelo blanco.";
writemessages[1404] = "Se trata de un pequeo pauelo blanco de fino tacto... todava hmedo y que desprende un extrao olor.\n";
writemessages[1405] = "Herramientas de jardinera, mecnica y bricolaje... aunque tratndose de elfos cualquier cosa pueden ser...\n";
writemessages[1406] = "Tan slo encuentras interesante una gran caja de cartn...\n";
writemessages[1407] = "Tpicos objetos intiles que se amontonan en los garajes (y en cualquier sitio), tratndose de elfos no es tan extrao que amontonen arpas, viejos anillos mgicos y arcos sin cuerdas, entre toda una multitud de cachivaches... no te interesan mucho...\n";
writemessages[1408] = "La puerta del garaje es amplia, se abre en vertical y de forma automtica para permitir el mximo aprovechamiento de espacio.\n";
writemessages[1409] = "Todos estos aparatos para abrir o cerrar puertas automticamente te dan algo de grima, mejor no tocarlo mucho.\n";
writemessages[1410] = "No entiendes mucho de autos... pero desde luego, estos dos no estn nada mal... Aunque son un poco demasiado... umm chillones... piensas que te resultara ridculo conducir un coche as por las estrechas sendas del Valle... eso suponiendo que supieras conducir! Tanteas las puertas pero ambos estn cerrados con llave.\n";
writemessages[1411] = "Gruesos cortinajes que impiden miradas indiscretas a travs de las ventanas.\n";
writemessages[1412] = "Gruesos cortinajes que impiden miradas indiscretas a travs de las ventanas.\n";
writemessages[1413] = "Gruesos cortinajes que impiden miradas indiscretas a travs de las ventanas.\n";
writemessages[1414] = "Te permite asomarte a la ventana...\n";
writemessages[1415] = "Desgraciadamente parecen estar todas cerradas y cubiertas por cortinas excepto una...\n";
writemessages[1416] = "Una de las ventanas de la planta baja tiene la cortina entreabierta... subindote al pequeo escaln contemplas con cuidado el interior...\n";
writemessages[1417] = "Es Agostine! Puedes ver a Agostine atado a una silla...\n";
writemessages[1418] = "No se mueve! Muerto?\n";
writemessages[1419] = "No... ves como respira pesadamente. Parece estar dormido, o drogado.\n";
writemessages[1420] = "Contemplas un desordenado saln, lleno hasta los topes de muebles y trastos. Por precaucin no ests mucho tiempo asomado. No sabes cuantos ms de estos malvados elfos pueden merodear por aqu.\n";
writemessages[1421] = "Encalada y ms bien vieja. La casa consta de una planta baja y un primer piso, adems del desvn-trastero donde te encerraron. En esta fachada lateral puedes ver cuatro ventanas, dos en el primer piso y dos en la parte baja... A simple vista estn todas cerradas, y todas excepto una, cubiertas con gruesos cortinajes.\n";
writemessages[1422] = "Cuidado y bonito.\n";
writemessages[1423] = "Las plantas y flores de este jardn parecen haber sido cuidadas con esmero y dedicacin lfica... tpico de elfos! Dedicar todo su cuidado a plantas y florecillas y al mismo tiempo tratar de dominar el mundo y encerrar a indefensos gnomos en polvorientos trasteros...\n";
writemessages[1424] = "Las plantas y flores de este jardn parecen haber sido cuidadas con esmero y dedicacin lfica... tpico de elfos! Dedicar todo su cuidado a plantas y florecillas y al mismo tiempo tratar de dominar el mundo y encerrar a indefensos gnomos en polvorientos trasteros...\n";
writemessages[1425] = "Las plantas y flores de este jardn parecen haber sido cuidadas con esmero y dedicacin lfica... tpico de elfos! Dedicar todo su cuidado a plantas y florecillas y al mismo tiempo tratar de dominar el mundo y encerrar a indefensos gnomos en polvorientos trasteros...\n";
writemessages[1426] = "Las plantas y flores de este jardn parecen haber sido cuidadas con esmero y dedicacin lfica... tpico de elfos! Dedicar todo su cuidado a plantas y florecillas y al mismo tiempo tratar de dominar el mundo y encerrar a indefensos gnomos en polvorientos trasteros...\n";
writemessages[1427] = "La tpica construccin humana, unifamiliar con jardn, quiz un poco ms ostentosa que la media... cuando fue construida, que sera ya hace bastantes aos a juzgar por el estado de la casa. Planta baja, primer piso y el desvn que (desgraciadamente) ya tan bien conoces. En esta parte trasera se abren cuatro ventanas, desgraciadamente todas cerradas.\n";
writemessages[1428] = "Las ventanas estn firmemente cerradas, intentas asomarte al interior de la casa, pero gruesas cortinas cubren las cuatro ventanas.\n";
writemessages[1429] = "Cuidado y bonito.\n";
writemessages[1430] = "Objetos viejos o inservibles como los que se acumulan en cualquier casa gnmica, o humana, o al parecer, tambin lfica (qu te habas pensado?).\n";
writemessages[1431] = "Objetos viejos o inservibles como los que se acumulan en cualquier casa gnmica, o humana, o al parecer, tambin lfica (qu te habas pensado?)\n";
writemessages[1432] = "Tus ropas estn recubiertas de una fina capa de jabn... resbaladizo.\n";
writemessages[1433] = "Un gnomo... como el del dibujo <;-)";
writemessages[1434] = "Tus ropas estn recubiertas de una fina capa de jabn... resbaladizo.\n";
writemessages[1435] = "Un gnomo... como el del dibujo ;-)";
writemessages[1436] = "Redondos, negros y gruesos... pero quiz lo suficientemente separados para que un pequeo cuerpo de gnomo pueda caber entre ellos.";
writemessages[1437] = " Estn recubiertos de una fina capa de jabn que los ha dejado levemente resbaladizos.\n";
writemessages[1438] = "Se trata de una pequea abertura en la pared, sin duda para que la buhardilla est ventilada. No tiene puerta ni cristal, pero si unos gruesos barrotes.\n";
writemessages[1439] = "Abuhardillado, es bajo y en forma de V invertida. Est recubierto, al igual que las paredes de una especie de espuma aislante.\n";
writemessages[1440] = "En una de ellas se abre una pequea ventana por donde entra la escasa luz que te ilumina ahora mismo.\n";
writemessages[1441] = "Pica!\n";
writemessages[1442] = "Recubierto de polvo... en l se encuentra lo que supones la entrada a este trastero... una cerrada trampilla.\n";
writemessages[1443] = "Inservibles ahora mismo...\n";
writemessages[1444] = "Rebuscas entre los montones de cajas, levantas polvo, te parece or una rata...\n";
writemessages[1445] = "Y lo nico que encuentras es una vieja pastilla de jabn y un rotulador...\n";
writemessages[1446] = "Pero no encuentras nada til.\n";
writemessages[1447] = "La trampilla es una especie de puerta de madera que se abre en el suelo del trastero-desvn. Est firmemente cerrada.\n";
writemessages[1448] = "Viejas cintas de cassete... no ha odo hablar Agostine de los cd? Entre ellas Duran-Duran, Depeche Mode... todo muy del gusto de t hermano (y no del tuyo, por precisar).\n";
writemessages[1449] = "No te avergenza confesar que no sabes ni lo que son ni para que se usan.\n";
writemessages[1450] = "No entiendes mucho de ordenadores, justo al revs que tu hermano Agostine, por lo que no tienes ni idea del modelo, o si es moderno o viejo... Para ti tan solo ves una pantalla, un teclado y la CPU? ";
writemessages[1451] = "Est apagado.\n";
writemessages[1452] = "Est encendido.\n";
writemessages[1453] = "Casi no la encuentras entre la multitud de trastos que tiene encima, alrededor e incluso debajo. Tiene dos ranuras, una para disquettes y otra para cds. ";
writemessages[1454] = "Ahora mismo en su interior tiene un disquette.\n";
writemessages[1455] = "Ahora mismo en su interior tiene un cd-rom.\n";
writemessages[1456] = "Listo para ser aporreado... digo, tecleado.\n";
writemessages[1457] = "La pantalla permanece oscura.\n";
writemessages[1458] = "La pantalla tiene ahora un intimidante color azul, en el que se puede leer:\n";
writemessages[1459] = "INTRODUZCA SOPORTE\n";
writemessages[1460] = "Sobre la ya conocida pantalla azul aparece el siguiente texto:\n";
writemessages[1461] = "TECLEE CLAVE DE ACCESSO:\n";
writemessages[1462] = "You are in a comfortable tunnel like hall. To the east there is the round green door.\n";
writemessages[1463] = "You see:\n";
writemessages[1464] = "The wooden chest.\n";
writemessages[1465] = "A curios map.\n";
writemessages[1466] = "Thorin.\n";
writemessages[1467] = "You are in a gloomy empty land with dreary hill ahead.\n";
writemessages[1468] = "To the west there is the round green door.\n";
writemessages[1469] = "Visibles exits are: east north northeast\n";
writemessages[1470] = "You see:\n";
writemessages[1471] = "Thorin.\n";
writemessages[1472] = "You are in the trolls clearing.\n";
writemessages[1473] = "Visibles exits are: southwest southeast north\n";
writemessages[1474] = "You see:\n";
writemessages[1475] = "Thorin.\n";
writemessages[1476] = "The hideous troll.\n";
writemessages[1477] = "The vicious troll.\n";
writemessages[1478] = "You are in a hidden path with trolls foot prints.\n";
writemessages[1479] = "To the north there is the heavy rock door.\n";
writemessages[1480] = "Visible exits are: south.\n";
writemessages[1481] = "You see:\n";
writemessages[1482] = "Thorin.\n";
writemessages[1483] = "El vestuario de Agostine es todo menos moderno... adems, estar hecho un revoltijo sobre sillas y muebles no ayuda mucho a que tenga mejor aspecto. ";
writemessages[1484] = "En un bolsillo de una camisa encuentras algo! Un disco de ordenador y un cd!\n";
writemessages[1485] = "Principalmente son libros de ingeniera, matemticas (matemtica discreta?) y AutoCad... Agostine, por si no os haba informado todava, es ingeniero.\n";
writemessages[1486] = "Doblado cuidadosamente entre los libros encuentras un peridico.\n";
writemessages[1487] = "Permanece abierta, no quieres correr el riesgo de quedarte aqu dentro encerrado.\n";
writemessages[1488] = "'Home Sweet Home' Parece que mam trajo felpudos para toda la familia... ";
writemessages[1489] = "Un momento! Bajo el felpudo encuentras una nota.\n";
writemessages[1490] = "Una enorme caja de cartn en la que fcilmente cabra un gnomo...";
writemessages[1491] = "En su parte superior has escrito una direccin... Eldrad Goldrin, el que supones dueo de la casa. ";
writemessages[1492] = " La caja est vaca.\n";
writemessages[1493] = " En el interior de la caja puedes ver ";
writemessages[1494] = "Un rotulador permanente negro.";
writemessages[1495] = "Se trata de un gordo rotulador permanente, color negro.\n";
writemessages[1496] = "Una vieja pastilla de jabn.";
writemessages[1497] = "Una vieja, pero apenas usada pastilla de jabn en la que an se lee con dificultad NH Hoteles.\n";
writemessages[1498] = "Sobre su cara hay dos letras escritas: AR.\n";
writemessages[1499] = "Sobre su cara hay dos letras escritas: AR.";
writemessages[1500] = "A juzgar por el ttulo y el diseo (tan aburrido!) debe tratarse de unas de las prestigiosas publicaciones cientficas a las que estaba suscrito Agostine.\n";
writemessages[1501] = "A juzgar por el ttulo y el diseo (tan aburrido!) debe tratarse de unas de las prestigiosas publicaciones cientficas a las que estaba suscrito Agostine.";
writemessages[1502] = "Una nota manuscrita con la descuidada caligrafa de Agostine.\n";
writemessages[1503] = "Una pequea nota.";
writemessages[1504] = "La puerta est cerrada. Ante ella ves un felpudo.\n";
writemessages[1505] = "Tu fuerte empujn dej la puerta abierta. Ante la puerta ves un felpudo.\n";
writemessages[1506] = "Se trata de una fuente de piedra, de forma circular y con unas curiosas figuras en su centro...\n";
writemessages[1507] = "En un lateral descubres una pequea puerta! La puerta de la casa de Agostine!\n";
writemessages[1508] = "No ests muy seguro de que representan. Se trata de un nio y una nia. El nio toca una flauta y la nia tiene un pajarillo sobre su hombro. Si este fuera el verdadero sentir humano no hara falta que gnomos y humanos vivieran separados, pero sabes que por desgracia se trata slo de un espejismo.\n";
writemessages[1509] = "Cuidado y asfaltado. Se adentra hacia el interior del parque.\n";
writemessages[1510] = "Las ramas de la entrelazada vegetacin forman un curioso y agradable techo vegetal.\n";
writemessages[1511] = "Te avergenzas de no saber que tipo de planta es esta.\n";
writemessages[1512] = "Te avergenzas de no saber que tipo de planta es esta.\n";
writemessages[1513] = "Una grata extensin de tierra verde y vegetacin en medio de la ciudad. Un lugar agradable, s seor.\n";
writemessages[1514] = "Negra y amenazadora. Para que vallar un parque? te preguntas con tu cndida ingenuidad gnmica.\n";
writemessages[1515] = "Permanece abierta.\n";
writemessages[1516] = "Pulse para cruzar.\n";
writemessages[1517] = "Rojo, redondo y pulsable.\n";
writemessages[1518] = "La ciudad se extiende en todas direcciones. Siempre has conocido a esta ciudad humana como la Gran Ciudad y no sabes si tiene otro nombre en humano, lfico o cualquiera de las lenguas habladas.\n";
writemessages[1519] = "Un taxi es una especie de automvil comunitario que utilizan los humanos para desplazarse de un sitio a otro.\n";
writemessages[1520] = "Junto a ti se alza un semforo, alto, flaco y amarillo. En su parte inferior puedes ver un botn, y a su lado un aviso: pulse para cruzar. En estos momentos el semforo est en verde para los automviles y en rojo para los peatones.\n";
writemessages[1521] = "Junto a ti se alza un semforo, alto, flaco y amarillo. En su parte inferior puedes ver un botn, y a su lado un aviso: 'Pulse para cruzar'. En estos momentos el semforo est en rojo para los automviles y en verde para los peatones.\n";
writemessages[1522] = "No es muy amplia y no crees que al atravesarla llames mucho la atencin... pero los automviles pasan a toda velocidad.\n";
writemessages[1523] = "En este momento los automviles estn detenidos ante el semforo en rojo.\n";
writemessages[1524] = "Te animas un poco al observar las altas copas de los rboles que asoman desde el Parque Central al otro lado de la calle.\n";
writemessages[1525] = "Te animas un poco al observar las altas copas de los rboles que asoman desde el Parque Central al otro lado de la calle.\n";
writemessages[1526] = "La calle est franqueada por altos edificios residenciales. No entiendes como tanta gente puede vivir junta en aparente armona. Nada que ver con los rboles-vivienda del Valle.\n";
writemessages[1527] = "Los humanos son gente curiosa que parece que vaya siempre con prisa. No conoces a muchos humanos personalmente, pero por lo que sabes de ellos no te pierdes gran cosa, ya que suelen ser malhumorados, descuidados y algo locos.\n";
writemessages[1528] = "Mquinas grandes, y ruidosas que no respetan ni a gnomos ni a animales pequeos. Parecen atestar las calles de la ciudad.\n";
writemessages[1529] = "Llenan los bajos de los edificios, con humanos entrando y saliendo de ellas cargados con innumerables bolsas.\n";
writemessages[1530] = "Al fondo del callejn empieza la bulliciosa ciudad...\n";
writemessages[1531] = "Un callejn sucio y maloliente, lo bastante cerca del Parque Central, pero lo bastante apartado para que BM puede esperarte aqu sin peligro.\n";
writemessages[1532] = "Para ti altas, pero entraables y familiares. Para un humano, altas y amenazadoras.\n";
writemessages[1533] = "Igual que para salir de l, la carretera es la ms rpida forma de entrar en el Valle.\n";
writemessages[1534] = "Las rutas a travs de las montaas pueden ser labernticas. No tienes ninguna necesidad de ir por all, pero, quin sabe...\n";
writemessages[1535] = "Altas y amenazadoras.\n";
writemessages[1536] = "Las rutas a travs de las montaas pueden ser labernticas. No tienes ninguna necesidad de ir por all, pero, quin sabe...\n";
writemessages[1537] = "El camino recto para salir del Valle. De reciente construccin, suscit encontradas discusiones sobre la conveniencia o no de esta. T mismo votaste en contra, lo que hizo que el Doctor (gran defensor y impulsor de la idea) estuviera un tiempo sin hablarte.\n";
writemessages[1538] = "Est cerrada.\n";
writemessages[1539] = "La abriste y est casi sepultada por cientos de objetos.\n";
writemessages[1540] = "A tu mente solo acude un pensamiento: el tridente es un tesoro.\n";
writemessages[1541] = "El tridente es un tesoro.";
writemessages[1542] = " Est en el interior del cajn del elevador.\n";
writemessages[1543] = "Cientos y cientos de ellos... forman parte del botn del pirata, que durante aos ha robado a incautos aventureros en estos y otros parajes.\n";
writemessages[1544] = "La Guarida del Malvado Pirata. Se trata de un rstico casero, que un su concepcin original pretendera imitar la silueta de un barco. Un lugar extrao para un personaje extrao. Su atrancada puerta est cerrada.\n";
writemessages[1545] = "La Guarida del Malvado Pirata. Se trata de un rstico casero, que un su concepcin original pretendera imitar la silueta de un barco. Un lugar extrao para un personaje extrao. Su puerta est abierta y bloqueada por cientos de objetos.\n";
writemessages[1546] = "La Guarida del Malvado Pirata. Se trata de un rstico casero, que un su concepcin original pretendera imitar la silueta de un barco. Un lugar extrao para un personaje extrao. Su atrancada puerta est cerrada.\n";
writemessages[1547] = "La Guarida del Malvado Pirata. Se trata de un rstico casero, que un su concepcin original pretendera imitar la silueta de un barco. Un lugar extrao para un personaje extrao. Su puerta est abierta y bloqueada por cientos de objetos.\n";
writemessages[1548] = "Te parece haberla visto ya en tu deambular entre las montaas. O no y ser otra? Ay! Todas las rocas te parecen ya iguales.\n";
writemessages[1549] = "Te parece haberla visto ya en tu deambular entre las montaas. O no y ser otra? Ay! Todas las rocas te parecen ya iguales.\n";
writemessages[1550] = "Has intentado tomarlos como punto de referencia, pero las nevadas cumbres que brillan al sol se confunden unas con otras, hasta llegar a marearte con su reflejo.\n";
writemessages[1551] = "Has intentado tomarlos como punto de referencia, pero las nevadas cumbres que brillan al sol se confunden unas con otras, hasta llegar a marearte con su reflejo.\n";
writemessages[1552] = "Todas te parecen ya iguales... Igual de malas quiero decir!\n";
writemessages[1553] = "Todas te parecen ya iguales... Igual de malas quiero decir!\n";
writemessages[1554] = "Todos te parecen ya iguales... Igual de malos quiero decir!\n";
writemessages[1555] = "Todos te parecen ya iguales... Igual de malos quiero decir!\n";
writemessages[1556] = "La caseta de BM, slidamente construida gracias a los planos de tu hermano Agostine (no en vano abandon la tradicin familiar de zapatero para hacerse ingeniero).\n";
writemessages[1557] = "El claro de las celebraciones familiares. Fro y solitario a la sombra de los rboles.\n";
writemessages[1558] = "Jvenes en esta parte del bosque.\n";
writemessages[1559] = "Tu zorro BM (abreviatura de Brian Molko, extrao nombre que tu alocada hermana le dio hace aos) ha sido fiel compaero de correras tuyo y de tus hermanos durante largos aos. Sin embargo, ahora est enfadado contigo porqu no le dejaste marchar junto a tu hermano Agostine (su favorito!) a la ciudad cuando este se fue. Desde entonces te ignora, no te deja montarlo y te grue cuando te acercas.\n";
writemessages[1560] = "Tu zorro BM (abreviatura de Brian Molko, extrao nombre que tu alocada hermana le dio hace aos) ha sido fiel compaero de correras tuyo y de tus hermanos durante largos aos. De pelaje rojo, gil y rpido, un gran amigo y el mejor medio de locomocin que cualquier gnomo quisiera tener.\n";
writemessages[1561] = "La salchicha est cubierta de un pegajoso lquido azul.\n";
writemessages[1562] = "La salchicha est cubierta de un pegajoso lquido azul.\n";
writemessages[1563] = "Una salchicha de aspecto apetitoso.\n";
writemessages[1564] = "Una salchicha de aspecto apetitoso.";
writemessages[1565] = " Est en el interior del cajn del elevador.\n";
writemessages[1566] = "Una seca y aplastada rosa que desprende un aroma adormecedor.\n";
writemessages[1567] = "Una seca y aplastada rosa que desprende un aroma adormecedor.";
writemessages[1568] = " Est en el interior del cajn del elevador.\n";
writemessages[1569] = "Rosas secas que desprenden un curioso aroma adormecedor.\n";
writemessages[1570] = "Comparar la graciosa y limpia cocina de Rosi con la tuya es algo odioso. Encuentras una pizca de pimienta.\n";
writemessages[1571] = "Comparar la graciosa y limpia cocina de Rosi con la tuya es algo odioso.\n";
writemessages[1572] = "Recostada en su duro lecho de piedra, Rosi, la ninfa, descansa los duros meses de invierno. El cabello le ha crecido espectacularmente durante el sueo, pero no oculta todava su bello y sereno rostro. Recuerdas como lo primero que hace nada ms despertar es acudir a la peluquera! Mirndola recuerdas ahora como te dej la llave de su casa por si ocurra alguna urgencia. Cuanto se sorprendera si despertara ahora y te viera aqu mirndola!\n";
writemessages[1573] = "La mesilla de noche de Rosi est toda llena de pequeos objetos... tiene que estar preparada para dormir casi seis meses de un tirn! Entre los distintos objetos destaca una vieja fotografa del Doctor.\n";
writemessages[1574] = "Nada en especial. Lo ms interesante es la vieja fotografa del Doctor.\n";
writemessages[1575] = "Observas con una sonrisa la vieja fotografa del Doctor, su melena leonina, su gastado traje... En la parte de atrs de la foto puedes leer. 'A mi querida Rosi. Sin duda la persona ms especial del Valle'.\n";
writemessages[1576] = "Te agachas para observar ms de cerca el curioso cofre...\n";
writemessages[1577] = "GUAAU!!! El cofre se levanta de un salto! Observas pasmado como el cofre se pone a corretear a tu alrededor ladrndote.\n";
writemessages[1578] = "Por increble que parezca se trata de un cofre con patas... que sin duda se cree un perro. Te olfatea y te ladra mientras corre alrededor de ti.\n";
writemessages[1579] = "Es un suelo rico en humus y nutrientes. No te extraa que en l halla crecido esta hermosa seta.\n";
writemessages[1580] = "Una graciosa, grande y colorada seta ha crecido a la sombra del viejo tocn muerto. No te extraa que haya alcanzado su tamao en este suelo rico y hmedo. Un momento! Casi desapercibida pasa una pequea puerta en un lateral de la seta.\n";
writemessages[1581] = "En su superficie ves grabada una solitaria letra R. Ahora recuerdas! Es la puerta de entrada a la casa de tu amiga la ninfa Rosi. Junto a la puerta ves una campanilla.";
writemessages[1582] = " La puerta est cerrada.\n";
writemessages[1583] = " La puerta est abierta.\n";
writemessages[1584] = "Una pequea campanilla dorada que cuelga junto a la puerta a modo de timbre.\n";
writemessages[1585] = "Desde aqu las todava lejanos montaas parecen mucho ms amenazadoras que desde tu casa.\n";
writemessages[1586] = "Bastante amplio... antes era mucho ms transitado... antes de estos sinistros tiempos... antes del imperio...\n";
writemessages[1587] = "Pero bueno, que estoy diciendo! Ejem... Se trata de un camino amplio, no en vano es la principal va de comunicacin del Valle con el mundo exterior. Est cubierto de hojas.\n";
writemessages[1588] = "Cubren el camino de un manto verde - marrn. Ya es otoo en el corte ingls!\n";
writemessages[1589] = "Se trata del tocn de un viejo rbol muerto. Seco y casi devorado por los insectos.\n";
writemessages[1590] = "La pequea termita mira al tocn abriendo mucho sus ojitos... Finalmente de un salto abandona tu hombro y se posa sobre el tocn. Antes de desaparecer entre sus recovecos te parece or un lejano sollozo cantarn: 'Adis'\n";
writemessages[1591] = "Se trata del tocn de un viejo rbol muerto. Seco y casi devorado por los insectos.\n";
writemessages[1592] = "Se trata del tocn de un viejo rbol muerto. Seco y casi devorado por los insectos.\n";
writemessages[1593] = "Los rboles de esta parte del bosque son viejos y carcomidos. En las alturas parecen rozar rama contra rama para asegurarse que sus viejos compaeros siguen ah. Un leve rumor, como el eco de una conversacin muda agita el aire.\n";
writemessages[1594] = "La Carnvora Vera se zambulle en el agua y bebe de la cascada con avidez, tratando de mitigar el picor que le provoc la pimienta. Ahora ya no se re.\n";
writemessages[1595] = "A pesar de los rayos del sol que penetran por sus acristaladas paredes, el interior del invernadero permanece en penumbra por la cantidad de plantas que crecen descontroladamente en l.\n";
writemessages[1596] = "Una de las paredes est destrozada, justo por donde la planta carnvora Vera sali saltando.\n";
writemessages[1597] = "Todo tipo de plantas crecen descontroladamente desde que el Doctor dej de ocuparse del invernadero. Te preguntas porqu lo cerr con llave y no te dej a ti o algn otro de sus amigos encargados de cuidar sus plantas.\n";
writemessages[1598] = "Todo tipo de plantas crecen descontroladamente desde que el Doctor dej de ocuparse del invernadero. Te preguntas porqu lo cerr con llave y no te dej a ti o algn otro de sus amigos encargados de cuidar sus plantas.\n";
writemessages[1599] = "La planta carnvora agita sus races, mordisquea el aire y ruge! Recuerdas las viejas historias sobre la Carnvora Vera que devor a tres gnomos el da de su cumpleaos. Est destrozando el invernadero, hay que buscar la forma de deshacerse de ella!\n";
writemessages[1600] = "La plantita parece susurrar algo...\n";
writemessages[1601] = "El agua cae desde no mucha altura entre las rocas, formando un bello espectculo. El rumor del agua al caer y la humedad en el ambiente confiere a este claro un encanto especial.\n";
writemessages[1602] = "Fra y cristalina. Puro manantial de montaa.\n";
writemessages[1603] = "Superado el salto de agua y el pequeo lago, el estrecho riachuelo se aleja mansamente entre los rboles recubiertos de musgo y lquenes.\n";
writemessages[1604] = "El pequeo lago presenta orillas escapadas... era muy fcil lanzarse a l... pero solo t sabes lo que te costaba salir una vez dentro...\n";
writemessages[1605] = "Tras el salto de agua se forma un pequeo lago, no muy profundo, de aguas fras y cristalinas. Tus primeras brazadas las diste aqu, y aqu has pasado innumerables tardes de verano con tus amigos... Hasta donde tu puedes recordar nunca viste ni solo pez en este lago.\n";
writemessages[1606] = "Los rboles se yerguen a ambos lados del riachuelo, hundiendo sus viejas races en l... por el efecto del fro y la humedad estn recubiertos de una espesa capa de musgo y lquenes que les confieren un curioso color verde. Sus ramas superiores se retuercen buscando los rayos del sol. Son verdaderos rboles de cuento.\n";
writemessages[1607] = "Se hace ms densa conforme te acercas a la orilla del lago. Verde y saludable. No se pueden quejar, no.\n";
writemessages[1608] = "Una pequea y negruzca pizca de pimienta... sabrosa, pero muy picante.\n";
writemessages[1609] = "Una pizca de pimienta.";
writemessages[1610] = "Est en el interior del cajn del elevador.\n";
writemessages[1611] = "Un tapn de corcho, redondo y no muy largo que tapona la botella.\n";
writemessages[1612] = "Un tapn de corcho, redondo y no muy largo.";
writemessages[1613] = "Un tapn de corcho, redondo y no muy largo.\n";
writemessages[1614] = "El frasco contiene un lquido azul, no muy espeso... el extrao elixir para olvidar... del que precisamente no recuerdas haber odo hablar nunca.";
writemessages[1615] = "Se trata de un pequeito frasco de cristal de forma extraa.";
writemessages[1616] = "Se trata de un pequeito frasco de cristal de forma extraa y lleno de un extrao lquido azul. Tiene una etiqueta pegada en la que puedes leer 'Elixir para olvidar'.";
writemessages[1617] = " Est tapado por un tapn de corcho.\n";
writemessages[1618] = " Est abierto.\n";
writemessages[1619] = "Se trata de una senda que atraviesa el bosque en direccin norte-sur. Aqu termina frente a la puerta del invernadero, hacia el sur te conduce a tu claro.\n";
writemessages[1620] = "Esta parte del bosque est invadida de helechos y matorrales, que amenazan las herrumbrosas paredes del invernadero. Dentro de este, la cuidada vegetacin original ha dado paso a una exhuberancia salvaje.\n";
writemessages[1621] = "Evocas la imagen del Doctor, con su negra barba y su frondosa cabellera... qu habr sido de l?\n";
writemessages[1622] = "Se trata de una vieja regadera metlica, modelo clsico, muy desmejorada seguramente por haber pasado una larga temporada a la intemperie.";
writemessages[1623] = " Observas con tristeza que tiene incluso un pequeo orificio casi redondo en una de sus caras.";
writemessages[1624] = " Satisfecho observas el apao que has hecho en el orificio con la ayuda del tapn de corcho.";
writemessages[1625] = " Est vaca.\n";
writemessages[1626] = " Est llena de agua.\n";
writemessages[1627] = "Se trata de una vieja regadera, modelo clsico, muy desmejorada seguramente por haber pasado una larga temporada a la intemperie.";
writemessages[1628] = "Viejo y oxidado... no resistir mucho ms.\n";
writemessages[1629] = "Ya de deshiciste de l.\n";
writemessages[1630] = "La desvencijada puerta del invernadero est cerrada por un viejo candado.";
writemessages[1631] = "Abierta a la fuerza, la puerta se sostiene ms mal que bien por uno slo de sus goznes.";
writemessages[1632] = "Blanco y acristalado, conserva todava el estilo aristocrtico que tuvo cuando fue construido, pero ahora la suciedad y el abandono estn empezando a hacer mella en l.";
writemessages[1633] = " Tiene una desvencijada puerta cerrada por un viejo candado.";
writemessages[1634] = " Ahora el invernadero est abierto.";
writemessages[1635] = "Varias cuidadas sendas de tierra apisonada y delimitadas por piedras se cruzan en el centro del claro y se adentran en lo ms profundo del bosque.\n";
writemessages[1636] = "Varias cuidadas sendas de tierra apisonada y delimitadas por piedras se cruzan en el centro del claro y se adentran en lo ms profundo del bosque.\n";
writemessages[1637] = "Blancas piedras se han colocado a intervalos regulares a lo largo de las sendas para delimitar estas.";
writemessages[1638] = "Alzas la cabeza y entre las ramas del rbol puedes apenas distinguir las formas de tu elevada casa.";
writemessages[1639] = "Verde y frondoso, menos poblado que hace unos aos, es lo que todo gnomo puede desear como hogar.";
writemessages[1640] = "Rodeado de rboles por todas partes, el claro se constituye en un agradable cruce de caminos para varias de las sendas que cruzan el bosque de lado a lado.";
writemessages[1641] = "Desde aqu tan solo puedes apreciar el tpico formulario de correos.\n";
writemessages[1642] = "Se trata de una pequea llave, con una solitaria letra R grabada en la parte superior.\n";
writemessages[1643] = "Se trata de una pequea llave, con una solitaria letra R grabada en la parte superior.";
writemessages[1644] = "Desde aqu tan solo puedes apreciar el tpico formulario de correos.";
writemessages[1645] = "DESTINATARIO: Rudolphine Rur. Casa del rbol s/n. Claro del Bosque. Valle.\n";
writemessages[1646] = "REMITENTE: Agostine Rur. Fuente Fantasa. Parque Central. Gran Ciudad.\n";
writemessages[1647] = "Se trata de un telegrama de tu hermano Agostine!\n";
writemessages[1648] = "Desde aqu tan solo ves que se trata de un grueso sobre.\n";
writemessages[1649] = "Desde aqu tan solo ves que se trata de un grueso sobre.";
writemessages[1650] = "Una gruesa carta...\n";
writemessages[1651] = "DESTINATARIO: Dr. Van Hallen. Vlaming Straat. Brujas.\n";
writemessages[1652] = "REMITENTE: Josep Coletas (Coletes?) Caubet. Tor. Lleida.\n";
writemessages[1653] = "Sin duda se trata de un error del servicio postal...\n";
writemessages[1654] = "Se trata de un pedazo de vidrio de las destrozadas paredes del invernadero. Lo manejas con cuidado, ya que por un lado est afilado como un cuchillo.";
writemessages[1655] = "Se trata de un pedazo de vidrio de las destrozadas paredes del invernadero.";
writemessages[1656] = "La cuerda est atada con un nudo pequeo pero puetero. El simptico cartero debi atarlo a conciencia despus de dejar la correspondencia.";
writemessages[1657] = "Viejo, gastado y destartalado. Su sujecin al suelo no es muy segura. Lo encontraste tirado en un Eco-Parque y decidiste usarlo. Una nueva muestra de la economa gnmica. Tu relacin con la Gnomo-Postal-Service se ha deteriorado bastante por esta decisin, ya que ellos 'subvencionan' buzones nuevos a unos mdicos precios.";
writemessages[1658] = " El buzn est cerrado. Una cuerdecilla sostiene la tapa.\n";
writemessages[1659] = " Ahora el buzn permanece abierto.";
writemessages[1660] = " En el interior del buzn puedes ver ";
writemessages[1661] = "Observas orgulloso tu ingenioso sistema elevador. Este consiste bsicamente en un enorme muelle anclado al suelo que sostiene en su parte superior una pequeo cajn de madera.";
writemessages[1662] = " El muelle est ahora mismo extendido y el cajn queda varios palmos por encima del suelo.";
writemessages[1663] = " Aplastado por el peso de la piedra, el muelle est comprimido, quedando el borde del cajn tan solo un par de palmos por encima del suelo.";
writemessages[1664] = " Dentro del cajn puedes ver ";
writemessages[1665] = "Se trata de una piedra casi cuadrada, de aspecto pesado, aunque unos huecos en ambos laterales permiten cogerla con facilidad. En la parte superior puedes observar toscamente talladas las iniciales 'R.R.'";
writemessages[1666] = "Se trata de una piedra casi cuadrada, de aspecto pesado, aunque unos huecos en ambos laterales permiten cogerla con facilidad. En la parte superior puedes observar toscamente talladas las iniciales 'R.R.'";
writemessages[1667] = "Extrao... te preguntas que utilidad podra tener...";
writemessages[1668] = "Extrao... te preguntas que utilidad podra tener...";
writemessages[1669] = "Tpico paraguas gnmico, de color oscuro (como corresponde a los gnomos masculinos) y tamao medio (exactamente como la mitad de tu estatura). Construido con flor seca de nenfar y varillas de madera de pino. El un lateral sobresale una etiqueta: 'Pepito Grillo Inc.' ";
writemessages[1670] = "Est abierto.";
writemessages[1671] = "Est cerrado.";
writemessages[1672] = "Tpico paraguas gnmico, de color oscuro (como corresponde a los gnomos masculinos) y tamao medio (exactamente como la mitad de tu estatura). Construido con flor seca de nenfar y varillas de madera de pino. El un lateral sobresale una etiqueta: 'Pepito Grillo Inc.' ";
writemessages[1673] = "Est cerrado.";
writemessages[1674] = "Est abierto.";
writemessages[1675] = "Viejo y robusto es la definicin que ms pronto te viene a la cabeza cuando piensas en 'tu' rbol. Aunque segn el certificado de propiedad (que debes conservar en alguna parte) el rbol forma parte de tus pertenencias ests seguro que mucho tiempo despus de que t desaparezcas el rbol seguir aqu, igual que estaba ya mucho tiempo antes de que t aparecieras por aqu.";
writemessages[1676] = "Viejo y robusto es la definicin que ms pronto te viene a la cabeza cuando piensas en 'tu' rbol. Aunque segn el certificado de propiedad (que debes conservar en alguna parte) el rbol forma parte de tus pertenencias ests seguro que mucho tiempo despus de que t desaparezcas el rbol seguir aqu, igual que estaba ya mucho tiempo antes de que t aparecieras por aqu.";
writemessages[1677] = "Cientos de ellos.";
writemessages[1678] = "Tu casa est construida entre las ramas de un robusto y viejo rbol, un lugar no adecuado para humanos con vrtigo (bah!) pero muy corriente entre los gnomos. Para conseguir este rbol tuviste que pujar duro en la subasta del Valle contra una numerosa familia de ardillas. Pero ganaste... y aqu ests.";
writemessages[1679] = "La puerta de tu casa est abierta.";
writemessages[1680] = "El tejado de la casa tiene forma de V invertida y est recubierto de tejas de barro cocido, cortesa del viejo Doctor (le sobraron al recubrir el tejado de su vieja casa).";
writemessages[1681] = "Desde aqu tienes una magnfica vista de tu querido bosque. Verde y frondoso, menos poblado que hace unos aos, es lo que todo gnomo puede desear como hogar.";
writemessages[1682] = "Abajo, junto a tu rbol, puedes ver el tapizado suelo del claro. La distancia (vertical) desde aqu es como mnimo considerable.";
writemessages[1683] = "Decoradas columnas sostienen el techo del porche. El equipo de albailes y carpinteros que construyeron tu casa realizaron un trabajo a la altura de la factura que presentaron.";
writemessages[1684] = "Una muralla de negras y nevadas montaas separa el Valle del mundo humano exterior. Si alguna vez tuvieron nombre ya ha sido olvidado. Amadas y temidas por igual por todos los habitantes del Valle, pocos son los que se han atrevido a escalar sus empinadas cuestas. Algunos afirman que estn habitadas por gigantes... pero los gnomos juiciosos como t no creen en estas y otras criaturas de leyenda.";
writemessages[1685] = "El banco es otra muestra de artesana gnmica de las muchas que conservas en tu hogar. Fue el regalo de tu abuelo el da que decidiste emanciparte. l, como todos los gnomos ancianos no entiende la vida sin un buen banco donde descansar y una buena pipa con la que fumar.";
writemessages[1686] = " Apoyado en el banco se encuentra tu viejo paraguas.";
writemessages[1687] = "El banco es otra muestra de artesana gnmica de las muchas que conservas en tu hogar. Fue el regalo de tu abuelo el da que decidiste emanciparte. l, como todos los gnomos ancianos no entiende la vida sin un buen banco donde descansar y una buena pipa con la que fumar.";
writemessages[1688] = "Forma un porche amplio y laminado... el preludio perfecto a una perfecta casa.- repeta una y otra vez el agente inmobiliario.";
writemessages[1689] = "Circundado por una alta cadena montaosa la mayor parte del Valle est cubierta por un frondoso bosque, entre los que conviven las ms diversas especies vegetales. El Valle es el lugar de donde nunca quisieras irte y a donde siempre querras volver. Es... tu hogar.";
writemessages[1690] = "Circundado por una alta cadena montaosa la mayor parte del Valle est cubierta por un frondoso bosque, entre los que conviven las ms diversas especies vegetales. El Valle es el lugar de donde nunca quisieras irte y a donde siempre querras volver. Es... tu hogar.";
writemessages[1691] = "Se trata de una vela gnmica hecha a base de un material parecido a la cera pero que nunca se extingue. Est apagada.";
writemessages[1692] = "Se trata de una vela gnmica hecha a base de un material parecido a la cera pero que nunca se extingue. Est encendida.";
writemessages[1693] = "Se trata de una pequea caja de cerillas en donde puedes leer la publicidad (engaosa?): 'interlap.com.ar tu correo POP3 gratis para toda la vida!'";
writemessages[1694] = "En su interior hay ";
writemessages[1695] = " cerillas.";
writemessages[1696] = "Se trata de una pequea caja de cerillas en donde puedes leer la publicidad (engaosa?): 'interlap.com.ar tu correo POP3 gratis para toda la vida!'";
writemessages[1697] = "En su interior tan slo queda 1 cerilla. sala bien!";
writemessages[1698] = "Se trata de una pequea caja de cerillas en donde puedes leer la publicidad (engaosa?): 'interlap.com.ar tu correo POP3 gratis para toda la vida!'";
writemessages[1699] = " Est vaca.";
writemessages[1700] = "Se trata de una pequea caja de cerillas en donde puedes leer la publicidad (engaosa?): 'interlap.com.ar tu correo POP3 gratis para toda la vida!'";
writemessages[1701] = " Est vaca.";
writemessages[1702] = "Se trata de una pequea caja de cerillas en donde puedes leer la publicidad (engaosa?): 'interlap.com.ar tu correo POP3 gratis para toda la vida!'";
writemessages[1703] = "En su interior hay ";
writemessages[1704] = " cerillas.";
writemessages[1705] = "Se trata de una pequea caja de cerillas en donde puedes leer la publicidad (engaosa?): 'interlap.com.ar tu correo POP3 gratis para toda la vida!'";
writemessages[1706] = "En su interior tan slo queda 1 cerilla. sala bien!";
writemessages[1707] = "Se trata de una pequea caja de cerillas en donde puedes leer la publicidad (engaosa?): 'interlap.com.ar tu correo POP3 gratis para toda la vida!'";
writemessages[1708] = " Est vaca.";
writemessages[1709] = "Se trata de una pequea caja de cerillas en donde puedes leer la publicidad (engaosa?): 'interlap.com.ar tu correo POP3 gratis para toda la vida!'";
writemessages[1710] = " Est vaca.";
writemessages[1711] = "Mrala que ojitos tiene... es idntica a su padre! Canturrea alegremente sobre tu hombro.";
writemessages[1712] = ">>>>Y t de donde sacas que hay un bal por aqu, majete?? Ah! el grfico... vers... los grficos no los hago yo, son escaneados y me tengo que conformar con lo que sale y adems en una aventura es el texto lo importante y as que nada de intentar abrir bal con llave misteriosa ni nada por el estilo!!!!<<<<";
writemessages[1713] = "Extraas voces resuenan en tu cabeza... Pero pronto todo vuelve a la normalidad. En un rincn bajo la ventana el bal est baado por el sol. Su interior... vaco como tu cuenta corriente!";
writemessages[1714] = "Nunca has hecho mucho caso a las tendencias. Algunos abrigos y chaquetas. Tu pijama y poco ms.";
writemessages[1715] = " Rebuscando en los bolsillos encuentras una misteriosa llave...";
writemessages[1716] = "Nunca has hecho mucho caso a las tendencias. Algunos abrigos y chaquetas. Tu pijama y poco ms.";
writemessages[1717] = "No te dejes impresionar por la palabra 'magia'. No se trata de magia! (o mejor an tu preferido 'magia potagia'). Estos objetos 'mgicos' pueden desafiar alguna ley fsica (ingravidez, invisibilidad, etc), pero slo t sabes la dedicacin en tiempo y dinero que te ha llevado su construccin. Adems, su consumo de bateras es inaudito! por lo que mejor dejarlos donde estn.";
writemessages[1718] = "Redonda y verde... puro estilo hobb... digo gnomo... Permanece abierta.";
writemessages[1719] = "Acristalada y aclimatada. Deja pasar la luz pero no el calor. Un lujo.";
writemessages[1720] = "Los perdiste! Un regalo de tu prima Esther.";
writemessages[1721] = "Regalo de mam. Segn ella lo compr durante un viaje a Estados Unidos durante su quincuagsimo-tercer aniversario de boda. Segn tu padre fue un regalo de la ta Emegilda. Peludo, polvoriento y con la sonriente inscripcin 'Home sweet home'.";
writemessages[1722] = "La chimenea que no suele faltar en todo hogar gnomo. Austera y funcional. Hace aos que no la enciendes. Casi tantos como desde que el nuevo guardabosques prohibi cortar lea en unos cientos de millas a la redonda. Encima de la chimenea encuentras una caja de cerillas.";
writemessages[1723] = "La chimenea que no suele faltar en todo hogar gnomo. Austera y funcional. Hace aos que no la enciendes. Casi tantos como desde que el nuevo guardabosques prohibi cortar lea en unos cientos de millas a la redonda.";
writemessages[1724] = "No tienes reloj! Eres un hombre libre de las ataduras y obligaciones del tiempo! Bueno, ejem... menos los das laborales!";
writemessages[1725] = "Ennegrecidos, aboyados y amontonados los enseres ocupan buena parte de la cocina. La gastronoma por desgracia no es tu fuerte.";
writemessages[1726] = "Ennegrecidos, aboyados y amontonados los enseres ocupan buena parte de la cocina. La gastronoma por desgracia no es tu fuerte.";
writemessages[1727] = "Entre unas cosas y otras encuentras un arenque rojo y una salchicha.";
writemessages[1728] = "Ennegrecidos, aboyados y amontonados los enseres ocupan buena parte de la cocina. La gastronoma por desgracia no es tu fuerte.";
writemessages[1729] = "Entre unas cosas y otras encuentras un arenque rojo y una salchicha.";
writemessages[1730] = "Ennegrecidos, aboyados y amontonados los enseres ocupan buena parte de la cocina. La gastronoma por desgracia no es tu fuerte.";
writemessages[1731] = "Se trata de tu viejo martillo de zapatero. Ancho, de madera y rodo por las termitas. No en vano lo heredaste de tu abuelo cuando cumpliste la mayora de edad y decidiste abandonar la universidad. Ah, loca juventud... pero que se le puede reprochar a un joven de 83 aos! El martillo... tan temido por las puntas de los zapatos como por los zagales del rbol vecino.";
writemessages[1732] = "Una pequea termita sale del martillo y se posa amorosamente sobre tu hombro.";
writemessages[1733] = "Se trata de tu viejo martillo de zapatero. Ancho, de madera y rodo por las termitas. No en vano lo heredaste de tu abuelo cuando cumpliste la mayora de edad y decidiste abandonar la universidad. Ah, loca juventud... pero que se le puede reprochar a un joven de 83 aos! El martillo... tan temido por las puntas de los zapatos como por los zagales del rbol vecino.";
writemessages[1734] = "Se trata de tu viejo martillo de zapatero. Ancho, de madera y rodo por las termitas. No en vano lo heredaste de tu abuelo cuando cumpliste la mayora de edad y decidiste abandonar la universidad. Ah, loca juventud... pero que se le puede reprochar a un joven de 83 aos! El martillo... tan temido por las puntas de los zapatos como por los zagales del rbol vecino.";
writemessages[1735] = "Una pequea termita sale del martillo y se posa amorosamente sobre tu hombro.";
writemessages[1736] = "Se trata de tu viejo martillo de zapatero. Ancho, de madera y rodo por las termitas. No en vano lo heredaste de tu abuelo cuando cumpliste la mayora de edad y decidiste abandonar la universidad. Ah, loca juventud... pero que se le puede reprochar a un joven de 83 aos! El martillo... tan temido por las puntas de los zapatos como por los zagales del rbol vecino.";
writemessages[1737] = "Tu desvencijado catre Cuantos sueos (y pesadillas) has vivido mientras te acurrucabas entre sus mantas!";
writemessages[1738] = "Viejo y puntiagudo, el sombrero gnmico es un elemento esencial de tu vestimenta: te protege la cabeza del fro, te ayuda a pensar y sostiene una vela...";
writemessages[1739] = "Me temo que no he entendido qu es lo que quieres examinar.\n";
writemessages[1740] = "No tiene nada ms destacable.\n";
writemessages[1741] = "Debers recurrir de nuevo al megasalto.\n";
writemessages[1742] = "La nica salida es oeste, hacia el despacho.\n";
writemessages[1743] = "Hacia el oeste vuelves al pasillo. Hacia el este hay otra estancia.\n";
writemessages[1744] = "Hacia el este entras en el despacho. Tambin puedes bajar a la planta baja por las escaleras.\n";
writemessages[1745] = "Hacia el sur vuelves al recibidor.\n";
writemessages[1746] = "La nica salida es oeste, hacia el recibidor.\n";
writemessages[1747] = "Hacia el norte queda la cocina, hacia el este una estancia amplia que parece ser una especie de saln. Las escaleras suben al piso superior. La puerta de salida os permitir escapar si rescatas a Agostine.\n";
writemessages[1748] = "Hacia el sur queda la verja de salida, hacia el norte rodeas la casa caminando por el jardn. Seguro que se te ocurre la forma de entrar en la casa.\n";
writemessages[1749] = "Hacia el norte est la entrada de la casa, salir te proporcionar la libertad.\n";
writemessages[1750] = "La nica opcin es salir.\n";
writemessages[1751] = "Hacia el oeste sales del garaje otra vez al jardn.\n";
writemessages[1752] = "Las salidas posibles son, norte para ir a la parte de atrs, este para entrar al garaje y sur para ir a la fachada principal de la casa.\n";
writemessages[1753] = "Puedes rodear la casa caminando hacia el sur.\n";
writemessages[1754] = "Aparentemente ests encerrado sin salida... o no?\n";
writemessages[1755] = "La nica salida es salir.\n";
writemessages[1756] = "La fuente y la vegetacin forman un callejn sin salida, ahora mismo tu nica salida es oeste.\n";
writemessages[1757] = "Entrar a casa de Agostine y caminar hacia el oeste hacia la salida del parque son tus opciones.\n";
writemessages[1758] = "Hacia el este llegas casi al centro del Parque. La salida se encuentra hacia el oeste.\n";
writemessages[1759] = "Hacia el este te internas en el interior del parque. Hacia el oeste cruzas la calle hacia las afueras de la ciudad.\n";
writemessages[1760] = "Hacia el norte regresas al oscuro callejn. La ciudad se extiende en todas direcciones, pero no tienes tiempo para hacer turismo, as que lo mejor sera cruzar la calle para llegar al parque.\n";
writemessages[1761] = "Hacia el norte abandonas la ciudad y tomas el camino del Valle. Hacia el sur te acercas al Parque Central dnde vive tu hermano.\n";
writemessages[1762] = "Hacia el oeste tomas la carretera que te llevar al interior del Valle. Hacia el norte penetras en el macizo montaoso. Hacia el sur empieza el mundo humano.\n";
writemessages[1763] = "Hacia el este vuelves al claro.\n";
writemessages[1764] = "La nica salida posible es salir.\n";
writemessages[1765] = "Hacia el oeste vuelves a 'tu' claro. Hacia el sur oyes un leve murmullo de agua. Entrar a la seta, aunque parezca raro tambin debe de ser una posible salida.\n";
writemessages[1766] = "Hacia el norte llegas al claro, hacia el sur el camino te lleva hacia la salida del Valle.\n";
writemessages[1767] = "Tan solo puedes salir al bosque otra vez.\n";
writemessages[1768] = "Hacia el norte puedes desandar lo andado...\n";
writemessages[1769] = "Hacia el sur puedes volver al claro bajo tu rbol. Tambin puedes tratar de entrar en el invernadero.\n";
writemessages[1770] = "Hacia el este puedes tomar el camino largo para atravesar las montaas, hacia el oeste penetras en el interior del macizo montaoso. Hacia el norte te adentras en el Valle.\n";
writemessages[1771] = "Hacia el oeste puedes tomar el camino largo para regresar al Valle, hacia el norte puedes regresar al Valle atravesando las montaas.\n";
writemessages[1772] = "Hacia el este y hacia el sur los intrincados senderos montaosos se extienden.\n";
writemessages[1773] = "La red de sendas montaosas se extienden en todas direcciones, norte, sur, este y oeste.\n";
writemessages[1774] = "La red de sendas montaosas se extienden en todas direcciones, norte, sur, este y oeste.\n";
writemessages[1775] = "La red de sendas montaosas se extienden en todas direcciones, norte, sur, este y oeste.\n";
writemessages[1776] = "La red de sendas montaosas se extienden en todas direcciones, norte, sur, este y oeste.\n";
writemessages[1777] = "La red de sendas montaosas se extienden en todas direcciones, norte, sur, este y oeste.\n";
writemessages[1778] = "La red de sendas montaosas se extienden en todas direcciones, norte, sur, este y oeste.\n";
writemessages[1779] = "Atravesando la puerta puedes salir al porche exterior.";
writemessages[1780] = "Atravesando la puerta puedes entrar en la casa. Miras hacia abajo pensativamente, pensando como podras llegar hasta el suelo.";
writemessages[1781] = "Varias sendas se pierden hacia el norte, el sur, el este y el oeste. Miras pensativamente a tu casa pensando en la forma de conseguir llegar hasta ella.";
writemessages[1782] = "El malvado pirata te roba _!\n";
writemessages[1783] = "El malvado pirata se marcha contento con su botn.\n";
writemessages[1784] = "El pirata se marcha sin robarte nada, has tenido suerte!\n";
writemessages[1785] = "No tienes ms ganas de jugar a este estpido juego... teclear las rdenes? qu estamos, en 1980? Prefieres tu PS2.\n";
writemessages[1786] = "Sacas el disquette del ordenador.\n";
writemessages[1787] = "Now the green door is open.\n";
writemessages[1788] = "The door is locked.\n";
writemessages[1789] = "The door is locked.\n";
writemessages[1790] = "Now the green door is closed.\n";
writemessages[1791] = "You take the curious map.\n";
writemessages[1792] = "You examine the curious map.\n";
writemessages[1793] = "There seem to be some symbols on it but you cannot read them.\n";
writemessages[1794] = "Thorin says: 'Hurry up'\n";
writemessages[1795] = "The green door is closed.\n";
writemessages[1796] = "En la pantalla aparece otro feucho dibujo de un prado? y el siguiente texto:\n";
writemessages[1797] = "You are in a gloomy empty land with dreary hill ahead.\n";
writemessages[1798] = "To the west there is the round green door.\n";
writemessages[1799] = "Visibles exits are: east northeast\n";
writemessages[1800] = "Thorin enters.\n";
writemessages[1801] = "You are in a hidden path with trolls foot prints.\n";
writemessages[1802] = "To the north there is the heavy rock door.\n";
writemessages[1803] = "Visible exits are: south.\n";
writemessages[1804] = "You see: nothing.\n";
writemessages[1805] = "Thorin enters.\n";
writemessages[1806] = "You are in a hidden path with trolls foot prints.\n";
writemessages[1807] = "To the north there is the heavy rock door.\n";
writemessages[1808] = "Visible exits are: south.\n";
writemessages[1809] = "You see: nothing.\n";
writemessages[1810] = "Thorin enters.\n";
writemessages[1811] = "You are in a comfortable tunnel like hall. To the east there is the round green door.\n";
writemessages[1812] = "You see:\n";
writemessages[1813] = "The wooden chest.\n";
writemessages[1814] = "A curios map.\n";
writemessages[1815] = "Thorin enters.\n";
writemessages[1816] = "Parece que los grficos no van a mejorar... Debajo de lo que parece ser un claro de un bosque aparece...\n";
writemessages[1817] = "You are in the trolls clearing.\n";
writemessages[1818] = "Visibles exits are: southwest southeast north\n";
writemessages[1819] = "Thorin enters.\n";
writemessages[1820] = "You see:\n";
writemessages[1821] = "The hideous troll.\n";
writemessages[1822] = "The vicious troll.\n";
writemessages[1823] = "You are in the trolls clearing.\n";
writemessages[1824] = "Visibles exits are: southwest southeast north\n";
writemessages[1825] = "Thorin enters.\n";
writemessages[1826] = "You see:\n";
writemessages[1827] = "The hideous troll.\n";
writemessages[1828] = "The vicious troll.\n";
writemessages[1829] = "Parece que los grficos no van a mejorar... Debajo de lo que parece ser un claro de un bosque aparece...\n";
writemessages[1830] = "You are in the trolls clearing.\n";
writemessages[1831] = "Visibles exits are: southwest southeast north\n";
writemessages[1832] = "Thorin enters.\n";
writemessages[1833] = "You see:\n";
writemessages[1834] = "The hideous troll.\n";
writemessages[1835] = "The vicious troll.\n";
writemessages[1836] = "You are in a gloomy empty land with dreary hill ahead.\n";
writemessages[1837] = "To the west there is the round green door.\n";
writemessages[1838] = "Visibles exits are: east northeast";
writemessages[1839] = "Thorin enters.\n";
writemessages[1840] = "You are in a gloomy empty land with dreary hill ahead.\n";
writemessages[1841] = "To the west there is the round green door.\n";
writemessages[1842] = "Visibles exits are: east northeast";
writemessages[1843] = "Thorin enters.\n";
writemessages[1844] = "The hideous troll eat you.\n";
writemessages[1845] = "His foul gluttony has killed the hideous troll.\n";
writemessages[1846] = "You are dead.\n";
writemessages[1847] = "You have mastered the 2.5% of this adventure.\n";
writemessages[1848] = "Me ha comido? Oh vamos!\n";
writemessages[1849] = "You are in a comfortable tunnel like hall. To the east there is the round green door.\n";
writemessages[1850] = "You see:\n";
writemessages[1851] = "The wooden chest.\n";
writemessages[1852] = "A curios map.\n";
writemessages[1853] = "Thorin.\n";
writemessages[1854] = "Thorin sits down and starts singing about gold.\n";
writemessages[1855] = "You see the wooden chest.\n";
writemessages[1856] = "The hideous troll eat you.\n";
writemessages[1857] = "His foul gluttony has killed the hideous troll.\n";
writemessages[1858] = "You are dead.\n";
writemessages[1859] = "You have mastered the 2.5% of this adventure.\n";
writemessages[1860] = "Parece que la has cagado.\n";
writemessages[1861] = "You are in a comfortable tunnel like hall. To the east there is the round green door.\n";
writemessages[1862] = "You see:\n";
writemessages[1863] = "The wooden chest.\n";
writemessages[1864] = "A curios map.\n";
writemessages[1865] = "Thorin.\n";
writemessages[1866] = "Thorin says: Hurry up!\n";
writemessages[1867] = "You cannot go west.\n";
writemessages[1868] = "You cannot go south.\n";
writemessages[1869] = "You cannot go north.\n";
writemessages[1870] = "You cannot go east.\n";
writemessages[1871] = "You cannot go southwest.\n";
writemessages[1872] = "You cannot go southeast.\n";
writemessages[1873] = "You cannot go northwest.\n";
writemessages[1874] = "You cannot go northeast.\n";
writemessages[1875] = "En la pantalla aparece el siguiente mensaje:\n";
writemessages[1876] = "What?\n";
writemessages[1877] = "Este estpido ordenador no entiende nada de nada!\n";
writemessages[1878] = "Tras lo que pueden haber sido horas vuelves poco a poco en ti...\n";

// LOCATION MESSAGES

total_location_messages=44;

locations = [];

locations[0] = "\n\n\n\n Las Aventuras de Rudolphine Rur\n Una aventura de Dwalin\n Betatesters: Uto, Diego, Roco y Jenesis\n Programada con el Supergls de Uto, YokiYoki y Baltasar el Arquero\n Gracias a Adeptus por sus ideas y a Lenko, Diyey y Urbatain por su reportes.\n (c) 2005 Dwalin\n\n REVISIN 2 - Recompilada en enero de 2015 para ngPAWS\n\n";
locations[1] = "La Casa del rbol. Es decir, el nombre con el que llamas cariosamente a tu casa. En realidad no es gran cosa, una sola habitacin donde se hacinan tu pequeo catre, tus libros, tu escasa ropa, tu taller de objetos mgicos, fotografas de todos tus viajes y ennegrecidos enseres de cocina. A travs de la puerta y la ventana puedes or a los pjaros cantar cuando sale el sol, por lo que decidiste vender tu ltimo reloj (de cuco!). En un rincn, la chimenea permanece apagada... desde por lo menos 1888! El ltimo gran invierno cuando se hel el lago y estrenaste unos nuevos patines... que no sabes donde estn. En definitiva, home sweet home, como reza el felpudo de dudoso gusto que tu madre coloc junto a la puerta y an no te has atrevido a quitar!\n";
locations[2] = "La LoCalidad VirtuaL de los ObjeTos-No-CreaDos.\n";
locations[3] = "El viejo invernadero del Doctor presenta un aspecto muy descuidado desde que este se volvi demasiado viejo o demasiado aburrido para cuidarlo. Pasaste tu niez entre sus plantas, escuchando las historias que el Doctor repeta una y otra vez, pero que a todos os encantaba escuchar. Ahora que el viejo ha desaparecido las plantas se han rebelado contra la estrechez de sus macetas y con bro se han lanzado a la conquista de ms espacio vital. Es la guerra: palmeras contra hortensias, lirios y rosales, todos luchan por los mejores rayos de sol, el agua ms fresca y la tierra ms rica. Dan miedo.\n";
locations[4] = "Ests en el porche de tu elevada casa. El 'porche' es en realidad una plataforma de madera de aproximadamente 5x3 metros ante la puerta, robustas columnas sostienen un desvencijado techo de teja que proporciona sombra al porche y lo protege de la lluvia... y la nieve! Construida sobre un viejo rbol, la posicin privilegiada de tu casa te permite tener una envidiable vista del bosque circundante y los sombros pero a la vez familiares picos que separan el Valle del mundo humano exterior. Junto a la puerta y bajo la ventana se encuentra tu querido viejo banco de madera, construido artesanalmente por tu propio abuelo, tu lugar favorito de relajacin en las largas noches de verano. Asomndote con cuidado al borde de la plataforma puedes ver abajo el claro del bosque.\n";
locations[5] = "El bosque, verde, limpio y hmedo por las recientes lluvias rodea un pequeo claro, donde se haya tu casa. Bueno, tu rbol, y en la cima de este tu casa. Con su verde suelo, tapizado de un cuidado csped, este es uno de los claros ms 'chic' de esta parte del Valle (como recuerdas cada mes cuando llega el recibo de la hipoteca!), la envidia de muchos gnomos. El claro sirve tambin como cruce para varias sendas, estas, bien cuidadas y delimitadas por piedras, se pierden en varias direcciones adentrndose en el bosque. Junto a tu rbol se alza, en precario equilibro tu viejo buzn postal, una antigualla que encontraste tirada por ah y decidiste aprovechar cuando estrenaste tu recin conquistada independencia. Entre el buzn y el rbol se encuentra tu ingenioso sistema 'elevador'.\n";
locations[6] = "Esta es la localidad encima-de-la-plataforma elevadora para los objetos que pongamos all.\n";
locations[7] = "Esta es la localidad en-el-interior-del-buzn.\n";
locations[8] = "La senda te ha conducido frente al viejo invernadero del Doctor. Extrao personaje, el nico humano que has visto visitar con asiduidad el Valle... Se mand construir este invernadero con paredes de cristal porqu deca que no haba tierra como la de este lugar para hacer crecer las plantas, y que aqu todo vegetal acababa por tener elementos beneficiosos para la salud. Los viejos curanderos gnomos movan la cabeza y no osaban contradecirlo, pero sabes de buena tinta que ms de uno se ha alegrado de no volverlo a ver por aqu en muuucho tiempo. Las paredes del viejo invernadero todava brillan cuando sobre ellas inciden los rayos del sol, aunque a su alrededor (y en su interior!) la vegetacin lo ha invadido todo.\n";
locations[9] = "Has llegado a una de las partes ms viejas del bosque. Los rboles de este claro ya haban crecido y cado miles de veces antes que ningn gnomo, o cualquier otro habitante del bosque llegase aqu. Se trata pues de rboles viejos, carcomidos y caprichosos, algunos an se yerguen, doblados bajo el peso de los aos, pero orgullosos de su pasado, y rumiando viejas historias para sus races. Otros, como el viejo tocn que tienes ante ti ya no soport su ltima tala, y es testigo mudo del paso del tiempo. Ningn habitante del bosque osara construirse una casa en uno de estos rboles, quin sabe que achaques pueden sobrevenirles en un fro invierno, por lo que es en el suelo donde algunos han buscado cobijo. Ante ti, a la sombra del tocn se yergue una coloreada seta.\n";
locations[10] = "Aqu ests casi en el borde del bosque. Un amplio camino entre los rboles conduce a las montaas, y ms all al mundo humano. Recuerdas la intensa emocin de esperar en este camino la llegada de tu padre o alguno de tus hermanos cuando volvan de una de sus cada vez ms peligrosas excursiones a la ciudad, y la vez que por este mismo camino lleg el propio Doctor conduciendo su flamante automvil. Ahora el camino est mucho menos transitado, y las hojas lo cubren. A lo lejos (muy lejos!) se alzan las montaas que rodean el Valle.\n";
locations[11] = "En esta parte del bosque los rboles son jvenes y crecen vigorosos. Al abrigo de sus recias ramas construisteis t y tu hermano Agostine una coqueta caseta para la mascota familiar: vuestro zorro BM. Este claro, no tan transitado como aquel donde se alza tu rbol es el lugar ideal para el descanso, los juegos y las reuniones familiares a las que acude tu amplia familia. Junto a la caseta de BM se celebr tu fiesta de mayora de edad... an rememorada por los ms juerguistas! En estos meses de otoo, sin embargo, el claro permanece vaco y silencioso.\n";
locations[12] = "Hasta tus odos llega el agradable murmullo del agua que cae por la pequea cascada que tienes ante ti. El pequeo riachuelo que atraviesa el Valle sortea la orografa del terreno formando un gracioso salto de agua. El pequeo lago (ummm laguna? charco? ms bien) es lugar de confluencia y diversin para gran parte de los habitantes del Valle en los calurosos meses de verano. Ahora mismo tan solo la espesa vegetacin pugna por un buen sitio ante la orilla. El riachuelo se pierde hacia el sur entre los rboles.\n";
locations[13] = "";
locations[14] = "El amplio camino termina ante las montaas. Aqu se bifurca en dos direcciones, por un lado la antigua ruta a travs de las montaas, tradicional va de comunicacin entre el Valle y el mundo exterior, y por otro lado una nueva carretera, pavimentada, cmoda, pero mucho ms larga que se abre paso a travs del desfiladero bordeando las altas cumbres. Sin lugar a dudas la nueva ruta es ms cmoda y directa, pero el viejo camino a travs de las montaas puede guardar extraas sorpresas en sus entrelazadas sendas.\n";
locations[15] = "Te ests internando en los estrechos senderos que atraviesan las montaas: antiguas vas pecuarias, caminos abiertos por cazadores, rutas haca pueblos abandonados hace tiempo y que se cierran cuando llegan las nevadas... Intentas tomar como punto de referencia los nevados picos, pero, poco a poco vas perdiendo el sentido de la orientacin. No es la tercera vez que pasas por delante de esa roca? Parece que ests algo perdido entre los montes.\n";
locations[16] = "Te ests internando en los estrechos senderos que atraviesan las montaas: antiguas vas pecuarias, caminos abiertos por cazadores, rutas haca pueblos abandonados hace tiempo y que se cierran cuando llegan las nevadas... Intentas tomar como punto de referencia los nevados picos, pero, poco a poco vas perdiendo el sentido de la orientacin. No es la tercera vez que pasas por delante de esa roca? Parece que ests algo perdido entre los montes.\n";
locations[17] = "Te ests internando en los estrechos senderos que atraviesan las montaas: antiguas vas pecuarias, caminos abiertos por cazadores, rutas haca pueblos abandonados hace tiempo y que se cierran cuando llegan las nevadas... Intentas tomar como punto de referencia los nevados picos, pero, poco a poco vas perdiendo el sentido de la orientacin. No es la tercera vez que pasas por delante de esa roca? Parece que ests algo perdido entre los montes.\n";
locations[18] = "Entre los nevados picos has hallado una extraa casa! Por su estructura parece imitar vagamente la silueta de un navo, aunque la robustez del tejado (para poder soportar las nevadas de las montaas) y lo rstico de los acabados no consiguen transmitir del todo esa ilusin. Se trata sin duda de la guarida del malvado pirata. La casa de un hombre de mar perdido entre fras montaas. Extrao, si no fuera por las historias que has odo desde nio de piratas que viven sobre y bajo las montaas, en misteriosos pasajes entrelazados y en sospechosa convivencia con malcarados enanos.\n";
locations[19] = "Te ests internando en los estrechos senderos que atraviesan las montaas: antiguas vas pecuarias, caminos abiertos por cazadores, rutas haca pueblos abandonados hace tiempo y que se cierran cuando llegan las nevadas... Intentas tomar como punto de referencia los nevados picos, pero, poco a poco vas perdiendo el sentido de la orientacin. No es la tercera vez que pasas por delante de esa roca? Parece que ests algo perdido entre los montes.\n";
locations[20] = "Te ests internando en los estrechos senderos que atraviesan las montaas: antiguas vas pecuarias, caminos abiertos por cazadores, rutas haca pueblos abandonados hace tiempo y que se cierran cuando llegan las nevadas... Intentas tomar como punto de referencia los nevados picos, pero, poco a poco vas perdiendo el sentido de la orientacin. No es la tercera vez que pasas por delante de esa roca? Parece que ests algo perdido entre los montes.\n";
locations[21] = "Te ests internando en los estrechos senderos que atraviesan las montaas: antiguas vas pecuarias, caminos abiertos por cazadores, rutas haca pueblos abandonados hace tiempo y que se cierran cuando llegan las nevadas... Intentas tomar como punto de referencia los nevados picos, pero, poco a poco vas perdiendo el sentido de la orientacin. No es la tercera vez que pasas por delante de esa roca? Parece que ests algo perdido entre los montes.\n";
locations[22] = "Esta es la localidad-en-el-interior-de-la-Guarida-del-Malvado-Pirata: slo objetos y similares.\n";
locations[23] = "Vistas desde el lado 'humano' las montaas circundantes del Valle parecen menos altas y menos amenazadoras, pero como muy bien sabe la tradicin, aquel que se interna por sus senderos puede verse abocado a extraos encuentros y entrelazados pasajes. Estas leyendas, firmemente arraigadas en las mentes de los humanos de la regin han protegido al Valle y a sus habitantes de molestos visitantes durante siglos... Hasta cuando durar este aislamiento? Para volver al Valle puedes utilizar la pavimentada carretera o usar las rutas montaosas.\n";
locations[24] = "Ms lejos de lo que este rpido viaje entre las montaas y este sucio callejn puede transmitir, se alza la Gran Ciudad, la ciudad humana ms prxima al Valle. Desde hace algunos aos el goteo de gnomos haca las oportunidades de trabajo, diversin y formacin que la ciudad ofrece ha sido constante. Tu hermano Agostine fue de los ltimos que march hace ahora algunos aos. No tienes muy clara la reaccin humana ante un gnomo en la ciudad, pero si has de creer aquello que has odo, los humanos han dejado hace aos de creer en la existencia de seres distintos a ellos. Si el hombre es la mesura de todas las cosas, al gnomo y al elfo se le niega su existencia, con lo que no debes temer que te tomen por nada ms que un pequeo y extravagante vagabundo.\n";
locations[25] = "Te aprietas contra la pared del edificio que tienes a tus espaldas, bajando la cabeza tratando de pasar desapercibido entre el bullicio de la ciudad. Gente, automviles, tiendas... y ms gente. No entiendes cmo un gnomo (o un humano!) quisiera vivir aqu, entre el trfico, los ruidos, y sin un rbol cerca. Bueno, cerca s, ya que al otro lado de la calle puedes ver la entrada del Parque Central. Junto a ti se alza tambin un semforo.\n";
locations[26] = "Ms all de la verja se extiende el Parque Central, el autntico pulmn verde de la Gran Ciudad. No te extraa que Agostine eligiera este lugar para vivir, ya que por lo que puedes ver desde aqu, parece ser lo ms parecido al Valle en millas a la redonda. Una oscura verja rodea el amplio parque, pero por suerte a estas horas las puertas an permanecen abiertas a los posibles visitantes. La mayora de los humanos, sin embargo, parecen demasiado ocupados como para demorarse un poco en las verdes estancias del parque. Mejor para ti.\n";
locations[27] = "Sigues un cuidado camino que se adentra hacia el interior del Parque, en busca de la 'fuente fantasa' dnde parece ser que tiene ubicada su morada Agostine. Bajo el entrelazado techo vegetal y con el sol que te da en la cara (y te hace cerrar los ojos!) piensas que despus de todo quiz no deba ser tan mala la vida en la ciudad, lejos de molestos vecinos, hambrientas plantas carnvoras, cofres ladradores y zorros rencorosos...\n";
locations[28] = "Te detienes ante lo que sin duda deber de ser la llamada por Agostine, Fuente Fantasa. Nombre adecuado, sin duda. Te asombras de que algn humano haya tenido la sensibilidad de tallar las figuras que adornan la fuente, dos delicadas imgenes de dos nios o elfos o ninfas silvestres en mrmol? verde. La fuente en si no es muy grande, pero es lo suficientemente alta como para no que no te valga la pena ni siquiera intentar trepar hasta el agua, y mucho menos hasta las imgenes. Adems, quin se fiara del agua clorada por los humanos? quin sabe a que extraos procesos qumicos la someten? y si olvidaras que eres un gnomo, zapatero para ms datos, y te convirtieras en algo as como un humano, pequeo, peludo y malhumorado? Vaya... ya empiezas a pensar como un verdadero pueblerino.\n";
locations[29] = "Qu desorden! La casa de Agostine es digna de verse. Los esfuerzos de tu madre para conseguir que sus hijos fueran modelo de pulcritud y orden gnmico no se han cumplido con Agostine. La estancia est en el ms completo desorden, como si un huracn hubiera pasado por aqu. Te preguntas como Agostine puede vivir en medio de este caos. Libros, montones de ropa, herramientas, vetustas cintas de cassete y decenas de objetos ms se amontonan aqu y all, incluso sobre el omnipresente ordenador, que preside la estancia... Por cierto, tal y como te temas, no hay rastro de Agostine por ningn lado.\n";
locations[30] = "Parece que hayas cambiado de casa! Todo lo que en otras estancias es viejo, antiguo y descuidado ha pasado en esta a ser nuevo, limpio y luminoso. Esta estancia configura un moderno despacho en el que no falta su mesa, sus estantes, su telfono y su ordenador (porttil!). La pared, pintada de un curioso color cereza desprende una agradable calidez, y est decorada por cuadros. Al otro lado del despacho, hacia el este se adivina otra estancia.\n";
locations[31] = "En contraste con el despacho esta estancia est desolada, parece que el buen gusto o el dinero utilizado en el despacho termin de pronto. Aqu parecen haberse amontonado gran parte de los muebles viejos o dems objetos inservibles que los elfos encontraron en la casa cuando la alquilaron.\n";
locations[32] = "Te encuentras ahora en un recargado saln. Las paredes y el suelo estn recubiertos de madera. Hay multitud de objetos en aparente estado de deterioro, como si varias decenas de gnomos adolescentes hubieran alquilado la casa de una vieja seora. De todas formas, los muebles, las lmparas, los libros amontonados por doquier, la pequea biblioteca que se insina a un lado... todo sugiere un pasado si no aristocrtico si quiz burgus, que, por desgracia, pas hace ya mucho tiempo.\n";
locations[33] = "Te aprietas contra un recodo de la pared para que el mayordomo humano no te vea. A veces el pequeo tamao de los gnomos es una ventaja. La cocina es quiz la estancia ms agradable que has visto hasta ahora de la casa, en realidad en este fro otoo cualquier lugar caliente lo es. La cocina es vieja, bueno, ms que vieja, antigua, el horno, las mesas, todo rezuma un aroma a aos de guisos y pucheros. Afortunadamente (para los elfos) todo parece muy limpio, el mayordomo humano parece eficiente. Olisqueas el aroma del guiso que est preparando mientras recuerdas con pena cuando fue la ltima vez que comiste.\n";
locations[34] = "No sabes como has llegado hasta aqu... Tan slo recuerdes que estabas enfrente de la casa de Agostine, y que aparecieron dos elfos y ahora... Parece que te han encerrado en un abuhardillado trastero. El techo es bajo (incluso para un gnomo) y est repleto de trastos: viejas cajas y multitud de otros objetos quien sabe si inservibles. El aire est como viciado, huele a polvo y moho. En el suelo hay una trampilla, y en una de las paredes se abre una pequea ventana.\n";
locations[35] = "Ests en un cuidado jardn trasero donde puedes apreciar el buen gusto lfico por flores y plantas. Los elfos, como todo el mundo sabe son altivos, vanidosos, credos, orgullosos e incluso malvados, pero son buenos jardineros... que se le va a hacer! Comparado con el jardn la casa no es gran cosa, menos cuidada de lo que podas esperar tan solo tiene una altura, amn de la buhardilla-trastero desde el que caste... y menos mal que no estaba ms alto! Los gnomos, desgraciadamente, no siempre caen de pi.\n";
locations[36] = "El garaje de la casa est prcticamente ocupado en su totalidad por dos grandes automviles... parece que no les va nada mal en la vida a los elfos-matones estos! La puerta del garaje se abre en vertical, mediante un mecanismo automtico al que no piensas acercarte! En el poco espacio que no ocupan los autos se amontonan algunas herramientas y ms trastos.\n";
locations[37] = "Ests en el recibidor-distribuidor de la casa, este es amplio y desde l puedes acceder a varias estancias. Sobretodo llama la atencin la escalera que sube al piso superior, que se alza en medio del recibidor, justo delante de la puerta de salida. Hay algo raro en este lugar, est como vaco, de muebles, de vida, no sabes muy bien que sensacin te produce, pero parece que a la casa le falte esa chispa o ese calor que tiene toda casa habitada, te recuerda a una habitacin de hotel o a un apartamento de vacaciones. Quiz esta casa tan slo sea una tapadera, o un lugar de paso para los elfos, una avanzadilla en el corazn de la Gran Ciudad humana, o quiz no, queda tan lejos del entendimiento de un gnomo como tu el pensamiento insidioso y altivo de los elfos.\n";
locations[38] = "Ests en el interior de la gran caja de cartn. Ciertamente caba un gnomo aqu dentro, pero encogido, agachado y apiado.\n";
locations[39] = "Sigues en el jardn alrededor de la casa, ahora ests en la parte central del mismo. Desde aqu puedes ver la fachada lateral de la casa, en la que, como en la fachada trasera, se abren cuatro ventanas, dos en la planta baja y otras dos en el primer piso. Un pequeo escaln te permite llegar hasta una de las ventanas. Desde aqu puedes ver tambin una construccin al este, lo que parece el garaje... Los humanos (y al parecer tambin los elfos) construyen casas para sus vehculos... algo parecido a la caseta de BM. Hacia el sur est la puerta de entrada a la casa.\n";
locations[40] = "Ests justo delante de la puerta de entrada a la casa. Desde aqu ves toda la fachada principal, pintada de blanco (encalada, ms bien), con las ya clsicas ventanas cubiertas de gruesos cortinajes. No sabes ya muy bien si se trata de una casa de elfos o de vampiros... vamos, que no les parece gustar mucho la luz del sol... o quiz tienen algo que esconder... La puerta de entrada est pintada de un curioso color azul fuerte y contiene adems unos graciosos adornos florales. Junto a la puerta, un timbre invita a ser llamado.\n";
locations[41] = "Aqu est la verja exterior de la propiedad, que la separa de la calle. Se trata de una verja no muy alta para los estndares humanos (o lficos), pero que para un gnomo como t entraa un ms que serio inconveniente. No obstante, en la verja se abre una amplia puerta, tan amplia como para permitir la entrada de automviles. Abierta o cerrada, este debe ser el camino hacia la libertad... tuya y de Agostine... por supuesto.\n";
locations[42] = "Te detienes ahora en un pasillo del piso superior, junto a las escaleras que bajan hasta la planta baja. Hacia el este distingues una estancia iluminada, lo que desde aqu parece un despacho. En el techo distingues tambin una obertura, sin duda se trata de la trampilla que da acceso al desvn en el cual te encerraron. Te vuelve a hervir la sangre al pensar como te trataron estos elfos a ti y a tu hermano Agostine... y todo por un CD-Rom. Si consigues salir de esta tendrs que hablar seriamente con Agostine sobre el lo en que se ha metido.\n";
locations[43] = "Esta-es-la-localidad-caja-fuerte";

// CONNECTIONS

connections = [];
connections_start = [];

connections[0] = [ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[1] = [ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[2] = [ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[3] = [ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[4] = [ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[5] = [ -1, -1, 8, 10, 9, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[6] = [ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[7] = [ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[8] = [ -1, -1, -1, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[9] = [ -1, -1, -1, 12, -1, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[10] = [ -1, -1, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[11] = [ -1, -1, -1, -1, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[12] = [ -1, -1, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[13] = [ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[14] = [ -1, -1, -1, -1, 23, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[15] = [ -1, -1, 15, 16, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[16] = [ -1, -1, 17, 16, 15, 16, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[17] = [ -1, -1, 17, 17, 16, 18, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[18] = [ -1, -1, -1, 19, 17, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[19] = [ -1, -1, 18, 19, 20, 19, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[20] = [ -1, -1, 20, 19, 21, 20, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[21] = [ -1, -1, 20, 23, 21, 21, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[22] = [ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[23] = [ -1, -1, 21, 24, -1, 14, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[24] = [ -1, -1, 23, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[25] = [ -1, -1, 24, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[26] = [ -1, -1, -1, -1, 27, 26, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[27] = [ -1, -1, -1, -1, 28, 26, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[28] = [ -1, -1, -1, -1, -1, 27, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[29] = [ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[30] = [ -1, -1, -1, -1, -1, 42, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[31] = [ -1, -1, -1, -1, -1, 30, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[32] = [ -1, -1, -1, -1, -1, 37, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[33] = [ -1, -1, -1, 37, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[34] = [ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[35] = [ -1, -1, -1, 39, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[36] = [ -1, -1, -1, -1, -1, 39, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[37] = [ -1, -1, 33, -1, 32, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[38] = [ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[39] = [ -1, -1, 35, 40, 36, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[40] = [ -1, -1, 39, 41, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[41] = [ -1, -1, 40, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[42] = [ -1, -1, -1, -1, 30, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections[43] = [ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];

connections_start[0] = [ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[1] = [ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[2] = [ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[3] = [ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[4] = [ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[5] = [ -1, -1, 8, 10, 9, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[6] = [ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[7] = [ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[8] = [ -1, -1, -1, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[9] = [ -1, -1, -1, 12, -1, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[10] = [ -1, -1, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[11] = [ -1, -1, -1, -1, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[12] = [ -1, -1, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[13] = [ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[14] = [ -1, -1, -1, -1, 23, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[15] = [ -1, -1, 15, 16, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[16] = [ -1, -1, 17, 16, 15, 16, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[17] = [ -1, -1, 17, 17, 16, 18, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[18] = [ -1, -1, -1, 19, 17, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[19] = [ -1, -1, 18, 19, 20, 19, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[20] = [ -1, -1, 20, 19, 21, 20, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[21] = [ -1, -1, 20, 23, 21, 21, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[22] = [ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[23] = [ -1, -1, 21, 24, -1, 14, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[24] = [ -1, -1, 23, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[25] = [ -1, -1, 24, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[26] = [ -1, -1, -1, -1, 27, 26, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[27] = [ -1, -1, -1, -1, 28, 26, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[28] = [ -1, -1, -1, -1, -1, 27, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[29] = [ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[30] = [ -1, -1, -1, -1, -1, 42, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[31] = [ -1, -1, -1, -1, -1, 30, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[32] = [ -1, -1, -1, -1, -1, 37, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[33] = [ -1, -1, -1, 37, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[34] = [ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[35] = [ -1, -1, -1, 39, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[36] = [ -1, -1, -1, -1, -1, 39, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[37] = [ -1, -1, 33, -1, 32, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[38] = [ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[39] = [ -1, -1, 35, 40, 36, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[40] = [ -1, -1, 39, 41, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[41] = [ -1, -1, 40, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[42] = [ -1, -1, -1, -1, 30, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];
connections_start[43] = [ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 ];


resources=[];
resources.push([RESOURCE_TYPE_IMG, 0, "dat/g0.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 1, "dat/g1.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 10, "dat/g10.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 11, "dat/g11.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 12, "dat/g12.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 13, "dat/g13.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 14, "dat/g14.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 15, "dat/g15.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 16, "dat/g16.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 17, "dat/g17.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 18, "dat/g18.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 19, "dat/g19.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 2, "dat/g2.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 20, "dat/g20.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 21, "dat/g21.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 22, "dat/g22.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 23, "dat/g23.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 24, "dat/g24.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 25, "dat/g25.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 26, "dat/g26.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 27, "dat/g27.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 28, "dat/g28.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 29, "dat/g29.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 3, "dat/g3.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 30, "dat/g30.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 31, "dat/g31.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 32, "dat/g32.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 33, "dat/g33.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 34, "dat/g34.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 35, "dat/g35.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 36, "dat/g36.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 37, "dat/g37.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 38, "dat/g38.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 39, "dat/g39.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 4, "dat/g4.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 40, "dat/g40.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 41, "dat/g41.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 42, "dat/g42.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 43, "dat/g43.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 5, "dat/g5.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 6, "dat/g6.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 7, "dat/g7.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 8, "dat/g8.jpg"]);
resources.push([RESOURCE_TYPE_IMG, 9, "dat/g9.jpg"]);


 //OBJECTS

objects = [];
objectsAttrLO = [];
objectsAttrHI = [];
objectsLocation = [];
objectsNoun = [];
objectsAdjective = [];
objectsWeight = [];
objectsAttrLO_start = [];
objectsAttrHI_start = [];
objectsLocation_start = [];
objectsWeight_start = [];

objects[0] = "una vela";
objectsNoun[0] = 50;
objectsAdjective[0] = 255;
objectsLocation[0] = 254;
objectsLocation_start[0] = 254;
objectsWeight[0] = 1;
objectsWeight_start[0] = 1;
objectsAttrLO[0] = 257;
objectsAttrLO_start[0] = 257;
objectsAttrHI[0] = 0;
objectsAttrHI_start[0] = 0;

objects[1] = "un libro";
objectsNoun[1] = 53;
objectsAdjective[1] = 255;
objectsLocation[1] = 2;
objectsLocation_start[1] = 2;
objectsWeight[1] = 1;
objectsWeight_start[1] = 1;
objectsAttrLO[1] = 0;
objectsAttrLO_start[1] = 0;
objectsAttrHI[1] = 0;
objectsAttrHI_start[1] = 0;

objects[2] = "tu sombrero";
objectsNoun[2] = 52;
objectsAdjective[2] = 255;
objectsLocation[2] = 253;
objectsLocation_start[2] = 253;
objectsWeight[2] = 1;
objectsWeight_start[2] = 1;
objectsAttrLO[2] = 0;
objectsAttrLO_start[2] = 0;
objectsAttrHI[2] = 0;
objectsAttrHI_start[2] = 0;

objects[3] = "un martillo";
objectsNoun[3] = 57;
objectsAdjective[3] = 255;
objectsLocation[3] = 254;
objectsLocation_start[3] = 254;
objectsWeight[3] = 1;
objectsWeight_start[3] = 1;
objectsAttrLO[3] = 0;
objectsAttrLO_start[3] = 0;
objectsAttrHI[3] = 0;
objectsAttrHI_start[3] = 0;

objects[4] = "la misteriosa llave";
objectsNoun[4] = 71;
objectsAdjective[4] = 255;
objectsLocation[4] = 2;
objectsLocation_start[4] = 2;
objectsWeight[4] = 1;
objectsWeight_start[4] = 1;
objectsAttrLO[4] = 256;
objectsAttrLO_start[4] = 256;
objectsAttrHI[4] = 0;
objectsAttrHI_start[4] = 0;

objects[5] = "una caja de cerillas";
objectsNoun[5] = 89;
objectsAdjective[5] = 255;
objectsLocation[5] = 2;
objectsLocation_start[5] = 2;
objectsWeight[5] = 1;
objectsWeight_start[5] = 1;
objectsAttrLO[5] = 256;
objectsAttrLO_start[5] = 256;
objectsAttrHI[5] = 0;
objectsAttrHI_start[5] = 0;

objects[6] = "un paraguas";
objectsNoun[6] = 76;
objectsAdjective[6] = 255;
objectsLocation[6] = 2;
objectsLocation_start[6] = 2;
objectsWeight[6] = 1;
objectsWeight_start[6] = 1;
objectsAttrLO[6] = 0;
objectsAttrLO_start[6] = 0;
objectsAttrHI[6] = 0;
objectsAttrHI_start[6] = 0;

objects[7] = "un arenque rojo";
objectsNoun[7] = 86;
objectsAdjective[7] = 255;
objectsLocation[7] = 2;
objectsLocation_start[7] = 2;
objectsWeight[7] = 1;
objectsWeight_start[7] = 1;
objectsAttrLO[7] = 0;
objectsAttrLO_start[7] = 0;
objectsAttrHI[7] = 0;
objectsAttrHI_start[7] = 0;

objects[8] = "una pesada piedra";
objectsNoun[8] = 87;
objectsAdjective[8] = 255;
objectsLocation[8] = 5;
objectsLocation_start[8] = 5;
objectsWeight[8] = 1;
objectsWeight_start[8] = 1;
objectsAttrLO[8] = 256;
objectsAttrLO_start[8] = 256;
objectsAttrHI[8] = 0;
objectsAttrHI_start[8] = 0;

objects[9] = "un trozo de vidrio";
objectsNoun[9] = 91;
objectsAdjective[9] = 255;
objectsLocation[9] = 2;
objectsLocation_start[9] = 2;
objectsWeight[9] = 1;
objectsWeight_start[9] = 1;
objectsAttrLO[9] = 0;
objectsAttrLO_start[9] = 0;
objectsAttrHI[9] = 0;
objectsAttrHI_start[9] = 0;

objects[10] = "una carta";
objectsNoun[10] = 92;
objectsAdjective[10] = 255;
objectsLocation[10] = 7;
objectsLocation_start[10] = 7;
objectsWeight[10] = 1;
objectsWeight_start[10] = 1;
objectsAttrLO[10] = 256;
objectsAttrLO_start[10] = 256;
objectsAttrHI[10] = 0;
objectsAttrHI_start[10] = 0;

objects[11] = "un telegrama";
objectsNoun[11] = 93;
objectsAdjective[11] = 255;
objectsLocation[11] = 7;
objectsLocation_start[11] = 7;
objectsWeight[11] = 1;
objectsWeight_start[11] = 1;
objectsAttrLO[11] = 0;
objectsAttrLO_start[11] = 0;
objectsAttrHI[11] = 0;
objectsAttrHI_start[11] = 0;

objects[12] = "una regadera";
objectsNoun[12] = 100;
objectsAdjective[12] = 255;
objectsLocation[12] = 8;
objectsLocation_start[12] = 8;
objectsWeight[12] = 1;
objectsWeight_start[12] = 1;
objectsAttrLO[12] = 256;
objectsAttrLO_start[12] = 256;
objectsAttrHI[12] = 0;
objectsAttrHI_start[12] = 0;

objects[13] = "un frasco";
objectsNoun[13] = 103;
objectsAdjective[13] = 255;
objectsLocation[13] = 2;
objectsLocation_start[13] = 2;
objectsWeight[13] = 1;
objectsWeight_start[13] = 1;
objectsAttrLO[13] = 0;
objectsAttrLO_start[13] = 0;
objectsAttrHI[13] = 0;
objectsAttrHI_start[13] = 0;

objects[14] = "un tapn de corcho";
objectsNoun[14] = 104;
objectsAdjective[14] = 255;
objectsLocation[14] = 2;
objectsLocation_start[14] = 2;
objectsWeight[14] = 1;
objectsWeight_start[14] = 1;
objectsAttrLO[14] = 0;
objectsAttrLO_start[14] = 0;
objectsAttrHI[14] = 0;
objectsAttrHI_start[14] = 0;

objects[15] = "una pizca de pimienta";
objectsNoun[15] = 114;
objectsAdjective[15] = 255;
objectsLocation[15] = 2;
objectsLocation_start[15] = 2;
objectsWeight[15] = 1;
objectsWeight_start[15] = 1;
objectsAttrLO[15] = 256;
objectsAttrLO_start[15] = 256;
objectsAttrHI[15] = 0;
objectsAttrHI_start[15] = 0;

objects[16] = "una flor seca";
objectsNoun[16] = 126;
objectsAdjective[16] = 255;
objectsLocation[16] = 255;
objectsLocation_start[16] = 255;
objectsWeight[16] = 1;
objectsWeight_start[16] = 1;
objectsAttrLO[16] = 256;
objectsAttrLO_start[16] = 256;
objectsAttrHI[16] = 0;
objectsAttrHI_start[16] = 0;

objects[17] = "una salchicha";
objectsNoun[17] = 127;
objectsAdjective[17] = 255;
objectsLocation[17] = 2;
objectsLocation_start[17] = 2;
objectsWeight[17] = 1;
objectsWeight_start[17] = 1;
objectsAttrLO[17] = 256;
objectsAttrLO_start[17] = 256;
objectsAttrHI[17] = 0;
objectsAttrHI_start[17] = 0;

objects[18] = "una salchicha";
objectsNoun[18] = 127;
objectsAdjective[18] = 255;
objectsLocation[18] = 2;
objectsLocation_start[18] = 2;
objectsWeight[18] = 1;
objectsWeight_start[18] = 1;
objectsAttrLO[18] = 256;
objectsAttrLO_start[18] = 256;
objectsAttrHI[18] = 0;
objectsAttrHI_start[18] = 0;

objects[19] = "un tridente";
objectsNoun[19] = 131;
objectsAdjective[19] = 255;
objectsLocation[19] = 22;
objectsLocation_start[19] = 22;
objectsWeight[19] = 1;
objectsWeight_start[19] = 1;
objectsAttrLO[19] = 0;
objectsAttrLO_start[19] = 0;
objectsAttrHI[19] = 0;
objectsAttrHI_start[19] = 0;

objects[20] = "una nota";
objectsNoun[20] = 149;
objectsAdjective[20] = 255;
objectsLocation[20] = 2;
objectsLocation_start[20] = 2;
objectsWeight[20] = 1;
objectsWeight_start[20] = 1;
objectsAttrLO[20] = 256;
objectsAttrLO_start[20] = 256;
objectsAttrHI[20] = 0;
objectsAttrHI_start[20] = 0;

objects[21] = "un peridico";
objectsNoun[21] = 51;
objectsAdjective[21] = 255;
objectsLocation[21] = 2;
objectsLocation_start[21] = 2;
objectsWeight[21] = 1;
objectsWeight_start[21] = 1;
objectsAttrLO[21] = 0;
objectsAttrLO_start[21] = 0;
objectsAttrHI[21] = 0;
objectsAttrHI_start[21] = 0;

objects[22] = "un disquette de ordenador";
objectsNoun[22] = 154;
objectsAdjective[22] = 255;
objectsLocation[22] = 2;
objectsLocation_start[22] = 2;
objectsWeight[22] = 1;
objectsWeight_start[22] = 1;
objectsAttrLO[22] = 0;
objectsAttrLO_start[22] = 0;
objectsAttrHI[22] = 0;
objectsAttrHI_start[22] = 0;

objects[23] = "un cd-rom";
objectsNoun[23] = 156;
objectsAdjective[23] = 255;
objectsLocation[23] = 2;
objectsLocation_start[23] = 2;
objectsWeight[23] = 1;
objectsWeight_start[23] = 1;
objectsAttrLO[23] = 0;
objectsAttrLO_start[23] = 0;
objectsAttrHI[23] = 0;
objectsAttrHI_start[23] = 0;

objects[24] = "una pastilla de jabn";
objectsNoun[24] = 173;
objectsAdjective[24] = 255;
objectsLocation[24] = 2;
objectsLocation_start[24] = 2;
objectsWeight[24] = 1;
objectsWeight_start[24] = 1;
objectsAttrLO[24] = 256;
objectsAttrLO_start[24] = 256;
objectsAttrHI[24] = 0;
objectsAttrHI_start[24] = 0;

objects[25] = "un rotulador";
objectsNoun[25] = 174;
objectsAdjective[25] = 255;
objectsLocation[25] = 2;
objectsLocation_start[25] = 2;
objectsWeight[25] = 1;
objectsWeight_start[25] = 1;
objectsAttrLO[25] = 0;
objectsAttrLO_start[25] = 0;
objectsAttrHI[25] = 0;
objectsAttrHI_start[25] = 0;

objects[26] = "una caja de cartn";
objectsNoun[26] = 89;
objectsAdjective[26] = 255;
objectsLocation[26] = 2;
objectsLocation_start[26] = 2;
objectsWeight[26] = 1;
objectsWeight_start[26] = 1;
objectsAttrLO[26] = 256;
objectsAttrLO_start[26] = 256;
objectsAttrHI[26] = 0;
objectsAttrHI_start[26] = 0;

objects[27] = "un pauelo";
objectsNoun[27] = 191;
objectsAdjective[27] = 255;
objectsLocation[27] = 34;
objectsLocation_start[27] = 34;
objectsWeight[27] = 1;
objectsWeight_start[27] = 1;
objectsAttrLO[27] = 0;
objectsAttrLO_start[27] = 0;
objectsAttrHI[27] = 0;
objectsAttrHI_start[27] = 0;

objects[28] = "un estetoscopio";
objectsNoun[28] = 190;
objectsAdjective[28] = 255;
objectsLocation[28] = 38;
objectsLocation_start[28] = 38;
objectsWeight[28] = 1;
objectsWeight_start[28] = 1;
objectsAttrLO[28] = 0;
objectsAttrLO_start[28] = 0;
objectsAttrHI[28] = 0;
objectsAttrHI_start[28] = 0;

objects[29] = "una sartn";
objectsNoun[29] = 205;
objectsAdjective[29] = 255;
objectsLocation[29] = 2;
objectsLocation_start[29] = 2;
objectsWeight[29] = 1;
objectsWeight_start[29] = 1;
objectsAttrLO[29] = 256;
objectsAttrLO_start[29] = 256;
objectsAttrHI[29] = 0;
objectsAttrHI_start[29] = 0;

last_object_number =  29; 
carried_objects = 2;
total_object_messages=30;

