// Created with Squiffy 5.1.3
// https://github.com/textadventures/squiffy

(function(){
/* jshint quotmark: single */
/* jshint evil: true */

var squiffy = {};

(function () {
    'use strict';

    squiffy.story = {};

    var initLinkHandler = function () {
        var handleLink = function (link) {
            if (link.hasClass('disabled')) return;
            var passage = link.data('passage');
            var section = link.data('section');
            var rotateAttr = link.attr('data-rotate');
            var sequenceAttr = link.attr('data-sequence');
            if (passage) {
                disableLink(link);
                squiffy.set('_turncount', squiffy.get('_turncount') + 1);
                passage = processLink(passage);
                if (passage) {
                    currentSection.append('<hr/>');
                    squiffy.story.passage(passage);
                }
                var turnPassage = '@' + squiffy.get('_turncount');
                if (turnPassage in squiffy.story.section.passages) {
                    squiffy.story.passage(turnPassage);
                }
                if ('@last' in squiffy.story.section.passages && squiffy.get('_turncount')>= squiffy.story.section.passageCount) {
                    squiffy.story.passage('@last');
                }
            }
            else if (section) {
                currentSection.append('<hr/>');
                disableLink(link);
                section = processLink(section);
                squiffy.story.go(section);
            }
            else if (rotateAttr || sequenceAttr) {
                var result = rotate(rotateAttr || sequenceAttr, rotateAttr ? link.text() : '');
                link.html(result[0].replace(/&quot;/g, '"').replace(/&#39;/g, '\''));
                var dataAttribute = rotateAttr ? 'data-rotate' : 'data-sequence';
                link.attr(dataAttribute, result[1]);
                if (!result[1]) {
                    disableLink(link);
                }
                if (link.attr('data-attribute')) {
                    squiffy.set(link.attr('data-attribute'), result[0]);
                }
                squiffy.story.save();
            }
        };

        squiffy.ui.output.on('click', 'a.squiffy-link', function () {
            handleLink(jQuery(this));
        });

        squiffy.ui.output.on('keypress', 'a.squiffy-link', function (e) {
            if (e.which !== 13) return;
            handleLink(jQuery(this));
        });

        squiffy.ui.output.on('mousedown', 'a.squiffy-link', function (event) {
            event.preventDefault();
        });
    };

    var disableLink = function (link) {
        link.addClass('disabled');
        link.attr('tabindex', -1);
    }
    
    squiffy.story.begin = function () {
        if (!squiffy.story.load()) {
            squiffy.story.go(squiffy.story.start);
        }
    };

    var processLink = function(link) {
		link = String(link);
        var sections = link.split(',');
        var first = true;
        var target = null;
        sections.forEach(function (section) {
            section = section.trim();
            if (startsWith(section, '@replace ')) {
                replaceLabel(section.substring(9));
            }
            else {
                if (first) {
                    target = section;
                }
                else {
                    setAttribute(section);
                }
            }
            first = false;
        });
        return target;
    };

    var setAttribute = function(expr) {
        var lhs, rhs, op, value;
        var setRegex = /^([\w]*)\s*=\s*(.*)$/;
        var setMatch = setRegex.exec(expr);
        if (setMatch) {
            lhs = setMatch[1];
            rhs = setMatch[2];
            if (isNaN(rhs)) {
				if(startsWith(rhs,"@")) rhs=squiffy.get(rhs.substring(1));
                squiffy.set(lhs, rhs);
            }
            else {
                squiffy.set(lhs, parseFloat(rhs));
            }
        }
        else {
			var incDecRegex = /^([\w]*)\s*([\+\-\*\/])=\s*(.*)$/;
            var incDecMatch = incDecRegex.exec(expr);
            if (incDecMatch) {
                lhs = incDecMatch[1];
                op = incDecMatch[2];
				rhs = incDecMatch[3];
				if(startsWith(rhs,"@")) rhs=squiffy.get(rhs.substring(1));
				rhs = parseFloat(rhs);
                value = squiffy.get(lhs);
                if (value === null) value = 0;
                if (op == '+') {
                    value += rhs;
                }
                if (op == '-') {
                    value -= rhs;
                }
				if (op == '*') {
					value *= rhs;
				}
				if (op == '/') {
					value /= rhs;
				}
                squiffy.set(lhs, value);
            }
            else {
                value = true;
                if (startsWith(expr, 'not ')) {
                    expr = expr.substring(4);
                    value = false;
                }
                squiffy.set(expr, value);
            }
        }
    };

    var replaceLabel = function(expr) {
        var regex = /^([\w]*)\s*=\s*(.*)$/;
        var match = regex.exec(expr);
        if (!match) return;
        var label = match[1];
        var text = match[2];
        if (text in squiffy.story.section.passages) {
            text = squiffy.story.section.passages[text].text;
        }
        else if (text in squiffy.story.sections) {
            text = squiffy.story.sections[text].text;
        }
        var stripParags = /^<p>(.*)<\/p>$/;
        var stripParagsMatch = stripParags.exec(text);
        if (stripParagsMatch) {
            text = stripParagsMatch[1];
        }
        var $labels = squiffy.ui.output.find('.squiffy-label-' + label);
        $labels.fadeOut(1000, function() {
            $labels.html(squiffy.ui.processText(text));
            $labels.fadeIn(1000, function() {
                squiffy.story.save();
            });
        });
    };

    squiffy.story.go = function(section) {
        squiffy.set('_transition', null);
        newSection();
        squiffy.story.section = squiffy.story.sections[section];
        if (!squiffy.story.section) return;
        squiffy.set('_section', section);
        setSeen(section);
        var master = squiffy.story.sections[''];
        if (master) {
            squiffy.story.run(master);
            squiffy.ui.write(master.text);
        }
        squiffy.story.run(squiffy.story.section);
        // The JS might have changed which section we're in
        if (squiffy.get('_section') == section) {
            squiffy.set('_turncount', 0);
            squiffy.ui.write(squiffy.story.section.text);
            squiffy.story.save();
        }
    };

    squiffy.story.run = function(section) {
        if (section.clear) {
            squiffy.ui.clearScreen();
        }
        if (section.attributes) {
            processAttributes(section.attributes);
        }
        if (section.js) {
            section.js();
        }
    };

    squiffy.story.passage = function(passageName) {
        var passage = squiffy.story.section.passages[passageName];
        if (!passage) return;
        setSeen(passageName);
        var masterSection = squiffy.story.sections[''];
        if (masterSection) {
            var masterPassage = masterSection.passages[''];
            if (masterPassage) {
                squiffy.story.run(masterPassage);
                squiffy.ui.write(masterPassage.text);
            }
        }
        var master = squiffy.story.section.passages[''];
        if (master) {
            squiffy.story.run(master);
            squiffy.ui.write(master.text);
        }
        squiffy.story.run(passage);
        squiffy.ui.write(passage.text);
        squiffy.story.save();
    };

    var processAttributes = function(attributes) {
        attributes.forEach(function (attribute) {
            if (startsWith(attribute, '@replace ')) {
                replaceLabel(attribute.substring(9));
            }
            else {
                setAttribute(attribute);
            }
        });
    };

    squiffy.story.restart = function() {
        if (squiffy.ui.settings.persist && window.localStorage) {
            var keys = Object.keys(localStorage);
            jQuery.each(keys, function (idx, key) {
                if (startsWith(key, squiffy.story.id)) {
                    localStorage.removeItem(key);
                }
            });
        }
        else {
            squiffy.storageFallback = {};
        }
        if (squiffy.ui.settings.scroll === 'element') {
            squiffy.ui.output.html('');
            squiffy.story.begin();
        }
        else {
            location.reload();
        }
    };

    squiffy.story.save = function() {
        squiffy.set('_output', squiffy.ui.output.html());
    };

    squiffy.story.load = function() {
        var output = squiffy.get('_output');
        if (!output) return false;
        squiffy.ui.output.html(output);
        currentSection = jQuery('#' + squiffy.get('_output-section'));
        squiffy.story.section = squiffy.story.sections[squiffy.get('_section')];
        var transition = squiffy.get('_transition');
        if (transition) {
            eval('(' + transition + ')()');
        }
        return true;
    };

    var setSeen = function(sectionName) {
        var seenSections = squiffy.get('_seen_sections');
        if (!seenSections) seenSections = [];
        if (seenSections.indexOf(sectionName) == -1) {
            seenSections.push(sectionName);
            squiffy.set('_seen_sections', seenSections);
        }
    };

    squiffy.story.seen = function(sectionName) {
        var seenSections = squiffy.get('_seen_sections');
        if (!seenSections) return false;
        return (seenSections.indexOf(sectionName) > -1);
    };
    
    squiffy.ui = {};

    var currentSection = null;
    var screenIsClear = true;
    var scrollPosition = 0;

    var newSection = function() {
        if (currentSection) {
            disableLink(jQuery('.squiffy-link', currentSection));
        }
        var sectionCount = squiffy.get('_section-count') + 1;
        squiffy.set('_section-count', sectionCount);
        var id = 'squiffy-section-' + sectionCount;
        currentSection = jQuery('<div/>', {
            id: id,
        }).appendTo(squiffy.ui.output);
        squiffy.set('_output-section', id);
    };

    squiffy.ui.write = function(text) {
        screenIsClear = false;
        scrollPosition = squiffy.ui.output.height();
        currentSection.append(jQuery('<div/>').html(squiffy.ui.processText(text)));
        squiffy.ui.scrollToEnd();
    };

    squiffy.ui.clearScreen = function() {
        squiffy.ui.output.html('');
        screenIsClear = true;
        newSection();
    };

    squiffy.ui.scrollToEnd = function() {
        var scrollTo, currentScrollTop, distance, duration;
        if (squiffy.ui.settings.scroll === 'element') {
            scrollTo = squiffy.ui.output[0].scrollHeight - squiffy.ui.output.height();
            currentScrollTop = squiffy.ui.output.scrollTop();
            if (scrollTo > currentScrollTop) {
                distance = scrollTo - currentScrollTop;
                duration = distance / 0.4;
                squiffy.ui.output.stop().animate({ scrollTop: scrollTo }, duration);
            }
        }
        else {
            scrollTo = scrollPosition;
            currentScrollTop = Math.max(jQuery('body').scrollTop(), jQuery('html').scrollTop());
            if (scrollTo > currentScrollTop) {
                var maxScrollTop = jQuery(document).height() - jQuery(window).height();
                if (scrollTo > maxScrollTop) scrollTo = maxScrollTop;
                distance = scrollTo - currentScrollTop;
                duration = distance / 0.5;
                jQuery('body,html').stop().animate({ scrollTop: scrollTo }, duration);
            }
        }
    };

    squiffy.ui.processText = function(text) {
        function process(text, data) {
            var containsUnprocessedSection = false;
            var open = text.indexOf('{');
            var close;
            
            if (open > -1) {
                var nestCount = 1;
                var searchStart = open + 1;
                var finished = false;
             
                while (!finished) {
                    var nextOpen = text.indexOf('{', searchStart);
                    var nextClose = text.indexOf('}', searchStart);
         
                    if (nextClose > -1) {
                        if (nextOpen > -1 && nextOpen < nextClose) {
                            nestCount++;
                            searchStart = nextOpen + 1;
                        }
                        else {
                            nestCount--;
                            searchStart = nextClose + 1;
                            if (nestCount === 0) {
                                close = nextClose;
                                containsUnprocessedSection = true;
                                finished = true;
                            }
                        }
                    }
                    else {
                        finished = true;
                    }
                }
            }
            
            if (containsUnprocessedSection) {
                var section = text.substring(open + 1, close);
                var value = processTextCommand(section, data);
                text = text.substring(0, open) + value + process(text.substring(close + 1), data);
            }
            
            return (text);
        }

        function processTextCommand(text, data) {
            if (startsWith(text, 'if ')) {
                return processTextCommand_If(text, data);
            }
            else if (startsWith(text, 'else:')) {
                return processTextCommand_Else(text, data);
            }
            else if (startsWith(text, 'label:')) {
                return processTextCommand_Label(text, data);
            }
            else if (/^rotate[: ]/.test(text)) {
                return processTextCommand_Rotate('rotate', text, data);
            }
            else if (/^sequence[: ]/.test(text)) {
                return processTextCommand_Rotate('sequence', text, data);   
            }
            else if (text in squiffy.story.section.passages) {
                return process(squiffy.story.section.passages[text].text, data);
            }
            else if (text in squiffy.story.sections) {
                return process(squiffy.story.sections[text].text, data);
            }
			else if (startsWith(text,'@') && !startsWith(text,'@replace')) {
				processAttributes(text.substring(1).split(","));
				return "";
			}
            return squiffy.get(text);
        }

        function processTextCommand_If(section, data) {
            var command = section.substring(3);
            var colon = command.indexOf(':');
            if (colon == -1) {
                return ('{if ' + command + '}');
            }

            var text = command.substring(colon + 1);
            var condition = command.substring(0, colon);
			condition = condition.replace("<", "&lt;");
            var operatorRegex = /([\w ]*)(=|&lt;=|&gt;=|&lt;&gt;|&lt;|&gt;)(.*)/;
            var match = operatorRegex.exec(condition);

            var result = false;

            if (match) {
                var lhs = squiffy.get(match[1]);
                var op = match[2];
                var rhs = match[3];

				if(startsWith(rhs,'@')) rhs=squiffy.get(rhs.substring(1));
				
                if (op == '=' && lhs == rhs) result = true;
                if (op == '&lt;&gt;' && lhs != rhs) result = true;
                if (op == '&gt;' && lhs > rhs) result = true;
                if (op == '&lt;' && lhs < rhs) result = true;
                if (op == '&gt;=' && lhs >= rhs) result = true;
                if (op == '&lt;=' && lhs <= rhs) result = true;
            }
            else {
                var checkValue = true;
                if (startsWith(condition, 'not ')) {
                    condition = condition.substring(4);
                    checkValue = false;
                }

                if (startsWith(condition, 'seen ')) {
                    result = (squiffy.story.seen(condition.substring(5)) == checkValue);
                }
                else {
                    var value = squiffy.get(condition);
                    if (value === null) value = false;
                    result = (value == checkValue);
                }
            }

            var textResult = result ? process(text, data) : '';

            data.lastIf = result;
            return textResult;
        }

        function processTextCommand_Else(section, data) {
            if (!('lastIf' in data) || data.lastIf) return '';
            var text = section.substring(5);
            return process(text, data);
        }

        function processTextCommand_Label(section, data) {
            var command = section.substring(6);
            var eq = command.indexOf('=');
            if (eq == -1) {
                return ('{label:' + command + '}');
            }

            var text = command.substring(eq + 1);
            var label = command.substring(0, eq);

            return '<span class="squiffy-label-' + label + '">' + process(text, data) + '</span>';
        }

        function processTextCommand_Rotate(type, section, data) {
            var options;
            var attribute = '';
            if (section.substring(type.length, type.length + 1) == ' ') {
                var colon = section.indexOf(':');
                if (colon == -1) {
                    return '{' + section + '}';
                }
                options = section.substring(colon + 1);
                attribute = section.substring(type.length + 1, colon);
            }
            else {
                options = section.substring(type.length + 1);
            }
            var rotation = rotate(options.replace(/"/g, '&quot;').replace(/'/g, '&#39;'));
            if (attribute) {
                squiffy.set(attribute, rotation[0]);
            }
            return '<a class="squiffy-link" data-' + type + '="' + rotation[1] + '" data-attribute="' + attribute + '" role="link">' + rotation[0] + '</a>';
        }

        var data = {
            fulltext: text
        };
        return process(text, data);
    };

    squiffy.ui.transition = function(f) {
        squiffy.set('_transition', f.toString());
        f();
    };

    squiffy.storageFallback = {};

    squiffy.set = function(attribute, value) {
        if (typeof value === 'undefined') value = true;
        if (squiffy.ui.settings.persist && window.localStorage) {
            localStorage[squiffy.story.id + '-' + attribute] = JSON.stringify(value);
        }
        else {
            squiffy.storageFallback[attribute] = JSON.stringify(value);
        }
        squiffy.ui.settings.onSet(attribute, value);
    };

    squiffy.get = function(attribute) {
        var result;
        if (squiffy.ui.settings.persist && window.localStorage) {
            result = localStorage[squiffy.story.id + '-' + attribute];
        }
        else {
            result = squiffy.storageFallback[attribute];
        }
        if (!result) return null;
        return JSON.parse(result);
    };

    var startsWith = function(string, prefix) {
        return string.substring(0, prefix.length) === prefix;
    };

    var rotate = function(options, current) {
        var colon = options.indexOf(':');
        if (colon == -1) {
            return [options, current];
        }
        var next = options.substring(0, colon);
        var remaining = options.substring(colon + 1);
        if (current) remaining += ':' + current;
        return [next, remaining];
    };

    var methods = {
        init: function (options) {
            var settings = jQuery.extend({
                scroll: 'body',
                persist: true,
                restartPrompt: true,
                onSet: function (attribute, value) {}
            }, options);

            squiffy.ui.output = this;
            squiffy.ui.restart = jQuery(settings.restart);
            squiffy.ui.settings = settings;

            if (settings.scroll === 'element') {
                squiffy.ui.output.css('overflow-y', 'auto');
            }

            initLinkHandler();
            squiffy.story.begin();
            
            return this;
        },
        get: function (attribute) {
            return squiffy.get(attribute);
        },
        set: function (attribute, value) {
            squiffy.set(attribute, value);
        },
        restart: function () {
            if (!squiffy.ui.settings.restartPrompt || confirm('Seguro quieres reiniciar?')) {
                squiffy.story.restart();
            }
        }
    };

    jQuery.fn.squiffy = function (methodOrOptions) {
        if (methods[methodOrOptions]) {
            return methods[methodOrOptions]
                .apply(this, Array.prototype.slice.call(arguments, 1));
        }
        else if (typeof methodOrOptions === 'object' || ! methodOrOptions) {
            return methods.init.apply(this, arguments);
        } else {
            jQuery.error('Method ' +  methodOrOptions + ' does not exist');
        }
    };
})();

var get = squiffy.get;
var set = squiffy.set;


squiffy.story.start = 'Beginning';
squiffy.story.id = 'fa90e447d5';
squiffy.story.sections = {
	'Beginning': {
		'clear': true,
		'text': "<!-- Encabezado para textadventures.co.uk -->\n<!-- <img src=\"RastrosTitulo.jpg\" align=middle alt=\"Caracol dejando rastros\" height=\"145\" width=\"221\"><font face=\"chiller\" color=\"red\" size=10>&nbsp;R&nbsp;a&nbsp;s&nbsp;t&nbsp;r&nbsp;o&nbsp;s</font> -->\n<!-- <br>versión 01.01.01 -->\n<!-- <br><a href=\"https://incanus.caad.club/rastros.html\" target=\"_blank\">Visita su página web</a> -->\n<!-- Encabezado para otras publicaciones -->\n<p><font face=\"chiller\" color=\"red\" size=10>R&nbsp;a&nbsp;s&nbsp;t&nbsp;r&nbsp;o&nbsp;s</font>\n<br>versión 01.01.01</p>\n<p>Mi reloj de sobremesa suena con ese zumbido en <i>crescendo</i>, insistente y molesto, que nunca falla en hacerme abrir los ojos.</p>\n<p>Desconecto la alarma, <a class=\"squiffy-link link-passage\" data-passage=\"bostezo\" role=\"link\" tabindex=\"0\">bostezo</a> y me estiro.</p>\n<p>Más dormido que despierto, camino hacia el <a class=\"squiffy-link link-passage\" data-passage=\"cuarto de baño\" role=\"link\" tabindex=\"0\">cuarto de baño</a>; la <a class=\"squiffy-link link-passage\" data-passage=\"ducha fría\" role=\"link\" tabindex=\"0\">ducha fría</a> termina de despabilarme.</p>\n<p>Ya vestido con el <a class=\"squiffy-link link-passage\" data-passage=\"mono de trabajo\" role=\"link\" tabindex=\"0\">mono de trabajo</a> y con un café en el cuerpo, estoy &quot;listo&quot; para otro día de trabajo más.</p>\n<p>Un <a class=\"squiffy-link link-section\" data-section=\"nuevo día\" role=\"link\" tabindex=\"0\">nuevo día</a> en la Estación botánica Nº23.</p>",
		'attributes': ["puntaje =0","not traje_puesto","not tengo_pala","not tengo_chuzo"],
		'passages': {
			'bostezo': {
				'text': "<p>Aún no termino de acostumbrarme a los horarios de trabajo; cosa de uso horario, supongo, porque aquí se trabaja de sol a sol.</p>",
			},
			'cuarto de baño': {
				'text': "<p>El cuarto de baño es espartano pero funcional: un lavabo, un retrete y una ducha... sin cortina, por cierto; no hay nadie más en la estación, así que ¿Para qué complicarse con esas consideraciones?</p>",
			},
			'ducha fría': {
				'text': "<p>Una ducha diaria es todo un lujo, pero ducha caliente sería un lujo inútil; afuera hace calor casi siempre y por lo demás el duchazo es intenso y breve. Podría tomar más de una ducha al día, pero con esa temperatura de agua en general no me apetece...</p>",
			},
			'mono de trabajo': {
				'text': "<p>El mono de trabajo es de una sola pieza de tela delgada pero resistente, con las botas incorporadas y unas buenas suelas de seguridad. Los guantes pueden dejarse colgando, pero rara vez lo hago; las manos respiran bien con los guantes puestos y por el tipo de trabajo, no es conveniente... ni sano.</p>",
			},
		},
	},
	'nuevo día': {
		'clear': true,
		'text': "<p>Me asomo afuera del <a class=\"squiffy-link link-passage\" data-passage=\"refugio\" role=\"link\" tabindex=\"0\">refugio</a> y veo que la entrada está limpia: no hay huellas ni restos animales... así que, para variar, ha sido una noche <a class=\"squiffy-link link-passage\" data-passage=\"tranquila\" role=\"link\" tabindex=\"0\">tranquila</a>.</p>\n<p>Ahora podría <a class=\"squiffy-link link-section\" data-section=\"coger una fruta\" role=\"link\" tabindex=\"0\">coger una fruta</a> para completar mi desayuno o <a class=\"squiffy-link link-section\" data-section=\"cobertizo de herramientas\" role=\"link\" tabindex=\"0\">irme directo al cobertizo de herramientas</a>.</p>",
		'passages': {
			'refugio': {
				'text': "<p>El refugio subterráneo es un hexágono bajo y es la estructura más sólida de la estación. Las paredes, de 2 metros de grosor, son de concreto sólido y completamente inexpugnables. En un apuro, puede servir de búnker (estanco incluído) por una semana o así... y se agradece, la verdad.</p>",
			},
			'tranquila': {
				'text': "<p>La verdad, nunca me entero de qué pasa de noche; las paredes del refugio no dejan pasar sonido o vibración externa alguna. Duermo sin interrupciones y cuando salgo todo es una sorpresa.\nNo siempre buena, por cierto.</p>",
			},
		},
	},
	'coger una fruta': {
		'clear': true,
		'text': "<p>Me decido por la fruta; café aparte, empezar el trabajo de la mañana sin energía es mala idea.</p>\n<p>El <a class=\"squiffy-link link-passage\" data-passage=\"camino\" role=\"link\" tabindex=\"0\">camino</a> a los frutales está limpio también; parece que mi día comienza definitivamente muy bien... o al menos con cara de que será más descansado que <a class=\"squiffy-link link-passage\" data-passage=\"ayer\" role=\"link\" tabindex=\"0\">ayer</a>; eso mejora mi humor <i>casi</i> tanto como la perspectiva de comerme una fruta.</p>\n<p>Salvo algún fruto caído de los árboles anoche, todo se ve en <a class=\"squiffy-link link-passage\" data-passage=\"orden\" role=\"link\" tabindex=\"0\">orden</a> en este lote de la estación.</p>\n<p>Una de las manzanas llama mi atención: es casi tan grande como mi cabeza. Supongo que podría <a class=\"squiffy-link link-section\" data-section=\"laboratorio\" role=\"link\" tabindex=\"0\">llevarla al laboratorio</a> y tomar alguna muestra... <a class=\"squiffy-link link-section\" data-section=\"no laboratorio\" role=\"link\" tabindex=\"0\">o podría pasar de ello</a>.</p>",
		'passages': {
			'camino': {
				'text': "<p>Los caminos y senderos de la estación están hechos de roca fundida con cemento y desechos industriales. A los bichos no les ha dado por mordisquearlo... a la fecha, vaya.</p>",
			},
			'ayer': {
				'text': "<p>Ayer tuve que fumigar. Un coñazo pero si no se hace a tiempo, las cosas se desmadran rápidamente.</p>",
			},
			'orden': {
				'text': "<p>Mantener tanta limpieza aquí y allá es un latazo, pero, en general, los terrenos despejados y limpios no atraen a los bichos, lo que es buena cosa.</p>",
			},
		},
	},
	'laboratorio': {
		'text': "<p>...y como de esto se trata en buena medida el trabajo en la Estación botánica Nº23, cojo la manzana (que pesa lo suyo), me devuelvo al refugio y, rodeándolo, entro al <a class=\"squiffy-link link-passage\" data-passage=\"laboratorio\" role=\"link\" tabindex=\"0\">laboratorio</a> que está detrás.</p>\n<p>Todo está en orden en mi mesa de trabajo, así que, sin mayor demora, troceo la manzana, separando el corazón del resto de la pulpa; pongo el corazón en un frasco para muestras y, sellando bien la tapa, lo meto en el tubo neumático de envío.</p>\n<p>Me he comido casi toda la fruta (buenísima, por cierto) antes de que el tubo devuelva el frasco con una <a class=\"squiffy-link link-passage\" data-passage=\"nota verde\" role=\"link\" tabindex=\"0\">nota verde</a> de respuesta dentro. Decido que la nota puede esperar; ya es hora de <a class=\"squiffy-link link-section\" data-section=\"cobertizo de herramientas\" role=\"link\" tabindex=\"0\">ir al cobertizo de herramientas</a>.</p>",
		'attributes': ["puntaje+=1"],
		'passages': {
			'laboratorio': {
				'text': "<p>El laboratorio también es subterráneo y es tan estanco e inexpugnable como el refugio. No tiene provisiones, pero desde aquí al menos puedes pedir ayuda... y cruzar los dedos.</p>",
			},
			'nota verde': {
				'text': "<p>Las notas de respuesta verdes suelen tener indicaciones para cambiar las mezclas para fertilizante o fumigación: química agrícola de mantención; nada urgente, vamos, que si no, los chicos de la <a class=\"squiffy-link link-passage\" data-passage=\"Estación Central\" role=\"link\" tabindex=\"0\">Estación Central</a> me habrían mandado una nota amarilla, como mínimo. Así las cosas, mejor me dedico a la rutina programada para hoy.  </p>",
			},
			'Estación Central': {
				'text': "<p>La Estación Central está más o menos al centro de las demás estaciones y desde ahí nos despachan los trabajos a cada estación.</p>",
			},
		},
	},
	'no laboratorio': {
		'text': "<p>La verdad, no quiero demorarme demasiado con el desayuno, así que cojo una manzana cualquiera y me la como <a class=\"squiffy-link link-section\" data-section=\"cobertizo de herramientas\" role=\"link\" tabindex=\"0\">camino del cobertizo de herramientas</a>.</p>",
		'passages': {
		},
	},
	'cobertizo de herramientas': {
		'clear': true,
		'text': "<p>{if seen coger una fruta:Con la fruta en el cuerpo, llego al cobertizo de buena gana y a paso vivo.}\n{else:En general, no es buena idea comenzar la faena diaria sin energías, pero ver la entrada del refugio limpia me ha puesto de muy buen humor y eso es casi tan bueno como una fruta por la mañana.}</p>\n<p>Ayer por la tarde fumigué a conciencia, así que no es sorpresa encontrar el <a class=\"squiffy-link link-passage\" data-passage=\"cobertizo\" role=\"link\" tabindex=\"0\">cobertizo</a> sin signos de que algún bicho se haya aproximado al lugar.</p>\n<p>Buena cosa. Se dice rápido, pero sin bichos cerca todo va mejor.</p>\n<p>Lo cierto es que la rejilla de las paredes es incomestible, pero es un latazo estar limpiando <a class=\"squiffy-link link-passage\" data-passage=\"babas\" role=\"link\" tabindex=\"0\">babas</a> de las herramientas y todo lo demás: algunas alimañas tiene  lenguas o bocas o qué sé yo así de largas... y la noche, para bichos que no tienen nada mejor que hacer que joder con el cobertizo, es larga.</p>\n<p>Abro el candado con la <a class=\"squiffy-link link-passage\" data-passage=\"huella\" role=\"link\" tabindex=\"0\">huella</a> de mi pulgar e inspecciono el interior: todo se ve como lo dejé ayer; los <a class=\"squiffy-link link-passage\" data-passage=\"trajes\" role=\"link\" tabindex=\"0\">trajes</a> para control de plagas colgando del techo, las palas, picotas y chuzos en su sitio y los frascos y sacos de <a class=\"squiffy-link link-passage\" data-passage=\"químicos\" role=\"link\" tabindex=\"0\">químicos</a> dentro de su <a class=\"squiffy-link link-passage\" data-passage=\"baúl\" role=\"link\" tabindex=\"0\">baúl</a> transparente bien cerrado... y sin &quot;visitas&quot; a la vista, dentro o fuera del baúl.</p>\n<p>Para el trabajo de hoy, puedo <a class=\"squiffy-link link-section\" data-section=\"pala\" role=\"link\" tabindex=\"0\">coger una pala</a> y cavar hoyos para sembrar plantas o bien <a class=\"squiffy-link link-section\" data-section=\"chuzo\" role=\"link\" tabindex=\"0\">hacerme de un chuzo</a> para picar tierra en el terreno que tengo en barbecho.</p>",
		'passages': {
			'cobertizo': {
				'text': "<p>El cobertizo de herramientas está en una estructura elevada sobre el suelo, para evitar problemas con la humedad si hay fallas de riego; contra los bichos, si no es subterráneo y blindado, da lo mismo si está en altura o no.</p>",
			},
			'babas': {
				'text': "<p>Algunas de las &quot;secreciones&quot; de estos bichos son corrosivas, si se las deja estar más de un día sin limpiar.</p>",
			},
			'huella': {
				'text': "<p>El lector funciona a través de mis guantes: buen diseño, joder; otra buena cosa salida de la <a class=\"squiffy-link link-passage\" data-passage=\"Estación Central\" role=\"link\" tabindex=\"0\">Estación Central</a>.</p>",
			},
			'Estación Central': {
				'text': "<p>La Estación Central está más o menos al centro de las demás estaciones y desde ahí nos despachan los trabajos a cada estación. Con la carga de trabajo que tienen, cuesta creer que tengan tiempo para tanta maravilla técnica, pero es que ahí solo trabajan los mejores... y a sobre tiempo, que me consta.</p>",
			},
			'trajes': {
				'text': "<p>Los trajes de control de plagas son como mi mono de trabajo, pero mucho más gruesos e incómodos: están presurizados, con escafandra y sistema de aire autónomo. No es que me guste ponérmelos, pero ni de madres se me ocurriría hacer fumigación sin eso puesto. El mono de trabajo es seguro, pero no es estanco ni blindado...</p>",
			},
			'químicos': {
				'text': "<p>Los químicos tienen etiquetas codificadas con símbolos, pero tanto da: sin instrucciones precisas, ponerse a hacer mezclas &quot;por deporte&quot; es tentar tu suerte; allá afuera, hay cráteres que lo demuestran.</p>",
			},
			'baúl': {
				'text': "<p>No sé de qué estará hecho el baúl, pero entiendo que podría pasar una erupción volcánica encima y ni se calentaría. También puede aguantar descompresiones violentas. Material de primera, ya te digo.</p>",
			},
		},
	},
	'pala': {
		'clear': true,
		'text': "<p>Cojo la pala y, tras cerrar el cobertizo, la muevo un par de veces y golpeo el suelo del sendero con el canto y la punta; saltan un par de chispas pero no se astilla y el mango se mantiene recto.</p>\n<p>Me gusta, la pala: no tiene la masa del chuzo o la picota, pero se maniobra mucho mejor; vaya a saber de qué estará hecha, pero es liviana y extremadamente dura. Si se tercia, sirve contra la mayoría de los bichos.</p>\n<p>Con la <a class=\"squiffy-link link-passage\" data-passage=\"pala al hombro\" role=\"link\" tabindex=\"0\">pala al hombro</a>, me dirijo tranquilo <a class=\"squiffy-link link-section\" data-section=\"sendero\" role=\"link\" tabindex=\"0\">hacia el barbecho</a>.</p>",
		'attributes': ["tengo_pala"],
		'passages': {
			'pala al hombro': {
				'text': "<p>Cuando llegué a la estación, apenas notaba el peso de la pala. Ahora, tengo que acordarme que la llevo.</p>",
			},
		},
	},
	'chuzo': {
		'clear': true,
		'text': "<p>Cojo el chuzo y, tras cerrar el cobertizo, lo muevo un par de veces y golpeo el suelo del sendero con la punta; saltan un par de chispas y astillas del suelo, pero el chuzo apenas vibra y se mantiene recto.</p>\n<p>Me gusta, el chuzo, aunque menos que la pala: pesa lo suyo, y se maniobra con dificultad, pero no hay herramienta en la estación que me dé una sensación tan... atávica de seguridad. Es una pieza pesada, durísima... y eficaz contra cualquier bicho.</p>\n<p>Y me consta.</p>\n<p>Con el <a class=\"squiffy-link link-passage\" data-passage=\"chuzo al hombro\" role=\"link\" tabindex=\"0\">chuzo al hombro</a>, me dirijo tranquilo <a class=\"squiffy-link link-section\" data-section=\"sendero\" role=\"link\" tabindex=\"0\">hacia el barbecho</a>.</p>",
		'attributes': ["tengo_chuzo"],
		'passages': {
			'chuzo al hombro': {
				'text': "<p>Cuando llegué a la estación, podía sostener el chuzo a dos manos, pero era torpe; no lograba balancearlo bien. Ahora, puedo hacer guaripolas con este hierro...</p>",
			},
		},
	},
	'sendero': {
		'clear': true,
		'text': "<p>Llevo medio camino andado hacia el barbecho, hecho unas pascuas, cuando noto que los helechos se mueven a mi derecha... y se escucha un ruido como el que haría un cerdo hozando entre las matas.</p>\n<p>Bichos.</p>\n<p>¡Mierda!</p>\n<p>Ya sabía yo que el día empezaba <i>demasiado</i> bien.</p>\n<p>Por el volumen del ruido y el movimiento de las plantas no parece que sea algo demasiado peligroso; podría atenderlo más tarde y <a class=\"squiffy-link link-section\" data-section=\"rastros\" role=\"link\" tabindex=\"0\">seguir mi camino</a>...</p>\n<p>...o <a class=\"squiffy-link link-section\" data-section=\"echar una mirada\" role=\"link\" tabindex=\"0\">echar una mirada</a> y ver si es algo que puedo despachar rápido.</p>",
		'passages': {
		},
	},
	'echar una mirada': {
		'clear': true,
		'text': "<p>Con cuidado, aparto las plantas con {if seen pala:la pala}{else:el chuzo} y miro entre la espesura.</p>\n<p>Es una oruga, comiendo helechos como si no hubiera mañana.</p>\n<p>¡Joder, qué susto que he pasado!</p>\n<p>Es sólo una oruga; que sí, que mide un metro de largo y pesará sus 100 kilos, pero es <i>una puta oruga</i>: no me va a perseguir, no va sacar crías ya mismo y sólo está comiendo helechos, que aquí crecen como maleza y me importa un bledo si se los come hasta hacerse pupa (je).</p>\n<p>Bueno, <a class=\"squiffy-link link-section\" data-section=\"oruga\" role=\"link\" tabindex=\"0\">nada me cuesta despacharla</a> y luego sigo con lo mío... aunque igual <a class=\"squiffy-link link-section\" data-section=\"rastros\" role=\"link\" tabindex=\"0\">la dejo para más tarde</a> que tampoco pasa nada.</p>",
		'passages': {
		},
	},
	'oruga': {
		'text': "<p>La verdad, esto es cosa de momentos y es mejor no acumular trabajo para la tarde.</p>\n<p>Tomando impulso, doy un salto y le caigo encima con la punta de{if seen pala: la pala}{else:l chuzo}. \n{if seen pala:Le corto la cabeza antes de que se dé cuenta de qué está pasando y con rapidez corto el resto del cuerpo en unos 15 pedazos.}\n{else:Hago palanca con violencia, separando la cabeza del cuerpo y perforo el resto unas 20 veces, desinflándola de sus fluidos corporales.}</p>\n<p>Los helechos quedan hechos un asco y la oruga está <a class=\"squiffy-link link-passage\" data-passage=\"bien muerta\" role=\"link\" tabindex=\"0\">bien muerta</a>.</p>\n<p>Bueno, limpiaré esto más tarde... si es que la vuelta los <a class=\"squiffy-link link-passage\" data-passage=\"bichitos\" role=\"link\" tabindex=\"0\"><i>otros</i> bichos</a> no han dado cuenta de los restos, claro.</p>\n<p>Con una preocupación menos, <a class=\"squiffy-link link-section\" data-section=\"rastros\" role=\"link\" tabindex=\"0\">sigo mi camino</a>.</p>",
		'attributes': ["puntaje+=1"],
		'passages': {
			'bichitos': {
				'text': "<p>La verdad, los bichos chicos no son mejores ni más fáciles de aniquilar que los grandes: se mueven más rápido y si me descuido con la fumigación pueden venir en números de verdad importantes; ahí no me queda otra que encerrarme en el refugio y activar los drones... que matan a todos los bichos, sí, pero me dejan las plantas hechas un asco y a veces tengo que empezar de cero con los brotes tiernos. Una lata.</p>",
			},
			'bien muerta': {
				'text': "<p>La pobre oruga quedó {if seen pala:servida para sushi}{else:lista para carne mechada}...</p>",
			},
		},
	},
	'rastros': {
		'clear': true,
		'text': "<p>Con {if seen echar una mirada:algo de alivio}{else:pies de plomo} voy avanzando al barbecho.</p>\n<p>Putos bichos... le quitan a uno el gusto por el trabajo agrario, joder.</p>\n<p>Voy tan concentrado pensando en {if seen pala:qué hoyos voy a cavar y dónde}{else:qué terreno voy a picar y cuánto} que no atino con el rastro que cruza el sendero hasta que lo tengo encima.</p>\n<p>Es una huella de <a class=\"squiffy-link link-passage\" data-passage=\"baba caracol\" role=\"link\" tabindex=\"0\">babas</a> densa, brillante, como de un metro de ancho, que cruza el sendero de lado a lado... y se ve que es fresca, por suerte: todavía despide ese vaho <a class=\"squiffy-link link-passage\" data-passage=\"irritante\" role=\"link\" tabindex=\"0\">irritante</a>.</p>\n<p>Me cago en la jardinería: hay un caracol <i>grande</i> aquí cerca... y como no me cargue al bicho pronto, empezará a poner huevos vaya usted a saber <a class=\"squiffy-link link-passage\" data-passage=\"dónde\" role=\"link\" tabindex=\"0\">dónde</a> y tendré una infestación en menos de lo que dices &quot;plaga&quot;.</p>\n<p>Por lo visto, mi día comienza con un poco de entomología agresiva. Y con lo bien que había empezado el día, joder...</p>\n<p>El <a class=\"squiffy-link link-passage\" data-passage=\"manual de operaciones\" role=\"link\" tabindex=\"0\">manual de operaciones</a> indica que, en estos casos, primero hay que <a class=\"squiffy-link link-section\" data-section=\"evaluar la amenaza\" role=\"link\" tabindex=\"0\">evaluar la amenaza</a>. En mi barrio, en cambio, dicen que <a class=\"squiffy-link link-section\" data-section=\"equipamiento\" role=\"link\" tabindex=\"0\">primero protegido</a> que luego arrepentido.</p>\n<p>Decisiones, decisiones...</p>",
		'passages': {
			'baba caracol': {
				'text': "<p>Parece como si un dinosaurio hubiera estornudado en medio del sendero.</p>",
			},
			'irritante': {
				'text': "<p>La baba está empezando a evaporarse, pero tocarla sin guantes te deja una quemada fea. Me consta.</p>",
			},
			'dónde': {
				'text': "<p>Lo habitual con los caracoles (da igual el tamaño) es que desoven entre los helechos y las matas, pero los he visto subirse a árboles y dejar sus nidos a varios metros de altura, no te jode.</p>",
			},
			'manual de operaciones': {
				'text': "<p>El manual de operaciones, diseñado y mantenido por los chicos de la <a class=\"squiffy-link link-passage\" data-passage=\"Estación Central\" role=\"link\" tabindex=\"0\">Estación Central</a>, es más bien breve y al grano, lo que a veces es bueno y otras veces  te deja a merced de tu propio criterio. Se supone que debo llevarlo en el sobre transparente de la manga del mono de trabajo, pero es una lata y ya me lo sé <i>casi</i> de memoria.</p>",
			},
			'Estación Central': {
				'text': "<p>La Estación Central está más o menos al centro de las demás estaciones y desde ahí nos despachan los trabajos a cada estación. Con la carga de trabajo que tienen, cuesta creer que tengan tiempo para manuales, pero de algún modo se las arreglan.</p>",
			},
		},
	},
	'equipamiento': {
		'clear': true,
		'text': "<p>La verdad, y visto lo peligrosa que llega a ser la <a class=\"squiffy-link link-passage\" data-passage=\"irritante\" role=\"link\" tabindex=\"0\">baba</a> de estos bichos, no quiero ni acercarme a mirarlo si no estoy con algo de protección &quot;extra&quot;.</p>\n<p>A la carrera, que con los caracoles el tiempo apremia (je), me vuelvo al cobertizo y me pongo el <a class=\"squiffy-link link-passage\" data-passage=\"traje\" role=\"link\" tabindex=\"0\">traje</a> para control de plagas. Es como ponerse un traje espacial, pero sin ayuda, vaya.</p>\n<p>Más tranquilo, me devuelvo a paso vivo\n{if seen evaluar la amenaza: para <a class=\"squiffy-link link-section\" data-section=\"atacar\" role=\"link\" tabindex=\"0\">acabar con esta alimaña</a> de una puñetera vez.}\n{else: y comienzo a <a class=\"squiffy-link link-section\" data-section=\"evaluar la amenaza\" role=\"link\" tabindex=\"0\">seguirle el rastro a esta bestia asquerosa</a>...}</p>",
		'attributes': ["puntaje+=1","traje_puesto"],
		'passages': {
			'irritante': {
				'text': "<p>Tocar la baba de los caracoles gigantes sin guantes te deja una quemada fea. No gracias.</p>",
			},
			'traje': {
				'text': "<p>Los trajes de control de plagas son como mi mono de trabajo, pero mucho más gruesos e incómodos: están presurizados, con escafandra y sistema de aire autónomo. No es que me guste ponérmelos, pero ni mamado me voy a cazar bichos como un caracol gigante así sin más. El mono de trabajo no es una armadura estanca; el traje sí.</p>",
			},
		},
	},
	'evaluar la amenaza': {
		'clear': true,
		'text': "<p>Apartando las plantas, y cuidando de no pisar ramitas u hojas que me delaten, comienzo a seguir el rastro de babas... tarea sencilla; el suelo está como si alguien hubiera pasado con una podadora industrial por la espesura.</p>\n<p>Aparte de la mugre que deja el bicho, <i>nada</i> queda tras su paso.</p>\n<p>A los pocos metros ya puedo oírlo \n{if seen equipamiento: aunque, gracias al traje, no tengo que olerlo; haber estado cerca de sus babas ya fue suficiente.}\n{else:y por desgracia puedo olerlo; sus babas eran apenas un pálido heraldo de la <a class=\"squiffy-link link-passage\" data-passage=\"peste\" role=\"link\" tabindex=\"0\">peste</a> de la criatura.}</p>\n<p>Avanzo y por fin lo diviso 10 metros adelante, al pie de un árbol, masticándole sus raíces como si fueran hierbas.</p>\n<p>Joder.</p>\n<p>Debe medir de hocico a cola unos 3 metros... y la concha, que parece hecha de piedra, ha de ser de 2 metros de alto o así.</p>\n<p>No me atrevo ni a {if seen protegido: <a class=\"squiffy-link link-passage\" data-passage=\"respirar fuerte\" role=\"link\" tabindex=\"0\">respirar fuerte</a>, traje con estanco o no}{else:<a class=\"squiffy-link link-passage\" data-passage=\"respirar fuerte\" role=\"link\" tabindex=\"0\">suspirar</a>}.</p>\n<p>{if seen pala:Con la pala, liviana como es, corro menos riesgos de movilidad, pero no creo que sirva contra el caparazón.. y por el frente tengo dudas de tener más de una oportunidad.}\n{else:Con el chuzo, que pesa lo suyo, me oirá en cuanto me le acerque, pero creo puedo reventarle el caparazón a golpes antes de que pueda reaccionar.}</p>\n<p>Y luego, están las <a class=\"squiffy-link link-passage\" data-passage=\"babas\" role=\"link\" tabindex=\"0\">babas</a>.</p>\n<p>Mierda y más mierda.</p>\n<p>{if traje_puesto:\nA menos que el animal se me eche encima, el traje <i>debiera</i> protegerme de sus &quot;salpicaduras&quot; o la eventual mordida.\n    {if seen pala: La pala tendrá que bastarme}\n    {else: El chuzo me bastará}\n     para acabar con el caracol.</p>\n<p>Bueno, basta ya de pendejadas. ¡Voy a acabar con este cabrón <a class=\"squiffy-link link-section\" data-section=\"atacar\" role=\"link\" tabindex=\"0\">ahora</a>!\n}\n{else:\nDudo que el mono de trabajo me proteja si el animal se me eche encima, o en caso de que me &quot;salpique&quot;, para no hablar de que me llegue a morder.</p>\n<p>Así las cosas, no sería mala idea volver al cobertizo a <a class=\"squiffy-link link-section\" data-section=\"equipamiento\" role=\"link\" tabindex=\"0\">buscar una mejor protección</a>... o dejarme de pendejadas y arriesgarme a <a class=\"squiffy-link link-section\" data-section=\"atacar\" role=\"link\" tabindex=\"0\">acabar ya mismo con este cabrón</a>.}</p>",
		'passages': {
			'peste': {
				'text': "<p>Antes de venir a la estación botánica trabajé en una fundición de metales pesados... y los crisoles olían mejor que este caracol.</p>",
			},
			'respirar fuerte': {
				'text': "<p>Aunque no les vea las orejas, tienen buen oído... y sienten cualquier movimiento en el suelo a 5 pasos o así.</p>",
			},
			'babas': {
				'text': "<p>Nunca he peleado un &quot;mano a mano&quot; con estos bichos... pero si la &quot;conchita&quot; es alguna indicación de lo &quot;avanzado&quot; del animal, puede que no se limite a dejar babas mientras avanza.</p>",
			},
		},
	},
	'atacar': {
		'clear': true,
		'text': "<p>Irrumpo sigiloso en el erial formado por las babas del caracol, que\n{if traje_puesto:\n    {if seen pala: sigue comiendo como si nada, ignorándome por completo.}\n    {else: deja de masticar por un instante.}\n}\n{else: en ese momento deja de masticar\n    {if seen pala: y se queda inmóvil.}\n    {else: y casi instantáneamente gira sus ojos hacia mí.}\n}</p>\n<p>No le doy tiempo a reaccionar y le ataco de inmediato\n{if seen pala: golpeándole el caparazón con el filo de la pala...\nque rebota sin causarle el más mínimo daño.</p>\n<p>De la cabeza del caracol sale un siseo...}\n{else: embistiendo el caparazón con la punta del chuzo, penetrando con un crujido horrible.\nDe la cabeza del caracol sale un chillido agudo...}\n y el animal levanta la cola, despegándola del suelo con un ruido líquido.</p>\n<p>Durante un brevísimo instante creo recordar algo parecido...</p>\n<p>...de otro animal...</p>\n<p>...en otro tiempo y lugar...</p>\n<p>...y entonces la cola del caracol <a class=\"squiffy-link link-section\" data-section=\"lluvia de babas\" role=\"link\" tabindex=\"0\">escupe una lluvia de babas</a>. </p>",
		'passages': {
		},
	},
	'lluvia de babas': {
		'text': "<p>Atino a cubrir mi cara con la manga del\n{if traje_puesto: traje, que recibe las gotas de lleno... sin que parezcan afectarlo; escurren al suelo, que comienza a humear de inmediato.}\n{else: mono, que empieza a consumirse ahí donde caen las gotas.</p>\n<p>Aunque sé que ya es tarde, intento retroceder, pero en mi apuro me enredo con {if seen pala: la pala}{else:el chuzo}... y <a class=\"squiffy-link link-section\" data-section=\"muerte\" role=\"link\" tabindex=\"0\">caigo de espalda sobre el rastro de babas</a>.}</p>\n<p>{if traje_puesto:\n    {if seen pala: La pala no vale nada con la concha, así que iré a por las partes blandas.\n    Puedo intentar <a class=\"squiffy-link link-section\" data-section=\"mátalo sucio\" role=\"link\" tabindex=\"0\">atacarlo por la cola</a> y cortar con las babas... o arriesgarme e <a class=\"squiffy-link link-section\" data-section=\"mátalo limpio\" role=\"link\" tabindex=\"0\">ir a por la cabeza</a>}\n    {else: Bueno, basta de tonterías: es hora de <a class=\"squiffy-link link-section\" data-section=\"mátalo limpio\" role=\"link\" tabindex=\"0\">rematar a este cabrón</a>}.}</p>",
		'passages': {
		},
	},
	'mátalo sucio': {
		'text': "<p>Para evitar más duchas viscosas, cojo la pala a dos manos, salto y le caigo encima de la cola con la punta de la pala; con un satisfactorio crujido y un ruido líquido le cerceno la cola...</p>\n<p>... y una explosión de babas cubre todo alrededor mío, mientras el caracol da un verdadero rugido.</p>\n<p>Asqueado, lo rodeo en un par de pasos y lo corto la cabeza de un solo golpe.</p>\n<p>El animal <a class=\"squiffy-link link-passage\" data-passage=\"yace inerte\" role=\"link\" tabindex=\"0\">yace inerte</a>.</p>\n<p>Las babas del bicho gotean por mi traje y contemplo las plantas a mi alrededor: todo humea y se consumen ante mis ojos, como si alguien hubiera usado una manguera de incendios con ácido en el lugar.</p>\n<p>El árbol, con la base consumida por la corrosión y sus raíces socavadas y deshechas, cae derribado.</p>\n<p>De la pala, sólo me ha quedado el mango.</p>\n<p><a class=\"squiffy-link link-section\" data-section=\"final\" role=\"link\" tabindex=\"0\">Joder, qué desastre</a>...</p>",
		'attributes': ["puntaje+=1"],
		'passages': {
			'yace inerte': {
				'text': "<p>El pobre animal parece un <i>amouse bouche escargot</i>...</p>",
			},
		},
	},
	'mátalo limpio': {
		'text': "<p>{if seen pala:Quiero terminar con esto rápido, así que cojo la pala a dos manos, rodeo al caracol en un par de pasos y lo corto la cabeza de un solo golpe.</p>\n<p>El animal <a class=\"squiffy-link link-passage\" data-passage=\"yace inerte\" role=\"link\" tabindex=\"0\">yace inerte</a>.}\n{else:Con más furia que antes, embisto al caracol con todo mi peso apoyado en el chuzo.</p>\n<p>Joder: lo arponeo, atravesando la concha y luego la cabeza del bicho, dejando la punta del chuzo clavada al tronco del árbol.</p>\n<p>El animal no alcanzó ni a suspirar y ha quedado <a class=\"squiffy-link link-passage\" data-passage=\"completamente inerte\" role=\"link\" tabindex=\"0\">completamente inerte</a>.}</p>\n<p>Las babas del bicho gotean por mi traje y contemplo las plantas a mi alrededor: algunas hojas humean y se consumen ante mis ojos, pero no hay mayores daños.</p>\n<p>El árbol tiene algunas raíces mordidas y alguna escoriación menor en el tronco, pero nada que un emplasto de tierra y abono no pueda curar.</p>\n<p>Nada mal para una exterminación: limpia y sin daños colaterales.</p>\n<p>Qué digo... <i>¡<a class=\"squiffy-link link-section\" data-section=\"final\" role=\"link\" tabindex=\"0\">si soy el puto amo de esta estación</a></i>!</p>",
		'attributes': ["puntaje+=1","puntaje+=1"],
		'passages': {
			'yace inerte': {
				'text': "<p>El pobre animal parece un <i>amouse bouche escargot</i>...</p>",
			},
			'completamente inerte': {
				'text': "<p>El pobre caracol quedó como una gigantesca y grotesca brocheta...</p>",
			},
		},
	},
	'final': {
		'clear': true,
		'text': "<p>{if seen mátalo sucio:Bueno, tengo que despejar este terreno... y mandar una orden de adquisición para otra pala.</p>\n<p>Menuda faena me espera: y eso, si no deciden &quot;prescindir&quot; de mí y traer un reemplazo.</p>\n<p>En fin, que fue una buena semana... hasta hoy.}\n{else: Bueno, tengo que volver al laboratorio y traer un frasco: seguro que querrán muestras del bicho...</p>\n<p>...y quién sabe: a lo mejor me cae una &quot;visita amistosa&quot; cuando termine mi turno: hay que hacer crecer la población sólo con &quot;buena cepa&quot;, je.}</p>\n<p>Tengo un <a class=\"squiffy-link link-passage\" data-passage=\"reporte\" role=\"link\" tabindex=\"0\">reporte</a> que hacer, así que camino de vuelta al laboratorio a paso {if seen mátalo sucio:lento y cansino: ha sido una victoria a lo Pirro, joder}{else:vivo y ganoso: esto lo anima a uno a seguir luchando todos los días}.</p>\n<p>Contemplo una vez más la estación con una mirada {if seen mátalo sucio:algo abatida}{else:nueva e inquieta}; cuesta creer que más allá del perímetro de seguridad no hay más que arena y asfixia. No estamos demasiado mejor que los pobres <a class=\"squiffy-link link-passage\" data-passage=\"Espaciales\" role=\"link\" tabindex=\"0\">Espaciales</a>... pero tenemos suelo y gravedad naturales bajo los pies, al menos.</p>\n<p>Exceptuando aquí y allá los domos de nuestras estaciones en funciones y los cráteres de <a class=\"squiffy-link link-passage\" data-passage=\"estaciones fallidas\" role=\"link\" tabindex=\"0\">algunas estaciones fallidas</a>, estamos en medio de un desierto árido,  completamente yermo, helado... y rojo.</p>\n<p>Así, precaria, avanza la <a class=\"squiffy-link link-section\" data-section=\"Marte\" role=\"link\" tabindex=\"0\">colonización de Marte</a>...</p>",
		'passages': {
			'reporte': {
				'text': "<p>En la Estación Central estiman que se aprende mucho de los éxitos, pero aún más de los tropiezos. Vaya si seremos todos optimistas, pero los de la Estación Central son el no va más...</p>",
			},
			'Espaciales': {
				'text': "<p>Unos tipos duros, los Espaciales. Hemos tratado de reclutar entre ellos, pero no les convence nuestro &quot;estilo rural&quot;. Teníamos a uno medio convencido, pero <a href=\"https://incanus.caad.club/goteras.html\" target=\"_blank\">tomó un OTV</a> y se fué a los asteroides camino de Júpiter, creo.</p>",
			},
			'estaciones fallidas': {
				'text': "<p>Una se ha perdido en un azote descontrolado de plagas, otra en un &quot;accidente&quot; al mezclar químicos (el operador era imbécil, vaya) y otra más por una descompresión explosiva. Considerando todas las <i>otras cosas</i> que pueden irse al diablo en una estación, es sorprendente que sean tan pocas las instalaciones que han fallado... hasta ahora.</p>",
			},
		},
	},
	'Marte': {
		'clear': true,
		'text': "<p>Una colonización más bien lenta, sobre todo porque, como estas estaciones demuestran, aún no terminamos de entender qué diablos pasó en este planeta para que quedara así ni por qué su suelo reacciona como lo hace con nuestras plantas.</p>\n<p>Para no hablar de los animales, por cierto: todo lo que nace y crece en contacto con el suelo marciano muta rápidamente a un estado casi prehistórico, lo que nos tiene a todos completamente apabullados... y a los encargados de demografía y crecimiento poblacional algo preocupados, la verdad.</p>\n<p>A lo mejor ya ha pasado en otra parte, <a class=\"squiffy-link link-passage\" data-passage=\"vaya uno a saber\" role=\"link\" tabindex=\"0\">vaya uno a saber</a>, pero si en la <a class=\"squiffy-link link-passage\" data-passage=\"Estación Central\" role=\"link\" tabindex=\"0\">Estación Central</a> lo saben, no nos lo han dicho; la información innnecesaria es casi tan peligrosa como la información falsa, ya se sabe.</p>\n<p>Porque así están las cosas: no hay regreso posible a la Tierra, menos de la manera apresurada y precipitada que se hizo nuestra &quot;migración&quot;, a espalda de cualquier gobierno, &quot;compañía&quot; o ricachones de turno que quisieran cosechar nuestros logros.</p>\n<p>Sin ataduras... y sin apoyos: baja tasa de retorno de <a class=\"squiffy-link link-passage\" data-passage=\"inversión\" role=\"link\" tabindex=\"0\">inversión</a> ¿saben?</p>\n<p>Así que tenemos que salir adelante con lo que hay y lo que somos o seremos; ésa es la primera regla de la colonización de Marte.</p>\n<p>Afíncate o muérete.</p>\n<p>De momento, tengo un reporte que llenar... y luego {if seen mátalo sucio:puede que tenga que buscarme la vida}{else: un terreno en barbecho que cuidar}.</p>\n<p>Qué día...</p>\n<p>{if seen mátalo sucio:</p>\n<p><font face=\"chiller\" color=\"green\" size=10><b>Has terminado por hoy</b></font>}\n{else:</p>\n<p><font face=\"chiller\" color=\"green\" size=10><b>Has vencido... por hoy</b></font>}</p>\n<p>Puedes revisar tu <a class=\"squiffy-link link-passage\" data-passage=\"Puntuación\" role=\"link\" tabindex=\"0\">puntuación</a>, leer los <a class=\"squiffy-link link-passage\" data-passage=\"Agradecimientos\" role=\"link\" tabindex=\"0\">agradecimientos</a>, mirar las <a class=\"squiffy-link link-passage\" data-passage=\"Curiosidades\" role=\"link\" tabindex=\"0\">curiosidades</a>, saber algo más <a class=\"squiffy-link link-passage\" data-passage=\"Acerca de\" role=\"link\" tabindex=\"0\">acerca de &quot;Rastros&quot;</a> o <a class=\"squiffy-link link-section\" data-section=\"Reiniciar\" role=\"link\" tabindex=\"0\">reiniciar</a> el relato.</p>",
		'passages': {
			'vaya uno a saber': {
				'text': "<p>Hay rumores de que una de las compañías mineras tuvo un <a href=\"https://incanus.caad.club/macetas.html\" target=\"_blank\">lío de macetas</a> en el cinturón de asteroides camino a Júpiter, pero no hay nada claro.</p>",
			},
			'Estación Central': {
				'text': "<p>La Estación Central está más o menos al centro de las demás estaciones y desde ahí se coordinan los trabajos de nuestra pequeña colonia. Se puede postular a trabajar ahí, pero el proceso de selección es muy riguroso y la carga de trabajo no es mejor que en las estaciones botánicas.</p>",
			},
			'inversión': {
				'text': "<p>El dinero, en Marte, está en las plataformas orbitales de las compañías a cargo de explotación minera. Será que es menos riesgoso el espacio que colonizar Marte, no te jode...</p>",
			},
			'Puntuación': {
				'text': "<p>Has conseguido {puntaje} punto{if puntaje=1: }{else:s }de 5 así que calificas como \n{if puntaje=0: <b>pisaverde</b></p>\n<p>Te limitaste a pasear por el lugar...}\n{if puntaje=1: <b>desmalezador</b>}\n{if puntaje=2: <b>podador de césped</b>}\n{if puntaje=3: <b>paisajista al uso</b>}\n{if puntaje=4: <b>jardinero</b>}\n{if puntaje=5: <b>exterminador de plagas</b>}</p>\n<p>{if seen laboratorio:+1 Llevaste muestras al laboratorio<br>}\n{if seen oruga:+1 Mataste una oruga<br>}\n{if seen equipamiento:+1 Te pusiste el traje para control de plagas<br>}\n{if seen final:\n    {if seen mátalo sucio:+1 Exterminaste al caracol con la pala y comenzando por la cola: qué desastre...<br>}\n    {else:+2\n        {if seen pala: Exterminaste al caracol con la pala y decapitándolo}{else: Exterminaste al caracol con el chuzo}: un trabajo limpio...<br>}\n}</p>",
			},
			'Agradecimientos': {
				'text': "<p>El autor quiere agradecer a:</p>\n<ul>\n<li>Comely, por su testing alfa</li>\n<li>Fernando Gregoire, por su testing beta</li>\n<li>Alex Warren, por crear Squiffy, con el que pude construir este hiperrelato</li>\n</ul>",
			},
			'Curiosidades': {
				'text': "<p>Algunas curiosidades para encontrar en una nueva lectura de &quot;Rastros&quot;:</p>\n<ul>\n<li>Algunos bichos quedan &quot;servidos&quot; según cómo se les extermina; fíjate en los detalles una vez que los has matado.</li>\n<li>El espacio es la frontera final, pero la colonización planetaria tiene sus riesgos. Lee entre líneas y verás por qué.</li>\n<li>Los chicos de la Estación Central están en todo. A veces, en detalles insospechados.</li>\n</ul>",
			},
			'Acerca de': {
				'text': "<p><b>Sobre la Creación de la Obra</b></p>\n<p>Estaba revisando la publicación de mis anteriores trabajos en <a href=\"http://textadventures.co.uk/\" target=\"_blank\">textadventures.co.uk</a> cuando ví un enlace a un sistema de creación de hiperrelatos llamado <a href=\"https://www.ifwiki.org/Squiffy\" target=\"_blank\">Squiffy</a>.</p>\n<p>Su sencillez, potencial y sobre todo la rapidez con que permite crear este tipo de ficciones interactivas me sedujo y me animó a escribir nuevamente un relato interactivo, después de casi 5 años de &quot;silencio&quot;.</p>\n<p>El resultado está ante ustedes.</p>\n<p><b>Sobre el Tema de la Obra</b></p>\n<p>Siempre que se habla de la colonización del espacio, la gente imagina emocionantes epopeyas de aventura y riesgo en el espacio, la frontera final...</p>\n<p>...pero la verdad es que, cuando se haga, la colonización del espacio y de otros mundos tendrá todas las pequeñas alegrías, dificultades y miserias del día a día de los seres humanos de estos tiempos y de todos los tiempos, porque <i>tanto</i> no ha de haber cambiado el ser humano cuando definitivamente se lance a las estrellas.</p>\n<p>Algo de eso he querido reflejar en <a href=\"https://incanus.caad.club/goteras.html\" target=\"_blank\">&quot;Goteras&quot;</a> y <a href=\"https://incanus.caad.club/macetas.html\" target=\"_blank\">&quot;Macetas&quot;</a>, los 2 trabajos anteriores de esta saga de Espaciales.</p>\n<p>Si este tercer relato lo consigue o no, queda a juicio del lector.</p>\n<p>Santiago de Chile, 4 de Julio, 2016</p>",
			},
		},
	},
	'muerte': {
		'text': "<p>Escucho el siseo de mi mono e intento rodar antes de que se consuma por completo, así que no puedo esquivar un segundo escupitajo del caracol, más abundante que el anterior.</p>\n<p>Las babas me golpean en todas partes, incluyendo la cara; siento quemaduras como si me estuvieran asando y mi visión se nubla por completo.</p>\n<p>Manoteando inútilmente, no logro salir del paso del caracol, que me cae encima con todo su peso...</p>\n<p>...soy su jodido postre...</p>\n<font face=\"chiller\" color=\"red\" size=10><b>Has muerto</b></font>\n\n<p>Puedes revisar tu <a class=\"squiffy-link link-passage\" data-passage=\"Puntuación\" role=\"link\" tabindex=\"0\">puntuación</a>, leer los <a class=\"squiffy-link link-passage\" data-passage=\"Agradecimientos\" role=\"link\" tabindex=\"0\">agradecimientos</a>, mirar las <a class=\"squiffy-link link-passage\" data-passage=\"Curiosidades\" role=\"link\" tabindex=\"0\">curiosidades</a> o <a class=\"squiffy-link link-section\" data-section=\"Reiniciar\" role=\"link\" tabindex=\"0\">reiniciar</a> el relato.</p>",
		'passages': {
			'Puntuación': {
				'text': "<p>Has conseguido {puntaje} punto{if puntaje=1: }{else:s }de 5 así que calificas como \n{if puntaje=0: <b>pisaverde</b></p>\n<p>Te limitaste a pasear por el lugar...}\n{if puntaje=1: <b>desmalezador</b>}\n{if puntaje=2: <b>podador de césped</b>}\n{if puntaje=3: <b>paisajista al uso</b>}\n{if puntaje=4: <b>jardinero</b>}\n{if puntaje=5: <b>exterminador de plagas</b>}</p>\n<p>{if seen laboratorio:+1 Llevaste muestras al laboratorio<br>}\n{if seen oruga:+1 Mataste una oruga<br>}\n{if seen equipamiento:+1 Te pusiste el traje para control de plagas<br>}\n{if seen final:\n    {if seen mátalo sucio:+1 Exterminaste al caracol con la pala y comenzando por la cola: qué desastre...<br>}\n    {else:+2\n        {if seen pala: Exterminaste al caracol con la pala y decapitándolo}{else: Exterminaste al caracol con el chuzo}: un trabajo limpio...<br>}\n}</p>",
			},
			'Agradecimientos': {
				'text': "<p>El autor quiere agradecer a:</p>\n<ul>\n<li>Comely, por su testing alfa</li>\n<li>Fernando Gregoire, por su testing beta</li>\n<li>Alex Warren, por crear Squiffy, con el que pude construir este hiperrelato</li>\n</ul>",
			},
			'Curiosidades': {
				'text': "<p>Algunas curiosidades para encontrar en una nueva lectura de &quot;Rastros&quot;:</p>\n<ul>\n<li>Algunos bichos quedan &quot;servidos&quot; según cómo se les extermina; fíjate en los detalles una vez que los has matado.</li>\n<li>Si quieres saber dónde está este &quot;jardín de las delicias&quot;, intenta completar este relato sin que te maten...</li>\n</ul>",
			},
		},
	},
	'Reiniciar': {
		'text': "",
		'js': function() {
			squiffy.story.restart();
		},
		'passages': {
		},
	},
}
})();