/*
 * Portcullis
 *
 * Special code
 *
 */

GAME_NAME = 'Portcullis'
GAME_ID = 'PCS'
MAX_SCORE = 45;
SCORE_AS_PERCENTAGE = false;

INV_CAP = 999; // number of items in inventory. max out, because inventory limits are annoying.


// list of flag & variable abbreviations
GAME_OVER = 'g0';

JUST_MOVED = 'j0';
TURN_NUMBER = 'f0';

IMAGE_ALIGN = 'fIM';

BEGUN_GAME = 'f1';
BOUGHT_DRINK = 'f2';
DRUNK = 'f3';
BEER_LEFT = 'f4';
GOT_NOTE = 'f5';
BEER_CELLAR_OPEN = 'f6';
TOLD_ABOUT_JOB = 'f7';
BOAT_GONE = 'f8';
TALKED_TO_MAYOR = 'f9';
EVER_DRUNK = 'fA';


BOUGHT_TSHIRT = 'fB';
BOUGHT_SNOWGLOBE = 'fC';
GOT_SNOWGLOBE = 'fD';
//BOUGHT_LANTERN = 'fD';

MEETING_COUNTDOWN = 'f10';
MEETING_HAPPENED = 'f11';
READ_NOTE = 'f12';
WAITED_IN_PUB = 'f13';
MEETING_STARTED_FROM_PUB = 'f14';

BANANA_PEELED = 'f21';
WHAT_CHEF_WANTS = 'f23';
NUM_WRONG_FOODS = 'f24';
WHAT_CHEF_GOT = 'f25';
FOOD_RAN_OUT = 'f26';
OVEN_OPEN = 'f27';
OVEN_EVER_OPENED = 'f28';
MET_CHEF = 'f29';
OVEN_PERMASHUT = 'f2A';
WHO_KNOWS_ABOUT_BANANASKIN = 'f2B';
FIRST_WRONG_CHEF_FOOD = 'f2C';
SECOND_WRONG_CHEF_FOOD = 'f2D';

PYRAMID_COMBINATION = 'f30';
PYRAMID_KEY = 'f31';
PYRAMID_CODE_ENTERED = 'f32';
GARGOYLE_SHUFFLE_ORDER = 'f33';
PYRAMID_OPENED = 'f34';
FRAF_BEING_CHASED = 'f35';
MUMMY_DEAD = 'f36';
GEMS_GLOWING = 'f37';

DRAWBRIDGE_OPEN = 'f40';
DRAWBRIDGE_EVER_OPENED = 'f41';

MAGIC_WORD = 'f50';
HEARD_MAGIC_WORD = 'f51';

TILE_GOLD = 'f60';
GOT_TILE = 'f61';
TRAP_DISARMED = 'f62';
ARIANE_IN_TRAP = 'f63';
PLAYER_IN_TRAP = 'f64';
PUT_TILE_ON_TRAP = 'f65';
DWARF_HAS_BOW = 'f66';
DWARF_DEAD = 'f67';
SEEN_DEAD_DWARF = 'f68';
SUMMONED_MINION = 'f69';
SHOWN_DWARF_EARS = 'f6A';
TALKED_TO_DWARF = 'f6B';
STANDOFF_INTERRUPTED = 'f6C';

TAKEN_STAUNTONS_STAFF = 'f70';
DOG_HAS_STAUNTON = 'f71';
DOG_FRIENDLY = 'f72';
THING_IN_BOOKCASE = 'f73';
BOOKCASE_SOLVED = 'f74';
ONE_LEGGED_MINION = 'f75';
DOG_JUST_DROPPED_STAFF = 'f76';
STAFF_POINTED_AT = 'f77';
DONE_FETCH = 'f78';
DOG_BIT_SKELETON = 'f79';
HELLHOUND_DEAD = 'f7A';

ANACHRONISM_JOKE = 'f80';
ROBOT_ACTIVATED = 'f81';
ROBOT_DEAD = 'f82';
ARGUMENT_POINTER = 'f83';
MIRANDA_HAS_WATER = 'f84';
FLOWN_KITE = 'f85';

LIBRARY_SCENE = 'f90';
HEARD_LIBRARY_SCENE = 'f91';
LOOKED_THROUGH_PAINTING = 'f92';
SAVED_HELMUT = 'f93';
PAINTING_REMOVED = 'f94';
PAINTING_EVER_REMOVED = 'f95';
SEEN_CONSPIRACY = 'f96';
HEARD_WHOLE_CONVERSATION = 'f97';
READ_BOOK = 'f98';

ARIANE_DEAD = 'f100';
FRAF_DEAD = 'f101';
MIRANDA_DEAD = 'f102';
STAUNTON_DEAD = 'f103';
ARIANE_FREE = 'f104';
FRAF_FREE = 'f105';
MIRANDA_FREE = 'f106';
STAUNTON_FREE = 'f107';

FINAL_SCENE = 'f110';
N_ADVENTURERS_LEFT = 'f111';
TOOK_HELMET = 'f112';
WORN_HELMET = 'f113';
FIGHT_STARTED = 'f114';

MONEY_LEFT = 'fM';

PYRAMID_ANIMALS = ['fish',    'lion',    'owl',      'snake', 'ox'];
PYRAMID_COLOURS = ['white',   'green',   'blue',     'red',   'purple'];
PYRAMID_GEMS    = ['diamond', 'emerald', 'sapphire', 'ruby',  'amethyst'];
NUM_COMBINATION_DIGITS = 5;


function set_gameflags() // if they're initially zero they needn't be set here
{
	sgs(MONEY_LEFT, 6);
	sgs(BEER_LEFT, 10);

	sgs(MEETING_COUNTDOWN, 3);
	
	sgs(PYRAMID_COMBINATION, random_pyramid_combination());
	sgs(PYRAMID_KEY, random_pyramid_combination());
	sgs(PYRAMID_CODE_ENTERED, '55555');
	sgs(GARGOYLE_SHUFFLE_ORDER, random_pyramid_combination());
	
	sgs(THING_IN_BOOKCASE, book.id);
	
	sleep(hellhound);
	sleep(robot);
	set_staunton_swearword();
	

}


// words of more than three letters to ignore
WORDS_TO_IGNORE = 'about.with.around.under.over.go.do';

Daemons = [];

PARDON = 'Pardon?'

function initialiseGame()
{
	give_person(ariane, bow);
	give_person(staunton, staff);
	
}


// all 'special command' attempts come this way if they are
// not caught by a specific place. Return true if a command
// is interpreted and obeyed (even if it is to no effect)
function anywhere_special()
{
	// you can create on-the-fly 'dynamic synonyms' this way -
	// it's awkward, but it will work.

	// make 'banana' refer to the peel if banana is peeled
	if(gs(BANANA_PEELED)) {
		for(var i=1; i<=MAX_TOKENS; ++i) {
			if(Token[i] == 'banana') {
				Token[i] = 'bananaskin';
				if(i < MAX_TOKENS && Token[i+1]=='bananaskin') { // "get banana skin"
					for(var j=i+1; j<MAX_TOKENS; ++j) {
						Token[j] = Token[j+1];
					}
					Token[MAX_TOKENS]='';
					//obey();
					//return true;
				}
			}
		}
	}
	// change "zapdorf castle" to "castle" if Token[1] isn't ask
	if(Token[1]!='talk') {
		var gotIt = false;
		for(var i=2; i<=MAX_TOKENS - 1; ++i) {
			if(!gotIt && Token[i]=='zapdorf' && Token[i+1]=='castle') { Token[i] = 'castle'; gotIt = true; };
			if(gotIt) { Token[i] = Token[i+1] };
		}
		
	}
	
	// change "x portcullis [=town] hall" to "x hall"
	if(Token[2]=='portcullis' && Token[3]=='hall') {
		for(var i=2; i<=MAX_TOKENS - 1; ++i) {
			Token[i] = Token[i+1];
		}
		Token[MAX_TOKENS]='';
	}
	
	// change 'lead' or 'gold' to 'tile' (once) if Token[1] isn't ask or alchemist
	if(Token[1]!='talk' && Token[1]!='alchemist') {
		for(var i=2; i<=MAX_TOKENS; ++i) {
			if(Token[i] == (gs(TILE_GOLD) ? 'gold' : 'lead')) {
				Token[i] = 'tile';
				if(Token[i+1] == 'tile') {
					for(var j=i+1; j<=MAX_TOKENS-1; ++j) {
						Token[j] = Token[j+1];
					}
				}
			}
		}
	}
	
	
	// 'kill ariane with bow' -> 'shoot ariane'
	if(Token[1]=='fight' && is_personname(Token[2]) && Token[3]=='bow') {
		Token[1] = 'shoot';
		return false;
	}

	// interpret 'pay' as 'give money to'
	if(Token[1]=='pay') {
		for(var i=MAX_TOKENS; i > 2; --i) {
			Token[i] = Token[i - 1];
		}
		Token[1] = 'give';
		Token[2] = 'money';
		return false;
	}
	
	// fudge because 'drink' is a noun as well as a verb
	if(Token[1]=='drink' && !Token[2]) {
		drink_beer();
		return true;
	}
	
	// shoot
	if(Token[1]=='shoot') {
		shoot_bow();
		return true;
	}
	
	// say the magic word
	if(Token[1]==gs(MAGIC_WORD) || Token[1]=='talk' && Token[2]==gs(MAGIC_WORD)) {
		say_magic_word();
		return true;
	}
	
	// try to trip someone
	if(Token[1]=='trip') {
		if(is_personname(Token[2]) || (Token[2]=='up' && is_personname(Token[3]))) {
			var person = eval(Token[is_personname(Token[2])?2:3]);
			if(personloc(person)!=heroloc()) {
				say("You can't see " + the_person(person) + " here.");
			} else if(asleep(person)) {
				say(is_asleep(person));
			} {
				say("You stick your foot out, but " + capitalise(the_person(person)) + " steps over it.");
			}
		} else {
			say("Sorry, I didn't understand that.");
		}
		return true;
	}
	
	// summon the minion
	if(Token[1]=='calcaneus' || (Token[1]=='talk' && Token[2]=='calcaneus' && !Token[3])) {
		summon_minion();
		return true;
	}

	// useless things
	if(Token[1]=='buy') {
		if(in_inv(money)) {
			say("Nobody\'s selling.");
		} else {
			say("You haven't got any money.");
		}
		return true;
	}
	else if(Token[1]=='listen')
	{
		say("You listen...");
		return true;
	}
	
	else if(Token[1]=='jump')
	{
		say('You can\'t jump very high.');
		return true;
	}
	else if(Token[1]=='shout')
	{
		say('\"AAAARRRGGGHHH!!!\"')
		return true;
	}
	else if(Token[1]=='sneeze')
	{
		say('Aaaachoooooo!');
		return true;
	}
	else if(Token[1]=='swear'||Token[2]=='swear')
	{
		say('Well, aren\'t you a grown-up.');
		return true;
	}
	else if(Token[1]=='sit')
	{
		say('You sit down.');
		return true;
	} else if(Token[1]=='stand') {
		say("You're standing up.");
		return true;
	}
	else if(Token[1]=='not')
	{
		say('Not done.');
		return true;
	}

	return(false);
}




INTRO = "It's been three months since the evil sorcerer Zapdorf conquered the town of \
Portcullis, and life under his brutal regime is... pretty much the same, actually, at least \
for those of you who haven't been purged as troublemakers. Sure, his politics \
are a bit harsh, and there are more undead minions around than there used \
to be, but at least the wagons are running on time.\n\
\n\
The most noticeable change has been the steady flow of professional adventurers coming to the city to \
try and dethrone Zapdorf. There\'s a party of them in town now.\n\
\n\
Keeping your head down has worked for you so far. Time to report to your job on the fishing boat - \
the Skipper\'s expecting you at the harbour.\n\
\n";

MANNER_FREQ = 5; // lower than other games, because there are a lot of NPCs

function score_rating()
{

	var n = num_adventurers_dead();
	if(gs(GAME_OVER)) {
		return '\n' + capitalise(numberToWords(n)) +
		       ' professional adventurer' + ( n==1 ? " was": "s were" ) + ' killed.';	
	} else return '';
}

var nu

START_LOC = hut;

function anywhere_do() {
	sgs(TURN_NUMBER, parseInt(gs(TURN_NUMBER),10) + 1);
	
	if(!gs(DRAWBRIDGE_EVER_OPENED)) {
		// before the castle is opened, have the adventurers wander about town
		if(pick(6)==0) { wander_town(ariane); }
		if(pick(6)==0) { wander_town(fraf); }
		if(pick(6)==0) { wander_town(miranda); }
		if(pick(6)==0) { wander_town(staunton); }
	}

	// the minion wanders about the town and the castle
	if(personloc(minion).isTown && pick(6)==0) { wander_town(minion); }
	if(personloc(minion).isCastle && pick(6)==0) { wander_castle(minion); }
	
	
	
	// meeting of the adventurers
	if(heroloc()==beer_cellar && !gs(MEETING_HAPPENED)) {
		// wait a turn (or however many specified in MEETING_COUNTDOWN) before the meeting happens, for atmosphere
		if(gs(MEETING_COUNTDOWN)) {
			sgs(MEETING_COUNTDOWN, gs(MEETING_COUNTDOWN)-1);
		}
		
		if(gs(MEETING_COUNTDOWN)==1) { // the attendees arrive
			if(personloc(fraf)!=beer_cellar) { // (in which case the others aren't there yet either)
				say('\nA party of professional adventurers arrives from the inn above: Ariane the Elf, Fraf the Barbarian, \
					Miranda the Priestess, and Staunton the Wizard. They sit on the barrels.');
				set_personloc(ariane, beer_cellar);
				set_personloc(fraf, beer_cellar);
				set_personloc(miranda, beer_cellar);
				set_personloc(staunton, beer_cellar);
			}
			else {
				sgs(MEETING_COUNTDOWN, 0); // so you don't have to wait an extra turn if you got there early
			}
		}
		
		if(!gs(MEETING_COUNTDOWN)) {
			do_meeting()
		}
	};
	
	// the adventurers wander towards the battlements after they are freed,
	// and hurry there once they are all accounted for
	var n = num_floors_solved();
	if(gs(ARIANE_FREE)) { head_to_battlements(ariane, n>=4); } // shouldn't be more than 5,
	if(gs(FRAF_FREE)) { head_to_battlements(fraf, n>=4); }     // but allow for weird cases where they die after being freed
	if(gs(MIRANDA_FREE)) { head_to_battlements(miranda, n>=4); }
	if(gs(STAUNTON_FREE)) { head_to_battlements(staunton, n>=4); }
}

function num_adventurers_dead(){
	var n = 0;
	if(gs(FRAF_DEAD)) ++n;
	if(gs(ARIANE_DEAD)) ++n;
	if(gs(STAUNTON_DEAD)) ++n;
	if(gs(MIRANDA_DEAD)) ++n;
	
	return n;
}
function num_adventurers_free() {
	var n = 0;
	if(gs(FRAF_FREE)) ++n;
	if(gs(ARIANE_FREE)) ++n;
	if(gs(STAUNTON_FREE)) ++n;
	if(gs(MIRANDA_FREE)) ++n;
	
	return n;
}

function num_floors_solved() {
	var n = 0;
	if(gs(FRAF_DEAD) || gs(FRAF_FREE)) { ++n; }
	if(gs(ARIANE_DEAD) || gs(ARIANE_FREE)) { ++n; }
	if(gs(STAUNTON_DEAD) || gs(STAUNTON_FREE)) { ++n; }
	if(gs(MIRANDA_DEAD) || gs(MIRANDA_FREE)) { ++n; }
	
	return n;
}

function do_meeting() {
	say('\n\n"I shall begin," says Staunton. "We are all intent on defeating Zapdorf, but none of us \
		can do it alone. We must co-operate."\n\
		"I could do it," says Fraf, "if I could get into the castle."\n\
		"I\'ve heard they\'re hiring a kitchen assistant," says Miranda. "Perhaps one of us could get in in disguise?",\n\
		"Impossible," says Ariane. "I don\'t know about you three, but I\'m a renowned adventurer. No disguise would \
		mask my grace and beauty. We need an absolute nobody to go in for us."\n\
		For the first time, everybody in the room seems to notice you.\n\
		\n\
		"You," says Fraf. "Go see the mayor. Get the job. Open the drawbridge from inside. We do the rest. Got it?"\n\
		You look at their faces, not so much expectant as threatening. Any one of these people could seriously hurt you, \
		and they are used to getting their way. You weakly nod.\n\
		"Excellent," says Staunton. "See you on the inside."\n\
		The meeting adjourned, the attendees get up and leave.');
		
		set_personloc(staunton, inn);
		set_personloc(fraf, inn);
		set_personloc(ariane, inn);
		set_personloc(miranda, inn);
		
		sgs(MEETING_COUNTDOWN, 0);
		get_point_for(MEETING_HAPPENED);
}







function game_help()
{
	window.open('porhelp.html','help',
	  'width=600,height=400,scrollbars=yes,menubar=no,resizable=yes,status=no,toolbar=no');
}

function game_hints()
{
	window.open('porhints.html','help',
	  'width=600,height=400,scrollbars=yes,menubar=no,resizable=yes,status=no,toolbar=no');
}

function anywhere_append()
{
	var txt = '';
	
	return(txt);
}

var anywhere_sights = {
	'self' : "You're a typical Portcullis citizen - tangled hair, cheap ragged clothing, skin hardened by \
	          a life of manual labour.",
	'adventurer' : '*see_adventurers()',
	'castle' : '*see_castle()',
	'portcullis' : '*see_city()',
	'wall' : 'Just an ordinary wall.',
	'roof' : '[[heroloc().isOutdoors ? "You\'re outside!" : "Just an ordinary ceiling."]]'
};
function see_city() {
	if(!heroloc().isOutdoors) {
		say("You can't see the city from here.");
	} else {
		if(heroloc()==battlements) {
			say("From the battlements, you have a magnificent view of the city of Portcullis, the surrounding countryside, \
			     and the ocean to the west. You can see your house from here!");
		} else {
			say("The city of Portcullis is a west-coast fishing port, generally unremarkable until its usurpation by \
			     Overlord Zapdorf, who probably wanted a nice sea view. Since then it's become a major attraction for \
			     adventurers looking for a tyrant to overthrow.");
		}
	}
}
ADVENTURERS = [ariane, fraf, miranda, staunton];
function see_adventurers() {
	var adventurersHere = [];
	ADVENTURERS.forEach(function(adventurer) {
		if(personloc(adventurer)==heroloc()) { adventurersHere.push(adventurer); }
	});
	
	if(adventurersHere.length==0) {
		say('There are no adventurers here.');
		return;
	}
	
	if(adventurersHere.length == 1) { // only one adventurer here, describe them in usual way
		personsee(adventurersHere[0]);
		return;
	}
	
	adventurersString = '';
	for(var i = 0; i < adventurersHere.length; ++i) {
		if((i > 0) && adventurersHere.length > 2) { adventurersString += ', '; }
		if(i == adventurersHere.length - 1) { adventurersString += ' and '; }
		adventurersString += adventurersHere[i].fullname;
	}
	
	say(capitalise(adventurersString) + " are professional adventurers: brave, noble and \
		insufferably self-important celebrities who roam the lands seeking wrongs to right \
		and tyrants to overthrow in the name of glory, righteousness and exorbitant rewards. \
		A lot of these people have been coming to Portcullis since Zapdorf took over. Not quite so many have \
		been leaving.");
}

function see_castle() {
	if(heroloc().isCastle) {
		say("The nice thing about being inside Zapdorf's castle is that you can't see Zapdorf's castle from here.");
	}
	else if(!heroloc().isOutdoors) {
		say("You can\'t see the castle from here.");
	} else {
		say("Zapdorf's castle takes up the whole northern skyline of Portcullis, and it's truly monstrous \
			in size and design. A great, windowless tower of obsidian blocks, tapering outward slightly \
			towards the top, and sporting oddly-shaped battlements around the edge of the roof. Nobody \
			who comes to the city has to ask where the evil sorcerer lives.");	
	}
}

function random_pyramid_combination() { // STRING of four DIFFERENT digits 0-3
	
	var combination = '';
	// 5 of everything is hardcoded here!
	var unshuffled = [0, 1, 2, 3, 4];
	for (var i=0; i<5; ++i) {
		combination += ('' + unshuffled.splice(pick(unshuffled.length), 1));
	}
	return combination;
}


function mummy_fraf_chase() {
	if(personloc(fraf)==castle_stairs_g) {
		move_person(fraf, entrance_hall, "Fraf runs south.", "Fraf the Barbarian runs in from the north.");
		move_person(mummy, castle_stairs_g, "The mummy moves west at a speedy shamble.", "The mummy comes in at a speedy shamble from the east.");
	} else if(personloc(fraf)==entrance_hall) {
		move_person(fraf, pyramid_room, "Fraf runs east.", "Fraf the Barbarian runs in from the west.");
		move_person(mummy, entrance_hall, "The mummy moves south at a speedy shamble.", "The mummy comes in at a speedy shamble from the north.");
	} else if(personloc(fraf)==pyramid_room) {
		move_person(fraf, mess_hall, "Fraf runs north.", "Fraf the Barbarian runs in from the south.");
		move_person(mummy, pyramid_room, "The mummy moves east at a speedy shamble.", "The mummy comes in at a speedy shamble from the west.");
	} else if(personloc(fraf)==mess_hall) {
		move_person(fraf, castle_stairs_g, "Fraf runs west.", "Fraf the Barbarian runs in from the east.");
		move_person(mummy, mess_hall, "The mummy moves north at a speedy shamble.", "The mummy comes in at a speedy shamble from the south.");
	} else {
		say("A bug flies past you.");
	}
}

/*
 * The final scene in the castle turret
 */

function final_scene_ready() {
	return (
		heroloc()==battlements &&
		(personloc(fraf)==battlements || gs(FRAF_DEAD)) &&
		(personloc(ariane)==battlements || gs(ARIANE_DEAD)) &&
		(personloc(miranda)==battlements || gs(MIRANDA_DEAD)) &&
		(personloc(staunton)==battlemnts || gs(STAUNTON_DEAD)) &&
		gs(SEEN_CONSPIRACY)
	);
} 

final_scene_steps = ['',
	function() {
		//sgs(N_ADVENTURERS_LEFT, num_adventurers_left());
		
		say('\n\nLara and Maynard, standing at the far side of the room, look at ' + adventurers_left_list() + '. There is an \
		    awkward pause.\n\
		    "All right," says Lara. "By now you\'ve probably figured out there\'s no Zapdorf."\n\
		    "That is to say, there\'s no physical Zapdorf," adds Maynard. "But there could be."');
	},
	
	function() {
		say('\nLara continues, "Until now, Zapdorf\'s been content to rule from the castle and send his minions out. \
		     That\'s got to change if we\'re to become a modern necrotyranny."\n\
		     Maynard nods. "Today\'s evil sorcerer has to engage with their people," says Maynard. "That\'s why \
		     we want someone to become the public face and presence of Zapdorf. Just wear the helmet, go out in public, \
		     and tyrannise a bit."\n\
		     "The two of us are happy raking cash in through our businesses," says Lara, "so we decided to recruit externally. \
		     And since you\'ve had the wits to make it through the castle, we\'re offering the job to ');
		var n = adventurers_left().length;
		if(n==0) { say('you."'); }
		else if(n==1) { say('either of you."'); }
		else { say('any one of you."'); }
		say('\nHe takes a horned helmet out of his robe and places it in the middle of the floor.');
		set_thingloc(helmet, turret);
	},

	suspicious_glance, // time to: get helmet...
	suspicious_glance, // ...wear it...
	adventurers_infight, // ...and you definitely time to SAY CALCANEUS if there are 3 adventurers alive.
	adventurers_infight
	
]

function suspicious_glance() {
	var advleft = adventurers_left();
	
	if(!advleft.length) {
		var adverb = pickOne(['expectantly', 'hopefully', 'inquisitively']);
		say('\n' + pickOne(['Lara','Maynard']) + ' looks ' + pickOne(['at you ' + adverb, adverb + ' at you']) + '.');
		return;
	}
	
	if(advleft.length > 0 && advleft.length < 4 && personloc(minion)==turret && worn(helmet)) {
		say("\nThe skeletal minion salutes you, then takes in the scene. Its master is under threat. \
		     It readies its spear, and advances on " + (advleft.length==1 ? capitalise(advleft[0].name) : "the adventurers") + ".\n");
		advleft.forEach(function(adventurer) {
			say(adventurer.killedBySkeleton + '\n');
			sgs( eval(adventurer.name.toUpperCase() + '_DEAD'), 1);
		});
		evil_ending();
		return;
	}
	
	var adventurers = shuffle(advleft);
	var looks = pickOne(['looks', 'glances']);
	var adverb = pickOne(['suspiciously', 'mistrustfully', 'sideways', 'dubiously', 'cagily', 'uneasily']);
	var lookee = (adventurers.length == 1 ? 'you' : capitalise(adventurers[1].name));
	say('\n' + capitalise(adventurers[0].name) + ' ' +
		pickOne([looks + ' ' + adverb + ' at ' + lookee,
		         looks + ' at ' + lookee + ' ' + adverb,
		         adverb + ' looks at ' + lookee]) + '.');
	
}

ariane.attacks = 'readies her bow and fires an arrow at $n.';
fraf.attacks = 'punches $n.';
staunton.attacks = 'points his staff at $n and yells "[[ capitalise( gs(MAGIC_WORD) ) ]]!"';
miranda.attacks = 'swings her mace at $n.';

ariane.dies = " falls, and her body expodes in a shower of pink sparkles";
fraf.dies = ' falls dead with a thump';
staunton.dies = ' rises a foot off the ground, and he\'s gone';
miranda.dies = ' crashes to the floor, dead';

ariane.dodges = "Ariane leaps nimbly out of the way.";
fraf.dodges = "Fraf blocks the attack.";
staunton.dodges = "Staunton teleports a short distance, evading the atttack.";
miranda.dodges = "The attack glances off Miranda's armour.";

ariane.scram = "scram";
fraf.scram = "go";
staunton.scram = "make yourself scarce";
miranda.scram = "begone";

ariane.killedBySkeleton = "Ariane shoots a couple of arrows, which pass harmlessly through the skeletal minion's ribcage \
                           before it gets her with the spear.";
fraf.killedBySkeleton = "Fraf puts up a good fight, but it's hard to punch someone who's dead already. The skeletal minion \
                         gets the better of him, and he falls dead with a thump.";
staunton.killedBySkeleton = "Staunton aims his staff at the skeleton, but before he can get his magic word out, there's \
                             a spear through his body.";
miranda.killedBySkeleton = "Miranda swings her mace, but it bounces off the skeletal minion's armour. The skeleton retaliates \
                            with its spear, and pierces her heart.";

function adventurers_infight() {
	var advleft = adventurers_left();
	
	if(!advleft.length) {
		// too late
		die('\n"We\'re wasting our time," says Lara. "I told you this goody two-shoes wouldn\'t be up for it. CALCANEUS!"\n\
	  		 The skeletal minion ' + (personloc(minion)==turret ? 'rattles its spear' : 'appears') + ', and runs you through.');
		return;
	}
	
	if(advleft.length == 4) {
		good_ending();
		return;
	}

	if(!gs(FIGHT_STARTED) && advleft.length >= 2) {
		say( '\nSuddenly, ' + capitalise(pickOne(advleft).name) + ' reaches out a hand towards ' +
		    (in_inv(helmet) ? 'your' : 'the') + ' helmet. That\'s enough to start it off.\n\
		    \n\
		    The next instant, everyone is fighting.\n');
		sgs(FIGHT_STARTED, 1);
	}
	
	
	
	if(personloc(minion)==turret && worn(helmet)) {
		say("\nThe skeletal minion salutes you, then takes in the scene. Its master is under threat. \
		     It readies its spear, and advances on " + (advleft.length==1 ? capitalise(advleft[0].name) : "the adventurers") + ".\n");
		advleft.forEach(function(adventurer) {
			say(adventurer.killedBySkeleton + '\n');
			sgs( eval(adventurer.name.toUpperCase() + '_DEAD'), 1);
		});
		evil_ending();
		return;
	}
	
	if(advleft.length == 1) {
		anticlimactic_ending();
		return;
	}
	
	var adventurers = shuffle(advleft);
	say( '\n' + capitalise(adventurers[0].name) + ' ' + adventurers[0].attacks.replace('$n', capitalise(adventurers[1].name)) + '\n' );
	if(!pick(2)) {
		say(capitalise(adventurers[1].name) + adventurers[1].dies + '.');
		sgs( eval( adventurers[1].name.toUpperCase() + '_DEAD'), 1); // yuck
		set_personloc(adventurers[1], nowhere);
	} else {
		say(adventurers[1].dodges);
	}
}

function adventurers_left() {
	var adventurers = [];
	[ariane, fraf, miranda, staunton].forEach(function(adventurer) {
		if(personloc(adventurer)==turret) {
			adventurers.push(adventurer);
		}
	});
	
	return adventurers;
}
function adventurers_left_list() {
	var adventurers = ['you'];
	if(personloc(ariane)==turret) adventurers.push('Ariane');
	if(personloc(fraf)==turret) adventurers.push('Fraf');
	if(personloc(miranda)==turret) adventurers.push('Miranda');
	if(personloc(staunton)==turret) adventurers.push('Staunton');
	
	return joinWithAnd(adventurers);
}


function final_scene() {

	if(gs(GAME_OVER)) { return; }
	
	var n = 1 + parseInt(gs(FINAL_SCENE));
	sgs(FINAL_SCENE, n);
		
	if(n < final_scene_steps.length) {
		
		var step = final_scene_steps[n];
		
		if(typeof step === 'function') {
			step();
		} else {
			say(step);
		}
		
	} else {
		adventurers_infight();
	}
	
	
}

function go_for_helmet() {
	if(adventurers_left().length==4) {
		
		say('You reach for the helmet. Fraf holds you back.\n');
		good_ending();
		return true;
	}
	
	else {
		if(thingloc(helmet)==turret) {
			get_point_for(TOOK_HELMET);
		}
		return take(helmet);
		// if you've got time to put it on and summon the minion, you'll win, otherwise you'll get the bad ending.
	}
}
function wear_helmet_at_ending() {
	if(!adventurers_left().length) {
		say('\nLara and Maynard smile.');
		if(personloc(minion)==heroloc()) {
			say(' The skeletal minion stands to attention.');
		}
		evil_ending();
	}
}

function give_helmet_to(adventurer) {
	if(worn(helmet)) {
		say("You'll have to take the helmet off first.");
		return;
	}
	say(capitalise(adventurer.name) + ' looks astonished, then grabs the helmet from you and puts it on.');
	[ariane,fraf,miranda,staunton].forEach(function(thisAdventurer) {
		if(thisAdventurer != adventurer) {
			set_personloc(thisAdventurer, nowhere);
		}
	});
	becomes_zapdorf(adventurer);
}

function anticlimactic_ending() {
	if(gs(GAME_OVER)) { return; }
	// only one adventurer left; they get to be zapdorf. (Your life is spared.)
	
	var adventurer = adventurers_left()[0];
	
	say('\n' + adventurer.fullname + ' turns toward you and advances... and stops.\n\
	    "' + capitalise(adventurer.scram) + '," ' + they(adventurer) + ' says, grabbing the helmet from \
	    [[ in_inv(helmet) ? ("your " + (worn(helmet) ? "head" : "hands")) : "the floor" ]] and putting it on. \
	    You ' + adventurer.scram + '.');
	
	becomes_zapdorf(adventurer);

}

function becomes_zapdorf(adventurer) {
	die('<p style=\"text-align: center;\">* * * * *</p> \
	    Six months later, life under Zapdorf\'s regime has improved considerably. For Zapdorf, that is. \
	    For the citizenry, you included, it\'s a nightmare. Of course, the visiting adventurers number more than \
	    ever, spending their gold in the taverns and tacky markets. But more and more ordinary jobs have been \
	    outsourced to the legions of undead, and Zapdorf ' + them(adventurer) + 'self has started coming out in public \
	    to pick on commoners, summarily execute people who don\'t look happy enough, and hold the occasional \
	    dragon-riding people-hunt through the streets. ' + capitalise(their(adventurer)) + ' helmet never comes off, \
	    but you know whose face it is under there.', "Ending 1 of 3");
	    
    winner = true; // sort of
}

function good_ending() {
	if(gs(GAME_OVER)) { return; }
	// if all adventurers are still alive, this is the only ending
	get_point_for(HEARD_MAGIC_WORD); // why not
	inc_score(); // get_point_for(win)
	die('\n"We took this castle together," says Fraf. "It isn\'t an adventure if you don\'t get to beat \
	     the sorcerer." He picks up the helmet. "Ready, wizard?"\n\
	     Fraf tosses the helmet into the air. Staunton points his staff at it and yells "' + capitalise(gs(MAGIC_WORD)) + '!" A jet \
	     of purple fire shoots from the staff, and the helm disintegrates into rusty-coloured flecks.\
	     <p style=\"text-align: center;\">* * * * *</p> \
	     It\'s been six months since Zapdorf was defeated, and the recently elected First Citizen - your former skipper - \
	     has announced a special parade to mark the occasion. There\'ll be a march through the streets, followed by \
	     a re-enactment by the Portcullis Undead Community Theatre of the now well-known story about a party of five brave \
	     adventurers who stormed the castle, killed the sorcerer, and rescued his prisoners, local business leaders Lara and \
	     Maynard, now senior advisers in the First Citizen\'s cabinet. That might not be entirely how it really happened, \
	     of course, but it gives the city something to rally behind. And if the wagons don\'t always run on time, well, \
	     at least the people are smiling.', "Ending 2 of 3");
	winner = true;
}

function evil_ending() {
	if(gs(GAME_OVER)) { return; }
	inc_score(); // get_point_for(win)
	// you get to be zapdorf
	die('<p style=\"text-align: center;\">* * * * *</p> \
	     Six months later, life under Zapdorf\'s regime has improved considerably. For you, anyway. \
	     Adventurers continue to flow into the town, seeking the glory of overthrowing you, \
	     but you\'ve had all the castle security puzzles tightened and your advisers assure you you\'re in no \
	     danger. They spend their gold in the taverns and the markets, and in accord with modern economic \
	     principles, it all trickles up.', "Ending 3 of 3");
	     
	winner = true;
}
