window.game={"compiled":"{\"title\":\"Social Democracy: An Alternate History\",\"author\":\"Autumn Chen\",\"ifid\":\"7FCDF039-2B77-4179-B795-CBAFA65253AA\",\"content\":\"\",\"scenes\":{\"1929\":{\"id\":\"1929\",\"type\":\"scene\",\"title\":\"1929\",\"subtitle\":\"A new year\",\"onArrival\":[{\"$code\":\"// see post_event.scene.dry for changes.\"}],\"tags\":[\"event\"],\"viewIf\":{\"$code\":\"return (((Q['year'] || 0)===1929) && ((Q['month'] || 0)===1));\"},\"priority\":2,\"maxVisits\":1,\"content\":{\"content\":\"A new year begins. The economy appears to be slackening; unemployment is increasing throughout the republic, although for the most part, people are still doing well.\",\"type\":\"paragraph\"},\"countVisitsMax\":1},\"1930\":{\"id\":\"1930\",\"type\":\"scene\",\"title\":\"1930\",\"subtitle\":\"A new year\",\"audio\":\"clear shuffle music/1928_1933/ZurSonne_zurFreiheit.mp3 music/1928_1933/arbeiter_marseille.mp3 music/1928_1933/DERLINDENBAUM_normalized.mp3 music/1928_1933/Wann_wir_schreiten_Seit_an_Seit.mp3 music/1930_1933/Internationale-de_normalized.ogg music/1930_1933/ironfront_normalized.mp3 music/1930_1933/KommSusserTod.mp3 music/1930_1933/Warszawianka.mp3 music/1928_1933/Liebesleid_normalized.mp3\",\"onArrival\":[{\"$code\":\"// increase NSDAP vote share\\nQ.unemployed += 8;\\nQ.inflation -= 4;\\nif (Q.budget > 0) {\\n    Q.budget -= 1;\\n}\\n// moved demographic changes to post_event\"}],\"tags\":[\"event\"],\"viewIf\":{\"$code\":\"return (((Q['year'] || 0)===1930) && ((Q['month'] || 0)===1));\"},\"priority\":2,\"maxVisits\":1,\"content\":{\"content\":\"A new year begins. The economic crisis is worsening throughout the world, with no end in sight. The NSDAP seems to be strengthening in local elections. All very worrisome trends.\",\"type\":\"paragraph\"},\"countVisitsMax\":1},\"1931\":{\"id\":\"1931\",\"type\":\"scene\",\"title\":\"1931\",\"subtitle\":\"A new year\",\"onArrival\":[{\"$code\":\"// increase NSDAP vote share\\n// TODO: if a public works program has started, unemployment is not so bad.\\nQ.unemployed += 8;\\nQ.inflation -= 5;\\nif (Q.works_program) {\\n    Q.unemployed -= 5;\\n    Q.inflation += 2;\\n}\\nif (Q.works_program && Q.works_program > 1) {\\n    Q.unemployed -= 2;\\n    Q.inflation += 2;\\n}\\n// moved demographic changes to post_event\"}],\"tags\":[\"event\"],\"viewIf\":{\"$code\":\"return (((Q['year'] || 0)===1931) && ((Q['month'] || 0)===1));\"},\"priority\":2,\"maxVisits\":1,\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"A new year begins. \",{\"type\":\"conditional\",\"content\":\"Unemployment continues to spiral upwards. The strength of the NSDAP continues to rise. \",\"predicate\":0},{\"type\":\"conditional\",\"content\":\"A works program has been enacted in order to reduce unemployment. \",\"predicate\":1},\" \",{\"type\":\"conditional\",\"content\":\"However, unemployment remains too high for comfort.\",\"predicate\":2}]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['works_program'] || 0)===0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['works_program'] || 0) > 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['works_program'] || 0) > 0) && ((Q['unemployment'] || 0) > 15));\"}}]},\"countVisitsMax\":1},\"1932\":{\"id\":\"1932\",\"type\":\"scene\",\"title\":\"1932\",\"subtitle\":\"A new year\",\"onArrival\":[{\"$code\":\"// increase NSDAP vote share\\n// TODO: if a public works program has started, unemployment is not so bad.\\nif (Q.works_program && Q.works_program >= 2) {\\n    Q.unemployed -= 1;\\n    Q.inflation += 1\\n}\\nif (!Q.works_program) {\\n    Q.unemployed += 6;\\n    Q.inflation -= 2;\\n\\n}\\n// moved demographic changes to post_event\"}],\"tags\":[\"event\"],\"viewIf\":{\"$code\":\"return (((Q['year'] || 0)===1932) && ((Q['month'] || 0)===1));\"},\"priority\":2,\"maxVisits\":1,\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[\"A new year begins. \",{\"type\":\"conditional\",\"content\":\"There is little to no good news in Germany. The economic depression has still not bottomed out. \",\"predicate\":0},{\"type\":\"conditional\",\"content\":\"We have begun to launch a public works program, but unemployment is still stubbornly high. The people are beginning to finally have optimism, however. \",\"predicate\":1},{\"type\":\"conditional\",\"content\":\"We have begun to launch a public works program, and unemployment is finally starting to fall. The people are beginning to finally have optimism. \",\"predicate\":2},\"\"]},{\"type\":\"paragraph\",\"content\":\"The presidential election is in April of this year.\"}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['works_program'] || 0)===0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['works_program'] || 0) >= 1) && ((Q['unemployment'] || 0) >= 20));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['works_program'] || 0) >= 1) && ((Q['unemployment'] || 0) < 20));\"}}]},\"countVisitsMax\":1},\"1933\":{\"id\":\"1933\",\"type\":\"scene\",\"title\":\"1933\",\"subtitle\":\"The end of the crisis?\",\"tags\":[\"event\"],\"priority\":-3,\"viewIf\":{\"$code\":\"return (((((Q['year'] || 0)===1933) && ((Q['month'] || 0) >= 12))) || ((Q['year'] || 0) >= 1934));\"},\"maxVisits\":1,\"onArrival\":[{\"$code\":\"// Einigkeit - survive on easy without a civil war.\\n// Einigkeit und Recht - survive on medium without a civil war.\\n// Einigkeit und Recht und Freiheit - survive on hard without a civil war.\\nif (Q.difficulty < 0) {\\n    this.achieve('einigkeit');\\n} else if (Q.difficulty == 0) {\\n    this.achieve('einigkeit_und_recht');\\n} else if (Q.difficulty > 0) {\\n    this.achieve('einigkeit_und_recht_und_freiheit');\\n}\\n\\nif (Q.historical_mode) {\\n    this.achieve('schwarz_rot_gold');\\n}\\n// Brüder, zur Sonne, zur Freiheit - reduce unemployment, pause reparations, increase women's rights, elect Otto Braun president, and deport Hitler in one playthrough on at least normal difficulty.\\nif (Q.difficulty >= 0 && Q.president == \\\"Braun\\\" && !(Q.chancellor == \\\"Hitler\\\") && Q.unemployed < 20 && Q.year == 1933 && !Q.civil_war_seen && Q.hitler_deported && Q.reparations <= -2 && Q.womens_rights >= 3) {\\n    this.achieve('bruder_zur_sonne');\\n}\\n// Freie Marktwirtschaft - win without doing an economic plan.\\nif (!Q.economic_plan) {\\n    this.achieve('freie_marktwirtschaft');\\n}\"}],\"options\":[{\"id\":\"@game_over\",\"title\":\"Game over.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"It is the end of 1933, and the NSDAP still has not taken power. It appears that we have already passed the worst of the years of crisis. We are turning the corner on the Great Depression, and Nazism's days are numbered.\"},{\"type\":\"paragraph\",\"content\":\"Perhaps Germany will finally enter into a new era of genuine peace...\"}],\"countVisitsMax\":1},\"prevScene\":{\"id\":\"prevScene\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"prevTopScene\":{\"id\":\"prevTopScene\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"jumpScene\":{\"id\":\"jumpScene\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"backSpecialScene\":{\"id\":\"backSpecialScene\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"returnScene\":{\"id\":\"returnScene\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"cancel_advisor_action\":{\"id\":\"cancel_advisor_action\",\"type\":\"scene\",\"title\":\"Cancel action.\",\"viewIf\":{\"$code\":\"return ((Q['last_advisor_action'] || 0)===1);\"},\"goTo\":[{\"id\":\"root\"}],\"onArrival\":[{\"$code\":\"if (Q.month_actions > 0) {\\n    Q.month_actions -= 1;\\n}\\nQ.advisor_action_timer = 0;\\n// Canceling an advisor action\\n// reset the timer...\\nif (Q[card.id + \\\"_timer\\\"]) {\\n    Q[card.id + \\\"_timer\\\"] = 0;\\n}\\n// reduce visit count\\nif (this.state.visits[card.id]) {\\n    this.state.visits[card.id] -= 1;\\n}\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"credits.books\":{\"id\":\"credits.books\",\"options\":[{\"id\":\"@credits\",\"title\":\"Back\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Books\"},{\"type\":\"paragraph\",\"content\":\"(bolded sources were heavily referenced)\"},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"Berman, Sheri. The Social Democratic Moment. Harvard University Press, 1998.\"},\"\"]},{\"type\":\"paragraph\",\"content\":\"Childers, Thomas. The Nazi Voter : The Social Foundations of Fascism in Germany, 1919-1933. Chapel Hill : University of North Carolina Press, 1983. Internet Archive, http://archive.org/details/nazivotersocialf0000chil.\"},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"Dobkowski, Michael N., and Isidor Wallimann. Towards the Holocaust: The Social and Economic Collapse of the Weimar Republic. 1983. https://surface.syr.edu/books/17/.\"},\"\"]},{\"type\":\"paragraph\",\"content\":\"Fowkes, Ben. The German Left and the Weimar Republic: A Selection of Documents. Brill, 2014. https://brill.com/display/title/20472.\"},{\"type\":\"paragraph\",\"content\":\"Guttsman, W. L. The German Social Democratic Party, 1875-1933: From Ghetto to Government. Routledge, 2019.\"},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"Harsch, Donna. German Social Democracy and the Rise of Nazism. University of North Carolina Press, 1993.\"},\"\"]},{\"type\":\"paragraph\",\"content\":\"Kolb, Eberhard. The Weimar Republic. Unwin Hyman, 1988.\"},{\"type\":\"paragraph\",\"content\":\"Miller, Frederick Alfred. Left-Wing Splinter Parties in the Weimar Republic. University of British Columbia, 1974.\"},{\"type\":\"paragraph\",\"content\":\"Mommsen, Hans. The Rise and Fall of Weimar Democracy. UNC Press Books, 2017.\"},{\"type\":\"paragraph\",\"content\":\"Orlow, Dietrich. Weimar Prussia, 1925–1933: The Illusion of Strength. University of Pittsburgh Pre, 1991.\"},{\"type\":\"paragraph\",\"content\":\"Rosenberg, Arthur. A History of the German Republic. 1936, https://www.marxists.org/archive/rosenberg/history-weimar/index.htm.\"},{\"type\":\"paragraph\",\"content\":\"Rosenhaft, Eve. Beating the Fascists?: The German Communists and Political Violence 1929-1933. Cambridge University Press, 1983.\"},{\"type\":\"paragraph\",\"content\":\"Sender, Toni. The Autobiography of a German Rebel, 1940. http://archive.org/details/TheAutobiographyOfAGermanRebel.\"},{\"type\":\"paragraph\",\"content\":\"Shirer, William L. The Rise and Fall of the Third Reich: A History of Nazi Germany. Simon & Schuster, 2011.\"},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"Smaldone, William. Confronting Hitler: German Social Democrats in Defense of the Weimar Republic, 1929-1933. Lexington Books, 2010.\"},\"\"]},{\"type\":\"paragraph\",\"content\":\"Woytinsky, Wladimir. Stormy Passage. Vanguard Press, 1961. Internet Archive, http://archive.org/details/Woytinsky-Stormy-passage.\"}]},\"easy_discard\":{\"id\":\"easy_discard\",\"type\":\"scene\",\"title\":\"Return card to hand.\",\"viewIf\":{\"$code\":\"return (((Q['difficulty'] || 0) <= 0) && ((Q['last_advisor_action'] || 0)===0));\"},\"goTo\":[{\"id\":\"root\"}],\"onArrival\":[{\"$code\":\"if (Q.month_actions > 0) {\\n    Q.month_actions -= 1;\\n}\\n// return card to hand\\nvar card = this.state.lastPlayedCard;\\ncard.image = card.cardImage;\\nif (Q.difficulty >= 0) {\\n    this.state.currentHands['main'].push(card);\\n} else {\\n    this.state.currentHands['main.main_easy'].push(card);\\n}\\n// reset the timer...\\nif (Q[card.id + \\\"_timer\\\"]) {\\n    Q[card.id + \\\"_timer\\\"] = 0;\\n}\\n// reduce visit count\\nif (this.state.visits[card.id]) {\\n    this.state.visits[card.id] -= 1;\\n}\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"election_algorithm\":{\"id\":\"election_algorithm\",\"type\":\"scene\",\"title\":\"Election\",\"onArrival\":[{\"$code\":\"// calculate normalized class voting amounts (0 to 100)\\nfor (var c of Q.classes) {\\n    var class_votes = 0;\\n    for (var party of Q.parties) {\\n        if (Q[c+'_'+party] < 0) {\\n            Q[c+'_'+party] = 0;\\n        }\\n        class_votes += Q[c+'_'+party];\\n    }\\n    for (var party of Q.parties) {\\n        Q[c + '_' + party + '_normalized'] = Math.round(100*Q[c+'_'+party]/class_votes);\\n    }\\n}\\n\\n// 1. calculate support for each of the parties\\nvar total_support = 0;\\nfor (var party of Q.parties) {\\n    var party_support = 0;\\n    for (var c of Q.classes) {\\n        // but this version is somewhat more entertaining and allows for wilder swings in votes.\\n        // the other option basically necessitates a multi-class strategy. while the first option allows for a working-class-only strategy.\\n        if (Q.old_demographics) {\\n            // okay i'm pretty sure this is wrong, and the hard version is correct\\n            // basically this allows for \\\"spillover\\\" effects in other demographics.\\n            // so you can campaign among say the workers and\\n            party_support += Q[c]*Q[c+'_'+party];\\n            // However, there should be a cap on how much party support you can get in a certain demo.\\n        } else  {\\n            party_support += Q[c]*Q[c+'_'+party+'_normalized'];\\n        }\\n    }\\n    Q[party + '_support'] = party_support;\\n    total_support += party_support;\\n}\\n// 2. normalize support (fraction)\\n// 3. Round to integers\\n// TODO: round to 1 decimal instead of rounding to integers\\n// to do that, we multiply party_normalized*1000 and divide the rounded number by 10.\\nfor (var party of Q.parties) {\\n    Q[party+'_normalized'] = Q[party + '_support']/total_support;\\n    Q[party+'_votes_dec'] = Math.round(Q[party+'_normalized']*1000)/10;\\n    Q[party+'_votes'] = Math.round(Q[party+'_normalized']*100);\\n    //Q[party+'_votes'] = Q[party+'_votes_dec'];\\n}\"}],\"goTo\":[{\"id\":\"jumpScene\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"election_simulation.1928\":{\"id\":\"election_simulation.1928\",\"onArrival\":[{\"$code\":\"Q.workers = 46; // industry and trade\\nQ.old_middle = 13; // \\\"old mittelstand\\\"\\n// 16.4 trade & commerce, 6.6 public and private services, 4.4 domestic help\\nQ.new_middle = 14; // \\\"new mittelstand\\\"\\nQ.rural = 25; // agriculture and forestry employment... but many of those are proletarians so...\\n// source: https://surface.syr.edu/cgi/viewcontent.cgi?filename=3&article=1016&context=books&type=additional page 43, table 3.3\\nQ.unemployed = 8.6;\\nQ.catholics = 30;\\n\\nQ.classes = ['workers', 'old_middle', 'new_middle', 'rural', 'unemployed', 'catholics'];\\nQ.parties = ['spd', 'kpd', 'z', 'ddp', 'dvp', 'dnvp', 'nsdap', 'other'];\\n\\n// Support for party by social group\\n// they don't have to sum to 100 since the electoral calculations will be normalized.\\nQ.workers_spd = 65;\\nQ.workers_kpd = 20;\\nQ.workers_z = 5;\\nQ.workers_ddp = 0;\\nQ.workers_dvp = 0;\\nQ.workers_dnvp = 5;\\nQ.workers_nsdap = 0;\\nQ.workers_other = 10;\\n\\nQ.old_middle_spd = 5;\\nQ.old_middle_kpd = 0;\\nQ.old_middle_z = 5;\\nQ.old_middle_ddp= 10;\\nQ.old_middle_dvp = 25;\\nQ.old_middle_dnvp = 25;\\nQ.old_middle_nsdap = 10;\\nQ.old_middle_other = 10;\\n\\nQ.new_middle_spd = 5;\\nQ.new_middle_kpd = 0;\\nQ.new_middle_z = 10;\\nQ.new_middle_ddp= 25;\\nQ.new_middle_dvp = 25;\\nQ.new_middle_dnvp = 10;\\nQ.new_middle_nsdap = 5;\\nQ.new_middle_other = 15;\\n\\nQ.rural_spd = 10;\\nQ.rural_kpd = 0;\\nQ.rural_z = 5;\\nQ.rural_ddp= 5;\\nQ.rural_dvp = 15;\\nQ.rural_dnvp = 45;\\nQ.rural_nsdap = 5;\\nQ.rural_other = 10;\\n\\nQ.unemployed_spd = 25;\\nQ.unemployed_kpd = 55;\\nQ.unemployed_z = 1;\\nQ.unemployed_ddp = 0;\\nQ.unemployed_dvp = 0;\\nQ.unemployed_dnvp = 5;\\nQ.unemployed_nsdap = 15;\\nQ.unemployed_other = 9;\\n\\nQ.catholics_spd = 15;\\nQ.catholics_kpd = 5;\\nQ.catholics_z = 50;\\nQ.catholics_ddp = 0;\\nQ.catholics_dvp = 5;\\nQ.catholics_dnvp = 5;\\nQ.catholics_nsdap = 0;\\nQ.catholics_other = 10;\"}],\"goTo\":[{\"id\":\"election_algorithm\"}],\"setJump\":\"election_simulation.post_election\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"game_over.eg_menu\":{\"id\":\"game_over.eg_menu\",\"options\":[{\"id\":\"#endings\"},{\"id\":\"@game_over.end_game\",\"title\":\"End game.\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"library.menu\":{\"id\":\"library.menu\",\"options\":[{\"id\":\"@library.government\",\"title\":\"Germany's system of government\"},{\"id\":\"@library.weimar_timeline\",\"title\":\"Timeline of the Weimar Republic before 1928\"},{\"id\":\"@library.curr_gov\",\"title\":\"Current government details\"},{\"id\":\"@library.demographics\",\"title\":\"Demographics\"},{\"id\":\"@library.parties\",\"title\":\"Parties\"},{\"id\":\"@library.public_opinion\",\"title\":\"Public opinion (and projected election results)\"},{\"id\":\"@library.paramilitaries\",\"title\":\"Paramilitary groups\"},{\"id\":\"@library.factions\",\"title\":\"Internal factions\"},{\"id\":\"@library.figures\",\"title\":\"Figures and charts\"},{\"id\":\"@backSpecialScene\",\"title\":\"Exit library.\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"mod_loader\":{\"id\":\"mod_loader\",\"type\":\"scene\",\"title\":\"Mods\",\"isSpecial\":true,\"onDisplay\":[{\"$code\":\"var mods_list = document.getElementById('mods_list');\\n// load mods from url\\nvar mods_url = 'https://aucchen.github.io/social_democracy_mods/mod_list.tsv';\\nvar table = document.createElement('table');\\ntable.style.border = '1px solid';\\ntable.style['border-collapse'] = 'collapse';\\ntable.style['font-size'] = '0.8em';\\nQ.mods_table = {};\\nfetch(mods_url)\\n.then(response => response.text())\\n.then(text => {\\n    // split text\\n    var lines = text.split('\\\\n');\\n    for (var i = 0; i < lines.length; i++) {\\n        var line_data = lines[i].split('\\\\t');\\n        if (line_data.length < 5) {\\n            continue;\\n        }\\n        var tr = document.createElement('tr');\\n        for (var j = 0; j < 4; j++) {\\n            var td = document.createElement('td');\\n            if (i == 0) {\\n                td = document.createElement('th');\\n            }\\n            td.style.border = '1px solid';\\n            td.style.padding = '0.5em';\\n            td.textContent = line_data[j];\\n\\n            tr.appendChild(td);\\n        }\\n        if (i > 0) {\\n            Q.mods_table[line_data[2]] = {\\n                name: line_data[0],\\n                author: line_data[1],\\n                description: line_data[3],\\n            };\\n\\n        }\\n        table.appendChild(tr);\\n    }\\n    mods_list.appendChild(table);\\n})\\n.catch(err => console.log(err));\\n\\nvar submit = document.getElementById('submit');\\nsubmit.onclick = function() {\\n    var mod_url = document.getElementById('mod_url').value;\\n    // if it's a known mod, set the game's titlebar and author.\\n    if (Q.mods_table[mod_url]) {\\n        var mod_data = Q.mods_table[mod_url];\\n        var title = document.getElementById('game-title');\\n        title.textContent = mod_data.name;\\n        var author = document.getElementById('game-author');\\n        author.textContent = mod_data.author;\\n    }\\n    window.loadMod(mod_url);\\n};\"}],\"options\":[{\"id\":\"@backSpecialScene\",\"title\":\"Back\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"Curated mods:\"},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<div id=\\\"mods_list\\\"></div>\"},\"\"]},{\"type\":\"paragraph\",\"content\":\"Enter a mod's URL:\"},{\"type\":\"paragraph\",\"content\":{\"type\":\"magic\",\"content\":\"<input type=\\\"text\\\" size=\\\"25\\\" id=\\\"mod_url\\\" name=\\\"mod_url\\\"/> <button id=\\\"submit\\\">Submit</button>\"}}]},\"main.main_easy\":{\"id\":\"main.main_easy\",\"setBg\":\"img/map_2.jpg\",\"isHand\":true,\"onArrival\":[{\"$code\":\"if (Q.advisor_action_timer <= 0) {\\n    Q.pinnedCardsDescription = 'Advisors - an action is available.';\\n} else if (Q.advisor_action_timer == 1) {\\n    Q.pinnedCardsDescription = 'Advisors - next action available in 1 month.';\\n} else {\\n    Q.pinnedCardsDescription = 'Advisors - next action available in ' + Q.advisor_action_timer + ' months.';\\n}\"}],\"maxCards\":4,\"options\":[{\"id\":\"@main.party\"},{\"id\":\"@main.govt\"},{\"id\":\"#advisor\"},{\"id\":\"@shuffle_leadership_pinned\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":\"The current bourgeois-right government has fallen. The next elections are slated for May of this year.\",\"predicate\":0}},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['year'] || 0)===1928) && ((Q['month'] || 0)===2));\"}}]}},\"return\":{\"id\":\"return\",\"type\":\"scene\",\"title\":\"Back to main\",\"goTo\":[{\"id\":\"root\"}],\"onArrival\":[{\"$code\":\"if (((Q['difficulty'] || 0) < 0) ) { Q['month_actions'] = (Q['month_actions'] || 0) - 1; }\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"post_event.events_choice\":{\"id\":\"post_event.events_choice\",\"options\":[{\"id\":\"#event\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"post_event\":{\"id\":\"post_event\",\"type\":\"scene\",\"title\":\"Post Event\",\"newPage\":true,\"onArrival\":[{\"$code\":\"Q.last_advisor_action = 0;\\n// make sure no stat is below 0.\\nfor (var c of Q.classes) {\\n    for (var party of Q.parties) {\\n        if (Q[c+'_'+party] < 0) {\\n            Q[c+'_'+party] = 0;\\n        }\\n    }\\n}\\n\\nQ.pro_republic = Math.round(Q.pro_republic);\\nQ.nationalism = Math.round(Q.nationalism);\\nQ.socialism = Math.round(Q.socialism);\\n\\nif (Q.pro_republic < 0) {\\n    Q.pro_republic = 0;\\n}\\nif (Q.pro_republic >= 100) {\\n    Q.pro_republic = 99;\\n}\\n// re-calculate party support\\n// calculate normalized class voting for the achievements\\nfor (var c of Q.classes) {\\n    var class_votes = 0;\\n    for (var party of Q.parties) {\\n        if (Q[c+'_'+party] < 0) {\\n            Q[c+'_'+party] = 0;\\n        }\\n        class_votes += Q[c+'_'+party];\\n    }\\n    for (var party of Q.parties) {\\n        Q[c + '_' + party + '_normalized'] = Math.round(100*Q[c+'_'+party]/class_votes);\\n    }\\n}\\n// calculate support for each of the parties\\nvar total_support = 0;\\nfor (var party of Q.parties) {\\n    var party_support = 0;\\n    for (var c of Q.classes) {\\n        if (Q.old_demographics) {\\n            party_support += Q[c]*Q[c+'_'+party];\\n        } else  {\\n            party_support += Q[c]*Q[c+'_'+party+'_normalized'];\\n        }\\n    }\\n    Q[party + '_support'] = party_support;\\n    total_support += party_support;\\n}\\n// 2. normalize support (fraction)\\nfor (var party of Q.parties) {\\n    Q[party+'_normalized'] = Q[party + '_support']/total_support;\\n    Q[party+'_votes'] = Math.round(Q[party+'_normalized']*100);\\n}\\n\\n\\n// set faction strength/dissent to 0\\nfor (var c of Q.factions) {\\n    if (Q[c+'_dissent'] < 0) {\\n        Q[c+'_dissent'] = 0;\\n    } else if (Q[c+'_dissent'] >= 100) {\\n        Q[c+'_dissent'] = 99;\\n    }\\n    if (Q[c+'_strength'] < 0) {\\n        Q[c+'_strength'] = 0;\\n    }\\n}\\n\\nif (Q.unemployed <= 1) {\\n    Q.unemployed = 1;\\n}\\n\\n// re-calculate dissent.\\nvar total_strength = Q.left_strength + Q.center_strength + Q.labor_strength + Q.reformist_strength + Q.neorevisionist_strength;\\n\\n// normalize strength for the different factions\\nQ.left_strength = 100*Q.left_strength/total_strength;\\nQ.center_strength = 100*Q.center_strength/total_strength;\\nQ.labor_strength = 100*Q.labor_strength/total_strength;\\nQ.reformist_strength = 100*Q.reformist_strength/total_strength;\\nQ.neorevisionist_strength = 100*Q.neorevisionist_strength/total_strength;\\n\\nvar total_dissent = Q.left_strength*Q.left_dissent + Q.center_strength*Q.center_dissent + Q.labor_strength*Q.labor_dissent + Q.reformist_strength*Q.reformist_dissent + Q.neorevisionist_strength*Q.neorevisionist_dissent;\\n\\n\\nQ.dissent = 0.01*total_dissent/total_strength;\\nQ.dissent_percent = Q.dissent*100;\\nconsole.log('new dissent: ' + Q.dissent);\\n\\nif (Q.dissent < 0) {\\n    Q.dissent = 0;\\n} else if (Q.dissent > 0.95) {\\n    Q.dissent = 0.95;\\n}\\n\\n// 1. update dates\\nif (Q.month_actions >= 1) {\\n    Q.time += 1;\\n    Q.month_actions = 0;\\n    Q.month += 1;\\n    if (Q.month >= 13) {\\n        Q.month = 1;\\n        Q.year += 1;\\n        if (Q.historical_mode) {\\n            Q.resources += 2;\\n        }\\n    }\\n    // decrement timers\\n    for (timer of Q.timers) {\\n        if (Q[timer+'_timer'] && Q[timer+'_timer'] > 0) {\\n            Q[timer+'_timer'] -= 1;\\n        }\\n    }\\n    // append to historical party support records\\n    var party_support_results = {'date': new Date(Q.year, Q.month - 1)};\\n    for (var party of Q.parties) {\\n        party_support_results[party] = Q[party + '_normalized']*100;\\n    }\\n    Q.party_support_records.push(party_support_results);\\n    Q.economic_records.push({'date': new Date(Q.year, Q.month - 1),\\n                             'inflation': Q.inflation,\\n                             'unemployment': Q.unemployed});\\n    // change economic stats...\\n    // we're basically implicity drawing a Philips curve\\n    // budget deficits lead to some inflation\\n    if (Q.budget <= 0 && Q.budget > -2 && Q.inflation < 2.5) {\\n        Q.inflation += 0.1;\\n    }\\n    if (Q.budget <= -2 && Q.budget > -5 && Q.inflation < 5) {\\n        Q.inflation += 0.2;\\n        if (Q.unemployed >= 12) {\\n            Q.inflation -= 0.1;\\n        }\\n    }\\n    if (Q.budget <= -5 && Q.inflation < 10) {\\n        Q.inflation += 0.3;\\n        if (Q.unemployed >= 15) {\\n            Q.inflation -= 0.1;\\n        }\\n    }\\n    // deflation is bad\\n    if (Q.inflation < -0.5 && Q.inflation > -5 && Q.unemployed < 15) {\\n        Q.unemployed += 0.2;\\n    }\\n    if (Q.inflation <= -5 && Q.unemployed < 20) {\\n        Q.unemployed += 0.3;\\n    }\\n    /////////////////////////////// update opinions based on economy\\n    if (Q.unemployed > 15 && Q.pro_republic > 40) {\\n        Q.pro_republic -= 1;\\n    }\\n    if (Q.unemployed > 30 && Q.pro_republic > 20) {\\n        Q.pro_republic -= 1;\\n    }\\n    if (Q.inflation > 8 && Q.pro_republic > 40) {\\n        Q.pro_republic -= 1;\\n    }\\n    ///////////////////////////// change party support based on pro_republic\\n    // if pro_republic is less than the support of the Weimar coalition, reduce SPD support...\\n    if (Q.pro_republic < (Q.spd_votes + Q.ddp_votes + Q.z_votes - 3)) {\\n        if (Q.new_middle_spd > 0) {\\n            Q.new_middle_spd -= 1;\\n            Q.new_middle_nsdap += 1;\\n        }\\n        if (Q.rural_spd > 0) {\\n            Q.rural_spd -= 1;\\n            Q.rural_nsdap += 1;\\n        }\\n        if (Q.workers_spd_normalized > 20) {\\n            Q.workers_spd -= 1;\\n        }\\n        if (Q.new_middle_ddp > 0) {\\n            Q.new_middle_ddp -= 1;\\n            Q.new_middle_nsdap += 1;\\n        }\\n        if (Q.old_middle_ddp > 0) {\\n            Q.old_middle_ddp -= 1;\\n            Q.old_middle_nsdap += 1;\\n        }\\n        if (Q.rural_ddp > 0) {\\n            Q.rural_ddp -= 1;\\n            Q.rural_nsdap += 1;\\n        }\\n    }\\n    ////////////////////////// annual support changes\\n    if (Q.year == 1929) {\\n        Q.unemployed += 3/12;\\n        Q.inflation -= 1/12;\\n        // increase NSDAP vote share\\n        Q.new_middle_nsdap += 10/12;\\n        Q.old_middle_nsdap += 10/12;\\n        Q.new_middle_ddp -= 5/12;\\n        Q.new_middle_dvp -= 5/12;\\n        Q.workers_kpd += 5/12;\\n        Q.sa_strength += 50/12;\\n        Q.sh_strength += 100/12;\\n        Q.rural_dnvp -= 15/12;\\n        Q.rural_nsdap += 10/12;\\n        Q.unemployed_nsdap += 18/12;\\n    }\\n    if (Q.year == 1930) {\\n        Q.rural_nsdap += 10/12;\\n        Q.rural_dnvp -= 15/12;\\n        Q.new_middle_dvp -= 5/12;\\n        Q.old_middle_dvp -= 6/12;\\n        Q.new_middle_ddp -= 5/12;\\n        Q.old_middle_ddp -= 6/12;\\n        Q.new_middle_nsdap += 10/12;\\n        Q.old_middle_nsdap += 10/12;\\n        Q.new_middle_other += 4/12;\\n        Q.old_middle_other += 4/12;\\n        Q.unemployed_nsdap += 8/12;\\n        Q.rural_other += 5/12;\\n\\n        Q.workers_z += 1/12;\\n        Q.old_middle_z += 2/12;\\n        Q.new_middle_z += 2/12;\\n        if (!Q.works_program) {\\n            Q.rural_nsdap += 3/12;\\n            Q.old_middle_nsdap += 5/12;\\n            Q.workers_nsdap += 2/12;\\n            Q.workers_other += 5/12;\\n            Q.workers_kpd += 2/12;\\n        }\\n        Q.sa_strength += 100/12;\\n        Q.sh_strength += 100/12;\\n    }\\n    if (Q.year == 1931) {\\n        Q.catholics_z += 2/12;\\n        Q.rural_dvp -= 8/12;\\n        Q.old_middle_dvp -= 8/12;\\n        Q.new_middle_dvp -= 8/12;\\n        Q.old_middle_ddp -= 8/12;\\n        Q.new_middle_ddp -= 8/12;\\n        Q.sa_strength += 50/12;\\n        Q.sh_strength += 50/12;\\n        Q.sa_militancy += 0.1/12;\\n        Q.old_middle_nsdap += 10/12;\\n        Q.rural_other -= 5/12;\\n        Q.rural_nsdap += 9/12;\\n        // TODO: economic policies should reduce NSDAP rurals\\n        if (!Q.works_program) {\\n            Q.old_middle_dvp -= 6/12;\\n            Q.new_middle_dvp -= 6/12;\\n            Q.rural_dvp -= 6/12;\\n            Q.workers -= 4/12;\\n            Q.unemployed_nsdap += 7/12;\\n            Q.unemployed_kpd += 2/12;\\n            Q.rural_other -= 12/12;\\n            Q.rural_nsdap += 12/12;\\n            Q.new_middle_nsdap += 12/12;\\n            Q.old_middle_nsdap += 12/12;\\n            Q.workers_nsdap += 2/12;\\n            Q.workers_kpd += 4/12;\\n            Q.sa_strength += 100/12;\\n            Q.sh_strength += 50/12;\\n        } else if (Q.unemployed > 15) {\\n            Q.old_middle_dvp -= 4/12;\\n            Q.new_middle_dvp -= 4/12;\\n            Q.rural_dvp -= 4/12;\\n            Q.unemployed_nsdap += 4/12;\\n            Q.old_middle_nsdap += 4/12;\\n            Q.new_middle_nsdap += 4/12;\\n            Q.rural_nsdap += 4/12;\\n        }\\n    }\\n    if (Q.year == 1932) {\\n        Q.old_middle_other -= 7/12;\\n        Q.rural_other -= 7/12;\\n        Q.old_middle_nsdap += 7/12;\\n        Q.rural_nsdap += 7/12;\\n        Q.unemployed_nsdap += 4/12;\\n        if (!Q.works_program) {\\n            Q.unemployed += 6/12;\\n            Q.inflation -= 2/12;\\n            Q.catholics_z += 2/12;\\n            Q.workers -= 4/12;\\n            Q.rural_dnvp -= 4/12;\\n            Q.rural_nsdap += 8/12;\\n            Q.new_middle_nsdap += 10/12;\\n            Q.old_middle_nsdap += 10/12;\\n            Q.unemployed_nsdap += 8/12;\\n            Q.unemployed_kpd += 2/12;\\n            Q.workers_nsdap += 3/12;\\n            Q.workers_kpd += 3/12;\\n            Q.sa_strength += 200/12;\\n            Q.new_middle_dnvp += 4/12;\\n            Q.new_middle_dnvp += 4/12;\\n            Q.new_middle_dvp -= 4/12;\\n            Q.old_middle_dvp -= 4/12;\\n            Q.rural_dvp -= 4/12;\\n        } else if (Q.unemployed > 25) {\\n            Q.rural_nsdap += 5/12;\\n            Q.unemployed_nsdap += 5/12;\\n            Q.old_middle_nsdap += 5/12;\\n            Q.new_middle_nsdap += 4/12;\\n            Q.sa_strength += 50/12;\\n        } else if (Q.unemployed > 20) {\\n            Q.rural_nsdap += 2/12;\\n            Q.unemployed_nsdap += 3/12;\\n            Q.old_middle_nsdap += 3/12;\\n            Q.new_middle_nsdap += 2/12;\\n        }\\n    }\\n}\\nQ.has_event = 0;\\n// check if there are any cards in #event, and then go to main if not.\\nvar scene = this.game.scenes['post_event.events_choice'];\\nvar choices = this._compileChoices(scene);\\nif (choices && choices[0].title != \\\"Continue...\\\") {\\n    Q.has_event = 1;\\n} else {\\n    has_event = 0;\\n}\\n// pre-load all of the event images\\nif (this.ui && this.ui.show_portraits) {\\n    for (var choice of choices) {\\n        var cc = this.game.scenes[choice.id];\\n        if (cc.faceImage) {\\n            var im = new Image();\\n            im.url = cc.faceImage;\\n        }\\n    }\\n}\\n\\nif (typeof window !== \\\"undefined\\\" && window.generateBar) {\\n}\"}],\"goTo\":[{\"id\":\"post_event.events_choice\",\"predicate\":{\"$code\":\"return ((Q['has_event'] || 0)===1);\"}},{\"id\":\"main\",\"predicate\":{\"$code\":\"return (((Q['has_event'] || 0)===0) && ((Q['difficulty'] || 0) >= 0));\"}},{\"id\":\"main.main_easy\",\"predicate\":{\"$code\":\"return (((Q['has_event'] || 0)===0) && ((Q['difficulty'] || 0) < 0));\"}}],\"content\":{\"content\":{\"type\":\"heading\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":0},\" \",{\"type\":\"insert\",\"insert\":1}]},\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['month'] || 0);\"},\"qdisplay\":\"month\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['year'] || 0);\"}}]}},\"set_next_election_time\":{\"id\":\"set_next_election_time\",\"type\":\"scene\",\"title\":\"next election time\",\"onArrival\":[{\"$code\":\"if (((Q['next_election_time'] || 0) >= ((Q['time'] || 0) + (Q['time_to_election'] || 0))) ) { Q['next_election_time'] = ((Q['time'] || 0) + (Q['time_to_election'] || 0)); } \\n if (((Q['next_election_time'] || 0) >= ((Q['time'] || 0) + (Q['time_to_election'] || 0))) ) { Q['next_election_month'] = ((Q['month'] || 0) + 3); } \\n if (((Q['next_election_time'] || 0) >= ((Q['time'] || 0) + (Q['time_to_election'] || 0))) ) { Q['next_election_year'] = (Q['year'] || 0); } \\n if (((Q['next_election_month'] || 0) > 12) ) { Q['next_election_year'] = (Q['next_election_year'] || 0) + 1; } \\n if (((Q['next_election_month'] || 0) > 12) ) { Q['next_election_month'] = (Q['next_election_month'] || 0) - 12; }\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"status.politics\":{\"id\":\"status.politics\",\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"Inter-party Relations\"},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<span class=\\\"tooltip-text\\\" title=\\\"Center Party\\\">Z</span>\"},\": \",{\"type\":\"insert\",\"insert\":0},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<span class=\\\"tooltip-text\\\" title=\\\"German Democratic Party\\\">DDP</span>\"},\": \",{\"type\":\"insert\",\"insert\":1},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<span class=\\\"tooltip-text\\\" title=\\\"German People's Party\\\">DVP</span>\"},\": \",{\"type\":\"insert\",\"insert\":2},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<span class=\\\"tooltip-text\\\" title=\\\"Communist Party of Germany\\\">KPD</span>\"},\": \",{\"type\":\"insert\",\"insert\":3},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<span class=\\\"tooltip-text\\\" title=\\\"German National People's Party\\\">DNVP</span>\"},\": \",{\"type\":\"insert\",\"insert\":4},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<span class=\\\"tooltip-text\\\" title=\\\"National-Socialist German Worker's Party (Nazis)\\\">NSDAP</span>\"},\": \",{\"type\":\"insert\",\"insert\":5},\"\"]},{\"type\":\"heading\",\"content\":\"Internal Factions of the SPD\"},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<span class=\\\"tooltip-text\\\" title=\\\"The Left is interested in radical, transformative policies and cooperation with the KPD.\\\">Left</span>\"},\" strength: \",{\"type\":\"insert\",\"insert\":6},\", dissent: \",{\"type\":\"insert\",\"insert\":7},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<span class=\\\"tooltip-text\\\" title=\\\"The Center is a faction of Center Marxists, between reform and revolution.\\\">Center</span>\"},\" strength: \",{\"type\":\"insert\",\"insert\":8},\", dissent: \",{\"type\":\"insert\",\"insert\":9},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<span class=\\\"tooltip-text\\\" title=\\\"Labor's goal is economic reform and benefits for organized workers.\\\">Labor</span>\"},\" strength: \",{\"type\":\"insert\",\"insert\":10},\", dissent: \",{\"type\":\"insert\",\"insert\":11},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<span class=\\\"tooltip-text\\\" title=\\\"Reformists are pragmatic participants in government, and seek to expand the welfare state and defend democracy.\\\">Reformist</span>\"},\" strength: \",{\"type\":\"insert\",\"insert\":12},\", dissent: \",{\"type\":\"insert\",\"insert\":13},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":[\"Neorevisionist strength: \",{\"type\":\"insert\",\"insert\":15},\", dissent: \",{\"type\":\"insert\",\"insert\":16},\"\"],\"predicate\":14}}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['z_relation'] || 0);\"},\"qdisplay\":\"relationships\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['ddp_relation'] || 0);\"},\"qdisplay\":\"relationships\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['dvp_relation'] || 0);\"},\"qdisplay\":\"relationships\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['kpd_relation'] || 0);\"},\"qdisplay\":\"relationships\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['dnvp_relation'] || 0);\"},\"qdisplay\":\"relationships\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['nsdap_relation'] || 0);\"},\"qdisplay\":\"relationships\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['left_strength'] || 0);\"},\"qdisplay\":\"strength\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['left_dissent'] || 0);\"},\"qdisplay\":\"dissent\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['center_strength'] || 0);\"},\"qdisplay\":\"strength\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['center_dissent'] || 0);\"},\"qdisplay\":\"dissent\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['labor_strength'] || 0);\"},\"qdisplay\":\"strength\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['labor_dissent'] || 0);\"},\"qdisplay\":\"dissent\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['reformist_strength'] || 0);\"},\"qdisplay\":\"strength\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['reformist_dissent'] || 0);\"},\"qdisplay\":\"dissent\"},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['neorevisionism'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['neorevisionist_strength'] || 0);\"},\"qdisplay\":\"strength\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['neorevisionist_dissent'] || 0);\"},\"qdisplay\":\"dissent\"}]}},\"root.start_menu\":{\"id\":\"root.start_menu\",\"newPage\":true,\"goTo\":[{\"id\":\"root.start_menu_2\"}],\"content\":{\"type\":\"heading\",\"content\":\"Social Democracy: An Alternate History\"}},\"aufhauser.white_collar\":{\"id\":\"aufhauser.white_collar\",\"title\":\"Organizing white-collar workers\",\"subtitle\":\"Improve our standing among the new middle class.\",\"chooseIf\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) <= 0);\"},\"unavailableSubtitle\":{\"content\":{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action.\"],\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) + (6 * (1 - (Q['dissent'] || 0)));\"}],\"content\":{\"content\":\"We have increased our organizing among white-collar workers.\",\"type\":\"paragraph\"}},\"braun.coalition\":{\"id\":\"braun.coalition\",\"title\":\"Negotiating with the Coalition\",\"subtitle\":\"Braun can improve our relationships with our centrist and center-right coalition partners in Prussia as well as in the Reichstag.\",\"chooseIf\":{\"$code\":\"return (((Q['advisor_action_timer'] || 0) <= 0) && (((((((Q['spd_prussia'] || 0)) !== 0) || (((Q['in_weimar_coalition'] || 0)) !== 0)) || (((Q['in_grand_coalition'] || 0)) !== 0)) || (((Q['in_popular_front'] || 0)) !== 0))));\"},\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action. \"],\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"The SPD does not control the Prussian government.\",\"predicate\":2}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (!(((Q['spd_prussia'] || 0)) !== 0));\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\n if ((((Q['spd_in_government'] || 0)===1) && ((Q['coalition_dissent'] || 0) > 0)) ) { Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) - 1; } \\nQ['z_relation'] = (Q['z_relation'] || 0) + 6;\\nQ['ddp_relation'] = (Q['ddp_relation'] || 0) + 6;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) + 2;\\n if ((((Q['in_grand_coalition'] || 0)) !== 0) ) { Q['dvp_relation'] = (Q['dvp_relation'] || 0) + 3; }\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"We have improved our relations with the \",{\"type\":\"conditional\",\"content\":\"Center (Zentrum) Party, DDP, and DVP, \",\"predicate\":0},{\"type\":\"conditional\",\"content\":\"Center (Zentrum) Party and DDP, \",\"predicate\":1},\" and reduced tensions with the coalition.\"]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['in_grand_coalition'] || 0)) !== 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (!(((Q['in_grand_coalition'] || 0)) !== 0));\"}}]}},\"baade.agriculture\":{\"id\":\"baade.agriculture\",\"title\":\"Agricultural Policy\",\"subtitle\":\"Baade is the Minister of Agriculture.\",\"chooseIf\":{\"$code\":\"return ((((Q['advisor_action_timer'] || 0) <= 0) && (((Q['spd_in_government'] || 0)) !== 0)) && (Q['agriculture_minister_party'] == \\\"SPD\\\"));\"},\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action. \"],\"predicate\":0},{\"type\":\"conditional\",\"content\":\"The SPD is not in government. \",\"predicate\":2},{\"type\":\"conditional\",\"content\":\"The SPD does not have the Agriculture Ministry.\",\"predicate\":3}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (!(((Q['spd_in_government'] || 0)) !== 0));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['agriculture_minister_party'] != \\\"SPD\\\");\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['agricultural_policy_timer'] = (Q['agricultural_policy_timer'] || 0) - 6;\\nQ['last_advisor_action'] = 1;\"}],\"goTo\":[{\"id\":\"agricultural_policy\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"breitscheid.breitscheid_international\":{\"id\":\"breitscheid.breitscheid_international\",\"title\":\"International Party Relations\",\"subtitle\":\"Breitscheid is one of our contacts with international socialist parties.\",\"unavailableSubtitle\":{\"content\":{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action.\"],\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}}]},\"chooseIf\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) == 0);\"},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['international_relations_timer'] = (Q['international_relations_timer'] || 0) - 12;\\nQ['last_advisor_action'] = 1;\"}],\"goTo\":[{\"id\":\"international_relations\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"hilferding.against_right_and_left\":{\"id\":\"hilferding.against_right_and_left\",\"title\":\"Against Right and Left\",\"subtitle\":\"As a Centrist, Hilferding seeks to steer a course between the party's factions.\",\"unavailableSubtitle\":{\"content\":{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action.\"],\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}}]},\"chooseIf\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0)===0);\"},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 5;\\nQ['advisor_action_time'] = (Q['time'] || 0);\\nQ['center_strength'] = (Q['center_strength'] || 0) + 10;\\nQ['left_strength'] = (Q['left_strength'] || 0) - 5;\\nQ['labor_strength'] = (Q['labor_strength'] || 0) - 5;\\nQ['neorevisionist_strength'] = (Q['neorevisionist_strength'] || 0) - 5;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) - 10;\"}],\"content\":{\"content\":\"We have reduced the strength of the dissident factions in the party.\",\"type\":\"paragraph\"}},\"hirschfeld.homosexual_rights_\":{\"id\":\"hirschfeld.homosexual_rights_\",\"title\":\"Homosexual rights\",\"subtitle\":\"Enact policy that supports homosexual rights.\",\"chooseIf\":{\"$code\":\"return ((((Q['advisor_action_timer'] || 0)===0) && (((Q['spd_in_government'] || 0)) !== 0)) && ((Q['progressive_coalition'] || 0) >= 50));\"},\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action. \"],\"predicate\":0},{\"type\":\"conditional\",\"content\":\"The SPD is not currently in government. \",\"predicate\":2},{\"type\":\"conditional\",\"content\":\"We do not have the votes to enact these policies.\",\"predicate\":3}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (!(((Q['spd_in_government'] || 0)) !== 0));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['progressive_coalition'] || 0) < 50);\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['homosexual_rights_timer'] = (Q['homosexual_rights_timer'] || 0) - 11;\\nQ['last_advisor_action'] = 1;\"}],\"goTo\":[{\"id\":\"homosexual_rights\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"juchacz.emergency_fundraising\":{\"id\":\"juchacz.emergency_fundraising\",\"title\":\"Emergency Fundraising\",\"subtitle\":\"An emergency infusion of resources.\",\"viewIf\":{\"$code\":\"return ((Q['difficulty'] || 0) < 1);\"},\"chooseIf\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0)===0);\"},\"unavailableSubtitle\":{\"content\":{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action.\"],\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['resources'] = (Q['resources'] || 0) + (Q['dues'] || 0);\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"We have gained +\",{\"type\":\"insert\",\"insert\":0},\" resources.\"]},\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['dues'] || 0);\"}}]}},\"leber.democratic_rally\":{\"id\":\"leber.democratic_rally\",\"title\":\"Rally for democracy\",\"subtitle\":\"Rally our party and the German people to defend democracy and freedom.\",\"chooseIf\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) == 0);\"},\"unavailableSubtitle\":{\"content\":{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action.\"],\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['pro_republic'] = (Q['pro_republic'] || 0) + 5;\\nQ['democratization'] = (Q['democratization'] || 0) + 1;\\nQ['neorevisionist_strength'] = (Q['neorevisionist_strength'] || 0) + 5;\\nQ['reformist_strength'] = (Q['reformist_strength'] || 0) + 3;\\n if (((Q['democratization'] || 0) >= 4) ) { Q['workers_spd'] = (Q['workers_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0))); } \\n if (((Q['democratization'] || 0) >= 4) ) { Q['new_middle_spd'] = (Q['new_middle_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0))); }\"}],\"content\":{\"content\":\"Leber helps us to rally the people in defense of democracy.\",\"type\":\"paragraph\"}},\"levi.building_the_left\":{\"id\":\"levi.building_the_left\",\"title\":\"Building the Left\",\"subtitle\":\"Push the SPD to the left.\",\"unavailableSubtitle\":{\"content\":{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action.\"],\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}}]},\"chooseIf\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0)===0);\"},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['left_strength'] = (Q['left_strength'] || 0) + 10;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) - 8;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 3;\"}],\"content\":{\"content\":\"We have increased the strength of the left faction with the SPD. This raised concern among the moderate reformists in the party.\",\"type\":\"paragraph\"}},\"leipart.organizing\":{\"id\":\"leipart.organizing\",\"title\":\"Organizing workers\",\"subtitle\":\"Improve our standing among the workers.\",\"chooseIf\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) <= 0);\"},\"unavailableSubtitle\":{\"content\":{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action.\"],\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\n if (((Q['wtb_adopted'] || 0) == 1) ) { Q['workers_spd'] = (Q['workers_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0))); } \\nQ['labor_strength'] = (Q['labor_strength'] || 0) + 2;\"}],\"content\":{\"content\":\"We have increased our organizing among the workers.\",\"type\":\"paragraph\"}},\"mierendorff.iron_front_buildup\":{\"id\":\"mierendorff.iron_front_buildup\",\"title\":\"Build up the Iron Front\",\"subtitle\":\"Increase our propaganda measures to recruit more members into the Reichsbanner.\",\"chooseIf\":{\"$code\":\"return (((Q['advisor_action_timer'] || 0) == 0) && (((Q['iron_front_formed'] || 0)) !== 0));\"},\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action. \"],\"predicate\":0},{\"type\":\"conditional\",\"content\":\"The Iron Front has not yet been formed.\",\"predicate\":2}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['iron_front_formed'] || 0) == 0);\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['rb_strength'] = (Q['rb_strength'] || 0) + ((200 * (Q['workers_spd'] || 0)) / ((((((Q['workers_spd'] || 0) + (Q['workers_kpd'] || 0)) + (Q['workers_nsdap'] || 0)) + (Q['workers_z'] || 0)) + (Q['workers_dnvp'] || 0)) + (Q['workers_other'] || 0)));\"}],\"content\":{\"content\":\"We have recruited more members into the Reichsbanner.\",\"type\":\"paragraph\"}},\"muller.coalition\":{\"id\":\"muller.coalition\",\"title\":\"Negotiating with the Coalition\",\"subtitle\":\"Müller can improve our relationships with our coalition partners.\",\"chooseIf\":{\"$code\":\"return (((Q['advisor_action_timer'] || 0) <= 0) && ((Q['spd_in_government'] || 0)===1));\"},\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action. \"],\"predicate\":0},{\"type\":\"conditional\",\"content\":\"The SPD is not in government.\",\"predicate\":2}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (!(((Q['spd_in_government'] || 0)) !== 0));\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\n if ((((Q['spd_in_government'] || 0)===1) && ((Q['coalition_dissent'] || 0) > 0)) ) { Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) - 1; } \\nQ['z_relation'] = (Q['z_relation'] || 0) + 5;\\nQ['ddp_relation'] = (Q['ddp_relation'] || 0) + 5;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) + 5;\"}],\"content\":{\"content\":\"We have improved our relations with the Z, DDP, and DVP, and reduced tensions with the coalition.\",\"type\":\"paragraph\"}},\"pfulf.support_peoples_party\":{\"id\":\"pfulf.support_peoples_party\",\"title\":\"Build support for a People's Party\",\"subtitle\":\"Can we expand our party beyond the industrial working class?\",\"viewIf\":{\"$code\":\"return ((Q['peoples_party'] || 0)===0);\"},\"chooseIf\":{\"$code\":\"return ((((Q['peoples_party_support'] || 0) <= 4) && ((Q['advisor_action_timer'] || 0)===0)) && ((Q['peoples_party'] || 0)===0));\"},\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action. \"],\"predicate\":0},{\"type\":\"conditional\",\"content\":\"There is already substantial support for a People's Party.\",\"predicate\":2}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['peoples_party_support'] || 0) > 4);\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['peoples_party_support'] = (Q['peoples_party_support'] || 0) + 1;\\nQ['reformist_strength'] = (Q['reformist_strength'] || 0) + 5;\"}],\"content\":{\"content\":\"We are building up support for the idea of a People's Party.\",\"type\":\"paragraph\"}},\"radbruch.judiciary_\":{\"id\":\"radbruch.judiciary_\",\"title\":\"Judicial Affairs\",\"subtitle\":\"Enact judicial reforms.\",\"chooseIf\":{\"$code\":\"return ((((Q['advisor_action_timer'] || 0)===0) && (((Q['spd_in_government'] || 0)) !== 0)) && (Q['justice_minister_party'] == \\\"SPD\\\"));\"},\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action. \"],\"predicate\":0},{\"type\":\"conditional\",\"content\":\"The SPD is not currently in government. \",\"predicate\":2},{\"type\":\"conditional\",\"content\":\"We do not have the Justice Ministry.\",\"predicate\":3}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (!(((Q['spd_in_government'] || 0)) !== 0));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['justice_minister_party'] != \\\"SPD\\\");\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['judiciary_timer'] = (Q['judiciary_timer'] || 0) - 6;\\nQ['last_advisor_action'] = 1;\"}],\"goTo\":[{\"id\":\"judiciary\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"rosenfeld.building_the_left\":{\"id\":\"rosenfeld.building_the_left\",\"title\":\"Building the Left\",\"subtitle\":\"Push the SPD to the left.\",\"unavailableSubtitle\":{\"content\":{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action.\"],\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}}]},\"chooseIf\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0)===0);\"},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['left_strength'] = (Q['left_strength'] || 0) + 6;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) - 8;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 2;\"}],\"content\":{\"content\":\"We have increased the strength of the left faction with the SPD.\",\"type\":\"paragraph\"}},\"schumacher.emergency_fundraising\":{\"id\":\"schumacher.emergency_fundraising\",\"title\":\"Emergency Fundraising\",\"subtitle\":\"An emergency infusion of resources.\",\"chooseIf\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0)===0);\"},\"unavailableSubtitle\":{\"content\":{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action.\"],\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['resources'] = (Q['resources'] || 0) + (Q['dues'] || 0);\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"We have gained +\",{\"type\":\"insert\",\"insert\":0},\" resources.\"]},\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['dues'] || 0);\"}}]}},\"severing.prussian_bulwark\":{\"id\":\"severing.prussian_bulwark\",\"title\":\"Prussian Bulwark\",\"subtitle\":\"Severing has influence over Prussian politics.\",\"chooseIf\":{\"$code\":\"return (((Q['advisor_action_timer'] || 0) <= 0) && ((Q['spd_prussia'] || 0)===1));\"},\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action. \"],\"predicate\":0},{\"type\":\"conditional\",\"content\":\"The SPD is not in control of Prussia.\",\"predicate\":2}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (!(((Q['spd_prussia'] || 0)) !== 0));\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['prussian_affairs_timer'] = (Q['prussian_affairs_timer'] || 0) - 6;\\nQ['last_advisor_action'] = 1;\"}],\"goTo\":[{\"id\":\"prussian_affairs\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"sender.left_unity\":{\"id\":\"sender.left_unity\",\"title\":\"Left-Center Unity\",\"subtitle\":\"Encourage cooperation between the left and center wings of the party.\",\"chooseIf\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0)===0);\"},\"unavailableSubtitle\":{\"content\":{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action.\"],\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) - 10;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) - 5;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) - 10;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) - 10;\\nQ['neorevisionist_dissent'] = (Q['neorevisionist_dissent'] || 0) - 5;\"}],\"content\":{\"content\":\"We have reduced dissent among the party's factions.\",\"type\":\"paragraph\"}},\"seydewitz.class_struggle\":{\"id\":\"seydewitz.class_struggle\",\"title\":\"Rally for class struggle\",\"subtitle\":\"The core of socialism should be the struggle of the proletariat against the bourgeoisie.\",\"unavailableSubtitle\":{\"content\":{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action.\"],\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}}]},\"chooseIf\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0)===0);\"},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\n if (((Q['nationalization_progress'] || 0) > 0) ) { Q['workers_spd'] = (Q['workers_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0))); } \\n if (((Q['nationalization_progress'] || 0) > 0) ) { Q['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0))); } \\nQ['left_strength'] = (Q['left_strength'] || 0) + 5;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) - 5;\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) - 3;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) - 2;\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"Our message of class struggle appeals to the left wing of the working class, while potentially alienating the middle class. \",{\"type\":\"conditional\",\"content\":\"Our achievements in nationalization have assisted our messaging.\",\"predicate\":0}]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['nationalization_progress'] || 0) > 0);\"}}]}},\"shuffle_leadership_pinned\":{\"id\":\"shuffle_leadership_pinned\",\"type\":\"scene\",\"title\":\"Shuffle Leadership\",\"viewIf\":{\"$code\":\"return ((Q['difficulty'] || 0) < 0);\"},\"newPage\":true,\"isCard\":true,\"isPinnedCard\":true,\"onArrival\":[{\"$code\":\"Q['month_activities'] = (Q['month_activities'] || 0) + 1;\\nQ['shuffle_leadership_timer'] = 6;\"}],\"cardImage\":\"img/vorwarts_2.jpg\",\"goTo\":[{\"id\":\"shuffle_leadership.rm_main\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"stampfer.media_\":{\"id\":\"stampfer.media_\",\"title\":\"Media\",\"subtitle\":\"Manage our party's newspapers and media.\",\"chooseIf\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0)===0);\"},\"unavailableSubtitle\":{\"content\":{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action.\"],\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['media_timer'] = (Q['media_timer'] || 0) - 6;\\nQ['last_advisor_action'] = 1;\"}],\"goTo\":[{\"id\":\"media\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"wels.clear_agenda\":{\"id\":\"wels.clear_agenda\",\"title\":\"Clear the agenda\",\"subtitle\":\"Removes all cards from the hand.\",\"chooseIf\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0)===0);\"},\"unavailableSubtitle\":{\"content\":{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action.\"],\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}}]},\"onArrival\":[{\"$code\":\"Q.advisor_action_timer = 6;\\nif (Q.difficulty >= 0) {\\n    window.dendryUI.dendryEngine.state.currentHands['main'] = [];\\n} else {\\n    window.dendryUI.dendryEngine.state.currentHands['main.main_easy'] = [];\\n}\"}],\"content\":{\"content\":\"All items from our agenda have been cleared.\",\"type\":\"paragraph\"}},\"wissell.labor_rights_\":{\"id\":\"wissell.labor_rights_\",\"title\":\"Labor Rights\",\"subtitle\":\"As Labor Minister, Wissell can help set regulations for working conditions.\",\"chooseIf\":{\"$code\":\"return ((((Q['advisor_action_timer'] || 0) <= 0) && (((Q['spd_in_government'] || 0)) !== 0)) && (Q['labor_minister_party'] == \\\"SPD\\\"));\"},\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action. \"],\"predicate\":0},{\"type\":\"conditional\",\"content\":\"The SPD does not control the Labor Ministry.\",\"predicate\":2}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['labor_minister_party'] != \\\"SPD\\\");\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['labor_rights_timer'] = (Q['labor_rights_timer'] || 0) - 10;\\nQ['last_advisor_action'] = 1;\"}],\"goTo\":[{\"id\":\"labor_rights\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"coalition_affairs.promise_cuts\":{\"id\":\"coalition_affairs.promise_cuts\",\"onArrival\":[{\"$code\":\"Q['workers_spd'] = (Q['workers_spd'] || 0) - 5;\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) - 6;\\nQ['workers_kpd'] = (Q['workers_kpd'] || 0) + 5;\\nQ['unemployed_kpd'] = (Q['unemployed_kpd'] || 0) + 3;\\nQ['unemployed_nsdap'] = (Q['unemployed_nsdap'] || 0) + 3;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 10;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) + 5;\\nQ['welfare'] = (Q['welfare'] || 0) - 1;\\nQ['budget'] = (Q['budget'] || 0) + 1;\\nQ['coalition_dissent'] = 0;\"}],\"content\":{\"content\":\"Fine. By cutting welfare, we have reduced dissent within the coalition.\",\"type\":\"paragraph\"}},\"agricultural_policy.land_reform\":{\"id\":\"agricultural_policy.land_reform\",\"title\":\"Land Reform\",\"subtitle\":\"-1 budget - Break up the large aristocratic estates and give land to landless workers.\",\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":\"Requires 1 budget. \",\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"The judiciary would never allow this.\",\"predicate\":1}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['budget'] || 0) <= 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['judicial_reform'] || 0) < 2);\"}}]},\"chooseIf\":{\"$code\":\"return (((Q['judicial_reform'] || 0) >= 2) && ((Q['budget'] || 0) > 0));\"},\"onArrival\":[{\"$code\":\"Q['budget'] = (Q['budget'] || 0) - 1;\\nQ['land_reform'] = (Q['land_reform'] || 0) + 1;\\nQ['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1;\\nQ['rural_spd'] = (Q['rural_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['rural_nsdap'] = (Q['rural_nsdap'] || 0) - (4 * (1 - (Q['dissent'] || 0)));\\n if (((Q['unemployed'] || 0) >= 5) ) { Q['unemployed'] = (Q['unemployed'] || 0) - 1; } \\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 5;\\nQ['z_relation'] = (Q['z_relation'] || 0) - 4;\\nQ['left_strength'] = (Q['left_strength'] || 0) + 8;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) - 5;\\nQ['rural_sol'] = (Q['rural_sol'] || 0) + 3;\\nQ['rural_policy'] = (Q['rural_policy'] || 0) + 1;\\nQ['coup_progress'] = (Q['coup_progress'] || 0) + 1;\\nQ['agriculture_goal_completed'] = (Q['agriculture_goal_completed'] || 0) + 1;\"}],\"maxVisits\":4,\"content\":{\"content\":\"With our policy of land reform, we are acquiring farmland from large estates, and giving the land to farmworkers' associations and small peasants. In essence, this brings class struggle to the countryside, breaking the semi-feudal property relations present in East Prussia and other areas with large estates. The bourgeois parties and large farmers despise our intrusion into the sacredness of private property, while leftists are cautiously optimistic.\",\"type\":\"paragraph\"},\"countVisitsMax\":4},\"dealing_with_toleration.break_toleration\":{\"id\":\"dealing_with_toleration.break_toleration\",\"viewIf\":{\"$code\":\"return (!(((Q['constructive_vonc'] || 0)) !== 0));\"},\"title\":\"End the toleration agreement with a vote of no confidence!\",\"options\":[{\"id\":\"@dealing_with_toleration.vonc\",\"title\":\"Yes, end this arrangement!\"},{\"id\":\"@dealing_with_toleration.stay_course\",\"title\":\"No, we should stay the course.\"}],\"content\":{\"content\":\"Are we sure about this? A vote of no confidence would trigger new elections, and potentially an increased vote-share for the extremist parties.\",\"type\":\"paragraph\"}},\"deport_hitler.deport\":{\"id\":\"deport_hitler.deport\",\"goTo\":[{\"id\":\"deport_hitler.deport_violence\",\"predicate\":{\"$code\":\"return ((Q['sa_strength'] || 0) >= 200);\"}},{\"id\":\"deport_hitler.deport_success\",\"predicate\":{\"$code\":\"return ((Q['sa_strength'] || 0) < 200);\"}}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"woytinsky.plan\":{\"id\":\"woytinsky.plan\",\"title\":\"Adopt the WTB-plan!\",\"subtitle\":\"Convincing the rest of the party to support the WTB-plan.\",\"chooseIf\":{\"$code\":\"return ((((((Q['advisor_action_timer'] || 0) <= 0) && ((Q['wtb_adopted'] || 0) == 0)) && ((Q['wtb_support'] || 0) >= 3)) && (((Q['black_thursday_seen'] || 0)) !== 0)) && (((!(((Q['historical_mode'] || 0)) !== 0)) || ((((((Q['labor_strength'] || 0) >= (Q['center_strength'] || 0))) && (((Q['labor_strength'] || 0) >= (Q['left_strength'] || 0)))) && (((Q['labor_strength'] || 0) >= (Q['reformist_strength'] || 0))))))));\"},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\"}],\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action. \"],\"predicate\":0},{\"type\":\"conditional\",\"content\":\"We are not currently in an economic crisis. \",\"predicate\":2},{\"type\":\"conditional\",\"content\":\"We have already adopted the WTB-Plan. \",\"predicate\":3},{\"type\":\"conditional\",\"content\":\"There is not enough support for the WTB-Plan. \",\"predicate\":4},{\"type\":\"conditional\",\"content\":\"The labor faction is not strong enough.\",\"predicate\":5}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['black_thursday_seen'] || 0) == 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['wtb_adopted'] || 0) > 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['wtb_support'] || 0) < 3);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((((Q['labor_strength'] || 0) < (Q['center_strength'] || 0)) || ((Q['labor_strength'] || 0) < (Q['left_strength'] || 0))) || ((Q['labor_strength'] || 0) < (Q['reformist_strength'] || 0)))) && (((Q['historical_mode'] || 0)) !== 0));\"}}]},\"goTo\":[{\"id\":\"crisis_program.plan_adopted\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"economic_democracy.expand_councils\":{\"id\":\"economic_democracy.expand_councils\",\"title\":\"Support works councils.\",\"subtitle\":\"Give works councils a greater influence in managing enterprises.\",\"viewIf\":{\"$code\":\"return ((Q['works_councils'] || 0) == 0);\"},\"onArrival\":[{\"$code\":\"Q['economic_democracy'] = (Q['economic_democracy'] || 0) + 1;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (7 * (1 - (Q['dissent'] || 0)));\\nQ['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) + 1;\\nQ['works_councils'] = (Q['works_councils'] || 0) + 1;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) - 6;\\nQ['labor_strength'] = (Q['labor_strength'] || 0) + 8;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 5;\\n if ((((Q['in_grand_coalition'] || 0)) !== 0) ) { Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1; }\"}],\"maxVisits\":1,\"content\":{\"content\":\"The works councils, elected by workers at each major business, have been in place since the German Revolution of 1918, but they have been largely powerless in the face of capital. Now, we will have worker representation on the boards of companies, giving them more influence in management decisions.\",\"type\":\"paragraph\"},\"countVisitsMax\":1},\"economic_policy.wtb_2\":{\"id\":\"economic_policy.wtb_2\",\"title\":\"Continue the implementation of the WTB-Plan.\",\"subtitle\":\"-3 budget\",\"unavailableSubtitle\":\"Unemployment is low enough that the time for the WTB-Plan has passed.\",\"viewIf\":{\"$code\":\"return (((Q['wtb_implemented'] || 0) > 2) && ((Q['budget'] || 0) >= 3));\"},\"chooseIf\":{\"$code\":\"return ((Q['unemployed'] || 0) > 8);\"},\"onArrival\":[{\"$code\":\"Q['works_program'] = (Q['works_program'] || 0) + 1;\\nQ['budget'] = (Q['budget'] || 0) - 3;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (7 * (1 - (Q['dissent'] || 0)));\\n if (((Q['unemployed'] || 0) > 8) ) { Q['workers'] = (Q['workers'] || 0) + 2; } \\n if (((Q['unemployed'] || 0) > 8) ) { Q['unemployed'] = (Q['unemployed'] || 0) - 3; } \\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (7 * (1 - (Q['dissent'] || 0)));\\nQ['workers_kpd'] = (Q['workers_kpd'] || 0) - 3;\\nQ['workers_nsdap'] = (Q['workers_nsdap'] || 0) - 3;\\nQ['wtb_implemented'] = (Q['wtb_implemented'] || 0) + 1;\\nQ['kpd_coalition_dissent'] = (Q['kpd_coalition_dissent'] || 0) + 1;\\n if (((((Q['in_popular_front'] || 0)) !== 0) || (((Q['in_left_front'] || 0)) !== 0)) ) { Q['kpd_relation'] = (Q['kpd_relation'] || 0) - 5; } \\nQ['inflation'] = (Q['inflation'] || 0) + 2;\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"We have commenced Phase 2 of the WTB-Plan. \",\"predicate\":0},{\"type\":\"conditional\",\"content\":\"We have continued our implementation of the WTB-Plan. \",\"predicate\":1},\" In addition to public works, we are now focusing on rebuilding our industries.\"]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['works_program'] || 0) == 4);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['works_program'] || 0) > 4);\"}}]}},\"domestic_enemies.ban_sa\":{\"id\":\"domestic_enemies.ban_sa\",\"viewIf\":{\"$code\":\"return (((Q['nazi_urgency'] || 0) >= 3) && ((Q['sa_banned'] || 0) == 0));\"},\"onArrival\":[{\"$code\":\"Q['sa_strength'] = (Q['sa_strength'] || 0) * 0.85;\\n if (((Q['interior_police_loyalty'] || 0) >= 0.7) ) { Q['sa_strength'] = (Q['sa_strength'] || 0) * 0.7; } \\nQ['sa_banned'] = 1;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 3;\\nQ['prussian_police_loyalty'] = (Q['prussian_police_loyalty'] || 0) - 0.05;\\nQ['interior_police_loyalty'] = (Q['interior_police_loyalty'] || 0) - 0.05;\\nQ['sa_militancy'] = (Q['sa_militancy'] || 0) - 0.05;\\nQ['sa_ban_timer'] = 6;\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"As it turns out, the Nazi SA has many allies in the police and bureaucracy. Our relationship with the police weakens, and the SA can still organize illegally, right under the police's noses. \",{\"type\":\"conditional\",\"content\":\"Nevertheless, the SA is substantially weakend by our ban.\",\"predicate\":0}]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['interior_police_loyalty'] || 0) >= 0.7);\"}}]}},\"foreign_policy.fp_menu\":{\"id\":\"foreign_policy.fp_menu\",\"options\":[{\"id\":\"@foreign_policy.improve_west\"},{\"id\":\"@foreign_policy.improve_east\"},{\"id\":\"@foreign_policy.improve_soviet\"},{\"id\":\"@foreign_policy.customs_union\"},{\"id\":\"@foreign_policy.negotiate\"},{\"id\":\"@foreign_policy.reduce_reparations\"},{\"id\":\"@foreign_policy.expose\"},{\"id\":\"@foreign_policy.european_union\"},{\"id\":\"@foreign_policy.european_union_2\"},{\"id\":\"@foreign_policy.concordat_negotiate\"},{\"id\":\"@foreign_policy.concordat\"},{\"id\":\"@root\",\"title\":\"Do not enact any policies for now.\"},{\"id\":\"@easy_discard\"},{\"id\":\"@cancel_advisor_action\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"homosexual_rights.repeal_175\":{\"id\":\"homosexual_rights.repeal_175\",\"subtitle\":\"Paragraph 175 currently criminalizes homosexual acts. We can pass a law to change that.\",\"unavailableSubtitle\":\"We do not have majority support for this policy.\",\"viewIf\":{\"$code\":\"return ((Q['repealed_175'] || 0) == 0);\"},\"chooseIf\":{\"$code\":\"return ((Q['progressive_coalition'] || 0) >= 50);\"},\"onArrival\":[{\"$code\":\"Q['repealed_175'] = 1;\\nQ['homosexual_rights'] = (Q['homosexual_rights'] || 0) + 1;\\nQ['z_relation'] = (Q['z_relation'] || 0) - 5;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\nQ['ddp_relation'] = (Q['ddp_relation'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\n if ((((((Q['in_grand_coalition'] || 0)) !== 0) || (((Q['in_weimar_coalition'] || 0)) !== 0))) ) { Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1; } \\nQ['catholics_spd'] = (Q['catholics_spd'] || 0) - 4;\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"Together with the progressives in the KPD and DDP, we have effectively decriminalized homosexual sex in Germany. Persecution of homosexuals for their private acts will stop, as long as the police are loyal to the republic.\"},{\"type\":\"paragraph\",\"content\":\"Of course, conservatives and the far right accuse us of \\\"degeneracy\\\".\"}]},\"fiscal_policy.fiscal_menu\":{\"id\":\"fiscal_policy.fiscal_menu\",\"options\":[{\"id\":\"@fiscal_policy.raise_progressive\",\"title\":\"Make the tax system more progressive by raising taxes on the rich and cutting them for the poor.\"},{\"id\":\"@fiscal_policy.raise_rich\",\"title\":\"Increase taxes on the rich.\"},{\"id\":\"@fiscal_policy.raise_overall\",\"title\":\"Increase overall taxes.\"},{\"id\":\"@fiscal_policy.cut_overall\",\"title\":\"Cut overall taxes.\"},{\"id\":\"@fiscal_policy.regressive\"},{\"id\":\"@fiscal_policy.tariffs\"},{\"id\":\"@root\",\"title\":\"Do not change the tax system.\"},{\"id\":\"@easy_discard\"},{\"id\":\"@cancel_advisor_action\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[\"Upper-income tax rates: \",{\"type\":\"insert\",\"insert\":0},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Lower-income tax rates: \",{\"type\":\"insert\",\"insert\":1}]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['upper_tax_rates'] || 0);\"},\"qdisplay\":\"taxation\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['lower_tax_rates'] || 0);\"},\"qdisplay\":\"taxation\"}]}},\"labor_affairs.support_labor\":{\"id\":\"labor_affairs.support_labor\",\"subtitle\":\"Popular among the workers, this will alienate the bourgeoisie.\",\"onArrival\":[{\"$code\":\"Q['labor_strength'] = (Q['labor_strength'] || 0) + 5;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) - 5;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) - 5;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (6 * (1 - (Q['dissent'] || 0)));\\nQ['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 4;\\n if (((Q['dvp_relation'] || 0) <= 30) ) { Q['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) + 1; } \\n if (((Q['unemployed'] || 0) > 15) ) { Q['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) + 1; } \\n if (((Q['unemployed'] || 0) > 24) ) { Q['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) + 1; } \\nQ['labor_goal_completed'] = (Q['labor_goal_completed'] || 0) + 1;\\nQ['inflation'] = (Q['inflation'] || 0) + 0.1;\\nQ['pro_labor'] = (Q['pro_labor'] || 0) + 1;\\nQ['strike_term_seen'] = (Q['strike_term_seen'] || 0) + 1;\"}],\"content\":{\"content\":\"Supporting labor is always popular in the SPD, although many of our coalition partners represent employers, and they are less enthused.\",\"type\":\"paragraph\"}},\"military_policy.increase_funding\":{\"id\":\"military_policy.increase_funding\",\"subtitle\":\"-1 budget\",\"chooseIf\":{\"$code\":\"return ((Q['budget'] || 0) >= 1);\"},\"unavailableSubtitle\":\"We do not have the budget.\",\"onArrival\":[{\"$code\":\"Q['budget'] = (Q['budget'] || 0) - 1;\\n if (((Q['coalition_dissent'] || 0) > 0) ) { Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) - 1; } \\nQ['reichswehr_loyalty'] = (Q['reichswehr_loyalty'] || 0) + 0.1;\\nQ['reichswehr_strength'] = (Q['reichswehr_strength'] || 0) + 20;\\nQ['kpd_coalition_dissent'] = (Q['kpd_coalition_dissent'] || 0) + 1;\\nQ['west_relation'] = (Q['west_relation'] || 0) - 1;\\nQ['east_relation'] = (Q['east_relation'] || 0) - 1;\\nQ['reparations_negotiation'] = (Q['reparations_negotiation'] || 0) - 1;\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"The military and the center-right parties are pleasantly surprised that we would increase military funding. Our membership tends to be anti-military, and is less enthused. Germany's neighbors are watching our military buildup with worry. \",{\"type\":\"conditional\",\"content\":\"This is not good for the reparations negotiations.\",\"predicate\":0}]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['reparations'] || 0) >= 0);\"}}]}},\"labor_rights.labor_rights_menu\":{\"id\":\"labor_rights.labor_rights_menu\",\"options\":[{\"id\":\"@labor_rights.working_hours\",\"title\":\"Enforce the 40-hour work week.\"},{\"id\":\"@labor_rights.shorten_hours\",\"title\":\"Shorten work hours less than 40 hours.\"},{\"id\":\"@labor_rights.safety\",\"title\":\"Develop and enforce safety regulations.\"},{\"id\":\"@labor_rights.unemployment_insurance\",\"title\":\"Fund the unemployment insurance program.\"},{\"id\":\"@root\",\"title\":\"Do not enact any policies.\"},{\"id\":\"@easy_discard\"},{\"id\":\"@cancel_advisor_action\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"police.loyalty\":{\"id\":\"police.loyalty\",\"onArrival\":[{\"$code\":\"Q['interior_police_loyalty'] = (Q['interior_police_loyalty'] || 0) + 0.1;\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"As with the Prussian state police, there are measures we can take to root out reactionary and anti-democratic sentiment in the police. We can improve training and recruiting procedures, and identify and remove known fascists and the like.\"},{\"type\":\"paragraph\",\"content\":[\"Current interior police loyalty: \",{\"type\":\"insert\",\"insert\":0}]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['interior_police_loyalty'] || 0);\"},\"qdisplay\":\"loyalty\"}]}},\"prussian_affairs.police_loyalty\":{\"id\":\"prussian_affairs.police_loyalty\",\"viewIf\":{\"$code\":\"return ((Q['prussian_police_loyalty'] || 0) < 1);\"},\"onArrival\":[{\"$code\":\"Q['prussian_police_loyalty'] = (Q['prussian_police_loyalty'] || 0) + 0.1;\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"The police have historically been overrun with reactionaries, and we are trying to change this, little by little. We have improved the training and recruitment process to select for a broader demographic than the traditional conservatives, and to put a tighter leash on their political activity. In addition, we set up committees to investigate the ranks of the police and remove those with far-right sympathies. It is a slow and arduous work.\"},{\"type\":\"paragraph\",\"content\":[\"Current police loyalty: \",{\"type\":\"insert\",\"insert\":0},\".\"]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['prussian_police_loyalty'] || 0);\"},\"qdisplay\":\"loyalty\"}]}},\"shuffle_cabinet.shuffle\":{\"id\":\"shuffle_cabinet.shuffle\",\"onArrival\":[{\"$code\":\"Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1;\\nQ['month_actions'] = (Q['month_actions'] || 0) + 1;\"}],\"goTo\":[{\"id\":\"election_1928.ministries\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"shuffle_cabinet\":{\"id\":\"shuffle_cabinet\",\"type\":\"scene\",\"title\":\"Shuffle Cabinet\",\"newPage\":true,\"isCard\":true,\"tags\":[\"govt_affairs\"],\"onArrival\":[{\"$code\":\"Q['shuffle_cabinet_timer'] = 6;\"}],\"viewIf\":{\"$code\":\"return (((((((Q['spd_in_government'] || 0) == 1) && ((Q['shuffle_cabinet_timer'] || 0) == 0)) && (Q['chancellor_party'] == \\\"SPD\\\")) && (!(((Q['in_spd_majority'] || 0)) !== 0))) && (!(((Q['in_emergency_government'] || 0)) !== 0))) && (!(((Q['in_left_front'] || 0)) !== 0)));\"},\"cardImage\":\"img/muller_cabinet.jpg\",\"options\":[{\"id\":\"@shuffle_cabinet.shuffle\",\"title\":\"Yes, do it.\"},{\"id\":\"@root\",\"title\":\"No, there is no need.\"},{\"id\":\"@easy_discard\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"Do we wish to shuffle our cabinet? This might upset our current coalition.\"},{\"type\":\"paragraph\",\"content\":\"Current cabinet:\"},{\"type\":\"paragraph\",\"content\":[\"Labor: \",{\"type\":\"insert\",\"insert\":0},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Interior: \",{\"type\":\"insert\",\"insert\":1},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Finance: \",{\"type\":\"insert\",\"insert\":2},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Economic: \",{\"type\":\"insert\",\"insert\":3},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Justice: \",{\"type\":\"insert\",\"insert\":4},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Foreign: \",{\"type\":\"insert\",\"insert\":5},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Reichswehr: \",{\"type\":\"insert\",\"insert\":6},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Agriculture: \",{\"type\":\"insert\",\"insert\":7}]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['labor_minister_party'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['interior_minister_party'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['finance_minister_party'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['economic_minister_party'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['justice_minister_party'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['foreign_minister_party'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['reichswehr_minister_party'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['agriculture_minister_party'] || 0);\"}}]}},\"social_welfare.reduce_spending\":{\"id\":\"social_welfare.reduce_spending\",\"subtitle\":\"This will hurt our proletarian base. +1 Budget\",\"unavailableSubtitle\":\"There is nothing left to cut.\",\"chooseIf\":{\"$code\":\"return ((Q['welfare'] || 0) >= -5);\"},\"onArrival\":[{\"$code\":\"Q['budget'] = (Q['budget'] || 0) + 1;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 6;\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) - 6;\\nQ['workers_kpd'] = (Q['workers_kpd'] || 0) + 3;\\nQ['welfare'] = (Q['welfare'] || 0) - 1;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 10;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 10;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) + 10;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) + 5;\\nQ['neorevisionist_dissent'] = (Q['neorevisionist_dissent'] || 0) + 5;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) + 5;\\nQ['z_relation'] = (Q['z_relation'] || 0) + 3;\\nQ['pro_republic'] = (Q['pro_republic'] || 0) - 3;\\n if (((((Q['in_grand_coalition'] || 0)) !== 0) && ((Q['coalition_dissent'] || 0) > 0)) ) { Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) - 1; } \\nQ['kpd_coalition_dissent'] = (Q['kpd_coalition_dissent'] || 0) + 1;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) - 8;\\nQ['inflation'] = (Q['inflation'] || 0) - 0.3;\\nQ['unemployed'] = (Q['unemployed'] || 0) + 0.4;\"}],\"content\":{\"content\":\"We have reduced levels of social welfare spending. This means more poverty and suffering for the working class. Our detractors claim that we are sacrificing proletarian livelihoods for the sake of class peace with the bourgeoisie. Are they wrong? Are the workers wrong to turn to the Communists, in light of our choices?\",\"type\":\"paragraph\"}},\"womens_rights.labor\":{\"id\":\"womens_rights.labor\",\"subtitle\":\"Paid maternal leave policies, equal pay policies, and so on.\",\"onArrival\":[{\"$code\":\"Q['womens_work'] = 1;\\nQ['womens_rights'] = (Q['womens_rights'] || 0) + 1;\\n if (((Q['unemployed'] || 0) > 15) ) { Q['workers_spd'] = (Q['workers_spd'] || 0) - 4; } \\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\"}],\"maxVisits\":3,\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"These policies mean that our party is increasing in popularity among the \\\"new women\\\" who work outside the home. \",{\"type\":\"conditional\",\"content\":\"However, many male workers develop a backlash towards women in the workplace, especially given the rising unemployment.\",\"predicate\":0}]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['unemployed'] || 0) > 15);\"}}]},\"countVisitsMax\":3},\"war_guilt.restart\":{\"id\":\"war_guilt.restart\",\"onArrival\":[{\"$code\":\"Q['war_guilt'] = (Q['war_guilt'] || 0) + 1;\"}],\"options\":[{\"id\":\"@war_guilt.pure_history\",\"title\":\"To provide a historical record of the events of the war.\"},{\"id\":\"@war_guilt.rewrite\",\"title\":\"To revise the popular German histories and finally put to rest the \\\"stabbed in the back\\\" myth.\"}],\"content\":{\"content\":\"What is the goal of this tribunal?\",\"type\":\"paragraph\"}},\"judiciary.reform\":{\"id\":\"judiciary.reform\",\"subtitle\":\"-1 budget\",\"unavailableSubtitle\":\"Not enough budget.\",\"chooseIf\":{\"$code\":\"return ((Q['budget'] || 0) >= 1);\"},\"onArrival\":[{\"$code\":\"Q['budget'] = (Q['budget'] || 0) - 1;\\nQ['democratization'] = (Q['democratization'] || 0) + 2;\\n if (((Q['in_grand_coalition'] || 0) == 1) ) { Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1; } \\n if (((Q['democratization'] || 0) >= 3) ) { Q['workers_spd'] = (Q['workers_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0))); } \\nQ['judicial_reform'] = (Q['judicial_reform'] || 0) + 2;\\nQ['pro_republic'] = (Q['pro_republic'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['coup_progress'] = (Q['coup_progress'] || 0) + 1;\\n if ((((Q['historical_mode'] || 0)) !== 0) ) { Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1; }\"}],\"content\":{\"content\":\"We investigate jurists who have shown themselves to have biased or corrupt behavior, and try to remove them, replacing them with more democratically-oriented jurists. This obviously raises quite a great deal of ire in conservative circles, including within our coalition.\",\"type\":\"paragraph\"}},\"all_quiet.ban\":{\"id\":\"all_quiet.ban\",\"onArrival\":[{\"$code\":\"Q['old_middle_nsdap'] = (Q['old_middle_nsdap'] || 0) + 5;\\nQ['new_middle_nsdap'] = (Q['new_middle_nsdap'] || 0) + 4;\\nQ['workers_nsdap'] = (Q['workers_nsdap'] || 0) + 2;\\nQ['unemployed_nsdap'] = (Q['unemployed_nsdap'] || 0) + 2;\\nQ['sa_strength'] = (Q['sa_strength'] || 0) + 50;\\nQ['nationalism'] = (Q['nationalism'] || 0) + 6;\\nQ['pro_republic'] = (Q['pro_republic'] || 0) - 5;\"}],\"content\":{\"content\":\"When we ban the film, the Nazis immediately celebrate it as a major victory; they claim that even the red Marxists agree with them! It is a major boost to their morale.\",\"type\":\"paragraph\"}},\"austrian_customs_union.let_it_happen\":{\"id\":\"austrian_customs_union.let_it_happen\",\"onArrival\":[{\"$code\":\"Q['banking_crisis_timer'] = 2;\\nQ['customs_union'] = 1;\\nQ['west_relation'] = (Q['west_relation'] || 0) - 2;\\nQ['east_relation'] = (Q['east_relation'] || 0) - 2;\"}],\"content\":{\"content\":\"The customs union has been formed. Immediately, France and other neighboring countries lodge their protests. The longer-term response is yet to be seen.\",\"type\":\"paragraph\"}},\"banking_crisis.nothing_to_do\":{\"id\":\"banking_crisis.nothing_to_do\",\"viewIf\":{\"$code\":\"return ((Q['spd_in_government'] || 0)===1);\"},\"onArrival\":[{\"$code\":\"Q['welfare'] = (Q['welfare'] || 0) - 1;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 3;\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) - 3;\\nQ['pro_republic'] = (Q['pro_republic'] || 0) - 3;\"}],\"content\":{\"content\":\"There is, essentially, nothing we can do.\",\"type\":\"paragraph\"}},\"black_thursday.cap\":{\"id\":\"black_thursday.cap\",\"content\":{\"content\":\"Perhaps this is simply one of the periodic crises of capitalism. Perhaps this moment will simply pass.\",\"type\":\"paragraph\"}},\"blutmai.ban\":{\"id\":\"blutmai.ban\",\"onArrival\":[{\"$code\":\"Q['blutmai'] = 1;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) - 25;\\nQ['z_relation'] = (Q['z_relation'] || 0) + 5;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) + 5;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 3;\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) - 3;\\nQ['workers_kpd'] = (Q['workers_kpd'] || 0) + 3;\\nQ['unemployed_kpd'] = (Q['unemployed_kpd'] || 0) + 3;\\nQ['communist_coalition'] = (Q['communist_coalition'] || 0) - 3;\\nQ['strife'] = (Q['strife'] || 0) + 1;\"}],\"faceImage\":\"img/blutmai.jpg\",\"options\":[{\"id\":\"@blutmai.corrupt_police\",\"title\":\"It is the fault of corrupt and reactionary elements within the police. Purge those responsible.\"},{\"id\":\"@blutmai.communist_fault\",\"title\":\"It is the fault of the Communists for refusing to follow the rule of law.\"},{\"id\":\"@blutmai.no_fault\",\"title\":\"It is an unfortunate incident that should not have happened, but is no one's fault at all.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[\"We issued the order to ban the demonstrations, and sent police to enforce the ban. There was a confrontation between the police and Communists, and violence erupted. Reports say that the Berlin police killed dozens of demonstrators and innocent bystanders. The Communists are already calling this incident \",{\"type\":\"emphasis-1\",\"content\":\"Blutmai\"},\", \\\"Bloody May\\\".\"]},{\"type\":\"paragraph\",\"content\":\"This may end any attempt at reconciliation with the KPD, but the Center and People's parties approve of our action.\"}]},\"altona_clashes.ban_march\":{\"id\":\"altona_clashes.ban_march\",\"chooseIf\":{\"$code\":\"return ((Q['judicial_reform'] || 0) >= 2);\"},\"unavailableSubtitle\":\"The judiciary would not allow us to ban the protest, because of free speech.\",\"onArrival\":[{\"$code\":\"Q['sa_strength'] = (Q['sa_strength'] || 0) - 10;\"}],\"content\":{\"content\":\"We have banned the planned protest. The Nazis appeal the ban in the courts in the name of freedom of speech. Thankfully, the judiciary agrees with us that the Nazis' argument is specious.\",\"type\":\"paragraph\"}},\"businesses_lose_confidence.taxes\":{\"id\":\"businesses_lose_confidence.taxes\",\"onArrival\":[{\"$code\":\"Q['upper_tax_rates'] = (Q['upper_tax_rates'] || 0) - 1;\\nQ['budget'] = (Q['budget'] || 0) - 1;\\nQ['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) - 1;\\nQ['unemployed'] = (Q['unemployed'] || 0) - 1;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\nQ['kpd_coalition_dissent'] = (Q['kpd_coalition_dissent'] || 0) + 1;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) - 5;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 5;\"}],\"content\":{\"content\":\"Cutting taxes improves our relationship with the capitalists.\",\"type\":\"paragraph\"}},\"capital_strike.seize\":{\"id\":\"capital_strike.seize\",\"title\":\"Empower workers to seize the factories!\",\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":\"The bulk of the party does not support this radical action. \",\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"The judiciary would oppose this action. \",\"predicate\":1},\" \",{\"type\":\"conditional\",\"content\":\"If we increased the strength of our paramilitary forces, perhaps we could do this. \",\"predicate\":2},\" \",{\"type\":\"conditional\",\"content\":\"We need the support of the works councils first.\",\"predicate\":3}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['left_strength'] || 0) <= ((Q['reformist_strength'] || 0) + (Q['neorevisionist_strength'] || 0)));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['judicial_reform'] || 0) < 3);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['rb_militancy'] || 0) < 0.25);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['works_councils'] || 0) < 1);\"}}]},\"chooseIf\":{\"$code\":\"return ((((Q['left_strength'] || 0) > ((Q['reformist_strength'] || 0) + (Q['neorevisionist_strength'] || 0))) && ((((Q['judicial_reform'] || 0) >= 3) || ((Q['rb_militancy'] || 0) >= 0.25)))) && ((Q['works_councils'] || 0) >= 1));\"},\"onArrival\":[{\"$code\":\"Q['nationalization_progress'] = (Q['nationalization_progress'] || 0) + 1;\\nQ['coup_progress'] = (Q['coup_progress'] || 0) + 6;\\nQ['unemployed'] = (Q['unemployed'] || 0) - 2;\\n if (((Q['works_councils'] || 0) >= 3) ) { Q['unemployed'] = (Q['unemployed'] || 0) - 1; } \\nQ['works_program'] = (Q['works_program'] || 0) + 1;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (10 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (10 * (1 - (Q['dissent'] || 0)));\\nQ['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 2;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 4;\\nQ['workers_nsdap'] = (Q['workers_nsdap'] || 0) - (8 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_nsdap'] = (Q['unemployed_nsdap'] || 0) - (8 * (1 - (Q['dissent'] || 0)));\\nQ['left_strength'] = (Q['left_strength'] || 0) + 15;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 10;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) - 10;\\nQ['factory_takeovers'] = (Q['factory_takeovers'] || 0) + 1;\"}],\"content\":{\"content\":\"If the capitalists are going to attack us, then we must hit them back. We have empowered the workers to seize and take full control of the factories that the capitalists have idled. The fascists, of course, call us thieves and looters.\",\"type\":\"paragraph\"}},\"centrist_leaders_resign\":{\"id\":\"centrist_leaders_resign\",\"type\":\"scene\",\"title\":\"Centrist leaders resign\",\"newPage\":true,\"subtitle\":\"Centrist disagreements with our policies have grown too severe.\",\"tags\":[\"event\"],\"viewIf\":{\"$code\":\"return ((Q['center_dissent'] || 0) >= 60);\"},\"onArrival\":[{\"$code\":\"Q['center_strength'] = (Q['center_strength'] || 0) * 0.3;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 5;\\n if (((Q['wels_advisor'] || 0) == 1) ) { Q['n_advisors'] = (Q['n_advisors'] || 0) - 1; } \\n if (((Q['hilferding_advisor'] || 0) == 1) ) { Q['n_advisors'] = (Q['n_advisors'] || 0) - 1; } \\n if (((Q['muller_advisor'] || 0) == 1) ) { Q['n_advisors'] = (Q['n_advisors'] || 0) - 1; } \\nQ['wels_advisor'] = 0;\\nQ['hilferding_advisor'] = 0;\\nQ['muller_advisor'] = 0;\\nQ['rb_strength'] = (Q['rb_strength'] || 0) - 100;\\nQ['centrists_resign'] = 1;\"}],\"goTo\":[{\"id\":\"sapd_formed\",\"predicate\":{\"$code\":\"return (((Q['left_split'] || 0)===1) && (!(((Q['sapd_formed'] || 0)) !== 0)));\"}}],\"maxVisits\":1,\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"Centrist leaders resign\"},{\"type\":\"paragraph\",\"content\":\"Our policy choices have greatly offended the Centrist faction. Many of our most experienced leaders have resigned.\"},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":\"Many former Centrist Marxists have joined with the SAPD, the party formed by dissident leftists. They have brought their support base and organization skills to the party, leading to its growth as a nascent rival to the SPD for the support of the working class.\",\"predicate\":0}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['left_split'] || 0)===1);\"}}]},\"countVisitsMax\":1},\"center_party_conference.kaas\":{\"id\":\"center_party_conference.kaas\",\"onArrival\":[{\"$code\":\"Q['z_party_leader'] = \\\"Kaas\\\";\\nQ['z_relation'] = (Q['z_relation'] || 0) - 5;\"}],\"content\":{\"content\":\"Ludwig Kaas has been selected as the chairman of the Center Party. He seems to represent a rightward turn from Marx, and will preside over a Center Party less inclined to compromise with the left.\",\"type\":\"paragraph\"}},\"death_of_levi\":{\"id\":\"death_of_levi\",\"type\":\"scene\",\"title\":\"The Death of Paul Levi\",\"viewIf\":{\"$code\":\"return (((Q['year'] || 0) == 1930) && ((Q['month'] || 0) >= 2));\"},\"frequency\":1000,\"maxVisits\":1,\"onArrival\":[{\"$code\":\"Q['levi_dead'] = 1;\\n if (((Q['levi_advisor'] || 0) == 1) ) { Q['n_advisors'] = (Q['n_advisors'] || 0) - 1; } \\nQ['levi_advisor'] = 0;\"}],\"tags\":[\"event\"],\"content\":{\"content\":\"Paul Levi, a leader of the left wing of our party, has died in an unfortunate accident. He will be missed.\",\"type\":\"paragraph\"},\"countVisitsMax\":1},\"death_of_muller.pm\":{\"id\":\"death_of_muller.pm\",\"onArrival\":[{\"$code\":\"Q['muller_died_in_office'] = 1;\"}],\"options\":[{\"id\":\"@death_of_muller.braun_chancellor\",\"title\":\"Otto Braun (SPD) for Chancellor.\"},{\"id\":\"@death_of_muller.wels_chancellor\",\"title\":\"Otto Wels (SPD) for Chancellor.\"},{\"id\":\"@death_of_muller.breitscheid_chancellor\",\"title\":\"Rudolf Breitscheid (SPD) for Chancellor.\"},{\"id\":\"@death_of_muller.bruning_chancellor\",\"title\":\"Let Heinrich Bruning of the Center Party become Chancellor.\"},{\"id\":\"@death_of_muller.wirth_chancellor\",\"title\":\"Joseph Wirth of the Center Party should be Chancellor.\"}],\"content\":{\"content\":\"Chancellor Hermann Müller has died while in office. He will be greatly missed. But now, we must select a new Chancellor.\",\"type\":\"paragraph\"}},\"civil_war.war_menu\":{\"id\":\"civil_war.war_menu\",\"options\":[{\"id\":\"@civil_war.rw_help\",\"title\":\"Appeal to the Reichswehr to stand down.\"},{\"id\":\"@civil_war.kpd_help\",\"title\":\"Call for support from the Communists.\"},{\"id\":\"@civil_war.general_strike\",\"title\":\"Call a general strike!\"},{\"id\":\"@civil_war.loyal_police\",\"title\":\"Call up the loyal portions of the police.\"},{\"id\":\"@civil_war.war_outcome\",\"title\":\"Now, the battle...\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"death_of_stresemann\":{\"id\":\"death_of_stresemann\",\"type\":\"scene\",\"title\":\"The Death of Gustav Stresemann\",\"viewIf\":{\"$code\":\"return (((Q['year'] || 0)===1929) && ((Q['month'] || 0) >= 9));\"},\"frequency\":1000,\"maxVisits\":1,\"tags\":[\"event\"],\"onArrival\":[{\"$code\":\"Q['stresemann_dead'] = 1;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 5;\"}],\"content\":{\"content\":\"Gustav Stresemann, leader of the DVP, has died. He was the primary force driving the party to support democracy; without him, the democratic forces in the Republic will be so much weaker.\",\"type\":\"paragraph\"},\"countVisitsMax\":1},\"economic_recovery\":{\"id\":\"economic_recovery\",\"type\":\"scene\",\"title\":\"Global Economic Recovery\",\"subtitle\":\"Finally, the world economy is leaving the worst throes of the depression.\",\"viewIf\":{\"$code\":\"return (((Q['year'] || 0)===1933) && ((Q['month'] || 0) >= 6));\"},\"onArrival\":[{\"$code\":\"if (((Q['unemployed'] || 0) > 25) ) { Q['unemployed'] = (Q['unemployed'] || 0) - 3; } \\n if (((Q['unemployed'] || 0) > 15) ) { Q['unemployed'] = (Q['unemployed'] || 0) - 2; } \\n if (((Q['unemployed'] || 0) > 8) ) { Q['unemployed'] = (Q['unemployed'] || 0) - 1; } \\nQ['workers_nsdap'] = (Q['workers_nsdap'] || 0) - 5;\\nQ['unemployed_nsdap'] = (Q['unemployed_nsdap'] || 0) - 5;\\n if (((Q['inflation'] || 0) < 0) ) { Q['inflation'] = (Q['inflation'] || 0) + 1.5; }\"}],\"newPage\":true,\"maxVisits\":1,\"tags\":[\"event\"],\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"Global Economic Recovery\"},{\"type\":\"paragraph\",\"content\":[\"Finally, countries across the world seem to be recovering from the worst effects of the Great Depression. It is an uneven recovery, but we seem to be exiting the worst period of crisis. \",{\"type\":\"conditional\",\"content\":\"Our unemployment has fallen.\",\"predicate\":0}]}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['unemployed'] || 0) >= 10);\"}}]},\"countVisitsMax\":1},\"emergency_cuts.nothing_to_do\":{\"id\":\"emergency_cuts.nothing_to_do\",\"viewIf\":{\"$code\":\"return ((Q['spd_toleration'] || 0) == 0);\"},\"onArrival\":[{\"$code\":\"Q['welfare'] = (Q['welfare'] || 0) - 1;\\nQ['unemployed'] = (Q['unemployed'] || 0) + 2;\\nQ['unemployed_nsdap'] = (Q['unemployed_nsdap'] || 0) + 4;\\nQ['unemployed_kpd'] = (Q['unemployed_kpd'] || 0) + 3;\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + 2;\\nQ['pro_republic'] = (Q['pro_republic'] || 0) - 4;\\nQ['budget'] = (Q['budget'] || 0) + 1;\\nQ['inflation'] = (Q['inflation'] || 0) - 2;\"}],\"content\":{\"content\":\"The emergency policy passes under emergency rules, as the Reichstag is currently dissolved. The Nazis use this as a recruiting tool, and so do we.\",\"type\":\"paragraph\"}},\"high_inflation.taxes\":{\"id\":\"high_inflation.taxes\",\"onArrival\":[{\"$code\":\"Q['upper_tax_rates'] = (Q['upper_tax_rates'] || 0) + 1;\\nQ['lower_tax_rates'] = (Q['lower_tax_rates'] || 0) + 1;\\nQ['budget'] = (Q['budget'] || 0) + 2;\\nQ['unemployed'] = (Q['unemployed'] || 0) + 1.5;\\nQ['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) - 1;\\nQ['inflation'] = (Q['inflation'] || 0) - 1;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) - 3;\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) - 3;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 3;\\nQ['rural_spd'] = (Q['rural_spd'] || 0) - 3;\\nQ['kpd_coalition_dissent'] = (Q['kpd_coalition_dissent'] || 0) + 1;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) - 5;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 5;\"}],\"content\":{\"content\":\"Raising taxes is unpopular among everyone, but it might be what it takes to keep inflation under control.\",\"type\":\"paragraph\"}},\"harzburg_front.strategy\":{\"id\":\"harzburg_front.strategy\",\"viewIf\":{\"$code\":\"return ((Q['nazi_urgency'] || 0) < 3);\"},\"onArrival\":[{\"$code\":\"Q['nazi_urgency'] = (Q['nazi_urgency'] || 0) + 1;\"}],\"content\":{\"content\":\"We do not yet have a coherent strategy for combatting the fascists. We must develop one as soon as possible.\",\"type\":\"paragraph\"}},\"harzburg_front\":{\"id\":\"harzburg_front\",\"type\":\"scene\",\"title\":\"The Harzburg Front\",\"subtitle\":\"The right-wing forces unite against the incumbent government.\",\"newPage\":true,\"onArrival\":[{\"$code\":\"Q['harzburg_front_seen'] = 1;\\nQ['sh_strength'] = (Q['sh_strength'] || 0) + 100;\\nQ['sa_strength'] = (Q['sa_strength'] || 0) + 100;\\nQ['old_middle_nsdap'] = (Q['old_middle_nsdap'] || 0) + 5;\\nQ['unemployed_nsdap'] = (Q['unemployed_nsdap'] || 0) + 5;\\nQ['rural_nsdap'] = (Q['rural_nsdap'] || 0) + 5;\\nQ['nazi_urgency'] = (Q['nazi_urgency'] || 0) + 1;\\nQ['iron_front_timer'] = 0;\"}],\"tags\":[\"event\"],\"viewIf\":{\"$code\":\"return (((((((Q['year'] || 0)===1931) && ((Q['month'] || 0) >= 10)) && (Q['chancellor'] != \\\"Schleicher\\\")) && (Q['chancellor'] != \\\"Papen\\\"))) || (((Q['coup_progress'] || 0) >= 6)));\"},\"maxVisits\":1,\"options\":[{\"id\":\"@harzburg_front.strategy\",\"title\":\"We must develop a coherent strategy to combat the Right.\"},{\"id\":\"@confronting_nazis.iron_front\",\"title\":\"We must form the Iron Front!\"},{\"id\":\"@iron_front\",\"title\":\"The Iron Front will be our answer!\"}],\"content\":[{\"type\":\"heading\",\"content\":\"The Harzburg Front\"},{\"type\":\"paragraph\",\"content\":\"The far-right parties and paramilitaries - the NSDAP (and its paramilitary the SA), the Stahlhelm paramilitary group, and the DNVP - have united to form the Harzburg Front, as a force dedicated to the overthrow of the current government.\"}],\"countVisitsMax\":1},\"election_1928.cancel_elections\":{\"id\":\"election_1928.cancel_elections\",\"title\":\"We cannot hold the elections now. Cancel the elections.\",\"subtitle\":\"This is an anti-democratic move that may backfire.\",\"viewIf\":{\"$code\":\"return ((((Q['in_emergency_government'] || 0) == 1) && (Q['president'] == \\\"Braun\\\")) && (!(((Q['presidential_powers'] || 0)) !== 0)));\"},\"options\":[{\"id\":\"@election_1928.cancel_elections_2\",\"title\":\"Yes, do it.\"},{\"id\":\"@election_algorithm\",\"title\":\"No, let's hold the elections.\"}],\"content\":{\"content\":\"Since we are currently ruling as part of an emergency government, we may use quasi-constitutional trickery to significantly delay these elections, and continue governing via Article 48. This is likely to be extremely unpopular both with our base and with the other parties. However, this may be necessary to prevent the extremists from gaining power.\",\"type\":\"paragraph\"}},\"hitler_chancellor.fight\":{\"id\":\"hitler_chancellor.fight\",\"options\":[{\"id\":\"@civil_war\",\"title\":\"Yes.\"},{\"id\":\"@hitler_chancellor.give_up\",\"title\":\"We are not ready for war. Instead, we will vote against the nazis in the Reichstag.\"}],\"content\":{\"content\":\"Do we realize that this means civil war, against the full force of the state?\",\"type\":\"paragraph\"}},\"hitler_takes_power.fight\":{\"id\":\"hitler_takes_power.fight\",\"options\":[{\"id\":\"@civil_war\",\"title\":\"Yes.\"},{\"id\":\"@hitler_takes_power.give_up\",\"title\":\"We are not ready for war. Instead, we will vote against the nazis in the Reichstag.\"}],\"content\":{\"content\":\"Do we realize that this means civil war, against the full force of the state?\",\"type\":\"paragraph\"}},\"judges_unban_sa\":{\"id\":\"judges_unban_sa\",\"type\":\"scene\",\"title\":\"SA unbanned\",\"subtitle\":\"The judges have re-legalized the SA.\",\"viewIf\":{\"$code\":\"return ((((Q['sa_banned'] || 0) == 1) && ((Q['sa_ban_timer'] || 0) == 0)) && ((Q['judicial_reform'] || 0) < 2));\"},\"onArrival\":[{\"$code\":\"Q['sa_banned'] = 0;\\nQ['sa_strength'] = (Q['sa_strength'] || 0) + 100;\\nQ['sa_militancy'] = (Q['sa_militancy'] || 0) + 0.04;\"}],\"tags\":[\"event\"],\"content\":{\"content\":\"Judges have ordered the Nazi SA to be re-legalized. They immediately return to mass recruiting and arming.\",\"type\":\"paragraph\"}},\"hoover_moratorium\":{\"id\":\"hoover_moratorium\",\"type\":\"scene\",\"title\":\"Hoover Moratorium\",\"subtitle\":\"Owing to the economic crisis, our debt payments have been paused...\",\"newPage\":true,\"viewIf\":{\"$code\":\"return (((((Q['banking_crisis_seen'] || 0)===1) && ((((((Q['year'] || 0) == 1931) && ((Q['month'] || 0) >= 6))) || (((Q['year'] || 0) == 1932))))) && ((Q['reparations'] || 0) >= 0)) && ((Q['unemployed'] || 0) > 15));\"},\"onArrival\":[{\"$code\":\"Q['budget'] = (Q['budget'] || 0) + 1;\\nQ['reparations_negotiation'] = (Q['reparations_negotiation'] || 0) + 2;\\nQ['hoover_moratorium_seen'] = 1;\\n if ((Q['foreign_minister_party'] == \\\"DVP\\\") ) { Q['workers_dvp'] = (Q['workers_dvp'] || 0) + 3; } \\n if ((Q['foreign_minister_party'] == \\\"DVP\\\") ) { Q['new_middle_dvp'] = (Q['new_middle_dvp'] || 0) + 3; } \\n if ((Q['foreign_minister_party'] == \\\"DVP\\\") ) { Q['old_middle_dvp'] = (Q['old_middle_dvp'] || 0) + 3; } \\n if ((Q['foreign_minister_party'] == \\\"DVP\\\") ) { Q['rural_dvp'] = (Q['rural_dvp'] || 0) + 3; } \\n if ((Q['foreign_minister_party'] == \\\"Z\\\") ) { Q['workers_z'] = (Q['workers_z'] || 0) + 3; } \\n if ((Q['foreign_minister_party'] == \\\"Z\\\") ) { Q['new_middle_z'] = (Q['new_middle_z'] || 0) + 3; } \\n if ((Q['foreign_minister_party'] == \\\"Z\\\") ) { Q['old_middle_z'] = (Q['old_middle_z'] || 0) + 3; } \\n if ((Q['foreign_minister_party'] == \\\"Z\\\") ) { Q['rural_z'] = (Q['rural_z'] || 0) + 3; } \\n if ((Q['foreign_minister_party'] == \\\"SPD\\\") ) { Q['workers_spd'] = (Q['workers_spd'] || 0) + 3; } \\n if ((Q['foreign_minister_party'] == \\\"SPD\\\") ) { Q['new_middle_spd'] = (Q['new_middle_spd'] || 0) + 3; } \\n if ((Q['foreign_minister_party'] == \\\"SPD\\\") ) { Q['old_middle_spd'] = (Q['old_middle_spd'] || 0) + 3; } \\n if ((Q['foreign_minister_party'] == \\\"SPD\\\") ) { Q['rural_spd'] = (Q['rural_spd'] || 0) + 3; }\"}],\"tags\":[\"event\"],\"maxVisits\":1,\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"Hoover Moratorium\"},{\"type\":\"paragraph\",\"content\":\"In light of the current economic situation, and the German banking crisis, President Herbert Hoover of the United States has issued a moratorium on war debt payments from the Great War, including Germany's. Our budget situation should improve somewhat.\"},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"Even though this is not our accomplishment, our foreign ministry is eager to take credit for this accomplishment. \",\"predicate\":0},{\"type\":\"conditional\",\"content\":\"Even though this is not the work of the foreign ministry, it is eager to take credit for this accomplishment.\",\"predicate\":1}]}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['spd_in_government'] || 0)) !== 0) && (Q['foreign_minister_party'] == \\\"SPD\\\"));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((!(((Q['spd_in_government'] || 0)) !== 0)) && (Q['foreign_minister_party'] != \\\"SPD\\\"));\"}}]},\"countVisitsMax\":1},\"hunger_chancellor.maintain_toleration\":{\"id\":\"hunger_chancellor.maintain_toleration\",\"subtitle\":\"It is necessary to preserve democracy.\",\"viewIf\":{\"$code\":\"return ((Q['spd_toleration'] || 0) == 1);\"},\"onArrival\":[{\"$code\":\"Q['workers_nsdap'] = (Q['workers_nsdap'] || 0) + 5;\\nQ['workers_kpd'] = (Q['workers_kpd'] || 0) + 5;\\nQ['unemployed_nsdap'] = (Q['unemployed_nsdap'] || 0) + 5;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 5;\\nQ['pro_republic'] = (Q['pro_republic'] || 0) - 5;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) - 5;\"}],\"content\":{\"content\":\"Our policy of toleration continues.\",\"type\":\"paragraph\"}},\"judges_unban_sh\":{\"id\":\"judges_unban_sh\",\"type\":\"scene\",\"title\":\"Stahlhelm unbanned\",\"subtitle\":\"The judges have re-legalized the Stahlhelm.\",\"viewIf\":{\"$code\":\"return ((((Q['sh_banned'] || 0) == 1) && ((Q['sh_ban_timer'] || 0) == 0)) && ((Q['judicial_reform'] || 0) < 2));\"},\"onArrival\":[{\"$code\":\"Q['sh_banned'] = 0;\\nQ['sh_strength'] = (Q['sh_strength'] || 0) + 100;\\nQ['sh_militancy'] = (Q['sh_militancy'] || 0) + 0.01;\"}],\"tags\":[\"event\"],\"content\":{\"content\":\"Judges have ordered the Stahlhelm to be re-legalized. They immediately return to mass recruiting.\",\"type\":\"paragraph\"}},\"kpd_goals_2\":{\"id\":\"kpd_goals_2\",\"type\":\"scene\",\"title\":\"The KPD presents its list of goals for the coalition.\",\"viewIf\":{\"$code\":\"return ((((((((Q['in_popular_front'] || 0)===1) || ((Q['in_left_front'] || 0)===1))) && ((Q['kpd_goals_seen'] || 0)===0)) && ((Q['kpd_coalition_success'] || 0)===1)) && (((Q['next_election_time'] || 0) - (Q['time'] || 0)) > 12)) && (((Q['spd_in_government'] || 0)) !== 0));\"},\"onArrival\":[{\"$code\":\"Q['kpd_goals_seen'] = 1;\\nQ['agriculture_goal'] = 1;\\nQ['economy_goal'] = 1;\\nQ['labor_goal'] = 1;\\nQ['foreign_goal'] = 1;\\nQ['welfare_goal'] = 0;\\nQ['finance_goal'] = 0;\\nQ['kpd_ultimatum_timer'] = 16;\\n if (((Q['kpd_relation'] || 0) >= 60) ) { Q['kpd_ultimatum_timer'] = 20; } \\n if ((Q['kpd_party_leader'] == \\\"Conciliators\\\") ) { Q['kpd_ultimatum_timer'] = 24; } \\n if ((((Q['next_election_time'] || 0) - (Q['time'] || 0)) <= 12) ) { Q['kpd_ultimatum_timer'] = (((Q['next_election_time'] || 0) - (Q['time'] || 0)) - 1); }\"}],\"newPage\":true,\"tags\":[\"event\"],\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"KPD Goals\"},{\"type\":\"paragraph\",\"content\":\"The KPD presents us with a new list of goals for the coalition:\"},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"- Expand social welfare programs. \",\"predicate\":0},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"- Continue the land reform program. \",\"predicate\":1},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"- Further nationalization of the economy. \",\"predicate\":2},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"- Make taxes more progressive. \",\"predicate\":3},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"- Continue to support workers in labor disputes. \",\"predicate\":4},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"- Improve our relations with the Soviet Union. \",\"predicate\":5},\"\"]},{\"type\":\"paragraph\",\"content\":[\"They say that they expect to see these goals fulfilled in \",{\"type\":\"insert\",\"insert\":6},\" months. Otherwise, they will vote to dissolve the coalition.\"]}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['welfare_goal'] || 0)===1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['agriculture_goal'] || 0)===1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['economy_goal'] || 0)===1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['finance_goal'] || 0)===1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['labor_goal'] || 0)===1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['foreign_goal'] || 0)===1);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['kpd_ultimatum_timer'] || 0);\"}}]}},\"kpd_conference.conciliator_success\":{\"id\":\"kpd_conference.conciliator_success\",\"title\":\"The Conciliators are the new leadership of the KPD.\",\"chooseIf\":{\"$code\":\"return (((((((Q['levi_advisor'] || 0)) !== 0) || (((Q['rosenfeld_advisor'] || 0)) !== 0))) && (((Q['left_strength'] || 0) >= (Q['reformist_strength'] || 0)))) && (((Q['kpd_relation'] || 0) >= 50)));\"},\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":\"Our party leadership is not left-wing enough. \",\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"The Comintern doubts our commitment to socialism.\",\"predicate\":1}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((!(((Q['levi_advisor'] || 0)) !== 0)) && (!(((Q['rosenfeld_advisor'] || 0)) !== 0)));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['left_strength'] || 0) < (Q['reformist_strength'] || 0));\"}}]},\"onArrival\":[{\"$code\":\"Q['kpd_party_leader'] = \\\"Conciliators\\\";\\nQ['communist_coalition'] = (Q['communist_coalition'] || 0) + 3;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) + (10 * (1 - (Q['dissent'] || 0)));\\nQ['left_strength'] = (Q['left_strength'] || 0) + 5;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) - 8;\"}],\"achievement\":\"versohnler\",\"content\":{\"content\":\"With our support, the Conciliators have won the leadership contest! The new leadership is a group of Conciliators, including Arthur Ewert, Hugo Eberlein, and Ernst Meyer. Thälmann remains, but largely as a figurehead only, it seems. We hope that the new leadership will be more inclined towards cooperation.\",\"type\":\"paragraph\"}},\"kpd_policy.labor\":{\"id\":\"kpd_policy.labor\",\"title\":\"Labor Ministry\",\"subtitle\":\"The Labor Ministry is giving significant concessions to organized labor.\",\"viewIf\":{\"$code\":\"return (Q['labor_minister_party'] == \\\"KPD\\\");\"},\"options\":[{\"id\":\"@kpd_policy.labor_support\",\"title\":\"Of course we support labor.\"},{\"id\":\"@kpd_policy.labor_oppose\",\"title\":\"No, this is too radical.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"The KPD-controlled Labor Ministry is taking a policy of supporting labor in every dispute between workers and employees, leading to a proliferation of strikes across the country. Given the economic circumstances, there are worries that this could harm any potential economic recovery, not to mention the conflicts this may engender with the bourgeois parties.\"},{\"type\":\"paragraph\",\"content\":\"Do we support their radical labor policy?\"}]},\"kpd_goals\":{\"id\":\"kpd_goals\",\"type\":\"scene\",\"title\":\"The KPD presents its list of goals for the coalition.\",\"viewIf\":{\"$code\":\"return ((((((((Q['in_popular_front'] || 0)===1) || ((Q['in_left_front'] || 0)===1))) && ((Q['kpd_goals_seen'] || 0)===0)) && ((Q['kpd_coalition_success'] || 0)===0)) && (((Q['next_election_time'] || 0) - (Q['time'] || 0)) > 12)) && (((Q['spd_in_government'] || 0)) !== 0));\"},\"onArrival\":[{\"$code\":\"Q['kpd_goals_seen'] = 1;\\nQ['welfare_goal'] = 1;\\nQ['foreign_goal'] = 0;\\n if ((Q['agriculture_minister_party'] != \\\"KPD\\\") ) { Q['agriculture_goal'] = 1; } \\n if ((Q['economy_minister_party'] != \\\"KPD\\\") ) { Q['economy_goal'] = 1; } \\n if ((Q['finance_minister_party'] != \\\"KPD\\\") ) { Q['finance_goal'] = 1; } \\n if ((Q['labor_minister_party'] != \\\"KPD\\\") ) { Q['labor_goal'] = 1; } \\n if ((Q['reichswehr_minister_party'] != \\\"KPD\\\") ) { Q['reichswehr_goal'] = 1; } \\nQ['kpd_ultimatum_timer'] = 12;\\n if (((Q['kpd_relation'] || 0) >= 60) ) { Q['kpd_ultimatum_timer'] = 16; } \\n if (((Q['kpd_party_leader'] == \\\"Conciliators\\\") || (((Q['constructive_vonc'] || 0)) !== 0)) ) { Q['kpd_ultimatum_timer'] = 24; } \\n if ((((Q['next_election_time'] || 0) - (Q['time'] || 0)) <= 12) ) { Q['kpd_ultimatum_timer'] = (((Q['next_election_time'] || 0) - (Q['time'] || 0)) - 1); }\"}],\"newPage\":true,\"tags\":[\"event\"],\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"KPD Goals\"},{\"type\":\"paragraph\",\"content\":\"The KPD presents us with a list of goals for the coalition:\"},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"- Expand social welfare programs. \",\"predicate\":0},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"- Enact a land reform program. \",\"predicate\":1},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"- Start substantial nationalization of the economy. \",\"predicate\":2},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"- Make taxes more progressive. \",\"predicate\":3},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"- Support workers in labor disputes. \",\"predicate\":4},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"- Improve our relations with the Soviet Union. \",\"predicate\":5},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"- Reduce funding for the Reichswehr. \",\"predicate\":6},\"\"]},{\"type\":\"paragraph\",\"content\":[\"They say that they expect to see these goals fulfilled in \",{\"type\":\"insert\",\"insert\":7},\" months. Otherwise, they will vote to dissolve the coalition.\"]}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['welfare_goal'] || 0)===1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['agriculture_goal'] || 0)===1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['economy_goal'] || 0)===1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['finance_goal'] || 0)===1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['labor_goal'] || 0)===1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['foreign_goal'] || 0)===1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['reichswehr_goal'] || 0)===1);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['kpd_ultimatum_timer'] || 0);\"}}]}},\"kpd_ultimatum.goals_failed\":{\"id\":\"kpd_ultimatum.goals_failed\",\"onArrival\":[{\"$code\":\"Q['kpd_relation'] = (Q['kpd_relation'] || 0) - 10;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 8;\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) - 8;\"}],\"options\":[{\"id\":\"@kpd_ultimatum.appeal\",\"title\":\"Appeal to the Communists to have patience - we are trying!\"},{\"id\":\"@kpd_vote_of_no_confidence.support_center\",\"title\":\"Could we form a new government based on the Center Party and DDP (and possibly DVP)?\"},{\"id\":\"@kpd_vote_of_no_confidence.let_it_happen\",\"title\":\"Let the vote happen.\"},{\"id\":\"@kpd_ultimatum.no_vonc\",\"title\":\"They cannot call a vote of no confidence due to the constitutional reforms, but they can obstruct our government at every opportunity.\"}],\"content\":{\"content\":\"Unfortunately, we have failed to accomplish all of the goals the KPD set out. They plan to call a vote of no confidence against our government, and have already begun mounting a propaganda campaign to delegitimize our government in the eyes of the workers.\",\"type\":\"paragraph\"}},\"labor_unrest.support_labor\":{\"id\":\"labor_unrest.support_labor\",\"subtitle\":\"This will alienate the bourgeoisie.\",\"onArrival\":[{\"$code\":\"Q['labor_strength'] = (Q['labor_strength'] || 0) + 5;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) - 5;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) - 5;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (6 * (1 - (Q['dissent'] || 0)));\\nQ['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 4;\\n if (((Q['dvp_relation'] || 0) <= 30) ) { Q['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) + 1; } \\n if (((Q['unemployed'] || 0) > 15) ) { Q['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) + 1; } \\n if (((Q['unemployed'] || 0) > 24) ) { Q['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) + 1; } \\nQ['labor_goal_completed'] = (Q['labor_goal_completed'] || 0) + 1;\\nQ['inflation'] = (Q['inflation'] || 0) + 0.1;\"}],\"content\":{\"content\":\"Supporting labor is always popular in the SPD, although many of our coalition partners represent employers, and they are less enthused.\",\"type\":\"paragraph\"}},\"kpd_vote_of_no_confidence.menu\":{\"id\":\"kpd_vote_of_no_confidence.menu\",\"options\":[{\"id\":\"@kpd_vote_of_no_confidence.try_assuage\",\"title\":\"Try to assuage them somehow.\"},{\"id\":\"@kpd_vote_of_no_confidence.support_center\",\"title\":\"Could we form a new government based on the Center Party and DDP (and possibly DVP)?\"},{\"id\":\"@kpd_vote_of_no_confidence.let_it_happen\",\"title\":\"Let the vote happen.\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"lausanne_conference\":{\"id\":\"lausanne_conference\",\"type\":\"scene\",\"title\":\"Lausanne Conference\",\"subtitle\":\"On the question of reparations...\",\"viewIf\":{\"$code\":\"return ((((((Q['year'] || 0)===1932) && ((Q['month'] || 0) >= 6)) && ((Q['hoover_moratorium_seen'] || 0)===1)) && ((Q['reparations'] || 0) > -2)) && ((Q['unemployed'] || 0) >= 15));\"},\"onArrival\":[{\"$code\":\"Q['reparations'] = -2;\\nQ['budget'] = (Q['budget'] || 0) + 1;\\n if ((Q['foreign_minister_party'] == \\\"DVP\\\") ) { Q['workers_dvp'] = (Q['workers_dvp'] || 0) + 3; } \\n if ((Q['foreign_minister_party'] == \\\"DVP\\\") ) { Q['new_middle_dvp'] = (Q['new_middle_dvp'] || 0) + 3; } \\n if ((Q['foreign_minister_party'] == \\\"DVP\\\") ) { Q['old_middle_dvp'] = (Q['old_middle_dvp'] || 0) + 3; } \\n if ((Q['foreign_minister_party'] == \\\"DVP\\\") ) { Q['rural_dvp'] = (Q['rural_dvp'] || 0) + 3; } \\n if ((Q['foreign_minister_party'] == \\\"Z\\\") ) { Q['workers_z'] = (Q['workers_z'] || 0) + 3; } \\n if ((Q['foreign_minister_party'] == \\\"Z\\\") ) { Q['new_middle_z'] = (Q['new_middle_z'] || 0) + 3; } \\n if ((Q['foreign_minister_party'] == \\\"Z\\\") ) { Q['old_middle_z'] = (Q['old_middle_z'] || 0) + 3; } \\n if ((Q['foreign_minister_party'] == \\\"Z\\\") ) { Q['rural_z'] = (Q['rural_z'] || 0) + 3; } \\n if ((Q['foreign_minister_party'] == \\\"SPD\\\") ) { Q['workers_spd'] = (Q['workers_spd'] || 0) + 3; } \\n if ((Q['foreign_minister_party'] == \\\"SPD\\\") ) { Q['new_middle_spd'] = (Q['new_middle_spd'] || 0) + 3; } \\n if ((Q['foreign_minister_party'] == \\\"SPD\\\") ) { Q['old_middle_spd'] = (Q['old_middle_spd'] || 0) + 3; } \\n if ((Q['foreign_minister_party'] == \\\"SPD\\\") ) { Q['rural_spd'] = (Q['rural_spd'] || 0) + 3; }\"}],\"newPage\":true,\"maxVisits\":1,\"tags\":[\"event\"],\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"Lausanne Conference\"},{\"type\":\"paragraph\",\"content\":\"At the Lausanne Conference, the Allies have met with Germany's representatives in order to deal with the issue of war reparations once and for all. In light of the current economic crisis, the Allies believe that Germany is unable to make the reparation payments.\"},{\"type\":\"paragraph\",\"content\":[\"Therefore, our reparations have been paused indefinitely! This should reduce the strain on our budget. \",{\"type\":\"conditional\",\"content\":\"Even though this is not our accomplishment, our foreign ministry is eager to take credit for this accomplishment. \",\"predicate\":0},{\"type\":\"conditional\",\"content\":\"Even though this is not the work of the foreign ministry, it is eager to take credit for this accomplishment.\",\"predicate\":1}]}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['spd_in_government'] || 0)) !== 0) && (Q['foreign_minister_party'] == \\\"SPD\\\"));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((!(((Q['spd_in_government'] || 0)) !== 0)) && (Q['foreign_minister_party'] != \\\"SPD\\\"));\"}}]},\"countVisitsMax\":1},\"left_split\":{\"id\":\"left_split\",\"type\":\"scene\",\"title\":\"Left-wing Split\",\"newPage\":true,\"subtitle\":\"The Left's disagreements with our policies have grown too severe.\",\"tags\":[\"event\"],\"viewIf\":{\"$code\":\"return ((Q['left_dissent'] || 0) >= 60);\"},\"onArrival\":[{\"$code\":\"Q['left_split'] = 1;\\nQ['left_strength'] = ((Q['left_strength'] || 0) / 2);\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 5;\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) - 5;\\nQ['workers_other'] = (Q['workers_other'] || 0) + 5;\\nQ['workers_kpd'] = (Q['workers_kpd'] || 0) + 3;\\n if (((Q['levi_advisor'] || 0) == 1) ) { Q['n_advisors'] = (Q['n_advisors'] || 0) - 1; } \\nQ['levi_advisor'] = 0;\\nQ['rb_strength'] = (Q['rb_strength'] || 0) - 300;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) - 5;\\n if (((Q['rb_militancy'] || 0) >= 0.1) ) { Q['rb_militancy'] = (Q['rb_militancy'] || 0) - 0.05; } \\n if (((Q['seydewitz_advisor'] || 0) == 1) ) { Q['n_advisors'] = (Q['n_advisors'] || 0) - 1; } \\nQ['seydewitz_advisor'] = 0;\\n if (((Q['rosenfeld_advisor'] || 0) == 1) ) { Q['n_advisors'] = (Q['n_advisors'] || 0) - 1; } \\nQ['rosenfeld_advisor'] = 0;\"}],\"goTo\":[{\"id\":\"sapd_formed\",\"predicate\":{\"$code\":\"return (((Q['centrists_resign'] || 0)===1) && (!(((Q['sapd_formed'] || 0)) !== 0)));\"}}],\"maxVisits\":1,\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"Left-wing members split\"},{\"type\":\"paragraph\",\"content\":\"Our policy choices have greatly offended the left, and many of their leaders have split to form a new party, the SAPD, or Socialist Worker's Party. They do not count a huge section of our membership, so this should be survivable.\"},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":\"Many former Centrist Marxists have joined with the SAPD, the party formed by dissident leftists. They have brought their support base and organization skills to the party, leading to its growth as a nascent rival to the SPD for the support of the working class.\",\"predicate\":0}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['centrists_resign'] || 0)===1);\"}}]},\"countVisitsMax\":1},\"march_on_berlin.non_govt_menu\":{\"id\":\"march_on_berlin.non_govt_menu\",\"options\":[{\"id\":\"@march_on_berlin.fight\"},{\"id\":\"@march_on_berlin.accept\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"It appears that President \",{\"type\":\"insert\",\"insert\":0},\" is looking favorably upon the fascist proposals. Chancellor \",{\"type\":\"insert\",\"insert\":1},\" has announced plans to resign.\"]},\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['president'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor'] || 0);\"}}]}},\"nazis_in_crisis.celebrate\":{\"id\":\"nazis_in_crisis.celebrate\",\"content\":{\"content\":\"This is an occasion to celebrate! Hopefully he Nazis will no longer be a threat to the Republic.\",\"type\":\"paragraph\"}},\"panzerkreuzer.vote_yes\":{\"id\":\"panzerkreuzer.vote_yes\",\"onArrival\":[{\"$code\":\"Q['left_dissent'] = (Q['left_dissent'] || 0) + 10;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) + 5;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) + 5;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 5;\\nQ['neorevisionist_dissent'] = (Q['neorevisionist_dissent'] || 0) + 5;\\nQ['panzerkreuzer_funded'] = 1;\\nQ['kpd_coalition_dissent'] = (Q['kpd_coalition_dissent'] || 0) + 1;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) - 6;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 3;\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"Our grassroots party members are shocked by our intransigence! Many party branches have begun agitating against the cabinet, and our Reichstag members even plan a full vote on the proposal, contravening the government's decision.\"},{\"type\":\"paragraph\",\"content\":\"The campaign against the battlecruiser fails, with only the dissident SPD and KPD members voting against. The ship will be built.\"}]},\"constitutional_reform.reforms_menu\":{\"id\":\"constitutional_reform.reforms_menu\",\"options\":[{\"id\":\"@constitutional_reform.vote_threshold\",\"title\":\"Change the vote threshold.\"},{\"id\":\"@constitutional_reform.constructive_vonc\",\"title\":\"Ban non-constructive votes of no confidence.\"},{\"id\":\"@constitutional_reform.presidential_powers\",\"title\":\"Reduce presidential powers.\"},{\"id\":\"@constitutional_reform.as_is\",\"title\":\"Do not pursue constitutional reform.\"},{\"id\":\"@easy_discard\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"popular_front_dispute.labor\":{\"id\":\"popular_front_dispute.labor\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"papen_chancellor\":{\"id\":\"papen_chancellor\",\"type\":\"scene\",\"title\":{\"content\":[\"Chancellor \",{\"type\":\"insert\",\"insert\":0},\" replaced by Franz von Papen\"],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor'] || 0);\"}}]},\"subtitle\":\"President Hindenburg dismisses the government.\",\"viewIf\":{\"$code\":\"return ((((((((Q['chancellor'] == \\\"Brüning\\\") || (Q['chancellor'] == \\\"Wirth\\\"))) && ((((((Q['year'] || 0)===1932) && ((Q['month'] || 0) >= 5))) || ((Q['year'] || 0) >= 1933)))) && (Q['president'] == \\\"Hindenburg\\\")) && ((Q['spd_in_government'] || 0)===0)) && (((((((Q['grand_coalition'] || 0) < 50) || (Q['largest_party'] == \\\"NSDAP\\\")) || ((Q['strife'] || 0) > 6)) || (((((Q['nsdap_votes'] || 0) + (Q['dnvp_votes'] || 0)) + (Q['kpd_votes'] || 0)) >= 50))) || ((Q['unemployed'] || 0) >= 30)))) && (!(((Q['presidential_powers'] || 0)) !== 0)));\"},\"onArrival\":[{\"$code\":\"Q['old_chancellor'] = (Q['chancellor'] || 0);\\nQ['spd_toleration'] = 0;\\nQ['chancellor'] = \\\"Papen\\\";\\nQ['chancellor_party'] = \\\"I\\\";\\n if (((Q['next_election_time'] || 0) >= ((Q['time'] || 0) + 3)) ) { Q['next_election_time'] = ((Q['time'] || 0) + 3); } \\n if (((Q['next_election_time'] || 0) >= ((Q['time'] || 0) + 3)) ) { Q['next_election_month'] = ((Q['month'] || 0) + 3); } \\n if (((Q['next_election_time'] || 0) >= ((Q['time'] || 0) + 3)) ) { Q['next_election_year'] = (Q['year'] || 0); } \\n if (((Q['next_election_month'] || 0) > 12) ) { Q['next_election_year'] = (Q['next_election_year'] || 0) + 1; } \\n if (((Q['next_election_month'] || 0) > 12) ) { Q['next_election_month'] = (Q['next_election_month'] || 0) - 12; } \\n if (((Q['judicial_reform'] || 0) >= 2) ) { Q['judicial_reform'] = (Q['judicial_reform'] || 0) - 2; } \\nQ['finance_minister_party'] = \\\"I\\\";\\nQ['interior_minister_party'] = \\\"I\\\";\\nQ['economy_minister_party'] = \\\"I\\\";\\nQ['labor_minister_party'] = \\\"I\\\";\\nQ['foreign_minister_party'] = \\\"I\\\";\\nQ['agriculture_minister_party'] = \\\"I\\\";\\nQ['reichswehr_minister'] = \\\"I\\\";\"}],\"newPage\":true,\"tags\":[\"event\"],\"maxVisits\":1,\"faceImage\":\"img/portraits/PapenFranz.jpg\",\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[\"President Hindenburg's secretive group of advisors (often called the \\\"camarilla\\\") has turned against \",{\"type\":\"insert\",\"insert\":0},\", and Hindenburg his dismissed the Chancellor, replacing him with the more reactionary Franz von Papen, an independent formerly of the Center Party. \",{\"type\":\"conditional\",\"content\":\"Brüning's final straw was his \\\"agricultural settlement\\\" policy, sending unemployed workers to homestead in underutilized lands (that happen to be owned by aristocrats). \",\"predicate\":1},\" \",{\"type\":\"conditional\",\"content\":\"Seeing the chaos that has gripped the country, Hindenburg's advisors seem to believe that the country needs stronger, more authoritarian rulers, and they see Papen as that kind of ruler. \",\"predicate\":2},\"\"]},{\"type\":\"paragraph\",\"content\":\"Papen is immediately faced with a vote of no confidence, given his unpopularity. However the SPD votes, he is guaranteed to fall, due to the unanimous hatred against him from all other parties. Meanwhile, he is governing via emergency powers with Hindenburg. His first policy is to legalize the Nazi SA, but this does not win their loyalty.\"},{\"type\":\"paragraph\",\"content\":[\"New elections have been set for \",{\"type\":\"insert\",\"insert\":3},\" \",{\"type\":\"insert\",\"insert\":4},\".\"]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['old_chancellor'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['year'] || 0) == 1932) && (Q['old_chancellor'] == \\\"Brüning\\\"));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['strife'] || 0) > 6);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_month'] || 0);\"},\"qdisplay\":\"month\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_year'] || 0);\"}}]},\"countVisitsMax\":1},\"presidential_election_1932.pres_election\":{\"id\":\"presidential_election_1932.pres_election\",\"options\":[{\"id\":\"@presidential_election_1932.support_hindenburg\",\"title\":\"Support Hindenburg.\"},{\"id\":\"@presidential_election_1932.support_braun\",\"title\":\"Run Otto Braun of the SPD.\"},{\"id\":\"@presidential_election_1932.support_thalmann\",\"title\":\"Support Ernst Thälmann of the KPD.\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[\"The presidential election is coming up soon. \",{\"type\":\"conditional\",\"content\":\"While the position of Chancellor is typically more important, recent governments have depended on the president's emergency decree powers, making the office vital. \",\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"The Nazis will run Hitler, while the KPD will run Thälmann. A victory for Hitler would mean the end of parliamentary democracy, and the beginning of an era of unspeakable horrors. \",\"predicate\":1},{\"type\":\"conditional\",\"content\":\"Since Hitler has been deported, the Nazis will run Hermann Göring in his stead. He is widely seen as a proxy for Hitler, who, despite his legal persecution, retains a popular base who wishes to see him returned to Germany. Meanwhile, the KPD will run Ernst Thälmann. \",\"predicate\":2},\" \",{\"type\":\"conditional\",\"content\":\"The SAPD, our former leftists, are supporting Thälmann of the KPD, and will likely share an endorsement with the Communists. \",\"predicate\":3},\"\"]},{\"type\":\"paragraph\",\"content\":\"Many are calling for us to support the incumbent Hindenburg, despite his well-known reactionary tendencies. Is he truly the best bulwark against Hitler's ascension? On the other hand, many in our party are calling for Otto Braun to run again, but he is reluctant.\"},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":\"Another strange possibilty is an united front with the Communists, either to support Thälmann or our own candidate.\",\"predicate\":4}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['spd_in_government'] || 0)===0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['hitler_deported'] || 0) == 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['hitler_deported'] || 0) == 1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['sapd_formed'] || 0)) !== 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['kpd_relation'] || 0) >= 50);\"}}]}},\"prussian_coup.defend\":{\"id\":\"prussian_coup.defend\",\"title\":\"Fight against the overthrow attempt!\",\"subtitle\":\"Labor will call a general strike. The Reichsbanner and the loyal elements of the Prussian police will resist the coup.\",\"unavailableSubtitle\":\"We do not have the forces to resist.\",\"chooseIf\":{\"$code\":\"return (((Q['rb_strength'] || 0) * (Q['rb_militancy'] || 0)) >= 200);\"},\"options\":[{\"id\":\"@prussian_coup.defend_2\",\"title\":\"We will fight, even if it leads to a civil war.\"},{\"id\":\"@prussian_coup.surrender\"}],\"content\":{\"content\":\"The Reichswehr and Stahlhelm are already surrounding Berlin, and the SA is supporting them. This could be civil war. We do realize that, correct?\",\"type\":\"paragraph\"}},\"reichsbanner_zentrum.let_go\":{\"id\":\"reichsbanner_zentrum.let_go\",\"onArrival\":[{\"$code\":\"Q['rb_strength'] = (Q['rb_strength'] || 0) * 0.9;\\nQ['z_relation'] = (Q['z_relation'] || 0) - 5;\\nQ['ddp_relation'] = (Q['ddp_relation'] || 0) - 5;\\nQ['rb_exit'] = 1;\\nQ['left_strength'] = (Q['left_strength'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\"}],\"content\":{\"content\":\"We have judged that the Reichsbanner's militancy is more important than maintaining a coalition with the Center Party and DDP. The Reichsbanner members affiliated with these parties leave, while the left of the SPD is strengthened.\",\"type\":\"paragraph\"}},\"panzerkreuzer_b.vote_yes\":{\"id\":\"panzerkreuzer_b.vote_yes\",\"onArrival\":[{\"$code\":\"Q['left_dissent'] = (Q['left_dissent'] || 0) + 10;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) + 5;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) + 5;\\n if ((!(((Q['panzerkreuzer_funded'] || 0)) !== 0)) ) { Q['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 5; } \\n if ((!(((Q['panzerkreuzer_funded'] || 0)) !== 0)) ) { Q['neorevisionist_dissent'] = (Q['neorevisionist_dissent'] || 0) + 5; } \\nQ['panzerkreuzer_b_funded'] = 1;\\nQ['kpd_coalition_dissent'] = (Q['kpd_coalition_dissent'] || 0) + 1;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) - 6;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 4;\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[\"Our grassroots party members are highly critical of our decision. Many party branches have increased their agitation against our parliamentary fraction. \",{\"type\":\"conditional\",\"content\":\"However, given the construction of the previous battlecruiser, this seemed to be a foregone conclusion, and the reaction is muted. \",\"predicate\":0},\"\"]},{\"type\":\"paragraph\",\"content\":\"The vote in favor of the battlecruiser easily passes, with opposition only from the KPD. The ship will be built.\"}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['panzerkreuzer_funded'] || 0)) !== 0);\"}}]}},\"reformist_leaders_resign\":{\"id\":\"reformist_leaders_resign\",\"type\":\"scene\",\"title\":\"Reformist leaders resign\",\"newPage\":true,\"subtitle\":\"Reformist disagreements with our policies have grown too severe.\",\"tags\":[\"event\"],\"viewIf\":{\"$code\":\"return ((Q['reformist_dissent'] || 0) >= 60);\"},\"onArrival\":[{\"$code\":\"Q['reformist_strength'] = (Q['reformist_strength'] || 0) * 0.3;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 10;\\nQ['workers_others'] = (Q['workers_others'] || 0) + 5;\\n if (((Q['braun_advisor'] || 0) == 1) ) { Q['n_advisors'] = (Q['n_advisors'] || 0) - 1; } \\n if (((Q['severing_advisor'] || 0) == 1) ) { Q['n_advisors'] = (Q['n_advisors'] || 0) - 1; } \\nQ['braun_advisor'] = 0;\\nQ['severing_advisor'] = 0;\\nQ['rb_strength'] = (Q['rb_strength'] || 0) - 250;\\nQ['reformists_resign'] = 1;\"}],\"maxVisits\":1,\"content\":[{\"type\":\"heading\",\"content\":\"Reformist leaders resign\"},{\"type\":\"paragraph\",\"content\":\"Our policy choices have greatly offended the reformist faction. Many of our most experienced leaders have resigned.\"}],\"countVisitsMax\":1},\"sapd_formed\":{\"id\":\"sapd_formed\",\"type\":\"scene\",\"onArrival\":[{\"$code\":\"// set up the infrastructure\\nQ.sapd_formed = 1;\\nQ.parties.push('sapd');\\n\\nQ.workers_sapd = 10;\\nQ.workers_spd -= 3;\\nQ.new_middle_sapd = 1;\\nQ.old_middle_sapd = 0;\\nQ.rural_sapd = 0;\\nQ.unemployed_sapd = 2;\\nQ.catholics_sapd = 0;\\n\\nQ.workers_other -= 5;\\n\\nif (Q.unions_independent) {\\n    Q.workers_sapd += 8;\\n}\\n\\n// update all records\\nQ.sapd_r = 0;\\nQ.old_sapd_r = 0;\\nfor (var record of Q.election_records) {\\n    record['sapd'] = 0;\\n}\\nfor (var record of Q.party_support_records) {\\n    record['sapd'] = 0;\\n}\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"schleichers_schemes\":{\"id\":\"schleichers_schemes\",\"type\":\"scene\",\"title\":\"Schleicher's Schemes\",\"subtitle\":\"Chancellor Schleicher claims to have a plan to save Germany...\",\"viewIf\":{\"$code\":\"return ((((((((Q['year'] || 0) >= 1932) && (Q['president'] == \\\"Hindenburg\\\")) && (Q['chancellor'] == \\\"Schleicher\\\")) && ((Q['spd_in_government'] || 0)===0)) && (Q['largest_party'] == \\\"NSDAP\\\")) && ((Q['hitler_deported'] || 0)===0)) && (!(((Q['presidential_powers'] || 0)) !== 0)));\"},\"newPage\":true,\"maxVisits\":1,\"content\":[{\"type\":\"heading\",\"content\":\"Schleicher's Schemes\"},{\"type\":\"paragraph\",\"content\":\"Chancellor Kurt von Schleicher claims to have a plan to save Germany, and he has reached out to the Social Democrats with vague promises. He claims that in order to govern, the Reichstag must be temporarily suspended to prevent the Nazis and Communists from disrupting government. He argues that his public works program and job creation plans will stabilize the economy,\"},{\"type\":\"paragraph\",\"content\":\"Rumors are that he is also reaching out to the Nazis with similar promises of cooperation. In addition, working with Schleicher would essentially mean the end of our claim to be a \\\"democratic\\\" party.\"}],\"countVisitsMax\":1},\"panzerkreuzer_ministry.vote_yes\":{\"id\":\"panzerkreuzer_ministry.vote_yes\",\"onArrival\":[{\"$code\":\"Q['left_dissent'] = (Q['left_dissent'] || 0) + 10;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) + 10;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) + 5;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 5;\\nQ['neorevisionist_dissent'] = (Q['neorevisionist_dissent'] || 0) + 5;\\nQ['reichswehr_loyalty'] = (Q['reichswehr_loyalty'] || 0) + 0.1;\\nQ['panzerkreuzer_funded'] = 1;\"}],\"content\":{\"content\":\"We have pleased the military by supporting the construction of the battlecruiser. However, our grassroots party members are shocked by our intransigence! Many party branches have begun agitating against the Reichstag delegation.\",\"type\":\"paragraph\"}},\"schacht_vs_hilferding.expose_him\":{\"id\":\"schacht_vs_hilferding.expose_him\",\"viewIf\":{\"$code\":\"return ((Q['investigate_far_right'] || 0) >= 1);\"},\"content\":{\"content\":\"We expose to the public Schacht's dealings with the Nazis. For better or worse, he is cowed, and refrains from taking further actions against us.\",\"type\":\"paragraph\"}},\"unemployment_insurance_1.tax_rich\":{\"id\":\"unemployment_insurance_1.tax_rich\",\"maxVisits\":1,\"goTo\":[{\"id\":\"unemployment_insurance_1.what_do\"}],\"content\":{\"content\":\"The bourgeois parties, as representatives of the rich industrialists, would not have that.\",\"type\":\"paragraph\"},\"countVisitsMax\":1},\"unemployment_insurance_weimar.cut_benefits\":{\"id\":\"unemployment_insurance_weimar.cut_benefits\",\"subtitle\":\"The workers will regard this as a betrayal.\",\"onArrival\":[{\"$code\":\"Q['workers_spd'] = (Q['workers_spd'] || 0) - (0.12 * (Q['workers_spd'] || 0));\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) - (0.2 * (Q['unemployed_spd'] || 0));\\nQ['workers_kpd'] = (Q['workers_kpd'] || 0) + 6;\\nQ['workers_nsdap'] = (Q['workers_nsdap'] || 0) + 6;\\nQ['unemployed_kpd'] = (Q['unemployed_kpd'] || 0) + 5;\\nQ['unemployed_nsdap'] = (Q['unemployed_nsdap'] || 0) + 5;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 15;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) + 10;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) + 15;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 5;\\nQ['welfare'] = (Q['welfare'] || 0) - 2;\\nQ['budget'] = (Q['budget'] || 0) + 1;\\nQ['unemployed'] = (Q['unemployed'] || 0) + 3;\\nQ['pro_republic'] = (Q['pro_republic'] || 0) - 4;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) - 8;\\nQ['inflation'] = (Q['inflation'] || 0) - 2;\\nQ['unemployment_insurance_threshold'] = (Q['unemployed'] || 0);\\nQ['unemployment_insurance_timer'] = 10;\"}],\"content\":{\"content\":\"For budgetary reasons, we have cut unemployment insurance benefits. Unfortunately, our reasons for fiscal discipline are alien to the workers. They are furious at our betrayal, as are a good portion of our membership throughout the factions. Our loss is the KPD's gain, and even the NSDAP, those lapdogs of the bourgeoisie, have joined in criticizing us for our austerity.\",\"type\":\"paragraph\"}},\"vote_of_no_confidence.try_assuage\":{\"id\":\"vote_of_no_confidence.try_assuage\",\"options\":[{\"id\":\"@vote_of_no_confidence.give_up_prussia\",\"title\":\"Give up on leadership of Prussia.\"},{\"id\":\"@vote_of_no_confidence.austerity\",\"title\":\"Enact a massive austerity plan.\"},{\"id\":\"@vote_of_no_confidence.resources\",\"title\":\"Use our resources to reduce dissent within the coalition.\"},{\"id\":\"@vote_of_no_confidence.support_kpd\",\"title\":\"Could we get the KPD to abstain?\"},{\"id\":\"@vote_of_no_confidence.let_it_happen\",\"title\":\"Never mind. Let the vote happen.\"}],\"content\":{\"content\":\"How do we assuage our partners?\",\"type\":\"paragraph\"}},\"unions_declare_independence\":{\"id\":\"unions_declare_independence\",\"type\":\"scene\",\"title\":\"Unions Declare Independence\",\"newPage\":true,\"subtitle\":\"Labor's disagreements with our policies have grown too severe.\",\"tags\":[\"event\"],\"viewIf\":{\"$code\":\"return ((Q['labor_dissent'] || 0) >= 60);\"},\"onArrival\":[{\"$code\":\"Q['unions_independent'] = 1;\\nQ['labor_strength'] = ((Q['labor_strength'] || 0) / 2);\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 20;\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) - 10;\\n if ((!(((Q['sapd_formed'] || 0)) !== 0)) ) { Q['workers_other'] = (Q['workers_other'] || 0) + 5; } \\nQ['workers_kpd'] = (Q['workers_kpd'] || 0) + 5;\\nQ['workers_nsdap'] = (Q['workers_nsdap'] || 0) + 5;\\n if (((Q['woytinsky_advisor'] || 0) == 1) ) { Q['n_advisors'] = (Q['n_advisors'] || 0) - 1; } \\n if (((Q['leipart_advisor'] || 0) == 1) ) { Q['n_advisors'] = (Q['n_advisors'] || 0) - 1; } \\nQ['woytinsky_advisor'] = 0;\\nQ['leipart_advisor'] = 0;\\nQ['rb_strength'] = (Q['rb_strength'] || 0) - 600;\\n if ((((Q['sapd_formed'] || 0)) !== 0) ) { Q['workers_sapd'] = (Q['workers_sapd'] || 0) + 10; } \\n if ((((Q['sapd_formed'] || 0)) !== 0) ) { Q['unemployed_sapd'] = (Q['unemployed_sapd'] || 0) + 6; }\"}],\"maxVisits\":1,\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"Unions Declare Independence\"},{\"type\":\"paragraph\",\"content\":\"Our policy choices have greatly offended the labor movement. Union leaders have declared that they are independent of any political party, and some have been seen seeking accomodation with the KPD and even the NSDAP.\"},{\"type\":\"paragraph\",\"content\":[\"Most workers remain loyal to the SPD, although their affiliation is less solid. Many workers move left\",{\"type\":\"conditional\",\"content\":\", to the KPD or the nascent SAPD\",\"predicate\":0},\". Others move in a more nationalist direction, as the ADGB signals its willingness to work with the right to solve the economic crisis.\"]},{\"type\":\"paragraph\",\"content\":\"Much of our working-class base has defected, and labor's influence in our party has greatly diminished.\"}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['sapd_formed'] || 0)) !== 0);\"}}]},\"countVisitsMax\":1},\"wittorf_affair.publicize\":{\"id\":\"wittorf_affair.publicize\",\"title\":\"We will publicize the scandal to damage the KPD and Thälmann.\",\"onArrival\":[{\"$code\":\"Q['kpd_relation'] = (Q['kpd_relation'] || 0) - 10;\\nQ['workers_kpd'] = (Q['workers_kpd'] || 0) - 4;\\nQ['unemployed_kpd'] = (Q['unemployed_kpd'] || 0) - 4;\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"Our newspapers are among the first to publicize the affair, bringing a torment of criticism to the hypocrisy of the communists. We have damaged the KPD's standing among the workers, but also perhaps closed the door on further cooperation.\"},{\"type\":\"paragraph\",\"content\":\"In the end, Stalin's pressure helps to keep Thälmann from facing much in the way of consequences.\"}]},\"young_plan.pro_plan\":{\"id\":\"young_plan.pro_plan\",\"options\":[{\"id\":\"@young_plan.internationalism\",\"title\":\"As part of a broader campaign in favor of internationalism and pacifism.\"},{\"id\":\"@young_plan.rational\",\"title\":\"The Young Plan is simply the most rational choice for Germany.\"}],\"content\":{\"content\":\"How should we campaign in favor of the Plan?\",\"type\":\"paragraph\"}},\"young_plan_right_coalition.vonc_yes\":{\"id\":\"young_plan_right_coalition.vonc_yes\",\"title\":\"Support the vote of no confidence, voting against the government.\",\"subtitle\":\"The government will collapse, and there will be new elections.\",\"viewIf\":{\"$code\":\"return ((Q['neo_weimar_coalition'] || 0) >= 50);\"},\"onArrival\":[{\"$code\":\"Q['time_to_election'] = 3;\\nQ['spd_in_government'] = 0;\\nQ['in_right_coalition'] = 0;\\nQ['in_grand_coalition'] = 0;\\nQ['spd_toleration'] = 0;\\nQ['pro_republic'] = (Q['pro_republic'] || 0) - 5;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 5;\\nQ['z_relation'] = (Q['z_relation'] || 0) - 5;\"}],\"call\":\"set_next_election_time\",\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"The right-wing coalition has fallen. New elections have been set for \",{\"type\":\"insert\",\"insert\":0},\" \",{\"type\":\"insert\",\"insert\":1},\".\"]},\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_month'] || 0);\"},\"qdisplay\":\"month\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_year'] || 0);\"}}]}},\"confronting_nazis.not_a_big_deal\":{\"id\":\"confronting_nazis.not_a_big_deal\",\"onArrival\":[{\"$code\":\"Q['nazi_urgency'] = (Q['nazi_urgency'] || 0) - 1;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 5;\\nQ['neorevisionist_dissent'] = (Q['neorevisionist_dissent'] || 0) + 15;\"}],\"viewIf\":{\"$code\":\"return ((((Q['mierendorff_advisor'] || 0)===0) && ((Q['leber_advisor'] || 0)===0)) && ((Q['schumacher_advisor'] || 0)===0));\"},\"content\":{\"content\":\"The Nazis are just another far-right movement that will die of its own contradictions sooner or later; we do not need to build a specific policy to combat them.\",\"type\":\"paragraph\"}},\"campaigning.workers\":{\"id\":\"campaigning.workers\",\"subtitle\":\"-1 resources\",\"chooseIf\":{\"$code\":\"return ((Q['resources'] || 0) >= 1);\"},\"unavailableSubtitle\":\"Not enough resources.\",\"onArrival\":[{\"$code\":\"Q['workers_spd'] = (Q['workers_spd'] || 0) + (6 * (1 - (Q['dissent'] || 0)));\\n if (((Q['unemployed'] || 0) >= 15) ) { Q['workers_spd'] = (Q['workers_spd'] || 0) - 2; } \\n if (((Q['unemployed'] || 0) >= 25) ) { Q['workers_spd'] = (Q['workers_spd'] || 0) - 2; } \\n if (((Q['wtb_adopted'] || 0)===1) ) { Q['workers_spd'] = (Q['workers_spd'] || 0) + (6 * (1 - (Q['dissent'] || 0))); } \\nQ['resources'] = (Q['resources'] || 0) - 1;\\n if (((Q['nationalization_progress'] || 0) >= 1) ) { Q['workers_spd'] = (Q['workers_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0))); }\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"We have increased our campaigning among the workers. \",{\"type\":\"conditional\",\"content\":\"The high levels of unemployment make our campaign more difficult. \",\"predicate\":0},{\"type\":\"conditional\",\"content\":\"Adopting the WTB plan gives us a new rallying point around which to attract workers.\",\"predicate\":1}]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['unemployed'] || 0) >= 15);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['wtb_adopted'] || 0)===1);\"}}]}},\"crisis_program.support_centrist\":{\"id\":\"crisis_program.support_centrist\",\"subtitle\":\"Let the depression play itself out.\",\"onArrival\":[{\"$code\":\"Q['center_strength'] = (Q['center_strength'] || 0) + 5;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) - 5;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) + 10;\\nQ['wtb_support'] = (Q['wtb_support'] || 0) - 1;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 10;\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"Woytinsky and the trade unions vehemently criticize the centrists for their policy. The workers are starving; are we going to callously abandon them and side with bourgeois austerity? On the other hand, the centrists criticize Woytinsky for promising the workers false hope; their position is that nothing can be done to alleviate the depression. They also speak of the fear of another round of hyperinflation that may result from deficit spending.\"},{\"type\":\"paragraph\",\"content\":\"Our policy course is currently that nothing can be done to alleviate the depression.\"}]},\"fundraising.maintain\":{\"id\":\"fundraising.maintain\",\"subtitle\":{\"content\":[{\"type\":\"insert\",\"insert\":0},\" resources gained.\"],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['dues'] || 0);\"}}]},\"onArrival\":[{\"$code\":\"Q['resources'] = (Q['resources'] || 0) + (Q['dues'] || 0);\"}],\"content\":{\"content\":\"We maintain our current dues.\",\"type\":\"paragraph\"}},\"enemies.anti_dem\":{\"id\":\"enemies.anti_dem\",\"onArrival\":[{\"$code\":\"Q['enemies'] = \\\"anti-democratic parties\\\";\\nQ['center_strength'] = (Q['center_strength'] || 0) + 5;\\nQ['reformist_strength'] = (Q['reformist_strength'] || 0) + 5;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 5;\\nQ['workers_kpd'] = (Q['workers_kpd'] || 0) - 2;\\nQ['workers_nsdap'] = (Q['workers_nsdap'] || 0) - 2;\\nQ['workers_dnvp'] = (Q['workers_dnvp'] || 0) - 2;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) - 10;\"}],\"content\":{\"content\":\"Attacking the far right and left is popular among all but the left wing of our party, who would prefer to be fighting the bourgeois parties. This might also hamper our ability to reconcile with the KPD in the future.\",\"type\":\"paragraph\"}},\"ideology.class_struggle\":{\"id\":\"ideology.class_struggle\",\"onArrival\":[{\"$code\":\"if (Q.ideology && Q.ideology != \\\"left\\\") {\\n    Q.changed = 1;\\n}\"}],\"goTo\":[{\"id\":\"ideology.changed\",\"predicate\":{\"$code\":\"return ((Q['changed'] || 0)===1);\"}}],\"onDeparture\":[{\"$code\":\"Q['ideology'] = \\\"left\\\";\\nQ['left_strength'] = (Q['left_strength'] || 0) + 10;\\nQ['communist_coalition'] = (Q['communist_coalition'] || 0) + 1;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) - 5;\\nQ['z_relation'] = (Q['z_relation'] || 0) - 3;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 5;\\nQ['nationalization_support'] = (Q['nationalization_support'] || 0) + 1;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) + 3;\"}],\"content\":{\"content\":\"The radical left of the party supports a course of class struggle, and potentially a reconcilliation with the Communists.\",\"type\":\"paragraph\"}},\"inter_party_relationships.kpd\":{\"id\":\"inter_party_relationships.kpd\",\"subtitle\":\"-1 resources\",\"chooseIf\":{\"$code\":\"return ((Q['resources'] || 0) >= 1);\"},\"unavailableSubtitle\":\"Not enough resources.\",\"onArrival\":[{\"$code\":\"Q['resources'] = (Q['resources'] || 0) - 1;\\nQ['kpd_inter_party_seen'] = (Q['kpd_inter_party_seen'] || 0) + 1;\"}],\"goTo\":[{\"id\":\"inter_party_relationships.kpd_blutmai\",\"predicate\":{\"$code\":\"return ((Q['blutmai'] || 0)===1);\"}},{\"id\":\"inter_party_relationships.kpd_1\",\"predicate\":{\"$code\":\"return ((((Q['blutmai'] || 0)===0) && ((Q['kpd_coalition_success'] || 0)===0)) && ((((Q['kpd_relation'] || 0) < 40) || ((Q['kpd_rectifed_history'] || 0)===1))));\"}},{\"id\":\"inter_party_relationships.kpd_rectification_of_history\",\"predicate\":{\"$code\":\"return (((Q['kpd_relation'] || 0) >= 40) && ((Q['kpd_rectifed_history'] || 0)===0));\"}},{\"id\":\"inter_party_relationships.kpd_2\",\"predicate\":{\"$code\":\"return (((Q['kpd_coalition_success'] || 0)===1) && ((Q['kpd_rectified_history'] || 0)===1));\"}}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"international_relations.fr_uk\":{\"id\":\"international_relations.fr_uk\",\"subtitle\":\"-1 resources\",\"chooseIf\":{\"$code\":\"return ((Q['resources'] || 0) >= 1);\"},\"unavailableSubtitle\":\"Not enough resources.\",\"onArrival\":[{\"$code\":\"Q['resources'] = (Q['resources'] || 0) - 1;\\nQ['west_relation'] = (Q['west_relation'] || 0) + 1;\\nQ['reformist_strength'] = (Q['reformist_strength'] || 0) + 5;\\nQ['pacifism'] = (Q['pacifism'] || 0) + 1;\\nQ['moderate_plan_support'] = (Q['moderate_plan_support'] || 0) + 1;\"}],\"content\":{\"content\":\"The socialists of France and Britain can influence their governments to be friendlier towards Germany. Hopefully they will reduce our reparations burden.\",\"type\":\"paragraph\"}},\"iron_front.defense\":{\"id\":\"iron_front.defense\",\"subtitle\":{\"content\":[\"-\",{\"type\":\"insert\",\"insert\":0},\" resources\"],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rb_militarization_cost'] || 0);\"}}]},\"chooseIf\":{\"$code\":\"return ((Q['resources'] || 0) >= (Q['rb_militarization_cost'] || 0));\"},\"onArrival\":[{\"$code\":\"Q['resources'] = (Q['resources'] || 0) - (Q['rb_militarization_cost'] || 0);\\nQ['rb_strength'] = (Q['rb_strength'] || 0) + 50;\\nQ['rb_militancy'] = (Q['rb_militancy'] || 0) + 0.05;\\n if ((((Q['historical_mode'] || 0)) !== 0) ) { Q['z_relation'] = (Q['z_relation'] || 0) - 5; }\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"The Iron Front rallies for the militant defense of the republic against the fascist paramilitaries, strengthening the Reichsbanner.\"},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":\"The Center Party decries the militarization of the Reichsbanner and Iron Front, and its members are leaving the republican organization.\",\"predicate\":0}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['historical_mode'] || 0)) !== 0);\"}}]}},\"media.commercial\":{\"id\":\"media.commercial\",\"title\":\"Make our newspapers more commercialized by broadening their appeal beyond party supporters.\",\"subtitle\":\"This might upset ideological purists, but it may bring in more funds and perhaps expose the middle class to socialist views.\",\"onArrival\":[{\"$code\":\"Q['resources'] = (Q['resources'] || 0) + 1;\\nQ['commercialized_media'] = (Q['commercialized_media'] || 0) + 1;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 10;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) + 10;\"}],\"content\":{\"content\":\"Our commercialized newspapers are able to bring in more funds. However, the left and labor factions express their displeasure.\",\"type\":\"paragraph\"}},\"party_disunity.enforce_unity\":{\"id\":\"party_disunity.enforce_unity\",\"title\":\"Enforce party discipline.\",\"onArrival\":[{\"$code\":\"Q['reformist_dissent'] = (Q['reformist_dissent'] || 0) - 5;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) - 5;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) - 5;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) - 5;\\nQ['neorevisionist_dissent'] = (Q['neorevisionist_dissent'] || 0) - 5;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 4;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) - 2;\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) - 2;\"}],\"content\":{\"content\":\"Enforcing party discipline reduces dissent, but it could lead to an exit of dissenting members.\",\"type\":\"paragraph\"}},\"neorevisionism.support_neo\":{\"id\":\"neorevisionism.support_neo\",\"onArrival\":[{\"$code\":\"Q['neorevisionist_strength'] = (Q['neorevisionist_strength'] || 0) + 10;\\nQ['nazi_urgency'] = (Q['nazi_urgency'] || 0) + 1;\\nQ['neorevisionism'] = 1;\\nQ['peoples_party_support'] = (Q['peoples_party_support'] || 0) + 1;\"}],\"options\":[{\"id\":\"@shuffle_leadership\",\"title\":\"We should use this opportunity to change the party's leadership.\"},{\"id\":\"@root\",\"title\":\"Continue...\"}],\"content\":{\"content\":\"We support the new leaders, and start using new-style propaganda techniques in our campaigns. The results are uncertain so far...\",\"type\":\"paragraph\"}},\"party_organizations.newspapers\":{\"id\":\"party_organizations.newspapers\",\"chooseIf\":{\"$code\":\"return ((Q['resources'] || 0) > 0);\"},\"unavailableSubtitle\":\"Not enough resources.\",\"subtitle\":\"-1 resources\",\"onArrival\":[{\"$code\":\"Q['resources'] = (Q['resources'] || 0) - 1;\\nQ['media_timer'] = 0;\"}],\"goTo\":[{\"id\":\"media\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"peoples_party.build_support\":{\"id\":\"peoples_party.build_support\",\"viewIf\":{\"$code\":\"return (((((Q['neorevisionist_strength'] || 0) + (Q['reformist_strength'] || 0)) < ((Q['left_strength'] || 0) + (Q['center_strength'] || 0)))) || ((Q['peoples_party_support'] || 0) < 5));\"},\"onArrival\":[{\"$code\":\"Q['peoples_party_support'] = (Q['peoples_party_support'] || 0) + 1;\\nQ['neorevisionist_strength'] = (Q['neorevisionist_strength'] || 0) + 5;\\nQ['left_strength'] = (Q['left_strength'] || 0) - 5;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 5;\"}],\"content\":{\"content\":\"Within our party, we are pushing forward proposals for a people's party against the Left and Center.\",\"type\":\"paragraph\"}},\"peoples_party_campaigning.campaign_workers\":{\"id\":\"peoples_party_campaigning.campaign_workers\",\"title\":\"Campaign among the workers, to assuage their doubts about our changes.\",\"onArrival\":[{\"$code\":\"Q['workers_spd'] = (Q['workers_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\"}],\"content\":{\"content\":\"The workers are still a key part of our constituency, and we must not alienate them in the transformation of our party.\",\"type\":\"paragraph\"}},\"rally.sa_disrupt\":{\"id\":\"rally.sa_disrupt\",\"options\":[{\"id\":\"@rally.police_protect\",\"title\":\"Call the police to protect our rally.\"},{\"id\":\"@rally.rb_protect\",\"title\":\"Use the Reichsbanner to protect our rally.\"},{\"id\":\"@rally.both_protect\",\"title\":\"The police and Reichsbanner should work together to protect our rally.\"},{\"id\":\"@rally.cancel\",\"title\":\"Cancel the rally.\"}],\"content\":{\"content\":\"The Nazi SA has disrupted our rally! Their street troops are preventing us from meeting.\",\"type\":\"paragraph\"}},\"reichsbanner.militant\":{\"id\":\"reichsbanner.militant\",\"chooseIf\":{\"$code\":\"return ((Q['resources'] || 0) >= (Q['rb_militarization_cost'] || 0));\"},\"unavailableSubtitle\":{\"content\":[\"Not enough resources (\",{\"type\":\"insert\",\"insert\":0},\" needed).\"],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rb_militarization_cost'] || 0);\"}}]},\"subtitle\":{\"content\":[\"-\",{\"type\":\"insert\",\"insert\":0},\" resources\"],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rb_militarization_cost'] || 0);\"}}]},\"onArrival\":[{\"$code\":\"Q['resources'] = (Q['resources'] || 0) - (Q['rb_militarization_cost'] || 0);\\nQ['rb_investment'] = (Q['rb_investment'] || 0) + 1;\\nQ['rb_strength'] = (Q['rb_strength'] || 0) + 100;\\nQ['rb_militancy'] = (Q['rb_militancy'] || 0) + 0.05;\\nQ['left_strength'] = (Q['left_strength'] || 0) + 2;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) - 2;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 5;\\nQ['spd_militancy'] = (Q['spd_militancy'] || 0) + 0.05;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (2 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (2 * (1 - (Q['dissent'] || 0)));\\n if ((((Q['historical_mode'] || 0)) !== 0) ) { Q['z_relation'] = (Q['z_relation'] || 0) - 5; }\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"Some in our party decry the increasing militarization of the Reichsbanner. They say it is emulating the right-wing nationalists or the communists, and risks alienating our allies in the centrist parties. On the other hand, more left-leaning radicals are being lured to our organizations, away from the communists.\"},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":\"The Center Party decries the militarization of the Reichsbanner, and its members are leaving the republican organization.\",\"predicate\":0}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['historical_mode'] || 0)) !== 0);\"}}]}},\"response_to_antisemitism.socialism_of_fools\":{\"id\":\"response_to_antisemitism.socialism_of_fools\",\"content\":{\"content\":\"The best policy to deal with this sort of irrational, senseless hatred is to ignore it. Few are swayed by racist rhetoric; the best way to combat it is to provide economic security so that people do not turn to antisemitism.\",\"type\":\"paragraph\"}},\"shuffle_leadership.rm_main\":{\"id\":\"shuffle_leadership.rm_main\",\"title\":\"Remove advisors.\",\"tags\":[\"center_advisor\",\"left_advisor\",\"reformist_advisor\",\"labor_advisor\",\"neorev_advisor\",\"nonfactional_advisor\"],\"frequency\":1,\"options\":[{\"id\":\"#remove_advisor\"},{\"id\":\"@shuffle_leadership.add_advisors\",\"title\":\"Add advisors\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"streetfighting.battle\":{\"id\":\"streetfighting.battle\",\"viewIf\":{\"$code\":\"return (((Q['rb_militancy'] || 0) > 0.1) && ((Q['rb_militancy'] || 0) < 0.5));\"},\"onArrival\":[{\"$code\":\"Q['rb_militancy'] = (Q['rb_militancy'] || 0) + 0.1;\\nQ['sa_strength'] = (Q['sa_strength'] || 0) + 40;\\nQ['rb_strength'] = (Q['rb_strength'] || 0) - 100;\"}],\"maxVisits\":1,\"content\":{\"content\":\"Many Reichsbanner members are not ready for actual fighting, and thus quit. However, the remainder are toughened as a result. Our confrontations also provide ample recruiting material for the Nazi SA.\",\"type\":\"paragraph\"},\"countVisitsMax\":1},\"credits.articles\":{\"id\":\"credits.articles\",\"options\":[{\"id\":\"@credits\",\"title\":\"Back\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"Aleskerov, Fuad T., et al. Power Distribution in the Weimar Reichstag in 1919-1933. 1806310, 1 Dec. 2010. Social Science Research Network, https://doi.org/10.2139/ssrn.1806310.\"},{\"type\":\"paragraph\",\"content\":\"Berman, Sheri. “Civil Society and the Collapse of the Weimar Republic.” World Politics, vol. 49, no. 3, Apr. 1997, pp. 401–29. DOI.org (Crossref), https://doi.org/10.1353/wp.1997.0008.\"},{\"type\":\"paragraph\",\"content\":\"Bodek, Richard. “Red Song: Social Democratic Music and Radicalism at the End of the Weimar Republic.” Central European History, vol. 28, no. 2, 1995, pp. 209–27.\"},{\"type\":\"paragraph\",\"content\":\"Bowlby, Chris. “Blutmai 1929: Police, Parties and Proletarians in a Berlin Confrontation.” The Historical Journal, vol. 29, no. 1, 1986, pp. 137–58.\"},{\"type\":\"paragraph\",\"content\":\"Chickering, Roger Philip. “The Reichsbanner and the Weimar Republic, 1924-26.” The Journal of Modern History, Dec. 1968. world, www.journals.uchicago.edu, https://doi.org/10.1086/240238.\"},{\"type\":\"paragraph\",\"content\":\"Diehl, Benjamin. “Sergei Chakhotin against the Swastika: Mass Psychology and Scientific Organization in the Iron Front’s Three Arrows Campaign.” Central European History, Mar. 2024, pp. 1–20. Cambridge University Press, https://doi.org/10.1017/S0008938924000025.\"},{\"type\":\"paragraph\",\"content\":\"Evans, Ellen L. “Adam Stegerwald and the Role of the Christian Trade Unions in the Weimar Republic.” The Catholic Historical Review 59, no. 4 (1974): 602–26.\"},{\"type\":\"paragraph\",\"content\":\"Falter, Jürgen W. “The Two Hindenburg Elections of 1925 and 1932: A Total Reversal of Voter Coalitions 1990.” Historical Social Research / Historische Sozialforschung. Supplement, no. 25, 2013, pp. 217–32.\"},{\"type\":\"paragraph\",\"content\":\"Frey, Bruno S., and Hannelore Weck. “A Statistical Study of the Effect of the Great Depression on Elections: The Weimar Republic, 1930?1933.” Political Behavior, vol. 5, no. 4, 1983, pp. 403–20. DOI.org (Crossref), https://doi.org/10.1007/BF00987564.\"},{\"type\":\"paragraph\",\"content\":\"Gaido, Daniel. “Paul Levi and the Origins of the United-Front Policy in the Communist International.” Historical Materialism 25, no. 1 (2017): 131–74. https://doi.org/10.1163/1569206x-12341515.\"},{\"type\":\"paragraph\",\"content\":\"Galofré-Vilà, Gregori, et al. “Austerity and the Rise of the Nazi Party.” The Journal of Economic History, vol. 81, no. 1, Mar. 2021, pp. 81–113. DOI.org (Crossref), https://doi.org/10.1017/S0022050720000601.\"},{\"type\":\"paragraph\",\"content\":\"Hilferding, Rudolf. \\\"Between Decisions.\\\" https://www.marxists.org/archive/hilferding/1933/decisions.htm. Accessed 3 Oct. 2023.\"},{\"type\":\"paragraph\",\"content\":\"Hodge, Carl Cavanagh. “Three Ways to Lose a Republic: The Electoral Politics of the Weimar SPD.” European History Quarterly, vol. 17, no. 2, Apr. 1987, pp. 165–93. SAGE Journals, https://doi.org/10.1177/026569148701700203.\"},{\"type\":\"paragraph\",\"content\":\"Kautsky, Karl: Communism and Socialism (1932). https://www.marxists.org/archive/kautsky/1932/commsoc/index.htm. Accessed 3 Oct. 2023.\"},{\"type\":\"paragraph\",\"content\":\"Kautsky, Karl: Hitlerism and Social Democracy (1934). https://www.marxists.org/archive/kautsky/1934/hitler/index.htm. Accessed 3 Oct. 2023.\"},{\"type\":\"paragraph\",\"content\":\"King, Gary, et al. “Ordinary Economic Voting Behavior in the Extraordinary Election of Adolf Hitler.” The Journal of Economic History, vol. 68, no. 4, Dec. 2008, pp. 951–96. Cambridge University Press, https://doi.org/10.1017/S0022050708000788.\"},{\"type\":\"paragraph\",\"content\":\"LaPorte, Norman H. “The German Communist Party in Saxony, 1924-1933 : Factionalism, Fratricide and Political Failure,” 1998. http://dspace.stir.ac.uk/handle/1893/3259.\"},{\"type\":\"paragraph\",\"content\":\"Shively, W. Phillips. “Party Identification, Party Choice, and Voting Stability: The Weimar Case.” American Political Science Review, vol. 66, no. 4, Dec. 1972, pp. 1203–25. Cambridge University Press, https://doi.org/10.2307/1957174.\"},{\"type\":\"paragraph\",\"content\":\"Smaldone, William. “Socialist Paths in a Capitalist Conundrum: Reconsidering the German Catastrophe of 1933.” Journal of World History, vol. 18, no. 3, 2007, pp. 297–323.\"},{\"type\":\"paragraph\",\"content\":\"Smith, Woodruff D. “The Mierendorff Group and the Modernization of German Social Democratic Politics, 1928-1933.” Politics & Society 5, no. 1 (March 1, 1975): 109–29. https://doi.org/10.1177/003232927500500105.\"},{\"type\":\"paragraph\",\"content\":\"Stockhammer, Engelbert. “Hilferding, Woytinsky and the Fiscal Orthodoxy of Interwar Social Democracy.” Working Papers, PKWP2118, Nov. 2021. ideas.repec.org, https://ideas.repec.org//p/pke/wpaper/pkwp2118.html.\"},{\"type\":\"paragraph\",\"content\":\"Voth, Hans-Joachim. Wages, Investment, and the Fate of the Weimar Republic: A Long-Term Perspective.\"},{\"type\":\"paragraph\",\"content\":\"Winkler, Heinrich August. “Choosing the Lesser Evil: The German Social Democrats and the Fall of the Weimar Republic.” Journal of Contemporary History, vol. 25, no. 2/3, 1990, pp. 205–27.\"},{\"type\":\"paragraph\",\"content\":\"Zimmermann, Adrian. “Economic Democracy Instead of More Capitalism: Core Historical Concepts Reconsidered.” In In Search of Social Democracy, edited by John Callaghan, Nina Fishman, Ben Jackson, and Martin Mcivor, 267–85. Responses to Crisis and Modernisation. Manchester University Press, 2009. https://www.jstor.org/stable/j.ctt1wn0s45.19.\"}]},\"election_simulation.1930\":{\"id\":\"election_simulation.1930\",\"onArrival\":[{\"$code\":\"Q.workers = 46; // industry and trade\\nQ.old_middle = 13; // \\\"old mittelstand\\\"\\n// 16.4 trade & commerce, 6.6 public and private services, 4.4 domestic help\\nQ.new_middle = 14; // \\\"new mittelstand\\\"\\nQ.rural = 25; // agriculture and forestry employment... but many of those are proletarians so...\\n// source: https://surface.syr.edu/cgi/viewcontent.cgi?filename=3&article=1016&context=books&type=additional page 43, table 3.3\\nQ.unemployed = 20;\\nQ.catholics = 30;\\n\\nQ.classes = ['workers', 'old_middle', 'new_middle', 'rural', 'unemployed', 'catholics'];\\nQ.parties = ['spd', 'kpd', 'z', 'ddp', 'dvp', 'dnvp', 'nsdap', 'other'];\\n\\n// Support for party by social group\\n// they don't have to sum to 100 since the electoral calculations will be normalized.\\nQ.workers_spd = 60;\\nQ.workers_kpd = 20;\\nQ.workers_z = 5;\\nQ.workers_ddp = 0;\\nQ.workers_dvp = 0;\\nQ.workers_dnvp = 0;\\nQ.workers_nsdap = 10;\\nQ.workers_other = 15;\\n\\nQ.old_middle_spd = 5;\\nQ.old_middle_kpd = 0;\\nQ.old_middle_z = 5;\\nQ.old_middle_ddp= 5;\\nQ.old_middle_dvp = 10;\\nQ.old_middle_dnvp = 20;\\nQ.old_middle_nsdap = 30;\\nQ.old_middle_other = 15;\\n\\nQ.new_middle_spd = 5;\\nQ.new_middle_kpd = 0;\\nQ.new_middle_z = 5;\\nQ.new_middle_ddp = 10;\\nQ.new_middle_dvp = 20;\\nQ.new_middle_dnvp = 10;\\nQ.new_middle_nsdap = 25;\\nQ.new_middle_other = 15;\\n\\nQ.rural_spd = 5;\\nQ.rural_kpd = 0;\\nQ.rural_z = 5;\\nQ.rural_ddp= 5;\\nQ.rural_dvp = 10;\\nQ.rural_dnvp = 20;\\nQ.rural_nsdap = 25;\\nQ.rural_other = 15;\\n\\nQ.unemployed_spd = 20;\\nQ.unemployed_kpd = 50;\\nQ.unemployed_z = 0;\\nQ.unemployed_ddp = 0;\\nQ.unemployed_dvp = 0;\\nQ.unemployed_dnvp = 5;\\nQ.unemployed_nsdap = 25;\\nQ.unemployed_other = 5;\\n\\nQ.catholics_spd = 10;\\nQ.catholics_kpd = 5;\\nQ.catholics_z = 50;\\nQ.catholics_ddp = 0;\\nQ.catholics_dvp = 5;\\nQ.catholics_dnvp = 5;\\nQ.catholics_nsdap = 10;\\nQ.catholics_other = 5;\\n\\nQ.spd_r = 25;\\nQ.kpd_r = 10;\\nQ.z_r = 15;\\nQ.ddp_r = 10;\\nQ.dvp_r = 10;\\nQ.dnvp_r = 14;\\nQ.nsdap_r = 10;\\nQ.other_r = 5;\"}],\"goTo\":[{\"id\":\"election_algorithm\"}],\"setJump\":\"election_simulation.post_election\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"game_over.hitler_wins\":{\"id\":\"game_over.hitler_wins\",\"viewIf\":{\"$code\":\"return ((((Q['chancellor'] == \\\"Hitler\\\") || (Q['president'] == \\\"Hitler\\\"))) && ((((Q['total_defeat'] || 0) == 1) || ((Q['civil_war_seen'] || 0) == 0))));\"},\"title\":\"Adolf Hitler is in undisputed control over Germany.\",\"tags\":[\"endings\"],\"goTo\":[{\"id\":\"game_over.eg_menu\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"Adolf Hitler is in undisputed control over Germany. The SPD, along with all of the democratic forces, have failed.\"},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":\"At the very least, we fought back. Perhaps our resistance will be celebrated in an impossible-to-forsee future.\",\"predicate\":0}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['civil_war_seen'] || 0) == 1);\"}}]}},\"library.government\":{\"id\":\"library.government\",\"goTo\":[{\"id\":\"library.menu\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"The German Republic, called by some of our detractors as the \\\"Weimar Republic\\\", is a parliamentary republic with a somewhat weak president and a strong parliament, called the Reichstag. The Reichstag is responsible for governing, while the President has a largely ceremonial role but also has some important governing responsibilities.\"},{\"type\":\"paragraph\",\"content\":\"The Reichstag is elected based on a proportional representation system, giving parties seats roughly proportional to their vote share in each electoral district. The Reichstag then elects the Chancellor and the cabinet by a majority vote, who are responsible for government. A majority vote-of-no-confidence can remove the current government.\"},{\"type\":\"paragraph\",\"content\":\"The President is elected by a national direct vote, in two rounds. The second round is used if the first round does not result in a majority for one candidate; the candidate who receives a plurality in the second round becomes president (there is no obligation for weaker candidates to drop out). The role of the president is mostly to represent Germany, but he also has some crucial governing powers. The president and chancellor can together use emergency decrees to govern, bypassing the Reichstag. The president can also appoint or remove a chancellor when a parliamentary majority is unable to be established, and can thus influence the formation of a government.\"},{\"type\":\"paragraph\",\"content\":\"Germany is divided into a number of states, each of which have their own governments with some responsibilities. By far the largest and most important state is Prussia.\"}]},\"main.party\":{\"id\":\"main.party\",\"title\":\"Party Affairs\",\"cardImage\":\"img/Vorwaerts_nr_1.png\",\"isDeck\":true,\"options\":[{\"id\":\"#party_affairs\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"status.paramilitaries\":{\"id\":\"status.paramilitaries\",\"onArrival\":[{\"$code\":\"if (Q.rb_strength) {\\n    Q.rb_strength_2 = Q.rb_strength.toFixed(1);\\n}\\nif (Q.rfb_strength) {\\n    Q.rfb_strength_2 = Q.rfb_strength.toFixed(1);\\n}\\nif (Q.sh_strength) {\\n    Q.sh_strength_2 = Q.sh_strength.toFixed(1);\\n}\\nif (Q.sa_strength) {\\n    Q.sa_strength_2 = Q.sa_strength.toFixed(1);\\n}\"}],\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"Paramilitaries\"},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<span class=\\\"tooltip-text\\\" title=\\\"The Reichsbanner Schwarz-Rot-Gold is a popular organization for defending democracy, mostly affiliated with the SPD.\\\">Reichsbanner</span>\"},\" Strength: \",{\"type\":\"insert\",\"insert\":0},\" thousand\"]},{\"type\":\"paragraph\",\"content\":[\"Reichsbanner Militarization: \",{\"type\":\"insert\",\"insert\":1},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<span class=\\\"tooltip-text\\\" title=\\\"The RFB (Rotfrontkämpferbund) is a communist group associated with the KPD.\\\">RFB</span>\"},\" Strength: \",{\"type\":\"insert\",\"insert\":2},\" thousand\"]},{\"type\":\"paragraph\",\"content\":[\"RFB Militarization: \",{\"type\":\"insert\",\"insert\":3},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<span class=\\\"tooltip-text\\\" title=\\\"The Stahlhelm is a right-wing organization of war veterans associated with the DNVP.\\\">Stahlhelm</span>\"},\" Strength: \",{\"type\":\"insert\",\"insert\":4},\" thousand\"]},{\"type\":\"paragraph\",\"content\":[\"Stahlhelm Militarization: \",{\"type\":\"insert\",\"insert\":5},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<span class=\\\"tooltip-text\\\" title=\\\"The SA (Sturmabteilung) is the Nazi paramilitary.\\\">SA</span>\"},\" Strength: \",{\"type\":\"insert\",\"insert\":6},\" thousand\"]},{\"type\":\"paragraph\",\"content\":[\"SA Militarization: \",{\"type\":\"insert\",\"insert\":7},\"\"]},{\"type\":\"heading\",\"content\":\"Official military/paramilitaries\"},{\"type\":\"paragraph\",\"content\":[\"Reichswehr: \",{\"type\":\"insert\",\"insert\":8},\" thousand troops.\"]},{\"type\":\"paragraph\",\"content\":[\"Reichswehr Loyalty: \",{\"type\":\"insert\",\"insert\":9},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Prussian police: \",{\"type\":\"insert\",\"insert\":10},\" thousand members.\"]},{\"type\":\"paragraph\",\"content\":[\"Prussian police loyalty: \",{\"type\":\"insert\",\"insert\":11},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":[\"Interior police loyalty: \",{\"type\":\"insert\",\"insert\":13},\"\"],\"predicate\":12}}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rb_strength_2'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rb_militancy'] || 0);\"},\"qdisplay\":\"militancy\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rfb_strength_2'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rfb_militancy'] || 0);\"},\"qdisplay\":\"militancy\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['sh_strength_2'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['sh_militancy'] || 0);\"},\"qdisplay\":\"militancy\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['sa_strength_2'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['sa_militancy'] || 0);\"},\"qdisplay\":\"militancy\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['reichswehr_strength'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['reichswehr_loyalty'] || 0);\"},\"qdisplay\":\"loyalty\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['prussian_police_strength'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['prussian_police_loyalty'] || 0);\"},\"qdisplay\":\"loyalty\"},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['spd_in_government'] || 0)) !== 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['interior_police_loyalty'] || 0);\"},\"qdisplay\":\"loyalty\"}]}},\"root.start_menu_2\":{\"id\":\"root.start_menu_2\",\"options\":[{\"id\":\"@root.start\",\"title\":\"Start game\"},{\"id\":\"@election_simulation\",\"title\":\"Election simulation\"},{\"id\":\"@credits\",\"title\":\"Credits\"},{\"id\":\"@game_over.achievements\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"aufhauser.union_unity\":{\"id\":\"aufhauser.union_unity\",\"title\":\"Union-party coordination\",\"subtitle\":\"Reduce dissent among the unions.\",\"chooseIf\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) <= 0);\"},\"unavailableSubtitle\":{\"content\":{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action.\"],\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) - 10;\"}],\"content\":{\"content\":\"We have reduced tensions with the Labor faction.\",\"type\":\"paragraph\"}},\"braun.prussian_bulwark\":{\"id\":\"braun.prussian_bulwark\",\"title\":\"The Prussian Bulwark\",\"subtitle\":\"As the Minister-President of Prussia, Braun has power over the Prussian bureaucracy and security services.\",\"chooseIf\":{\"$code\":\"return (((Q['advisor_action_timer'] || 0) <= 0) && ((Q['spd_prussia'] || 0)===1));\"},\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action. \"],\"predicate\":0},{\"type\":\"conditional\",\"content\":\"The SPD does not control Prussia.\",\"predicate\":2}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['spd_prussia'] || 0) == 0);\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['prussian_affairs_timer'] = (Q['prussian_affairs_timer'] || 0) - 6;\\nQ['last_advisor_action'] = 1;\"}],\"goTo\":[{\"id\":\"prussian_affairs\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"baade.rural_campaign\":{\"id\":\"baade.rural_campaign\",\"title\":\"Rural Campaign\",\"subtitle\":\"Try to campaign among the rural populace.\",\"chooseIf\":{\"$code\":\"return (((Q['advisor_action_timer'] || 0) == 0) && ((Q['rural_policy'] || 0) > 0));\"},\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action. \"],\"predicate\":0},{\"type\":\"conditional\",\"content\":\"We have not enacted any rural policies.\",\"predicate\":2}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['rural_policy'] || 0) == 0);\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['rural_spd'] = (Q['rural_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['peoples_party_support'] = (Q['peoples_party_support'] || 0) + 1;\"}],\"content\":{\"content\":\"We have increased our campaigning among farmers and the rural populace.\",\"type\":\"paragraph\"}},\"breitscheid.breitscheid_foreign\":{\"id\":\"breitscheid.breitscheid_foreign\",\"title\":\"Foreign Policy\",\"subtitle\":\"As Foreign Minister, Breitscheid can set our foreign policy.\",\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":\"The SPD is not in government. \",\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"The SPD does not control the Foreign Ministry. \",\"predicate\":1},{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":3},\" months before next advisor action.\"],\"predicate\":2}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (!(((Q['spd_in_government'] || 0)) !== 0));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['foreign_minister_party'] != \\\"SPD\\\");\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}}]},\"chooseIf\":{\"$code\":\"return ((((Q['advisor_action_timer'] || 0) == 0) && (((Q['spd_in_government'] || 0)) !== 0)) && (Q['foreign_minister_party'] == \\\"SPD\\\"));\"},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['foreign_policy_timer'] = (Q['foreign_policy_timer'] || 0) - 8;\\nQ['last_advisor_action'] = 1;\"}],\"goTo\":[{\"id\":\"foreign_policy\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"hilferding.toleration\":{\"id\":\"hilferding.toleration\",\"title\":\"Defending Toleration\",\"subtitle\":\"Hilferding supports cooperation with the bourgeois parties.\",\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action. \"],\"predicate\":0},{\"type\":\"conditional\",\"content\":\"The SPD is not in toleration.\",\"predicate\":2}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (!(((Q['spd_toleration'] || 0)) !== 0));\"}}]},\"chooseIf\":{\"$code\":\"return ((((Q['spd_in_government'] || 0)===0) && ((Q['spd_toleration'] || 0)===1)) && ((Q['advisor_action_timer'] || 0)===0));\"},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) - 10;\\nQ['neorevisionist_dissent'] = (Q['neorevisionist_dissent'] || 0) - 8;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) - 5;\"}],\"content\":{\"content\":\"We have reduced dissent among the anti-toleration factions.\",\"type\":\"paragraph\"}},\"hirschfeld.womens_rights_\":{\"id\":\"hirschfeld.womens_rights_\",\"title\":\"Women's rights\",\"subtitle\":\"Enact policy with regards to women's rights.\",\"chooseIf\":{\"$code\":\"return (((Q['advisor_action_timer'] || 0)===0) && (((Q['spd_in_government'] || 0)) !== 0));\"},\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action. \"],\"predicate\":0},{\"type\":\"conditional\",\"content\":\"The SPD is not currently in government.\",\"predicate\":2}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (!(((Q['spd_in_government'] || 0)) !== 0));\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['womens_rights_timer'] = (Q['womens_rights_timer'] || 0) - 10;\\nQ['last_advisor_action'] = 1;\"}],\"goTo\":[{\"id\":\"womens_rights\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"hirschfeld\":{\"id\":\"hirschfeld\",\"type\":\"scene\",\"title\":\"Magnus Hirschfeld\",\"isPinnedCard\":true,\"tags\":[\"advisor\"],\"cardImage\":\"img/portraits/HirschfeldMagnus.jpg\",\"viewIf\":{\"$code\":\"return ((Q['hirschfeld_advisor'] || 0)===1);\"},\"newPage\":true,\"options\":[{\"id\":\"@hirschfeld.homosexual_rights_\"},{\"id\":\"@hirschfeld.womens_rights_\"},{\"id\":\"@root\",\"title\":\"Return to main\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Magnus Hirschfeld\"},{\"type\":\"paragraph\",\"content\":\"Magnus Hirschfeld is the founder of the Institut für Sexualwissenschaft and an advocate for the rights of sexual minorities.\"}]},\"juchacz.welfare\":{\"id\":\"juchacz.welfare\",\"title\":\"Support Workers' Welfare, our mutual aid organization.\",\"subtitle\":\"-1 resources\",\"chooseIf\":{\"$code\":\"return (((Q['resources'] || 0) > 0) && ((Q['advisor_action_timer'] || 0)===0));\"},\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action. \"],\"predicate\":0},{\"type\":\"conditional\",\"content\":\"Not enough resources.\",\"predicate\":2}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['resources'] || 0) < 0);\"}}]},\"onArrival\":[{\"$code\":\"Q['resources'] = (Q['resources'] || 0) - 1;\\nQ['workers_aid'] = (Q['workers_aid'] || 0) + 1;\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\n if ((((Q['black_thursday_seen'] || 0)) !== 0) ) { Q['workers_spd'] = (Q['workers_spd'] || 0) + (2 * (1 - (Q['dissent'] || 0))); } \\nQ['advisor_action_timer'] = 6;\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"We have increased funding to Workers' Welfare. \",{\"type\":\"conditional\",\"content\":\"In an age of economic crisis, this will be helpful for improving our standing among the unemployed.\",\"predicate\":0}]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['black_thursday_seen'] || 0) > 0);\"}}]}},\"leber.military_affairs\":{\"id\":\"leber.military_affairs\",\"title\":\"Military affairs\",\"subtitle\":\"We can set our military policy.\",\"chooseIf\":{\"$code\":\"return ((((Q['advisor_action_timer'] || 0) == 0) && (((Q['spd_in_government'] || 0)) !== 0)) && (Q['reichswehr_minister_party'] == \\\"SPD\\\"));\"},\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action. \"],\"predicate\":0},{\"type\":\"conditional\",\"content\":\"The SPD is not in government. \",\"predicate\":2},{\"type\":\"conditional\",\"content\":\"The SPD does not have the Reichswehr ministry.\",\"predicate\":3}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (!(((Q['spd_in_government'] || 0)) !== 0));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['reichswehr_minister_party'] != \\\"SPD\\\");\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['last_advisor_action'] = 1;\"}],\"goTo\":[{\"id\":\"military_policy\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"levi.kpd_cooperation\":{\"id\":\"levi.kpd_cooperation\",\"title\":\"Cooperation with the KPD\",\"subtitle\":\"Any cooperation between the parties requires compromise from the KPD as well as the SPD.\",\"unavailableSubtitle\":{\"content\":{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action.\"],\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}}]},\"chooseIf\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0)===0);\"},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['left_strength'] = (Q['left_strength'] || 0) + 5;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) + (6 * (1 - (Q['dissent'] || 0)));\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 3;\\n if (((Q['kpd_cooperation_seen'] || 0) <= 1) ) { Q['communist_coalition'] = (Q['communist_coalition'] || 0) + 1; } \\nQ['kpd_cooperation_seen'] = (Q['kpd_cooperation_seen'] || 0) + 1;\"}],\"content\":{\"content\":\"Levi attempts to reach out to his former colleagues to dissuade the KPD from their current extreme Stalinist path. Some concessions are extracted.\",\"type\":\"paragraph\"}},\"levi\":{\"id\":\"levi\",\"type\":\"scene\",\"title\":\"Paul Levi\",\"isPinnedCard\":true,\"tags\":[\"advisor\",\"left\"],\"cardImage\":\"img/portraits/LeviPaul.jpg\",\"viewIf\":{\"$code\":\"return ((Q['levi_advisor'] || 0)===1);\"},\"newPage\":true,\"options\":[{\"id\":\"@levi.building_the_left\"},{\"id\":\"@levi.kpd_cooperation\"},{\"id\":\"@root\",\"title\":\"Return to main\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Paul Levi\"},{\"type\":\"paragraph\",\"content\":\"Levi is a former leader of the KPD who left over their devotion to violence and revolutionary adventurism.\"}]},\"leipart.depression\":{\"id\":\"leipart.depression\",\"title\":\"Addressing the economic crisis\",\"subtitle\":\"Formulate a plan to get us out of this mess.\",\"chooseIf\":{\"$code\":\"return ((((Q['advisor_action_timer'] || 0) <= 0) && ((Q['wtb_adopted'] || 0)===0)) && (((Q['black_thursday_seen'] || 0)) !== 0));\"},\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action. \"],\"predicate\":0},{\"type\":\"conditional\",\"content\":\"We are not currently in an economic crisis. \",\"predicate\":2},{\"type\":\"conditional\",\"content\":\"We have already adopted the WTB-Plan.\",\"predicate\":3}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['black_thursday_seen'] || 0) == 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['wtb_adopted'] || 0) > 0);\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['wtb_support'] = (Q['wtb_support'] || 0) + 2;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) + 10;\\nQ['labor_strength'] = (Q['labor_strength'] || 0) + 1;\"}],\"content\":{\"content\":\"The WTB-Plan, standing for its primary supporters Woytinsky, Tarnow, and Baade, has been adopted as the unions' plan for getting us out of the depression. Leipart canvasses in favor of this policy throughout the party and the unions.\",\"type\":\"paragraph\"}},\"mierendorff.form_iron_front\":{\"id\":\"mierendorff.form_iron_front\",\"title\":\"Forming the Iron Front\",\"chooseIf\":{\"$code\":\"return ((((Q['advisor_action_timer'] || 0) == 0) && ((Q['iron_front_formed'] || 0) == 0)) && ((Q['nazi_urgency'] || 0) >= 2));\"},\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action. \"],\"predicate\":0},{\"type\":\"conditional\",\"content\":\"The Iron Front has already been formed. \",\"predicate\":2},{\"type\":\"conditional\",\"content\":\"The party does not yet see the danger of the Nazis.\",\"predicate\":3}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['iron_front_formed'] || 0)) !== 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['nazi_urgency'] || 0) < 2);\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['rb_strength'] = (Q['rb_strength'] || 0) + 50;\\nQ['nazi_urgency'] = (Q['nazi_urgency'] || 0) + 1;\"}],\"goTo\":[{\"id\":\"confronting_nazis.iron_front\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"muller.toleration\":{\"id\":\"muller.toleration\",\"title\":\"Defending Toleration\",\"subtitle\":\"Müller supports the toleration arrangement with the bourgeois parties.\",\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action. \"],\"predicate\":0},{\"type\":\"conditional\",\"content\":\"The SPD is not in toleration.\",\"predicate\":2}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (!(((Q['spd_toleration'] || 0)) !== 0));\"}}]},\"chooseIf\":{\"$code\":\"return ((((Q['spd_in_government'] || 0)===0) && ((Q['spd_toleration'] || 0)===1)) && ((Q['advisor_action_timer'] || 0)===0));\"},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) - 8;\\nQ['neorevisionist_dissent'] = (Q['neorevisionist_dissent'] || 0) - 8;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) - 5;\"}],\"content\":{\"content\":\"We have reduced dissent among the anti-toleration factions.\",\"type\":\"paragraph\"}},\"pfulf.build_peoples_party\":{\"id\":\"pfulf.build_peoples_party\",\"title\":\"Building a People's Party\",\"subtitle\":\"Can we expand our party beyond the industrial working class?\",\"viewIf\":{\"$code\":\"return ((Q['peoples_party'] || 0)===0);\"},\"chooseIf\":{\"$code\":\"return (((Q['peoples_party_support'] || 0) >= 3) && ((Q['advisor_action_timer'] || 0)===0));\"},\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action. \"],\"predicate\":0},{\"type\":\"conditional\",\"content\":\"There is not enough support for this policy within the party.\",\"predicate\":2}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['peoples_party_support'] || 0) < 3);\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\"}],\"goTo\":[{\"id\":\"peoples_party\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"radbruch.constitutional_reform_\":{\"id\":\"radbruch.constitutional_reform_\",\"title\":\"Constitutional Reform\",\"subtitle\":\"Pursue reforms of the inadequate Weimar Constitution.\",\"chooseIf\":{\"$code\":\"return ((((((Q['advisor_action_timer'] || 0)===0) && (((Q['spd_in_government'] || 0)) !== 0)) && (Q['justice_minister_party'] == \\\"SPD\\\")) && (((Q['neorevisionism'] || 0)) !== 0)) && ((((((((Q['in_weimar_coalition'] || 0)) !== 0)) || ((((Q['in_spd_majority'] || 0)) !== 0))) || ((((Q['in_left_front'] || 0)) !== 0))) || ((((Q['in_popular_front'] || 0)) !== 0)))));\"},\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action. \"],\"predicate\":0},{\"type\":\"conditional\",\"content\":\"The SPD is not currently in government. \",\"predicate\":2},\" \",{\"type\":\"conditional\",\"content\":\"We do not have the Justice Ministry. \",\"predicate\":3},\" \",{\"type\":\"conditional\",\"content\":\"We do not have ideological support for constitutional reform yet - new ideas are needed. \",\"predicate\":4},\" \",{\"type\":\"conditional\",\"content\":\"Our current governing coalition will not support constitutional reforms.\",\"predicate\":5}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (!(((Q['spd_in_government'] || 0)) !== 0));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['justice_minister_party'] != \\\"SPD\\\");\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (!(((Q['neorevisionism'] || 0)) !== 0));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (!((((((((Q['in_weimar_coalition'] || 0)) !== 0)) || ((((Q['in_spd_majority'] || 0)) !== 0))) || ((((Q['in_left_front'] || 0)) !== 0))) || ((((Q['in_popular_front'] || 0)) !== 0)))));\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['last_advisor_action'] = 1;\"}],\"goTo\":[{\"id\":\"constitutional_reform\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"radbruch\":{\"id\":\"radbruch\",\"type\":\"scene\",\"title\":\"Gustav Radbruch\",\"isPinnedCard\":true,\"tags\":[\"advisor\"],\"cardImage\":\"img/portraits/RadbruchGustav.jpg\",\"viewIf\":{\"$code\":\"return ((Q['radbruch_advisor'] || 0)===1);\"},\"newPage\":true,\"options\":[{\"id\":\"@radbruch.judiciary_\"},{\"id\":\"@radbruch.constitutional_reform_\"},{\"id\":\"@root\",\"title\":\"Return to main\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Gustav Radbruch\"},{\"type\":\"paragraph\",\"content\":\"Gustav Radbruch is a renowned legal scholar and long-time SPD justice minister.\"}]},\"rosenfeld.kpd_cooperation\":{\"id\":\"rosenfeld.kpd_cooperation\",\"title\":\"Cooperation with the KPD\",\"subtitle\":\"Push the party to be more friendly towards the KPD.\",\"unavailableSubtitle\":{\"content\":{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action.\"],\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}}]},\"chooseIf\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0)===0);\"},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['left_strength'] = (Q['left_strength'] || 0) + 5;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 2;\\n if (((Q['kpd_cooperation_seen'] || 0) <= 1) ) { Q['communist_coalition'] = (Q['communist_coalition'] || 0) + 1; } \\nQ['kpd_cooperation_seen'] = (Q['kpd_cooperation_seen'] || 0) + 1;\"}],\"content\":{\"content\":\"Through his work, Rosenfeld has defended individual KPD members; this should make some connections possible.\",\"type\":\"paragraph\"}},\"schumacher.build_reichsbanner\":{\"id\":\"schumacher.build_reichsbanner\",\"title\":\"Reichsbanner\",\"subtitle\":\"Schumacher supports providing more resources to the Reichsbanner.\",\"chooseIf\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0)===0);\"},\"unavailableSubtitle\":{\"content\":{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action.\"],\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['reichsbanner_timer'] = (Q['reichsbanner_timer'] || 0) - 6;\\nQ['last_advisor_action'] = 1;\"}],\"goTo\":[{\"id\":\"reichsbanner\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"severing.police_affairs\":{\"id\":\"severing.police_affairs\",\"title\":\"Police affairs\",\"subtitle\":\"We can set our police policy.\",\"chooseIf\":{\"$code\":\"return ((((Q['advisor_action_timer'] || 0) == 0) && (((Q['spd_in_government'] || 0)) !== 0)) && (Q['interior_minister_party'] == \\\"SPD\\\"));\"},\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action. \"],\"predicate\":0},{\"type\":\"conditional\",\"content\":\"The SPD is not in government. \",\"predicate\":2},{\"type\":\"conditional\",\"content\":\"The SPD does not have the Interior ministry.\",\"predicate\":3}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (!(((Q['spd_in_government'] || 0)) !== 0));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['interior_minister_party'] != \\\"SPD\\\");\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['police_timer'] = (Q['police_timer'] || 0) - 6;\\nQ['last_advisor_action'] = 1;\"}],\"goTo\":[{\"id\":\"police\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"severing\":{\"id\":\"severing\",\"type\":\"scene\",\"title\":\"Carl Severing\",\"isPinnedCard\":true,\"tags\":[\"advisor\",\"reformist\"],\"cardImage\":\"img/portraits/SeveringCarl.jpg\",\"viewIf\":{\"$code\":\"return ((Q['severing_advisor'] || 0)===1);\"},\"newPage\":true,\"options\":[{\"id\":\"@severing.prussian_bulwark\"},{\"id\":\"@severing.police_affairs\"},{\"id\":\"@root\",\"title\":\"Return to main\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Carl Severing\"},{\"type\":\"paragraph\",\"content\":\"Severing has been Interior Minister for both the German Republic and for the state of Prussia, and his priority is using the security services to target the enemies of the republic.\"}]},\"sender.organizing_women\":{\"id\":\"sender.organizing_women\",\"title\":\"Organizing women\",\"subtitle\":\"Sender's strategies are aimed at young working women.\",\"chooseIf\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0)===0);\"},\"unavailableSubtitle\":{\"content\":{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action.\"],\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}}]},\"onArrival\":[{\"$code\":\"Q['womens_rights'] = (Q['womens_rights'] || 0) + 1;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['advisor_action_timer'] = 6;\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"Sender's message is popular among young women working in the service sector, and we have recruited many white-collar employees.\"},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":\"Unfortunately, women still disproportionately support the bourgeois parties.\",\"predicate\":0}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['spd_r'] || 0) < 50);\"}}]}},\"seydewitz.socialist_youth\":{\"id\":\"seydewitz.socialist_youth\",\"title\":\"Support the Socialist Youth\",\"subtitle\":\"We must end our reputation as a party for old men by increasing funding to the youth organizations. -1 resources\",\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action. \"],\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"Not enough resources.\",\"predicate\":2}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['resources'] || 0) <= 0);\"}}]},\"chooseIf\":{\"$code\":\"return (((Q['advisor_action_timer'] || 0)===0) && ((Q['resources'] || 0) > 0));\"},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['resources'] = (Q['resources'] || 0) - 1;\\nQ['left_strength'] = (Q['left_strength'] || 0) + 5;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) - 3;\\nQ['rb_strength'] = (Q['rb_strength'] || 0) + 50;\\nQ['rb_militancy'] = (Q['rb_militancy'] || 0) + 0.025;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (2 * (1 - (Q['dissent'] || 0)));\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) + 1;\"}],\"content\":{\"content\":\"Seydewitz supports building up the Socialist Youth, which attracts support to the Left and increases the militancy of the Reichsbanner.\",\"type\":\"paragraph\"}},\"stampfer.faction_support_\":{\"id\":\"stampfer.faction_support_\",\"title\":\"Editorial Line\",\"subtitle\":\"We can change the editorial line of Vorwärts to support a particular faction.\",\"chooseIf\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0)===0);\"},\"unavailableSubtitle\":{\"content\":{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action.\"],\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\"}],\"options\":[{\"id\":\"@stampfer.support_left\",\"title\":\"Left\"},{\"id\":\"@stampfer.support_center\",\"title\":\"Center\"},{\"id\":\"@stampfer.support_labor\",\"title\":\"Labor\"},{\"id\":\"@stampfer.support_reform\",\"title\":\"Reformists\"},{\"id\":\"@stampfer.support_neorev\",\"title\":\"Neorevisionists\"}],\"content\":{\"content\":\"Which faction should we support?\",\"type\":\"paragraph\"}},\"wels.party_discipline\":{\"id\":\"wels.party_discipline\",\"title\":\"Party Discipline\",\"subtitle\":\"Reduce dissent across the party.\",\"chooseIf\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0)===0);\"},\"unavailableSubtitle\":{\"content\":{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action.\"],\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) - 5;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) - 10;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) - 10;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) - 10;\\nQ['neorevisionist_dissent'] = (Q['neorevisionist_dissent'] || 0) - 5;\"}],\"content\":{\"content\":\"We have enforced party discipline to reduce dissent across all factions.\",\"type\":\"paragraph\"}},\"wissell.union_unity\":{\"id\":\"wissell.union_unity\",\"title\":\"Union-party coordination\",\"subtitle\":\"Reduce dissent among the unions.\",\"chooseIf\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) <= 0);\"},\"unavailableSubtitle\":{\"content\":{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action.\"],\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) - 5;\\nQ['labor_strength'] = (Q['labor_strength'] || 0) + 5;\"}],\"content\":{\"content\":\"We have reduced tensions with the Labor faction, and increased its strength in the party.\",\"type\":\"paragraph\"}},\"wissell\":{\"id\":\"wissell\",\"type\":\"scene\",\"title\":\"Rudolf Wissell\",\"isPinnedCard\":true,\"tags\":[\"advisor\",\"labor\"],\"cardImage\":\"img/portraits/WissellRudolf.jpg\",\"viewIf\":{\"$code\":\"return ((Q['wissell_advisor'] || 0)===1);\"},\"newPage\":true,\"options\":[{\"id\":\"@wissell.labor_rights_\"},{\"id\":\"@wissell.union_unity\"},{\"id\":\"@root\",\"title\":\"Return to main\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Rudolf Wissell\"},{\"type\":\"paragraph\",\"content\":\"Wissell is a labor economist working for the ADGB, the federation of free trade unions, and has been a labor minister on multiple occasions. His priority is to improve conditions for organized workers.\"}]},\"coalition_affairs.resources\":{\"id\":\"coalition_affairs.resources\",\"subtitle\":\"-2 resources\",\"viewIf\":{\"$code\":\"return ((Q['historical_mode'] || 0)===0);\"},\"unavailableSubtitle\":\"Not enough resources (need 2).\",\"chooseIf\":{\"$code\":\"return ((Q['resources'] || 0) >= 2);\"},\"onArrival\":[{\"$code\":\"Q['resources'] = (Q['resources'] || 0) - 2;\\nQ['coalition_dissent'] = (Q['coalition_dissent'] || 0) - 1;\"}],\"content\":{\"content\":\"By transferring campaign funds to our coalition partners, we can make our policies more acceptable to them. Some would call this corruption, but perhaps it is necessary to save democracy.\",\"type\":\"paragraph\"}},\"agricultural_policy.agricultural_finance\":{\"id\":\"agricultural_policy.agricultural_finance\",\"title\":\"Agricultural Financing\",\"subtitle\":\"-1 budget - Increase financing for agricultural credit and insurance.\",\"chooseIf\":{\"$code\":\"return ((Q['budget'] || 0) >= 1);\"},\"onArrival\":[{\"$code\":\"Q['budget'] = (Q['budget'] || 0) - 1;\\nQ['agricultural_finance'] = (Q['agricultural_finance'] || 0) + 1;\\nQ['rural_spd'] = (Q['rural_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['rural_nsdap'] = (Q['rural_nsdap'] || 0) - (3 * (1 - (Q['dissent'] || 0)));\\nQ['peoples_party_support'] = (Q['peoples_party_support'] || 0) + 1;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) + 5;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 4;\\nQ['rural_sol'] = (Q['rural_sol'] || 0) + 4;\\nQ['rural_policy'] = (Q['rural_policy'] || 0) + 1;\"}],\"content\":{\"content\":\"We have increased financial support for small farmers, providing access to credit and insurance, saving them from privation. The left and center of our party are opposed to our rural policy, seeing these policies as giveaways to petit-bourgeois farmers.\",\"type\":\"paragraph\"}},\"dealing_with_toleration.vonc\":{\"id\":\"dealing_with_toleration.vonc\",\"onArrival\":[{\"$code\":\"Q['spd_in_government'] = 0;\\nQ['spd_toleration'] = 0;\\nQ['in_grand_coalition'] = 0;\\nQ['chancellor'] = \\\"Brüning\\\";\\nQ['chancellor_party'] = \\\"Z\\\";\\n if (((Q['next_election_time'] || 0) > ((Q['time'] || 0) + 3)) ) { Q['next_election_time'] = ((Q['time'] || 0) + 3); } \\n if (((Q['next_election_time'] || 0) >= ((Q['time'] || 0) + 3)) ) { Q['next_election_month'] = ((Q['month'] || 0) + 3); } \\n if (((Q['next_election_time'] || 0) >= ((Q['time'] || 0) + 3)) ) { Q['next_election_year'] = (Q['year'] || 0); } \\n if (((Q['next_election_month'] || 0) > 12) ) { Q['next_election_year'] = (Q['next_election_year'] || 0) + 1; } \\n if (((Q['next_election_month'] || 0) > 12) ) { Q['next_election_month'] = (Q['next_election_month'] || 0) - 12; } \\nQ['spd_toleration'] = 0;\\nQ['left_strength'] = (Q['left_strength'] || 0) + 8;\\nQ['pro_republic'] = (Q['pro_republic'] || 0) - 5;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) - 3;\\nQ['rural_spd'] = (Q['rural_spd'] || 0) - 3;\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) - 3;\\nQ['catholics_spd'] = (Q['catholics_spd'] || 0) - 3;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 5;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) - 5;\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[\"We have called for a vote of no confidence, and have brought down this government. Chancellor \",{\"type\":\"insert\",\"insert\":0},\" currently rules as acting chancellor.\"]},{\"type\":\"paragraph\",\"content\":[\"New elections have been set for \",{\"type\":\"insert\",\"insert\":1},\" \",{\"type\":\"insert\",\"insert\":2},\".\"]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_month'] || 0);\"},\"qdisplay\":\"month\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_year'] || 0);\"}}]}},\"deport_hitler.deport_violence\":{\"id\":\"deport_hitler.deport_violence\",\"options\":[{\"id\":\"@deport_hitler.force_approach\",\"title\":\"Force the approach!\"},{\"id\":\"@deport_hitler.no_deport\",\"title\":\"Cancel the deportation.\"}],\"content\":{\"content\":\"When the police approach, he is surrounded by his SA guards, preventing him from being extricated! We can attempt to force a confrontation, but that may have negative consequences. The Reichsbanner may also attempt to draw off the SA.\",\"type\":\"paragraph\"}},\"woytinsky.carry_out_policy\":{\"id\":\"woytinsky.carry_out_policy\",\"title\":\"Carry out the economic plan.\",\"subtitle\":\"If we are in government, we can carry out a public works program such as the WTB-Plan.\",\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action. \"],\"predicate\":0},{\"type\":\"conditional\",\"content\":\"We have not yet adopted an economic plan. \",\"predicate\":2},{\"type\":\"conditional\",\"content\":\"The SPD is not in government. \",\"predicate\":3},{\"type\":\"conditional\",\"content\":\"We have already started implementing the plan.\",\"predicate\":4}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['wtb_adopted'] || 0) == 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['spd_in_government'] || 0) == 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['works_program'] || 0) >= 2);\"}}]},\"chooseIf\":{\"$code\":\"return (((((Q['advisor_action_timer'] || 0) <= 0) && (((Q['wtb_adopted'] || 0)) !== 0)) && (((Q['spd_in_government'] || 0)) !== 0)) && ((Q['wtb_implemented'] || 0) <= 1));\"},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['economic_policy_timer'] = (Q['economic_policy_timer'] || 0) - 12;\"}],\"goTo\":[{\"id\":\"economic_policy\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"economic_democracy.expand_councils_2\":{\"id\":\"economic_democracy.expand_councils_2\",\"title\":\"Support national and sectorial works councils.\",\"subtitle\":\"This is a step towards workers' control over the entire economy.\",\"viewIf\":{\"$code\":\"return ((Q['works_councils'] || 0) == 1);\"},\"onArrival\":[{\"$code\":\"Q['economic_democracy'] = (Q['economic_democracy'] || 0) + 1;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (7 * (1 - (Q['dissent'] || 0)));\\nQ['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) + 1;\\nQ['works_councils'] = (Q['works_councils'] || 0) + 1;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) - 6;\\nQ['labor_strength'] = (Q['labor_strength'] || 0) + 8;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 5;\\n if ((((Q['in_grand_coalition'] || 0)) !== 0) ) { Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1; }\"}],\"maxVisits\":1,\"content\":{\"content\":\"National and sectorial workers councils have been part of the Weimar Constitution, but they were disempowered in the past, acting as nothing more than advisory bodies. We can change that.\",\"type\":\"paragraph\"},\"countVisitsMax\":1},\"economic_policy.wtb_2_deficit\":{\"id\":\"economic_policy.wtb_2_deficit\",\"title\":\"Continue the implementation of the WTB-Plan.\",\"subtitle\":\"-3 budget - we will enter a deficit.\",\"unavailableSubtitle\":\"Unemployment is low enough that we should not do deficit spending.\",\"viewIf\":{\"$code\":\"return ((((Q['wtb_implemented'] || 0) > 2) && ((Q['budget'] || 0) < 3)) && ((Q['budget'] || 0) >= -3));\"},\"chooseIf\":{\"$code\":\"return ((Q['unemployed'] || 0) > 10);\"},\"onArrival\":[{\"$code\":\"Q['works_program'] = (Q['works_program'] || 0) + 1;\\nQ['budget'] = (Q['budget'] || 0) - 3;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (6 * (1 - (Q['dissent'] || 0)));\\nQ['workers'] = (Q['workers'] || 0) + 2;\\n if (((Q['unemployed'] || 0) > 8) ) { Q['unemployed'] = (Q['unemployed'] || 0) - 3; } \\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (6 * (1 - (Q['dissent'] || 0)));\\nQ['workers_kpd'] = (Q['workers_kpd'] || 0) - 2;\\nQ['workers_nsdap'] = (Q['workers_nsdap'] || 0) - 2;\\nQ['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1;\\nQ['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) + 1;\\nQ['wtb_implemented'] = (Q['wtb_implemented'] || 0) + 1;\\nQ['kpd_coalition_dissent'] = (Q['kpd_coalition_dissent'] || 0) + 1;\\n if (((((Q['in_popular_front'] || 0)) !== 0) || (((Q['in_left_front'] || 0)) !== 0)) ) { Q['kpd_relation'] = (Q['kpd_relation'] || 0) - 5; } \\nQ['inflation'] = (Q['inflation'] || 0) + 3;\"}],\"content\":{\"content\":\"We have continued our implementation of the WTB-Plan, despite the continued deficit spending. In addition to public works, we are now focusing on rebuilding our industries.\",\"type\":\"paragraph\"}},\"domestic_enemies.unban_sa\":{\"id\":\"domestic_enemies.unban_sa\",\"viewIf\":{\"$code\":\"return ((Q['sa_banned'] || 0)===1);\"},\"onArrival\":[{\"$code\":\"Q['sa_banned'] = 0;\\nQ['sa_strength'] = (Q['sa_strength'] || 0) + 100;\\nQ['sa_militancy'] = (Q['sa_militancy'] || 0) + 0.05;\"}],\"content\":{\"content\":\"The SA is no longer banned. They immediately go on a recruiting spree.\",\"type\":\"paragraph\"}},\"foreign_policy.improve_west\":{\"id\":\"foreign_policy.improve_west\",\"title\":\"Improve our relations with the Western Allies.\",\"onArrival\":[{\"$code\":\"Q['west_relation'] = (Q['west_relation'] || 0) + 2;\\nQ['reparations_negotiation'] = (Q['reparations_negotiation'] || 0) + 1;\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"The key to peace in Europe is a rapproachment between France and Germany. We are taking steps towards that rapproachment. \",{\"type\":\"conditional\",\"content\":\"This is difficult to do when France is occupying a major portion of Germany's territory, but we are working on that part.\",\"predicate\":0}]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['young_plan_seen'] || 0) == 0);\"}}]}},\"homosexual_rights.reform_183\":{\"id\":\"homosexual_rights.reform_183\",\"subtitle\":\"Paragraph 183 criminalizes public homosexual displays and cross-dressing. We can change that.\",\"unavailableSubtitle\":\"We do not have majority support for this policy.\",\"viewIf\":{\"$code\":\"return ((Q['reformed_183'] || 0) == 0);\"},\"chooseIf\":{\"$code\":\"return ((Q['progressive_coalition'] || 0) >= 50);\"},\"onArrival\":[{\"$code\":\"Q['reformed_183'] = 1;\\nQ['homosexual_rights'] = (Q['homosexual_rights'] || 0) + 1;\\nQ['z_relation'] = (Q['z_relation'] || 0) - 5;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\nQ['ddp_relation'] = (Q['ddp_relation'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\n if ((((((Q['in_grand_coalition'] || 0)) !== 0) || (((Q['in_weimar_coalition'] || 0)) !== 0))) ) { Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1; } \\nQ['catholics_spd'] = (Q['catholics_spd'] || 0) - 4;\"}],\"content\":{\"content\":\"Voting together with the progressives in the KPD and DDP, we have reformed Paragraph 183 so that it no longer criminalizes public homosexuality and cross-dressing.\",\"type\":\"paragraph\"}},\"fiscal_policy.raise_progressive\":{\"id\":\"fiscal_policy.raise_progressive\",\"subtitle\":\"This does not change overall revenue.\",\"onArrival\":[{\"$code\":\"Q['workers_spd'] = (Q['workers_spd'] || 0) + (6 * (1 - (Q['dissent'] || 0)));\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) - 3;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) - 3;\\n if ((((Q['in_grand_coalition'] || 0)) !== 0) ) { Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1; } \\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 4;\\nQ['finance_goal_completed'] = (Q['finance_goal_completed'] || 0) + 1;\\nQ['upper_tax_rates'] = (Q['upper_tax_rates'] || 0) + 1;\\nQ['lower_tax_rates'] = (Q['lower_tax_rates'] || 0) - 1;\\nQ['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) + 1;\\n if (((Q['upper_tax_rates'] || 0) > 1) ) { Q['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) + 1; } \\n if (((Q['upper_tax_rates'] || 0) > 3) ) { Q['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) + 1; }\"}],\"content\":{\"content\":\"Making the tax system more progressive is popular among our base, but it upsets our bourgeois coalition partners, as well as our minimal number of bourgeois voters.\",\"type\":\"paragraph\"}},\"labor_affairs.support_employers\":{\"id\":\"labor_affairs.support_employers\",\"subtitle\":\"Popular among the bourgeoisie, much less so among the workers.\",\"onArrival\":[{\"$code\":\"Q['labor_dissent'] = (Q['labor_dissent'] || 0) + 8;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 3;\\n if (((Q['coalition_dissent'] || 0) > 0) ) { Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) - 1; } \\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) + 5;\\nQ['z_relation'] = (Q['z_relation'] || 0) + 5;\\nQ['workers_kpd'] = (Q['workers_kpd'] || 0) + 3;\\nQ['kpd_coalition_dissent'] = (Q['kpd_coalition_dissent'] || 0) + 1;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) - 8;\\n if (((Q['capital_strike_progress'] || 0) > 1) ) { Q['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) - 1; } \\n if (((Q['capital_strike_progress'] || 0) > 8) ) { Q['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) - 1; } \\nQ['pro_labor'] = (Q['pro_labor'] || 0) - 1;\\nQ['strike_term_seen'] = (Q['strike_term_seen'] || 0) + 1;\"}],\"content\":{\"content\":\"The more radical workers despise our suppression of their strikes, recalling the days of Friedrich Ebert.\",\"type\":\"paragraph\"}},\"military_policy.decrease_funding\":{\"id\":\"military_policy.decrease_funding\",\"subtitle\":\"+1 budget\",\"unavailableSubtitle\":\"There is nothing left to cut.\",\"chooseIf\":{\"$code\":\"return ((Q['reichswehr_strength'] || 0) > 0);\"},\"onArrival\":[{\"$code\":\"Q['budget'] = (Q['budget'] || 0) + 1;\\n if (((Q['in_grand_coalition'] || 0) == 1) ) { Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1; } \\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 8;\\nQ['reichswehr_militancy'] = (Q['reichswehr_militancy'] || 0) - 1;\\nQ['reichswehr_strength'] = (Q['reichswehr_strength'] || 0) - 20;\\nQ['sh_strength'] = (Q['sh_strength'] || 0) + 15;\\nQ['sa_strength'] = (Q['sa_strength'] || 0) + 5;\\nQ['sh_militancy'] = (Q['sh_militancy'] || 0) + 0.05;\\n if (((Q['reichswehr_loyalty'] || 0) > 0) ) { Q['reichswehr_loyalty'] = (Q['reichswehr_loyalty'] || 0) - 0.05; } \\nQ['coup_progress'] = (Q['coup_progress'] || 0) + 1;\\n if (((Q['reichswehr_loyalty'] || 0) < 0.2) ) { Q['coup_progress'] = (Q['coup_progress'] || 0) + 1; } \\n if (((Q['reichswehr_loyalty'] || 0) < 0.1) ) { Q['coup_progress'] = (Q['coup_progress'] || 0) + 1; } \\n if (((Q['reichswehr_loyalty'] || 0) <= 0) ) { Q['coup_progress'] = (Q['coup_progress'] || 0) + 1; } \\nQ['reichswehr_goal_completed'] = 1;\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"The military has fewer guns and fewer soldiers. There is no hint of a coup yet, but we do not know where the line will be drawn. The center-right parties are committed to the military and deeply opposed to our budget cuts.\"},{\"type\":\"paragraph\",\"content\":\"Many demobilized soldiers have joined the right-wing paramilitaries such as the Stahlhelm and SA, and weapons are missing from our stockpiles.\"}]},\"labor_rights.working_hours\":{\"id\":\"labor_rights.working_hours\",\"viewIf\":{\"$code\":\"return ((Q['working_hours'] || 0) < 2);\"},\"onArrival\":[{\"$code\":\"Q['working_hours'] = (Q['working_hours'] || 0) + 1;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) - 8;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) - 5;\\nQ['labor_strength'] = (Q['labor_strength'] || 0) + 5;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (7 * (1 - (Q['dissent'] || 0)));\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 4;\\nQ['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1;\\n if (((Q['dvp_relation'] || 0) <= 30) ) { Q['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) + 1; } \\nQ['labor_goal_completed'] = 1;\\nQ['inflation'] = (Q['inflation'] || 0) + 0.1;\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"While a 40-hour work week was declared during the German Revolution in 1918, enforcement has become increasingly porous over the years. The capitalists have successfully added numerous exceptions and loopholes, returning to the old regime of forced overtime for workers.\"},{\"type\":\"paragraph\",\"content\":\"Now, with the force of the Labor Ministry, we are finally enforcing the rights of workers to their own time. The bourgeoisie and their political representatives are displeased.\"}]},\"police.investigate_corruption\":{\"id\":\"police.investigate_corruption\",\"goTo\":[{\"id\":\"police.investigate_corruption_success\",\"predicate\":{\"$code\":\"return ((Q['interior_police_loyalty'] || 0) >= 0.5);\"}},{\"id\":\"police.investigate_corruption_failure\",\"predicate\":{\"$code\":\"return ((Q['interior_police_loyalty'] || 0) < 0.5);\"}}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"prussian_affairs.police_strength\":{\"id\":\"prussian_affairs.police_strength\",\"onArrival\":[{\"$code\":\"Q['prussian_police_strength'] = (Q['prussian_police_strength'] || 0) + 20;\"}],\"content\":{\"content\":\"We have increased the size of the Prussian police.\",\"type\":\"paragraph\"}},\"social_welfare.increase_spending_pre_depression\":{\"id\":\"social_welfare.increase_spending_pre_depression\",\"viewIf\":{\"$code\":\"return ((Q['unemployed'] || 0) <= 15);\"},\"chooseIf\":{\"$code\":\"return ((Q['budget'] || 0) > 0);\"},\"subtitle\":\"-1 Budget\",\"onArrival\":[{\"$code\":\"Q['budget'] = (Q['budget'] || 0) - 1;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (6 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (6 * (1 - (Q['dissent'] || 0)));\\nQ['welfare'] = (Q['welfare'] || 0) + 1;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) - 5;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) - 5;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) - 5;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) - 5;\\nQ['neorevisionist_dissent'] = (Q['neorevisionist_dissent'] || 0) - 5;\\n if (((Q['welfare'] || 0) > 1) ) { Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1; } \\nQ['welfare_goal_completed'] = (Q['welfare_goal_completed'] || 0) + 1;\\nQ['inflation'] = (Q['inflation'] || 0) + 0.3;\\nQ['unemployed'] = (Q['unemployed'] || 0) - 0.4;\"}],\"content\":{\"content\":\"We have increased welfare spending. Our proletarian base is pleased.\",\"type\":\"paragraph\"}},\"womens_rights.family\":{\"id\":\"womens_rights.family\",\"subtitle\":\"Change family and inheritance law to treat women more equally.\",\"onArrival\":[{\"$code\":\"Q['family_law'] = (Q['family_law'] || 0) + 1;\\nQ['womens_rights'] = (Q['womens_rights'] || 0) + 1;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) + (2 * (1 - (Q['dissent'] || 0)));\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) - 2;\\nQ['rural_spd'] = (Q['rural_spd'] || 0) - 2;\\nQ['catholics_spd'] = (Q['catholics_spd'] || 0) - 4;\\nQ['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1;\"}],\"maxVisits\":2,\"content\":{\"content\":\"These policies aim to ensure that women have equal rights within a marriage, including the right to divorce. The more conservative segments of society treat our reforms as deleterious to the social fabric.\",\"type\":\"paragraph\"},\"countVisitsMax\":2},\"war_guilt.pure_history\":{\"id\":\"war_guilt.pure_history\",\"content\":{\"content\":\"The history is being compiled, as it always has been.\",\"type\":\"paragraph\"}},\"judiciary.minor_reforms\":{\"id\":\"judiciary.minor_reforms\",\"onArrival\":[{\"$code\":\"Q['democratization'] = (Q['democratization'] || 0) + 1;\\n if (((Q['democratization'] || 0) >= 3) ) { Q['workers_spd'] = (Q['workers_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0))); } \\nQ['judicial_reform'] = (Q['judicial_reform'] || 0) + 1;\\nQ['pro_republic'] = (Q['pro_republic'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\nQ['judiciary_timer'] = (Q['judiciary_timer'] || 0) + 6;\"}],\"content\":{\"content\":\"We try to remove the most obviously biased and corrupt jurists, while leaving most of the system intact. It is slow work reforming the judiciary.\",\"type\":\"paragraph\"}},\"all_quiet.allow\":{\"id\":\"all_quiet.allow\",\"onArrival\":[{\"$code\":\"Q['nationalism'] = (Q['nationalism'] || 0) + 3;\\nQ['old_middle_nsdap'] = (Q['old_middle_nsdap'] || 0) + 4;\\nQ['new_middle_nsdap'] = (Q['new_middle_nsdap'] || 0) + 3;\\nQ['workers_nsdap'] = (Q['workers_nsdap'] || 0) + 1;\\nQ['sa_strength'] = (Q['sa_strength'] || 0) + 15;\\nQ['pro_republic'] = (Q['pro_republic'] || 0) - 3;\\nQ['strife'] = (Q['strife'] || 0) + 1;\"}],\"content\":{\"content\":\"While we allow the film, showings are marred by violence. Showings of the film eventually stop, and the Nazis claim victory.\",\"type\":\"paragraph\"}},\"austrian_customs_union.end_coalition\":{\"id\":\"austrian_customs_union.end_coalition\",\"viewIf\":{\"$code\":\"return ((Q['spd_in_government'] || 0)===1);\"},\"onArrival\":[{\"$code\":\"Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 5;\\nQ['z_relation'] = (Q['z_relation'] || 0) - 4;\\n if ((Q['chancellor_party'] == \\\"Z\\\") ) { Q['z_relation'] = (Q['z_relation'] || 0) - 3; } \\n if ((Q['chancellor_party'] == \\\"Z\\\") ) { Q['dvp_relation'] = (Q['dvp_relation'] || 0) - 3; }\"}],\"content\":{\"content\":\"We attempt to impress upon our coalition partners the gravity of the potential Allied response. The proposal is dead, although the DVP and Center are not pleased.\",\"type\":\"paragraph\"}},\"banking_crisis.stabilization\":{\"id\":\"banking_crisis.stabilization\",\"viewIf\":{\"$code\":\"return ((Q['spd_in_government'] || 0)===1);\"},\"subtitle\":\"-1 budget\",\"chooseIf\":{\"$code\":\"return ((Q['budget'] || 0) >= 1);\"},\"onArrival\":[{\"$code\":\"Q['workers_spd'] = (Q['workers_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) + (2 * (1 - (Q['dissent'] || 0)));\\nQ['rural_spd'] = (Q['rural_spd'] || 0) + (2 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed'] = (Q['unemployed'] || 0) - 2;\\n if (((Q['inflation'] || 0) < 0) ) { Q['inflation'] = (Q['inflation'] || 0) + 1; } \\nQ['budget'] = (Q['budget'] || 0) - 1;\\nQ['workers_nsdap'] = (Q['workers_nsdap'] || 0) - 3;\"}],\"content\":{\"content\":\"In the face of the banking crisis, we have taken emergency action to stabilize the economy. It might not be not enough.\",\"type\":\"paragraph\"}},\"black_thursday.do_something\":{\"id\":\"black_thursday.do_something\",\"onArrival\":[{\"$code\":\"Q['crisis_urgency'] = (Q['crisis_urgency'] || 0) + 1;\"}],\"content\":{\"content\":\"What can we do to staunch the workers' suffering? It is becoming a hotly debated question.\",\"type\":\"paragraph\"}},\"black_thursday\":{\"id\":\"black_thursday\",\"type\":\"scene\",\"title\":\"Black Thursday\",\"subtitle\":\"The great stock market crash...\",\"newPage\":true,\"onArrival\":[{\"$code\":\"Q['black_thursday_seen'] = 1;\\nQ['workers_kpd'] = (Q['workers_kpd'] || 0) + 5;\\nQ['workers_nsdap'] = (Q['workers_nsdap'] || 0) + 3;\\nQ['new_middle_nsdap'] = (Q['new_middle_nsdap'] || 0) + 4;\\nQ['old_middle_nsdap'] = (Q['old_middle_nsdap'] || 0) + 5;\\nQ['rural_nsdap'] = (Q['rural_nsdap'] || 0) + 5;\\nQ['unemployed_nsdap'] = (Q['unemployed_nsdap'] || 0) + 5;\\nQ['unemployed'] = (Q['unemployed'] || 0) + 2;\\n if (((Q['budget'] || 0) > 0) ) { Q['budget'] = (Q['budget'] || 0) - 1; } \\n if (((Q['dues'] || 0) > 2) ) { Q['dues'] = (Q['dues'] || 0) - 1; } \\nQ['inflation'] = (Q['inflation'] || 0) - 1;\"}],\"tags\":[\"event\"],\"viewIf\":{\"$code\":\"return (((Q['year'] || 0)===1929) && ((Q['month'] || 0) >= 10));\"},\"maxVisits\":1,\"faceImage\":\"img/bankrun.jpg\",\"options\":[{\"id\":\"@black_thursday.cap\",\"title\":\"It is the nature of capitalism...\"},{\"id\":\"@black_thursday.do_something\",\"title\":\"We must do something to stop the suffering...\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Black Thursday\"},{\"type\":\"paragraph\",\"content\":\"The stock market in America has had its biggest crash in history. It is too early to tell what the international effects will be, but it cannot be good. Our economy is already feeling the effects - unemployment will rise even more, and wages will fall. As always, it is the capitalists' crisis, and the workers' burden.\"}],\"countVisitsMax\":1},\"blutmai.corrupt_police\":{\"id\":\"blutmai.corrupt_police\",\"onArrival\":[{\"$code\":\"Q['kpd_relation'] = (Q['kpd_relation'] || 0) + 10;\\nQ['z_relation'] = (Q['z_relation'] || 0) - 2;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 2;\\nQ['prussian_police_loyalty'] = (Q['prussian_police_loyalty'] || 0) + 0.05;\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[\"We arrested the police responsible for the killings, and put them on trial. \",{\"type\":\"conditional\",\"content\":\"Unfortunately, the reactionary judiciary let them go free with barely any punishment at all. \",\"predicate\":0},\"\"]},{\"type\":\"paragraph\",\"content\":\"This assuages some of the Communists' outrage, but certainly not all.\"}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['judicial_reform'] || 0)===0);\"}}]}},\"altona_clashes.allow_police\":{\"id\":\"altona_clashes.allow_police\",\"goTo\":[{\"id\":\"altona_clashes.allow_police_violence\",\"predicate\":{\"$code\":\"return ((Q['prussian_police_loyalty'] || 0) <= 0.75);\"}},{\"id\":\"altona_clashes.allow_police_no_violence\",\"predicate\":{\"$code\":\"return ((Q['prussian_police_loyalty'] || 0) > 0.75);\"}}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"businesses_lose_confidence.welfare\":{\"id\":\"businesses_lose_confidence.welfare\",\"onArrival\":[{\"$code\":\"Q['welfare'] = (Q['welfare'] || 0) - 1;\\nQ['budget'] = (Q['budget'] || 0) + 1;\\nQ['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) - 2;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 5;\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) - 5;\\nQ['unemployed'] = (Q['unemployed'] || 0) - 1;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 5;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) + 5;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) + 5;\\nQ['kpd_coalition_dissent'] = (Q['kpd_coalition_dissent'] || 0) + 1;\\nQ['inflation'] = (Q['inflation'] || 0) - 1;\"}],\"content\":{\"content\":\"Cutting welfare improves our relationship with the capitalists, but it hurts our working-class base.\",\"type\":\"paragraph\"}},\"capital_strike.capital_controls\":{\"id\":\"capital_strike.capital_controls\",\"title\":\"Enact capital controls to lessen the impact.\",\"chooseIf\":{\"$code\":\"return ((Q['judicial_reform'] || 0) >= 2);\"},\"unavailableSubtitle\":\"The judiciary would never allow this.\",\"onArrival\":[{\"$code\":\"Q['unemployed'] = (Q['unemployed'] || 0) - 1.5;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (6 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (6 * (1 - (Q['dissent'] || 0)));\"}],\"content\":{\"content\":\"Capital controls might blunt some of the worst economic components of the capital strike.\",\"type\":\"paragraph\"}},\"center_party_conference.joos\":{\"id\":\"center_party_conference.joos\",\"unavailableSubtitle\":\"Our relations are not good enough.\",\"subtitle\":\"Joos is likely to be friendlier to us than Kaas.\",\"chooseIf\":{\"$code\":\"return ((Q['z_relation'] || 0) >= 70);\"},\"onArrival\":[{\"$code\":\"Q['z_party_leader'] = \\\"Joos\\\";\\nQ['catholics_spd'] = (Q['catholics_spd'] || 0) + 5;\\nQ['workers_z'] = (Q['workers_z'] || 0) + 3;\"}],\"content\":{\"content\":\"With our grassroots connections, we have been able to influence the Center delegates to support Joseph Joos as the new Center chairman. He has long been a friend of the SPD, and will be more inclined to collaborate with us compared to Kaas. He also increases the appeal of the Center Party to the working class.\",\"type\":\"paragraph\"}},\"death_of_muller.braun_chancellor\":{\"id\":\"death_of_muller.braun_chancellor\",\"onArrival\":[{\"$code\":\"Q['chancellor'] = \\\"Braun\\\";\\nQ['chancellor_party'] = \\\"SPD\\\";\\nQ['z_relation'] = (Q['z_relation'] || 0) - 5;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 5;\"}],\"subtitle\":\"The Center Party is worried about having so much power in one man.\",\"content\":{\"content\":\"Our coalition partners are reluctant to accept the new Chancellor, but they do not make loud objections.\",\"type\":\"paragraph\"}},\"civil_war.rw_help\":{\"id\":\"civil_war.rw_help\",\"maxVisits\":1,\"goTo\":[{\"id\":\"civil_war.war_menu\"}],\"onArrival\":[{\"$code\":\"Q['war_choices'] = (Q['war_choices'] || 0) + 1;\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"We have urged the Reichswehr to stand down, to avoid killing their countrymen. \",{\"type\":\"conditional\",\"content\":\"Unfortunately, few heed our calls; the Reichswhere detest us. \",\"predicate\":0},{\"type\":\"conditional\",\"content\":\"Some officers and troops heed our calls to not fight against us. Some even join us. \",\"predicate\":1},{\"type\":\"conditional\",\"content\":\"The Reichswehr is split. Many avoid taking a side, or join our side. \",\"predicate\":2},{\"type\":\"conditional\",\"content\":\"Surprisingly, the majority of the Reichswehr is on our side! Our preparations have worked.\",\"predicate\":3}]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['reichswehr_loyalty'] || 0) < 0.2);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['reichswehr_loyalty'] || 0) >= 0.2) && ((Q['reichswehr_loyalty'] || 0) < 0.4));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['reichswehr_loyalty'] || 0) >= 0.4) && ((Q['reichswehr_loyalty'] || 0) < 0.6));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['reichswehr_loyalty'] || 0) >= 0.6);\"}}]},\"countVisitsMax\":1},\"emergency_cuts.vote_no\":{\"id\":\"emergency_cuts.vote_no\",\"title\":\"Vote against this measure, ending the toleration agreement.\",\"viewIf\":{\"$code\":\"return (((Q['spd_toleration'] || 0)) !== 0);\"},\"onArrival\":[{\"$code\":\"Q['time_to_election'] = 3;\\nQ['spd_in_government'] = 0;\\nQ['in_grand_coalition'] = 0;\\nQ['spd_toleration'] = 0;\\nQ['pro_republic'] = (Q['pro_republic'] || 0) - 5;\"}],\"call\":\"set_next_election_time\",\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[\"We have broken with the \",{\"type\":\"insert\",\"insert\":0},\" government, and have voted against them in a vote of no confidence. Welfare has been saved, but at what cost?\"]},{\"type\":\"paragraph\",\"content\":[\"New elections have been set for \",{\"type\":\"insert\",\"insert\":1},\" \",{\"type\":\"insert\",\"insert\":2},\".\"]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_month'] || 0);\"},\"qdisplay\":\"month\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_year'] || 0);\"}}]}},\"high_inflation.welfare\":{\"id\":\"high_inflation.welfare\",\"onArrival\":[{\"$code\":\"Q['welfare'] = (Q['welfare'] || 0) - 1;\\nQ['budget'] = (Q['budget'] || 0) + 1;\\nQ['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) - 2;\\nQ['unemployed'] = (Q['unemployed'] || 0) + 1.5;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 5;\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) - 5;\\nQ['inflation'] = (Q['inflation'] || 0) - 1;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 5;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) + 5;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) + 5;\\nQ['kpd_coalition_dissent'] = (Q['kpd_coalition_dissent'] || 0) + 1;\"}],\"content\":{\"content\":\"Reducing the amount of government spending should reduce the inflation rate, according to classical economics. But it imposes pain upon the people who are suffering the most.\",\"type\":\"paragraph\"}},\"election_1928.cancel_elections_2\":{\"id\":\"election_1928.cancel_elections_2\",\"onDeparture\":[{\"$code\":\"Q['next_election_year'] = ((Q['next_election_year'] || 0) + 1);\\nQ['next_election_time'] = ((Q['time'] || 0) + 12);\\nQ['pro_republic'] = (Q['pro_republic'] || 0) - 10;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 8;\\nQ['z_relation'] = (Q['z_relation'] || 0) - 8;\\nQ['ddp_relation'] = (Q['ddp_relation'] || 0) - 10;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) - 8;\\nQ['coup_progress'] = (Q['coup_progress'] || 0) + 2;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 4;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) - 5;\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) - 5;\\nQ['rural_spd'] = (Q['rural_spd'] || 0) - 5;\\nQ['catholics_spd'] = (Q['catholics_spd'] || 0) - 5;\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) - 5;\\n if (((Q['nsdap_normalized'] || 0) >= 0.3) ) { Q['coup_progress'] = (Q['coup_progress'] || 0) + 2; } \\n if ((((Q['nsdap_normalized'] || 0) + (Q['dnvp_normalized'] || 0)) >= 0.5) ) { Q['coup_progress'] = (Q['coup_progress'] || 0) + 2; }\"}],\"achievement\":\"ausnahmezustand\",\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[\"Fine. President \",{\"type\":\"insert\",\"insert\":0},\" has taken the unprecedented step of canceling these elections. New elections are scheduled for \",{\"type\":\"insert\",\"insert\":1},\" \",{\"type\":\"insert\",\"insert\":2},\".\"]},{\"type\":\"paragraph\",\"content\":\"Let us hope this does not backfire.\"}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['president'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_month'] || 0);\"},\"qdisplay\":\"month\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_year'] || 0);\"}}]}},\"hitler_chancellor.give_up\":{\"id\":\"hitler_chancellor.give_up\",\"options\":[{\"id\":\"@game_over\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"Speeches are made. Votes are held. Bullets fly in the streets. Some socialists are killed or jailed. Others flee the country. What can votes even do at this juncture?\"},{\"type\":\"paragraph\",\"content\":\"The Reichstag is burned, ostensibly by a foreign communist. In the wake, the Nazis pass decrees giving them unlimited power. They, combined with the DNVP, will win a majority at the next elections.\"},{\"type\":\"paragraph\",\"content\":\"Germany is lost.\"}]},\"hitler_chancellor\":{\"id\":\"hitler_chancellor\",\"type\":\"scene\",\"title\":\"Hitler appointed Chancellor!\",\"subtitle\":\"The beginning of the end...\",\"viewIf\":{\"$code\":\"return (((((((((Q['year'] || 0) >= 1933) && (Q['president'] == \\\"Hindenburg\\\")) && (((Q['chancellor'] == \\\"Papen\\\") || (Q['chancellor'] == \\\"Schleicher\\\")))) && ((Q['in_grand_coalition'] || 0)===0)) && ((Q['spd_in_government'] || 0)===0)) && (Q['largest_party'] == \\\"NSDAP\\\")) && ((Q['hitler_deported'] || 0)===0)) && (!(((Q['presidential_powers'] || 0)) !== 0)));\"},\"onDeparture\":[{\"$code\":\"Q['chancellor'] = \\\"Hitler\\\";\\nQ['chancellor_party'] = \\\"NSDAP\\\";\"}],\"tags\":[\"event\"],\"newPage\":true,\"options\":[{\"id\":\"@hitler_chancellor.fight\",\"title\":\"We will fight on the streets to prevent Hitler from taking power.\"},{\"id\":\"@hitler_chancellor.give_up\",\"title\":\"We will vote against the nazis in the Reichstag.\"}],\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"Hitler Appointed Chancellor!\"},{\"type\":\"paragraph\",\"content\":[\"Internal scheming by the camarilla surrounding the president has caused President Hindenburg to appoint Hitler as chancellor, replacing the unpopular \",{\"type\":\"insert\",\"insert\":0},\". \",{\"type\":\"conditional\",\"content\":\"Despite his earlier deportation, the Nazi leaders and their reactionary allies have connived for the president to give him German citizenship after all. \",\"predicate\":1},\" Some of the reactionaries surrounding Hindenburg believe that he will restore Germany to its supposed former glory, while others believe that they can control him and his movement.\"]},{\"type\":\"paragraph\",\"content\":\"He has promised a campaign of revenge against the socialists, and the Nazis have already spilled blood. In his published manifesto, he promises a campaign of unspeakable horror against Jews, and endless wars of violent expansion that will ruin all of Europe.\"},{\"type\":\"paragraph\",\"content\":\"What are we to do now?\"}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['hitler_deported'] || 0)) !== 0);\"}}]}},\"hitler_takes_power.give_up\":{\"id\":\"hitler_takes_power.give_up\",\"options\":[{\"id\":\"@game_over\",\"title\":\"Game over.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"Speeches are made. Votes are held. Bullets fly in the streets. Some socialists are killed or jailed. Others flee the country. What can votes even do at this juncture?\"},{\"type\":\"paragraph\",\"content\":\"The Reichstag is burned, ostensibly by a foreign communist. In the wake, the Nazis pass decrees giving them unlimited power. They, combined with the DNVP, will win a majority at the next elections.\"},{\"type\":\"paragraph\",\"content\":\"Germany is lost.\"}]},\"hitler_takes_power\":{\"id\":\"hitler_takes_power\",\"type\":\"scene\",\"title\":\"Hitler takes power.\",\"subtitle\":\"The beginning of the end.\",\"viewIf\":{\"$code\":\"return (((Q['chancellor'] == \\\"Hitler\\\") || (Q['president'] == \\\"Hitler\\\")) || (Q['chancellor_party'] == \\\"NSDAP\\\"));\"},\"onArrival\":[{\"$code\":\"Q['spd_in_government'] = 0;\"}],\"tags\":[\"event\"],\"newPage\":true,\"options\":[{\"id\":\"@hitler_takes_power.fight\",\"title\":\"We will fight on the streets to prevent Hitler from taking power.\"},{\"id\":\"@hitler_takes_power.give_up\",\"title\":\"We will vote against the nazis in the Reichstag.\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"The first act that Chancellor \",{\"type\":\"insert\",\"insert\":1},\" takes upon assuming office is bringing Adolf Hitler back to Germany, and giving him citizenship and an official cabinet position. \"],\"predicate\":0},\"\"]},{\"type\":\"paragraph\",\"content\":\"Hitler has promised a campaign of revenge against the socialists, and the Nazis have already spilled much blood on the streets. In his published manifesto, he promises a campaign of unspeakable horror against our Jews, and endless wars of violent expansion that will ruin all of Europe.\"},{\"type\":\"paragraph\",\"content\":\"What are we to do now?\"}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((((Q['hitler_deported'] || 0)) !== 0) && (Q['president'] != \\\"Hitler\\\")) && (Q['chancellor'] != \\\"Hitler\\\"));\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor'] || 0);\"}}]}},\"hunger_chancellor.break_toleration\":{\"id\":\"hunger_chancellor.break_toleration\",\"subtitle\":\"This is likely to result in new elections.\",\"viewIf\":{\"$code\":\"return ((Q['spd_toleration'] || 0) == 1);\"},\"onArrival\":[{\"$code\":\"if (((Q['next_election_time'] || 0) >= ((Q['time'] || 0) + 3)) ) { Q['next_election_time'] = ((Q['time'] || 0) + 3); } \\n if (((Q['next_election_time'] || 0) >= ((Q['time'] || 0) + 3)) ) { Q['next_election_month'] = ((Q['month'] || 0) + 3); } \\n if (((Q['next_election_time'] || 0) >= ((Q['time'] || 0) + 3)) ) { Q['next_election_year'] = (Q['year'] || 0); } \\n if (((Q['next_election_month'] || 0) > 12) ) { Q['next_election_year'] = (Q['next_election_year'] || 0) + 1; } \\n if (((Q['next_election_month'] || 0) > 12) ) { Q['next_election_month'] = (Q['next_election_month'] || 0) - 12; } \\nQ['spd_in_government'] = 0;\\nQ['in_grand_coalition'] = 0;\\nQ['spd_toleration'] = 0;\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[\"We have definitively broken with the \",{\"type\":\"insert\",\"insert\":0},\" government, and have voted against them in a vote of no confidence.\"]},{\"type\":\"paragraph\",\"content\":[\"New elections have been set for \",{\"type\":\"insert\",\"insert\":1},\" \",{\"type\":\"insert\",\"insert\":2},\".\"]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_month'] || 0);\"},\"qdisplay\":\"month\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_year'] || 0);\"}}]}},\"hunger_chancellor\":{\"id\":\"hunger_chancellor\",\"type\":\"scene\",\"title\":\"The Hunger Chancellor\",\"subtitle\":{\"content\":[\"Popular discontent with Chancellor \",{\"type\":\"insert\",\"insert\":0},\" rises.\"],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor'] || 0);\"}}]},\"newPage\":true,\"viewIf\":{\"$code\":\"return ((((((Q['year'] || 0) >= 1931) && ((Q['month'] || 0) >= 2)) && ((Q['unemployed'] || 0) >= 18)) && ((Q['welfare'] || 0) < 0)) && ((Q['works_program'] || 0) == 0));\"},\"onArrival\":[{\"$code\":\"if ((Q['chancellor_party'] == \\\"SPD\\\") ) { Q['workers_spd'] = (Q['workers_spd'] || 0) * 0.9; } \\n if (((Q['spd_in_government'] || 0) == 1) ) { Q['workers_spd'] = (Q['workers_spd'] || 0) * 0.9; } \\n if ((((Q['spd_in_government'] || 0)) !== 0) ) { Q['workers_nsdap'] = (Q['workers_nsdap'] || 0) + 5; } \\n if ((((Q['spd_in_government'] || 0)) !== 0) ) { Q['workers_kpd'] = (Q['workers_kpd'] || 0) + 5; } \\n if ((((Q['spd_in_government'] || 0)) !== 0) ) { Q['unemployed_nsdap'] = (Q['unemployed_nsdap'] || 0) + 5; }\"}],\"tags\":[\"event\"],\"maxVisits\":1,\"options\":[{\"id\":\"@hunger_chancellor.maintain_toleration\",\"title\":\"Maintain the current governing arrangement.\"},{\"id\":\"@hunger_chancellor.break_toleration\",\"title\":\"Break toleration; vote against this government.\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[\"People are calling Chancellor \",{\"type\":\"insert\",\"insert\":0},\" the Hunger Chancellor because of his perceived callousness in the face of the depression. \",{\"type\":\"conditional\",\"content\":\"This is obviously a very bad sign for us. \",\"predicate\":1},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":[\"As we are currently tolerating the \",{\"type\":\"insert\",\"insert\":3},\" government, this could very well reflect badly on us.\"],\"predicate\":2}}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['chancellor_party'] == \\\"SPD\\\");\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['spd_toleration'] || 0) == 1);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor'] || 0);\"}}]},\"countVisitsMax\":1},\"kpd_conference.conciliator_fail\":{\"id\":\"kpd_conference.conciliator_fail\",\"title\":\"Thälmann retains his leadership position.\",\"content\":{\"content\":\"Unfortunately, we could not influence the KPD leadership election against the hardliners. Thälmann quickly moves to consolidate absolute leadership, expelling or exiling his opponents.\",\"type\":\"paragraph\"}},\"kpd_conference\":{\"id\":\"kpd_conference\",\"type\":\"scene\",\"title\":\"KPD Party Conference\",\"subtitle\":\"The KPD chooses their new central committee - will the Wittorf Affair have an influence on their choice?\",\"newPage\":true,\"viewIf\":{\"$code\":\"return ((((((Q['kpd_relation'] || 0) >= 50) && ((Q['wittorf_soviet_union'] || 0)===1)) && ((Q['year'] || 0)===1929)) && ((Q['month'] || 0) >= 6)) && ((Q['month'] || 0) <= 8));\"},\"maxVisits\":1,\"onArrival\":[{\"$code\":\"Q['kpd_party_conference_seen'] = 1;\"}],\"tags\":[\"event\"],\"options\":[{\"id\":\"@kpd_conference.conciliator_success\"},{\"id\":\"@kpd_conference.conciliator_fail\"}],\"content\":[{\"type\":\"heading\",\"content\":\"KPD Party Conference\"},{\"type\":\"paragraph\",\"content\":\"Now is the KPD's national party conference, where they will choose their new leadership. The shadow of the Wittorf Affair hangs over it. On one hand are the hardline supporters of Thälmann, who support a \\\"social fascist\\\" policy that places the SPD as equivalent to the Nazis. On the other hand is the \\\"Conciliator\\\" faction, who support a more cooperative policy towards the SPD.\"},{\"type\":\"paragraph\",\"content\":\"After our discussion with the Soviets, we are inclined to believe that Stalin is at least open to the Conciliators. In order to affect the KPD's leadership elections, we have to influence both the Comintern leaders as as well as the KPD membership.\"}],\"countVisitsMax\":1},\"kpd_policy.labor_support\":{\"id\":\"kpd_policy.labor_support\",\"onArrival\":[{\"$code\":\"Q['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) + 2;\\nQ['workers_kpd'] = (Q['workers_kpd'] || 0) + 5;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\nQ['kpd_labor_support'] = (Q['kpd_labor_support'] || 0) + 1;\\nQ['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1;\\nQ['z_relation'] = (Q['z_relation'] || 0) - 6;\\nQ['unemployment'] = (Q['unemployment'] || 0) + 2;\\nQ['kpd_influence'] = (Q['kpd_influence'] || 0) + 2;\"}],\"content\":{\"content\":\"The pro-labor policy is popular among workers and is bringing the KPD more support, but in response businesses are laying off more workers and reducing hours. This is setting the government up for a confrontation with the capitalists.\",\"type\":\"paragraph\"}},\"kpd_ultimatum.appeal\":{\"id\":\"kpd_ultimatum.appeal\",\"chooseIf\":{\"$code\":\"return ((((((Q['kpd_score'] || 0) >= 4) && ((Q['kpd_relation'] || 0) > 50)) && ((Q['kpd_appeal_seen'] || 0)===0))) || (Q['kpd_party_leader'] == \\\"Conciliators\\\"));\"},\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":\"They do not see us as serious in trying to achieve the goals of the coalition. \",\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"Our relations are too poor. \",\"predicate\":1},\" \",{\"type\":\"conditional\",\"content\":\"we do not have any more time.\",\"predicate\":2}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['kpd_score'] || 0) < 4);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['kpd_relation'] || 0) < 50);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['kpd_appeal_seen'] || 0)===1);\"}}]},\"onArrival\":[{\"$code\":\"Q['kpd_ultimatum_seen'] = 0;\\nQ['kpd_ultimatum_timer'] = (Q['kpd_ultimatum_timer'] || 0) + 6;\\nQ['kpd_appeal_seen'] = 1;\"}],\"content\":{\"content\":\"We argue that we are working hard to achieve the coalition's goals, and in the name of proletarian solidarity, we must make this coalition function. Surprisingly, the KPD hears our pleas, and is willing to give us six more months before the coalition goals must be achieved.\",\"type\":\"paragraph\"}},\"labor_unrest.support_employers\":{\"id\":\"labor_unrest.support_employers\",\"subtitle\":\"This will alienate the workers.\",\"onArrival\":[{\"$code\":\"Q['labor_dissent'] = (Q['labor_dissent'] || 0) + 8;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 8;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 6;\\nQ['coalition_dissent'] = (Q['coalition_dissent'] || 0) - 1;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) + 5;\\nQ['z_relation'] = (Q['z_relation'] || 0) + 5;\\nQ['coalition_dissent'] = (Q['coalition_dissent'] || 0) - 1;\\nQ['workers_kpd'] = (Q['workers_kpd'] || 0) + 5;\\nQ['kpd_coalition_dissent'] = (Q['kpd_coalition_dissent'] || 0) + 1;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) - 8;\\n if (((Q['capital_strike_progress'] || 0) > 1) ) { Q['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) - 1; } \\n if (((Q['capital_strike_progress'] || 0) > 8) ) { Q['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) - 1; }\"}],\"content\":{\"content\":\"Even though most workers grudgingly accept the our intervention, there is deep bitterness developing against the SPD, especially among the more radical workers. The Communists stand to gain.\",\"type\":\"paragraph\"}},\"kpd_vote_of_no_confidence.try_assuage\":{\"id\":\"kpd_vote_of_no_confidence.try_assuage\",\"options\":[{\"id\":\"@kpd_vote_of_no_confidence.resources\",\"title\":\"Use our resources to reduce dissent within the coalition.\"},{\"id\":\"@kpd_vote_of_no_confidence.thalmann\",\"title\":{\"content\":[\"Appoint Thälmann as chancellor instead of \",{\"type\":\"insert\",\"insert\":0},\".\"],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor'] || 0);\"}}]}},{\"id\":\"@kpd_vote_of_no_confidence.support_center\",\"title\":\"Could we form a new government based on the Center Party and DDP (and possibly DVP)?\"},{\"id\":\"@kpd_vote_of_no_confidence.let_it_happen\",\"title\":\"Never mind. Let the vote happen.\"}],\"content\":{\"content\":\"How do we assuage the KPD?\",\"type\":\"paragraph\"}},\"march_on_berlin.accept\":{\"id\":\"march_on_berlin.accept\",\"title\":\"There is nothing we can do.\",\"goTo\":[{\"id\":\"march_on_berlin.accept_election\",\"predicate\":{\"$code\":\"return (((Q['nsdap_normalized'] || 0) + (Q['dnvp_normalized'] || 0)) >= 0.45);\"}},{\"id\":\"march_on_berlin.accept_hitler\",\"predicate\":{\"$code\":\"return (((Q['nsdap_normalized'] || 0) + (Q['dnvp_normalized'] || 0)) < 0.45);\"}}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"nazis_in_crisis.complacency\":{\"id\":\"nazis_in_crisis.complacency\",\"content\":{\"content\":\"Even in their weakened state, the Nazis are still a threat. We must not be too complacent.\",\"type\":\"paragraph\"}},\"nazis_in_crisis\":{\"id\":\"nazis_in_crisis\",\"type\":\"scene\",\"title\":\"Nazis in Crisis\",\"subtitle\":\"Finally, the internal contradictions of the NSDAP have caught up to it.\",\"viewIf\":{\"$code\":\"return (((((Q['year'] || 0)===1933) && ((Q['month'] || 0) >= 9)) && ((Q['nsdap_r'] || 0) >= 8)) && (((Q['nsdap_normalized'] || 0) + (Q['dnvp_normalized'] || 0)) < 0.5));\"},\"onArrival\":[{\"$code\":\"Q['workers_nsdap'] = (Q['workers_nsdap'] || 0) - 12;\\nQ['new_middle_nsdap'] = (Q['new_middle_nsdap'] || 0) - 12;\\nQ['old_middle_nsdap'] = (Q['old_middle_nsdap'] || 0) - 12;\\nQ['rural_nsdap'] = (Q['rural_nsdap'] || 0) - 12;\\nQ['unemployed_nsdap'] = (Q['unemployed_nsdap'] || 0) - 10;\\nQ['sa_strength'] = (Q['sa_strength'] || 0) * 0.7;\\n if (((Q['coup_progress'] || 0) > 4) ) { Q['coup_progress'] = (Q['coup_progress'] || 0) - 4; } \\nQ['new_middle_ddp'] = (Q['new_middle_ddp'] || 0) + 6;\\nQ['new_middle_dvp'] = (Q['new_middle_dvp'] || 0) + 6;\\nQ['old_middle_ddp'] = (Q['old_middle_ddp'] || 0) + 5;\\nQ['old_middle_dvp'] = (Q['old_middle_dvp'] || 0) + 5;\\nQ['old_middle_dnvp'] = (Q['old_middle_dnvp'] || 0) + 3;\\nQ['rural_dnvp'] = (Q['rural_dnvp'] || 0) + 6;\\nQ['rural_ddp'] = (Q['rural_ddp'] || 0) + 2;\\nQ['rural_dvp'] = (Q['rural_dvp'] || 0) + 2;\\nQ['unemployed_kpd'] = (Q['unemployed_kpd'] || 0) + 4;\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + 4;\"}],\"maxVisits\":1,\"newPage\":true,\"tags\":[\"event\"],\"options\":[{\"id\":\"@nazis_in_crisis.celebrate\",\"title\":\"This is an occasion to celebrate.\"},{\"id\":\"@nazis_in_crisis.complacency\",\"title\":\"The Nazis are still a threat. We must not be too complacent.\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Nazis in Crisis\"},{\"type\":\"paragraph\",\"content\":\"Finally, the internal contradictions of the NSDAP have caught up to it. With the improving economic conditions, many business leaders are less interested in supporting them. Tensions between their remaining big capitalist funders and their lower middle class frontliners have come to a head, leading to desertions and public spats. This all saps Hitler's aura of strength, weakening Nazi support across a variety of demographics.\"}],\"countVisitsMax\":1},\"panzerkreuzer.vote_no\":{\"id\":\"panzerkreuzer.vote_no\",\"onArrival\":[{\"$code\":\"Q['dvp_relation'] = (Q['dvp_relation'] || 0) - 8;\\nQ['z_relation'] = (Q['z_relation'] || 0) - 5;\\nQ['pacifism'] = (Q['pacifism'] || 0) + 1;\\nQ['nationalism'] = (Q['nationalism'] || 0) - (5 * (1 - (Q['dissent'] || 0)));\\nQ['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1;\"}],\"goTo\":[{\"id\":\"panzerkreuzer.vote_no_chancellor\",\"predicate\":{\"$code\":\"return (Q['chancellor_party'] == \\\"SPD\\\");\"}},{\"id\":\"panzerkreuzer.vote_no_pass\",\"predicate\":{\"$code\":\"return (Q['chancellor_party'] != \\\"SPD\\\");\"}}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"constitutional_reform.vote_threshold\":{\"id\":\"constitutional_reform.vote_threshold\",\"subtitle\":\"Change the vote threshold to 5% for parties to be represented in the Reichstag.\",\"onArrival\":[{\"$code\":\"Q.reform_support = Q.spd_normalized;\\nif (Q.z_relation > 30) {\\n    Q.reform_support += Q.z_normalized - 0.03;\\n}\\nif (Q.kpd_relation > 50 && Q.kpd_normalized >= 0.1) {\\n    Q.reform_support += Q.kpd_normalized;\\n}\\nif (Q.nsdap_normalized >= 0.2 ) {\\n    Q.reform_support += Q.nsdap_normalized;\\n}\"}],\"viewIf\":{\"$code\":\"return ((Q['electoral_threshold'] || 0)===0);\"},\"options\":[{\"id\":\"@constitutional_reform.vote_threshold_2\",\"title\":\"Call a constitutional referendum to pass the reform!\"},{\"id\":\"@constitutional_reform.reforms_menu\",\"title\":\"See other reform options.\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"Some political thinkers believe that the proliferation of minor parties is responsible for the instability of the republic. They believe that a higher electoral threshold will reduce the influence of small radical parties. Parties that win a plurality in a constituency will maintain their representation, a gift to regional parties such as the BVP.\"},{\"type\":\"paragraph\",\"content\":[\"The smaller parties will obviously oppose this reform. \",{\"type\":\"conditional\",\"content\":\"The Center Party supports this reform, while their BVP partners oppose it. \",\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"Perhaps surprisingly, the KPD supports this reform. \",\"predicate\":1},\" \",{\"type\":\"conditional\",\"content\":\"The NSDAP supports this reform, as they believe they have something to gain. \",\"predicate\":2},\"\"]},{\"type\":\"paragraph\",\"content\":\"The SPD Left opposes this change, as they believe it to be anti-democratic.\"}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['z_relation'] || 0) > 30);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['kpd_relation'] || 0) > 50) && ((Q['kpd_normalized'] || 0) >= 0.1));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['nsdap_normalized'] || 0) >= 0.2);\"}}]}},\"popular_front_dispute.agriculture\":{\"id\":\"popular_front_dispute.agriculture\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"presidential_election_1932.support_hindenburg\":{\"id\":\"presidential_election_1932.support_hindenburg\",\"subtitle\":\"This is the default option.\",\"options\":[{\"id\":\"@presidential_election_1932.final_election\",\"title\":\"The final vote...\"}],\"content\":{\"content\":\"Despite his known reactionary nature, Hindenburg has at least been keeping the Nazis at bay. Thus, we must support him.\",\"type\":\"paragraph\"}},\"prussian_coup.defend_2\":{\"id\":\"prussian_coup.defend_2\",\"onArrival\":[{\"$code\":\"Q['resist_coup'] = 1;\\nQ['defense_strength'] = (((Q['rb_strength'] || 0) * (Q['rb_militancy'] || 0)) * (1 - ((Q['dissent'] || 0) / 2)));\\n if ((((Q['spd_prussia'] || 0)) !== 0) ) { Q['defense_strength'] = (Q['defense_strength'] || 0) + (((Q['prussian_police_strength'] || 0) * (Q['prussian_police_militancy'] || 0)) * (Q['prussian_police_loyalty'] || 0)); } \\nQ['enemy_strength'] = (((Q['sa_strength'] || 0) * (Q['sa_militancy'] || 0)) + ((Q['sh_strength'] || 0) * (Q['sh_militancy'] || 0)));\\nQ['enemy_strength'] = (Q['enemy_strength'] || 0) + ((((Q['reichswehr_strength'] || 0) * (Q['reichswehr_militancy'] || 0)) * (1 - (Q['reichswehr_loyalty'] || 0))) / 2);\\nQ['defense_strength'] = (Q['defense_strength'] || 0) + (((Q['workers_spd_normalized'] || 0) * (2 - (Q['dissent'] || 0))) * (2 - ((Q['unemployed'] || 0) / 100)));\"}],\"goTo\":[{\"id\":\"prussian_coup.defend_2_civil_war\",\"predicate\":{\"$code\":\"return ((Q['defense_strength'] || 0) < (Q['enemy_strength'] || 0));\"}},{\"id\":\"prussian_coup.defend_2_victory\",\"predicate\":{\"$code\":\"return ((Q['defense_strength'] || 0) >= (Q['enemy_strength'] || 0));\"}}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"reichsbanner_zentrum.lower_militancy\":{\"id\":\"reichsbanner_zentrum.lower_militancy\",\"onArrival\":[{\"$code\":\"Q['rb_militancy'] = (Q['rb_militancy'] || 0) * 0.5;\"}],\"content\":{\"content\":\"Bowing to the other parties' demands, we reduce the Reichsbanner's military training, thus inducing them to stay.\",\"type\":\"paragraph\"}},\"panzerkreuzer_b.vote_no\":{\"id\":\"panzerkreuzer_b.vote_no\",\"onArrival\":[{\"$code\":\"Q['dvp_relation'] = (Q['dvp_relation'] || 0) - 8;\\nQ['z_relation'] = (Q['z_relation'] || 0) - 5;\\nQ['pacifism'] = (Q['pacifism'] || 0) + 1;\\nQ['nationalism'] = (Q['nationalism'] || 0) - (5 * (1 - (Q['dissent'] || 0)));\\nQ['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1;\\n if (((Q['nationalism'] || 0) < 49) ) { Q['workers_spd'] = (Q['workers_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0))); }\"}],\"goTo\":[{\"id\":\"panzerkreuzer_b.built\",\"predicate\":{\"$code\":\"return ((((Q['spd_r'] || 0) + (Q['kpd_r'] || 0)) + (Q['ddp_r'] || 0)) < 50);\"}},{\"id\":\"panzerkreuzer_b.not_built\",\"predicate\":{\"$code\":\"return ((((Q['spd_r'] || 0) + (Q['kpd_r'] || 0)) + (Q['ddp_r'] || 0)) >= 50);\"}}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"Our vote against the battlecruiser is unpopular among the right-wing parties\",{\"type\":\"conditional\",\"content\":\", including our coalition partners \",\"predicate\":0},{\"type\":\"conditional\",\"content\":\", including the minority government that we are currently supporting \",\"predicate\":1},\".\"]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['in_grand_coalition'] || 0)) !== 0) || (((Q['in_weimar_coalition'] || 0)) !== 0));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['spd_toleration'] || 0)) !== 0);\"}}]}},\"panzerkreuzer_ministry.vote_no\":{\"id\":\"panzerkreuzer_ministry.vote_no\",\"onArrival\":[{\"$code\":\"Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1;\\nQ['reichswehr_loyalty'] = (Q['reichswehr_loyalty'] || 0) - 0.05;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) - 10;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) - 10;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) - 5;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) - 5;\\nQ['neorevisionist_dissent'] = (Q['neorevisionist_dissent'] || 0) - 5;\\nQ['nationalism'] = (Q['nationalism'] || 0) - 5;\\nQ['pacifism'] = (Q['pacifism'] || 0) + 1;\\nQ['z_relation'] = (Q['z_relation'] || 0) - 5;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 5;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['panzerkreuzer_failed'] = 1;\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"Military leaders are upset at the Ministry's decision to not construct the battlecruiser, and they have taken the complaints to our coalition partners. However, there is not much they can do to force the construction, as we have control over the Reichswehr ministry.\"},{\"type\":\"paragraph\",\"content\":\"No matter what, the battlecruiser will not be built. We have fulfilled one of our campaign promises, and our supporters are pleased.\"}]},\"panzerkreuzer_ministry\":{\"id\":\"panzerkreuzer_ministry\",\"type\":\"scene\",\"title\":\"Panzerkreuzer A\",\"subtitle\":\"A political question\",\"tags\":[\"event\",\"govt_affairs\"],\"isCard\":true,\"onArrival\":[{\"$code\":\"Q['panzerkreuzer_seen'] = 1;\"}],\"viewIf\":{\"$code\":\"return ((((((Q['panzerkreuzer_seen'] || 0)===0) && ((Q['year'] || 0)===1928)) && ((Q['month'] || 0) >= 8)) && (Q['reichswehr_minister_party'] == \\\"SPD\\\")) && ((Q['spd_in_government'] || 0)===1));\"},\"newPage\":true,\"faceImage\":\"img/panzerkreuzer.jpg\",\"options\":[{\"id\":\"@panzerkreuzer_ministry.vote_yes\",\"title\":\"Build the battlecruiser.\"},{\"id\":\"@panzerkreuzer_ministry.vote_no\",\"title\":\"Do not build the battlecruiser.\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Panzerkreuzer\"},{\"type\":\"paragraph\",\"content\":\"Navy leaders are asking for the construction of a new battlecruiser, as promised by the previous government. Since we control the Reichswehr ministry, it is our decision as to whether to build the battlecruiser or not.\"}]},\"schacht_vs_hilferding.work_with\":{\"id\":\"schacht_vs_hilferding.work_with\",\"options\":[{\"id\":\"@schacht_vs_hilferding.hilferding_resign\",\"title\":\"Hilferding must resign.\"}],\"content\":{\"content\":\"After a second budget proposal, Schacht still considers Hilferding's budget to be unacceptable, despite more regressive taxes and expenditure cuts.\",\"type\":\"paragraph\"}},\"unemployment_insurance_1.gift\":{\"id\":\"unemployment_insurance_1.gift\",\"goTo\":[{\"id\":\"unemployment_insurance_1.what_do\"}],\"content\":{\"content\":\"This is a gift to the Communists, a boost to their theory that parliamentary democracy will never benefit the working class.\",\"type\":\"paragraph\"}},\"unemployment_insurance_weimar.increase_employers\":{\"id\":\"unemployment_insurance_weimar.increase_employers\",\"subtitle\":{\"content\":[\"Employers are strongly against this. \",{\"type\":\"conditional\",\"content\":\"The DVP will likely break the coalition.\",\"predicate\":0}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['in_grand_coalition'] || 0)) !== 0);\"}}]},\"onArrival\":[{\"$code\":\"Q['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) + 2;\\n if ((((Q['in_grand_coalition'] || 0)) !== 0) ) { Q['coalition_dissent'] = 2; } \\nQ['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1;\\nQ['welfare'] = (Q['welfare'] || 0) + 1;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (6 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (6 * (1 - (Q['dissent'] || 0)));\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) - (6 * (1 - (Q['dissent'] || 0)));\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) - (2 * (1 - (Q['dissent'] || 0)));\\nQ['unemployment_insurance_threshold'] = (Q['unemployed'] || 0);\\nQ['unemployment_insurance_timer'] = 10;\"}],\"content\":{\"content\":\"We have increased employer contributions to the unemployment insurance fund, allowing the program to continue without hurting workers and the unemployed. Perhaps understandably, the capitalists and their political parties are furious, while our base in the unions and among the unemployed are pleased.\",\"type\":\"paragraph\"}},\"vote_of_no_confidence.give_up_prussia\":{\"id\":\"vote_of_no_confidence.give_up_prussia\",\"viewIf\":{\"$code\":\"return ((Q['spd_prussia'] || 0) == 1);\"},\"onArrival\":[{\"$code\":\"Q['coalition_dissent'] = 0;\\nQ['spd_prussia'] = 0;\\nQ['prussian_government'] = \\\"I\\\";\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 10;\\nQ['centrist_dissent'] = (Q['centrist_dissent'] || 0) + 10;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) + 10;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 5;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 5;\\nQ['rural_spd'] = (Q['rural_spd'] || 0) - 5;\"}],\"content\":{\"content\":\"Fine. We no longer control the government of Prussia. The vote has been called off.\",\"type\":\"paragraph\"}},\"wittorf_affair.nothing\":{\"id\":\"wittorf_affair.nothing\",\"title\":\"Do nothing with the information.\",\"onArrival\":[{\"$code\":\"Q['workers_kpd'] = (Q['workers_kpd'] || 0) - 2;\\nQ['unemployed_kpd'] = (Q['unemployed_kpd'] || 0) - 2;\"}],\"content\":{\"content\":\"The information spreads without our help, leading to some loss of KPD support among the workers.\",\"type\":\"paragraph\"}},\"young_plan.internationalism\":{\"id\":\"young_plan.internationalism\",\"onArrival\":[{\"$code\":\"if (((Q['pacifism'] || 0) >= 2) ) { \\nQ['nationalism'] = (Q['nationalism'] || 0) - (5 * (1 - (Q['dissent'] || 0)));;\\n } else { Q['nationalism'] = (Q['nationalism'] || 0) + 3; } \\nQ['pacifism'] = (Q['pacifism'] || 0) + 1;\\n if ((((Q['pacifism'] || 0) >= 3) && ((Q['nationalism'] || 0) <= 50)) ) { Q['workers_spd'] = (Q['workers_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0))); } \\n if (((Q['pacifism'] || 0) <= 3) ) { Q['workers_nsdap'] = (Q['workers_nsdap'] || 0) + 4; } \\nQ['rural_nsdap'] = (Q['rural_nsdap'] || 0) + 5;\\n if (((Q['pacifism'] || 0) <= 3) ) { Q['catholics_spd'] = (Q['catholics_spd'] || 0) - 4; } \\nQ['rural_dvp'] = (Q['rural_dvp'] || 0) - 4;\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"We rail hard against nationalism and in favor of pacifism and belonging to the international community of nations. The referendum easily fails, with only around 15% of voters supporting it. It seems that nationalism is not omnipotent in Germany, despite everything. \",{\"type\":\"conditional\",\"content\":\"We have rallied the workers to the cause of internationalism.\",\"predicate\":0}]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['pacifism'] || 0) >= 3) && ((Q['nationalism'] || 0) <= 50));\"}}]}},\"young_plan_right_coalition.vonc_no\":{\"id\":\"young_plan_right_coalition.vonc_no\",\"title\":\"Support the rump Center-led government, voting in favor of the government.\",\"subtitle\":\"We would essentially provide \\\"toleration\\\" to a bourgeois government.\",\"viewIf\":{\"$code\":\"return ((Q['neo_weimar_coalition'] || 0) >= 50);\"},\"onArrival\":[{\"$code\":\"Q['spd_toleration'] = 1;\\nQ['in_right_coalition'] = 0;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 8;\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"By supporting the government, we have essentially entered into a \\\"toleration\\\" arrangement with the \",{\"type\":\"insert\",\"insert\":0},\" government. We do not have a voice in the government, but we are responsible for its continued stability. The left of our party opposes this plan, and would rather that we hold new elections.\"]},\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor'] || 0);\"}}]}},\"confronting_nazis.economic_crisis\":{\"id\":\"confronting_nazis.economic_crisis\",\"title\":\"We must address the economic crisis first.\",\"viewIf\":{\"$code\":\"return (((Q['economic_plan'] || 0) == 0) && ((Q['black_thursday_seen'] || 0) == 1));\"},\"goTo\":[{\"id\":\"crisis_program\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"campaigning.new_middle\":{\"id\":\"campaigning.new_middle\",\"subtitle\":\"-1 resources\",\"chooseIf\":{\"$code\":\"return ((Q['resources'] || 0) >= 1);\"},\"unavailableSubtitle\":\"Not enough resources.\",\"onArrival\":[{\"$code\":\"Q['new_middle_spd'] = (Q['new_middle_spd'] || 0) + (6 * (1 - (Q['dissent'] || 0)));\\n if ((((Q['socialism'] || 0) <= 49) && ((Q['peoples_party'] || 0) == 0)) ) { Q['new_middle_spd'] = (Q['new_middle_spd'] || 0) - 4; } \\nQ['resources'] = (Q['resources'] || 0) - 1;\\nQ['peoples_party_support'] = (Q['peoples_party_support'] || 0) + 1;\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"We have increased our campaigning among the new middle class. \",{\"type\":\"conditional\",\"content\":\"The popular antipathy towards socialism among this group makes our campaign more difficult. \",\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"As a people's party, we have an easier time increasing support among the middle class than before.\",\"predicate\":1}]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['socialism'] || 0) <= 49) && ((Q['peoples_party'] || 0) == 0));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['peoples_party'] || 0) > 0);\"}}]}},\"crisis_program.support_labor\":{\"id\":\"crisis_program.support_labor\",\"subtitle\":\"Call for increased public works and fiscal stimulus.\",\"unavailableSubtitle\":\"The Labor faction is not strong enough.\",\"chooseIf\":{\"$code\":\"return (((Q['historical_mode'] || 0) == 0) || (((((Q['labor_strength'] || 0) >= (Q['left_strength'] || 0)) && ((Q['labor_strength'] || 0) >= (Q['center_strength'] || 0))) && ((Q['labor_strength'] || 0) >= (Q['reformist_strength'] || 0)))));\"},\"onArrival\":[{\"$code\":\"Q['center_dissent'] = (Q['center_dissent'] || 0) + 10;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 5;\\nQ['labor_strength'] = (Q['labor_strength'] || 0) + 5;\\nQ['wtb_support'] = (Q['wtb_support'] || 0) + 1;\"}],\"goTo\":[{\"id\":\"crisis_program.plan_adopted\",\"predicate\":{\"$code\":\"return ((Q['wtb_support'] || 0) >= 3);\"}},{\"id\":\"crisis_program.plan_support\",\"predicate\":{\"$code\":\"return ((Q['wtb_support'] || 0) < 3);\"}}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"fundraising.reduce\":{\"id\":\"fundraising.reduce\",\"subtitle\":{\"content\":[{\"type\":\"insert\",\"insert\":0},\" resources gained.\"],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return ((Q['dues'] || 0) - 1);\"}}]},\"chooseIf\":{\"$code\":\"return ((Q['dues'] || 0) > 1);\"},\"onArrival\":[{\"$code\":\"Q['dues'] = (Q['dues'] || 0) - 1;\\nQ['resources'] = (Q['resources'] || 0) + (Q['dues'] || 0);\\nQ['left_dissent'] = (Q['left_dissent'] || 0) - 8;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) - 8;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) - 8;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) - 8;\"}],\"content\":{\"content\":\"Our current members appreciate this, but no one decides to join a party because of the low dues.\",\"type\":\"paragraph\"}},\"enemies.far_right\":{\"id\":\"enemies.far_right\",\"onArrival\":[{\"$code\":\"Q['enemies'] = \\\"far right\\\";\\nQ['left_strength'] = (Q['left_strength'] || 0) + 5;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) - 5;\\nQ['workers_nsdap'] = (Q['workers_nsdap'] || 0) - 3;\\nQ['workers_dnvp'] = (Q['workers_dnvp'] || 0) - 3;\"}],\"content\":{\"content\":\"Attacking the far right is popular among the entire party, although the left considers the bourgeois parties to be just as dangerous, while the right is critical of our lack of response to the KPD. Our bourgeois coalition partners are also skeptical of our lack of commitment to anti-communism.\",\"type\":\"paragraph\"}},\"ideology.centrist\":{\"id\":\"ideology.centrist\",\"onArrival\":[{\"$code\":\"if (Q.ideology && Q.ideology != \\\"centrist\\\") {\\n    Q.changed = 1;\\n}\"}],\"goTo\":[{\"id\":\"ideology.changed\",\"predicate\":{\"$code\":\"return ((Q['changed'] || 0)===1);\"}}],\"onDeparture\":[{\"$code\":\"Q['ideology'] = \\\"centrist\\\";\\nQ['center_strength'] = (Q['center_strength'] || 0) + 10;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) - 10;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) - 5;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) - 5;\"}],\"content\":{\"content\":\"The Center Marxists, represented by Kautsky and Hilferding, support a middle course of preparing for revolution while building up the consciousness of the working class.\",\"type\":\"paragraph\"}},\"inter_party_relationships.kpd_1\":{\"id\":\"inter_party_relationships.kpd_1\",\"onArrival\":[{\"$code\":\"Q['kpd_relation'] = (Q['kpd_relation'] || 0) + (6 * (1 - (Q['dissent'] || 0)));\\n if (((Q['kpd_inter_party_seen'] || 0) <= 1) ) { Q['communist_coalition'] = (Q['communist_coalition'] || 0) + 1; } \\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 2;\\nQ['z_relation'] = (Q['z_relation'] || 0) - 2;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 3;\"}],\"content\":{\"content\":\"The communists are suspicious of our overtures, especially the Stalinist leadership, who persist in calling us \\\"social fascists\\\". However, connections are made at the grassroots and local levels.\",\"type\":\"paragraph\"}},\"international_relations.austria\":{\"id\":\"international_relations.austria\",\"subtitle\":\"-1 resources\",\"chooseIf\":{\"$code\":\"return ((Q['resources'] || 0) >= 1);\"},\"unavailableSubtitle\":\"Not enough resources.\",\"audio\":\"shuffle music/communist/workers_of_vienna_normalized.mp3\",\"onArrival\":[{\"$code\":\"Q['left_strength'] = (Q['left_strength'] || 0) + 5;\\nQ['radicalization'] = (Q['radicalization'] || 0) + 1;\\nQ['rb_militancy'] = (Q['rb_militancy'] || 0) + 0.03;\\nQ['resources'] = (Q['resources'] || 0) - 1;\"}],\"content\":{\"content\":\"Our Reichsbanner can learn much in paramilitary organization and training from the Austrian Republican Protection Units.\",\"type\":\"paragraph\"}},\"iron_front.pacifism\":{\"id\":\"iron_front.pacifism\",\"onArrival\":[{\"$code\":\"Q['pacifism'] = (Q['pacifism'] || 0) + 1;\\n if (((Q['pacifism'] || 0) >= 3) ) { Q['nationalism'] = (Q['nationalism'] || 0) - 5; } \\n if (((Q['pacifism'] || 0) >= 4) ) { Q['workers_spd'] = (Q['workers_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0))); } \\n if (((Q['pacifism'] || 0) >= 4) ) { Q['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0))); } \\n if (((Q['pacifism'] || 0) >= 4) ) { Q['new_middle_spd'] = (Q['new_middle_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0))); }\"}],\"content\":{\"content\":\"The Iron Front rallies against nationalism and war.\",\"type\":\"paragraph\"}},\"media.campaign\":{\"id\":\"media.campaign\",\"title\":\"The purpose of our media is to elect more Social Democrats.\",\"subtitle\":\"Our newspapers will focus on the electoral campaign.\",\"onArrival\":[{\"$code\":\"Q['campaign_media'] = (Q['campaign_media'] || 0) + 1;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (2 * (1 - (Q['dissent'] || 0)));\"}],\"content\":{\"type\":\"paragraph\",\"content\":[\"Our campaign media is mostly reaching the workers who are already saturated with Socialist propaganda, but it must be doing \",{\"type\":\"emphasis-1\",\"content\":\"something\"},\", or at least that is what we hope.\"]}},\"party_disunity.concessions_reformists\":{\"id\":\"party_disunity.concessions_reformists\",\"title\":\"Give concessions to the reformists.\",\"viewIf\":{\"$code\":\"return ((Q['reformist_dissent'] || 0) > 30);\"},\"onArrival\":[{\"$code\":\"Q['reformist_dissent'] = (Q['reformist_dissent'] || 0) - 7;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 5;\"}],\"content\":{\"content\":\"We have promised to adopt a more reformist posture. This may alienate the left, however.\",\"type\":\"paragraph\"}},\"neorevisionism.no_new_ideas\":{\"id\":\"neorevisionism.no_new_ideas\",\"onArrival\":[{\"$code\":\"Q['neorevisionist_strength'] = (Q['neorevisionist_strength'] || 0) - 5;\\nQ['center_strength'] = (Q['center_strength'] || 0) + 5;\\nQ['neorevisionism'] = -1;\"}],\"content\":{\"content\":\"We do not need these new ideas; they seem to imitate too closely those of the Nazis and Communists.\",\"type\":\"paragraph\"}},\"neorevisionism\":{\"id\":\"neorevisionism\",\"type\":\"scene\",\"title\":\"Neorevisionism: a new idea\",\"newPage\":true,\"isCard\":true,\"cardImage\":\"img/portraits/MierendorffCarlo.jpg\",\"viewIf\":{\"$code\":\"return ((((Q['nazi_urgency'] || 0) > 0) && ((Q['neorevisionism'] || 0) == 0)) && ((((Q['nsdap_r'] || 0) >= 10) || ((Q['nsdap_normalized'] || 0) >= 0.15))));\"},\"onArrival\":[{\"$code\":\"Q['shuffle_leadership_timer'] = 0;\"}],\"tags\":[\"party_affairs\"],\"frequency\":200,\"maxVisits\":1,\"options\":[{\"id\":\"@neorevisionism.support_neo\",\"title\":\"Support the neorevisionist movement.\"},{\"id\":\"@neorevisionism.no_new_ideas\",\"title\":\"We don't need new ideas.\"},{\"id\":\"@easy_discard\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Neorevisionism: A New Idea\"},{\"type\":\"paragraph\",\"content\":\"Several young socialists, led by Carlo Mierendorff, are calling for a \\\"new revisionism\\\" in response to the Nazi threat. This political tendency calls for a mass movement in favor of democracy in order to counter the Nazi and Communist movements, and to update our rhetoric and imagery to appeal to emotion and not just reason.\"}],\"countVisitsMax\":1},\"party_organizations.welfare\":{\"id\":\"party_organizations.welfare\",\"chooseIf\":{\"$code\":\"return ((Q['resources'] || 0) > 0);\"},\"unavailableSubtitle\":\"Not enough resources.\",\"subtitle\":\"-1 resources\",\"onArrival\":[{\"$code\":\"Q['resources'] = (Q['resources'] || 0) - 1;\\nQ['workers_aid'] = (Q['workers_aid'] || 0) + 1;\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"We have increased funding to Workers' Welfare. \",{\"type\":\"conditional\",\"content\":\"In an age of economic crisis, this will be helpful for improving our standing among the unemployed.\",\"predicate\":0}]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['black_thursday_seen'] || 0) > 0);\"}}]}},\"peoples_party.support_peoples_party\":{\"id\":\"peoples_party.support_peoples_party\",\"chooseIf\":{\"$code\":\"return (((((Q['neorevisionist_strength'] || 0) + (Q['reformist_strength'] || 0)) >= ((Q['left_strength'] || 0) + (Q['center_strength'] || 0)))) && ((Q['peoples_party_support'] || 0) >= 4));\"},\"unavailableSubtitle\":\"The opposition is too strong.\",\"onArrival\":[{\"$code\":\"Q['neorevisionist_strength'] = (Q['neorevisionist_strength'] || 0) + 15;\\nQ['reformist_strength'] = (Q['reformist_strength'] || 0) + 15;\\nQ['neorevisionist_dissent'] = (Q['neorevisionist_dissent'] || 0) - 10;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) - 10;\\nQ['peoples_party'] = 1;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 12;\\nQ['rural_spd'] = (Q['rural_spd'] || 0) + 10;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) + 10;\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) + 8;\\nQ['catholics_spd'] = (Q['catholics_spd'] || 0) + 8;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 25;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) + 20;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) - 10;\\nQ['kpd_coalition_dissent'] = (Q['kpd_coalition_dissent'] || 0) + 1;\\nQ['coalition_dissent'] = (Q['coalition_dissent'] || 0) - 1;\\nQ['z_relation'] = (Q['z_relation'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\"}],\"achievement\":\"volkspartei\",\"options\":[{\"id\":\"@peoples_party.campaign_workers\"},{\"id\":\"@peoples_party.campaign_middle\"},{\"id\":\"@peoples_party.campaign_rural\"},{\"id\":\"@peoples_party.campaign_unemployed\"},{\"id\":\"@peoples_party.campaign_women\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"In an emergency conference, we have decided to become a people's party that encompasses all of the regular people of Germany, not just the workers and urban poor. The Left and Center claim that our new party platform is a betrayal of our founding principles, a turn away from Marxism towards bourgeois opportunism. Whatever the case, we are now a party representing all of the people, not just the proletariat.\"},{\"type\":\"paragraph\",\"content\":\"Should we run a new campaign to publicize our new platform?\"}]},\"peoples_party_campaigning.campaign_middle\":{\"id\":\"peoples_party_campaigning.campaign_middle\",\"title\":\"Campaign among the middle classes.\",\"onArrival\":[{\"$code\":\"Q['old_middle_spd'] = (Q['old_middle_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\"}],\"content\":{\"content\":\"As a people's party, we represent the employees and small businesspeople of the middle class, and they are becoming receptive to our messages.\",\"type\":\"paragraph\"}},\"rally.police_protect\":{\"id\":\"rally.police_protect\",\"viewIf\":{\"$code\":\"return ((Q['spd_prussia'] || 0) == 1);\"},\"onArrival\":[{\"$code\":\"Q['police_protect_success'] = (((((Q['prussian_police_loyalty'] || 0) * (Q['prussian_police_militancy'] || 0)) * (Q['prussian_police_strength'] || 0)) * 2) - ((Q['sa_militancy'] || 0) * (Q['sa_strength'] || 0)));\"}],\"goTo\":[{\"id\":\"rally.police_protect_win\",\"predicate\":{\"$code\":\"return ((Q['police_protect_success'] || 0) >= 0);\"}},{\"id\":\"rally.police_protect_lose\",\"predicate\":{\"$code\":\"return ((Q['police_protect_success'] || 0) < 0);\"}}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"reichsbanner.militant_2\":{\"id\":\"reichsbanner.militant_2\",\"viewIf\":{\"$code\":\"return ((Q['funded_reichsbanner'] || 0) >= 1);\"},\"onArrival\":[{\"$code\":\"Q['rb_militancy'] = (Q['rb_militancy'] || 0) + 0.02;\\nQ['funded_reichsbanner'] = (Q['funded_reichsbanner'] || 0) - 1;\"}],\"content\":{\"content\":\"As we have already funded resources towards the Reichsbanner, we can invest in building up their militancy.\",\"type\":\"paragraph\"}},\"response_to_antisemitism.if\":{\"id\":\"response_to_antisemitism.if\",\"onArrival\":[{\"$code\":\"Q['confronting_antisemitism'] = (Q['confronting_antisemitism'] || 0) + 2;\\nQ['sa_strength'] = (Q['sa_strength'] || 0) - 20;\\nQ['democratization'] = (Q['democratization'] || 0) + 1;\\nQ['pacifism'] = (Q['pacifism'] || 0) + 1;\\nQ['nationalism'] = (Q['nationalism'] || 0) - (5 * (1 - (Q['dissent'] || 0)));\\nQ['workers_nsdap'] = (Q['workers_nsdap'] || 0) - (6 * (1 - (Q['dissent'] || 0)));\"}],\"content\":{\"content\":\"We develop an entire campaign against antisemitism under the auspices of the Iron Front. Hopefully our campaign can sway the workers away from Nazism.\",\"type\":\"paragraph\"}},\"shuffle_leadership.remove_none\":{\"id\":\"shuffle_leadership.remove_none\",\"title\":\"Stop changing advisors.\",\"goTo\":[{\"id\":\"root\"}],\"tags\":[\"remove_advisor\"],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"streetfighting.arm_rb\":{\"id\":\"streetfighting.arm_rb\",\"subtitle\":{\"content\":[\"-\",{\"type\":\"insert\",\"insert\":0},\" resource\"],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rb_militarization_cost'] || 0);\"}}]},\"chooseIf\":{\"$code\":\"return ((Q['resources'] || 0) >= (Q['rb_militarization_cost'] || 0));\"},\"unavailableSubtitle\":{\"content\":[\"Not enough resources (\",{\"type\":\"insert\",\"insert\":0},\" needed).\"],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rb_militarization_cost'] || 0);\"}}]},\"onArrival\":[{\"$code\":\"Q['resources'] = (Q['resources'] || 0) - (Q['rb_militarization_cost'] || 0);\\nQ['rb_militancy'] = (Q['rb_militancy'] || 0) + 0.06;\\nQ['rb_strength'] = (Q['rb_strength'] || 0) + 50;\\nQ['sa_strength'] = (Q['sa_strength'] || 0) + 50;\\n if ((((Q['historical_mode'] || 0)) !== 0) ) { Q['z_relation'] = (Q['z_relation'] || 0) - 5; }\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"We have increased training and purchased more armaments for the Reichsbanner.\"},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":\"The Center Party decries the militarization of the Reichsbanner, and its members are leaving the republican organization.\",\"predicate\":0}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['historical_mode'] || 0)) !== 0);\"}}]}},\"credits.images\":{\"id\":\"credits.images\",\"options\":[{\"id\":\"@credits\",\"title\":\"Back\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"People\"},\"\"]},{\"type\":\"paragraph\",\"content\":\"ThälmannErnst.jpg: Agence de presse Meurisse. German Politician Ernst Thälmann (1886-1944). 1932. Bibliothèque nationale de France, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Ernst_Th%C3%A4lmann_1932.jpg. Public Domain\"},{\"type\":\"paragraph\",\"content\":\"CrispienArthur.jpg: author, Unknown authorUnknown. Arthur Crispien. 13 Oct. 1931. German Federal Archives, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Arthur_Crispien_crop.jpg. CC-BY-SA 3.0 https://creativecommons.org/licenses/by-sa/3.0/de/deed.en\"},{\"type\":\"paragraph\",\"content\":\"MüllerHermann.jpg: ---. Hermann Müller. 1928date QS:P571,+ - -00T00:00:00Z/9 1928. German Federal Archives, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Bundesarchiv_Bild_146-1979-122-28A,_Hermann_M%C3%BCller.jpg. CC-BY-SA 3.0 https://creativecommons.org/licenses/by-sa/3.0/de/deed.en\"},{\"type\":\"paragraph\",\"content\":\"BraunOtto.jpg: ---. Otto Braun Und Rudolf Breitscheid. 4 Apr. 1932. German Federal Archives, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Bundesarchiv_Bild_102-13412,_Otto_Braun_und_Rudolf_Breitscheid.jpg. CC-BY-SA 3.0 https://creativecommons.org/licenses/by-sa/3.0/de/deed.en\"},{\"type\":\"paragraph\",\"content\":\"WelsOtto.jpg: ---. Otto Wels (1873 - 1939), Deutscher Politiker (SPD). 22 Nov. 2006. http://germanhistorydocs.ghi-dc.org/images/highres_10002240%20copy.jpg, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Ottowelsportait.jpg. CC-BY-SA 4.0 https://creativecommons.org/licenses/by-sa/4.0/deed.en\"},{\"type\":\"paragraph\",\"content\":\"BaadeFritz.jpg: “BaadeFritz.jpg.” Wikipedia, 5 Apr. 2012. Wikipedia, https://de.wikipedia.org/w/index.php?title=Datei:BaadeFritz.jpg&oldid=101696578. Public Domain\"},{\"type\":\"paragraph\",\"content\":\"BreitscheidRudolf.jpg: “BreitscheidRudolf.jpg.” Wikipedia, 28 Mar. 2013. Wikipedia, https://de.wikipedia.org/w/index.php?title=Datei:BreitscheidRudolf.jpg&oldid=116089615. Public Domain\"},{\"type\":\"paragraph\",\"content\":\"KautskyKarl.jpg: Collection, George Grantham Bain. English: German Marxist Karl Kautsky (1884-1938). Unrecorded. This image is available from the United States Library of Congress’s Prints and Photographs division under the digital ID ggbain.30969., Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Karl_Kautsky_01.jpg. Public Domain\"},{\"type\":\"paragraph\",\"content\":\"LeberJulius.jpg: “Datei:LeberJulius.jpg.” Wikipedia, 7 Jan. 2024. Wikipedia, https://de.wikipedia.org/w/index.php?title=Datei:LeberJulius.jpg&oldid=240958104. Public Domain\"},{\"type\":\"paragraph\",\"content\":\"MierendorffCarlo.jpg: “Datei:MierendorffCarlo.jpg.” Wikipedia, 24 Feb. 2010. Wikipedia, https://de.wikipedia.org/w/index.php?title=Datei:MierendorffCarlo.jpg&oldid=71088897. Public Domain\"},{\"type\":\"paragraph\",\"content\":\"RosenfeldKurt.jpg: “Datei:RosenfeldKurt.jpg.” Wikipedia, 18 Aug. 2011. Wikipedia, https://de.wikipedia.org/w/index.php?title=Datei:RosenfeldKurt.jpg&oldid=92597570. Public Domain\"},{\"type\":\"paragraph\",\"content\":\"HilferdingRudolf.jpg: “HilferdingRudolf.jpg.” Wikipedia, 31 Jan. 2018. Wikipedia, https://de.wikipedia.org/w/index.php?title=Datei:HilferdingRudolf.jpg&oldid=173508706. Public Domain\"},{\"type\":\"paragraph\",\"content\":\"PfülfAntonie.jpg: Kester, Philipp. Fotografie von Toni Pfülf. Unknown. Münchner Stadtmuseum, Sammlung Fotografie, Archiv Kester, Inv. Nr. FM-87/61.053.2, Ankauf 1987, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Philipp_Kester,_Toni_Pf%C3%BClf.jpg. CC-BY-SA 4.0 https://creativecommons.org/licenses/by-sa/4.0/deed.en\"},{\"type\":\"paragraph\",\"content\":\"SchumacherKurt.jpg: OCCW, US Army photographers on behalf of the OUSCCPAC or its successor organisation, the. English: Former Concentration Camp Inmate Kurt Schumacher as a Witness during the Nuremberg Trials. between and 1948date QS:P,+1945- -00T00:00:00Z/8,P1319,+1945-00-00T00:00:00Z/9,P1326,+1948-00-00T00:00:00Z/9 1945. https://forum.axishistory.com/viewtopic.php?p=1142184#p1142184, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:K.Schumacher.jpg. Public Domain\"},{\"type\":\"paragraph\",\"content\":\"muller_cabinet.jpg: Ruge, Willi. Kabinett Müller. 6 June 1928. German Federal Archives, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Bundesarchiv_Bild_146-1986-014-10,_Kabinett_M%C3%BCller.jpg. CC-BY-SA 3.0 https://creativecommons.org/licenses/by-sa/3.0/de/deed.en\"},{\"type\":\"paragraph\",\"content\":\"JuchaczMarie.jpg: Saracleg. Español: Marie Juchacz En 1919. 28 Jan. 2022. Own work, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:JuchaczMarie.jpg. CC-BY-SA 4.0 https://creativecommons.org/licenses/by-sa/4.0/deed.en\"},{\"type\":\"paragraph\",\"content\":\"SchleicherKurt.jpg: Sennecke, Robert. El General Kurt von Scheleicher En 1932. 1932. Bibliothèque nationale de France, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:KurtVonScheleicherEn1932.jpeg. Public Domain\"},{\"type\":\"paragraph\",\"content\":\"AufhäuserSiegfried.jpg: “Siegfried Aufhäuser 1928.jpg.” Wikipedia, 6 Nov. 2023. Wikipedia, https://de.wikipedia.org/w/index.php?title=Datei:Siegfried_Aufh%C3%A4user_1928.jpg&oldid=238853315. Public Domain\"},{\"type\":\"paragraph\",\"content\":\"SenderToni.jpg: S-T-R-E-E-T-L-I-V-E. Toni-Sender. photo, 26 Mar. 2013. Flickr, https://www.flickr.com/photos/s-t-r-e-e-t-l-i-v-e/8593056537/. CC-BY-ND 2.0 https://creativecommons.org/licenses/by-nd/2.0/\"},{\"type\":\"paragraph\",\"content\":[\"RadbruchGustav.jpg: Unbekannt, English: UnknownDeutsch: Deutsch: Gustav Radbruch (\",{\"type\":\"emphasis-1\",\"content\":\" 21. November 1878 in Lübeck; † 23. November 1949 in Heidelberg) Deutscher Politiker (SPD). English: or earlierDeutsch: 1920 oder früher 1920. Deutsch: Büro des Reichstags (Hg.): Reichstags-Handbuch 1920, I. Wahlperiode, Verlag der Reichsdruckerei, Berlin 1920, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:RadbruchGustav.jpg. Public Domain\"}]},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"LeviPaul.jpg: ---. Picture of Paul Levi. between circa and circa 1925date QS:P,+1920- -00T00:00:00Z/8,P1319,+1920-00-00T00:00:00Z/9,P1326,+1925-00-00T00:00:00Z/9,P1480,Q5727902 1920. עברית: הספרייה הלאומית, אוסף שבדרון English: National Library of Israel, Schwadron collection, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Paul_Levi_-_Schwadron.jpg. CC-BY 3.0 https://creativecommons.org/licenses/by/3.0/deed.en\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"WissellRudolf.jpg: ---. Rudolf Wissel. 3 Mar. 1930. German Federal Archives, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Bundesarchiv_Bild_102-09381,_Rudolf_Wissel_(cropped).jpg. CC-BY-SA 3.0 https://creativecommons.org/licenses/by-sa/3.0/de/deed.en\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"SeveringCarl.jpg: ---. SeveringCarl. 1919date QS:P571,+ - -00T00:00:00Z/9 1919. German Federal Archives, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Bundesarchiv_Bild_183-R11405,_Carl_Severing.jpg. CC-BY-SA 3.0 https://creativecommons.org/licenses/by-sa/3.0/de/deed.en\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"StresemannGustav.jpg: Gustav Stresemann. circa 1928. German Federal Archives, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Bundesarchiv_Bild_146-1989-040-27,_Gustav_Stresemann.jpg. CC-BY-SA 3.0 https://creativecommons.org/licenses/by-sa/3.0/de/deed.en\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"PapenFranz.jpg: ---. Franz v. Papen. 23 Sept. 1933. German Federal Archives, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Bundesarchiv_Bild_183-1988-0113-500,_Franz_v._Papen_(cropped)(2).jpg. CC-BY-SA 3.0 https://creativecommons.org/licenses/by-sa/3.0/de/deed.en\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"StegerwaldAdam.jpg: Verlag, Herder. Deutsch: Adam Stegerwald, Preußischer Minister, Reichstagsabgeordneter, Zentrum. 1931. Der Große Herder, Band 11, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Adam_Stegerwald_JS2.jpg. Public Domain\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"LeipartTheodor.jpg: Portrait Theodor Leipart 1926. Die Arbeit (1924 - 1933)- Zeitschrift Für Gewerkschaftspolitik Und Wirtschaftskunde : Online-Edition Der Bibliothek Der Friedrich-Ebert-Stiftung. https://library.fes.de/arbeit/bild-leipart2.html. Accessed 6 Apr. 2024. Public Domain\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"WoytinskyWladimir.jpg: “Файл:Владимир Савельевич Войтинский.jpg.” In Википедия, March 19, 2016. https://ru.wikipedia.org/w/index.php?title=%D0%A4%D0%B0%D0%B9%D0%BB:%D0%92%D0%BB%D0%B0%D0%B4%D0%B8%D0%BC%D0%B8%D1%80_%D0%A1%D0%B0%D0%B2%D0%B5%D0%BB%D1%8C%D0%B5%D0%B2%D0%B8%D1%87_%D0%92%D0%BE%D0%B9%D1%82%D0%B8%D0%BD%D1%81%D0%BA%D0%B8%D0%B9.jpg&oldid=77189356.\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"StampferFriedrich.jpg: Porträtfoto von Friedrich Stampfer. circa 1931date QS:P,+ - -00T00:00:00Z/9,P1480,Q5727902 1931. Edmund Schultz (Hrsg.): Das Gesicht der Demokratie. Breitkopf & Härtel, Leipzig 1931, S. 84. https://commons.wikimedia.org/wiki/File:Friedrich_Stampfer.jpg. Public Domain\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"HirschfeldMagnus.jpg: Image of German Physician and Sexologist Magnus Hirschfeld (1868–1935). 1934. This file has been extracted from another file: Karl Giese and Magnus Hirschfeld.jpg. https://commons.wikimedia.org/wiki/File:Magnus_Hirschfeld_1934.jpg. CC-BY-SA 3.0 https://creativecommons.org/licenses/by-sa/3.0/deed.en\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"SeydewitzMax.jpg: Deutsches Reich. Reichstag. Reichstags-Handbuch IV. Wahlperiode 1928. Berlin, 1928.\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"JoosJoseph.jpg: Joseph Joos Katholischer Laie. 1938. Pilger Jahrgang 1938. https://commons.wikimedia.org/wiki/File:Joseph_Joos_JS.jpg. Public Domain\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"Posters\"},\"\"]}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"poster_3.jpg: ---. English: Liste 2 (Zwei). Wählt Sozialdemokraten. (Mit Dem Symbol Der Eisernen Front). Berlin: Kriedemann, (1932). 1932. http://tudigit.ulb.tu-darmstadt.de/show/Plak12_27, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Liste_2._W%C3%A4hlt_Sozialdemokraten.jpg. Public Domain\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"weimar_coalition.jpg: CDU. Unter Diesen Farben Für Einheit Freiheit Vaterland! Wählt: Sozialdemokraten Oder Demokraten Oder Zentrum!Abbildung:Schwarz-Rot-Goldene Fahne Mit AdlermotivKommentar:Reichstagswahl 1924Plakatart:Motiv-/TextplakatKünstler_Grafiker:H. Klaer-G.Drucker_Druckart_Druckort:Offsetdruck Hermann Baswitz, Berlin S 42Objekt-Signatur:10-043 : 8Bestand:Plakatsammlung Weimarer Republik/NS-Zeit (10-043)GliederungBestand10-18:ZentrumLizenz:KAS/ACDP 10-043 : 8 CC-BY-SA 3.0 DE. 1924. This file was provided to Wikimedia Commons by the Konrad-Adenauer-Stiftung, a German political foundation, as part of a cooperation project., Wikimedia Commons, https://commons.wikimedia.org/wiki/File:KAS-Weimarer_Koalition-Bild-15731-1.jpg. CC-BY-SA 3.0 https://creativecommons.org/licenses/by-sa/3.0/de/deed.en\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"weimar_coalition_2.jpg: CDU. Helft Aufbauen! Wählt: Sozialdemokraten, Demokraten, Zentrum!Abbildung:Strichmännchen Richten Aus Trümmern Vor Aufgehender Strahlender Sonne Bauklötze in Nationalfarben aufKommentar:Datum Unsicher; Weitere Plakate von H. Klaer-G. Siehe: 10-043:008, 10-043:009, 10-043:010Plakatart:Motiv-/TextplakatKünstler_Grafiker:H. Klaer-G.Drucker_Druckart_Druckort:Offsetdruck Hermann Baswitz, BerlinObjekt-Signatur:10-043 : 20Bestand:Plakatsammlung Weimarer Republik/NS-Zeit (10-043)GliederungBestand10-18:ZentrumLizenz:KAS/ACDP 10-043 : 20 CC-BY-SA 3.0 DE. 1924. This file was provided to Wikimedia Commons by the Konrad-Adenauer-Stiftung, a German political foundation, as part of a cooperation project., Wikimedia Commons, https://commons.wikimedia.org/wiki/File:KAS-Wiederaufbau-Bild-35026-1.jpg. CC-BY-SA 3.0 https://creativecommons.org/licenses/by-sa/3.0/de/deed.en\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"zentrum_poster.jpg: ---. Wählt Die Führer Der Deutschen Zentrumspartei Die Männer Der Tat Der Wahrheit Und Der Verantwortung Die Bürgen Des Aufbaues Die Gegner Der Phrase Und Der Radikalen Verhetzung Des Volkes! Wählt Liste 3 (Zentrumspartei)Abbildung:PorträtzeichnungenPlakatart:Kandidaten-/Personenplakat Mit PorträtDrucker_Druckart_Druckort:Görres-Druckerei (Koblenzer Volkszeitung)Objekt-Signatur:10-043 : 2Bestand:Plakatsammlung Weimarer Republik/NS-Zeit (10-043)GliederungBestand10-18:ZentrumLizenz:KAS/ACDP 10-043 : 2 CC-BY-SA 3.0 DE. 1930. This file was provided to Wikimedia Commons by the Konrad-Adenauer-Stiftung, a German political foundation, as part of a cooperation project. Wikimedia Commons, https://commons.wikimedia.org/wiki/File:KAS-Br%C3%BCning,_Heinrich_Kaas,_Ludwig-Bild-15724-1.jpg. CC-BY-SA 3.0 https://creativecommons.org/licenses/by-sa/3.0/de/deed.en\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"zentrum_poster_2.jpg: ---. Zurück Zu Brüning Gegen Brudermord Für Ordnung u. Aufbau . Arbeit Und Brot 4 Liste 4Abbildung:Porträtzeichnung, Arbeiter, Pflügender Bauer, FamilieKommentar:Das Plakat Liegt Nur Als Kleinbilddia von Schlechter Bildqualität Vor.Plakatart:Kandidaten-/Personenplakat Mit PorträtObjekt-Signatur:10-043 : 1Bestand:Plakatsammlung Weimarer Republik/NS-Zeit (10-043)GliederungBestand10-18:ZentrumLizenz:KAS/ACDP 10-043 : 1 CC-BY-SA 3.0 DE. This file was provided to Wikimedia Commons by the Konrad-Adenauer-Stiftung, a German political foundation, as part of a cooperation project. Wikimedia Commons, https://commons.wikimedia.org/wiki/File:KAS-Br%C3%BCning,_Heinrich-Bild-15720-1.jpg. Accessed 4 Feb. 2024. CC-BY-SA 3.0 https://creativecommons.org/licenses/by-sa/3.0/de/deed.en\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"1932-kpd.jpg: Deni, Viktor. Русский: Постер КПГ «Конец Этой Системе». Mk:Податотека:1932-Kpd.Jpg. 1932. http://www.lsg.musin.de/Geschichte/Quellen/Plakate/Plakate%20-%20Weimar/plakate_zur_geschichte_der_weima.htm, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:1932-kpd.jpg. Public Domain\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"poster_4.jpg: Deutsch: Schützt Eure Demokratischen Volksrechte – Wählt Liste 2 – Sozialdemokratie. 1932. https://www.baden18-45.de/filter/sozialdemokratische-partei-deutschlands-spd/ (Baden 1918 bis 1945 Das Geschichtsportal des projekts Lernort Kislau), Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Sch%C3%BCtz_Eure_demokratischen_Volksrechte_W%C3%A4hlt_Liste_2_Sozialdemokratie_Wahlplakat_Anti-Faschismus_SPD_1932-11-06_Plakat_SPD_Volksrechte_StadtA_MA_P_318_01_Social_Democratic_Party_Anti-nazi-communist_election_poster_Unknown_artist_No.jpg. CC BY-SA 4.0 https://creativecommons.org/licenses/by-sa/4.0/deed.en\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"Vorwaerts_nr_1.png: de.wikipedia, User Akl on. Beschreibung: Titelseite Des de:Vorwärts Vom 1. Oktober 1876 (Erstausgabe). 19 June 2006. Originally from de.wikipedia; description page is (was) here 21:58, 12. Apr 2004 Akl 445 x 600 (100.894 Byte) (Titelseite des ((:de:Vorwärts)) vom 1. Oktober 1876 (Erstausgabe), Urheberrechte abgelaufen), Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Vorwaerts_nr_1.png. Public Domain\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"kpd_2.jpg: Druckwerkstätten (Verl, Unknown authorUnknown authorSchneller, Ernst; Neue. English: Rote Einheitsfront Unter Führung Der KPD. Arbeit, Brot, Freiheit, Sozialismus Gegen Imperialistischen Krieg. Wählt Thälmann. Hrsg. Und Verantwortlich: Ernst Schneller, Berlin; Sign.: W (Entwurf). Leipzig: Neue Druckwerkstätten (1932). 1932. http://tudigit.ulb.tu-darmstadt.de/show/Plak12_13, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Rote_Einheitsfront_unter_F%C3%BChrung_der_KPD._Arbeit,_Brot,_Freiheit,_Sozialismus_gegen_imperialistischen_Krieg.jpg. Public Domain\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"1925_Workers'_Summer_Olympiad_poster.jpg: “File:1925 Workers’ Summer Olympiad Poster.Jpg.” Wikipedia, 4 Jan. 2021. Wikipedia, https://en.wikipedia.org/w/index.php?title=File:1925_Workers%27_Summer_Olympiad_poster.jpg&oldid=998175748. Public Domain\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"poster_2.jpg: File:Plakat Sozialdemokraten 1928.Jpg - Wikimedia Commons. https://commons.wikimedia.org/wiki/File:Plakat_Sozialdemokraten_1928.jpg. Accessed 3 Feb. 2024. Public Domain\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"Three_Arrows_election_poster.png: Fritz, Plakatsammlung Karl. English: Election Poster of the Social Democratic Party of Germany, 1932, with Three Arrows Symbol Representing Resistance against Reactionary Conservatism, Nazism and Communism, with the Slogan “Gegen (Against) Papen, Hitler, Thälmann.” 23 Mar. 2021. https://www.europeana.eu/en/item/00735/plink__f_5_197016, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Three_Arrows_election_poster_of_the_Social_Democratic_Party_of_Germany,_1932_-_Gegen_Papen,_Hitler,_Th%C3%A4lmann.png. CC-BY-SA 4.0 https://creativecommons.org/licenses/by-sa/4.0/deed.en\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"poster_0.jpg: Kirchbach, Design Fritz Gottfried. English: Gleiche Rechte Gleiche Pflichten. German Social Democrat Party Election Poster 1919. 1919. http://www.dhm.de/ausstellungen/grundrechte/kap1_2.htm, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Gleiche_Rechte_Gleiche_Pflichten,_social_democrat_party_poster_1919.jpg. Public Domain\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"braun.jpg: Kirchbach, Poster artist: Fritz Gottfried. Plakat Der SPD Zur Reichstagswahl. 3 Mar. 1925. German Federal Archives, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Bundesarchiv_Bild_102-01196,_Plakat_der_SPD_zur_Reichstagswahl.jpg. Public Domain\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"vorwarts_2.jpg: Julie Wolfthorn - VORWÄRTS. Mark 1,10 pro Monat; Frei Ins Haus. Farblithographie, 1360 Mm x 930 Mm, Vor 1902, Druck: Kunstanstalt Hollerbaum & Schmidt, Berlin. before 1902date QS:P,+ - -00T00:00:00Z/7,P1326,+1902-00-00T00:00:00Z/9 1902. http://www.kulturpool.at/plugins/kulturpool/showitem.action?itemId=4296109451, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Julie_Wolfthorn_-_VORW%C3%84RTS._Mark_1,10_pro_Monat;_frei_ins_Haus.jpg. Public Domain\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"sangerbund.jpg: Reibetantz, Curt. Deutsch: Plakat von Curt Reibetantz Für Das Erste Deutsche Arbeitersängerbundesfest Vom 16. Bis 18. Juni 1928 in Hannover. Mehrfarbdruck Durch Die Buchdruckerwerkstätte GmbH in Berlin in Den Maßen 88 x 59,2 Cm ... 1929. https://www.plakatkontor.de/plakatkatalog-14/nr-70---77/index.html, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:1928_Curt_Reibetantz_Plakat_Hannover_1928_Erstes_Deutsches_Arbeiter_S%C3%A4ngerbundesfest.jpg. Public Domain\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"poster_1.png: Riemer, Walter. English: “Worker, Open Your Eyes!” Workers Are Supposed to Become Political Active to Defend Social Democracy against Forces from the Left (Communist, USPD) and the Right (Monarchist, Militarisitc). 1 Jan. 1919. href=\\\"http://digital.slub-dresden.de/id446234842-19210090\\\", Wikimedia Commons, https://commons.wikimedia.org/wiki/File:SPD-1919--Wahlwerbung-Walter-Riemer.png. CC-BY-SA 4.0 https://creativecommons.org/licenses/by-sa/4.0/deed.en\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"hindenburg_election.jpg: Berlin, Wahlplakat Für Hindenburg. 3 Mar. 1932. German Federal Archives, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Bundesarchiv_Bild_183-R99203,_Berlin,_Wahlplakat_f%C3%BCr_Hindenburg.jpg. CC-BY-SA 3.0 https://creativecommons.org/licenses/by-sa/3.0/de/deed.en\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"All_Quiet.jpg: Poster for the 1930 Film All Quiet on the Western Front. 1930. https://commons.wikimedia.org/wiki/File:All_Quiet_on_the_Western_Front_(1930_film)_poster.jpg. Public Domain\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"Other\"},\"\"]}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"map.jpg, map_2.jpg: Anonymous. Meyers Blitz-Lexikon. English: scanned by User:LA2 in September 2005, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:LA2-Blitz-0083.jpg. Accessed 3 Feb. 2024. Public Domain\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"reichstag_2.jpg: ---. Berlin, Reichstag, Verfassungsfeier. 11 Aug. 1932. German Federal Archives, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Bundesarchiv_Bild_102-13744,_Berlin,_Reichstag,_Verfassungsfeier.jpg. CC-BY-SA 3.0 https://creativecommons.org/licenses/by-sa/3.0/de/deed.en\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"reichstag_3.jpg: ---. Berlin, Sitzung Des Reichstages. 12 Sept. 1932. German Federal Archives, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Bundesarchiv_Bild_102-13850,_Berlin,_Sitzung_des_Reichstages.jpg. CC-BY-SA 3.0 https://creativecommons.org/licenses/by-sa/3.0/de/deed.en\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"protest.jpg: ---. Berlin, Versammlung Der Republikaner. 7 July 1932. German Federal Archives, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Bundesarchiv_Bild_102-13624,_Berlin,_Versammlung_der_Republikaner.jpg. CC-BY-SA 3.0 https://creativecommons.org/licenses/by-sa/3.0/de/deed.en\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"arbeiterbew.jpg: ---. Deutsch: Köpfe Der Frühen Deutschen Arbeiterbewegung: Unknown dateUnknown date. scan (aus Sozialdemokratie im Wandel, S.27), Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Arbeiterbew.jpg. Public Domain\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"iron_front_rally.jpg: Berlin, Aufmarsch Der “Eisernen Front.” 3 Mar. 1932. German Federal Archives, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Bundesarchiv_Bild_102-13201A,_Berlin,_Aufmarsch_der_%22Eisernen_Front%22.jpg. CC-BY-SA 3.0 https://creativecommons.org/licenses/by-sa/3.0/de/deed.en\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"blutmai_2.jpg: Berlin, Blutmai, Straßenbarrikade. 5 May 1929. German Federal Archives, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Bundesarchiv_B_145_Bild-P046278,_Berlin,_Blutmai,_Stra%C3%9Fenbarrikade.jpg. CC-BY-SA 3.0 https://creativecommons.org/licenses/by-sa/3.0/de/deed.en\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"reichsbanner.jpg: Berlin, Kundgebung Des Reichsbanners Im Lustgarten. 3 Mar. 1928. German Federal Archives, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Bundesarchiv_Bild_102-05611,_Berlin,_Kundgebung_des_Reichsbanners_im_Lustgarten.jpg. CC-BY-SA 3.0 https://creativecommons.org/licenses/by-sa/3.0/de/deed.en\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"stahlhelm.jpg: Berlin, Lustgarten, Stahlhelmaufmarsch. 3 Mar. 1931. German Federal Archives, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Bundesarchiv_Bild_102-11416,_Berlin,_Lustgarten,_Stahlhelmaufmarsch.jpg. CC-BY-SA 3.0 https://creativecommons.org/licenses/by-sa/3.0/de/deed.en\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"danat_bank.jpg: Ceccaldi, Julie. English: Darmstädter Und Nationalbank KGaA (DANAT-Bank) Stock Certificate for 100 Reichsmark, Issued in October 1928 in Berlin. 4 Apr. 2023. „Sammlung Commodore“, Rüdiger K. Weng, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Darmstaedter_und_Nationalbank_1928.jpg.\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"mann_der_arbeit.jpg: credited, Poet: Georg Herwegh, artist not. Mann Der Arbeit, Aufgewacht! Und Erkenne Deine Macht! Alle Räder Stehen Still, Wenn Dein Starker Arm Es Will, Postkarte. Druck Und Verlag: Rauh Und Pohle, Leipzig. circa 1910date QS:P,+ - -00T00:00:00Z/9,P1480,Q5727902 1910. ebay, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Mann_der_Arbeit,_aufgewacht!_Postkarte,_c._1910.jpg. Public Domain\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"zentrum.png: “File:Logo of the German Centre Party.Svg.” Wikipedia, 9 Dec. 2023. Wikipedia, https://en.wikipedia.org/w/index.php?title=File:Logo_of_the_German_Centre_Party.svg&oldid=1189025539. Public Domain\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"freiheit_und_arbeit.jpg: Ganss (Verl, Unknown authorUnknown authorHeedt &. English: Freiheit Und Arbeit! (Mit Dem Symbol Der “Eisernen Front” Über Dem Hakenkreuz). Darmstadt: Heedt & Ganss, (1932). 1932. http://tudigit.ulb.tu-darmstadt.de/show/Plak10_02, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Freiheit_und_Arbeit!_(Mit_dem_Symbol_der_%22Eisernen_Front%22_%C3%BCber_dem_Hakenkreuz).jpg. Public Domain\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"international.jpg: ---. Français : Drapeau Genevois de l’Association Internationale Des Travailleurs. 1 Jan. 1864. https://bge-geneve.ch/iconographie/oeuvre/vg-1131317, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Drapeau_genevois_de_l%27Association_Internationale_des_travailleurs.png. Public Domain\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"sapd.jpg: Giannisfl. Das Logo von SAP. 25 Dec. 2022. https://imgur.com/gallery/bQejNsc, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Sozialistische_Arbeiterpartei_Deutschlands-01.svg. CC-BY-SA 4.0 https://creativecommons.org/licenses/by-sa/4.0/deed.en\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"spartakus.jpg: Leipzig, Verlag J. J. Weber in. Deutsch: Barrikade Während Des Spartakusaufstandes. 12 Jan. 1919. Illustrirte Zeitung, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Spartakusaufstand_Barrikaden.jpg. Public Domain\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"workers.jpg: Marcus, Otto. Français : \\\"Prolétaires de Tous Les Pays, Unissez-Vous! 1901. http://cjouneau1.free.fr/4eme/mvt_ouvriers/socialisme.html, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Proletarier_aller_L%C3%A4nder,_vereinigt_euch_(cropped).jpg. Public Domain\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"reichsbanner_flag.jpg: Michel, Der. Flagge Des Reichsbanners Schwarz-Rot-Gold, Bund Aktiver Demokraten. 15 June 2013. Own work, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Flagge_Reichsbanner_2013.jpg. CC-BY-SA 3.0 https://creativecommons.org/licenses/by-sa/3.0/deed.en\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"bankrun.jpg: Berlin, Bankenkrach, Andrang Bei Der Sparkasse. 13 July 1931. German Federal Archives, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Bundesarchiv_Bild_102-12023,_Berlin,_Bankenkrach,_Andrang_bei_der_Sparkasse.jpg. CC-BY-SA 3.0 https://creativecommons.org/licenses/by-sa/3.0/de/deed.en\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"spd_logo.jpg: Nicklaarakkers. Deutsch: Selbst Gemacht Logo Der SPD in Den 1930er Jahren. 15 June 2008. Own work, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Sozialdemokratische_Partei_Deutschlands,_Logo_um_1930.jpg. Public Domain\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"panzerkreuzer.jpg: Seized, 1675-1958, Heinrich Hoffman Collection, U. S. National Archives Collection of Foreign Records. The German “Pocket Battleship” Deutschland with Her Crew Manning the Rails, 1935. This Ship Was Reclassified as a Heavy Cruiser and Renamed Lützow in 1939. 1935. Photograph 242-HB-14598a34 from the Hoffman collection in the U.S. National Archives from the U.S. Navy Naval History and Heritage Command, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:German_cruiser_Deutschland_in_1935.jpg. Public Domain\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"blutmai.jpg: Sturkow. Berlin, Mai-Unruhen. 5 May 1929. German Federal Archives, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Bundesarchiv_Bild_102-07717,_Berlin,_Mai-Unruhen.jpg. CC-BY-SA 3.0 https://creativecommons.org/licenses/by-sa/3.0/de/deed.en\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"comintern_logo.png: Thespoondragon. English: Logo of the Comintern World Congress, Based on the Photo on This Page: Http://Www.Orlandofiges.Info/section13_RevolutionforExport/TheComintern.Php Similar Logo: Https://Www.Pikfox.Com/Media/Bubevp1BiG5. 3 Oct. 2018. Own work, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Comintern_Logo.svg. CC-BY-SA 4.0 https://creativecommons.org/licenses/by-sa/4.0/deed.en\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"reichstag_1.jpg: Unknown. Berlin, Reichstag, Reichsgründungsfeier. Jan. 1931. German Federal Archives, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Bundesarchiv_Bild_102-11057A,_Berlin,_Reichstag,_Reichsgr%C3%BCndungsfeier.jpg. CC-BY-SA 3.0 https://creativecommons.org/licenses/by-sa/3.0/de/deed.en\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"flags.jpg: UnknownUnknown. Berlin, Maidemonstration Der SPD. 1 May 1930. German Federal Archives, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Bundesarchiv_Bild_102-09700,_Berlin,_Maidemonstration_der_SPD.jpg. CC-BY-SA 3.0 https://creativecommons.org/licenses/by-sa/3.0/de/deed.en\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"reichsbanner_2.jpg: Verfassungsfeier, Hörsing Vor Dem Berliner Schloss. 11 Aug. 1929. German Federal Archives, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Bundesarchiv_Bild_102-08218,_Verfassungsfeier,_H%C3%B6rsing_vor_dem_Berliner_Schloss.jpg. CC-BY-SA 3.0 https://creativecommons.org/licenses/by-sa/3.0/de/deed.en\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"iron_front.png: Warddr, FusslkoppSVG-version made by. Symbol of the Iron Front. 17 Oct. 2004. http://de.wikipedia.org/wiki/Bild:Eiserne_Front_Symbol.png, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Eiserne_Front_Symbol.svg. CC-BY-SA 3.0 https://creativecommons.org/licenses/by-sa/3.0/deed.en\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"kpd.jpg: Weinrother, Carl. Berlin, Liebknecht-Haus Am Bülowplatz. 1932date QS:P571,+ - -00T00:00:00Z/9 1932. German Federal Archives, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Bundesarchiv_B_145_Bild-P046279,_Berlin,_Liebknecht-Haus_am_B%C3%BClowplatz.jpg. CC-BY-SA 3.0 https://creativecommons.org/licenses/by-sa/3.0/de/deed.en\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"union_2.jpg: Werbekarte Des Deutschen Holzarbeiterverbands. 1900. Self-scanned, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Deutscher_Holzarbeiter_Verband_Werbekarte_um_1900.jpg. Public Domain\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"rfkb_logo.png: РОСТа“, Пётр Лидов, Telegram-канал „Окна. Русский: Членские Знаки Союза Красных Фронтовиков Делятся На Два Типа: 31 Jan. 2023. https://t.me/okna_rosta, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Bundesabzeichen_1924-1926.png. Public Domain\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"redfront.jpg: author, Unknown authorUnknown. Berlin, Pfingstreffen Der Rot-Front-Kämpfer. 5 May 1928. German Federal Archives, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Bundesarchiv_Bild_102-05977,_Berlin,_Pfingstreffen_der_Rot-Front-K%C3%A4mpfer.jpg. CC-BY-SA 3.0 https://creativecommons.org/licenses/by-sa/3.0/de/deed.en\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"generalstrike.jpg: ---. Vorwärts1918. photo, 26 Mar. 2013. Flickr, https://www.flickr.com/photos/s-t-r-e-e-t-l-i-v-e/8593159825/. CC-BY-ND 2.0 https://creativecommons.org/licenses/by-nd/2.0/\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"hirschfeld.jpg: author, Unknown. From Left, Bernhardt (Bernard) Schapiro, Magnus Hirschfeld, Tao Lee. Location Berlin, Germany. circa 1920. https://collections.ushmm.org/search/catalog/pa1136956, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Bernhard_Schapiro,_Magnus_Hirschfeld,_Tao_Lee.jpg. Public Domain\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"Reichstagsfraktion_der_SPD.jpg: 75CT. (1914). Deutsch: Reichstagsfraktion der SPD. https://commons.wikimedia.org/wiki/File:Reichstagsfraktion_der_SPD.jpg. Public Domain\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"Rothe_Wahlen_1903.jpg: Rothe Wahlen, Illustrierte Festzeitung für 1903. https://commons.wikimedia.org/wiki/File:Rothe_Wahlen_1903.jpg. Public Domain\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"Der_wahre_Jacob.jpg: (1900). https://commons.wikimedia.org/wiki/File:Der_wahre_Jacob_1900_Titel.jpg. Public Domain\"}},{\"type\":\"paragraph\",\"content\":{\"type\":\"emphasis-1\",\"content\":\"Reichswehr.jpg: Reichswehrposten Vor Dem Reichswehrministerium. July 7, 1932. German Federal Archives. https://commons.wikimedia.org/wiki/File:Bundesarchiv_Bild_102-13678,_Reichswehrposten_vor_dem_Reichswehrministerium.jpg. CC-BY-SA 3.0 https://creativecommons.org/licenses/by-sa/3.0/de/deed.en\"}}]},\"election_simulation.1932\":{\"id\":\"election_simulation.1932\",\"onArrival\":[{\"$code\":\"Q.workers = 46; // industry and trade\\nQ.old_middle = 13; // \\\"old mittelstand\\\"\\n// 16.4 trade & commerce, 6.6 public and private services, 4.4 domestic help\\nQ.new_middle = 14; // \\\"new mittelstand\\\"\\nQ.rural = 25; // agriculture and forestry employment... but many of those are proletarians so...\\n// source: https://surface.syr.edu/cgi/viewcontent.cgi?filename=3&article=1016&context=books&type=additional page 43, table 3.3\\nQ.unemployed = 33;\\nQ.catholics = 30;\\n\\nQ.classes = ['workers', 'old_middle', 'new_middle', 'rural', 'unemployed', 'catholics'];\\nQ.parties = ['spd', 'kpd', 'z', 'ddp', 'dvp', 'dnvp', 'nsdap', 'other'];\\n\\n// Support for party by social group\\n// they don't have to sum to 100 since the electoral calculations will be normalized.\\nQ.workers_spd = 55;\\nQ.workers_kpd = 20;\\nQ.workers_z = 5;\\nQ.workers_ddp = 0;\\nQ.workers_dvp = 0;\\nQ.workers_dnvp = 0;\\nQ.workers_nsdap = 15;\\nQ.workers_other = 5;\\n\\nQ.old_middle_spd = 0;\\nQ.old_middle_kpd = 0;\\nQ.old_middle_z = 5;\\nQ.old_middle_ddp = 4;\\nQ.old_middle_dvp = 4;\\nQ.old_middle_dnvp = 15;\\nQ.old_middle_nsdap = 70;\\nQ.old_middle_other = 5;\\n\\nQ.new_middle_spd = 5;\\nQ.new_middle_kpd = 0;\\nQ.new_middle_z = 5;\\nQ.new_middle_ddp = 10;\\nQ.new_middle_dvp = 10;\\nQ.new_middle_dnvp = 10;\\nQ.new_middle_nsdap = 60;\\nQ.new_middle_other = 5;\\n\\nQ.rural_spd = 0;\\nQ.rural_kpd = 0;\\nQ.rural_z = 5;\\nQ.rural_ddp = 0;\\nQ.rural_dvp = 5;\\nQ.rural_dnvp = 15;\\nQ.rural_nsdap = 65;\\nQ.rural_other = 5;\\n\\nQ.unemployed_spd = 20;\\nQ.unemployed_kpd = 40;\\nQ.unemployed_z = 0;\\nQ.unemployed_ddp = 0;\\nQ.unemployed_dvp = 0;\\nQ.unemployed_dnvp = 0;\\nQ.unemployed_nsdap = 50;\\nQ.unemployed_other = 5;\\n\\nQ.catholics_spd = 10;\\nQ.catholics_kpd = 5;\\nQ.catholics_z = 60;\\nQ.catholics_ddp = 0;\\nQ.catholics_dvp = 5;\\nQ.catholics_dnvp = 5;\\nQ.catholics_nsdap = 10;\\nQ.catholics_other = 5;\\n\\nQ.spd_r = 25;\\nQ.kpd_r = 10;\\nQ.z_r = 15;\\nQ.ddp_r = 10;\\nQ.dvp_r = 10;\\nQ.dnvp_r = 14;\\nQ.nsdap_r = 10;\\nQ.other_r = 5;\"}],\"goTo\":[{\"id\":\"election_algorithm\"}],\"setJump\":\"election_simulation.post_election\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"game_over.war_against_hitler\":{\"id\":\"game_over.war_against_hitler\",\"viewIf\":{\"$code\":\"return ((((Q['chancellor'] == \\\"Hitler\\\") || (Q['president'] == \\\"Hitler\\\"))) && (((Q['long_war'] || 0) == 1)));\"},\"title\":\"Adolf Hitler is in power, but we are fighting to stop him.\",\"tags\":[\"endings\"],\"goTo\":[{\"id\":\"game_over.eg_menu\"}],\"content\":{\"content\":\"Adolf Hitler has taken power in Germany. However, we have rallied the democratic forces of the country against him, and are fighting back. The outcome of this war is uncertain.\",\"type\":\"paragraph\"}},\"library.weimar_timeline\":{\"id\":\"library.weimar_timeline\",\"goTo\":[{\"id\":\"library.menu\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Timeline of the SPD and the Republic (until 1928)\"},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"1875\"},\": The SPD is formed as a merger of the General German Workers' Association, founded by Ferdinand Lassalle, and the Social Democratic Workers' Party of Germany, led by Wilhelm Liebknecht and August Bebel. Eventually, the SPD grows to become the largest party in the German Empire.\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"1914\"},\": The Great War begins. The SPD votes in favor of war credits, with substantial internal dissent. This begins a policy of \",{\"type\":\"emphasis-1\",\"content\":\"Burgfriedenspolitik\"},\", a general peace between all political parties and trade unions.\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"1917\"},\": The USPD, a left-wing anti-war split from the SPD, is formed.\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"1918\"},\": Following defeats in the war and uprisings by soldiers, sailors, and workers, SPD leader Philip Scheidemann proclaims the German Republic, and Kaiser Wilhelm II abdicates from his throne. An armistice is declared, ending the Great War. Conflict between center-left social democrats and far-left radicals erupts in the streets of Berlin and elsewhere.\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"1919\"},\": The Spartacist Uprising, in which communist workers attempt to seize control of government, is launched. The uprising is defeated by the Social Democratic government, now led by President Friedrich Ebert and Chancellor Philipp Scheidemann, with the support of the far-right Freikorps militas. The two key leaders of the uprising, Rosa Luxemburg and Karl Liebknecht, are murdered by the Freikorps. The Treaty of Versailles is signed under great protest from all political factions in Germany, officially ending the Great War. The Weimar Constitution is signed. The first \\\"Weimar Coalition\\\" government is formed, led by the SPD, DDP, and Center (Z) parties.\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"1920\"},\": The Kapp Putsch, an attempt by reactionary actors within the military to take power, is launched, and is defeated by the workers with a general strike. This is followed by left-wing uprisings in the Ruhr, which are defeated by the Reichswehr and Freikorps. The Weimar Coalition is defeated in the elections, with the right and far left increasing in vote share. Elected governments in this period are very unstable, often only lasting a matter of months. There is a split in the USPD, with the majority faction joining with the KPD and the Soviet Union's Communist International (Comintern) alliance.\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"1921\"},\": Communist uprisings in Saxony and Hamburg are defeated. Matthias Erzberger, the Center Party leader who signed the Versailles Treaty, is assassinated.\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"1922\"},\": Walther Rathenau, the DDP Foreign Minister, is assassinated. The SPD reunites with most of the remaining USPD.\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"1923\"},\": Hyperinflation begins, largely due to the economic policy of \\\"passive resistance\\\" against the French occupation of the Ruhr and the Versailles reparations. The currency is rapidly devalued as prices for necessities rise to billions of Reichsmarks. The government launches a \",{\"type\":\"emphasis-1\",\"content\":\"Reichsexekution\"},\" against Saxony, which was led by a joint SPD-KPD government. The Nazi \\\"Beer Hall Putsch\\\" is launched in Munich, and fails, with the arrest of Hitler. Eventually, new policies manage to stabilize the currency, and the French occupation ends.\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"1924\"},\": Parliamentary elections are held in May and December, the latter leading to the bourgeois-right governments that last until 1928. Germany begins to enter a period of relative stability, with the end of the hyperinflation crisis. Hitler is released from prison.\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"1925\"},\": President Friedrich Ebert dies, and new presidential elections are held, leading to the narrow election of Paul von Hindenburg in the second round. Hindenburg is a war hero and a right-wing reactionary. The SPD adopts the Heidelberg Program as its party platform.\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"1926\"},\": A referendum on the expropriation of the princes, supported by the SPD and KPD, fails.\"]}]},\"main.govt\":{\"id\":\"main.govt\",\"title\":\"Government Affairs\",\"viewIf\":{\"$code\":\"return ((Q['time'] || 0) >= 6);\"},\"cardImage\":\"img/reichstag_2.jpg\",\"isDeck\":true,\"options\":[{\"id\":\"#govt_affairs\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"main\":{\"id\":\"main\",\"type\":\"scene\",\"title\":\"Next month\",\"setBg\":\"img/map_2.jpg\",\"isHand\":true,\"onArrival\":[{\"$code\":\"if (Q.advisor_action_timer <= 0) {\\n    Q.pinnedCardsDescription = 'Advisors - an action is available.';\\n} else if (Q.advisor_action_timer == 1) {\\n    Q.pinnedCardsDescription = 'Advisors - next action available in 1 month.';\\n} else {\\n    Q.pinnedCardsDescription = 'Advisors - next action available in ' + Q.advisor_action_timer + ' months.';\\n}\"}],\"maxCards\":3,\"options\":[{\"id\":\"@main.party\"},{\"id\":\"@main.govt\"},{\"id\":\"#advisor\"},{\"id\":\"@shuffle_leadership_pinned\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":\"The current bourgeois-right government has fallen. The next elections are slated for May of this year.\",\"predicate\":0}},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['year'] || 0)===1928) && ((Q['month'] || 0)===2));\"}}]}},\"status.polls\":{\"id\":\"status.polls\",\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"Projected election results\"},{\"type\":\"paragraph\",\"content\":\"(if the election were to be held now):\"},{\"type\":\"paragraph\",\"content\":[\"SPD: \",{\"type\":\"insert\",\"insert\":0},\"%\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"SAPD: \",{\"type\":\"insert\",\"insert\":2},\"% \"],\"predicate\":1},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Z + BVP: \",{\"type\":\"insert\",\"insert\":3},\"%\"]},{\"type\":\"paragraph\",\"content\":[\"KPD: \",{\"type\":\"insert\",\"insert\":4},\"%\"]},{\"type\":\"paragraph\",\"content\":[\"DDP: \",{\"type\":\"insert\",\"insert\":5},\"%\"]},{\"type\":\"paragraph\",\"content\":[\"DVP: \",{\"type\":\"insert\",\"insert\":6},\"%\"]},{\"type\":\"paragraph\",\"content\":[\"DNVP: \",{\"type\":\"insert\",\"insert\":7},\"%\"]},{\"type\":\"paragraph\",\"content\":[\"NSDAP: \",{\"type\":\"insert\",\"insert\":8},\"%\"]},{\"type\":\"paragraph\",\"content\":[\"Others: \",{\"type\":\"insert\",\"insert\":9},\"%\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"Detailed results for each demographic\"},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Workers: SPD: \",{\"type\":\"insert\",\"insert\":10},\"%, Z: \",{\"type\":\"insert\",\"insert\":11},\"%, KPD: \",{\"type\":\"insert\",\"insert\":12},\"%, DDP: \",{\"type\":\"insert\",\"insert\":13},\"%, DVP: \",{\"type\":\"insert\",\"insert\":14},\"%; DNVP: \",{\"type\":\"insert\",\"insert\":15},\"%, NSDAP: \",{\"type\":\"insert\",\"insert\":16},\"%, Others: \",{\"type\":\"insert\",\"insert\":17},\"% \",{\"type\":\"conditional\",\"content\":[\"SAPD: \",{\"type\":\"insert\",\"insert\":19},\"% \"],\"predicate\":18},\"\"]},{\"type\":\"paragraph\",\"content\":[\"New Middle Class: SPD: \",{\"type\":\"insert\",\"insert\":20},\"%, Z: \",{\"type\":\"insert\",\"insert\":21},\"%, KPD: \",{\"type\":\"insert\",\"insert\":22},\"%, DDP: \",{\"type\":\"insert\",\"insert\":23},\"%, DVP: \",{\"type\":\"insert\",\"insert\":24},\"%; DNVP: \",{\"type\":\"insert\",\"insert\":25},\"%, NSDAP: \",{\"type\":\"insert\",\"insert\":26},\"%, Others: \",{\"type\":\"insert\",\"insert\":27},\"% \",{\"type\":\"conditional\",\"content\":[\"SAPD: \",{\"type\":\"insert\",\"insert\":29},\"% \"],\"predicate\":28},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Old Middle Class: SPD: \",{\"type\":\"insert\",\"insert\":30},\"%, Z: \",{\"type\":\"insert\",\"insert\":31},\"%, KPD: \",{\"type\":\"insert\",\"insert\":32},\"%, DDP: \",{\"type\":\"insert\",\"insert\":33},\"%, DVP: \",{\"type\":\"insert\",\"insert\":34},\"%; DNVP: \",{\"type\":\"insert\",\"insert\":35},\"%, NSDAP: \",{\"type\":\"insert\",\"insert\":36},\"%, Others: \",{\"type\":\"insert\",\"insert\":37},\"% \",{\"type\":\"conditional\",\"content\":[\"SAPD: \",{\"type\":\"insert\",\"insert\":39},\"% \"],\"predicate\":38},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Rural: SPD: \",{\"type\":\"insert\",\"insert\":40},\"%, Z: \",{\"type\":\"insert\",\"insert\":41},\"%, KPD: \",{\"type\":\"insert\",\"insert\":42},\"%, DDP: \",{\"type\":\"insert\",\"insert\":43},\"%, DVP: \",{\"type\":\"insert\",\"insert\":44},\"%; DNVP: \",{\"type\":\"insert\",\"insert\":45},\"%, NSDAP: \",{\"type\":\"insert\",\"insert\":46},\"%, Others: \",{\"type\":\"insert\",\"insert\":47},\"% \",{\"type\":\"conditional\",\"content\":[\"SAPD: \",{\"type\":\"insert\",\"insert\":49},\"% \"],\"predicate\":48},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Unemployed: SPD: \",{\"type\":\"insert\",\"insert\":50},\"%, Z: \",{\"type\":\"insert\",\"insert\":51},\"%, KPD: \",{\"type\":\"insert\",\"insert\":52},\"%, DDP: \",{\"type\":\"insert\",\"insert\":53},\"%, DVP: \",{\"type\":\"insert\",\"insert\":54},\"%; DNVP: \",{\"type\":\"insert\",\"insert\":55},\"%, NSDAP: \",{\"type\":\"insert\",\"insert\":56},\"%, Others: \",{\"type\":\"insert\",\"insert\":57},\"% \",{\"type\":\"conditional\",\"content\":[\"SAPD: \",{\"type\":\"insert\",\"insert\":59},\"% \"],\"predicate\":58},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Catholics: SPD: \",{\"type\":\"insert\",\"insert\":60},\"%, Z: \",{\"type\":\"insert\",\"insert\":61},\"%, KPD: \",{\"type\":\"insert\",\"insert\":62},\"%, DDP: \",{\"type\":\"insert\",\"insert\":63},\"%, DVP: \",{\"type\":\"insert\",\"insert\":64},\"%; DNVP: \",{\"type\":\"insert\",\"insert\":65},\"%, NSDAP: \",{\"type\":\"insert\",\"insert\":66},\"%, Others: \",{\"type\":\"insert\",\"insert\":67},\"% \",{\"type\":\"conditional\",\"content\":[\"SAPD: \",{\"type\":\"insert\",\"insert\":69},\"% \"],\"predicate\":68},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Support for the Republic: \",{\"type\":\"insert\",\"insert\":70},\"%\"]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['spd_votes'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['sapd_formed'] || 0)) !== 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['sapd_votes'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['z_votes'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['kpd_votes'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['ddp_votes'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['dvp_votes'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['dnvp_votes'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['nsdap_votes'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['other_votes'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['workers_spd_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['workers_z_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['workers_kpd_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['workers_ddp_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['workers_dvp_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['workers_dnvp_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['workers_nsdap_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['workers_other_normalized'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['sapd_formed'] || 0)) !== 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['workers_sapd_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['new_middle_spd_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['new_middle_z_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['new_middle_kpd_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['new_middle_ddp_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['new_middle_dvp_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['new_middle_dnvp_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['new_middle_nsdap_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['new_middle_other_normalized'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['sapd_formed'] || 0)) !== 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['new_middle_sapd_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['old_middle_spd_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['old_middle_z_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['old_middle_kpd_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['old_middle_ddp_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['old_middle_dvp_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['old_middle_dnvp_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['old_middle_nsdap_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['old_middle_other_normalized'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['sapd_formed'] || 0)) !== 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['old_middle_sapd_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rural_spd_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rural_z_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rural_kpd_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rural_ddp_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rural_dvp_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rural_dnvp_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rural_nsdap_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rural_other_normalized'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['sapd_formed'] || 0)) !== 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rural_sapd_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['unemployed_spd_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['unemployed_z_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['unemployed_kpd_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['unemployed_ddp_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['unemployed_dvp_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['unemployed_dnvp_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['unemployed_nsdap_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['unemployed_other_normalized'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['sapd_formed'] || 0)) !== 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['unemployed_sapd_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['catholics_spd_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['catholics_z_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['catholics_kpd_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['catholics_ddp_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['catholics_dvp_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['catholics_dnvp_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['catholics_nsdap_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['catholics_other_normalized'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['sapd_formed'] || 0)) !== 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['catholics_sapd_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['pro_republic'] || 0);\"}}]}},\"status\":{\"id\":\"status\",\"type\":\"scene\",\"title\":\"Status\",\"newPage\":true,\"isSpecial\":true,\"onArrival\":[{\"$code\":\"if (Q.unemployed) {\\n    Q.unemployed_2 = Q.unemployed.toFixed(1);\\n}\\nif (Q.inflation) {\\n    Q.inflation_2 = Q.inflation.toFixed(1);\\n}\"}],\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"Status\"},{\"type\":\"paragraph\",\"content\":[{\"type\":\"insert\",\"insert\":0},\" \",{\"type\":\"insert\",\"insert\":1},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Resources available: \",{\"type\":\"insert\",\"insert\":2},\"\"]},{\"type\":\"paragraph\",\"content\":[\"SPD position: \",{\"type\":\"conditional\",\"content\":\"toleration \",\"predicate\":3},{\"type\":\"conditional\",\"content\":\"in government - \",\"predicate\":4},{\"type\":\"conditional\",\"content\":\"opposition \",\"predicate\":5},{\"type\":\"conditional\",\"content\":\"caretaker government \",\"predicate\":6},\" \",{\"type\":\"conditional\",\"content\":\"Weimar Coalition \",\"predicate\":7},{\"type\":\"conditional\",\"content\":\"Grand Coalition \",\"predicate\":8},{\"type\":\"conditional\",\"content\":\"Popular Front \",\"predicate\":9},{\"type\":\"conditional\",\"content\":\"Left Front \",\"predicate\":10},{\"type\":\"conditional\",\"content\":\"SPD majority \",\"predicate\":11},{\"type\":\"conditional\",\"content\":\"minority government \",\"predicate\":12},{\"type\":\"conditional\",\"content\":\"emergency government \",\"predicate\":13},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"Coalition dissent: \",{\"type\":\"insert\",\"insert\":15},\" \"],\"predicate\":14},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"KPD coalition dissent: \",{\"type\":\"insert\",\"insert\":17},\" \"],\"predicate\":16},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Internal dissent: \",{\"type\":\"insert\",\"insert\":18},\"\"]},{\"type\":\"heading\",\"content\":\"Government\"},{\"type\":\"paragraph\",\"content\":[\"President: \",{\"type\":\"insert\",\"insert\":19},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Chancellor: \",{\"type\":\"insert\",\"insert\":20},\" (\",{\"type\":\"insert\",\"insert\":21},\")\"]},{\"type\":\"paragraph\",\"content\":\"Reichstag composition:\"},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<span class=\\\"tooltip-text\\\" title=\\\"Social Democratic Party of Germany\\\">SPD</span>\"},\": \",{\"type\":\"insert\",\"insert\":22},\"% \",{\"type\":\"conditional\",\"content\":[\"SAPD: \",{\"type\":\"insert\",\"insert\":24},\"% \"],\"predicate\":23},\" \",{\"type\":\"magic\",\"content\":\"<span class=\\\"tooltip-text\\\" title=\\\"Center Party + Bavarian People's Party\\\">Z + BVP</span>\"},\": \",{\"type\":\"insert\",\"insert\":25},\"% \",{\"type\":\"magic\",\"content\":\"<span class=\\\"tooltip-text\\\" title=\\\"Communist Party of Germany\\\">KPD</span>\"},\": \",{\"type\":\"insert\",\"insert\":26},\"% \",{\"type\":\"magic\",\"content\":\"<span class=\\\"tooltip-text\\\" title=\\\"German Democratic Party\\\">DDP</span>\"},\": \",{\"type\":\"insert\",\"insert\":27},\"% \",{\"type\":\"magic\",\"content\":\"<span class=\\\"tooltip-text\\\" title=\\\"German People's Party\\\">DVP</span>\"},\": \",{\"type\":\"insert\",\"insert\":28},\"% \",{\"type\":\"magic\",\"content\":\"<span class=\\\"tooltip-text\\\" title=\\\"German National People's Party\\\">DNVP</span>\"},\": \",{\"type\":\"insert\",\"insert\":29},\"% \",{\"type\":\"magic\",\"content\":\"<span class=\\\"tooltip-text\\\" title=\\\"National-Socialist German Worker's Party (Nazis)\\\">NSDAP</span>\"},\": \",{\"type\":\"insert\",\"insert\":30},\"% Others: \",{\"type\":\"insert\",\"insert\":31},\"%\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"Budget: \",{\"type\":\"insert\",\"insert\":33},\" \"],\"predicate\":32},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Inflation: \",{\"type\":\"insert\",\"insert\":34},\"%\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"Unemployment: \",{\"type\":\"insert\",\"insert\":36},\"% \"],\"predicate\":35},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Next election: \",{\"type\":\"insert\",\"insert\":37},\" \",{\"type\":\"insert\",\"insert\":38}]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['month'] || 0);\"},\"qdisplay\":\"month\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['year'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['resources'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['spd_toleration'] || 0)) !== 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['spd_in_government'] || 0)) !== 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['spd_toleration'] || 0) == 0) && ((Q['spd_in_government'] || 0) == 0)) && ((Q['spd_caretaker'] || 0) == 0));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['spd_caretaker'] || 0)) !== 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['in_weimar_coalition'] || 0)) !== 0) && (((Q['spd_in_government'] || 0)) !== 0));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['in_grand_coalition'] || 0)) !== 0) && (((Q['spd_in_government'] || 0)) !== 0));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['in_popular_front'] || 0)) !== 0) && (((Q['spd_in_government'] || 0)) !== 0));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['in_left_front'] || 0)) !== 0) && (((Q['spd_in_government'] || 0)) !== 0));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['in_spd_majority'] || 0)) !== 0) && (((Q['spd_in_government'] || 0)) !== 0));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['in_minority_government'] || 0)) !== 0) && (((Q['spd_in_government'] || 0)) !== 0));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['in_emergency_government'] || 0)) !== 0) && (((Q['spd_in_government'] || 0)) !== 0));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((((Q['spd_in_government'] || 0)) !== 0) && (!(((Q['in_spd_majority'] || 0)) !== 0))) && (!(((Q['in_left_front'] || 0)) !== 0)));\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['coalition_dissent'] || 0);\"},\"qdisplay\":\"coalition_dissent\"},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['spd_in_government'] || 0)) !== 0) && (((((Q['in_left_front'] || 0)) !== 0) || (((Q['in_popular_front'] || 0)) !== 0))));\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['kpd_coalition_dissent'] || 0);\"},\"qdisplay\":\"coalition_dissent\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['dissent_percent'] || 0);\"},\"qdisplay\":\"dissent\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['president'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor_party'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['spd_r'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['sapd_formed'] || 0)) !== 0) && ((Q['sapd_r'] || 0) > 0));\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['sapd_r'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['z_r'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['kpd_r'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['ddp_r'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['dvp_r'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['dnvp_r'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['nsdap_r'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['other_r'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['spd_in_government'] || 0)===1);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['budget'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['inflation_2'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['black_thursday_seen'] || 0)===1);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['unemployed_2'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_month'] || 0);\"},\"qdisplay\":\"month\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_year'] || 0);\"}}]}},\"root.start\":{\"id\":\"root.start\",\"onArrival\":[{\"$code\":\"Q.started = 1;\\n// time elapsed (in months)\\nQ.time = 1;\\nQ.year = 1928;\\nQ.month = 1;\\n// how many actions have been taken this month?\\nQ.month_actions = 0;\\n\\n// 0 = normal difficulty, 1 = hard mode, 2 = hard mode no saves\\nQ.difficulty = 0;\\nQ.historical_mode = 0;\\n// old demographics\\nQ.old_demographics = 0;\\n\\n// party resources\\nQ.resources = 2;\\n// party dues\\nQ.dues = 2;\\n\\n// the state of the party\\n// overall dissent reduces every increase in party support.\\nQ.dissent = 0.05;\\nQ.dissent_percent = 5;\\n\\n// factions\\nQ.factions = ['left', 'center', 'labor', 'reformist', 'neorevisionist'];\\n// should this be normalized to 100%?\\nQ.left_strength = 15;\\nQ.left_dissent = 20;\\nQ.center_strength = 30;\\nQ.center_dissent = 0;\\nQ.labor_strength = 25;\\nQ.labor_dissent = 5;\\nQ.reformist_strength = 25;\\nQ.reformist_dissent = 5;\\nQ.neorevisionist_strength = 5;\\nQ.neorevisionist_dissent = 10;\\n\\n// secret events...\\nQ.unions_independent = 0;\\nQ.centrists_resign = 0;\\nQ.left_split = 0;\\nQ.reformists_resigned = 0;\\n\\n// have we discovered neorevisionism?\\nQ.neorevisionism = 0;\\n\\n// crisis_urgency indicates how seriously the SPD is taking the economic crisis - scale from 0 to 10.\\nQ.crisis_urgency = 0;\\n// nazi_urgency indicates how seriously the SPD takes the nazis - scale from 0 to 10.\\nQ.nazi_urgency = 0;\\n// radicalization indicates how radical the SPD's rhetoric is - scale from 0 to 10.\\nQ.radicalization = 0;\\n// Support for the WTB plan and proto-Keynesian works creation plans in general\\nQ.wtb_support = 0;\\n// Support for Pacifism within the SPD relative to 1928\\nQ.pacifism = 0;\\n// Support for democratic reform within the SPD relative to 1928\\nQ.democratization = 0;\\n// Support for a communist coalition relative to 1928\\nQ.communist_coalition = 0;\\n// economic_plan: have we adopted *any* economic plan?\\n// 1 - WTB plan, 2 - AfA-bund plan, 3 - radical plan (mass nationalization of industries)\\nQ.economic_plan = 0;\\n// have we officially adopted the WTB plan?\\nQ.wtb_adopted = 0;\\n// have we formed the iron front?\\nQ.iron_front_formed = 0;\\n// people's party support\\nQ.peoples_party_support = 0;\\n// support for nationalizations\\nQ.nationalization_support = 0;\\nQ.nationalization_adopted = 0;\\n// moderate economic plan\\nQ.moderate_plan_support = 0;\\nQ.moderate_plan_adopted = 0;\\n\\n// organizations\\n\\n// inter-party relations\\nQ.z_relation = 50;\\nQ.kpd_relation = 25;\\nQ.ddp_relation = 60;\\nQ.dvp_relation = 35;\\n// DNVP and NSDAP are invariably hostile\\nQ.DNVP_relation = 10;\\nQ.NSDAP_relation = 0;\\n\\nQ.kpd_leader = \\\"Thälmann\\\";\\n// alternative is the Conciliators as party leader\\nQ.kpd_party_leader = \\\"Thälmann\\\";\\nQ.z_leader = \\\"Brüning\\\";\\n// party leader - can be Ludwig Kaas, Joseph Joos, or Adam Stegerwald after the 1928 December conference. Joos will be most friendly to the SPD.\\nQ.z_party_leader = \\\"Marx\\\";\\nQ.nsdap_leader = \\\"Hitler\\\";\\n\\n// hmm... maybe we can play nice with Hindenburg???\\nQ.hindenburg_relation = 25;\\n\\n\\n// Does the SPD lead in Prussia?\\nQ.spd_prussia = 1;\\n// Options: spd, z, dnvp, papen, nsdap\\nQ.prussian_government = \\\"SPD\\\";\\n\\n// The array of forces - paramilitary groups\\n// Number of members in 1928 (in thousands)\\n// Reichsbanner, stahlhelm, SA, rotfrontkämpferbund\\nQ.rb_strength = 2000;\\nQ.rb_militancy = 0.01;\\nQ.women_in_rb = 0;\\nQ.rb_banned = 0;\\nQ.sh_strength = 500;\\nQ.sh_militancy = 0.5;\\nQ.sh_banned = 0;\\nQ.sh_banned_prussia = 0;\\nQ.sa_strength = 80;\\nQ.sa_militancy = 0.5;\\nQ.sa_banned = 0;\\nQ.sa_banned_prussia = 0;\\nQ.rfb_strength = 130;\\nQ.rfb_militancy = 0.5;\\nQ.rfb_banned = 0;\\nQ.rfb_banned_prussia = 0;\\n\\nQ.interior_police_strength = 50;\\nQ.interior_police_militancy = 1;\\nQ.interior_police_loyalty = 0.45;\\n\\nQ.prussian_police_strength = 90;\\nQ.prussian_police_militancy = 1;\\nQ.prussian_police_loyalty = 0.5;\\n\\n// strength includes actual military and de facto reserves?\\nQ.reichswehr_strength = 100;\\nQ.reichswehr_militancy = 5;\\nQ.reichswehr_loyalty = 0.2;\\n\\n// The state of the country\\n\\n// popular opinion\\n// national ideology - on a binary scale\\n// nationalism vs internationalism or pacifism or non-nationalism\\nQ.nationalism = 60;\\n// socialism vs capitalism\\nQ.socialism = 40;\\n// pro-republic vs anti-republic\\nQ.pro_republic = 59;\\n\\nQ.emergency_rule = 0;\\n\\n// minimum percentage of votes to be represented in the Reichstag\\nQ.electoral_threshold = 0;\\n// constitutional reform level\\nQ.constitutional_reform = 0;\\n// constructive vote of no confidence\\nQ.constructive_vonc = 0;\\n// reduction in presidential powers\\nQ.presidential_powers = 0;\\n// allows banning of non-constitutional parties\\nQ.constitutional_protection = 0;\\nQ.kpd_banned = 0;\\nQ.nsdap_banned = 0;\\n\\n// coups and capital strikes happen when you upset the right or the capitalists too much with your policies. they're an additional check on your policies, when purely electoral checks don't suffice.\\n// when coup_progress reaches 10 or capital_strike_progress reaches 10, there's a special event that launches the coup.\\nQ.coup_progress = 0;\\nQ.capital_strike_progress = 0;\\n\\nQ.budget = 5;\\n\\n// Proportion of different social groups\\n// source: https://surface.syr.edu/cgi/viewcontent.cgi?filename=3&article=1016&context=books&type=additional page 45, table 3.4 - using 1925 figures\\nQ.workers = 48; // industry and trade\\nQ.old_middle = 13; // \\\"old mittelstand\\\"\\n// 16.4 trade & commerce, 6.6 public and private services, 4.4 domestic help\\nQ.new_middle = 14; // \\\"new mittelstand\\\"\\nQ.rural = 25; // agriculture and forestry employment... but many of those are proletarians so...\\n// source: https://surface.syr.edu/cgi/viewcontent.cgi?filename=3&article=1016&context=books&type=additional page 43, table 3.3\\nQ.unemployed = 8.6;\\nQ.catholics = 30;\\n\\n// unemployment: 1929 - 13.3, 1930 - 22.7, 1931 - 34.3, 1932 - 43.8 (same source as above)\\n\\n// income for industrial workers in reichsmarks/year - 1928 = 1600 Reichsmarks/year; 1931 = 1440 Reichsmarks/year; 1933 = 1138 Reichsmarks/year - source: https://babel.hathitrust.org/cgi/pt?id=uiug.30112104147985&seq=50\\nQ.income = 1600;\\n// what about incomes for different classes? rural workers? middle-class workers?\\n\\n// inflation (in %; 1928: 2.9; 1929: 0; 1930: -5%; 1931: -10%; 1932: -10%) - source: https://en.wikipedia.org/wiki/File:BSPDRWeltkriseEngl.PNG, derived from https://www.destatis.de/DE/Methoden/WISTA-Wirtschaft-und-Statistik/2009/03/rezession-betrachtung-032009.pdf?__blob=publicationFile\\nQ.inflation = 2.9;\\n\\n// quality of life (as % of 1928 - currently unused - should be welfare-adjusted.)\\nQ.workers_qol = 100;\\nQ.rural_qol = 100;\\nQ.unemployed_qol = 100;\\nQ.old_middle_qol = 100;\\nQ.new_middle_qol = 100;\\n\\nQ.classes = ['workers', 'old_middle', 'new_middle', 'rural', 'unemployed', 'catholics'];\\nQ.parties = ['spd', 'kpd', 'z', 'ddp', 'dvp', 'dnvp', 'nsdap', 'other'];\\n\\n// TODO: add 'sapd' later on\\nQ.sapd_formed = 0;\\n\\n// Support for party by social group\\n// they don't have to sum to 100 since the electoral calculations will be normalized.\\nQ.workers_spd = 60;\\nQ.workers_kpd = 20;\\nQ.workers_z = 5;\\nQ.workers_ddp = 0;\\nQ.workers_dvp = 0;\\nQ.workers_dnvp = 5;\\nQ.workers_nsdap = 0;\\nQ.workers_other = 10;\\n\\nQ.old_middle_spd = 5;\\nQ.old_middle_kpd = 0;\\nQ.old_middle_z = 5;\\nQ.old_middle_ddp= 10;\\nQ.old_middle_dvp = 25;\\nQ.old_middle_dnvp = 25;\\nQ.old_middle_nsdap = 10;\\nQ.old_middle_other = 10;\\n\\nQ.new_middle_spd = 5;\\nQ.new_middle_kpd = 1;\\nQ.new_middle_z = 10;\\nQ.new_middle_ddp= 25;\\nQ.new_middle_dvp = 25;\\nQ.new_middle_dnvp = 10;\\nQ.new_middle_nsdap = 5;\\nQ.new_middle_other = 15;\\n\\nQ.rural_spd = 10;\\nQ.rural_kpd = 0;\\nQ.rural_z = 5;\\nQ.rural_ddp= 5;\\nQ.rural_dvp = 15;\\nQ.rural_dnvp = 45;\\nQ.rural_nsdap = 5;\\nQ.rural_other = 10;\\n\\nQ.unemployed_spd = 25;\\nQ.unemployed_kpd = 55;\\nQ.unemployed_z = 1;\\nQ.unemployed_ddp = 0;\\nQ.unemployed_dvp = 0;\\nQ.unemployed_dnvp = 5;\\nQ.unemployed_nsdap = 15;\\nQ.unemployed_other = 9;\\n\\nQ.catholics_spd = 15;\\nQ.catholics_kpd = 2;\\nQ.catholics_z = 50;\\nQ.catholics_ddp = 0;\\nQ.catholics_dvp = 5;\\nQ.catholics_dnvp = 5;\\nQ.catholics_nsdap = 0;\\nQ.catholics_other = 12;\\n\\n\\n// Current Reichstag composition\\n// % of Reichstag in Jan 1928\\n// source: wikipedia\\n// note: the Z figures also include the BVP (Bavarian people's party)\\n// since they were ideologically similar, but they were separate parties.\\n// They did not have a CDU/CSU-style relationship.\\nQ.spd_r = 26;\\nQ.kpd_r = 9;\\nQ.z_r = 17;\\nQ.ddp_r = 6;\\nQ.dvp_r = 10;\\nQ.dnvp_r = 20;\\nQ.nsdap_r = 3;\\nQ.other_r = 9;\\n\\n// diff from prev\\nQ.old_spd_r = 26;\\nQ.old_kpd_r = 9;\\nQ.old_z_r = 17;\\nQ.old_ddp_r = 6;\\nQ.old_dvp_r = 10;\\nQ.old_dnvp_r = 20;\\nQ.old_nsdap_r = 3;\\nQ.old_other_r = 9;\\n\\n// sapd isn't formed yet, but it may be formed\\nQ.sapd_r = 0;\\nQ.old_sapd_r = 0;\\n\\n// for changing the DDP's name to the DStP\\nQ.ddp_name = \\\"DDP\\\";\\n\\n// array of objects of the form {date: Date(), spd: 10, kpd: 12, ...} for each election\\nQ.election_records = [];\\n// party support records for every month\\nQ.party_support_records = [];\\n// inflation and unemployment records\\nQ.economic_records = [];\\n\\n\\n// State of the government\\nQ.president = \\\"Hindenburg\\\";\\n// starting chancellor: Wilhelm Marx\\nQ.chancellor = \\\"Marx\\\";\\nQ.chancellor_party = 'Z';\\nQ.spd_in_government = 0;\\nQ.z_in_government = 1;\\nQ.ddp_in_government = 0;\\nQ.dvp_in_government = 1;\\nQ.dnvp_in_government = 1;\\nQ.kpd_in_government = 0;\\nQ.nsdap_in_government = 0;\\n\\nQ.in_right_coalition = 0;\\n// Weimar coalition = SPD + Z + DDP\\nQ.in_weimar_coalition = 0;\\n// Grand coalition = SPD + Z + BVP + DDP + DVP\\n// also includes the \\\"new grand coalition\\\" of SPD + Z + BVP + DDP + DVP + Others\\nQ.in_grand_coalition = 0;\\n// Popular front = SPD + KPD + Z + DDP\\nQ.in_popular_front = 0;\\n// left coalition = SPD + KPD + left-splinters\\nQ.in_left_front = 0;\\n// emergency government containing the SPD: only president Braun can do this.\\nQ.in_emergency_government = 0;\\nQ.in_spd_majority = 0;\\nQ.grand_coalition_failed = 0;\\n// if the SPD is ruling as part of a minority government\\nQ.in_minority_government = 0;\\n// national unity governmet\\n\\n// if you're in a coalition, this is an incremental counter for how many times dissent has happened from the right.\\nQ.coalition_dissent = 0;\\n// dissent from the KPD, in a popular front or left front government\\nQ.kpd_coalition_dissent = 0;\\n\\n// does the SPD tolerate the government even if it is not a participant?\\nQ.spd_toleration = 0;\\n\\n// is the current government a presidential minority government?\\nQ.minority_government = 0;\\n\\n// ministries - which parties control the ministries?\\n// starting with the 4th Marx cabinet https://en.wikipedia.org/wiki/Fourth_Marx_cabinet\\n// is the agricultural ministry useful at all?\\nQ.foreign_minister = 'Streseman';\\nQ.foreign_minister_party = 'DVP';\\nQ.interior_minister = 'von Keudell';\\nQ.interior_minister_party = 'DNVP';\\nQ.justice_minister = 'Hergt';\\nQ.justice_minister_party = 'DNVP';\\nQ.labor_minister = 'Brauns';\\nQ.labor_minister_party = 'Z';\\nQ.reichswehr_minister = 'Groener';\\nQ.reichswehr_minister_party = 'I';\\nQ.economic_minister = 'Curtius';\\nQ.economic_minister_party = 'DVP';\\nQ.finance_minister = 'Köhler';\\nQ.finance_minister_party = 'Z';\\nQ.agriculture_minister = 'Schiele';\\nQ.agriculture_minister_party = 'DNVP';\\n\\n// Events: what has occurred?\\nQ.panzerkreuzer_seen = 0;\\nQ.panzerkreuzer_funded = 0;\\nQ.panzerkreuzer_failed = 0;\\nQ.unemployment_insurance_seen = 0;\\n// unemployment insurance event is seen if the unemployment level is at least 4 more than the threshold...\\nQ.unemployment_insurance_threshold = 10;\\nQ.blutmai = 0;\\n\\n// have we reformed these institutions to be more democratic?\\nQ.judicial_reform = 0;\\nQ.bureaucratic_reform = 0;\\nQ.military_reform = 0;\\nQ.womens_rights = 0;\\n// level of welfare relative to 1928 (can go negative)\\nQ.welfare = 0;\\n// level of support for farmers\\nQ.agricultural_policy = 0;\\nQ.land_reform = 0;\\n// works-creation programs (i.e. WTB-plan) - how much have they implemented?\\nQ.works_program = 0;\\nQ.wtb_implemented = 0;\\n// Relations with the Western countries (France, UK).\\nQ.west_relation = 0;\\n// Relations with the Eastern countries (Poland, Czechoslovakia)\\nQ.east_relation = 0;\\n// Relations with the Soviet Union\\nQ.soviet_relation = 0;\\n// How much have we exposed the secret rearmament programs?\\nQ.rearmament_exposed = 0;\\n// reparations vs baseline: young plan is -1.\\nQ.reparations = 0;\\nQ.reparations_negotiation = 0;\\n// nationalization_progress is part of the left economic plan.\\nQ.nationalization_progress = 0;\\n// socializations is part of the economic democracy card.\\nQ.socializations = 0;\\nQ.nationalize_budget = 4;\\n// have there been any factory takeovers?\\nQ.factory_takeovers = 0;\\n// progress on the moderate economic plan\\nQ.moderate_plan_progress = 0;\\n// European Union negotiation process\\nQ.eu = 0;\\nQ.eu_progress = 0;\\n\\n// Tax rates relative to 1928 baseline\\nQ.lower_tax_rates = 0;\\nQ.upper_tax_rates = 0;\\nQ.tariffs = 0;\\n\\nQ.electoral_threshold = 0;\\n\\n// our conduct in the government, and the conduct of our coalition opponents.\\n// did the SPD vote against the previous government in a vote of no confidence?\\nQ.spd_no_confidence = 0;\\n// was the last SPD government taken down in a vote of no confidence by right-wing coalition partners?\\nQ.no_confidence_against_spd = 0;\\n\\n// Advisors/Leaders\\nQ.n_advisors = 3;\\n// timer - this decrements by 1 every turn, and is set to 5 whenever an advisor action is used, so that you can only use one advisor action every 5 months.\\n// let's just put all of the timers here...\\n// most party affairs and government affairs cards are on a timer.\\nQ.timers = ['advisor_action', 'confronting_nazis', 'crisis_program',\\n            'fundraising', 'ideology',\\n            'inter_party_relationships', 'international_relations',\\n            'iron_front', 'media', 'enemies',\\n            'party_organizations', 'rally', 'reichsbanner',\\n            'shuffle_leadership', 'streetfighting', 'peoples_party',\\n            'party_disunity',\\n            // govt\\n            'agricultural_policy', 'domestic_enemies', 'fiscal_policy',\\n            'foreign_policy', 'judiciary', 'labor_affairs', 'military_policy',\\n            'police', 'prussian_affairs', 'shuffle_cabinet', 'social_welfare',\\n            'homosexual_rights', 'economic_policy', 'coalition_affairs',\\n            'war_guilt', 'womens_rights', 'economic_democracy',\\n            'dealing_with_toleration',\\n            'constitutional_reform', 'labor_rights',\\n            // events\\n            'emergency_cuts', 'unemployment_insurance',\\n            'sa_ban', 'sh_ban', 'papen_chancellor',\\n            'kpd_policy', 'kpd_ultimatum', 'popular_front_dispute',\\n            'high_inflation', 'banking_crisis'];\\nQ.advisor_action_timer = 0;\\n// party affairs timers\\nQ.confronting_nazis_timer = 0;\\nQ.crisis_program_timer = 0;\\nQ.fundraising_timer = 0;\\nQ.ideology_timer = 0;\\nQ.inter_party_relationships_timer = 0;\\nQ.international_relations_timer = 0;\\nQ.iron_front_timer = 0;\\nQ.media_timer = 0;\\nQ.enemies_timer = 0;\\nQ.party_organizations_timer =  0;\\nQ.rally_timer = 0;\\nQ.reichsbanner_timer = 0;\\nQ.shuffle_leadership_timer = 0;\\nQ.streetfighting_timer = 0;\\nQ.peoples_party_timer = 0;\\n// n_elections is the number of elections that have happened since the start of the game.\\nQ.n_elections = 0;\\n// number of elections without a clear majority.\\nQ.no_majority_elections = 0;\\n// elections are not on a timer, but rather there is an indicator for whether you're in an electoral cycle.\\nQ.in_election = 1;\\nQ.next_election_year = 1928;\\nQ.next_election_month = 5;\\nQ.next_election_time = 5;\\n// government affairs timers\\nQ.agricultural_policy_timer = 0;\\nQ.domestic_enemies_timer = 0;\\nQ.economic_policy_timer = 0;\\nQ.fiscal_policy_timer = 0;\\nQ.foreign_policy_timer = 0;\\nQ.judiciary_timer = 0;\\nQ.labor_affairs_timer = 0;\\nQ.military_policy_timer = 0;\\nQ.police_timer = 0;\\nQ.prussian_affairs_timer = 0;\\nQ.shuffle_cabinet_timer = 0;\\nQ.social_welfare_timer = 0;\\nQ.war_guilt_timer = 0;\\nQ.womens_rights_timer = 0;\\nQ.homosexual_rights_timer = 0;\\nQ.economic_democracy_timer = 0;\\nQ.coalition_affairs_timer = 0;\\n// event timers\\nQ.emergency_cuts_timer = 0;\\nQ.unemployment_insurance_timer = 0;\\nQ.sa_ban_timer = 0;\\nQ.sh_ban_timer = 0;\\nQ.kpd_ultimatum_timer = 0;\\n\\n\\n// all the initial advisors are centrists.\\nQ.wels_advisor = 1; // Otto Wels\\nQ.muller_advisor = 1; // Hermann Müller\\nQ.muller_dead = 0;\\n// okay I know Arthur Crispien was a leader irl but i couldn't find much interesting about him...\\nQ.crispien_advisor = 0; // Arthur Crispien\\nQ.hilferding_advisor = 1; // Rudolf Hilferding\\n\\n// left advisors\\nQ.sender_advisor = 0; // Toni Sender\\nQ.levi_advisor = 0; // Paul Levi\\nQ.levi_dead = 0;\\nQ.rosenfeld_advisor = 0; // Kurt Rosenfeld\\nQ.seydewitz_advisor = 0; // Max Seydewitz\\n\\n// centrist alternate advisors\\nQ.pfulf_advisor = 0; // Antonie Pfülf\\nQ.breitscheid_advisor = 0; // Rudolf Breitscheid\\n\\n// Reformist advisors\\nQ.severing_advisor = 0; // Carl Severing\\nQ.braun_advisor = 0; // Otto Braun\\nQ.juchacz_advisor = 0; // Marie Juchacz\\nQ.baade_advisor = 0; // Fritz Baade\\n\\n// Labor advisors\\nQ.leipart_advisor = 0; // Theodor Leipart\\nQ.aufhauser_advisor = 0; // Siegfried Aufhäuser\\nQ.woytinsky_advisor = 0; // Wladimir Woytinsky (post-1930)\\nQ.wissell_advisor = 0; // Rudolf Wissell\\n\\n// Revisionist advisors\\nQ.mierendorff_advisor = 0; // Carlo Mierendorf (post-1930)\\n\\nQ.leber_advisor = 0; // Julius Leber (post-1930)\\nQ.schumacher_advisor = 0; // Kurt Schumacher (post-1930)\\n\\n// Nonfactional advisors\\nQ.hirschfeld_advisor = 0; // Magnus Hirschfeld\\nQ.radbruch_advisor = 0; // Gustav Radbruch\\nQ.stampfer_advisor = 0; // Friedrich Stampfer\"}],\"setBg\":\"img/map_2.jpg\",\"newPage\":true,\"options\":[{\"id\":\"@root.1928_easy\",\"title\":\"Begin (easy difficulty)\"},{\"id\":\"@root.1928_main\",\"title\":\"Begin (normal difficulty)\"},{\"id\":\"@root.1928_hard\",\"title\":\"Begin (hard difficulty)\"},{\"id\":\"@root.1928_historical\",\"title\":\"Begin (historical mode)\"}],\"content\":[{\"type\":\"quotation\",\"content\":[\"\",{\"type\":\"emphasis-1\",\"content\":\"\\\"Such a general development cannot be attributed to the false tactics of any single party or to the mistakes of individual leaders. On the contrary, the conduct of individual leaders is determined largely by the sentiments of the people as a whole. It would be erroneous, however, to regard the sentiments of the moment as reflecting the natural make-up and character of the people. They are merely the consequence of the special circumstances which have brought about this profound degradation of the entire nation.\\\"\"},\"\"]},{\"type\":\"paragraph\",\"content\":[\"- Karl Kautsky, \",{\"type\":\"emphasis-1\",\"content\":\"Hitlerism and Social Democracy\"},\", 1934\"]},{\"type\":\"paragraph\",\"content\":[\"This is a game of alternate history. While historical accuracy is a major concern, keep in mind that this is a \",{\"type\":\"emphasis-1\",\"content\":\"game\"},\", and that any divergence from actual events will necessarily have to involve some element of make-believe. Nevertheless, please let the author know if there are any glaring mistakes.\"]},{\"type\":\"paragraph\",\"content\":\"For more information on the politics and government of the German Republic, see the \\\"Library\\\" page on the top left. If this is your first time playing the game, it is strongly recommended that you read at least some of this information.\"}]},\"aufhauser.crisis\":{\"id\":\"aufhauser.crisis\",\"title\":\"Addressing the economic crisis\",\"subtitle\":\"Aufhäuser can help support a left-wing economic program.\",\"chooseIf\":{\"$code\":\"return (((((Q['advisor_action_timer'] || 0) <= 0) && ((Q['nationalization_adopted'] || 0) == 0)) && ((Q['black_thursday_seen'] || 0) == 1)) && ((Q['nationalization_support'] || 0) <= 3));\"},\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action. \"],\"predicate\":0},{\"type\":\"conditional\",\"content\":\"We are not currently in an economic crisis. \",\"predicate\":2},{\"type\":\"conditional\",\"content\":\"We have already adopted the Left plan.\",\"predicate\":3}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['black_thursday_seen'] || 0) == 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['nationalization_adopted'] || 0) > 0);\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\"}],\"goTo\":[{\"id\":\"crisis_program.support_left\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"braun.snap_election\":{\"id\":\"braun.snap_election\",\"title\":\"Snap Election\",\"subtitle\":\"Call a snap election.\",\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":\"Braun must be Chancellor or President. \",\"predicate\":0},{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":2},\" months before next advisor action. \"],\"predicate\":1},\" \",{\"type\":\"conditional\",\"content\":\"We have removed this power from the president with a constitutional reform.\",\"predicate\":3}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['chancellor'] != \\\"Braun\\\") && (Q['president'] != \\\"Braun\\\"));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['president'] == \\\"Braun\\\") && (((Q['presidential_powers'] || 0)) !== 0));\"}}]},\"chooseIf\":{\"$code\":\"return (((Q['advisor_action_timer'] || 0) == 0) && (((Q['chancellor'] == \\\"Braun\\\") || (((Q['president'] == \\\"Braun\\\") && (!(((Q['presidential_powers'] || 0)) !== 0)))))));\"},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\n if (((Q['next_election_time'] || 0) > ((Q['time'] || 0) + 3)) ) { Q['next_election_time'] = ((Q['time'] || 0) + 3); } \\n if (((Q['next_election_time'] || 0) >= ((Q['time'] || 0) + 3)) ) { Q['next_election_month'] = ((Q['month'] || 0) + 3); } \\n if (((Q['next_election_time'] || 0) >= ((Q['time'] || 0) + 3)) ) { Q['next_election_year'] = (Q['year'] || 0); } \\n if (((Q['next_election_month'] || 0) > 12) ) { Q['next_election_year'] = (Q['next_election_year'] || 0) + 1; } \\n if (((Q['next_election_month'] || 0) > 12) ) { Q['next_election_month'] = (Q['next_election_month'] || 0) - 12; }\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"We have called for new elections, set for \",{\"type\":\"insert\",\"insert\":0},\" \",{\"type\":\"insert\",\"insert\":1},\".\"]},\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_month'] || 0);\"},\"qdisplay\":\"month\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_year'] || 0);\"}}]}},\"braun\":{\"id\":\"braun\",\"type\":\"scene\",\"title\":\"Otto Braun\",\"isPinnedCard\":true,\"tags\":[\"advisor\",\"reformist\"],\"cardImage\":\"img/portraits/BraunOtto.jpg\",\"viewIf\":{\"$code\":\"return ((Q['braun_advisor'] || 0)===1);\"},\"newPage\":true,\"options\":[{\"id\":\"@braun.coalition\"},{\"id\":\"@braun.prussian_bulwark\"},{\"id\":\"@braun.snap_election\"},{\"id\":\"@root\",\"title\":\"Return to main\"}],\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"Otto Braun\"},{\"type\":\"paragraph\",\"content\":[\"Braun \",{\"type\":\"conditional\",\"content\":\"is \",\"predicate\":0},{\"type\":\"conditional\",\"content\":\"was \",\"predicate\":1},\" the Minister-President of Prussia, the largest state in Germany. He is a reformist leader who seeks to work with the bourgeois parties.\"]}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['spd_prussia'] || 0)===1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['spd_prussia'] || 0)===0);\"}}]}},\"baade.depression\":{\"id\":\"baade.depression\",\"title\":\"Addressing the economic crisis\",\"subtitle\":\"Formulate a plan to rescue us from the economic crisis.\",\"chooseIf\":{\"$code\":\"return ((((Q['advisor_action_timer'] || 0) <= 0) && ((Q['wtb_adopted'] || 0)===0)) && (((Q['black_thursday_seen'] || 0)) !== 0));\"},\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action. \"],\"predicate\":0},{\"type\":\"conditional\",\"content\":\"We are not currently in an economic crisis. \",\"predicate\":2},{\"type\":\"conditional\",\"content\":\"We have already adopted the WTB-Plan.\",\"predicate\":3}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['black_thursday_seen'] || 0) == 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['wtb_adopted'] || 0) > 0);\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['wtb_support'] = (Q['wtb_support'] || 0) + 2;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) + 10;\\nQ['labor_strength'] = (Q['labor_strength'] || 0) + 1;\"}],\"content\":{\"content\":\"The WTB-Plan, standing for its primary supporters Woytinsky, Tarnow, and Baade, has been adopted as the unions' plan for getting us out of the depression. Baade canvasses in favor of this plan throughout the party.\",\"type\":\"paragraph\"}},\"baade\":{\"id\":\"baade\",\"type\":\"scene\",\"title\":\"Fritz Baade\",\"isPinnedCard\":true,\"tags\":[\"advisor\",\"reformist\"],\"cardImage\":\"img/portraits/BaadeFritz.jpg\",\"viewIf\":{\"$code\":\"return ((Q['baade_advisor'] || 0)===1);\"},\"newPage\":true,\"options\":[{\"id\":\"@baade.agriculture\"},{\"id\":\"@baade.rural_campaign\"},{\"id\":\"@baade.depression\"},{\"id\":\"@root\",\"title\":\"Return to main\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Fritz Baade\"},{\"type\":\"paragraph\",\"content\":\"Baade is one of the few agricultural experts in the SPD, and an unorthodox economist.\"}]},\"breitscheid.party_discipline\":{\"id\":\"breitscheid.party_discipline\",\"title\":\"Party Discipline\",\"subtitle\":\"Reduce dissent across the party.\",\"chooseIf\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0)===0);\"},\"unavailableSubtitle\":{\"content\":{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action.\"],\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) - 5;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) - 10;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) - 10;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) - 10;\\nQ['neorevisionist_dissent'] = (Q['neorevisionist_dissent'] || 0) - 5;\"}],\"content\":{\"content\":\"We have enforced party discipline to reduce dissent across all factions.\",\"type\":\"paragraph\"}},\"hilferding.finance_ministry_\":{\"id\":\"hilferding.finance_ministry_\",\"title\":\"Fiscal Policy\",\"subtitle\":\"As Finance Minister, Hilferding can enact tax policies.\",\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action. \"],\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"SPD not in government: \",\"predicate\":2},\" \",{\"type\":\"conditional\",\"content\":\"The SPD does not control the finance ministry.\",\"predicate\":3}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['spd_in_government'] || 0)===0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['finance_minister_party'] != \\\"SPD\\\");\"}}]},\"chooseIf\":{\"$code\":\"return ((((Q['advisor_action_timer'] || 0) == 0) && ((Q['spd_in_government'] || 0) == 1)) && (Q['finance_minister_party'] == \\\"SPD\\\"));\"},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['fiscal_policy_timer'] = (Q['fiscal_policy_timer'] || 0) - 6;\\nQ['last_advisor_action'] = 1;\"}],\"goTo\":[{\"id\":\"fiscal_policy\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"juchacz.organizing_women\":{\"id\":\"juchacz.organizing_women\",\"title\":\"Organizing women\",\"subtitle\":\"Juchacz's strategies are aimed at more \\\"traditional\\\" women.\",\"chooseIf\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0)===0);\"},\"unavailableSubtitle\":{\"content\":{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action.\"],\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}}]},\"onArrival\":[{\"$code\":\"Q['womens_rights'] = (Q['womens_rights'] || 0) + 1;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\nQ['rural_spd'] = (Q['rural_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\nQ['advisor_action_timer'] = 6;\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"Juchacz's strategies for organizing women are aimed at working-class housewives, and acknowledge women's traditional household roles. We argue that our economic welfare programs will improve the livelihoods of women and their families.\"},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":\"Unfortunately, women still disproportionately support the bourgeois parties.\",\"predicate\":0}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['spd_r'] || 0) < 50);\"}}]}},\"juchacz\":{\"id\":\"juchacz\",\"type\":\"scene\",\"title\":\"Marie Juchacz\",\"isPinnedCard\":true,\"tags\":[\"advisor\",\"reformist\"],\"cardImage\":\"img/portraits/JuchaczMarie.jpg\",\"viewIf\":{\"$code\":\"return ((Q['juchacz_advisor'] || 0)===1);\"},\"newPage\":true,\"options\":[{\"id\":\"@juchacz.emergency_fundraising\"},{\"id\":\"@juchacz.welfare\"},{\"id\":\"@juchacz.organizing_women\"},{\"id\":\"@root\",\"title\":\"Return to main\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Marie Juchacz\"},{\"type\":\"paragraph\",\"content\":\"Juchacz is the founder of the Worker's Welfare, our mutual aid organization; her experiences as a single mother in poverty led her to socialism. She is the most senior woman among the SPD leadership, who is often treated as the \\\"go-to\\\" when the predominantly male leadership sought out womens' voices.\"}]},\"leber.support_peoples_party\":{\"id\":\"leber.support_peoples_party\",\"title\":\"Build support for a People's Party\",\"subtitle\":\"Can we expand our party beyond the industrial working class?\",\"viewIf\":{\"$code\":\"return ((Q['peoples_party'] || 0)===0);\"},\"chooseIf\":{\"$code\":\"return ((((Q['peoples_party_support'] || 0) <= 4) && ((Q['advisor_action_timer'] || 0)===0)) && ((Q['peoples_party'] || 0) == 0));\"},\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action. \"],\"predicate\":0},{\"type\":\"conditional\",\"content\":\"There is already substantial support for a People's Party.\",\"predicate\":2}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['peoples_party_support'] || 0) > 4);\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['peoples_party_support'] = (Q['peoples_party_support'] || 0) + 1;\"}],\"content\":{\"content\":\"We are building up support for the idea of a People's Party.\",\"type\":\"paragraph\"}},\"leipart.union_unity\":{\"id\":\"leipart.union_unity\",\"title\":\"Union-party coordination\",\"subtitle\":\"Reduce dissent among the unions.\",\"chooseIf\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) <= 0);\"},\"unavailableSubtitle\":{\"content\":{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action.\"],\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) - 5;\\nQ['labor_strength'] = (Q['labor_strength'] || 0) + 5;\"}],\"content\":{\"content\":\"We have reduced tensions with the Labor faction, and increased its strength in the party.\",\"type\":\"paragraph\"}},\"leipart\":{\"id\":\"leipart\",\"type\":\"scene\",\"title\":\"Theodor Leipart\",\"isPinnedCard\":true,\"tags\":[\"advisor\",\"labor\"],\"cardImage\":\"img/portraits/LeipartTheodor.jpg\",\"viewIf\":{\"$code\":\"return ((Q['leipart_advisor'] || 0)===1);\"},\"newPage\":true,\"options\":[{\"id\":\"@leipart.organizing\"},{\"id\":\"@leipart.depression\"},{\"id\":\"@root\",\"title\":\"Return to main\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Theodor Leipart\"},{\"type\":\"paragraph\",\"content\":\"Leipart is a leader of the ADGB, the largest federation of socialist trade unions.\"}]},\"mierendorff.nazi_urgency\":{\"id\":\"mierendorff.nazi_urgency\",\"title\":\"Warning about the Nazis\",\"subtitle\":\"By warning the party about the Nazis, we can spur our members to action.\",\"chooseIf\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) == 0);\"},\"unavailableSubtitle\":{\"content\":{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action.\"],\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['nazi_urgency'] = (Q['nazi_urgency'] || 0) + 1;\\nQ['rb_militancy'] = (Q['rb_militancy'] || 0) + 0.01;\\nQ['nsdap_workers'] = (Q['nsdap_workers'] || 0) - (4 * (1 - (Q['dissent'] || 0)));\"}],\"content\":{\"content\":\"We have begun a propaganda campaign to warn our members away from the Nazis.\",\"type\":\"paragraph\"}},\"mierendorff\":{\"id\":\"mierendorff\",\"type\":\"scene\",\"title\":\"Carlo Mierendorff\",\"isPinnedCard\":true,\"tags\":[\"advisor\"],\"cardImage\":\"img/portraits/MierendorffCarlo.jpg\",\"viewIf\":{\"$code\":\"return ((Q['mierendorff_advisor'] || 0)===1);\"},\"newPage\":true,\"options\":[{\"id\":\"@mierendorff.iron_front_buildup\"},{\"id\":\"@mierendorff.form_iron_front\"},{\"id\":\"@mierendorff.nazi_urgency\"},{\"id\":\"@root\",\"title\":\"Return to main\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Carlo Mierendorff\"},{\"type\":\"paragraph\",\"content\":\"Carlo Mierendorff is the founder of the neo-revisionist ideological tendency, and supports both democratic reforms and extra-parliamentary action to combat the Nazis and authoritarian parties. He is from a middle-class, academic background, and is one of our youngest leaders.\"}]},\"muller.snap_election\":{\"id\":\"muller.snap_election\",\"title\":\"Snap Election\",\"subtitle\":\"Call a snap election.\",\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":\"Müller must be Chancellor. \",\"predicate\":0},{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":2},\" months before next advisor action.\"],\"predicate\":1}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['chancellor'] != \\\"Müller\\\");\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}}]},\"chooseIf\":{\"$code\":\"return (((Q['advisor_action_timer'] || 0) == 0) && (Q['chancellor'] == \\\"Müller\\\"));\"},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\n if (((Q['next_election_time'] || 0) > ((Q['time'] || 0) + 3)) ) { Q['next_election_time'] = ((Q['time'] || 0) + 3); } \\n if (((Q['next_election_time'] || 0) >= ((Q['time'] || 0) + 3)) ) { Q['next_election_month'] = ((Q['month'] || 0) + 3); } \\n if (((Q['next_election_time'] || 0) >= ((Q['time'] || 0) + 3)) ) { Q['next_election_year'] = (Q['year'] || 0); } \\n if (((Q['next_election_month'] || 0) > 12) ) { Q['next_election_year'] = (Q['next_election_year'] || 0) + 1; } \\n if (((Q['next_election_month'] || 0) > 12) ) { Q['next_election_month'] = (Q['next_election_month'] || 0) - 12; }\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"We have called for new elections, set for \",{\"type\":\"insert\",\"insert\":0},\" \",{\"type\":\"insert\",\"insert\":1},\".\"]},\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_month'] || 0);\"},\"qdisplay\":\"month\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_year'] || 0);\"}}]}},\"muller\":{\"id\":\"muller\",\"type\":\"scene\",\"title\":\"Hermann Müller\",\"isPinnedCard\":true,\"tags\":[\"advisor\",\"centrist\"],\"cardImage\":\"img/portraits/MüllerHermann.jpg\",\"newPage\":true,\"viewIf\":{\"$code\":\"return ((Q['muller_advisor'] || 0)===1);\"},\"options\":[{\"id\":\"@muller.coalition\"},{\"id\":\"@muller.toleration\"},{\"id\":\"@muller.snap_election\"},{\"id\":\"@root\",\"title\":\"Return to main\"}],\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"Herman Müller\"},{\"type\":\"paragraph\",\"content\":[\"Müller is a former \",{\"type\":\"conditional\",\"content\":\"and current \",\"predicate\":0},\" Chancellor, and is a long-time Social Democratic leader.\"]}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['chancellor'] == \\\"Müller\\\");\"}}]}},\"pfulf.campaigning_peoples_party\":{\"id\":\"pfulf.campaigning_peoples_party\",\"title\":\"Campaigning as a People's Party\",\"subtitle\":\"Campaigning with some of our previously nontraditional demographics.\",\"viewIf\":{\"$code\":\"return ((Q['peoples_party'] || 0)===1);\"},\"chooseIf\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0)===0);\"},\"unavailableSubtitle\":{\"content\":{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action.\"],\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\"}],\"goTo\":[{\"id\":\"peoples_party_campaigning\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"rosenfeld.against_toleration\":{\"id\":\"rosenfeld.against_toleration\",\"title\":\"Against toleration\",\"viewIf\":{\"$code\":\"return (!(((Q['constructive_vonc'] || 0)) !== 0));\"},\"subtitle\":\"Break our current toleration arrangement, and bring down the government via a no-confidence vote.\",\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action. \"],\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"The SPD is not currently in toleration.\",\"predicate\":2}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['spd_toleration'] || 0) == 0);\"}}]},\"chooseIf\":{\"$code\":\"return (((Q['advisor_action_timer'] || 0) == 0) && (((Q['spd_toleration'] || 0)) !== 0));\"},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\n if (((Q['next_election_time'] || 0) > ((Q['time'] || 0) + 3)) ) { Q['next_election_time'] = ((Q['time'] || 0) + 3); } \\n if (((Q['next_election_time'] || 0) >= ((Q['time'] || 0) + 3)) ) { Q['next_election_month'] = ((Q['month'] || 0) + 3); } \\n if (((Q['next_election_time'] || 0) >= ((Q['time'] || 0) + 3)) ) { Q['next_election_year'] = (Q['year'] || 0); } \\n if (((Q['next_election_month'] || 0) > 12) ) { Q['next_election_year'] = (Q['next_election_year'] || 0) + 1; } \\n if (((Q['next_election_month'] || 0) > 12) ) { Q['next_election_month'] = (Q['next_election_month'] || 0) - 12; } \\nQ['spd_toleration'] = 0;\\nQ['left_strength'] = (Q['left_strength'] || 0) + 8;\\nQ['pro_republic'] = (Q['pro_republic'] || 0) - 4;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) - 3;\\nQ['rural_spd'] = (Q['rural_spd'] || 0) - 3;\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) - 3;\\nQ['catholics_spd'] = (Q['catholics_spd'] || 0) - 3;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 8;\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"We have grown tired of the burdens of toleration, and have called a vote of no confidence in the current minority government.\"},{\"type\":\"paragraph\",\"content\":[\"New elections have been set for \",{\"type\":\"insert\",\"insert\":0},\" \",{\"type\":\"insert\",\"insert\":1},\".\"]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_month'] || 0);\"},\"qdisplay\":\"month\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_year'] || 0);\"}}]}},\"rosenfeld\":{\"id\":\"rosenfeld\",\"type\":\"scene\",\"title\":\"Kurt Rosenfeld\",\"isPinnedCard\":true,\"tags\":[\"advisor\",\"left\"],\"cardImage\":\"img/portraits/RosenfeldKurt.jpg\",\"viewIf\":{\"$code\":\"return ((Q['rosenfeld_advisor'] || 0)===1);\"},\"newPage\":true,\"options\":[{\"id\":\"@rosenfeld.building_the_left\"},{\"id\":\"@rosenfeld.kpd_cooperation\"},{\"id\":\"@rosenfeld.against_toleration\"},{\"id\":\"@root\",\"title\":\"Return to main\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Kurt Rosenfeld\"},{\"type\":\"paragraph\",\"content\":\"Rosenfeld works as a lawyer in Berlin who defends left-wing individuals and causes. He favors cooperation with the KPD and a path of class struggle for the SPD.\"}]},\"schumacher.moderate_economic_plan\":{\"id\":\"schumacher.moderate_economic_plan\",\"title\":\"Support the reformist economic plan\",\"subtitle\":\"Call for a limited program of job creation without deficit spending.\",\"chooseIf\":{\"$code\":\"return ((((Q['advisor_action_timer'] || 0)===0) && ((Q['moderate_plan_adopted'] || 0)===0)) && ((Q['black_thursday_seen'] || 0)===1));\"},\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action. \"],\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"We have already adopted the reformist economic plan. \",\"predicate\":2},\" \",{\"type\":\"conditional\",\"content\":\"We are not currently in an economic crisis.\",\"predicate\":3}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['moderate_economic_plan'] || 0)===0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['black_thursday_seen'] || 0) == 0);\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\"}],\"goTo\":[{\"id\":\"crisis_program.support_moderate\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"schumacher\":{\"id\":\"schumacher\",\"type\":\"scene\",\"title\":\"Kurt Schumacher\",\"isPinnedCard\":true,\"tags\":[\"advisor\",\"neorevisionist\"],\"cardImage\":\"img/portraits/SchumacherKurt.jpg\",\"viewIf\":{\"$code\":\"return ((Q['schumacher_advisor'] || 0)===1);\"},\"newPage\":true,\"options\":[{\"id\":\"@schumacher.emergency_fundraising\"},{\"id\":\"@schumacher.build_reichsbanner\"},{\"id\":\"@schumacher.moderate_economic_plan\"},{\"id\":\"@root\",\"title\":\"Return to main\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Kurt Schumacher\"},{\"type\":\"paragraph\",\"content\":\"A Great War veteran and a neorevisionist leader, Kurt Schumacher argues for a strong resistance against the Nazis.\"}]},\"sender.against_toleration\":{\"id\":\"sender.against_toleration\",\"title\":\"Against toleration\",\"viewIf\":{\"$code\":\"return (!(((Q['constructive_vonc'] || 0)) !== 0));\"},\"subtitle\":\"Break our current toleration arrangement, and bring down the government via a no-confidence vote.\",\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action. \"],\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"The SPD is not currently in toleration.\",\"predicate\":2}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['spd_toleration'] || 0) == 0);\"}}]},\"chooseIf\":{\"$code\":\"return (((Q['advisor_action_timer'] || 0) == 0) && (((Q['spd_toleration'] || 0)) !== 0));\"},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\n if (((Q['next_election_time'] || 0) > ((Q['time'] || 0) + 3)) ) { Q['next_election_time'] = ((Q['time'] || 0) + 3); } \\n if (((Q['next_election_time'] || 0) >= ((Q['time'] || 0) + 3)) ) { Q['next_election_month'] = ((Q['month'] || 0) + 3); } \\n if (((Q['next_election_time'] || 0) >= ((Q['time'] || 0) + 3)) ) { Q['next_election_year'] = (Q['year'] || 0); } \\n if (((Q['next_election_month'] || 0) > 12) ) { Q['next_election_year'] = (Q['next_election_year'] || 0) + 1; } \\n if (((Q['next_election_month'] || 0) > 12) ) { Q['next_election_month'] = (Q['next_election_month'] || 0) - 12; } \\nQ['spd_toleration'] = 0;\\nQ['left_strength'] = (Q['left_strength'] || 0) + 8;\\nQ['pro_republic'] = (Q['pro_republic'] || 0) - 4;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) - 3;\\nQ['rural_spd'] = (Q['rural_spd'] || 0) - 3;\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) - 3;\\nQ['catholics_spd'] = (Q['catholics_spd'] || 0) - 3;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 8;\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"We have grown tired of the burdens of toleration, and have called a vote of no confidence in the current minority government.\"},{\"type\":\"paragraph\",\"content\":[\"New elections have been set for \",{\"type\":\"insert\",\"insert\":0},\" \",{\"type\":\"insert\",\"insert\":1},\".\"]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_month'] || 0);\"},\"qdisplay\":\"month\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_year'] || 0);\"}}]}},\"seydewitz.against_toleration\":{\"id\":\"seydewitz.against_toleration\",\"title\":\"Against toleration\",\"subtitle\":\"Break our current toleration arrangement, and bring down the government via a no-confidence vote.\",\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action. \"],\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"The SPD is not currently in toleration.\",\"predicate\":2}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['spd_toleration'] || 0) == 0);\"}}]},\"viewIf\":{\"$code\":\"return (!(((Q['constructive_vonc'] || 0)) !== 0));\"},\"chooseIf\":{\"$code\":\"return (((Q['advisor_action_timer'] || 0) == 0) && (((Q['spd_toleration'] || 0)) !== 0));\"},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\n if (((Q['next_election_time'] || 0) > ((Q['time'] || 0) + 3)) ) { Q['next_election_time'] = ((Q['time'] || 0) + 3); } \\n if (((Q['next_election_time'] || 0) >= ((Q['time'] || 0) + 3)) ) { Q['next_election_month'] = ((Q['month'] || 0) + 3); } \\n if (((Q['next_election_time'] || 0) >= ((Q['time'] || 0) + 3)) ) { Q['next_election_year'] = (Q['year'] || 0); } \\n if (((Q['next_election_month'] || 0) > 12) ) { Q['next_election_year'] = (Q['next_election_year'] || 0) + 1; } \\n if (((Q['next_election_month'] || 0) > 12) ) { Q['next_election_month'] = (Q['next_election_month'] || 0) - 12; } \\nQ['spd_toleration'] = 0;\\nQ['left_strength'] = (Q['left_strength'] || 0) + 8;\\nQ['pro_republic'] = (Q['pro_republic'] || 0) - 4;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) - 3;\\nQ['rural_spd'] = (Q['rural_spd'] || 0) - 3;\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) - 3;\\nQ['catholics_spd'] = (Q['catholics_spd'] || 0) - 3;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 8;\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"We have grown tired of the burdens of toleration, and have called a vote of no confidence in the current minority government.\"},{\"type\":\"paragraph\",\"content\":[\"New elections have been set for \",{\"type\":\"insert\",\"insert\":0},\" \",{\"type\":\"insert\",\"insert\":1},\".\"]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_month'] || 0);\"},\"qdisplay\":\"month\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_year'] || 0);\"}}]}},\"seydewitz\":{\"id\":\"seydewitz\",\"type\":\"scene\",\"title\":\"Max Seydewitz\",\"isPinnedCard\":true,\"tags\":[\"advisor\",\"left\"],\"cardImage\":\"img/portraits/SeydewitzMax.jpg\",\"viewIf\":{\"$code\":\"return ((Q['seydewitz_advisor'] || 0)===1);\"},\"newPage\":true,\"options\":[{\"id\":\"@seydewitz.class_struggle\"},{\"id\":\"@seydewitz.socialist_youth\"},{\"id\":\"@seydewitz.against_toleration\"},{\"id\":\"@root\",\"title\":\"Return to main\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Max Seydewitz\"},{\"type\":\"paragraph\",\"content\":\"Max Seydewitz is a former leader of the youth wing, current supporter of the left wing of the SPD, and advocates for class struggle.\"}]},\"stampfer.support_left\":{\"id\":\"stampfer.support_left\",\"onArrival\":[{\"$code\":\"Q['left_dissent'] = (Q['left_dissent'] || 0) - 8;\\nQ['left_strength'] = (Q['left_strength'] || 0) + 8;\"}],\"content\":{\"content\":\"Vorwärts prints editorials in support of Left positions.\",\"type\":\"paragraph\"}},\"wels.emergency_fundraising\":{\"id\":\"wels.emergency_fundraising\",\"title\":\"Emergency Fundraising\",\"viewIf\":{\"$code\":\"return ((Q['difficulty'] || 0) < 1);\"},\"subtitle\":\"An emergency infusion of resources.\",\"chooseIf\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0)===0);\"},\"unavailableSubtitle\":{\"content\":{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action.\"],\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['resources'] = (Q['resources'] || 0) + (Q['dues'] || 0);\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"We have gained +\",{\"type\":\"insert\",\"insert\":0},\" resources.\"]},\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['dues'] || 0);\"}}]}},\"coalition_affairs.no_change\":{\"id\":\"coalition_affairs.no_change\",\"content\":{\"content\":\"No. We will not do this.\",\"type\":\"paragraph\"}},\"agricultural_policy.pro_consumer\":{\"id\":\"agricultural_policy.pro_consumer\",\"title\":\"Food Procurement\",\"subtitle\":\"-1 budget - Provide inexpensive food for workers.\",\"chooseIf\":{\"$code\":\"return ((Q['budget'] || 0) >= 1);\"},\"onArrival\":[{\"$code\":\"Q['budget'] = (Q['budget'] || 0) - 1;\\nQ['pro_consumer'] = (Q['pro_consumer'] || 0) + 1;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\nQ['workers_sol'] = (Q['workers_sol'] || 0) + 4;\\n if ((((Q['black_thursday_seen'] || 0)) !== 0) ) { Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1; }\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"We have increased state purchasing of food staples to provide to urban workers and the poor. This benefits workers more than it benefits farmers, as we are negotiating for lower purchase prices. \",{\"type\":\"conditional\",\"content\":\"Our coalition partners consider this policy to be a wasteful handout.\",\"predicate\":0}]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['black_thursday_seen'] || 0)) !== 0) && (((((Q['in_weimar_coalition'] || 0)) !== 0) || (((Q['in_grand_coalition'] || 0)) !== 0))));\"}}]}},\"dealing_with_toleration.urge_against_austerity\":{\"id\":\"dealing_with_toleration.urge_against_austerity\",\"title\":\"Urge the coalition against austerity politics, and to increase social spending.\",\"chooseIf\":{\"$code\":\"return ((Q['budget'] || 0) >= 1);\"},\"unavailableSubtitle\":\"This can only happen with a budget surplus.\",\"goTo\":[{\"id\":\"dealing_with_toleration.urge_success\",\"predicate\":{\"$code\":\"return (((Q['dvp_relation'] || 0) >= 30) && ((Q['z_relation'] || 0) >= 40));\"}},{\"id\":\"dealing_with_toleration.urge_failure\",\"predicate\":{\"$code\":\"return (((Q['dvp_relation'] || 0) < 30) || ((Q['z_relation'] || 0) < 40));\"}}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"deport_hitler.force_approach\":{\"id\":\"deport_hitler.force_approach\",\"onArrival\":[{\"$code\":\"var total_allied_strength = Q.rb_strength*Q.rb_militancy + Q.prussian_police_strength*Q.prussian_police_militancy*Q.prussian_police_loyalty;\\nvar enemy_strength = Q.sa_strength*Q.sa_militancy;\\nconsole.log('Deporting Hitler - force approach');\\nconsole.log(total_allied_strength, enemy_strength);\\n\\nif (total_allied_strength > enemy_strength) {\\n    Q.deportation_success = 1;\\n} else {\\n    Q.deportation_success = 0;\\n}\"}],\"goTo\":[{\"id\":\"deport_hitler.force_fail\",\"predicate\":{\"$code\":\"return ((Q['deportation_success'] || 0) == 0);\"}},{\"id\":\"deport_hitler.force_success\",\"predicate\":{\"$code\":\"return ((Q['deportation_success'] || 0)===1);\"}}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"woytinsky.depression\":{\"id\":\"woytinsky.depression\",\"title\":\"Addressing the economic crisis\",\"subtitle\":\"Formulate a plan to get us out of the economic crisis.\",\"chooseIf\":{\"$code\":\"return (((((Q['advisor_action_timer'] || 0) <= 0) && ((Q['wtb_adopted'] || 0) == 0)) && ((Q['black_thursday_seen'] || 0) == 1)) && ((Q['wtb_support'] || 0) <= 3));\"},\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action. \"],\"predicate\":0},{\"type\":\"conditional\",\"content\":\"We are not currently in an economic crisis. \",\"predicate\":2},{\"type\":\"conditional\",\"content\":\"We have already adopted the WTB-Plan.\",\"predicate\":3}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['black_thursday_seen'] || 0) == 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['wtb_adopted'] || 0) > 0);\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['wtb_support'] = (Q['wtb_support'] || 0) + 2;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) + 10;\\nQ['labor_strength'] = (Q['labor_strength'] || 0) + 1;\"}],\"content\":{\"content\":\"The WTB-plan, named for its primary supporters Woytinsky, Tarnow, and Baade, has been adopted as the unions' plan for getting us out of the depression. Woytinsky canvasses in favor of this policy through the SPD and the unions.\",\"type\":\"paragraph\"}},\"woytinsky\":{\"id\":\"woytinsky\",\"type\":\"scene\",\"title\":\"Wladimir Woytinsky\",\"isPinnedCard\":true,\"tags\":[\"advisor\",\"labor\"],\"cardImage\":\"img/portraits/WoytinskyWladimir.jpg\",\"viewIf\":{\"$code\":\"return ((Q['woytinsky_advisor'] || 0)===1);\"},\"newPage\":true,\"options\":[{\"id\":\"@woytinsky.plan\"},{\"id\":\"@woytinsky.carry_out_policy\"},{\"id\":\"@woytinsky.depression\"},{\"id\":\"@root\",\"title\":\"Return to main\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Wladimir Woytinsky\"},{\"type\":\"paragraph\",\"content\":\"Wladimir Woytinsky is a Russian Menshevik in exile, and the chief economist of the socialist trade union federation. His primary idea is to use massive government spending as a way of stimulating demand to extricate us from the depression.\"}]},\"economic_democracy.expand_councils_3\":{\"id\":\"economic_democracy.expand_councils_3\",\"title\":\"Empower sectorial works councils.\",\"subtitle\":\"Give works councils a role in setting wage and price policy for entire industrial sectors.\",\"viewIf\":{\"$code\":\"return ((Q['works_councils'] || 0) == 2);\"},\"onArrival\":[{\"$code\":\"Q['economic_democracy'] = (Q['economic_democracy'] || 0) + 1;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (7 * (1 - (Q['dissent'] || 0)));\\nQ['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) + 1;\\nQ['works_councils'] = (Q['works_councils'] || 0) + 1;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) - 6;\\nQ['labor_strength'] = (Q['labor_strength'] || 0) + 8;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 5;\\n if ((((Q['in_grand_coalition'] || 0)) !== 0) ) { Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1; } \\n if (((Q['unemployed'] || 0) > 5) ) { Q['unemployed'] = (Q['unemployed'] || 0) - 2; } \\nQ['workers'] = (Q['workers'] || 0) + 2;\"}],\"maxVisits\":1,\"content\":{\"content\":\"Sectorial works councils can now negotiate wage and price policies for entire economic sectors, helping to both give workers more of a voice, and to rationalize the economy, smoothing over the anarchy of the market.\",\"type\":\"paragraph\"},\"countVisitsMax\":1},\"economic_policy.wtb_continuation\":{\"id\":\"economic_policy.wtb_continuation\",\"title\":\"Look back on our results, and continue our implementation...\",\"viewIf\":{\"$code\":\"return (((Q['wtb_implemented'] || 0) >= 1) && ((Q['wtb_implemented'] || 0) <= 2));\"},\"onArrival\":[{\"$code\":\"if (((Q['works_program'] || 0) <= 2) ) { Q['budget'] = (Q['budget'] || 0) + 1; } \\n if (((((Q['works_program'] || 0) <= 2) && ((Q['unemployed'] || 0) > 15))) ) { \\nQ['unemployed'] = (Q['unemployed'] || 0) - 5;;\\n } else { Q['unemployed'] = (Q['unemployed'] || 0) - 3; } \\n if (((Q['unemployed'] || 0) < 5) ) { Q['unemployed'] = (Q['unemployed'] || 0) + 3; } \\n if (((Q['unemployed'] || 0) < 0) ) { Q['unemployed'] = (Q['unemployed'] || 0) + 3; } \\n if (((Q['works_program'] || 0) <= 2) ) { \\nQ['workers'] = (Q['workers'] || 0) + 4;;\\n } else { Q['workers'] = (Q['workers'] || 0) + 2; } \\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (8 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (8 * (1 - (Q['dissent'] || 0)));\\nQ['workers_kpd'] = (Q['workers_kpd'] || 0) - 3;\\nQ['workers_nsdap'] = (Q['workers_nsdap'] || 0) - 5;\\nQ['works_program'] = (Q['works_program'] || 0) + 1;\\nQ['z_relation'] = (Q['z_relation'] || 0) + 3;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) + 3;\\n if (((Q['coalition_dissent'] || 0) >= 1) ) { Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) - 1; } \\nQ['wtb_implemented'] = (Q['wtb_implemented'] || 0) + 1;\\n if (((Q['capital_strike_progress'] || 0) >= 3) ) { Q['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) - 1; } \\nQ['inflation'] = (Q['inflation'] || 0) + 1.5;\\n if (((Q['unemployed'] || 0) < 10) ) { Q['inflation'] = (Q['inflation'] || 0) + 1; }\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"Our spending on public works has resulted in a lower need for unemployment insurance and welfare, and increased tax receipts through the multiplier effect as the new money courses through the economy, recuperating some of our spending. We continue to invest most of the new revenue into the program.\"},{\"type\":\"paragraph\",\"content\":\"The economy is doing better, finally. Even the bourgeois parties are beginning to see the light.\"},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":\"The KPD, however, still opposes our policy of \\\"rescuing\\\" capitalism.\",\"predicate\":0}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['in_popular_front'] || 0)) !== 0) || (((Q['in_left_front'] || 0)) !== 0));\"}}]}},\"domestic_enemies.persecute_sa\":{\"id\":\"domestic_enemies.persecute_sa\",\"title\":\"Further persecute the SA.\",\"viewIf\":{\"$code\":\"return ((Q['sa_banned'] || 0)===1);\"},\"chooseIf\":{\"$code\":\"return (((Q['judicial_reform'] || 0) >= 3) && ((Q['interior_police_loyalty'] || 0) >= 0.7));\"},\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":\"The judiciary would not allow this. \",\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"The police are too disloyal to be trusted with this.\",\"predicate\":1}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['judicial_reform'] || 0) < 3);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['interior_police_loyalty'] || 0) < 0.7);\"}}]},\"onArrival\":[{\"$code\":\"Q['sa_strength'] = (Q['sa_strength'] || 0) * 0.7;\\nQ['sa_militancy'] = (Q['sa_militancy'] || 0) - 0.05;\"}],\"content\":{\"content\":\"We have arrested more of the SA's leaders and confiscated their weapons.\",\"type\":\"paragraph\"}},\"foreign_policy.improve_east\":{\"id\":\"foreign_policy.improve_east\",\"title\":\"Improve our relations with our eastern neighbors.\",\"onArrival\":[{\"$code\":\"Q['east_relation'] = (Q['east_relation'] || 0) + 2;\"}],\"content\":{\"content\":\"We also aim to improve relations with our eastern neighbors, Poland and Czechoslovakia, who are righfully terrified of German aggression. Hopefully we can convince them of our peaceful intentions.\",\"type\":\"paragraph\"}},\"homosexual_rights.change_sex\":{\"id\":\"homosexual_rights.change_sex\",\"subtitle\":\"We can create a legal process for individuals to change their sex, making their lives easier.\",\"unavailableSubtitle\":\"We do not have majority support for this policy.\",\"viewIf\":{\"$code\":\"return ((Q['trans_rights'] || 0) == 0);\"},\"chooseIf\":{\"$code\":\"return ((Q['progressive_coalition'] || 0) >= 50);\"},\"onArrival\":[{\"$code\":\"Q['trans_rights'] = 1;\\nQ['homosexual_rights'] = (Q['homosexual_rights'] || 0) + 1;\\nQ['z_relation'] = (Q['z_relation'] || 0) - 5;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\nQ['ddp_relation'] = (Q['ddp_relation'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\n if ((((((Q['in_grand_coalition'] || 0)) !== 0) || (((Q['in_weimar_coalition'] || 0)) !== 0))) ) { Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1; } \\nQ['catholics_spd'] = (Q['catholics_spd'] || 0) - 4;\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"We have passed a bill to allow legal recognition of transsexual and transvestite individuals as the sex in which they live, and allow them to change their name, dress as they wish without police persecution, and undergo medical treatment.\"},{\"type\":\"paragraph\",\"content\":\"Of course, conservatives and the far right accuse us of \\\"degeneracy\\\".\"}]},\"homosexual_rights\":{\"id\":\"homosexual_rights\",\"type\":\"scene\",\"title\":\"Homosexual Rights\",\"newPage\":true,\"isCard\":true,\"cardImage\":\"img/hirschfeld.jpg\",\"frequency\":25,\"maxVisits\":3,\"viewIf\":{\"$code\":\"return ((((((Q['spd_in_government'] || 0) == 1) && (((Q['progressive_coalition'] || 0) >= 50))) && (Q['chancellor_party'] == \\\"SPD\\\")) && ((Q['homosexual_rights_timer'] || 0) == 0)) && ((Q['homosexual_rights'] || 0) < 3));\"},\"onArrival\":[{\"$code\":\"Q['homosexual_rights_timer'] = (Q['homosexual_rights_timer'] || 0) + 11;\\nQ['month_actions'] = (Q['month_actions'] || 0) + 1;\"}],\"tags\":[\"govt_affairs\"],\"options\":[{\"id\":\"@homosexual_rights.repeal_175\",\"title\":\"Repeal Paragraph 175.\"},{\"id\":\"@homosexual_rights.reform_183\",\"title\":\"Reform Paragraph 183.\"},{\"id\":\"@homosexual_rights.change_sex\",\"title\":\"Create a legal process for changing sex.\"},{\"id\":\"@return\",\"title\":\"Do not enact any changes for now.\"},{\"id\":\"@easy_discard\"},{\"id\":\"@cancel_advisor_action\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Homosexual Rights\"},{\"type\":\"paragraph\",\"content\":\"There is a constellation of different groups that have grown up around divergences in gender and sexuality, including homosexuals, lesbians, transsexuals, transvestites, inverts, etc. Our party's policy is to support their right to live freely and free from persecution; Magnus Hirschfeld, the founder of the Institut für Sexualwissenschaft, is a member of our party and a major advocate for homosexual rights.\"}],\"countVisitsMax\":3},\"fiscal_policy.raise_rich\":{\"id\":\"fiscal_policy.raise_rich\",\"subtitle\":\"+2 budget\",\"onArrival\":[{\"$code\":\"Q['upper_tax_rates'] = (Q['upper_tax_rates'] || 0) + 1;\\nQ['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) + 1;\\n if (((Q['upper_tax_rates'] || 0) > 1) ) { Q['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) + 1; } \\n if (((Q['upper_tax_rates'] || 0) > 3) ) { Q['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) + 1; } \\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) - 4;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) - 4;\\n if ((((Q['in_grand_coalition'] || 0)) !== 0) ) { Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1; } \\n if (((Q['capital_strike_progress'] || 0) >= 5) ) { Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1; } \\nQ['budget'] = (Q['budget'] || 0) + 2;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 4;\\nQ['unemployed'] = (Q['unemployed'] || 0) + 1;\\nQ['finance_goal_completed'] = (Q['finance_goal_completed'] || 0) + 1;\\nQ['inflation'] = (Q['inflation'] || 0) - 0.6;\"}],\"content\":{\"content\":\"Raising taxes on the rich is popular among our base, but it alienates the bourgeoisie. Increasing taxes also decreases economic demand, which may lead to more unemployment.\",\"type\":\"paragraph\"}},\"labor_affairs.balance\":{\"id\":\"labor_affairs.balance\",\"subtitle\":\"Both sides need to share the pain in the current crisis.\",\"onArrival\":[{\"$code\":\"Q['labor_dissent'] = (Q['labor_dissent'] || 0) + 4;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 2;\\nQ['kpd_coalition_dissent'] = (Q['kpd_coalition_dissent'] || 0) + 1;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) - 5;\\nQ['strike_term_seen'] = (Q['strike_term_seen'] || 0) + 1;\"}],\"content\":{\"content\":\"Many workers are unhappy at our compromises, but they will learn to accept that we are all in a shared struggle against economic forces.\",\"type\":\"paragraph\"}},\"labor_affairs\":{\"id\":\"labor_affairs\",\"type\":\"scene\",\"title\":\"Labor Affairs\",\"newPage\":true,\"isCard\":true,\"tags\":[\"govt_affairs\"],\"onArrival\":[{\"$code\":\"Q['labor_affairs_timer'] = 6;\\nQ['month_actions'] = (Q['month_actions'] || 0) + 1;\\nQ['labor_affairs_seen'] = 1;\"}],\"viewIf\":{\"$code\":\"return (((((Q['spd_in_government'] || 0)===1) && (Q['labor_minister_party'] == \\\"SPD\\\")) && ((Q['labor_affairs_timer'] || 0)===0)) && ((Q['strike_term_seen'] || 0)===0));\"},\"cardImage\":\"img/portraits/WissellRudolf.jpg\",\"options\":[{\"id\":\"@labor_affairs.support_labor\",\"title\":\"Support labor in their demands.\"},{\"id\":\"@labor_affairs.support_employers\",\"title\":\"Support the employers in their demands.\"},{\"id\":\"@labor_affairs.balance\",\"title\":\"Try to strike a compromise between the sides.\"},{\"id\":\"@easy_discard\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Labor Affairs\"},{\"type\":\"paragraph\",\"content\":\"The industrial Ruhr region is aflame with labor unrest. The employers have started a major lockout to force the workers to take more cuts to wages and benefits. There is a need for the Labor Ministry to arbitrate in conflicts between employers and workers.\"}]},\"military_policy.reform\":{\"id\":\"military_policy.reform\",\"subtitle\":\"-1 budget\",\"chooseIf\":{\"$code\":\"return ((Q['budget'] || 0) >= 1);\"},\"unavailableSubtitle\":\"We do not have the budget.\",\"onArrival\":[{\"$code\":\"if (((Q['in_grand_coalition'] || 0) == 1) ) { Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1; } \\nQ['reichswehr_loyalty'] = (Q['reichswehr_loyalty'] || 0) + 0.15;\\nQ['reichswehr_militancy'] = (Q['reichswehr_militancy'] || 0) - 1;\\nQ['budget'] = (Q['budget'] || 0) - 1;\\nQ['coup_progress'] = (Q['coup_progress'] || 0) + 1;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 5;\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"Our efforts are at least somewhat successful; we have changed the recruiting and training patterns so that more soldiers from non-reactionary backgrounds can join, hopefully changing the culture of the forces. We have also removed some of the officers who supported the previous Kapp putsch.\"},{\"type\":\"paragraph\",\"content\":\"The center-right parties are committed to the military and deeply suspicious of our efforts to reform it.\"}]},\"military_policy\":{\"id\":\"military_policy\",\"type\":\"scene\",\"title\":\"Military Policy\",\"newPage\":true,\"isCard\":true,\"tags\":[\"govt_affairs\"],\"onArrival\":[{\"$code\":\"Q['military_policy_timer'] = (Q['military_policy_timer'] || 0) + 6;\\nQ['month_actions'] = (Q['month_actions'] || 0) + 1;\"}],\"viewIf\":{\"$code\":\"return ((((Q['spd_in_government'] || 0)===1) && (Q['reichswehr_minister_party'] == \\\"SPD\\\")) && ((Q['military_policy_timer'] || 0) <= 0));\"},\"cardImage\":\"img/portraits/LeberJulius.jpg\",\"options\":[{\"id\":\"@military_policy.increase_funding\",\"title\":\"Increase funding for the military to purchase its loyalty.\"},{\"id\":\"@military_policy.decrease_funding\",\"title\":\"Reduce funding for the military so we have more for social spending.\"},{\"id\":\"@military_policy.reform\",\"title\":\"Conduct a thorough reform of the ranks, reducing the influence of reactionaries and making it more hospitable to us.\"},{\"id\":\"@root\",\"title\":\"No change to military policy.\"},{\"id\":\"@easy_discard\"},{\"id\":\"@cancel_advisor_action\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Military Policy\"},{\"type\":\"paragraph\",\"content\":\"The Reichswehr is a deeply reactionary institution that has been generally hostile to any notion of socialism or democracy. However, we now control the military as part of the government. What should we do to reform it?\"}]},\"labor_rights.shorten_hours\":{\"id\":\"labor_rights.shorten_hours\",\"viewIf\":{\"$code\":\"return (((Q['working_hours'] || 0) >= 2) && ((Q['black_thursday_seen'] || 0)===1));\"},\"subtitle\":\"Could we induce more hiring and reduce unemployment by reducing work hours?\",\"onArrival\":[{\"$code\":\"Q['working_hours'] = (Q['working_hours'] || 0) + 1;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) - 8;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) - 5;\\nQ['labor_strength'] = (Q['labor_strength'] || 0) + 5;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (7 * (1 - (Q['dissent'] || 0)));\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 4;\\nQ['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1;\\nQ['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) + 1;\\nQ['labor_goal_completed'] = 1;\\nQ['unemployed'] = (Q['unemployed'] || 0) - 0.3;\"}],\"content\":{\"content\":\"Some in the labor movement argue that by reducing the maximum number of hours worked, employers would be induced to hire more workers, reducing unemployment. The argument also goes that this would be complementary to deflation, maintaining the same purchasing power for workers by cutting hours without cutting wages. Employers, however, resist this policy, arguing for more flexibility in hiring and firing.\",\"type\":\"paragraph\"}},\"police.investigate_corruption_success\":{\"id\":\"police.investigate_corruption_success\",\"onArrival\":[{\"$code\":\"Q['investigate_corruption'] = (Q['investigate_corruption'] || 0) + 1;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\n if (((Q['inflation'] || 0) > 3) ) { Q['inflation'] = (Q['inflation'] || 0) - 0.1; } \\n if (((Q['inflation'] || 0) >= 8) ) { Q['inflation'] = (Q['inflation'] || 0) - 0.2; }\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"Corruption in big business is rampant, of course. We have uncovered a number of scandals, and publicizing them brings new attention to the work of Interior Minister \",{\"type\":\"insert\",\"insert\":0},\", building up his popular appeal and that of the SPD.\"]},\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['interior_minister'] || 0);\"}}]}},\"prussian_affairs.bureaucracy\":{\"id\":\"prussian_affairs.bureaucracy\",\"onArrival\":[{\"$code\":\"Q['prussian_police_loyalty'] = (Q['prussian_police_loyalty'] || 0) + 0.05;\\nQ['nationalism'] = (Q['nationalism'] || 0) - 5;\\nQ['pacifism'] = (Q['pacifism'] || 0) + 1;\\nQ['democratization'] = (Q['democratization'] || 0) + 1;\\nQ['pro_republic'] = (Q['pro_republic'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\n if (((Q['democratization'] || 0) >= 3) ) { Q['new_middle_spd'] = (Q['new_middle_spd'] || 0) + (2 * (1 - (Q['dissent'] || 0))); } \\n if (((Q['democratization'] || 0) >= 4) ) { Q['new_middle_spd'] = (Q['new_middle_spd'] || 0) + (2 * (1 - (Q['dissent'] || 0))); } \\nQ['coup_progress'] = (Q['coup_progress'] || 0) + 0.5;\"}],\"content\":{\"content\":\"The bureaucracy is deeply reactionary, and many abuse their power to favor the political right. By removing the pro-monarchy and pro-dictatorship elements, we can democratize it. Some of our opponents claim that we are infringing on individual freedoms, but perhaps the security of the republic requires it.\",\"type\":\"paragraph\"}},\"social_welfare.increase_spending_post_depression\":{\"id\":\"social_welfare.increase_spending_post_depression\",\"viewIf\":{\"$code\":\"return ((Q['unemployed'] || 0) > 15);\"},\"chooseIf\":{\"$code\":\"return ((Q['budget'] || 0) > 0);\"},\"onArrival\":[{\"$code\":\"Q['budget'] = (Q['budget'] || 0) - 1;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\n if (((Q['welfare'] || 0) > 0) ) { Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1; } \\nQ['welfare_goal_completed'] = (Q['welfare_goal_completed'] || 0) + 1;\\nQ['inflation'] = (Q['inflation'] || 0) + 0.3;\"}],\"subtitle\":\"The increased levels of unemployment necessitate more spending on aid to maintain the same benefits. -1 Budget\",\"content\":{\"content\":\"Increasing welfare spending is necessary in light of the rise in unemployment, so we are essentially treading water.\",\"type\":\"paragraph\"}},\"womens_rights.welfare\":{\"id\":\"womens_rights.welfare\",\"subtitle\":\"-1 budget\",\"chooseIf\":{\"$code\":\"return ((Q['budget'] || 0) > 0);\"},\"onArrival\":[{\"$code\":\"Q['welfare'] = (Q['welfare'] || 0) + 1;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['budget'] = (Q['budget'] || 0) - 1;\\nQ['womens_rights'] = (Q['womens_rights'] || 0) + 1;\\n if ((((Q['welfare'] || 0) >= 1) && ((Q['unemployed'] || 0) >= 15)) ) { Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1; } \\nQ['unemployed'] = (Q['unemployed'] || 0) - 0.4;\\nQ['inflation'] = (Q['inflation'] || 0) + 0.2;\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"We have increased welfare spending on women and children. \",{\"type\":\"conditional\",\"content\":\"Some of our coalition partners consider increased welfare spending profligate at this time.\",\"predicate\":0}]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['welfare'] || 0) >= 1) && ((Q['unemployed'] || 0) >= 15));\"}}]}},\"war_guilt.rewrite\":{\"id\":\"war_guilt.rewrite\",\"onArrival\":[{\"$code\":\"Q['pacifism'] = (Q['pacifism'] || 0) + 1;\\nQ['nationalism'] = (Q['nationalism'] || 0) - (5 * (1 - (Q['dissent'] || 0)));\\nQ['pro_republic'] = (Q['pro_republic'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['coup_progress'] = (Q['coup_progress'] || 0) + 1;\"}],\"content\":{\"content\":\"Destroying the \\\"stabbed in the back\\\" myth, in addition to finally correcting the historical record, would do a great deal to improve our party's reputation. This is why it would be resisted by the military establishment every step of the way.\",\"type\":\"paragraph\"}},\"war_guilt\":{\"id\":\"war_guilt\",\"type\":\"scene\",\"title\":\"War Guilt Inquiry\",\"newPage\":true,\"isCard\":true,\"tags\":[\"govt_affairs\"],\"onArrival\":[{\"$code\":\"Q['war_guilt_timer'] = 6;\\nQ['month_actions'] = (Q['month_actions'] || 0) + 1;\"}],\"viewIf\":{\"$code\":\"return (((Q['spd_in_government'] || 0)===1) && ((Q['war_guilt_timer'] || 0)===0));\"},\"cardImage\":\"img/reichstag_1.jpg\",\"maxVisits\":1,\"options\":[{\"id\":\"@war_guilt.restart\",\"title\":\"Restart the inquiry.\"},{\"id\":\"@root\",\"title\":\"Do nothing.\"},{\"id\":\"@easy_discard\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Reichstag War Guilt Inquiry\"},{\"type\":\"paragraph\",\"content\":\"The War Guilt Inquiry has been an intermittent Reichstag committee for investigating the causes of the Great War and the German defeat. So far, it has faced massive resistance from the military establishment up to President Hindenburg.\"}],\"countVisitsMax\":1},\"judiciary.as_is\":{\"id\":\"judiciary.as_is\",\"goTo\":[{\"id\":\"root\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"judiciary\":{\"id\":\"judiciary\",\"type\":\"scene\",\"title\":\"Judiciary Reform\",\"newPage\":true,\"isCard\":true,\"viewIf\":{\"$code\":\"return ((((Q['spd_in_government'] || 0)===1) && (Q['justice_minister_party'] == \\\"SPD\\\")) && ((Q['judiciary_timer'] || 0)===0));\"},\"onArrival\":[{\"$code\":\"Q['month_actions'] = (Q['month_actions'] || 0) + 1;\\nQ['judiciary_timer'] = (Q['judiciary_timer'] || 0) + 6;\"}],\"cardImage\":\"img/portraits/RadbruchGustav.jpg\",\"tags\":[\"govt_affairs\"],\"options\":[{\"id\":\"@judiciary.reform\",\"title\":\"Carry out substantial judicial reforms,\"},{\"id\":\"@judiciary.minor_reforms\",\"title\":\"Carry out minor judicial reforms.\"},{\"id\":\"@judiciary.as_is\",\"title\":\"Leave the judiciary as it is.\"},{\"id\":\"@easy_discard\"},{\"id\":\"@cancel_advisor_action\"}],\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"Judiciary Reform\"},{\"type\":\"paragraph\",\"content\":\"The Judiciary is one of the most reactionary components of the government, along with the military. Many jurists have held office since the days of the Emperor. They give violent fascists like Adolf Hitler laughably light sentences, while ruthlessly persecuting leftists and pacifists for lesser crimes.\"},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"There is great demand in our membership for reforming the judiciary, although this may bring us into a collision course with our coalition allies. \",\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"We have started on the path to judicial reform. While some of the most antideluvian and biased justices have been replaced, many still remain. More should be done. \",\"predicate\":1},\" \",{\"type\":\"conditional\",\"content\":\"We have successfully reformed the judiciary, to some extent. At the very least, the courts will not actively obstruct our attempts to prosecute crimes committed by the far-right.\",\"predicate\":2}]}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['judicial_reform'] || 0) <= 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['judicial_reform'] || 0) == 1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['judicial_reform'] || 0) >= 2);\"}}]}},\"all_quiet.allow_protect\":{\"id\":\"all_quiet.allow_protect\",\"chooseIf\":{\"$code\":\"return ((Q['prussian_police_loyalty'] || 0) >= 0.65);\"},\"unavailableSubtitle\":\"The police are not willing to protect the film.\",\"onArrival\":[{\"$code\":\"Q['nationalism'] = (Q['nationalism'] || 0) - 4;\\nQ['pro_republic'] = (Q['pro_republic'] || 0) + 3;\\nQ['strife'] = (Q['strife'] || 0) + 1;\"}],\"content\":{\"content\":\"Under the protection of the police, the people are allowed to watch the film in peace. Nazi disturbances are kept to a minimum.\",\"type\":\"paragraph\"}},\"austrian_customs_union.end_toleration\":{\"id\":\"austrian_customs_union.end_toleration\",\"viewIf\":{\"$code\":\"return ((Q['spd_toleration'] || 0)===1);\"},\"subtitle\":\"This is difficult; all of the right-of-center parties support this policy.\",\"goTo\":[{\"id\":\"austrian_customs_union.end_toleration_success\",\"predicate\":{\"$code\":\"return ((((Q['spd_r'] || 0) + (Q['kpd_r'] || 0)) + (Q['ddp_r'] || 0)) >= 50);\"}},{\"id\":\"austrian_customs_union.end_toleration_fail\",\"predicate\":{\"$code\":\"return ((((Q['spd_r'] || 0) + (Q['kpd_r'] || 0)) + (Q['ddp_r'] || 0)) < 50);\"}}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"banking_crisis.austerity\":{\"id\":\"banking_crisis.austerity\",\"viewIf\":{\"$code\":\"return ((Q['spd_in_government'] || 0)===0);\"},\"onArrival\":[{\"$code\":\"Q['welfare'] = (Q['welfare'] || 0) - 1;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 3;\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) - 3;\\nQ['pro_republic'] = (Q['pro_republic'] || 0) - 3;\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"Chancellor \",{\"type\":\"insert\",\"insert\":0},\" responds to the banking crisis with more cuts to welfare.\"]},\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor'] || 0);\"}}]}},\"blutmai.communist_fault\":{\"id\":\"blutmai.communist_fault\",\"onArrival\":[{\"$code\":\"Q['kpd_relation'] = (Q['kpd_relation'] || 0) - 10;\\nQ['z_relation'] = (Q['z_relation'] || 0) + 5;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) + 5;\\nQ['rfb_strength'] = (Q['rfb_strength'] || 0) - 80;\\nQ['rfb_banned'] = 1;\"}],\"content\":{\"content\":\"If the KPD continues to act illegally, they must suffer the consequences. Thus, we have banned the RFKB, their paramilitary group. The bourgeois and right-leaning parties approve.\",\"type\":\"paragraph\"}},\"altona_clashes.allow_police_violence\":{\"id\":\"altona_clashes.allow_police_violence\",\"onArrival\":[{\"$code\":\"Q['strife'] = (Q['strife'] || 0) + 1;\\nQ['sa_strength'] = (Q['sa_strength'] || 0) + 50;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) - 8;\\nQ['communist_coalition'] = (Q['communist_coalition'] || 0) - 1;\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"When the march arrives in Altona, they are immediately confronted by an angry crowd of communists and socialists, who throw objects at the Nazis. The police attempt to separate the two groups, to no avail. Gunshots are heard, reportedly from rooftop snipers (whom the police believe are communists). In response, the police fire into the surrounding buildings. Dozens are killed. All turn out to be civilians, and the reported snipers are never found.\"},{\"type\":\"paragraph\",\"content\":\"This incident has been called \\\"Altona Bloody Sunday\\\" in the media. The Communists assail the incompetence of the police, who are supposedly under our command.\"}]},\"businesses_lose_confidence.nothing\":{\"id\":\"businesses_lose_confidence.nothing\",\"content\":{\"content\":\"Realistically, there is nothing we can do.\",\"type\":\"paragraph\"}},\"capital_strike.propaganda\":{\"id\":\"capital_strike.propaganda\",\"title\":\"Launch a propaganda campaign blaming the capitalists for the crisis.\",\"subtitle\":\"-1 resources\",\"chooseIf\":{\"$code\":\"return (((((Q['radio'] || 0) >= 2) || ((Q['commercialized_media'] || 0) >= 3))) && ((Q['resources'] || 0) >= 1));\"},\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":\"We have not built up our media enough. \",\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"We do not have enough resources.\",\"predicate\":1}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['radio'] || 0) < 2) && ((Q['commercialized_media'] || 0) < 3));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['resources'] || 0) < 1);\"}}]},\"onArrival\":[{\"$code\":\"Q['workers_spd'] = (Q['workers_spd'] || 0) + (7 * (1 - (Q['dissent'] || 0)));\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) + (6 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (6 * (1 - (Q['dissent'] || 0)));\\nQ['pro_republic'] = (Q['pro_republic'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['resources'] = (Q['resources'] || 0) - 1;\"}],\"content\":{\"content\":\"We launch a counter-propaganda campaign to blame the economic crisis on the capitalists, using all of our media channels to do so. Because of our existing media framework, this is moderately successful in directing popular criticisms towards the capitalists and away from us.\",\"type\":\"paragraph\"}},\"center_party_conference.joos_campaign\":{\"id\":\"center_party_conference.joos_campaign\",\"chooseIf\":{\"$code\":\"return (((Q['z_relation'] || 0) >= 62) && ((Q['resources'] || 0) >= 1));\"},\"viewIf\":{\"$code\":\"return ((Q['z_relation'] || 0) < 70);\"},\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":\"Our relations are not good enough. \",\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"We do not have enough resources.\",\"predicate\":1}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['z_relation'] || 0) <= 62);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['resources'] || 0) < 1);\"}}]},\"subtitle\":\"-1 resource. Joos is likely to be friendlier to us than Kaas.\",\"onArrival\":[{\"$code\":\"Q['resources'] = (Q['resources'] || 0) - 1;\\nQ['z_party_leader'] = \\\"Joos\\\";\\nQ['catholics_spd'] = (Q['catholics_spd'] || 0) + 5;\\nQ['workers_z'] = (Q['workers_z'] || 0) + 3;\"}],\"content\":{\"content\":\"With our grassroots connections as well as a professional campaign, we have been able to influence the Center delegates to support Joseph Joos as the new Center chairman. He has long been a friend of the SPD, and will be more inclined to collaborate with us compared to Kaas. He also increases the appeal of the Center Party to the working class.\",\"type\":\"paragraph\"}},\"center_party_conference\":{\"id\":\"center_party_conference\",\"type\":\"scene\",\"title\":\"Center Party Conference\",\"subtitle\":\"The Center Party chooses their new leader...\",\"viewIf\":{\"$code\":\"return ((((Q['year'] || 0)===1928) && ((Q['month'] || 0)===12)) && (Q['z_party_leader'] == \\\"Marx\\\"));\"},\"maxVisits\":1,\"tags\":[\"event\"],\"newPage\":true,\"options\":[{\"id\":\"@center_party_conference.kaas\",\"title\":\"The Center Party elects Ludwig Kaas as the party chair.\"},{\"id\":\"@center_party_conference.joos\",\"title\":\"Influence the Center Party to select Joseph Joos as the party chair.\"},{\"id\":\"@center_party_conference.joos_campaign\",\"title\":\"We must hold a campaign in support of Joseph Joos as party chair.\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Center Party Conference\"},{\"type\":\"paragraph\",\"content\":\"Wilhelm Marx, former Center Party chancellor and presidential candidate, has chosen to resign from leadership of the Center Party. Now, the party holds a conference to replace him.\"},{\"type\":\"paragraph\",\"content\":\"The consensus candidate on the right is Ludwig Kaas, a Catholic priest who represents the party's traditionalists. On the other hand, there is Joseph Joos, a leader of the Catholic trade unions, who has been more supportive of cooperation with the SPD than most of the Center Party.\"}],\"countVisitsMax\":1},\"death_of_muller.wels_chancellor\":{\"id\":\"death_of_muller.wels_chancellor\",\"onArrival\":[{\"$code\":\"Q['chancellor'] = \\\"Wels\\\";\\nQ['chancellor_party'] = \\\"SPD\\\";\\nQ['z_relation'] = (Q['z_relation'] || 0) - 3;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 3;\"}],\"subtitle\":\"He is a good organizer, but is he also a good chancellor?\",\"content\":{\"content\":\"Our coalition partners are reluctant to accept the new Chancellor, but they do not make loud objections.\",\"type\":\"paragraph\"}},\"civil_war.kpd_help\":{\"id\":\"civil_war.kpd_help\",\"maxVisits\":1,\"viewIf\":{\"$code\":\"return ((Q['chancellor_party'] != \\\"KPD\\\") && (Q['president'] != \\\"Thälmann\\\"));\"},\"goTo\":[{\"id\":\"civil_war.war_menu\"}],\"onArrival\":[{\"$code\":\"Q['war_choices'] = (Q['war_choices'] || 0) + 1;\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[\"There are \",{\"type\":\"insert\",\"insert\":0},\" thousand fighters with the Communist RFB, in addition to the workers who support the KPD.\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"The KPD is entirely on our side, owing to our good relations.. \",\"predicate\":1},{\"type\":\"conditional\",\"content\":\"Most of the KPD is on our side, due to their good relations with us. \",\"predicate\":2},{\"type\":\"conditional\",\"content\":\"The KPD does not support us.\",\"predicate\":3}]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rfb_strength'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['kpd_relation'] || 0) >= 60);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['kpd_relation'] || 0) < 60) && ((Q['kpd_relation'] || 0) >= 45));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['kpd_relation'] || 0) < 45);\"}}]},\"countVisitsMax\":1},\"emergency_cuts.vote_yes\":{\"id\":\"emergency_cuts.vote_yes\",\"title\":\"Vote in favor of this measure to continue the toleration agreement.\",\"viewIf\":{\"$code\":\"return (((Q['spd_toleration'] || 0)) !== 0);\"},\"onArrival\":[{\"$code\":\"Q['welfare'] = (Q['welfare'] || 0) - 1;\\nQ['unemployed'] = (Q['unemployed'] || 0) + 2;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 10;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) + 10;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) * 0.9;\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) * 0.9;\\nQ['unemployed_nsdap'] = (Q['unemployed_nsdap'] || 0) + 5;\\nQ['unemployed_kpd'] = (Q['unemployed_kpd'] || 0) + 5;\\nQ['workers_nsdap'] = (Q['workers_nsdap'] || 0) + 5;\\nQ['workers_kpd'] = (Q['workers_kpd'] || 0) + 5;\\n if (((Q['welfare'] || 0) < 0) ) { Q['workers_spd'] = (Q['workers_spd'] || 0) - 4; } \\n if (((Q['welfare'] || 0) < 0) ) { Q['unemployed_spd'] = (Q['unemployed_spd'] || 0) - 5; } \\nQ['pro_republic'] = (Q['pro_republic'] || 0) - 4;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) - 8;\\nQ['budget'] = (Q['budget'] || 0) + 1;\\nQ['inflation'] = (Q['inflation'] || 0) - 2;\"}],\"content\":{\"content\":\"We try to convince the workers that this policy is necessary in order to maintain a stable parliamentary government, and to deal with the fiscal consequences of the depression. Still, this policy provides excellent recruiting fodder for Nazis and Communists.\",\"type\":\"paragraph\"}},\"emergency_cuts\":{\"id\":\"emergency_cuts\",\"type\":\"scene\",\"title\":\"Emergency budget cuts\",\"subtitle\":{\"content\":[\"Chancellor \",{\"type\":\"insert\",\"insert\":0},\" proposes significant cuts to social spending.\"],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor'] || 0);\"}}]},\"newPage\":true,\"viewIf\":{\"$code\":\"return ((((((((((((Q['year'] || 0) == 1929) || ((Q['year'] || 0) == 1930)) || ((Q['year'] || 0) == 1931)) || ((Q['year'] || 0) == 1932))) && ((Q['month'] || 0) >= 12)) && (Q['chancellor'] == \\\"Brüning\\\")) && ((Q['spd_in_government'] || 0) == 0)) && ((((Q['unemployed'] || 0) > 15) || ((((Q['year'] || 0) == 1929) && ((Q['unemployed'] || 0) > 10)))))) && ((Q['welfare'] || 0) >= 0)) && ((Q['emergency_cuts_timer'] || 0)===0));\"},\"onArrival\":[{\"$code\":\"Q['emergency_cuts_seen'] = 1;\\nQ['emergency_cuts_timer'] = 12;\"}],\"tags\":[\"event\"],\"maxVisits\":4,\"options\":[{\"id\":\"@emergency_cuts.nothing_to_do\",\"title\":\"There is nothing we can do.\"},{\"id\":\"@emergency_cuts.vote_no\"},{\"id\":\"@emergency_cuts.vote_yes\"}],\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"Emergency budget cuts\"},{\"type\":\"paragraph\",\"content\":[\"Due to the crisis of the Great Depression, government budgets have fallen and welfare spending has risen substantially. Chancellor \",{\"type\":\"insert\",\"insert\":0},\" has used Article 48 of the constitution in order to pass an emergency bill cutting welfare spending.\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":[\"If we reject this, it would mean the end of the toleration agreement, and \",{\"type\":\"insert\",\"insert\":2},\" would likely dissolve the Reichstag and call new elections. Of course, the workers are opposed to this policy, although it might be necessary for economic and political stability.\"],\"predicate\":1}}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['spd_toleration'] || 0)) !== 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor'] || 0);\"}}]},\"countVisitsMax\":4},\"high_inflation.price_controls\":{\"id\":\"high_inflation.price_controls\",\"onArrival\":[{\"$code\":\"Q['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) + 3;\\nQ['inflation'] = (Q['inflation'] || 0) - 3;\\nQ['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1;\\nQ['unemployed'] = (Q['unemployed'] || 0) + 1;\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) - 4;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) - 3;\\nQ['rural_spd'] = (Q['rural_spd'] || 0) - 5;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 2;\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + 3;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) + 6;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 6;\\nQ['z_relation'] = (Q['z_relation'] || 0) - 4;\\nQ['ddp_relation'] = (Q['ddp_relation'] || 0) - 4;\"}],\"content\":{\"content\":\"Price controls are very unpopular with the bourgeoisie and their representatives, as well as rural producers, while wage controls hurt organized workers. However, the policies do stem the tide of inflation, at least somewhat.\",\"type\":\"paragraph\"}},\"election_1928.post_election_1928\":{\"id\":\"election_1928.post_election_1928\",\"onArrival\":[{\"$code\":\"// set old results\\n// election threshold constitutional reform\\n// banning parties\\nvar new_party_sum = 0;\\nfor (var party of Q.parties) {\\n    Q['old_' + party + '_r'] = Q[party + '_r'];\\n    if (Q.constitutional_reform > 0) {\\n        if (Q[party + '_votes'] < Q.electoral_threshold || (Q.electoral_threshold > 1 && party == 'other') || Q[party + '_banned']) {\\n            Q[party + '_r'] = 0;\\n        } else {\\n            Q[party + '_r'] = Q[party + '_votes'];\\n        }\\n        new_party_sum += Q[party + '_r'];\\n    } else {\\n        Q[party + '_r'] = Q[party + '_votes'];\\n    }\\n    Q['change_' + party + '_r'] = Q[party + '_r'] - Q['old_' + party + '_r'];\\n    var sign = Q['change_' + party + '_r'] > 0 ? '+'  : '';\\n    Q['str_change_' + party] = sign + Q['change_' + party + '_r'];//.toFixed(1);\\n}\\n// calculate new party sum if electoral reform\\nif (Q.electoral_threshold && Q.electoral_threshold > 0) {\\n    for (var party of Q.parties) {\\n        if (Q[party + '_r'] > 0) {\\n            Q[party + '_r'] = Math.round(Q[party + '_r']*100/new_party_sum);\\n        }\\n        Q['change_' + party + '_r'] = Q[party + '_r'] - Q['old_' + party + '_r'];\\n        var sign = Q['change_' + party + '_r'] > 0 ? '+'  : '';\\n        Q['str_change_' + party] = sign + Q['change_' + party + '_r'];//.toFixed(1);\\n    }\\n}\\n\\n// get change arrows and signs\\n\\n\\n// The largest party can only be the NSDAP or the SPD.\\nQ.largest_party = 'SPD';\\nif (Q.nsdap_r >= Q.spd_r && Q.nsdap_r >= Q.kpd_r) {\\n    Q.largest_party = 'NSDAP';\\n}\\nif (Q.kpd_r >= Q.spd_r && Q.kpd_r >= Q.nsdap_r) {\\n    Q.largest_party = 'KPD';\\n}\\n\\n// coalitions\\nQ.weimar_coalition = Q.spd_r + Q.ddp_r + Q.z_r - 3;\\nQ.grand_coalition = Q.spd_r + Q.ddp_r + Q.z_r + Q.dvp_r;\\nQ.bourgeois_coalition = Q.ddp_r + Q.z_r + Q.dvp_r + Q.other_r;\\nQ.center_right_coalition = Q.z_r + Q.ddp_r + Q.dvp_r + Q.other_r + Q.dnvp_r;\\nQ.right_coalition = Q.z_r + Q.dvp_r + Q.other_r + Q.dnvp_r;\\nQ.far_right_coalition = Q.dnvp_r + Q.nsdap_r;\\nQ.left_coalition = Q.spd_r + Q.kpd_r + Q.sapd_r;\\n// this is an absurd concept lol\\nQ.popular_front_coalition = Q.spd_r + Q.kpd_r + Q.z_r + Q.ddp_r - 3 + Q.sapd_r;\\nQ.anti_democratic_coalition = Q.kpd_r + Q.nsdap_r + Q.dnvp_r;\\n// aka everyone except nazi, kpd, dnvp\\nQ.neo_weimar_coalition = Q.spd_r + Q.ddp_r + Q.z_r + Q.dvp_r + Q.other_r;\\n// Hitler + Right-wing parties (only comes into effect if you've alienated Z too badly)\\nQ.hitler_right_coalition = Q.z_r + Q.dnvp_r + Q.nsdap_r;\\n// Progressive coalition isn't going to be implemented as a distinct coalition but it's the coalition that lets you pass improved women's rights/gay rights\\nQ.progressive_coalition = Q.spd_r + Q.kpd_r + Q.ddp_r + Q.sapd_r;\\n\\nif (Q.kpd_relation >= 30) {\\n    Q.weimar_coalition += Q.sapd_r;\\n}\\n\\nQ.leverage = Q.spd_r;\\n\\nQ.grand_coalition_failed = 0;\\n// Reset government and ministers... Based on Brüning's 1930 govt\\nQ.coalition_dissent = 0;\\nQ.kpd_coalition_dissent = 0;\\nQ.spd_in_government = 0;\\nQ.in_weimar_coalition = 0;\\nQ.in_grand_coalition = 0;\\nQ.in_left_front = 0;\\nQ.in_popular_front = 0;\\nQ.in_emergency_government = 0;\\nQ.in_minority_government = 0;\\nQ.in_unity_government = 0;\\nQ.spd_toleration = 0;\\nQ.spd_caretaker = 0;\\nQ.foreign_minister_party = 'DVP';\\nQ.interior_minister_party = 'Z';\\nQ.justice_minister_party = 'I';\\nQ.labor_minister_party = 'Z';\\nQ.reichswehr_minister_party = 'I';\\nQ.economic_minister_party = 'DDP';\\nQ.finance_minister_party = 'DVP';\\nQ.agriculture_minister_party = 'Z';\\n\\n// reset KPD goals\\nQ.kpd_goals_seen = 0;\\nQ.kpd_ultimatum_seen = 0;\\nQ.welfare_goal = 0;\\nQ.agriculture_goal = 0;\\nQ.economy_goal = 0;\\nQ.finance_goal = 0;\\nQ.labor_goal = 0;\\nQ.foreign_goal = 0;\\nQ.interior_goal = 0;\\nQ.reichswehr_goal = 0;\\n\\nQ.welfare_goal_completed = 0;\\nQ.agriculture_goal_completed = 0;\\nQ.economy_goal_completed = 0;\\nQ.finance_goal_completed = 0;\\nQ.labor_goal_completed = 0;\\nQ.foreign_goal_completed = 0;\\nQ.interior_goal_completed = 0;\\nQ.reichswehr_goal_completed = 0;\\n\\nQ.strike_term_seen = 0;\\n\\nQ.z_minus_bvp_r = Q.z_r - 3;\\n\\nvar election_result = {'date': new Date(Q.year, Q.month - 1)};\\nfor (var party of Q.parties) {\\n    election_result[party] = Q[party + '_r'];\\n}\\nQ.election_records.push(election_result);\"}],\"onDeparture\":[{\"$code\":\"if (((((Q['nazi_urgency'] || 0) == 0) && ((Q['nsdap_r'] || 0) >= 15))) ) { Q['nazi_urgency'] = 1; }\"}],\"onDisplay\":[{\"$code\":\"data = [\\n    {\\n        \\\"id\\\": \\\"kpd\\\",\\n        \\\"legend\\\": \\\"KPD\\\",\\n        \\\"name\\\": \\\"KPD\\\",\\n        \\\"seats\\\": Math.round(Q.kpd_r*5),\\n    }\\n];\\nif (Q.sapd_formed && Q.sapd_r) {\\n    data.push({\\n            \\\"id\\\": \\\"sapd\\\",\\n            \\\"legend\\\": \\\"SAPD\\\",\\n            \\\"name\\\": \\\"SAPD\\\",\\n            \\\"seats\\\": Math.round(Q.sapd_r*5),\\n            });\\n}\\ndata = data.concat([\\n    {\\n        \\\"id\\\": \\\"spd\\\",\\n        \\\"legend\\\": \\\"SPD\\\",\\n        \\\"name\\\": \\\"SPD\\\",\\n        \\\"seats\\\": Math.round(Q.spd_r*5),\\n    },\\n    {\\n        \\\"id\\\": \\\"ddp\\\",\\n        \\\"legend\\\": \\\"DDP\\\",\\n        \\\"name\\\": \\\"DDP\\\",\\n        \\\"seats\\\": Math.round(Q.ddp_r*5),\\n    },\\n    {\\n        \\\"id\\\": \\\"z\\\",\\n        \\\"legend\\\": \\\"Center\\\",\\n        \\\"name\\\": \\\"Center\\\",\\n        \\\"seats\\\": Math.round((Q.z_r - 3)*5),\\n    },\\n    {\\n        \\\"id\\\": \\\"bvp\\\",\\n        \\\"legend\\\": \\\"BVP\\\",\\n        \\\"name\\\": \\\"BVP\\\",\\n        \\\"seats\\\": Math.round(3*5),\\n    },\\n    {\\n        \\\"id\\\": \\\"dvp\\\",\\n        \\\"legend\\\": \\\"DVP\\\",\\n        \\\"name\\\": \\\"DVP\\\",\\n        \\\"seats\\\": Math.round(Q.dvp_r*5),\\n    },\\n    {\\n        \\\"id\\\": \\\"other\\\",\\n        \\\"legend\\\": \\\"Other\\\",\\n        \\\"name\\\": \\\"Other\\\",\\n        \\\"seats\\\": Math.round(Q.other_r*5),\\n    },\\n    {\\n        \\\"id\\\": \\\"dnvp\\\",\\n        \\\"legend\\\": \\\"DNVP\\\",\\n        \\\"name\\\": \\\"DNVP\\\",\\n        \\\"seats\\\": Math.round(Q.dnvp_r*5),\\n    },\\n    {\\n        \\\"id\\\": \\\"nsdap\\\",\\n        \\\"legend\\\": \\\"NSDAP\\\",\\n        \\\"name\\\": \\\"NSDAP\\\",\\n        \\\"seats\\\": Math.round(Q.nsdap_r*5),\\n    },\\n]);\\n\\nif (window && d3) {\\n    var width = 500;\\n    var height = 500;\\n    var screenWidth = document.getElementById('content').offsetWidth;\\n    if (screenWidth < width - 50) {\\n        width = screenWidth - 50;\\n        height = width;\\n        document.getElementById(\\\"reichstag\\\").style.height = screenWidth/2 + \\\"px\\\";\\n    }\\n\\n    var parliament = d3.parliament();\\n    parliament.width(width).height(height).innerRadiusCoef(0.4);\\n    parliament.enter.fromCenter(true).smallToBig(true);\\n    parliament.exit.toCenter(false).bigToSmall(true);\\n    d3.select(\\\"#reichstag\\\").datum(data).call(parliament);\\n}\"}],\"goTo\":[{\"id\":\"election_1928.coalition_menu\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"Election results:\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<svg id=\\\"reichstag\\\" style=\\\"width: 500px; height: 250px;\\\"> </svg>\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<table>\"},\"  \",{\"type\":\"magic\",\"content\":\"<tr><td>Party</td><td>Vote share</td><td>% Change</td></tr>\"},\" \",{\"type\":\"magic\",\"content\":\"<tr><td><div class=\\\"box\\\" style='background-color:#E3000F; outline: 2px; outline-style: solid;'> </div> \"},\" \",{\"type\":\"emphasis-2\",\"content\":\"SPD:\"},\" \",{\"type\":\"magic\",\"content\":\"</td><td>\"},\" \",{\"type\":\"emphasis-2\",\"content\":[{\"type\":\"insert\",\"insert\":0},\"%\"]},\" \",{\"type\":\"magic\",\"content\":\"</td><td>\"},\" \",{\"type\":\"emphasis-2\",\"content\":{\"type\":\"insert\",\"insert\":1}},\" \",{\"type\":\"magic\",\"content\":\"</td></tr>\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"magic\",\"content\":\"<tr><td><div class=\\\"box\\\" style='background-color:#C40000'> </div> \"},\"SAPD: \",{\"type\":\"magic\",\"content\":\"</td><td>\"},\" \",{\"type\":\"insert\",\"insert\":3},\"% \",{\"type\":\"magic\",\"content\":\"</td><td>\"},\" \",{\"type\":\"insert\",\"insert\":4},\" \",{\"type\":\"magic\",\"content\":\"</td></tr>\"},\" \"],\"predicate\":2},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<tr><td><div class=\\\"box\\\" style='background-color:#8B0000'> </div> \"},\"KPD: \",{\"type\":\"magic\",\"content\":\"</td><td>\"},\" \",{\"type\":\"insert\",\"insert\":5},\"% \",{\"type\":\"magic\",\"content\":\"</td><td>\"},\" \",{\"type\":\"insert\",\"insert\":6},\" \",{\"type\":\"magic\",\"content\":\"</td></tr>\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<tr><td><div class=\\\"box\\\" style='background-color:#DCCA4A'> </div> \"},\" DDP: \",{\"type\":\"magic\",\"content\":\"</td><td>\"},\" \",{\"type\":\"insert\",\"insert\":7},\"% \",{\"type\":\"magic\",\"content\":\"</td><td>\"},\" \",{\"type\":\"insert\",\"insert\":8},\" \",{\"type\":\"magic\",\"content\":\"</td></tr>\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<tr><td><div class=\\\"box\\\" style='background-color:#000'> </div> \"},\" Z: \",{\"type\":\"magic\",\"content\":\"</td><td>\"},\" \",{\"type\":\"insert\",\"insert\":9},\"% \",{\"type\":\"magic\",\"content\":\"</td><td>\"},\" \",{\"type\":\"insert\",\"insert\":10},\" \",{\"type\":\"magic\",\"content\":\"</td></tr>\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<tr><td><div class=\\\"box\\\" style='background-color:#69A2BE'> </div> \"},\" BVP: \",{\"type\":\"magic\",\"content\":\"</td><td>\"},\" 3% \",{\"type\":\"magic\",\"content\":\"</td><td>\"},\" 0 \",{\"type\":\"magic\",\"content\":\"</td></tr>\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<tr><td><div class=\\\"box\\\" style='background-color:#D5AC27'> </div> \"},\" DVP: \",{\"type\":\"magic\",\"content\":\"</td><td>\"},\" \",{\"type\":\"insert\",\"insert\":11},\"% \",{\"type\":\"magic\",\"content\":\"</td><td>\"},\" \",{\"type\":\"insert\",\"insert\":12},\" \",{\"type\":\"magic\",\"content\":\"</td></tr>\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<tr><td><div class=\\\"box\\\" style='background-color:#a0a0a0'> </div> \"},\" Others: \",{\"type\":\"magic\",\"content\":\"</td><td>\"},\" \",{\"type\":\"insert\",\"insert\":13},\" % \",{\"type\":\"magic\",\"content\":\"</td><td>\"},\" \",{\"type\":\"insert\",\"insert\":14},\" \",{\"type\":\"magic\",\"content\":\"</td></tr>\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<tr><td><div class=\\\"box\\\" style='background-color:#3f7bc1'> </div> \"},\" DNVP: \",{\"type\":\"magic\",\"content\":\"</td><td>\"},\" \",{\"type\":\"insert\",\"insert\":15},\"% \",{\"type\":\"magic\",\"content\":\"</td><td>\"},\" \",{\"type\":\"insert\",\"insert\":16},\" \",{\"type\":\"magic\",\"content\":\"</td></tr>\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<tr><td><div class=\\\"box\\\" style='background-color:#954B00'> </div> \"},\" NSDAP: \",{\"type\":\"magic\",\"content\":\"</td><td>\"},\" \",{\"type\":\"insert\",\"insert\":17},\"% \",{\"type\":\"magic\",\"content\":\"</td><td>\"},\" \",{\"type\":\"insert\",\"insert\":18},\" \",{\"type\":\"magic\",\"content\":\"</td></tr>\"},\" \",{\"type\":\"magic\",\"content\":\"</table>\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"Potential coalitions:\"},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Weimar Coalition (SPD + Z + DDP): \",{\"type\":\"insert\",\"insert\":19},\"%\"]},{\"type\":\"paragraph\",\"content\":[\"Grand Coalition (SPD + Z + BVP + DDP + DVP): \",{\"type\":\"insert\",\"insert\":20},\"%\"]},{\"type\":\"paragraph\",\"content\":[\"Bourgeois Coalition (Z + BVP + DDP + DVP + Others): \",{\"type\":\"insert\",\"insert\":21},\"%\"]},{\"type\":\"paragraph\",\"content\":[\"Right-wing Coalition (Z + BVP + DVP + Others + DNVP): \",{\"type\":\"insert\",\"insert\":22},\"%\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"The rapid rise in NSDAP votes is extremely worrying. Many had believed that the party was moribound; now, some of us consider it to be the greatest threat to democracy in Germany. \",\"predicate\":23},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"Together, the anti-democratic KPD, DNVP, and NSDAP have a majority in the Reichstag. A stable governing majority will be almost impossible. \",\"predicate\":24},\"\"]},{\"type\":\"paragraph\",\"content\":\"There are some potential coalition arrangements.\"}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['spd_r'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['str_change_spd'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['sapd_formed'] || 0)) !== 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['sapd_r'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['str_change_sapd'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['kpd_r'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['str_change_kpd'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['ddp_r'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['str_change_ddp'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['z_minus_bvp_r'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['str_change_z'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['dvp_r'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['str_change_dvp'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['other_r'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['str_change_other'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['dnvp_r'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['str_change_dnvp'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['nsdap_r'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['str_change_nsdap'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['weimar_coalition'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['grand_coalition'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['bourgeois_coalition'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['right_coalition'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['nazi_urgency'] || 0) <= 1) && ((Q['nsdap_r'] || 0) >= 15));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['anti_democratic_coalition'] || 0) >= 50);\"}}]}},\"kpd_policy.labor_oppose\":{\"id\":\"kpd_policy.labor_oppose\",\"onArrival\":[{\"$code\":\"Q['kpd_coalition_dissent'] = (Q['kpd_coalition_dissent'] || 0) + 1;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 5;\\nQ['workers_kpd'] = (Q['workers_kpd'] || 0) + 5;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) - 6;\"}],\"content\":{\"content\":\"We oppose the KPD's policy, and prevent it from being enacted. The KPD is displeased, as are the workers who would have stood to benefit.\",\"type\":\"paragraph\"}},\"kpd_ultimatum.goals_success\":{\"id\":\"kpd_ultimatum.goals_success\",\"onArrival\":[{\"$code\":\"Q['workers_spd'] = (Q['workers_spd'] || 0) + 8;\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + 8;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) + 10;\\nQ['workers_kpd'] = (Q['workers_kpd'] || 0) + 5;\\nQ['kpd_coalition_success'] = (Q['kpd_coalition_success'] || 0) + 1;\"}],\"goTo\":[{\"id\":\"kpd_ultimatum.popular_front_achievement\",\"predicate\":{\"$code\":\"return (((Q['in_popular_front'] || 0)) !== 0);\"}},{\"id\":\"kpd_ultimatum.united_front_achievement\",\"predicate\":{\"$code\":\"return (((Q['in_left_front'] || 0)) !== 0);\"}}],\"content\":{\"content\":\"Against all expectations, the KPD's goals have all been met! Apparently the Communists did not prepare for this eventuality, a worker's government successfully built through democratic means. They will continue to \\\"tolerate\\\" our government for the rest of our term, while still acting as a watchdog against bourgeois backsliding.\",\"type\":\"paragraph\"}},\"labor_unrest.balance\":{\"id\":\"labor_unrest.balance\",\"subtitle\":\"Both sides need to share the pain in the current crisis.\",\"onArrival\":[{\"$code\":\"Q['labor_dissent'] = (Q['labor_dissent'] || 0) + 4;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 2;\\nQ['kpd_coalition_dissent'] = (Q['kpd_coalition_dissent'] || 0) + 1;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) - 5;\\nQ['workers_kpd'] = (Q['workers_kpd'] || 0) + 2;\"}],\"content\":{\"content\":\"Many workers are unhappy at our compromises, but they will learn to accept that we are all in a shared struggle against economic forces. This is perhaps the best we could do given the present circumstances.\",\"type\":\"paragraph\"}},\"labor_unrest\":{\"id\":\"labor_unrest\",\"type\":\"scene\",\"title\":\"Labor Unrest\",\"subtitle\":\"Clashes between workers and employers in the Ruhr...\",\"viewIf\":{\"$code\":\"return (((((Q['year'] || 0)===1928) && ((Q['month'] || 0)===12)) && (((Q['spd_in_government'] || 0)) !== 0)) && (Q['labor_minister_party'] != \\\"SPD\\\"));\"},\"maxVisits\":1,\"newPage\":true,\"tags\":[\"event\"],\"options\":[{\"id\":\"@labor_unrest.support_labor\",\"title\":\"Support labor in their demands.\"},{\"id\":\"@labor_unrest.support_employers\",\"title\":\"Support the employers in their demands.\"},{\"id\":\"@labor_unrest.balance\",\"title\":\"Try to strike a compromise between the sides.\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Labor Unrest\"},{\"type\":\"paragraph\",\"content\":\"The mining and metals industry of the Ruhr region is beset by a wave of strikes against cuts to wages and benefits. Meanwhile, employers have started a retaliatory lockout to force their workers to accept these cuts. Both the strikers and the employers look to the SPD in the government to resolve this crisis.\"}],\"countVisitsMax\":1},\"kpd_vote_of_no_confidence.thalmann\":{\"id\":\"kpd_vote_of_no_confidence.thalmann\",\"chooseIf\":{\"$code\":\"return (Q['president'] == \\\"Braun\\\");\"},\"subtitle\":\"This would be pretext for a right-wing coup.\",\"unavailableSubtitle\":{\"content\":{\"type\":\"conditional\",\"content\":\"President Hindenburg would never allow this.\",\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['president'] == \\\"Hindenburg\\\");\"}}]},\"onArrival\":[{\"$code\":\"Q['chancellor'] = \\\"Thälmann\\\";\\nQ['chancellor_party'] = \\\"KPD\\\";\"}],\"options\":[{\"id\":\"@civil_war\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[\"With great reluctance, President \",{\"type\":\"insert\",\"insert\":0},\" appoints \",{\"type\":\"insert\",\"insert\":1},\" as chancellor.\"]},{\"type\":\"paragraph\",\"content\":[\"Immediately, \",{\"type\":\"insert\",\"insert\":2},\" goes to work building a \\\"Soviet Germany\\\": consolidating as much power as possible in the KPD, purging state institutions of anti-communists, and sending street fighters against the \\\"enemies of the people\\\".\"]},{\"type\":\"paragraph\",\"content\":[\"In response to \",{\"type\":\"insert\",\"insert\":3},\" being appointed Chancellor, the right-wing forces launches almost immediately launch an attempted coup. Troops of the Stahlhelm and Nazi SA enter Berlin and immediately begin clashing with our supporters! Reactionary officers within the Reichswehr have taken their troops out of the barracks and joined them with the Stahlhelm to stop the KPD from taking power. We are forced to be on the same side as the KPD, whether we want to or not.\"]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['president'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor'] || 0);\"}}]}},\"march_on_berlin.accept_election\":{\"id\":\"march_on_berlin.accept_election\",\"onArrival\":[{\"$code\":\"if (((Q['next_election_time'] || 0) > ((Q['time'] || 0) + 1)) ) { Q['next_election_time'] = ((Q['time'] || 0) + 1); } \\n if (((Q['next_election_time'] || 0) >= ((Q['time'] || 0) + 1)) ) { Q['next_election_month'] = ((Q['month'] || 0) + 1); } \\n if (((Q['next_election_time'] || 0) >= ((Q['time'] || 0) + 1)) ) { Q['next_election_year'] = (Q['year'] || 0); } \\n if (((Q['next_election_month'] || 0) > 12) ) { Q['next_election_year'] = (Q['next_election_year'] || 0) + 1; } \\n if (((Q['next_election_month'] || 0) > 12) ) { Q['next_election_month'] = (Q['next_election_month'] || 0) - 12; } \\nQ['old_middle_nsdap'] = (Q['old_middle_nsdap'] || 0) + 10;\\nQ['new_middle_nsdap'] = (Q['new_middle_nsdap'] || 0) + 10;\\nQ['workers_nsdap'] = (Q['workers_nsdap'] || 0) + 10;\\nQ['rural_nsdap'] = (Q['rural_nsdap'] || 0) + 10;\\nQ['unemployed_nsdap'] = (Q['unemployed_nsdap'] || 0) + 8;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 10;\\nQ['workers_kpd'] = (Q['workers_kpd'] || 0) - 10;\\nQ['sa_strength'] = (Q['sa_strength'] || 0) + 100;\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"President \",{\"type\":\"insert\",\"insert\":0},\" has called for emergency elections, to be held next month, under a caretaker government. The SA is permitted to act with impunity, intimidating voters into supporting the fascists.\"]},\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['president'] || 0);\"}}]}},\"panzerkreuzer.vote_no_chancellor\":{\"id\":\"panzerkreuzer.vote_no_chancellor\",\"goTo\":[{\"id\":\"panzerkreuzer.braun\",\"predicate\":{\"$code\":\"return (Q['chancellor'] == \\\"Braun\\\");\"}},{\"id\":\"panzerkreuzer.muller\",\"predicate\":{\"$code\":\"return (Q['chancellor'] == \\\"Müller\\\");\"}}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"constitutional_reform.vote_threshold_2\":{\"id\":\"constitutional_reform.vote_threshold_2\",\"chooseIf\":{\"$code\":\"return ((Q['reform_support'] || 0) >= (Q['pass_threshold'] || 0));\"},\"unavailableSubtitle\":{\"content\":[\"We do not have enough support for this policy. \",{\"type\":\"conditional\",\"content\":\"We should have an additional margin for the referendum since we need a majority of voters, and many voters who do not support the republic will not participate. \",\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"The Center Party does not trust us enough to support this policy.\",\"predicate\":1}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['pro_republic'] || 0) < 65);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['z_relation'] || 0) <= 30);\"}}]},\"onArrival\":[{\"$code\":\"Q['constitutional_reform'] = (Q['constitutional_reform'] || 0) + 1;\\nQ['electoral_threshold'] = 5;\\nQ['ddp_relation'] = (Q['ddp_relation'] || 0) - 25;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 25;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 20;\\nQ['workers_other'] = (Q['workers_other'] || 0) * 0.1;\\nQ['new_middle_other'] = (Q['new_middle_other'] || 0) * 0.1;\\nQ['old_middle_other'] = (Q['old_middle_other'] || 0) * 0.1;\\nQ['rural_other'] = (Q['rural_other'] || 0) * 0.2;\\nQ['unemployed_other'] = (Q['unemployed_other'] || 0) * 0.2;\\nQ['catholics_other'] = (Q['catholics_other'] || 0) * 0.1;\"}],\"achievement\":\"verfassungsreform\",\"content\":{\"content\":\"We have passed a constitutional amendment to increase the electoral threshold to 5%. This is likely to benefit the larger parties and harm the smaller ones.\",\"type\":\"paragraph\"}},\"popular_front_dispute.foreign\":{\"id\":\"popular_front_dispute.foreign\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"presidential_election_1932.support_braun\":{\"id\":\"presidential_election_1932.support_braun\",\"subtitle\":\"This will cost us 2 resources.\",\"chooseIf\":{\"$code\":\"return ((Q['resources'] || 0) >= 2);\"},\"unavailableSubtitle\":\"Not enough resources.\",\"onArrival\":[{\"$code\":\"Q['resources'] = (Q['resources'] || 0) - 2;\\nQ['braun_campaign'] = 1;\"}],\"goTo\":[{\"id\":\"presidential_election_1932.braun_campaign\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"It takes effort to run a somewhat unexpected campaign. First, Braun has to be convinced to run. He himself had supported voting for Hindenburg, and it takes a good deal of prodding to convince him of his destiny.\"},{\"type\":\"paragraph\",\"content\":\"The miniscule remnants of the Democratic Party (now called the German State Party) will likely support us. Who else will? Can we convince the Center to support Braun? What about the Communists?\"}]},\"prussian_coup.defend_2_victory\":{\"id\":\"prussian_coup.defend_2_victory\",\"onArrival\":[{\"$code\":\"Q['sa_strength'] = (Q['sa_strength'] || 0) * 0.8;\\nQ['sh_strength'] = (Q['sh_strength'] || 0) * 0.8;\\nQ['pro_republic'] = (Q['pro_republic'] || 0) + 10;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + 6;\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + 6;\\nQ['workers_nsdap'] = (Q['workers_nsdap'] || 0) - 6;\\nQ['unemployed_nsdap'] = (Q['unemployed_nsdap'] || 0) - 6;\\nQ['coup_victory'] = 1;\"}],\"achievement\":\"bollwerk_der_demokratie\",\"goTo\":[{\"id\":\"prussian_coup.defend_2_victory_2\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[\"Our forces confront the government troops and their reactionary auxiliaries, and somehow, our enemies retreat without a fight! They were overwhelmed by our display of strength, and have chosen to slink away. Chancellor \",{\"type\":\"insert\",\"insert\":0},\" withdraws the dismissal of the Prussian government, at least for now.\"]},{\"type\":\"paragraph\",\"content\":\"The show of force has reinvigorated support for the republic and for the SPD, and has weakened the fascists.\"}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor'] || 0);\"}}]}},\"reichsbanner_zentrum.keep_them\":{\"id\":\"reichsbanner_zentrum.keep_them\",\"unavailableSubtitle\":\"They are unable to be convinced at this time.\",\"chooseIf\":{\"$code\":\"return ((((Q['strife'] || 0) >= 5) && ((((Q['z_relation'] || 0) >= 50) || (((Q['z_party_leader'] == \\\"Joos\\\") && ((Q['z_relation'] || 0) >= 30)))))) && ((Q['ddp_relation'] || 0) >= 50));\"},\"onArrival\":[{\"$code\":\"Q['rb_stay'] = 1;\"}],\"content\":{\"content\":\"Seeing the strife that has filled Germany's streets, the Center Party and DDP seem to be convinced that it is necessary for the Reichsbanner to be militarized, and will not leave the organization.\",\"type\":\"paragraph\"}},\"reichsbanner_zentrum\":{\"id\":\"reichsbanner_zentrum\",\"type\":\"scene\",\"title\":\"Exodus from the Reichsbanner\",\"subtitle\":\"Owing to its militarization, he Center Party and DDP are leaving the Reichsbanner.\",\"viewIf\":{\"$code\":\"return ((((Q['rb_militancy'] || 0) >= 0.2) && (!(((Q['rb_exit'] || 0)) !== 0))) && (!(((Q['rb_stay'] || 0)) !== 0)));\"},\"newPage\":true,\"tags\":[\"event\"],\"options\":[{\"id\":\"@reichsbanner_zentrum.let_go\",\"title\":\"Let the centrists and liberals go.\"},{\"id\":\"@reichsbanner_zentrum.lower_militancy\",\"title\":\"We must lower the Reichsbanner's militancy.\"},{\"id\":\"@reichsbanner_zentrum.keep_them\",\"title\":\"Can we convince them that a militant Reichsbanner is necessary for defending the Republic?\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Exodus from the Reichsbanner\"},{\"type\":\"paragraph\",\"content\":\"The Reichsbanner has become increasingly militarized as of late, with ever-greater quantities of arms and paramilitary training, as well as a stream of radicalized SPD members. In response, the members associated with the other Weimar parties, the Center Party and DDP, are threatening to leave for good. They signed up for a mass movement to defend the republic, not a socialist militia.\"}]},\"panzerkreuzer_b.abstain\":{\"id\":\"panzerkreuzer_b.abstain\",\"onArrival\":[{\"$code\":\"Q['dvp_relation'] = (Q['dvp_relation'] || 0) - 5;\\nQ['z_relation'] = (Q['z_relation'] || 0) - 3;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 5;\\n if ((!(((Q['panzerkreuzer_funded'] || 0)) !== 0)) ) { Q['labor_dissent'] = (Q['labor_dissent'] || 0) + 5; } \\nQ['panzerkreuzer_b_funded'] = 1;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) - 3;\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"The center-right parties are critical of our decision to abstain, and the pressure from our left flank is not entirely assuaged. Despite our abstention, the vote in the Reichstag passes, with all parties in favor except the SPD and KPD. The ship will be built.\"},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":\"Given the construction of the previous battlecruiser, this seemed to be a foregone conclusion, and the reaction is muted.\",\"predicate\":0}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['panzerkreuzer_funded'] || 0)) !== 0);\"}}]}},\"schacht_vs_hilferding.hilferding_resign\":{\"id\":\"schacht_vs_hilferding.hilferding_resign\",\"onArrival\":[{\"$code\":\"if ((((Q['in_grand_coalition'] || 0)) !== 0) ) { Q['finance_minister_party'] = \\\"DVP\\\"; } \\n if ((((((Q['in_weimar_coalition'] || 0)) !== 0) || (((Q['in_popular_front'] || 0)) !== 0)) || (((Q['in_left_front'] || 0)) !== 0)) ) { Q['finance_minister_party'] = \\\"I\\\"; } \\nQ['finance_minister'] = \\\"Moldenhauer\\\";\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"With no other choice, Hilferding has resigned as Finance Minister, to be replaced by a \",{\"type\":\"conditional\",\"content\":\"center-right \",\"predicate\":0},{\"type\":\"conditional\",\"content\":\"technocratic \",\"predicate\":1},\" candidate.\"]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['in_grand_coalition'] || 0)) !== 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (!(((Q['in_grand_coalition'] || 0)) !== 0));\"}}]}},\"schacht_vs_hilferding\":{\"id\":\"schacht_vs_hilferding\",\"type\":\"scene\",\"title\":\"Hjalmar Schacht against Hilferding\",\"newPage\":true,\"viewIf\":{\"$code\":\"return ((((((Q['year'] || 0)===1929) && ((Q['month'] || 0) >= 11)) && ((Q['spd_in_government'] || 0)===1)) && (Q['finance_minister'] == \\\"Hilferding\\\")) && (Q['finance_minister_party'] == \\\"SPD\\\"));\"},\"tags\":[\"event\"],\"maxVisits\":1,\"faceImage\":\"img/portraits/SchachtHjalmar.jpg\",\"options\":[{\"id\":\"@schacht_vs_hilferding.expose_him\",\"title\":\"Expose his reactionary dealings!\"},{\"id\":\"@schacht_vs_hilferding.work_with\",\"title\":\"Work with him to shape the budget.\"},{\"id\":\"@schacht_vs_hilferding.hilferding_resign\",\"title\":\"Hilferding must resign.\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Schacht against Hilferding\"},{\"type\":\"paragraph\",\"content\":\"Reichsbank president Hjalmar Schacht has criticized Finance Minister Hilferding of the SPD for his budget, which he claims is unbalanced and contains too much social welfare and not enough tax cuts for top earners and businesses. More importantly, he is refusing to release loans necessary for the functioning of the government unless Hilferding either massively changes his budget or resigns.\"},{\"type\":\"paragraph\",\"content\":\"Of course, this criticism is unfounded, but the bourgeois establishment does not care.\"}],\"countVisitsMax\":1},\"unemployment_insurance_1.what_do\":{\"id\":\"unemployment_insurance_1.what_do\",\"onArrival\":[{\"$code\":\"if ((Q['chancellor'] == \\\"Braun\\\") ) { Q['dvp_relation'] = (Q['dvp_relation'] || 0) + 5; }\"}],\"options\":[{\"id\":\"@unemployment_insurance_1.destroy\",\"title\":\"Fine. We will end this coalition.\"},{\"id\":\"@unemployment_insurance_1.accept\",\"title\":\"Unfortunately, we must accept the Right's demands for the sake of stability.\"},{\"id\":\"@unemployment_insurance_1.compromise\",\"title\":\"Surely there is some compromise to be had?\"}],\"content\":{\"content\":\"But the crux of the matter is, what can we do?\",\"type\":\"paragraph\"}},\"unemployment_insurance_weimar.balance\":{\"id\":\"unemployment_insurance_weimar.balance\",\"subtitle\":{\"content\":[\"Neither workers nor employers will be entirely satisfied or dissatisfied. \",{\"type\":\"conditional\",\"content\":\"The DVP will likely consider the compromise unacceptable. \",\"predicate\":0},{\"type\":\"conditional\",\"content\":\"The DVP might grudgingly accept the compromise for now.\",\"predicate\":1}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['in_grand_coalition'] || 0)) !== 0) && ((Q['dvp_relation'] || 0) < 30));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['in_grand_coalition'] || 0)) !== 0) && ((Q['dvp_relation'] || 0) >= 30));\"}}]},\"onArrival\":[{\"$code\":\"Q['workers_spd'] = (Q['workers_spd'] || 0) - 4;\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) - 5;\\nQ['workers_kpd'] = (Q['workers_kpd'] || 0) + 4;\\nQ['unemployed_kpd'] = (Q['unemployed_kpd'] || 0) + 3;\\nQ['unemployed_nsdap'] = (Q['unemployed_nsdap'] || 0) + 3;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 10;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) + 8;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) + 5;\\nQ['welfare'] = (Q['welfare'] || 0) - 1;\\nQ['budget'] = (Q['budget'] || 0) + 1;\\nQ['month'] = (Q['month'] || 0) + 1;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) - 4;\\nQ['inflation'] = (Q['inflation'] || 0) - 1;\\nQ['unemployment_insurance_threshold'] = (Q['unemployed'] || 0);\\nQ['unemployment_insurance_timer'] = 10;\\n if (((((Q['in_grand_coalition'] || 0)) !== 0) && ((Q['dvp_relation'] || 0) < 30)) ) { Q['coalition_dissent'] = 2; } \\n if ((((Q['in_grand_coalition'] || 0)) !== 0) ) { Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1; }\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"Neither side is entirely satisfied by our compromise solution. Many of the workers and unemployed see this as a betrayal, although we present it as the successful aversion of a much worse alternative. \",{\"type\":\"conditional\",\"content\":\"Meanwhile, the DVP is aghast at the prospect of raising any taxes on businesses at all.\",\"predicate\":0}]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['in_grand_coalition'] || 0)) !== 0);\"}}]}},\"unemployment_insurance_weimar\":{\"id\":\"unemployment_insurance_weimar\",\"type\":\"scene\",\"title\":\"Unemployment Insurance Crisis\",\"subtitle\":\"Our unemployment insurance programs need additional funding...\",\"newPage\":true,\"viewIf\":{\"$code\":\"return (((((((Q['spd_in_government'] || 0)===1) && (((((Q['year'] || 0)===1930) || ((Q['year'] || 0)===1931)) || ((Q['year'] || 0)===1932)))) && ((Q['month'] || 0) == 3)) && (((((Q['spd_in_government'] || 0)) !== 0) && (((((Q['in_grand_coalition'] || 0)===0) || (((Q['constructive_vonc'] || 0)) !== 0)) || (Q['president'] == \\\"Braun\\\")))))) && ((Q['unemployment_insurance_timer'] || 0)===0)) && ((Q['unemployed'] || 0) >= ((Q['unemployment_insurance_threshold'] || 0) + 4)));\"},\"onArrival\":[{\"$code\":\"Q['unemployment_insurance_crisis'] = (Q['unemployment_insurance_crisis'] || 0) + 1;\\n if (((Q['budget'] || 0) >= 1) ) { Q['budget'] = (Q['budget'] || 0) - 1; } \\nQ['unemployment_insurance_timer'] = 8;\\nQ['crisis_urgency'] = (Q['crisis_urgency'] || 0) + 1;\\nQ['unemployment_insurance_threshold'] = (Q['unemployed'] || 0);\"}],\"tags\":[\"event\"],\"maxVisits\":2,\"options\":[{\"id\":\"@unemployment_insurance_weimar.cut_benefits\",\"title\":\"Cut benefits.\"},{\"id\":\"@unemployment_insurance_weimar.increase_employers\",\"title\":\"Increase employer contributions.\"},{\"id\":\"@unemployment_insurance_weimar.balance\",\"title\":\"Increase both employer and employee contributions.\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Unemployment Insurance Crisis\"},{\"type\":\"paragraph\",\"content\":\"The economic crisis has caused mass layoffs all throughout Germany, affecting the industrial working class the hardest. Our welfare spending is increasing due to the greater need.\"},{\"type\":\"paragraph\",\"content\":\"In the midst of all this, our unemployment insurance program is underfunded; the program was never budgeted for this much unemployment. We have to either increase funding or cut benefits.\"}],\"countVisitsMax\":2},\"vote_of_no_confidence.austerity\":{\"id\":\"vote_of_no_confidence.austerity\",\"viewIf\":{\"$code\":\"return ((Q['welfare'] || 0) >= 0);\"},\"onArrival\":[{\"$code\":\"Q['coalition_dissent'] = 0;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 10;\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) - 10;\\nQ['workers_kpd'] = (Q['workers_kpd'] || 0) + 7;\\nQ['workers_nsdap'] = (Q['workers_nsdap'] || 0) + 3;\\nQ['unemployed_kpd'] = (Q['unemployed_kpd'] || 0) + 5;\\nQ['unemployed_nsdap'] = (Q['unemployed_nsdap'] || 0) + 5;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 15;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) + 10;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) + 15;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 5;\\nQ['welfare'] = (Q['welfare'] || 0) - 2;\\nQ['budget'] = (Q['budget'] || 0) + 1;\\nQ['unemployed'] = (Q['unemployed'] || 0) + 3;\\nQ['kpd_coalition_dissent'] = (Q['kpd_coalition_dissent'] || 0) + 1;\\n if ((((Q['in_popular_front'] || 0)) !== 0) ) { Q['kpd_relation'] = (Q['kpd_relation'] || 0) - 10; }\"}],\"content\":{\"content\":\"Fine. We enacted a massive austerity program to cut welfare, in order to maintain the stability of our coalition. The vote has been called off.\",\"type\":\"paragraph\"}},\"wittorf_affair.secret\":{\"id\":\"wittorf_affair.secret\",\"title\":\"It is best to keep this information secret. Prevent the Leninbund and dissident KPD members from spreading this.\",\"chooseIf\":{\"$code\":\"return ((((Q['levi_advisor'] || 0)) !== 0) || (((Q['rosenfeld_advisor'] || 0)) !== 0));\"},\"unavailableSubtitle\":\"We do not have contacts among the dissident communists.\",\"onArrival\":[{\"$code\":\"Q['wittorf_secret'] = 1;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 5;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 5;\"}],\"content\":{\"content\":\"Some among our leadership consider it unsavory to engage in cloak-and-dagger scheming. However, keeping this secret might be necessary to work with the KPD, and the information might become useful later.\",\"type\":\"paragraph\"}},\"wittorf_affair\":{\"id\":\"wittorf_affair\",\"type\":\"scene\",\"title\":\"Wittorf Affair\",\"subtitle\":\"A crisis in the KPD?\",\"newPage\":true,\"viewIf\":{\"$code\":\"return ((((((Q['kpd_relation'] || 0) >= 30) && (((Q['comintern_seen'] || 0)) !== 0)) && ((Q['year'] || 0)===1928)) && ((Q['month'] || 0) >= 8)) && ((Q['month'] || 0) <= 10));\"},\"maxVisits\":1,\"onArrival\":[{\"$code\":\"Q['wittorf_affair_seen'] = 1;\"}],\"tags\":[\"event\"],\"options\":[{\"id\":\"@wittorf_affair.publicize\"},{\"id\":\"@wittorf_affair.nothing\"},{\"id\":\"@wittorf_affair.secret\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Wittorf Affair\"},{\"type\":\"paragraph\",\"content\":\"Our spies and contacts amongst the communists have brought news of a scandal engulfing the KPD leadership. An associate of KPD chairman Ernst Thälmann, a KPD official named John Wittorf, is accused of embezzling campaign funds, diverting thousands of Reichsmarks for personal use, and Thälmann is accused of covering up the affair. The party's central committee considers this charge serious.\"},{\"type\":\"paragraph\",\"content\":\"The Conciliators in the KPD, a faction opposed to the party's present hard-line policy, are said to have leaked this information to aid them in the intra-party struggle. Dissident communists in the Leninbund also have information about this affair, and are planning to publish it.\"},{\"type\":\"paragraph\",\"content\":\"What should we do with this information?\"}],\"countVisitsMax\":1},\"young_plan.rational\":{\"id\":\"young_plan.rational\",\"onArrival\":[{\"$code\":\"Q['nationalism'] = (Q['nationalism'] || 0) + 5;\\nQ['workers_nsdap'] = (Q['workers_nsdap'] || 0) + 4;\\nQ['rural_nsdap'] = (Q['rural_nsdap'] || 0) + 5;\\nQ['catholics_spd'] = (Q['catholics_spd'] || 0) - 4;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 3;\\nQ['rural_dvp'] = (Q['rural_dvp'] || 0) - 5;\"}],\"content\":{\"content\":\"The referendum easily fails, with only around 15% of voters supporting it. It seems that the German people have a sense of rationality, after all.\",\"type\":\"paragraph\"}},\"young_plan_right_coalition.no_matter\":{\"id\":\"young_plan_right_coalition.no_matter\",\"title\":\"It does not matter what we do.\",\"subtitle\":\"The anti-government parties have over 50% of the vote, no matter our choices.\",\"viewIf\":{\"$code\":\"return ((Q['neo_weimar_coalition'] || 0) < 50);\"},\"call\":\"set_next_election_time\",\"onArrival\":[{\"$code\":\"Q['time_to_election'] = 3;\\nQ['spd_in_government'] = 0;\\nQ['in_right_coalition'] = 0;\\nQ['in_grand_coalition'] = 0;\\nQ['spd_toleration'] = 0;\\nQ['pro_republic'] = (Q['pro_republic'] || 0) - 5;\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"The right-wing coalition has fallen. New elections have been set for \",{\"type\":\"insert\",\"insert\":0},\" \",{\"type\":\"insert\",\"insert\":1},\".\"]},\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_month'] || 0);\"},\"qdisplay\":\"month\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_year'] || 0);\"}}]}},\"young_plan_right_coalition\":{\"id\":\"young_plan_right_coalition\",\"type\":\"scene\",\"title\":\"Young Plan\",\"newPage\":true,\"subtitle\":\"The right-wing coalition has collapsed...\",\"tags\":[\"event\"],\"viewIf\":{\"$code\":\"return (((((Q['year'] || 0)===1929) && ((Q['month'] || 0) >= 7)) && ((Q['young_plan_seen'] || 0)===0)) && (((Q['in_right_coalition'] || 0)) !== 0));\"},\"onArrival\":[{\"$code\":\"Q['young_plan_seen'] = 1;\"}],\"maxVisits\":1,\"options\":[{\"id\":\"@young_plan_right_coalition.vonc_yes\"},{\"id\":\"@young_plan_right_coalition.vonc_no\"},{\"id\":\"@young_plan_right_coalition.no_matter\"}],\"content\":[{\"type\":\"heading\",\"content\":\"The Young Plan and the fall of the coalition\"},{\"type\":\"paragraph\",\"content\":\"The Foreign Ministry under Gustav Streseman has agreed to the Young Plan, an agreement with the Western powers to reduce Germany's reparation payments and give us more fiscal autonomy. Simultaneously, France will agree to withdraw its military occupation from the Rhineland.\"},{\"type\":\"paragraph\",\"content\":\"While this seems to be a positive development for the country, the DNVP opposes the plan, claiming that any reparations are a form of national slavery. They have called for a vote of no confidence against the government, supported by the NSDAP and the KPD, and for a referendum on the Young Plan.\"},{\"type\":\"paragraph\",\"content\":\"We can either vote to bring down the government and hold new elections, or \\\"tolerate\\\" a government led by the remaining bourgeois parties.\"}],\"countVisitsMax\":1},\"confronting_nazis.major_crisis\":{\"id\":\"confronting_nazis.major_crisis\",\"viewIf\":{\"$code\":\"return ((Q['nazi_urgency'] || 0) < 5);\"},\"onArrival\":[{\"$code\":\"Q['nazi_urgency'] = (Q['nazi_urgency'] || 0) + 1;\\nQ['neorevisionist_dissent'] = (Q['neorevisionist_dissent'] || 0) - 5;\\nQ['neorevisionist_strength'] = (Q['neorevisionist_strength'] || 0) + 5;\"}],\"content\":{\"content\":\"The Nazis are one of the foremost threats to the German republic. However, we are still formulating a strategy to confront them, and still trying to build up consensus within our party for action. Check back on this later.\",\"type\":\"paragraph\"}},\"campaigning.old_middle\":{\"id\":\"campaigning.old_middle\",\"subtitle\":\"-1 resources\",\"chooseIf\":{\"$code\":\"return ((Q['resources'] || 0) >= 1);\"},\"unavailableSubtitle\":\"Not enough resources.\",\"onArrival\":[{\"$code\":\"Q['old_middle_spd'] = (Q['old_middle_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['resources'] = (Q['resources'] || 0) - 1;\\n if ((((Q['nationalism'] || 0) >= 51) && ((Q['peoples_party'] || 0) == 0)) ) { Q['old_middle_spd'] = (Q['old_middle_spd'] || 0) - 3; } \\nQ['peoples_party_support'] = (Q['peoples_party_support'] || 0) + 1;\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"We have increased our campaigning among the old middle class. \",{\"type\":\"conditional\",\"content\":\"The high levels of nationalism among this group make our campaign more difficult. \",\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"As a people's party, we have an easier time increasing support among the middle class than before.\",\"predicate\":1}]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['nationalism'] || 0) >= 51) && ((Q['peoples_party'] || 0) == 0));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['peoples_party'] || 0) > 0);\"}}]}},\"crisis_program.plan_support\":{\"id\":\"crisis_program.plan_support\",\"content\":[{\"type\":\"paragraph\",\"content\":\"Our support of the WTB plan alienates the orthodox Marxists of the Centrist faction, and faces both opposition and support from a variety of sources across the spectrum. Leftists argue that the plan is flawed because it leaves capitalism intact, while some reformists are cautiously optimistic.\"},{\"type\":\"paragraph\",\"content\":\"We have not yet convinced the party to formally adopt the plan. More work needs to be done.\"}]},\"fundraising.increase\":{\"id\":\"fundraising.increase\",\"subtitle\":{\"content\":[{\"type\":\"insert\",\"insert\":0},\" resources gained. \",{\"type\":\"conditional\",\"content\":\"Given the present economic situation, this may be painful. \",\"predicate\":1},{\"type\":\"conditional\",\"content\":\"Dues are already rather high; increasing them might reduce our membership.\",\"predicate\":2}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return ((Q['dues'] || 0) + 1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['unemployed'] || 0) >= 15);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['dues'] || 0) >= 4);\"}}]},\"onArrival\":[{\"$code\":\"Q['dues'] = (Q['dues'] || 0) + 1;\\nQ['resources'] = (Q['resources'] || 0) + (Q['dues'] || 0);\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 3;\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) - 3;\\n if (((Q['unemployed'] || 0) >= 15) ) { Q['workers_spd'] = (Q['workers_spd'] || 0) - 10; } \\n if (((Q['unemployed'] || 0) >= 15) ) { Q['unemployed_spd'] = (Q['unemployed_spd'] || 0) - 10; } \\n if (((Q['dues'] || 0) >= 5) ) { Q['workers_spd'] = (Q['workers_spd'] || 0) - (3 * (Q['dues'] || 0)); } \\n if (((Q['dues'] || 0) >= 5) ) { Q['unemployed_spd'] = (Q['unemployed_spd'] || 0) - (3 * (Q['dues'] || 0)); }\"}],\"viewIf\":{\"$code\":\"return ((Q['dues'] || 0) <= 4);\"},\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"Our members grumble at this, and some of the less committed members leave. But now, we have access to additional resources.\"},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":\"Because of the presently high unemployment, our members are feeling the extra burden hard.\",\"predicate\":0}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['unemployed'] || 0) >= 15);\"}}]}},\"fundraising\":{\"id\":\"fundraising\",\"type\":\"scene\",\"title\":\"Fundraising\",\"newPage\":true,\"viewIf\":{\"$code\":\"return (((Q['fundraising_timer'] || 0) <= 0) && ((!(((Q['historical_mode'] || 0)) !== 0))));\"},\"onArrival\":[{\"$code\":\"Q['fundraising_timer'] = 6;\\nQ['month_actions'] = (Q['month_actions'] || 0) + 1;\"}],\"frequency\":300,\"isCard\":true,\"cardImage\":\"img/poster_2.jpg\",\"tags\":[\"party_affairs\"],\"options\":[{\"id\":\"@fundraising.maintain\",\"title\":\"Maintain our current dues.\"},{\"id\":\"@fundraising.reduce\",\"title\":\"Reduce dues.\"},{\"id\":\"@fundraising.increase\",\"title\":\"Increase dues.\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Fundraising\"},{\"type\":\"paragraph\",\"content\":\"For better or for worse, the party cannot exist without money.\"}]},\"enemies.nsdap\":{\"id\":\"enemies.nsdap\",\"onArrival\":[{\"$code\":\"Q['enemies'] = \\\"NSDAP\\\";\\nQ['neorevisionist_strength'] = (Q['neorevisionist_strength'] || 0) + 5;\\nQ['nazi_urgency'] = (Q['nazi_urgency'] || 0) + 1;\\nQ['workers_nsdap'] = (Q['workers_nsdap'] || 0) - 4;\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"The NSDAP is a tiny party right now, with more bark than bite. Many in our party are questioning our choices. \",\"predicate\":0},{\"type\":\"conditional\",\"content\":\"The Nazis are the most urgent problem for us to deal with.\",\"predicate\":1}]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['nazi_urgency'] || 0) == 0) || ((Q['nsdap_r'] || 0) < 10));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['nazi_urgency'] || 0) > 0) && ((Q['nsdap_r'] || 0) >= 10));\"}}]}},\"ideology.labor\":{\"id\":\"ideology.labor\",\"onArrival\":[{\"$code\":\"if (Q.ideology && Q.ideology != \\\"labor\\\") {\\n    Q.changed = 1;\\n}\"}],\"goTo\":[{\"id\":\"ideology.changed\",\"predicate\":{\"$code\":\"return ((Q['changed'] || 0)===1);\"}}],\"onDeparture\":[{\"$code\":\"Q['ideology'] = \\\"labor\\\";\\nQ['labor_strength'] = (Q['labor_strength'] || 0) + 10;\\nQ['wtb_support'] = (Q['wtb_support'] || 0) + 1;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) - 5;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) - 3;\"}],\"content\":{\"content\":\"The labor wing of the party supports continued particpation in government in order to provide benefits to the workers, and the creation of public works programs for employment.\",\"type\":\"paragraph\"}},\"inter_party_relationships.kpd_rectification_of_history\":{\"id\":\"inter_party_relationships.kpd_rectification_of_history\",\"options\":[{\"id\":\"@inter_party_relationships.yes_history\",\"title\":\"Yes, we must apologize for our past actions.\"},{\"id\":\"@inter_party_relationships.no_history\",\"title\":\"No, we have no need to apologize.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"One stumbling block for our relations with the KPD is our history of conflict, dating back to 1918 and 1919. The KPD is especially contemptuous of Gustav Noske, the SPD \\\"bloodhound\\\" who reportedly ordered the violent suppression of the Spartacist uprising and other KPD revolts. They also blame us for the deaths of Rosa Luxemburg and Karl Liebknecht, two SPD-turned-KPD leaders who were killed during the suppression of the uprising.\"},{\"type\":\"paragraph\",\"content\":\"For further improvements in KPD relations, it might be necessary to expel Noske, and hold some sort of commemoration for Luxemburg and Liebknecht.\"}]},\"international_relations.scandi\":{\"id\":\"international_relations.scandi\",\"subtitle\":\"-1 resources\",\"chooseIf\":{\"$code\":\"return ((Q['resources'] || 0) >= 1);\"},\"unavailableSubtitle\":\"Not enough resources.\",\"onArrival\":[{\"$code\":\"Q['reformist_strength'] = (Q['reformist_strength'] || 0) + 8;\\nQ['wtb_support'] = (Q['wtb_support'] || 0) + 1;\\nQ['resources'] = (Q['resources'] || 0) - 1;\\nQ['moderate_plan_support'] = (Q['moderate_plan_support'] || 0) + 1;\"}],\"content\":{\"content\":\"The programs of the Nordic socialists involve active government intervention in the economy. We can learn from their economic strategies, and how they moved beyond their working-class base to attract a broader set of constituents.\",\"type\":\"paragraph\"}},\"iron_front.republic\":{\"id\":\"iron_front.republic\",\"onArrival\":[{\"$code\":\"Q['pro_republic'] = (Q['pro_republic'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['democratization'] = (Q['democratization'] || 0) + 1;\\n if (((Q['democratization'] || 0) >= 4) ) { Q['workers_spd'] = (Q['workers_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0))); } \\n if (((Q['democratization'] || 0) >= 4) ) { Q['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0))); } \\n if (((Q['democratization'] || 0) >= 4) ) { Q['new_middle_spd'] = (Q['new_middle_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0))); }\"}],\"content\":{\"content\":\"The Iron Front rallies in defense of the democratic republic and against dictatorship.\",\"type\":\"paragraph\"}},\"media.ideological\":{\"id\":\"media.ideological\",\"title\":\"We will have vibrant ideological debate within our newspapers.\",\"subtitle\":\"There will be space for all factions to air their views.\",\"onArrival\":[{\"$code\":\"Q['left_dissent'] = (Q['left_dissent'] || 0) - 6;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) - 6;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) - 6;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) - 6;\\nQ['neorevisionist_dissent'] = (Q['neorevisionist_dissent'] || 0) - 6;\"}],\"content\":{\"content\":\"This has been our media course historically, and it has successfully paved over the many tensions in our party.\",\"type\":\"paragraph\"}},\"party_disunity.concessions_center\":{\"id\":\"party_disunity.concessions_center\",\"title\":\"Give concessions to the centrists.\",\"viewIf\":{\"$code\":\"return ((Q['center_dissent'] || 0) > 30);\"},\"onArrival\":[{\"$code\":\"Q['center_dissent'] = (Q['center_dissent'] || 0) - 7;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 2;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 2;\\nQ['neorevisionist_dissent'] = (Q['neorevisionist_dissent'] || 0) + 2;\"}],\"content\":{\"content\":\"We have promised to take more policy suggestions from the centrists. Both the left and reformist wings of the party might be displeased.\",\"type\":\"paragraph\"}},\"party_organizations.culture\":{\"id\":\"party_organizations.culture\",\"chooseIf\":{\"$code\":\"return ((Q['resources'] || 0) > 0);\"},\"unavailableSubtitle\":\"Not enough resources.\",\"subtitle\":\"-1 resources\",\"onArrival\":[{\"$code\":\"Q['resources'] = (Q['resources'] || 0) - 1;\\nQ['cultural_organizations'] = (Q['cultural_organizations'] || 0) + 1;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) - 6;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) - 6;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) - 6;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) - 6;\\nQ['neorevisionist_dissent'] = (Q['neorevisionist_dissent'] || 0) - 6;\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"It is not enough for the SPD to solely be a political party. The Worker Singer's League, Worker's Sports, and our schools and libraries are crucial to our members' lives. Funding these organizations makes our members more committed to the party, even when our policies might not be to their liking.\"},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":\"However, it feels frivolous to spend on sports and choirs when the fascists are murdering us in the streets.\",\"predicate\":0}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['sa_strength'] || 0) > 500);\"}}]}},\"peoples_party.support_peoples_party_hard\":{\"id\":\"peoples_party.support_peoples_party_hard\",\"subtitle\":\"This will increase dissent.\",\"viewIf\":{\"$code\":\"return (((((Q['neorevisionist_strength'] || 0) + (Q['reformist_strength'] || 0)) < ((Q['left_strength'] || 0) + (Q['center_strength'] || 0)))) || (((Q['peoples_party_support'] || 0) < 4)));\"},\"onArrival\":[{\"$code\":\"Q['neorevisionist_strength'] = (Q['neorevisionist_strength'] || 0) + 10;\\nQ['reformist_strength'] = (Q['reformist_strength'] || 0) + 8;\\nQ['peoples_party'] = 1;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 15;\\nQ['rural_spd'] = (Q['rural_spd'] || 0) + 10;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) + 10;\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) + 8;\\nQ['catholics_spd'] = (Q['catholics_spd'] || 0) + 8;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 40;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) + 40;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) - 10;\\nQ['kpd_coalition_dissent'] = (Q['kpd_coalition_dissent'] || 0) + 1;\\nQ['coalition_dissent'] = (Q['coalition_dissent'] || 0) - 1;\"}],\"achievement\":\"volkspartei\",\"options\":[{\"id\":\"@peoples_party.campaign_workers\"},{\"id\":\"@peoples_party.campaign_middle\"},{\"id\":\"@peoples_party.campaign_rural\"},{\"id\":\"@peoples_party.campaign_unemployed\"},{\"id\":\"@peoples_party.campaign_women\"},{\"id\":\"@peoples_party.campaign_catholics\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"It is an arduous and contentious process, but we have pushed through the proposal to become a people's party. The Left and Center claim that our new party platform is a betrayal of our founding principles, a turn away from Marxism towards bourgeois opportunism. Whatever the case, we are now a party representing all of the people, not just the proletariat.\"},{\"type\":\"paragraph\",\"content\":\"Should we run a new campaign to publicize our new platform?\"}]},\"peoples_party_campaigning.campaign_rural\":{\"id\":\"peoples_party_campaigning.campaign_rural\",\"title\":\"Campaign in rural areas.\",\"chooseIf\":{\"$code\":\"return ((Q['rural_policy'] || 0) > 0);\"},\"unavailableSubtitle\":\"We have not enacted any rural policies yet.\",\"onArrival\":[{\"$code\":\"Q['rural_spd'] = (Q['rural_spd'] || 0) + (6 * (1 - (Q['dissent'] || 0)));\"}],\"content\":{\"content\":\"As a people's party, we represent farmers and rural workers as well, and they are becoming receptive to our messages.\",\"type\":\"paragraph\"}},\"rally.police_protect_win\":{\"id\":\"rally.police_protect_win\",\"goTo\":[{\"id\":\"rally.main_rally\"}],\"content\":{\"content\":\"The police successfully protected our rally, so it can go ahead as usual.\",\"type\":\"paragraph\"}},\"reichsbanner.same\":{\"id\":\"reichsbanner.same\",\"options\":[{\"id\":\"@return\",\"title\":\"Continue...\"}],\"content\":{\"content\":\"The Reichsbanner is already serving the purpose it needs to serve. There is no reason to change what already works.\",\"type\":\"paragraph\"}},\"response_to_antisemitism.all\":{\"id\":\"response_to_antisemitism.all\",\"content\":{\"content\":\"We do not need any special treatment for minorities.\",\"type\":\"paragraph\"}},\"response_to_antisemitism\":{\"id\":\"response_to_antisemitism\",\"type\":\"scene\",\"title\":\"Confronting Antisemitism\",\"newPage\":true,\"isCard\":true,\"viewIf\":{\"$code\":\"return (((Q['iron_front_formed'] || 0) == 1) && ((Q['nazi_urgency'] || 0) >= 3));\"},\"onArrival\":[{\"$code\":\"Q['confronting_antisemitism'] = (Q['confronting_antisemitism'] || 0) + 1;\\nQ['month_actions'] = (Q['month_actions'] || 0) + 1;\"}],\"cardImage\":\"img/iron_front.png\",\"tags\":[\"party_affairs\",\"antifascism\"],\"maxVisits\":1,\"options\":[{\"id\":\"@response_to_antisemitism.socialism_of_fools\",\"title\":\"Antisemitism is the \\\"socialism of fools\\\". We will defeat them with real socialism.\"},{\"id\":\"@response_to_antisemitism.if\",\"title\":\"Antisemitism is a crisis. Direct the full force of the Iron Front against antisemitism.\"},{\"id\":\"@response_to_antisemitism.all\",\"title\":\"All Germans will suffer from fascism, not just the Jews. We do not need a separate policy for them.\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Confronting Antisemitism\"},{\"type\":\"paragraph\",\"content\":\"Antisemitism has long been a latent feature of German society, but since the beginning of the economic depression, it has grown to a horrifying extent. The Nazis are the worst of it, but all the right-wing parties are deeply antisemitic. Regarding the SPD specifically, our right-wing enemies love to deploy their racist rhetoric against our many Jewish comrades, magnifying criticism of any minor transgression, and they call the entire SPD a Jewish party. We are a favorite target of their invectives.\"}],\"countVisitsMax\":1},\"shuffle_leadership.remove_hilferding\":{\"id\":\"shuffle_leadership.remove_hilferding\",\"title\":\"Remove Hilferding\",\"viewIf\":{\"$code\":\"return ((Q['hilferding_advisor'] || 0)===1);\"},\"onArrival\":[{\"$code\":\"Q['hilferding_advisor'] = 0;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) + 5;\\nQ['n_advisors'] = (Q['n_advisors'] || 0) - 1;\"}],\"tags\":[\"remove_advisor\"],\"goTo\":[{\"id\":\"shuffle_leadership.rm_main\"}],\"content\":{\"content\":\"Hilferding has been removed as an advisor. The Centrist faction disapproves.\",\"type\":\"paragraph\"}},\"streetfighting.if_training\":{\"id\":\"streetfighting.if_training\",\"viewIf\":{\"$code\":\"return ((Q['iron_front_formed'] || 0) == 1);\"},\"onArrival\":[{\"$code\":\"Q['rb_militancy'] = (Q['rb_militancy'] || 0) + 0.03;\\nQ['rb_strength'] = (Q['rb_strength'] || 0) + 200;\\nQ['sa_strength'] = (Q['sa_strength'] || 0) + 50;\"}],\"maxVisits\":2,\"content\":{\"content\":\"As part of the Iron Front, we are increasing coordination between the Reichsbanner and the unions, and many union members want to become more involved.\",\"type\":\"paragraph\"},\"countVisitsMax\":2},\"credits.music\":{\"id\":\"credits.music\",\"options\":[{\"id\":\"@credits\",\"title\":\"Back\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"Choir. The Internationale in German. 19XX. https://www.youtube.com/watch?v=UXKr4HSPHT8, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:Internationale-de.ogg. CC-BY-SA 4.0 https://creativecommons.org/licenses/by-sa/4.0/deed.en\"},{\"type\":\"paragraph\",\"content\":\"CNT. A Las Barricadas (Instrumental). 17 June 2014. http://www.cnt.es/, Wikimedia Commons, https://commons.wikimedia.org/wiki/File:A_las_barricadas_(Instrumental).ogg. CC-BY-SA 3.0 https://creativecommons.org/licenses/by-sa/3.0/deed.en\"},{\"type\":\"paragraph\",\"content\":\"Columbia Orchester and Mendelssohn. Fruhlingslied. Columbia, 1917. Internet Archive, http://archive.org/details/78_fruhlingslied_columbia-orchester-mendelssohn_gbia0003448a. Public Domain\"},{\"type\":\"paragraph\",\"content\":\"“Deutsche Arbeiter-Marseillaise.” Wikipedia, 31 Oct. 2023. Wikipedia, https://en.wikipedia.org/w/index.php?title=Deutsche_Arbeiter-Marseillaise&oldid=1182815568. Public Domain\"},{\"type\":\"paragraph\",\"content\":\"Erich-Weinert-Ensemble. Workers of Vienna. Internet Archive, http://archive.org/details/WorkersOfVienna. Accessed 29 Feb. 2024.\"},{\"type\":\"paragraph\",\"content\":\"Großes Odeon-Orchester. Warszawianka. 5 May 1928. Internet Archive, http://archive.org/details/WarszawiankaOdeon1928. Public Domain\"},{\"type\":\"paragraph\",\"content\":\"Kapelle Jais, München. AUF HOHEN BERGEN. Odeon, 1920. Internet Archive, http://archive.org/details/78_auf-hohen-bergen_kapelle-jais-mnchen_gbia0166297b. Public Domain\"},{\"type\":\"paragraph\",\"content\":\"Marek Weber and Bruno Granichstaedten. Fräulein, wie kann man nur so treu sein. Parlophon, 1920. Internet Archive, http://archive.org/details/78_frulein-wie-kann-man-nur-so-treu-sein_marek-weber-bruno-granichstaedten_gbia0290517b. Public Domain\"},{\"type\":\"paragraph\",\"content\":\"Mitgliedern des Berliner Schubert-Chors mit Blas-Orchester. Marsch Der Eisernen Front. Internet Archive, http://archive.org/details/front_20210826. Accessed 29 Feb. 2024.\"},{\"type\":\"paragraph\",\"content\":\"Pauline DOBERT - Alt, Bruno SEIDLER-WINKLER-Orgel. Komm, süsser Tod. Sept. 1923. Internet Archive, http://archive.org/details/dobert-komm-susser-tod. Public Domain\"},{\"type\":\"paragraph\",\"content\":\"Peasant Band BAUERN KAPELLE and Sousedska. BEIM FENSTERLN - U OKENEČKA. Columbia, 1923. Internet Archive, http://archive.org/details/78_beim-fensterln-u-okeneka_peasant-band-bauern-kapelle-sousedska_gbia0483844b. Public Domain\"},{\"type\":\"paragraph\",\"content\":\"REICHSBANNER-GAU-KAPELLE mit Chor. Wann wir schreiten Seit’ an Seit’. 1928. Internet Archive, http://archive.org/details/reichsbanner-gau-kapelle-wann-wir-schreiten-seit-an-seit. Public Domain\"},{\"type\":\"paragraph\",\"content\":\"---. Zur Sonne, zur Freiheit. 1928. Internet Archive, http://archive.org/details/reichsbanner-gau-kapelle-zur-sonne-zur-freiheit. Public Domain\"},{\"type\":\"paragraph\",\"content\":\"SIGRID ONEGIN and Schubert. DER LINDENBAUM (The Linden-Tree). Brunswick, 3 Dec. 1923. Internet Archive, http://archive.org/details/78_der-lindenbaum-the-linden-tree_sigrid-onegin-schubert_gbia0260352b. Public Domain\"},{\"type\":\"paragraph\",\"content\":\"Ilse ASCH - Sopran. Lied der Pompadour, 1922. http://archive.org/details/ilse-asch-lied-der-pompadour. Public Domain\"},{\"type\":\"paragraph\",\"content\":\"Rudolf DEMAN - Violine, Otto URACK-Piano. Liebesleid (Fritz Kreisler), 1922. http://archive.org/details/deman-liebesleid. Public Domain\"}]},\"credits\":{\"id\":\"credits\",\"type\":\"scene\",\"title\":\"Credits\",\"options\":[{\"id\":\"@credits.books\",\"title\":\"Books\"},{\"id\":\"@credits.articles\",\"title\":\"Articles\"},{\"id\":\"@credits.images\",\"title\":\"Image sources\"},{\"id\":\"@credits.music\",\"title\":\"Music sources\"},{\"id\":\"@root\",\"title\":\"Back\"}],\"content\":{\"content\":\"Many works were referenced in the making of this game.\",\"type\":\"paragraph\"}},\"election_simulation.post_election\":{\"id\":\"election_simulation.post_election\",\"onArrival\":[{\"$code\":\"// set congress proportion to votes\\nQ.spd_r = Q.spd_votes;\\nQ.z_r = Q.z_votes;\\nQ.kpd_r = Q.kpd_votes;\\nQ.ddp_r = Q.ddp_votes;\\nQ.dvp_r = Q.dvp_votes;\\nQ.dnvp_r = Q.dnvp_votes;\\nQ.nsdap_r = Q.nsdap_votes;\\nQ.other_r = Q.other_votes;\\n\\n// The largest party can only be the NSDAP or the SPD.\\nQ.largest_party = 'SPD';\\nif (Q.nsdap_r >= Q.spd_r && Q.nsdap_r >= Q.kpd_r) {\\n    Q.largest_party = 'NSDAP';\\n}\\nif (Q.kpd_r >= Q.spd_r && Q.kpd_r >= Q.nsdap_r) {\\n    Q.largest_party = 'KPD';\\n}\\n\\n// coalitions\\nQ.weimar_coalition = Q.spd_r + Q.ddp_r + Q.z_r - 3;\\nQ.grand_coalition = Q.spd_r + Q.ddp_r + Q.z_r + Q.dvp_r;\\nQ.bourgeois_coalition = Q.ddp_r + Q.z_r + Q.dvp_r + Q.other_r;\\nQ.center_right_coalition = Q.z_r + Q.ddp_r + Q.dvp_r + Q.other_r + Q.dnvp_r;\\nQ.right_coalition = Q.z_r + Q.dvp_r + Q.other_r + Q.dnvp_r;\\nQ.far_right_coalition = Q.dnvp_r + Q.nsdap_r;\\nQ.left_coalition = Q.spd_r + Q.kpd_r;\\n// this is an absurd concept lol\\nQ.united_front_coalition = Q.spd_r + Q.kpd_r + Q.z_r + Q.ddp_r - 3;\\nQ.anti_democratic_coalition = Q.kpd_r + Q.nsdap_r;\\n// aka everyone except nazi, kpd, dnvp\\nQ.neo_weimar_coalition = Q.spd_r + Q.ddp_r + Q.z_r + Q.dvp_r + Q.other_r;\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"The electoral system is essentially proportional, with the proportion of Reichstag seats roughly equal to the proportion of votes.\"},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"Election results:\"},\"\"]},{\"type\":\"paragraph\",\"content\":[\"SPD: \",{\"type\":\"insert\",\"insert\":0},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Z + BVP: \",{\"type\":\"insert\",\"insert\":1},\"\"]},{\"type\":\"paragraph\",\"content\":[\"KPD: \",{\"type\":\"insert\",\"insert\":2},\"\"]},{\"type\":\"paragraph\",\"content\":[\"DDP: \",{\"type\":\"insert\",\"insert\":3},\"\"]},{\"type\":\"paragraph\",\"content\":[\"DVP: \",{\"type\":\"insert\",\"insert\":4},\"\"]},{\"type\":\"paragraph\",\"content\":[\"DNVP: \",{\"type\":\"insert\",\"insert\":5},\"\"]},{\"type\":\"paragraph\",\"content\":[\"NSDAP: \",{\"type\":\"insert\",\"insert\":6},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Other: \",{\"type\":\"insert\",\"insert\":7},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"Potential coalitions:\"},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Weimar Coalition (SPD + Z + DDP): \",{\"type\":\"insert\",\"insert\":8},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Grand Coalition (SPD + Z + BVP + DDP + DVP): \",{\"type\":\"insert\",\"insert\":9},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Bourgeois Coalition (Z + BVP + DDP + DVP + Others): \",{\"type\":\"insert\",\"insert\":10},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Right-wing Coalition (Z + BVP + DVP + Others + DNVP): \",{\"type\":\"insert\",\"insert\":11}]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['spd_r'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['z_r'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['kpd_r'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['ddp_r'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['dvp_r'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['dnvp_r'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['nsdap_r'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['other_r'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['weimar_coalition'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['grand_coalition'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['bourgeois_coalition'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['right_coalition'] || 0);\"}}]}},\"election_simulation\":{\"id\":\"election_simulation\",\"type\":\"scene\",\"title\":\"Election Simulation\",\"setJump\":\"election_simulation.post_election\",\"options\":[{\"id\":\"@election_simulation.1928\",\"title\":\"1928 historical scenario\"},{\"id\":\"@election_simulation.1930\",\"title\":\"1930 historical scenario\"},{\"id\":\"@election_simulation.1932\",\"title\":\"1932 (July) historical scenario\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"game_over.no_hitler\":{\"id\":\"game_over.no_hitler\",\"viewIf\":{\"$code\":\"return ((((Q['chancellor'] != \\\"Hitler\\\") && (Q['president'] != \\\"Hitler\\\")) && (Q['president'] != \\\"Göring\\\")) && (Q['chancellor_party'] != \\\"NSDAP\\\"));\"},\"title\":\"Hitler does not yet control Germany...\",\"tags\":[\"endings\"],\"goTo\":[{\"id\":\"game_over.eg_menu\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[\"Hitler does not yet control Germany. \",{\"type\":\"conditional\",\"content\":\"However, Chancellor Papen's authoritarianism and far-right politics are paving the way for Hitler, or someone like him, to take power. \",\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"However, Chancellor Schleicher's authoritarianism and scheming is paving the way for Hitler, or someone like him, to take power. \",\"predicate\":1},{\"type\":\"conditional\",\"content\":\"Given our defeat in the Prussian coup, the far-right appears to be ascendant. \",\"predicate\":2},{\"type\":\"conditional\",\"content\":\"However, Chancellor Brüning's austerity policies and the continuation of the depression are paving the way for Hitler, or someone like him, to take power. \",\"predicate\":3},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":\"We have deported Hitler back to Austria. Hopefully he will never return.\",\"predicate\":4}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['chancellor'] == \\\"Papen\\\");\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['chancellor'] == \\\"Schleicher\\\");\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((((Q['resist_coup'] || 0) == 1) && ((Q['republic_victory'] || 0) == 0)) && ((Q['long_war'] || 0) == 0)) && ((Q['coup_victory'] || 0) == 0));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['chancellor'] == \\\"Brüning\\\");\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['hitler_deported'] || 0) == 1);\"}}]}},\"library.curr_gov\":{\"id\":\"library.curr_gov\",\"goTo\":[{\"id\":\"library.cabinet\",\"predicate\":{\"$code\":\"return (((Q['spd_in_government'] || 0)) !== 0);\"}},{\"id\":\"library.menu\",\"predicate\":{\"$code\":\"return (!(((Q['spd_in_government'] || 0)) !== 0));\"}}],\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"Current Government\"},{\"type\":\"paragraph\",\"content\":[\"President: \",{\"type\":\"insert\",\"insert\":0},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Chancellor: \",{\"type\":\"insert\",\"insert\":1},\" (\",{\"type\":\"insert\",\"insert\":2},\")\"]},{\"type\":\"paragraph\",\"content\":\"Reichstag composition:\"},{\"type\":\"paragraph\",\"content\":[\"SPD: \",{\"type\":\"insert\",\"insert\":3},\"% \",{\"type\":\"conditional\",\"content\":[\"SAPD: \",{\"type\":\"insert\",\"insert\":5},\"% \"],\"predicate\":4},\" Z + BVP: \",{\"type\":\"insert\",\"insert\":6},\"% KPD: \",{\"type\":\"insert\",\"insert\":7},\"% DDP: \",{\"type\":\"insert\",\"insert\":8},\"% DVP: \",{\"type\":\"insert\",\"insert\":9},\"% DNVP: \",{\"type\":\"insert\",\"insert\":10},\"% NSDAP: \",{\"type\":\"insert\",\"insert\":11},\"% Others: \",{\"type\":\"insert\",\"insert\":12},\"%\"]},{\"type\":\"paragraph\",\"content\":[\"SPD position: \",{\"type\":\"conditional\",\"content\":\"toleration \",\"predicate\":13},{\"type\":\"conditional\",\"content\":\"in government - \",\"predicate\":14},{\"type\":\"conditional\",\"content\":\"opposition \",\"predicate\":15},{\"type\":\"conditional\",\"content\":\"caretaker government \",\"predicate\":16},\" \",{\"type\":\"conditional\",\"content\":\"Weimar Coalition \",\"predicate\":17},{\"type\":\"conditional\",\"content\":\"Grand Coalition \",\"predicate\":18},{\"type\":\"conditional\",\"content\":\"Popular Front \",\"predicate\":19},{\"type\":\"conditional\",\"content\":\"Left Front \",\"predicate\":20},{\"type\":\"conditional\",\"content\":\"SPD majority \",\"predicate\":21},{\"type\":\"conditional\",\"content\":\"minority government \",\"predicate\":22},{\"type\":\"conditional\",\"content\":\"emergency government \",\"predicate\":23},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"Coalition dissent: \",{\"type\":\"insert\",\"insert\":25},\" \"],\"predicate\":24},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":[\"KPD coalition dissent: \",{\"type\":\"insert\",\"insert\":27},\"\"],\"predicate\":26}}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['president'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor_party'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['spd_r'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['sapd_formed'] || 0)) !== 0) && ((Q['sapd_r'] || 0) > 0));\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['sapd_r'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['z_r'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['kpd_r'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['ddp_r'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['dvp_r'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['dnvp_r'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['nsdap_r'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['other_r'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['spd_toleration'] || 0)) !== 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['spd_in_government'] || 0)) !== 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['spd_toleration'] || 0) == 0) && ((Q['spd_in_government'] || 0) == 0)) && ((Q['spd_caretaker'] || 0) == 0));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['spd_caretaker'] || 0)) !== 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['in_weimar_coalition'] || 0)) !== 0) && (((Q['spd_in_government'] || 0)) !== 0));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['in_grand_coalition'] || 0)) !== 0) && (((Q['spd_in_government'] || 0)) !== 0));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['in_popular_front'] || 0)) !== 0) && (((Q['spd_in_government'] || 0)) !== 0));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['in_left_front'] || 0)) !== 0) && (((Q['spd_in_government'] || 0)) !== 0));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['in_spd_majority'] || 0)) !== 0) && (((Q['spd_in_government'] || 0)) !== 0));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['in_minority_government'] || 0)) !== 0) && (((Q['spd_in_government'] || 0)) !== 0));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['in_emergency_government'] || 0)) !== 0) && (((Q['spd_in_government'] || 0)) !== 0));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((((Q['spd_in_government'] || 0)) !== 0) && (!(((Q['in_spd_majority'] || 0)) !== 0))) && (!(((Q['in_left_front'] || 0)) !== 0)));\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['coalition_dissent'] || 0);\"},\"qdisplay\":\"coalition_dissent\"},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['spd_in_government'] || 0)) !== 0) && (((((Q['in_left_front'] || 0)) !== 0) || (((Q['in_popular_front'] || 0)) !== 0))));\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['kpd_coalition_dissent'] || 0);\"},\"qdisplay\":\"coalition_dissent\"}]}},\"root.1928_easy\":{\"id\":\"root.1928_easy\",\"onArrival\":[{\"$code\":\"Q['difficulty'] = -1;\\nQ['resources'] = 4;\\nQ['dues'] = 3;\\nQ['rb_strength'] = 2500;\\nQ['kpd_relation'] = 29;\\nQ['z_relation'] = 54;\\nQ['dvp_relation'] = 49;\"}],\"goTo\":[{\"id\":\"root.1928_main\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"aufhauser.moderate_economic_plan\":{\"id\":\"aufhauser.moderate_economic_plan\",\"title\":\"Support the reformist economic plan\",\"subtitle\":\"Aufhäuser can also support a moderate economic plan.\",\"chooseIf\":{\"$code\":\"return ((((Q['advisor_action_timer'] || 0)===0) && ((Q['moderate_plan_adopted'] || 0)===0)) && ((Q['black_thursday_seen'] || 0)===1));\"},\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action. \"],\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"We have already adopted the reformist economic plan. \",\"predicate\":2},\" \",{\"type\":\"conditional\",\"content\":\"We are not currently in an economic crisis.\",\"predicate\":3}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['moderate_economic_plan'] || 0)===0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['black_thursday_seen'] || 0) == 0);\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\"}],\"goTo\":[{\"id\":\"crisis_program.support_moderate\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"aufhauser\":{\"id\":\"aufhauser\",\"type\":\"scene\",\"title\":\"Siegfried Aufhäuser\",\"isPinnedCard\":true,\"tags\":[\"advisor\",\"reformist\"],\"cardImage\":\"img/portraits/AufhäuserSiegfried.jpg\",\"viewIf\":{\"$code\":\"return ((Q['aufhauser_advisor'] || 0)===1);\"},\"newPage\":true,\"options\":[{\"id\":\"@aufhauser.white_collar\"},{\"id\":\"@aufhauser.union_unity\"},{\"id\":\"@aufhauser.crisis\"},{\"id\":\"@aufhauser.moderate_economic_plan\"},{\"id\":\"@root\",\"title\":\"Return to main\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Siegfried Aufhäuser\"},{\"type\":\"paragraph\",\"content\":\"Aufhäuser is a leader of the AfA-Bund, the federation of socialist white-collar trade unions.\"}]},\"breitscheid.snap_election\":{\"id\":\"breitscheid.snap_election\",\"title\":\"Snap Election\",\"subtitle\":\"Call a snap election.\",\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":\"Breitscheid must be Chancellor. \",\"predicate\":0},{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":2},\" months before next advisor action.\"],\"predicate\":1}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['chancellor'] != \\\"Breitscheid\\\");\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}}]},\"chooseIf\":{\"$code\":\"return (((Q['advisor_action_timer'] || 0) == 0) && (Q['chancellor'] == \\\"Breitscheid\\\"));\"},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\n if (((Q['next_election_time'] || 0) > ((Q['time'] || 0) + 3)) ) { Q['next_election_time'] = ((Q['time'] || 0) + 3); } \\n if (((Q['next_election_time'] || 0) >= ((Q['time'] || 0) + 3)) ) { Q['next_election_month'] = ((Q['month'] || 0) + 3); } \\n if (((Q['next_election_time'] || 0) >= ((Q['time'] || 0) + 3)) ) { Q['next_election_year'] = (Q['year'] || 0); } \\n if (((Q['next_election_month'] || 0) > 12) ) { Q['next_election_year'] = (Q['next_election_year'] || 0) + 1; } \\n if (((Q['next_election_month'] || 0) > 12) ) { Q['next_election_month'] = (Q['next_election_month'] || 0) - 12; }\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"We have called for new elections, set for \",{\"type\":\"insert\",\"insert\":0},\" \",{\"type\":\"insert\",\"insert\":1},\".\"]},\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_month'] || 0);\"},\"qdisplay\":\"month\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_year'] || 0);\"}}]}},\"breitscheid\":{\"id\":\"breitscheid\",\"type\":\"scene\",\"title\":\"Rudolf Breitscheid\",\"isPinnedCard\":true,\"tags\":[\"advisor\",\"centrist\"],\"cardImage\":\"img/portraits/BreitscheidRudolf.jpg\",\"newPage\":true,\"viewIf\":{\"$code\":\"return ((Q['breitscheid_advisor'] || 0)===1);\"},\"options\":[{\"id\":\"@breitscheid.breitscheid_international\"},{\"id\":\"@breitscheid.breitscheid_foreign\"},{\"id\":\"@breitscheid.party_discipline\"},{\"id\":\"@breitscheid.snap_election\"},{\"id\":\"@root\",\"title\":\"Return to main\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Rudolf Breitscheid\"},{\"type\":\"paragraph\",\"content\":\"Breitscheid is a long-time SPD leader, who was at one time part of the anti-war USPD. He came from a working-class family, but has a doctorate degree and started his political career as a liberal.\"}]},\"hilferding.economic_democracy_\":{\"id\":\"hilferding.economic_democracy_\",\"title\":\"Economic Democracy\",\"subtitle\":\"Enact policies to build a more democratic economy.\",\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action. \"],\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"SPD not in government: \",\"predicate\":2},\" \",{\"type\":\"conditional\",\"content\":\"We do not have the necessary government ministers.\",\"predicate\":3}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['spd_in_government'] || 0)===0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['labor_minister_party'] != \\\"SPD\\\") || (((Q['finance_minister_party'] != \\\"SPD\\\") && (Q['economic_minister_party'] != \\\"SPD\\\"))));\"}}]},\"chooseIf\":{\"$code\":\"return (((((Q['advisor_action_timer'] || 0) == 0) && ((Q['spd_in_government'] || 0) == 1)) && (((Q['economic_minister_party'] == \\\"SPD\\\") || (Q['finance_minister_party'] == \\\"SPD\\\")))) && ((Q['labor_minister_party'] == \\\"SPD\\\")));\"},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['economic_democracy_timer'] = (Q['economic_democracy_timer'] || 0) - 10;\\nQ['last_advisor_action'] = 1;\"}],\"goTo\":[{\"id\":\"economic_democracy\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"hilferding\":{\"id\":\"hilferding\",\"type\":\"scene\",\"title\":\"Rudolf Hilferding\",\"isPinnedCard\":true,\"tags\":[\"advisor\",\"centrist\"],\"cardImage\":\"img/portraits/HilferdingRudolf.jpg\",\"viewIf\":{\"$code\":\"return ((Q['hilferding_advisor'] || 0)===1);\"},\"newPage\":true,\"options\":[{\"id\":\"@hilferding.against_right_and_left\"},{\"id\":\"@hilferding.toleration\"},{\"id\":\"@hilferding.finance_ministry_\"},{\"id\":\"@hilferding.economic_democracy_\"},{\"id\":\"@root\",\"title\":\"Return to main\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Rudolf Hilferding\"},{\"type\":\"paragraph\",\"content\":\"Hilferding is an economist and a disciple of Karl Kautsky. Originating from Vienna, Austria, he trained as a medical doctor, but later became involved in Marxist economics as a discipline. He has been the lead ideologist of our party since the Heidelberg Program of 1925.\"}]},\"leber.build_peoples_party\":{\"id\":\"leber.build_peoples_party\",\"title\":\"Building a People's Party\",\"subtitle\":\"Can we expand our party beyond the industrial working class?\",\"viewIf\":{\"$code\":\"return ((Q['peoples_party'] || 0) == 0);\"},\"chooseIf\":{\"$code\":\"return (((Q['peoples_party_support'] || 0) >= 3) && ((Q['advisor_action_timer'] || 0)===0));\"},\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action. \"],\"predicate\":0},{\"type\":\"conditional\",\"content\":\"There is not enough support for this policy within the party.\",\"predicate\":2}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['peoples_party_support'] || 0) < 3);\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['last_advisor_action'] = 1;\"}],\"goTo\":[{\"id\":\"peoples_party\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"pfulf.womens_rights_\":{\"id\":\"pfulf.womens_rights_\",\"title\":\"Women's rights\",\"subtitle\":\"Enact policy with regards to women's rights.\",\"chooseIf\":{\"$code\":\"return (((Q['advisor_action_timer'] || 0)===0) && (((Q['spd_in_government'] || 0)) !== 0));\"},\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action. \"],\"predicate\":0},{\"type\":\"conditional\",\"content\":\"The SPD is not currently in government.\",\"predicate\":2}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (!(((Q['spd_in_government'] || 0)) !== 0));\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['womens_rights_timer'] = (Q['womens_rights_timer'] || 0) - 10;\\nQ['last_advisor_action'] = 1;\"}],\"goTo\":[{\"id\":\"womens_rights\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"pfulf\":{\"id\":\"pfulf\",\"type\":\"scene\",\"title\":\"Antonie Pfülf\",\"isPinnedCard\":true,\"tags\":[\"advisor\",\"centrist\"],\"cardImage\":\"img/portraits/PfülfAntonie.jpg\",\"viewIf\":{\"$code\":\"return ((Q['pfulf_advisor'] || 0)===1);\"},\"newPage\":true,\"options\":[{\"id\":\"@pfulf.support_peoples_party\"},{\"id\":\"@pfulf.build_peoples_party\"},{\"id\":\"@pfulf.campaigning_peoples_party\"},{\"id\":\"@pfulf.womens_rights_\"},{\"id\":\"@root\",\"title\":\"Return to main\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Antonie Pfülf\"},{\"type\":\"paragraph\",\"content\":\"Pfülf is a former teacher from Bavaria who came from a conservative Catholic family. She is an activist for women's rights and for broadening the support of the SPD.\"}]},\"sender.crisis\":{\"id\":\"sender.crisis\",\"title\":\"Addressing the economic crisis\",\"subtitle\":\"Sender can help support a left-wing economic program.\",\"chooseIf\":{\"$code\":\"return (((((Q['advisor_action_timer'] || 0) <= 0) && ((Q['nationalization_adopted'] || 0) == 0)) && ((Q['black_thursday_seen'] || 0) == 1)) && ((Q['nationalization_support'] || 0) <= 3));\"},\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action. \"],\"predicate\":0},{\"type\":\"conditional\",\"content\":\"We are not currently in an economic crisis. \",\"predicate\":2},{\"type\":\"conditional\",\"content\":\"We have already adopted the Left plan.\",\"predicate\":3}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['black_thursday_seen'] || 0) == 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['nationalization_adopted'] || 0) > 0);\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\"}],\"goTo\":[{\"id\":\"crisis_program.support_left\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"sender\":{\"id\":\"sender\",\"type\":\"scene\",\"title\":\"Toni Sender\",\"isPinnedCard\":true,\"tags\":[\"advisor\",\"left\"],\"cardImage\":\"img/portraits/SenderToni.jpg\",\"viewIf\":{\"$code\":\"return ((Q['sender_advisor'] || 0)===1);\"},\"newPage\":true,\"options\":[{\"id\":\"@sender.left_unity\"},{\"id\":\"@sender.organizing_women\"},{\"id\":\"@sender.against_toleration\"},{\"id\":\"@sender.crisis\"},{\"id\":\"@root\",\"title\":\"Return to main\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Toni Sender\"},{\"type\":\"paragraph\",\"content\":\"Toni Sender is an organizer and writer who came from a bourgeois family, but was radicalized into socialism after her experiences in the workforce. She was a member of the anti-war USPD, but did not support armed revolution.\"}]},\"stampfer.support_center\":{\"id\":\"stampfer.support_center\",\"onArrival\":[{\"$code\":\"Q['center_dissent'] = (Q['center_dissent'] || 0) - 8;\\nQ['center_strength'] = (Q['center_strength'] || 0) + 8;\"}],\"content\":{\"content\":\"Vorwärts prints editorials in support of centrist positions.\",\"type\":\"paragraph\"}},\"wels.snap_election\":{\"id\":\"wels.snap_election\",\"title\":\"Snap Election\",\"subtitle\":\"Call a snap election.\",\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":\"Wels must be Chancellor or President. \",\"predicate\":0},{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":2},\" months before next advisor action.\"],\"predicate\":1}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['chancellor'] != \\\"Wels\\\");\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}}]},\"chooseIf\":{\"$code\":\"return (((Q['advisor_action_timer'] || 0) == 0) && ((Q['chancellor'] == \\\"Wels\\\")));\"},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['time_to_election'] = 3;\"}],\"call\":\"set_next_election_time\",\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"We have called for new elections, set for \",{\"type\":\"insert\",\"insert\":0},\" \",{\"type\":\"insert\",\"insert\":1},\".\"]},\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_month'] || 0);\"},\"qdisplay\":\"month\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_year'] || 0);\"}}]}},\"wels\":{\"id\":\"wels\",\"type\":\"scene\",\"title\":\"Otto Wels\",\"isPinnedCard\":true,\"tags\":[\"advisor\",\"centrist\"],\"cardImage\":\"img/portraits/WelsOtto.jpg\",\"viewIf\":{\"$code\":\"return ((Q['wels_advisor'] || 0)===1);\"},\"newPage\":true,\"options\":[{\"id\":\"@wels.clear_agenda\"},{\"id\":\"@wels.party_discipline\"},{\"id\":\"@wels.emergency_fundraising\"},{\"id\":\"@wels.snap_election\"},{\"id\":\"@root\",\"title\":\"Return to main\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Otto Wels\"},{\"type\":\"paragraph\",\"content\":\"Wels is the long-time chairman of the SPD. He is a gifted organizer and a member of the centrist faction.\"}]},\"coalition_affairs.bring_down\":{\"id\":\"coalition_affairs.bring_down\",\"subtitle\":\"Bring down this government before our opponents do.\",\"onArrival\":[{\"$code\":\"Q['spd_in_government'] = 0;\\nQ['in_grand_coalition'] = 0;\\nQ['in_weimar_coalition'] = 0;\\nQ['chancellor'] = \\\"Brüning\\\";\\nQ['chancellor_party'] = \\\"Z\\\";\\n if (((Q['next_election_time'] || 0) > ((Q['time'] || 0) + 3)) ) { Q['next_election_time'] = ((Q['time'] || 0) + 3); } \\n if (((Q['next_election_time'] || 0) >= ((Q['time'] || 0) + 3)) ) { Q['next_election_month'] = ((Q['month'] || 0) + 3); } \\n if (((Q['next_election_time'] || 0) >= ((Q['time'] || 0) + 3)) ) { Q['next_election_year'] = (Q['year'] || 0); } \\n if (((Q['next_election_month'] || 0) > 12) ) { Q['next_election_year'] = (Q['next_election_year'] || 0) + 1; } \\n if (((Q['next_election_month'] || 0) > 12) ) { Q['next_election_month'] = (Q['next_election_month'] || 0) - 12; } \\nQ['spd_toleration'] = 0;\\nQ['left_strength'] = (Q['left_strength'] || 0) + 8;\\nQ['pro_republic'] = (Q['pro_republic'] || 0) - 5;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) - 3;\\nQ['rural_spd'] = (Q['rural_spd'] || 0) - 3;\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) - 3;\\nQ['catholics_spd'] = (Q['catholics_spd'] || 0) - 3;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 5;\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[\"We have called for a vote of no confidence in ourselves, and have brought down this government. Chancellor \",{\"type\":\"insert\",\"insert\":0},\" currently rules as acting chancellor.\"]},{\"type\":\"paragraph\",\"content\":[\"New elections have been set for \",{\"type\":\"insert\",\"insert\":1},\" \",{\"type\":\"insert\",\"insert\":2},\".\"]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_month'] || 0);\"},\"qdisplay\":\"month\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_year'] || 0);\"}}]}},\"coalition_affairs\":{\"id\":\"coalition_affairs\",\"type\":\"scene\",\"title\":\"Coalition Affairs\",\"newPage\":true,\"isCard\":true,\"tags\":[\"govt_affairs\"],\"onArrival\":[{\"$code\":\"Q['month_actions'] = (Q['month_actions'] || 0) + 1;\\nQ['coalition_affairs_timer'] = 5;\"}],\"viewIf\":{\"$code\":\"return (((((Q['spd_in_government'] || 0)===1) && ((Q['coalition_dissent'] || 0) >= 1)) && ((Q['coalition_affairs_timer'] || 0)===0)) && ((((((Q['in_grand_coalition'] || 0)) !== 0) || (((Q['in_weimar_coalition'] || 0)) !== 0)) || (((Q['in_popular_front'] || 0)) !== 0))));\"},\"cardImage\":\"img/muller_cabinet.jpg\",\"options\":[{\"id\":\"@coalition_affairs.promise_cuts\",\"title\":\"Agree to the bourgeois plans to cut welfare.\"},{\"id\":\"@coalition_affairs.resources\",\"title\":\"Use our party resources to support our allies.\"},{\"id\":\"@coalition_affairs.bring_down\",\"title\":\"Instead, we will bring down the government with a no-confidence vote, and call for new elections.\"},{\"id\":\"@coalition_affairs.no_change\",\"title\":\"Take none of these actions.\"},{\"id\":\"@easy_discard\"}],\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"Coalition Affairs\"},{\"type\":\"paragraph\",\"content\":[\"Our coalition is in trouble. The right-leaning members of the Center \",{\"type\":\"conditional\",\"content\":\"and DVP \",\"predicate\":0},\" are constantly criticizing us for our policies, and are threatening to call a vote of no confidence to collapse this government\",{\"type\":\"conditional\",\"content\":\", or to do the same for our government in the state of Prussia \",\"predicate\":1},\".\"]},{\"type\":\"paragraph\",\"content\":\"How do we reduce tensions with the coalition?\"}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['in_grand_coalition'] || 0)) !== 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['spd_prussia'] || 0)) !== 0);\"}}]}},\"agricultural_policy.state_buyer\":{\"id\":\"agricultural_policy.state_buyer\",\"title\":\"State Buyer\",\"subtitle\":{\"content\":[\"-2 budget - Create a state monopoly for grain purchases, guaranteeing prices for farmers and stable prices for consumers. \",{\"type\":\"conditional\",\"content\":\"The judiciary would never allow this.\",\"predicate\":0}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['judicial_reform'] || 0) < 2);\"}}]},\"chooseIf\":{\"$code\":\"return (((Q['budget'] || 0) >= 2) && ((Q['judicial_reform'] || 0) >= 2));\"},\"onArrival\":[{\"$code\":\"Q['budget'] = (Q['budget'] || 0) - 2;\\nQ['state_buyer'] = 1;\\nQ['rural_spd'] = (Q['rural_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['rural_nsdap'] = (Q['rural_nsdap'] || 0) - (3 * (1 - (Q['dissent'] || 0)));\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\n if ((((((Q['in_grand_coalition'] || 0)) !== 0) || (((Q['in_weimar_coalition'] || 0)) !== 0))) ) { Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1; } \\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 5;\\nQ['z_relation'] = (Q['z_relation'] || 0) - 3;\\nQ['peoples_party_support'] = (Q['peoples_party_support'] || 0) + 1;\\nQ['rural_policy'] = (Q['rural_policy'] || 0) + 2;\\nQ['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) + 1;\"}],\"maxVisits\":1,\"content\":{\"content\":\"Our new purchasing agency guarantees fair prices for farmers, while also providing lower food prices for workers and the urban poor. This policy necessitates heavy spending and an unprecedented level of state intervention in the economy, raising the ire of conservative economists.\",\"type\":\"paragraph\"},\"countVisitsMax\":1},\"agricultural_policy\":{\"id\":\"agricultural_policy\",\"type\":\"scene\",\"title\":\"Agricultural Policy\",\"newPage\":true,\"isCard\":true,\"onArrival\":[{\"$code\":\"Q['agricultural_policy_timer'] = (Q['agricultural_policy_timer'] || 0) + 6;\\nQ['month_actions'] = (Q['month_actions'] || 0) + 1;\"}],\"viewIf\":{\"$code\":\"return ((((Q['spd_in_government'] || 0)===1) && ((Q['agriculture_minister_party'] == \\\"SPD\\\"))) && ((Q['agricultural_policy_timer'] || 0) == 0));\"},\"cardImage\":\"img/portraits/BaadeFritz.jpg\",\"tags\":[\"govt_affairs\"],\"options\":[{\"id\":\"@agricultural_policy.land_reform\"},{\"id\":\"@agricultural_policy.agricultural_finance\"},{\"id\":\"@agricultural_policy.pro_consumer\"},{\"id\":\"@agricultural_policy.state_buyer\"},{\"id\":\"@root\",\"title\":\"Do not enact any policies for now.\"},{\"id\":\"@easy_discard\"},{\"id\":\"@cancel_advisor_action\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Agricultural Policy\"},{\"type\":\"paragraph\",\"content\":\"While agricultural policy has historically not been the domain of the SPD, there is much need for policy in this area. Our urban constituencies hope for cheaper and more stable food supplies, while small farmers need economic relief. There is also the movement for land reform, to break up the large aristocratic estates and redistribute land to peasants.\"}]},\"dealing_with_toleration.urge_success\":{\"id\":\"dealing_with_toleration.urge_success\",\"onArrival\":[{\"$code\":\"Q['welfare'] = (Q['welfare'] || 0) + 1;\\nQ['budget'] = (Q['budget'] || 0) - 1;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['z_relation'] = (Q['z_relation'] || 0) - 3;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 3;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) - 5;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) - 5;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) - 5;\"}],\"content\":{\"content\":\"We have successfully urged the coalition parties to increase social spending! Unfortunately, the center-right parties increasingly see us as a nuisance, and might not wish to continue these negotiations.\",\"type\":\"paragraph\"}},\"deport_hitler.force_fail\":{\"id\":\"deport_hitler.force_fail\",\"onArrival\":[{\"$code\":\"Q['sa_strength'] = (Q['sa_strength'] || 0) + 50;\\nQ['workers_nsdap'] = (Q['workers_nsdap'] || 0) + 5;\\nQ['unemployed_nsdap'] = (Q['unemployed_nsdap'] || 0) + 5;\\nQ['new_middle_nsdap'] = (Q['new_middle_nsdap'] || 0) + 5;\\nQ['old_middle_nsdap'] = (Q['old_middle_nsdap'] || 0) + 5;\\nQ['rural_nsdap'] = (Q['rural_nsdap'] || 0) + 5;\\nQ['coup_progress'] = (Q['coup_progress'] || 0) + 3;\"}],\"content\":{\"content\":\"Unfortunately, our forces fail to disloge the SA from their positions surrounding Hitler. He is seen as both a strong and powerful leader and a victim, further reinforcing his image. The Nazis are left stronger than ever.\",\"type\":\"paragraph\"}},\"economic_democracy.nationalize_1\":{\"id\":\"economic_democracy.nationalize_1\",\"title\":\"Begin to socialize key industries.\",\"subtitle\":\"-1 budget - we should buy out industries and govern them together with workers and consumers.\",\"onArrival\":[{\"$code\":\"Q['economic_democracy'] = (Q['economic_democracy'] || 0) + 1;\\nQ['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) + 1;\\nQ['budget'] = (Q['budget'] || 0) - 1;\\nQ['socializations'] = (Q['socializations'] || 0) + 1;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (6 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\n if ((((Q['in_grand_coalition'] || 0)) !== 0) ) { Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1; } \\n if ((((Q['black_thursday_seen'] || 0)) !== 0) ) { Q['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) + 1; } \\n if (((Q['unemployed'] || 0) > 9) ) { Q['unemployed'] = (Q['unemployed'] || 0) - 1; }\"}],\"chooseIf\":{\"$code\":\"return ((Q['budget'] || 0) >= 1);\"},\"maxVisits\":3,\"content\":{\"content\":\"We have begun to socialize key industries by buying out the capitalist owners, and creating coordinated governing boards consisting of worker, consumer, and state representatives. The capitalists are not pleased at our intrusion into the economy.\",\"type\":\"paragraph\"},\"countVisitsMax\":3},\"economic_policy.implement_wtb_no_deficit\":{\"id\":\"economic_policy.implement_wtb_no_deficit\",\"title\":\"Implement the WTB plan.\",\"subtitle\":{\"content\":[\"-\",{\"type\":\"insert\",\"insert\":0},\" budget. \",{\"type\":\"conditional\",\"content\":\"Our pro-labor policies have reduced the cost of the plan.\",\"predicate\":1}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['wtb_budget'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['wtb_budget'] || 0) == 3);\"}}]},\"unavailableSubtitle\":\"Unemployment is low enough that the time for the WTB-Plan has passed.\",\"viewIf\":{\"$code\":\"return ((((Q['budget'] || 0) >= (Q['wtb_budget'] || 0)) && ((Q['wtb_implemented'] || 0) == 0)) && ((Q['wtb_adopted'] || 0) == 1));\"},\"chooseIf\":{\"$code\":\"return ((Q['unemployed'] || 0) > 8);\"},\"onArrival\":[{\"$code\":\"Q['budget'] = (Q['budget'] || 0) - (Q['wtb_budget'] || 0);\\nQ['works_program'] = (Q['works_program'] || 0) + 1;\\nQ['unemployed'] = (Q['unemployed'] || 0) - 4;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (8 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (8 * (1 - (Q['dissent'] || 0)));\\nQ['wtb_implemented'] = (Q['wtb_implemented'] || 0) + 1;\\nQ['kpd_coalition_dissent'] = (Q['kpd_coalition_dissent'] || 0) + 1;\\n if (((((Q['in_popular_front'] || 0)) !== 0) || (((Q['in_left_front'] || 0)) !== 0)) ) { Q['kpd_relation'] = (Q['kpd_relation'] || 0) - 5; } \\nQ['inflation'] = (Q['inflation'] || 0) + 2;\"}],\"achievement\":\"wirtschaftspolitik\",\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"We have started to enact the WTB plan. Money is beginning to flow through the economy via investments in large-scale public works.\"},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":\"The KPD opposes the WTB plan, seeing it as a rescue of capitalism rather than a step towards real socialism.\",\"predicate\":0}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['in_popular_front'] || 0)) !== 0) || (((Q['in_left_front'] || 0)) !== 0));\"}}]}},\"domestic_enemies.ban_sh\":{\"id\":\"domestic_enemies.ban_sh\",\"onArrival\":[{\"$code\":\"Q['sh_strength'] = (Q['sh_strength'] || 0) * 0.85;\\n if (((Q['interior_police_loyalty'] || 0) >= 0.7) ) { Q['sh_strength'] = (Q['sh_strength'] || 0) * 0.7; } \\nQ['sh_banned'] = 1;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 5;\\nQ['prussian_police_loyalty'] = (Q['prussian_police_loyalty'] || 0) - 0.1;\\nQ['interior_police_loyalty'] = (Q['interior_police_loyalty'] || 0) - 0.05;\\n if (((((Q['spd_in_government'] || 0)===1) && ((Q['in_grand_coalition'] || 0)===1)) && (Q['president'] == \\\"Hindenburg\\\")) ) { Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1; } \\nQ['sh_ban_timer'] = 6;\"}],\"viewIf\":{\"$code\":\"return ((Q['sh_banned'] || 0) == 0);\"},\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"Banning the Stahlhelm weakens our relationship with President Hindenburg, as well as the political right and the police. \",\"predicate\":0},{\"type\":\"conditional\",\"content\":\"Banning the Stahlhelm weakens our relationship with the political right and the police. \",\"predicate\":1},\" \",{\"type\":\"conditional\",\"content\":\"It also weakens our coalition due to the influence of Hindenburg on the right wing of our coalition. \",\"predicate\":2},\" In addition, the Stahlhelm still operates out of public sight.\"]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['president'] == \\\"Hindenburg\\\");\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['president'] != \\\"Hindenburg\\\");\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['spd_in_government'] || 0)===1) && ((Q['in_grand_coalition'] || 0)===1)) && (Q['president'] == \\\"Hindenburg\\\"));\"}}]}},\"foreign_policy.improve_soviet\":{\"id\":\"foreign_policy.improve_soviet\",\"title\":\"Improve our relations with the Soviet Union.\",\"subtitle\":\"We could also broach the question of the KPD...\",\"options\":[{\"id\":\"@foreign_policy.soviet_economic_aid_yes_mil\",\"title\":\"Provide aid, in exchange for Reichswehr assistance.\"},{\"id\":\"@foreign_policy.soviet_economic_aid_yes\",\"title\":\"Provide aid, in exchange for only good relations.\"},{\"id\":\"@foreign_policy.soviet_economic_aid_no\",\"title\":\"Don't provide aid.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"The Soviet Union also suffered from the international order created by the Treaty of Versailles; they have been participating in our secret rearmament program. The Treaty of Rapallo in 1922 affirmed our friendly relations.\"},{\"type\":\"paragraph\",\"content\":\"The Soviets are asking for economic and developmental assistance. They are still a poor country on the whole, and are desperately trying to catch up to the western powers. There is a chance that our anti-communist coalition partners would be upset, but we could assuage them by asking the Soviets for secret assistance in training and equiping the Reichswehr.\"}]},\"fiscal_policy.cut_overall\":{\"id\":\"fiscal_policy.cut_overall\",\"subtitle\":\"-2 budget\",\"chooseIf\":{\"$code\":\"return ((Q['budget'] || 0) >= 2);\"},\"onArrival\":[{\"$code\":\"Q['budget'] = (Q['budget'] || 0) - 2;\\nQ['upper_tax_rates'] = (Q['upper_tax_rates'] || 0) - 1;\\nQ['lower_tax_rates'] = (Q['lower_tax_rates'] || 0) - 1;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['z_relation'] = (Q['z_relation'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\n if (((Q['unemployed'] || 0) >= 5) ) { Q['unemployed'] = (Q['unemployed'] || 0) - 1; } \\n if (((Q['upper_tax_rates'] || 0) < 0) ) { Q['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) - 1; } \\nQ['inflation'] = (Q['inflation'] || 0) + 0.4;\"}],\"content\":{\"content\":\"Cutting taxes benefits most the rich and middle-class, who pay more taxes than the working class. Our coalition partners are happy at our orthodox economic course.\",\"type\":\"paragraph\"}},\"labor_rights.safety\":{\"id\":\"labor_rights.safety\",\"onArrival\":[{\"$code\":\"Q['workers_safety'] = (Q['workers_safety'] || 0) + 1;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) - 5;\\nQ['labor_strength'] = (Q['labor_strength'] || 0) + 2;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\n if (((Q['workers_safety'] || 0) >= 3) ) { Q['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) + 1; }\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"The Labor Ministry works on developing and enforcing safety regulations, in order to ensure healty working conditions for the proletariat. \",{\"type\":\"conditional\",\"content\":\"Businesses have begun to argue that our focus on safety is overbearing and unnecessary, interfering with the economy.\",\"predicate\":0}]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['workers_safety'] || 0) >= 3);\"}}]}},\"police.investigate_corruption_failure\":{\"id\":\"police.investigate_corruption_failure\",\"content\":{\"content\":\"Unfortunately, our investigations have failed to turn up anything. Rumors are that the targets of our investigation were tipped off by infiltrators within the police.\",\"type\":\"paragraph\"}},\"prussian_affairs.ban_sa\":{\"id\":\"prussian_affairs.ban_sa\",\"viewIf\":{\"$code\":\"return (((Q['nazi_urgency'] || 0) >= 3) && ((Q['sa_banned'] || 0) == 0));\"},\"onArrival\":[{\"$code\":\"Q['sa_strength'] = (Q['sa_strength'] || 0) * 0.9;\\n if (((Q['prussian_police_loyalty'] || 0) >= 0.75) ) { Q['sa_strength'] = (Q['sa_strength'] || 0) * 0.75; } \\nQ['sa_banned'] = 1;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 3;\\nQ['prussian_police_loyalty'] = (Q['prussian_police_loyalty'] || 0) - 0.05;\\nQ['sa_militancy'] = (Q['sa_militancy'] || 0) - 0.05;\\nQ['sa_ban_timer'] = 6;\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"As it turns out, the Nazi SA has many allies in the police and bureaucracy. Our relationship with the police weakens, and the SA can still organize illegally, right under the police's noses. \",{\"type\":\"conditional\",\"content\":\"Nevertheless, the SA is substantially weakend by our ban. \",\"predicate\":0},\"\"]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['prussian_police_loyalty'] || 0) >= 0.7);\"}}]}},\"social_welfare.spending_same_pre_depression\":{\"id\":\"social_welfare.spending_same_pre_depression\",\"viewIf\":{\"$code\":\"return ((Q['unemployed'] || 0) <= 15);\"},\"content\":{\"content\":\"We have kept welfare spending the same.\",\"type\":\"paragraph\"}},\"womens_rights.liberalize\":{\"id\":\"womens_rights.liberalize\",\"maxVisits\":1,\"subtitle\":{\"content\":{\"type\":\"conditional\",\"content\":\"This is unlikely to succeed; we do not have majority support.\",\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['progressive_coalition'] || 0) < 50);\"}}]},\"goTo\":[{\"id\":\"womens_rights.liberalize_fail\",\"predicate\":{\"$code\":\"return ((Q['progressive_coalition'] || 0) < 50);\"}},{\"id\":\"womens_rights.liberalize_success\",\"predicate\":{\"$code\":\"return ((Q['progressive_coalition'] || 0) >= 50);\"}}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"},\"countVisitsMax\":1},\"all_quiet.everyone\":{\"id\":\"all_quiet.everyone\",\"chooseIf\":{\"$code\":\"return ((Q['prussian_police_loyalty'] || 0) >= 0.75);\"},\"unavailableSubtitle\":\"The police are unable to guarantee the safety of all the attendees.\",\"onArrival\":[{\"$code\":\"Q['nationalism'] = (Q['nationalism'] || 0) - 3;\\nQ['pro_republic'] = (Q['pro_republic'] || 0) + 3;\\nQ['workers_nsdap'] = (Q['workers_nsdap'] || 0) - 3;\\nQ['unemployed_nsdap'] = (Q['unemployed_nsdap'] || 0) - 3;\\nQ['new_middle_nsdap'] = (Q['new_middle_nsdap'] || 0) - 3;\"}],\"content\":{\"content\":\"Under police protection, crowds throng the film's showings, as Nazis protest outside. The reception is mixed, but a new national conversation develops, reexamining the right-wing histories of the war. Quietly, many minds are changed, or at least affected in subtle ways.\",\"type\":\"paragraph\"}},\"all_quiet\":{\"id\":\"all_quiet\",\"type\":\"scene\",\"title\":\"All Quiet on the Western Front\",\"subtitle\":\"Censorship and violence over a movie...\",\"viewIf\":{\"$code\":\"return ((((Q['year'] || 0)===1930) && ((Q['month'] || 0)===12)) && (((Q['spd_prussia'] || 0)) !== 0));\"},\"maxVisits\":1,\"tags\":[\"event\"],\"newPage\":true,\"faceImage\":\"img/All_Quiet.jpg\",\"options\":[{\"id\":\"@all_quiet.ban\",\"title\":\"Ban the film, to prevent Nazi violence.\"},{\"id\":\"@all_quiet.allow\",\"title\":\"Allow the film to be shown.\"},{\"id\":\"@all_quiet.allow_protect\",\"title\":\"Allow the film to be shown, and use the Prussian police to prevent Nazi disruptions.\"},{\"id\":\"@all_quiet.everyone\",\"title\":\"In fact, everyone needs to learn the lessons of this film. Give free tickets to students and government employees.\"}],\"content\":[{\"type\":\"heading\",\"content\":\"All Quiet on the Western Front\"},{\"type\":\"paragraph\",\"content\":[\"The American film \",{\"type\":\"emphasis-1\",\"content\":\"All Quiet on the Western Front\"},\", based on the German novel \",{\"type\":\"emphasis-1\",\"content\":\"Im Westen nichts Neues\"},\" by Erich Maria Remarque, is a film about the experiences of German soldiers in the Great War, and how they gradually became disillusioned with the ideas of patriotism and nationalism.\"]},{\"type\":\"paragraph\",\"content\":\"As an anti-war film, it is the target of major protest by far-right actors, especially the Nazis and the Stahlhelm. They are calling for the government to ban the film. If we do not ban it, the SA threatens to violently stop the film from being shown or watched.\"}],\"countVisitsMax\":1},\"austrian_customs_union.end_toleration_success\":{\"id\":\"austrian_customs_union.end_toleration_success\",\"onArrival\":[{\"$code\":\"Q['time_to_election'] = 3;\\nQ['spd_in_government'] = 0;\\nQ['in_grand_coalition'] = 0;\\nQ['spd_toleration'] = 0;\"}],\"call\":\"set_next_election_time\",\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[\"With the support of the KPD and DDP/DStP, we have successfully stopped the formation of the customs union. This results in the fall of the \",{\"type\":\"insert\",\"insert\":0},\" government.\"]},{\"type\":\"paragraph\",\"content\":[\"New elections have been set for \",{\"type\":\"insert\",\"insert\":1},\" \",{\"type\":\"insert\",\"insert\":2},\".\"]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_month'] || 0);\"},\"qdisplay\":\"month\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_year'] || 0);\"}}]}},\"banking_crisis.end_toleration\":{\"id\":\"banking_crisis.end_toleration\",\"viewIf\":{\"$code\":\"return ((Q['spd_toleration'] || 0)===1);\"},\"onArrival\":[{\"$code\":\"Q['time_to_election'] = 3;\\nQ['spd_in_government'] = 0;\\nQ['in_grand_coalition'] = 0;\\nQ['spd_toleration'] = 0;\"}],\"call\":\"set_next_election_time\",\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[\"We are tired of \",{\"type\":\"insert\",\"insert\":0},\"'s policy of austerity. After \",{\"type\":\"insert\",\"insert\":1},\"'s attempt to use emergency powers to pass another welfare cut, we have worked with the other parties to reverse this policy. In response, the Reichstag has been dissolved, and new elections called.\"]},{\"type\":\"paragraph\",\"content\":[\"New elections have been set for \",{\"type\":\"insert\",\"insert\":2},\" \",{\"type\":\"insert\",\"insert\":3},\".\"]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_month'] || 0);\"},\"qdisplay\":\"month\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_year'] || 0);\"}}]}},\"banking_crisis\":{\"id\":\"banking_crisis\",\"type\":\"scene\",\"title\":\"Banking Crisis\",\"subtitle\":\"The collapse of the German banking system...\",\"newPage\":true,\"onArrival\":[{\"$code\":\"Q['banking_crisis_seen'] = 1;\\nQ['workers_kpd'] = (Q['workers_kpd'] || 0) + 5;\\nQ['workers_nsdap'] = (Q['workers_nsdap'] || 0) + 3;\\nQ['new_middle_nsdap'] = (Q['new_middle_nsdap'] || 0) + 3;\\nQ['old_middle_nsdap'] = (Q['old_middle_nsdap'] || 0) + 4;\\nQ['rural_nsdap'] = (Q['rural_nsdap'] || 0) + 3;\\nQ['unemployed'] = (Q['unemployed'] || 0) + 3;\\nQ['crisis_urgency'] = (Q['crisis_urgency'] || 0) + 1;\\n if ((((Q['spd_in_government'] || 0)) !== 0) ) { Q['workers_spd'] = (Q['workers_spd'] || 0) - 4; } \\n if ((((Q['spd_in_government'] || 0)) !== 0) ) { Q['new_middle_spd'] = (Q['new_middle_spd'] || 0) - 5; } \\n if ((((Q['spd_in_government'] || 0)) !== 0) ) { Q['old_middle_spd'] = (Q['old_middle_spd'] || 0) - 5; } \\n if ((((Q['spd_in_government'] || 0)) !== 0) ) { Q['rural_spd'] = (Q['rural_spd'] || 0) - 4; }\"}],\"tags\":[\"event\"],\"viewIf\":{\"$code\":\"return (((Q['customs_union'] || 0)===1) && ((Q['banking_crisis_timer'] || 0)===0));\"},\"maxVisits\":1,\"faceImage\":\"img/danat_bank.jpg\",\"options\":[{\"id\":\"@banking_crisis.nothing_to_do\",\"title\":\"There is nothing we can do.\"},{\"id\":\"@banking_crisis.stabilization\",\"title\":\"Take action to stabilize the economy!\"},{\"id\":\"@banking_crisis.austerity\",\"title\":{\"content\":[\"Chancellor \",{\"type\":\"insert\",\"insert\":0},\"'s response is, as always, more austerity.\"],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor'] || 0);\"}}]}},{\"id\":\"@banking_crisis.end_toleration\",\"title\":\"We are tired of austerity. End the toleration arrangement!\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Banking Crisis\"},{\"type\":\"paragraph\",\"content\":\"The Darmstädter und Nationalbank, or Danat Bank, has collapsed! Along with it goes much of the German banking system. The cause seemed to be due to the government's pursuit of a customs union with Austria, which led to de facto international sanctions.\"},{\"type\":\"paragraph\",\"content\":\"This is a bourgeois dispute, but the costs will be borne by the proletariat. The people are facing ever-increasing hunger and poverty, and perhaps we are partly to blame.\"}],\"countVisitsMax\":1},\"blutmai.no_fault\":{\"id\":\"blutmai.no_fault\",\"content\":{\"content\":\"This position gains us no allies, and does not alienate anyone any further.\",\"type\":\"paragraph\"}},\"altona_clashes.allow_police_no_violence\":{\"id\":\"altona_clashes.allow_police_no_violence\",\"onArrival\":[{\"$code\":\"Q['sa_strength'] = (Q['sa_strength'] || 0) + 10;\"}],\"content\":{\"content\":\"When the march arrives in Altona, they are immediately confronted by an angry crowd of communists and socialists, who throw objects at the Nazis. The police attempt to separate the two groups, to no avail. Gunshots are heard, reportedly from rooftop snipers. The police manage to keep their cool, the shots stop, and the march disperses without further violence.\",\"type\":\"paragraph\"}},\"businesses_lose_confidence.watch\":{\"id\":\"businesses_lose_confidence.watch\",\"content\":{\"content\":\"Presumably, we have an economic plan that will lead us out of the crisis. The capitalists do not trust us, but we will show them eventually.\",\"type\":\"paragraph\"}},\"businesses_lose_confidence\":{\"id\":\"businesses_lose_confidence\",\"type\":\"scene\",\"title\":\"Businesses Lose Confidence\",\"subtitle\":\"Big businesses are losing confidence in our government's policies.\",\"viewIf\":{\"$code\":\"return ((((((Q['capital_strike_progress'] || 0) >= 6) && ((Q['capital_strike_progress'] || 0) < 10)) && ((Q['budget'] || 0) > -5))) && (((Q['spd_in_government'] || 0)) !== 0));\"},\"newPage\":true,\"maxVisits\":1,\"onArrival\":[{\"$code\":\"Q['unemployed'] = (Q['unemployed'] || 0) + 2;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) - 6;\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) - 6;\\nQ['rural_spd'] = (Q['rural_spd'] || 0) - 5;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 4;\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) - 4;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 6;\"}],\"tags\":[\"event\"],\"options\":[{\"id\":\"@businesses_lose_confidence.taxes\",\"title\":\"Cut taxes for the upper brackets.\"},{\"id\":\"@businesses_lose_confidence.welfare\",\"title\":\"Reduce welfare and social spending.\"},{\"id\":\"@businesses_lose_confidence.nothing\",\"title\":\"We will not take any action for now.\"},{\"id\":\"@businesses_lose_confidence.watch\",\"title\":[\"Just watch us. The economy \",{\"type\":\"emphasis-1\",\"content\":\"will\"},\" improve.\"]}],\"content\":[{\"type\":\"heading\",\"content\":\"Businesses Lose Confidence\"},{\"type\":\"paragraph\",\"content\":\"Because of our government's policies, which are perceived as anti-business, the capitalists are reducing their investment and laying off workers. This has the immediate effect of raising unemployment and dissent against our government, especially among the middle class.\"},{\"type\":\"paragraph\",\"content\":\"The business community has a variety of suggestions as to how we might improve the business environment.\"}],\"countVisitsMax\":1},\"capital_strike.nothing\":{\"id\":\"capital_strike.nothing\",\"title\":\"There is nothing we can do.\",\"content\":{\"content\":\"There is nothing we can do that is within constitutional and legal bounds.\",\"type\":\"paragraph\"}},\"capital_strike\":{\"id\":\"capital_strike\",\"type\":\"scene\",\"title\":\"Capital Strike\",\"subtitle\":\"Germany's industries are idling...\",\"viewIf\":{\"$code\":\"return (((((Q['capital_strike_progress'] || 0) >= 10) || ((Q['budget'] || 0) <= -5))) && (((Q['spd_in_government'] || 0)) !== 0));\"},\"newPage\":true,\"maxVisits\":1,\"onArrival\":[{\"$code\":\"Q['unemployed'] = (Q['unemployed'] || 0) + 5;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) * 0.7;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) - 15;\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) - 15;\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) * 0.7;\\nQ['rural_spd'] = (Q['rural_spd'] || 0) - 15;\\nQ['pro_republic'] = (Q['pro_republic'] || 0) - 15;\\nQ['capital_strike_seen'] = 1;\\nQ['z_relation'] = (Q['z_relation'] || 0) - 10;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 10;\\nQ['workers_nsdap'] = (Q['workers_nsdap'] || 0) + 8;\\nQ['unemployed_nsdap'] = (Q['unemployed_nsdap'] || 0) + 10;\\nQ['new_middle_nsdap'] = (Q['new_middle_nsdap'] || 0) + 15;\\nQ['old_middle_nsdap'] = (Q['old_middle_nsdap'] || 0) + 15;\\nQ['rural_nsdap'] = (Q['rural_nsdap'] || 0) + 15;\"}],\"tags\":[\"event\"],\"options\":[{\"id\":\"@capital_strike.seize\"},{\"id\":\"@capital_strike.capital_controls\"},{\"id\":\"@capital_strike.propaganda\"},{\"id\":\"@capital_strike.nothing\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Capital Strike\"},{\"type\":\"paragraph\",\"content\":\"Our policies have greatly angered the capitalists. Investment has fallen, and factories are idling, preventing the workers from fulfilling their jobs. Meanwhile, the bourgeois press is a constant chorus of venomous invective directed at us and our economic policies.\"},{\"type\":\"paragraph\",\"content\":\"What can we do?\"}],\"countVisitsMax\":1},\"death_of_muller.breitscheid_chancellor\":{\"id\":\"death_of_muller.breitscheid_chancellor\",\"onArrival\":[{\"$code\":\"Q['chancellor'] = \\\"Breitscheid\\\";\\nQ['chancellor_party'] = \\\"SPD\\\";\\nQ['z_relation'] = (Q['z_relation'] || 0) - 5;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 5;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) + 1;\"}],\"subtitle\":\"The Center Party is worried about his left-leaning tendencies.\",\"content\":{\"content\":\"Our coalition partners are reluctant to accept the new Chancellor, but they do not make loud objections.\",\"type\":\"paragraph\"}},\"civil_war.general_strike\":{\"id\":\"civil_war.general_strike\",\"maxVisits\":1,\"goTo\":[{\"id\":\"civil_war.war_menu\"}],\"onArrival\":[{\"$code\":\"Q['war_choices'] = (Q['war_choices'] || 0) + 1;\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"A general strike stopped the Kapp Putsch in 1920, and it can stop fascism today. \",{\"type\":\"conditional\",\"content\":\"The workers are largely united with us. \",\"predicate\":0},{\"type\":\"conditional\",\"content\":\"There is some dissent within labor, but a majority of workers support the general strike. \",\"predicate\":1},{\"type\":\"conditional\",\"content\":\"However, there is substantial dissent within labor, and less than half support the general strike. \",\"predicate\":2},{\"type\":\"conditional\",\"content\":\"However, labor is deeply divided, and most workers do not heed the call to strike.\",\"predicate\":3}]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['normalized_workers_total'] || 0) > 70);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['normalized_workers_total'] || 0) >= 50) && ((Q['normalized_workers_total'] || 0) <= 70));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['normalized_workers_total'] || 0) > 30) && ((Q['normalized_workers_total'] || 0) < 50));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['normalized_workers_total'] || 0) <= 30);\"}}]},\"countVisitsMax\":1},\"high_inflation.bank\":{\"id\":\"high_inflation.bank\",\"onArrival\":[{\"$code\":\"Q['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) + 2;\"}],\"content\":{\"content\":\"Unfortunately, but perhaps expectedly, the Reichsbank is refusing to help the government, claiming that our socialist policies are solely to blame. Reichsbank president Hjalmar Schacht is all but calling for the fall of the government.\",\"type\":\"paragraph\"}},\"election_1928.coalition_menu\":{\"id\":\"election_1928.coalition_menu\",\"options\":[{\"id\":\"@election_1928.spd_majority\"},{\"id\":\"@election_1928.weimar_coalition\"},{\"id\":\"@election_1928.grand_coalition\"},{\"id\":\"@election_1928.new_grand_coalition\"},{\"id\":\"@election_1928.unity_government\"},{\"id\":\"@election_1928.far_right_coalition\"},{\"id\":\"@election_1928.no_majority\"},{\"id\":\"@election_1928.brauns_dilemma\"},{\"id\":\"@election_1928.left_coalition\"},{\"id\":\"@election_1928.popular_front_coalition\"},{\"id\":\"@election_1928.right_coalition\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"kpd_policy.economy\":{\"id\":\"kpd_policy.economy\",\"title\":\"Economy Ministry\",\"subtitle\":\"The Economy Ministry is pursuing a policy of nationalizations.\",\"viewIf\":{\"$code\":\"return (Q['economy_minister_party'] == \\\"KPD\\\");\"},\"options\":[{\"id\":\"@kpd_policy.economy_support\",\"title\":\"Yes, support the nationalization policy.\"},{\"id\":\"@kpd_policy.economy_oppose\",\"title\":\"No, this must be stopped.\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[\"The KPD-controlled Economy Ministry is planning a policy of mass nationalizations. \",{\"type\":\"conditional\",\"content\":\"They plan to use deficit spending to finance state takeovers of underutilized industrial enterprises, and run them for the benefit of the workers. \",\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"They plan to buy out closed and underutilized industrial enterprises, and run them at full capacity for the benefit of the workers. \",\"predicate\":1},\"\"]},{\"type\":\"paragraph\",\"content\":\"Do we support this policy?\"}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['budget'] || 0) < 3);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['budget'] || 0) >= 3);\"}}]}},\"kpd_ultimatum.popular_front_achievement\":{\"id\":\"kpd_ultimatum.popular_front_achievement\",\"onArrival\":[{\"$code\":\"Q['popular_front_success'] = (Q['popular_front_success'] || 0) + 1;\"}],\"achievement\":\"volksfront_2\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"kpd_vote_of_no_confidence.resources\":{\"id\":\"kpd_vote_of_no_confidence.resources\",\"chooseIf\":{\"$code\":\"return (((Q['resources'] || 0) >= 3) && ((Q['kpd_ultimatum_seen'] || 0)===0));\"},\"unavailableSubtitle\":{\"content\":[\"-3 resources - \",{\"type\":\"conditional\",\"content\":\"We do not have enough resources. \",\"predicate\":0},{\"type\":\"conditional\",\"content\":\"This is beyond the point when resources could fix.\",\"predicate\":1}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['resources'] || 0) < 3);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['kpd_ultimatum_seen'] || 0)) !== 0);\"}}]},\"subtitle\":\"-3 resources\",\"onArrival\":[{\"$code\":\"Q['resources'] = (Q['resources'] || 0) - 3;\\nQ['kpd_coalition_dissent'] = (Q['kpd_coalition_dissent'] || 0) - 1;\"}],\"content\":{\"content\":\"By transferring resources to our coalition partners, we can reduce their dissent against our policies. This is a crude, but effective solution.\",\"type\":\"paragraph\"}},\"march_on_berlin.accept_hitler\":{\"id\":\"march_on_berlin.accept_hitler\",\"onArrival\":[{\"$code\":\"Q['chancellor'] = \\\"Hitler\\\";\\nQ['chancellor_party'] = \\\"NSDAP\\\";\\nQ['spd_in_government'] = 0;\"}],\"options\":[{\"id\":\"@hitler_takes_power\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"After the resignation of the chancellor, Hitler has been appointed chancellor\",{\"type\":\"conditional\",\"content\":\", after being made a citizen again \",\"predicate\":0},\".\"]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['hitler_deported'] || 0)) !== 0);\"}}]}},\"panzerkreuzer.braun\":{\"id\":\"panzerkreuzer.braun\",\"onArrival\":[{\"$code\":\"Q['panzerkreuzer_funded'] = 0;\\nQ['nationalism'] = (Q['nationalism'] || 0) - (3 * (1 - (Q['dissent'] || 0)));\\nQ['panzerkreuzer_failed'] = 1;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\"}],\"content\":{\"content\":\"Our coalition partners are shocked by our intransigence! However, Chancellor Braun manages to persuade our cabinet ministers to drop the plan to vote on the battlecruiser. The ship will not be built!\",\"type\":\"paragraph\"}},\"constitutional_reform.constructive_vonc\":{\"id\":\"constitutional_reform.constructive_vonc\",\"subtitle\":\"Votes of no confidence can only be called if an alternative plan for government formation can be passed, greatly reducing their incidence.\",\"onArrival\":[{\"$code\":\"Q.reform_support = Q.spd_normalized + Q.ddp_normalized;\\nif (Q.z_relation >= 30) {\\n    Q.reform_support += Q.z_normalized - 0.03;\\n}\\nif (!Q.stresemann_dead) {\\n    Q.reform_support += Q.dvp_normalized;\\n}\"}],\"viewIf\":{\"$code\":\"return ((Q['constructive_vonc'] || 0)===0);\"},\"options\":[{\"id\":\"@constitutional_reform.constructive_vonc_2\",\"title\":\"Call a constitutional referendum to pass the reform!\"},{\"id\":\"@constitutional_reform.reforms_menu\",\"title\":\"See other reform options.\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"The Weimar Coalition parties, the DDP and Center Party, support this reform, which will greatly improve the stability of the government. \",\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"The DDP supports this reform, but the Center Party does not trust us enough to support the constitutional referendum. \",\"predicate\":1},\" The more conservative and radical right-wing parties and the KPD are in opposition, as they seem to relish in the republican system's instability.\"]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['z_relation'] || 0) >= 30);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['z_relation'] || 0) < 30);\"}}]}},\"popular_front_dispute.finance\":{\"id\":\"popular_front_dispute.finance\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"presidential_election_1932.support_thalmann\":{\"id\":\"presidential_election_1932.support_thalmann\",\"chooseIf\":{\"$code\":\"return (((Q['kpd_relation'] || 0) >= 50) && ((Q['reformist_strength'] || 0) < (Q['left_strength'] || 0)));\"},\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":\"We do not have good enough relations with the Communists, so they are not even willing to accept our support. \",\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"The reformist faction is able to dissuade the party from supporting this arrangement.\",\"predicate\":1}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['kpd_relation'] || 0) < 50);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['reformist_strength'] || 0) >= (Q['left_strength'] || 0));\"}}]},\"options\":[{\"id\":\"@presidential_election_1932.support_thalmann_2\",\"title\":\"Yes, we will support Thälmann, despite the reformists' pleas against it.\"},{\"id\":\"@presidential_election_1932.support_braun\",\"title\":\"Support Braun instead.\"},{\"id\":\"@presidential_election_1932.support_hindenburg\",\"title\":\"Support Hindenburg instead.\"}],\"content\":{\"content\":\"Supporting Thälmann is rather unpopular in our party, even if the Communists accept our support. Are we sure?\",\"type\":\"paragraph\"}},\"prussian_coup.defend_2_victory_2\":{\"id\":\"prussian_coup.defend_2_victory_2\",\"achievement\":\"drei_pfeile\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"panzerkreuzer_b.built\":{\"id\":\"panzerkreuzer_b.built\",\"onArrival\":[{\"$code\":\"Q['panzerkreuzer_b_funded'] = 1;\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"Chancellor \",{\"type\":\"insert\",\"insert\":0},\" brings the matter to a full Reichstag vote, which passes with all parties in favor except the SPD and KPD. The ship will be built.\"]},\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor'] || 0);\"}}]}},\"unemployment_insurance_1.destroy\":{\"id\":\"unemployment_insurance_1.destroy\",\"call\":\"set_next_election_time\",\"onArrival\":[{\"$code\":\"Q['time_to_election'] = 3;\\nQ['spd_in_government'] = 0;\\nQ['in_grand_coalition'] = 0;\\nQ['spd_toleration'] = 0;\\nQ['z_relation'] = (Q['z_relation'] || 0) - 8;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 10;\\nQ['chancellor'] = \\\"Brüning\\\";\\nQ['chancellor_party'] = \\\"Z \\\";\\nQ['welfare'] = (Q['welfare'] || 0) - 2;\\nQ['budget'] = (Q['budget'] || 0) + 1;\\nQ['inflation'] = (Q['inflation'] || 0) - 2;\\nQ['foreign_minister_party'] = \\\"DVP\\\";\\nQ['interior_minister_party'] = \\\"Z\\\";\\nQ['justice_minister_party'] = \\\"I\\\";\\nQ['labor_minister_party'] = \\\"Z\\\";\\nQ['reichswehr_minister_party'] = \\\"I\\\";\\nQ['economic_minister_party'] = \\\"DDP\\\";\\nQ['finance_minister_party'] = \\\"DVP\\\";\\nQ['agriculture_minister_party'] = \\\"Z\\\";\\nQ['spd_no_confidence'] = 1;\\nQ['pro_republic'] = (Q['pro_republic'] || 0) - 4;\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) - 3;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) - 2;\\nQ['rural_spd'] = (Q['rural_spd'] || 0) - 2;\\nQ['catholics_spd'] = (Q['catholics_spd'] || 0) - 2;\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"Fine. If the bourgeoisie wish to blow up the government, let them do so. Socialists will not be complicit in the destruction of the working class.\"},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"Heinrich Brüning of the Center Party has been appointed Chancellor. \",\"predicate\":0},\" Brüning now leads an all-bourgeois cabinet. Using the emergency powers of Article 48, Brüning and President Hindenburg have passed the welfare cuts over the objections of the Reichstag.\"]},{\"type\":\"paragraph\",\"content\":[\"New elections have been set for \",{\"type\":\"insert\",\"insert\":1},\" \",{\"type\":\"insert\",\"insert\":2},\".\"]}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['chancellor_party'] == \\\"SPD\\\");\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_month'] || 0);\"},\"qdisplay\":\"month\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_year'] || 0);\"}}]}},\"vote_of_no_confidence.resources\":{\"id\":\"vote_of_no_confidence.resources\",\"chooseIf\":{\"$code\":\"return ((Q['resources'] || 0) >= 3);\"},\"unavailableSubtitle\":\"We do not have enough resources.\",\"subtitle\":\"-3 resources\",\"onArrival\":[{\"$code\":\"Q['resources'] = (Q['resources'] || 0) - 3;\\nQ['coalition_dissent'] = (Q['coalition_dissent'] || 0) - 1;\"}],\"content\":{\"content\":\"By transferring resources to our coalition partners, we can reduce their dissent against our policies. This is a crude, but effective solution.\",\"type\":\"paragraph\"}},\"young_plan.no_plan\":{\"id\":\"young_plan.no_plan\",\"onArrival\":[{\"$code\":\"Q['nationalism'] = (Q['nationalism'] || 0) + 5;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 3;\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) - 3;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) - 3;\\nQ['pacifism'] = (Q['pacifism'] || 0) - 1;\\nQ['workers_nsdap'] = (Q['workers_nsdap'] || 0) + 5;\\nQ['rural_nsdap'] = (Q['rural_nsdap'] || 0) + 5;\\nQ['rural_dnvp'] = (Q['rural_dnvp'] || 0) - 5;\\nQ['catholics_spd'] = (Q['catholics_spd'] || 0) - 5;\\nQ['rural_dvp'] = (Q['rural_dvp'] || 0) - 5;\"}],\"content\":{\"content\":\"The referendum easily fails with or without our presence in the campaign, with only around 15% of voters supporting it. However, nationalist sentiment is inflammed, and the right-wing parties are using our silence around the Plan as a tacit admission of its faults. Our silence has only emboldened the Right, especially the NSDAP.\",\"type\":\"paragraph\"}},\"young_plan\":{\"id\":\"young_plan\",\"type\":\"scene\",\"title\":\"Young Plan\",\"newPage\":true,\"subtitle\":\"A new agreement on reparations\",\"tags\":[\"event\"],\"viewIf\":{\"$code\":\"return (((((Q['year'] || 0)===1929) && ((Q['month'] || 0) >= 7)) && ((Q['in_right_coalition'] || 0)===0)) && ((Q['young_plan_seen'] || 0)===0));\"},\"onArrival\":[{\"$code\":\"Q['young_plan_seen'] = 1;\"}],\"maxVisits\":1,\"options\":[{\"id\":\"@young_plan.pro_plan\",\"title\":\"Campaign in favor of the Young Plan and against the referendum.\"},{\"id\":\"@young_plan.no_plan\",\"title\":\"Do not campaign on the Young Plan, one way or another.\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Young Plan\"},{\"type\":\"paragraph\",\"content\":\"The Young Plan is an agreement with the Western powers to reduce Germany's reparation payments and give us more fiscal autonomy. Simultaneously, France will agree to withdraw its military occupation from the Rhineland.\"},{\"type\":\"paragraph\",\"content\":\"While this seems to be a positive development for the country, the Right is campaigning hard against this plan, as are the Communists for whatever reason. They claim that any reparations are a form of national slavery, and have organized a referendum against it.\"}],\"countVisitsMax\":1},\"confronting_nazis.iron_front\":{\"id\":\"confronting_nazis.iron_front\",\"title\":\"Form the Iron Front!\",\"subtitle\":\"The Iron Front consists of the SPD, the trade unions, and the Reichsbanner.\",\"viewIf\":{\"$code\":\"return (((Q['nazi_urgency'] || 0) >= 3) && ((Q['iron_front_formed'] || 0) == 0));\"},\"onArrival\":[{\"$code\":\"Q['iron_front_formed'] = 1;\\nQ['radicalization'] = (Q['radicalization'] || 0) + 1;\\nQ['nazi_urgency'] = (Q['nazi_urgency'] || 0) + 1;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['pro_republic'] = (Q['pro_republic'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['left_dissent'] = (Q['left_dissent'] || 0) - 8;\\nQ['neorevisionist_dissent'] = (Q['neorevisionist_dissent'] || 0) - 10;\\nQ['neorevisionist_strength'] = (Q['neorevisionist_strength'] || 0) + 5;\"}],\"achievement\":\"eiserne_front\",\"options\":[{\"id\":\"@confronting_nazis.unity\",\"title\":\"Unity, Activity, and Discipline.\"},{\"id\":\"@confronting_nazis.anti\",\"title\":\"Opposition to Fascism, Stalinism, and Monarchism.\"},{\"id\":\"@confronting_nazis.orgs\",\"title\":\"The SPD, ADGB, and Reichsbanner.\"},{\"id\":\"@confronting_nazis.wtb\",\"title\":\"Woytinsky, Tarnow, and Baade of the WTB-Plan\"},{\"id\":\"@confronting_nazis.all\",\"title\":\"All of the above.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[\"The Nazi threat can no longer be ignored. We must build a new organization to confront them - the Iron Front - consisting of the SPD, the ADGB trade union federation, and the \",{\"type\":\"emphasis-1\",\"content\":\"Reichsbanner Schwarz-Rot-Gold\"},\". We have a new symbol - the Three Arrows, pointing down towards the left.\"]},{\"type\":\"paragraph\",\"content\":\"What do the three arrows stand for?\"}]},\"campaigning.rural\":{\"id\":\"campaigning.rural\",\"subtitle\":\"-1 resources\",\"chooseIf\":{\"$code\":\"return ((Q['resources'] || 0) >= 1);\"},\"unavailableSubtitle\":\"Not enough resources.\",\"onArrival\":[{\"$code\":\"Q['rural_spd'] = (Q['rural_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\n if (((Q['peoples_party'] || 0) == 0) ) { Q['rural_spd'] = (Q['rural_spd'] || 0) - (3 * (1 - (Q['dissent'] || 0))); } \\nQ['resources'] = (Q['resources'] || 0) - 1;\\nQ['peoples_party_support'] = (Q['peoples_party_support'] || 0) + 1;\\n if (((Q['rural_policy'] || 0) >= 2) ) { Q['rural_spd'] = (Q['rural_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0))); }\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"We have increased our campaigning among farmers. \",{\"type\":\"conditional\",\"content\":\"We have not historically campaigned much among the farmers, and they do not trust us. \",\"predicate\":0},{\"type\":\"conditional\",\"content\":\"As a people's party, we have an easier time increasing support among farmers than before. \",\"predicate\":1},{\"type\":\"conditional\",\"content\":\"Our rural policies have made it easier for us to build support among farmers.\",\"predicate\":2}]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['peoples_party'] || 0) == 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['peoples_party'] || 0) > 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['rural_policy'] || 0) >= 2);\"}}]}},\"crisis_program.plan_adopted\":{\"id\":\"crisis_program.plan_adopted\",\"onArrival\":[{\"$code\":\"Q['wtb_adopted'] = 1;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) - 15;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) - 10;\\nQ['labor_strength'] = (Q['labor_strength'] || 0) + 10;\\nQ['center_strength'] = (Q['center_strength'] || 0) - 10;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) + 20;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 5;\\nQ['economic_plan'] = 1;\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"With our hard work, we have finally convinced the majority of the party to adopt the WTB plan! \",{\"type\":\"conditional\",\"content\":\"We can begin implementing the plan as soon as possible, as long as we have the Economic or Finance ministries. \",\"predicate\":0},{\"type\":\"conditional\",\"content\":\"We should emphasize the plan in our electoral propaganda.\",\"predicate\":1}]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['spd_in_government'] || 0) == 1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['spd_in_government'] || 0)===0);\"}}]}},\"enemies.kpd\":{\"id\":\"enemies.kpd\",\"onArrival\":[{\"$code\":\"Q['enemies'] = \\\"KPD\\\";\\nQ['reformist_strength'] = (Q['reformist_strength'] || 0) + 5;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 8;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) - 5;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) - 15;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) + 5;\\nQ['z_relation'] = (Q['z_relation'] || 0) + 5;\\nQ['workers_kpd'] = (Q['workers_kpd'] || 0) - 4;\"}],\"content\":{\"content\":\"Attacking the KPD is supported by all but the most left-wing socialists, and wins us some measure of approval among the bourgeois parties. However, If we are to reconcile with the KPD, this may not be the best choice.\",\"type\":\"paragraph\"}},\"ideology.reform\":{\"id\":\"ideology.reform\",\"onArrival\":[{\"$code\":\"if (Q.ideology && Q.ideology != \\\"reformist\\\") {\\n    Q.changed = 1;\\n}\"}],\"goTo\":[{\"id\":\"ideology.changed\",\"predicate\":{\"$code\":\"return ((Q['changed'] || 0)===1);\"}}],\"onDeparture\":[{\"$code\":\"Q['ideology'] = \\\"reformist\\\";\\nQ['reformist_strength'] = (Q['reformist_strength'] || 0) + 10;\\nQ['democratization'] = (Q['democratization'] || 0) + 1;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) - 5;\\nQ['z_relation'] = (Q['z_relation'] || 0) + 5;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) + 5;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) - 8;\\nQ['moderate_plan_support'] = (Q['moderate_plan_support'] || 0) + 1;\"}],\"content\":{\"content\":\"The reformist wing of the party seeks to preserve the Republic and the democratic system of government, and is most supportive of coalitions with the other pro-democracy parties.\",\"type\":\"paragraph\"}},\"inter_party_relationships.yes_history\":{\"id\":\"inter_party_relationships.yes_history\",\"onArrival\":[{\"$code\":\"Q['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 12;\\nQ['reformist_strength'] = (Q['reformist_strength'] || 0) - 2;\\nQ['neorevisionist_dissent'] = (Q['neorevisionist_dissent'] || 0) + 5;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) - 6;\\nQ['left_strength'] = (Q['left_strength'] || 0) + 5;\\nQ['kpd_rectified_history'] = 1;\\nQ['z_relation'] = (Q['z_relation'] || 0) - 6;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 6;\\nQ['ddp_relation'] = (Q['ddp_relation'] || 0) - 4;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) + (8 * (1 - (Q['dissent'] || 0)));\\nQ['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1;\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"As part of normalizing relations with the KPD, we have to acknowledge the wrongdoings of our past. We have expelled Noske, and have held public commemorations for those killed by troops during the uprisings.\"},{\"type\":\"paragraph\",\"content\":\"This leads to tensions with the moderates and reformists within our party, and criticism from the conservative and liberal parties.\"}]},\"international_relations.comintern\":{\"id\":\"international_relations.comintern\",\"subtitle\":\"-1 resources\",\"chooseIf\":{\"$code\":\"return ((Q['resources'] || 0) >= 1);\"},\"unavailableSubtitle\":\"Not enough resources.\",\"onArrival\":[{\"$code\":\"Q['resources'] = (Q['resources'] || 0) - 1;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\n if (((Q['comintern_seen'] || 0) == 0) ) { Q['communist_coalition'] = (Q['communist_coalition'] || 0) + 1; } \\nQ['comintern_seen'] = (Q['comintern_seen'] || 0) + 1;\"}],\"content\":{\"content\":\"The Stalinists of the KPD insists on calling us \\\"social fascists\\\", suggesting that we social democrats are as bad or worse than actual fascists. Needless to say, this is not good for our relationship with the Communists. By observing the Comintern, we can better understand the KPD, enabling us to potentially improve relations, or counter the KPD if it may come to that.\",\"type\":\"paragraph\"}},\"iron_front.wtb\":{\"id\":\"iron_front.wtb\",\"viewIf\":{\"$code\":\"return ((Q['wtb_adopted'] || 0) == 1);\"},\"onArrival\":[{\"$code\":\"Q['workers_spd'] = (Q['workers_spd'] || 0) + (8 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (8 * (1 - (Q['dissent'] || 0)));\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\nQ['rural_spd'] = (Q['rural_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\"}],\"content\":{\"content\":\"The WTB-Plan is the rallying point for the entire SPD and its affiliated organizations, including the Iron Front.\",\"type\":\"paragraph\"}},\"media.radio\":{\"id\":\"media.radio\",\"title\":\"Why not fund a radio station?\",\"subtitle\":\"-2 resources\",\"chooseIf\":{\"$code\":\"return ((Q['resources'] || 0) >= 2);\"},\"unavailableSubtitle\":\"Not enough resources.\",\"viewIf\":{\"$code\":\"return ((Q['radio'] || 0)===0);\"},\"onArrival\":[{\"$code\":\"Q['radio'] = (Q['radio'] || 0) + 1;\\nQ['resources'] = (Q['resources'] || 0) - 2;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (2 * (1 - (Q['dissent'] || 0)));\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) + 5;\\nQ['socialism'] = (Q['socialism'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\n if (((Q['pacifism'] || 0) > 1) ) { Q['nationalism'] = (Q['nationalism'] || 0) - (3 * (1 - (Q['dissent'] || 0))); } \\n if (((Q['democratization'] || 0) > 1) ) { Q['pro_republic'] = (Q['pro_republic'] || 0) + (3 * (1 - (Q['dissent'] || 0))); }\"}],\"content\":{\"content\":\"Our new radio station allows us to connect to people in a more intimate setting than before, spreading the message of socialism along with music and other popular content. Since most proletarians cannot afford family radios right now, we are reaching the middle class, a fact of which our labor comrades are painfully aware.\",\"type\":\"paragraph\"}},\"party_disunity.concessions_left\":{\"id\":\"party_disunity.concessions_left\",\"title\":\"Give concessions to the left.\",\"viewIf\":{\"$code\":\"return ((Q['left_dissent'] || 0) > 30);\"},\"onArrival\":[{\"$code\":\"Q['left_dissent'] = (Q['left_dissent'] || 0) - 7;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 5;\"}],\"content\":{\"content\":\"We have promised that we will listen to the left wing of the party. Of course, this leads to increased dissent from the centrists.\",\"type\":\"paragraph\"}},\"party_organizations.rb\":{\"id\":\"party_organizations.rb\",\"chooseIf\":{\"$code\":\"return ((Q['resources'] || 0) > 0);\"},\"unavailableSubtitle\":\"Not enough resources.\",\"subtitle\":\"-1 resources\",\"onArrival\":[{\"$code\":\"Q['resources'] = (Q['resources'] || 0) - 1;\\nQ['rb_strength'] = (Q['rb_strength'] || 0) + 100;\\nQ['rb_militancy'] = (Q['rb_militancy'] || 0) + 0.01;\\nQ['reichsbanner_timer'] = 0;\\nQ['funded_reichsbanner'] = (Q['funded_reichsbanner'] || 0) + 1;\"}],\"content\":{\"content\":\"We have increased recruiting to the Reichsbanner.\",\"type\":\"paragraph\"}},\"peoples_party.campaign_workers\":{\"id\":\"peoples_party.campaign_workers\",\"title\":\"Campaign among the workers, to assuage their doubts about our changes.\",\"onArrival\":[{\"$code\":\"Q['workers_spd'] = (Q['workers_spd'] || 0) + (6 * (1 - (Q['dissent'] || 0)));\"}],\"content\":{\"content\":\"The workers are still a key part of our constituency, and we must not alienate them in the transformation of our party.\",\"type\":\"paragraph\"}},\"peoples_party_campaigning.campaign_unemployed\":{\"id\":\"peoples_party_campaigning.campaign_unemployed\",\"title\":\"Campaign among the unemployed.\",\"onArrival\":[{\"$code\":\"Q['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\"}],\"content\":{\"content\":\"As a people's party, the urban poor are still a key part of our constituency.\",\"type\":\"paragraph\"}},\"rally.police_protect_lose\":{\"id\":\"rally.police_protect_lose\",\"onArrival\":[{\"$code\":\"Q['strife'] = (Q['strife'] || 0) + 1;\\nQ['workers_nsdap'] = (Q['workers_nsdap'] || 0) + 3;\"}],\"content\":{\"content\":\"Unfortunately, the police were unable or unwilling to hold back the SA mob. The Nazis have won this show of strength.\",\"type\":\"paragraph\"}},\"reichsbanner.cut_rb\":{\"id\":\"reichsbanner.cut_rb\",\"subtitle\":\"+1 resources\",\"onArrival\":[{\"$code\":\"Q['resources'] = (Q['resources'] || 0) + 1;\\nQ['rb_strength'] = (Q['rb_strength'] || 0) - 100;\\nQ['rb_militancy'] = (Q['rb_militancy'] || 0) - 0.05;\\nQ['left_strength'] = (Q['left_strength'] || 0) - 2;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) - 2;\\nQ['spd_militancy'] = (Q['spd_militancy'] || 0) - 0.05;\\nQ['workers_kpd'] = (Q['workers_kpd'] || 0) + 2;\\nQ['unemployed_kpd'] = (Q['unemployed_kpd'] || 0) + 2;\"}],\"content\":{\"content\":\"Cutting resources to the Reichsbanner causes a drop in the membership, and leads some would-be members to join the Communists instead.\",\"type\":\"paragraph\"}},\"shuffle_leadership.remove_wels\":{\"id\":\"shuffle_leadership.remove_wels\",\"title\":\"Remove Wels\",\"viewIf\":{\"$code\":\"return ((Q['wels_advisor'] || 0)===1);\"},\"tags\":[\"remove_advisor\"],\"onArrival\":[{\"$code\":\"Q['wels_advisor'] = 0;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) + 5;\\nQ['n_advisors'] = (Q['n_advisors'] || 0) - 1;\"}],\"goTo\":[{\"id\":\"shuffle_leadership.rm_main\"}],\"content\":{\"content\":\"Wels has been removed as an advisor. The Centrist faction disapproves.\",\"type\":\"paragraph\"}},\"streetfighting.prussian_police_training\":{\"id\":\"streetfighting.prussian_police_training\",\"viewIf\":{\"$code\":\"return (((Q['spd_prussia'] || 0) == 1) && ((Q['prussian_police_loyalty'] || 0) > 0.5));\"},\"onArrival\":[{\"$code\":\"Q['rb_militancy'] = (Q['rb_militancy'] || 0) + 0.05;\\nQ['sa_strength'] = (Q['sa_strength'] || 0) + 50;\\nQ['prussian_police_training'] = (Q['prussian_police_training'] || 0) + 1;\"}],\"content\":{\"content\":\"The loyal sections of the Prussian police can help train the Reichsbanner.\",\"type\":\"paragraph\"}},\"game_over.nsdap_win\":{\"id\":\"game_over.nsdap_win\",\"viewIf\":{\"$code\":\"return ((Q['chancellor'] == \\\"Goebbels\\\") || (Q['president'] == \\\"Göring\\\"));\"},\"title\":\"Despite the deportation of Hitler, the Nazis have still taken power...\",\"tags\":[\"endings\"],\"goTo\":[{\"id\":\"game_over.eg_menu\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"Despite the deportation of Hitler, the NSDAP has somehow still wormed its way into power. \",{\"type\":\"conditional\",\"content\":\"We are fighting them for control of Germany.\",\"predicate\":0}]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['long_war'] || 0) == 1);\"}}]}},\"library.cabinet\":{\"id\":\"library.cabinet\",\"goTo\":[{\"id\":\"library.menu\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"Current cabinet:\"},{\"type\":\"paragraph\",\"content\":[\"Labor: \",{\"type\":\"insert\",\"insert\":0},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Interior: \",{\"type\":\"insert\",\"insert\":1},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Finance: \",{\"type\":\"insert\",\"insert\":2},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Economic: \",{\"type\":\"insert\",\"insert\":3},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Justice: \",{\"type\":\"insert\",\"insert\":4},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Foreign: \",{\"type\":\"insert\",\"insert\":5},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Reichswehr: \",{\"type\":\"insert\",\"insert\":6},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Agriculture: \",{\"type\":\"insert\",\"insert\":7}]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['labor_minister_party'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['interior_minister_party'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['finance_minister_party'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['economic_minister_party'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['justice_minister_party'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['foreign_minister_party'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['reichswehr_minister_party'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['agriculture_minister_party'] || 0);\"}}]}},\"root.1928_hard\":{\"id\":\"root.1928_hard\",\"onArrival\":[{\"$code\":\"Q['difficulty'] = 1;\\nQ['resources'] = 0;\\nQ['dues'] = 1;\\nQ['rb_strength'] = 1000;\\nQ['reformist_dissent'] = 25;\\nQ['left_dissent'] = 30;\\nQ['labor_dissent'] = 25;\\nQ['center_dissent'] = 25;\\nQ['z_relation'] = 41;\\nQ['kpd_relation'] = 16;\\nQ['dvp_relation'] = 31;\"}],\"goTo\":[{\"id\":\"root.1928_main\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"leber.campaigning_peoples_party\":{\"id\":\"leber.campaigning_peoples_party\",\"title\":\"Campaigning as a People's Party\",\"subtitle\":\"Campaigning with some of our previously nontraditional demographics.\",\"viewIf\":{\"$code\":\"return ((Q['peoples_party'] || 0)===1);\"},\"chooseIf\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0)===0);\"},\"unavailableSubtitle\":{\"content\":{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action.\"],\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}}]},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\"}],\"goTo\":[{\"id\":\"peoples_party_campaigning\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"leber\":{\"id\":\"leber\",\"type\":\"scene\",\"title\":\"Julius Leber\",\"isPinnedCard\":true,\"tags\":[\"advisor\",\"neorevisionist\"],\"cardImage\":\"img/portraits/LeberJulius.jpg\",\"viewIf\":{\"$code\":\"return ((Q['leber_advisor'] || 0)===1);\"},\"newPage\":true,\"options\":[{\"id\":\"@leber.democratic_rally\"},{\"id\":\"@leber.military_affairs\"},{\"id\":\"@leber.support_peoples_party\"},{\"id\":\"@leber.build_peoples_party\"},{\"id\":\"@leber.campaigning_peoples_party\"},{\"id\":\"@root\",\"title\":\"Return to main\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Julius Leber\"},{\"type\":\"paragraph\",\"content\":\"Leber is a former army officer who turned against the military leaders of the Kapp Putsch in 1920, helping us put down the army's attempted coup. He is in favor of expanded democracy and building a broad popular base for the SPD.\"}]},\"stampfer.support_labor\":{\"id\":\"stampfer.support_labor\",\"onArrival\":[{\"$code\":\"Q['labor_dissent'] = (Q['labor_dissent'] || 0) - 8;\\nQ['labor_strength'] = (Q['labor_strength'] || 0) + 8;\"}],\"content\":{\"content\":\"Vorwärts prints editorials in support of the policies of the trade unions.\",\"type\":\"paragraph\"}},\"dealing_with_toleration.urge_failure\":{\"id\":\"dealing_with_toleration.urge_failure\",\"onArrival\":[{\"$code\":\"Q['z_relation'] = (Q['z_relation'] || 0) - 3;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 3;\"}],\"content\":{\"content\":\"Unfortunately, our negotiations have met with failure. The center-right parties increasingly see us as a nuisance, and might not wish to continue these negotiations.\",\"type\":\"paragraph\"}},\"deport_hitler.force_success\":{\"id\":\"deport_hitler.force_success\",\"onArrival\":[{\"$code\":\"Q['hitler_deported'] = 1;\\nQ['sa_strength'] = ((Q['sa_strength'] || 0) / 2);\\nQ['workers_nsdap'] = (Q['workers_nsdap'] || 0) - 10;\\nQ['new_middle_nsdap'] = (Q['new_middle_nsdap'] || 0) - 10;\\nQ['old_middle_nsdap'] = (Q['old_middle_nsdap'] || 0) - 10;\\nQ['rural_nsdap'] = (Q['rural_nsdap'] || 0) - 10;\\nQ['unemployed_nsdap'] = (Q['unemployed_nsdap'] || 0) - 10;\\nQ['sa_banned'] = 1;\\nQ['coup_progress'] = (Q['coup_progress'] || 0) - 2;\\nQ['nsdap_leader'] = \\\"Goebbels\\\";\"}],\"achievement\":\"deport_hitler\",\"content\":[{\"type\":\"paragraph\",\"content\":\"The confrontation ends with the police and Reichsbanner prevailing, capturing Hitler so he can be deported! This is a sign of weakness, and his physical distance makes organizing difficult, impeding the Nazi effort to win more votes.\"},{\"type\":\"paragraph\",\"content\":\"In Hitler's absence, Joseph Goebbels has become the temporary leader of the Nazi party, with substantial influence from Hermann Göring.\"}]},\"economic_democracy.cooperatives_1\":{\"id\":\"economic_democracy.cooperatives_1\",\"title\":\"Support worker and consumer cooperatives.\",\"subtitle\":\"-1 budget\",\"onArrival\":[{\"$code\":\"Q['economic_democracy'] = (Q['economic_democracy'] || 0) + 1;\\nQ['cooperatives'] = (Q['cooperatives'] || 0) + 1;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\nQ['budget'] = (Q['budget'] || 0) - 1;\\n if (((Q['unemployed'] || 0) > 9) ) { Q['unemployed'] = (Q['unemployed'] || 0) - 1; }\"}],\"chooseIf\":{\"$code\":\"return ((Q['budget'] || 0) >= 1);\"},\"maxVisits\":3,\"content\":{\"content\":\"We have enacted legislation that makes it easier to create cooperative enterprises of all sorts, and provide financial support to struggling cooperatives.\",\"type\":\"paragraph\"},\"countVisitsMax\":3},\"economic_democracy\":{\"id\":\"economic_democracy\",\"type\":\"scene\",\"title\":\"Economic Democracy\",\"isCard\":true,\"newPage\":true,\"onArrival\":[{\"$code\":\"Q['economic_democracy_timer'] = (Q['economic_democracy_timer'] || 0) + 10;\\nQ['month_actions'] = (Q['month_actions'] || 0) + 1;\"}],\"viewIf\":{\"$code\":\"return ((((((Q['spd_in_government'] || 0)) !== 0) && (((Q['economic_minister_party'] == \\\"SPD\\\") || (Q['finance_minister_party'] == \\\"SPD\\\")))) && ((Q['labor_minister_party'] == \\\"SPD\\\"))) && ((Q['economic_democracy_timer'] || 0) <= 0));\"},\"cardImage\":\"img/portraits/HilferdingRudolf.jpg\",\"maxVisits\":8,\"tags\":[\"govt_affairs\"],\"options\":[{\"id\":\"@economic_democracy.expand_councils\"},{\"id\":\"@economic_democracy.expand_councils_2\"},{\"id\":\"@economic_democracy.expand_councils_3\"},{\"id\":\"@economic_democracy.nationalize_1\"},{\"id\":\"@economic_democracy.cooperatives_1\"},{\"id\":\"@return\",\"title\":\"Do not enact any policies for now.\"},{\"id\":\"@easy_discard\"},{\"id\":\"@cancel_advisor_action\"}],\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"Economic Democracy\"},{\"type\":\"paragraph\",\"content\":\"A key part of the social democratic platform is that workers should have more control over the economy. This can be done either directly at the enterprise level, by giving works councils greater influence over management, or indirectly via the democratic government, by acquiring key industries from the capitalist class and placing them under democratic control.\"},{\"type\":\"paragraph\",\"content\":[\"As we control the Labor \",{\"type\":\"conditional\",\"content\":\"and Economic \",\"predicate\":0},{\"type\":\"conditional\",\"content\":\"and Finance \",\"predicate\":1},\" ministries, we can finally begin to implement our long-standing goals. \",{\"type\":\"conditional\",\"content\":\"Our bourgeois coalition partners might not agree, however.\",\"predicate\":2}]}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['economic_minister_party'] == \\\"SPD\\\");\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['finance_minister_party'] == \\\"SPD\\\");\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['in_grand_coalition'] || 0)) !== 0);\"}}]},\"countVisitsMax\":8},\"economic_policy.implement_wtb_deficit\":{\"id\":\"economic_policy.implement_wtb_deficit\",\"title\":\"Implement the WTB plan.\",\"subtitle\":{\"content\":[\"-\",{\"type\":\"insert\",\"insert\":0},\" budget - we will enter deficit spending. \",{\"type\":\"conditional\",\"content\":\"Our pro-labor policies have reduced the cost of the plan.\",\"predicate\":1}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['wtb_budget'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['wtb_budget'] || 0) == 3);\"}}]},\"unavailableSubtitle\":\"Unemployment is low enough that the time for the WTB-Plan has passed.\",\"viewIf\":{\"$code\":\"return ((((Q['budget'] || 0) < (Q['wtb_budget'] || 0)) && ((Q['wtb_implemented'] || 0) == 0)) && ((Q['wtb_adopted'] || 0) == 1));\"},\"chooseIf\":{\"$code\":\"return ((Q['unemployed'] || 0) > 8);\"},\"onArrival\":[{\"$code\":\"Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1;\\n if ((((Q['historical_mode'] || 0)) !== 0) ) { Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1; } \\n if ((Q['chancellor'] == \\\"Brüning\\\") ) { Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1; } \\nQ['works_program'] = (Q['works_program'] || 0) + 1;\\nQ['budget'] = (Q['budget'] || 0) - (Q['wtb_budget'] || 0);\\nQ['unemployed'] = (Q['unemployed'] || 0) - 4;\\nQ['workers'] = (Q['workers'] || 0) + 3;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (8 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (8 * (1 - (Q['dissent'] || 0)));\\nQ['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) + 1;\\nQ['wtb_implemented'] = (Q['wtb_implemented'] || 0) + 1;\\nQ['kpd_coalition_dissent'] = (Q['kpd_coalition_dissent'] || 0) + 1;\\n if (((((Q['in_popular_front'] || 0)) !== 0) || (((Q['in_left_front'] || 0)) !== 0)) ) { Q['kpd_relation'] = (Q['kpd_relation'] || 0) - 5; } \\nQ['inflation'] = (Q['inflation'] || 0) + 3;\"}],\"achievement\":\"wirtschaftspolitik\",\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"We have entered the realm of deficit spending. Our coalition partners are disgusted, but the works plan is enacted anyway. Money is beginning to flow through the economy via investments in large-scale public works.\"},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":\"The KPD opposes the WTB plan, seeing it as a rescue of capitalism rather than a step towards real socialism.\",\"predicate\":0}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['in_popular_front'] || 0)) !== 0) || (((Q['in_left_front'] || 0)) !== 0));\"}}]}},\"domestic_enemies.unban_sh\":{\"id\":\"domestic_enemies.unban_sh\",\"viewIf\":{\"$code\":\"return ((Q['sh_banned'] || 0)===1);\"},\"onArrival\":[{\"$code\":\"Q['sh_banned'] = 0;\\nQ['sh_strength'] = (Q['sh_strength'] || 0) + 100;\"}],\"content\":{\"content\":\"The Stahlhelm is no longer banned.\",\"type\":\"paragraph\"}},\"foreign_policy.soviet_economic_aid_yes_mil\":{\"id\":\"foreign_policy.soviet_economic_aid_yes_mil\",\"chooseIf\":{\"$code\":\"return ((Q['budget'] || 0) >= 1);\"},\"subtitle\":\"-1 budget\",\"onArrival\":[{\"$code\":\"Q['budget'] = (Q['budget'] || 0) - 1;\\nQ['soviet_relation'] = (Q['soviet_relation'] || 0) + 1;\\nQ['reichswehr_strength'] = (Q['reichswehr_strength'] || 0) + 20;\\nQ['reichswehr_loyalty'] = (Q['reichswehr_loyalty'] || 0) + 0.05;\\nQ['foreign_goal_completed'] = (Q['foreign_goal_completed'] || 0) + 1;\"}],\"content\":{\"content\":\"The Soviets are pleased that we have sent them aid, and have agreed to help train our military. The Reichswehr appreciates our support.\",\"type\":\"paragraph\"}},\"fiscal_policy.raise_overall\":{\"id\":\"fiscal_policy.raise_overall\",\"subtitle\":\"+3 budget\",\"onArrival\":[{\"$code\":\"Q['budget'] = (Q['budget'] || 0) + 3;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) - 4;\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) - 4;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 3;\\nQ['rural_spd'] = (Q['rural_spd'] || 0) - 3;\\nQ['unemployed'] = (Q['unemployed'] || 0) + 2;\\nQ['kpd_coalition_dissent'] = (Q['kpd_coalition_dissent'] || 0) + 1;\\nQ['lower_tax_rates'] = (Q['lower_tax_rates'] || 0) + 1;\\nQ['upper_tax_rates'] = (Q['upper_tax_rates'] || 0) + 1;\\n if (((Q['upper_tax_rates'] || 0) > 1) ) { Q['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) + 1; } \\n if (((Q['upper_tax_rates'] || 0) > 2) ) { Q['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) + 1; } \\n if (((Q['lower_tax_rates'] || 0) > 1) ) { Q['workers_spd'] = (Q['workers_spd'] || 0) - 5; } \\nQ['inflation'] = (Q['inflation'] || 0) - 1.1;\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"Raising taxes hurts our support among all those who pay taxes. \",{\"type\":\"conditional\",\"content\":\"However, our coalition partners are more supportive of the idea of \\\"shared sacrifice\\\" than simply taxing the rich. \",\"predicate\":0},\" Increasing taxes also decreases economic demand, which may lead to more unemployment.\"]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['in_grand_coalition'] || 0)) !== 0) || (((Q['in_weimar_coalition'] || 0)) !== 0));\"}}]}},\"labor_rights.unemployment_insurance\":{\"id\":\"labor_rights.unemployment_insurance\",\"viewIf\":{\"$code\":\"return ((Q['unemployed'] || 0) >= ((Q['unemployment_insurance_threshold'] || 0) + 4));\"},\"subtitle\":\"With increasing unemployment, we must find new ways to fund our signature program.\",\"options\":[{\"id\":\"@labor_rights.cut_benefits\",\"title\":\"Cut benefits.\"},{\"id\":\"@labor_rights.increase_employers\",\"title\":\"Increase employer contributions.\"},{\"id\":\"@labor_rights.balance\",\"title\":\"Increase both employer and employee contributions.\"},{\"id\":\"@labor_rights.labor_rights_menu\",\"title\":\"We can defer this decision for now.\"}],\"content\":{\"content\":\"With the onset of the Depression and its throngs of unemployed, our unemployment insurance program is under strain. The program was never designed for this many claimants; something must be done to balance the budget.\",\"type\":\"paragraph\"}},\"police.investigate_far_right\":{\"id\":\"police.investigate_far_right\",\"goTo\":[{\"id\":\"police.investigate_far_right_success\",\"predicate\":{\"$code\":\"return ((Q['interior_police_loyalty'] || 0) >= 0.55);\"}},{\"id\":\"police.investigate_far_right_failure\",\"predicate\":{\"$code\":\"return ((Q['interior_police_loyalty'] || 0) < 0.55);\"}}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"prussian_affairs.unban_sa\":{\"id\":\"prussian_affairs.unban_sa\",\"viewIf\":{\"$code\":\"return ((Q['sa_banned'] || 0)===1);\"},\"onArrival\":[{\"$code\":\"Q['sa_banned'] = 0;\\nQ['sa_strength'] = (Q['sa_strength'] || 0) + 100;\\nQ['sa_militancy'] = (Q['sa_militancy'] || 0) + 0.05;\"}],\"content\":{\"content\":\"The SA is no longer banned. They immediately go on a recruiting spree.\",\"type\":\"paragraph\"}},\"social_welfare.spending_same_post_depression\":{\"id\":\"social_welfare.spending_same_post_depression\",\"viewIf\":{\"$code\":\"return ((Q['unemployed'] || 0) > 15);\"},\"onArrival\":[{\"$code\":\"Q['workers_spd'] = (Q['workers_spd'] || 0) - 3;\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) - 4;\\nQ['welfare'] = (Q['welfare'] || 0) - 1;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 5;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 5;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) + 5;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) + 5;\\nQ['neorevisionist_dissent'] = (Q['neorevisionist_dissent'] || 0) + 5;\\nQ['kpd_coalition_dissent'] = (Q['kpd_coalition_dissent'] || 0) + 1;\\n if (((((Q['in_popular_front'] || 0)) !== 0) || (((Q['in_left_front'] || 0)) !== 0)) ) { Q['kpd_relation'] = (Q['kpd_relation'] || 0) - 8; }\"}],\"subtitle\":\"The increased levels of unemployment necessitate more spending on aid.\",\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"Increasing welfare spending is necessary in light of the rise in unemployment, so we have essentially cut welfare. The workers are justifiably displeased - we are sacrificing their livelihoods to appease bourgeois demands for austerity.\"},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":\"The KPD is turning against us for our welfare policy.\",\"predicate\":0}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['in_popular_front'] || 0)) !== 0) || (((Q['in_left_front'] || 0)) !== 0));\"}}]}},\"social_welfare\":{\"id\":\"social_welfare\",\"type\":\"scene\",\"title\":\"Social welfare policy\",\"newPage\":true,\"isCard\":true,\"tags\":[\"govt_affairs\"],\"onArrival\":[{\"$code\":\"Q['social_welfare_timer'] = 10;\\nQ['month_actions'] = (Q['month_actions'] || 0) + 1;\"}],\"viewIf\":{\"$code\":\"return (((Q['spd_in_government'] || 0)===1) && ((Q['social_welfare_timer'] || 0)===0));\"},\"cardImage\":\"img/portraits/JuchaczMarie.jpg\",\"options\":[{\"id\":\"@social_welfare.reduce_spending\",\"title\":\"Reduce spending on welfare.\"},{\"id\":\"@social_welfare.increase_spending_pre_depression\",\"title\":\"Increase spending on welfare.\"},{\"id\":\"@social_welfare.increase_spending_post_depression\",\"title\":\"Increase spending (welfare levels will remain about the same).\"},{\"id\":\"@social_welfare.spending_same_pre_depression\",\"title\":\"Keep spending the same.\"},{\"id\":\"@social_welfare.spending_same_post_depression\",\"title\":\"Keep spending the same (effectively a service cut).\"},{\"id\":\"@easy_discard\"}],\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"Social Welfare Policy\"},{\"type\":\"paragraph\",\"content\":[\"The social welfare program, including unemployment insurance, healthcare, and old-age care, is the proudest achievement of the SPD in our time in government. There is continuous pressure to dismantle the welfare system\",{\"type\":\"conditional\",\"content\":\", especially given the economic crisis \",\"predicate\":0},\".\"]}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['black_thursday_seen'] || 0)===1);\"}}]}},\"womens_rights.liberalize_fail\":{\"id\":\"womens_rights.liberalize_fail\",\"onArrival\":[{\"$code\":\"Q['z_relation'] = (Q['z_relation'] || 0) - 5;\\nQ['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\nQ['catholics_spd'] = (Q['catholics_spd'] || 0) - 5;\"}],\"content\":{\"content\":\"Unfortunately, our proposal is voted down in the Reichstag, with the Catholic Center party (our long-time partners) speaking in particularly vehement opposition, and some of our own members breaking party discipline. The activists, feeling demoralized from this attempt, have decided to bide their time.\",\"type\":\"paragraph\"}},\"austrian_customs_union.end_toleration_fail\":{\"id\":\"austrian_customs_union.end_toleration_fail\",\"onArrival\":[{\"$code\":\"Q['banking_crisis_timer'] = 2;\\nQ['customs_union'] = 1;\\nQ['west_relation'] = (Q['west_relation'] || 0) - 2;\\nQ['east_relation'] = (Q['east_relation'] || 0) - 2;\"}],\"content\":{\"content\":\"Unfortunately, the far-right parties united with the government to outvote us. The customs union will be formed.\",\"type\":\"paragraph\"}},\"austrian_customs_union\":{\"id\":\"austrian_customs_union\",\"type\":\"scene\",\"title\":\"Austrian customs union\",\"subtitle\":\"The Foreign Ministry seeks closer ties to Austria...\",\"newPage\":true,\"onArrival\":[{\"$code\":\"Q['customs_union_seen'] = 1;\"}],\"tags\":[\"event\"],\"viewIf\":{\"$code\":\"return (((((((Q['year'] || 0)===1931) && ((Q['month'] || 0) >= 3)) && (Q['foreign_minister_party'] != \\\"SPD\\\")) && (Q['foreign_minister_party'] != \\\"KPD\\\")) && ((Q['customs_union'] || 0) == 0)) && (!(((Q['eu'] || 0)) !== 0)));\"},\"maxVisits\":1,\"options\":[{\"id\":\"@austrian_customs_union.let_it_happen\",\"title\":\"Let it happen.\"},{\"id\":\"@austrian_customs_union.end_coalition\",\"title\":\"Stop this arrangement!\"},{\"id\":\"@austrian_customs_union.end_toleration\",\"title\":\"Attempt to stop this arrangement!\"}],\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"Austrian Customs Union\"},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"The \",{\"type\":\"insert\",\"insert\":1},\" foreign minister has a proposal for a customs union with Austria. We can either accept or reject this agreement. \"],\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":[\"The government of Chancellor \",{\"type\":\"insert\",\"insert\":3},\" has a proposal for a customs union with Austria. Most likely, this will happen whatever we decide. \"],\"predicate\":2},\"\"]},{\"type\":\"paragraph\",\"content\":\"The nationalist right has long yearned for closer ties with Austria, with the eventual goal of the merger of the two German-speaking countries. A customs union with Austria is the first step towards this goal. Additionally, many believe that a union with Austria would improve our current economic circumstances.\"},{\"type\":\"paragraph\",\"content\":\"However, the Allies, especially France, are likely to object. This agreement would break the terms of the Versailles Treaty, and could lead to economic sanctions, further hurting our economy.\"}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['spd_in_government'] || 0)) !== 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['foreign_minister_party'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (!(((Q['spd_in_government'] || 0)) !== 0));\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor'] || 0);\"}}]},\"countVisitsMax\":1},\"blutmai.allow_police\":{\"id\":\"blutmai.allow_police\",\"onArrival\":[{\"$code\":\"Q['kpd_relation'] = (Q['kpd_relation'] || 0) + 5;\\nQ['workers_kpd'] = (Q['workers_kpd'] || 0) + 5;\\nQ['unemployed_kpd'] = (Q['unemployed_kpd'] || 0) + 5;\"}],\"content\":{\"content\":\"The demonstration proceeds peacefully under the watchful eyes of the police. Onlookers admire the strength of the Communist workers, and perhaps some of our supporters have been peeled off.\",\"type\":\"paragraph\"}},\"altona_clashes.allow_no_police\":{\"id\":\"altona_clashes.allow_no_police\",\"onArrival\":[{\"$code\":\"Q['sa_strength'] = (Q['sa_strength'] || 0) + 80;\\nQ['rfb_strength'] = (Q['rfb_strength'] || 0) + 50;\\nQ['strife'] = (Q['strife'] || 0) + 1;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) - 8;\\nQ['communist_coalition'] = (Q['communist_coalition'] || 0) - 1;\"}],\"content\":{\"content\":\"When the march arrives in Altona, they are immediately confronted by an angry crowd of communists and socialists, who throw objects at the Nazis. Gunshots are heard, reportedly from rooftop snipers. In response, the SA engage the surrounding crowd and fire at the surrounding buildings. Dozens are killed, mostly civilians. The Nazis recruit off their dead martyrs.\",\"type\":\"paragraph\"}},\"altona_clashes\":{\"id\":\"altona_clashes\",\"type\":\"scene\",\"title\":\"Nazi March in Altona\",\"newPage\":true,\"subtitle\":\"An SA demonstration, with the potential for violence\",\"tags\":[\"event\"],\"viewIf\":{\"$code\":\"return (((((Q['year'] || 0) == 1932) && ((Q['month'] || 0) == 6)) && ((Q['sa_banned'] || 0) == 0)) && ((Q['spd_prussia'] || 0) == 1));\"},\"maxVisits\":1,\"options\":[{\"id\":\"@altona_clashes.ban_march\",\"title\":\"Ban the march before it starts.\"},{\"id\":\"@altona_clashes.allow_police\",\"title\":\"Allow the march, with a heavy police presence.\"},{\"id\":\"@altona_clashes.allow_no_police\",\"title\":\"Allow the march without a police presence.\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Nazi March in Altona\"},{\"type\":\"paragraph\",\"content\":\"The Nazi SA is planning a march through Altona, a working-class neighborhood of Hamburg known for its high working-class population. Altona is a Communist stronghold, and the planned march will almost certainly lead to violent conflict.\"}],\"countVisitsMax\":1},\"death_of_muller.bruning_chancellor\":{\"id\":\"death_of_muller.bruning_chancellor\",\"onArrival\":[{\"$code\":\"Q['chancellor'] = \\\"Brüning\\\";\\nQ['chancellor_party'] = \\\"Z\\\";\\nQ['z_relation'] = (Q['z_relation'] || 0) + 5;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) + 5;\"}],\"subtitle\":\"The Center Party claims it is their turn...\",\"content\":{\"content\":\"The Center Party is grateful that we have supported Brüning for Chancellor.\",\"type\":\"paragraph\"}},\"civil_war.loyal_police\":{\"id\":\"civil_war.loyal_police\",\"maxVisits\":1,\"goTo\":[{\"id\":\"civil_war.war_menu\"}],\"onArrival\":[{\"$code\":\"Q['war_choices'] = (Q['war_choices'] || 0) + 1;\"}],\"viewIf\":{\"$code\":\"return ((Q['spd_prussia'] || 0)===1);\"},\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"Since we still control the Prussian government, we can call upon the Prussian police. \",{\"type\":\"conditional\",\"content\":\"Unfortunately, the police are politically unreliable at best. \",\"predicate\":0},{\"type\":\"conditional\",\"content\":\"In this crucial hour, the Prussian police are split, with about half actively supporting our efforts. \",\"predicate\":1},{\"type\":\"conditional\",\"content\":\"Most join in supporting our efforts. Our efforts in cultivating republican loyalties in the police have proven their worth.\",\"predicate\":2}]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['prussian_police_loyalty'] || 0) < 0.4);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['prussian_police_loyalty'] || 0) >= 0.4) && ((Q['prussian_police_loyalty'] || 0) < 0.65));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['prussian_police_loyalty'] || 0) >= 0.65);\"}}]},\"countVisitsMax\":1},\"high_inflation.nothing\":{\"id\":\"high_inflation.nothing\",\"onArrival\":[{\"$code\":\"Q['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) + 1;\"}],\"content\":{\"content\":\"Realistically, there is nothing we can do to stem the tide of inflation.\",\"type\":\"paragraph\"}},\"high_inflation\":{\"id\":\"high_inflation\",\"type\":\"scene\",\"title\":\"High Inflation\",\"subtitle\":\"Workers are seeing their purchasing power decline.\",\"viewIf\":{\"$code\":\"return ((((Q['inflation'] || 0) >= 8) && ((Q['high_inflation_timer'] || 0)===0)) && (((Q['spd_in_government'] || 0)) !== 0));\"},\"newPage\":true,\"maxVisits\":1,\"onArrival\":[{\"$code\":\"Q['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) + 1;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 4;\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) - 6;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) - 6;\\nQ['rural_spd'] = (Q['rural_spd'] || 0) - 5;\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) - 4;\\nQ['high_inflation_timer'] = 6;\\nQ['pro_republic'] = (Q['pro_republic'] || 0) - 5;\"}],\"tags\":[\"event\"],\"options\":[{\"id\":\"@high_inflation.taxes\",\"title\":\"Raise taxes.\"},{\"id\":\"@high_inflation.welfare\",\"title\":\"Reduce welfare and social spending.\"},{\"id\":\"@high_inflation.price_controls\",\"title\":\"Impose price and wage controls.\"},{\"id\":\"@high_inflation.bank\",\"title\":\"Surely the Reichsbank has a plan this time?\"},{\"id\":\"@high_inflation.nothing\",\"title\":\"Realistically, there is nothing we can do.\"}],\"content\":[{\"type\":\"heading\",\"content\":\"High Inflation\"},{\"type\":\"paragraph\",\"content\":\"Inflation has risen. People of all social classes are seeing their purchasing power fall. Memories of the hyperinflation period of 1923 echo through the public conscious, even though the present inflation is not nearly as severe.\"},{\"type\":\"paragraph\",\"content\":\"The people and the press are clamoring for action to reduce inflation.\"}],\"countVisitsMax\":1},\"election_1928.popular_front_coalition\":{\"id\":\"election_1928.popular_front_coalition\",\"title\":\"A new \\\"Popular Front\\\" coalition?\",\"subtitle\":{\"content\":[\"SPD + KPD + Z + DDP \",{\"type\":\"conditional\",\"content\":\"+ SAPD \",\"predicate\":0},\"(\",{\"type\":\"insert\",\"insert\":1},\"%)\"],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['sapd_formed'] || 0)) !== 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['popular_front_coalition'] || 0);\"}}]},\"unavailableSubtitle\":{\"content\":[\"SPD + KPD + Z + DDP \",{\"type\":\"conditional\",\"content\":\"+ SAPD \",\"predicate\":0},\"(\",{\"type\":\"insert\",\"insert\":1},\"%) - \",{\"type\":\"conditional\",\"content\":\"We do not have good enough relations with the KPD. \",\"predicate\":2},{\"type\":\"conditional\",\"content\":\"We do not have good enough relations with the Center Party. \",\"predicate\":3},{\"type\":\"conditional\",\"content\":\"The Communists are unwilling to compromise at all.\",\"predicate\":4}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['sapd_formed'] || 0)) !== 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['popular_front_coalition'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((((Q['kpd_relation'] || 0) < 65) && (Q['kpd_party_leader'] == \\\"Thälmann\\\"))) || ((((Q['kpd_relation'] || 0) < 45) && (Q['kpd_party_leader'] == \\\"Conciliators\\\")))));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((((Q['z_relation'] || 0) < 45) && (Q['z_party_leader'] == \\\"Joos\\\"))) || (((((Q['z_relation'] || 0) < 65) && (Q['z_party_leader'] != \\\"Joos\\\")) && (Q['kpd_party_leader'] != \\\"Conciliators\\\")))) || (((((Q['z_relation'] || 0) < 55) && (Q['z_party_leader'] != \\\"Joos\\\")) && (Q['kpd_party_leader'] == \\\"Conciliators\\\"))));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['communist_coalition'] || 0) < 3);\"}}]},\"viewIf\":{\"$code\":\"return ((Q['popular_front_coalition'] || 0) >= 50);\"},\"chooseIf\":{\"$code\":\"return (((((((((((Q['kpd_relation'] || 0) >= 65) && (Q['kpd_party_leader'] == \\\"Thälmann\\\"))) || ((((Q['kpd_relation'] || 0) >= 45) && (Q['kpd_party_leader'] == \\\"Conciliators\\\"))))) && (((((((Q['z_relation'] || 0) >= 45) && (Q['z_party_leader'] == \\\"Joos\\\"))) || (((((Q['z_relation'] || 0) >= 65) && (Q['z_party_leader'] != \\\"Joos\\\")) && (Q['kpd_party_leader'] != \\\"Conciliators\\\")))) || (((((Q['z_relation'] || 0) >= 55) && (Q['z_party_leader'] != \\\"Joos\\\")) && (Q['kpd_party_leader'] == \\\"Conciliators\\\")))))) && ((Q['ddp_relation'] || 0) >= 50)) && ((Q['communist_coalition'] || 0) >= 3))) || (((((Q['z_party_leader'] == \\\"Joos\\\") && (Q['kpd_party_leader'] == \\\"Conciliators\\\")) && ((Q['z_relation'] || 0) >= 30)) && ((Q['kpd_relation'] || 0) >= 30))));\"},\"options\":[{\"id\":\"@election_1928.popular_front_2\",\"title\":\"Form the Popular Front!\"},{\"id\":\"@election_1928.great_popular_front\",\"title\":\"Form the Popular Front!\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"Could we really form a coalition that included both the Center and the Communists? It seems like an absurd concept, but given our good relationships with both sides, it is not an impossibility.\"},{\"type\":\"paragraph\",\"content\":\"The far-right might attempt a coup, if such a coalition were formed.\"}]},\"kpd_policy.economy_support\":{\"id\":\"kpd_policy.economy_support\",\"onArrival\":[{\"$code\":\"Q['nationalization_progress'] = (Q['nationalization_progress'] || 0) + 1;\\nQ['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) + 4;\\n if (((Q['unemployed'] || 0) >= 6) ) { Q['unemployed'] = (Q['unemployed'] || 0) - 2.5; } \\n if (((Q['works_councils'] || 0) >= 3) ) { Q['unemployed'] = (Q['unemployed'] || 0) - 1.2; } \\nQ['budget'] = (Q['budget'] || 0) - 3;\\nQ['works_program'] = (Q['works_program'] || 0) + 1;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\nQ['workers_kpd'] = (Q['workers_kpd'] || 0) + (8 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_kpd'] = (Q['unemployed_kpd'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\nQ['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 2;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 6;\\nQ['z_relation'] = (Q['z_relation'] || 0) - 4;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) - 3;\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) - 3;\\nQ['economy_goal_completed'] = (Q['economy_goal_completed'] || 0) + 1;\\nQ['kpd_influence'] = (Q['kpd_influence'] || 0) + 2;\"}],\"content\":{\"content\":\"The KPD has gained credit with the workers for enabling many to keep their jobs. Meanwhile, the bourgeois parties and middle-class voters blame the SPD for enabling the nationalizations.\",\"type\":\"paragraph\"}},\"kpd_ultimatum.united_front_achievement\":{\"id\":\"kpd_ultimatum.united_front_achievement\",\"onArrival\":[{\"$code\":\"Q['united_front_success'] = (Q['united_front_success'] || 0) + 1;\"}],\"achievement\":\"einheitsfront_2\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"kpd_vote_of_no_confidence.support_center\":{\"id\":\"kpd_vote_of_no_confidence.support_center\",\"chooseIf\":{\"$code\":\"return (((((Q['weimar_coalition'] || 0) >= 50) && ((Q['z_relation'] || 0) >= 40))) || (((((Q['grand_coalition'] || 0) >= 50) && ((Q['z_relation'] || 0) >= 45)) && ((Q['dvp_relation'] || 0) >= 30))));\"},\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":\"This would not give us a majority. \",\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"After working with the Communists, the Center Party does not wish to form a coalition with us. \",\"predicate\":1},\" \",{\"type\":\"conditional\",\"content\":\"The DVP would rather see the government fall than rescue us from the Communists.\",\"predicate\":2}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['grand_coalition'] || 0) < 50);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['z_relation'] || 0) < 45);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['dvp_relation'] || 0) < 30);\"}}]},\"options\":[{\"id\":\"@election_1928.weimar_coalition\",\"title\":\"Form a Weimar Coalition?\"},{\"id\":\"@election_1928.grand_coalition\",\"title\":\"Form a Grand Coalition?\"},{\"id\":\"@kpd_vote_of_no_confidence.let_it_happen\",\"title\":\"There is nothing we can do.\"}],\"content\":{\"content\":\"We could try to boot the KPD from our governing coalition, and form a new government with the bourgeois parties.\",\"type\":\"paragraph\"}},\"march_on_berlin.ask_resign\":{\"id\":\"march_on_berlin.ask_resign\",\"options\":[{\"id\":\"@march_on_berlin.fight\"},{\"id\":\"@march_on_berlin.fight_constitution\"},{\"id\":\"@march_on_berlin.resign\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"President \",{\"type\":\"insert\",\"insert\":0},\" has asked our government to resign.\"]},\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['president'] || 0);\"}}]}},\"panzerkreuzer.muller\":{\"id\":\"panzerkreuzer.muller\",\"onArrival\":[{\"$code\":\"Q['panzerkreuzer_funded'] = 1;\"}],\"content\":{\"content\":\"Our coalition partners are shocked by our intransigence! Despite Chancellor Müller's rejection of the proposal, the other parties bring the matter to a Reichstag vote, which easily passes, with only the SPD and KPD voting against. The ship will be built.\",\"type\":\"paragraph\"}},\"constitutional_reform.constructive_vonc_2\":{\"id\":\"constitutional_reform.constructive_vonc_2\",\"chooseIf\":{\"$code\":\"return ((Q['reform_support'] || 0) >= (Q['pass_threshold'] || 0));\"},\"unavailableSubtitle\":{\"content\":[\"We do not have enough support for this policy. \",{\"type\":\"conditional\",\"content\":\"We should have an additional margin for the referendum since we need a majority of voters, and many voters who do not support the republic will not participate. \",\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"The Center Party does not trust us enough to support this policy.\",\"predicate\":1}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['pro_republic'] || 0) < 65);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['z_relation'] || 0) <= 30);\"}}]},\"onArrival\":[{\"$code\":\"Q['constitutional_reform'] = (Q['constitutional_reform'] || 0) + 1;\\nQ['constructive_vonc'] = 1;\"}],\"achievement\":\"verfassungsreform\",\"content\":{\"content\":\"We have successfully passed a constitutional amendment to ban votes of no confidence when a new government cannot be formed. Hopefully this increases the stability of our governments.\",\"type\":\"paragraph\"}},\"popular_front_dispute.economy\":{\"id\":\"popular_front_dispute.economy\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"presidential_election_1932.support_thalmann_2\":{\"id\":\"presidential_election_1932.support_thalmann_2\",\"onArrival\":[{\"$code\":\"Q['spd_support_thalmann'] = 1;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 15;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) + 10;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) + 5;\\nQ['neorevisionist_dissent'] = (Q['neorevisionist_dissent'] || 0) + 10;\\nQ['catholics_spd'] = (Q['catholics_spd'] || 0) - 5;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 3;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) + 10;\\nQ['communist_coalition'] = (Q['communist_coalition'] || 0) + 2;\\nQ['z_relation'] = (Q['z_relation'] || 0) - 15;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 15;\"}],\"options\":[{\"id\":\"@presidential_election_1932.final_election\",\"title\":\"The final vote...\"}],\"content\":{\"content\":\"Fine. We have thrown our support to Chairman Thälmann of the KPD.\",\"type\":\"paragraph\"}},\"prussian_coup.defend_2_civil_war\":{\"id\":\"prussian_coup.defend_2_civil_war\",\"options\":[{\"id\":\"@civil_war\",\"title\":\"It is a civil war.\"}],\"content\":{\"content\":\"Our forces confront the government troops and their supporters on the streets of Berlin, and armed fighting erupts. The reactionaries do not budge from their positions. We are caught at a disadvantage.\",\"type\":\"paragraph\"}},\"panzerkreuzer_b.not_built\":{\"id\":\"panzerkreuzer_b.not_built\",\"onArrival\":[{\"$code\":\"Q['panzerkreuzer_b_funded'] = 0;\\n if (((Q['panzerkreuzer_funded'] || 0)===0) ) { Q['budget'] = (Q['budget'] || 0) + 1; }\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"Our vote against the battlecruiser succeeds, with the support of the KPD and anti-war portions of the former DDP. The ship will not be built! \",{\"type\":\"conditional\",\"content\":\"We have saved some budget from not funding the two ships.\",\"predicate\":0}]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['panzerkreuzer_funded'] || 0) == 0);\"}}]}},\"unemployment_insurance_1.accept\":{\"id\":\"unemployment_insurance_1.accept\",\"onArrival\":[{\"$code\":\"Q['workers_spd'] = (Q['workers_spd'] || 0) - (0.15 * (Q['workers_spd'] || 0));\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) - (0.3 * (Q['unemployed_spd'] || 0));\\nQ['workers_kpd'] = (Q['workers_kpd'] || 0) + 7;\\nQ['workers_nsdap'] = (Q['workers_nsdap'] || 0) + 7;\\nQ['unemployed_kpd'] = (Q['unemployed_kpd'] || 0) + 5;\\nQ['unemployed_nsdap'] = (Q['unemployed_nsdap'] || 0) + 5;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 15;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) + 10;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) + 15;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 5;\\nQ['welfare'] = (Q['welfare'] || 0) - 2;\\nQ['budget'] = (Q['budget'] || 0) + 1;\\nQ['unemployed'] = (Q['unemployed'] || 0) + 3;\\nQ['month'] = (Q['month'] || 0) + 1;\\nQ['pro_republic'] = (Q['pro_republic'] || 0) - 4;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) - 8;\\nQ['inflation'] = (Q['inflation'] || 0) - 2;\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"Unfortunately, we must accept this ultimatum if we are to maintain this coalition. The Nazis and Communists are waiting in the wings for us to fail, ready to pounce upon the instability that would result from a breakup of the governing coalition.\"},{\"type\":\"paragraph\",\"content\":\"The workers are furious at our betrayal, as are a good portion of our membership throughout the factions. Our loss is the KPD's gain, and even the NSDAP, those lapdogs of the bourgeoisie, have joined in criticizing us for our austerity.\"}]},\"vote_of_no_confidence.support_kpd\":{\"id\":\"vote_of_no_confidence.support_kpd\",\"chooseIf\":{\"$code\":\"return ((((((((Q['in_grand_coalition'] || 0)) !== 0) && ((Q['communist_coalition'] || 0) >= 3)) && ((Q['kpd_relation'] || 0) >= 50)) && ((Q['kpd_r'] || 0) >= (Q['dvp_r'] || 0)))) || (((((((Q['in_weimar_coalition'] || 0)) !== 0) && ((Q['kpd_relation'] || 0) >= 50)) && ((Q['kpd_r'] || 0) >= (Q['z_r'] || 0))) && ((Q['communist_coalition'] || 0) >= 3))));\"},\"viewIf\":{\"$code\":\"return ((Q['tried_supporting_kpd'] || 0)===0);\"},\"onArrival\":[{\"$code\":\"Q['tried_supporting_kpd'] = 1;\"}],\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":\"The KPD won't take part in parliamentary government. \",\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"The KPD is not friendly enough with us. \",\"predicate\":1},\" \",{\"type\":\"conditional\",\"content\":\"The KPD does not have enough votes. \",\"predicate\":2},\" \",{\"type\":\"conditional\",\"content\":\"We are already in a Popular Front with the KPD.\",\"predicate\":3}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['communist_coalition'] || 0) < 3);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['kpd_relation'] || 0) < 50);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((((Q['in_grand_coalition'] || 0)) !== 0) && ((Q['kpd_r'] || 0) < (Q['dvp_r'] || 0)))) || (((((Q['in_weimar_coalition'] || 0)) !== 0) && ((Q['kpd_r'] || 0) < (Q['z_r'] || 0)))));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['in_popular_front'] || 0)) !== 0);\"}}]},\"options\":[{\"id\":\"@vote_of_no_confidence.support_kpd_2\",\"title\":\"Persuade the KPD to \\\"tolerate\\\" us?\"},{\"id\":\"@vote_of_no_confidence.let_it_happen\",\"title\":\"Never mind. Let the vote happen.\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"If the Communists abstain, then we essentially can maintain a minority government\",{\"type\":\"conditional\",\"content\":\", although it would be very difficult to make policy without the support of President Hindenburg, which we do not have \",\"predicate\":0},\". If this happens, then we will own a massive debt to the KPD. This could lead to broader cooperation in the future, for better or for worse.\"]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['president'] == \\\"Hindenburg\\\");\"}}]}},\"confronting_nazis.unity\":{\"id\":\"confronting_nazis.unity\",\"goTo\":[{\"id\":\"confronting_nazis.if_end\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"campaigning.unemployed\":{\"id\":\"campaigning.unemployed\",\"subtitle\":\"-1 resources\",\"chooseIf\":{\"$code\":\"return ((Q['resources'] || 0) >= 1);\"},\"unavailableSubtitle\":\"Not enough resources.\",\"onArrival\":[{\"$code\":\"Q['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (6 * (1 - (Q['dissent'] || 0)));\\nQ['resources'] = (Q['resources'] || 0) - 1;\\n if (((Q['welfare'] || 0) < 0) ) { Q['unemployed_spd'] = (Q['unemployed_spd'] || 0) - 3; } \\n if (((Q['wtb_adopted'] || 0)===1) ) { Q['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (6 * (1 - (Q['dissent'] || 0))); } \\n if (((Q['welfare'] || 0) >= 2) ) { Q['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0))); }\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"We have increased our campaigning among the unemployed. \",{\"type\":\"conditional\",\"content\":\"The welfare cuts and resultant poverty make our campaign more difficult, since we are associated with the government that enacted these cuts, and our campaign may even backfire. \",\"predicate\":0},{\"type\":\"conditional\",\"content\":\"Adopting the WTB plan gives us a new rallying point around which to attract support from the unemployed.\",\"predicate\":1}]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['welfare'] || 0) < 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['wtb_adopted'] || 0)===1);\"}}]}},\"crisis_program.support_left\":{\"id\":\"crisis_program.support_left\",\"subtitle\":\"Call for mass nationalizations and the transformation of the economy.\",\"unavailableSubtitle\":\"The Left faction is not strong enough.\",\"chooseIf\":{\"$code\":\"return (((Q['historical_mode'] || 0) == 0) || (((((Q['left_strength'] || 0) >= (Q['labor_strength'] || 0)) && ((Q['left_strength'] || 0) >= (Q['center_strength'] || 0))) && ((Q['left_strength'] || 0) >= (Q['reformist_strength'] || 0)))));\"},\"onArrival\":[{\"$code\":\"Q['left_strength'] = (Q['left_strength'] || 0) + 10;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 5;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) + 5;\\nQ['nationalization_support'] = (Q['nationalization_support'] || 0) + 2;\"}],\"goTo\":[{\"id\":\"crisis_program.support_left_progress\",\"predicate\":{\"$code\":\"return ((Q['nationalization_support'] || 0) < 3);\"}},{\"id\":\"crisis_program.adopt_left\",\"predicate\":{\"$code\":\"return ((Q['nationalization_support'] || 0) >= 3);\"}}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"enemies.bourgeois\":{\"id\":\"enemies.bourgeois\",\"onArrival\":[{\"$code\":\"Q['enemies'] = \\\"bourgeois parties\\\";\\nQ['left_strength'] = (Q['left_strength'] || 0) + 8;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) - 5;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 5;\\nQ['z_relation'] = (Q['z_relation'] || 0) - 5;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) + 5;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 8;\\nQ['workers_z'] = (Q['workers_z'] || 0) - 3;\\nQ['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1;\"}],\"content\":{\"content\":\"Our anti-bourgeois rhetoric is popular among the left, but may make it harder to build the coalitions that are necessary for government in the future.\",\"type\":\"paragraph\"}},\"enemies\":{\"id\":\"enemies\",\"type\":\"scene\",\"title\":\"Choosing Our Enemies\",\"newPage\":true,\"viewIf\":{\"$code\":\"return (((Q['year'] || 0) <= 1930) && ((Q['enemies_timer'] || 0) <= 0));\"},\"onArrival\":[{\"$code\":\"Q['month_actions'] = (Q['month_actions'] || 0) + 1;\\nQ['enemies_timer'] = 18;\"}],\"maxVisits\":3,\"isCard\":true,\"cardImage\":\"img/poster_1.png\",\"tags\":[\"party_affairs\"],\"options\":[{\"id\":\"@enemies.anti_dem\",\"title\":\"The anti-democratic parties of the far right and left - the KPD, NSDAP, and DNVP.\"},{\"id\":\"@enemies.far_right\",\"title\":\"The far right - the NSDAP and DNVP.\"},{\"id\":\"@enemies.nsdap\",\"title\":\"The NSDAP alone.\"},{\"id\":\"@enemies.kpd\",\"title\":\"The KPD.\"},{\"id\":\"@enemies.bourgeois\",\"title\":\"The bourgeois parties - the Center and DVP.\"},{\"id\":\"@easy_discard\"}],\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"Choosing our enemies\"},{\"type\":\"paragraph\",\"content\":\"In our media and campaign materials, who should we consider as our main opponents?\"},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":[\"Previously, we had considered the \",{\"type\":\"insert\",\"insert\":1},\" as our prior enemies. Is a change of direction necessary?\"],\"predicate\":0}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['enemies'] || 0) != 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['enemies'] || 0);\"}}]},\"countVisitsMax\":3},\"ideology.changed\":{\"id\":\"ideology.changed\",\"onArrival\":[{\"$code\":\"Q['left_dissent'] = (Q['left_dissent'] || 0) + 5;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) + 5;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) + 5;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 5;\"}],\"content\":{\"content\":\"We have changed ideologies. Many in the party feel unmoored.\",\"type\":\"paragraph\"}},\"ideology\":{\"id\":\"ideology\",\"type\":\"scene\",\"title\":\"Questions of Ideology\",\"newPage\":true,\"isCard\":true,\"tags\":[\"party_affairs\"],\"viewIf\":{\"$code\":\"return ((Q['ideology_timer'] || 0)===0);\"},\"onArrival\":[{\"$code\":\"Q['month_actions'] = (Q['month_actions'] || 0) + 1;\\nQ['old_ideology'] = (Q['ideology'] || 0);\\nQ['ideology_timer'] = 18;\"}],\"cardImage\":\"img/arbeiterbew.jpg\",\"maxVisits\":3,\"options\":[{\"id\":\"@ideology.class_struggle\",\"title\":\"Class struggle and preparing the proletariat for the revolution are our primary goals.\"},{\"id\":\"@ideology.centrist\",\"title\":\"The Center Marxism of Karl Kautsky remains the best way to resolve our internal contradictions.\"},{\"id\":\"@ideology.labor\",\"title\":\"We should work with the trade unions to improve the lives of workers.\"},{\"id\":\"@ideology.reform\",\"title\":\"Following Eduard Bernstein, we should work for ethical socialism, strengthen democracy, and expand the party's electorate.\"},{\"id\":\"@easy_discard\"}],\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"Questions of Ideology\"},{\"type\":\"paragraph\",\"content\":\"The SPD is torn between many different ideological currents. What should be our primary ideological guidance for now?\"},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":[\"We have previously chosen a \",{\"type\":\"insert\",\"insert\":1},\" ideology. Changing it will likely have drawbacks.\"],\"predicate\":0}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['ideology'] || 0) != 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['ideology'] || 0);\"}}]},\"countVisitsMax\":3},\"inter_party_relationships.no_history\":{\"id\":\"inter_party_relationships.no_history\",\"onArrival\":[{\"$code\":\"Q['kpd_relation'] = (Q['kpd_relation'] || 0) - 3;\"}],\"content\":{\"content\":\"We have no need to apologize for the actions of Ebert and Noske; it is the Communists' fault for launching a violent insurrection.\",\"type\":\"paragraph\"}},\"international_relations.america\":{\"id\":\"international_relations.america\",\"subtitle\":\"-1 resources\",\"chooseIf\":{\"$code\":\"return ((Q['resources'] || 0) >= 1);\"},\"unavailableSubtitle\":\"Not enough resources.\",\"onArrival\":[{\"$code\":\"Q['resources'] = (Q['resources'] || 0) - 1;\"}],\"content\":{\"content\":\"The Socialist Party of America is tiny and has limited support. There is not much we can do for them, and conversely, not much they can do for us.\",\"type\":\"paragraph\"}},\"iron_front.antisemitism\":{\"id\":\"iron_front.antisemitism\",\"title\":\"Rally against antisemitism and in defense of Jewish Germans.\",\"viewIf\":{\"$code\":\"return ((Q['confronting_antisemitism'] || 0) > 1);\"},\"onArrival\":[{\"$code\":\"Q['nationalism'] = (Q['nationalism'] || 0) - (4 * (1 - (Q['dissent'] || 0)));\\nQ['pro_republic'] = (Q['pro_republic'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\nQ['confronting_antisemitism'] = (Q['confronting_antisemitism'] || 0) + 1;\\nQ['workers_nsdap'] = (Q['workers_nsdap'] || 0) - (4 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_nsdap'] = (Q['unemployed_nsdap'] || 0) - (4 * (1 - (Q['dissent'] || 0)));\"}],\"content\":{\"content\":\"The Nazis and other far-right political movements are increasingly turning their hatred against the Jewish community of Germany. The Iron Front rallies in defense of individual Jews and the broader community against violence.\",\"type\":\"paragraph\"}},\"iron_front\":{\"id\":\"iron_front\",\"type\":\"scene\",\"title\":\"The Iron Front\",\"newPage\":true,\"isCard\":true,\"viewIf\":{\"$code\":\"return (((Q['iron_front_formed'] || 0) == 1) && ((Q['iron_front_timer'] || 0)===0));\"},\"onArrival\":[{\"$code\":\"Q['iron_front_timer'] = 7;\\nQ['month_actions'] = (Q['month_actions'] || 0) + 1;\\n if (((Q['rb_militancy'] || 0) > 0.1) ) { \\nQ['rb_militarization_cost'] = 2;;\\n } else { Q['rb_militarization_cost'] = 1; } \\n if (((Q['rb_militancy'] || 0) > 0.25) ) { Q['rb_militarization_cost'] = 3; }\"}],\"cardImage\":\"img/iron_front.png\",\"frequency\":200,\"tags\":[\"party_affairs\",\"antifascism\"],\"options\":[{\"id\":\"@iron_front.defense\",\"title\":\"Rally for defense against the fascists with the Reichsbanner.\"},{\"id\":\"@iron_front.pacifism\",\"title\":\"Rally for pacifism, against nationalism and war.\"},{\"id\":\"@iron_front.republic\",\"title\":\"Rally to save the democratic republic against dictatorship.\"},{\"id\":\"@iron_front.wtb\",\"title\":\"Rally for economic change and the WTB-Plan.\"},{\"id\":\"@iron_front.antisemitism\"},{\"id\":\"@easy_discard\"}],\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"The Iron Front\"},{\"type\":\"paragraph\",\"content\":\"The Iron Front is our new antifascist coordination front, consisting of the SPD, the trade unions, and the Reichsbanner. How should we use the Iron Front?\"},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":\"Unfortunately, the Iron Front's effectiveness is dragged down by the SPD's unpopularity, as the SPD is no longer the dominant party among the workers. Many Reichsbanner members have left, and many workers are not interested.\",\"predicate\":0}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['workers_spd'] || 0) < 45) || ((Q['workers_spd'] || 0) < (Q['workers_nsdap'] || 0))) || ((Q['workers_spd'] || 0) < (Q['workers_kpd'] || 0)));\"}}]}},\"media.radio_2\":{\"id\":\"media.radio_2\",\"title\":\"We must keep on building up our radio network.\",\"subtitle\":\"-1 resources\",\"chooseIf\":{\"$code\":\"return ((Q['resources'] || 0) >= 1);\"},\"unavailableSubtitle\":\"Not enough resources.\",\"viewIf\":{\"$code\":\"return (((Q['radio'] || 0) > 0) && ((Q['radio'] || 0) <= 3));\"},\"onArrival\":[{\"$code\":\"Q['radio'] = (Q['radio'] || 0) + 1;\\nQ['resources'] = (Q['resources'] || 0) - 1;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\nQ['socialism'] = (Q['socialism'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\n if (((Q['pacifism'] || 0) > 2) ) { Q['nationalism'] = (Q['nationalism'] || 0) - ((3 * (1 - (Q['dissent'] || 0))) * (Q['pacifism-2'] || 0)); } \\n if (((Q['democratization'] || 0) > 2) ) { Q['pro_republic'] = (Q['pro_republic'] || 0) + ((3 * (1 - (Q['dissent'] || 0))) * (Q['democratization-2'] || 0)); }\"}],\"content\":{\"content\":\"Our new radio network has a mix of popular and political programming, and is proving a success.\",\"type\":\"paragraph\"}},\"party_disunity.concessions_labor\":{\"id\":\"party_disunity.concessions_labor\",\"title\":\"Give concessions to labor.\",\"viewIf\":{\"$code\":\"return ((Q['labor_dissent'] || 0) > 30);\"},\"onArrival\":[{\"$code\":\"Q['labor_dissent'] = (Q['labor_dissent'] || 0) - 7;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) + 5;\"}],\"content\":{\"content\":\"The trade unions will be granted more influence in party decision making. This upsets the centrists, who would prefer to centralize political decision making within the party.\",\"type\":\"paragraph\"}},\"party_organizations.youth\":{\"id\":\"party_organizations.youth\",\"chooseIf\":{\"$code\":\"return ((Q['resources'] || 0) > 0);\"},\"unavailableSubtitle\":\"Not enough resources.\",\"subtitle\":\"-1 resources\",\"onArrival\":[{\"$code\":\"Q['resources'] = (Q['resources'] || 0) - 1;\\nQ['rb_strength'] = (Q['rb_strength'] || 0) + 50;\\nQ['rb_militancy'] = (Q['rb_militancy'] || 0) + 0.02;\\nQ['young_socialists'] = (Q['young_socialists'] || 0) + 1;\\nQ['left_strength'] = (Q['left_strength'] || 0) + 5;\\nQ['neorevisionist_strength'] = (Q['neorevisionist_strength'] || 0) + 5;\\nQ['radicalization'] = (Q['radicalization'] || 0) + 1;\"}],\"content\":{\"content\":\"Our new youth members flock to the left or neorevisionist wings of the party, and also bring new radicalism to the Reichsbanner.\",\"type\":\"paragraph\"}},\"peoples_party.campaign_middle\":{\"id\":\"peoples_party.campaign_middle\",\"title\":\"Campaign among the middle classes.\",\"onArrival\":[{\"$code\":\"Q['old_middle_spd'] = (Q['old_middle_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) + (6 * (1 - (Q['dissent'] || 0)));\"}],\"content\":{\"content\":\"As a people's party, we represent the employees and small businesspeople of the middle class, and they are becoming receptive to our messages.\",\"type\":\"paragraph\"}},\"peoples_party_campaigning.campaign_women\":{\"id\":\"peoples_party_campaigning.campaign_women\",\"title\":\"Campaign among women of all classes.\",\"onArrival\":[{\"$code\":\"Q['workers_spd'] = (Q['workers_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\nQ['rural_spd'] = (Q['rural_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\"}],\"content\":{\"content\":\"As a people's party, we represent women of all classes.\",\"type\":\"paragraph\"}},\"rally.rb_protect\":{\"id\":\"rally.rb_protect\",\"onArrival\":[{\"$code\":\"Q['rb_success'] = (((Q['rb_strength'] || 0) * (Q['rb_militancy'] || 0)) - ((Q['sa_strength'] || 0) * (Q['sa_militancy'] || 0)));\\nQ['strife'] = (Q['strife'] || 0) + 1;\"}],\"goTo\":[{\"id\":\"rally.rb_protect_win\",\"predicate\":{\"$code\":\"return ((Q['rb_success'] || 0) >= 0);\"}},{\"id\":\"rally.rb_protect_lose\",\"predicate\":{\"$code\":\"return ((Q['rb_success'] || 0) < 0);\"}}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"reichsbanner.women_rb\":{\"id\":\"reichsbanner.women_rb\",\"title\":\"Allow women to join the Reichsbanner.\",\"subtitle\":\"-1 resources - This might cause a backlash from existing members.\",\"chooseIf\":{\"$code\":\"return ((Q['resources'] || 0) > 0);\"},\"viewIf\":{\"$code\":\"return ((((Q['womens_rights'] || 0) >= 4) && ((Q['sender_advisor'] || 0) == 1)) && ((Q['iron_front_formed'] || 0) == 1));\"},\"onArrival\":[{\"$code\":\"Q['resources'] = (Q['resources'] || 0) - 1;\\nQ['rb_militancy'] = (Q['rb_militancy'] || 0) * 0.85;\\nQ['rb_strength'] = (Q['rb_strength'] || 0) + 400;\\nQ['women_in_rb'] = 1;\\n if ((((Q['repealed_175'] || 0)) !== 0) ) { Q['rb_militancy'] = (Q['rb_militancy'] || 0) + 0.05; } \\n if ((((Q['trans_rights'] || 0)) !== 0) ) { Q['rb_militancy'] = (Q['rb_militancy'] || 0) + 0.04; } \\n if ((((Q['reformed_183'] || 0)) !== 0) ) { Q['rb_militancy'] = (Q['rb_militancy'] || 0) + 0.02; }\"}],\"maxVisits\":1,\"achievement\":\"women_reichsbanner\",\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[\"The suggestion to allow women into the Reichsbanner is ridiculed by most, except for Toni Sender. But this is an exceptional time, and we need anyone who is willing to join. Thus, we organize specialized units for women, \",{\"type\":\"conditional\",\"content\":\"and even some covert units for transsexuals and inverts \",\"predicate\":0},\".\"]},{\"type\":\"paragraph\",\"content\":\"After allowing women to join, the number of comrades who leave is more than balanced out by the number of radicalized women and others who join. However, many of our departed members were veterans, and many of the new members have no experience with military-style training.\"}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['homosexual_rights'] || 0) > 0);\"}}]},\"countVisitsMax\":1},\"reichsbanner\":{\"id\":\"reichsbanner\",\"type\":\"scene\",\"title\":\"Reichsbanner\",\"newPage\":true,\"isCard\":true,\"tags\":[\"party_affairs\"],\"viewIf\":{\"$code\":\"return ((Q['reichsbanner_timer'] || 0) <= 0);\"},\"cardImage\":\"img/reichsbanner.jpg\",\"onArrival\":[{\"$code\":\"Q['month_actions'] = (Q['month_actions'] || 0) + 1;\\nQ['reichsbanner_timer'] = (Q['reichsbanner_timer'] || 0) + 6;\\n if (((Q['rb_militancy'] || 0) > 0.1) ) { \\nQ['rb_militarization_cost'] = 2;;\\n } else { Q['rb_militarization_cost'] = 1; } \\n if (((Q['rb_militancy'] || 0) > 0.25) ) { Q['rb_militarization_cost'] = 3; }\"}],\"maxVisits\":5,\"options\":[{\"id\":\"@reichsbanner.militant\",\"title\":\"Fund more military-style training and equipment for the Reichsbanner.\"},{\"id\":\"@reichsbanner.militant_2\",\"title\":\"Use our existing resources to support more training for the Reichsbanner.\"},{\"id\":\"@reichsbanner.same\",\"title\":\"Keep the Reichsbanner as it is.\"},{\"id\":\"@reichsbanner.cut_rb\",\"title\":\"Cut funding for the Reichsbanner.\"},{\"id\":\"@reichsbanner.women_rb\"},{\"id\":\"@easy_discard\"},{\"id\":\"@cancel_advisor_action\"}],\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"Reichsbanner\"},{\"type\":\"paragraph\",\"content\":[\"The \",{\"type\":\"emphasis-1\",\"content\":\"Reichsbanner Schwarz-Rot-Gold\"},\" is a mass organization for the defense of the Republic against the extremists who threaten it. Some would call it a paramilitary, although currently it is hardly any sort of military. It is officially associated with the pro-democratic parties -the SPD, Center, and DDP, but by far the largest component is with the SPD.\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":\"The Reichsbanner is having a more difficult time recruiting, as the SPD is no longer the dominant party among the workers. Many of its members have left.\",\"predicate\":0}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['workers_spd'] || 0) < 46) || ((Q['workers_spd'] || 0) < (Q['workers_nsdap'] || 0))) || ((Q['workers_spd'] || 0) < (Q['workers_kpd'] || 0)));\"}}]},\"countVisitsMax\":5},\"shuffle_leadership.remove_muller\":{\"id\":\"shuffle_leadership.remove_muller\",\"title\":\"Remove Müller\",\"viewIf\":{\"$code\":\"return ((Q['muller_advisor'] || 0)===1);\"},\"tags\":[\"remove_advisor\"],\"onArrival\":[{\"$code\":\"Q['muller_advisor'] = 0;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) + 5;\\nQ['n_advisors'] = (Q['n_advisors'] || 0) - 1;\"}],\"goTo\":[{\"id\":\"shuffle_leadership.rm_main\"}],\"content\":{\"content\":\"Müller has been removed as an advisor. The Centrist faction disapproves.\",\"type\":\"paragraph\"}},\"streetfighting.peace\":{\"id\":\"streetfighting.peace\",\"onArrival\":[{\"$code\":\"Q['rb_militancy'] = (Q['rb_militancy'] || 0) - 0.02;\\nQ['rb_strength'] = (Q['rb_strength'] || 0) - 50;\\nQ['pacifism'] = (Q['pacifism'] || 0) + 1;\"}],\"content\":{\"content\":\"By not fighting, the strength of the Reichsbanner atrophies. Pacifists in the party are gaining the upper hand.\",\"type\":\"paragraph\"}},\"game_over.civil_war_won\":{\"id\":\"game_over.civil_war_won\",\"title\":\"We have won the civil war.\",\"viewIf\":{\"$code\":\"return ((Q['republic_victory'] || 0) == 1);\"},\"tags\":[\"endings\"],\"goTo\":[{\"id\":\"game_over.eg_menu\"}],\"content\":{\"content\":\"We have won the civil war against the reactionary forces. Germany will be changed forever, but it is too early to know how.\",\"type\":\"paragraph\"}},\"library.demographics\":{\"id\":\"library.demographics\",\"goTo\":[{\"id\":\"library.menu\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"Demographic Groups\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"Working Class\"},\": The urban working class - blue-collar workers in factories, workshops, mines, and the like. Most are socialist, supporting either the SPD or KPD. They make up 40-50% of the population.\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"Old Mittelstand\"},\": The old middle class consists of independent artisans, shopkeepers, and small-time businesspeople. They tend to be conservative and are the strongest base for the far right. 10-15% of the population.\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"New Mittelstand\"},\": The new middle class consists of white-collar workers and government employees. This is the base of liberalism. 10-15% of the population.\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"Rural\"},\": Small and large farmers and independent rural workers. Protestant farmers often support the DNVP. 20-30% of the population.\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"Catholics\"},\" are the largest religious minority, at about 30% of the population. They disproportionately support the Center Party (or the Bavarian People's Party in Bavaria).\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"Jews\"},\" account for between 0.5% to 1% of the population, and tend to support liberal parties, mostly the DDP, although substantial numbers support the SPD or KPD.\"]}]},\"root.1928_historical\":{\"id\":\"root.1928_historical\",\"subtitle\":{\"content\":[\"Saving, loading, and polls will be disabled. \",{\"type\":\"conditional\",\"content\":\"Not recommended for a first playthrough.\",\"predicate\":0}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (!(((Q['achievement_game_completed'] || 0)) !== 0));\"}}]},\"onArrival\":[{\"$code\":\"Q.difficulty = 2;\\nQ.historical_mode = 1;\\nQ.resources = 2;\\nQ.dues = 1;\\nQ.rb_strength = 2000;\\nQ.reformist_dissent = 25;\\nQ.left_dissent = 30;\\nQ.labor_dissent = 25;\\nQ.center_dissent = 25;\\nQ.z_relation = 41;\\nQ.kpd_relation = 16;\\nQ.dvp_relation = 31;\\nQ.budget = 2;\\nthis.state.disableSaves = true;\"}],\"goTo\":[{\"id\":\"root.1928_main\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"stampfer.support_reform\":{\"id\":\"stampfer.support_reform\",\"onArrival\":[{\"$code\":\"Q['reformist_dissent'] = (Q['reformist_dissent'] || 0) - 8;\\nQ['reformist_strength'] = (Q['reformist_strength'] || 0) + 8;\"}],\"content\":{\"content\":\"Vorwärts prints editorials in support of the reformist policies.\",\"type\":\"paragraph\"}},\"dealing_with_toleration.improve_relations\":{\"id\":\"dealing_with_toleration.improve_relations\",\"title\":\"Improve relations with the parties of the coalition.\",\"onArrival\":[{\"$code\":\"Q['z_relation'] = (Q['z_relation'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 5;\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"We have increased our level of contact and discussions with the parties of the coalition, primarily the Center Party and DVP.\"},{\"type\":\"paragraph\",\"content\":\"Our attempts to reach out to the center-right are met with disdain by leftists within our party.\"}]},\"deport_hitler.deport_success\":{\"id\":\"deport_hitler.deport_success\",\"onArrival\":[{\"$code\":\"Q['hitler_deported'] = 1;\\nQ['sa_strength'] = ((Q['sa_strength'] || 0) / 2);\\nQ['workers_nsdap'] = (Q['workers_nsdap'] || 0) - 10;\\nQ['new_middle_nsdap'] = (Q['new_middle_nsdap'] || 0) - 10;\\nQ['old_middle_nsdap'] = (Q['old_middle_nsdap'] || 0) - 10;\\nQ['rural_nsdap'] = (Q['rural_nsdap'] || 0) - 10;\\nQ['unemployed_nsdap'] = (Q['unemployed_nsdap'] || 0) - 10;\\nQ['coup_progress'] = (Q['coup_progress'] || 0) - 2;\\nQ['nsdap_leader'] = \\\"Goebbels\\\";\"}],\"achievement\":\"deport_hitler\",\"content\":[{\"type\":\"paragraph\",\"content\":\"Somehow, the plan worked! There was minimal resistance to Hitler's deportation. This is a sign of weakness, and his physical distance makes organizing difficult, impeding the Nazi effort to win more votes.\"},{\"type\":\"paragraph\",\"content\":\"In Hitler's absence, Joseph Goebbels has become the temporary leader of the Nazi party, with substantial influence from Hermann Göring.\"}]},\"economic_policy.nationalize_1\":{\"id\":\"economic_policy.nationalize_1\",\"title\":\"Implement the Left plan for the transformation of the economy.\",\"subtitle\":{\"content\":[\"-\",{\"type\":\"insert\",\"insert\":0},\" budget. \",{\"type\":\"conditional\",\"content\":\"Our works councils have reduced the budget necessary for this program. \",\"predicate\":1},\" \",{\"type\":\"conditional\",\"content\":\"Our existing socialization policies have reduced the budget necessary for this program.\",\"predicate\":2}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['nationalize_budget'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['works_councils'] || 0) >= 3);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['socializations'] || 0) >= 2);\"}}]},\"viewIf\":{\"$code\":\"return (((Q['nationalization_adopted'] || 0) == 1) && ((Q['nationalization_progress'] || 0) == 0));\"},\"goTo\":[{\"id\":\"economic_policy.nationalize_deficit\",\"predicate\":{\"$code\":\"return ((Q['budget'] || 0) < (Q['nationalize_budget'] || 0));\"}},{\"id\":\"economic_policy.nationalize_no_deficit\",\"predicate\":{\"$code\":\"return ((Q['budget'] || 0) >= (Q['nationalize_budget'] || 0));\"}}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"domestic_enemies.persecute_sh\":{\"id\":\"domestic_enemies.persecute_sh\",\"title\":\"Further persecute the Stahlhelm.\",\"viewIf\":{\"$code\":\"return ((Q['sh_banned'] || 0)===1);\"},\"chooseIf\":{\"$code\":\"return (((Q['judicial_reform'] || 0) >= 4) && ((Q['interior_police_loyalty'] || 0) >= 0.7));\"},\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":\"The judiciary would not allow this. \",\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"The police are too disloyal to be trusted with this.\",\"predicate\":1}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['judicial_reform'] || 0) < 4);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['interior_police_loyalty'] || 0) < 0.7);\"}}]},\"onArrival\":[{\"$code\":\"Q['sh_strength'] = (Q['sh_strength'] || 0) * 0.7;\\nQ['sh_militancy'] = (Q['sh_militancy'] || 0) - 0.05;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 5;\\nQ['prussian_police_loyalty'] = (Q['prussian_police_loyalty'] || 0) - 0.1;\\nQ['interior_police_loyalty'] = (Q['interior_police_loyalty'] || 0) - 0.05;\\n if (((((Q['spd_in_government'] || 0)===1) && ((Q['in_grand_coalition'] || 0)===1)) && (Q['president'] == \\\"Hindenburg\\\")) ) { Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1; }\"}],\"content\":{\"content\":\"We have arrested more of the Stahlhelm's leaders and confiscated their weapons.\",\"type\":\"paragraph\"}},\"foreign_policy.soviet_economic_aid_yes\":{\"id\":\"foreign_policy.soviet_economic_aid_yes\",\"chooseIf\":{\"$code\":\"return ((Q['budget'] || 0) >= 1);\"},\"subtitle\":\"-1 budget\",\"onArrival\":[{\"$code\":\"Q['budget'] = (Q['budget'] || 0) - 1;\\nQ['soviet_relation'] = (Q['soviet_relation'] || 0) + 2;\\nQ['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1;\\nQ['foreign_goal_completed'] = (Q['foreign_goal_completed'] || 0) + 1;\"}],\"options\":[{\"id\":\"@foreign_policy.kpd\",\"title\":\"Ask if Moscow could help repair our relations with the KPD.\"},{\"id\":\"@foreign_policy.wittorf\",\"title\":\"Do the Soviets know about the Wittorf Affair? Do they know that we know?\"},{\"id\":\"@root\",\"title\":\"Do not mention the KPD.\"}],\"content\":{\"content\":\"The Soviets are pleased that we have sent them aid, and have not asked for anything specific in exchange. Our coalition partners are less pleased.\",\"type\":\"paragraph\"}},\"fiscal_policy.regressive\":{\"id\":\"fiscal_policy.regressive\",\"title\":\"Lower taxes on the rich, while increasing consumption taxes (which affect the working class more).\",\"subtitle\":\"This does not change overall revenue.\",\"onArrival\":[{\"$code\":\"Q['workers_spd'] = (Q['workers_spd'] || 0) - 6;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) + 5;\\nQ['z_relation'] = (Q['z_relation'] || 0) + 4;\\n if (((((Q['in_grand_coalition'] || 0)) !== 0) && ((Q['coalition_dissent'] || 0) > 0)) ) { Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) - 1; } \\nQ['kpd_coalition_dissent'] = (Q['kpd_coalition_dissent'] || 0) + 1;\\nQ['upper_tax_rates'] = (Q['upper_tax_rates'] || 0) - 1;\\nQ['lower_tax_rates'] = (Q['lower_tax_rates'] || 0) + 1;\\n if (((Q['lower_tax_rates'] || 0) >= 2) ) { Q['workers_spd'] = (Q['workers_spd'] || 0) - 5; } \\n if (((Q['upper_tax_rates'] || 0) < 0) ) { Q['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) - 1; }\"}],\"content\":{\"content\":\"Our regressive taxation policy benefits the rich while hurting the poor and working-class. Our bourgeois coalition partners approve of this orthodox economic course.\",\"type\":\"paragraph\"}},\"labor_rights.cut_benefits\":{\"id\":\"labor_rights.cut_benefits\",\"subtitle\":\"The workers will regard this as a betrayal.\",\"onArrival\":[{\"$code\":\"Q['workers_spd'] = (Q['workers_spd'] || 0) - (0.12 * (Q['workers_spd'] || 0));\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) - (0.2 * (Q['unemployed_spd'] || 0));\\nQ['workers_kpd'] = (Q['workers_kpd'] || 0) + 6;\\nQ['workers_nsdap'] = (Q['workers_nsdap'] || 0) + 6;\\nQ['unemployed_kpd'] = (Q['unemployed_kpd'] || 0) + 5;\\nQ['unemployed_nsdap'] = (Q['unemployed_nsdap'] || 0) + 5;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 15;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) + 10;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) + 15;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 5;\\nQ['welfare'] = (Q['welfare'] || 0) - 2;\\nQ['budget'] = (Q['budget'] || 0) + 1;\\nQ['unemployed'] = (Q['unemployed'] || 0) + 3;\\nQ['pro_republic'] = (Q['pro_republic'] || 0) - 4;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) - 8;\\nQ['inflation'] = (Q['inflation'] || 0) - 2;\\nQ['unemployment_insurance_threshold'] = (Q['unemployed'] || 0);\\nQ['unemployment_insurance_timer'] = 10;\"}],\"content\":{\"content\":\"For budgetary reasons, we have cut unemployment insurance benefits. Unfortunately, our reasons for fiscal discipline are alien to the workers. They are furious at our betrayal, as are a good portion of our membership throughout the factions. Our loss is the KPD's gain, and even the NSDAP, those lapdogs of the bourgeoisie, have joined in criticizing us for our austerity.\",\"type\":\"paragraph\"}},\"police.investigate_far_right_success\":{\"id\":\"police.investigate_far_right_success\",\"onArrival\":[{\"$code\":\"Q['investigate_far_right'] = (Q['investigate_far_right'] || 0) + 1;\\nQ['sa_strength'] = (Q['sa_strength'] || 0) - 20;\\nQ['workers_nsdap'] = (Q['workers_nsdap'] || 0) - 3;\\nQ['new_middle_nsdap'] = (Q['new_middle_nsdap'] || 0) - 3;\\n if (((Q['investigate_far_right'] || 0) == 2) ) { Q['nazi_urgency'] = (Q['nazi_urgency'] || 0) + 1; } \\n if (((Q['investigate_far_right'] || 0) == 3) ) { Q['nazi_urgency'] = (Q['nazi_urgency'] || 0) + 2; } \\n if (((Q['investigate_far_right'] || 0) == 3) ) { Q['workers_nsdap'] = (Q['workers_nsdap'] || 0) - 3; } \\n if (((Q['investigate_far_right'] || 0) == 3) ) { Q['new_middle_nsdap'] = (Q['new_middle_nsdap'] || 0) - 3; } \\n if (((Q['investigate_far_right'] || 0) == 3) ) { Q['old_middle_nsdap'] = (Q['old_middle_nsdap'] || 0) - 3; } \\n if (((Q['investigate_far_right'] || 0) == 3) ) { Q['unemployed_spd'] = (Q['unemployed_spd'] || 0) - 3; } \\n if (((Q['coup_progress'] || 0) >= 7) ) { Q['coup_progress'] = (Q['coup_progress'] || 0) - 1; }\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"We have discovered collusion between Hjalmar Schacht, president of the Reichsbank, and the Nazis. This is very useful information. \",\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"We have discovered illegal arms smuggling by the SA, the Nazi paramilitary. \",\"predicate\":1},\" \",{\"type\":\"conditional\",\"content\":\"We have discovered a secret cache of documents from the NSDAP detailing their plan to violently take over the country if they enter into power. This is an anti-constitutional plot, and will be publicized and persecuted. \",\"predicate\":2},\" \",{\"type\":\"conditional\",\"content\":\"Of course the Nazis are doing crimes; everyone knows that. Now, we finally have proof. \",\"predicate\":3},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":\"There are reports of an imminent coup by the far-right. We have attempted to disrupt some of these plans, but the threat is still present.\",\"predicate\":4}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['investigate_far_right'] || 0) == 1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['investigate_far_right'] || 0) == 2);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['investigate_far_right'] || 0) == 3);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['investigate_far_right'] || 0) > 3);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['coup_progress'] || 0) >= 6);\"}}]}},\"prussian_affairs.ban_sh\":{\"id\":\"prussian_affairs.ban_sh\",\"onArrival\":[{\"$code\":\"Q['sh_strength'] = (Q['sh_strength'] || 0) * 0.85;\\n if (((Q['prussian_police_loyalty'] || 0) >= 0.75) ) { Q['sh_strength'] = (Q['sh_strength'] || 0) * 0.7; } \\nQ['sh_banned'] = 1;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 5;\\nQ['prussian_police_loyalty'] = (Q['prussian_police_loyalty'] || 0) - 0.1;\\n if (((((Q['spd_in_government'] || 0)===1) && ((Q['in_grand_coalition'] || 0)===1)) && (Q['president'] == \\\"Hindenburg\\\")) ) { Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1; } \\nQ['sh_ban_timer'] = 6;\"}],\"viewIf\":{\"$code\":\"return ((Q['sh_banned'] || 0) == 0);\"},\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"Banning the Stahlhelm weakens our relationship with President Hindenburg, as well as the political right and the police. \",\"predicate\":0},{\"type\":\"conditional\",\"content\":\"Banning the Stahlhelm weakens our relationship with the political right and the police. \",\"predicate\":1},\" \",{\"type\":\"conditional\",\"content\":\"It also weakens our coalition due to the influence of Hindenburg on the right wing of our coalition. \",\"predicate\":2},\" In addition, the Stahlhelm still operates out of public sight.\"]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['president'] == \\\"Hindenburg\\\");\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['president'] != \\\"Hindenburg\\\");\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['spd_in_government'] || 0)===1) && ((Q['in_grand_coalition'] || 0)===1)) && (Q['president'] == \\\"Hindenburg\\\"));\"}}]}},\"womens_rights.liberalize_success\":{\"id\":\"womens_rights.liberalize_success\",\"onArrival\":[{\"$code\":\"Q['abortion_rights'] = (Q['abortion_rights'] || 0) + 1;\\nQ['womens_rights'] = (Q['womens_rights'] || 0) + 1;\\nQ['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1;\\nQ['z_relation'] = (Q['z_relation'] || 0) - 8;\\nQ['catholics_spd'] = (Q['catholics_spd'] || 0) - 10;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 5;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\nQ['workers_z'] = (Q['workers_z'] || 0) + 3;\\nQ['new_middle_z'] = (Q['new_middle_z'] || 0) + 3;\\nQ['old_middle_z'] = (Q['old_middle_z'] || 0) + 3;\\nQ['old_middle_dnvp'] = (Q['old_middle_dnvp'] || 0) + 3;\\nQ['rural_dnvp'] = (Q['rural_dnvp'] || 0) + 3;\\nQ['workers_nsdap'] = (Q['workers_nsdap'] || 0) - 3;\\nQ['new_middle_nsdap'] = (Q['new_middle_nsdap'] || 0) - 3;\\nQ['old_middle_nsdap'] = (Q['old_middle_nsdap'] || 0) - 2;\\nQ['rural_nsdap'] = (Q['rural_nsdap'] || 0) - 2;\\nQ['unemployed_nsdap'] = (Q['unemployed_nsdap'] || 0) - 2;\\nQ['unemployed_z'] = (Q['unemployed_z'] || 0) + 3;\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\"}],\"content\":{\"content\":\"With the support of a \\\"progressive coalition\\\" including the KPD and DDP, we have successfully passed a bill to legalize abortion in Germany! This has heartened our more progressive supporters, while hurting our relations with the Center Party. With the increasing political discourse around abortion, the religiously-oriented Center Party and DNVP have gained conservative votes at the expense of the NSDAP.\",\"type\":\"paragraph\"}},\"womens_rights\":{\"id\":\"womens_rights\",\"type\":\"scene\",\"title\":\"Women's Rights\",\"newPage\":true,\"isCard\":true,\"tags\":[\"govt_affairs\"],\"viewIf\":{\"$code\":\"return ((((Q['spd_in_government'] || 0)===1) && ((Q['womens_rights_timer'] || 0)===0)) && (Q['chancellor_party'] == \\\"SPD\\\"));\"},\"onArrival\":[{\"$code\":\"Q['womens_rights_timer'] = (Q['womens_rights_timer'] || 0) + 10;\\nQ['month_actions'] = (Q['month_actions'] || 0) + 1;\"}],\"cardImage\":\"img/portraits/PfülfAntonie.jpg\",\"frequency\":50,\"maxVisits\":4,\"options\":[{\"id\":\"@womens_rights.labor\",\"title\":\"Institute policies that help women in the workforce.\"},{\"id\":\"@womens_rights.family\",\"title\":\"Reform marriage, divorce, and property law.\"},{\"id\":\"@womens_rights.welfare\",\"title\":\"Improve welfare for single mothers and children.\"},{\"id\":\"@womens_rights.liberalize\",\"title\":\"Attempt to liberalize abortion laws.\"},{\"id\":\"@return\",\"title\":\"Do not enact any policies for now.\"},{\"id\":\"@easy_discard\"},{\"id\":\"@cancel_advisor_action\"}],\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"Women's Rights\"},{\"type\":\"paragraph\",\"content\":\"According to the Constitution, women are equal to men, but this is not followed in practice. Women in the workforce are not paid equally for the same work, in addition to often being pushed out of employment after marriage. Men are still favored in marriage and family policy, and there are restrictions on women's rights in many other domains. And that is not to mention the overwhelming patriarchal culture present in Germany.\"},{\"type\":\"paragraph\",\"content\":[\"For better or for worse, the Socialists stand virtually alone in supporting increased rights for women, and even within the party, the leadership does not consider it a priority. \",{\"type\":\"conditional\",\"content\":\"Unfortunately, women still disproportionately support the bourgeois parties.\",\"predicate\":0}]}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['spd_r'] || 0) < 50);\"}}]},\"countVisitsMax\":4},\"blutmai.allow\":{\"id\":\"blutmai.allow\",\"onArrival\":[{\"$code\":\"Q['workers_kpd'] = (Q['workers_kpd'] || 0) + 5;\\nQ['unemployed_kpd'] = (Q['unemployed_kpd'] || 0) + 5;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) + 10;\\nQ['rfb_strength'] = (Q['rfb_strength'] || 0) + 50;\\nQ['z_relation'] = (Q['z_relation'] || 0) - 3;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 3;\\nQ['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1;\\nQ['rfb_militancy'] = (Q['rfb_militancy'] || 0) + 0.1;\"}],\"content\":{\"type\":\"paragraph\",\"content\":[\"The demonstration proceeds peacefully, with a minimal police presence. Onlookers admire the strength of the Communist workers, and perhaps some of our members have been peeled off. The KPD will never admit it, but they are developing a less hostile view towards us (even if they do not \",{\"type\":\"emphasis-1\",\"content\":\"like\"},\" us yet). Our centrist allies denounce the demonstration, but their cries are ineffectual.\"]}},\"death_of_muller.wirth_chancellor\":{\"id\":\"death_of_muller.wirth_chancellor\",\"onArrival\":[{\"$code\":\"Q['chancellor'] = \\\"Wirth\\\";\\nQ['chancellor_party'] = \\\"Z\\\";\\nQ['z_relation'] = (Q['z_relation'] || 0) + 5;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) + 2;\"}],\"viewIf\":{\"$code\":\"return (Q['z_party_leader'] == \\\"Joos\\\");\"},\"subtitle\":\"As a moderate member of the Center Party, he could represent unity.\",\"content\":{\"content\":\"Our coalition partners accept Joseph Wirth of the Center Party as the new Chancellor.\",\"type\":\"paragraph\"}},\"civil_war.foreign_intervention\":{\"id\":\"civil_war.foreign_intervention\",\"maxVisits\":1,\"goTo\":[{\"id\":\"civil_war.war_menu\"}],\"onArrival\":[{\"$code\":\"Q['war_choices'] = (Q['war_choices'] || 0) + 1;\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"},\"countVisitsMax\":1},\"election_1928.popular_front_2\":{\"id\":\"election_1928.popular_front_2\",\"viewIf\":{\"$code\":\"return ((Q['z_party_leader'] != \\\"Joos\\\") || (Q['kpd_party_leader'] != \\\"Conciliators\\\"));\"},\"options\":[{\"id\":\"@election_1928.popular_front_resources\"},{\"id\":\"@election_1928.popular_front_democracy\"},{\"id\":\"@election_1928.popular_front_braun\"},{\"id\":\"@election_1928.coalition_menu\",\"title\":\"This is impossible. Try another governing arrangement.\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"Somehow, both the Communists and Center are at the very least willing to entertain negotiations. Of course, KPD radicals and Center conservatives derail the negotiations almost immediately. The KPD demands leadership of the coalition for themselves and their chairman Ernst Thälmann, \",{\"type\":\"conditional\",\"content\":\"despite our higher vote share, \",\"predicate\":0},\"while the Center is offended by the prospect of helping Bolsheviks enter government. \",{\"type\":\"emphasis-1\",\"content\":\"Something\"},\" must be done to restore balance.\"]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['spd_r'] || 0) > (Q['kpd_r'] || 0));\"}}]}},\"kpd_policy.economy_oppose\":{\"id\":\"kpd_policy.economy_oppose\",\"onArrival\":[{\"$code\":\"Q['kpd_coalition_dissent'] = (Q['kpd_coalition_dissent'] || 0) + 1;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 5;\\nQ['workers_kpd'] = (Q['workers_kpd'] || 0) + 5;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) - 6;\"}],\"content\":{\"content\":\"After opposing the nationalization policy, the KPD has commenced a propaganda campaign against us, accusing the SPD of yet another perfidy.\",\"type\":\"paragraph\"}},\"kpd_ultimatum.no_vonc\":{\"id\":\"kpd_ultimatum.no_vonc\",\"viewIf\":{\"$code\":\"return (((Q['constructive_vonc'] || 0)) !== 0);\"},\"onArrival\":[{\"$code\":\"Q['in_popular_front'] = 0;\\nQ['in_left_front'] = 0;\\nQ['in_minority_government'] = 1;\"}],\"content\":{\"content\":\"We have been effectively made a minority government, and the KPD intends to obstruct our attempts to pass policy.\",\"type\":\"paragraph\"}},\"kpd_ultimatum\":{\"id\":\"kpd_ultimatum\",\"type\":\"scene\",\"title\":\"The KPD checks upon our progress in accomplishing the coalition's goals...\",\"viewIf\":{\"$code\":\"return (((((((((Q['in_popular_front'] || 0)) !== 0) || (((Q['in_left_front'] || 0)) !== 0))) && ((((Q['kpd_ultimatum_timer'] || 0)===0) || (((((((((Q['welfare_goal_completed'] || 0)) !== 0) && (((Q['agriculture_goal_completed'] || 0)) !== 0)) && (((Q['economy_goal_completed'] || 0)) !== 0)) && (((Q['finance_goal_completed'] || 0)) !== 0)) && (((Q['labor_goal_completed'] || 0)) !== 0)) && (((Q['reichswehr_goal_completed'] || 0)) !== 0)))))) && ((Q['kpd_goals_seen'] || 0)===1)) && ((Q['kpd_ultimatum_seen'] || 0)===0)) && (((Q['spd_in_government'] || 0)) !== 0));\"},\"onArrival\":[{\"$code\":\"Q.kpd_ultimatum_seen = 1;\\nQ.kpd_goals_completed = 1;\\nQ.kpd_score = 6;\\nif (Q.welfare_goal && !Q.welfare_goal_completed) {\\n    Q.kpd_goals_completed = 0;\\n    Q.kpd_score -= 1;\\n}\\nif (Q.agriculture_goal && !Q.agriculture_goal_completed) {\\n    Q.kpd_goals_completed = 0;\\n    Q.kpd_score -= 1;\\n}\\nif (Q.economy_goal && !Q.economy_goal_completed) {\\n    Q.kpd_goals_completed = 0;\\n    Q.kpd_score -= 1;\\n}\\nif (Q.finance_goal && !Q.finance_goal_completed) {\\n    Q.kpd_goals_completed = 0;\\n    Q.kpd_score -= 1;\\n}\\nif (Q.labor_goal && !Q.labor_goal_completed) {\\n    Q.kpd_goals_completed = 0;\\n    Q.kpd_score -= 1;\\n}\\nif (Q.foreign_goal && !Q.foreign_goal_completed) {\\n    Q.kpd_goals_completed = 0;\\n    Q.kpd_score -= 1;\\n}\\nif (Q.interior_goal && !Q.interior_goal_completed) {\\n    Q.kpd_goals_completed = 0;\\n}\\nif (Q.reichswehr_goal && !Q.reichswehr_goal_completed) {\\n    Q.kpd_goals_completed = 0;\\n    Q.kpd_score -= 1;\\n}\"}],\"newPage\":true,\"tags\":[\"event\"],\"goTo\":[{\"id\":\"kpd_ultimatum.goals_success\",\"predicate\":{\"$code\":\"return (((Q['kpd_goals_completed'] || 0)) !== 0);\"}},{\"id\":\"kpd_ultimatum.goals_failed\",\"predicate\":{\"$code\":\"return (!(((Q['kpd_goals_completed'] || 0)) !== 0));\"}}],\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"KPD Goals\"},{\"type\":\"paragraph\",\"content\":\"At the start of this government, the KPD presented a list of goals for the coalition:\"},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"- Expand social welfare programs - \",{\"type\":\"conditional\",\"content\":\"success \",\"predicate\":1},{\"type\":\"conditional\",\"content\":\"failed \",\"predicate\":2},\" \"],\"predicate\":0},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"- Enact a land reform program. - \",{\"type\":\"conditional\",\"content\":\"success \",\"predicate\":4},{\"type\":\"conditional\",\"content\":\"failed \",\"predicate\":5},\" \"],\"predicate\":3},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"- Start substantial nationalization of the economy. - \",{\"type\":\"conditional\",\"content\":\"success \",\"predicate\":7},{\"type\":\"conditional\",\"content\":\"failed \",\"predicate\":8},\" \"],\"predicate\":6},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"- Make taxes more progressive. - \",{\"type\":\"conditional\",\"content\":\"success \",\"predicate\":10},{\"type\":\"conditional\",\"content\":\"failed \",\"predicate\":11},\" \"],\"predicate\":9},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"- Support workers in labor disputes. - \",{\"type\":\"conditional\",\"content\":\"success \",\"predicate\":13},{\"type\":\"conditional\",\"content\":\"failed \",\"predicate\":14},\" \"],\"predicate\":12},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"- Improve our relations with the Soviet Union. - \",{\"type\":\"conditional\",\"content\":\"success \",\"predicate\":16},{\"type\":\"conditional\",\"content\":\"failed \",\"predicate\":17},\" \"],\"predicate\":15},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":[\"- Reduce funding for the Reichswehr. - \",{\"type\":\"conditional\",\"content\":\"success \",\"predicate\":19},{\"type\":\"conditional\",\"content\":\"failed \",\"predicate\":20},\"\"],\"predicate\":18}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['welfare_goal'] || 0)===1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['welfare_goal_completed'] || 0)) !== 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (!(((Q['welfare_goal_completed'] || 0)) !== 0));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['agriculture_goal'] || 0)===1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['agriculture_goal_completed'] || 0)) !== 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (!(((Q['agriculture_goal_completed'] || 0)) !== 0));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['economy_goal'] || 0)===1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['economy_goal_completed'] || 0)) !== 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (!(((Q['economy_goal_completed'] || 0)) !== 0));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['finance_goal'] || 0)===1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['finance_goal_completed'] || 0)) !== 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (!(((Q['finance_goal_completed'] || 0)) !== 0));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['labor_goal'] || 0)===1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['labor_goal_completed'] || 0)) !== 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (!(((Q['labor_goal_completed'] || 0)) !== 0));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['foreign_goal'] || 0)===1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['foreign_goal_completed'] || 0)) !== 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (!(((Q['foreign_goal_completed'] || 0)) !== 0));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['reichswehr_goal'] || 0)===1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['reichswehr_goal_completed'] || 0)) !== 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (!(((Q['reichswehr_goal_completed'] || 0)) !== 0));\"}}]}},\"kpd_vote_of_no_confidence.let_it_happen\":{\"id\":\"kpd_vote_of_no_confidence.let_it_happen\",\"viewIf\":{\"$code\":\"return (!(((Q['constructive_vonc'] || 0)) !== 0));\"},\"onArrival\":[{\"$code\":\"Q['kpd_relation'] = (Q['kpd_relation'] || 0) - 8;\\nQ['workers_kpd'] = (Q['workers_kpd'] || 0) - 5;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 8;\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) - 6;\"}],\"goTo\":[{\"id\":\"kpd_vote_of_no_confidence.let_it_happen_braun\",\"predicate\":{\"$code\":\"return (Q['president'] == \\\"Braun\\\");\"}},{\"id\":\"kpd_vote_of_no_confidence.let_it_happen_hindenburg\",\"predicate\":{\"$code\":\"return (Q['president'] == \\\"Hindenburg\\\");\"}}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"march_on_berlin.govt_menu\":{\"id\":\"march_on_berlin.govt_menu\",\"options\":[{\"id\":\"@march_on_berlin.fight\"},{\"id\":\"@march_on_berlin.new_elections\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"panzerkreuzer.vote_no_pass\":{\"id\":\"panzerkreuzer.vote_no_pass\",\"onArrival\":[{\"$code\":\"Q['panzerkreuzer_funded'] = 1;\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"Our coalition partners are shocked by our intransigence! Chancellor \",{\"type\":\"insert\",\"insert\":0},\" brings the matter to a Reichstag vote, which passes with all parties in favor except the SPD and KPD. The ship will be built.\"]},\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor'] || 0);\"}}]}},\"constitutional_reform.presidential_powers\":{\"id\":\"constitutional_reform.presidential_powers\",\"subtitle\":[\"The president can no longer dissolve the Reichstag at will, or call a \",{\"type\":\"emphasis-1\",\"content\":\"Reichsexekution\"},\" on state governments.\"],\"onArrival\":[{\"$code\":\"Q.reform_support = Q.spd_normalized + Q.ddp_normalized + Q.kpd_normalized;\\nif (Q.z_relation > 49 && (Q.president == \\\"Hindenburg\\\" || Q.president == \\\"Eckener\\\")) {\\n    Q.reform_support += Q.z_normalized;\\n} else if (Q.president == \\\"Braun\\\") {\\n    Q.reform_support += Q.z_normalized - 0.03;\\n}\"}],\"viewIf\":{\"$code\":\"return ((Q['presidential_powers'] || 0)===0);\"},\"options\":[{\"id\":\"@constitutional_reform.presidential_powers_2\",\"title\":\"Call a constitutional referendum to pass the reform!\"},{\"id\":\"@constitutional_reform.reforms_menu\",\"title\":\"See other reform options.\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"The wide-ranging presidential powers promised by the constitution are a potential gateway to authoritarianism. Thus, we can support reforms that limit the powers of the president, ending his power to unilaterally terminate an elected government and to remove state governments.\"},{\"type\":\"paragraph\",\"content\":[\"The KPD is in favor of this reform, having been victims of the \",{\"type\":\"emphasis-1\",\"content\":\"Reichsexekution\"},\" in the past (when KPD-supported state governments in Thuringia and Saxony were removed). The democrats of the DDP also support this. \",{\"type\":\"conditional\",\"content\":\"However, the opposition from conservatives is vehement, as they see a reduction in presidential powers as disrespectful to Hindenburg. \",\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"Thus, the Center Party has been influenced to oppose these reforms. \",\"predicate\":1},\" \",{\"type\":\"conditional\",\"content\":\"Despite this, the Center Party supports the proposed reform. \",\"predicate\":2},\" \",{\"type\":\"conditional\",\"content\":\"The Center Party supports this reform.\",\"predicate\":3}]}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['president'] == \\\"Hindenburg\\\");\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['z_relation'] || 0) <= 49) && (Q['president'] == \\\"Hindenburg\\\"));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['z_relation'] || 0) > 49) && (Q['president'] == \\\"Hindenburg\\\"));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['president'] == \\\"Braun\\\");\"}}]}},\"popular_front_dispute.interior\":{\"id\":\"popular_front_dispute.interior\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"presidential_election_1932.braun_campaign\":{\"id\":\"presidential_election_1932.braun_campaign\",\"options\":[{\"id\":\"@presidential_election_1932.convince_z\",\"title\":\"Convince the Center Party.\"},{\"id\":\"@presidential_election_1932.convince_kpd\",\"title\":\"Convince the Communists.\"},{\"id\":\"@presidential_election_1932.convince_liberals\",\"title\":\"Convince the remaining liberals, wherever they are.\"},{\"id\":\"@presidential_election_1932.final_election\",\"title\":\"The final vote...\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"prussian_coup.surrender\":{\"id\":\"prussian_coup.surrender\",\"title\":\"Give up on the Prussian government.\",\"onArrival\":[{\"$code\":\"Q['spd_prussia'] = 0;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 5;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 10;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) + 10;\\nQ['rb_militancy'] = ((Q['rb_militancy'] || 0) / 2);\\nQ['rb_strength'] = (Q['rb_strength'] || 0) - 1000;\"}],\"content\":{\"content\":\"A pall of hopelessness and despair descends over social democracy. We have failed. Many in the Reichsbanner simply quit, demoralized by their leaders' lack of a call to action.\",\"type\":\"paragraph\"}},\"prussian_coup\":{\"id\":\"prussian_coup\",\"type\":\"scene\",\"title\":\"Coup in Prussia\",\"subtitle\":\"The Chancellor attempts to overthrow the Prussian government.\",\"viewIf\":{\"$code\":\"return (((((((((Q['chancellor'] == \\\"Papen\\\") || (Q['chancellor'] == \\\"Schleicher\\\"))) && (Q['president'] == \\\"Hindenburg\\\")) && ((Q['year'] || 0) >= 1932)) && ((Q['month'] || 0) >= 8)) && ((Q['spd_in_government'] || 0) == 0)) && ((Q['spd_prussia'] || 0)===1)) && (!(((Q['presidential_powers'] || 0)) !== 0)));\"},\"onArrival\":[{\"$code\":\"Q['prussian_coup_seen'] = 1;\"}],\"newPage\":true,\"tags\":[\"event\"],\"maxVisits\":1,\"faceImage\":\"img/Reichswehr.jpg\",\"options\":[{\"id\":\"@prussian_coup.defend\"},{\"id\":\"@prussian_coup.surrender\"}],\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"Coup in Prussia\"},{\"type\":\"paragraph\",\"content\":[\"A crisis! Chancellor \",{\"type\":\"insert\",\"insert\":0},\" has ordered the dismissal of the Prussian government in a procedure known as the \",{\"type\":\"emphasis-1\",\"content\":\"Reichsexecution\"},\". His argument is that the Prussian state government is unable to maintain order due to the battles on the streets between the SA, Reichsbanner, and other paramilitaries. This is despite his own government legalizing them.\"]},{\"type\":\"paragraph\",\"content\":\"The legality of the action is questionable. Many of our members are ready to resist.\"}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor'] || 0);\"}}]},\"countVisitsMax\":1},\"panzerkreuzer_b.ministry\":{\"id\":\"panzerkreuzer_b.ministry\",\"onArrival\":[{\"$code\":\"Q['panzerkreuzer_b_funded'] = 0;\\n if (((Q['panzerkreuzer_funded'] || 0)===0) ) { Q['budget'] = (Q['budget'] || 0) + 1; }\"}],\"viewIf\":{\"$code\":\"return (Q['reichswehr_minister_party'] == \\\"SPD\\\");\"},\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"With our control of the Reichswehr Ministry, we have pressured the Navy to abandon its rearmament plans. The ship will not be built. \",{\"type\":\"conditional\",\"content\":\"We have saved some budget from not funding the two ships.\",\"predicate\":0}]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['panzerkreuzer_funded'] || 0) == 0);\"}}]}},\"panzerkreuzer_b\":{\"id\":\"panzerkreuzer_b\",\"type\":\"scene\",\"title\":\"Panzerkreuzer B\",\"subtitle\":\"A political question\",\"tags\":[\"event\"],\"onArrival\":[{\"$code\":\"Q['panzerkreuzer_b_seen'] = 1;\"}],\"newPage\":true,\"faceImage\":\"img/panzerkreuzer.jpg\",\"viewIf\":{\"$code\":\"return (((((Q['panzerkreuzer_b_seen'] || 0)===0) && ((Q['year'] || 0)===1931)) && ((Q['month'] || 0) >= 2)) && ((((Q['spd_in_government'] || 0)===1) || ((Q['spd_toleration'] || 0)===1))));\"},\"options\":[{\"id\":\"@panzerkreuzer_b.vote_yes\",\"title\":\"Vote yes, for constructing the battlecruiser.\"},{\"id\":\"@panzerkreuzer_b.vote_no\",\"title\":\"Vote no, against constructing the battlecruiser.\"},{\"id\":\"@panzerkreuzer_b.abstain\",\"title\":\"Abstain from the vote.\"},{\"id\":\"@panzerkreuzer_b.ministry\",\"title\":\"Use the Reichswehr Ministry to prevent the construction.\"}],\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"Panzerkreuzer B\"},{\"type\":\"paragraph\",\"content\":[\"The Navy is demanding the construction of another new battlecruiser. \",{\"type\":\"conditional\",\"content\":\"The previous battlecruiser had been funded, and has already been launched. Another ship would futher progress Germany's rearmament. \",\"predicate\":0},{\"type\":\"conditional\",\"content\":\"The previous battlecruiser requested by the Navy was not funded, thanks to us. The military remains bitter, but nevertheless they are still pursuing their rearmament plan, and must seek funding from the Reichstag. \",\"predicate\":1},\"\"]},{\"type\":\"paragraph\",\"content\":\"Much of our party is deeply opposed to rearmament, while the center and right parties are united in support. What will we do?\"}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['panzerkreuzer_funded'] || 0)) !== 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (!(((Q['panzerkreuzer_funded'] || 0)) !== 0));\"}}]}},\"unemployment_insurance_1.compromise\":{\"id\":\"unemployment_insurance_1.compromise\",\"unavailableSubtitle\":\"We do not have good enough relations with the right-wing parties.\",\"chooseIf\":{\"$code\":\"return ((Q['dvp_relation'] || 0) >= 35);\"},\"options\":[{\"id\":\"@unemployment_insurance_1.accept_compromise\",\"title\":\"Accept the compromise.\"},{\"id\":\"@unemployment_insurance_1.destroy\",\"title\":\"Reject the compromise and let this government fall.\"}],\"content\":{\"content\":\"Thanks to our good relations, the DVP have offered a compromise that raises some taxes on the wealthy, along with lesser welfare cuts. Our members have mixed opinions on accepting this compromise. Reformists and Centrists support maintaining our government to keep the fascists and communists out, while Labor generally opposes any cuts, and the Left is opposed to compromises with the bourgeoisie.\",\"type\":\"paragraph\"}},\"vote_of_no_confidence.support_kpd_2\":{\"id\":\"vote_of_no_confidence.support_kpd_2\",\"onArrival\":[{\"$code\":\"Q['communist_coalition'] = (Q['communist_coalition'] || 0) + 1;\\nQ['workers_kpd'] = (Q['workers_kpd'] || 0) + 3;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) + 5;\"}],\"goTo\":[{\"id\":\"vote_of_no_confidence.support_kpd_weimar\",\"predicate\":{\"$code\":\"return (((Q['in_weimar_coalition'] || 0)) !== 0);\"}},{\"id\":\"vote_of_no_confidence.support_kpd_grand\",\"predicate\":{\"$code\":\"return (((Q['in_grand_coalition'] || 0)) !== 0);\"}}],\"content\":{\"content\":\"The KPD is not interested in a \\\"toleration\\\" arrangement; they will only support us if they can participate in the government as part of a coalition. And, if this toleration agreement happens, the right-wing parties will not be inclined to support us.\",\"type\":\"paragraph\"}},\"confronting_nazis.anti\":{\"id\":\"confronting_nazis.anti\",\"goTo\":[{\"id\":\"confronting_nazis.if_end\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"campaigning.catholics\":{\"id\":\"campaigning.catholics\",\"subtitle\":\"-1 resources\",\"chooseIf\":{\"$code\":\"return ((Q['resources'] || 0) >= 1);\"},\"unavailableSubtitle\":\"Not enough resources.\",\"viewIf\":{\"$code\":\"return ((Q['peoples_party'] || 0) == 1);\"},\"onArrival\":[{\"$code\":\"Q['catholics_spd'] = (Q['catholics_spd'] || 0) + (6 * (1 - (Q['dissent'] || 0)));\\nQ['resources'] = (Q['resources'] || 0) - 1;\"}],\"content\":{\"content\":\"We have increased our campaigning among Catholics.\",\"type\":\"paragraph\"}},\"campaigning\":{\"id\":\"campaigning\",\"type\":\"scene\",\"title\":\"Campaigning\",\"newPage\":true,\"onArrival\":[{\"$code\":\"Q['month_actions'] = (Q['month_actions'] || 0) + 1;\"}],\"maxVisits\":36,\"isCard\":true,\"cardImage\":\"img/flags.jpg\",\"frequency\":100,\"tags\":[\"party_affairs\"],\"options\":[{\"id\":\"@campaigning.workers\",\"title\":\"The urban working class, our traditional support base.\"},{\"id\":\"@campaigning.new_middle\",\"title\":\"The \\\"new middle class\\\" of government employees and white-collar workers.\"},{\"id\":\"@campaigning.old_middle\",\"title\":\"The \\\"old middle class\\\" of small independent businessmen and artisans.\"},{\"id\":\"@campaigning.rural\",\"title\":\"Rural workers and small farmers, who have felt neglected by us in the past.\"},{\"id\":\"@campaigning.unemployed\",\"title\":\"The unemployed.\"},{\"id\":\"@campaigning.catholics\",\"title\":\"Catholics, who typically support the Center Party.\"},{\"id\":\"@root\",\"title\":\"We either don't want to or cannot campaign right now.\"},{\"id\":\"@easy_discard\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Campaigning\"},{\"type\":\"paragraph\",\"content\":\"Whether or not we are in an electoral campaign, the party is always trying to broaden its voter base. Who should we focus our campaign efforts on?\"}],\"countVisitsMax\":36},\"crisis_program.support_left_progress\":{\"id\":\"crisis_program.support_left_progress\",\"content\":[{\"type\":\"paragraph\",\"content\":\"We attempt to convince the party to support a program of mass nationalizations in response to the economic crisis. Leftists argue that this policy is in accordance with our long-standing socialist platform, while reformists and some trade unionists argue that the plan is unrealistic, and that we need to focus on more immediate improvements to workers' lives.\"},{\"type\":\"paragraph\",\"content\":\"We have not yet formally adopted the plan. More work needs to be done.\"}]},\"inter_party_relationships.kpd_2\":{\"id\":\"inter_party_relationships.kpd_2\",\"onArrival\":[{\"$code\":\"Q['kpd_relation'] = (Q['kpd_relation'] || 0) + (8 * (1 - (Q['dissent'] || 0)));\\n if (((Q['kpd_inter_party_seen'] || 0) <= 1) ) { Q['communist_coalition'] = (Q['communist_coalition'] || 0) + 1; } \\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 2;\\nQ['z_relation'] = (Q['z_relation'] || 0) - 3;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 3;\"}],\"content\":{\"content\":\"After the success of the coalition government with the KPD, they are much more amenable to us.\",\"type\":\"paragraph\"}},\"international_relations.reduce\":{\"id\":\"international_relations.reduce\",\"content\":{\"content\":\"We do not need the international contacts at the moment.\",\"type\":\"paragraph\"}},\"international_relations\":{\"id\":\"international_relations\",\"type\":\"scene\",\"title\":\"International Relations\",\"newPage\":true,\"isCard\":true,\"tags\":[\"party_affairs\"],\"viewIf\":{\"$code\":\"return ((Q['international_relations_timer'] || 0) <= 0);\"},\"onArrival\":[{\"$code\":\"Q['month_actions'] = (Q['month_actions'] || 0) + 1;\\nQ['international_relations_timer'] = (Q['international_relations_timer'] || 0) + 12;\"}],\"cardImage\":\"img/international.jpg\",\"maxVisits\":3,\"options\":[{\"id\":\"@international_relations.fr_uk\",\"title\":\"Build relationships with the French SFIO and British Labour Party to move their governments in Germany's favor.\"},{\"id\":\"@international_relations.austria\",\"title\":\"Learn organization and street fighting from the Austrian socialists.\"},{\"id\":\"@international_relations.scandi\",\"title\":\"Learn the path of economics and reform from the Scandinavian social democrats.\"},{\"id\":\"@international_relations.comintern\",\"title\":\"Forget the second international - embed a spy in the Comintern's conference.\"},{\"id\":\"@international_relations.america\",\"title\":\"Contact the Socialist party of America.\"},{\"id\":\"@return\",\"title\":\"We do not need international contacts at the moment.\"},{\"id\":\"@easy_discard\"},{\"id\":\"@cancel_advisor_action\"}],\"content\":{\"content\":\"At the Labor and Socialist International, we can forge contacts with our fraternal socialist parties in Europe and across the world.\",\"type\":\"paragraph\"},\"countVisitsMax\":3},\"media.radio_3\":{\"id\":\"media.radio_3\",\"title\":\"We must keep on building up our radio network.\",\"subtitle\":\"It is now financially self-sufficient, and does not require any more resources.\",\"viewIf\":{\"$code\":\"return ((((Q['radio'] || 0) > 3) && ((Q['radio'] || 0) <= 5)) && ((Q['year'] || 0) <= 1931));\"},\"onArrival\":[{\"$code\":\"Q['radio'] = (Q['radio'] || 0) + 1;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\nQ['rural_spd'] = (Q['rural_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (2 * (1 - (Q['dissent'] || 0)));\\nQ['socialism'] = (Q['socialism'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\n if (((Q['pacifism'] || 0) > 2) ) { Q['nationalism'] = (Q['nationalism'] || 0) - ((3 * (1 - (Q['dissent'] || 0))) * (Q['pacifism-2'] || 0)); } \\n if (((Q['democratization'] || 0) > 2) ) { Q['pro_republic'] = (Q['pro_republic'] || 0) + ((3 * (1 - (Q['dissent'] || 0))) * (Q['democratization-2'] || 0)); }\"}],\"content\":{\"content\":\"Our radio network has become a successful tool for spreading our message.\",\"type\":\"paragraph\"}},\"party_disunity.concessions_neorevisionists\":{\"id\":\"party_disunity.concessions_neorevisionists\",\"title\":\"Give concessions to the neorevisionists.\",\"viewIf\":{\"$code\":\"return (((Q['neorevisionist_dissent'] || 0) > 30) && ((Q['neorevisionism'] || 0)===1));\"},\"onArrival\":[{\"$code\":\"Q['neorevisionist_dissent'] = (Q['neorevisionist_dissent'] || 0) - 7;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) + 5;\"}],\"content\":{\"content\":\"Giving the neorevisionists more influence will cause increased dissent from the centrists.\",\"type\":\"paragraph\"}},\"party_organizations.nothing\":{\"id\":\"party_organizations.nothing\",\"options\":[{\"id\":\"@return\",\"title\":\"Continue...\"}],\"content\":{\"content\":\"We do not fund any party organizations.\",\"type\":\"paragraph\"}},\"party_organizations\":{\"id\":\"party_organizations\",\"type\":\"scene\",\"title\":\"Party Organizations\",\"newPage\":true,\"isCard\":true,\"tags\":[\"party_affairs\"],\"viewIf\":{\"$code\":\"return ((Q['party_organizations_timer'] || 0) <= 0);\"},\"onArrival\":[{\"$code\":\"Q['month_actions'] = (Q['month_actions'] || 0) + 1;\\nQ['party_organizations_timer'] = 6;\"}],\"cardImage\":\"img/Mann_der_Arbeit.jpg\",\"maxVisits\":5,\"options\":[{\"id\":\"@party_organizations.newspapers\",\"title\":\"Fund more newspapers and journalists.\"},{\"id\":\"@party_organizations.welfare\",\"title\":\"Fund more mutual aid and welfare programs.\"},{\"id\":\"@party_organizations.culture\",\"title\":\"Fund sports leagues, educational, and cultural programs.\"},{\"id\":\"@party_organizations.rb\",\"title\":\"Fund the Reichsbanner, our self-defense organization.\"},{\"id\":\"@party_organizations.youth\",\"title\":\"We have the reputation of being a party for old men. Support the youth organizations.\"},{\"id\":\"@party_organizations.nothing\",\"title\":\"Do not increase funding for any program.\"},{\"id\":\"@easy_discard\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Party Organizations\"},{\"type\":\"paragraph\",\"content\":\"In addition to being a political party, the SPD is a social world onto itself, with a vast array of associated organizations which serve the social needs of their members from cradle to grave.\"}],\"countVisitsMax\":5},\"peoples_party.campaign_rural\":{\"id\":\"peoples_party.campaign_rural\",\"title\":\"Campaign in rural areas.\",\"chooseIf\":{\"$code\":\"return ((Q['rural_policy'] || 0) > 0);\"},\"unavailableSubtitle\":\"We have not enacted any rural policies yet.\",\"onArrival\":[{\"$code\":\"Q['rural_spd'] = (Q['rural_spd'] || 0) + (7 * (1 - (Q['dissent'] || 0)));\"}],\"content\":{\"content\":\"As a people's party, we represent farmers and rural workers as well, and they are becoming receptive to our messages.\",\"type\":\"paragraph\"}},\"peoples_party_campaigning.campaign_catholics\":{\"id\":\"peoples_party_campaigning.campaign_catholics\",\"title\":\"Campaign among political Catholics.\",\"onArrival\":[{\"$code\":\"Q['catholics_spd'] = (Q['catholics_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\"}],\"content\":{\"content\":\"Catholics have historically been tied to the Center Party, but there is no reason why our party cannot appeal to them. The Prussian Concordat in particular is a sign of our friendship with Catholicism.\",\"type\":\"paragraph\"}},\"peoples_party_campaigning\":{\"id\":\"peoples_party_campaigning\",\"type\":\"scene\",\"title\":\"Campaigning (People's Party)\",\"options\":[{\"id\":\"@peoples_party_campaigning.campaign_workers\"},{\"id\":\"@peoples_party_campaigning.campaign_middle\"},{\"id\":\"@peoples_party_campaigning.campaign_rural\"},{\"id\":\"@peoples_party_campaigning.campaign_unemployed\"},{\"id\":\"@peoples_party_campaigning.campaign_women\"},{\"id\":\"@peoples_party_campaigning.campaign_catholics\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"rally.rb_protect_win\":{\"id\":\"rally.rb_protect_win\",\"goTo\":[{\"id\":\"rally.main_rally\"}],\"content\":{\"content\":\"The Reichsbanner has successfully protected our rally against the SA! Our meeting can go ahead as usual.\",\"type\":\"paragraph\"}},\"shuffle_leadership.remove_breitscheid\":{\"id\":\"shuffle_leadership.remove_breitscheid\",\"title\":\"Remove Breitscheid\",\"viewIf\":{\"$code\":\"return ((Q['breitscheid_advisor'] || 0)===1);\"},\"tags\":[\"remove_advisor\"],\"onArrival\":[{\"$code\":\"Q['breitscheid_advisor'] = 0;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) + 5;\\nQ['n_advisors'] = (Q['n_advisors'] || 0) - 1;\"}],\"goTo\":[{\"id\":\"shuffle_leadership.rm_main\"}],\"content\":{\"content\":\"Breitscheid has been removed as an advisor. The Centrist faction disapproves.\",\"type\":\"paragraph\"}},\"streetfighting.truce_rfb\":{\"id\":\"streetfighting.truce_rfb\",\"chooseIf\":{\"$code\":\"return ((Q['kpd_relation'] || 0) >= 45);\"},\"viewIf\":{\"$code\":\"return ((Q['kpd_truce'] || 0) == 0);\"},\"unavailableSubtitle\":\"The KPD is not interested.\",\"onArrival\":[{\"$code\":\"Q['kpd_truce'] = 1;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) + 5;\\nQ['rfb_strength'] = (Q['rfb_strength'] || 0) + 50;\\nQ['rb_strength'] = (Q['rb_strength'] || 0) + 50;\\nQ['sa_strength'] = (Q['sa_strength'] || 0) + 50;\"}],\"content\":{\"content\":\"We have made at least a temporary truce with the KPD, so that our respective paramilitaries will stop fighting.\",\"type\":\"paragraph\"}},\"streetfighting\":{\"id\":\"streetfighting\",\"type\":\"scene\",\"title\":\"Streetfighting\",\"newPage\":true,\"isCard\":true,\"onArrival\":[{\"$code\":\"Q['streetfighting_timer'] = 6;\\nQ['month_actions'] = (Q['month_actions'] || 0) + 1;\\n if (((Q['rb_militancy'] || 0) > 0.1) ) { \\nQ['rb_militarization_cost'] = 2;;\\n } else { Q['rb_militarization_cost'] = 1; } \\n if (((Q['rb_militancy'] || 0) > 0.25) ) { Q['rb_militarization_cost'] = 3; } \\nQ['strife'] = (Q['strife'] || 0) + 1;\"}],\"viewIf\":{\"$code\":\"return ((((Q['year'] || 0) >= 1930) && ((Q['sa_strength'] || 0) >= 150)) && ((Q['streetfighting_timer'] || 0) == 0));\"},\"cardImage\":\"img/blutmai_2.jpg\",\"tags\":[\"party_affairs\",\"antifascism\"],\"options\":[{\"id\":\"@streetfighting.arm_rb\",\"title\":\"Increase training and armaments for the Reichsbanner.\"},{\"id\":\"@streetfighting.if_training\",\"title\":\"Train union members to fight as part of the Iron Front.\"},{\"id\":\"@streetfighting.prussian_police_training\",\"title\":\"Use the Prussian police to help train the Reichsbanner.\"},{\"id\":\"@streetfighting.peace\",\"title\":\"Try to avoid all militant confrontations, as much as possible.\"},{\"id\":\"@streetfighting.truce_rfb\",\"title\":\"Try to make peace with the RFB.\"},{\"id\":\"@easy_discard\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Streetfighting\"},{\"type\":\"paragraph\",\"content\":\"Battles rage on the streets between the Nazi SA, nationalist Stahlhelm, communist Rotfrontkämpferbund (RFB), and our own Reichsbanner. In some parts of the country, conditions are nearing civil war levels, as dozens of people are killed each month.\"},{\"type\":\"paragraph\",\"content\":\"We must do something to protect the workers against these predations.\"}]},\"game_over.civil_war_lost\":{\"id\":\"game_over.civil_war_lost\",\"title\":\"We lost the civil war.\",\"viewIf\":{\"$code\":\"return ((Q['total_defeat'] || 0) == 1);\"},\"tags\":[\"endings\"],\"goTo\":[{\"id\":\"game_over.eg_menu\"}],\"content\":{\"content\":\"We have lost the civil war. At least it was a quick coup, and ended before Germany could be plunged into total war.\",\"type\":\"paragraph\"}},\"library.public_opinion\":{\"id\":\"library.public_opinion\",\"onArrival\":[{\"$code\":\"Q.pro_republic = Math.round(Q.pro_republic);\\nQ.nationalism = Math.round(Q.nationalism);\\nQ.socialism = Math.round(Q.socialism);\"}],\"viewIf\":{\"$code\":\"return (((!(((Q['historical_mode'] || 0)) !== 0))) || (((Q['game_over'] || 0)) !== 0));\"},\"goTo\":[{\"id\":\"election_algorithm\"}],\"setJump\":\"library.election_projections\",\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"Public Opinion\"},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Support for the Republic: \",{\"type\":\"insert\",\"insert\":0},\"%\"]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['pro_republic'] || 0);\"}}]}},\"root.1928_main\":{\"id\":\"root.1928_main\",\"audio\":\"shuffle music/1928_1930/FruhlingsliedMendelssohn.mp3 music/1928_1930/AUF_HOHEN_BERGEN_noise_reduced.mp3 music/1928_1930/MarekWeber.mp3 music/1928_1930/BAUERNKAPELLE.mp3 music/1928_1933/DERLINDENBAUM_normalized.mp3 music/1928_1933/ZurSonne_zurFreiheit.mp3 music/1928_1933/arbeiter_marseille.mp3 music/1928_1933/Wann_wir_schreiten_Seit_an_Seit.mp3 music/1930_1933/Internationale-de_normalized.ogg music/1928_1930/LiedDerPompadour.mp3\",\"newPage\":true,\"goTo\":[{\"id\":\"main\",\"predicate\":{\"$code\":\"return ((Q['difficulty'] || 0) >= 0);\"}},{\"id\":\"main.main_easy\",\"predicate\":{\"$code\":\"return ((Q['difficulty'] || 0) < 0);\"}}],\"content\":[{\"type\":\"heading\",\"content\":\"1928\"},{\"type\":\"paragraph\",\"content\":\"It is a bright time for German democracy. After a period of struggle, inflation is finally under control, and the economy is expanding steadily. In foreign policy, we have reached agreements with the Western powers and the Soviet Union that might make genuine peace a reality.\"},{\"type\":\"paragraph\",\"content\":\"Now, the task of Social Democracy is to prepare for the next election. The bourgeois-right government of Wilhelm Marx is unpopular, and we stand to gain. Perhaps the next government will have a socialist majority.\"}]},\"root\":{\"id\":\"root\",\"type\":\"scene\",\"title\":\"Root Scene\",\"newPage\":true,\"goTo\":[{\"id\":\"post_event\",\"predicate\":{\"$code\":\"return ((Q['started'] || 0)===1);\"}},{\"id\":\"root.start_menu\",\"predicate\":{\"$code\":\"return ((Q['started'] || 0)===0);\"}}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"stampfer.support_neorev\":{\"id\":\"stampfer.support_neorev\",\"viewIf\":{\"$code\":\"return (((Q['neorevisionism'] || 0)) !== 0);\"},\"onArrival\":[{\"$code\":\"Q['neorevisionist_dissent'] = (Q['neorevisionist_dissent'] || 0) - 8;\\nQ['neorevisionist_strength'] = (Q['neorevisionist_strength'] || 0) + 8;\"}],\"content\":{\"content\":\"Vorwärts prints editorials in support of neorevisionist ideas.\",\"type\":\"paragraph\"}},\"dealing_with_toleration.new_grand_coalition\":{\"id\":\"dealing_with_toleration.new_grand_coalition\",\"title\":\"Can we join the government in a new grand coalition?\",\"viewIf\":{\"$code\":\"return ((Q['neo_weimar_coalition'] || 0) >= 50);\"},\"chooseIf\":{\"$code\":\"return ((((Q['z_relation'] || 0) >= 50) && ((Q['dvp_relation'] || 0) >= 30)) && ((Q['resources'] || 0) >= 2));\"},\"subtitle\":\"We will need 2 resources to smooth out the process of forming the coalition.\",\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":\"We do not have adequate relations with the Center Party. \",\"predicate\":0},{\"type\":\"conditional\",\"content\":\"We do not have adequate relations with the DVP. \",\"predicate\":1},\" \",{\"type\":\"conditional\",\"content\":\"We do not have enough resources.\",\"predicate\":2}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['z_relation'] || 0) < 50);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['dvp_relation'] || 0) < 30);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['resources'] || 0) < 2);\"}}]},\"onArrival\":[{\"$code\":\"Q['resources'] = (Q['resources'] || 0) - 2;\\nQ['spd_in_government'] = 1;\\nQ['in_grand_coalition'] = 1;\\nQ['spd_toleration'] = 0;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 6;\\nQ['reformist_strength'] = (Q['reformist_strength'] || 0) + 5;\\n if (((Q['leverage'] || 0) >= 20) ) { Q['leverage'] = 20; }\"}],\"achievement\":\"constitutional_coalition\",\"options\":[{\"id\":\"@election_1928.ministries\",\"title\":\"Now, we must select our ministries.\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"Our negotiations have succeeded, and the Center Party and DVP have agreed to form a new coalition government with us!\"},{\"type\":\"paragraph\",\"content\":[\"We are now part of a \\\"constitutional coalition\\\" government that includes all parties except the extremists of the KPD, DNVP, and NSDAP. \",{\"type\":\"insert\",\"insert\":0},\" will remain as chancellor. Leftists in our party are skeptical of this arrangement.\"]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor'] || 0);\"}}]}},\"deport_hitler.no_deport\":{\"id\":\"deport_hitler.no_deport\",\"goTo\":[{\"id\":\"root\"}],\"content\":{\"content\":\"We will not be deporting Hitler.\",\"type\":\"paragraph\"}},\"deport_hitler\":{\"id\":\"deport_hitler\",\"type\":\"scene\",\"title\":\"We can deport Hitler.\",\"subtitle\":\"He is a foreign citizen and a criminal, after all.\",\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":\"Unfortunately, the reactionary judiciary will not cooperate. \",\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"Hitler has already been made a citizen of Germany, in the run-up to the presidential election. \",\"predicate\":1},\" \",{\"type\":\"conditional\",\"content\":\"We cannot do this without the cooperation of the Prussian police, who are not currently in our control.\",\"predicate\":2}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['judicial_reform'] || 0) < 2);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['presidential_election_seen'] || 0) == 1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (!(((Q['spd_prussia'] || 0)) !== 0));\"}}]},\"viewIf\":{\"$code\":\"return ((((((Q['nazi_urgency'] || 0) >= 3) && ((Q['hitler_deported'] || 0)===0)) && (Q['chancellor'] != \\\"Papen\\\")) && (Q['chancellor'] != \\\"Schleicher\\\")) && ((Q['investigate_far_right'] || 0) >= 2));\"},\"chooseIf\":{\"$code\":\"return ((((Q['judicial_reform'] || 0) >= 2) && ((Q['presidential_election_seen'] || 0) == 0)) && ((Q['spd_prussia'] || 0) == 1));\"},\"options\":[{\"id\":\"@deport_hitler.deport\",\"title\":\"Deport him!\"},{\"id\":\"@deport_hitler.no_deport\",\"title\":\"No, we must not.\"}],\"content\":{\"content\":\"Is it really that simple? Won't his supporters react violently to this suggestion? And even if the deportation does succeed, won't he just re-enter the country, or perhaps organize from Austria? And, some people consider this to be an anti-democratic abuse of power, using the law in order to target a political opponent.\",\"type\":\"paragraph\"}},\"economic_policy.nationalize_no_deficit\":{\"id\":\"economic_policy.nationalize_no_deficit\",\"onArrival\":[{\"$code\":\"Q['nationalization_progress'] = (Q['nationalization_progress'] || 0) + 1;\\nQ['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) + 2;\\n if (((Q['unemployed'] || 0) >= 6) ) { Q['unemployed'] = (Q['unemployed'] || 0) - 3.5; } \\n if (((Q['works_councils'] || 0) >= 3) ) { Q['unemployed'] = (Q['unemployed'] || 0) - 1.2; } \\nQ['workers'] = (Q['workers'] || 0) + 2.5;\\nQ['budget'] = (Q['budget'] || 0) - (Q['nationalize_budget'] || 0);\\nQ['works_program'] = (Q['works_program'] || 0) + 1;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (8 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 4;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) - 5;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) - 2;\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) - 3;\\nQ['economy_goal_completed'] = (Q['economy_goal_completed'] || 0) + 1;\\nQ['inflation'] = (Q['inflation'] || 0) + 2;\"}],\"achievement\":\"wirtschaftspolitik\",\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"We have begun purchasing idling enterprises from the capitalists\",{\"type\":\"conditional\",\"content\":\", and running them in coordination with empowered works councils \",\"predicate\":1},\". By keeping production going, we can stave off the rising unemployment. \"],\"predicate\":0},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"The Left argues that this should only be a first step in the socialist transformation of the economy. Eventually, much of the economy must be brought under popular control. \",\"predicate\":2},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":\"We purchase additional underutilized enterprises and run them in a coordinated socialist fashion with the works councils, hiring formerly laid off workers. A significant portion of the economy is now under public control.\",\"predicate\":3}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['nationalization_progress'] || 0) == 1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['works_councils'] || 0) >= 1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['nationalization_progress'] || 0) == 1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['nationalization_progress'] || 0) > 1);\"}}]}},\"domestic_enemies.ban_rfb\":{\"id\":\"domestic_enemies.ban_rfb\",\"viewIf\":{\"$code\":\"return (((Q['communist_coalition'] || 0) < 3) && ((Q['rfb_banned'] || 0)===0));\"},\"onArrival\":[{\"$code\":\"Q['kpd_relation'] = (Q['kpd_relation'] || 0) - 15;\\nQ['rfb_strength'] = (Q['rfb_strength'] || 0) - 50;\\nQ['rfb_banned'] = 1;\\nQ['communist_coalition'] = (Q['communist_coalition'] || 0) - 1;\\nQ['z_relation'] = (Q['z_relation'] || 0) + 5;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) + 5;\\nQ['prussian_police_loyalty'] = (Q['prussian_police_loyalty'] || 0) + 0.1;\\nQ['interior_police_loyalty'] = (Q['interior_police_loyalty'] || 0) + 0.1;\\nQ['kpd_coalition_dissent'] = (Q['kpd_coalition_dissent'] || 0) + 2;\"}],\"content\":{\"content\":\"The ban is enthusiastically carried out by the police, perhaps too enthusiastically. The Communists take this as one more reason why the Socialists are traitors to the left. However, the moderate and center-right parties approve, as do the police.\",\"type\":\"paragraph\"}},\"foreign_policy.soviet_economic_aid_no\":{\"id\":\"foreign_policy.soviet_economic_aid_no\",\"content\":{\"content\":\"The Soviets are slightly upset, but they seemed to expect this answer.\",\"type\":\"paragraph\"}},\"fiscal_policy.tariffs\":{\"id\":\"fiscal_policy.tariffs\",\"title\":\"Change tariffs instead.\",\"options\":[{\"id\":\"@fiscal_policy.raise_tariffs\"},{\"id\":\"@fiscal_policy.lower_tariffs\"},{\"id\":\"@fiscal_policy.fiscal_menu\",\"title\":\"Change domestic taxes instead of tariffs.\"},{\"id\":\"@root\",\"title\":\"Do not change tariffs or taxes.\"},{\"id\":\"@easy_discard\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"Tariffs, or taxes on international imports, are another way to finance our government.\"},{\"type\":\"paragraph\",\"content\":\"Historically, socialists have been in favor of free trade and a low-tariff regime. Workers in export-oriented industries benefit from free trade, and they also benefit from lower prices for imported necessities. Do the present economic circumstances change these calculations?\"},{\"type\":\"paragraph\",\"content\":[\"Current tariff level: \",{\"type\":\"insert\",\"insert\":0}]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['tariffs'] || 0);\"},\"qdisplay\":\"taxation\"}]}},\"labor_rights.increase_employers\":{\"id\":\"labor_rights.increase_employers\",\"subtitle\":{\"content\":[\"Employers are strongly against this. \",{\"type\":\"conditional\",\"content\":\"The DVP will likely break the coalition.\",\"predicate\":0}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['in_grand_coalition'] || 0)) !== 0);\"}}]},\"onArrival\":[{\"$code\":\"Q['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) + 2;\\n if ((((Q['in_grand_coalition'] || 0)) !== 0) ) { Q['coalition_dissent'] = 2; } \\nQ['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1;\\nQ['welfare'] = (Q['welfare'] || 0) + 1;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (6 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (6 * (1 - (Q['dissent'] || 0)));\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) - (6 * (1 - (Q['dissent'] || 0)));\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) - (2 * (1 - (Q['dissent'] || 0)));\\nQ['unemployment_insurance_threshold'] = (Q['unemployed'] || 0);\\nQ['unemployment_insurance_timer'] = 10;\"}],\"content\":{\"content\":\"We have increased employer contributions to the unemployment insurance fund, allowing the program to continue without hurting workers and the unemployed. Perhaps understandably, the capitalists and their political parties are furious, while our base in the unions and among the unemployed are pleased.\",\"type\":\"paragraph\"}},\"police.investigate_far_right_failure\":{\"id\":\"police.investigate_far_right_failure\",\"content\":{\"content\":\"Unfortunately, our investigations have failed to turn up anything. Rumors are that the targets of our investigation were tipped off by infiltrators within the police.\",\"type\":\"paragraph\"}},\"police\":{\"id\":\"police\",\"type\":\"scene\",\"title\":\"Internal Security\",\"newPage\":true,\"isCard\":true,\"tags\":[\"govt_affairs\"],\"onArrival\":[{\"$code\":\"Q['police_timer'] = (Q['police_timer'] || 0) + 6;\\nQ['month_actions'] = (Q['month_actions'] || 0) + 1;\"}],\"viewIf\":{\"$code\":\"return ((((Q['spd_in_government'] || 0)===1) && (Q['interior_minister_party'] == \\\"SPD\\\")) && ((Q['police_timer'] || 0) <= 0));\"},\"cardImage\":\"img/portraits/SeveringCarl.jpg\",\"options\":[{\"id\":\"@police.loyalty\",\"title\":\"Improve the loyalty of the Interior Ministry forces.\"},{\"id\":\"@police.investigate_corruption\",\"title\":\"Investigate corruption by big businesses.\"},{\"id\":\"@police.investigate_far_right\",\"title\":\"Investigate illegal activity among the far right.\"},{\"id\":\"@domestic_enemies\",\"title\":\"Investigate or ban our domestic enemies.\"},{\"id\":\"@deport_hitler\"},{\"id\":\"@root\",\"title\":\"Take no action for now.\"},{\"id\":\"@easy_discard\"},{\"id\":\"@cancel_advisor_action\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Internal Security\"},{\"type\":\"paragraph\",\"content\":\"The Interior Ministry controls internal security throughout the German Republic. While most police work is delegated to the states, the national security agency can perform special investigations.\"},{\"type\":\"paragraph\",\"content\":\"As with the state police units and the Reichswehr, the internal police tends to be reactionary, and has serious issues with loyalty to the elected government of the Republic.\"}]},\"prussian_affairs.unban_sh\":{\"id\":\"prussian_affairs.unban_sh\",\"viewIf\":{\"$code\":\"return ((Q['sh_banned'] || 0)===1);\"},\"onArrival\":[{\"$code\":\"Q['sh_banned'] = 0;\\nQ['sh_strength'] = (Q['sh_strength'] || 0) + 100;\"}],\"content\":{\"content\":\"The Stahlhelm is no longer banned.\",\"type\":\"paragraph\"}},\"blutmai.join\":{\"id\":\"blutmai.join\",\"chooseIf\":{\"$code\":\"return ((Q['kpd_relation'] || 0) >= 45);\"},\"unavailableSubtitle\":\"The Communists do not trust us enough.\",\"onArrival\":[{\"$code\":\"Q['kpd_relation'] = (Q['kpd_relation'] || 0) + 15;\\nQ['workers_kpd'] = (Q['workers_kpd'] || 0) + 5;\\nQ['unemployed_kpd'] = (Q['unemployed_kpd'] || 0) + 5;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + 5;\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + 5;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) - 5;\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) - 5;\\nQ['z_relation'] = (Q['z_relation'] || 0) - 10;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 10;\\nQ['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 2;\\nQ['communist_coalition'] = (Q['communist_coalition'] || 0) + 2;\\nQ['rfb_strength'] = (Q['rfb_strength'] || 0) + 100;\\nQ['rfb_militancy'] = (Q['rfb_militancy'] || 0) + 0.1;\\nQ['sa_strength'] = (Q['sa_strength'] || 0) + 50;\\nQ['sh_strength'] = (Q['sh_strength'] || 0) + 50;\"}],\"achievement\":\"die_rote_fahne\",\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"It is difficult to persuade the Communists to let us march with them, given the histories of their party and ours. However, they eventually relent. The display of proletarian unity inspires the workers and terrifies the bourgeoisie and middle class. \",{\"type\":\"conditional\",\"content\":\"Our coalition partners in the government are outraged at our display with the communists, and are threatening to break up the government. \",\"predicate\":0},\" The far-right paramilitaries increase their recruitment to counter us.\"]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['in_grand_coalition'] || 0)) !== 0);\"}}]}},\"blutmai\":{\"id\":\"blutmai\",\"type\":\"scene\",\"title\":\"May Day, 1929\",\"newPage\":true,\"subtitle\":\"A Communist demonstration\",\"tags\":[\"event\"],\"viewIf\":{\"$code\":\"return (((Q['year'] || 0)===1929) && ((Q['month'] || 0)===5));\"},\"maxVisits\":1,\"faceImage\":\"img/redfront.jpg\",\"options\":[{\"id\":\"@blutmai.ban\",\"title\":\"Ban the demonstrations.\"},{\"id\":\"@blutmai.allow_police\",\"title\":\"Allow the demonstrations to proceed, but maintain a heavy police presence.\"},{\"id\":\"@blutmai.allow\",\"title\":\"Allow the demonstrations to proceed.\"},{\"id\":\"@blutmai.join\",\"title\":\"Join in the demonstrations ourselves.\"}],\"content\":[{\"type\":\"heading\",\"content\":\"May Day, 1929\"},{\"type\":\"paragraph\",\"content\":\"Tensions run high in Berlin. The Communists are planning a demonstration to commemorate the 10th anniversary of the Spartacist Uprising. No one has forgotten that it was our party members who ordered the uprising's suppression, and the Communists still blame us for the deaths of Rosa Luxemburg and Karl Liebknecht.\"},{\"type\":\"paragraph\",\"content\":\"Many non-communists are afraid of the possibility of another violent uprising, and our allies in the Prussian coalition are asking the Prussian Interior Ministry to ban the demonstrations.\"}],\"countVisitsMax\":1},\"death_of_muller.not_pm\":{\"id\":\"death_of_muller.not_pm\",\"content\":{\"content\":\"Herman Müller, one of the SPD's long-time leaders, has died. He will be greatly missed.\",\"type\":\"paragraph\"}},\"death_of_muller\":{\"id\":\"death_of_muller\",\"type\":\"scene\",\"title\":\"The Death of Hermann Müller\",\"viewIf\":{\"$code\":\"return (((Q['year'] || 0)===1931) && ((Q['month'] || 0) >= 3));\"},\"frequency\":1000,\"maxVisits\":1,\"tags\":[\"event\"],\"goTo\":[{\"id\":\"death_of_muller.pm\",\"predicate\":{\"$code\":\"return (Q['chancellor'] == \\\"Müller\\\");\"}},{\"id\":\"death_of_muller.not_pm\",\"predicate\":{\"$code\":\"return (Q['chancellor'] != \\\"Müller\\\");\"}}],\"onArrival\":[{\"$code\":\"Q['muller_dead'] = 1;\\n if (((Q['muller_advisor'] || 0) == 1) ) { Q['n_advisors'] = (Q['n_advisors'] || 0) - 1; } \\nQ['muller_advisor'] = 0;\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"},\"countVisitsMax\":1},\"civil_war.war_outcome\":{\"id\":\"civil_war.war_outcome\",\"viewIf\":{\"$code\":\"return ((Q['war_choices'] || 0) >= 2);\"},\"goTo\":[{\"id\":\"civil_war.defeat\",\"predicate\":{\"$code\":\"return ((Q['total_defeat'] || 0)===1);\"}},{\"id\":\"civil_war.long_war\",\"predicate\":{\"$code\":\"return ((Q['long_war'] || 0)===1);\"}},{\"id\":\"civil_war.republic_victory\",\"predicate\":{\"$code\":\"return ((Q['republic_victory'] || 0)===1);\"}}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"election_1928.popular_front_resources\":{\"id\":\"election_1928.popular_front_resources\",\"title\":\"Use our resources to smooth things over.\",\"unavailableSubtitle\":\"Required: 4 resources\",\"subtitle\":\"-4 resources\",\"chooseIf\":{\"$code\":\"return ((Q['resources'] || 0) >= 4);\"},\"onArrival\":[{\"$code\":\"Q['resources'] = (Q['resources'] || 0) - 4;\"}],\"goTo\":[{\"id\":\"election_1928.popular_front_success\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"kpd_policy.finance\":{\"id\":\"kpd_policy.finance\",\"title\":\"Finance Ministry\",\"subtitle\":\"The Finance Ministry is increasing taxes on the rich.\",\"viewIf\":{\"$code\":\"return (Q['finance_minister_party'] == \\\"KPD\\\");\"},\"options\":[{\"id\":\"@kpd_policy.finance_support\",\"title\":\"Yes, we support increasing taxes on the rich.\"},{\"id\":\"@kpd_policy.finance_oppose\",\"title\":\"No, now is not the right time.\"}],\"content\":{\"content\":\"The KPD-controlled Finance Ministry\",\"type\":\"paragraph\"}},\"kpd_vote_of_no_confidence.let_it_happen_braun\":{\"id\":\"kpd_vote_of_no_confidence.let_it_happen_braun\",\"onArrival\":[{\"$code\":\"if (((Q['next_election_time'] || 0) >= ((Q['time'] || 0) + 3)) ) { Q['next_election_time'] = ((Q['time'] || 0) + 3); } \\n if (((Q['next_election_time'] || 0) >= ((Q['time'] || 0) + 3)) ) { Q['next_election_month'] = ((Q['month'] || 0) + 3); } \\n if (((Q['next_election_time'] || 0) >= ((Q['time'] || 0) + 3)) ) { Q['next_election_year'] = (Q['year'] || 0); } \\n if (((Q['next_election_month'] || 0) > 12) ) { Q['next_election_year'] = (Q['next_election_year'] || 0) + 1; } \\n if (((Q['next_election_month'] || 0) > 12) ) { Q['next_election_month'] = (Q['next_election_month'] || 0) - 12; } \\nQ['spd_in_government'] = 0;\\nQ['in_popular_front'] = 0;\\nQ['in_left_front'] = 0;\\nQ['foreign_minister_party'] = \\\"I\\\";\\nQ['interior_minister_party'] = \\\"I\\\";\\nQ['justice_minister_party'] = \\\"I\\\";\\nQ['labor_minister_party'] = \\\"I\\\";\\nQ['reichswehr_minister_party'] = \\\"I\\\";\\nQ['economic_minister_party'] = \\\"I\\\";\\nQ['finance_minister_party'] = \\\"I\\\";\\nQ['agriculture_minister_party'] = \\\"I\\\";\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[\"The vote succeeds, and our coalition has collapsed. Chancellor \",{\"type\":\"insert\",\"insert\":0},\" will lead a caretaker government until the next election.\"]},{\"type\":\"paragraph\",\"content\":[\"New elections have been set for \",{\"type\":\"insert\",\"insert\":1},\" \",{\"type\":\"insert\",\"insert\":2},\".\"]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_month'] || 0);\"},\"qdisplay\":\"month\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_year'] || 0);\"}}]}},\"march_on_berlin.fight\":{\"id\":\"march_on_berlin.fight\",\"title\":\"Deploy the Reichsbanner and call a general strike to resist the fascists!\",\"onArrival\":[{\"$code\":\"Q['defense_strength'] = (((Q['rb_strength'] || 0) * (Q['rb_militancy'] || 0)) * (1 - ((Q['dissent'] || 0) / 2)));\\n if ((((Q['spd_prussia'] || 0)) !== 0) ) { Q['defense_strength'] = (Q['defense_strength'] || 0) + (((Q['prussian_police_strength'] || 0) * (Q['prussian_police_militancy'] || 0)) * (Q['prussian_police_loyalty'] || 0)); } \\nQ['enemy_strength'] = (((Q['sa_strength'] || 0) * (Q['sa_militancy'] || 0)) + ((Q['sh_strength'] || 0) * (Q['sh_militancy'] || 0)));\\nQ['defense_strength'] = (Q['defense_strength'] || 0) + (((Q['workers_spd_normalized'] || 0) * (2 - (Q['dissent'] || 0))) * (2 - ((Q['unemployed'] || 0) / 100)));\\n if (((Q['president'] == \\\"Braun\\\") && (((Q['spd_in_government'] || 0)) !== 0)) ) { Q['defense_strength'] = (Q['defense_strength'] || 0) + (((Q['reichswehr_strength'] || 0) * (Q['reichswehr_loyalty'] || 0)) * (Q['reichswehr_militancy'] || 0)); }\"}],\"goTo\":[{\"id\":\"march_on_berlin.fight_2_win\",\"predicate\":{\"$code\":\"return ((Q['defense_strength'] || 0) >= (Q['enemy_strength'] || 0));\"}},{\"id\":\"march_on_berlin.fight_2_pre_civil_war\",\"predicate\":{\"$code\":\"return ((Q['defense_strength'] || 0) < (Q['enemy_strength'] || 0));\"}}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[\"The Reichsbanner number at \",{\"type\":\"insert\",\"insert\":0},\" thousand; many are in Berlin to counter the fascist demonstration.\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"The Prussian police has been deployed against the fascists. \",\"predicate\":1},\" \",{\"type\":\"conditional\",\"content\":\"The portions of the Reichswehr that are loyal are also deployed.\",\"predicate\":2}]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rb_strength'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['spd_prussia'] || 0)) !== 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['spd_in_government'] || 0)) !== 0) && (Q['president'] == \\\"Braun\\\"));\"}}]}},\"panzerkreuzer.abstain\":{\"id\":\"panzerkreuzer.abstain\",\"onArrival\":[{\"$code\":\"Q['dvp_relation'] = (Q['dvp_relation'] || 0) - 5;\\nQ['z_relation'] = (Q['z_relation'] || 0) - 3;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 5;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) + 5;\\nQ['panzerkreuzer_funded'] = 1;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) - 3;\"}],\"content\":{\"content\":\"Our coalition partners are shocked by our intransigence! Despite our abstention, the vote in the Reichstag goes through, with all parties in favor except the SPD and KPD. The ship will be built.\",\"type\":\"paragraph\"}},\"panzerkreuzer\":{\"id\":\"panzerkreuzer\",\"type\":\"scene\",\"title\":\"Panzerkreuzer A\",\"subtitle\":\"A political question\",\"tags\":[\"event\",\"govt_affairs\"],\"isCard\":true,\"onArrival\":[{\"$code\":\"Q['panzerkreuzer_seen'] = 1;\"}],\"faceImage\":\"img/panzerkreuzer.jpg\",\"viewIf\":{\"$code\":\"return ((((((Q['panzerkreuzer_seen'] || 0)===0) && ((Q['year'] || 0)===1928)) && ((Q['month'] || 0) >= 8)) && (Q['reichswehr_minister_party'] != \\\"SPD\\\")) && ((Q['spd_in_government'] || 0)===1));\"},\"newPage\":true,\"options\":[{\"id\":\"@panzerkreuzer.vote_yes\",\"title\":\"Vote yes, for constructing the battlecruiser.\"},{\"id\":\"@panzerkreuzer.vote_no\",\"title\":\"Vote no, against constructing the battlecruiser.\"},{\"id\":\"@panzerkreuzer.abstain\",\"title\":\"Abstain from the vote.\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Panzerkreuzer\"},{\"type\":\"paragraph\",\"content\":\"The Reichswehr Ministry is demanding the construction of a new battlecruiser, as part of Germany's rearmament. Our coalition partners are united in support. While many of our members are vehemently against new military spending, this vote may be necessary to preserve the coalition. We campaigned on food for children instead of battlecruisers. Will we really betray our campaign promises?\"}]},\"constitutional_reform.presidential_powers_2\":{\"id\":\"constitutional_reform.presidential_powers_2\",\"chooseIf\":{\"$code\":\"return ((Q['reform_support'] || 0) >= (Q['pass_threshold'] || 0));\"},\"unavailableSubtitle\":{\"content\":[\"We do not have enough support for this policy. \",{\"type\":\"conditional\",\"content\":\"We should have an additional margin for the referendum since we need a majority of voters, and many voters who do not support the republic will not participate. \",\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"The Center Party does not trust us enough to support this policy.\",\"predicate\":1}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['pro_republic'] || 0) < 65);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['z_relation'] || 0) <= 49) && (Q['president'] != \\\"Braun\\\"));\"}}]},\"onArrival\":[{\"$code\":\"Q['constitutional_reform'] = (Q['constitutional_reform'] || 0) + 1;\\nQ['presidential_powers'] = 1;\"}],\"achievement\":\"verfassungsreform\",\"content\":{\"content\":\"We have successfully passed a constitutional amendment to limit presidential powers! Hopefully this results in a less authoritarian Germany.\",\"type\":\"paragraph\"}},\"popular_front_dispute.education\":{\"id\":\"popular_front_dispute.education\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"presidential_election_1932.convince_z\":{\"id\":\"presidential_election_1932.convince_z\",\"chooseIf\":{\"$code\":\"return ((Q['spd_votes'] || 0) >= (Q['z_votes'] || 0));\"},\"unavailableSubtitle\":\"The Center knows that they are more popular than us; they do not see a reason to support our candidate.\",\"onArrival\":[{\"$code\":\"Q.z_support_braun = 0;\\nif (Q.z_relation >= 55 || (Q.z_relation > 35 && Q.z_party_leader == \\\"Joos\\\")) {\\n    Q.z_support_braun = 1;\\n} else if (Q.z_relation <= 35) {\\n    Q.z_support_braun = 0;\\n} else {\\n    Q.z_support_braun = 2;\\n}\"}],\"goTo\":[{\"id\":\"presidential_election_1932.z_failed\",\"predicate\":{\"$code\":\"return (((Q['z_support_braun'] || 0)===0) || ((((Q['z_support_braun'] || 0) == 2) && (((Q['historical_mode'] || 0)) !== 0))));\"}},{\"id\":\"presidential_election_1932.z_success\",\"predicate\":{\"$code\":\"return ((Q['z_support_braun'] || 0)===1);\"}},{\"id\":\"presidential_election_1932.z_partial\",\"predicate\":{\"$code\":\"return (((Q['z_support_braun'] || 0)===2) && (!(((Q['historical_mode'] || 0)) !== 0)));\"}}],\"maxVisits\":1,\"content\":{\"content\":\"We remind the Center leaders of Hindenburg's anti-Catholicism, and try to convince them that Hindenburg's path will eventually lead to Hitler. We also remind them of the successes they've had as part of the Weimar coalition in Prussia with Otto Braun, and our support for the Center candidate Wilhelm Marx in the 1925 presidential election.\",\"type\":\"paragraph\"},\"countVisitsMax\":1},\"unemployment_insurance_1.accept_compromise\":{\"id\":\"unemployment_insurance_1.accept_compromise\",\"onArrival\":[{\"$code\":\"Q['workers_spd'] = (Q['workers_spd'] || 0) - 5;\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) - 6;\\nQ['workers_kpd'] = (Q['workers_kpd'] || 0) + 5;\\nQ['unemployed_kpd'] = (Q['unemployed_kpd'] || 0) + 3;\\nQ['unemployed_nsdap'] = (Q['unemployed_nsdap'] || 0) + 3;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 10;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) + 8;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) + 5;\\nQ['welfare'] = (Q['welfare'] || 0) - 1;\\nQ['budget'] = (Q['budget'] || 0) + 1;\\nQ['month'] = (Q['month'] || 0) + 1;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) - 4;\\nQ['inflation'] = (Q['inflation'] || 0) - 1;\"}],\"content\":{\"content\":\"We have accepted the compromise offered by the bourgeoisie. Many of the workers and unemployed see this as a betrayal, although we present it as the successful aversion of a much worse alternative.\",\"type\":\"paragraph\"}},\"unemployment_insurance_1\":{\"id\":\"unemployment_insurance_1\",\"type\":\"scene\",\"title\":\"Unemployment Insurance Crisis\",\"subtitle\":\"The right wing of our coalition presents an ultimatum.\",\"newPage\":true,\"viewIf\":{\"$code\":\"return (((((((((Q['spd_in_government'] || 0)===1) && (((((Q['year'] || 0)===1930) || ((Q['year'] || 0)===1931)) || ((Q['year'] || 0)===1932)))) && (((Q['month'] || 0) >= 3))) && ((Q['in_grand_coalition'] || 0)===1)) && ((Q['unemployment_insurance_timer'] || 0)===0)) && ((((Q['unemployed'] || 0) >= ((Q['unemployment_insurance_threshold'] || 0) + 4)) || ((((Q['unemployed'] || 0) >= 20) && ((Q['unemployed'] || 0) >= (Q['unemployment_insurance_threshold'] || 0))))))) && (!(((Q['constructive_vonc'] || 0)) !== 0))) && (Q['president'] == \\\"Hindenburg\\\"));\"},\"onArrival\":[{\"$code\":\"Q['unemployment_insurance_crisis'] = (Q['unemployment_insurance_crisis'] || 0) + 1;\\n if (((Q['budget'] || 0) >= 1) ) { Q['budget'] = (Q['budget'] || 0) - 1; } \\nQ['unemployment_insurance_timer'] = 10;\\nQ['crisis_urgency'] = (Q['crisis_urgency'] || 0) + 1;\\nQ['unemployment_insurance_threshold'] = (Q['unemployed'] || 0);\"}],\"tags\":[\"event\"],\"maxVisits\":2,\"goTo\":[{\"id\":\"unemployment_insurance_1.what_do\",\"predicate\":{\"$code\":\"return ((Q['unemployment_insurance_crisis'] || 0)===2);\"}}],\"options\":[{\"id\":\"@unemployment_insurance_1.tax_rich\",\"title\":\"Why can't we simply tax the rich?\"},{\"id\":\"@unemployment_insurance_1.gift\",\"title\":\"This is a gift to the Communists.\"}],\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"Unemployment Insurance Crisis\"},{\"type\":\"paragraph\",\"content\":\"The economic crisis has caused mass layoffs all throughout Germany, affecting the industrial working class the hardest. Our welfare spending is increasing due to the greater need.\"},{\"type\":\"paragraph\",\"content\":\"In the midst of all this, our right-wing coalition partners in the DVP and Center parties have a plan to cut benefits for the unemployed, lower taxes on the rich, and raise taxes on the working class, as part of a plan to balance the budget and discipline labor. They do not see a possibility for compromise. If we do not accept, they could blow up the coalition.\"},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":\"This is the second such ultimatum thrown by the Right. Obviously, the bourgeoisie are trying to remove us from the government.\",\"predicate\":0}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['unemployment_insurance_crisis'] || 0)===2);\"}}]},\"countVisitsMax\":2},\"vote_of_no_confidence.support_kpd_grand\":{\"id\":\"vote_of_no_confidence.support_kpd_grand\",\"options\":[{\"id\":\"@election_1928.popular_front_coalition\",\"title\":\"Form a \\\"Popular Front\\\" coalition?\"},{\"id\":\"@election_1928.left_coalition\"},{\"id\":\"@vote_of_no_confidence.try_assuage\",\"title\":\"Never mind. We must deal with this some other way.\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"confronting_nazis.orgs\":{\"id\":\"confronting_nazis.orgs\",\"goTo\":[{\"id\":\"confronting_nazis.if_end\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"crisis_program.adopt_left\":{\"id\":\"crisis_program.adopt_left\",\"onArrival\":[{\"$code\":\"Q['left_strength'] = (Q['left_strength'] || 0) + 15;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) - 10;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 10;\\nQ['neorevisionist_dissent'] = (Q['neorevisionist_dissent'] || 0) + 8;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) + 6;\\nQ['nationalization_adopted'] = 1;\\nQ['coup_progress'] = (Q['coup_progress'] || 0) + 1;\\nQ['economic_plan'] = 3;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"With our hard work, we have convinced the majority of the party to adopt the socialist economic plan! \",{\"type\":\"conditional\",\"content\":\"We can begin implementing the plan as soon as possible, as long as we have the Economic or Finance ministries. \",\"predicate\":0},\" Bourgeois opposition is likely to be fierce. \",{\"type\":\"conditional\",\"content\":\"It might be difficult to enact the plan, given present conditions.\",\"predicate\":1}]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['spd_in_government'] || 0) == 1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['spd_in_government'] || 0) == 0);\"}}]}},\"inter_party_relationships.kpd_blutmai\":{\"id\":\"inter_party_relationships.kpd_blutmai\",\"onArrival\":[{\"$code\":\"Q['kpd_relation'] = (Q['kpd_relation'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 1;\"}],\"content\":{\"content\":\"After the events of Blütmai, reconciling with the Communists is difficult, if not impossible. Nevertheless, we must try.\",\"type\":\"paragraph\"}},\"media.radio_4\":{\"id\":\"media.radio_4\",\"title\":\"We should keep on supporting our radio network.\",\"subtitle\":\"As radio becomes more common, the novelty is beginning to wear off, and radio is becoming saturated in society. -1 resources\",\"chooseIf\":{\"$code\":\"return ((Q['resources'] || 0) >= 1);\"},\"unavailableSubtitle\":\"Not enough resources.\",\"viewIf\":{\"$code\":\"return ((((Q['radio'] || 0) > 3) && ((((Q['radio'] || 0) >= 6) || ((Q['year'] || 0) >= 1932)))) && ((Q['radio'] || 0) <= 9));\"},\"onArrival\":[{\"$code\":\"Q['radio'] = (Q['radio'] || 0) + 1;\\nQ['resources'] = (Q['resources'] || 0) - 1;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) + (2 * (1 - (Q['dissent'] || 0)));\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\nQ['rural_spd'] = (Q['rural_spd'] || 0) + (2 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (2 * (1 - (Q['dissent'] || 0)));\\nQ['socialism'] = (Q['socialism'] || 0) + (2 * (1 - (Q['dissent'] || 0)));\\n if (((Q['pacifism'] || 0) > 2) ) { Q['nationalism'] = (Q['nationalism'] || 0) - ((2 * (1 - (Q['dissent'] || 0))) * (Q['pacifism-2'] || 0)); } \\n if (((Q['democratization'] || 0) > 2) ) { Q['pro_republic'] = (Q['pro_republic'] || 0) + ((2 * (1 - (Q['dissent'] || 0))) * (Q['democratization-2'] || 0)); }\"}],\"content\":{\"content\":\"We are continuing to invest in our radio stations. Both commercial and political radio are becoming more prevalent, making it harder to spread our message amidst the competition.\",\"type\":\"paragraph\"}},\"media\":{\"id\":\"media\",\"type\":\"scene\",\"title\":\"Media\",\"newPage\":true,\"isCard\":true,\"tags\":[\"party_affairs\"],\"viewIf\":{\"$code\":\"return ((Q['media_timer'] || 0) <= 0);\"},\"onArrival\":[{\"$code\":\"Q['month_actions'] = (Q['month_actions'] || 0) + 1;\\nQ['media_timer'] = (Q['media_timer'] || 0) + 6;\"}],\"cardImage\":\"img/sangerbund.jpg\",\"options\":[{\"id\":\"@media.commercial\"},{\"id\":\"@media.campaign\"},{\"id\":\"@media.ideological\"},{\"id\":\"@media.radio\"},{\"id\":\"@media.radio_2\"},{\"id\":\"@media.radio_3\"},{\"id\":\"@media.radio_4\"},{\"id\":\"@return\",\"title\":\"We should not do anything with media at the moment.\"},{\"id\":\"@easy_discard\"},{\"id\":\"@cancel_advisor_action\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Media\"},{\"type\":\"paragraph\",\"content\":\"The SPD runs a veritable media empire, with many newspapers throughout every German city and region. We could use the media for various purposes...\"}]},\"party_disunity.do_nothing\":{\"id\":\"party_disunity.do_nothing\",\"title\":\"Let the factions argue with themselves.\",\"onArrival\":[{\"$code\":\"Q['labor_dissent'] = (Q['labor_dissent'] || 0) + 1;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 1;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) + 1;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 1;\"}],\"content\":{\"content\":\"Let the factions bicker; perhaps dissent is healthy for the party.\",\"type\":\"paragraph\"}},\"peoples_party.campaign_unemployed\":{\"id\":\"peoples_party.campaign_unemployed\",\"title\":\"Campaign among the unemployed.\",\"onArrival\":[{\"$code\":\"Q['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (6 * (1 - (Q['dissent'] || 0)));\"}],\"content\":{\"content\":\"As a people's party, the urban poor are still a key part of our constituency.\",\"type\":\"paragraph\"}},\"rally.rb_protect_lose\":{\"id\":\"rally.rb_protect_lose\",\"onArrival\":[{\"$code\":\"Q['workers_nsdap'] = (Q['workers_nsdap'] || 0) + 3;\\nQ['rb_strength'] = (Q['rb_strength'] || 0) - 50;\"}],\"content\":{\"content\":\"Unfortunately, the Reichsbanner was not able to hold back the SA mob. The Nazis have won this show of strength.\",\"type\":\"paragraph\"}},\"shuffle_leadership.remove_severing\":{\"id\":\"shuffle_leadership.remove_severing\",\"title\":\"Remove Severing\",\"viewIf\":{\"$code\":\"return ((Q['severing_advisor'] || 0)===1);\"},\"tags\":[\"remove_advisor\"],\"onArrival\":[{\"$code\":\"Q['severing_advisor'] = 0;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 5;\\nQ['n_advisors'] = (Q['n_advisors'] || 0) - 1;\"}],\"goTo\":[{\"id\":\"shuffle_leadership.rm_main\"}],\"content\":{\"content\":\"Severing has been removed as an advisor. The Reformist faction disapproves.\",\"type\":\"paragraph\"}},\"game_over.long_war\":{\"id\":\"game_over.long_war\",\"title\":\"Germany is gripped by civil war.\",\"viewIf\":{\"$code\":\"return ((Q['long_war'] || 0) == 1);\"},\"tags\":[\"endings\"],\"goTo\":[{\"id\":\"game_over.eg_menu\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"Germany is currently in the grip of a civil war, a brutal affair that has no obvious end. Thousands of lives have already been extinguished, and it is likely that the war will not stop until Germany's cities are reduced to ruins.\"},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"The current conditions are not favorable for us. \",\"predicate\":0},{\"type\":\"conditional\",\"content\":\"Our cause is popular in the West, but their sclerotic governments are reluctant to send us aid. \",\"predicate\":1},{\"type\":\"conditional\",\"content\":\"The Soviet Union has aided the Communists, but not the socialists and democrats, in an attempt to shape Germany's future government. \",\"predicate\":2},{\"type\":\"conditional\",\"content\":\"Poland and Czechoslovakia have sent some assistance against the fascists.\",\"predicate\":3}]}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['is_favorable'] || 0) == 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['west_relation'] || 0) >= 2);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['soviet_aid'] || 0) >= 1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['east_aid'] || 0) >= 1);\"}}]}},\"library.election_projections\":{\"id\":\"library.election_projections\",\"viewIf\":{\"$code\":\"return (((!(((Q['historical_mode'] || 0)) !== 0))) || (((Q['game_over'] || 0)) !== 0));\"},\"goTo\":[{\"id\":\"library.menu\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"Projected election results\"},\" (if the election were to be held now):\"]},{\"type\":\"paragraph\",\"content\":[\"SPD: \",{\"type\":\"insert\",\"insert\":0},\"%\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"SAPD: \",{\"type\":\"insert\",\"insert\":2},\"% \"],\"predicate\":1},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Z + BVP: \",{\"type\":\"insert\",\"insert\":3},\"%\"]},{\"type\":\"paragraph\",\"content\":[\"KPD: \",{\"type\":\"insert\",\"insert\":4},\"%\"]},{\"type\":\"paragraph\",\"content\":[\"DDP: \",{\"type\":\"insert\",\"insert\":5},\"%\"]},{\"type\":\"paragraph\",\"content\":[\"DVP: \",{\"type\":\"insert\",\"insert\":6},\"%\"]},{\"type\":\"paragraph\",\"content\":[\"DNVP: \",{\"type\":\"insert\",\"insert\":7},\"%\"]},{\"type\":\"paragraph\",\"content\":[\"NSDAP: \",{\"type\":\"insert\",\"insert\":8},\"%\"]},{\"type\":\"paragraph\",\"content\":[\"Others: \",{\"type\":\"insert\",\"insert\":9},\"%\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"Detailed results for each demographic\"},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Workers: SPD: \",{\"type\":\"insert\",\"insert\":10},\"%, Z: \",{\"type\":\"insert\",\"insert\":11},\"%, KPD: \",{\"type\":\"insert\",\"insert\":12},\"%, DDP: \",{\"type\":\"insert\",\"insert\":13},\"%, DVP: \",{\"type\":\"insert\",\"insert\":14},\"%; DNVP: \",{\"type\":\"insert\",\"insert\":15},\"%, NSDAP: \",{\"type\":\"insert\",\"insert\":16},\"%, Others: \",{\"type\":\"insert\",\"insert\":17},\"% \",{\"type\":\"conditional\",\"content\":[\"SAPD: \",{\"type\":\"insert\",\"insert\":19},\"% \"],\"predicate\":18},\"\"]},{\"type\":\"paragraph\",\"content\":[\"New Middle Class: SPD: \",{\"type\":\"insert\",\"insert\":20},\"%, Z: \",{\"type\":\"insert\",\"insert\":21},\"%, KPD: \",{\"type\":\"insert\",\"insert\":22},\"%, DDP: \",{\"type\":\"insert\",\"insert\":23},\"%, DVP: \",{\"type\":\"insert\",\"insert\":24},\"%; DNVP: \",{\"type\":\"insert\",\"insert\":25},\"%, NSDAP: \",{\"type\":\"insert\",\"insert\":26},\"%, Others: \",{\"type\":\"insert\",\"insert\":27},\"% \",{\"type\":\"conditional\",\"content\":[\"SAPD: \",{\"type\":\"insert\",\"insert\":29},\"% \"],\"predicate\":28},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Old Middle Class: SPD: \",{\"type\":\"insert\",\"insert\":30},\"%, Z: \",{\"type\":\"insert\",\"insert\":31},\"%, KPD: \",{\"type\":\"insert\",\"insert\":32},\"%, DDP: \",{\"type\":\"insert\",\"insert\":33},\"%, DVP: \",{\"type\":\"insert\",\"insert\":34},\"%; DNVP: \",{\"type\":\"insert\",\"insert\":35},\"%, NSDAP: \",{\"type\":\"insert\",\"insert\":36},\"%, Others: \",{\"type\":\"insert\",\"insert\":37},\"% \",{\"type\":\"conditional\",\"content\":[\"SAPD: \",{\"type\":\"insert\",\"insert\":39},\"% \"],\"predicate\":38},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Rural: SPD: \",{\"type\":\"insert\",\"insert\":40},\"%, Z: \",{\"type\":\"insert\",\"insert\":41},\"%, KPD: \",{\"type\":\"insert\",\"insert\":42},\"%, DDP: \",{\"type\":\"insert\",\"insert\":43},\"%, DVP: \",{\"type\":\"insert\",\"insert\":44},\"%; DNVP: \",{\"type\":\"insert\",\"insert\":45},\"%, NSDAP: \",{\"type\":\"insert\",\"insert\":46},\"%, Others: \",{\"type\":\"insert\",\"insert\":47},\"% \",{\"type\":\"conditional\",\"content\":[\"SAPD: \",{\"type\":\"insert\",\"insert\":49},\"% \"],\"predicate\":48},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Unemployed: SPD: \",{\"type\":\"insert\",\"insert\":50},\"%, Z: \",{\"type\":\"insert\",\"insert\":51},\"%, KPD: \",{\"type\":\"insert\",\"insert\":52},\"%, DDP: \",{\"type\":\"insert\",\"insert\":53},\"%, DVP: \",{\"type\":\"insert\",\"insert\":54},\"%; DNVP: \",{\"type\":\"insert\",\"insert\":55},\"%, NSDAP: \",{\"type\":\"insert\",\"insert\":56},\"%, Others: \",{\"type\":\"insert\",\"insert\":57},\"% \",{\"type\":\"conditional\",\"content\":[\"SAPD: \",{\"type\":\"insert\",\"insert\":59},\"% \"],\"predicate\":58},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Catholics: SPD: \",{\"type\":\"insert\",\"insert\":60},\"%, Z: \",{\"type\":\"insert\",\"insert\":61},\"%, KPD: \",{\"type\":\"insert\",\"insert\":62},\"%, DDP: \",{\"type\":\"insert\",\"insert\":63},\"%, DVP: \",{\"type\":\"insert\",\"insert\":64},\"%; DNVP: \",{\"type\":\"insert\",\"insert\":65},\"%, NSDAP: \",{\"type\":\"insert\",\"insert\":66},\"%, Others: \",{\"type\":\"insert\",\"insert\":67},\"% \",{\"type\":\"conditional\",\"content\":[\"SAPD: \",{\"type\":\"insert\",\"insert\":69},\"%\"],\"predicate\":68}]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['spd_votes'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['sapd_formed'] || 0)) !== 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['sapd_votes'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['z_votes'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['kpd_votes'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['ddp_votes'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['dvp_votes'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['dnvp_votes'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['nsdap_votes'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['other_votes'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['workers_spd_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['workers_z_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['workers_kpd_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['workers_ddp_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['workers_dvp_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['workers_dnvp_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['workers_nsdap_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['workers_other_normalized'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['sapd_formed'] || 0)) !== 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['workers_sapd_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['new_middle_spd_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['new_middle_z_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['new_middle_kpd_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['new_middle_ddp_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['new_middle_dvp_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['new_middle_dnvp_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['new_middle_nsdap_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['new_middle_other_normalized'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['sapd_formed'] || 0)) !== 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['new_middle_sapd_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['old_middle_spd_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['old_middle_z_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['old_middle_kpd_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['old_middle_ddp_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['old_middle_dvp_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['old_middle_dnvp_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['old_middle_nsdap_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['old_middle_other_normalized'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['sapd_formed'] || 0)) !== 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['old_middle_sapd_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rural_spd_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rural_z_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rural_kpd_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rural_ddp_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rural_dvp_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rural_dnvp_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rural_nsdap_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rural_other_normalized'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['sapd_formed'] || 0)) !== 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rural_sapd_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['unemployed_spd_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['unemployed_z_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['unemployed_kpd_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['unemployed_ddp_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['unemployed_dvp_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['unemployed_dnvp_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['unemployed_nsdap_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['unemployed_other_normalized'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['sapd_formed'] || 0)) !== 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['unemployed_sapd_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['catholics_spd_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['catholics_z_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['catholics_kpd_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['catholics_ddp_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['catholics_dvp_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['catholics_dnvp_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['catholics_nsdap_normalized'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['catholics_other_normalized'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['sapd_formed'] || 0)) !== 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['catholics_sapd_normalized'] || 0);\"}}]}},\"stampfer.kpd_cooperation\":{\"id\":\"stampfer.kpd_cooperation\",\"title\":\"Cooperation with the KPD\",\"subtitle\":\"Could we build closer ties with the KPD?\",\"unavailableSubtitle\":{\"content\":{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"insert\",\"insert\":1},\" months before next advisor action.\"],\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['advisor_action_timer'] || 0);\"}}]},\"chooseIf\":{\"$code\":\"return ((Q['advisor_action_timer'] || 0)===0);\"},\"onArrival\":[{\"$code\":\"Q['advisor_action_timer'] = 6;\\nQ['left_strength'] = (Q['left_strength'] || 0) + 2;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 2;\"}],\"content\":{\"content\":\"Stampfer works towards closer ties with the KPD through our media.\",\"type\":\"paragraph\"}},\"stampfer\":{\"id\":\"stampfer\",\"type\":\"scene\",\"title\":\"Friedrich Stampfer\",\"isPinnedCard\":true,\"tags\":[\"advisor\"],\"cardImage\":\"img/portraits/StampferFriedrich.jpg\",\"viewIf\":{\"$code\":\"return ((Q['stampfer_advisor'] || 0)===1);\"},\"newPage\":true,\"options\":[{\"id\":\"@stampfer.media_\"},{\"id\":\"@stampfer.faction_support_\"},{\"id\":\"@stampfer.kpd_cooperation\"},{\"id\":\"@root\",\"title\":\"Return to main\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Friedrich Stampfer\"},{\"type\":\"paragraph\",\"content\":\"Friedrich Stampfer is the long-time editor-in-chief of Vorwärts, our party newspaper, and also a Reichstag member. He was historically part of the Majority SPD that supported our participation in the Great War, but also supports cooperation with the KPD to save the Republic.\"}]},\"dealing_with_toleration.stay_course\":{\"id\":\"dealing_with_toleration.stay_course\",\"content\":{\"content\":\"We will stay the course of toleration, for the sake of stability.\",\"type\":\"paragraph\"}},\"dealing_with_toleration\":{\"id\":\"dealing_with_toleration\",\"type\":\"scene\",\"title\":\"Dealing with Toleration\",\"newPage\":true,\"isCard\":true,\"cardImage\":\"img/portraits/BrüningHeinrich.jpg\",\"viewIf\":{\"$code\":\"return ((((Q['dealing_with_toleration_timer'] || 0)===0) && (((Q['spd_toleration'] || 0)) !== 0)) && (Q['chancellor_party'] == \\\"Z\\\"));\"},\"onArrival\":[{\"$code\":\"Q['dealing_with_toleration_timer'] = (Q['dealing_with_toleration_timer'] || 0) + 6;\\nQ['month_actions'] = (Q['month_actions'] || 0) + 1;\"}],\"tags\":[\"govt_affairs\"],\"options\":[{\"id\":\"@dealing_with_toleration.break_toleration\"},{\"id\":\"@dealing_with_toleration.urge_against_austerity\"},{\"id\":\"@dealing_with_toleration.improve_relations\"},{\"id\":\"@dealing_with_toleration.new_grand_coalition\"},{\"id\":\"@dealing_with_toleration.stay_course\",\"title\":\"Stay the course, for stability's sake.\"}],\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"Dealing with Toleration\"},{\"type\":\"paragraph\",\"content\":[\"We are currently acting as external support to the government of Chancellor \",{\"type\":\"insert\",\"insert\":0},\". How should we use our position?\"]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor'] || 0);\"}}]}},\"economic_policy.nationalize_deficit\":{\"id\":\"economic_policy.nationalize_deficit\",\"options\":[{\"id\":\"@economic_policy.nationalize_deficit_1\"},{\"id\":\"@economic_policy.nationalize_without_compensation\"},{\"id\":\"@economic_policy.empower_workers\"},{\"id\":\"@return\",\"title\":\"No, we should not do this.\"}],\"content\":{\"content\":\"Unfortunately, we do not have the budget to begin buying out industrial facilities. Some are urging for deficit spending in order to purchase factories, while others are encouraging (currently illegal) factory takeovers by workers, or nationalization without compensation. Taking any of these actions would require a vast departure from our previous party stances.\",\"type\":\"paragraph\"}},\"domestic_enemies.unban_rfb\":{\"id\":\"domestic_enemies.unban_rfb\",\"viewIf\":{\"$code\":\"return ((Q['rfb_banned'] || 0)===1);\"},\"onArrival\":[{\"$code\":\"Q['rfb_banned'] = 0;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) + 5;\\nQ['rfb_strength'] = (Q['rfb_strength'] || 0) + 50;\\nQ['prussian_police_loyalty'] = (Q['prussian_police_loyalty'] || 0) - 0.05;\\nQ['interior_police_loyalty'] = (Q['interior_police_loyalty'] || 0) - 0.05;\"}],\"content\":{\"content\":\"The Communist RFB is no longer banned.\",\"type\":\"paragraph\"}},\"foreign_policy.kpd\":{\"id\":\"foreign_policy.kpd\",\"onArrival\":[{\"$code\":\"Q['kpd_relation'] = (Q['kpd_relation'] || 0) + (8 * (1 - (Q['dissent'] || 0)));\\n if (((Q['kpd_foreign_seen'] || 0) == 0) ) { Q['communist_coalition'] = (Q['communist_coalition'] || 0) + 1; } \\nQ['kpd_foreign_seen'] = 1;\"}],\"content\":{\"content\":\"We also mention the KPD in our conversations with the Soviet ambassador. They claim that the KPD is entirely independent of the Soviet government, and that the conflict is Thälmann's doing. But, soon after our conversation we notice a slight improvement in attitudes from the KPD.\",\"type\":\"paragraph\"}},\"fiscal_policy.raise_tariffs\":{\"id\":\"fiscal_policy.raise_tariffs\",\"title\":\"Raise tariffs on imports.\",\"subtitle\":\"+2 budget. Other countries will retaliate by increasing tariffs of their own.\",\"onArrival\":[{\"$code\":\"Q['tariffs'] = (Q['tariffs'] || 0) + 1;\\n if (((Q['inflation'] || 0) > 0) ) { Q['inflation'] = (Q['inflation'] || 0) + 1; } \\n if (((Q['inflation'] || 0) <= 0) ) { Q['inflation'] = (Q['inflation'] || 0) + 0.5; } \\nQ['unemployed'] = (Q['unemployed'] || 0) + 1.5;\\nQ['budget'] = (Q['budget'] || 0) + 2;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) - 5;\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) - 5;\\nQ['rural_spd'] = (Q['rural_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\nQ['ddp_relation'] = (Q['ddp_relation'] || 0) - 5;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 2;\\nQ['west_relation'] = (Q['west_relation'] || 0) - 1;\\nQ['east_relation'] = (Q['east_relation'] || 0) - 1;\\nQ['reparations_negotiation'] = (Q['reparations_negotiation'] || 0) - 1;\\n if (((Q['eu_progress'] || 0) > 0) ) { Q['eu_progress'] = (Q['eu_progress'] || 0) - 1; } \\nQ['peoples_party_support'] = (Q['peoples_party_support'] || 0) + 1;\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"Increasing tariffs leads to higher prices for basic goods, increasing inflation and hurting consumption among the working class. Retaliatory tariffs reduce the competitiveness of German exports, raising unemployment among workers. They also lead to an atmosphere of international suspicion, reducing our ability to negotiate with other countries.\"},{\"type\":\"paragraph\",\"content\":\"On the other hand, agricultural producers and some small businesses benefit from higher tariffs, as farmers can now command higher prices for grain, and formerly uncompetitive businesses are now able to function.\"}]},\"labor_rights.balance\":{\"id\":\"labor_rights.balance\",\"subtitle\":{\"content\":[\"Neither workers nor employers will be entirely satisfied or dissatisfied. \",{\"type\":\"conditional\",\"content\":\"The DVP will likely consider the compromise unacceptable. \",\"predicate\":0},{\"type\":\"conditional\",\"content\":\"The DVP might grudgingly accept the compromise for now.\",\"predicate\":1}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['in_grand_coalition'] || 0)) !== 0) && ((Q['dvp_relation'] || 0) < 30));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['in_grand_coalition'] || 0)) !== 0) && ((Q['dvp_relation'] || 0) >= 30));\"}}]},\"onArrival\":[{\"$code\":\"Q['workers_spd'] = (Q['workers_spd'] || 0) - 4;\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) - 5;\\nQ['workers_kpd'] = (Q['workers_kpd'] || 0) + 4;\\nQ['unemployed_kpd'] = (Q['unemployed_kpd'] || 0) + 3;\\nQ['unemployed_nsdap'] = (Q['unemployed_nsdap'] || 0) + 3;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 10;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) + 8;\\nQ['center_dissent'] = (Q['center_dissent'] || 0) + 5;\\nQ['welfare'] = (Q['welfare'] || 0) - 1;\\nQ['budget'] = (Q['budget'] || 0) + 1;\\nQ['month'] = (Q['month'] || 0) + 1;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) - 4;\\nQ['inflation'] = (Q['inflation'] || 0) - 1;\\nQ['unemployment_insurance_threshold'] = (Q['unemployed'] || 0);\\nQ['unemployment_insurance_timer'] = 10;\\n if (((((Q['in_grand_coalition'] || 0)) !== 0) && ((Q['dvp_relation'] || 0) < 30)) ) { Q['coalition_dissent'] = 2; } \\n if ((((Q['in_grand_coalition'] || 0)) !== 0) ) { Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1; }\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"Neither side is entirely satisfied by our compromise solution. Many of the workers and unemployed see this as a betrayal, although we present it as the successful aversion of a much worse alternative. \",{\"type\":\"conditional\",\"content\":\"Meanwhile, the DVP is aghast at the prospect of raising any taxes on businesses at all.\",\"predicate\":0}]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['in_grand_coalition'] || 0)) !== 0);\"}}]}},\"labor_rights\":{\"id\":\"labor_rights\",\"type\":\"scene\",\"title\":\"Labor Rights\",\"newPage\":true,\"isCard\":true,\"tags\":[\"govt_affairs\"],\"onArrival\":[{\"$code\":\"Q['labor_rights_timer'] = (Q['labor_rights_timer'] || 0) + 10;\\nQ['month_actions'] = (Q['month_actions'] || 0) + 1;\"}],\"viewIf\":{\"$code\":\"return (((((Q['spd_in_government'] || 0)===1) && (Q['labor_minister_party'] == \\\"SPD\\\")) && ((Q['labor_rights_timer'] || 0) <= 0)) && ((Q['labor_affairs_seen'] || 0)===1));\"},\"cardImage\":\"img/portraits/WissellRudolf.jpg\",\"maxVisits\":6,\"goTo\":[{\"id\":\"labor_rights.labor_rights_menu\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Labor Rights\"},{\"type\":\"paragraph\",\"content\":\"With control of the Labor Ministry, we can set national standards for labor. Our supporters expect us to enforce a 40-hour work week and enforce safety regulations, as well as fully fund the unemployment insurance program.\"}],\"countVisitsMax\":6},\"prussian_affairs.ban_rfb\":{\"id\":\"prussian_affairs.ban_rfb\",\"viewIf\":{\"$code\":\"return (((Q['communist_coalition'] || 0) < 3) && ((Q['rfb_banned'] || 0)===0));\"},\"onArrival\":[{\"$code\":\"Q['kpd_relation'] = (Q['kpd_relation'] || 0) - 15;\\nQ['rfb_strength'] = (Q['rfb_strength'] || 0) - 50;\\nQ['rfb_banned'] = 1;\\nQ['communist_coalition'] = (Q['communist_coalition'] || 0) - 1;\\nQ['z_relation'] = (Q['z_relation'] || 0) + 5;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) + 5;\\nQ['prussian_police_loyalty'] = (Q['prussian_police_loyalty'] || 0) + 0.1;\"}],\"content\":{\"content\":\"The ban is enthusiastically carried out by the police, perhaps too enthusiastically. The Communists take this as one more reason why the Socialists are traitors to the left. However, the moderate and center-right parties approve, as do the police.\",\"type\":\"paragraph\"}},\"civil_war.defeat\":{\"id\":\"civil_war.defeat\",\"options\":[{\"id\":\"@game_over\",\"title\":\"Game over.\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Total Defeat\"},{\"type\":\"paragraph\",\"content\":\"Our forces are no match for those of the reactionaries. Reichsbanner fighters are quickly overpowered by the forces of the Stahlhelm, SA, and Reichswehr. Many are killed before the rest surrender. Our remaining leaders flee the country or face execution, as the reactionaries take absolute power over Germany.\"},{\"type\":\"paragraph\",\"content\":\"Our resistance will be recorded in the history books, and in the future, our names will be honored. But for now, all is lost.\"}]},\"election_1928.popular_front_democracy\":{\"id\":\"election_1928.popular_front_democracy\",\"title\":\"Convince the KPD to accept democracy.\",\"subtitle\":{\"content\":{\"type\":\"conditional\",\"content\":\"The Conciliator leadership of the KPD at least claim to support the Popular Front.\",\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['kpd_party_leader'] == \\\"Conciliators\\\");\"}}]},\"unavailableSubtitle\":\"Our relationship with the KPD is not high enough.\",\"chooseIf\":{\"$code\":\"return (((((Q['kpd_relation'] || 0) >= 60) && ((Q['communist_coalition'] || 0) >= 3))) || (Q['kpd_party_leader'] == \\\"Conciliators\\\"));\"},\"goTo\":[{\"id\":\"election_1928.popular_front_success\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"kpd_policy.finance_support\":{\"id\":\"kpd_policy.finance_support\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"kpd_vote_of_no_confidence.let_it_happen_hindenburg\":{\"id\":\"kpd_vote_of_no_confidence.let_it_happen_hindenburg\",\"onArrival\":[{\"$code\":\"if (((Q['next_election_time'] || 0) >= ((Q['time'] || 0) + 3)) ) { Q['next_election_time'] = ((Q['time'] || 0) + 3); } \\n if (((Q['next_election_time'] || 0) >= ((Q['time'] || 0) + 3)) ) { Q['next_election_month'] = ((Q['month'] || 0) + 3); } \\n if (((Q['next_election_time'] || 0) >= ((Q['time'] || 0) + 3)) ) { Q['next_election_year'] = (Q['year'] || 0); } \\n if (((Q['next_election_month'] || 0) > 12) ) { Q['next_election_year'] = (Q['next_election_year'] || 0) + 1; } \\n if (((Q['next_election_month'] || 0) > 12) ) { Q['next_election_month'] = (Q['next_election_month'] || 0) - 12; } \\nQ['spd_in_government'] = 0;\\nQ['in_popular_front'] = 0;\\nQ['in_left_front'] = 0;\\nQ['chancellor'] = \\\"Brüning\\\";\\nQ['chancellor_party'] = \\\"Z \\\";\\nQ['foreign_minister_party'] = \\\"DVP\\\";\\nQ['interior_minister_party'] = \\\"Z\\\";\\nQ['justice_minister_party'] = \\\"I\\\";\\nQ['labor_minister_party'] = \\\"Z\\\";\\nQ['reichswehr_minister_party'] = \\\"I\\\";\\nQ['economic_minister_party'] = \\\"DDP\\\";\\nQ['finance_minister_party'] = \\\"DVP\\\";\\nQ['agriculture_minister_party'] = \\\"Z\\\";\\nQ['coalition_dissent'] = 0;\\nQ['kpd_coalitipn_dissent'] = 0;\\nQ['pro_republic'] = (Q['pro_republic'] || 0) - 5;\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) - 3;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) - 2;\\n if (((Q['pro_republic'] || 0) < 50) ) { Q['workers_spd'] = (Q['workers_spd'] || 0) - 3; } \\n if (((Q['pro_republic'] || 0) < 40) ) { Q['workers_spd'] = (Q['workers_spd'] || 0) - 4; } \\n if (((Q['pro_republic'] || 0) < 50) ) { Q['old_middle_nsdap'] = (Q['old_middle_nsdap'] || 0) + 4; } \\n if (((Q['pro_republic'] || 0) < 50) ) { Q['new_middle_nsdap'] = (Q['new_middle_nsdap'] || 0) + 3; }\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"The vote succeeds, and our government has resigned. Chancellor Brüning has been appointed as the head of an acting government, consisting solely of the bourgeois parties.\"},{\"type\":\"paragraph\",\"content\":[\"New elections have been set for \",{\"type\":\"insert\",\"insert\":0},\" \",{\"type\":\"insert\",\"insert\":1},\".\"]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_month'] || 0);\"},\"qdisplay\":\"month\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_year'] || 0);\"}}]}},\"kpd_vote_of_no_confidence\":{\"id\":\"kpd_vote_of_no_confidence\",\"type\":\"scene\",\"title\":\"The KPD calls a vote of no confidence against the current government!\",\"subtitle\":\"We have angered the KPD too much...\",\"newPage\":true,\"viewIf\":{\"$code\":\"return (((((Q['spd_in_government'] || 0)===1) && ((((((Q['in_popular_front'] || 0)===1) && ((Q['kpd_coalition_dissent'] || 0) >= 3))) || ((((Q['in_left_front'] || 0)===1) && ((Q['kpd_coalition_dissent'] || 0) >= 4)))))) && ((Q['spd_r'] || 0) < 50)) && (!(((Q['constructive_vonc'] || 0)) !== 0)));\"},\"tags\":[\"event\"],\"goTo\":[{\"id\":\"kpd_vote_of_no_confidence.menu\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Vote of No Confidence\"},{\"type\":\"paragraph\",\"content\":\"The KPD has called a vote of no confidence against us, due to our various policies and disagreements. If this succeeds, there will be an election in a few months.\"}]},\"march_on_berlin.fight_2_win\":{\"id\":\"march_on_berlin.fight_2_win\",\"onArrival\":[{\"$code\":\"Q['coup_progress'] = 0;\\nQ['sa_strength'] = (Q['sa_strength'] || 0) * 0.6;\\nQ['sh_strength'] = (Q['sh_strength'] || 0) * 0.6;\\nQ['workers_nsdap'] = (Q['workers_nsdap'] || 0) - (12 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_nsdap'] = (Q['unemployed_nsdap'] || 0) - (10 * (1 - (Q['dissent'] || 0)));\\nQ['new_middle_nsdap'] = (Q['new_middle_nsdap'] || 0) - (6 * (1 - (Q['dissent'] || 0)));\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (8 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (6 * (1 - (Q['dissent'] || 0)));\\nQ['pro_republic'] = (Q['pro_republic'] || 0) + 15;\"}],\"achievement\":\"drei_pfeile\",\"content\":[{\"type\":\"paragraph\",\"content\":\"Our forces confront the fascists, and somehow, the fascists retreat! They were overwhelmed by our display of strength, and have chosen to slink away. The attempted coup is over, at least for now.\"},{\"type\":\"paragraph\",\"content\":\"The show of force has reinvigorated support for the republic and for the SPD, and has weakened the fascists.\"}]},\"constitutional_reform.constitutional_bans\":{\"id\":\"constitutional_reform.constitutional_bans\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"popular_front_dispute.secularism\":{\"id\":\"popular_front_dispute.secularism\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"popular_front_dispute\":{\"id\":\"popular_front_dispute\",\"type\":\"scene\",\"title\":\"Disputes within the Popular Front\",\"subtitle\":\"As expected, there are clashes between the KPD and Center Party.\",\"viewIf\":{\"$code\":\"return ((((Q['in_popular_front'] || 0)===1) && ((Q['popular_front_dispute_timer'] || 0)===0)) && (((((Q['labor_minister_party'] == \\\"Z\\\") || (Q['economy_minister_party'] == \\\"Z\\\")) || (Q['interior_minister_party'] == \\\"Z\\\")) || (Q['agriculture_minister_party'] == \\\"Z\\\"))));\"},\"newPage\":true,\"onArrival\":[{\"$code\":\"Q['popular_front_dispute_timer'] = 5;\"}],\"content\":{\"type\":\"heading\",\"content\":\"Disputes within the Popular Front\"}},\"presidential_election_1932.z_success\":{\"id\":\"presidential_election_1932.z_success\",\"goTo\":[{\"id\":\"presidential_election_1932.braun_campaign\"}],\"content\":{\"content\":\"The Center are convinced! They will be part of the Braun coalition.\",\"type\":\"paragraph\"}},\"vote_of_no_confidence.support_kpd_weimar\":{\"id\":\"vote_of_no_confidence.support_kpd_weimar\",\"options\":[{\"id\":\"@election_1928.left_coalition\"},{\"id\":\"@vote_of_no_confidence.try_assuage\",\"title\":\"Never mind. We must deal with this some other way.\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"confronting_nazis.wtb\":{\"id\":\"confronting_nazis.wtb\",\"viewIf\":{\"$code\":\"return ((Q['wtb_adopted'] || 0) == 1);\"},\"goTo\":[{\"id\":\"confronting_nazis.if_end\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"crisis_program.support_moderate\":{\"id\":\"crisis_program.support_moderate\",\"subtitle\":\"Call for a limited program of job creation without deficit spending.\",\"unavailableSubtitle\":\"The Reformist faction is not strong enough.\",\"chooseIf\":{\"$code\":\"return (((Q['historical_mode'] || 0) == 0) || (((((Q['reformist_strength'] || 0) >= (Q['left_strength'] || 0)) && ((Q['reformist_strength'] || 0) >= (Q['center_strength'] || 0))) && ((Q['reformist_strength'] || 0) >= (Q['labor_strength'] || 0)))));\"},\"onArrival\":[{\"$code\":\"Q['moderate_plan_support'] = (Q['moderate_plan_support'] || 0) + 1;\\nQ['reformist_strength'] = (Q['reformist_strength'] || 0) + 8;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) - 5;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 6;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) + 5;\"}],\"goTo\":[{\"id\":\"crisis_program.adopt_moderate\",\"predicate\":{\"$code\":\"return ((Q['moderate_plan_support'] || 0) >= 2);\"}},{\"id\":\"crisis_program.support_moderate_progress\",\"predicate\":{\"$code\":\"return ((Q['moderate_plan_support'] || 0) < 2);\"}}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"inter_party_relationships.center\":{\"id\":\"inter_party_relationships.center\",\"subtitle\":\"-1 resources\",\"chooseIf\":{\"$code\":\"return ((Q['resources'] || 0) >= 1);\"},\"unavailableSubtitle\":\"Not enough resources.\",\"onArrival\":[{\"$code\":\"Q['resources'] = (Q['resources'] || 0) - 1;\\n if ((Q['z_party_leader'] == \\\"Joos\\\") ) { Q['z_relation'] = (Q['z_relation'] || 0) + 2; }\"}],\"goTo\":[{\"id\":\"inter_party_relationships.center_op\",\"predicate\":{\"$code\":\"return ((((Q['z_in_government'] || 0)===1) && ((Q['spd_in_government'] || 0)===0)) && (Q['chancellor'] != \\\"Brüning\\\"));\"}},{\"id\":\"inter_party_relationships.center_coalition\",\"predicate\":{\"$code\":\"return (((Q['spd_in_government'] || 0)===1) && ((Q['z_in_government'] || 0)===1));\"}},{\"id\":\"inter_party_relationships.center_bruning\",\"predicate\":{\"$code\":\"return (Q['chancellor'] == \\\"Brüning\\\");\"}}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"party_disunity.expel_reformists\":{\"id\":\"party_disunity.expel_reformists\",\"title\":\"Expel the dissident reformists.\",\"viewIf\":{\"$code\":\"return ((Q['reformist_dissent'] || 0) > 30);\"},\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"peoples_party.campaign_women\":{\"id\":\"peoples_party.campaign_women\",\"title\":\"Campaign among women of all classes.\",\"onArrival\":[{\"$code\":\"Q['workers_spd'] = (Q['workers_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\nQ['rural_spd'] = (Q['rural_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\"}],\"content\":{\"content\":\"As a people's party, we represent women of all classes.\",\"type\":\"paragraph\"}},\"rally.both_protect\":{\"id\":\"rally.both_protect\",\"viewIf\":{\"$code\":\"return (((Q['spd_prussia'] || 0)) !== 0);\"},\"chooseIf\":{\"$code\":\"return ((Q['prussian_police_training'] || 0) > 0);\"},\"unavailableSubtitle\":\"The loyal sections of the police have never coordinated with the Reichsbanner before.\",\"onArrival\":[{\"$code\":\"Q['rb_success'] = ((((Q['rb_strength'] || 0) * (Q['rb_militancy'] || 0)) - ((Q['sa_strength'] || 0) * (Q['sa_militancy'] || 0))) + ((((Q['prussian_police_loyalty'] || 0) * (Q['prussian_police_militancy'] || 0)) * (Q['prussian_police_strength'] || 0)) * 2));\\nQ['strife'] = (Q['strife'] || 0) + 1;\"}],\"goTo\":[{\"id\":\"rally.both_protect_win\",\"predicate\":{\"$code\":\"return ((Q['rb_success'] || 0) >= 0);\"}},{\"id\":\"rally.both_protect_lose\",\"predicate\":{\"$code\":\"return ((Q['rb_success'] || 0) < 0);\"}}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"shuffle_leadership.remove_braun\":{\"id\":\"shuffle_leadership.remove_braun\",\"title\":\"Remove Braun\",\"viewIf\":{\"$code\":\"return ((Q['braun_advisor'] || 0)===1);\"},\"tags\":[\"remove_advisor\"],\"onArrival\":[{\"$code\":\"Q['braun_advisor'] = 0;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 5;\\nQ['n_advisors'] = (Q['n_advisors'] || 0) - 1;\"}],\"goTo\":[{\"id\":\"shuffle_leadership.rm_main\"}],\"content\":{\"content\":\"Braun has been removed as an advisor. The Reformist faction disapproves.\",\"type\":\"paragraph\"}},\"game_over.braun_victorious\":{\"id\":\"game_over.braun_victorious\",\"title\":\"Otto Braun victorious\",\"viewIf\":{\"$code\":\"return (Q['president'] == \\\"Braun\\\");\"},\"tags\":[\"endings\"],\"goTo\":[{\"id\":\"game_over.eg_menu\"}],\"content\":{\"content\":\"Otto Braun has been elected as President of Germany. He had never desired to be the most powerful man in Germany, but now he is.\",\"type\":\"paragraph\"}},\"library.parties\":{\"id\":\"library.parties\",\"goTo\":[{\"id\":\"library.menu\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"SPD\"},\" - \",{\"type\":\"emphasis-1\",\"content\":\"Sozialdemokratische Partei Deutschlands\"},\" (Social Democratic Party of Germany) - this is us. We are a socialist and democratic party of the working class. We are the heirs of the legacy of Marx and Engels, Lassalle and Bebel. We are the foremost defenders of the Republic. The modern SPD was formed from a merger of the \\\"Majority\\\" SPD, which supported the Great War, and the \\\"Independent\\\" SPD or USPD, which opposed the war.\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"Z\"},\" - \",{\"type\":\"emphasis-1\",\"content\":\"Zentrumspartei\"},\" (Center Party) - a centrist to center-right Catholic party that supports the Republic, and has historically supported many of our labor, welfare, and anti-militarist priorities. They have often been in coalitions with us. They are often associated with the \",{\"type\":\"emphasis-2\",\"content\":\"BVP\"},\" (Bavarian People's Party), which represents Catholics in Bavaria. \",{\"type\":\"conditional\",\"content\":\"They have appeared to take a more conservative turn recently, with the rise of Brüning and the party leader, Ludwig Kaas. \",\"predicate\":0},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Current relations: \",{\"type\":\"insert\",\"insert\":1},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"DDP\"},\" - \",{\"type\":\"emphasis-1\",\"content\":\"Deutsche Demokratische Partei\"},\" (German Democratic Party) - a center-left liberal party, popular among the intelligensia and educated middle class. They have often been in coalitions with us. \",{\"type\":\"conditional\",\"content\":\"They have recently renamed themselves the German State Party. \",\"predicate\":2},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Current relations: \",{\"type\":\"insert\",\"insert\":3},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"DVP\"},\" - \",{\"type\":\"emphasis-1\",\"content\":\"Deutsche Volkspartei\"},\" (German People's Party) - a conservative-liberal party, supported by the middle classes and bourgeoisie. We have occasionally been in coalitions.\"]},{\"type\":\"paragraph\",\"content\":[\"Current relations: \",{\"type\":\"insert\",\"insert\":4},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"DNVP\"},\" - \",{\"type\":\"emphasis-1\",\"content\":\"Deutschnationale Volkspartei\"},\" (German National People's Party) - a right-wing nationalist-conservative party, with authoritarian, monarchist, and racist elements. It is supported by the former aristocracy, rural landowners, and conservative Lutherans.\"]},{\"type\":\"paragraph\",\"content\":[\"Current relations: \",{\"type\":\"insert\",\"insert\":5},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"KPD\"},\" - \",{\"type\":\"emphasis-1\",\"content\":\"Kommunistische Partei Deutschlands\"},\" (German Communist Party) - a radical left-wing offshoot of the SPD that emerged in the aftermath of the German Revolution of 1918, they follow the path of Moscow, opposing parliamentary democracy in favor of a Soviet-style revolution.\"]},{\"type\":\"paragraph\",\"content\":[\"Current relations: \",{\"type\":\"insert\",\"insert\":6},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"SAPD - Sozialistische Arbeiterpartei Deutschlands (Socialist Worker's Party of Germany) - a party recently formed in a split from the SPD, the SAPD is essentially an agglomeration of various left-wing splinter groups between the SPD and KPD. \",\"predicate\":7},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"NSDAP\"},\" - \",{\"type\":\"emphasis-1\",\"content\":\"Nationalsozialistische Deutsche Arbeiterpartei\"},\" - (National Socialist German Worker's Party, or Nazis) - a far-right nationalist and antisemitic party. Led by Adolf Hitler, they attempted a coup in 1923, and were banned for it, but have since been legalized.\"]},{\"type\":\"paragraph\",\"content\":[\"Current relations: \",{\"type\":\"insert\",\"insert\":8},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"Other parties\"},\" - there is a multitude of small, mostly conservative parties, such as the Economic Party of the German Middle Class, the Farmer's Party, the Agricultural League, and others. Their political position usually lies between the DVP and DNVP.\"]}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['year'] || 0) >= 1930) || (Q['chancellor'] == \\\"Brüning\\\"));\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['z_relation'] || 0);\"},\"qdisplay\":\"relationships\"},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['year'] || 0) >= 1930);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['ddp_relation'] || 0);\"},\"qdisplay\":\"relationships\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['dvp_relation'] || 0);\"},\"qdisplay\":\"relationships\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['dnvp_relation'] || 0);\"},\"qdisplay\":\"relationships\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['kpd_relation'] || 0);\"},\"qdisplay\":\"relationships\"},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['sapd_formed'] || 0)) !== 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['nsdap_relation'] || 0);\"},\"qdisplay\":\"relationships\"}]}},\"economic_policy.nationalize_deficit_1\":{\"id\":\"economic_policy.nationalize_deficit_1\",\"title\":\"Take a budget deficit to fund the nationalization program.\",\"chooseIf\":{\"$code\":\"return (((Q['left_strength'] || 0) > ((Q['reformist_strength'] || 0) + (Q['center_strength'] || 0))) || ((Q['woytinsky_advisor'] || 0) == 1));\"},\"subtitle\":{\"content\":{\"type\":\"conditional\",\"content\":\"Woytinsky can bring us around to supporting a budget deficit.\",\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['woytinsky_advisor'] || 0)) !== 0);\"}}]},\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":\"The party does not yet support budget deficits for this purpose. \",\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"Perhaps bringing on an advisor might help make this action palatable?\",\"predicate\":1}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['left_strength'] || 0) <= ((Q['reformist_strength'] || 0) + (Q['center_strength'] || 0)));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (!(((Q['woytinsky_advisor'] || 0)) !== 0));\"}}]},\"onArrival\":[{\"$code\":\"Q['nationalization_progress'] = (Q['nationalization_progress'] || 0) + 1;\\nQ['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) + 3;\\n if (((Q['unemployed'] || 0) >= 6) ) { Q['unemployed'] = (Q['unemployed'] || 0) - 3; } \\n if (((Q['works_councils'] || 0) >= 3) ) { Q['unemployed'] = (Q['unemployed'] || 0) - 1.2; } \\nQ['budget'] = (Q['budget'] || 0) - (Q['nationalize_budget'] || 0);\\nQ['works_program'] = (Q['works_program'] || 0) + 1;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (8 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 2;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 6;\\nQ['z_relation'] = (Q['z_relation'] || 0) - 4;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) - 3;\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) - 3;\\nQ['economy_goal_completed'] = (Q['economy_goal_completed'] || 0) + 1;\\nQ['inflation'] = (Q['inflation'] || 0) + 3;\"}],\"achievement\":\"wirtschaftspolitik\",\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"Most of the party, even on the left, are opposed to budget deficits for any purpose, with the exception of Wladimir Woytinsky. While he did not originally support the left's \\\"transformational\\\" plan, he has come around, and has persuaded the party and the Finance Ministry to support budget deficits in limited cases, for the purpose of exiting from the depression. \",\"predicate\":0},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"We have begun purchasing idling enterprises from the capitalists\",{\"type\":\"conditional\",\"content\":\", and running them in coordination with empowered works councils \",\"predicate\":2},\". By keeping production going, we can stave off the rising unemployment. \"],\"predicate\":1},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"The Left argues that this should only be a first step in the socialist transformation of the economy. Eventually, much of the economy must be brought under popular control. \",\"predicate\":3},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":\"We purchase additional underutilized enterprises and run them in a coordinated socialist fashion with the works councils, hiring formerly laid off workers. A significant portion of the economy is now under public control.\",\"predicate\":4}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['woytinsky_advisor'] || 0)) !== 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['nationalization_progress'] || 0) == 1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['works_councils'] || 0) >= 1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['nationalization_progress'] || 0) == 1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['nationalization_progress'] || 0) > 1);\"}}]}},\"domestic_enemies.persecute_rfb\":{\"id\":\"domestic_enemies.persecute_rfb\",\"title\":\"Further persecute the RFB.\",\"viewIf\":{\"$code\":\"return ((Q['rfb_banned'] || 0)===1);\"},\"onArrival\":[{\"$code\":\"Q['rfb_strength'] = (Q['rfb_strength'] || 0) * 0.7;\\nQ['rfb_militancy'] = (Q['rfb_militancy'] || 0) - 0.05;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) - 10;\\nQ['kpd_coalition_dissent'] = (Q['kpd_coalition_dissent'] || 0) + 1;\\nQ['z_relation'] = (Q['z_relation'] || 0) + 5;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) + 5;\\nQ['prussian_police_loyalty'] = (Q['prussian_police_loyalty'] || 0) + 0.1;\\nQ['interior_police_loyalty'] = (Q['interior_police_loyalty'] || 0) + 0.1;\\n if (((Q['coalition_dissent'] || 0) > 0) ) { Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) - 1; }\"}],\"content\":{\"content\":\"We have arrested more of the RFB's leaders and confiscated their weapons.\",\"type\":\"paragraph\"}},\"domestic_enemies\":{\"id\":\"domestic_enemies\",\"type\":\"scene\",\"title\":\"Investigating Domestic Enemies\",\"onArrival\":[{\"$code\":\"Q['month_actions'] = (Q['month_actions'] || 0) + 1;\"}],\"viewIf\":{\"$code\":\"return (((Q['spd_in_government'] || 0)===1) && (Q['interior_minister_party'] == \\\"SPD\\\"));\"},\"options\":[{\"id\":\"@deport_hitler\"},{\"id\":\"@domestic_enemies.ban_sa\",\"title\":\"Ban the SA.\"},{\"id\":\"@domestic_enemies.unban_sa\",\"title\":\"Unban the SA.\"},{\"id\":\"@domestic_enemies.persecute_sa\"},{\"id\":\"@domestic_enemies.ban_sh\",\"title\":\"Ban the Stahlhelm.\"},{\"id\":\"@domestic_enemies.unban_sh\",\"title\":\"Unban the Stahlhelm.\"},{\"id\":\"@domestic_enemies.persecute_sh\"},{\"id\":\"@domestic_enemies.ban_rfb\",\"title\":\"Ban the Communist RFB.\"},{\"id\":\"@domestic_enemies.unban_rfb\",\"title\":\"Unban the RFB.\"},{\"id\":\"@domestic_enemies.persecute_rfb\"},{\"id\":\"@root\",\"title\":\"Take no action for now.\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Investigating Domestic Enemies\"},{\"type\":\"paragraph\",\"content\":\"As we have control over the Interior Ministry, we can direct police and intelligence services to investigate internal enemies. We can proscribe various organizations.\"}]},\"foreign_policy.wittorf\":{\"id\":\"foreign_policy.wittorf\",\"viewIf\":{\"$code\":\"return ((((Q['wittorf_secret'] || 0)===1) && ((((((Q['year'] || 0)===1929) && ((Q['month'] || 0) < 6))) || ((Q['year'] || 0)===1928)))) && ((Q['wittorf_soviet_union'] || 0)===0));\"},\"unavailableSubtitle\":\"It is impossible that Stalin and the Comintern could be moved on their policy.\",\"onArrival\":[{\"$code\":\"Q['wittorf_soviet_union'] = 1;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) + (6 * (1 - (Q['dissent'] || 0)));\\nQ['kpd_foreign_seen'] = 1;\"}],\"maxVisits\":1,\"content\":{\"content\":\"Of course Stalin and the various leaders of the Comintern know about the Wittorf Affair, but they do not seem to know that we know as well. The Comintern was planning to build a narrative around the affair that absolves Thälmann, but perhaps now they will be less inclined to defend him.\",\"type\":\"paragraph\"},\"countVisitsMax\":1},\"fiscal_policy.lower_tariffs\":{\"id\":\"fiscal_policy.lower_tariffs\",\"title\":\"Lower tariffs on imports.\",\"chooseIf\":{\"$code\":\"return ((Q['budget'] || 0) >= 2);\"},\"subtitle\":\"-2 budget.\",\"onArrival\":[{\"$code\":\"Q['tariffs'] = (Q['tariffs'] || 0) - 1;\\nQ['budget'] = (Q['budget'] || 0) - 2;\\nQ['inflation'] = (Q['inflation'] || 0) - 0.5;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\nQ['rural_spd'] = (Q['rural_spd'] || 0) - 5;\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) - 3;\\nQ['west_relation'] = (Q['west_relation'] || 0) + 1;\\nQ['east_relation'] = (Q['east_relation'] || 0) + 1;\\n if (((Q['eu_progress'] || 0) > 0) ) { Q['eu_progress'] = (Q['eu_progress'] || 0) + 1; }\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"Lowering tariffs helps workers and the urban poor by reducing prices for basic necessities. In addition, other countries are pleased by lower tariffs, and are more willing to negotiate on many issues.\"},{\"type\":\"paragraph\",\"content\":\"Farmers are hurt by this policy, as cheap imported grain leads to ruin for some small producers. In general, cheap imports are detrimental for small-scale industries aimed at the domestic market.\"}]},\"fiscal_policy\":{\"id\":\"fiscal_policy\",\"type\":\"scene\",\"title\":\"Fiscal Policy\",\"newPage\":true,\"isCard\":true,\"tags\":[\"govt_affairs\"],\"onArrival\":[{\"$code\":\"Q['fiscal_policy_timer'] = (Q['fiscal_policy_timer'] || 0) + 6;\\nQ['month_actions'] = (Q['month_actions'] || 0) + 1;\"}],\"viewIf\":{\"$code\":\"return ((((Q['spd_in_government'] || 0)===1) && (Q['finance_minister_party'] == \\\"SPD\\\")) && ((Q['fiscal_policy_timer'] || 0)===0));\"},\"cardImage\":\"img/portraits/HilferdingRudolf.jpg\",\"goTo\":[{\"id\":\"fiscal_policy.fiscal_menu\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Fiscal Policy\"},{\"type\":\"paragraph\",\"content\":\"Fiscal policy involves issues of taxation and budget.\"}]},\"prussian_affairs.unban_rfb\":{\"id\":\"prussian_affairs.unban_rfb\",\"viewIf\":{\"$code\":\"return ((Q['rfb_banned'] || 0)===1);\"},\"onArrival\":[{\"$code\":\"Q['rfb_banned'] = 0;\\nQ['rfb_strength'] = (Q['rfb_strength'] || 0) + 50;\\nQ['prussian_police_loyalty'] = (Q['prussian_police_loyalty'] || 0) - 0.1;\"}],\"content\":{\"content\":\"The Communist RFB is no longer banned.\",\"type\":\"paragraph\"}},\"civil_war.long_war\":{\"id\":\"civil_war.long_war\",\"goTo\":[{\"id\":\"civil_war.long_war_intervention\",\"predicate\":{\"$code\":\"return ((Q['resist_coup'] || 0) == 0);\"}},{\"id\":\"civil_war.game_over_menu\",\"predicate\":{\"$code\":\"return ((Q['resist_coup'] || 0) == 1);\"}}],\"content\":[{\"type\":\"heading\",\"content\":\"Long War\"},{\"type\":\"paragraph\",\"content\":\"The initial phase of the action ends, and somehow, both sides remain standing.\"},{\"type\":\"paragraph\",\"content\":\"The war settles into fixed battle lines. This will not be a quick coup, but a long civil war. The nation will destroy itself before it can be rebuilt again.\"}]},\"election_1928.popular_front_braun\":{\"id\":\"election_1928.popular_front_braun\",\"title\":\"Use pressure from President Braun to force the parties to cooperate.\",\"viewIf\":{\"$code\":\"return (Q['president'] == \\\"Braun\\\");\"},\"goTo\":[{\"id\":\"election_1928.popular_front_success\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"kpd_policy.finance_oppose\":{\"id\":\"kpd_policy.finance_oppose\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"march_on_berlin.fight_2_pre_civil_war\":{\"id\":\"march_on_berlin.fight_2_pre_civil_war\",\"options\":[{\"id\":\"@civil_war\",\"title\":\"It is a civil war.\"}],\"content\":{\"content\":\"Our forces confront the fascists on the streets of Berlin, and armed fighting erupts. Neither side is dislodged from their positions.\",\"type\":\"paragraph\"}},\"constitutional_reform.as_is\":{\"id\":\"constitutional_reform.as_is\",\"goTo\":[{\"id\":\"root\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"constitutional_reform\":{\"id\":\"constitutional_reform\",\"type\":\"scene\",\"title\":\"Constitutional Reform\",\"newPage\":true,\"isCard\":true,\"viewIf\":{\"$code\":\"return ((((((((Q['spd_in_government'] || 0)===1) && (Q['justice_minister_party'] == \\\"SPD\\\")) && ((Q['constitutional_reform_timer'] || 0)===0)) && ((Q['judicial_reform'] || 0) >= 4)) && (((Q['neorevisionism'] || 0)) !== 0)) && ((((((((Q['in_weimar_coalition'] || 0)) !== 0)) || ((((Q['in_spd_majority'] || 0)) !== 0))) || ((((Q['in_left_front'] || 0)) !== 0))) || ((((Q['in_popular_front'] || 0)) !== 0))))) && ((Q['constitutional_reform'] || 0) < 3));\"},\"frequency\":25,\"onArrival\":[{\"$code\":\"Q['month_actions'] = (Q['month_actions'] || 0) + 1;\\nQ['constitutional_reform_timer'] = 12;\\nQ['pass_threshold'] = 0.51;\\n if (((Q['pro_republic'] || 0) < 65) ) { Q['pass_threshold'] = 0.6; }\"}],\"cardImage\":\"img/portraits/RadbruchGustav.jpg\",\"goTo\":[{\"id\":\"constitutional_reform.reforms_menu\"}],\"tags\":[\"govt_affairs\"],\"content\":[{\"type\":\"heading\",\"content\":\"Constitutional Reform\"},{\"type\":\"paragraph\",\"content\":\"Many neorevisionists consider the Weimar Constitution to be inadequate. They believe that the clauses of the constitution are in part responsible for the instability of the country, and must change in order to build a more stable democratic republic. Ideas from both socialists and liberals\"},{\"type\":\"paragraph\",\"content\":\"A constitutional reform requires either a two-thirds supermajority in the Reichstag, or a constitutional referendum with support from a majority of the electorate. If we do not have a supermajority in the Reichstag, we must be assured of strong support from the other parties for the constitutional referendum.\"}]},\"presidential_election_1932.z_partial\":{\"id\":\"presidential_election_1932.z_partial\",\"options\":[{\"id\":\"@presidential_election_1932.pay_z\",\"title\":\"Give them the resources they need.\"},{\"id\":\"@presidential_election_1932.braun_campaign\",\"title\":\"Forget about the Center.\"}],\"content\":{\"content\":\"The Center are not satisfied with our arguments, but they are open to being convinced. They are willing to run a joint campaign if we front the resources.\",\"type\":\"paragraph\"}},\"vote_of_no_confidence.let_it_happen\":{\"id\":\"vote_of_no_confidence.let_it_happen\",\"call\":\"set_next_election_time\",\"onArrival\":[{\"$code\":\"Q['time_to_election'] = 3;\\nQ['spd_in_government'] = 0;\\nQ['in_grand_coalition'] = 0;\\nQ['in_weimar_coalition'] = 0;\\nQ['in_popular_front'] = 0;\\nQ['spd_toleration'] = 0;\\nQ['foreign_minister_party'] = \\\"DVP\\\";\\nQ['interior_minister_party'] = \\\"Z\\\";\\nQ['justice_minister_party'] = \\\"I\\\";\\nQ['labor_minister_party'] = \\\"Z\\\";\\nQ['reichswehr_minister_party'] = \\\"I\\\";\\nQ['economic_minister_party'] = \\\"DDP\\\";\\nQ['finance_minister_party'] = \\\"DVP\\\";\\nQ['agriculture_minister_party'] = \\\"Z\\\";\\nQ['labor_minister'] = \\\"Stegerwald\\\";\\nQ['interior_minister'] = \\\"Wirth\\\";\\nQ['finance_minister'] = \\\"Moldenhauer\\\";\\nQ['economic_minister'] = \\\"Curtius\\\";\\nQ['justice_minister'] = \\\"Koch-Weser\\\";\\nQ['foreign_minister'] = \\\"Stresemann\\\";\\nQ['agriculture_minister'] = \\\"Dietrich\\\";\\nQ['reichswehr_minister'] = \\\"Groener\\\";\\nQ['coalition_dissent'] = 0;\\nQ['pro_republic'] = (Q['pro_republic'] || 0) - 5;\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) - 3;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) - 2;\\n if (((Q['pro_republic'] || 0) < 50) ) { Q['workers_spd'] = (Q['workers_spd'] || 0) - 3; } \\n if (((Q['pro_republic'] || 0) < 40) ) { Q['workers_spd'] = (Q['workers_spd'] || 0) - 4; } \\n if (((Q['pro_republic'] || 0) < 50) ) { Q['old_middle_nsdap'] = (Q['old_middle_nsdap'] || 0) + 4; } \\n if (((Q['pro_republic'] || 0) < 50) ) { Q['new_middle_nsdap'] = (Q['new_middle_nsdap'] || 0) + 3; }\"}],\"goTo\":[{\"id\":\"vote_of_no_confidence.let_it_happen_hindenburg\",\"predicate\":{\"$code\":\"return (Q['president'] != \\\"Braun\\\");\"}},{\"id\":\"vote_of_no_confidence.let_it_happen_braun\",\"predicate\":{\"$code\":\"return (Q['president'] == \\\"Braun\\\");\"}}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"confronting_nazis.all\":{\"id\":\"confronting_nazis.all\",\"goTo\":[{\"id\":\"confronting_nazis.if_end\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"crisis_program.support_moderate_progress\":{\"id\":\"crisis_program.support_moderate_progress\",\"content\":[{\"type\":\"paragraph\",\"content\":\"We attempt to convince the party to support a moderate program of job creation without deficit spending. Advocates of the moderate plan argue that this plan is most likely to receive support from the bourgeois parties, and most practical in the immediate term. Opponents in the left and labor factions criticize the plan for being inadequate in its ambition.\"},{\"type\":\"paragraph\",\"content\":\"We have not yet adopted the plan. More work needs to be done.\"}]},\"inter_party_relationships.center_op\":{\"id\":\"inter_party_relationships.center_op\",\"onArrival\":[{\"$code\":\"Q['z_relation'] = (Q['z_relation'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\"}],\"content\":{\"content\":\"We are currently in opposition to the Center-led government, but that does not preclude the general building of feelings of good will.\",\"type\":\"paragraph\"}},\"party_disunity.expel_left\":{\"id\":\"party_disunity.expel_left\",\"title\":\"Expel the dissident leftists.\",\"viewIf\":{\"$code\":\"return ((Q['left_dissent'] || 0) > 30);\"},\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"peoples_party.campaign_catholics\":{\"id\":\"peoples_party.campaign_catholics\",\"title\":\"Campaign among political Catholics.\",\"onArrival\":[{\"$code\":\"Q['catholics_spd'] = (Q['catholics_spd'] || 0) + (7 * (1 - (Q['dissent'] || 0)));\"}],\"content\":{\"content\":\"Catholics have historically been tied to the Center Party, but there is no reason why our party cannot appeal to them. The Prussian Concordat in particular is a sign of our friendship with Catholicism.\",\"type\":\"paragraph\"}},\"rally.both_protect_win\":{\"id\":\"rally.both_protect_win\",\"goTo\":[{\"id\":\"rally.main_rally\"}],\"content\":{\"content\":\"The police and Reichsbanner have successfully protected our rally against the SA! Our meeting can go ahead as usual.\",\"type\":\"paragraph\"}},\"shuffle_leadership.remove_juchacz\":{\"id\":\"shuffle_leadership.remove_juchacz\",\"title\":\"Remove Juchacz\",\"viewIf\":{\"$code\":\"return ((Q['juchacz_advisor'] || 0)===1);\"},\"tags\":[\"remove_advisor\"],\"onArrival\":[{\"$code\":\"Q['juchacz_advisor'] = 0;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 5;\\nQ['n_advisors'] = (Q['n_advisors'] || 0) - 1;\"}],\"goTo\":[{\"id\":\"shuffle_leadership.rm_main\"}],\"content\":{\"content\":\"Juchacz has been removed as an advisor. The Reformist faction disapproves.\",\"type\":\"paragraph\"}},\"game_over.spd_victorious\":{\"id\":\"game_over.spd_victorious\",\"title\":\"SPD still in government\",\"viewIf\":{\"$code\":\"return (((((Q['spd_in_government'] || 0) == 1) && (Q['chancellor_party'] == \\\"SPD\\\")) && ((Q['total_defeat'] || 0) == 0)) && ((Q['long_war'] || 0) == 0));\"},\"tags\":[\"endings\"],\"goTo\":[{\"id\":\"game_over.eg_menu\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"The SPD is still in government, under Chancellor \",{\"type\":\"insert\",\"insert\":0},\". Given the circumstances, this is a substantial accomplishment.\"]},\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor'] || 0);\"}}]}},\"library.paramilitaries\":{\"id\":\"library.paramilitaries\",\"onArrival\":[{\"$code\":\"Q.rb_strength = Math.round(Q.rb_strength);\\nQ.sh_strength = Math.round(Q.sh_strength);\\nQ.sa_strength = Math.round(Q.sa_strength);\"}],\"goTo\":[{\"id\":\"library.menu\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"Paramilitary groups:\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"Reichsbanner Schwarz-Rot-Gold\"},\": The Reichsbanner is an organization affiliated with all of the democratic parties - the SPD, Z, and DDP, but primarily with the SPD. Historically, this has been an unarmed organization.\"]},{\"type\":\"paragraph\",\"content\":[\"Strength: \",{\"type\":\"insert\",\"insert\":0},\" thousand\"]},{\"type\":\"paragraph\",\"content\":[\"Militarization: \",{\"type\":\"insert\",\"insert\":1},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"Rotfrontkämpferbund (RFB)\"},\": The \\\"Red Front Fighter's League\\\" is associated with the KPD.\"]},{\"type\":\"paragraph\",\"content\":[\"Strength: \",{\"type\":\"insert\",\"insert\":2},\" thousand\"]},{\"type\":\"paragraph\",\"content\":[\"Militarization: \",{\"type\":\"insert\",\"insert\":3},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"Der Stahlhelm\"},\": A right-wing nationalist organization of primarily Great War veterans, descended from the \",{\"type\":\"emphasis-1\",\"content\":\"Freikorps\"},\" that emerged after the war. Associated with the DNVP.\"]},{\"type\":\"paragraph\",\"content\":[\"Strength: \",{\"type\":\"insert\",\"insert\":4},\" thousand\"]},{\"type\":\"paragraph\",\"content\":[\"Militarization: \",{\"type\":\"insert\",\"insert\":5},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"Sturmabteilung (SA)\"},\": This is the nazi paramilitary group.\"]},{\"type\":\"paragraph\",\"content\":[\"Strength: \",{\"type\":\"insert\",\"insert\":6},\" thousand\"]},{\"type\":\"paragraph\",\"content\":[\"Militarization: \",{\"type\":\"insert\",\"insert\":7},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"Official military/paramilitary groups:\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"Reichswehr\"},\": \",{\"type\":\"insert\",\"insert\":8},\" thousand troops. This is Germany's military.\"]},{\"type\":\"paragraph\",\"content\":[\"Loyalty: \",{\"type\":\"insert\",\"insert\":9},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"Prussian police\"},\": \",{\"type\":\"insert\",\"insert\":10},\" thousand members.\"]},{\"type\":\"paragraph\",\"content\":[\"Loyalty: \",{\"type\":\"insert\",\"insert\":11}]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rb_strength'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rb_militancy'] || 0);\"},\"qdisplay\":\"militancy\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rfb_strength'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rfb_militancy'] || 0);\"},\"qdisplay\":\"militancy\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['sh_strength'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['sh_militancy'] || 0);\"},\"qdisplay\":\"militancy\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['sa_strength'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['sa_militancy'] || 0);\"},\"qdisplay\":\"militancy\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['reichswehr_strength'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['reichswehr_loyalty'] || 0);\"},\"qdisplay\":\"loyalty\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['prussian_police_strength'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['prussian_police_loyalty'] || 0);\"},\"qdisplay\":\"loyalty\"}]}},\"economic_policy.nationalize_without_compensation\":{\"id\":\"economic_policy.nationalize_without_compensation\",\"title\":\"Nationalize without compensation.\",\"subtitle\":\"There is no reason why we should not simply take over idle factories. This is likely to provoke a confrontation with the capitalists.\",\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":\"The bulk of the party does not support this quasi-legal action. \",\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"The judiciary would oppose this action.\",\"predicate\":1}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['left_strength'] || 0) <= ((Q['reformist_strength'] || 0) + (Q['center_strength'] || 0)));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['judicial_reform'] || 0) < 3);\"}}]},\"chooseIf\":{\"$code\":\"return (((Q['left_strength'] || 0) > ((Q['reformist_strength'] || 0) + (Q['center_strength'] || 0))) && ((Q['judicial_reform'] || 0) >= 3));\"},\"onArrival\":[{\"$code\":\"Q['nationalization_progress'] = (Q['nationalization_progress'] || 0) + 1;\\nQ['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) + 7;\\nQ['coup_progress'] = (Q['coup_progress'] || 0) + 3;\\n if (((Q['unemployed'] || 0) >= 6) ) { Q['unemployed'] = (Q['unemployed'] || 0) - 2.5; } \\n if ((((Q['works_councils'] || 0) >= 3) && ((Q['unemployed'] || 0) >= 3)) ) { Q['unemployed'] = (Q['unemployed'] || 0) - 1.2; } \\nQ['works_program'] = (Q['works_program'] || 0) + 1;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (8 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (6 * (1 - (Q['dissent'] || 0)));\\nQ['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 2;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 10;\\nQ['z_relation'] = (Q['z_relation'] || 0) - 8;\\nQ['ddp_relation'] = (Q['ddp_relation'] || 0) - 8;\\nQ['left_strength'] = (Q['left_strength'] || 0) + 15;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 10;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) - 10;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) - 5;\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) - 8;\\nQ['economy_goal_completed'] = (Q['economy_goal_completed'] || 0) + 1;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['inflation'] = (Q['inflation'] || 0) + 4;\"}],\"achievement\":\"wirtschaftspolitik\",\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"The capitalists are, predictably, up in arms about our policy of nationalization without compensation. They call it illegal expropriation, and it is. Nevertheless, it is clear that they have failed by keeping their factories idle, and we must take radical action.\"},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"We have begun acquiring idling enterprises from the capitalists\",{\"type\":\"conditional\",\"content\":\", and running them in coordination with empowered works councils \",\"predicate\":1},\". By keeping production going, we can stave off the rising unemployment. \"],\"predicate\":0},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":\"We acquired additional underutilized enterprises and run them in a coordinated socialist fashion with the works councils, hiring formerly laid off workers. A significant portion of the economy is now under public control.\",\"predicate\":2}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['nationalization_progress'] || 0) == 1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['works_councils'] || 0) >= 1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['nationalization_progress'] || 0) > 1);\"}}]}},\"foreign_policy.customs_union\":{\"id\":\"foreign_policy.customs_union\",\"title\":\"Form a customs union with Austria?\",\"subtitle\":\"This will likely incur the wrath of France.\",\"unavailableSubtitle\":\"This is superseded by the European Union.\",\"chooseIf\":{\"$code\":\"return ((Q['eu'] || 0)===0);\"},\"viewIf\":{\"$code\":\"return (((Q['black_thursday_seen'] || 0)===1) && ((Q['customs_union'] || 0)===0));\"},\"options\":[{\"id\":\"@foreign_policy.customs_union_2\",\"title\":\"Yes, do it!\"},{\"id\":\"@foreign_policy.fp_menu\",\"title\":\"No, we should do something else.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"The right has long desired closer ties with Austria, with the eventual goal of the merger of the two German-speaking countries. A customs union with Austria is the first step towards this goal. Additionally, many believe that a union with Austria would improve our current economic circumstances.\"},{\"type\":\"paragraph\",\"content\":\"However, the Allies, especially France, are likely to object. This agreement would break the terms of the Versailles Treaty, and could lead to economic sanctions, further hurting our economy.\"}]},\"prussian_affairs.negotiate_concordat\":{\"id\":\"prussian_affairs.negotiate_concordat\",\"viewIf\":{\"$code\":\"return ((Q['prussian_concordat_progress'] || 0) < 1);\"},\"onArrival\":[{\"$code\":\"Q['prussian_concordat_progress'] = (Q['prussian_concordat_progress'] || 0) + 1;\\nQ['z_relation'] = (Q['z_relation'] || 0) + (2 * (1 - (Q['dissent'] || 0)));\"}],\"content\":{\"content\":\"We are making progress towards negotiating a concordat between Prussia and the Catholic church.\",\"type\":\"paragraph\"}},\"civil_war.game_over_menu\":{\"id\":\"civil_war.game_over_menu\",\"options\":[{\"id\":\"@game_over\"}],\"content\":{\"content\":\"While we might want to call for foreign assistance, the foreign powers see the \\\"Prussian Coup\\\" as a purely internal matter.\",\"type\":\"paragraph\"}},\"election_1928.great_popular_front\":{\"id\":\"election_1928.great_popular_front\",\"viewIf\":{\"$code\":\"return ((Q['z_party_leader'] == \\\"Joos\\\") && (Q['kpd_party_leader'] == \\\"Conciliators\\\"));\"},\"onArrival\":[{\"$code\":\"Q['spd_in_government'] = 1;\\nQ['in_popular_front'] = 1;\\nQ['chancellor'] = \\\"Breitscheid\\\";\\nQ['chancellor_party'] = \\\"SPD\\\";\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) + 10;\\nQ['coup_progress'] = (Q['coup_progress'] || 0) + 2;\\nQ['in_left_front'] = 0;\\nQ['in_weimar_coalition'] = 0;\\nQ['in_grand_coalition'] = 0;\\nQ['coalition_dissent'] = 0;\"}],\"achievement\":\"grosse_volksfront\",\"goTo\":[{\"id\":\"election_1928.popular_front_civil_war\",\"predicate\":{\"$code\":\"return ((Q['coup_progress'] || 0) >= 10);\"}},{\"id\":\"election_1928.popular_front_no_civil_war\",\"predicate\":{\"$code\":\"return ((Q['coup_progress'] || 0) < 10);\"}}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"Somehow, the coalition is successfully formed! The conciliatory leadership of the Center Party and KPD helped make the negotiations possible. We still need a chancellor; the only acceptable choice among the parties was Rudolf Breitscheid of the SPD, acceptable to the Center and KPD \",{\"type\":\"conditional\",\"content\":\"as well as President Hindenburg, albeit extremely reluctantly \",\"predicate\":0},\".\"]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['president'] == \\\"Hindenburg\\\");\"}}]}},\"kpd_policy.foreign\":{\"id\":\"kpd_policy.foreign\",\"title\":\"Foreign Ministry\",\"subtitle\":\"The Foreign Ministry is aiding the Soviet Union.\",\"viewIf\":{\"$code\":\"return (Q['foreign_minister_party'] == \\\"KPD\\\");\"},\"options\":[{\"id\":\"@kpd_policy.foreign_support\",\"title\":\"Yes, we support aiding the Soviet Union.\"},{\"id\":\"@kpd_policy.foreign_oppose\",\"title\":\"No, this must be stopped.\"}],\"content\":{\"content\":\"The KPD-controlled Foreign Ministry is planning to send economic aid to the Soviet Union.\",\"type\":\"paragraph\"}},\"march_on_berlin.fight_constitution\":{\"id\":\"march_on_berlin.fight_constitution\",\"title\":\"This is unconstitutional! We will keep our positions in government, and ask the courts to keep us in power.\",\"chooseIf\":{\"$code\":\"return ((Q['judicial_reform'] || 0) >= 3);\"},\"unavailableSubtitle\":\"The judiciary would never agree with us.\",\"options\":[{\"id\":\"@march_on_berlin.new_elections\"},{\"id\":\"@march_on_berlin.fight\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"The courts agree that President \",{\"type\":\"insert\",\"insert\":0},\" is wrong to dismiss us, and that we should remin in the government. The President might respect the court's decision for now, but the fascists in the streets do not. They are still demanding snap elections or the resignation of the government, and will remain in the streets until we either meet their demands, or they are forced out.\"]},\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['president'] || 0);\"}}]}},\"presidential_election_1932.pay_z\":{\"id\":\"presidential_election_1932.pay_z\",\"chooseIf\":{\"$code\":\"return ((Q['resources'] || 0) >= 3);\"},\"subtitle\":\"-3 resources\",\"unavailableSubtitle\":\"Not enough resources (need 3)\",\"onArrival\":[{\"$code\":\"Q['resources'] = (Q['resources'] || 0) - 3;\\nQ['z_support_braun'] = 1;\"}],\"goTo\":[{\"id\":\"presidential_election_1932.braun_campaign\"}],\"content\":{\"content\":\"With our resources, the Center are convinced to support Braun over Hindenburg.\",\"type\":\"paragraph\"}},\"vote_of_no_confidence.let_it_happen_hindenburg\":{\"id\":\"vote_of_no_confidence.let_it_happen_hindenburg\",\"onArrival\":[{\"$code\":\"Q['chancellor'] = \\\"Brüning\\\";\\nQ['chancellor_party'] = \\\"Z\\\";\\nQ['welfare'] = (Q['welfare'] || 0) - 2;\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"The vote succeeds, and our government has resigned. Chancellor Brüning has been appointed as the head of an acting government, consisting solely of the bourgeois parties. He immediately proceeds to cut welfare spending substantially.\"},{\"type\":\"paragraph\",\"content\":[\"New elections have been set for \",{\"type\":\"insert\",\"insert\":0},\" \",{\"type\":\"insert\",\"insert\":1},\".\"]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_month'] || 0);\"},\"qdisplay\":\"month\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_year'] || 0);\"}}]}},\"confronting_nazis.if_end\":{\"id\":\"confronting_nazis.if_end\",\"content\":{\"content\":\"The Iron Front has given a new energy to our party.\",\"type\":\"paragraph\"}},\"confronting_nazis\":{\"id\":\"confronting_nazis\",\"type\":\"scene\",\"title\":\"Confronting the Nazis\",\"newPage\":true,\"isCard\":true,\"viewIf\":{\"$code\":\"return ((((((Q['nsdap_r'] || 0) >= 10) && ((Q['nazi_urgency'] || 0) > 1))) && ((Q['confronting_nazis_timer'] || 0) == 0)) && ((Q['iron_front_formed'] || 0) == 0));\"},\"onArrival\":[{\"$code\":\"Q['confronting_nazis_seen'] = (Q['confronting_nazis_seen'] || 0) + 1;\\nQ['confronting_nazis_timer'] = 5;\\nQ['month_actions'] = (Q['month_actions'] || 0) + 1;\"}],\"cardImage\":\"img/iron_front.png\",\"tags\":[\"party_affairs\",\"antifascism\"],\"options\":[{\"id\":\"@confronting_nazis.not_a_big_deal\",\"title\":\"The Nazis' moment will pass. Let's not get too hasty.\"},{\"id\":\"@confronting_nazis.economic_crisis\"},{\"id\":\"@confronting_nazis.major_crisis\",\"title\":\"We must do something to confront the Nazis.\"},{\"id\":\"@confronting_nazis.iron_front\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"The Nazis' strength is gaining, as shown by their recent election results and their violent presence in the streets. Their fascism threatens to plunge Germany once again into the abyss.\"},{\"type\":\"paragraph\",\"content\":\"Many in our party are calling for urgent action. The \\\"neorevisionist\\\" faction, led by young socialists like Carlo Mierendorff and Julius Leber, have formed specifically around this cause. But many in all factions of the party are calling for action.\"}]},\"crisis_program.adopt_moderate\":{\"id\":\"crisis_program.adopt_moderate\",\"onArrival\":[{\"$code\":\"Q['reformst_strength'] = (Q['reformst_strength'] || 0) + 10;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) - 10;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 8;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) + 6;\\nQ['moderate_plan_adopted'] = 1;\\nQ['economic_plan'] = 2;\\n if (((Q['unemployed'] || 0) > 15) ) { Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) - 1; } \\nQ['z_relation'] = (Q['z_relation'] || 0) + 5;\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"With our hard work, we have convinced the majority of the party to adopt the moderate job creation plan! \",{\"type\":\"conditional\",\"content\":\"We can begin implementing the plan as soon as possible, as long as we have the Economic or Finance ministries.\",\"predicate\":0}]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['spd_in_government'] || 0) == 1);\"}}]}},\"inter_party_relationships.center_coalition\":{\"id\":\"inter_party_relationships.center_coalition\",\"onArrival\":[{\"$code\":\"Q['z_relation'] = (Q['z_relation'] || 0) + (8 * (1 - (Q['dissent'] || 0)));\"}],\"content\":{\"content\":\"We are currently coalition partners with them, so improving relations comes naturally.\",\"type\":\"paragraph\"}},\"party_disunity.expel_center\":{\"id\":\"party_disunity.expel_center\",\"title\":\"Expel the centrists.\",\"viewIf\":{\"$code\":\"return ((Q['center_dissent'] || 0) > 30);\"},\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"peoples_party.no_new_ideas\":{\"id\":\"peoples_party.no_new_ideas\",\"onArrival\":[{\"$code\":\"Q['neorevisionist_strength'] = (Q['neorevisionist_strength'] || 0) - 6;\\nQ['neorevisionist_dissent'] = (Q['neorevisionist_dissent'] || 0) + 5;\\nQ['center_strength'] = (Q['center_strength'] || 0) + 8;\\nQ['left_strength'] = (Q['left_strength'] || 0) + 3;\\nQ['peoples_party'] = 0;\\nQ['peoples_party_support'] = (Q['peoples_party_support'] || 0) - 3;\"}],\"content\":{\"content\":\"The Social Democrats have been and will always be a party of the working class.\",\"type\":\"paragraph\"}},\"peoples_party\":{\"id\":\"peoples_party\",\"type\":\"scene\",\"title\":\"Building a People's Party\",\"newPage\":true,\"isCard\":true,\"cardImage\":\"img/poster_0.jpg\",\"viewIf\":{\"$code\":\"return (((((Q['neorevisionism'] || 0) > 0) && ((Q['peoples_party_support'] || 0) >= 3)) && ((Q['peoples_party'] || 0)===0)) && ((Q['peoples_party_timer'] || 0) == 0));\"},\"onArrival\":[{\"$code\":\"Q['peoples_party_timer'] = 6;\"}],\"tags\":[\"party_affairs\"],\"maxVisits\":4,\"options\":[{\"id\":\"@peoples_party.support_peoples_party\",\"title\":\"Yes, we must become a people's party!\"},{\"id\":\"@peoples_party.build_support\",\"title\":\"We must build additional support before becoming a people's party.\"},{\"id\":\"@peoples_party.support_peoples_party_hard\",\"title\":\"Despite strong opposition from the Center and Left factions, we will become a people's party.\"},{\"id\":\"@peoples_party.no_new_ideas\",\"title\":\"No, we will always be a party of the working class.\"},{\"id\":\"@root\",\"title\":\"Perhaps we can discuss this at a later time.\"},{\"id\":\"@easy_discard\"},{\"id\":\"@cancel_advisor_action\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Building a People's Party\"},{\"type\":\"paragraph\",\"content\":\"Contrary to orthodox Marxist predictions, the industrial proletariat is not constantly increasing in size. The rapid growth of the \\\"new middle class\\\" of white-collar workers and the persistence of small farmers and the peasantry confound predictions of a working-class majority.\"},{\"type\":\"paragraph\",\"content\":\"In order to build a socialist majority, many reformists and neorevisionists are calling for our party to move beyond the urban working class, to embrace the concerns of the middle class, farmers, and women of all classes. We can create a new and inclusive vision of the party that encompasses all people who work for a living, which is almost everyone in the country save the aristocrats and top capitalists.\"}],\"countVisitsMax\":4},\"rally.both_protect_lose\":{\"id\":\"rally.both_protect_lose\",\"onArrival\":[{\"$code\":\"Q['workers_nsdap'] = (Q['workers_nsdap'] || 0) + 3;\\nQ['rb_strength'] = (Q['rb_strength'] || 0) - 50;\"}],\"content\":{\"content\":\"Unfortunately, the police and Reichsbanner were not able to hold back the SA mob. The Nazis have won this show of strength.\",\"type\":\"paragraph\"}},\"shuffle_leadership.remove_pfulf\":{\"id\":\"shuffle_leadership.remove_pfulf\",\"title\":\"Remove Pfülf\",\"viewIf\":{\"$code\":\"return ((Q['pfulf_advisor'] || 0)===1);\"},\"tags\":[\"remove_advisor\"],\"onArrival\":[{\"$code\":\"Q['pfulf_advisor'] = 0;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 5;\\nQ['n_advisors'] = (Q['n_advisors'] || 0) - 1;\"}],\"goTo\":[{\"id\":\"shuffle_leadership.rm_main\"}],\"content\":{\"content\":\"Pfülf has been removed as an advisor. The Reformist faction disapproves.\",\"type\":\"paragraph\"}},\"game_over.communist_victory\":{\"id\":\"game_over.communist_victory\",\"title\":\"Communist victory\",\"viewIf\":{\"$code\":\"return ((((Q['chancellor_party'] == \\\"KPD\\\") || (Q['president'] == \\\"Thälmann\\\")) && ((Q['total_defeat'] || 0) == 0)) && ((Q['long_war'] || 0) == 0));\"},\"tags\":[\"endings\"],\"goTo\":[{\"id\":\"game_over.eg_menu\"}],\"content\":{\"content\":\"The KPD has won power in Germany, with our assistance. They will try to remake Germany in the Soviet image. How much they succeed is yet to be determined.\",\"type\":\"paragraph\"}},\"library.factions\":{\"id\":\"library.factions\",\"goTo\":[{\"id\":\"library.neorevisionists\",\"predicate\":{\"$code\":\"return ((Q['neorevisionism'] || 0) > 0);\"}},{\"id\":\"library.menu\",\"predicate\":{\"$code\":\"return ((Q['neorevisionism'] || 0) <= 0);\"}}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"Internal factions of the SPD\"},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Overall dissent: \",{\"type\":\"insert\",\"insert\":0},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"Left\"},\"\"]},{\"type\":\"paragraph\",\"content\":\"Many leftists are former members of the USPD (the left-wing, anti-war Independent Social Democratic Party), or are young radicals. Many are interested in closer cooperation with the KPD, and some support extraparliamentary action.\"},{\"type\":\"paragraph\",\"content\":[\"Strength: \",{\"type\":\"insert\",\"insert\":1},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Dissent: \",{\"type\":\"insert\",\"insert\":2},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"Centrists\"},\"\"]},{\"type\":\"paragraph\",\"content\":\"Centrists in the SPD are followers of the doctrine of orthodox Marxism as expounded by Karl Kautsky and later Rudolf Hilferding. They seek a middle course between reform and revolution, while defending the democratic state.\"},{\"type\":\"paragraph\",\"content\":[\"Strength: \",{\"type\":\"insert\",\"insert\":3},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Dissent: \",{\"type\":\"insert\",\"insert\":4},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"Labor\"},\"\"]},{\"type\":\"paragraph\",\"content\":\"Many SPD members are also part of the ADGB, the federation of free trade unions. Their goal is economic reform and benefits for organized workers.\"},{\"type\":\"paragraph\",\"content\":[\"Strength: \",{\"type\":\"insert\",\"insert\":5},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Dissent: \",{\"type\":\"insert\",\"insert\":6},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"Reformists\"},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Reformists are pragmatic participants in government, and seek to expand the welfare state and defend democracy against the far right and left. \",{\"type\":\"conditional\",\"content\":\"They are dominant in the state government of Prussia. \",\"predicate\":7},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Strength: \",{\"type\":\"insert\",\"insert\":8},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Dissent: \",{\"type\":\"insert\",\"insert\":9}]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['dissent_percent'] || 0);\"},\"qdisplay\":\"dissent\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['left_strength'] || 0);\"},\"qdisplay\":\"strength\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['left_dissent'] || 0);\"},\"qdisplay\":\"dissent\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['center_strength'] || 0);\"},\"qdisplay\":\"strength\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['center_dissent'] || 0);\"},\"qdisplay\":\"dissent\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['labor_strength'] || 0);\"},\"qdisplay\":\"strength\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['labor_dissent'] || 0);\"},\"qdisplay\":\"dissent\"},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['spd_prussia'] || 0)) !== 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['reformist_strength'] || 0);\"},\"qdisplay\":\"strength\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['reformist_dissent'] || 0);\"},\"qdisplay\":\"dissent\"}]}},\"economic_policy.empower_workers\":{\"id\":\"economic_policy.empower_workers\",\"title\":\"Empower workers to take over factories.\",\"subtitle\":\"We can promise to legalize factory occupations, giving the factories over to worker unions. This is highly confrontational, and would likely provoke a reaction from right-wing militants as well as capitalists.\",\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":\"The bulk of the party does not support this radical action. \",\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"The judiciary would oppose this action. \",\"predicate\":1},\" \",{\"type\":\"conditional\",\"content\":\"If we increased the strength of our paramilitary forces, perhaps we could do this. \",\"predicate\":2},\" \",{\"type\":\"conditional\",\"content\":\"We need the support of the works councils first.\",\"predicate\":3}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['left_strength'] || 0) <= ((Q['reformist_strength'] || 0) + (Q['neorevisionist_strength'] || 0)));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['judicial_reform'] || 0) < 3);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['rb_militancy'] || 0) < 0.25);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['works_councils'] || 0) < 1);\"}}]},\"chooseIf\":{\"$code\":\"return ((((Q['left_strength'] || 0) > ((Q['reformist_strength'] || 0) + (Q['neorevisionist_strength'] || 0))) && ((((Q['judicial_reform'] || 0) >= 3) || ((Q['rb_militancy'] || 0) >= 0.25)))) && ((Q['works_councils'] || 0) >= 1));\"},\"onArrival\":[{\"$code\":\"Q['nationalization_progress'] = (Q['nationalization_progress'] || 0) + 1;\\nQ['capital_strike_progress'] = (Q['capital_strike_progress'] || 0) + 6;\\nQ['coup_progress'] = (Q['coup_progress'] || 0) + 5;\\n if (((Q['unemployed'] || 0) >= 6) ) { Q['unemployed'] = (Q['unemployed'] || 0) - 3; } \\n if ((((Q['works_councils'] || 0) >= 3) && ((Q['unemployed'] || 0) > 4)) ) { Q['unemployed'] = (Q['unemployed'] || 0) - 1.5; } \\nQ['works_program'] = (Q['works_program'] || 0) + 1;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (10 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (10 * (1 - (Q['dissent'] || 0)));\\nQ['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 2;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) - 10;\\nQ['z_relation'] = (Q['z_relation'] || 0) - 8;\\nQ['ddp_relation'] = (Q['ddp_relation'] || 0) - 8;\\nQ['workers_nsdap'] = (Q['workers_nsdap'] || 0) - (5 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_nsdap'] = (Q['unemployed_nsdap'] || 0) - (5 * (1 - (Q['dissent'] || 0)));\\nQ['left_strength'] = (Q['left_strength'] || 0) + 15;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) + 10;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) - 10;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) - 5;\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) - 10;\\nQ['factory_takeovers'] = (Q['factory_takeovers'] || 0) + 1;\\nQ['economy_goal_completed'] = (Q['economy_goal_completed'] || 0) + 1;\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['inflation'] = (Q['inflation'] || 0) + 3;\"}],\"achievement\":\"wirtschaftspolitik\",\"content\":[{\"type\":\"paragraph\",\"content\":\"The capitalists are, predictably, up in arms about our policy of legalizing factory occupations. They call it illegal expropriation, and it is. Nevertheless, it is clear that they have failed, and we must take radical action.\"},{\"type\":\"paragraph\",\"content\":\"Fascists have been taking increasingly violent actions around the occupied factories, calling us thieves and looters. However, the some of the working-class supporters of the fascists have been peeled off, or at least the ones with a sense of class solidarity.\"}]},\"foreign_policy.customs_union_2\":{\"id\":\"foreign_policy.customs_union_2\",\"onArrival\":[{\"$code\":\"Q['banking_crisis_timer'] = 2;\\nQ['customs_union'] = 1;\\nQ['west_relation'] = (Q['west_relation'] || 0) - 2;\\nQ['east_relation'] = (Q['east_relation'] || 0) - 2;\\nQ['z_relation'] = (Q['z_relation'] || 0) + 6;\\nQ['dvp_relation'] = (Q['dvp_relation'] || 0) + 6;\\n if (((Q['coalition_dissent'] || 0) > 0) ) { Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) - 1; } \\nQ['coup_progress'] = (Q['coup_progress'] || 0) - 1;\"}],\"maxVisits\":1,\"content\":[{\"type\":\"paragraph\",\"content\":\"We have formed a customs union with Austria! The right-wing parties are praising us for this unexpected turn of events.\"},{\"type\":\"paragraph\",\"content\":\"Immediately, France and other neighboring countries lodge their protests. The longer-term response is yet to be seen.\"}],\"countVisitsMax\":1},\"prussian_affairs.sign_concordat\":{\"id\":\"prussian_affairs.sign_concordat\",\"viewIf\":{\"$code\":\"return (((Q['prussian_concordat_progress'] || 0) >= 1) && ((Q['prussian_concordat'] || 0)===0));\"},\"onArrival\":[{\"$code\":\"Q['prussian_concordat'] = 1;\\nQ['z_relation'] = (Q['z_relation'] || 0) + 5;\\nQ['catholics_spd'] = (Q['catholics_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\"}],\"content\":{\"content\":\"We have signed a Concordat between the Free State of Prussia and the Roman Catholic Church, guaranteeing religious freedom for Catholics in Prussia. This sets the stage for the negotiation of a national Concordat covering all of Germany.\",\"type\":\"paragraph\"}},\"prussian_affairs\":{\"id\":\"prussian_affairs\",\"type\":\"scene\",\"title\":\"The Prussian Bulwark\",\"newPage\":true,\"isCard\":true,\"viewIf\":{\"$code\":\"return (((Q['spd_prussia'] || 0)===1) && ((Q['prussian_affairs_timer'] || 0) <= 0));\"},\"onArrival\":[{\"$code\":\"Q['prussian_affairs_timer'] = (Q['prussian_affairs_timer'] || 0) + 6;\\nQ['month_actions'] = (Q['month_actions'] || 0) + 1;\"}],\"tags\":[\"govt_affairs\"],\"cardImage\":\"img/braun.jpg\",\"options\":[{\"id\":\"@prussian_affairs.police_loyalty\",\"title\":\"Bolster the loyalty of the police.\"},{\"id\":\"@prussian_affairs.police_strength\",\"title\":\"Recruit additional police.\"},{\"id\":\"@prussian_affairs.bureaucracy\",\"title\":\"Purge the bureaucracy of reactionary elements.\"},{\"id\":\"@prussian_affairs.ban_sa\",\"title\":\"Ban the SA, the Nazi paramilitary group.\"},{\"id\":\"@prussian_affairs.unban_sa\",\"title\":\"Reverse the SA ban.\"},{\"id\":\"@prussian_affairs.ban_rfb\",\"title\":\"Ban the RFB, the Communist paramilitary.\"},{\"id\":\"@prussian_affairs.unban_rfb\",\"title\":\"Reverse the RFB ban.\"},{\"id\":\"@prussian_affairs.ban_sh\",\"title\":\"Ban the Stahlhelm, the Nationalist paramilitary.\"},{\"id\":\"@prussian_affairs.unban_sh\",\"title\":\"Reverse the Stahlhelm ban.\"},{\"id\":\"@prussian_affairs.negotiate_concordat\",\"title\":\"Negotiate a concordat with the Vatican.\"},{\"id\":\"@prussian_affairs.sign_concordat\",\"title\":\"Sign a concordat with the Vatican.\"},{\"id\":\"@root\",\"title\":\"No new policies are needed.\"},{\"id\":\"@easy_discard\"},{\"id\":\"@cancel_advisor_action\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Prussian Affairs\"},{\"type\":\"paragraph\",\"content\":\"Prussia, by far the largest and most important state in Germany, is governed by our party, in a coalition with the Center and Democratic parties. It is the most stable and democratic state government in Germany, led by the able Otto Braun.\"},{\"type\":\"paragraph\",\"content\":\"We can enact policies in Prussia.\"}]},\"civil_war.long_war_intervention\":{\"id\":\"civil_war.long_war_intervention\",\"options\":[{\"id\":\"@civil_war.west_aid\",\"title\":\"Perhaps we can receive aid from the Western powers, France and Britain.\"},{\"id\":\"@civil_war.soviet_aid\",\"title\":\"Perhaps we can receive aid from the Soviet Union.\"},{\"id\":\"@civil_war.east_aid\",\"title\":\"Perhaps our eastern neighbors, Poland and Czechoslovakia, can help us. If they know anything, they do not want fascists coming to power in Germany.\"},{\"id\":\"@game_over\",\"title\":\"Game over.\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"election_1928.popular_front_success\":{\"id\":\"election_1928.popular_front_success\",\"onArrival\":[{\"$code\":\"Q['spd_in_government'] = 1;\\nQ['in_popular_front'] = 1;\\nQ['chancellor'] = \\\"Breitscheid\\\";\\nQ['chancellor_party'] = \\\"SPD\\\";\\nQ['kpd_relation'] = (Q['kpd_relation'] || 0) + 10;\\nQ['coup_progress'] = (Q['coup_progress'] || 0) + 2;\\nQ['in_left_front'] = 0;\\nQ['in_weimar_coalition'] = 0;\\nQ['in_grand_coalition'] = 0;\\nQ['coalition_dissent'] = 0;\"}],\"goTo\":[{\"id\":\"election_1928.popular_front_civil_war\",\"predicate\":{\"$code\":\"return ((Q['coup_progress'] || 0) >= 10);\"}},{\"id\":\"election_1928.popular_front_no_civil_war\",\"predicate\":{\"$code\":\"return ((Q['coup_progress'] || 0) < 10);\"}}],\"achievement\":\"volksfront\",\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"Somehow, surprisingly, the coalition is successfully formed! We still need a chancellor; the only acceptable choice among the parties was Rudolf Breitscheid of the SPD, acceptable to the Center and KPD \",{\"type\":\"conditional\",\"content\":\"as well as President Hindenburg, albeit extremely reluctantly \",\"predicate\":0},\".\"]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['president'] == \\\"Hindenburg\\\");\"}}]}},\"kpd_policy.foreign_support\":{\"id\":\"kpd_policy.foreign_support\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"march_on_berlin.new_elections\":{\"id\":\"march_on_berlin.new_elections\",\"title\":\"Call for new snap elections.\",\"subtitle\":\"We will not resign at gunpoint, and we will attempt to maintain the integrity of the elections.\",\"goTo\":[{\"id\":\"march_on_berlin.new_elections_braun\",\"predicate\":{\"$code\":\"return (Q['president'] == \\\"Braun\\\");\"}},{\"id\":\"march_on_berlin.new_elections_hindenburg\",\"predicate\":{\"$code\":\"return ((Q['president'] != \\\"Braun\\\") && ((Q['z_relation'] || 0) >= 40));\"}},{\"id\":\"march_on_berlin.new_elections_hindenburg_reject\",\"predicate\":{\"$code\":\"return ((Q['president'] != \\\"Braun\\\") && ((Q['z_relation'] || 0) < 40));\"}}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"presidential_election_1932.z_failed\":{\"id\":\"presidential_election_1932.z_failed\",\"goTo\":[{\"id\":\"presidential_election_1932.braun_campaign\"}],\"content\":{\"content\":\"Unfortunately, we fail to turn them away from Hindenburg.\",\"type\":\"paragraph\"}},\"vote_of_no_confidence.let_it_happen_braun\":{\"id\":\"vote_of_no_confidence.let_it_happen_braun\",\"onArrival\":[{\"$code\":\"Q['spd_caretaker'] = 1;\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[\"The vote succeeds, and our government has resigned. Chancellor \",{\"type\":\"insert\",\"insert\":0},\" remains as the head of a caretaker government, but no longer has the power to enact new policies.\"]},{\"type\":\"paragraph\",\"content\":[\"New elections have been set for \",{\"type\":\"insert\",\"insert\":1},\" \",{\"type\":\"insert\",\"insert\":2},\".\"]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_month'] || 0);\"},\"qdisplay\":\"month\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_year'] || 0);\"}}]}},\"vote_of_no_confidence\":{\"id\":\"vote_of_no_confidence\",\"type\":\"scene\",\"title\":\"The Right calls a vote of no confidence against the current government!\",\"subtitle\":\"We have angered our coalition partners too much...\",\"newPage\":true,\"onArrival\":[{\"$code\":\"Q['tried_supporting_kpd'] = 0;\"}],\"viewIf\":{\"$code\":\"return (((((Q['spd_in_government'] || 0)===1) && ((((((((Q['in_grand_coalition'] || 0)===1) || ((Q['in_popular_front'] || 0)===1)) || ((Q['in_minority_government'] || 0)===1))) && ((Q['coalition_dissent'] || 0) >= 3))) || ((((Q['in_weimar_coalition'] || 0)===1) && ((Q['coalition_dissent'] || 0) >= 4))))) && ((Q['spd_r'] || 0) < 50)) && (!(((Q['constructive_vonc'] || 0)) !== 0)));\"},\"tags\":[\"event\"],\"options\":[{\"id\":\"@vote_of_no_confidence.try_assuage\",\"title\":\"Try to assuage our partners.\"},{\"id\":\"@vote_of_no_confidence.support_kpd\",\"title\":\"Could we get the KPD to abstain?\"},{\"id\":\"@vote_of_no_confidence.let_it_happen\",\"title\":\"Let the vote happen.\"}],\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"Vote of No Confidence\"},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"The DVP \",\"predicate\":0},{\"type\":\"conditional\",\"content\":\"The Center Party \",\"predicate\":1},\" has called for a vote of no confidence against us, due to our various policies and disagreements. If this succeeds, there will be an election in a few months.\"]}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['in_grand_coalition'] || 0)) !== 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((((Q['in_weimar_coalition'] || 0)) !== 0) || (((Q['in_popular_front'] || 0)) !== 0)) || (((Q['in_minority_government'] || 0)) !== 0));\"}}]}},\"crisis_program.defer\":{\"id\":\"crisis_program.defer\",\"content\":{\"content\":\"We hold off on making a decision on economic policy, awaiting more information. Woytinsky and his supporters argue that inaction is a form of action of its own.\",\"type\":\"paragraph\"}},\"crisis_program\":{\"id\":\"crisis_program\",\"type\":\"scene\",\"title\":\"The Economic Crisis\",\"newPage\":true,\"isCard\":true,\"viewIf\":{\"$code\":\"return (((((Q['crisis_urgency'] || 0) >= 1) && ((Q['crisis_program_timer'] || 0)===0)) && ((Q['economic_plan'] || 0)===0)) && ((Q['black_thursday_seen'] || 0) == 1));\"},\"frequency\":200,\"onArrival\":[{\"$code\":\"Q['month_actions'] = (Q['month_actions'] || 0) + 1;\\nQ['crisis_program_timer'] = 5;\"}],\"cardImage\":\"img/bankrun.jpg\",\"tags\":[\"party_affairs\",\"govt_affairs\"],\"options\":[{\"id\":\"@crisis_program.support_centrist\",\"title\":\"Support the Centrist view.\"},{\"id\":\"@crisis_program.support_labor\",\"title\":\"Support the Labor view.\"},{\"id\":\"@crisis_program.support_left\",\"title\":\"Support the Left view.\"},{\"id\":\"@crisis_program.support_moderate\",\"title\":\"Support the Reformist view.\"},{\"id\":\"@crisis_program.defer\",\"title\":\"Defer making a decision until we have more information.\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Addressing the Economic Crisis\"},{\"type\":\"paragraph\",\"content\":\"Our party is wracked as to how to deal with the economic crisis. From the centrist faction, Hilferding argues that the economic crisis must be allowed to play out, because it is simply a part of the cyclic nature of capitalism.\"},{\"type\":\"paragraph\",\"content\":\"From labor, the economist Wladimir Woytinsky argues that we must pursue a massive public works program to reduce unemployment and stimulate demand, perhaps including deficit spending. His opponents, like Hilferding, argue that this plan will cause a return to hyper-inflation, and that it would not even help the economy. In addition, according to Hilferding, Woytinsky's strategy is opposed to Marxist principles.\"},{\"type\":\"paragraph\",\"content\":\"The so-called WTB plan, after its chief supporters Woytinsky, Tarnow, and Baade, is receiving more attention within the party.\"},{\"type\":\"paragraph\",\"content\":\"However, leftists in the party argue that the WTB plan is merely a bandage over the fundamental flaws of capitalism. They argue that the crisis is an opportunity to end capitalism through massive nationalizations of industry, and finally bring our country to socialism.\"},{\"type\":\"paragraph\",\"content\":\"Meanwhile, moderates and reformists draw up proposals for a limited plan of job creation through public works, funded through taxes, that does not involve deficit spending or large-scale restructuring of the economy. Labor argues that the plan is inadequate in its scale and ambition.\"}]},\"inter_party_relationships.center_bruning\":{\"id\":\"inter_party_relationships.center_bruning\",\"onArrival\":[{\"$code\":\"Q['z_relation'] = (Q['z_relation'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\"}],\"content\":{\"content\":\"The Brüning semi-autocratic regime makes building friendly relations difficult, but not impossible.\",\"type\":\"paragraph\"}},\"party_disunity.expel_labor\":{\"id\":\"party_disunity.expel_labor\",\"title\":\"Expel the labor supporters.\",\"viewIf\":{\"$code\":\"return ((Q['labor_dissent'] || 0) > 30);\"},\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"party_disunity\":{\"id\":\"party_disunity\",\"type\":\"scene\",\"title\":\"Party Disunity\",\"newPage\":true,\"isCard\":true,\"viewIf\":{\"$code\":\"return (((Q['party_disunity_timer'] || 0)===0) && ((((((((Q['dissent'] || 0) >= 0.3) || ((((Q['reformist_dissent'] || 0) > 30) && (!(((Q['reformists_resign'] || 0)) !== 0))))) || ((((Q['center_dissent'] || 0) > 30) && (!(((Q['centrists_resign'] || 0)) !== 0))))) || ((((Q['left_dissent'] || 0) > 30) && (!(((Q['sapd_formed'] || 0)) !== 0))))) || ((((Q['labor_dissent'] || 0) > 30) && (!(((Q['unions_independent'] || 0)) !== 0))))) || ((((Q['neorevisionist_dissent'] || 0) > 30) && (((Q['neorevisionism'] || 0)) !== 0))))));\"},\"onArrival\":[{\"$code\":\"Q['month_actions'] = (Q['month_actions'] || 0) + 1;\\nQ['party_disunity_timer'] = 4;\"}],\"cardImage\":\"img/Reichstagsfraktion_der_SPD.jpg\",\"frequency\":200,\"tags\":[\"party_affairs\"],\"options\":[{\"id\":\"@party_disunity.enforce_unity\"},{\"id\":\"@party_disunity.concessions_reformists\"},{\"id\":\"@party_disunity.concessions_center\"},{\"id\":\"@party_disunity.concessions_left\"},{\"id\":\"@party_disunity.concessions_labor\"},{\"id\":\"@party_disunity.concessions_neorevisionists\"},{\"id\":\"@party_disunity.do_nothing\"}],\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"Party Disunity\"},{\"type\":\"paragraph\",\"content\":\"The party is being torn apart by internal dissent. Upset at the leadership and general direction, factions have started sabotaging their rivals, hampering our efforts to win votes and carry out our policies.\"},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"The reformists are upset at our direction. \",\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"The centrists are displeased with the direction of our party. \",\"predicate\":1},\" \",{\"type\":\"conditional\",\"content\":\"The trade unions disagree with our present course of action. \",\"predicate\":2},\" \",{\"type\":\"conditional\",\"content\":\"Leftists are making noises about another party split. \",\"predicate\":3},\" \",{\"type\":\"conditional\",\"content\":\"Neorevisionists are in disagreement about our political direction. \",\"predicate\":4},\"\"]},{\"type\":\"paragraph\",\"content\":\"Something must be done to reinforce party unity.\"}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['reformist_dissent'] || 0) > 30);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['center_dissent'] || 0) > 30);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['labor_dissent'] || 0) > 30);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['left_dissent'] || 0) > 30);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['neorevisionist_dissent'] || 0) > 30) && ((Q['neorevisionism'] || 0)===1));\"}}]}},\"rally.cancel\":{\"id\":\"rally.cancel\",\"onArrival\":[{\"$code\":\"Q['workers_nsdap'] = (Q['workers_nsdap'] || 0) + 3;\"}],\"content\":{\"content\":\"The SA have won this show of strength.\",\"type\":\"paragraph\"}},\"shuffle_leadership.remove_leipart\":{\"id\":\"shuffle_leadership.remove_leipart\",\"title\":\"Remove Leipart\",\"viewIf\":{\"$code\":\"return ((Q['leipart_advisor'] || 0)===1);\"},\"tags\":[\"remove_advisor\"],\"onArrival\":[{\"$code\":\"Q['leipart_advisor'] = 0;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) + 5;\\nQ['n_advisors'] = (Q['n_advisors'] || 0) - 1;\"}],\"goTo\":[{\"id\":\"shuffle_leadership.rm_main\"}],\"content\":{\"content\":\"Leipart has been removed as an advisor. The Labor faction disapproves.\",\"type\":\"paragraph\"}},\"game_over.works_program\":{\"id\":\"game_over.works_program\",\"title\":\"Works program enacted!\",\"viewIf\":{\"$code\":\"return ((Q['works_program'] || 0) > 0);\"},\"tags\":[\"endings\"],\"goTo\":[{\"id\":\"game_over.eg_menu\"}],\"content\":{\"content\":\"Our government has enacted a public works program!\",\"type\":\"paragraph\"}},\"library.neorevisionists\":{\"id\":\"library.neorevisionists\",\"goTo\":[{\"id\":\"library.menu\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"emphasis-2\",\"content\":\"Neorevisionists\"},\"\"]},{\"type\":\"paragraph\",\"content\":\"Neorevisionists focus on defending the republic and expanding democracy, while also expanding the party's base beyond the working class to create a people's party. They support new propaganda methods and extraparliamentary action in defense of the republic.\"},{\"type\":\"paragraph\",\"content\":[\"Strength: \",{\"type\":\"insert\",\"insert\":0},\"\"]},{\"type\":\"paragraph\",\"content\":[\"Dissent: \",{\"type\":\"insert\",\"insert\":1}]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['neorevisionist_strength'] || 0);\"},\"qdisplay\":\"strength\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['neorevisionist_dissent'] || 0);\"},\"qdisplay\":\"dissent\"}]}},\"economic_policy.nationalize_2\":{\"id\":\"economic_policy.nationalize_2\",\"title\":\"Continue the Left plan for the transformation of the economy.\",\"subtitle\":{\"content\":[\"-\",{\"type\":\"insert\",\"insert\":0},\" budget. \",{\"type\":\"conditional\",\"content\":\"Our works councils have reduced the budget necessary for this program. \",\"predicate\":1},\" \",{\"type\":\"conditional\",\"content\":\"Our existing socialization policies have reduced the budget necessary for this program.\",\"predicate\":2}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['nationalize_budget'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['works_councils'] || 0) >= 3);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['socializations'] || 0) + (Q['nationalization_progress'] || 0)) >= 2);\"}}]},\"viewIf\":{\"$code\":\"return (((Q['nationalization_adopted'] || 0) == 1) && ((Q['nationalization_progress'] || 0) >= 1));\"},\"goTo\":[{\"id\":\"economic_policy.nationalize_deficit\",\"predicate\":{\"$code\":\"return ((Q['budget'] || 0) < (Q['nationalize_budget'] || 0));\"}},{\"id\":\"economic_policy.nationalize_no_deficit\",\"predicate\":{\"$code\":\"return ((Q['budget'] || 0) >= (Q['nationalize_budget'] || 0));\"}}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"foreign_policy.negotiate\":{\"id\":\"foreign_policy.negotiate\",\"title\":\"Negotiate regarding our remaining obligations from the Treaty of Versailles.\",\"subtitle\":{\"content\":{\"type\":\"conditional\",\"content\":\"After passing the Young Plan, France has committed to withdrawing from the Rhineland. Now, we must see if they can reduce our reparations further, given the economic depression.\",\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['young_plan_seen'] || 0) == 1);\"}}]},\"viewIf\":{\"$code\":\"return (((Q['reparations'] || 0) > -2) && ((Q['reparations_negotiation'] || 0) < 3));\"},\"onArrival\":[{\"$code\":\"Q['west_relation'] = (Q['west_relation'] || 0) + 1;\\nQ['reparations_negotiation'] = (Q['reparations_negotiation'] || 0) + 1;\\n if (((Q['pacifism'] || 0) >= 3) ) { Q['reparations_negotiation'] = (Q['reparations_negotiation'] || 0) + 1; } \\n if (((Q['nationalism'] || 0) <= 50) ) { Q['reparations_negotiations'] = (Q['reparations_negotiations'] || 0) + 1; } \\n if (((Q['west_relation'] || 0) >= 3) ) { Q['reparations_negotiation'] = (Q['reparations_negotiation'] || 0) + 1; }\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"Negotiations procede smoothly for the most part. The Western powers are convinced of Germany's sincerity and goodwill. \",{\"type\":\"conditional\",\"content\":\"They are pleased to see that we are renouncing militarism.\",\"predicate\":0}]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['nationalism'] || 0) <= 50) || ((Q['pacifism'] || 0) >= 3));\"}}]}},\"civil_war.west_aid\":{\"id\":\"civil_war.west_aid\",\"chooseIf\":{\"$code\":\"return ((Q['west_relation'] || 0) >= 2);\"},\"unavailableSubtitle\":\"Our relations are not strong enough.\",\"onArrival\":[{\"$code\":\"Q['west_aid'] = (Q['west_aid'] || 0) + 1;\"}],\"maxVisits\":1,\"goTo\":[{\"id\":\"civil_war.long_war_intervention\"}],\"content\":{\"content\":\"We send a call for help to the West, but their governments are divided on whether or not to support us. We have to survive on our own until they make a decision.\",\"type\":\"paragraph\"},\"countVisitsMax\":1},\"election_1928.popular_front_no_civil_war\":{\"id\":\"election_1928.popular_front_no_civil_war\",\"onArrival\":[{\"$code\":\"Q['kpd_goals_seen'] = 0;\\nQ['finance_minister_party'] = \\\"Z\\\";\\nQ['interior_minister_party'] = \\\"Z\\\";\\nQ['economy_minister_party'] = \\\"Z\\\";\\nQ['labor_minister_party'] = \\\"Z\\\";\\nQ['foreign_minister_party'] = \\\"Z\\\";\\nQ['agriculture_minister_party'] = \\\"Z\\\";\\nQ['reichswehr_minister'] = \\\"I\\\";\\nQ['leverage'] = (Q['leverage'] || 0) + (Q['kpd_r'] || 0);\"}],\"achievement\":\"volksfront\",\"options\":[{\"id\":\"@election_1928.ministries\",\"title\":\"First, we must select our ministries.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"In response to the KPD's entrance into the government, the right-wing takes a \\\"wait-and-see\\\" approach for now. They expect that the Popular Front government will be unstable and incompetent, and will collapse of its own accord, discrediting the left and center and eventually enabling the destruction of the Weimar Republic. Our task is to prove them wrong.\"},{\"type\":\"paragraph\",\"content\":\"The KPD has taken an abstentionist position with regards to ministries. They claim to be participating as the \\\"loyal opposition\\\" within the Popular Front government, supporting us from the outside while also running their own propaganda campaigns to turn workers to their side. They seem to expect that the Popular Front would inevitably fail, and that our failure would benefit them.\"}]},\"kpd_policy.foreign_oppose\":{\"id\":\"kpd_policy.foreign_oppose\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"march_on_berlin.new_elections_braun\":{\"id\":\"march_on_berlin.new_elections_braun\",\"goTo\":[{\"id\":\"march_on_berlin.new_elections_braun_2\",\"predicate\":{\"$code\":\"return (((Q['nsdap_normalized'] || 0) + (Q['dnvp_normalized'] || 0)) >= 0.5);\"}},{\"id\":\"march_on_berlin.new_elections_braun_reject\",\"predicate\":{\"$code\":\"return (((Q['nsdap_normalized'] || 0) + (Q['dnvp_normalized'] || 0)) < 0.5);\"}}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"presidential_election_1932.convince_kpd\":{\"id\":\"presidential_election_1932.convince_kpd\",\"chooseIf\":{\"$code\":\"return ((Q['spd_votes'] || 0) >= (Q['kpd_votes'] || 0));\"},\"unavailableSubtitle\":\"The KPD knows that they are more popular than us; they do not see a reason to support our candidate.\",\"maxVisits\":1,\"options\":[{\"id\":\"@presidential_election_1932.kpd_resources\",\"title\":\"Use our resources.\"},{\"id\":\"@presidential_election_1932.kpd_relations\",\"title\":\"Use our good relations.\"},{\"id\":\"@presidential_election_1932.braun_campaign\",\"title\":\"Forget about the KPD.\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"The KPD is supporting their own candidate, Ernst Thälmann. \",{\"type\":\"conditional\",\"content\":\"However, they are willing to be convinced to drop their campaign and support Braun; how do we convince them? \",\"predicate\":0},{\"type\":\"conditional\",\"content\":\"They do not seem willing to be convinced.\",\"predicate\":1}]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['kpd_relation'] || 0) >= 50);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['kpd_relation'] || 0) < 50) || (Q['kpd_party_leader'] != \\\"Conciliators\\\"));\"}}]},\"countVisitsMax\":1},\"inter_party_relationships.liberals\":{\"id\":\"inter_party_relationships.liberals\",\"subtitle\":\"-1 resources\",\"chooseIf\":{\"$code\":\"return ((Q['resources'] || 0) >= 1);\"},\"unavailableSubtitle\":\"Not enough resources.\",\"onArrival\":[{\"$code\":\"Q['resources'] = (Q['resources'] || 0) - 1;\\nQ['ddp_relation'] = (Q['ddp_relation'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\"}],\"goTo\":[{\"id\":\"inter_party_relationships.dvp_stresemann\",\"predicate\":{\"$code\":\"return ((Q['stresemann_dead'] || 0)===0);\"}},{\"id\":\"inter_party_relationships.dvp_loss\",\"predicate\":{\"$code\":\"return (((Q['stresemann_dead'] || 0)===1) && ((Q['year'] || 0) <= 1930));\"}},{\"id\":\"inter_party_relationships.dvp_moribound\",\"predicate\":{\"$code\":\"return ((Q['year'] || 0) > 1930);\"}}],\"content\":{\"content\":\"The DDP has been one of our closest allies through the course of the Republic.\",\"type\":\"paragraph\"}},\"rally.main_rally\":{\"id\":\"rally.main_rally\",\"options\":[{\"id\":\"@rally.class_struggle\",\"title\":\"The class struggle of the proletariat against the bourgeoisie.\"},{\"id\":\"@rally.welfare\",\"title\":\"Sozialpolitik - the maintenance and expansion of social welfare programs.\"},{\"id\":\"@rally.democracy\",\"title\":\"Expanding our nascent democracy and defending it against dictatorship and fascism.\"},{\"id\":\"@rally.pacifism\",\"title\":\"Opposing war, nationalism, and militarism at all costs.\"},{\"id\":\"@rally.wtb\",\"title\":\"Support the WTB plan!\"},{\"id\":\"@rally.local\",\"title\":\"A mixture of various local and national concerns that resonate most with the audience.\"},{\"id\":\"@easy_discard\"}],\"content\":{\"content\":\"Mass rallies are a common feature of social democratic life, especially in the lead-up to an election. What is the primary theme of this rally?\",\"type\":\"paragraph\"}},\"shuffle_leadership.remove_aufhauser\":{\"id\":\"shuffle_leadership.remove_aufhauser\",\"title\":\"Remove Aufhäuser\",\"viewIf\":{\"$code\":\"return ((Q['aufhauser_advisor'] || 0)===1);\"},\"tags\":[\"remove_advisor\"],\"onArrival\":[{\"$code\":\"Q['aufhauser_advisor'] = 0;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) + 5;\\nQ['n_advisors'] = (Q['n_advisors'] || 0) - 1;\"}],\"goTo\":[{\"id\":\"shuffle_leadership.rm_main\"}],\"content\":{\"content\":\"Aufhäuser has been removed as an advisor. The Labor faction disapproves.\",\"type\":\"paragraph\"}},\"game_over.unemployment_reduced\":{\"id\":\"game_over.unemployment_reduced\",\"title\":\"Unemployment has been successfully reduced!\",\"viewIf\":{\"$code\":\"return ((((Q['unemployed'] || 0) <= 20) && ((Q['unemployed'] || 0) >= 10)) && ((Q['year'] || 0) >= 1930));\"},\"tags\":[\"endings\"],\"goTo\":[{\"id\":\"game_over.eg_menu\"}],\"content\":{\"content\":\"While still uncomfortably high, unemployment levels are nowhere near their peak. This is a success of our economic policy.\",\"type\":\"paragraph\"}},\"library.figures\":{\"id\":\"library.figures\",\"title\":\"Figures and Charts\",\"goTo\":[{\"id\":\"library.menu\"}],\"onArrival\":[{\"$code\":\"Q['z_minus_bvp_r'] = ((Q['z_r'] || 0) - 3);\"}],\"onDisplay\":[{\"$code\":\"data = [\\n    {\\n        \\\"id\\\": \\\"kpd\\\",\\n        \\\"legend\\\": \\\"KPD\\\",\\n        \\\"name\\\": \\\"KPD\\\",\\n        \\\"seats\\\": Q.kpd_r*5,\\n    }];\\nif (Q.sapd_formed && Q.sapd_r) {\\n    data.push({\\n            \\\"id\\\": \\\"sapd\\\",\\n            \\\"legend\\\": \\\"SAPD\\\",\\n            \\\"name\\\": \\\"SAPD\\\",\\n            \\\"seats\\\": Math.round(Q.sapd_r*5),\\n            });\\n}\\ndata = data.concat([\\n    {\\n        \\\"id\\\": \\\"spd\\\",\\n        \\\"legend\\\": \\\"SPD\\\",\\n        \\\"name\\\": \\\"SPD\\\",\\n        \\\"seats\\\": Q.spd_r*5,\\n    },\\n    {\\n        \\\"id\\\": \\\"ddp\\\",\\n        \\\"legend\\\": \\\"DDP\\\",\\n        \\\"name\\\": \\\"DDP\\\",\\n        \\\"seats\\\": Q.ddp_r*5,\\n    },\\n    {\\n        \\\"id\\\": \\\"z\\\",\\n        \\\"legend\\\": \\\"Center\\\",\\n        \\\"name\\\": \\\"Center\\\",\\n        \\\"seats\\\": (Q.z_r - 3)*5,\\n    },\\n    {\\n        \\\"id\\\": \\\"bvp\\\",\\n        \\\"legend\\\": \\\"BVP\\\",\\n        \\\"name\\\": \\\"BVP\\\",\\n        \\\"seats\\\": 3*5,\\n    },\\n    {\\n        \\\"id\\\": \\\"dvp\\\",\\n        \\\"legend\\\": \\\"DVP\\\",\\n        \\\"name\\\": \\\"DVP\\\",\\n        \\\"seats\\\": Q.dvp_r*5,\\n    },\\n    {\\n        \\\"id\\\": \\\"other\\\",\\n        \\\"legend\\\": \\\"Other\\\",\\n        \\\"name\\\": \\\"Other\\\",\\n        \\\"seats\\\": Q.other_r*5,\\n    },\\n    {\\n        \\\"id\\\": \\\"dnvp\\\",\\n        \\\"legend\\\": \\\"DNVP\\\",\\n        \\\"name\\\": \\\"DNVP\\\",\\n        \\\"seats\\\": Q.dnvp_r*5,\\n    },\\n    {\\n        \\\"id\\\": \\\"nsdap\\\",\\n        \\\"legend\\\": \\\"NSDAP\\\",\\n        \\\"name\\\": \\\"NSDAP\\\",\\n        \\\"seats\\\": Q.nsdap_r*5,\\n    },\\n]);\\nif (d3 && window) {\\n    // get screen width\\n    var width = 500;\\n    var height = 500;\\n    var screenWidth = document.getElementById('content').offsetWidth;\\n    if (screenWidth < width - 50) {\\n        width = screenWidth - 50;\\n        height = width;\\n        document.getElementById(\\\"reichstag\\\").style.height = screenWidth/2 + \\\"px\\\";\\n    }\\n    var parliament = d3.parliament();\\n    parliament.width(width).height(height).innerRadiusCoef(0.4);\\n    parliament.enter.fromCenter(true).smallToBig(true);\\n    parliament.exit.toCenter(false).bigToSmall(true);\\n    d3.select(\\\"#reichstag\\\").datum(data).call(parliament);\\n\\n    var lines = d3.linegraph(false, false,\\n            Q.parties,\\n            {'spd': '#E3000F', 'kpd': '#8B0000', 'ddp': '#DCCA4A', 'z': '#000', 'dvp': '#D5AC27', 'dnvp': '#3f7bc1', 'nsdap': '#954B00', 'other': '#a0a0a0', 'sapd': '#c40000'},\\n            {'spd': 'SPD', 'kpd': 'KPD', 'ddp': 'DDP', 'z': 'Z + BVP', 'dvp': 'DVP', 'dnvp': 'DNVP', 'nsdap': 'NSDAP', 'other': 'Others', 'sapd': 'SAPD'});\\n    lines.width(width).height(400);\\n    //var svg = lines(Q.election_records);\\n    if (Q.election_records.length > 0) {\\n        d3.select(\\\"#election_history\\\").datum(Q.election_records).call(lines);\\n    }\\n    //document.getElementById('election_history').innerHTML = svg.outerHTML;\\n\\n    // party support records should not have so many ticks\\n    if (!Q.historical_mode && !Q.game_over) {\\n        var lines_2 = d3.linegraph(true, true,\\n            Q.parties,\\n            {'spd': '#E3000F', 'kpd': '#8B0000', 'ddp': '#DCCA4A', 'z': '#000', 'dvp': '#D5AC27', 'dnvp': '#3f7bc1', 'nsdap': '#954B00', 'other': '#a0a0a0', 'sapd': '#c40000'},\\n            {'spd': 'SPD', 'kpd': 'KPD', 'ddp': 'DDP', 'z': 'Z + BVP', 'dvp': 'DVP', 'dnvp': 'DNVP', 'nsdap': 'NSDAP', 'other': 'Others', 'sapd': 'SAPD'});\\n        lines_2.width(width).height(400);\\n        d3.select(\\\"#party_support_history\\\").datum(Q.party_support_records).call(lines_2);\\n    }\\n\\n    // economic stats\\n    var minInflation = d3.min(Q.economic_records, d => d.inflation);\\n    var maxUnemployment = d3.max(Q.economic_records, d => d.unemployment);\\n    var lines_3 = d3.linegraph(true, true, ['inflation', 'unemployment'],\\n            {'inflation': '#0000FF', 'unemployment': '#FF0000'},\\n            {'inflation': 'Inflation', 'unemployment': 'Unemployment'},\\n            maxUnemployment + 5, minInflation - 5, 21);\\n    lines_3.width(width).height(300);\\n    d3.select(\\\"#economic_history\\\").datum(Q.economic_records).call(lines_3);\\n}\"}],\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"Reichstag composition\"},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<svg id=\\\"reichstag\\\" style=\\\"width: 500px; height: 250px;\\\"> </svg>\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<table>\"},\" \",{\"type\":\"magic\",\"content\":\"<tr><td><div class=\\\"box\\\" style='background-color:#E3000F; outline: 2px; outline-style: solid;'> </div></td><td>\"},\" \",{\"type\":\"emphasis-2\",\"content\":\"SPD:\"},\" \",{\"type\":\"magic\",\"content\":\"</td><td>\"},\" \",{\"type\":\"emphasis-2\",\"content\":[{\"type\":\"insert\",\"insert\":0},\"%\"]},\" \",{\"type\":\"magic\",\"content\":\"</td></tr>\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"magic\",\"content\":\"<tr><td><div class=\\\"box\\\" style='background-color:#C40000'> </div></td> <td> \"},\"SAPD: \",{\"type\":\"magic\",\"content\":\"</td><td>\"},\" \",{\"type\":\"insert\",\"insert\":2},\"% \",{\"type\":\"magic\",\"content\":\"</td></tr>\"},\" \"],\"predicate\":1},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<tr><td><div class=\\\"box\\\" style='background-color:#8B0000'> </div></td> <td>\"},\"KPD: \",{\"type\":\"magic\",\"content\":\"</td><td>\"},\" \",{\"type\":\"insert\",\"insert\":3},\"% \",{\"type\":\"magic\",\"content\":\"</td></tr>\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<tr><td><div class=\\\"box\\\" style='background-color:#DCCA4A'> </div></td><td>\"},\" DDP: \",{\"type\":\"magic\",\"content\":\"</td><td>\"},\" \",{\"type\":\"insert\",\"insert\":4},\"% \",{\"type\":\"magic\",\"content\":\"</td></tr>\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<tr><td><div class=\\\"box\\\" style='background-color:#000'> </div></td><td>\"},\" Z: \",{\"type\":\"magic\",\"content\":\"</td><td>\"},\" \",{\"type\":\"insert\",\"insert\":5},\"% \",{\"type\":\"magic\",\"content\":\"</td></tr>\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<tr><td><div class=\\\"box\\\" style='background-color:#69A2BE'> </div></td><td>\"},\" BVP: \",{\"type\":\"magic\",\"content\":\"</td><td>\"},\" 3% \",{\"type\":\"magic\",\"content\":\"</td></tr>\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<tr><td><div class=\\\"box\\\" style='background-color:#D5AC27'> </div></td><td>\"},\" DVP: \",{\"type\":\"magic\",\"content\":\"</td><td>\"},\" \",{\"type\":\"insert\",\"insert\":6},\"% \",{\"type\":\"magic\",\"content\":\"</td></tr>\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<tr><td><div class=\\\"box\\\" style='background-color:#a0a0a0'> </div></td><td>\"},\" Other parties: \",{\"type\":\"magic\",\"content\":\"</td><td>\"},\" \",{\"type\":\"insert\",\"insert\":7},\" % \",{\"type\":\"magic\",\"content\":\"</td></tr>\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<tr><td><div class=\\\"box\\\" style='background-color:#3f7bc1'> </div></td><td>\"},\" DNVP: \",{\"type\":\"magic\",\"content\":\"</td><td>\"},\" \",{\"type\":\"insert\",\"insert\":8},\"% \",{\"type\":\"magic\",\"content\":\"</td></tr>\"},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<tr><td><div class=\\\"box\\\" style='background-color:#954B00'> </div></td><td>\"},\" NSDAP: \",{\"type\":\"magic\",\"content\":\"</td><td>\"},\" \",{\"type\":\"insert\",\"insert\":9},\"% \",{\"type\":\"magic\",\"content\":\"</td></tr>\"},\" \",{\"type\":\"magic\",\"content\":\"</table>\"},\"\"]},{\"type\":\"heading\",\"content\":\"Election history\"},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"No new elections yet. \",\"predicate\":10},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<svg id=\\\"election_history\\\" style=\\\"width: 500px; height: 400px;\\\"> </svg>\"},\"\"]},{\"type\":\"heading\",\"content\":\"Party support history\"},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"Not available in historical mode. \",\"predicate\":11},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"magic\",\"content\":\"<svg id=\\\"party_support_history\\\" style=\\\"width: 500px; height: 400px;\\\"> </svg>\"},\"\"]},{\"type\":\"heading\",\"content\":\"Economic history\"},{\"type\":\"paragraph\",\"content\":{\"type\":\"magic\",\"content\":\"<svg id=\\\"economic_history\\\" style=\\\"width: 500px; height: 300px;\\\"> </svg>\"}}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['spd_r'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['sapd_formed'] || 0)) !== 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['sapd_r'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['kpd_r'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['ddp_r'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['z_minus_bvp_r'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['dvp_r'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['other_r'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['dnvp_r'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['nsdap_r'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['year'] || 0)===1928) && ((Q['month'] || 0) < 5));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['historical_mode'] || 0)) !== 0);\"}}]}},\"library\":{\"id\":\"library\",\"type\":\"scene\",\"title\":\"library\",\"newPage\":true,\"isSpecial\":true,\"goTo\":[{\"id\":\"library.menu\"}],\"content\":[{\"type\":\"heading\",\"content\":\"The Library\"},{\"type\":\"paragraph\",\"content\":\"Herein contains relevant information about the government and politics of the German republic.\"}]},\"economic_policy.moderate_plan\":{\"id\":\"economic_policy.moderate_plan\",\"title\":\"Implement the Reformists' job-creation plan.\",\"subtitle\":\"-2 budget.\",\"unavailableSubtitle\":{\"content\":[\"-2 budget. \",{\"type\":\"conditional\",\"content\":\"We do not have the necessary budget. \",\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"Unemployment is low enough that job creation is not necessary.\",\"predicate\":1}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['budget'] || 0) < 2);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['unemployed'] || 0) < 8);\"}}]},\"viewIf\":{\"$code\":\"return ((Q['moderate_plan_adopted'] || 0) == 1);\"},\"chooseIf\":{\"$code\":\"return (((Q['budget'] || 0) >= 2) && ((Q['unemployed'] || 0) >= 8));\"},\"onArrival\":[{\"$code\":\"Q['budget'] = (Q['budget'] || 0) - 2;\\nQ['works_program'] = (Q['works_program'] || 0) + 1;\\n if (((Q['unemployed'] || 0) >= 8) ) { Q['unemployed'] = (Q['unemployed'] || 0) - 3; } \\nQ['inflation'] = (Q['inflation'] || 0) + 1.5;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (6 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) + (2 * (1 - (Q['dissent'] || 0)));\\nQ['rural_spd'] = (Q['rural_spd'] || 0) + (2 * (1 - (Q['dissent'] || 0)));\\nQ['moderate_plan_progress'] = (Q['moderate_plan_progress'] || 0) + 1;\\nQ['kpd_coalition_dissent'] = (Q['kpd_coalition_dissent'] || 0) + 1;\\n if (((Q['unemployed'] || 0) < 10) ) { Q['inflation'] = (Q['inflation'] || 0) + 1; } \\n if (((((Q['in_popular_front'] || 0)) !== 0) || (((Q['in_left_front'] || 0)) !== 0)) ) { Q['kpd_relation'] = (Q['kpd_relation'] || 0) - 5; }\"}],\"achievement\":\"wirtschaftspolitik\",\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"We have started to implement the job-creation plan! Funds are sent to build public works projects across Germany, reducing unemployment. \",\"predicate\":0},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"We have continued to fund the job-creation plan, using our funds to build public works throughout Germany. \",\"predicate\":1},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"The bourgeois approve of this plan as the \\\"least bad\\\" alternative, seeing it as necessary to save Germany's economy. \",\"predicate\":2},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"Unemployment is low enough that the plan does not seem to have the intended effect. \",\"predicate\":3},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":\"The KPD opposes the economic plan, seeing it as a rescue of capitalism rather than a step towards real socialism.\",\"predicate\":4}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['moderate_plan_progress'] || 0) == 1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['moderate_plan_progress'] || 0) > 1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['unemployed'] || 0) >= 10);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['unemployed'] || 0) < 10);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['in_popular_front'] || 0)) !== 0) || (((Q['in_left_front'] || 0)) !== 0));\"}}]}},\"foreign_policy.reduce_reparations\":{\"id\":\"foreign_policy.reduce_reparations\",\"title\":\"The Western Allies are finally willing to pause our reparations payments!\",\"subtitle\":\"Our negotiations have been successful.\",\"viewIf\":{\"$code\":\"return ((((Q['reparations_negotiation'] || 0) >= 3) && ((Q['black_thursday_seen'] || 0) == 1)) && ((Q['reparations'] || 0) > -2));\"},\"onArrival\":[{\"$code\":\"Q['west_relation'] = (Q['west_relation'] || 0) + 1;\\nQ['reparations'] = -2;\\n if (((Q['hoover_memorandum_seen'] || 0) == 0) ) { Q['budget'] = (Q['budget'] || 0) + 2; } \\n if (((Q['hoover_memorandum_seen'] || 0) == 1) ) { Q['budget'] = (Q['budget'] || 0) + 1; } \\n if (((Q['coalition_dissent'] || 0) > 0) ) { Q['coalition_dissent'] = (Q['coalition_dissent'] || 0) - 1; } \\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (8 * (1 - (Q['dissent'] || 0)));\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['rural_spd'] = (Q['rural_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\n if (((Q['coup_progress'] || 0) > 2) ) { Q['coup_progress'] = (Q['coup_progress'] || 0) - 2; }\"}],\"maxVisits\":1,\"content\":[{\"type\":\"paragraph\",\"content\":\"Finally, given both the economic circumstances and our continued negotiations, the Western Allies are willing to pause our reparations payments! Much of the credit must go to American president Hoover, who has been friendlier towards us than the Europeans.\"},{\"type\":\"paragraph\",\"content\":\"This has reduced tensions within our government, and our party has gotten credit for the achievement.\"}],\"countVisitsMax\":1},\"civil_war.soviet_aid\":{\"id\":\"civil_war.soviet_aid\",\"chooseIf\":{\"$code\":\"return (((((Q['soviet_relation'] || 0) >= 1) && ((Q['kpd_relation'] || 0) >= 50))) || (((Q['kpd_relation'] || 0) >= 75)));\"},\"onArrival\":[{\"$code\":\"Q['soviet_aid'] = (Q['soviet_aid'] || 0) + 1;\"}],\"unavailableSubtitle\":\"Our relations are not strong enough.\",\"maxVisits\":1,\"goTo\":[{\"id\":\"civil_war.long_war_intervention\"}],\"content\":{\"content\":\"We send a call for help to the Soviet Union. The KPD receives the bulk of the aid, while the Reichsbanner and our loyal military units are left floundering. If we win, this does not bode well for our future.\",\"type\":\"paragraph\"},\"countVisitsMax\":1},\"election_1928.popular_front_civil_war\":{\"id\":\"election_1928.popular_front_civil_war\",\"onArrival\":[{\"$code\":\"Q['kpd_relation'] = 80;\\nQ['reichswehr_loyalty'] = (Q['reichswehr_loyalty'] || 0) + 0.25;\"}],\"options\":[{\"id\":\"@civil_war\",\"title\":\"A civil war, then.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"In response to the KPD's entrance into the government, the right-wing immediately launches a coup attempt. Troops of the Stahlhelm and Nazi SA enter Berlin and immediately begin clashing with our supporters! Reactionary officers within the Reichswehr have taken their troops out of the barracks and joined them with the Stahlhelm to stop us from taking power.\"},{\"type\":\"paragraph\",\"content\":\"The Center manages to diffuse some of the hostility from the Reichswehr and the Stahlhelm, but fail to prevent the outbreak of fighting. We are forced to fight on the same side as the KPD, whether we want to or not.\"}]},\"kpd_policy.interior\":{\"id\":\"kpd_policy.interior\",\"title\":\"Interior Ministry\",\"subtitle\":\"The Interior Ministry is engaged in a purge of the security services.\",\"viewIf\":{\"$code\":\"return (Q['interior_minister_party'] == \\\"KPD\\\");\"},\"options\":[{\"id\":\"@kpd_policy.interior_support\",\"title\":\"Yes, we support purging the security services.\"},{\"id\":\"@kpd_policy.interior_oppose\",\"title\":\"No, this seems to be a pretext for a KPD power grab.\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"march_on_berlin.new_elections_braun_reject\":{\"id\":\"march_on_berlin.new_elections_braun_reject\",\"options\":[{\"id\":\"@march_on_berlin.braun_appoints_hitler\"},{\"id\":\"@march_on_berlin.fight\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"The fascists reject our offer of free and fair elections. They are demanding that President \",{\"type\":\"insert\",\"insert\":0},\" dismisses the current government and appoints Hitler chancellor.\"]},\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['president'] || 0);\"}}]}},\"presidential_election_1932.kpd_resources\":{\"id\":\"presidential_election_1932.kpd_resources\",\"viewIf\":{\"$code\":\"return (((Q['kpd_relation'] || 0) >= 50) && (!(((Q['historical_mode'] || 0)) !== 0)));\"},\"chooseIf\":{\"$code\":\"return ((Q['resources'] || 0) >= 3);\"},\"subtitle\":\"-3 resources\",\"unavailableSubtitle\":\"Not enough resources (need 3).\",\"onArrival\":[{\"$code\":\"Q['resources'] = (Q['resources'] || 0) - 3;\\nQ['kpd_support_braun'] = 1;\"}],\"goTo\":[{\"id\":\"presidential_election_1932.braun_campaign\"}],\"content\":{\"content\":\"The KPD now endorses Braun in the presidential election! We ask them to keep their support low-key, so as to not alienate the bourgeois voters.\",\"type\":\"paragraph\"}},\"inter_party_relationships.dvp_stresemann\":{\"id\":\"inter_party_relationships.dvp_stresemann\",\"onArrival\":[{\"$code\":\"Q['dvp_relation'] = (Q['dvp_relation'] || 0) + (8 * (1 - (Q['dissent'] || 0)));\"}],\"content\":{\"content\":\"Gustav Stresemann, the leader of the DVP is the best foreign policy leaders of the republic, and while he has previously expressed monarchist tendencies, he has been friendly towards us.\",\"type\":\"paragraph\"}},\"rally.class_struggle\":{\"id\":\"rally.class_struggle\",\"onArrival\":[{\"$code\":\"Q['workers_spd'] = (Q['workers_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\n if (((Q['left_strength'] || 0) > (Q['reformist_strength'] || 0)) ) { Q['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0))); } \\n if (((Q['nationalization_progress'] || 0) > 0) ) { Q['workers_spd'] = (Q['workers_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0))); } \\n if (((Q['nationalization_progress'] || 0) > 0) ) { Q['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0))); } \\nQ['left_strength'] = (Q['left_strength'] || 0) + 5;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) - 5;\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) - 3;\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) - 2;\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"Our message of class struggle appeals to the left wing of the working class, while potentially alienating the middle class. \",{\"type\":\"conditional\",\"content\":\"Our achievements in nationalization have assisted our messaging.\",\"predicate\":0}]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['nationalization_progress'] || 0) > 0);\"}}]}},\"shuffle_leadership.remove_wissell\":{\"id\":\"shuffle_leadership.remove_wissell\",\"title\":\"Remove Wissell\",\"viewIf\":{\"$code\":\"return ((Q['wissell_advisor'] || 0)===1);\"},\"tags\":[\"remove_advisor\"],\"onArrival\":[{\"$code\":\"Q['wissell_advisor'] = 0;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) + 3;\\nQ['n_advisors'] = (Q['n_advisors'] || 0) - 1;\"}],\"goTo\":[{\"id\":\"shuffle_leadership.rm_main\"}],\"content\":{\"content\":\"Wissell has been removed as an advisor. The Labor faction disapproves.\",\"type\":\"paragraph\"}},\"game_over.unemployment_reduced_2\":{\"id\":\"game_over.unemployment_reduced_2\",\"title\":\"Unemployment has been successfully reduced!\",\"viewIf\":{\"$code\":\"return (((Q['unemployed'] || 0) < 10) && ((Q['year'] || 0) >= 1930));\"},\"tags\":[\"endings\"],\"goTo\":[{\"id\":\"game_over.eg_menu\"}],\"content\":{\"content\":\"Unemployment levels have fallen substantially! This is a success of our economic policy.\",\"type\":\"paragraph\"}},\"economic_policy.moderate_plan_limited_budget\":{\"id\":\"economic_policy.moderate_plan_limited_budget\",\"title\":\"Partially implement the Reformists' job-creation plan, with a lower cost.\",\"subtitle\":\"-1 budget.\",\"unavailableSubtitle\":{\"content\":[\"-1 budget. \",{\"type\":\"conditional\",\"content\":\"We do not have the necessary budget. \",\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"Unemployment is low enough that job creation is not necessary.\",\"predicate\":1}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['budget'] || 0) < 1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['unemployed'] || 0) < 8);\"}}]},\"viewIf\":{\"$code\":\"return ((Q['moderate_plan_adopted'] || 0) == 1);\"},\"chooseIf\":{\"$code\":\"return (((Q['budget'] || 0) >= 1) && ((Q['unemployed'] || 0) >= 8));\"},\"onArrival\":[{\"$code\":\"Q['budget'] = (Q['budget'] || 0) - 1;\\nQ['works_program'] = (Q['works_program'] || 0) + 1;\\n if (((Q['unemployed'] || 0) >= 8) ) { Q['unemployed'] = (Q['unemployed'] || 0) - 2; } \\nQ['inflation'] = (Q['inflation'] || 0) + 1;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (2 * (1 - (Q['dissent'] || 0)));\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) + (2 * (1 - (Q['dissent'] || 0)));\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) + (1 * (1 - (Q['dissent'] || 0)));\\nQ['rural_spd'] = (Q['rural_spd'] || 0) + (1 * (1 - (Q['dissent'] || 0)));\\nQ['moderate_plan_progress'] = (Q['moderate_plan_progress'] || 0) + 1;\\nQ['kpd_coalition_dissent'] = (Q['kpd_coalition_dissent'] || 0) + 1;\\n if (((Q['unemployed'] || 0) < 10) ) { Q['inflation'] = (Q['inflation'] || 0) + 1; } \\n if (((((Q['in_popular_front'] || 0)) !== 0) || (((Q['in_left_front'] || 0)) !== 0)) ) { Q['kpd_relation'] = (Q['kpd_relation'] || 0) - 5; }\"}],\"achievement\":\"wirtschaftspolitik\",\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"We have started to implement the job-creation plan! Funds are sent to build public works projects across Germany, reducing unemployment. \",\"predicate\":0},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"We have continued to fund the job-creation plan, using our funds to build public works throughout Germany. \",\"predicate\":1},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"The bourgeois approve of this plan as the \\\"least bad\\\" alternative, seeing it as necessary to save Germany's economy. \",\"predicate\":2},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"Unemployment is low enough that the plan does not seem to have the intended effect. \",\"predicate\":3},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":\"The KPD opposes the economic plan, seeing it as a rescue of capitalism rather than a step towards real socialism.\",\"predicate\":4}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['moderate_plan_progress'] || 0) == 1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['moderate_plan_progress'] || 0) > 1);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['unemployed'] || 0) >= 10);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['unemployed'] || 0) < 10);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['in_popular_front'] || 0)) !== 0) || (((Q['in_left_front'] || 0)) !== 0));\"}}]}},\"economic_policy\":{\"id\":\"economic_policy\",\"type\":\"scene\",\"title\":\"Economic Policy\",\"newPage\":true,\"isCard\":true,\"tags\":[\"govt_affairs\"],\"onArrival\":[{\"$code\":\"Q['economic_policy_timer'] = (Q['economic_policy_timer'] || 0) + 12;\\nQ['month_actions'] = (Q['month_actions'] || 0) + 1;\\nQ['nationalize_budget'] = 4;\\n if (((Q['works_councils'] || 0) >= 2) ) { Q['nationalize_budget'] = (Q['nationalize_budget'] || 0) - 1; } \\n if (((Q['works_councils'] || 0) >= 3) ) { Q['nationalize_budget'] = (Q['nationalize_budget'] || 0) - 1; } \\n if ((((Q['socializations'] || 0) + (Q['nationalization_progress'] || 0)) >= 2) ) { Q['nationalize_budget'] = (Q['nationalize_budget'] || 0) - 1; } \\nQ['wtb_budget'] = 4;\\n if (((((Q['works_councils'] || 0) >= 2) || ((Q['socializations'] || 0) >= 1)) || ((Q['pro_labor'] || 0) >= 2)) ) { Q['wtb_budget'] = (Q['wtb_budget'] || 0) - 1; }\"}],\"viewIf\":{\"$code\":\"return (((((Q['spd_in_government'] || 0)===1) && (((Q['economic_minister_party'] == \\\"SPD\\\") || (Q['finance_minister_party'] == \\\"SPD\\\")))) && ((Q['economic_policy_timer'] || 0) <= 0)) && ((Q['economic_plan'] || 0) > 0));\"},\"cardImage\":\"img/portraits/SchmidtRobert.jpg\",\"options\":[{\"id\":\"@economic_policy.wtb_2\"},{\"id\":\"@economic_policy.wtb_2_deficit\"},{\"id\":\"@economic_policy.wtb_continuation\"},{\"id\":\"@economic_policy.implement_wtb_no_deficit\"},{\"id\":\"@economic_policy.implement_wtb_deficit\"},{\"id\":\"@economic_policy.nationalize_1\"},{\"id\":\"@economic_policy.nationalize_2\"},{\"id\":\"@economic_policy.moderate_plan\"},{\"id\":\"@economic_policy.moderate_plan_limited_budget\"},{\"id\":\"@root\",\"title\":\"Do not implement the economic plan.\"},{\"id\":\"@easy_discard\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Economic Policy\"},{\"type\":\"paragraph\",\"content\":\"We have already formulated an economic plan. Now we have to implement it.\"}]},\"foreign_policy.expose\":{\"id\":\"foreign_policy.expose\",\"title\":\"Expose the secret rearmament plans of the previous foreign ministry!\",\"viewIf\":{\"$code\":\"return ((Q['rearmament_exposed'] || 0) == 0);\"},\"onArrival\":[{\"$code\":\"Q['west_relation'] = (Q['west_relation'] || 0) + 2;\\nQ['east_relation'] = (Q['east_relation'] || 0) + 1;\\nQ['nationalism'] = (Q['nationalism'] || 0) - (5 * (1 - (Q['dissent'] || 0)));\\nQ['pro_republic'] = (Q['pro_republic'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['coalition_dissent'] = (Q['coalition_dissent'] || 0) + 1;\\nQ['rearmament_exposed'] = (Q['rearmament_exposed'] || 0) + 1;\\nQ['reparations_negotiation'] = (Q['reparations_negotiation'] || 0) + 3;\\nQ['coup_progress'] = (Q['coup_progress'] || 0) + 2;\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"The previous foreign ministry, despite its benevolent and peaceful face, was secretly helping the Reichswehr to build up its forces, in contravention of the Treaty of Versailles.\"},{\"type\":\"paragraph\",\"content\":\"The Allies are grateful of our exposure and repudiation of militarism. Our partners in the coalition are less supportive.\"}]},\"civil_war.east_aid\":{\"id\":\"civil_war.east_aid\",\"chooseIf\":{\"$code\":\"return ((Q['east_relation'] || 0) >= 2);\"},\"onArrival\":[{\"$code\":\"Q['east_aid'] = (Q['east_aid'] || 0) + 1;\"}],\"unavailableSubtitle\":\"Our relations are not strong enough.\",\"maxVisits\":1,\"goTo\":[{\"id\":\"civil_war.long_war_intervention\"}],\"content\":{\"content\":\"Poland and Czechoslovakia are largely too absorbed in their own problems to be of much help, but weapons and volunteers filter through the parts of the borders that we control.\",\"type\":\"paragraph\"},\"countVisitsMax\":1},\"election_1928.far_right_coalition\":{\"id\":\"election_1928.far_right_coalition\",\"title\":\"Far-right coalition\",\"subtitle\":{\"content\":[\"NSDAP + DNVP (\",{\"type\":\"insert\",\"insert\":0},\"%)\"],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['far_right_coalition'] || 0);\"}}]},\"viewIf\":{\"$code\":\"return ((Q['far_right_coalition'] || 0) >= 50);\"},\"goTo\":[{\"id\":\"election_1928.far_right_win\",\"predicate\":{\"$code\":\"return (((((Q['year'] || 0) >= 1932) || ((Q['nsdap_r'] || 0) >= 44))) && (Q['president'] != \\\"Braun\\\"));\"}},{\"id\":\"election_1928.far_right_fail\",\"predicate\":{\"$code\":\"return (((((Q['year'] || 0) < 1932) && ((Q['nsdap_r'] || 0) < 44))) && (Q['president'] != \\\"Braun\\\"));\"}},{\"id\":\"election_1928.far_right_braun\",\"predicate\":{\"$code\":\"return (Q['president'] == \\\"Braun\\\");\"}}],\"priority\":2,\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"There are enough votes for the Nazis and the DNVP to form a coalition. \",{\"type\":\"insert\",\"insert\":0},\" has made his participation in government contingent on being appointed chancellor. It is up to President \",{\"type\":\"insert\",\"insert\":1},\" to decide.\"]},\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['nsdap_leader'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['president'] || 0);\"}}]}},\"kpd_policy.interior_support\":{\"id\":\"kpd_policy.interior_support\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"march_on_berlin.new_elections_braun_2\":{\"id\":\"march_on_berlin.new_elections_braun_2\",\"goTo\":[{\"id\":\"march_on_berlin.new_elections_2\"}],\"content\":{\"content\":\"The fascists seem to believe that they would win an election if one were to be held now, so they agree to our holding an election for next month.\",\"type\":\"paragraph\"}},\"presidential_election_1932.kpd_relations\":{\"id\":\"presidential_election_1932.kpd_relations\",\"viewIf\":{\"$code\":\"return (((Q['kpd_relation'] || 0) >= 60) || (((Q['kpd_party_leader'] == \\\"Conciliators\\\") && ((Q['kpd_relation'] || 0) >= 45))));\"},\"unavailableSubtitle\":\"Our relations are not good enough.\",\"onArrival\":[{\"$code\":\"Q['kpd_support_braun'] = 1;\"}],\"goTo\":[{\"id\":\"presidential_election_1932.braun_campaign\"}],\"content\":{\"content\":\"The KPD now endorses Braun in the presidential election! We ask them to keep their support low-key, so as to not alienate the bourgeois voters.\",\"type\":\"paragraph\"}},\"inter_party_relationships.dvp_loss\":{\"id\":\"inter_party_relationships.dvp_loss\",\"onArrival\":[{\"$code\":\"Q['dvp_relation'] = (Q['dvp_relation'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"With the death of Gustav Stresemann, the DVP is much less likely to be accommodating of us. In addition, the liberal parties are electorally in decline, so perhaps our efforts are best spent elsewhere.\"},{\"type\":\"paragraph\",\"content\":[\"However, given the influence of the DVP among the other right-leaning parties \",{\"type\":\"conditional\",\"content\":\"and with President Hindenburg \",\"predicate\":0},\", it can still be helpful to influence them.\"]}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['president'] == \\\"Hindenburg\\\");\"}}]}},\"rally.welfare\":{\"id\":\"rally.welfare\",\"onArrival\":[{\"$code\":\"Q['workers_spd'] = (Q['workers_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\n if (((Q['welfare'] || 0) > 0) ) { Q['workers_spd'] = (Q['workers_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0))); } \\n if (((Q['welfare'] || 0) > 0) ) { Q['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0))); } \\n if (((Q['welfare'] || 0) > 1) ) { Q['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0))); } \\nQ['reformist_strength'] = (Q['reformist_strength'] || 0) + 3;\\nQ['labor_strength'] = (Q['labor_strength'] || 0) + 4;\\nQ['reformist_dissent'] = (Q['reformist_dissent'] || 0) - 3;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) - 3;\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"The reformist message appeals to the organized workers, whose benefits are the accomplishments of social democracy. \",{\"type\":\"conditional\",\"content\":\"Our achievements in expanding welfare have made this message more effective.\",\"predicate\":0}]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['welfare'] || 0) > 1);\"}}]}},\"shuffle_leadership.remove_woytinsky\":{\"id\":\"shuffle_leadership.remove_woytinsky\",\"title\":\"Remove Woytinsky\",\"viewIf\":{\"$code\":\"return ((Q['woytinsky_advisor'] || 0)===1);\"},\"tags\":[\"remove_advisor\"],\"onArrival\":[{\"$code\":\"Q['woytinsky_advisor'] = 0;\\nQ['labor_dissent'] = (Q['labor_dissent'] || 0) + 3;\\nQ['n_advisors'] = (Q['n_advisors'] || 0) - 1;\"}],\"goTo\":[{\"id\":\"shuffle_leadership.rm_main\"}],\"content\":{\"content\":\"Woytinsky has been removed as an advisor. The Labor faction disapproves.\",\"type\":\"paragraph\"}},\"game_over.unemployment_high\":{\"id\":\"game_over.unemployment_high\",\"title\":\"Unemployment is still too high.\",\"viewIf\":{\"$code\":\"return (((((Q['unemployed'] || 0) >= 30) && (((Q['chancellor'] != \\\"Hitler\\\") && (Q['president'] != \\\"Hitler\\\")))) && (((Q['total_defeat'] || 0) == 0))) && ((Q['long_war'] || 0) == 0));\"},\"tags\":[\"endings\"],\"goTo\":[{\"id\":\"game_over.eg_menu\"}],\"content\":{\"content\":\"Unemployment is still at dangerously high levels. Even though Hitler is not in power, the situation is ripe for instability and extremism.\",\"type\":\"paragraph\"}},\"foreign_policy.economic_conference\":{\"id\":\"foreign_policy.economic_conference\",\"title\":\"Organize an international economic conference to deal with the Depression.\",\"unavailableSubtitle\":{\"content\":{\"type\":\"conditional\",\"content\":\"Our relations with the West are not good enough.\",\"predicate\":0},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['west_relation'] || 0) < 4);\"}}]},\"viewIf\":{\"$code\":\"return ((((Q['black_friday_seen'] || 0) == 1) && ((Q['crisis_urgency'] || 0) >= 1)) && ((Q['reparations'] || 0) <= -2));\"},\"chooseIf\":{\"$code\":\"return ((Q['west_relation'] || 0) >= 4);\"},\"onArrival\":[{\"$code\":\"Q['economic_conference'] = 1;\\nQ['west_relation'] = (Q['west_relation'] || 0) + 1;\\nQ['east_relation'] = (Q['east_relation'] || 0) + 1;\"}],\"maxVisits\":1,\"content\":{\"content\":\"\",\"type\":\"paragraph\"},\"countVisitsMax\":1},\"civil_war.republic_victory\":{\"id\":\"civil_war.republic_victory\",\"options\":[{\"id\":\"@game_over\",\"title\":\"Game over.\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Victory for the Republic\"},{\"type\":\"paragraph\",\"content\":\"The battle lines hold, and the SA, Stahlhelm, and pro-coup Reichswehr forces are defeated. Today, the forces of the republic prevail over the fascists and the reactionaries. There is a new revolution in Germany. Let us hope it produces a longer-lasting peace than the previous one.\"}]},\"civil_war\":{\"id\":\"civil_war\",\"type\":\"scene\",\"title\":\"Civil War\",\"audio\":\"music/communist/A_las_barricadas.ogg\",\"onArrival\":[{\"$code\":\"Q.rb_strength = Math.round(Q.rb_strength);\\nQ.sh_strength = Math.round(Q.sh_strength);\\nQ.sa_strength = Math.round(Q.sa_strength);\\n// re-calculate dissent, in case we transitioned from, say, the KPD support that raised reformist dissent.\\nvar total_strength = Q.left_strength + Q.center_strength + Q.labor_strength + Q.reformist_strength + Q.neorevisionist_strength;\\nvar total_dissent = Q.left_strength*Q.left_dissent + Q.center_strength*Q.center_dissent + Q.labor_strength*Q.labor_dissent + Q.reformist_strength*Q.reformist_dissent + Q.neorevisionist_strength*Q.neorevisionist_dissent;\\n\\nQ.dissent = 0.01*total_dissent/total_strength;\\nconsole.log('new dissent: ' + Q.dissent);\\n\\nif (Q.dissent < 0) {\\n    Q.dissent = 0;\\n} else if (Q.dissent > 0.95) {\\n    Q.dissent = 0.95;\\n}\\n\\nQ.civil_war_seen = 1;\\n\\n// our allies\\nQ.total_power = 0;\\n// TODO:  lower reichsbanner strength if the party's popularity is very low.\\nQ.rb_power = Q.rb_strength*Q.rb_militancy;\\nif (Q.dissent > 0.15) {\\n    Q.rb_power *= (1 - Q.dissent/1.5);\\n}\\nQ.total_power += Q.rb_power;\\nQ.prussian_police_power = Q.prussian_police_strength*Q.prussian_police_militancy*Q.prussian_police_loyalty;\\nif (Q.spd_prussia) {\\n    Q.total_power += Q.prussian_police_power;\\n}\\nif (Q.reichswehr_loyalty < 0) {\\n    Q.reichswehr_loyalty = 0;\\n}\\nQ.loyal_reichswehr_power = Q.reichswehr_strength*Q.reichswehr_militancy*Q.reichswehr_loyalty;\\nif (Q.spd_in_government && Q.chancellor_party == \\\"SPD\\\") {\\n    Q.total_power += Q.loyal_reichswehr_power;\\n} else {\\n    Q.total_power += Q.loyal_reichswehr_power/4;\\n}\\nQ.rfb_power = Q.rfb_strength*Q.rfb_militancy;\\nif (Q.kpd_relation >= 60) {\\n    Q.total_power += Q.rfb_power;\\n} else if (Q.kpd_relation >= 45) {\\n    Q.total_power += Q.rfb_power*0.5;\\n}\\n// general strike strength\\n// maximum (given 25 labor strength) is 400\\n// use normalized workers_spd instead of labor_strength?\\nQ.normalized_workers_spd = 100*Q.workers_spd/(Q.workers_spd + Q.workers_kpd + Q.workers_nsdap + Q.workers_other + Q.workers_dnvp + Q.workers_z);\\nQ.normalized_workers_kpd = 100*Q.workers_kpd/(Q.workers_spd + Q.workers_kpd + Q.workers_nsdap + Q.workers_other + Q.workers_dnvp + Q.workers_z);\\nQ.normalized_workers_total = Q.normalized_workers_spd;\\nif (Q.kpd_relation >= 60) {\\n    Q.normalized_workers_total += Q.normalized_workers_kpd;\\n} else if (Q.kpd_relation >= 45) {\\n    Q.normalized_workers_total += Q.normalized_workers_kpd*0.5;\\n}\\nQ.total_power += (2 - Q.labor_dissent/100)*Q.normalized_workers_total*(2 - Q.unemployed/100)*2.5;\\nconsole.log(\\\"Supporter strength:\\\", Q.total_power);\\n\\n// our enemies\\nQ.enemy_power = 0;\\nQ.sa_power = Q.sa_strength*Q.sa_militancy;\\nQ.enemy_power += Q.sa_power;\\nQ.sh_power = Q.sh_strength*Q.sh_militancy;\\nQ.enemy_power += Q.sh_power;\\nQ.hostile_reichswehr_power = Q.reichswehr_strength*Q.reichswehr_militancy*(1-Q.reichswehr_loyalty);\\nQ.enemy_power += Q.hostile_reichswehr_power;\\nconsole.log(\\\"Enemy strength:\\\", Q.enemy_power);\\n\\nif (Q.total_power > Q.enemy_power*1.1) {\\n    Q.republic_victory = 1;\\n} else if (Q.total_power/Q.enemy_power >= 0.6) {\\n    Q.long_war = 1;\\n} else {\\n    Q.total_defeat = 1;\\n}\\n\\nQ.is_favorable = 0;\\nif (Q.total_power >= Q.enemy_power*0.95) {\\n    Q.is_favorable = 1;\\n}\"}],\"goTo\":[{\"id\":\"civil_war.war_menu\"}],\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"The Array of Forces\"},{\"type\":\"paragraph\",\"content\":[\"Our enemies are the nationalist Stahlhelm, with \",{\"type\":\"insert\",\"insert\":0},\" thousand troops, and the Nazi SA, with \",{\"type\":\"insert\",\"insert\":1},\" thousand troops. The loyalties of the Reichswehr, with its \",{\"type\":\"insert\",\"insert\":2},\" thousand regular soldiers, and Prussian police, with \",{\"type\":\"insert\",\"insert\":3},\" thousand members, are unclear.\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"The KPD's paramilitary, the RFB, is leading the battle, and we are their co-combatants. \",\"predicate\":4},\"\"]},{\"type\":\"paragraph\",\"content\":[\"On our side, we have the Reichsbanner, at \",{\"type\":\"insert\",\"insert\":5},\" thousand members. \",{\"type\":\"conditional\",\"content\":\"It is somewhat weakened by dissent within the party, and some members choose not to fight. \",\"predicate\":6},{\"type\":\"conditional\",\"content\":\"It is weakened by dissent within the party, and many members choose not to fight. \",\"predicate\":7},{\"type\":\"conditional\",\"content\":\"It is heavily weakened by dissent within the party, and a substantial portion of members choose not to fight. \",\"predicate\":8},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"Unfortunately, the Reichsbanner are poorly trained and equipped, and will not be able to stand against our more militarized opponents. \",\"predicate\":9},{\"type\":\"conditional\",\"content\":\"We have spent some resources training and equipping the Reichsbanner. Let us hope our people can persist. \",\"predicate\":10},{\"type\":\"conditional\",\"content\":\"We have spent quite a great deal of resources on turning the Reichsbanner into a fighting force. Let us hope that they survive. \",\"predicate\":11},\"\"]},{\"type\":\"paragraph\",\"content\":\"What else do we have?\"}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['sh_strength'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['sa_strength'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['reichswehr_strength'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['prussian_police_strength'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['chancellor_party'] == \\\"KPD\\\") || (Q['president'] == \\\"Thälmann\\\"));\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['rb_strength'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['dissent'] || 0) > 0.15) && ((Q['dissent'] || 0) <= 0.25));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['dissent'] || 0) > 0.25) && ((Q['dissent'] || 0) < 0.5));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['dissent'] || 0) >= 0.5);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['rb_militancy'] || 0) < 0.25);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['rb_militancy'] || 0) >= 0.25) && ((Q['rb_militancy'] || 0) < 0.5));\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['rb_militancy'] || 0) >= 0.5);\"}}]}},\"election_1928.far_right_win\":{\"id\":\"election_1928.far_right_win\",\"onArrival\":[{\"$code\":\"Q['chancellor'] = (Q['nsdap_leader'] || 0);\\nQ['chancellor_party'] = \\\"NSDAP\\\";\"}],\"options\":[{\"id\":\"@hitler_takes_power\",\"title\":\"What do we do now?\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"President Hindenburg's camarilla \",\"predicate\":0},{\"type\":\"conditional\",\"content\":\"President Braun somehow \",\"predicate\":1},\" has decided that \",{\"type\":\"insert\",\"insert\":2},\" must be chancellor \",{\"type\":\"conditional\",\"content\":\", and the aging president accepts their recommendations. \",\"predicate\":3},{\"type\":\"conditional\",\"content\":\"because it is what the constitution would stipulate.\",\"predicate\":4}]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['president'] == \\\"Hindenburg\\\");\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['president'] == \\\"Braun\\\");\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['nsdap_leader'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['president'] == \\\"Hindenburg\\\");\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['president'] == \\\"Braun\\\");\"}}]}},\"kpd_policy.interior_oppose\":{\"id\":\"kpd_policy.interior_oppose\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"kpd_policy\":{\"id\":\"kpd_policy\",\"type\":\"scene\",\"title\":\"KPD policy\",\"subtitle\":\"The KPD ministers are carrying out their policy portfolios.\",\"newPage\":true,\"viewIf\":{\"$code\":\"return (((((((Q['in_popular_front'] || 0)) !== 0) || (((Q['in_left_front'] || 0)) !== 0))) && ((((Q['labor_minister_party'] == \\\"KPD\\\") || (Q['economy_minister_party'] == \\\"KPD\\\")) || (Q['finance_minister_party'] == \\\"KPD\\\")))) && (((Q['kpd_policy_timer'] || 0)===0)));\"},\"onArrival\":[{\"$code\":\"Q['kpd_policy_timer'] = 5;\"}],\"options\":[{\"id\":\"@kpd_policy.labor\"},{\"id\":\"@kpd_policy.economy\"},{\"id\":\"@kpd_policy.finance\"},{\"id\":\"@kpd_policy.foreign\"},{\"id\":\"@kpd_policy.interior\"}],\"content\":{\"type\":\"heading\",\"content\":\"KPD Policy\"}},\"march_on_berlin.new_elections_hindenburg\":{\"id\":\"march_on_berlin.new_elections_hindenburg\",\"goTo\":[{\"id\":\"march_on_berlin.new_elections_2\"}],\"content\":{\"content\":\"With the mediation of various establishment figures, new elections are called for next month, without the use of fascist \\\"electoral monitors\\\".\",\"type\":\"paragraph\"}},\"presidential_election_1932.convince_liberals\":{\"id\":\"presidential_election_1932.convince_liberals\",\"maxVisits\":1,\"goTo\":[{\"id\":\"presidential_election_1932.convince_liberals_success\",\"predicate\":{\"$code\":\"return ((Q['dvp_relation'] || 0) >= 50);\"}},{\"id\":\"presidential_election_1932.convince_liberals_fail\",\"predicate\":{\"$code\":\"return ((Q['dvp_relation'] || 0) < 50);\"}}],\"content\":{\"content\":\"The liberal vote (DDP and DVP) has been falling over time, so they will probably be of minimal help to us. For what it's worth, the DDP is already willing to support Braun.\",\"type\":\"paragraph\"},\"countVisitsMax\":1},\"inter_party_relationships.dvp_moribound\":{\"id\":\"inter_party_relationships.dvp_moribound\",\"onArrival\":[{\"$code\":\"Q['dvp_relation'] = (Q['dvp_relation'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"The liberal parties (both the DDP and DVP) are electorally moribund, so perhaps our efforts are best spent elsewhere.\"},{\"type\":\"paragraph\",\"content\":[\"However, given the influence of the DVP among the other right-leaning parties\",{\"type\":\"conditional\",\"content\":\"and with President Hindenburg \",\"predicate\":0},\", it can still be helpful to influence them.\"]}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['president'] == \\\"Hindenburg\\\");\"}}]}},\"rally.democracy\":{\"id\":\"rally.democracy\",\"onArrival\":[{\"$code\":\"Q['democratization'] = (Q['democratization'] || 0) + 1;\\nQ['pro_republic'] = (Q['pro_republic'] || 0) + (2 * (1 - (Q['dissent'] || 0)));\\n if (((Q['democratization'] || 0) >= 3) ) { Q['workers_spd'] = (Q['workers_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0))); } \\n if (((Q['democratization'] || 0) >= 3) ) { Q['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0))); } \\n if (((Q['democratization'] || 0) >= 3) ) { Q['pro_republic'] = (Q['pro_republic'] || 0) + (4 * (1 - (Q['dissent'] || 0))); } \\n if (((Q['democratization'] || 0) >= 3) ) { Q['new_middle_spd'] = (Q['new_middle_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0))); }\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"Our speakers defend the republican system and rail against the monarchists and authoritarians who threaten it.\"},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"Talk of democracy does not excite the workers as much as more practical issues. But that may change; part of our job is to provide political education to the proletariat. \",\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"Since we have consistently made democratization a theme of our campaign, the workers are enthusiastic about our message.\",\"predicate\":1}]}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['democratization'] || 0) < 3);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['democratization'] || 0) >= 3);\"}}]}},\"shuffle_leadership.remove_levi\":{\"id\":\"shuffle_leadership.remove_levi\",\"title\":\"Remove Levi\",\"viewIf\":{\"$code\":\"return ((Q['levi_advisor'] || 0)===1);\"},\"tags\":[\"remove_advisor\"],\"onArrival\":[{\"$code\":\"Q['levi_advisor'] = 0;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 5;\\nQ['n_advisors'] = (Q['n_advisors'] || 0) - 1;\"}],\"goTo\":[{\"id\":\"shuffle_leadership.rm_main\"}],\"content\":{\"content\":\"Levi has been removed as an advisor. The Leftist faction disapproves.\",\"type\":\"paragraph\"}},\"game_over.emergency_government\":{\"id\":\"game_over.emergency_government\",\"title\":\"SPD ruling in an emergency government.\",\"viewIf\":{\"$code\":\"return ((Q['in_emergency_government'] || 0) == 1);\"},\"tags\":[\"endings\"],\"goTo\":[{\"id\":\"game_over.eg_menu\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"The SPD is ruling as part of an emergency minority government, led by President \",{\"type\":\"insert\",\"insert\":0},\" and Chancellor \",{\"type\":\"insert\",\"insert\":1},\". This is a temporary and unstable arrangement, leaving the door open to further authoritarianism.\"]},\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['president'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['chancellor'] || 0);\"}}]}},\"foreign_policy.concordat_negotiate\":{\"id\":\"foreign_policy.concordat_negotiate\",\"title\":\"Negotiate a Concordat between the Germany and the Vatican.\",\"viewIf\":{\"$code\":\"return ((((Q['prussian_concordat'] || 0)===1) && ((Q['reichskonkordat'] || 0)===0)) && ((Q['reichskonkordat_progress'] || 0) < 4));\"},\"onArrival\":[{\"$code\":\"Q['reichskonkordat_progress'] = (Q['reichskonkordat_progress'] || 0) + 2;\\n if ((((Q['abortion_rights'] || 0)) !== 0) ) { Q['reichskonkordat_progress'] = (Q['reichskonkordat_progress'] || 0) - 1; } \\n if ((((Q['family_law'] || 0)) !== 0) ) { Q['reichskonkordat_progress'] = (Q['reichskonkordat_progress'] || 0) - 1; } \\nQ['z_relation'] = (Q['z_relation'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"The Roman Catholic Church is interested in furthering relations with the German Republic, seeing us as preferable to the old anti-Catholic policies of the Empire. We are working towards the signing of a Concordat, an agreement between the Vatican and the Republic that formally recognizes the Church's rights and interests in the country. The Center Party is especially interested in making this agreement.\"},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"Our liberalized divorce policies make it difficult to build relations with the Vatican. \",\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"Our legalization of abortion make it difficult to connect with the Church.\",\"predicate\":1}]}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['family_law'] || 0)) !== 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['abortion'] || 0)) !== 0);\"}}]}},\"election_1928.far_right_fail\":{\"id\":\"election_1928.far_right_fail\",\"onArrival\":[{\"$code\":\"Q['chancellor'] = \\\"Schleicher\\\";\\nQ['chancellor_party'] = \\\"I\\\";\\nQ['pro_republic'] = (Q['pro_republic'] || 0) - 10;\\nQ['next_election_time'] = ((Q['time'] || 0) + 5);\\nQ['next_election_month'] = ((Q['month'] || 0) + 5);\\nQ['next_election_year'] = (Q['year'] || 0);\\n if (((Q['next_election_month'] || 0) > 12) ) { Q['next_election_year'] = (Q['next_election_year'] || 0) + 1; } \\n if (((Q['next_election_month'] || 0) > 12) ) { Q['next_election_month'] = (Q['next_election_month'] || 0) - 12; }\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":[\"The reactionary establishment is still very skeptical of the Nazis, so instead, \",{\"type\":\"insert\",\"insert\":0},\" appoints Kurt von Schleicher, a former general, as chancellor, to try to \\\"tame\\\" the Nazis.\"]},{\"type\":\"paragraph\",\"content\":\"Schleicher's government is deeply unpopular among all parties of the Reichstag. Despite his support for a coalition with the NSDAP, the Nazis want power all to themselves, without Schleicher.\"},{\"type\":\"paragraph\",\"content\":[\"New elections have been set for \",{\"type\":\"insert\",\"insert\":1},\" \",{\"type\":\"insert\",\"insert\":2},\".\"]}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['president'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_month'] || 0);\"},\"qdisplay\":\"month\"},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['next_election_year'] || 0);\"}}]}},\"march_on_berlin.new_elections_2\":{\"id\":\"march_on_berlin.new_elections_2\",\"onArrival\":[{\"$code\":\"if (((Q['next_election_time'] || 0) > ((Q['time'] || 0) + 1)) ) { Q['next_election_time'] = ((Q['time'] || 0) + 1); } \\n if (((Q['next_election_time'] || 0) >= ((Q['time'] || 0) + 1)) ) { Q['next_election_month'] = ((Q['month'] || 0) + 1); } \\n if (((Q['next_election_time'] || 0) >= ((Q['time'] || 0) + 1)) ) { Q['next_election_year'] = (Q['year'] || 0); } \\n if (((Q['next_election_month'] || 0) > 12) ) { Q['next_election_year'] = (Q['next_election_year'] || 0) + 1; } \\n if (((Q['next_election_month'] || 0) > 12) ) { Q['next_election_month'] = (Q['next_election_month'] || 0) - 12; }\"}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"presidential_election_1932.convince_liberals_success\":{\"id\":\"presidential_election_1932.convince_liberals_success\",\"onArrival\":[{\"$code\":\"Q['dvp_support_braun'] = 1;\"}],\"goTo\":[{\"id\":\"presidential_election_1932.braun_campaign\"}],\"content\":{\"content\":\"Thanks to our good relations, the DVP has promised to support Braun in the election.\",\"type\":\"paragraph\"}},\"inter_party_relationships.spd_alone\":{\"id\":\"inter_party_relationships.spd_alone\",\"options\":[{\"id\":\"@return\",\"title\":\"Continue...\"}],\"content\":{\"type\":\"paragraph\",\"content\":[\"Whether it is because we \",{\"type\":\"emphasis-1\",\"content\":\"cannot\"},\" or \",{\"type\":\"emphasis-1\",\"content\":\"will not\"},\", we do not make ties with other parties at this moment.\"]}},\"inter_party_relationships\":{\"id\":\"inter_party_relationships\",\"type\":\"scene\",\"title\":\"Inter-Party Relationships\",\"newPage\":true,\"viewIf\":{\"$code\":\"return (((Q['year'] || 0) <= 1932) && ((Q['inter_party_relationships_timer'] || 0) <= 0));\"},\"tags\":[\"party_affairs\"],\"isCard\":true,\"onArrival\":[{\"$code\":\"Q['month_actions'] = (Q['month_actions'] || 0) + 1;\\nQ['inter_party_relationships_timer'] = 6;\"}],\"cardImage\":\"img/weimar_coalition_2.jpg\",\"maxVisits\":12,\"options\":[{\"id\":\"@inter_party_relationships.liberals\",\"title\":\"Strengthen our bonds with the left-liberal German Democratic Party and conservative-liberal German People's Party.\"},{\"id\":\"@inter_party_relationships.center\",\"title\":\"Strengthen our bonds with the Catholic Center Party.\"},{\"id\":\"@inter_party_relationships.kpd\",\"title\":\"Work towards repairing relationships with the Communist Party.\"},{\"id\":\"@inter_party_relationships.spd_alone\",\"title\":\"The SPD can stand alone for now.\"},{\"id\":\"@easy_discard\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Inter-Party Relationships\"},{\"type\":\"paragraph\",\"content\":\"The SPD cannot govern by itself yet. Because we do not have an electoral majority, we need the support of other parties. Recently, our governments have consisted of the Weimar Coalition of the SPD, Center, and Democratic parties. We can reach out and build additional connections with these parties, or perhaps we can stand alone.\"}],\"countVisitsMax\":12},\"rally.pacifism\":{\"id\":\"rally.pacifism\",\"onArrival\":[{\"$code\":\"Q['pacifism'] = (Q['pacifism'] || 0) + 1;\\nQ['nationalism'] = (Q['nationalism'] || 0) - (2 * (1 - (Q['dissent'] || 0)));\\n if (((Q['pacifism'] || 0) >= 3) ) { Q['workers_spd'] = (Q['workers_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0))); } \\n if (((Q['pacifism'] || 0) >= 3) ) { Q['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0))); } \\n if (((Q['pacifism'] || 0) >= 3) ) { Q['nationalism'] = (Q['nationalism'] || 0) - (3 * (1 - (Q['dissent'] || 0))); } \\n if (((Q['pacifism'] || 0) >= 3) ) { Q['new_middle_spd'] = (Q['new_middle_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0))); }\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"Our speakers denounce the military establishment and all the spending entering that black hole. Some adventurous speakers question the responsibility of the military elites in organizing the Great War.\"},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":\"Given the volume of nationalist indoctrination in our society, it is difficult to argue so vehemently against the military. \",\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"Since we have consistently made pacifism a theme of our campaign, the workers are enthusiastic about our message.\",\"predicate\":1}]}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['pacifism'] || 0) < 3);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['pacifism'] || 0) >= 3);\"}}]}},\"shuffle_leadership.remove_sender\":{\"id\":\"shuffle_leadership.remove_sender\",\"title\":\"Remove Sender\",\"viewIf\":{\"$code\":\"return ((Q['sender_advisor'] || 0)===1);\"},\"tags\":[\"remove_advisor\"],\"onArrival\":[{\"$code\":\"Q['sender_advisor'] = 0;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 3;\\nQ['n_advisors'] = (Q['n_advisors'] || 0) - 1;\"}],\"goTo\":[{\"id\":\"shuffle_leadership.rm_main\"}],\"content\":{\"content\":\"Sender has been removed as an advisor. The Leftist faction disapproves.\",\"type\":\"paragraph\"}},\"game_over.peoples_party_achieved\":{\"id\":\"game_over.peoples_party_achieved\",\"title\":\"The SPD is a \\\"People's Party\\\".\",\"viewIf\":{\"$code\":\"return ((Q['peoples_party'] || 0) == 1);\"},\"tags\":[\"endings\"],\"goTo\":[{\"id\":\"game_over.eg_menu\"}],\"content\":{\"content\":\"The SPD has been declared a \\\"People's Party\\\", representing all of the people, not just the working class. This policy has many supporters and detractors, and what will become of the party is still unclear.\",\"type\":\"paragraph\"}},\"foreign_policy.concordat\":{\"id\":\"foreign_policy.concordat\",\"title\":\"We can sign a Concordat with the Vatican!\",\"viewIf\":{\"$code\":\"return (((Q['reichskonkordat_progress'] || 0) >= 4) && ((Q['reichskonkordat'] || 0)===0));\"},\"onArrival\":[{\"$code\":\"Q['reichskonkordat'] = 1;\\nQ['z_relation'] = (Q['z_relation'] || 0) + (15 * (1 - (Q['dissent'] || 0)));\\nQ['catholics_spd'] = (Q['catholics_spd'] || 0) + (8 * (1 - (Q['dissent'] || 0)));\\n if ((((((Q['in_weimar_coalition'] || 0)) !== 0) || (((Q['in_grand_coalition'] || 0)) !== 0)) || (((Q['in_popular_front'] || 0)) !== 0)) ) { Q['catholics_z'] = (Q['catholics_z'] || 0) + 5; }\"}],\"achievement\":\"reichskonkordat\",\"content\":{\"content\":\"We have successfully signed a Concordat between Germany and the Roman Catholic Church! This treaty defines a formal relationship between the Church and the German state, guaranteeing freedom of worship for Catholics, and the right of the church to appoint their own clergy. Catholics in Germany are pleased, as are their representatives in the Center Party.\",\"type\":\"paragraph\"}},\"election_1928.far_right_braun\":{\"id\":\"election_1928.far_right_braun\",\"onArrival\":[{\"$code\":\"Q['coup_progress'] = (Q['coup_progress'] || 0) + 2;\"}],\"options\":[{\"id\":\"@election_1928.emergency_braun\",\"title\":\"We will form an emergency government with Braun's support.\"},{\"id\":\"@election_1928.new_elections\",\"title\":\"We will have new elections.\"},{\"id\":\"@election_1928.far_right_win\",\"title\":\"Let the Nazis form their government.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":[\"President Braun faces a dilemma. Is it \\\"democratic\\\" to let democracy be destroyed, if the majority of voters have willed it so? Some, even on the left, suggest that the Nazis would not \",{\"type\":\"emphasis-1\",\"content\":\"truly\"},\" be as horrific as their platform suggests, and that giving them power would let them discredit themselves in the eyes of the public.\"]},{\"type\":\"paragraph\",\"content\":\"Alternatively, Braun could use the emergency powers of the presidency. Article 48 has been used by Hindenburg to promulgate anti-democratic and anti-worker policies; can Article 48 be used for good as well as evil?\"}]},\"march_on_berlin.new_elections_hindenburg_reject\":{\"id\":\"march_on_berlin.new_elections_hindenburg_reject\",\"options\":[{\"id\":\"@march_on_berlin.resign\"},{\"id\":\"@march_on_berlin.fight\"}],\"content\":{\"content\":\"Influenced by his inner circle and by the fascists in the streets, President Hindenburg rejects our offer of new free and fair elections, and again demands that we resign. There is no arguing.\",\"type\":\"paragraph\"}},\"presidential_election_1932.convince_liberals_fail\":{\"id\":\"presidential_election_1932.convince_liberals_fail\",\"onArrival\":[{\"$code\":\"Q['dvp_support_braun'] = 0;\"}],\"goTo\":[{\"id\":\"presidential_election_1932.braun_campaign\"}],\"content\":{\"content\":\"We failed to convince the DVP to support Braun.\",\"type\":\"paragraph\"}},\"rally.wtb\":{\"id\":\"rally.wtb\",\"viewIf\":{\"$code\":\"return ((Q['wtb_adopted'] || 0)===1);\"},\"onArrival\":[{\"$code\":\"Q['wtb_support'] = (Q['wtb_support'] || 0) + 1;\\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (6 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (6 * (1 - (Q['dissent'] || 0)));\\nQ['rural_spd'] = (Q['rural_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\"}],\"content\":{\"content\":\"The WTB plan has become a popular rallying cry for our party. The workers are eager to go back to work, and that is exactly what the plan promises.\",\"type\":\"paragraph\"}},\"shuffle_leadership.remove_rosenfeld\":{\"id\":\"shuffle_leadership.remove_rosenfeld\",\"title\":\"Remove Rosenfeld\",\"viewIf\":{\"$code\":\"return ((Q['rosenfeld_advisor'] || 0)===1);\"},\"tags\":[\"remove_advisor\"],\"onArrival\":[{\"$code\":\"Q['rosenfeld_advisor'] = 0;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 3;\\nQ['n_advisors'] = (Q['n_advisors'] || 0) - 1;\"}],\"goTo\":[{\"id\":\"shuffle_leadership.rm_main\"}],\"content\":{\"content\":\"Rosenfeld has been removed as an advisor. The Leftist faction disapproves.\",\"type\":\"paragraph\"}},\"game_over.nationalization_achieved\":{\"id\":\"game_over.nationalization_achieved\",\"title\":\"Socialization of the economy has commenced.\",\"viewIf\":{\"$code\":\"return ((Q['nationalization_progress'] || 0) >= 2);\"},\"tags\":[\"endings\"],\"goTo\":[{\"id\":\"game_over.eg_menu\"}],\"content\":{\"content\":\"As part of our socialist economic plan, we have nationalized a substantial portion of the economy, beginning the transition to actual socialism.\",\"type\":\"paragraph\"}},\"foreign_policy.european_union\":{\"id\":\"foreign_policy.european_union\",\"title\":\"Take steps to form a \\\"European Union\\\".\",\"subtitle\":\"Is a \\\"United States of Europe\\\" possible?\",\"unavailableSubtitle\":{\"content\":[{\"type\":\"conditional\",\"content\":\"Our relations with the West are not good enough. \",\"predicate\":0},\" \",{\"type\":\"conditional\",\"content\":\"Our relations with the East are not good enough.\",\"predicate\":1}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['west_relation'] || 0) < 5);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['east_relation'] || 0) < 4);\"}}]},\"viewIf\":{\"$code\":\"return (((Q['reparations'] || 0) <= -2) && ((Q['eu_progress'] || 0) < 2));\"},\"chooseIf\":{\"$code\":\"return (((Q['west_relation'] || 0) >= 5) && ((Q['east_relation'] || 0) >= 4));\"},\"onArrival\":[{\"$code\":\"Q['eu_progress'] = (Q['eu_progress'] || 0) + 1;\\nQ['west_relation'] = (Q['west_relation'] || 0) + 1;\"}],\"content\":{\"content\":\"Forming a \\\"United States of Europe\\\" has long been part of the Social Democratic foreign program. Finally, we are taking steps towards it. Given our positive relations with the other countries of Europe, we can begin to hold multilateral negotiations for more European federalism. It will take time to hammer out the exact shape of this future \\\"European Union\\\", however.\",\"type\":\"paragraph\"}},\"election_1928.left_coalition\":{\"id\":\"election_1928.left_coalition\",\"title\":\"Is a United Left coalition possible?\",\"subtitle\":{\"content\":[\"SPD + KPD \",{\"type\":\"conditional\",\"content\":\"+ SAPD \",\"predicate\":0},\" (\",{\"type\":\"insert\",\"insert\":1},\"%)\"],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['sapd_formed'] || 0)) !== 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['left_coalition'] || 0);\"}}]},\"unavailableSubtitle\":{\"content\":[\"SPD + KPD \",{\"type\":\"conditional\",\"content\":\"+ SAPD \",\"predicate\":0},\" (\",{\"type\":\"insert\",\"insert\":1},\"%). \",{\"type\":\"conditional\",\"content\":\"We do not have adequate relations with the KPD. \",\"predicate\":2},{\"type\":\"conditional\",\"content\":\"The Communists are too committed to their radical ways to partake in government.\",\"predicate\":3}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['sapd_formed'] || 0)) !== 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['left_coalition'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['kpd_relation'] || 0) < 50);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['communist_coalition'] || 0) < 3);\"}}]},\"viewIf\":{\"$code\":\"return ((Q['left_coalition'] || 0) >= 50);\"},\"chooseIf\":{\"$code\":\"return (((((Q['kpd_relation'] || 0) >= 50) || (((Q['kpd_party_leader'] == \\\"Conciliators\\\") && ((Q['kpd_relation'] || 0) >= 40))))) && ((Q['communist_coalition'] || 0) >= 3));\"},\"options\":[{\"id\":\"@election_1928.left_coalition_impossible\",\"title\":\"This is impossible.\"},{\"id\":\"@election_1928.left_coalition_possible\",\"title\":\"This could be possible.\"}],\"content\":[{\"type\":\"paragraph\",\"content\":\"There are enough votes for a SPD + KPD coalition government, if such a thing were actually possible.\"},{\"type\":\"paragraph\",\"content\":\"The far-right might attempt a coup, if such a coalition were formed.\"}]},\"march_on_berlin.resign\":{\"id\":\"march_on_berlin.resign\",\"title\":\"Resign our positions in the government.\",\"chooseIf\":{\"$code\":\"return (Q['president'] != \\\"Braun\\\");\"},\"unavailableSubtitle\":\"President Braun cannot resign.\",\"onArrival\":[{\"$code\":\"Q['chancellor'] = \\\"Papen\\\";\\nQ['chancellor_party'] = \\\"I\\\";\\nQ['spd_in_government'] = 0;\"}],\"goTo\":[{\"id\":\"march_on_berlin.accept\"}],\"content\":{\"content\":\"We have resigned our positions in the government.\",\"type\":\"paragraph\"}},\"presidential_election_1932.final_election\":{\"id\":\"presidential_election_1932.final_election\",\"onArrival\":[{\"$code\":\"Q['election_round'] = 0;\"}],\"goTo\":[{\"id\":\"election_algorithm\"}],\"setJump\":\"presidential_election_1932.post_election\",\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"rally.local\":{\"id\":\"rally.local\",\"onArrival\":[{\"$code\":\"Q['workers_spd'] = (Q['workers_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) + (1 * (1 - (Q['dissent'] || 0)));\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) + (2 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (3 * (1 - (Q['dissent'] || 0)));\"}],\"content\":{\"content\":\"Our speakers have gauged the mood and are speaking to the issues that seem to most affect the workers in this moment.\",\"type\":\"paragraph\"}},\"rally\":{\"id\":\"rally\",\"type\":\"scene\",\"title\":\"Political Rally\",\"newPage\":true,\"isCard\":true,\"tags\":[\"party_affairs\"],\"viewIf\":{\"$code\":\"return ((Q['rally_timer'] || 0) <= 0);\"},\"onArrival\":[{\"$code\":\"Q['month_actions'] = (Q['month_actions'] || 0) + 1;\\nQ['rally_timer'] = 6;\"}],\"cardImage\":\"img/protest.jpg\",\"goTo\":[{\"id\":\"rally.main_rally\"},{\"id\":\"rally.sa_disrupt\",\"predicate\":{\"$code\":\"return (((Q['sa_strength'] || 0) > 180) && (!(((Q['sa_banned'] || 0)) !== 0)));\"}}],\"content\":{\"content\":\"\",\"type\":\"paragraph\"}},\"shuffle_leadership.remove_seydewitz\":{\"id\":\"shuffle_leadership.remove_seydewitz\",\"title\":\"Remove Seydewitz\",\"viewIf\":{\"$code\":\"return ((Q['seydewitz_advisor'] || 0)===1);\"},\"tags\":[\"remove_advisor\"],\"onArrival\":[{\"$code\":\"Q['seydewitz_advisor'] = 0;\\nQ['left_dissent'] = (Q['left_dissent'] || 0) + 3;\\nQ['n_advisors'] = (Q['n_advisors'] || 0) - 1;\"}],\"goTo\":[{\"id\":\"shuffle_leadership.rm_main\"}],\"content\":{\"content\":\"Seydewitz has been removed as an advisor. The Leftist faction disapproves.\",\"type\":\"paragraph\"}},\"game_over.works_councils\":{\"id\":\"game_over.works_councils\",\"title\":\"Works councils have more power.\",\"viewIf\":{\"$code\":\"return ((Q['works_councils'] || 0) >= 3);\"},\"tags\":[\"endings\"],\"goTo\":[{\"id\":\"game_over.eg_menu\"}],\"content\":{\"content\":\"Works councils now have substantially greater influence, giving workers democratic control over their economic lives.\",\"type\":\"paragraph\"}},\"foreign_policy.european_union_2\":{\"id\":\"foreign_policy.european_union_2\",\"title\":\"We can sign a treaty to form a European Union!\",\"viewIf\":{\"$code\":\"return ((((Q['west_relation'] || 0) >= 5) && ((Q['east_relation'] || 0) >= 4)) && ((Q['eu_progress'] || 0) >= 2));\"},\"onArrival\":[{\"$code\":\"Q['eu'] = 1;\\n if (((Q['unemployed'] || 0) >= 10) ) { Q['unemployed'] = (Q['unemployed'] || 0) - 2; } \\n if (((Q['inflation'] || 0) <= -2) ) { Q['inflation'] = (Q['inflation'] || 0) + 2; } \\n if (((Q['inflation'] || 0) >= 4.5) ) { Q['inflation'] = (Q['inflation'] || 0) - 1; } \\nQ['workers_spd'] = (Q['workers_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['new_middle_spd'] = (Q['new_middle_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['old_middle_spd'] = (Q['old_middle_spd'] || 0) + (5 * (1 - (Q['dissent'] || 0)));\\nQ['rural_spd'] = (Q['rural_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\nQ['catholics_spd'] = (Q['catholics_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\nQ['unemployed_spd'] = (Q['unemployed_spd'] || 0) + (4 * (1 - (Q['dissent'] || 0)));\\nQ['pro_republic'] = (Q['pro_republic'] || 0) + 5;\\nQ['nationalism'] = (Q['nationalism'] || 0) - 5;\\nQ['budget'] = (Q['budget'] || 0) + 1;\"}],\"maxVisits\":1,\"achievement\":\"eu\",\"content\":[{\"type\":\"paragraph\",\"content\":\"Along with France, Great Britain, and many other states of Western and Eastern Europe, we have signed a treaty to form a European Union! It is hoped that Europe has learned the lessons of the Great War; never again will there be another war that tears the continent apart.\"},{\"type\":\"paragraph\",\"content\":\"A major component of the union is the free movement of people and goods across the countries of Europe, as well as the stabilization of currency exchange rates. This provides new markets for German products and new sources of investment.\"},{\"type\":\"paragraph\",\"content\":\"Fascist Italy remains a problem, and the Soviet Union also lies outside the system. But for now, there is new hope for peace and prosperity throughout the continent.\"}],\"countVisitsMax\":1},\"foreign_policy\":{\"id\":\"foreign_policy\",\"type\":\"scene\",\"title\":\"Foreign Policy\",\"newPage\":true,\"isCard\":true,\"tags\":[\"govt_affairs\"],\"onArrival\":[{\"$code\":\"Q['month_actions'] = (Q['month_actions'] || 0) + 1;\\nQ['foreign_policy_timer'] = (Q['foreign_policy_timer'] || 0) + 8;\"}],\"viewIf\":{\"$code\":\"return ((((Q['spd_in_government'] || 0)===1) && (Q['foreign_minister_party'] == \\\"SPD\\\")) && ((Q['foreign_policy_timer'] || 0) <= 0));\"},\"cardImage\":\"img/portraits/BreitscheidRudolf.jpg\",\"goTo\":[{\"id\":\"foreign_policy.fp_menu\"}],\"content\":[{\"type\":\"heading\",\"content\":\"Foreign Policy\"},{\"type\":\"paragraph\",\"content\":\"What should our foreign policy priority be?\"}]},\"election_1928.left_coalition_impossible\":{\"id\":\"election_1928.left_coalition_impossible\",\"goTo\":[{\"id\":\"election_1928.coalition_menu\"}],\"content\":{\"content\":\"A far left coalition is impossible.\",\"type\":\"paragraph\"}},\"march_on_berlin.braun_appoints_hitler\":{\"id\":\"march_on_berlin.braun_appoints_hitler\",\"title\":\"We cannot do anything but appoint Hitler chancellor.\",\"viewIf\":{\"$code\":\"return (Q['president'] == \\\"Braun\\\");\"},\"chooseIf\":{\"$code\":\"return (((Q['nsdap_normalized'] || 0) >= 0.5) || (Q['largest_party'] == \\\"NSDAP\\\"));\"},\"unavailableSubtitle\":{\"content\":[\"There is no way President \",{\"type\":\"insert\",\"insert\":0},\" could do such a blatantly undemocratic act.\"],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['president'] || 0);\"}}]},\"onArrival\":[{\"$code\":\"Q['chancellor'] = \\\"Hitler\\\";\\nQ['chancellor_party'] = \\\"NSDAP\\\";\\nQ['spd_in_government'] = 0;\"}],\"options\":[{\"id\":\"@hitler_takes_power\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"Threatened with a civil war, and unwilling to fight anymore, President \",{\"type\":\"insert\",\"insert\":0},\" dismisses the current government and appoints Hitler of the NSDAP as chancellor.\"]},\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['president'] || 0);\"}}]}},\"march_on_berlin\":{\"id\":\"march_on_berlin\",\"type\":\"scene\",\"title\":\"March on Berlin\",\"subtitle\":\"Right-wing militants are taking action...\",\"viewIf\":{\"$code\":\"return (((((((Q['spd_in_government'] || 0)===1) && ((Q['coup_progress'] || 0) >= 10)) && ((Q['year'] || 0) >= 1930)) && ((((Q['sa_banned'] || 0)===0) || ((Q['sh_banned'] || 0)===0))))) || (((((Q['year'] || 0) >= 1933) && ((Q['month'] || 0) >= 2)) && (((Q['nsdap_normalized'] || 0) + (Q['dnvp_normalized'] || 0)) >= 0.5))));\"},\"newPage\":true,\"maxVisits\":1,\"onArrival\":[{\"$code\":\"Q['march_on_berlin_seen'] = 1;\\nQ['sa_strength'] = (Q['sa_strength'] || 0) + 80;\\nQ['sh_strength'] = (Q['sh_strength'] || 0) + 80;\\nQ['strife'] = (Q['strife'] || 0) + 1;\"}],\"goTo\":[{\"id\":\"march_on_berlin.ask_resign\",\"predicate\":{\"$code\":\"return ((((Q['spd_in_government'] || 0)) !== 0) && (Q['president'] != \\\"Braun\\\"));\"}},{\"id\":\"march_on_berlin.govt_menu\",\"predicate\":{\"$code\":\"return (Q['president'] == \\\"Braun\\\");\"}},{\"id\":\"march_on_berlin.non_govt_menu\",\"predicate\":{\"$code\":\"return (((Q['spd_in_government'] || 0)===0) && (Q['president'] != \\\"Braun\\\"));\"}}],\"tags\":[\"event\"],\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"March on Berlin\"},{\"type\":\"paragraph\",\"content\":\"The far right is mobilizing. Paramilitary forces of the Stahlhelm and SA, organized under the Harzburg Front, have marched on Berlin, threatening to violently overthrow the government.\"},{\"type\":\"paragraph\",\"content\":[\"They demand either immediate elections under the \\\"supervision\\\" of the nationalist paramilitaries, or else the immediate resignation of the government and the appointment of Adolf Hitler as chancellor\",{\"type\":\"conditional\",\"content\":\", and the revocation of his deportation \",\"predicate\":0},\". It is obvious that they are threatening a civil war if their demands are not met.\"]}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (((Q['hitler_deported'] || 0)) !== 0);\"}}]},\"countVisitsMax\":1},\"presidential_election_1932.post_election\":{\"id\":\"presidential_election_1932.post_election\",\"onArrival\":[{\"$code\":\"Q.braun_votes = 0;\\nQ.hindenburg_votes = 0;\\nQ.hitler_votes = 0;\\nQ.thalmann_votes = 0;\\n\\n// initial phase:\\nQ.hitler_votes += Q.nsdap_normalized;\\nQ.hindenburg_votes += Q.other_normalized;\\nQ.hindenburg_votes += Q.dnvp_normalized;\\n\\nif (Q.braun_campaign) {\\n    Q.braun_votes += Q.spd_normalized;\\n    Q.braun_votes += Q.ddp_normalized;\\n    if (Q.z_support_braun && Q.z_support_braun == 1) {\\n        Q.braun_votes += Q.z_normalized;\\n    } else {\\n        Q.hindenburg_votes += Q.z_normalized;\\n    }\\n    if (Q.kpd_support_braun) {\\n        Q.braun_votes += Q.kpd_normalized;\\n        if (Q.sapd_formed && Q.sapd_votes) {\\n            Q.braun_votes += Q.sapd_normalized;\\n        }\\n    } else {\\n        Q.thalmann_votes += Q.kpd_normalized;\\n        if (Q.sapd_formed && Q.sapd_votes) {\\n            Q.thalmann_votes += Q.sapd_normalized;\\n        }\\n    }\\n    if (Q.dvp_support_braun) {\\n        Q.braun_votes += Q.dvp_normalized;\\n    } else {\\n        Q.hindenburg_votes += Q.dvp_normalized;\\n    }\\n} else if (Q.spd_support_thalmann) {\\n    Q.thalmann_votes += Q.kpd_normalized;\\n    Q.thalmann_votes += Q.spd_normalized;\\n    Q.hindenburg_votes += Q.z_normalized;\\n    Q.hindenburg_votes += Q.ddp_normalized;\\n    Q.hindenburg_votes += Q.dvp_normalized;\\n} else {\\n    Q.hindenburg_votes += Q.spd_normalized;\\n    Q.hindenburg_votes += Q.z_normalized;\\n    Q.hindenburg_votes += Q.ddp_normalized;\\n    Q.hindenburg_votes += Q.dvp_normalized;\\n    Q.thalmann_votes += Q.kpd_normalized;\\n}\\nif (Q.hitler_support_hindenburg) {\\n    Q.hitler_votes -= Q.nsdap_normalized;\\n    Q.hindenburg_votes += Q.nsdap_normalized;\\n}\\n\\nif (Q.hindenburg_to_braun_bonus) {\\n    Q.hindenburg_votes -= Q.hindenburg_to_braun_bonus;\\n    Q.braun_votes += Q.hindenburg_to_braun_bonus;\\n}\\nif (Q.thalmann_to_braun_bonus) {\\n    Q.thalmann_votes -= Q.thalmann_to_braun_bonus;\\n    Q.braun_votes += Q.thalmann_to_braun_bonus;\\n}\\n\\n// check for majority\\nQ.hindenburg_votes = Math.round(Q.hindenburg_votes*100);\\nQ.braun_votes = Math.round(Q.braun_votes*100);\\nQ.hitler_votes = Math.round(Q.hitler_votes*100);\\nQ.thalmann_votes = Math.round(Q.thalmann_votes*100);\\n\\nQ.hindenburg_majority = (Q.hindenburg_votes >= 50);\\nQ.thalmann_majority = (Q.thalmann_votes >= 50);\\nQ.hitler_majority = (Q.hitler_votes >= 50);\\nQ.braun_majority = (Q.braun_votes >= 50);\\nQ.any_majority = Q.hindenburg_majority | Q.thalmann_majority | Q.hitler_majority | Q.braun_majority;\\n\\n// check for plurality\\nQ.hindenburg_plurality = (Q.hindenburg_votes >= Q.hitler_votes && Q.hindenburg_votes >= Q.braun_votes && Q.hindenburg_votes >= Q.thalmann_votes);\\nQ.thalmann_plurality = (Q.thalmann_votes >= Q.hindenburg_votes && Q.thalmann_votes >= Q.braun_votes && Q.thalmann_votes >= Q.hitler_votes);\\nQ.hitler_plurality = (Q.hitler_votes >= Q.hindenburg_votes && Q.hitler_votes >= Q.braun_votes && Q.hitler_votes >= Q.thalmann_votes);\\nQ.braun_plurality = (Q.braun_votes >= Q.hindenburg_votes && Q.braun_votes >= Q.hitler_votes && Q.braun_votes >= Q.thalmann_votes);\\n// If no candidate gets above 50%, then there's a second round. In the second round, a plurality wins.\\nQ.election_round += 1;\"}],\"goTo\":[{\"id\":\"presidential_election_1932.hindenburg_wins\",\"predicate\":{\"$code\":\"return ((Q['hindenburg_majority'] || 0) == 1);\"}},{\"id\":\"presidential_election_1932.thalmann_wins\",\"predicate\":{\"$code\":\"return ((Q['thalmann_majority'] || 0) == 1);\"}},{\"id\":\"presidential_election_1932.hitler_wins\",\"predicate\":{\"$code\":\"return ((Q['hitler_majority'] || 0) == 1);\"}},{\"id\":\"presidential_election_1932.braun_wins\",\"predicate\":{\"$code\":\"return ((Q['braun_majority'] || 0) == 1);\"}},{\"id\":\"presidential_election_1932.no_majority_round1\",\"predicate\":{\"$code\":\"return (((Q['any_majority'] || 0) == 0) && ((Q['election_round'] || 0) == 1));\"}},{\"id\":\"presidential_election_1932.round2_results\",\"predicate\":{\"$code\":\"return ((Q['election_round'] || 0) >= 2);\"}}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"Results:\"},{\"type\":\"paragraph\",\"content\":[\"Hindenburg - \",{\"type\":\"insert\",\"insert\":0},\"%\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"insert\",\"insert\":1},\" - \",{\"type\":\"insert\",\"insert\":2},\"%\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"Thälmann - \",{\"type\":\"insert\",\"insert\":4},\"% \"],\"predicate\":3},\"\"]},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":[\"Braun - \",{\"type\":\"insert\",\"insert\":6},\"%\"],\"predicate\":5}}],\"stateDependencies\":[{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['hindenburg_votes'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['nsdap_candidate'] || 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['hitler_votes'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['kpd_support_braun'] || 0) == 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['thalmann_votes'] || 0);\"}},{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((Q['braun_campaign'] || 0) > 0);\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['braun_votes'] || 0);\"}}]}},\"shuffle_leadership.remove_mierendorff\":{\"id\":\"shuffle_leadership.remove_mierendorff\",\"title\":\"Remove Mierendorff\",\"viewIf\":{\"$code\":\"return ((Q['mierendorff_advisor'] || 0)===1);\"},\"tags\":[\"remove_advisor\"],\"onArrival\":[{\"$code\":\"Q['mierendorff_advisor'] = 0;\\nQ['neorevisionist_dissent'] = (Q['neorevisionist_dissent'] || 0) + 5;\\nQ['n_advisors'] = (Q['n_advisors'] || 0) - 1;\"}],\"goTo\":[{\"id\":\"shuffle_leadership.rm_main\"}],\"content\":{\"content\":\"Mierendorff has been removed as an advisor. The Neorevisionist faction disapproves.\",\"type\":\"paragraph\"}},\"game_over.european_union\":{\"id\":\"game_over.european_union\",\"title\":\"There is now a European Union!\",\"viewIf\":{\"$code\":\"return ((Q['eu'] || 0)===1);\"},\"tags\":[\"endings\"],\"goTo\":[{\"id\":\"game_over.eg_menu\"}],\"content\":{\"content\":\"We have helped to form a European Union to bring peace and prosperity to the continent. Time will tell how effective it will be.\",\"type\":\"paragraph\"}},\"election_1928.left_coalition_possible\":{\"id\":\"election_1928.left_coalition_possible\",\"options\":[{\"id\":\"@election_1928.thalmann_chancellor\",\"title\":\"Appoint Thälmann as chancellor.\"},{\"id\":\"@election_1928.left_coalition_resources\"},{\"id\":\"@election_1928.left_coalition_relations\"},{\"id\":\"@election_1928.coalition_menu\",\"title\":\"Try a different governing arrangement.\"}],\"content\":{\"content\":{\"type\":\"paragraph\",\"content\":[\"The KPD is still very reluctant to join a coalition, despite grassroots friendliness between our memberships. The Stalinist leadership is vehemently against such a thing. They demand the appointment of Ernst Thälmann as chancellor in exchange for a coalition. \",{\"type\":\"conditional\",\"content\":\"There is no chance whatsoever that President Hindenburg would approve of the appointment of a die-hard communist as chancellor. \",\"predicate\":0},\" Alternatively, if our relations with them are good enough, we could convince them to support the appointment of one of our centrist or left-leaning members as chancellor.\"]},\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return (Q['president'] == \\\"Hindenburg\\\");\"}}]}},\"presidential_election_1932.no_majority_round1\":{\"id\":\"presidential_election_1932.no_majority_round1\",\"onArrival\":[{\"$code\":\"if ((((((Q['braun_plurality'] || 0)) !== 0) || (((Q['thalmann_plurality'] || 0)) !== 0))) ) { Q['hitler_support_hindenburg'] = 1; }\"}],\"goTo\":[{\"id\":\"presidential_election_1932.round2_menu\"}],\"content\":{\"content\":[{\"type\":\"paragraph\",\"content\":\"There is no majority in this round. In the second round, any candidate who wins a plurality will win overall. What should we do?\"},{\"type\":\"paragraph\",\"content\":{\"type\":\"conditional\",\"content\":[\"In order to consolidate the vote for the Right, and to prevent a socialist from becoming president, \",{\"type\":\"insert\",\"insert\":1},\" is no longer running in the second round, and has switched his endorsement to Hindenburg.\"],\"predicate\":0}}],\"stateDependencies\":[{\"type\":\"predicate\",\"fn\":{\"$code\":\"return ((((Q['braun_plurality'] || 0)) !== 0) || (((Q['thalmann_plurality'] || 0)) !== 0));\"}},{\"type\":\"insert\",\"fn\":{\"$code\":\"return (Q['nsdap_candidate'] || 0);\"}}]}},\"shuffle_leadership.remove_leber\":{\"id\":\"shuffle_leadership.remove_leber\",\"title\":\"Remove Leber\",\"viewIf\":{\"$code\":\"return ((Q['leber_advisor'] || 0)===1);\"},\"tags\":[\"remove_advisor\"],\"onArrival\":[{\"$code\":\"Q['leber_advisor'] = 0;\\nQ['neorevisionist_dissent'] = (Q['neorevisionist_dissent'] || 0) + 3;\\nQ['n_advisors'] = (Q['n_advisors'] || 0) - 1;\"}],\"goTo\":[{\"id\":\"shuffle_leadership.rm_main\"}],\"content\":{\"content\":\"Leber has been removed as an advisor. The Neorevisionist faction disapproves.\",\"type\":\"paragraph\"}},\"game_over.achievements\":{\"id\":\"game_over.achievements\",\"title\":\"Achievements\",\"viewIf\":{\"$code\":\"return ((Q['achievement_game_completed'] || 0) == 1);\"},\"tags\":[\"endings\"],\"goTo\":[{\"id\":\"game_over.eg_menu\",\"predicate\":{\"$code\":\"return ((Q['started'] || 0) == 1);\"}},{\"id\":\"root.start_menu_2\",\"predicate\":{\"$code\":\"return ((Q['started'] || 0) == 0);\"}}],\"content\":{\"content\":[{\"type\":\"heading\",\"content\":\"Completed Achievements in this Playthrough\"},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Eiserne Front\"},\" - form the Iron Front. \"],\"predicate\":0},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Bürgerkrieg\"},\" - enter a long civil war. \"],\"predicate\":1},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Einigkeit\"},\" - reach the end of 1933 without a civil war on easy. \"],\"predicate\":2},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Einigkeit und Recht\"},\" - reach the end of 1933 without a civil war on normal. \"],\"predicate\":3},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Einigkeit und Recht und Freiheit\"},\" - reach the end of 1933 without a civil war on hard. \"],\"predicate\":4},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Schwarz-Rot-Gold\"},\" - reach the end of 1933 without a civil war on historical mode. \"],\"predicate\":5},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Sieg für die Republik\"},\" - win the civil war. \"],\"predicate\":6},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Bollwerk der Demokratie\"},\" - Resist the Prussian Coup and win. \"],\"predicate\":7},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Roter Zar von Preußen\"},\" - Otto Braun is President, Chancellor, and Minister-President. \"],\"predicate\":8},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Einheitsfront\"},\" - Form a government consisting of the SPD and KPD. \"],\"predicate\":9},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Sieg für die Einheitsfront\"},\" - Form a Left Front that survives the KPD demands. \"],\"predicate\":10},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Volksfront\"},\" - Form a government consisting of the SPD, KPD, Z, and DDP. \"],\"predicate\":11},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Große Volksfront\"},\" - With Joos leading the Center Party and the Conciliators leading the KPD, form a government consisting of the SPD, KPD, Z, and DDP. \"],\"predicate\":12},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Sieg für die Volksfront\"},\" - Form a Popular Front that survives the KPD demands. \"],\"predicate\":13},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Verfassungskoalition\"},\" - form a \\\"constitutional coalition\\\". \"],\"predicate\":14},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Weimarer Koalition\"},\" - form a Weimar coalition. \"],\"predicate\":15},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Mehrheitspartei\"},\" - form an SPD-only majority government. \"],\"predicate\":16},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Minderheitsregierung\"},\" - form an SPD minority government. \"],\"predicate\":17},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Volkspartei\"},\" - the SPD is a People's Party. \"],\"predicate\":18},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Sohn seiner Klasse\"},\" - Ernst Thälmann is either president or chancellor. \"],\"predicate\":19},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Versöhnler\"},\" - the Conciliators lead the KPD. \"],\"predicate\":20},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Der österreichische Gefreiter\"},\" - deported Hitler \"],\"predicate\":21},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Wirtschaftspolitik\"},\" - enact an economic plan. \"],\"predicate\":22},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Wirtschaftswunder\"},\" - In 1933, have unemployment less than 10%, inflation below 5%, and a budget surplus. \"],\"predicate\":23},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Wirtschaftsexperiment\"},\" - enact two different economic plans. \"],\"predicate\":24},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Freie Marktwirtschaft\"},\" - survive to 1933 without adopting an economic plan. \"],\"predicate\":25},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Gleichheit\"},\" - pass reforms for women's rights. \"],\"predicate\":26},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Hirschfeld\"},\" - pass reforms for homosexual rights. \"],\"predicate\":27},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Mädchen in Uniform\"},\" - a woman's place is in the Reichsbanner. \"],\"predicate\":28},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Brüder, zur Sonne, zur Freiheit\"},\" - reduce unemployment, pause reparations, increase women's rights, elect Otto Braun president, and deport Hitler in one playthrough on at least normal difficulty. \"],\"predicate\":29},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Die Rote Fahne\"},\" - join the KPD in their May Day march. \"],\"predicate\":30},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Panik im Mittelstand\"},\" - SPD new middle class support is at least 50%. \"],\"predicate\":31},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Bauernrevolution\"},\" - SPD rural support is at least 50%. \"],\"predicate\":32},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Katholischer Sozialismus\"},\" - SPD Catholic support is at least 50%. \"],\"predicate\":33},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Klassenkampf\"},\" - SPD worker support is at least 80%, while middle-class and rural supports are less than 20%. \"],\"predicate\":34},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Räterepublik\"},\" - begin the transformation to a socialist economy. \"],\"predicate\":35},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Polykrise\"},\" - survive a capital strike and a fascist coup. \"],\"predicate\":36},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Syndikalismus\"},\" - support factory takeovers by the workers. \"],\"predicate\":37},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Drei Pfeile\"},\" - defeat a coup without a civil war. \"],\"predicate\":38},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Ausnahmezustand\"},\" - use emergency powers to cancel elections. \"],\"predicate\":39},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Vereinigte Staaten von Europa\"},\" - form a \\\"European Union\\\". \"],\"predicate\":40},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Heidelberger Programm\"},\" - achieve the goals of the SPD's Heidelberg Program: social welfare, judicial reform, women's rights in the workplace and family, progressive taxation, works councils, and the formation of a European Union. \"],\"predicate\":41},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Verfassungsreform\"},\" - pass a constitutional amendment. \"],\"predicate\":42},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Stolperstein\"},\" - we lost, but history might memorialize us... \"],\"predicate\":43},\"\"]},{\"type\":\"heading\",\"content\":\"Completed Achievements Overall\"},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Eiserne Front\"},\" - form the Iron Front. \"],\"predicate\":44},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Bürgerkrieg\"},\" - enter a long civil war. \"],\"predicate\":45},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Einigkeit\"},\" - reach the end of 1933 without a civil war on easy. \"],\"predicate\":46},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Einigkeit und Recht\"},\" - reach the end of 1933 without a civil war on normal. \"],\"predicate\":47},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Einigkeit und Recht und Freiheit\"},\" - reach the end of 1933 without a civil war on hard. \"],\"predicate\":48},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Schwarz-Rot-Gold\"},\" - reach the end of 1933 without a civil war on historical mode. \"],\"predicate\":49},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Sieg für die Republik\"},\" - win the civil war. \"],\"predicate\":50},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Bollwerk der Demokratie\"},\" - Resist the Prussian Coup and win. \"],\"predicate\":51},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Roter Zar von Preußen\"},\" - Otto Braun is President, Chancellor, and Minister-President. \"],\"predicate\":52},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Einheitsfront\"},\" - Form a government consisting of the SPD and KPD. \"],\"predicate\":53},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Sieg für die Einheitsfront\"},\" - Form a Left Front that survives the KPD demands. \"],\"predicate\":54},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Volksfront\"},\" - Form a government consisting of the SPD, KPD, Z, and DDP. \"],\"predicate\":55},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Große Volksfront\"},\" - With Joos leading the Center Party and the Conciliators leading the KPD, form a government consisting of the SPD, KPD, Z, and DDP. \"],\"predicate\":56},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Sieg für die Volksfront\"},\" - Form a Popular Front that survives the KPD demands. \"],\"predicate\":57},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Verfassungskoalition\"},\" - form a \\\"constitutional coalition\\\". \"],\"predicate\":58},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Weimarer Koalition\"},\" - form a Weimar coalition. \"],\"predicate\":59},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Mehrheitspartei\"},\" - form an SPD-only majority government. \"],\"predicate\":60},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Minderheitsregierung\"},\" - form an SPD minority government. \"],\"predicate\":61},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Volkspartei\"},\" - the SPD is a People's Party. \"],\"predicate\":62},\"\"]},{\"type\":\"paragraph\",\"content\":[{\"type\":\"conditional\",\"content\":[\"\",{\"type\":\"emphasis-2\",\"content\":\"Sohn seiner Klasse\"},\" - Erns