/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.server;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Properties;
import simplenlg.server.RealisationRequest;
import simplenlg.xmlrealiser.XMLRealiser;

public class SimpleServer
implements Runnable {
    private ServerSocket serverSocket;
    static boolean DEBUG = false;
    String lexiconPath = "src/main/resources/NIHLexicon/lexAccess2011.data";
    private boolean isActive = true;

    public SimpleServer(int port) throws IOException {
        this.startServer(new ServerSocket(port, 8));
    }

    public SimpleServer(ServerSocket socket) throws IOException {
        this.startServer(socket);
    }

    private void startServer(ServerSocket socket) throws IOException, SocketException {
        this.serverSocket = socket;
        this.serverSocket.setReuseAddress(true);
        this.serverSocket.setSoTimeout(0);
        System.out.println("Port Number used by Server is: " + this.serverSocket.getLocalPort());
        try {
            Properties prop = new Properties();
            FileReader reader = new FileReader(new File("./src/main/resources/lexicon.properties"));
            prop.load(reader);
            String dbFile = prop.getProperty("DB_FILENAME");
            if (null == dbFile) {
                throw new Exception("No DB_FILENAME in lexicon.properties");
            }
            this.lexiconPath = dbFile;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Server is using the following lexicon: " + this.lexiconPath);
        XMLRealiser.setLexicon(XMLRealiser.LexiconType.NIHDB, this.lexiconPath);
    }

    static void print(Object o) {
        System.out.println(o);
    }

    public void terminate() {
        this.isActive = false;
    }

    public void run() {
        try {
            while (this.isActive) {
                try {
                    if (DEBUG) {
                        System.out.println("Waiting for client on port " + this.serverSocket.getLocalPort() + "...");
                    }
                    Socket clientSocket = this.serverSocket.accept();
                    this.handleClient(clientSocket);
                }
                catch (SocketTimeoutException s) {
                    System.err.println("Socket timed out!");
                    break;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.serverSocket.close();
            }
            catch (Exception ee) {
                System.err.println("Could not close socket!");
            }
        }
    }

    protected void handleClient(Socket socket) {
        if (null == socket) {
            return;
        }
        Thread request = new Thread(new RealisationRequest(socket));
        request.setDaemon(true);
        request.start();
    }

    public synchronized void shutdown() {
        System.out.println("Server shutting down.");
        this.terminate();
    }

    public synchronized void exit() {
        this.exit(0);
    }

    public synchronized void exit(int code) {
        System.exit(code);
    }

    public static void main(String[] args) {
        int port;
        try {
            port = Integer.parseInt(args[0]);
        }
        catch (Exception e) {
            port = 50007;
        }
        try {
            SimpleServer serverapp = new SimpleServer(port);
            Thread server = new Thread(serverapp);
            server.setDaemon(true);
            server.start();
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(System.out));
            while (true) {
                try {
                    while (true) {
                        bw.write(":>");
                        bw.flush();
                        String input = br.readLine();
                        if (null == input || input.compareToIgnoreCase("exit") != 0) continue;
                        serverapp.shutdown();
                        serverapp.exit();
                    }
                }
                catch (IOException e) {
                    serverapp.shutdown();
                    e.printStackTrace();
                    serverapp.exit(-1);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }
}

