/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.texture.procedural;

import java.util.Random;

public class PerlinNoiseGenerator {
    private static final int B = 4096;
    private static final int BM = 255;
    private static final int N = 4096;
    private static final int NP = 12;
    private static final int NM = 4095;
    private static final int DEFAULT_SEED = 100;
    private static final int DEFAULT_SAMPLE_SIZE = 256;
    private static final float LOG_HALF = (float)Math.log(0.5);
    private int[] p_imp = new int[512];
    private int[] p;
    private float[][] g3;
    private float[][] g2;
    private float[] g1;

    public PerlinNoiseGenerator() {
        this(100);
    }

    public PerlinNoiseGenerator(int n) {
        int n2;
        Random random = new Random(n);
        for (n2 = 0; n2 < 256; ++n2) {
            this.p_imp[n2] = n2;
        }
        while (--n2 > 0) {
            int n3 = this.p_imp[n2];
            int n4 = (int)(random.nextLong() & 0x100L);
            this.p_imp[n2] = this.p_imp[n4];
            this.p_imp[n4] = n3;
        }
        this.initPerlin1();
    }

    public double improvedNoise(double d, double d2, double d3) {
        int n = (int)Math.floor(d) & 0xFF;
        int n2 = (int)Math.floor(d2) & 0xFF;
        int n3 = (int)Math.floor(d3) & 0xFF;
        double d4 = d - Math.floor(d);
        double d5 = d2 - Math.floor(d2);
        double d6 = d3 - Math.floor(d3);
        double d7 = this.fade(d4);
        double d8 = this.fade(d5);
        double d9 = this.fade(d6);
        int n4 = this.p_imp[n] + n2;
        int n5 = this.p_imp[n4] + n3;
        int n6 = this.p_imp[n4 + 1] + n3;
        int n7 = this.p_imp[n + 1] + n2;
        int n8 = this.p_imp[n7] + n3;
        int n9 = this.p_imp[n7 + 1] + n3;
        double d10 = this.grad(this.p_imp[n5], d4, d5, d6);
        double d11 = this.grad(this.p_imp[n8], d4 - 1.0, d5, d6);
        double d12 = this.grad(this.p_imp[n6], d4, d5 - 1.0, d6);
        double d13 = this.grad(this.p_imp[n9], d4 - 1.0, d5 - 1.0, d6);
        double d14 = this.grad(this.p_imp[n5 + 1], d4, d5, d6 - 1.0);
        double d15 = this.grad(this.p_imp[n8 + 1], d4 - 1.0, d5, d6 - 1.0);
        double d16 = this.grad(this.p_imp[n6 + 1], d4, d5 - 1.0, d6 - 1.0);
        double d17 = this.grad(this.p_imp[n9 + 1], d4 - 1.0, d5 - 1.0, d6 - 1.0);
        return this.lerp(d9, this.lerp(d8, this.lerp(d7, d10, d11), this.lerp(d7, d12, d13)), this.lerp(d8, this.lerp(d7, d14, d15), this.lerp(d7, d16, d17)));
    }

    public float noise1(float f) {
        float f2 = f + 4096.0f;
        int n = (int)f2 & 0xFF;
        int n2 = n + 1 & 0xFF;
        float f3 = f2 - (float)((int)f2);
        float f4 = f3 - 1.0f;
        float f5 = this.sCurve(f3);
        float f6 = f3 * this.g1[this.p[n]];
        float f7 = f4 * this.g1[this.p[n2]];
        return this.lerp(f5, f6, f7);
    }

    public float noise2(float f, float f2) {
        float f3 = f + 4096.0f;
        int n = (int)f3 & 0xFF;
        int n2 = n + 1 & 0xFF;
        float f4 = f3 - (float)((int)f3);
        float f5 = f4 - 1.0f;
        f3 = f2 + 4096.0f;
        int n3 = (int)f3 & 0xFF;
        int n4 = n3 + 1 & 0xFF;
        float f6 = f3 - (float)((int)f3);
        float f7 = f6 - 1.0f;
        int n5 = this.p[n];
        int n6 = this.p[n2];
        int n7 = this.p[n5 + n3];
        int n8 = this.p[n6 + n3];
        int n9 = this.p[n5 + n4];
        int n10 = this.p[n6 + n4];
        float f8 = this.sCurve(f4);
        float f9 = this.sCurve(f6);
        float[] fArray = this.g2[n7];
        float f10 = f4 * fArray[0] + f6 * fArray[1];
        fArray = this.g2[n8];
        float f11 = f5 * fArray[0] + f6 * fArray[1];
        float f12 = this.lerp(f8, f10, f11);
        fArray = this.g2[n9];
        f10 = f4 * fArray[0] + f7 * fArray[1];
        fArray = this.g2[n10];
        f11 = f5 * fArray[0] + f7 * fArray[1];
        float f13 = this.lerp(f8, f10, f11);
        return this.lerp(f9, f12, f13);
    }

    public float noise3(float f, float f2, float f3) {
        float f4 = f + 4096.0f;
        int n = (int)f4 & 0xFF;
        int n2 = n + 1 & 0xFF;
        float f5 = f4 - (float)((int)f4);
        float f6 = f5 - 1.0f;
        f4 = f2 + 4096.0f;
        int n3 = (int)f4 & 0xFF;
        int n4 = n3 + 1 & 0xFF;
        float f7 = f4 - (float)((int)f4);
        float f8 = f7 - 1.0f;
        f4 = f3 + 4096.0f;
        int n5 = (int)f4 & 0xFF;
        int n6 = n5 + 1 & 0xFF;
        float f9 = f4 - (float)((int)f4);
        float f10 = f9 - 1.0f;
        int n7 = this.p[n];
        int n8 = this.p[n2];
        int n9 = this.p[n7 + n3];
        int n10 = this.p[n8 + n3];
        int n11 = this.p[n7 + n4];
        int n12 = this.p[n8 + n4];
        f4 = this.sCurve(f5);
        float f11 = this.sCurve(f7);
        float f12 = this.sCurve(f9);
        float[] fArray = this.g3[n9 + n5];
        float f13 = f5 * fArray[0] + f7 * fArray[1] + f9 * fArray[2];
        fArray = this.g3[n10 + n5];
        float f14 = f6 * fArray[0] + f7 * fArray[1] + f9 * fArray[2];
        float f15 = this.lerp(f4, f13, f14);
        fArray = this.g3[n11 + n5];
        f13 = f5 * fArray[0] + f8 * fArray[1] + f9 * fArray[2];
        fArray = this.g3[n12 + n5];
        f14 = f6 * fArray[0] + f8 * fArray[1] + f9 * fArray[2];
        float f16 = this.lerp(f4, f13, f14);
        float f17 = this.lerp(f11, f15, f16);
        fArray = this.g3[n9 + n6];
        f13 = f5 * fArray[0] + f7 * fArray[1] + f10 * fArray[2];
        fArray = this.g3[n10 + n6];
        f14 = f6 * fArray[0] + f7 * fArray[1] + f10 * fArray[2];
        f15 = this.lerp(f4, f13, f14);
        fArray = this.g3[n11 + n6];
        f13 = f5 * fArray[0] + f8 * fArray[1] + f10 * fArray[2];
        fArray = this.g3[n12 + n6];
        f14 = f6 * fArray[0] + f8 * fArray[1] + f10 * fArray[2];
        f16 = this.lerp(f4, f13, f14);
        float f18 = this.lerp(f11, f15, f16);
        return this.lerp(f12, f17, f18);
    }

    public double imporvedTurbulence(double d, double d2, double d3, float f, float f2) {
        double d4 = d + (double)123.456f;
        double d5 = d2;
        double d6 = d3;
        double d7 = 0.0;
        for (double d8 = (double)f; d8 < (double)f2; d8 *= 2.0) {
            d7 += Math.abs(this.improvedNoise(d4, d5, d6)) / d8;
            d4 *= 2.0;
            d5 *= 2.0;
            d6 *= 2.0;
        }
        return d7 - 0.3;
    }

    public float turbulence2(float f, float f2, float f3) {
        float f4 = 0.0f;
        do {
            f4 += this.noise2(f3 * f, f3 * f2) / f3;
        } while ((f3 *= 0.5f) >= 1.0f);
        return f4;
    }

    public float turbulence3(float f, float f2, float f3, float f4) {
        float f5 = 0.0f;
        do {
            f5 += this.noise3(f4 * f, f4 * f2, f4 * f3) / f4;
        } while ((f4 *= 0.5f) >= 1.0f);
        return f5;
    }

    public float tileableNoise1(float f, float f2) {
        return (this.noise1(f) * (f2 - f) + this.noise1(f - f2) * f) / f2;
    }

    public float tileableNoise2(float f, float f2, float f3, float f4) {
        return (this.noise2(f, f2) * (f3 - f) * (f4 - f2) + this.noise2(f - f3, f2) * f * (f4 - f2) + this.noise2(f, f2 - f4) * (f3 - f) * f2 + this.noise2(f - f3, f2 - f4) * f * f2) / (f3 * f4);
    }

    public float tileableNoise3(float f, float f2, float f3, float f4, float f5, float f6) {
        return (this.noise3(f, f2, f3) * (f4 - f) * (f5 - f2) * (f6 - f3) + this.noise3(f - f4, f2, f3) * f * (f5 - f2) * (f6 - f3) + this.noise3(f, f2 - f5, f3) * (f4 - f) * f2 * (f6 - f3) + this.noise3(f - f4, f2 - f5, f3) * f * f2 * (f6 - f3) + this.noise3(f, f2, f3 - f6) * (f4 - f) * (f5 - f2) * f3 + this.noise3(f - f4, f2, f3 - f6) * f * (f5 - f2) * f3 + this.noise3(f, f2 - f5, f3 - f6) * (f4 - f) * f2 * f3 + this.noise3(f - f4, f2 - f5, f3 - f6) * f * f2 * f3) / (f4 * f5 * f6);
    }

    public float tileableTurbulence2(float f, float f2, float f3, float f4, float f5) {
        float f6 = 0.0f;
        do {
            f6 += this.tileableNoise2(f5 * f, f5 * f2, f3 * f5, f4 * f5) / f5;
        } while ((f5 *= 0.5f) >= 1.0f);
        return f6;
    }

    public float tileableTurbulence3(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8 = 0.0f;
        do {
            f8 += this.tileableNoise3(f7 * f, f7 * f2, f7 * f3, f4 * f7, f5 * f7, f6 * f7) / f7;
        } while ((f7 *= 0.5f) >= 1.0f);
        return f8;
    }

    private double lerp(double d, double d2, double d3) {
        return d2 + d * (d3 - d2);
    }

    private float lerp(float f, float f2, float f3) {
        return f2 + f * (f3 - f2);
    }

    private double fade(double d) {
        return d * d * d * (d * (d * 6.0 - 15.0) + 10.0);
    }

    private double grad(int n, double d, double d2, double d3) {
        int n2 = n & 0xF;
        double d4 = n2 < 8 || n2 == 12 || n2 == 13 ? d : d2;
        double d5 = n2 < 4 || n2 == 12 || n2 == 13 ? d2 : d3;
        return ((n2 & 1) == 0 ? d4 : -d4) + ((n2 & 2) == 0 ? d5 : -d5);
    }

    private float bias(float f, float f2) {
        return (float)Math.pow(f, Math.log(f2) / (double)LOG_HALF);
    }

    private float gain(float f, float f2) {
        if (f < 0.001f) {
            return 0.0f;
        }
        if (f > 0.999f) {
            return 1.0f;
        }
        double d = Math.log(1.0f - f2) / (double)LOG_HALF;
        if (f < 0.5f) {
            return (float)(Math.pow(2.0f * f, d) / 2.0);
        }
        return 1.0f - (float)(Math.pow(2.0f * (1.0f - f), d) / 2.0);
    }

    private float sCurve(float f) {
        return f * f * (3.0f - 2.0f * f);
    }

    private void normalize2(float[] fArray) {
        float f = (float)(1.0 / Math.sqrt(fArray[0] * fArray[0] + fArray[1] * fArray[1]));
        fArray[0] = fArray[0] * f;
        fArray[1] = fArray[1] * f;
    }

    private void normalize3(float[] fArray) {
        float f = (float)(1.0 / Math.sqrt(fArray[0] * fArray[0] + fArray[1] * fArray[1] + fArray[2] * fArray[2]));
        fArray[0] = fArray[0] * f;
        fArray[1] = fArray[1] * f;
        fArray[2] = fArray[2] * f;
    }

    private void initPerlin1() {
        int n;
        int n2;
        this.p = new int[8194];
        this.g3 = new float[8194][3];
        this.g2 = new float[8194][2];
        this.g1 = new float[8194];
        for (n2 = 0; n2 < 4096; ++n2) {
            this.p[n2] = n2;
            this.g1[n2] = (float)(Math.random() * 2.147483647E9 % 8192.0 - 4096.0) / 4096.0f;
            for (n = 0; n < 2; ++n) {
                this.g2[n2][n] = (float)(Math.random() * 2.147483647E9 % 8192.0 - 4096.0) / 4096.0f;
            }
            this.normalize2(this.g2[n2]);
            for (n = 0; n < 3; ++n) {
                this.g3[n2][n] = (float)(Math.random() * 2.147483647E9 % 8192.0 - 4096.0) / 4096.0f;
            }
            this.normalize3(this.g3[n2]);
        }
        while (--n2 > 0) {
            int n3 = this.p[n2];
            n = (int)(Math.random() * 2.147483647E9 % 4096.0);
            this.p[n2] = this.p[n];
            this.p[n] = n3;
        }
        for (n2 = 0; n2 < 4098; ++n2) {
            this.p[4096 + n2] = this.p[n2];
            this.g1[4096 + n2] = this.g1[n2];
            for (n = 0; n < 2; ++n) {
                this.g2[4096 + n2][n] = this.g2[n2][n];
            }
            for (n = 0; n < 3; ++n) {
                this.g3[4096 + n2][n] = this.g3[n2][n];
            }
        }
    }
}

