/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Trie;

import java.lang.reflect.Array;
import java.util.HashSet;

public final class WildCard {
    public static final char VOWEL = 'V';
    public static final char CONSONANT = 'C';
    public static final char SAME_AS_PREV = 'S';
    public static final char DIGIT = 'D';
    public static final char LETTER = 'L';
    public static final char BEGIN = '^';
    public static final char END = '$';
    public static final char FS = '|';
    private static HashSet<String> vowelWildCardSet_ = new HashSet();
    private static HashSet<String> consonantWildCardSet_ = new HashSet();
    private static HashSet<String> wildCardSet_ = new HashSet();
    private static HashSet<String> vowelSet_ = new HashSet();
    private static HashSet<String> consonantSet_ = new HashSet();
    private static HashSet<String> digitSet_ = new HashSet();
    private static HashSet<String> letterSet_ = new HashSet();

    private WildCard() {
    }

    public static String GetSuffix(String inSuffix, String outSuffix, String inStr) {
        int size = inStr.length();
        int inSize = inSuffix.length();
        String endStr = inStr.substring(size - inSize);
        StringBuffer suffixStr = new StringBuffer();
        for (int i = 0; i < outSuffix.length(); ++i) {
            char curChar = outSuffix.charAt(i);
            if (WildCard.IsLegalWildCard(curChar) && curChar != '$') {
                if (i >= inSuffix.length() - 1) {
                    suffixStr.append(endStr.charAt(endStr.length() - 2));
                    continue;
                }
                suffixStr.append(endStr.charAt(i));
                continue;
            }
            suffixStr.append(curChar);
        }
        return suffixStr.toString();
    }

    public static boolean IsMatchKey(char key, int index, char[] inCharArray) {
        boolean matchFlag = false;
        if (WildCard.IsWildCard(key) && !WildCard.IsLegalWildCard(key)) {
            return false;
        }
        char curChar = inCharArray[index];
        String curStr = String.valueOf(curChar);
        if (key == inCharArray[index]) {
            matchFlag = true;
        } else if (key == 'V' && vowelSet_.contains(curStr)) {
            matchFlag = true;
        } else if (key == 'C' && consonantSet_.contains(curStr)) {
            matchFlag = true;
        } else if (key == 'S' && index < Array.getLength(inCharArray) - 1 && curChar == inCharArray[index + 1]) {
            matchFlag = true;
        } else if (key == 'D' && Character.isDigit(curChar)) {
            matchFlag = true;
        } else if (key == 'L' && Character.isLetter(curChar) && Character.isLowerCase(curChar)) {
            matchFlag = true;
        } else if (key == '$' && index == Array.getLength(inCharArray) - 1) {
            matchFlag = true;
        } else if (key == '^' && index == -1) {
            matchFlag = true;
        }
        return matchFlag;
    }

    public static char WildCardTransform(char inChar) {
        String inStr = String.valueOf((char)inChar);
        int outChar = inChar;
        if (vowelWildCardSet_.contains(inStr)) {
            outChar = 86;
        } else if (consonantWildCardSet_.contains(inStr)) {
            outChar = 67;
        }
        return (char)outChar;
    }

    public static String WildCardTransform(String inStr) {
        StringBuffer curStr = new StringBuffer(inStr);
        char lastChar = ' ';
        for (int i = curStr.length() - 1; i >= 0; --i) {
            char curChar = curStr.charAt(i);
            if (WildCard.IsWildCard(curChar)) {
                if (curChar == lastChar) {
                    curStr.setCharAt(i, 'S');
                } else {
                    curStr.setCharAt(i, WildCard.WildCardTransform(curChar));
                }
            }
            lastChar = inStr.charAt(i);
        }
        return curStr.toString();
    }

    public static boolean IsWildCard(char inChar) {
        boolean isWildCard = Character.isLetter(inChar) && !Character.isLowerCase(inChar);
        return isWildCard;
    }

    public static void main(String[] args) {
        String str = "CEXXer$|adj|comparative|CEX$|adj|positive";
        System.out.println("in:  '" + str + "'");
        System.out.println("out: '" + WildCard.WildCardTransform(str) + "'");
        System.out.println("-----------------------");
        str = "|CUAB|BDDer|ARRRRT|arrrrt";
        System.out.println("in:  '" + str + "'");
        System.out.println("out: '" + WildCard.WildCardTransform(str) + "'");
        System.out.println("-----------------------");
        System.out.println("IsLegalWildCard('A'): " + WildCard.IsLegalWildCard('A'));
        System.out.println("IsLegalWildCard('S'): " + WildCard.IsLegalWildCard('S'));
    }

    private static boolean IsLegalWildCard(char inChar) {
        String inStr = String.valueOf(inChar);
        return wildCardSet_.contains(inStr);
    }

    static {
        vowelWildCardSet_.add("A");
        vowelWildCardSet_.add("E");
        vowelWildCardSet_.add("I");
        vowelWildCardSet_.add("O");
        vowelWildCardSet_.add("U");
        consonantWildCardSet_.add("B");
        consonantWildCardSet_.add("C");
        consonantWildCardSet_.add("F");
        consonantWildCardSet_.add("G");
        consonantWildCardSet_.add("H");
        consonantWildCardSet_.add("J");
        consonantWildCardSet_.add("K");
        consonantWildCardSet_.add("M");
        consonantWildCardSet_.add("N");
        consonantWildCardSet_.add("P");
        consonantWildCardSet_.add("Q");
        consonantWildCardSet_.add("R");
        consonantWildCardSet_.add("T");
        consonantWildCardSet_.add("V");
        consonantWildCardSet_.add("W");
        consonantWildCardSet_.add("X");
        consonantWildCardSet_.add("Y");
        consonantWildCardSet_.add("Z");
        wildCardSet_.add(new Character('V').toString());
        wildCardSet_.add(new Character('C').toString());
        wildCardSet_.add(new Character('S').toString());
        wildCardSet_.add(new Character('D').toString());
        wildCardSet_.add(new Character('L').toString());
        wildCardSet_.add(new Character('^').toString());
        wildCardSet_.add(new Character('$').toString());
        vowelSet_.add("a");
        vowelSet_.add("e");
        vowelSet_.add("i");
        vowelSet_.add("o");
        vowelSet_.add("u");
        vowelSet_.add("\u00e0");
        vowelSet_.add("\u00e1");
        vowelSet_.add("\u00e2");
        vowelSet_.add("\u00e3");
        vowelSet_.add("\u00e4");
        vowelSet_.add("\u00e5");
        vowelSet_.add("\u00e8");
        vowelSet_.add("\u00e9");
        vowelSet_.add("\u00ea");
        vowelSet_.add("\u00eb");
        vowelSet_.add("\u00ec");
        vowelSet_.add("\u00ed");
        vowelSet_.add("\u00ee");
        vowelSet_.add("\u00ef");
        vowelSet_.add("\u00f0");
        vowelSet_.add("\u00f2");
        vowelSet_.add("\u00f3");
        vowelSet_.add("\u00f4");
        vowelSet_.add("\u00f5");
        vowelSet_.add("\u00f6");
        vowelSet_.add("\u00f8");
        vowelSet_.add("\u00f9");
        vowelSet_.add("\u00fa");
        vowelSet_.add("\u00fb");
        vowelSet_.add("\u00fc");
        consonantSet_.add("b");
        consonantSet_.add("c");
        consonantSet_.add("d");
        consonantSet_.add("f");
        consonantSet_.add("g");
        consonantSet_.add("h");
        consonantSet_.add("j");
        consonantSet_.add("k");
        consonantSet_.add("l");
        consonantSet_.add("m");
        consonantSet_.add("n");
        consonantSet_.add("p");
        consonantSet_.add("q");
        consonantSet_.add("r");
        consonantSet_.add("s");
        consonantSet_.add("t");
        consonantSet_.add("v");
        consonantSet_.add("w");
        consonantSet_.add("x");
        consonantSet_.add("y");
        consonantSet_.add("z");
        consonantSet_.add("\u00e7");
        consonantSet_.add("\u00f1");
        consonantSet_.add("\u00fd");
        consonantSet_.add("\u00fe");
        letterSet_ = new HashSet<String>(consonantSet_);
        letterSet_.add("a");
        letterSet_.add("e");
        letterSet_.add("i");
        letterSet_.add("o");
        letterSet_.add("u");
        letterSet_.add("\u00e0");
        letterSet_.add("\u00e1");
        letterSet_.add("\u00e2");
        letterSet_.add("\u00e3");
        letterSet_.add("\u00e4");
        letterSet_.add("\u00e5");
        letterSet_.add("\u00e8");
        letterSet_.add("\u00e9");
        letterSet_.add("\u00ea");
        letterSet_.add("\u00eb");
        letterSet_.add("\u00ec");
        letterSet_.add("\u00ed");
        letterSet_.add("\u00ee");
        letterSet_.add("\u00ef");
        letterSet_.add("\u00f0");
        letterSet_.add("\u00f2");
        letterSet_.add("\u00f3");
        letterSet_.add("\u00f4");
        letterSet_.add("\u00f5");
        letterSet_.add("\u00f6");
        letterSet_.add("\u00f8");
        letterSet_.add("\u00f9");
        letterSet_.add("\u00fa");
        letterSet_.add("\u00fb");
        letterSet_.add("\u00fc");
        letterSet_.add("\u00e7");
        letterSet_.add("\u00f1");
        letterSet_.add("\u00fd");
        letterSet_.add("\u00fe");
    }
}

