/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Db;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbInflectionUtil;
import gov.nih.nlm.nls.lvg.Db.InflectionRecord;
import gov.nih.nlm.nls.lvg.Db.UninflectionComparator;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Vector;

public class DbUninflection {
    public static Vector<InflectionRecord> GetUninflections(String inStr, Connection conn) throws SQLException {
        Vector<InflectionRecord> out = DbInflectionUtil.GetRecordsByIfTerm(inStr, conn, false);
        UninflectionComparator uc = new UninflectionComparator();
        Collections.sort(out, uc);
        return out;
    }

    public static boolean IsExistUninflectedTerm(String unTerm, Connection conn) throws SQLException {
        if (unTerm == null) {
            return false;
        }
        boolean existInTable = false;
        String query = "SELECT unTerm FROM Inflection WHERE unTermLC = ?";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setString(1, unTerm.toLowerCase());
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            existInTable = true;
        }
        rs.close();
        ps.close();
        return existInTable;
    }

    public static void main(String[] args) {
        String testStr = "oth";
        if (args.length == 1) {
            testStr = args[0];
        }
        Configuration conf = new Configuration("data.config.lvg", true);
        try {
            Connection conn = DbBase.OpenConnection(conf);
            if (conn != null) {
                System.out.println("--- " + testStr + ": " + DbUninflection.IsExistUninflectedTerm(testStr, conn));
                DbBase.CloseConnection(conn, conf);
            }
        }
        catch (SQLException sqle) {
            System.err.println(sqle.getMessage());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }
}

