/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Db;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbInflectionUtil;
import gov.nih.nlm.nls.lvg.Db.InflectionRecord;
import gov.nih.nlm.nls.lvg.Db.SpellingVarComparator;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Vector;

public class DbSpellingVariants {
    public static Vector<InflectionRecord> GetSpellingVariants(String inStr, Connection conn) throws SQLException {
        Vector<InflectionRecord> records = DbInflectionUtil.GetRecordsByIfTerm(inStr, conn, false);
        Vector<InflectionRecord> pureRecords = DbSpellingVariants.EliminateDuplicateRecords(records);
        Vector<InflectionRecord> svRecords = DbSpellingVariants.GetInflectionsByEuiCatInf(pureRecords, conn);
        SpellingVarComparator sc = new SpellingVarComparator();
        Collections.sort(svRecords, sc);
        return svRecords;
    }

    private static Vector<InflectionRecord> EliminateDuplicateRecords(Vector<InflectionRecord> ins) {
        Vector<InflectionRecord> outs = new Vector<InflectionRecord>();
        for (int i = 0; i < ins.size(); ++i) {
            InflectionRecord record = ins.elementAt(i);
            if (DbSpellingVariants.IsContainRecord(outs, record)) continue;
            outs.addElement(record);
        }
        return outs;
    }

    private static boolean IsContainRecord(Vector<InflectionRecord> records, InflectionRecord record) {
        if (record == null) {
            return false;
        }
        for (int i = 0; i < records.size(); ++i) {
            InflectionRecord cur = records.elementAt(i);
            if (!record.GetEui().equals(cur.GetEui()) || record.GetCategory() != cur.GetCategory() || record.GetInflection() != cur.GetInflection()) continue;
            return true;
        }
        return false;
    }

    private static Vector<InflectionRecord> GetInflectionsByEuiCatInf(Vector<InflectionRecord> ins, Connection conn) throws SQLException {
        Vector<InflectionRecord> out = new Vector<InflectionRecord>();
        for (int i = 0; i < ins.size(); ++i) {
            InflectionRecord record = ins.elementAt(i);
            Vector<InflectionRecord> temp = DbSpellingVariants.GetInflectionsByEuiCatInf(record, conn);
            out.addAll(temp);
        }
        return out;
    }

    private static Vector<InflectionRecord> GetInflectionsByEuiCatInf(InflectionRecord in, Connection conn) throws SQLException {
        String query = "SELECT ifTerm, termCat, termInfl, eui, unTerm, ctTerm FROM Inflection WHERE eui = ? AND termCat = ? AND termInfl = ?";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setString(1, in.GetEui());
        ps.setInt(2, in.GetCategory());
        ps.setLong(3, in.GetInflection());
        return DbInflectionUtil.GetRecordsByPreparedStatement(ps, false);
    }

    public static void main(String[] args) {
        Configuration conf = new Configuration("data.config.lvg", true);
        String testStr = "color";
        if (args.length == 1) {
            testStr = args[0];
        }
        try {
            Connection conn = DbBase.OpenConnection(conf);
            if (conn != null) {
                Vector<InflectionRecord> records = DbSpellingVariants.GetSpellingVariants(testStr, conn);
                System.out.println("----- Total records found: " + records.size());
                for (int i = 0; i < records.size(); ++i) {
                    InflectionRecord record = records.elementAt(i);
                    System.out.println(record.GetInflectedTerm() + "|" + record.GetUninflectedTerm() + "|" + record.GetCitationTerm() + "|" + record.GetEui() + "|" + record.GetCategory() + "|" + record.GetInflection());
                }
                DbBase.CloseConnection(conn, conf);
            }
        }
        catch (SQLException sqle) {
            System.err.println(sqle.getMessage());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }
}

