/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexCheck.Tools;

import gov.nih.nlm.nls.lexCheck.Gram.CheckGrammer;
import gov.nih.nlm.nls.lexCheck.Lib.CheckSt;
import gov.nih.nlm.nls.lexCheck.Lib.Configuration;
import gov.nih.nlm.nls.lexCheck.Lib.GlobalVars;
import gov.nih.nlm.nls.lexCheck.Lib.LexRecord;
import gov.nih.nlm.nls.lexCheck.Lib.LineObject;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.Option;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionItem;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionUtility;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.SystemOption;
import gov.nih.nlm.nls.lvg.Util.Out;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;

public class LexCheck
extends SystemOption {
    private static BufferedReader inReader_ = null;
    private static BufferedWriter outWriter_ = null;
    private static boolean fileOutput_ = false;
    private static boolean runFlag_ = true;
    private static boolean debugFlag_ = false;
    private static boolean printFlag_ = true;
    private static boolean printXmlHeader_ = true;
    private static final int TEXT_FORMAT = 0;
    private static final int XML_FORMAT = 1;
    private static final int TEXT_XML_FORMAT = 3;
    private static final int RELEASE_FORMAT = 4;
    private static int format_ = 0;
    private static String cDate = new String();
    private static String configFile_ = null;
    private static Configuration conf_ = null;
    private static CheckSt st_ = new CheckSt();
    private static CheckSt catSt_ = new CheckSt(40);
    private static LineObject lineObject_ = new LineObject();

    public static void main(String[] args) {
        String optionStr = new String();
        Option inOption = new Option(optionStr);
        if (args.length > 0) {
            optionStr = new String();
            for (int i = 0; i < args.length; ++i) {
                optionStr = i == 0 ? args[i] : optionStr + " " + args[i];
            }
            inOption = new Option(optionStr);
        }
        LexCheck lexCheck = new LexCheck();
        Vector<OptionItem> optionItems = inOption.GetOptionItems();
        if (SystemOption.CheckSyntax(inOption, lexCheck.GetOption(), false, true)) {
            lexCheck.ExecuteCommands(inOption, lexCheck.GetOption());
            if (runFlag_ && inReader_ == null) {
                try {
                    LexCheck.helpMenu();
                }
                catch (Exception e) {}
            } else if (runFlag_) {
                boolean useClassPath = false;
                if (configFile_ == null) {
                    useClassPath = true;
                    configFile_ = "data.config.lexCheck";
                }
                if (conf_ == null) {
                    conf_ = new Configuration(configFile_, useClassPath);
                }
                lexCheck.RunProgram();
            }
        } else {
            LexCheck.helpMenu();
        }
        try {
            LexCheck.Close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private static void RunProgram() {
        String ti = conf_.GetConfiguration("TEXT_INDENT");
        String xi = conf_.GetConfiguration("XML_INDENT");
        String xmlHeader = conf_.GetConfiguration("XML_HEADER");
        GlobalVars.SetTextIndent(LexCheck.GetStringContent(ti));
        GlobalVars.SetXmlIndent(LexCheck.GetStringContent(xi));
        GlobalVars.SetXmlHeader(LexCheck.GetStringContent(xmlHeader));
        LexCheck.CheckRecord();
    }

    private static String GetStringContent(String inStr) {
        int length = inStr.length();
        if (inStr != null && inStr.startsWith("\"") && inStr.endsWith("\"")) {
            return inStr.substring(1, length - 1);
        }
        return inStr;
    }

    @Override
    protected void ExecuteCommand(OptionItem optionItem, Option systemOption) {
        OptionItem nameItem = OptionUtility.GetItemByName(optionItem, systemOption, false);
        if (LexCheck.CheckOption(nameItem, "-d")) {
            debugFlag_ = true;
        } else if (LexCheck.CheckOption(nameItem, "-f:r")) {
            format_ = 4;
        } else if (LexCheck.CheckOption(nameItem, "-f:t")) {
            format_ = 0;
        } else if (LexCheck.CheckOption(nameItem, "-f:tx")) {
            format_ = 3;
        } else if (LexCheck.CheckOption(nameItem, "-f:x")) {
            format_ = 1;
        } else if (LexCheck.CheckOption(nameItem, "-f:nxh")) {
            printXmlHeader_ = false;
        } else if (LexCheck.CheckOption(nameItem, "-h")) {
            LexCheck.helpMenu();
            runFlag_ = false;
        } else if (LexCheck.CheckOption(nameItem, "-hs")) {
            systemOption.PrintOptionHierachy();
            runFlag_ = false;
        } else if (LexCheck.CheckOption(nameItem, "-i:STR")) {
            String inFile = nameItem.GetOptionArgument();
            if (inFile != null) {
                try {
                    inReader_ = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inFile), "UTF-8"));
                }
                catch (IOException e) {
                    runFlag_ = false;
                    System.err.println("**Error: problem of opening/reading file " + inFile);
                }
            }
        } else if (LexCheck.CheckOption(nameItem, "-o:STR")) {
            String outFile = nameItem.GetOptionArgument();
            try {
                outWriter_ = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8"));
                fileOutput_ = true;
            }
            catch (IOException e) {
                runFlag_ = false;
                System.err.println("**Error: problem of opening/writing file " + outFile);
            }
        } else if (LexCheck.CheckOption(nameItem, "-v")) {
            try {
                Out.Println(outWriter_, "lexCheck.2006", fileOutput_, false);
            }
            catch (IOException e) {
                // empty catch block
            }
            runFlag_ = false;
        } else if (LexCheck.CheckOption(nameItem, "-x:STR")) {
            configFile_ = nameItem.GetOptionArgument();
        }
    }

    private static void helpMenu() {
        LexCheck.MenuPrint("");
        LexCheck.MenuPrint("Synopsis:");
        LexCheck.MenuPrint("  LexCheck [options]");
        LexCheck.MenuPrint("");
        LexCheck.MenuPrint("Description:");
        LexCheck.MenuPrint("  Validates text syntax in LexRecords and convert them among text, Xml, and Java objects from an input file.");
        LexCheck.MenuPrint("");
        LexCheck.MenuPrint("Options:");
        LexCheck.MenuPrint("  -d:     Print syntax validation debug message");
        LexCheck.MenuPrint("  -f:t    Print lexical records in text format");
        LexCheck.MenuPrint("  -f:tx   Print lexical records in text and Xml format");
        LexCheck.MenuPrint("  -f:x    Print lexical records in Xml format");
        LexCheck.MenuPrint("  -f:nxh  No Xml header with version information");
        LexCheck.MenuPrint("  -h      Print program help information (this is it).");
        LexCheck.MenuPrint("  -hs     Print option's hierarchy structure.");
        LexCheck.MenuPrint("  -i:STR  Define input file");
        LexCheck.MenuPrint("  -o:STR  Define output file");
        LexCheck.MenuPrint("  -v:     Return the current verion identification of LexCheck");
        LexCheck.MenuPrint("  -x:STR  Loading an alternative configuration file.");
    }

    private static void MenuPrint(String text) {
        try {
            Out.Println(outWriter_, text, fileOutput_, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void DefineFlag() {
        String flagStr = "-d -f:r:t:tx:x:nxh -h -hs -i:STR -o:STR -v -x:STR";
        this.systemOption_ = new Option(flagStr);
        this.systemOption_.SetFlagFullName("-d", "Print_Error_Msg");
        this.systemOption_.SetFlagFullName("-f:r", "Release_Format");
        this.systemOption_.SetFlagFullName("-f:t", "Text_Format");
        this.systemOption_.SetFlagFullName("-f:tx", "Text_Xml_Format");
        this.systemOption_.SetFlagFullName("-f:x", "Xml_Format");
        this.systemOption_.SetFlagFullName("-f:nxh", "No_Xml_Header");
        this.systemOption_.SetFlagFullName("-h", "Help");
        this.systemOption_.SetFlagFullName("-hs", "Hierarchy_Struture");
        this.systemOption_.SetFlagFullName("-i", "Input_File");
        this.systemOption_.SetFlagFullName("-o", "Output_File");
        this.systemOption_.SetFlagFullName("-v", "Version");
        this.systemOption_.SetFlagFullName("-x", "Load_Configuration_file");
    }

    private static void Close() throws IOException {
        if (outWriter_ != null) {
            outWriter_.close();
        }
        if (inReader_ != null) {
            inReader_.close();
        }
    }

    private static void CheckRecord() {
        try {
            if (format_ == 1) {
                if (printXmlHeader_) {
                    Out.Println(outWriter_, LexRecord.GetXmlHeader(), fileOutput_, false);
                }
                Out.Println(outWriter_, LexRecord.GetXmlRootBeginTag(), fileOutput_, false);
            }
            do {
                if (!lineObject_.IsGoToNext()) continue;
                lineObject_.SetLine(inReader_.readLine());
                lineObject_.IncreaseLineNum();
            } while (LexCheck.CheckLine());
            if (format_ == 1) {
                Out.Println(outWriter_, LexRecord.GetXmlRootEndTag(), fileOutput_, false);
            }
            inReader_.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean CheckLine() {
        boolean flag = false;
        if (lineObject_ == null || lineObject_.GetLine() == null) {
            return false;
        }
        flag = CheckGrammer.Check(lineObject_, printFlag_, st_, catSt_, debugFlag_);
        if (st_.GetCurState() == 10 && flag) {
            try {
                switch (format_) {
                    case 4: {
                        Out.Print(outWriter_, CheckGrammer.GetLexRecord().GetReleaseFormatText(), fileOutput_, false);
                        break;
                    }
                    case 0: {
                        Out.Print(outWriter_, CheckGrammer.GetLexRecord().GetText(), fileOutput_, false);
                        break;
                    }
                    case 3: {
                        Out.Println(outWriter_, CheckGrammer.GetLexRecord().GetText(), fileOutput_, false);
                        Out.Println(outWriter_, CheckGrammer.GetLexRecord().GetXml(0), fileOutput_, false);
                        break;
                    }
                    case 1: {
                        Out.Println(outWriter_, CheckGrammer.GetLexRecord().GetXml(1), fileOutput_, false);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return flag;
    }

    static {
        try {
            outWriter_ = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
        }
        catch (Exception e) {
            System.out.println("** Error: File Exception: " + e.toString());
        }
    }
}

