/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexCheck.Lib;

import gov.nih.nlm.nls.lexCheck.Lib.Agreement;
import gov.nih.nlm.nls.lexCheck.Lib.Convert;
import gov.nih.nlm.nls.lexCheck.Lib.InflVar;
import gov.nih.nlm.nls.lexCheck.Lib.LexRecord;
import gov.nih.nlm.nls.lexCheck.Lib.XmlLib;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.Vector;

public class InflVarsAndAgreements {
    private LexRecord lexRecord_ = null;
    private Vector<InflVar> inflValues_ = new Vector();
    private Vector<Agreement> agrValues_ = new Vector();
    private static HashSet<String> inflections_ = new HashSet();
    public static HashSet<String> consonants_ = new HashSet();
    public static HashSet<String> vowels_ = new HashSet();
    private static HashSet<String> eioySets_ = new HashSet();

    public InflVarsAndAgreements(LexRecord lexRecord) {
        this.lexRecord_ = lexRecord;
        String base = lexRecord.GetBase();
        String cit = lexRecord.GetBase();
        String eui = lexRecord.GetEui();
        String cat = lexRecord.GetCategory();
        this.GetInflVarsAndAgreements(base, eui, cat, cit);
        Vector<String> sv = lexRecord.GetSpellingVars();
        for (int i = 0; i < sv.size(); ++i) {
            String svBase = sv.elementAt(i);
            this.GetInflVarsAndAgreements(svBase, eui, cat, cit);
        }
    }

    public static String GetXml(LexRecord lexRecord) {
        boolean convertFlag = true;
        InflVarsAndAgreements inflVars = new InflVarsAndAgreements(lexRecord);
        String out = new String();
        Vector<InflVar> inflValues = inflVars.GetInflValues();
        for (int i = 0; i < inflValues.size(); ++i) {
            InflVar inflectionVar = inflValues.elementAt(i);
            String typeAttribute = new String();
            if (inflectionVar.GetType() != null) {
                typeAttribute = " type=\"" + inflectionVar.GetType() + "\"";
            }
            String startTag = "<inflVars cat=\"" + inflectionVar.GetCat() + "\" cit=\"" + Convert.ToNumericEntity(inflectionVar.GetCit()) + "\" eui=\"" + inflectionVar.GetEui() + "\" infl=\"" + inflectionVar.GetInflection() + "\"" + typeAttribute + " unInfl=\"" + Convert.ToNumericEntity(inflectionVar.GetUnInfl()) + "\">";
            out = XmlLib.AddToXml(out, startTag, "</inflVars>", inflectionVar.GetVar(), 2, convertFlag);
        }
        return out;
    }

    public Vector<InflVar> GetInflValues() {
        return this.inflValues_;
    }

    public Vector<Agreement> GetAgreementValues() {
        return this.agrValues_;
    }

    private void GetInflVarsAndAgreements(String unInfl, String eui, String cat, String cit) {
        if (cat.equals("verb")) {
            this.GetVerbInflVarsAndAgreements(unInfl, eui, cat, cit);
        } else if (cat.equals("noun")) {
            this.GetNounInflVarsAndAgreements(unInfl, eui, cat, cit);
        } else if (cat.equals("adj")) {
            this.GetAdjInflVarsAndAgreements(unInfl, eui, cat, cit);
        } else if (cat.equals("adv")) {
            this.GetAdvInflVarsAndAgreements(unInfl, eui, cat, cit);
        } else if (cat.equals("aux")) {
            this.GetAuxInflVarsAndAgreements(unInfl, eui, cat, cit);
        } else if (cat.equals("modal")) {
            this.GetModalInflVarsAndAgreements(unInfl, eui, cat, cit);
        } else if (cat.equals("pron")) {
            this.GetPronInflVarsAndAgreements(unInfl, eui, cat, cit);
        } else if (cat.equals("det")) {
            this.GetDetInflVarsAndAgreements(unInfl, eui, cat, cit);
        } else if (cat.equals("prep")) {
            this.GetPrepInflVarsAndAgreements(unInfl, eui, cat, cit);
        } else if (cat.equals("compl")) {
            this.GetComplInflVarsAndAgreements(unInfl, eui, cat, cit);
        } else if (cat.equals("conj")) {
            this.GetConjInflVarsAndAgreements(unInfl, eui, cat, cit);
        }
    }

    private void GetVerbInflVarsAndAgreements(String unInfl, String eui, String cat, String cit) {
        this.inflValues_.addElement(new InflVar(eui, unInfl, "base", unInfl, cat, cit));
        this.inflValues_.addElement(new InflVar(eui, unInfl, "pres1p23p", unInfl, cat, cit));
        this.agrValues_.addElement(new Agreement(eui, unInfl, cat, "pres(fst_sing,fst_plur,thr_plur,second)", unInfl, cit));
        InflVar infinitive = new InflVar(eui, unInfl, "infinitive", unInfl, cat, cit);
        Agreement agrInf = new Agreement(eui, unInfl, cat, "infinitive", unInfl, cit);
        Vector<String> variants = this.lexRecord_.GetCatEntry().GetVerbEntry().GetVariants();
        String inflVar = new String();
        for (int i = 0; i < variants.size(); ++i) {
            char last2Char;
            char lastChar;
            String variant = variants.elementAt(i);
            if (variant.startsWith("regd")) {
                if (!this.inflValues_.contains(infinitive)) {
                    this.inflValues_.addElement(infinitive);
                }
                if (!this.agrValues_.contains(agrInf)) {
                    this.agrValues_.addElement(agrInf);
                }
                String type = "regd";
                lastChar = InflVarsAndAgreements.GetLastChar(unInfl);
                last2Char = InflVarsAndAgreements.GetLast2Char(unInfl);
                String lastCharStr = new Character(lastChar).toString();
                String last2CharStr = new Character(last2Char).toString();
                if (!consonants_.contains(lastCharStr) || !vowels_.contains(last2CharStr)) {
                    System.err.println("** Err@regd violation: " + eui + "|" + unInfl + "|" + cat);
                }
                InflVar pres3s = null;
                if (unInfl.endsWith("s") || unInfl.endsWith("z") || unInfl.endsWith("x") || unInfl.endsWith("ch") || unInfl.endsWith("sh")) {
                    inflVar = unInfl + "es";
                    pres3s = new InflVar(eui, unInfl, type, "pres3s", inflVar, cat, cit);
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "pres(thr_sing)", unInfl, cit));
                } else if (unInfl.endsWith("ie")) {
                    inflVar = unInfl + "s";
                    pres3s = new InflVar(eui, unInfl, type, "pres3s", inflVar, cat, cit);
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "pres(thr_sing)", unInfl, cit));
                } else if (unInfl.endsWith("ee") || unInfl.endsWith("oe") || unInfl.endsWith("ye")) {
                    inflVar = unInfl + "s";
                    pres3s = new InflVar(eui, unInfl, type, "pres3s", inflVar, cat, cit);
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "pres(thr_sing)", unInfl, cit));
                } else if (unInfl.endsWith("y") && consonants_.contains(last2CharStr)) {
                    inflVar = unInfl.substring(0, unInfl.length() - 1) + "ies";
                    pres3s = new InflVar(eui, unInfl, type, "pres3s", inflVar, cat, cit);
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "pres(thr_sing)", unInfl, cit));
                } else if (unInfl.endsWith("e") && !eioySets_.contains(last2CharStr)) {
                    inflVar = unInfl + "s";
                    pres3s = new InflVar(eui, unInfl, type, "pres3s", inflVar, cat, cit);
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "pres(thr_sing)", unInfl, cit));
                } else {
                    inflVar = unInfl + "s";
                    pres3s = new InflVar(eui, unInfl, type, "pres3s", inflVar, cat, cit);
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "pres(thr_sing)", unInfl, cit));
                }
                pres3s.SetUnique(this.IsUnique(this.inflValues_, pres3s));
                this.inflValues_.addElement(pres3s);
                inflVar = unInfl + lastChar + "ed";
                this.inflValues_.addElement(new InflVar(eui, unInfl, type, "past", inflVar, cat, cit));
                this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "past", unInfl, cit));
                inflVar = unInfl + lastChar + "ed";
                this.inflValues_.addElement(new InflVar(eui, unInfl, type, "pastPart", inflVar, cat, cit));
                this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "past_part", unInfl, cit));
                inflVar = unInfl + lastChar + "ing";
                this.inflValues_.addElement(new InflVar(eui, unInfl, type, "presPart", inflVar, cat, cit));
                this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "pres_part", unInfl, cit));
                continue;
            }
            if (variant.startsWith("reg")) {
                if (!this.inflValues_.contains(infinitive)) {
                    this.inflValues_.addElement(infinitive);
                }
                if (!this.agrValues_.contains(agrInf)) {
                    this.agrValues_.addElement(agrInf);
                }
                String type = "reg";
                lastChar = InflVarsAndAgreements.GetLastChar(unInfl);
                last2Char = InflVarsAndAgreements.GetLast2Char(unInfl);
                String last2CharStr = new Character(last2Char).toString();
                InflVar pres3s = null;
                InflVar past = null;
                InflVar pastPart = null;
                InflVar presPart = null;
                if (unInfl.endsWith("s") || unInfl.endsWith("z") || unInfl.endsWith("x") || unInfl.endsWith("ch") || unInfl.endsWith("sh")) {
                    inflVar = unInfl + "es";
                    pres3s = new InflVar(eui, unInfl, type, "pres3s", inflVar, cat, cit);
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "pres(thr_sing)", unInfl, cit));
                    inflVar = unInfl + "ed";
                    past = new InflVar(eui, unInfl, type, "past", inflVar, cat, cit);
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "past", unInfl, cit));
                    inflVar = unInfl + "ed";
                    pastPart = new InflVar(eui, unInfl, type, "pastPart", inflVar, cat, cit);
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "past_part", unInfl, cit));
                    inflVar = unInfl + "ing";
                    presPart = new InflVar(eui, unInfl, type, "presPart", inflVar, cat, cit);
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "pres_part", unInfl, cit));
                } else if (unInfl.endsWith("ie")) {
                    inflVar = unInfl + "s";
                    pres3s = new InflVar(eui, unInfl, type, "pres3s", inflVar, cat, cit);
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "pres(thr_sing)", unInfl, cit));
                    inflVar = unInfl + "d";
                    past = new InflVar(eui, unInfl, type, "past", inflVar, cat, cit);
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "past", unInfl, cit));
                    inflVar = unInfl + "d";
                    pastPart = new InflVar(eui, unInfl, type, "pastPart", inflVar, cat, cit);
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "past_part", unInfl, cit));
                    inflVar = unInfl.substring(0, unInfl.length() - 2) + "ying";
                    presPart = new InflVar(eui, unInfl, type, "presPart", inflVar, cat, cit);
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "pres_part", unInfl, cit));
                } else if (unInfl.endsWith("ee") || unInfl.endsWith("oe") || unInfl.endsWith("ye")) {
                    inflVar = unInfl + "s";
                    pres3s = new InflVar(eui, unInfl, type, "pres3s", inflVar, cat, cit);
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "pres(thr_sing)", unInfl, cit));
                    inflVar = unInfl + "d";
                    past = new InflVar(eui, unInfl, type, "past", inflVar, cat, cit);
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "past", unInfl, cit));
                    inflVar = unInfl + "d";
                    pastPart = new InflVar(eui, unInfl, type, "pastPart", inflVar, cat, cit);
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "past_part", unInfl, cit));
                    inflVar = unInfl + "ing";
                    presPart = new InflVar(eui, unInfl, type, "presPart", inflVar, cat, cit);
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "pres_part", unInfl, cit));
                } else if (unInfl.endsWith("y") && consonants_.contains(last2CharStr)) {
                    inflVar = unInfl.substring(0, unInfl.length() - 1) + "ies";
                    pres3s = new InflVar(eui, unInfl, type, "pres3s", inflVar, cat, cit);
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "pres(thr_sing)", unInfl, cit));
                    inflVar = unInfl.substring(0, unInfl.length() - 1) + "ied";
                    past = new InflVar(eui, unInfl, type, "past", inflVar, cat, cit);
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "past", unInfl, cit));
                    inflVar = unInfl.substring(0, unInfl.length() - 1) + "ied";
                    pastPart = new InflVar(eui, unInfl, type, "pastPart", inflVar, cat, cit);
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "past_part", unInfl, cit));
                    inflVar = unInfl + "ing";
                    presPart = new InflVar(eui, unInfl, type, "presPart", inflVar, cat, cit);
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "pres_part", unInfl, cit));
                } else if (unInfl.endsWith("e") && !eioySets_.contains(last2CharStr)) {
                    inflVar = unInfl + "s";
                    pres3s = new InflVar(eui, unInfl, type, "pres3s", inflVar, cat, cit);
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "pres(thr_sing)", unInfl, cit));
                    inflVar = unInfl + "d";
                    past = new InflVar(eui, unInfl, type, "past", inflVar, cat, cit);
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "past", unInfl, cit));
                    inflVar = unInfl + "d";
                    pastPart = new InflVar(eui, unInfl, type, "pastPart", inflVar, cat, cit);
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "past_part", unInfl, cit));
                    inflVar = unInfl.substring(0, unInfl.length() - 1) + "ing";
                    presPart = new InflVar(eui, unInfl, type, "presPart", inflVar, cat, cit);
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "pres_part", unInfl, cit));
                } else {
                    inflVar = unInfl + "s";
                    pres3s = new InflVar(eui, unInfl, type, "pres3s", inflVar, cat, cit);
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "pres(thr_sing)", unInfl, cit));
                    inflVar = unInfl + "ed";
                    past = new InflVar(eui, unInfl, type, "past", inflVar, cat, cit);
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "past", unInfl, cit));
                    inflVar = unInfl + "ed";
                    pastPart = new InflVar(eui, unInfl, type, "pastPart", inflVar, cat, cit);
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "past_part", unInfl, cit));
                    inflVar = unInfl + "ing";
                    presPart = new InflVar(eui, unInfl, type, "presPart", inflVar, cat, cit);
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "pres_part", unInfl, cit));
                }
                pres3s.SetUnique(this.IsUnique(this.inflValues_, pres3s));
                past.SetUnique(this.IsUnique(this.inflValues_, past));
                pastPart.SetUnique(this.IsUnique(this.inflValues_, pastPart));
                presPart.SetUnique(this.IsUnique(this.inflValues_, presPart));
                this.inflValues_.addElement(pres3s);
                this.inflValues_.addElement(past);
                this.inflValues_.addElement(pastPart);
                this.inflValues_.addElement(presPart);
                continue;
            }
            if (variant.startsWith("irreg")) {
                if (!this.inflValues_.contains(infinitive)) {
                    this.inflValues_.addElement(infinitive);
                }
                if (!this.agrValues_.contains(agrInf)) {
                    this.agrValues_.addElement(agrInf);
                }
                int index1 = variant.indexOf("|");
                int index2 = variant.indexOf("|", index1 + 1);
                int index3 = variant.indexOf("|", index2 + 1);
                int index4 = variant.indexOf("|", index3 + 1);
                int index5 = variant.indexOf("|", index4 + 1);
                int index6 = variant.indexOf("|", index5 + 1);
                String type = variant.substring(0, index1);
                String baseStr = variant.substring(index1 + 1, index2);
                String pres3sStr = variant.substring(index2 + 1, index3);
                String pastStr = variant.substring(index3 + 1, index4);
                String pastPartStr = variant.substring(index4 + 1, index5);
                String presPartStr = variant.substring(index5 + 1, index6);
                if (!unInfl.equals(baseStr)) continue;
                if (pres3sStr.length() > 0) {
                    InflVar pres3s = new InflVar(eui, unInfl, type, "pres3s", pres3sStr, cat, cit);
                    pres3s.SetUnique(this.IsUnique(this.inflValues_, pres3s));
                    this.inflValues_.addElement(pres3s);
                    this.agrValues_.addElement(new Agreement(eui, pres3sStr, cat, "pres(thr_sing)", unInfl, cit));
                }
                if (pastStr.length() > 0) {
                    InflVar past = new InflVar(eui, unInfl, type, "past", pastStr, cat, cit);
                    past.SetUnique(this.IsUnique(this.inflValues_, past));
                    this.inflValues_.addElement(past);
                    this.agrValues_.addElement(new Agreement(eui, pastStr, cat, "past", unInfl, cit));
                }
                if (pastPartStr.length() > 0) {
                    InflVar pastPart = new InflVar(eui, unInfl, type, "pastPart", pastPartStr, cat, cit);
                    pastPart.SetUnique(this.IsUnique(this.inflValues_, pastPart));
                    this.inflValues_.addElement(pastPart);
                    this.agrValues_.addElement(new Agreement(eui, pastPartStr, cat, "past_part", unInfl, cit));
                }
                if (presPartStr.length() <= 0) continue;
                InflVar presPart = new InflVar(eui, unInfl, type, "presPart", presPartStr, cat, cit);
                presPart.SetUnique(this.IsUnique(this.inflValues_, presPart));
                this.inflValues_.addElement(presPart);
                this.agrValues_.addElement(new Agreement(eui, presPartStr, cat, "pres_part", unInfl, cit));
                continue;
            }
            System.out.println("-- Warning: InflVarsAndAgreements.GetVerbInflVarsAndAgreements()");
        }
    }

    private void GetNounInflVarsAndAgreements(String unInfl, String eui, String cat, String cit) {
        this.inflValues_.addElement(new InflVar(eui, unInfl, "base", unInfl, cat, cit));
        InflVar singular = new InflVar(eui, unInfl, "singular", unInfl, cat, cit);
        Agreement singAgr = new Agreement(eui, unInfl, cat, "count(thr_sing)", unInfl, cit);
        Vector<String> variants = this.lexRecord_.GetCatEntry().GetNounEntry().GetVariants();
        String inflVar = new String();
        for (int i = 0; i < variants.size(); ++i) {
            String variant = variants.elementAt(i);
            if (variant.startsWith("reg")) {
                if (!this.inflValues_.contains(singular)) {
                    this.inflValues_.addElement(singular);
                }
                if (!this.agrValues_.contains(singAgr)) {
                    this.agrValues_.addElement(singAgr);
                }
                char lastChar = InflVarsAndAgreements.GetLastChar(unInfl);
                char last2Char = InflVarsAndAgreements.GetLast2Char(unInfl);
                String last2CharStr = new Character(last2Char).toString();
                InflVar plural = null;
                if (lastChar == 'y' && consonants_.contains(last2CharStr)) {
                    inflVar = unInfl.substring(0, unInfl.length() - 1) + "ies";
                    plural = new InflVar(eui, unInfl, "reg", "plural", inflVar, cat, cit);
                } else if (unInfl.endsWith("s") || unInfl.endsWith("z") || unInfl.endsWith("x") || unInfl.endsWith("ch") || unInfl.endsWith("sh")) {
                    inflVar = unInfl + "es";
                    plural = new InflVar(eui, unInfl, "reg", "plural", inflVar, cat, cit);
                } else {
                    inflVar = unInfl + "s";
                    plural = new InflVar(eui, unInfl, "reg", "plural", inflVar, cat, cit);
                }
                plural.SetUnique(this.IsUnique(this.inflValues_, plural));
                this.inflValues_.addElement(plural);
                this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "count(thr_plur)", unInfl, cit));
                continue;
            }
            if (variant.startsWith("glreg")) {
                if (!this.inflValues_.contains(singular)) {
                    this.inflValues_.addElement(singular);
                }
                if (!this.agrValues_.contains(singAgr)) {
                    this.agrValues_.addElement(singAgr);
                }
                inflVar = unInfl;
                if (unInfl.endsWith("us")) {
                    inflVar = unInfl.substring(0, unInfl.length() - 2) + "i";
                    this.inflValues_.addElement(new InflVar(eui, unInfl, "glreg", "plural", inflVar, cat, cit));
                } else if (unInfl.endsWith("ma")) {
                    inflVar = unInfl + "ta";
                    this.inflValues_.addElement(new InflVar(eui, unInfl, "glreg", "plural", inflVar, cat, cit));
                } else if (unInfl.endsWith("a")) {
                    inflVar = unInfl + "e";
                    this.inflValues_.addElement(new InflVar(eui, unInfl, "glreg", "plural", inflVar, cat, cit));
                } else if (unInfl.endsWith("um")) {
                    inflVar = unInfl.substring(0, unInfl.length() - 2) + "a";
                    this.inflValues_.addElement(new InflVar(eui, unInfl, "glreg", "plural", inflVar, cat, cit));
                } else if (unInfl.endsWith("on")) {
                    inflVar = unInfl.substring(0, unInfl.length() - 2) + "a";
                    this.inflValues_.addElement(new InflVar(eui, unInfl, "glreg", "plural", inflVar, cat, cit));
                } else if (unInfl.endsWith("sis")) {
                    inflVar = unInfl.substring(0, unInfl.length() - 2) + "es";
                    this.inflValues_.addElement(new InflVar(eui, unInfl, "glreg", "plural", inflVar, cat, cit));
                } else if (unInfl.endsWith("is")) {
                    inflVar = unInfl.substring(0, unInfl.length() - 1) + "des";
                    this.inflValues_.addElement(new InflVar(eui, unInfl, "glreg", "plural", inflVar, cat, cit));
                } else if (unInfl.endsWith("men")) {
                    inflVar = unInfl.substring(0, unInfl.length() - 2) + "ina";
                    this.inflValues_.addElement(new InflVar(eui, unInfl, "glreg", "plural", inflVar, cat, cit));
                } else if (unInfl.endsWith("ex")) {
                    inflVar = unInfl.substring(0, unInfl.length() - 2) + "ices";
                    this.inflValues_.addElement(new InflVar(eui, unInfl, "glreg", "plural", inflVar, cat, cit));
                } else if (unInfl.endsWith("x")) {
                    inflVar = unInfl.substring(0, unInfl.length() - 1) + "ces";
                    this.inflValues_.addElement(new InflVar(eui, unInfl, "glreg", "plural", inflVar, cat, cit));
                } else {
                    System.err.println("** Err@glreg violation: " + eui + "|" + unInfl + "|" + cat);
                }
                this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "count(thr_plur)", unInfl, cit));
                continue;
            }
            if (variant.startsWith("metareg")) {
                if (!this.inflValues_.contains(singular)) {
                    this.inflValues_.addElement(singular);
                }
                if (!this.agrValues_.contains(singAgr)) {
                    this.agrValues_.addElement(singAgr);
                }
                inflVar = unInfl + "s";
                InflVar plural = new InflVar(eui, unInfl, "metareg", "plural", inflVar, cat, cit);
                plural.SetUnique(this.IsUnique(this.inflValues_, plural));
                this.inflValues_.addElement(plural);
                this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "count(thr_plur)", unInfl, cit));
                inflVar = unInfl + "'s";
                InflVar plural2 = new InflVar(eui, unInfl, "metareg", "plural", inflVar, cat, cit);
                plural2.SetUnique(this.IsUnique(this.inflValues_, plural2));
                this.inflValues_.addElement(plural2);
                this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "count(thr_plur)", unInfl, cit));
                continue;
            }
            if (variant.startsWith("irreg")) {
                if (!this.inflValues_.contains(singular)) {
                    this.inflValues_.addElement(singular);
                }
                if (!this.agrValues_.contains(singAgr)) {
                    this.agrValues_.addElement(singAgr);
                }
                int index1 = variant.indexOf("|");
                int index2 = variant.indexOf("|", index1 + 1);
                int index3 = variant.indexOf("|", index2 + 1);
                String type = variant.substring(0, index1);
                String baseStr = variant.substring(index1 + 1, index2);
                String pluralStr = variant.substring(index2 + 1, index3);
                if (!unInfl.equals(baseStr) || pluralStr.length() <= 0) continue;
                InflVar plural = new InflVar(eui, unInfl, type, "plural", pluralStr, cat, cit);
                plural.SetUnique(this.IsUnique(this.inflValues_, plural));
                this.inflValues_.addElement(plural);
                this.agrValues_.addElement(new Agreement(eui, pluralStr, cat, "count(thr_plur)", unInfl, cit));
                continue;
            }
            if (variant.startsWith("sing")) {
                if (!this.inflValues_.contains(singular)) {
                    this.inflValues_.addElement(singular);
                }
                if (this.agrValues_.contains(singAgr)) continue;
                this.agrValues_.addElement(singAgr);
                continue;
            }
            if (variant.startsWith("plur")) {
                InflVar plural = new InflVar(eui, unInfl, "plur", "plural", unInfl, cat, cit);
                plural.SetUnique(this.IsUnique(this.inflValues_, plural));
                this.inflValues_.addElement(plural);
                this.agrValues_.addElement(new Agreement(eui, unInfl, cat, "count(thr_plur)", unInfl, cit));
                continue;
            }
            if (variant.startsWith("inv")) {
                if (!this.inflValues_.contains(singular)) {
                    this.inflValues_.addElement(singular);
                }
                if (!this.agrValues_.contains(singAgr)) {
                    this.agrValues_.addElement(singAgr);
                }
                InflVar plural = new InflVar(eui, unInfl, "inv", "plural", unInfl, cat, cit);
                plural.SetUnique(this.IsUnique(this.inflValues_, plural));
                this.inflValues_.addElement(plural);
                this.agrValues_.addElement(new Agreement(eui, unInfl, cat, "count(thr_plur)", unInfl, cit));
                continue;
            }
            if (variant.startsWith("uncount")) {
                if (!this.inflValues_.contains(singular)) {
                    this.inflValues_.addElement(singular);
                }
                this.agrValues_.addElement(new Agreement(eui, unInfl, cat, "uncount(thr_sing)", unInfl, cit));
                continue;
            }
            if (variant.startsWith("groupuncount")) {
                if (!this.inflValues_.contains(singular)) {
                    this.inflValues_.addElement(singular);
                }
                this.agrValues_.addElement(new Agreement(eui, unInfl, cat, "uncount(thr_sing)", unInfl, cit));
                InflVar plural = new InflVar(eui, unInfl, "groupuncount", "plural", unInfl, cat, cit);
                plural.SetUnique(this.IsUnique(this.inflValues_, plural));
                this.inflValues_.addElement(plural);
                this.agrValues_.addElement(new Agreement(eui, unInfl, cat, "uncount(thr_plur)", unInfl, cit));
                continue;
            }
            if (variant.startsWith("group(")) {
                String argument;
                if (!this.inflValues_.contains(singular)) {
                    this.inflValues_.addElement(singular);
                }
                if (!this.agrValues_.contains(singAgr)) {
                    this.agrValues_.addElement(singAgr);
                }
                InflVar plur = new InflVar(eui, unInfl, variant, "plural", unInfl, cat, cit);
                plur.SetUnique(this.IsUnique(this.inflValues_, plur));
                if (this.IsUnique(this.inflValues_, plur) && !this.inflValues_.contains(plur)) {
                    this.inflValues_.addElement(plur);
                    this.agrValues_.addElement(new Agreement(eui, unInfl, cat, "count(thr_plur)", unInfl, cit));
                }
                if ((argument = variant.substring(6, variant.length() - 1)).equals("reg")) {
                    char lastChar = InflVarsAndAgreements.GetLastChar(unInfl);
                    char last2Char = InflVarsAndAgreements.GetLast2Char(unInfl);
                    String last2CharStr = new Character(last2Char).toString();
                    InflVar plural = null;
                    if (lastChar == 'y' && consonants_.contains(last2CharStr)) {
                        inflVar = unInfl.substring(0, unInfl.length() - 1) + "ies";
                        plural = new InflVar(eui, unInfl, variant, "plural", inflVar, cat, cit);
                    } else if (unInfl.endsWith("s") || unInfl.endsWith("z") || unInfl.endsWith("x") || unInfl.endsWith("ch") || unInfl.endsWith("sh")) {
                        inflVar = unInfl + "es";
                        plural = new InflVar(eui, unInfl, variant, "plural", inflVar, cat, cit);
                    } else {
                        inflVar = unInfl + "s";
                        plural = new InflVar(eui, unInfl, variant, "plural", inflVar, cat, cit);
                    }
                    plural.SetUnique(this.IsUnique(this.inflValues_, plural));
                    this.inflValues_.addElement(plural);
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "count(thr_plur)", unInfl, cit));
                    continue;
                }
                if (argument.equals("glreg")) {
                    if (unInfl.endsWith("us")) {
                        inflVar = unInfl.substring(0, unInfl.length() - 2) + "i";
                        this.inflValues_.addElement(new InflVar(eui, unInfl, variant, "plural", inflVar, cat, cit));
                    } else if (unInfl.endsWith("ma")) {
                        inflVar = unInfl + "ta";
                        this.inflValues_.addElement(new InflVar(eui, unInfl, variant, "plural", inflVar, cat, cit));
                    } else if (unInfl.endsWith("a")) {
                        inflVar = unInfl + "e";
                        this.inflValues_.addElement(new InflVar(eui, unInfl, variant, "plural", inflVar, cat, cit));
                    } else if (unInfl.endsWith("um")) {
                        inflVar = unInfl.substring(0, unInfl.length() - 2) + "a";
                        this.inflValues_.addElement(new InflVar(eui, unInfl, variant, "plural", inflVar, cat, cit));
                    } else if (unInfl.endsWith("on")) {
                        inflVar = unInfl.substring(0, unInfl.length() - 2) + "a";
                        this.inflValues_.addElement(new InflVar(eui, unInfl, variant, "plural", inflVar, cat, cit));
                    } else if (unInfl.endsWith("sis")) {
                        inflVar = unInfl.substring(0, unInfl.length() - 2) + "es";
                        this.inflValues_.addElement(new InflVar(eui, unInfl, variant, "plural", inflVar, cat, cit));
                    } else if (unInfl.endsWith("is")) {
                        inflVar = unInfl.substring(0, unInfl.length() - 1) + "des";
                        this.inflValues_.addElement(new InflVar(eui, unInfl, variant, "plural", inflVar, cat, cit));
                    } else if (unInfl.endsWith("men")) {
                        inflVar = unInfl.substring(0, unInfl.length() - 2) + "ina";
                        this.inflValues_.addElement(new InflVar(eui, unInfl, variant, "plural", inflVar, cat, cit));
                    } else if (unInfl.endsWith("ex")) {
                        inflVar = unInfl.substring(0, unInfl.length() - 2) + "ices";
                        this.inflValues_.addElement(new InflVar(eui, unInfl, variant, "plural", inflVar, cat, cit));
                    } else if (unInfl.endsWith("x")) {
                        inflVar = unInfl.substring(0, unInfl.length() - 1) + "ces";
                        this.inflValues_.addElement(new InflVar(eui, unInfl, variant, "plural", inflVar, cat, cit));
                    } else {
                        System.err.println("** Err@glreg violation: " + eui + "|" + unInfl + "|" + cat);
                    }
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "count(thr_plur)", unInfl, cit));
                    continue;
                }
                if (argument.equals("metareg")) {
                    inflVar = unInfl + "s";
                    InflVar plural = new InflVar(eui, unInfl, variant, "plural", inflVar, cat, cit);
                    plural.SetUnique(this.IsUnique(this.inflValues_, plural));
                    this.inflValues_.addElement(plural);
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "count(thr_plur)", unInfl, cit));
                    inflVar = unInfl + "'s";
                    InflVar plural2 = new InflVar(eui, unInfl, variant, "plural", inflVar, cat, cit);
                    plural2.SetUnique(this.IsUnique(this.inflValues_, plural2));
                    this.inflValues_.addElement(plural2);
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "count(thr_plur)", unInfl, cit));
                    continue;
                }
                if (!argument.startsWith("irreg")) continue;
                int index1 = argument.indexOf("|");
                int index2 = argument.indexOf("|", index1 + 1);
                int index3 = argument.indexOf("|", index2 + 1);
                String tagStr = argument.substring(0, index1);
                String baseStr = argument.substring(index1 + 1, index2);
                String pluralStr = argument.substring(index2 + 1, index3);
                if (!unInfl.equals(baseStr) || pluralStr.length() <= 0) continue;
                InflVar plural = new InflVar(eui, unInfl, variant, "plural", pluralStr, cat, cit);
                plural.SetUnique(this.IsUnique(this.inflValues_, plural));
                this.inflValues_.addElement(plural);
                this.agrValues_.addElement(new Agreement(eui, pluralStr, cat, "count(thr_plur)", unInfl, cit));
                continue;
            }
            System.out.println("-- Warning: InflVarsAndAgreements.GetNounInflVarsAndAgreements()" + variant);
        }
    }

    private void GetAdjInflVarsAndAgreements(String unInfl, String eui, String cat, String cit) {
        this.inflValues_.addElement(new InflVar(eui, unInfl, "base", unInfl, cat, cit));
        InflVar positive = new InflVar(eui, unInfl, "positive", unInfl, cat, cit);
        this.inflValues_.addElement(positive);
        Vector<String> variants = this.lexRecord_.GetCatEntry().GetAdjEntry().GetVariants();
        String inflVar = new String();
        for (int i = 0; i < variants.size(); ++i) {
            char last2Char;
            char lastChar;
            String variant = variants.elementAt(i);
            if (variant.startsWith("irreg")) {
                int index1 = variant.indexOf("|");
                int index2 = variant.indexOf("|", index1 + 1);
                int index3 = variant.indexOf("|", index2 + 1);
                int index4 = variant.indexOf("|", index3 + 1);
                String type = variant.substring(0, index1);
                String baseStr = variant.substring(index1 + 1, index2);
                String compStr = variant.substring(index2 + 1, index3);
                String superStr = variant.substring(index3 + 1, index4);
                this.agrValues_.addElement(new Agreement(eui, unInfl, cat, "positive", unInfl, cit));
                if (!unInfl.equals(baseStr)) continue;
                if (compStr.length() > 0) {
                    InflVar comparative = new InflVar(eui, unInfl, type, "comparative", compStr, cat, cit);
                    comparative.SetUnique(this.IsUnique(this.inflValues_, comparative));
                    this.inflValues_.addElement(comparative);
                }
                if (superStr.length() <= 0) continue;
                InflVar superlative = new InflVar(eui, unInfl, type, "superlative", superStr, cat, cit);
                superlative.SetUnique(this.IsUnique(this.inflValues_, superlative));
                this.inflValues_.addElement(superlative);
                this.agrValues_.addElement(new Agreement(eui, superStr, cat, "superlative", unInfl, cit));
                continue;
            }
            if (variant.startsWith("regd")) {
                String type = "regd";
                lastChar = InflVarsAndAgreements.GetLastChar(unInfl);
                last2Char = InflVarsAndAgreements.GetLast2Char(unInfl);
                String lastCharStr = new Character(lastChar).toString();
                String last2CharStr = new Character(last2Char).toString();
                if (!consonants_.contains(lastCharStr) || !vowels_.contains(last2CharStr)) {
                    System.err.println("** Err@regd violation: " + eui + "|" + unInfl + "|" + cat);
                }
                this.agrValues_.addElement(new Agreement(eui, unInfl, cat, "positive", unInfl, cit));
                inflVar = unInfl + lastChar + "er";
                this.inflValues_.addElement(new InflVar(eui, unInfl, type, "comparative", inflVar, cat, cit));
                this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "comparative", unInfl, cit));
                inflVar = unInfl + lastChar + "est";
                this.inflValues_.addElement(new InflVar(eui, unInfl, type, "superlative", inflVar, cat, cit));
                this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "superlative", unInfl, cit));
                continue;
            }
            if (variant.startsWith("reg")) {
                String type = "reg";
                lastChar = InflVarsAndAgreements.GetLastChar(unInfl);
                last2Char = InflVarsAndAgreements.GetLast2Char(unInfl);
                String last2CharStr = new Character(last2Char).toString();
                this.agrValues_.addElement(new Agreement(eui, unInfl, cat, "positive", unInfl, cit));
                if (lastChar == 'y' && consonants_.contains(last2CharStr)) {
                    inflVar = unInfl.substring(0, unInfl.length() - 1) + "ier";
                    this.inflValues_.addElement(new InflVar(eui, unInfl, type, "comparative", inflVar, cat, cit));
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "comparative", unInfl, cit));
                    inflVar = unInfl.substring(0, unInfl.length() - 1) + "iest";
                    this.inflValues_.addElement(new InflVar(eui, unInfl, type, "superlative", inflVar, cat, cit));
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "superlative", unInfl, cit));
                    continue;
                }
                if (lastChar == 'e') {
                    inflVar = unInfl + "r";
                    this.inflValues_.addElement(new InflVar(eui, unInfl, type, "comparative", inflVar, cat, cit));
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "comparative", unInfl, cit));
                    inflVar = unInfl + "st";
                    this.inflValues_.addElement(new InflVar(eui, unInfl, type, "superlative", inflVar, cat, cit));
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "superlative", unInfl, cit));
                    continue;
                }
                inflVar = unInfl + "er";
                this.inflValues_.addElement(new InflVar(eui, unInfl, type, "comparative", inflVar, cat, cit));
                this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "comparative", unInfl, cit));
                inflVar = unInfl + "est";
                this.inflValues_.addElement(new InflVar(eui, unInfl, type, "superlative", inflVar, cat, cit));
                this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "superlative", unInfl, cit));
                continue;
            }
            if (variant.startsWith("inv;periph")) {
                this.agrValues_.addElement(new Agreement(eui, unInfl, cat, "positive;periph", unInfl, cit));
                continue;
            }
            this.agrValues_.addElement(new Agreement(eui, unInfl, cat, "positive", unInfl, cit));
        }
    }

    private void GetAdvInflVarsAndAgreements(String unInfl, String eui, String cat, String cit) {
        this.inflValues_.addElement(new InflVar(eui, unInfl, "base", unInfl, cat, cit));
        InflVar positive = new InflVar(eui, unInfl, "positive", unInfl, cat, cit);
        this.inflValues_.addElement(positive);
        Vector<String> variants = this.lexRecord_.GetCatEntry().GetAdvEntry().GetVariants();
        String inflVar = new String();
        for (int i = 0; i < variants.size(); ++i) {
            String variant = variants.elementAt(i);
            if (variant.startsWith("irreg")) {
                int index1 = variant.indexOf("|");
                int index2 = variant.indexOf("|", index1 + 1);
                int index3 = variant.indexOf("|", index2 + 1);
                int index4 = variant.indexOf("|", index3 + 1);
                String type = variant.substring(0, index1);
                String baseStr = variant.substring(index1 + 1, index2);
                String comparative = variant.substring(index2 + 1, index3);
                String superlative = variant.substring(index3 + 1, index4);
                this.agrValues_.addElement(new Agreement(eui, unInfl, cat, "positive", unInfl, cit));
                if (unInfl.equals(baseStr)) {
                    if (comparative.length() > 0) {
                        this.inflValues_.addElement(new InflVar(eui, unInfl, type, "comparative", comparative, cat, cit));
                    }
                    if (superlative.length() > 0) {
                        this.inflValues_.addElement(new InflVar(eui, unInfl, type, "superlative", superlative, cat, cit));
                    }
                }
                if (comparative.length() > 0) {
                    this.agrValues_.addElement(new Agreement(eui, comparative, cat, "comparative", unInfl, cit));
                }
                if (superlative.length() <= 0) continue;
                this.agrValues_.addElement(new Agreement(eui, superlative, cat, "superlative", unInfl, cit));
                continue;
            }
            if (variant.startsWith("reg")) {
                String type = "reg";
                char lastChar = InflVarsAndAgreements.GetLastChar(unInfl);
                char last2Char = InflVarsAndAgreements.GetLast2Char(unInfl);
                String last2CharStr = new Character(last2Char).toString();
                this.agrValues_.addElement(new Agreement(eui, unInfl, cat, "positive", unInfl, cit));
                if (lastChar == 'y' && consonants_.contains(last2CharStr)) {
                    inflVar = unInfl.substring(0, unInfl.length() - 1) + "ier";
                    this.inflValues_.addElement(new InflVar(eui, unInfl, type, "comparative", inflVar, cat, cit));
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "comparative", unInfl, cit));
                    inflVar = unInfl.substring(0, unInfl.length() - 1) + "iest";
                    this.inflValues_.addElement(new InflVar(eui, unInfl, type, "superlative", inflVar, cat, cit));
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "superlative", unInfl, cit));
                    continue;
                }
                if (lastChar == 'e') {
                    inflVar = unInfl + "r";
                    this.inflValues_.addElement(new InflVar(eui, unInfl, type, "comparative", inflVar, cat, cit));
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "comparative", unInfl, cit));
                    inflVar = unInfl + "st";
                    this.inflValues_.addElement(new InflVar(eui, unInfl, type, "superlative", inflVar, cat, cit));
                    this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "superlative", unInfl, cit));
                    continue;
                }
                inflVar = unInfl + "er";
                this.inflValues_.addElement(new InflVar(eui, unInfl, type, "comparative", inflVar, cat, cit));
                this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "comparative", unInfl, cit));
                inflVar = unInfl + "est";
                this.inflValues_.addElement(new InflVar(eui, unInfl, type, "superlative", inflVar, cat, cit));
                this.agrValues_.addElement(new Agreement(eui, inflVar, cat, "superlative", unInfl, cit));
                continue;
            }
            if (variant.startsWith("inv;periph")) {
                this.agrValues_.addElement(new Agreement(eui, unInfl, cat, "positive;periph", unInfl, cit));
                continue;
            }
            this.agrValues_.addElement(new Agreement(eui, unInfl, cat, "positive", unInfl, cit));
        }
    }

    public static char GetLastChar(String in) {
        int length = in.length();
        char out = in.toLowerCase().charAt(length - 1);
        return out;
    }

    public static char GetLast2Char(String in) {
        int length = in.length();
        char out = in.toLowerCase().charAt(length - 2);
        return out;
    }

    private void GetAuxInflVarsAndAgreements(String unInfl, String eui, String cat, String cit) {
        this.inflValues_.addElement(new InflVar(eui, unInfl, "base", unInfl, cat, cit));
        Vector<String> variants = this.lexRecord_.GetCatEntry().GetAuxEntry().GetVariant();
        for (int i = 0; i < variants.size(); ++i) {
            String variant = variants.elementAt(i);
            int index = variant.indexOf(";");
            String value = variant.substring(0, index);
            int index1 = variant.indexOf("(", index);
            int index2 = variant.indexOf(":", index);
            String inflStr = variant.substring(index + 1);
            String infl = this.MapToInflection(inflStr);
            this.inflValues_.addElement(new InflVar(eui, unInfl, "reg", infl, value, cat, cit));
            this.agrValues_.addElement(new Agreement(eui, value, cat, inflStr, unInfl, cit));
        }
    }

    private void GetModalInflVarsAndAgreements(String unInfl, String eui, String cat, String cit) {
        this.inflValues_.addElement(new InflVar(eui, unInfl, "base", unInfl, cat, cit));
        this.inflValues_.addElement(new InflVar(eui, unInfl, "pres", unInfl, cat, cit));
        this.agrValues_.addElement(new Agreement(eui, unInfl, cat, "pres", unInfl, cit));
        Vector<String> variants = this.lexRecord_.GetCatEntry().GetModalEntry().GetVariant();
        for (int i = 0; i < variants.size(); ++i) {
            String variant = variants.elementAt(i);
            int index = variant.indexOf(";");
            String value = variant.substring(0, index);
            int index1 = variant.indexOf("(", index);
            int index2 = variant.indexOf(":", index);
            String inflStr = variant.substring(index + 1);
            String infl = this.MapToInflection(inflStr);
            this.inflValues_.addElement(new InflVar(eui, unInfl, "reg", infl, value, cat, cit));
            this.agrValues_.addElement(new Agreement(eui, value, cat, inflStr, unInfl, cit));
        }
    }

    private String MapToInflection(String in) {
        String delim = " (,):";
        StringTokenizer buf = new StringTokenizer(in, delim);
        String out = new String();
        while (buf.hasMoreTokens()) {
            String curToken = buf.nextToken();
            if (curToken.equals("past")) {
                out = out + "past";
                continue;
            }
            if (curToken.equals("pres")) {
                out = out + "pres";
                continue;
            }
            if (curToken.equals("past_part")) {
                out = out + "pastPart";
                continue;
            }
            if (curToken.equals("pres_part")) {
                out = out + "presPart";
                continue;
            }
            if (curToken.equals("infinitive")) {
                out = out + "infinitive";
                continue;
            }
            if (curToken.equals("negative")) {
                out = out + "Neg";
                continue;
            }
            if (curToken.equals("fst_sing")) {
                out = out + "1s";
                continue;
            }
            if (curToken.equals("fst_plur")) {
                out = out + "1p";
                continue;
            }
            if (curToken.equals("second")) {
                out = out + "2";
                continue;
            }
            if (curToken.equals("sec_sing")) {
                out = out + "2s";
                continue;
            }
            if (curToken.equals("sec_plur")) {
                out = out + "2p";
                continue;
            }
            if (curToken.equals("third")) {
                out = out + "3";
                continue;
            }
            if (curToken.equals("thr_sing")) {
                out = out + "3s";
                continue;
            }
            if (!curToken.equals("thr_plur")) continue;
            out = out + "3p";
        }
        int index = out.indexOf("1s1p");
        if (index > 0) {
            out = out.substring(0, index + 1) + out.substring(index + 4);
        }
        if (!inflections_.contains(out)) {
            System.out.println("** Error: inflection '" + out + "' is illegal");
            out = "Error";
        }
        return out;
    }

    private void GetPronInflVarsAndAgreements(String unInfl, String eui, String cat, String cit) {
        this.inflValues_.addElement(new InflVar(eui, unInfl, "base", unInfl, cat, cit));
        Vector<String> variants = this.lexRecord_.GetCatEntry().GetPronEntry().GetVariants();
        String agreement = new String();
        for (int i = 0; i < variants.size(); ++i) {
            agreement = variants.elementAt(i);
            this.agrValues_.addElement(new Agreement(eui, unInfl, cat, agreement, unInfl, cit));
        }
    }

    private void GetDetInflVarsAndAgreements(String unInfl, String eui, String cat, String cit) {
        this.inflValues_.addElement(new InflVar(eui, unInfl, "base", unInfl, cat, cit));
        String agreement = this.lexRecord_.GetCatEntry().GetDetEntry().GetVariants();
        if (agreement.equals("singuncount")) {
            this.agrValues_.addElement(new Agreement(eui, unInfl, cat, "sing", unInfl, cit));
            this.agrValues_.addElement(new Agreement(eui, unInfl, cat, "uncount", unInfl, cit));
        } else if (agreement.equals("pluruncount")) {
            this.agrValues_.addElement(new Agreement(eui, unInfl, cat, "plur", unInfl, cit));
            this.agrValues_.addElement(new Agreement(eui, unInfl, cat, "uncount", unInfl, cit));
        } else {
            this.agrValues_.addElement(new Agreement(eui, unInfl, cat, agreement, unInfl, cit));
        }
    }

    private void GetPrepInflVarsAndAgreements(String unInfl, String eui, String cat, String cit) {
        this.inflValues_.addElement(new InflVar(eui, unInfl, "base", unInfl, cat, cit));
        this.agrValues_.addElement(new Agreement(eui, unInfl, cat, new String(), unInfl, cit));
    }

    private void GetComplInflVarsAndAgreements(String unInfl, String eui, String cat, String cit) {
        this.inflValues_.addElement(new InflVar(eui, unInfl, "base", unInfl, cat, cit));
        this.agrValues_.addElement(new Agreement(eui, unInfl, cat, new String(), unInfl, cit));
    }

    private void GetConjInflVarsAndAgreements(String unInfl, String eui, String cat, String cit) {
        this.inflValues_.addElement(new InflVar(eui, unInfl, "base", unInfl, cat, cit));
        this.agrValues_.addElement(new Agreement(eui, unInfl, cat, new String(), unInfl, cit));
    }

    private boolean IsUnique(Vector<InflVar> inflVars, InflVar inflVar) {
        boolean isUnique = true;
        for (int i = 0; i < inflVars.size(); ++i) {
            InflVar cur = inflVars.elementAt(i);
            if (inflVar.GetEui() == null || cur.GetEui() == null) {
                if (!inflVar.GetVar().equals(cur.GetVar()) || !inflVar.GetInflection().equals(cur.GetInflection()) || !inflVar.GetCat().equals(cur.GetCat()) || !inflVar.GetCit().equals(cur.GetCit()) || !inflVar.GetUnInfl().equals(cur.GetUnInfl())) continue;
                isUnique = false;
                break;
            }
            if (!inflVar.GetVar().equals(cur.GetVar()) || !inflVar.GetInflection().equals(cur.GetInflection()) || !inflVar.GetCat().equals(cur.GetCat()) || !inflVar.GetCit().equals(cur.GetCit()) || !inflVar.GetEui().equals(cur.GetEui()) || !inflVar.GetUnInfl().equals(cur.GetUnInfl())) continue;
            isUnique = false;
            break;
        }
        return isUnique;
    }

    static {
        inflections_.add("base");
        inflections_.add("comparative");
        inflections_.add("superlative");
        inflections_.add("plural");
        inflections_.add("presPart");
        inflections_.add("past");
        inflections_.add("pastPart");
        inflections_.add("pres3s");
        inflections_.add("positive");
        inflections_.add("singular");
        inflections_.add("infinitive");
        inflections_.add("pres123p");
        inflections_.add("pastNeg");
        inflections_.add("pres123pNeg");
        inflections_.add("pres1s");
        inflections_.add("past1p23pNeg");
        inflections_.add("past1p23p");
        inflections_.add("past1s3sNeg");
        inflections_.add("pres1p23p");
        inflections_.add("pres1p23pNeg");
        inflections_.add("past1s3s");
        inflections_.add("pres");
        inflections_.add("pres3sNeg");
        inflections_.add("presNeg");
        vowels_.add("a");
        vowels_.add("e");
        vowels_.add("i");
        vowels_.add("o");
        vowels_.add("u");
        consonants_.add("b");
        consonants_.add("c");
        consonants_.add("d");
        consonants_.add("f");
        consonants_.add("g");
        consonants_.add("h");
        consonants_.add("j");
        consonants_.add("k");
        consonants_.add("l");
        consonants_.add("m");
        consonants_.add("n");
        consonants_.add("p");
        consonants_.add("q");
        consonants_.add("r");
        consonants_.add("s");
        consonants_.add("t");
        consonants_.add("v");
        consonants_.add("w");
        consonants_.add("x");
        consonants_.add("y");
        consonants_.add("z");
        eioySets_.add("e");
        eioySets_.add("i");
        eioySets_.add("o");
        eioySets_.add("y");
    }
}

