/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexCheck.CkLib;

import gov.nih.nlm.nls.lexCheck.CkLib.CheckObject;
import gov.nih.nlm.nls.lexCheck.Lib.CheckFillerFormat;
import gov.nih.nlm.nls.lexCheck.Lib.CheckFormat;
import gov.nih.nlm.nls.lexCheck.Lib.ErrMsg;
import gov.nih.nlm.nls.lexCheck.Lib.LineObject;
import gov.nih.nlm.nls.lexCheck.Lib.TokenObject;
import java.util.StringTokenizer;

public class LineCheck {
    public static boolean CheckStartStr(LineObject lineObject, boolean printFlag, CheckObject checkObject) {
        String line = lineObject.GetLine();
        String startStr = checkObject.GetStartStr();
        boolean flag = line.startsWith(startStr);
        boolean isTab = checkObject.IsTab();
        int beginIndex = 0;
        int endIndex = startStr.length() - 1;
        if (isTab) {
            beginIndex = 1;
        }
        if (!flag) {
            ErrMsg.PrintErrMsg(printFlag, checkObject.GetStartErrMsg(), lineObject, null, beginIndex, endIndex, isTab);
        }
        return flag;
    }

    public static boolean CheckWholeLine(LineObject lineObject, boolean printFlag, CheckObject checkObject) {
        String line = lineObject.GetLine();
        String startStr = checkObject.GetStartStr();
        boolean flag = line.equals(startStr);
        boolean isTab = checkObject.IsTab();
        int beginIndex = 0;
        int endIndex = startStr.length();
        if (isTab) {
            beginIndex = 1;
        }
        if (!flag) {
            ErrMsg.PrintErrMsg(printFlag, checkObject.GetStartErrMsg(), lineObject, null, beginIndex, endIndex, isTab);
        }
        return flag;
    }

    public static String GetStartStr(LineObject lineObject, String delim) {
        String line = lineObject.GetLine();
        StringTokenizer buf = new StringTokenizer(line, delim);
        String startStr = new String();
        if (buf.hasMoreTokens()) {
            startStr = buf.nextToken();
        }
        return startStr;
    }

    public static boolean CheckSlotFiller(LineObject lineObject, boolean printFlag, CheckObject checkObject, TokenObject tokenObject, boolean checkLength) {
        String line = lineObject.GetLine();
        boolean isTab = checkObject.IsTab();
        String slot = null;
        String filler = null;
        String delim = checkObject.GetDelim();
        int index = line.indexOf(delim);
        if (index != -1) {
            if (delim == "=") {
                slot = line.substring(0, index + 1);
                filler = line.substring(index + 1);
            } else {
                slot = line.substring(0, index + 1);
                filler = line;
            }
        } else {
            ErrMsg.PrintErrMsg(printFlag, 80, lineObject, line, 0, line.length(), isTab);
            return false;
        }
        boolean flag = false;
        String startStr = checkObject.GetStartStr();
        if (startStr != null) {
            flag = slot.equals(startStr);
        }
        if (!flag) {
            ErrMsg.PrintErrMsg(printFlag, checkObject.GetStartErrMsg(), lineObject, slot, 0, index, isTab);
            return flag;
        }
        flag = CheckFillerFormat.IsLegalFormat(printFlag, lineObject, filler, index, isTab, checkLength);
        if (!flag) {
            return false;
        }
        CheckFormat fillerFormat = checkObject.GetFillerFormat();
        if (fillerFormat != null && !(flag = fillerFormat.IsLegalFormat(filler))) {
            ErrMsg.PrintErrMsg(printFlag, checkObject.GetFillerErrMsg(), lineObject, filler, index + 1, index + filler.length(), isTab);
            return flag;
        }
        if (flag && tokenObject != null) {
            tokenObject.SetToken(filler);
        }
        return flag;
    }
}

