/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexCheck.Api;

import gov.nih.nlm.nls.lexCheck.Api.ApiOutput;
import gov.nih.nlm.nls.lexCheck.Api.ToInflVarsApi;
import gov.nih.nlm.nls.lexCheck.Gram.CheckGrammer;
import gov.nih.nlm.nls.lexCheck.Lib.CheckSt;
import gov.nih.nlm.nls.lexCheck.Lib.Convert;
import gov.nih.nlm.nls.lexCheck.Lib.LineObject;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;

public class ToXmlApi {
    @Deprecated
    public static ApiOutput ToXmlFromFile(String inFile) {
        return ToXmlApi.ToXmlFromTextFile(inFile);
    }

    public static ApiOutput ToXmlFromTextFile(String inFile) {
        CheckSt st = new CheckSt();
        CheckSt catSt = new CheckSt(40);
        LineObject lineObject = new LineObject();
        StringBuffer xmlOut = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        xmlOut.append("<lexRecords>\n");
        int recordNum = 0;
        try {
            BufferedReader inReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inFile), "UTF-8"));
            while (lineObject != null) {
                if (lineObject.IsGoToNext()) {
                    lineObject.SetLine(inReader.readLine());
                    lineObject.IncreaseLineNum();
                }
                if (lineObject.GetLine() == null) break;
                recordNum = ToXmlApi.CheckLine(st, catSt, lineObject, xmlOut, recordNum);
            }
            inReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        xmlOut.append("</lexRecords>\n");
        ApiOutput apiOutput = new ApiOutput(xmlOut.toString(), recordNum);
        return apiOutput;
    }

    public static ApiOutput ToXmlFromText(String text) {
        CheckSt st = new CheckSt();
        CheckSt catSt = new CheckSt(40);
        LineObject lineObject = new LineObject();
        StringBuffer xmlOut = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        xmlOut.append("<lexRecords>\n");
        int recordNum = 0;
        String unixText = Convert.ToUnixLineSeparator(text);
        StringTokenizer buf = new StringTokenizer(unixText, "\n");
        while (lineObject != null) {
            if (lineObject.IsGoToNext()) {
                if (!buf.hasMoreTokens()) break;
                lineObject.SetLine(buf.nextToken());
                lineObject.IncreaseLineNum();
            }
            recordNum = ToXmlApi.CheckLine(st, catSt, lineObject, xmlOut, recordNum);
        }
        xmlOut.append("</lexRecords>\n");
        ApiOutput apiOutput = new ApiOutput(xmlOut.toString(), recordNum);
        return apiOutput;
    }

    @Deprecated
    public static Vector GetInflVars(String inFile) {
        return ToInflVarsApi.GetInflVarsFromTextFile(inFile);
    }

    public static void main(String[] args) {
        String bat = "{base=bat\nentry=E0012112\n\tcat=noun\n\tvariants=reg\nsignature=vanni\n}";
        String molt = "{base=molt\nspelling_variant=moult\nentry=E0040723\n\tcat=noun\n\tvariants=reg\nsignature=vanni\n}\n{base=molt\nspelling_variant=moult\nentry=E0040724\n\tcat=verb\n\tvariants=reg\n\tintran\n\ttran=np\n\tnominalization=molting|noun|E0412675\nsignature=vanni\n}";
        String inFile = "molt";
        System.out.print(ToXmlApi.ToXmlFromFile(inFile).GetXml());
        System.out.println("---- Record Num: " + ToXmlApi.ToXmlFromFile(inFile).GetRecordNum());
    }

    private static int CheckLine(CheckSt st, CheckSt catSt, LineObject lineObject, StringBuffer xmlOut, int recordNum) {
        boolean flag = false;
        boolean printFlag = true;
        flag = CheckGrammer.Check(lineObject, printFlag, st, catSt, false);
        if (st.GetCurState() == 10 && flag) {
            xmlOut.append(CheckGrammer.GetLexRecord().GetXml());
            ++recordNum;
        }
        return recordNum;
    }
}

