/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Operations;

import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.ByBasePanel;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.ByCategoryPanel;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.ByTermEuiPanel;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.LaFrame;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Model.LaObj;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Operations.FileIoOperations;
import java.io.File;
import java.util.GregorianCalendar;

public class ByCategoryOperations {
    private ByCategoryOperations() {
    }

    public static void SearchOperation(LaObj laObj) {
        long category = ByCategoryPanel.GetCategory();
        String outStr = laObj.GetLexAccessResultsByCategory(category);
        if (laObj.GetOutSource() == 0) {
            ByCategoryPanel.GetLaOutputs().setText(outStr);
            ByCategoryPanel.GetLaOutputs().setCaretPosition(0);
        } else {
            String outPath = new String();
            File outFile = laObj.GetOutFile();
            try {
                outPath = outFile.getCanonicalPath();
            }
            catch (Exception e) {
                // empty catch block
            }
            boolean append = laObj.GetAppendToOutFile();
            String msgStr = "--- The results are saved to the following file ---\n";
            if (append) {
                msgStr = "--- The results are appended to the following file ---\n";
            }
            GregorianCalendar cal = new GregorianCalendar();
            msgStr = msgStr + outPath + "\n" + "@" + cal.getTime().toString();
            ByCategoryPanel.GetLaOutputs().setText(msgStr);
            ByCategoryPanel.GetLaOutputs().setCaretPosition(0);
            FileIoOperations.WriteToFile(outFile, outStr, append);
        }
    }

    public static void ClearAllOperation() {
        ByCategoryPanel.ClearAllCategory();
    }

    public static void SelectAllOperation() {
        ByCategoryPanel.SelectAllCategory();
    }

    public static void ResetOperation(LaFrame owner) {
        owner.GetLaObj().ResetAllOptions();
        ByCategoryPanel.ClearAllCategory();
        ByCategoryPanel.GetLaOutputs().setText("-- All Options of LexAccess Tool are reset to default values.");
        ByTermEuiPanel.UpdateInputPanel(owner.GetLaObj().GetInSource());
        ByBasePanel.UpdateInputPanel(owner.GetLaObj().GetInSource());
        ByCategoryPanel.UpdateInputPanel(owner.GetLaObj().GetInSource());
    }
}

