/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexAccess.Lib;

import gov.nih.nlm.nls.lexAccess.Util.GlobalVars;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class Configuration {
    public static final String LA_DIR = "LA_DIR";
    public static final String AUTO_MODE = "AUTO_MODE";
    public static final String DB_TYPE = "DB_TYPE";
    public static final String DB_DRIVER = "DB_DRIVER";
    public static final String JDBC_URL = "JDBC_URL";
    public static final String DB_HOST = "DB_HOST";
    public static final String DB_PORT_NUM = "DB_PORT_NUM";
    public static final String DB_NAME = "DB_NAME";
    public static final String DB_USERNAME = "DB_USERNAME";
    public static final String DB_PASSWORD = "DB_PASSWORD";
    public static final String NO_OUTPUT_MSG = "NO_OUTPUT_MSG";
    public static final String TEXT_INDENT = "TEXT_INDENT";
    public static final String XML_INDENT = "XML_INDENT";
    public static final String XML_HEADER = "XML_HEADER";
    private PropertyResourceBundle configSrc_ = null;
    private Hashtable<String, String> config_ = new Hashtable();

    public Configuration(String fName, boolean useClassPath) {
        this.SetConfiguration(fName, useClassPath);
    }

    public String GetConfiguration(String key) {
        String out = this.config_.get(key);
        return out;
    }

    public void OverwriteProperties(Hashtable<String, String> properties) {
        Enumeration<String> e = properties.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            String value = properties.get(key);
            this.config_.put(key, value);
        }
    }

    public String GetInformation() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("LA_DIR: [" + this.GetConfiguration(LA_DIR) + "]");
        buffer.append(GlobalVars.LS_STR);
        buffer.append("DB_TYPE: [" + this.GetConfiguration(DB_TYPE) + "]");
        buffer.append(GlobalVars.LS_STR);
        buffer.append("DB_NAME: [" + this.GetConfiguration(DB_NAME) + "]");
        return buffer.toString();
    }

    private void SetConfiguration(String fName, boolean useClassPath) {
        Object file;
        try {
            if (useClassPath) {
                this.configSrc_ = (PropertyResourceBundle)ResourceBundle.getBundle(fName);
            } else {
                file = new FileInputStream(fName);
                this.configSrc_ = new PropertyResourceBundle((InputStream)file);
                ((FileInputStream)file).close();
            }
        }
        catch (Exception e) {
            System.out.println("** Configuration Error: " + e.getMessage());
            System.out.println("** Error: problem of opening/reading config file: '" + fName + "'. Use -x option to specify the config file path.");
        }
        Enumeration<String> e = this.configSrc_.getKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            String value = this.configSrc_.getString(key);
            this.config_.put(key, value);
        }
        if (this.GetConfiguration(LA_DIR).equals(AUTO_MODE)) {
            file = new File(System.getProperty("user.dir"));
            String curDir = ((File)file).getAbsolutePath() + System.getProperty("file.separator");
            this.config_.put(LA_DIR, curDir);
        }
    }
}

