/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft.world.dsl.jungle;

import com.fabriziopolo.textcraft.nlg.Prepositions;
import com.fabriziopolo.textcraft.nlg.SimpleNounAutoBuilder;
import com.fabriziopolo.textcraft.objects.NounOfContents;
import com.fabriziopolo.textcraft.objects.RoomFactory;
import com.fabriziopolo.textcraft.objects.SimpleNoun;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.capability.ResourceState;
import com.fabriziopolo.timecraft.capabilities.TokenResourceCapabilities;
import com.fabriziopolo.timecraft.world.dsl.jungle.Jungle;
import java.util.List;

public class Rooms
extends Jungle {
    private static final int MAX_NUM_TREES_IN_JUNGLE_ROOM = 3;
    private final RoomFactory roomFactory;

    public Rooms(Simulation simulation) {
        super(simulation);
        this.roomFactory = new RoomFactory(simulation);
    }

    public Noun genericJungle() {
        Noun floor = this.lightJungleFloor();
        Noun room = this.roomFactory.roomWithFloor("jungle", "The Jungle is a confusion of wide leafed plants and trees.", "the sound of", "Damp leaves brush unpleasantly against you.", floor);
        return room;
    }

    public Noun thickerJungle() {
        Noun floor = this.lightJungleFloor();
        Noun room = this.roomFactory.roomWithFloor("dense jungle", "The Jungle is denser here.", "the jungle", "It is difficult not to trip over exposed roots and wet plants.", floor);
        return room;
    }

    public Noun thinJungle() {
        Noun floor = this.lightJungleFloor();
        Noun room = this.roomFactory.roomWithFloor("a gap in the jungle", "There is a gap in the jungle here where a tree has fallen.", "the jungle", "Damp leaves brush unpleasantly against you.", floor);
        return room;
    }

    public Noun flexibleJungle() {
        FlexibleJungleRoomNoun room = new FlexibleJungleRoomNoun();
        Noun floor = this.lightJungleFloor();
        this.roomFactory.addFloorToRoom(room, floor);
        int numTrees = this.simulation.getRandom().nextInt(3);
        for (int i = 0; i < numTrees; ++i) {
            this.put(this.createRandomJungleTree(), Prepositions.on, floor);
        }
        if (numTrees == 0) {
            this.put(this.beach().plants().treeLog("wimba"), Prepositions.on, floor);
        }
        int numPlants = this.simulation.getRandom().nextInt(2);
        for (int i = 0; i < numPlants; ++i) {
            this.put(this.beach().plants().junglePlant(), Prepositions.on, floor);
        }
        return room;
    }

    private Noun createRandomJungleTree() {
        int i = this.simulation.getRandom().nextInt(3);
        switch (i) {
            case 0: {
                return this.plants().figTreeWithRandomFigs();
            }
            case 1: {
                return this.beach().plants().smallPalmTree();
            }
            case 2: {
                return this.beach().plants().smallPalmTree();
            }
        }
        return this.beach().plants().smallPalmTree();
    }

    private Noun lightJungleFloor() {
        SimpleNoun floor = new SimpleNounAutoBuilder().setDescription("The jungle floor is littered with random bits of plant matter in various states of decay.", "the jungle floor", "floors", "jungle", "jungles").visibleInDark().build();
        return floor;
    }

    private final class FlexibleJungleRoomNoun
    extends NounOfContents {
        private final Noun jungle;
        private final Noun denseJungle;
        private final Noun thinJungle;

        private FlexibleJungleRoomNoun() {
            this.jungle = Rooms.this.genericJungle();
            this.denseJungle = Rooms.this.thickerJungle();
            this.thinJungle = Rooms.this.thinJungle();
        }

        @Override
        protected Noun getDelegateBasedOnContents(Noun object, List<Noun> contents, Frame frame) {
            ResourceState resourceState = ResourceState.get(frame);
            long numTrees = contents.stream().filter(noun -> resourceState.itemSatisfiesCapability((Noun)noun, TokenResourceCapabilities.IS_TREE, frame)).count();
            if (numTrees == 0L) {
                return this.thinJungle;
            }
            if (numTrees <= 2L) {
                return this.jungle;
            }
            return this.denseJungle;
        }
    }
}

