/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft.world.dsl.beach;

import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.perception.Perceiver;
import com.fabriziopolo.textcraft.simulation.perception.PerceptionChannel;
import com.fabriziopolo.textcraft.states.scenery.DelegatingScenery;
import com.fabriziopolo.textcraft.states.scenery.DistanceLimitedScenery;
import com.fabriziopolo.textcraft.states.scenery.LinearlyVisibleScenery;
import com.fabriziopolo.textcraft.states.scenery.Scenery;
import com.fabriziopolo.textcraft.states.scenery.SimpleScenery;
import com.fabriziopolo.textcraft.states.scenery.VisualScenery;
import com.fabriziopolo.textcraft.states.time.TimeState;
import com.fabriziopolo.timecraft.world.dsl.beach.Beach;

public final class Sceneries
extends Beach {
    public Sceneries(Simulation simulation) {
        super(simulation);
    }

    public Scenery mainlandFromNear() {
        return new DelegatingScenery(){

            @Override
            public Scenery getDelegate(Perceiver perceiver, Noun direction, Noun associatedNoun, PerceptionChannel channel, Frame frame) {
                int dayNumber = TimeState.getDaySinceDay0(frame);
                if (dayNumber == 1) {
                    return new SimpleScenery("an imposing column of black, stinking, sulpherous, smoke rises from the mountainous mainland", "the smell of sulpherous smoke distracts from the black silhouette of the mountainous mainland against the stars");
                }
                return new SimpleScenery("the beaches and verdent coastal jungles of the mainland dominate your view", "you can hear waves crash against the beaches of the mainland ");
            }
        };
    }

    public Scenery mainlandFromAfar() {
        return new DelegatingScenery(){

            @Override
            public Scenery getDelegate(Perceiver perceiver, Noun direction, Noun associatedNoun, PerceptionChannel channel, Frame frame) {
                String usualDarkDescription = "the black silhouette of the mainland is visible only as negative space among the stars";
                int dayNumber = TimeState.getDaySinceDay0(frame);
                int hourNumber = TimeState.get(frame).getGameTimeHour();
                if (dayNumber == 1) {
                    String darkDescription = hourNumber < 2 ? usualDarkDescription : "a wildfire burns out of control on the mainland hillside";
                    return new SimpleScenery("a thick column of black smoke rises from the mountainous mainland", darkDescription);
                }
                return new SimpleScenery("the hazy silhouette of a lush, mountainous mainland looms over the ocean", usualDarkDescription);
            }
        };
    }

    public Scenery weasternOceanAndSky() {
        return new DelegatingScenery(){

            @Override
            public Scenery getDelegate(Perceiver perceiver, Noun direction, Noun associatedNoun, PerceptionChannel channel, Frame frame) {
                int dayNumber = TimeState.getDaySinceDay0(frame);
                if (dayNumber < 1) {
                    return null;
                }
                switch (dayNumber) {
                    case 1: {
                        return new SimpleScenery("the ocean stretches to a faintly orange horizon");
                    }
                    case 2: {
                        return new SimpleScenery("the western sky takes on a strangely orange cast");
                    }
                    case 3: {
                        return new SimpleScenery("the western sky glows a shade of orange unjustified by the position of the sun");
                    }
                    case 4: {
                        return new SimpleScenery("a vibrant spectrum of oranges reaches half way across the sky");
                    }
                    case 5: {
                        return new SimpleScenery("a pendulous vortex of storm clouds appears green in contrast to the alien orange sky");
                    }
                }
                return new SimpleScenery("the ocean stretches to the horizon");
            }
        };
    }

    public Scenery oceanToHorizon() {
        return new SimpleScenery("the ocean stretches to the horizon");
    }

    public Scenery beachContinues(String direction, String bendDirection, double maxVisibleDistance) {
        SimpleScenery simpleScenery = new SimpleScenery("the beach continues " + direction + " for a bit before bending out of sight to the " + bendDirection);
        return new DistanceLimitedScenery(2.0, maxVisibleDistance, new LinearlyVisibleScenery(simpleScenery, direction));
    }

    public Scenery islandCenter() {
        return new VisualScenery(new SimpleScenery("the rocky high-point of this small island protrudes from the sand"));
    }

    public Scenery islandFromNear() {
        return new VisualScenery(new SimpleScenery("the scenic beach of Alpha Island invites you", "you can hear waves crashing on the beaches of Alpha Island"));
    }

    public Scenery islandFromFar() {
        return new VisualScenery(new SimpleScenery("your short-term home Alpha Island interrupts ocean"));
    }
}

