/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft.world.dsl;

import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.worldbuilder.WorldBuilder;
import com.fabriziopolo.timecraft.world.dsl.beach.Beach;
import com.fabriziopolo.timecraft.world.dsl.builds.Fires;
import com.fabriziopolo.timecraft.world.dsl.builds.Shelters;
import com.fabriziopolo.timecraft.world.dsl.crafts.Clothes;
import com.fabriziopolo.timecraft.world.dsl.crafts.Tools;
import com.fabriziopolo.timecraft.world.dsl.crater.Crater;
import com.fabriziopolo.timecraft.world.dsl.jungle.Jungle;
import com.fabriziopolo.timecraft.world.dsl.mountain.Mountain;
import com.fabriziopolo.timecraft.world.dsl.plains.Plains;
import com.fabriziopolo.timecraft.world.dsl.tutorial.Tutorial;

public class Dsl
extends WorldBuilder {
    private Dsl delegate = null;
    private final Tutorial tutorial;
    private final Beach beach;
    private final Plains plains;
    private final Jungle jungle;
    private final Mountain mountain;
    private final Crater crater;
    private final Tools tools;
    private final Clothes clothes;
    private final Shelters shelters;
    private final Fires fires;

    public Dsl(Simulation simulation) {
        super(simulation);
        if (this.getClass().equals(Dsl.class)) {
            this.tutorial = new Tutorial(simulation);
            this.tutorial.setDelegate(this);
            this.beach = new Beach(simulation);
            this.beach.setDelegate(this);
            this.plains = new Plains(simulation);
            this.plains.setDelegate(this);
            this.jungle = new Jungle(simulation);
            this.jungle.setDelegate(this);
            this.mountain = new Mountain(simulation);
            this.mountain.setDelegate(this);
            this.crater = new Crater(simulation);
            this.crater.setDelegate(this);
            this.tools = new Tools(simulation);
            this.tools.setDelegate(this);
            this.clothes = new Clothes(simulation);
            this.clothes.setDelegate(this);
            this.shelters = new Shelters(simulation);
            this.shelters.setDelegate(this);
            this.fires = new Fires(simulation);
            this.fires.setDelegate(this);
        } else {
            this.tutorial = null;
            this.beach = null;
            this.plains = null;
            this.jungle = null;
            this.mountain = null;
            this.crater = null;
            this.tools = null;
            this.clothes = null;
            this.shelters = null;
            this.fires = null;
        }
    }

    public void setDelegate(Dsl delegate) {
        this.delegate = delegate;
    }

    public final Tutorial tutorial() {
        return this.delegate == null ? this.tutorial : this.delegate.tutorial();
    }

    public final Jungle jungle() {
        return this.delegate == null ? this.jungle : this.delegate.jungle();
    }

    public final Plains plains() {
        return this.delegate == null ? this.plains : this.delegate.plains();
    }

    public final Mountain mountain() {
        return this.delegate == null ? this.mountain : this.delegate.mountain();
    }

    public final Beach beach() {
        return this.delegate == null ? this.beach : this.delegate.beach();
    }

    public final Crater crater() {
        return this.delegate == null ? this.crater : this.delegate.crater();
    }

    public final Tools tools() {
        return this.delegate == null ? this.tools : this.delegate.tools();
    }

    public final Clothes clothes() {
        return this.delegate == null ? this.clothes : this.delegate.clothes();
    }

    public final Shelters shelters() {
        return this.delegate == null ? this.shelters : this.delegate.shelters();
    }

    public final Fires fires() {
        return this.delegate == null ? this.fires : this.delegate.fires();
    }
}

