/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.text;

import com.fabriziopolo.textcraft.app.TextPrinter;
import com.fabriziopolo.textcraft.events.end.EndGameEvent;
import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.nlg.Sentences;
import com.fabriziopolo.textcraft.nlg.SimpleDocument;
import com.fabriziopolo.textcraft.simulation.Event;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.perception.Perceiver;
import com.fabriziopolo.textcraft.states.time.TimeState;
import com.fabriziopolo.textcraft.text.Text;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.codehaus.plexus.util.StringUtils;

public final class FrameRenderer {
    private boolean showDebug = false;
    private final int width;
    private final int height;
    private List<Event> unrenderedEvents = new ArrayList<Event>();
    private Frame frame = null;
    private Perceiver perceiver;
    private boolean lastRenderedEventIsBlocking = false;

    public FrameRenderer(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void startRendering(Frame frame, Perceiver perceiver, TextPrinter txt) {
        if (!this.unrenderedEvents.isEmpty()) {
            this.unrenderedEvents = new ArrayList<Event>();
        }
        if (this.lastRenderedEventIsBlocking) {
            this.lastRenderedEventIsBlocking = false;
        }
        this.frame = Objects.requireNonNull(frame);
        this.perceiver = Objects.requireNonNull(perceiver);
        this.unrenderedEvents.addAll(frame.events);
        this.continueRendering(txt);
    }

    public void continueRendering(TextPrinter txt) {
        if (this.unrenderedEvents.isEmpty()) {
            this.lastRenderedEventIsBlocking = false;
            return;
        }
        ArrayList<Event> eventsToRender = new ArrayList<Event>();
        for (int i = 0; i < this.unrenderedEvents.size(); ++i) {
            eventsToRender.add(this.unrenderedEvents.get(i));
            if (this.unrenderedEvents.get(i).isBlocking()) break;
        }
        this.renderEvents(eventsToRender, txt);
        ArrayList<Event> remainingEvents = new ArrayList<Event>();
        for (int j = i + 1; j < this.unrenderedEvents.size(); ++j) {
            remainingEvents.add(this.unrenderedEvents.get(j));
        }
        this.unrenderedEvents = remainingEvents;
    }

    private void renderEvents(List<Event> events, TextPrinter txt) {
        if (events.isEmpty()) {
            return;
        }
        SimpleDocument.Builder doc = SimpleDocument.builder();
        Event finalEvent = events.stream().filter(event -> event instanceof EndGameEvent).findFirst().orElseGet(() -> null);
        if (finalEvent != null) {
            events.remove(finalEvent);
            events.add(finalEvent);
        }
        for (Event event2 : events) {
            this.renderEvent(event2, this.perceiver, doc, this.frame);
        }
        String renderedFrame = doc.build().toString();
        if (this.showDebug && !renderedFrame.isEmpty()) {
            renderedFrame = TimeState.get(this.frame).getGameTimeString() + " - " + renderedFrame;
        }
        if (!renderedFrame.isEmpty()) {
            txt.println(renderedFrame);
        }
        this.lastRenderedEventIsBlocking = events.get(events.size() - 1).isBlocking();
    }

    public boolean isBlocked() {
        if (!this.unrenderedEvents.isEmpty()) {
            return true;
        }
        return this.lastRenderedEventIsBlocking;
    }

    private void renderEvent(Event event, Perceiver perceiver, SimpleDocument.Builder doc, Frame frame) {
        Sentences perception = perceiver.getPerceptionOf(event, frame);
        if (perception != null) {
            if (event.getStyle() == Event.Style.PROMINENT) {
                doc.appendSentencesOnNewLine(Nlg.literalSentences(this.renderProminently(perception.toString())));
            } else if (event.getStyle() == Event.Style.PROMINENT_PAGE) {
                doc.appendSentencesOnNewLine(Nlg.literalSentences(this.renderProminentPage(perception.toString())));
            } else if (event.getStyle() == Event.Style.WARNING) {
                doc.appendSentencesOnNewLine(Nlg.literalSentences(this.renderWarning(perception.toString())));
            } else {
                doc.appendSentencesOnNewLine(perception);
            }
        }
    }

    private String renderProminently(String text) {
        String bar = "+" + StringUtils.repeat("-", this.width - 3) + "+" + Text.getLineSeparator();
        return Text.getLineSeparator() + bar + Text.wrap("| ", " |", this.width - 4, text) + bar;
    }

    private String renderProminentPage(String text) {
        List<String> lines = Text.wrapToLines(this.width - 4, text);
        int numLines = lines.size() + 2;
        return StringUtils.repeat(Text.getLineSeparator(), this.height / 2 + 3 - numLines / 2) + this.renderProminently(text) + StringUtils.repeat(Text.getLineSeparator(), this.height / 2 - 2 - numLines / 2);
    }

    private String renderWarning(String text) {
        return "!! " + text + " !!";
    }
}

