/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.text;

import com.fabriziopolo.textcraft.text.NumberRenderer;
import com.fabriziopolo.textcraft.text.PercentNumberRenderer;

public class BarNumberRenderer
implements NumberRenderer {
    private static final int MAX_WIDTH = 20;
    private static final char OPENING_CHAR = '[';
    private static final char CLOSING_CHAR = ']';
    private static final char FULL_BAR_CHAR = '#';
    private static final char TERMINAL_BAR_CHAR = ')';
    private static final char EMPTY_BAR_CHAR = '\u00b7';
    private static final char MAX_VALUE_SEPERATOR = '|';
    private static final char MISSING_BAR_CHAR = ' ';

    @Override
    public String render(double value, double maxValue) {
        int i;
        int length = this.valueToWidth(value);
        int maxLength = this.valueToWidth(maxValue);
        StringBuilder str = new StringBuilder();
        str.append('[');
        for (i = 0; i < length - 1; ++i) {
            str.append('#');
        }
        if (length > 0) {
            if (length == 20) {
                str.append('#');
            } else {
                str.append(')');
            }
        }
        for (i = length; i < maxLength; ++i) {
            str.append('\u00b7');
        }
        if (maxLength < 20) {
            str.append('|');
            for (i = maxLength + 1; i < 20; ++i) {
                str.append(' ');
            }
        }
        str.append(']');
        str.append(' ');
        str.append(new PercentNumberRenderer().render(value, maxValue));
        return str.toString();
    }

    private int valueToWidth(double value) {
        return (int)Math.ceil(Math.max(0.0, Math.min(1.0, value)) * 20.0);
    }
}

