/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.updatable;

import com.fabriziopolo.textcraft.objects.EmptyNoun;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.State;
import com.fabriziopolo.textcraft.states.ValueState;
import com.fabriziopolo.textcraft.states.updatable.Updateable;

public class UpdateableState
extends ValueState<Updateable> {
    @Override
    protected Class getStateKey() {
        return UpdateableState.class;
    }

    @Override
    public State updateState(Simulation simulation) {
        UpdateableState newState = new UpdateableState();
        this.setUpdatedState(simulation, newState);
        newState.setImmutable();
        newState.invokeUpdates(simulation);
        return newState;
    }

    private void invokeUpdates(Simulation simulation) {
        this.getValueMap().forEach((noun, updateable) -> updateable.update((Noun)noun, simulation));
    }

    public static void requestCreateUpdateable(Simulation simulation, Updateable updateable) {
        UpdateableState.requestSetUpdateable(new EmptyNoun(), updateable, simulation);
    }

    public static void requestSetUpdateable(Noun noun, Updateable updateable, Simulation simulation) {
        simulation.requestStateChange(UpdateableState.class, new ValueState.ChangeRequest<Updateable>(noun, updateable));
    }

    public static void requestRemoveUpdateable(Noun noun, Simulation simulation) {
        simulation.requestStateChange(UpdateableState.class, ValueState.ChangeRequest.remove(noun));
    }
}

