/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.updatable;

import com.fabriziopolo.textcraft.events.notification.PlayerNotificationEvent;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.characterbio.awake.AwakeState;
import com.fabriziopolo.textcraft.states.updatable.Updateable;
import com.fabriziopolo.textcraft.states.updatable.UpdateableState;
import java.util.Objects;

public class NotifyAwakePlayerUpdateable
implements Updateable {
    private final Noun player;
    private final String message;
    private final boolean deferIfSleeping;

    public NotifyAwakePlayerUpdateable(Noun player, String message, boolean deferIfSleeping) {
        this.player = Objects.requireNonNull(player);
        this.message = Objects.requireNonNull(message);
        this.deferIfSleeping = deferIfSleeping;
    }

    @Override
    public void update(Noun noun, Simulation simulation) {
        Frame frame = simulation.getCurrentFrame();
        if (AwakeState.get(frame).isAwake(this.player).booleanValue()) {
            PlayerNotificationEvent.postProminent(this.player, simulation, this.message);
            UpdateableState.requestRemoveUpdateable(noun, simulation);
        } else if (!this.deferIfSleeping) {
            UpdateableState.requestRemoveUpdateable(noun, simulation);
        }
    }
}

