/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.updatable;

import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.time.TimeState;
import com.fabriziopolo.textcraft.states.updatable.Updateable;
import java.time.Instant;
import java.util.Objects;

public class DelayedUpdateable
implements Updateable {
    private final Instant startTime;
    private final Updateable delegate;

    public DelayedUpdateable(Instant startTime, Updateable delegate) {
        this.startTime = Objects.requireNonNull(startTime);
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public void update(Noun noun, Simulation simulation) {
        Instant now = TimeState.get(simulation.getCurrentFrame()).getGameTimeInstant();
        if (now.isAfter(this.startTime)) {
            this.delegate.update(noun, simulation);
        }
    }

    public String toString() {
        return "Delayed(" + this.delegate.toString() + ")";
    }
}

