/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.time;

import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.nlg.Sentences;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.State;
import com.fabriziopolo.textcraft.simulation.UpdateParameters;
import com.fabriziopolo.textcraft.states.sun.SunState;
import com.fabriziopolo.textcraft.text.DebugInfoBuilder;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;

public class TimeState
implements State {
    private static final ZoneId timeZone = ZoneId.of("UTC");
    private final double realTimeElapsed;
    private final Instant startTime;
    private final Instant gameTime;

    public static TimeState get(Frame frame) {
        return (TimeState)frame.states.get(TimeState.class);
    }

    public TimeState(Instant startTime, double realTimeElapsed) {
        this(startTime, startTime, realTimeElapsed);
    }

    private TimeState(Instant startTime, Instant currTime, double realTimeElapsed) {
        this.realTimeElapsed = realTimeElapsed;
        this.startTime = startTime;
        this.gameTime = currTime;
    }

    public ZonedDateTime getGameTime() {
        return ZonedDateTime.ofInstant(this.gameTime, timeZone);
    }

    public Duration getGameTimeElapsed() {
        return Duration.between(this.startTime, this.gameTime);
    }

    public int getGameTimeHour() {
        return this.getGameTime().getHour();
    }

    public static double getGameTimeElapsedHoursSinceDay0(Frame frame) {
        TimeState timeState = TimeState.get(frame);
        ZonedDateTime now = timeState.getGameTime();
        ZonedDateTime day0 = TimeState.getDay0(frame);
        return (double)Duration.between(day0, now).getSeconds() / 3600.0;
    }

    public static int getDaySinceDay0(Frame frame) {
        return (int)TimeState.getGameTimeElapsedHoursSinceDay0(frame) / 24;
    }

    public static int getHourOfDaySinceDay0(Frame frame) {
        return (int)TimeState.getGameTimeElapsedHoursSinceDay0(frame) % 24;
    }

    public static int getMinuteOfDaySinceDay0(Frame frame) {
        return (int)TimeState.getGameTimeElapsedHoursSinceDay0(frame) * 60 % 60;
    }

    public static ZonedDateTime getDay0(Frame frame) {
        TimeState timeState = TimeState.get(frame);
        return ZonedDateTime.ofInstant(timeState.startTime, timeZone).truncatedTo(ChronoUnit.DAYS);
    }

    public static Instant getGameTimeAt(int day, int hour, Frame frame) {
        return TimeState.getDay0(frame).plusDays(day).plusHours(hour).toInstant();
    }

    public Instant getGameTimeInstant() {
        return this.gameTime;
    }

    public static Instant getGameTimeInstantPlusRealTimeSeconds(double seconds, Frame frame) {
        return TimeState.get(frame).getGameTimeInstant().plusSeconds((long)(seconds * frame.updateParameters.getTimeScale()));
    }

    @Override
    public State updateState(Simulation simulation) {
        UpdateParameters params = simulation.getUpdateParameters();
        return new TimeState(this.startTime, this.gameTime.plusNanos((long)(params.getGameTimeDtSeconds() * 1.0E9)), this.realTimeElapsed + params.getPlayTimeDtSeconds());
    }

    @Override
    public String getDebugInfo(Noun noun, Frame frame) {
        double hours = TimeState.getGameTimeElapsedHoursSinceDay0(frame);
        DebugInfoBuilder builder = new DebugInfoBuilder(TimeState.class);
        builder.addLine("day", (int)hours / 24);
        builder.addLine("time", this.getGameTime());
        return builder.toString();
    }

    public String getGameTimeString() {
        return DateTimeFormatter.ofPattern("h:mm a").format(this.getGameTime());
    }

    public Sentences getTimeOfDayDescriptionSentences() {
        return Nlg.literalSentences("It is " + this.getGameTimeDescription() + ".");
    }

    private String getGameTimeDescription() {
        int hour = this.getGameTimeHour();
        return SunState.getGameTimeDescription(hour);
    }

    public static double getHoursFromDuration(Duration elapsed) {
        return (double)elapsed.getSeconds() / 60.0 / 60.0;
    }

    public static Instant getGameTimeInstant(Frame frame) {
        return TimeState.get(frame).getGameTimeInstant();
    }

    public static Instant getNextFrameInstant(Simulation simulation) {
        return TimeState.get(simulation.getCurrentFrame()).getGameTimeInstant().plus(simulation.getUpdateParameters().getGameTimeDtDuration());
    }
}

