/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.temperature;

import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.State;
import com.fabriziopolo.textcraft.states.ValueState;
import com.fabriziopolo.textcraft.states.temperature.TemperatureEffect;
import com.fabriziopolo.textcraft.states.temperature.TemperatureState;

public class TemperatureEffectState
extends ValueState<TemperatureEffect> {
    @Override
    protected Class getStateKey() {
        return TemperatureEffectState.class;
    }

    @Override
    public State updateState(Simulation simulation) {
        TemperatureEffectState newState = new TemperatureEffectState();
        this.setUpdatedState(simulation, newState);
        newState.setImmutable();
        newState.applyEffects(simulation);
        return newState;
    }

    private void applyEffects(Simulation simulation) {
        this.getValueMap().forEach((noun, effect) -> {
            Frame frame = simulation.getCurrentFrame();
            effect.onTemperature((Noun)noun, TemperatureState.getTemperatureAt(noun, frame), simulation);
        });
    }

    public static TemperatureEffectState get(Frame frame) {
        return (TemperatureEffectState)frame.states.get(TemperatureEffectState.class);
    }

    public static void requestSetEffect(Simulation simulation, Noun noun, TemperatureEffect effect) {
        TemperatureEffectState.get(simulation.getCurrentFrame()).requestChange(simulation, noun, effect);
    }
}

