/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.structure;

import com.fabriziopolo.textcraft.nlg.Preposition;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.State;
import com.fabriziopolo.textcraft.simulation.StateChangeRequest;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.states.structure.DefaultPassageFilter;
import com.fabriziopolo.textcraft.states.structure.PassageFilter;
import com.fabriziopolo.textcraft.states.structure.StructureStateBuilder;
import com.fabriziopolo.textcraft.text.DebugInfoBuilder;
import com.fabriziopolo.textcraft.utils.Lockable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class StructureState
extends Lockable
implements State {
    protected final Map<Noun, Boolean> isIntegralMap = new HashMap<Noun, Boolean>();
    protected final Map<Noun, Map<Preposition, Boolean>> isSurroundingMap = new HashMap<Noun, Map<Preposition, Boolean>>();
    protected final Map<Noun, PassageFilter> passageFilterMap = new HashMap<Noun, PassageFilter>();

    public static StructureState get(Frame frame) {
        return (StructureState)frame.states.get(StructureState.class);
    }

    public boolean isIntegral(Noun noun) {
        Boolean is = this.isIntegralMap.get(noun);
        if (is == null) {
            return false;
        }
        return is;
    }

    public boolean isSurrounding(Noun noun, Preposition preposition) {
        Map<Preposition, Boolean> localMap = this.isSurroundingMap.get(noun);
        if (localMap == null) {
            return false;
        }
        Boolean isSurrounding = localMap.get(preposition);
        return isSurrounding == null ? false : isSurrounding;
    }

    public PassageFilter getPassageFilter(Noun interfaceNoun) {
        PassageFilter filter = this.passageFilterMap.get(interfaceNoun);
        if (filter == null) {
            return new DefaultPassageFilter();
        }
        return filter;
    }

    @Override
    public State updateState(Simulation simulation) {
        StructureStateBuilder builder = new StructureStateBuilder(this);
        List<StateChangeRequest> stateChangeRequests = simulation.getStateChangeRequests(StructureState.class);
        if (stateChangeRequests != null) {
            stateChangeRequests.forEach(request -> ((UpdateRequest)request).apply(builder, simulation));
        }
        return builder.build();
    }

    @Override
    public String getDebugInfo(Noun noun, Frame frame) {
        DebugInfoBuilder builder = new DebugInfoBuilder(StructureState.class);
        builder.addLine("isIntegral", this.isIntegral(noun));
        return builder.toString();
    }

    public static Noun getSurroundingParent(Noun noun, Frame frame) {
        StructureState structureState = StructureState.get(frame);
        PositionState positionState = PositionState.get(frame);
        return positionState.getParentSatisfying(noun, structureState::isSurrounding);
    }

    public static Noun getSurroundParentOrRoot(Noun noun, Frame frame) {
        Noun surroundingParent = StructureState.getSurroundingParent(noun, frame);
        if (surroundingParent != null) {
            return surroundingParent;
        }
        return PositionState.get(frame).getContainingRoom(noun);
    }

    public static Noun getNonintegralParent(Noun noun, Frame frame) {
        PositionState positionState = PositionState.get(frame);
        StructureState structureState = StructureState.get(frame);
        Noun parent = positionState.getParent(noun);
        if (parent == null) {
            return noun;
        }
        if (!structureState.isIntegral(parent)) {
            return parent;
        }
        return StructureState.getNonintegralParent(parent, frame);
    }

    public static Set<Noun> getNonintegralChildren(Noun noun, Frame frame) {
        return StructureState.getNonintegralChildren(noun, frame, PositionState.get(frame));
    }

    public static Set<Noun> getNonintegralChildren(Noun noun, Frame frame, PositionState positionState) {
        Set<Noun> children = positionState.getChildren(noun);
        if (children == null) {
            return new HashSet<Noun>();
        }
        StructureState structureState = StructureState.get(frame);
        return children.stream().filter(child -> !structureState.isIntegral((Noun)child)).collect(Collectors.toSet());
    }

    public static List<Noun> getNonintegralDescendents(Noun noun, Frame frame, PositionState positionState) {
        StructureState structureState = StructureState.get(frame);
        return PositionState.get(frame).getDesendentsOf(noun).stream().filter(descendent -> !structureState.isIntegral((Noun)descendent)).collect(Collectors.toList());
    }

    public static StructureStateBuilder builder() {
        return new StructureStateBuilder();
    }

    public static void requestMakeIntegral(Noun noun, Simulation simulation) {
        simulation.requestStateChange(StructureState.class, (partialState, simulation1) -> partialState.makeIntegral(noun));
    }

    public static void requestMakeSurrounding(Noun noun, Preposition preposition, Simulation simulation) {
        simulation.requestStateChange(StructureState.class, (partialState, simulation1) -> partialState.makeSurrounding(noun, preposition));
    }

    public static void requestSetPassageFilter(Noun interfaceNoun, PassageFilter filter, Simulation simulation) {
        simulation.requestStateChange(StructureState.class, (partialState, simulation1) -> partialState.setPassageFilter(interfaceNoun, filter));
    }

    private static interface UpdateRequest
    extends StateChangeRequest {
        public void apply(StructureStateBuilder var1, Simulation var2);
    }
}

