/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.scenery;

import com.fabriziopolo.textcraft.nlg.AdverbialClause;
import com.fabriziopolo.textcraft.nlg.Conjunctions;
import com.fabriziopolo.textcraft.nlg.IndependentClause;
import com.fabriziopolo.textcraft.nlg.IndependentClausesWithConjunction;
import com.fabriziopolo.textcraft.nlg.IndependentWithAdverbialClause;
import com.fabriziopolo.textcraft.nlg.MultipleSentences;
import com.fabriziopolo.textcraft.nlg.PureAdverbialClause;
import com.fabriziopolo.textcraft.nlg.Sentences;
import com.fabriziopolo.textcraft.nlg.SingleClauseSentence;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.State;
import com.fabriziopolo.textcraft.simulation.perception.Perceiver;
import com.fabriziopolo.textcraft.states.ValueState;
import com.fabriziopolo.textcraft.states.scenery.Scenery;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SceneryState
extends ValueState<Scenery> {
    private static final String JUST_AHEAD_MESSAGE = "just ahead";
    private static final String AHEAD_MESSAGE = "ahead";
    private static final String FAR_AHEAD_MESSAGE = "far ahead";
    private static final String IN_THE_DISTANCE_MESSAGE = "in the distance";
    private static final String FAR_IN_THE_DISTANCE_MESSAGE = "far in the distance";

    @Override
    protected Class getStateKey() {
        return SceneryState.class;
    }

    @Override
    public State updateState(Simulation simulation) {
        SceneryState newState = new SceneryState();
        this.setUpdatedState(simulation, newState);
        newState.setImmutable();
        return newState;
    }

    @Override
    public Scenery get(Noun noun) {
        return (Scenery)super.get(noun);
    }

    public static SceneryState get(Frame frame) {
        return (SceneryState)frame.states.get(SceneryState.class);
    }

    public static Sentences getSceneryDescription(Perceiver perceiver, Noun direction, Frame frame) {
        List visibleItems = SceneryState.get(frame).getEntrySet().stream().filter(kv -> {
            Noun nounKey = (Noun)kv.getKey();
            Scenery sceneryValue = (Scenery)kv.getValue();
            return null != perceiver.getPerceptionOf(sceneryValue, direction, nounKey, frame);
        }).collect(Collectors.toList());
        Map<String, List<Map.Entry>> itemsByDistanceDescription = visibleItems.stream().collect(Collectors.groupingBy(kv -> SceneryState.getDistanceDescription(perceiver, (Noun)kv.getKey(), (Scenery)kv.getValue(), frame).toString()));
        ArrayList<IndependentClause> perceptionsOfSceneryItems = new ArrayList<IndependentClause>();
        itemsByDistanceDescription.entrySet().stream().sorted(Comparator.comparing(entry -> -SceneryState.getDistanceRankFromDescription((String)entry.getKey()))).forEach(entry -> {
            String distanceDescription = (String)entry.getKey();
            List items = (List)entry.getValue();
            PureAdverbialClause distanceDescriptionClause = new PureAdverbialClause(distanceDescription);
            List<IndependentClause> itemDescriptions = items.stream().map(kv -> perceiver.getPerceptionOf((Scenery)kv.getValue(), direction, (Noun)kv.getKey(), frame)).collect(Collectors.toList());
            IndependentClausesWithConjunction itemsDescriptionClause = new IndependentClausesWithConjunction(itemDescriptions, Conjunctions.and);
            perceptionsOfSceneryItems.add(IndependentWithAdverbialClause.createInverted(itemsDescriptionClause, distanceDescriptionClause));
        });
        if (perceptionsOfSceneryItems.isEmpty()) {
            return null;
        }
        if (visibleItems.size() <= 2) {
            return new SingleClauseSentence(new IndependentClausesWithConjunction(perceptionsOfSceneryItems, Conjunctions.and));
        }
        return new MultipleSentences(perceptionsOfSceneryItems.stream().map(perceptionClause -> new SingleClauseSentence((IndependentClause)perceptionClause)).collect(Collectors.toList()));
    }

    private static AdverbialClause getDistanceDescription(Noun noun1, Noun noun2, Scenery scenery, Frame frame) {
        return SceneryState.getDistanceDescription(scenery.getPerceivedDistance(noun1, noun2, frame));
    }

    private static AdverbialClause getDistanceDescription(double distance) {
        String literal = distance <= 2.0 ? JUST_AHEAD_MESSAGE : (distance <= 4.0 ? AHEAD_MESSAGE : (distance <= 8.0 ? FAR_AHEAD_MESSAGE : (distance <= 20.0 ? IN_THE_DISTANCE_MESSAGE : FAR_IN_THE_DISTANCE_MESSAGE)));
        return new PureAdverbialClause(literal);
    }

    private static int getDistanceRankFromDescription(String description) {
        switch (description) {
            case "just ahead": {
                return 1;
            }
            case "ahead": {
                return 2;
            }
            case "far ahead": {
                return 3;
            }
            case "in the distance": {
                return 4;
            }
        }
        return 5;
    }

    public static void requestPut(Noun noun, Scenery scenery, Simulation simulation) {
        simulation.requestStateChange(SceneryState.class, new ValueState.ChangeRequest<Scenery>(noun, scenery));
    }
}

