/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.scenery;

import com.fabriziopolo.textcraft.nlg.IndependentClause;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.perception.Perceiver;
import com.fabriziopolo.textcraft.simulation.perception.PerceptionChannel;
import com.fabriziopolo.textcraft.states.coordinate.CoordinateState;
import com.fabriziopolo.textcraft.states.coordinate.Coordinates;
import com.fabriziopolo.textcraft.states.scenery.Scenery;

public class LinearlyVisibleScenery
implements Scenery {
    private final Scenery delegate;
    private final String directionFromPerceiverToScenery;

    public LinearlyVisibleScenery(Scenery delegate, String directionFromPerceiverToScenery) {
        this.delegate = delegate;
        this.directionFromPerceiverToScenery = directionFromPerceiverToScenery;
    }

    @Override
    public IndependentClause asPerceivedBy(Perceiver perceiver, Noun direction, Noun associatedNoun, PerceptionChannel channel, Frame frame) {
        String viewDirectionString = direction.getContextFreeDescription().toString();
        if (!viewDirectionString.equals(this.directionFromPerceiverToScenery)) {
            return null;
        }
        Coordinates perceiverCoordinates = CoordinateState.get(perceiver, frame);
        Coordinates sceneryCoordinates = CoordinateState.get(associatedNoun, frame);
        if (perceiverCoordinates == null || sceneryCoordinates == null) {
            return null;
        }
        double yDiff = sceneryCoordinates.y - perceiverCoordinates.y;
        double xDiff = sceneryCoordinates.x - perceiverCoordinates.x;
        boolean isVisible = false;
        switch (viewDirectionString) {
            case "north": {
                isVisible = yDiff < 0.0 && xDiff == 0.0;
                break;
            }
            case "south": {
                isVisible = yDiff > 0.0 && xDiff == 0.0;
                break;
            }
            case "east": {
                isVisible = xDiff > 0.0 && yDiff == 0.0;
                break;
            }
            case "west": {
                isVisible = xDiff < 0.0 && yDiff == 0.0;
            }
        }
        return isVisible ? this.delegate.asPerceivedBy(perceiver, direction, associatedNoun, channel, frame) : null;
    }

    @Override
    public double getPerceivedDistance(Noun noun1, Noun noun2, Frame frame) {
        return this.delegate.getPerceivedDistance(noun1, noun2, frame);
    }
}

