/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.position;

import com.fabriziopolo.textcraft.nlg.Preposition;
import com.fabriziopolo.textcraft.simulation.Noun;
import java.io.Serializable;
import java.util.Objects;

public final class SpacialRelationship
implements Serializable {
    private final Noun direction;
    private final Preposition preposition;

    private SpacialRelationship(Noun direction, Preposition preposition) {
        this.direction = direction;
        this.preposition = preposition;
    }

    public boolean isDirection() {
        return this.direction != null;
    }

    public boolean isPreposition() {
        return !this.isDirection();
    }

    public Noun getDirection() {
        if (this.isDirection()) {
            return this.direction;
        }
        throw new IllegalStateException("getDirection() called on SpacialRelationship representing preposition.");
    }

    public Preposition getPreposition() {
        if (this.isPreposition()) {
            return this.preposition;
        }
        throw new IllegalStateException("getPreposition() called on SpacialRelationship representing direction.");
    }

    public static SpacialRelationship of(Noun direction) {
        Objects.requireNonNull(direction);
        return new SpacialRelationship(direction, null);
    }

    public static SpacialRelationship of(Preposition preposition) {
        Objects.requireNonNull(preposition);
        return new SpacialRelationship(null, preposition);
    }

    public static SpacialRelationship ofOrNull(Preposition preposition) {
        if (preposition == null) {
            return null;
        }
        return new SpacialRelationship(null, preposition);
    }

    public String toString() {
        return this.isDirection() ? this.direction.toString() : this.preposition.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpacialRelationship that = (SpacialRelationship)o;
        if (this.direction != null ? !this.direction.equals(that.direction) : that.direction != null) {
            return false;
        }
        return this.preposition != null ? this.preposition.equals(that.preposition) : that.preposition == null;
    }

    public int hashCode() {
        int result = this.direction != null ? this.direction.hashCode() : 0;
        result = 31 * result + (this.preposition != null ? this.preposition.hashCode() : 0);
        return result;
    }
}

