/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.position;

import com.fabriziopolo.textcraft.nlg.Preposition;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.states.position.RoomExitLink;
import com.fabriziopolo.textcraft.states.position.SpacialRelationship;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PositionStateBuilder
extends PositionState {
    public PositionStateBuilder() {
    }

    public PositionStateBuilder(PositionState oldState) {
        this.parents.putAll(oldState.parents);
        this.children.putAll(oldState.children);
        this.prepositionMap.putAll(oldState.prepositionMap);
        this.reversePrepositionMap.putAll(oldState.reversePrepositionMap);
        oldState.exitMap.forEach((noun, directionToExitMap) -> this.getOrCreateExitsFor((Noun)noun).putAll((Map<SpacialRelationship, RoomExitLink>)directionToExitMap));
        oldState.entranceMap.forEach((noun, directionToEntranceMap) -> this.getOrCreateEntrancesFor((Noun)noun).putAll((Map<SpacialRelationship, Noun>)directionToEntranceMap));
    }

    public PositionStateBuilder put(Noun child, Preposition preposition, Preposition reversePreposition, Noun parent) {
        this.requireMutable();
        this.disconnect(child);
        this.parents.put(child, parent);
        this.getOrCreateChildren(parent).add(child);
        if (preposition != null) {
            this.prepositionMap.put(child, preposition);
        }
        if (reversePreposition != null) {
            this.reversePrepositionMap.put(child, reversePreposition);
        }
        return this;
    }

    public void disconnect(Noun object) {
        Noun parent = this.getParent(object);
        if (parent != null) {
            this.parents.remove(object);
            this.getChildren(parent).remove(object);
        }
    }

    public void setPreposition(Noun noun, Preposition preposition) {
        this.requireMutable();
        this.prepositionMap.put(noun, preposition);
    }

    public void putExit(Noun room, SpacialRelationship direction, RoomExitLink exitLink) {
        this.requireMutable();
        this.getOrCreateExitsFor(room).put(direction, exitLink);
    }

    public void putEntrance(Noun spot, SpacialRelationship spacialRelationship, Noun entrance) {
        this.requireMutable();
        this.getOrCreateEntrancesFor(spot).put(spacialRelationship, entrance);
    }

    public void putNounsWhereThingIs(Set<Noun> nouns, Noun thing, Frame frame) {
        PositionState positionState = PositionState.get(frame);
        Noun parentSpot = positionState.getParent(thing);
        Preposition preposition = positionState.getPreposition(thing);
        Preposition reversePreposition = positionState.getReversePreposition(thing);
        nouns.forEach(child -> this.disconnect((Noun)child));
        if (parentSpot != null) {
            nouns.forEach(child -> this.put((Noun)child, preposition, reversePreposition, parentSpot));
        }
    }

    public PositionState build() {
        this.setImmutable();
        return this;
    }

    private Set<Noun> getOrCreateChildren(Noun parent) {
        Set<Noun> childrenOfParent = this.getChildren(parent);
        if (childrenOfParent == null) {
            childrenOfParent = new HashSet<Noun>();
            this.children.put(parent, childrenOfParent);
        }
        return childrenOfParent;
    }

    private Map<SpacialRelationship, RoomExitLink> getOrCreateExitsFor(Noun noun) {
        this.requireMutable();
        HashMap map = (HashMap)this.exitMap.get(noun);
        if (map == null) {
            map = new HashMap();
            this.exitMap.put(noun, map);
        }
        return map;
    }

    private Map<SpacialRelationship, Noun> getOrCreateEntrancesFor(Noun noun) {
        this.requireMutable();
        HashMap map = (HashMap)this.entranceMap.get(noun);
        if (map == null) {
            map = new HashMap();
            this.entranceMap.put(noun, map);
        }
        return map;
    }
}

