/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.inventory;

import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.inventory.InventoryState;
import com.fabriziopolo.textcraft.states.inventory.InventoryStateChangeRequest;
import java.util.ArrayList;
import java.util.Collection;

public class InventoryRemoveItemsRequest
implements InventoryStateChangeRequest {
    Noun person;
    Collection<Noun> items;

    private InventoryRemoveItemsRequest(Noun person, Collection<Noun> items) {
        this.items = items;
        this.person = person;
    }

    private InventoryRemoveItemsRequest(Noun person, Noun item) {
        this.items = new ArrayList<Noun>();
        this.items.add(item);
        this.person = person;
    }

    @Override
    public void apply(InventoryState.Builder builder, Simulation simulation) {
        for (Noun item : this.items) {
            builder.discard(this.person, item);
        }
    }

    public static void post(Noun player, Noun objectToDrop, Simulation simulation) {
        simulation.requestStateChange(InventoryState.class, new InventoryRemoveItemsRequest(player, objectToDrop));
    }

    public static void post(Noun objectToDrop, Command.Context context) {
        InventoryRemoveItemsRequest.post(context.player, objectToDrop, context.simulation);
    }
}

