/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.description;

import com.fabriziopolo.textcraft.nlg.GroupedCollectionNounPhrase;
import com.fabriziopolo.textcraft.nlg.MultipleSentences;
import com.fabriziopolo.textcraft.nlg.NounPhrase;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithPrepositionalPhrase;
import com.fabriziopolo.textcraft.nlg.Prepositions;
import com.fabriziopolo.textcraft.nlg.Sentences;
import com.fabriziopolo.textcraft.nlg.SimpleNounAutoBuilder;
import com.fabriziopolo.textcraft.objects.SimpleNoun;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.State;
import com.fabriziopolo.textcraft.simulation.StateChangeRequest;
import com.fabriziopolo.textcraft.simulation.perception.Perceiver;
import com.fabriziopolo.textcraft.simulation.perception.PerceptionChannel;
import com.fabriziopolo.textcraft.states.description.DescriptionStateBuilder;
import com.fabriziopolo.textcraft.states.description.DescriptionStateUpdateRequest;
import com.fabriziopolo.textcraft.states.description.ProminenceState;
import com.fabriziopolo.textcraft.states.light.PerceptionTracePathAlgorithm;
import com.fabriziopolo.textcraft.states.position.PathSegment;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.states.position.SpacialRelationship;
import com.fabriziopolo.textcraft.states.sun.SunState;
import com.fabriziopolo.textcraft.states.time.TimeState;
import com.fabriziopolo.textcraft.states.weather.WeatherState;
import com.fabriziopolo.textcraft.text.DebugInfoBuilder;
import com.fabriziopolo.textcraft.utils.Lockable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DescriptionState
extends Lockable
implements State {
    protected Map<Noun, Boolean> describeChildrenInOverviewMap = new HashMap<Noun, Boolean>();
    protected Map<Noun, Boolean> isExternallyPerceivableMap = new HashMap<Noun, Boolean>();

    public static DescriptionState get(Frame frame) {
        return (DescriptionState)frame.states.get(DescriptionState.class);
    }

    @Override
    public State updateState(Simulation simulation) {
        DescriptionStateBuilder builder = new DescriptionStateBuilder(this);
        List<StateChangeRequest> stateChangeRequests = simulation.getStateChangeRequests(DescriptionState.class);
        if (stateChangeRequests != null) {
            stateChangeRequests.forEach(obj -> ((DescriptionStateUpdateRequest)obj).apply(builder, simulation));
        }
        return builder.build();
    }

    @Override
    public String getDebugInfo(Noun noun, Frame frame) {
        DebugInfoBuilder builder = new DebugInfoBuilder(DescriptionState.class);
        builder.addLine("describeChildrenInOverview", this.shouldDescribeChildrenInOverview(noun));
        builder.addLine("isExternallyPerceivable", this.isExternallyPerceivable(noun));
        return builder.toString();
    }

    public boolean shouldDescribeChildrenInOverview(Noun noun) {
        return this.describeChildrenInOverviewMap.getOrDefault(noun, false);
    }

    public boolean isExternallyPerceivable(Noun noun) {
        return this.isExternallyPerceivableMap.getOrDefault(noun, true);
    }

    public static DescriptionStateBuilder builder() {
        return new DescriptionStateBuilder();
    }

    public static DescriptionStateBuilder builder(DescriptionState state) {
        DescriptionStateBuilder builder = DescriptionState.builder();
        builder.describeChildrenInOverviewMap.putAll(state.describeChildrenInOverviewMap);
        return builder;
    }

    public static void requestDescribeChildrenInOverview(Noun noun, Simulation simulation) {
        simulation.requestStateChange(DescriptionState.class, (partialState, simulation1) -> partialState.describeChildrenInOverview(noun));
    }

    public static void requestSetExternallyVisible(Noun noun, boolean visible, Simulation simulation) {
        simulation.requestStateChange(DescriptionState.class, (partialState, simulation1) -> partialState.setExternallyVisible(noun, visible));
    }

    public final NounPhrase getPathSegmentAsPerceivedBy(Perceiver perceiver, Noun room, SpacialRelationship direction, Frame frame) {
        PathSegment pathSegment = PositionState.get(frame).getExit(room, direction);
        return this.getPathSegmentAsPerceivedBy(perceiver, pathSegment, frame);
    }

    public final NounPhrase getPathSegmentAsPerceivedBy(Perceiver perceiver, PathSegment pathSegment, Frame frame) {
        NounPhrase endRoomDescription = perceiver.getPerceptionOf(pathSegment.endNoun, frame);
        if (endRoomDescription == null) {
            return null;
        }
        Set<Noun> prominentFeatures = this.getProminentNounsDescendingFrom(pathSegment.endNoun, frame);
        if (prominentFeatures.isEmpty()) {
            return endRoomDescription;
        }
        List perceptionsOfProminentFeatures = prominentFeatures.stream().map(featureNoun -> perceiver.getPerceptionOf((Noun)featureNoun, frame)).filter(nounPhrase -> nounPhrase != null).collect(Collectors.toList());
        if (perceptionsOfProminentFeatures.size() == 0) {
            return endRoomDescription;
        }
        GroupedCollectionNounPhrase allProminentFeaturesDescription = GroupedCollectionNounPhrase.create(perceptionsOfProminentFeatures);
        return NounPhraseWithPrepositionalPhrase.builder().setBaseNounPhrase(endRoomDescription).setPreposition(Prepositions.with).setObjectOfPreposition(NounPhraseWithArticle.a(allProminentFeaturesDescription)).build();
    }

    public static Sentences getDescriptionOfWeather(Perceiver perceiver, Frame frame) {
        MultipleSentences.Builder builder = MultipleSentences.builder();
        DescriptionState.appendDescriptionOfTimeOfDay(frame, builder);
        DescriptionState.appendDescriptionOfWeather(frame, builder);
        MultipleSentences weatherDescription = builder.build();
        return DescriptionState.getPerceptionOfExteriorFromString(weatherDescription.toString(), perceiver, frame);
    }

    public static Sentences getVerboseDescriptionOfWeather(Perceiver perceiver, Frame frame) {
        MultipleSentences.Builder builder = MultipleSentences.builder();
        DescriptionState.appendVerboseDescriptionOfTimeOfDay(frame, builder);
        DescriptionState.appendDescriptionOfWeather(frame, builder);
        MultipleSentences weatherDescription = builder.build();
        return DescriptionState.getPerceptionOfExteriorFromString(weatherDescription.toString(), perceiver, frame);
    }

    public static Sentences getPerceptionOfTimeOfDay(Noun perceiver, Frame frame) {
        return DescriptionState.getPerceptionOfExteriorFromString(TimeState.get(frame).getTimeOfDayDescriptionSentences().toString(), perceiver, frame);
    }

    private static Sentences getPerceptionOfExteriorFromString(String description, Noun perceiver, Frame frame) {
        Noun room = PositionState.get(frame).getContainingRoom(perceiver);
        SimpleNoun outsideNoun = new SimpleNounAutoBuilder().setDescription(description.toString(), "oustide", "outsides", new String[0]).alwaysVisible().build();
        Noun viewedWeatherNoun = new PerceptionTracePathAlgorithm().tracePerceptionBetween(outsideNoun, room, perceiver, frame);
        return viewedWeatherNoun.asVerboselyPerceivedBy(perceiver, frame, PerceptionChannel.DEFAULT);
    }

    private static void appendDescriptionOfTimeOfDay(Frame frame, MultipleSentences.Builder roomDescriptionBuilder) {
        SunState.get(frame);
        roomDescriptionBuilder.add(SunState.getDescription(frame));
    }

    private static void appendVerboseDescriptionOfTimeOfDay(Frame frame, MultipleSentences.Builder roomDescriptionBuilder) {
        SunState.get(frame);
        roomDescriptionBuilder.add(SunState.getVerboseDescription(frame));
    }

    private static void appendDescriptionOfWeather(Frame frame, MultipleSentences.Builder roomDescriptionBuilder) {
        roomDescriptionBuilder.add(WeatherState.getWeatherDescription(frame));
    }

    public final Set<Noun> getProminentNounsDescendingFrom(Noun noun, Frame frame) {
        HashSet<Noun> results = new HashSet<Noun>();
        this.accumulateProminentNounsDescendingFrom(noun, frame, results);
        return results;
    }

    private void accumulateProminentNounsDescendingFrom(Noun noun, Frame frame, Set<Noun> results) {
        Set<Noun> childrenOfNoun = PositionState.get(frame).getChildren(noun);
        if (childrenOfNoun == null) {
            return;
        }
        for (Noun child : childrenOfNoun) {
            if (ProminenceState.isProminent(child, frame)) {
                results.add(child);
            }
            if (!this.shouldDescribeChildrenInOverview(child)) continue;
            this.accumulateProminentNounsDescendingFrom(child, frame, results);
        }
    }

    public final Set<Noun> getExternallyPerceivableNounsDescendingFrom(Noun noun, Frame frame) {
        HashSet<Noun> results = new HashSet<Noun>();
        this.accumulateExternallyPerceivableNounsDescendingFrom(noun, frame, results);
        return results;
    }

    private void accumulateExternallyPerceivableNounsDescendingFrom(Noun noun, Frame frame, Set<Noun> results) {
        Set<Noun> childrenOfNoun = PositionState.get(frame).getChildren(noun);
        if (childrenOfNoun == null) {
            return;
        }
        for (Noun child : childrenOfNoun) {
            if (this.isExternallyPerceivable(child)) {
                results.add(child);
            }
            this.accumulateExternallyPerceivableNounsDescendingFrom(child, frame, results);
        }
    }
}

