/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.characterbio.hydration;

import com.fabriziopolo.textcraft.nlg.IndependentClause;
import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.simulation.Event;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.State;
import com.fabriziopolo.textcraft.states.NotifyingNumberWithCauseState;
import com.fabriziopolo.textcraft.states.characterbio.health.HealthState;
import com.fabriziopolo.textcraft.states.characterbio.hydration.HydrationStateBuilder;
import com.fabriziopolo.textcraft.states.notification.Notification;
import com.fabriziopolo.textcraft.states.notification.NotificationKey;
import com.fabriziopolo.textcraft.states.notification.NotificationState;

public class HydrationState
extends NotifyingNumberWithCauseState {
    private static final NotificationKey THIRST_NOTIFICATION_KEY = new NotificationKey(HydrationState.class, "thirst");
    private static final NotificationKey THIRST_DAMAGE_NOTIFICATION_KEY = new NotificationKey(HydrationState.class, "thirst damage");
    private static final int NOTIFICATION_REPEAT_RATE = 60;
    private static final int NOTIFICATION_TIMEOUT = 2;
    public static final double DEHYDRATION_DAMAGE_RATE = -0.005;
    private static final String NOT_THIRSTY_DESCRIPTION = "hydrated";

    public static HydrationState get(Frame frame) {
        return (HydrationState)frame.states.get(HydrationState.class);
    }

    @Override
    protected Class getStateKey() {
        return HydrationState.class;
    }

    private HydrationState getUpdatedThirstState(Simulation simulation) {
        HydrationStateBuilder newState = new HydrationStateBuilder();
        this.setUpdatedState(simulation, newState);
        return newState.build();
    }

    @Override
    public State updateState(Simulation simulation) {
        HydrationState newState = this.getUpdatedThirstState(simulation);
        Frame currentFrame = simulation.getCurrentFrame();
        HealthState health = HealthState.get(currentFrame);
        newState.getValueMap().forEach((noun, waterLevelWithCause) -> {
            if (waterLevelWithCause.value == 0.0) {
                health.requestChange(simulation, (Noun)noun, -0.005, Nlg.literalClause("you are dehydrated"));
            }
            this.maybePostDehydrationNotification(simulation, (Noun)noun, waterLevelWithCause.value);
        });
        return newState;
    }

    private void maybePostDehydrationNotification(Simulation simulation, Noun noun, double hydrationLevel) {
        String hydrationLevelDescription = HydrationState.getHydrationDescription(hydrationLevel);
        if (hydrationLevelDescription.equals(NOT_THIRSTY_DESCRIPTION)) {
            return;
        }
        NotificationState.post(simulation, Notification.builder(noun, THIRST_NOTIFICATION_KEY).setMessage("You are " + hydrationLevelDescription + ".").setDuration(2L).notifyPeriodically(60L).setStyle(this.getNotificationStyle(this.getValue(noun))).build());
    }

    private Event.Style getNotificationStyle(double value) {
        return this.getNotificationStyle(value, -1.0);
    }

    public static String getHydrationDescription(double water) {
        if (water <= 0.0) {
            return "dangerously dehydrated";
        }
        if (water <= 0.1) {
            return "extremely dehydrated";
        }
        if (water <= 0.3) {
            return "dehydrated";
        }
        if (water <= 0.5) {
            return "very thirsty";
        }
        if (water <= 0.7) {
            return "thirsty";
        }
        return NOT_THIRSTY_DESCRIPTION;
    }

    public static HydrationStateBuilder builder() {
        return new HydrationStateBuilder();
    }

    public static void requestChange(Noun noun, double delta, IndependentClause cause, Simulation simulation, boolean notifyOnChange) {
        HydrationState.get(simulation.getCurrentFrame()).requestChange(simulation, noun, delta, cause, notifyOnChange);
    }

    public static void requestChange(Noun noun, double delta, IndependentClause cause, Simulation simulation) {
        HydrationState.requestChange(noun, delta, cause, simulation, true);
    }

    public static void requestChangeWithoutCause(Noun noun, double delta, Simulation simulation) {
        HydrationState.requestChange(noun, delta, null, simulation, false);
    }

    @Override
    protected NotificationKey getNotificationKey() {
        return THIRST_NOTIFICATION_KEY;
    }

    @Override
    protected int getNotificationRepeatRate() {
        return 60;
    }

    @Override
    protected int getNotificationTimeout() {
        return 2;
    }

    @Override
    protected String getIncreaseDescription() {
        return "are hydrated";
    }

    @Override
    protected String getDecreaseDescription() {
        return "lose hydration";
    }

    @Override
    protected Event.Style getNotificationStyle(double value, double change) {
        if (value < 0.1 && change < 0.0) {
            return Event.Style.WARNING;
        }
        return Event.Style.DEFAULT;
    }
}

