/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.characterbio.hunger;

import com.fabriziopolo.textcraft.nlg.IndependentClause;
import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.simulation.Event;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.State;
import com.fabriziopolo.textcraft.states.NotifyingNumberWithCauseState;
import com.fabriziopolo.textcraft.states.characterbio.health.HealthState;
import com.fabriziopolo.textcraft.states.characterbio.hunger.HungerStateBuilder;
import com.fabriziopolo.textcraft.states.notification.Notification;
import com.fabriziopolo.textcraft.states.notification.NotificationKey;
import com.fabriziopolo.textcraft.states.notification.NotificationState;

public class HungerState
extends NotifyingNumberWithCauseState {
    private static final NotificationKey HUNGER_NOTIFICATION_KEY = new NotificationKey(HungerState.class, "hunger");
    private static final NotificationKey HUNGER_DAMAGE_NOTIFICATION_KEY = new NotificationKey(HungerState.class, "hunger damage");
    private static final int NOTIFICATION_REPEAT_RATE = 60;
    private static final int NOTIFICATION_TIMEOUT = 2;
    public static final double STARVATION_DEATH_DAY_COUNT = 14.0;
    public static final double STARVATION_DAMAGE_RATE = -0.37142857142857144;

    public static HungerState get(Frame frame) {
        return (HungerState)frame.states.get(HungerState.class);
    }

    @Override
    protected Class getStateKey() {
        return HungerState.class;
    }

    private HungerState getUpdatedHungerState(Simulation simulation) {
        HungerStateBuilder newState = new HungerStateBuilder();
        this.setUpdatedState(simulation, newState);
        return newState.build();
    }

    @Override
    public State updateState(Simulation simulation) {
        HungerState newState = this.getUpdatedHungerState(simulation);
        Frame frame = simulation.getCurrentFrame();
        HealthState health = HealthState.get(frame);
        newState.getValueMap().forEach((noun, foodLevelWithCause) -> {
            if (foodLevelWithCause.value == 0.0) {
                health.requestChange(simulation, (Noun)noun, frame.updateParameters.getDeltaForRatePerDay(-0.37142857142857144), Nlg.literalClause("you are starving"));
            }
            this.maybePostChangeNotification(simulation, (Noun)noun, foodLevelWithCause.value);
        });
        return newState;
    }

    private void maybePostChangeNotification(Simulation simulation, Noun noun, double foodLevel) {
        String hungerDescription = HungerState.getHungerDescription(foodLevel);
        if (hungerDescription == null) {
            return;
        }
        if (hungerDescription.equals(HungerState.getHungerDescription(1.0))) {
            return;
        }
        NotificationState.post(simulation, new Notification("You are " + hungerDescription + ".", noun, HUNGER_DAMAGE_NOTIFICATION_KEY, 60L, 2L));
    }

    public static void requestChange(Noun noun, double delta, IndependentClause cause, Simulation simulation) {
        HungerState.get(simulation.getCurrentFrame()).requestChange(simulation, noun, delta, cause);
    }

    public static void requestChangeWithoutCause(Noun noun, double delta, Simulation simulation) {
        HungerState.requestChange(noun, delta, null, simulation);
    }

    public static HungerStateBuilder builder() {
        return new HungerStateBuilder();
    }

    @Override
    protected NotificationKey getNotificationKey() {
        return HUNGER_NOTIFICATION_KEY;
    }

    @Override
    protected int getNotificationRepeatRate() {
        return 60;
    }

    @Override
    protected int getNotificationTimeout() {
        return 2;
    }

    @Override
    protected String getIncreaseDescription() {
        return "become less hungry";
    }

    @Override
    protected String getDecreaseDescription() {
        return "become more hungry";
    }

    @Override
    protected Event.Style getNotificationStyle(double value, double change) {
        if (value < 0.1 && change < 0.0) {
            return Event.Style.WARNING;
        }
        return Event.Style.DEFAULT;
    }

    public static String getHungerDescription(double food) {
        if (food <= 0.0) {
            return "starving";
        }
        if (food <= 0.1) {
            return "ravenously hungry";
        }
        if (food <= 0.3) {
            return "very hungry";
        }
        if (food <= 0.5) {
            return "hungry";
        }
        if (food <= 0.7) {
            return null;
        }
        return "full";
    }
}

