/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.characterbio.health;

import com.fabriziopolo.textcraft.events.health.DeathEvent;
import com.fabriziopolo.textcraft.nlg.IndependentClause;
import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.simulation.Event;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.State;
import com.fabriziopolo.textcraft.states.NotifyingNumberWithCauseState;
import com.fabriziopolo.textcraft.states.characterbio.awake.AwakeState;
import com.fabriziopolo.textcraft.states.characterbio.energy.EnergyState;
import com.fabriziopolo.textcraft.states.characterbio.health.HealthStateBuilder;
import com.fabriziopolo.textcraft.states.notification.NotificationKey;
import com.fabriziopolo.textcraft.states.singleplayer.EndGameState;

public class HealthState
extends NotifyingNumberWithCauseState {
    private static final NotificationKey HEALTH_NOTIFICATION_KEY = new NotificationKey(HealthState.class);
    private static final int NOTIFICATION_REPEAT_RATE = 15;
    private static final int NOTIFICATION_TIMEOUT = 1;
    public static final double HEALING_RATE_PER_DAY = 0.3;
    public static final double MAX_PLAYER_HEALTH = 1.0;
    public static final boolean STOP_WAITING_IF_HURT = false;

    public static HealthState get(Frame frame) {
        return (HealthState)frame.states.get(HealthState.class);
    }

    @Override
    public NotifyingNumberWithCauseState.NumberWithCauses get(Noun noun) {
        return (NotifyingNumberWithCauseState.NumberWithCauses)super.get(noun);
    }

    @Override
    protected void applyUpdateRequestSideEffect(Noun noun, NotifyingNumberWithCauseState.NumberWithCauses value, Simulation simulation) {
        if (value.value < 0.0) {
            String causeDescription = value.getCause() == null ? "you lose health" : "you lose health because " + value.getCause();
            NotifyingNumberWithCauseState.NumberWithCauses energyWithCause = EnergyState.get(simulation.getCurrentFrame()).get(noun);
            if (energyWithCause != null && energyWithCause.value != 0.0) {
                AwakeState.requestWakeUpIfHasAwakeState(noun, Nlg.literalClause(causeDescription), simulation);
            }
        }
    }

    @Override
    protected Class getStateKey() {
        return HealthState.class;
    }

    private HealthState getUpdatedHealthState(Simulation simulation) {
        HealthStateBuilder newState = new HealthStateBuilder();
        this.setUpdatedState(simulation, newState);
        return newState.build();
    }

    @Override
    public State updateState(Simulation simulation) {
        Frame frame = simulation.getCurrentFrame();
        HealthState newState = this.getUpdatedHealthState(simulation);
        newState.getValueMap().forEach((noun, healthWithCause) -> {
            if (healthWithCause.value > 0.0) {
                HealthState.requestChangeWithoutCause(noun, this.getEffectiveHealingRate((Noun)noun, frame), simulation);
            }
            Double newValue = healthWithCause.value;
            NotifyingNumberWithCauseState.NumberWithCauses oldValueWithCause = this.get((Noun)noun);
            if (newValue == 0.0 && (oldValueWithCause == null || oldValueWithCause.value > 0.0)) {
                EndGameState.requestEndGame(simulation, DeathEvent.getMessage(healthWithCause.getNegativeCause()).toString());
            }
        });
        return newState;
    }

    public boolean isAlive(Noun noun) {
        NotifyingNumberWithCauseState.NumberWithCauses isAliveWithCause = this.get(noun);
        if (isAliveWithCause == null) {
            return false;
        }
        return isAliveWithCause.value > 0.0;
    }

    private double getEffectiveHealingRate(Noun noun, Frame frame) {
        double multiplier;
        Double maxEnergy = EnergyState.get(frame).getMaxEnergy(noun, frame);
        if (maxEnergy == null) {
            maxEnergy = 1.0;
        }
        if ((multiplier = maxEnergy * 2.0) > 1.0) {
            multiplier = 1.0;
        }
        return frame.updateParameters.getDeltaForRatePerDay(multiplier * 0.3);
    }

    public static HealthStateBuilder builder() {
        return new HealthStateBuilder();
    }

    public static void requestChange(Noun noun, double delta, IndependentClause cause, Simulation simulation) {
        HealthState.get(simulation.getCurrentFrame()).requestChange(simulation, noun, delta, cause);
    }

    public static void requestChangeWithoutCause(Noun noun, double delta, Simulation simulation) {
        HealthState.requestChange(noun, delta, null, simulation);
    }

    @Override
    protected NotificationKey getNotificationKey() {
        return HEALTH_NOTIFICATION_KEY;
    }

    @Override
    protected int getNotificationRepeatRate() {
        return 15;
    }

    @Override
    protected int getNotificationTimeout() {
        return 1;
    }

    @Override
    protected String getIncreaseDescription() {
        return "gain health";
    }

    @Override
    protected String getDecreaseDescription() {
        return "lose health";
    }

    @Override
    protected Event.Style getNotificationStyle(double value, double change) {
        if (value < 0.1 && change < 0.0) {
            return Event.Style.WARNING;
        }
        return Event.Style.DEFAULT;
    }

    public static String getHealthDescription(double health) {
        if (health <= 0.0) {
            return "dead";
        }
        if (health <= 0.1) {
            return "near death";
        }
        if (health <= 0.3) {
            return "dangerously unwell";
        }
        if (health <= 0.5) {
            return "unwell";
        }
        if (health <= 0.7) {
            return "healthy";
        }
        return "vigorous";
    }
}

