/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states;

import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.State;
import com.fabriziopolo.textcraft.simulation.StateChangeRequest;
import com.fabriziopolo.textcraft.text.DebugInfoBuilder;
import com.fabriziopolo.textcraft.utils.Lockable;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class ValueState<T extends Serializable>
extends Lockable
implements State {
    private Map<Noun, T> values = new HashMap<Noun, T>();

    protected T get(Noun noun) {
        return (T)((Serializable)this.values.get(noun));
    }

    protected void set(Noun noun, T value) {
        this.requireMutable();
        if (value == null) {
            this.remove(noun);
            return;
        }
        this.values.put(noun, value);
    }

    protected void setAll(ValueState<T> otherState) {
        this.requireMutable();
        this.setAll(otherState.values);
    }

    protected void setAll(Map<Noun, T> newValues) {
        this.requireMutable();
        newValues.forEach((noun, value) -> this.values.put((Noun)noun, (T)value));
    }

    protected void remove(Noun noun) {
        this.requireMutable();
        this.values.remove(noun);
    }

    protected void cloneStateToBuilder(ValueState<T> newStateBuilder) {
        newStateBuilder.setAll(this);
    }

    protected void setUpdatedState(Simulation simulation, ValueState<T> newStateBuilder) {
        this.cloneStateToBuilder(newStateBuilder);
        newStateBuilder.applyUpdates(simulation);
    }

    protected void applyUpdates(Simulation simulation) {
        this.requireMutable();
        List<StateChangeRequest> stateChangeRequests = simulation.getStateChangeRequests(this.getStateKey());
        if (stateChangeRequests != null) {
            stateChangeRequests.forEach(object -> {
                ChangeRequest req = (ChangeRequest)object;
                T currentValue = this.get(req.noun);
                if (currentValue == null) {
                    this.set(req.noun, (Serializable)req.value);
                } else {
                    Serializable combinedValue = this.combineValues(req.noun, currentValue, (Serializable)req.value, simulation);
                    this.set(req.noun, combinedValue);
                    this.applyUpdateRequestSideEffect(req.noun, (Serializable)req.value, simulation);
                }
            });
        }
    }

    protected Map<Noun, T> getValueMap() {
        return this.values;
    }

    protected Set<Map.Entry<Noun, T>> getEntrySet() {
        return this.values.entrySet();
    }

    protected T combineValues(Noun noun, T t1, T t2, Simulation simulation) {
        return t2;
    }

    protected void applyUpdateRequestSideEffect(Noun noun, T value, Simulation simulation) {
    }

    protected abstract Class getStateKey();

    @Override
    public abstract State updateState(Simulation var1);

    @Override
    public String getDebugInfo(Noun noun, Frame frame) {
        DebugInfoBuilder builder = new DebugInfoBuilder(this.getStateKey());
        builder.addLine("value", this.get(noun));
        return builder.toString();
    }

    public void requestChange(Simulation simulation, Noun noun, T value) {
        ChangeRequest<T> request = new ChangeRequest<T>(noun, value);
        simulation.requestStateChange(this.getStateKey(), request);
    }

    public static class ChangeRequest<T>
    implements StateChangeRequest {
        public final Noun noun;
        public final T value;

        public ChangeRequest(Noun noun, T value) {
            this.noun = Objects.requireNonNull(noun);
            this.value = value;
        }

        public static ChangeRequest remove(Noun noun) {
            return new ChangeRequest<Object>(noun, null);
        }
    }
}

