/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.simulation;

import com.fabriziopolo.textcraft.simulation.Event;
import com.fabriziopolo.textcraft.simulation.State;
import com.fabriziopolo.textcraft.simulation.UpdateParameters;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Frame
implements Serializable {
    public final Map<Object, State> states;
    public final Map<Object, State> prevStates;
    public final List<Event> events;
    public final UpdateParameters updateParameters;
    public final int frameNumber;

    private Frame(Builder builder) {
        this.states = Objects.requireNonNull(builder.states);
        this.prevStates = Objects.requireNonNull(builder.prevStates);
        this.events = Objects.requireNonNull(builder.events);
        this.updateParameters = Objects.requireNonNull(builder.updateParameters);
        this.frameNumber = builder.frameNumber;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builderFromPrevFrame(Frame prevFrame) {
        return new Builder().setPrevStates(prevFrame.states).setUpdateParamters(prevFrame.updateParameters).setFrameNumber(prevFrame.frameNumber + 1);
    }

    public static final class Builder {
        public Map<Object, State> states;
        public Map<Object, State> prevStates = new HashMap<Object, State>();
        public List<Event> events = new ArrayList<Event>();
        public UpdateParameters updateParameters;
        public int frameNumber = 0;

        public Builder setStates(Map<Object, State> states) {
            this.states = states;
            return this;
        }

        public Builder setPrevStates(Map<Object, State> prevStates) {
            this.prevStates = prevStates;
            return this;
        }

        public Builder setEvents(List<Event> events) {
            this.events = events;
            return this;
        }

        public Builder setUpdateParamters(UpdateParameters updateParameters) {
            this.updateParameters = updateParameters;
            return this;
        }

        public Builder setFrameNumber(int frameNumber) {
            this.frameNumber = frameNumber;
            return this;
        }

        public Frame build() {
            return new Frame(this);
        }
    }
}

