/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.objects;

import com.fabriziopolo.textcraft.nlg.NounPhrase;
import com.fabriziopolo.textcraft.nlg.Sentences;
import com.fabriziopolo.textcraft.nlg.SimpleNounAutoBuilder;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.perception.PerceptionChannel;
import com.fabriziopolo.textcraft.states.position.SpacialRelationship;

public class SimpleNoun
implements Noun {
    private final NounPhrase nounPhraseDescription;
    private final Sentences verboseDescription;
    private final NounPhrase nounPhraseDescriptionDark;
    private final Sentences verboseDescriptionDark;
    private final NounPhrase nounPhraseDescriptionBlind;
    private final Sentences verboseDescriptionBlind;

    private SimpleNoun(Builder builder) {
        this.nounPhraseDescription = builder.nounPhraseDescription;
        this.verboseDescription = builder.verboseDescription;
        this.nounPhraseDescriptionDark = builder.nounPhraseDescriptionDark;
        this.verboseDescriptionDark = builder.verboseDescriptionDark;
        this.nounPhraseDescriptionBlind = builder.nounPhraseDescriptionBlind;
        this.verboseDescriptionBlind = builder.verboseDescriptionBlind;
    }

    public static SimpleNoun create(NounPhrase nounPhraseDescription, Sentences verboseDescription) {
        return SimpleNoun.builder(nounPhraseDescription, verboseDescription).build();
    }

    public static SimpleNoun createVisibleInDark(NounPhrase nounPhraseDescription, Sentences verboseDescription) {
        return SimpleNoun.builder(nounPhraseDescription, verboseDescription).setDarkDescription(nounPhraseDescription, verboseDescription).build();
    }

    public static SimpleNoun createAlwaysVisible(NounPhrase nounPhraseDescription, Sentences verboseDescription) {
        return SimpleNoun.builder(nounPhraseDescription, verboseDescription).setDarkDescription(nounPhraseDescription, verboseDescription).setBlindDescription(nounPhraseDescription, verboseDescription).build();
    }

    @Override
    public NounPhrase asPerceivedBy(Noun perceiver, SpacialRelationship spacialRelationship, Frame frame, PerceptionChannel channel) {
        if (channel == PerceptionChannel.BLIND) {
            return this.nounPhraseDescriptionBlind;
        }
        if (channel == PerceptionChannel.DARK) {
            return this.nounPhraseDescriptionDark;
        }
        return this.nounPhraseDescription;
    }

    @Override
    public Sentences asVerboselyPerceivedBy(Noun perceiver, SpacialRelationship spacialRelationship, Frame frame, PerceptionChannel channel) {
        if (channel == PerceptionChannel.BLIND) {
            return this.verboseDescriptionBlind;
        }
        if (channel == PerceptionChannel.DARK) {
            return this.verboseDescriptionDark;
        }
        return this.verboseDescription;
    }

    public String toString() {
        return "SimpleNoun{" + this.nounPhraseDescription + '}';
    }

    public static Builder builder(NounPhrase nounPhraseDescription, Sentences verboseDescription) {
        return new Builder(nounPhraseDescription, verboseDescription);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SimpleNounAutoBuilder autoBuilder() {
        return new SimpleNounAutoBuilder();
    }

    public static SimpleNoun auto(String verboseDescription, String fullString, String pluralNounString, String ... alternatives) {
        return SimpleNoun.autoBuilder().setDescription(verboseDescription, fullString, pluralNounString, alternatives).build();
    }

    public static SimpleNoun autoAlwaysVisible(String verboseDescription, String fullString, String pluralNounString, String ... alternatives) {
        return SimpleNoun.autoBuilder().setDescription(verboseDescription, fullString, pluralNounString, alternatives).alwaysVisible().build();
    }

    public static Builder builder(SimpleNoun simpleNoun) {
        Builder builder = new Builder(simpleNoun.nounPhraseDescription, simpleNoun.verboseDescription);
        builder.setDarkDescription(simpleNoun.nounPhraseDescriptionDark, simpleNoun.verboseDescriptionDark);
        builder.setBlindDescription(simpleNoun.nounPhraseDescriptionBlind, simpleNoun.verboseDescriptionBlind);
        return builder;
    }

    public static final class Builder {
        private NounPhrase nounPhraseDescription;
        private Sentences verboseDescription;
        private NounPhrase nounPhraseDescriptionDark;
        private Sentences verboseDescriptionDark;
        private NounPhrase nounPhraseDescriptionBlind;
        private Sentences verboseDescriptionBlind;

        private Builder() {
        }

        private Builder(NounPhrase nounPhraseDescription, Sentences verboseDescription) {
            this.nounPhraseDescription = nounPhraseDescription;
            this.verboseDescription = verboseDescription;
            this.nounPhraseDescriptionDark = null;
            this.verboseDescriptionDark = null;
            this.nounPhraseDescriptionBlind = null;
            this.verboseDescriptionBlind = null;
        }

        public NounPhrase getNounPhraseDescription() {
            return this.nounPhraseDescription;
        }

        public Sentences getVerboseDescription() {
            return this.verboseDescription;
        }

        public NounPhrase getNounPhraseDescriptionDark() {
            return this.nounPhraseDescriptionDark;
        }

        public Sentences getVerboseDescriptionDark() {
            return this.verboseDescriptionDark;
        }

        public NounPhrase getNounPhraseDescriptionBlind() {
            return this.nounPhraseDescriptionBlind;
        }

        public Sentences getVerboseDescriptionBlind() {
            return this.verboseDescriptionBlind;
        }

        public Builder setDescription(NounPhrase description, Sentences verboseDescription) {
            this.nounPhraseDescription = description;
            this.verboseDescription = verboseDescription;
            return this;
        }

        public Builder setDarkDescription(NounPhrase darkDescription, Sentences darkVerboseDescription) {
            this.nounPhraseDescriptionDark = darkDescription;
            this.verboseDescriptionDark = darkVerboseDescription;
            return this;
        }

        public Builder setBlindDescription(NounPhrase blindDescription, Sentences blindVerboseDescription) {
            this.nounPhraseDescriptionBlind = blindDescription;
            this.verboseDescriptionBlind = blindVerboseDescription;
            return this;
        }

        public SimpleNoun build() {
            return new SimpleNoun(this);
        }
    }
}

