/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.objects;

import com.fabriziopolo.textcraft.objects.AbstractDelegatingNoun;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.perception.PerceptionChannel;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.states.structure.StructureState;
import com.fabriziopolo.textcraft.states.time.TimeState;
import com.fabriziopolo.textcraft.states.updatable.DelayedUpdateable;
import com.fabriziopolo.textcraft.states.updatable.Updateable;
import com.fabriziopolo.textcraft.states.updatable.UpdateableState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class AbstractFuelAndActionNoun
extends AbstractDelegatingNoun {
    protected abstract boolean isFuel(Noun var1, Frame var2);

    protected abstract boolean isMaterial(Noun var1, Frame var2);

    protected abstract double getFuelAmount(Noun var1, Frame var2);

    protected abstract Noun getDelegate(List<Noun> var1, List<Noun> var2, Frame var3);

    protected void onOutOfFuel(Simulation simulation) {
    }

    protected void onFuelSpent(Noun fuel, Simulation simulation) {
    }

    @Override
    protected Noun getDelegate(Noun ignored, PerceptionChannel channel, Frame frame) {
        return this.getDelegate(this.getFuel(frame), this.getMaterials(frame), frame);
    }

    protected List<Noun> getFuel(Frame frame) {
        if (frame == null) {
            return new ArrayList<Noun>();
        }
        return StructureState.getNonintegralChildren(this, frame).stream().filter(child -> this.isFuel((Noun)child, frame)).collect(Collectors.toList());
    }

    protected List<Noun> getMaterials(Frame frame) {
        if (frame == null) {
            return new ArrayList<Noun>();
        }
        return StructureState.getNonintegralChildren(this, frame).stream().filter(child -> this.isMaterial((Noun)child, frame)).collect(Collectors.toList());
    }

    protected double getTotalFuelAmount(Frame frame) {
        return this.getFuel(frame).stream().mapToDouble(fuel -> this.getFuelAmount((Noun)fuel, frame)).sum();
    }

    public void ignite(Simulation simulation) {
        Frame frame = simulation.getCurrentFrame();
        DelayedUpdateable fuelConsumptionUpdate = new DelayedUpdateable(TimeState.get(frame).getGameTimeInstant().plusSeconds(1L), ConsumeFuelUpdate.create(this));
        UpdateableState.requestSetUpdateable(this, fuelConsumptionUpdate, simulation);
    }

    public void putOut(Simulation simulation) {
        PositionState position = PositionState.get(simulation.getCurrentFrame());
        List<Noun> fuel = this.getFuel(simulation.getCurrentFrame());
        if (fuel == null || fuel.isEmpty()) {
            return;
        }
        UpdateableState.requestRemoveUpdateable(this, simulation);
        Noun someFuel = fuel.get(0);
        UpdateableState.requestSetUpdateable(this, new ConsumeFuelUpdate(this, someFuel), simulation);
        fuel.forEach(child -> {
            if (child != someFuel) {
                PositionState.requestRemove(child, simulation);
            }
        });
    }

    public static final class ConsumeFuelUpdate
    implements Updateable {
        private final AbstractFuelAndActionNoun fire;
        private final Noun fuelToConsume;

        private ConsumeFuelUpdate(AbstractFuelAndActionNoun fire, Noun fuelToConsume) {
            this.fire = Objects.requireNonNull(fire);
            this.fuelToConsume = fuelToConsume;
        }

        @Override
        public void update(Noun ignored, Simulation simulation) {
            Frame frame;
            Noun fuel;
            if (this.fuelToConsume != null) {
                this.consumeFuel(this.fuelToConsume, simulation);
            }
            if ((fuel = this.chooseFuelToConsume(frame = simulation.getCurrentFrame())) == null) {
                this.runOutOfFuel(simulation);
                return;
            }
            double fuelValue = this.fire.getFuelAmount(fuel, frame);
            DelayedUpdateable fuelConsumptionUpdate = new DelayedUpdateable(TimeState.getGameTimeInstantPlusRealTimeSeconds(fuelValue, frame), new ConsumeFuelUpdate(this.fire, fuel));
            UpdateableState.requestSetUpdateable(ignored, fuelConsumptionUpdate, simulation);
        }

        private Noun chooseFuelToConsume(Frame frame) {
            List fuel = this.fire.getFuel(frame).stream().filter(unconsumedFuel -> unconsumedFuel != this.fuelToConsume).collect(Collectors.toList());
            return fuel.isEmpty() ? null : (Noun)fuel.get(0);
        }

        private void consumeFuel(Noun fuel, Simulation simulation) {
            PositionState.requestRemove(fuel, simulation);
            this.fire.onFuelSpent(fuel, simulation);
        }

        private void runOutOfFuel(Simulation simulation) {
            UpdateableState.requestRemoveUpdateable(this.fire, simulation);
            this.fire.onOutOfFuel(simulation);
        }

        public static ConsumeFuelUpdate create(AbstractFuelAndActionNoun fire) {
            return new ConsumeFuelUpdate(fire, null);
        }
    }
}

