/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.nlg;

import com.fabriziopolo.textcraft.nlg.AdjectivePhrase;
import com.fabriziopolo.textcraft.nlg.Articles;
import com.fabriziopolo.textcraft.nlg.NounPhrase;
import com.fabriziopolo.textcraft.nlg.Number;
import com.fabriziopolo.textcraft.nlg.Person;
import com.fabriziopolo.textcraft.nlg.SimpleNounPhraseData;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.text.Text;
import com.fabriziopolo.textcraft.text.TextMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class SimpleNounPhrase
implements NounPhrase {
    private final SimpleNounPhraseData data;
    private final Number number;

    private SimpleNounPhrase(String singularNounString, String pluralNounString, Number number) {
        this.data = new SimpleNounPhraseData(singularNounString, pluralNounString, null, true, Person.ThirdPerson, null);
        this.number = number;
    }

    private SimpleNounPhrase(Builder builder) {
        this.data = new SimpleNounPhraseData(builder.singularNounString, builder.pluralNounString, builder.adjectivePhrases, builder.isCountNoun, builder.person, builder.alternativeMatchableNounPhrases);
        this.number = builder.number;
    }

    private SimpleNounPhrase(SimpleNounPhraseData data, Number number) {
        this.data = data;
        this.number = number;
    }

    public static SimpleNounPhrase create(String word, String pluralWord) {
        return new SimpleNounPhrase(word, pluralWord, Number.Singular);
    }

    @Override
    public Number getNumber() {
        return this.number;
    }

    @Override
    public Person getPerson() {
        return this.data.person;
    }

    @Override
    public boolean isCountNoun() {
        return this.data.isCountNoun;
    }

    @Override
    public NounPhrase as(Number number) {
        if (this.number == number) {
            return this;
        }
        if (number == Number.Singular) {
            return new SimpleNounPhrase(this.data, Number.Singular);
        }
        if (this.data.pluralNounString == null) {
            throw new IllegalStateException("Simple noun cannot be converted to plural.  No plural version supplied.");
        }
        return new SimpleNounPhrase(this.data, Number.Plural);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        if (this.hasAdjectives()) {
            str.append(Text.connectWithSpaces(this.data.adjectivePhrases.stream().map(adj -> adj.toString()).collect(Collectors.toList())));
            str.append(" ");
        }
        str.append(this.isPlural() ? this.data.pluralNounString : this.data.singularNounString);
        return str.toString();
    }

    @Override
    public TextMatcher.Result matches(String[] words, int startIndex, Frame frame) {
        TextMatcher.Result result;
        TextMatcher.Result alternativeResult = null;
        if (this.data.alternativeMatchableNounPhrases != null) {
            for (TextMatcher textMatcher : this.data.alternativeMatchableNounPhrases) {
                result = textMatcher.matches(words, startIndex, frame);
                if (!result.isMatch) continue;
                alternativeResult = result;
            }
        }
        if (startIndex >= words.length) {
            return TextMatcher.Result.createFailed();
        }
        int idx = startIndex;
        String string = words[idx].toLowerCase();
        if (Articles.isArticle(string.toLowerCase())) {
            ++idx;
        }
        result = null;
        while (idx < words.length) {
            String nounStringToMatch;
            String string2 = words[idx].toLowerCase();
            String string3 = nounStringToMatch = this.isPlural() ? this.data.pluralNounString : this.data.singularNounString;
            if (string2.equals(nounStringToMatch.toLowerCase())) {
                result = TextMatcher.Result.createMatch(startIndex, idx - startIndex + 1);
                break;
            }
            TextMatcher.Result adjMatchResult = this.matchAdjective(words, idx, frame);
            if (!adjMatchResult.isMatch) break;
            idx += adjMatchResult.numWordsMatched;
        }
        if (result == null) {
            if (alternativeResult == null) {
                return TextMatcher.Result.createFailed();
            }
            return alternativeResult;
        }
        if (alternativeResult == null) {
            return result;
        }
        if (alternativeResult.numWordsMatched > result.numWordsMatched) {
            return alternativeResult;
        }
        return result;
    }

    private TextMatcher.Result matchAdjective(String[] words, int idx, Frame frame) {
        for (AdjectivePhrase adj : this.data.adjectivePhrases) {
            TextMatcher.Result result = adj.matches(words, idx, frame);
            if (!result.isMatch) continue;
            return result;
        }
        return TextMatcher.Result.createFailed();
    }

    private boolean hasAdjectives() {
        return this.data.adjectivePhrases != null && this.data.adjectivePhrases.size() != 0;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SimpleNounPhrase simpleNounPhrase) {
        Builder builder = new Builder();
        builder.setSingular(simpleNounPhrase.data.singularNounString);
        builder.setPlural(simpleNounPhrase.data.pluralNounString);
        if (simpleNounPhrase.isPlural()) {
            builder.plural();
        }
        builder.addAllAdjectives(simpleNounPhrase.data.adjectivePhrases);
        builder.setIsCountNoun(simpleNounPhrase.data.isCountNoun);
        builder.setPerson(simpleNounPhrase.data.person);
        simpleNounPhrase.data.alternativeMatchableNounPhrases.forEach(alt -> builder.addAlternativeMatchableNounPhrase((NounPhrase)alt));
        return builder;
    }

    public static final class Builder {
        private String singularNounString;
        private String pluralNounString;
        private Number number = Number.Singular;
        private List<AdjectivePhrase> adjectivePhrases = new ArrayList<AdjectivePhrase>();
        private boolean isCountNoun = true;
        private Person person = Person.ThirdPerson;
        List<NounPhrase> alternativeMatchableNounPhrases;

        public Builder setSingular(String word) {
            this.singularNounString = word;
            return this;
        }

        public Builder setPlural(String word) {
            this.pluralNounString = word;
            return this;
        }

        public Builder plural() {
            this.number = Number.Plural;
            return this;
        }

        public Builder setNumber(Number number) {
            this.number = number;
            return this;
        }

        public Builder addAdjective(AdjectivePhrase adjective) {
            this.adjectivePhrases.add(adjective);
            return this;
        }

        public Builder addAllAdjectives(Collection<AdjectivePhrase> adjectives) {
            this.adjectivePhrases.addAll(adjectives);
            return this;
        }

        public Builder setIsCountNoun(boolean isCountNoun) {
            this.isCountNoun = isCountNoun;
            return this;
        }

        public Builder setPerson(Person person) {
            this.person = person;
            return this;
        }

        public Builder addAlternativeMatchableNounPhrase(NounPhrase matchable) {
            if (this.alternativeMatchableNounPhrases == null) {
                this.alternativeMatchableNounPhrases = new ArrayList<NounPhrase>();
            }
            this.alternativeMatchableNounPhrases.add(matchable);
            return this;
        }

        public SimpleNounPhrase build() {
            return new SimpleNounPhrase(this);
        }
    }
}

